#!/bin/ksh
#!/bin/ksh -xv
#
# $Id: disk_trace.sh,v 1.1 2023/03/27 16:07:05 root Exp $
#
# The following code is Confidential and is covered by the installation license
# (c) Copyright Fortra, LLC. and its group of companies.
#
#&& Used to setup and run blktrace and iostat to files and gather the
#&& resulting files into a dated gzipped tar file.
#
#&  Written using infor from IBM see 3rd_IBM_blktrace_instructions.txt
#
echo "Running `grep "\$\I\d\:" ${0} | awk '{print $3,$4,$5,$6}' ` "
apts2install=""
max_minutes=20
jminutes=1 # default of one minutes or 60 seconds
# echo ${jminutes} > number_of_minutes
jdate=`date '+%Y%m%d_%H%M'`
jhost=`uname -n`
gzip_file_name="MPG_Inc_blktrace_`uname`_${jhost}_${jminutes}_mins_${jdate}.tar.gz"
blktrace_running=`ps -ef | egrep "blktrace|iostat" | grep -v egrep `
look4files=`ls -1 sd*blktrace* 2>/dev/null`

# Usage message 
function usage {
   echo "usage: $0 [options]
   where options may be any of:
        -a (a)uto_install any missing required apps
	-b (b)lktrace and iostat on only (specified scsii device)
	-B (B)lktrace and iostat on all scsii devices
	-G (G)zip blktrace files into ${gzip_file_name}
        -l (l)ist available scsii devices
        -m (m)inutes for blktrace and iostat to run (1 min default, max 20) 
        -t (t)est for required applications
        -D (D)ebug (debug=\"T\")
        -v (v)erbose (verbose=\"T\")
        -h (h)elp
        -H (H)elp
"
}

# Simply adds a line for display
function addline {
   echo "# ======================================================== #"
}

# Tests for applications 
function apptest {
   # Checking for required applications lsscsi, blktrace and sysstat and
   # program manager application 
   echo "Checking for required packages for scsi tracing"
   addline
   which lsscsi >/dev/null 2>&1
   jchk=${?}
   if [ $jchk != 0 ] ; then
      echo "### lsscsi is not installed - error"
      apts2install="lsscsi $apts2install"
   else
      echo "lsscsi is installed - OK"
      lsscsi_ok="T"
      jscsi=`lsscsi | grep "disk" | grep -v "VDASD" | awk '{print $NF}'`
      if [ "xx" != "x${jscsi}x" ] ; then
         echo "Direct attached scsi disks detected are:" 
         echo "# ============== #"
         echo "${jscsi}"
         echo "# ============== #"
      else
         echo "### There are NO non-virtual scsi disks detected: (${jscsi})"
         echo "### blktrace cannot be performed on virtual disks!"
      fi
   fi

   # http://www.kossboss.com/linux---blktrace-blkparse-seekwatcher---how-to-run-and-install---and-example-script-to-run-all-nicely
   #
   which blktrace >/dev/null 2>&1
   jchk2=${?}
   if [ $jchk2 != 0 ] ; then
      echo "### blktrace is not installed - error"
      apts2install="blktrace $apts2install"
   else
      echo "blktrace is installed - OK"
      blktrace_ok="T"
   fi

   # sysstat is the package that iostat is in.
   which iostat >/dev/null 2>&1
   jchk3=${?}
   if [ $jchk3 != 0 ] ; then
      echo "### sysstat is not installed - error" 
      apts2install="sysstat $apts2install"
   else
      echo "sysstat is installed - OK" 
      sysstat_ok="T"
   fi
 
   addline

   # http://www.ibmsystemsmag.com/aix/administrator/performance/Linux-Performance-Tuning-(1)/?page=4

   if [ "xx" == "x${lsscsi_ok}x" ] || [ "xx" == "x${sysstat_ok}x" ] || [ "xx" == "x${blktrace_ok}x" ] ; then
      echo "### Please install items above that had error using package manager(s) or"
      echo "### use auto install option (-a)"
      addline
   fi

   # 
   # Checking for package manager programs
   # (yast, yum, apt-get, zypper and/or ppm). 
   #
   # http://opensuse-guide.org/yast.php
   which yast 2>/dev/null
   jtest=$?
   if [ ${jtest} = 0 ]; then
      echo "yast is a semi-GUI based package manager"
      addline
   fi

   # https://en.opensuse.org/images/1/17/Zypper-cheat-sheet-1.pdf
   which zypper 2>/dev/null
   jtest=$?
   if [ ${jtest} = 0 ]; then
      echo "zypper search package_name"
      echo "zypper install package_name_full # ID'd in search"
      pmdetected="zypper"
      addline
   fi

   #  http://www.tecmint.com/20-linux-yum-yellowdog-updater-modified-commands-for-package-mangement/
   which yum 2>/dev/null
   jtest=$?
   if [ ${jtest} = 0 ]; then
      echo "yum search package_name"
      echo "yum install package_name_full # ID'd in search"
      pmdetected="yum" 
      addline
   fi

   # Puppy Package Manager detection
   which ppm 2>/dev/null
   jtest=$?
   if [ ${jtest} = 0 ]; then
      echo "Puppy package manager is (ppm)"
      echo "This is a GUI, so type (ppm) and install the packages manually"
      echo "You will need to install (${apts2install}) via the GUI in (ppm)"
      echo "### They cannot be installed automatically by this script"
      pmdetected="ppm"
      addline
   fi

   # http://www.tecmint.com/useful-basic-commands-of-apt-get-and-apt-cache-for-package-management/
   which apt-get 2>/dev/null
   jtest=$?
   if [ ${jtest} = 0 ]; then
      echo "apt-cache search package_name"
      echo "apt-get install package_name_full # ID'd in search"
      pmdetected="apt-get"
      addline
   fi

   if [ "xx" != "x${blktrace_running}x" ] ; then
      jstarted=`ps -ef | egrep iostat\|blktrace | head -1 | grep -v grep | awk '{print $5}'`
      jmins=`cat number_of_minutes`
      echo "### blktrace or iostat are currently running since (${jstarted}) for (${jmins}) mins."
      addline
      ps -ef | egrep "blktrace|iostat" | egrep -v egrep | sed s/\ \ */\ /g
      addline
      grep -c sd sd* iostat*
      addline
   else
      echo "Neither blktrace or iostat are running"
      addline
   fi

   if [ "xx" != "x${look4files}x" ] ; then
      echo "blktrace files exist"
      addline
   else
      echo "No blktrace files exist"
      addline
   fi

   # End of function apptest 
}

function change_minutes {
   # Beginning of function change_minutes 
   # jminutes
   # new_minutes
   # max_minutes
   if [ "xx" != "x${new_minutes}x" ] ; then
      if [ ${new_minutes} -gt ${max_minutes}  ] ; then
         jminutes=20 
      else 
         jminutes=${new_minutes}  
      fi  
   fi  
   # End of function change_minutes 
}

# Auto installs applications required for scsci disk tracing
function auto_install {
if [ "xx" != "x${apts2install}x" ] && [ "xppmx" != "x${pmdetected}x" ] && [ "xx" != "x${pmdetected}x" ] ; then
    echo "Installing ( ${apts2install}) with ... (${pmdetected}) "
    echo "Command: ( $pmdetected install ${apts2install})"
    $pmdetected install ${apts2install}
    addline
else
   if [ "xx" != "x${apts2install}x" ] ; then
       echo "### Cannot auto install apps ( ${apts2install}) with ... ( ${pmdetected} ) " 
   else
       echo "### No apps to install ( ${apts2install}) with ... ( ${pmdetected} ) " 

   fi
   addline
fi
   # End of function auto_install 
}

function run_blktrace {
   # Beginning of function run_blktrace 
   jwait=1
   jcnt=`echo "${jminutes} * 60" |  bc`
   jsecs=`echo "${jwait} * ${jcnt}" |  bc`
   # block size defaults to 512k
   # With wait 5 count 200 block 512 max file size is 104857600
   # Not specifying wait 5 count and block the file appears to not get as big.
   # In testing it appeared to get big and then reduce itself to a more
   # manageable size.  With only the -w wait in seconds, it appears to not 
   # create such a large file then reduce it.  
   if [ "xx" != "x${jscsi}x" ] ; then
      echo "#### Running blktrace and iostat on each for (${jsecs}) seconds  ####"
      select_scsi=$jscsi
      select_dev="all" #`echo $select_scsi | awk -F\/ '{print $3}'`
      blktrace -d ${select_scsi} -w ${jsecs} -a write -a read > ${select_dev}.blktrace.out & 
      echo "blktrace -d ${select_scsi} -w ${jsecs} -a write -a read > ${select_dev}.blktrace.out &"
      iostat  ${select_scsi} ${jwait} ${jcnt} > ${select_dev}.blktrace.iostat.out & 
      echo "iostat  ${select_scsi} ${jwait} ${jcnt} > ${select_dev}.blktrace.iostat.out &"
      echo "All are running in the background:"
      echo "Files are in (`pwd`)" 
   else
      echo "### No scsi devices specified for run_blktrace"
   fi 
   # End of function run_blktrace  
   echo "${jminutes}" > number_of_minutes
}

function gzip_files {
   if [ -s number_of_minutes ]; then
      jminutes=`cat number_of_minutes`
   fi
   gzip_file_name="MPG_Inc_blktrace_`uname`_${jhost}_${jminutes}_mins_${jdate}.tar.gz"
   if [ "xx" != "x${look4files}x" ] ; then 
      if [ "xx" == "x${blktrace_running}x" ] ; then 
         echo "Compressing files into ${gzip_file_name} !"
         tar cf - sd*blktrace* | gzip -c > ${gzip_file_name} 
         gunzip -c ${gzip_file_name}   | tar -tvf -
      else
         echo "### Cannot create ${gzip_file_name} , blktrace is running!"
         echo "(${blktrace_running})"
      fi
   else
      echo "### There are NO blktrace files to gzip"
   fi
}


#MAIN#
# Ensure transfer options are set.  If not, show usage message.
if [ "xx" = "x${1}x" ] ; then
   usage
   exit 1
fi

while getopts "ab:BltDvhHGm:" opt ; do
   case $opt in
	  a)      apptest ; auto_install ;;
	  b)      opt_scsci=$OPTARG ; apptest; jscsi=$opt_scsci; run_blktrace ;;
	  B)      opt_scsci_all='T'; apptest; run_blktrace ;;
	  G)      gzip_files ;;
	  l)      lsscsi ; addline ;;
	  m)      new_minutes=$OPTARG ; change_minutes ;;
	  t)      apptest ;;
	  D)      debug="T" ;;
	  v)      verbose="T" ;;
	  h)      usage;  exit ;;
	  H)      usage;  exit ;;
	  ?)      usage;  exit ;;
	  *)      usage;  exit ;;
   esac
done

# exit

##### mount -t debugfs none /sys/kernel/debug  if directory exists
if [ -d /sys/kernel/debug ] ; then
   if [ ! -d /sys/kernel/debug/tracing ] ; then
      echo "### Mounting /sys/kernel/debug with " 
      echo "### mount -t debugfs none /sys/kernel/debug "  
      mount -t debugfs none /sys/kernel/debug 
   else
      echo "### /sys/kernel/debug may already be mounted" 
   fi
fi

if [ "xx" != "x${debug}x" ] ; then
   ### Begin of debug
   echo "apts2install=(${apts2install})
lsscsi_ok=(${lsscsi_ok})
blktrace_ok=(${blktrace_ok})
sysstat_ok=(${sysstat_ok})
pmdetected=(${pmdetected})
jminutes=(${jminutes})
new_minutes=(${new_minutes})
opt_scsci_all=(${opt_scsci_all})
debug=(${debug})
verbose=(${verbose})"
   ### End of debug
fi

#& # disk_trace.sh 
#& Running disk_trace.sh,v #.# YYYY/MM/DD hh:mm:ss
#& usage: /perfnav-nix/pn/scripts/disk_trace.sh [options]
#&    where options may be any of:
#&         -a (a)uto_install any missing required apps
#&      -b (b)lktrace and iostat on only (specified scsii device)
#&      -B (B)lktrace and iostat on all scsii devices
#&      -G (G)zip blktrace files into MPG_Inc_blktrace_AIX_MPGAIX_1_mins_YYYYMMDD_hhmm.tar.gz
#&         -l (l)ist available scsii devices
#&         -m (m)inutes for blktrace and iostat to run (1 min default, max 10)
#&         -t (t)est for required applications
#&         -D (D)ebug (debug="T")
#&         -v (v)erbose (verbose="T")
#&         -h (h)elp
#&         -H (H)elp
#&
#&
#&
#& # disk_trace.sh -l 
#& Running disk_trace.sh,v ......
#& [0:0:1:0]    disk    AIX      VDASD            0001  /dev/sda
#& [0:0:2:0]    disk    AIX      VDASD            0001  /dev/sdb
#& # ======================================================== #
#& ### Mounting /sys/kernel/debug with
#& ### mount -t debugfs none /sys/kernel/debug
#&
#&
#&
#& # disk_trace.sh -B 
#& Running disk_trace.sh,v ......
#& Checking for required packages for scsi tracing
#& # ======================================================== #
#& lsscsi is installed - OK
#& ### There are NO non-virtual scsi disks detected: ()
#& ### blktrace cannot be performed on virtual disks!
#& blktrace is installed - OK
#& sysstat is installed - OK
#& # ======================================================== #
#& /usr/bin/zypper
#& zypper search package_name
#& zypper install package_name_full # ID'd in search
#& # ======================================================== #
#& Neither blktrace or iostat are running
#& # ======================================================== #
#& No blktrace files exist
#& # ======================================================== #
#& ### No scsi devices specified for run_blktrace
#& ### Mounting /sys/kernel/debug with
#& ### mount -t debugfs none /sys/kernel/debug
#&
#&
#&
#& #  ./disk_trace.sh  -a
#& Running disk_trace.sh,v ......
#& Checking for required packages for scsi tracing
#& # ======================================================== #
#& ### lsscsi is not installed - error
#& ### blktrace is not installed - error
#& ### sysstat is not installed - error
#& # ======================================================== #
#& ### Please install items above that had error using package manager(s) or
#& ### use auto install option (-a)
#& # ======================================================== #
#& /usr/bin/apt-get
#& apt-cache search package_name
#& apt-get install package_name_full # ID'd in search
#& # ======================================================== #
#& Neither blktrace or iostat are running
#& # ======================================================== #
#& blktrace files exist
#& # ======================================================== #
#& Installing ( sysstat blktrace lsscsi ) with ... (apt-get) 
#& Command: ( apt-get install sysstat blktrace lsscsi )
#& Reading package lists... Done
#& Building dependency tree       
#& Reading state information... Done
#& The following extra packages will be installed:
#&   libaio1
#& Suggested packages:
#&   gnuplot-x11 isag
#& The following NEW packages will be installed:
#&   blktrace libaio1 lsscsi sysstat
#& 0 upgraded, 4 newly installed, 0 to remove and 0 not upgraded.
#& Need to get 1,068 kB of archives.
#& After this operation, 2,317 kB of additional disk space will be used.
#& Do you want to continue [Y/n]? y
#& Get:1 http://http.debian.net/debian/ wheezy/main libaio1 amd64 0.3.109-3 [9,150 B]
#& Get:2 http://http.debian.net/debian/ wheezy/main lsscsi amd64 0.26-2 [35.4 kB]
#& Get:3 http://http.debian.net/debian/ wheezy/main sysstat amd64 10.0.5-1 [391 kB]
#& Get:4 http://http.debian.net/debian/ wheezy/main blktrace amd64 1.0.1-2.1 [632 kB]
#& Fetched 1,068 kB in 1s (575 kB/s) 
#& Preconfiguring packages ...
#& Selecting previously unselected package libaio1:amd64.
#& (Reading database ... 143610 files and directories currently installed.)
#& Unpacking libaio1:amd64 (from .../libaio1_0.3.109-3_amd64.deb) ...
#& Selecting previously unselected package lsscsi.
#& Unpacking lsscsi (from .../lsscsi_0.26-2_amd64.deb) ...
#& Selecting previously unselected package sysstat.
#& Unpacking sysstat (from .../sysstat_10.0.5-1_amd64.deb) ...
#& Selecting previously unselected package blktrace.
#& Unpacking blktrace (from .../blktrace_1.0.1-2.1_amd64.deb) ...
#& Processing triggers for man-db ...
#& Setting up libaio1:amd64 (0.3.109-3) ...
#& Setting up lsscsi (0.26-2) ...
#& Setting up sysstat (10.0.5-1) ...
#& 
#& Creating config file /etc/default/sysstat with new version
#& update-alternatives: using /usr/bin/sar.sysstat to provide /usr/bin/sar (sar) in auto mode
#& Setting up blktrace (1.0.1-2.1) ...
#& update-rc.d: warning:  start runlevel arguments (S) do not match mountdebugfs Default-Start values (S 1 2 3 4 5)
#& [ ok ] Mounted debugfs on /sys/kernel/debug.
#& # ======================================================== #
#& ### /sys/kernel/debug may already be mounted
#&
#& # ./disk_trace.sh  -t | awk '{print "#&",$0}'
#& Running disk_trace.sh,v 1.9 2014/08/19 17:25:30 
#& Checking for required packages for scsi tracing
#& # ======================================================== #
#& ### lsscsi is not installed - error
#& ### blktrace is not installed - error
#& ### sysstat is not installed - error
#& # ======================================================== #
#& ### Please install items above that had error using package manager(s) or
#& ### use auto install option (-a)
#& # ======================================================== #
#& /usr/bin/apt-get
#& apt-cache search package_name
#& apt-get install package_name_full # ID'd in search
#& # ======================================================== #
#& Neither blktrace or iostat are running
#& # ======================================================== #
#& No blktrace files exist
#& # ======================================================== #
#& ### /sys/kernel/debug may already be mounted


