#!/bin/ksh
#!/bin/ksh -xv
#
# $Id: compile_nmon_pre_chk.sh,v 1.1 2023/03/27 16:07:05 root Exp $
#
# The following code is Confidential and is covered by the installation license
# (c) Copyright Fortra, LLC. and its group of companies.
#
#&& Tests items required to compile nmon, use if compiling new nmon version or
#&& install needed nmon that was not in the Performance Navigator host code.
#
#@ Other programs required
#
#& To run type ./compile_nmon_pre_chk.sh 
#& 
#& This would normally be used as root but can be used as a non-root user.
#& Need root to install gcc, make, ssh, and ncurses development package.
#& Once that is done, you could compile as a non-root user in temp directory.
#& 
#
echo "Running `grep "\$\I\d\:" ${0} | awk '{print $3,$4,$5,$6}' ` "
#

mkdir -p /tmp/helpsystems_tmp

#Determine Linux version if possible
if [ -e /etc/os-release ] ; then
   egrep -i "ubuntu|ubuntu" /etc/os-release 2>&1 >/dev/null
   if [ $? = 0 ]; then
      lxversion="_ubuntu"
   fi 
   egrep -i "suse|sles" /etc/os-release 2>&1 >/dev/null
   if [ $? = 0 ]; then
      lxversion="_sles"
   fi
   egrep -i "centos|redhat|fedora" /etc/os-release 2>&1 >/dev/null
   if [ $? = 0 ]; then
      lxversion="_rhel"
   fi
   lxvnum=`grep -i version_id /etc/os-release | sed -e "s,[=|\.|\"],\ ,g"  | awk '{print $2}'`
   # echo "($lxversion)($lxvnum)" # Only uncomment for testing.
fi

if [ -s /usr/local/mpg/nmon*${lxversion}* ] ; then
   ls -al /usr/local/mpg/nmon
fi

echo "uname -a (`uname -a`)"
echo "#===          ===#"
echo "uname -s (`uname -s`), uname -m (`uname -m`), uname -n (`uname -n`), uname -p (`uname -p`)"

# Add _gpu via ${has_gpu} if nvidia-smi exists in /bin or /usr/bin
# to each nmon_version
if [ -s /usr/bin/nvidia-smi ] || [ -s /bin/nvidia-smi ] ; then
   has_gpu="_gpu"
else
   has_gpu=""
fi
#

echo "#=== required files ===#"
# Both centos and rhel
find /usr/share/doc/ncurses-dev* -type d  -name ncurses-dev\* 2>/dev/null > /tmp/helpsystems_tmp/ncursedev.tmp

# Suse or open suse
find /var -name \*ncurses\* -name ncurses-dev\*  2>/dev/null >> /tmp/helpsystems_tmp/ncursedev.tmp             

# Ubuntu or Debian
find /var -name \*ncurses\* -name \*ncurses\*-dev\* 2>/dev/null >> /tmp/helpsystems_tmp/ncursedev.tmp

if [ -s /tmp/helpsystems_tmp/ncursedev.tmp ]; then
   cat /tmp/helpsystems_tmp/ncursedev.tmp
   echo "ncurses development is installed OK" 
else
   echo "### ncurses development is Missing ###"
fi

for jcmp in ssh make gcc
do
   which $jcmp 2>/dev/null
   if [ $? -eq 0 ]; then
      echo "$jcmp OK"
   else
      echo "### ($jcmp) Missing ###"
   fi
done

echo "#=== /etc/issue  ===#"
cat /etc/issue 2>/dev/null | awk '{if( NF != 0 )print $0}'
echo "#=== /etc/*release without equals  ===#"
cat /etc/*release 2>/dev/null | grep -v '=' | sort | uniq
echo "#=== How 2 get gcc, ncurses, ssh, make, or other files ===#"
for jcmp in "zypper yum apt-cache" #### yast?
do
   jfound=`which $jcmp 2>/dev/null`
   if [ "x${jfound}x" != "xx" ]; then
      echo $jfound|sed s,apt-cache,apt-get, 
      $jfound search ncurses 2>/dev/null | egrep "libncurses5-dev|\ ncurses-devel\ |^ncurses-devel"
   fi
done
alias mpg='cd /usr/local/mpg'
alias var='mkdir -p /usr/local/mpg/install; cd /usr/local/mpg'
alias lt='ls -altr'
set -o vi

# ldd /usr/bin/topas_nmon | grep curses

jsys=`uname -s`
if [ "x${jsys}x" != "xLinuxx" ]; then
   echo ""
   echo "#### You cannot compile Linux nmon on ${jsys} ####"
   echo ""
   echo "#### There are executables already available from IBM  ####"
   echo "`which nmon`"
   echo "`which topas_nmon`"
   echo ""
fi

myproc=`uname -p`
if [ "x${myproc}x" = "xi686x" ]  || [ "x${myproc}x" = "xathlonx" ] ;  then
   myproc="x86"
fi
if [ "x${myproc}x" = "xunknownx" ] ; then
   myproc="uname -m"
fi

if [ "x${myproc}x" == "xppc64x" ] ;  then
   myproc="power_64"
fi

if [ "x${myproc}x" == "xppc64lex" ] ;  then
   myproc="power_64le"
fi

if [ "x${jsys}x" == "xLinuxx" ]; then
   echo "==="
   echo "Try:    (make nmon_${myproc}${has_gpu}_test) "
   echo "or:     (make nmon_${myproc}${lxversion}${has_gpu}_test) "
   echo "Better name might be nmon_${myproc}${lxversion}${lxvnum}${has_gpu}" 
   echo "==="
   echo "or\: grep nmon_${myproc}_test makefile"
fi

#& 
#& ##############
#& Sample run [if ncurses-development, ssh, make, or gcc are not installed,
#& note error(s)]  I.E.   ### (make) Missing ### and install missing item.
#& ##############
#& 
#& # ./compile_nmon_pre_chk.sh
#& Running compile_nmon_pre_chk.sh,v 1.4 2020/04/15 21:00:56
#& lrwxrwxrwx 1 root root 20 Apr 16 17:44 /usr/local/mpg/nmon -> nmon_x86_64_ubuntu18
#& uname -a (Linux UbuntuDesktop16 4.15.0-88-generic #88-Ubuntu SMP Tue Feb 11 20:11:34 UTC 2020 x86_64 x86_64 x86_64 GNU/Linux)
#& #===          ===#
#& uname -s (Linux), uname -m (x86_64), uname -n (UbuntuDesktop16), uname -p (x86_64)
#& #=== required files ===#
#& /lib/x86_64-linux-gnu/libncurses.so.5
#& ncurses is installed OK
#& /usr/bin/ssh
#& ssh OK
#& /usr/bin/make
#& make OK
#& /usr/bin/gcc
#& gcc OK
#& #=== /etc/issue  ===#
#& Ubuntu 18.04.3 LTS \n \l
#& #=== /etc/*release without equals  ===#
#& #=== How 2 get gcc, ncurses, ssh, make, or other files ===#
#& /usr/bin/apt-get
#& libncurses5-dev - developer's libraries for ncurses
#& ===
#& Try:    (make nmon_x86_64_test)
#& or:     (make nmon_x86_64_ubuntu_test)
#& Better name might be nmon_x86_64_ubuntu18
#& ===
#& or\: grep nmon_x86_64_test makefile
#& 

