#!/bin/ksh
#
# $Id: chk_ps_4_nmon.sh,v 1.1 2023/03/27 16:07:05 root Exp $
#
# The following code is Confidential and is covered by the installation license
# (c) Copyright Fortra, LLC. and its group of companies.
#
#&& Looks for nmon running in the ps command and ids the directories where 
#&& nmon files are placed.
#
#& With the old option it will do a find on root looking for files with nmon 
#& in the name and identifies the directories those files are in. 
#& I.E. 
#& chk_ps4_nmon.sh old
#
# Running statement
echo "Running `grep "\$\I\d\:" ${0} | awk '{print $3,$4,$5,$6}' ` "
#

mkdir -p /tmp/helpsystems_tmp

# Check process for nmon
ps -ef |grep "nmon " | grep -v grep | sed 's/.*\ -F\ //' | awk '{print $1}' > /tmp/helpsystems_tmp/nmon_ps_running.tmp
if [ -s /tmp/helpsystems_tmp/nmon_ps_running.tmp ] ; then
   echo "#----------------------------------#"
   while
   read jnmonfile
   do 
      # jnmonfile=`ps -ef |grep nmon | grep -v grep | sed 's/.*dir=//' | awk '{print $1}'`
      # echo "(${jnmonfile})"
      jbasedir=`dirname "${jnmonfile}"`
      jbasename=`basename "${jnmonfile}"`
      # echo "(${jnmonfile})(${jbasedir})(${jbasename})"
      echo "${jbasedir}"
   done < /tmp/helpsystems_tmp/nmon_ps_running.tmp
else
   echo "No nmon processes running or do not have nmon in the name." 
fi

# Check process for nmon
if [ "xold" = "x${1}" ]; then
   find / -name \*nmon\* -type f 2>/dev/null  > /tmp/helpsystems_tmp/nmon_find_files.tmp
   if [ -s /tmp/helpsystems_tmp/nmon_find_files.tmp ] ; then
      echo "#----------------------------------#"
      echo "# --------- $0 $1 ---------- #"
      echo "#----------------------------------#"
      while
      read jnmonfile
      do 
         jbasedir=`dirname "${jnmonfile}"`
         echo "${jbasedir}"
      done < /tmp/helpsystems_tmp/nmon_find_files.tmp | sort | uniq  > /tmp/helpsystems_tmp/nmon_find_nmon_dirs.tmp
      echo "nmon files found are in /tmp/helpsystems_tmp/nmon_find_files.tmp" 
      echo "nmon directories found are in /tmp/helpsystems_tmp/nmon_find_nmon_dirs.tmp"
   else
      echo "No nmon files previously or do not have nmon in the name." 
   fi
fi
echo "#-------------- Done --------------#"

#& chk_ps_4_nmon.sh 
#& Running chk_ps_4_nmon.sh,v #.# YYYY/MM/DD hh:mm:ss
#& #----------------------------------#
#& /usr/local/mpg
#& /_other_nmon_directory
#& #----------------------------------#
#& # --------- /perfnav-nix/pn/scripts/chk_ps_4_nmon.sh old ---------- #
#& #----------------------------------#
#& nmon files found are in /tmp/helpsystems_tmp/nmon_find_files.tmp
#& nmon directories found are in /tmp/helpsystems_tmp/nmon_find_nmon_dirs.tmp
#& #-------------- Done --------------#
