#!/bin/ksh
#
# If necessary, install ksh or create a soft link from bash location to /bin/ksh
#
# The following code is Confidential and is covered by the installation license
# (c) Copyright Fortra, LLC. and its group of companies.
#
#&& Used to check ps info and kernel ps info at a moment in time 
#
# $Id: chk_ps.sh,v 1.1 2023/03/27 16:07:05 root Exp $
#
juname_p=`uname -p`
echo "#========================#"
echo "Checking processes ,(`date`)"
echo "(`uptime`)"
echo "(`uname -a`)"
echo "(${juname_p})"
echo "#========================#"

# Added test to allow for thcount when available on powerpc AIX.
if [ "x${juname_p}x" = "xpowerpcx" ] ; then
   echo "ps -edo  pid,ppid,uname,pcpu,pmem,vsz,pagein,thcount,args"
   ps -edo  pid,ppid,uname,pcpu,pmem,vsz,pagein,thcount,args
else
   echo "ps -edo  pid,ppid,uname,pcpu,pmem,vsz,pagein,args"
   ps -edo  pid,ppid,uname,pcpu,pmem,vsz,pagein,args
fi

echo ""
echo ""
echo "#========================#"
echo "Checking kernel processes"
echo "#========================#"
# Added test to allow for thcount when available on powerpc AIX.
if [ "x${juname_p}x" = "xpowerpcx" ] ; then
   echo "ps -ko  pid,ppid,uname,pcpu,pmem,vsz,pagein,thcount,args"
   ps -ko  pid,ppid,uname,pcpu,pmem,vsz,pagein,thcount,args
else
   echo "Kernel process info is not available with this os"
fi
echo "#========================#"
echo ""
echo ""


#& #========================#
#& Checking processes, (date info)
#& (uptime info)
#& (uname -a) 
#& #========================#
#& ps -edo  pid,ppid,uname,pcpu,pmem,vsz,args
#&      PID     PPID     USER  %CPU  %MEM   VSZ COMMAND
#&        1        0     root   0.0   0.0   800 /etc/init
#&  1638482        1     root   0.0   0.0   396 /usr/ccs/bin/shlap64
#&  1966324  4063360     root   0.0   0.0  1124 /usr/sbin/hrd
#&  2293922        1     root   0.0   0.0  1076 /usr/lib/errdemon
#&  2556076        1     root   0.0   0.0   604 /usr/sbin/syncd 60
#&  2621562  4063360     root   0.0   0.0   516 /bin/ksh /opt/itlm/tlmagent
#&  2949276  4063360     root   0.0   0.0  1968 /usr/sbin/clcomd -d
#&  3014856  4063360     root   0.0   0.0  1296 sendmail: accepting connections
#&  3080210        1     root   0.0   0.0   712 /usr/sbin/nmbd
#&  3276818  4063360     root   0.0   0.0  1288 /usr/sbin/hostmibd
#&  3342482  2621562     root   0.0   0.0  1536 /opt/itlm/tlmagent.bin
#&  3539068  4063360     root   0.0   0.0   652 /usr/sbin/inetd
#&  3670134  4063360     root   0.0   0.0  1780 /usr/sbin/snmpd
#&  3735670  4063360     root   0.0   0.0  1144 /usr/sbin/snmpmibd
#&  3801268  4063360     root   0.0   0.0  1420 /usr/sbin/aixmibd
#&  3866744  4063360     root   0.0   0.0  1024 /usr/sbin/portmap
#&  3932290  4063360     root   0.0   0.0   880 /usr/sbin/syslogd
#&  4063360        1     root   0.0   0.0   940 /usr/sbin/srcmstr
#&  4128956        1     root   0.0   0.0  1360 /usr/bin/topasrec  -L -s 300 -R 1 -r 6 -o /var/perf/daily/ -ypersistent=1 -O type=bin -ystart_time=13:55:44,Nov12,2015
#&  4653218  4063360     root   0.0   0.0   220 /usr/sbin/qdaemon
#&  4915440        1     root   0.0   0.0 12932 /opt/freeware/cimom/pegasus/bin/cimprovagt 0 12 16 root SLPProviderModule
#&  4980982  5505222     root   0.0   0.0   896 /usr/sbin/smbd
#&  5112010        1     root   0.0   1.0 30312 [cimserve]
#&  5243066  9961572     root   0.0   0.0   788 ps -edo pid,ppid,uname,pcpu,pmem,vsz,args
#&  5505222        1     root   0.0   0.0  1040 /usr/sbin/smbd
#&  5570732        1     root   0.0   0.0    88 /usr/sbin/uprintfd
#&  5701810  4063360     root   0.0   0.0   156 /usr/sbin/biod 6
#&  5832896  4063360     root   0.0   0.0   284 /usr/sbin/writesrv
#&  5898426  4063360     root   0.0   0.0   372 /usr/sbin/rpc.lockd -d 0
#&  5963966  4063360     root   0.0   0.0   416 /opt/freeware/cimom/pegasus/bin/cimssys cimsys
#&  6029532  4063360     root   0.0   0.0   544 /bin/ksh /pconsole/lwi/bin/lwistart_src.sh
#&  6160598  6029532 pconsole   0.0   0.0   540 /bin/ksh /pconsole/lwi/bin/lwistart_src.sh
#&  6291656        1     root   0.0   0.0   312 /opt/freeware/cimom/pegasus/bin/CIM_diagd
#&  6357196  4063360   daemon   0.0   0.0  1516 /usr/sbin/rpc.statd -d 0 -t 50
#&  6553802  4063360     root   0.0   0.0   276 /usr/sbin/nfsd 3891
#&  6619374        1   nobody   0.0   0.0  3592 /opt/freeware/sbin/gmond -p /var/run/gmond.pid
#&  6815966  4063360     root   0.0   0.0   556 /bin/ksh /var/opt/tivoli/ep/runtime/nonstop/bin/cas_src.sh
#&  6947030  4063360     root   0.0   0.0  1776 /usr/sbin/rpc.mountd
#&  7012414        1     root   0.0   0.0  2832 /usr/bin/topas_nmon  -m /usr/local/mpg -F /usr/local/mpg/mpg_20151115.nmon -s300 -c287 -t -I 0.02 -youtput_dir=/usr/local/mpg/mpg_20151115.nmon -ystart_time=00:01:00,Nov15,2015
#&  7209104  6815966     root   0.0   0.0   448 bin/nonstop_aix @/var/opt/tivoli/ep/runtime/nonstop/config/nonstop.properties
#&  7536894        1     root   0.0   0.0  1168 /usr/sbin/cron
#&  7733500        1     root   0.0   0.0   660 /usr/sbin/getty /dev/console
#&  8061084  6160598 pconsole   0.0   1.0 56640 /usr/java6/bin/java -Xmx512m -Xms20m -Xscmx10m -Xshareclasses -Dfile.encoding=UTF-8 -Xbootclasspath/a:/pconsole/lwi/runtime/core/eclipse/plugins/com.ibm.rcp.base_6.2.1.20091117-1800/rcpbootcp.jar:/pconsole/lwi/lib/ISCJaasModule.jar:/pconsole/lwi/lib/com.ibm.logging.icl_1.1.1.jar:/pconsole/lwi/lib/jaas2zos.jar:/pconsole/lwi/lib/jaasmodule.jar:/pconsole/lwi/lib/lwinative.jar:/pconsole/lwi/lib/lwinl.jar:/pconsole/lwi/lib/lwirolemap.jar:/pconsole/lwi/lib/lwisecurity.jar:/pconsole/lwi/lib/lwitools.jar:/pconsole/lwi/lib/passutils.jar -Xverify:none -cp eclipse/launch.jar:eclipse/startup.jar:/pconsole/lwi/runtime/core/eclipse/plugins/com.ibm.rcp.base_6.2.1.20091117-1800/launcher.jar com.ibm.lwi.LaunchLWI
#&  8126718  4063360     root   0.0   4.0 216476 /usr/sbin/rsct/bin/rmcd -a IBM.LPCommands -r -d all_but_msgs=4
#&  9043998  4063360     root   0.0   0.0   900 /usr/sbin/sshd
#&  9502768  4063360     root   0.0   0.0  1712 /usr/sbin/rsct/bin/IBM.DRMd
#&  9830474        1     root   0.0   0.0  9712 /usr/bin/cimlistener
#&  9896122  7209104     root   0.0   1.0 65444 /var/opt/tivoli/ep/_jvm/jre/bin/java -Xmx384m -Xminf0.01 -Xmaxf0.4 -Dsun.rmi.dgc.client.gcInterval=3600000 -Dsun.rmi.dgc.server.gcInterval=3600000 -Xbootclasspath/a:/var/opt/tivoli/ep/runtime/core/eclipse/plugins/com.ibm.rcp.base_6.2.3.20110824-0615/rcpbootcp.jar:/var/opt/tivoli/ep/lib/com.ibm.logging.icl_1.1.1.jar:/var/opt/tivoli/ep/lib/jaas2zos.jar:/var/opt/tivoli/ep/lib/jaasmodule.jar:/var/opt/tivoli/ep/lib/lwidiag.jar:/var/opt/tivoli/ep/lib/lwinative.jar:/var/opt/tivoli/ep/lib/lwinl.jar:/var/opt/tivoli/ep/lib/lwirolemap.jar:/var/opt/tivoli/ep/lib/lwisecurity.jar:/var/opt/tivoli/ep/lib/lwitools.jar:/var/opt/tivoli/ep/lib/passutils.jar:../../runtime/agent/lib/cas-bootcp.jar -Xverify:none -cp eclipse/launch.jar:eclipse/startup.jar:/var/opt/tivoli/ep/runtime/core/eclipse/plugins/com.ibm.rcp.base_6.2.3.20110824-0615/launcher.jar com.ibm.lwi.LaunchLWI
#&  9961572 14549238     root   0.0   0.0   492 /bin/ksh /perfnav-nix/pn/scripts/chk_ps.sh
#& 10289218  4063360     root   0.0   0.0  5560 /usr/sbin/rsct/bin/IBM.MgmtDomainRMd
#& 10354752  4063360     root   0.0   0.0  1580 /usr/sbin/rsct/bin/IBM.ServiceRMd
#& 11206768 13697070  username   0.0   0.0   992 sshd: username@pts/0
#& 12714004  9043998     root   0.0   0.0   536 sshd: [accepted]
#& 13697070  9043998     root   0.0   0.0   764 sshd: username [priv]
#& 13959366 11206768  username   0.0   0.0   556 -ksh
#& 14221458 12714004     sshd   0.0   0.0   788 sshd: [net]
#& 14549238 13959366     root   0.0   0.0   572 -ksh
#& 
#& 
#& #========================#
#& Checking kernel processes
#& #========================#
#& ps -ko  pid,ppid,uname,pcpu,pmem,vsz,args
#&      PID     PPID     USER  %CPU  %MEM   VSZ COMMAND
#&        0        0     root   0.0   0.0   384 swapper
#&   131076        0     root   0.0   0.0   448 wait
#&   196614        0     root   0.0   0.0   448 sched
#&   262152        0     root   0.0   0.0   512 lrud
#&   327690        0     root   0.0   0.0   448 vmptacrt
#&   393228        0     root   0.0   0.0   512 psmd
#&   458766        0     root   0.0   0.0   832 vmmd
#&   524304        0     root   0.0   0.0   448 pvlist
#&   589842        0     root   0.0   0.0   640 reaffin
#&   655380        0     root   0.0   0.0   448 memgrdd
#&   720938        1     root   0.0   0.0   448 pofCmdProc
#&   786456        0     root   0.0   0.0   512 vtiol
#&   851994        0     root   0.0   0.0   448 devstatd
#&   917532        0     root   0.0   0.0   640 pilegc
#&   983070        0     root   0.0   0.0   448 xmgc
#&  1048608        0     root   0.1   0.0   448 wait
#&  1114146        0     root   0.1   0.0   448 wait
#&  1179684        0     root   0.1   0.0   448 wait
#&  1245222        0     root   0.0   0.0   448 netm
#&  1310760        0     root   0.0   0.0   960 gil
#&  1376298        0     root   0.0   0.0   512 wlmsched
#&  1441836        0     root   0.0   0.0   448 armtrace_kproc
#&  1572978        0     root   0.0   0.0   704 nfssync_kproc
#&  1704022        1     root   0.0   0.0   448 aioPpool
#&  1769536        0     root   0.0   0.0  2176 j2pg
#&  1835208        0     root   0.0   0.0   960 dog
#&  2031700        0     root   0.0   0.0   448 memp_rbd
#&  2097218        0     root   0.0   0.0   448 lvmbb
#&  2162830        1     root   0.0   0.0   448 hea_kproc
#&  2359456        0     root   0.0   0.0   448 rtcmd
#&  2424912        1     root   0.0   0.0   448 aioLpool
#&  2490446        1     root   0.0   0.0  1216 kpkcs11
#&  2687064        0     root   0.0   0.0   448 rdpgc
#&  2752728        1     root   0.0   0.0   512 ldmp_process
#&  2818172        0     root   0.0   0.0   512 nfsSM
#&  2883694        1     root   0.0   0.0   512 kbiod
#&  3145840        0     root   0.0   0.0   448 rgsr
#&  3211370        0     root   0.0   0.0   448 n4bg
#&  3604636        1     root   0.0   0.0   448 events
#&  3997846        1     root   0.0   0.0   448 random
#&  4194432        1     root   0.0   0.0   448 ib_addr
#&  4259970        1     root   0.0   0.0   448 ib_mcast
#&  4325508        1     root   0.0   0.0   448 ib_inform
#&  4391046        1     root   0.0   0.0   448 local_sa
#&  4456584        1     root   0.0   0.0   448 ib_cm
#&  4522122        1     root   0.0   0.0   448 iw_cm_wq
#&  4587660        1     root   0.0   0.0   448 rdma_cm
#&  5767346        1     root   0.0   0.0  1216 rpc.lockd
#&  6881492        1     root   0.0   0.0  1856 nfsd
#&  8257672        1     root   0.0   0.0   448 ahafs_kproc
#& #========================#
#& 
#& 
