#!/bin/ksh
#!/bin/ksh -xv
#
#&& Used to change long hostnames to short hostnames in all nmon files.
#&& This includes internal lines and filename.
#
#@ change_pn.sh is used to change auto_start variable so nmon will or will not
#@ start.
#@ killnmon is used to stop nmon
#@ nmon will start automatically after the change to the auto_start variable.
#& 
#& 1. Turn off auto_start
#& 2. killnmon
#& 3. cd to data directory 
#& 4. Backup data before changes are made to alternate location, just in case.
#& 5. Rename files with longhostname to shorthostname 
#& 6. Identify gzipped files that internally have longhostname 
#& 7. Fix Identifed gzipped files that internally have longhostname 
#& 8. Identify non-gzipped files that internally have longhostname 
#& 9. Fix Identified non-gzipped files that internally have longhostname 
#& 10. Turn on auto_start
#& 11. nmon will then auto_start within 15 minutes.
#& 
#
echo "Running `grep "\$\I\d\:" ${0} | awk '{print $3,$4,$5,$6}' ` "
#
# $Id: change_long2short.sh,v 1.1 2023/03/27 16:07:05 root Exp $
#
# The following code is Confidential and is covered by the installation license
# (c) Copyright Fortra, LLC. and its group of companies.
#

# Display the starting directory
jcurrent_dir=`pwd`
echo "Started in directory ${jcurrent_dir}"
# Confirm pn.config is in the directory
if [ ! -s pn.config ]; then
   echo "Did not find pn.config, may not be ran in non-install directory"
   echo "Exiting"; exit 1
else
   echo "Setting variables within pn.config"
   . pn.config
fi

# Saving environment after running . pn.config to /tmp/helpsystems_tmp/long2short_env.tmp
set > /tmp/helpsystems_tmp/long2short_env.tmp

# Only run if necessary
jlonghost=`uname -n`
jshorthost=`uname -n | awk -F. '{print $1}'`
if [ "x${jlonghost}x" = "x${jshorthost}x" ]; then
   echo "long hostname is the same as short hostname no need to run $0"
   echo "( ${jlonghost} )"
   echo "Exiting"; exit 1
else
   echo "long hostname is ( ${jlonghost} ), short hostname is ( ${jshorthost} )"
fi
# End Only run if necessary

# Identify files that need to be renamed
echo "Identifying files that need to be renamed"
if [ "x${mpgdatadir}x" = "x${installdir}x" ]; then
   echo "mpgdatadir ( ${mpgdatadir} ) and installdir ( ${installdir} ) are the same."
   ls -1 ${mpgdatadir}/*${jlonghost}* | awk '{print "mv",$1,$1}' \
      | sed s/${jlonghost}/${jshorthost}/2 > /tmp/helpsystems_tmp/rename_long_short.tmp
else
   echo "mpgdatadir ( ${mpgdatadir} ) and installdir ( ${installdir} ) are different."
   ls -1 ${mpgdatadir}/*${jlonghost}* ${installdir}/*${jlonghost}* | awk '{print "mv",$1,$1}' \
      | sed s/${jlonghost}/${jshorthost}/2 > /tmp/helpsystems_tmp/rename_long_short.tmp
fi
# End Identify files that need to be renamed

# Rename files that need to be renamed
if [ -s /tmp/helpsystems_tmp/rename_long_short.tmp ]; then
   echo "Renaming files with ( ${jlonghost} ) replacing with ( ${jshorthost} )"
   . /tmp/helpsystems_tmp/rename_long_short.tmp
else
   echo "There are no files to rename by replacing ( ${jlonghost} ) with ( ${jshorthost} )"
fi
# End Rename files that need to be renamed

# 1.  Turn off auto_start
echo "Turning off nmon auto_start in pn.config"
  ./change_pn.sh -n F
# End Turn off auto_start

# 2.  Stop nmon by running killnmon
echo "Stopping nmon!!!!"
   ./killnmon
# END Stop nmon by running killnmon

# 3.  cd to data directory
# End cd to data directory

# 4.  Backup data before changes are made to alternate location, just in case.
# End Backup data before changes are made to alternate location, just in case.

# 5.  Rename files with longhostname to shorthostname
# ls -1 *${jlonghost}* | awk '{print "mv",$1,$1}' | sed s/${jlonghost}/${jshorthost}/2
# End Rename files with longhostname to shorthostname

# 6.  Identify gzipped and non-gzipped files that internally have longhostname
echo "Identifying gzipped and non-gzipped files that internally have longhostname"
zgrep -c ${jlonghost} ${mpgdatadir}/*.gz ${installdir}/*.gz \
   | egrep -v "mpgdata2|mpg_20|:0|pninfo|mpgpn.tar" \
   | awk -F: '{print $1}' \
   | sort \
   | uniq > /tmp/helpsystems_tmp/long2short_gzfiles.tmp
grep -c ${jlonghost} ${mpgdatadir}/* ${installdir}/* \
   | egrep -v "mpgdata2|mpg_20|:0|pninfo|mpgpn.tar" \
   | awk -F: '{print $1}' \
   | sort \
   | uniq > /tmp/helpsystems_tmp/long2short_non-gzfiles.tmp
# End Identify gzipped and non-gzipped files that internally have longhostname


# 7.  Fix Identifed gzipped files that internally have longhostname
echo "Fix Identifed gzipped files that internally have longhostname"
while
read jfile
do
   touch -r $jfile /tmp/helpsystems_tmp/long2short_time_ref.tmp
   gunzip -c $jfile \
      | sed s/${jlonghost}/${jshorthost}/g | gzip -c  > /tmp/helpsystems_tmp/long2short_hold.gz 
   touch -r /tmp/helpsystems_tmp/long2short_time_ref.tmp /tmp/helpsystems_tmp/long2short_hold.gz
   mv /tmp/helpsystems_tmp/long2short_hold.gz $jfile  
done < /tmp/helpsystems_tmp/long2short_gzfiles.tmp
# End Fix Identifed gzipped files that internally have longhostname

# 9.  Fix Identified non-gzipped files that internally have longhostname
echo "Fix Identified non-gzipped files that internally have longhostname"
while
read jfile
do
   touch -r $jfile /tmp/helpsystems_tmp/long2short_time_ref.tmp
   cat $jfile \
      | sed s/${jlonghost}/${jshorthost}/g > /tmp/helpsystems_tmp/long2short_hold_non_gz 
   touch -r /tmp/helpsystems_tmp/long2short_time_ref.tmp /tmp/helpsystems_tmp/long2short_hold_non_gz
   mv /tmp/helpsystems_tmp/long2short_hold_non_gz $jfile  
done < /tmp/helpsystems_tmp/long2short_non-gzfiles.tmp
# End Fix Identified non-gzipped files that internally have longhostname

# 10. Turn on auto_start
echo "Turning on nmon auto_start in pn.config"
  ./change_pn.sh -n T
# End Turn on auto_start

# 11. nmon will then auto_start within 15 minutes.
echo "nmon will start within 15 minutes with short hostname"  
# End nmon will then auto_start within 15 minutes.

# 12. Display any details to user that are still needed.
echo "Additional details:"
# End Display any details to user that are still needed.



