#!/bin/ksh  
#
# $Id: cend.sh,v 1.1 2023/03/27 16:07:05 root Exp $
#
# The following code is Confidential and is covered by the installation license
# (c) Copyright Fortra, LLC. and its group of companies.
#
#&& Collect Existing Nmon Data (cend.sh)
#
#&  Defaults to all mpg_*.nmon files (except for "today's" file)
#
#&@ pndcutils.sh is also required
#&@ pndcm.sh is also required
#
#&%  Does not collect data for "today" 
#&%  Ran daily by a cron job
#&%  Accepts file patterns on the commandline to designate which files to 
#&%  collect.
#
# NEEDS:
#  Would be really nice to be able to insert missing datafiles in the middle...
#

mkdir -p /tmp/helpsystems_tmp
rm -f /tmp/pfcdaemon.out

debug=""

invocdir=`dirname $0`
if [ -s $invocdir/pndcutils.sh ]; then
   . $invocdir/pndcutils.sh
fi

if [ -s $invocdir/pn.config ];  then
. $invocdir/pn.config
fi

# Three new environmental variables
# installdir
# mpgdatadir
# nmondatadir

# installdir should be defined, but if not use invocdir
if [ -z "$installdir" ] ; then
   installdir=$invocdir
fi

# mpgdatadir should be defined, but if not use invocdir
if [ -z "$mpgdatadir" ] ; then
   mpgdatadir=$invocdir
fi

# nmondatadir should be defined, but if not use invocdir
if [ -z "$nmondatadir" ] ; then
   nmondatadir=$invocdir
fi

def_datafile="${mpgdatadir}/mpgdata2.$sysname"    # default datafile name


if [ ! -z "$debug" ] ; then
   echo "#$0# installdir=$installdir"
   echo "#$0# mpgdatadir=$mpgdatadir"
   echo "#$0# nmondatadir=$nmondatadir"
   echo "#$0# def_datafile=$def_datafile"

   # echo Remove stop later ; exit 1
fi

# Next line added because it worked when ran manually, but failed to catch .01 .... .99 when ran automatically

cd $invocdir

function usage {
echo "USAGE:
cend.sh [options] [filepattern]
   filepattern is a regex of datafiles to collect
	defaults to: '${installdir}/mpg_*.nmon ${installdir}/mpg_*.nmon.gz'
   and options are any of:
	-D		- debug
	-d installdir	- specify nmon data directory (def: $installdir)
	-o datafile	- full path to output file (def: $def_datafile)
	-c configfile	- get settings from \"configfile\"
	-t tempfile	- full path to tempfile (def: $tempfile)
"
}

passopts="";
while getopts "D:o:c:d:t:" opt ; do
  case $opt in
	D)	debug="T" ;;
	o)	opt_datafile=$OPTARG ; passopts="$passopts -o $OPTARG" ;;
	c)	opt_configfile=$OPTARG ; passopts="$passopts -c $OPTARG" ;;
	t)	opt_tempfile=$OPTARG ; passopts="$passopts -t $OPTARG" ;;
	d)	opt_installdir=$OPTARG ; passopts="$passopts -d $OPTARG" ;;
	?)	usage;  exit ;;
  esac
done
shift `expr $OPTIND - 1`

if [ ! -z "$opt_configfile" ] ; then configfile=$opt_configfile; fi
##### quick+dirty configfile - unsafe!
if [ ! -z "$configfile" ] ; then
  . $configfile
fi
	if [ ! -z "$debug" ] ; then
	echo " -- options after configfile processing: -- ";
	echo "datafile:$datafile"
	echo "tempfile:$tempfile"
	echo "installdir:$installdir"
	echo "passopts:$passopts"
	fi
## this allows just setting sysname in the configfile
def_datafile="${mpgdatadir}/mpgdata2.$sysname"    # default datafile name
if [ -z "$datafile" ] ; then datafile="$def_datafile" ; fi
if [ ! -z "$opt_datafile" ] ; then datafile=$opt_datafile; fi
if [ ! -z "$opt_tempfile" ] ; then tempfile=$opt_tempfile; fi
if [ ! -z "$opt_installdir" ] ; then installdir=$opt_installdir; fi
	if [ ! -z "$debug" ] ; then
	echo " ----- options after commandline option processing:";
	echo "datafile:$datafile"
	echo "tempfile:$tempfile"
	echo "installdir:$installdir"
	fi

# Automatically remove ${datafile}.sorted
# This has to be removed because the primary ${datafile} is changing when 
# this script is ran.
rm -f ${datafile}.sorted

today=`date +%Y%m%d`
clp=${1:-none}
if [ "$clp" = "none" ] ; then
  pattern="${nmondatadir}/mpg_*.nmon ${nmondatadir}/mpg_*.nmon.gz" 
else
  pattern=$*
fi

# echo $sysname

ls -1 mpgdataps_* 2>/dev/null \
   | grep -v $today 2>/dev/null > /tmp/helpsystems_tmp/mpgdataps.list
# set > /tmp/helpsystems_tmp/mpgdataps_set.hsllc

# def_psfile is here, because it is not used during the snap. 
def_psfile=${invocdir}/mpgdata5.${sysname}

# ext_ps_collect and ext_ps_days is defined in start_nmon_now
# ext_ps_collect=T
# ext_ps_days=''

# function mpgd5hdr will echo below comment into the mpgdata5.hostname file
function mpgd5hdr { 
      echo "# ${def_psfile} is use to store process information 
# for normal and kernel processes.  How many days retained is controlled by 
# ext_ps_days(${ext_ps_days}) which sets to 7 if blank."
} 

if [ "xx" = "x${ext_ps_days}x" ] ; then
   jext_ps_days=7
else
   jext_ps_days=${ext_ps_days}
fi

# Beginning of processing of mpgdata5.hostname file
if [ -s /tmp/helpsystems_tmp/mpgdataps.list ]; then
   if [ ! -s ${def_psfile} ]; then
      mpgd5hdr  > ${def_psfile} 
   fi
   while
   read jps
   do 
       # Added lines for date, time and sysname
       echo "MPG,host,${sysname}" >> ${def_psfile}
       jmytime=`grep ZZZZ, $jps | head -1 | awk -F, '{print $3}'` >> ${def_psfile}
       jmydate=`grep ZZZZ, $jps | head -1 | awk -F, '{print $4}'` >> ${def_psfile}
       echo "MPG,date,${jmydate}" >> ${def_psfile}
       echo "MPG,time,${jmytime}" >> ${def_psfile}
       #  Needs to gather data from mpgdataps_2files into ${def_psfile} 
       cat $jps | awk -F, 'BEGIN {jcnt=1}; {if($1 == "ZZZZ") { printf("ZZZZ,T%04d,%s,%s\n", (substr($3,1,2) * 12) + substr($3,4,2)/5 +1 ,$3,$4) ; jcnt==jcnt+1; } else {print $0}}' >> ${def_psfile}
       rm -f $jps # Remove mpgdataps file once is has been processed.
   done < /tmp/helpsystems_tmp/mpgdataps.list
fi

# Limiting mpgdata5.hostname to number in ext_ps_days(${ext_ps_days}) 
psdaycnt=`grep -n ,host, ${def_psfile} | wc -l | awk '{print $1}'`
if [ ${psdaycnt} -gt ${jext_ps_days} ] ; then
   pslocdays=`grep -n ,host,  ${def_psfile} | tee /tmp/helpsystems_tmp/pslocdays.hsllc | tail -${jext_ps_days} | head -1 | awk -F: '{print $1}'`
   gzip -c ${def_psfile}  > ${def_psfile}.hold.gz    
   mpgd5hdr > ${def_psfile}
   gunzip -c ${def_psfile}.hold.gz \
      | awk -v jpsloc=${pslocdays} '{if ( NR >= jpsloc ) print $0}' >> ${def_psfile}
   rm ${def_psfile}.hold.gz    
fi

# This part is set up to automatically remove ^M at the end of the lines
# within input files.  This may happen if someone transfers the files using 
# ansi instead of binary or if files are extracted via windows. 
cd $nmondatadir
for jpfile in `echo $pattern`
do
   if [ -s $jpfile ]
   then 
      jbase=`basename $jpfile` 
      jbasegz=`basename $jpfile .gz` 
      # Is the file gzipped, if so, gunzip the file?
      if [ "x${jbase}x" != "x${jbasegz}x" ]
      then 
         # if file is gzipped gunzip the file
         gunzip $jpfile
         jpfile=$jbasegz
      fi
      # If input file has ^M at end of the line remove them.
      jmcnt=`grep -c 
$ $jpfile`
      jmtest=0
      if [ "x${jmcnt}x" != "x${jmtest}x" ]
      then
         cat $jpfile | sed s,
$,, > ${jpfile}.tmp # helpsystems_tmp
         touch -r $jpfile ${jpfile}.tmp  # helpsystems_tmp
         mv ${jpfile}.tmp $jpfile  # helpsystems_tmp
      fi
   fi
done

if [ ! -z "$debug" ] ; then echo "pattern=$pattern" ; fi

# This corrects all of the .01, .02...... files that need to be merged.
# It merges them into the data file that ends with .nmon and has same date.
for file in `ls -1tr mpg_*nmon.01 2> /dev/null | grep -v ${today}`
do 
  ${installdir}/pndcm.sh -F `basename $file .01` daily 
done

# Added grep -v to ensure today's files are not processed.
filelist=`ls -1tr $pattern 2> /dev/null | grep -v ${today}| tail -1023` # max size of ksh array is 1023
	if [ ! -z "$debug" ] ; then echo "filelist=$filelist" ; fi

# easier to tell what is happening here if debugging is turned off while getting dates
	if [ ! -z "$debug" ] ; then debugoff=$debug ; unset debug ; fi
##### order file list by date
#copy code from sdcm.sh
i=0

for file in $filelist
do
  get_nmon_data_date $file
  filedate=$nmondatadate
  let i=i+1
  fn[$i]=$file
  fd[$i]=$filedate
	if [ ! -z "$debug" ] ; then echo "$i: ${fn[$i]} -- ${fd[$i]}" ; fi
done
#	turn debug back on if it was turned off
	if [ ! -z "$debugoff" ] ; then debug=$debugoff ; unset debugoff ; fi
 ## sort filelist (fn) by date (fd) 
 i=1
 nfd=${#fd[*]}
 let nfd1=nfd-1
 while [ $i -le $nfd1 ] ;
 do
   let j=i+1
   while [ $j -le $nfd ] ;
   do
     if [ "${fd[$i]}" -gt "${fd[$j]}" ] ; then
	tfd=${fd[$i]}
	fd[$i]=${fd[$j]}
	fd[$j]=$tfd
	tfn=${fn[$i]}
	fn[$i]=${fn[$j]}
	fn[$j]=$tfn
     fi
     let j=j+1
   done
   let i=i+1
 done
	if [ ! -z "$debug" ] ; then  i=0
	 while [ $i -lt ${#fn[*]} ]; do let i=i+1; echo "$i: ${fn[$i]} -- ${fd[$i]}"; done
	fi


## check each file in list against existing mpgdata file ...
## rc=2 nmonfiles are earlier than datafile : collect to different file and prepend
## rc=3 skip and try next file
## rc=0  ok to collect
## rc=1 ??  should not happen
## mpgdata does not exist gives rc 0 - OK to collect


filelistbydate="${fn[*]}"
	if [ ! -z "$debug" ] ; then echo "filelistbydate=$filelistbydate" ; fi


# prependflag="FALSE";
# prependfile="${invocdir}/nmondata.prepend"
for getfile in $filelistbydate
do
  gzfile=`basename $getfile`
  file=`basename $getfile .gz`
  getdir=`dirname $getfile`
  # Ensure data is recompressed
  recompress="TRUE"
	if [ ! -z "$debug" ] ; then echo "getfile:$getfile file:$file gzfile:$gzfile" ; fi
  if [ "$file" != "mpg_${today}.nmon" ] ; then
    if [ "$file" != "$gzfile" ] ; then
	if [ ! -z "$debug" ] ; then echo "gunzipping $getfile ..." ; fi
	gunzip $getfile
	getfile=${getdir}/$file
	recompress="TRUE"
    fi
    if [ ! -z "$debug" ] ; then echo "check_datafile_dates $getfile" ; fi
    check_datafile_dates $getfile
    rc=$?
    if [ ! -z "$debug" ] ; then echo "check_datafile_dates rc=$rc" ; fi
    case $rc in
	0)
	  if [ ! -z "$debug" ] ; then
		echo "${installdir}/pndcm.sh $passopts daily $getfile" ;
	  fi
	  ${installdir}/pndcm.sh $passopts daily $getfile
	 ;;
	2)
	  if [ ! -z "$debug" ] ; then
		echo "${installdir}/pndcm.sh $passopts daily $getfile" ;
	  fi
	  ${installdir}/pndcm.sh $passopts daily $getfile
	 ;;
# Originally processing of files that are misplaced whould put them in 
# the beginning of the file.
# Currently unnessessary because, pndchk.sh will resequence if necessary.
#	2)
#	  if [ ! -z "$debug" ] ; then
#		echo "prepending..."
#		echo "$installdir/pndcm.sh $passopts -o $prependfile daily $getfile";
#	  fi
#	  prependflag="TRUE";
#	  ${installdir}/pndcm.sh $passopts -o $prependfile daily $getfile
#	 ;;
	3)
	  if [ ! -z "$debug" ] ; then echo "CEND:data from $file already in $datafile"; fi
	  if [ "$recompress" = "TRUE" ] ; then gzip $getfile ; fi
	 ;;
	1)
	  if [ ! -z "$debug" ] ; then
		echo " Bad State : Should not get here..." ; exit 1;
	  fi
	 ;;
    esac
  fi
done

# Reference file for last time cend.sh was ran.
jdate=`date +%Y%m%d`
echo "cend.sh `date`" > ${invocdir}/last_cend
touch -t ${jdate}0000 ${invocdir}/last_cend
rm -f /tmp/mpgdataps* # helpsystems_tmp   

# Originally processing of files that are misplaced whould put them in 
# the beginning of the file.
# Currently unnessessary because, pndchk.sh will resequence if necessary.
##### if prepend needed, put the original stuff on the end...
# if [ "$prependflag" = "TRUE" ] ; then
#    if [ ! -z "$debug" ] ; then
#       echo '
#       mv  $datafile ${datafile}.hold_for_prepend
#       mv $prependfile $datafile
#       cat ${datafile}.hold_for_prepend | sed s,
$,, >> $datafile
# '
#   fi
#   mv  $datafile ${datafile}.hold_for_prepend
#   mv $prependfile $datafile
#   cat ${datafile}.hold_for_prepend | sed s,
$,, >> $datafile
# fi

