#!/bin/ksh
# $Id: bz2_2_gz.sh,v 1.1 2023/03/27 16:07:05 root Exp $
#
# The following code is Confidential and is covered by the installation license
# (c) Copyright Fortra, LLC. and its group of companies.
#
#&& bz2_2_gz.sh converts all .bz2 files to .gz files in the current directory
#&

mkdir -p /tmp/helpsystems_tmp

find . -name \*.bz2 2>/dev/null > /tmp/helpsystems_tmp/bz2_2_gz.tmp

if [ "x${1}x" = "xFortra.comx" ] && [ -s /tmp/helpsystems_tmp/bz2_2_gz.tmp ] ; then
   echo "Running `grep "\$\I\d\:" ${0} | awk '{print $3,$4,$5,$6}' ` "
   if [ -s /tmp/helpsystems_tmp/bz2_2_gz.tmp ];
   then
      echo "Converting (`wc -l /tmp/helpsystems_tmp/bz2_2_gz.tmp | awk '{print $1}'`) .bz2 files to .gz files! "
      while
      read  jfile
      do
         #  ls -al $jfile
         bunzip2 $jfile
         unjfile=`echo $jfile | sed s,\.bz2$,,`
         gzip $unjfile
      done < /tmp/helpsystems_tmp/bz2_2_gz.tmp
   else
      echo "There are no .bz2 files to convert to .gz files! "
   fi
else
      echo "There are (` wc -l  /tmp/helpsystems_tmp/bz2_2_gz.tmp | awk '{print $1}'`) .bz2 files to convert to .gz files! "
      echo "Type "
      echo "./bz2_2_gz.sh Fortra.com"
fi

#& #=#=#=#=#=#=#=#=#=#=#
#& Sample runs
#& #=#=#=#=#=#=#=#=#=#=#
#& 
#& # ./bz2_2_gz.sh
#& There are (27) .bz2 files to convert to .gz files!
#& Type
#& ./bz2_2_gz.sh Fortra.com
#& 
#& # ./bz2_2_gz.sh Fortra.com
#& Running bz2_2_gz.sh,v #.# YYYY/MM/DD hh:mm:ss
#& Converting (27) .bz2 files to .gz files!
#& 
#& # ./bz2_2_gz.sh hsllc.com
#& Running bz2_2_gz.sh,v #.# YYYY/MM/DD hh:mm:ss
#& There are no .bz2 files to convert to .gz files!
#& 
