#!/bin/ksh
#!/bin/ksh -xv
#
# $Id: 3rd_zonetype.sh,v 1.1 2023/03/27 16:02:21 root Exp $
#
# The following code is Confidential and is covered by the installation license
#
#&& zonetype 
#
#& This script can be used by customers and came from IBM developerworks
#
# echo "Running `grep "\$\I\d\:" ${0} | awk '{print $3,$4,$5,$6}' ` "

##! /bin/bash
#
# Found at sight:
# http://spiralbound.net/blog/2010/01/26/zonetype-sh-version-2-0/
#
# When issued with the -g or --global flag, this script will return:
# 0 if the machine is a global zone and has one or more local zones. 
# Otherwise, it will return 1
#
# When issued with the -l or --local flag, this script will return:
# 0 if if is a local zone and 1 if it is not
#
# When issued with the -v or --vmware flag, this script will return:
# 0 if it is a vmware host and 1 if not.
#

list=( `/usr/sbin/zoneadm list -civ | awk '{ print $1 }'`)

  case "$1" in
      -g|--global)
	  # If the third element in our array is null, set it to 0
	  if [ "${list[2]}" == ""  ]; then
	     list[2]=0
	  fi
	  # This is a global zone only if it has one or more local zones.
	  if [ ${list[1]} -eq 0 ] && [ ${list[2]} -ge 1 ]; then
	  # 1 is returned if we have a global and local zone, 
	  # otherwise, we return 0
	          exit 0
	      else
	          exit 1
	  fi
	        ;;
      -l|--local)
          # If the second element in our array is = or > 1, it is a local zone.
	  if [ ${list[1]} -ge 1 ]; then
	  # Return 1 if this is a local zone, otherwise return 0.
	     exit 0
	  else
	     exit 1
	  fi
                ;;
      -v|--vmware)
          # Don't run our check on local zones... Prtdiag can't run there
	  if [ ${list[1]} != 0 ]; then
	     exit 1
          else 
	     vmhost=( `/usr/sbin/prtdiag | grep System | awk '{ print $5 }'`)
	     if [ $vmhost == VMware ]; then
	        #If the host is running on the vmware cluster return 0, 
	        # otherwise, return 1
		exit 0
	     else
	        exit 1
             fi
	  fi
	        ;;
	  *)
	  echo "Usage: /local/adm/zonetype.sh {-l | --local | -g | --global | -v | --vmware}"
	  exit 1
  esac
