#!/bin/ksh
#!/bin/ksh -xv
#
# $Id: 3rd_IBM_userattr.sh,v 1.1 2023/03/27 16:02:21 root Exp $
#
#&& Identify user attributes 
#
#& This script can be used by customers and came from IBM developerworks
#
echo "Running `grep "\$\I\d\:" ${0} | awk '{print $3,$4,$5,$6}' ` "


# userattr
#
# Copyright Brian Smith
# https://www.ibm.com/developerworks/community/blogs/brian/entry/aix_user_attributes_in_depth2?lang=en

tab=`printf "\t"`

if [ -n "$1" ]; then
  printf "# \033[37mDEFAULT For User  \033[32m SET For User  \033[33m Unknown";
  lsuser -f $* | grep -v "^$" | while read line; do
    if echo "$line" | grep ":$" >/dev/null; then
      printf "\n\033[0m$line " | tr -d ":"
      user=`echo "$line"  | tr -d ":"`
      continue
    fi

    if echo "$line" | egrep "id=|pgrp=|groups=|home=|shell=|gecos=" > /dev/null && ! echo "$line" | egrep "sugroups|admgroups" >/dev/null; then
      printf "\033[32m$line "
      continue
    fi

    if echo "$line" | egrep "time_last_login=|time_last_unsuccessful_login=|tty_last_login=|tty_last_unsuccessful_login=|host_last_login=|host_last_unsuccessful_login=|unsuccessful_login_count" > /dev/null; then
      continue
    fi

    #lsuser umask doesn't show umask with padded zeros, so add these in for comparison
    if echo "$line" | grep "umask=" > /dev/null; then
      mask=`echo $line | awk -F= '{print $2}'`
      line=`printf "umask=%03d" $mask`
    fi
    if cat /etc/security/user /etc/security/passwd /etc/security/limits | sed "s/[ $tab]=[ $tab]*/=/g" | grep -p "^${user}:" | tr -d '"' | grep "$line$" >/dev/null; then
      printf "\033[32m$line "  #Set
    else
      if cat /etc/security/user /etc/security/passwd /etc/security/limits | sed "s/[ $tab]=[ $tab]*/=/g" | grep -p "^default:" | tr -d '"' | grep "$line$" >/dev/null; then
        printf "\033[37m$line "  #default
      else
        printf "\033[33m$line "  #other
      fi
    fi
  done
printf "\033[0m\n";
else
  printf "\033[0m\n";
  printf "Specify user account or ALL\n"
fi

