#!/bin/ksh
#!/bin/ksh -xv
#
# $Id: 3rd_IBM_chk_oslevel.sh,v 1.1 2023/03/27 16:02:21 root Exp $
#
# The following code is Confidential and is covered by the installation license
# (c) Copyright Fortra, LLC. and its group of companies.
#
#&& Can be used to identify the version number 
#
#& This script can be used by customers and came from IBM developerworks  
#
echo "Running `grep "\$\I\d\:" ${0} | awk '{print $3,$4,$5,$6}' ` "
#
echo "Found script at IBM developer works"
#& https://www.ibm.com/developerworks/community/blogs/brian/entry/how_to_determine_why_your_aix_oslevel_is_downlevel_and_a_script_to_help?lang=en
echo "Checking oslevel..."
curr_oslevel=`oslevel -s`

if [ "`oslevel -sq 2>/dev/null | sed -n '1p'`" = "$curr_oslevel" ]; then
        echo "oslevel appears to be correct:  $curr_oslevel"
        exit 0
fi

if [ "`oslevel -rq 2>/dev/null | sed -n '1p'`" = "`oslevel -r`" ]; then
        echo "Current SP level appears to be downlevel"
        echo "oslevel -s:     $curr_oslevel"
        echo "oslevel -s -q:  `oslevel -sq 2>/dev/null | sed -n '1p'`"
        echo; echo "Check the following filesets:"
        oslevel -s -l `oslevel -sq 2>/dev/null | sed -n '1p'`
else
        echo "Current TL level appears to be downlevel"
        echo "oslevel -r:     `oslevel -r`"
        echo "oslevel -r -q:  `oslevel -rq 2>/dev/null | sed -n '1p'`"
        echo; echo "Check the following filesets:"
        oslevel -r -l `oslevel -rq 2>/dev/null | sed -n '1p'`
fi

#& ##################
#& ### Sample run ###
#& ##################
#& # 
#& # Running chk_oslevel.sh,v #.# YYYY/MM/DD hh:mm:ss
#& # Found script at IBM developer works
#& # Checking oslevel...
#& # Current TL level appears to be downlevel
#& # oslevel -r:     6100-04
#& # oslevel -r -q:  6100-05
#& # 
#& # Check the following filesets:
#& # Fileset                                 Actual Level           Recommended ML
#& # -----------------------------------------------------------------------------
#& # DirectorCommonAgent                     6.1.0.4                6.1.2.0
#& # X11.base.lib                            6.1.4.0                6.1.5.0
#& # ... ...
#& # devices.vdevice.hvterm1.rte             6.1.4.0                6.1.5.0
#& # perfagent.tools                         6.1.4.0                6.1.5.0

