//
//  ViewController.swift
//  OrientationTest
//
//  Created by Pavel Alexeev on 06.01.2022.
//

import UIKit

class ViewController: UIViewController {
	
	override func viewDidLoad() {
		super.viewDidLoad()
	
		for _ in 0...5000 {
			addRandomView()
		}

		DispatchQueue.main.async() {[self] in
			for _ in 0...15000 {
				addRandomView()
			}
		}
		
		view.backgroundColor = .white
	}
	
	func addRandomView() {
		let square = UIView(frame: CGRect(x: Double.random(in: 0..<view.frame.width), y: Double.random(in: 0..<view.frame.height), width: 150, height:75))
		square.backgroundColor = [UIColor.systemRed, UIColor.systemBlue, UIColor.systemCyan, UIColor.systemGray, UIColor.systemMint, UIColor.systemPink, UIColor.systemTeal, UIColor.systemBrown].randomElement()

		view.addSubview(square)
	}

	override var supportedInterfaceOrientations: UIInterfaceOrientationMask {
		print("checking supported interface orientation for UIViewController")
		return .landscape
	}

}

