# transform.sh param1-dir(input) param2-ipa(input)
#              param1-dir : the directory that contains the branding input files. which we will define. 
#              param2-pkg : the input ipa file that was released by Gladinet.
#              
readonly PARAM1_DIR=$1
readonly PARAM2_PKG=$2
readonly PARAM3_PKG=$3

readonly PLISTBUDDY="/usr/libexec/PlistBuddy"




readonly CURRENT_DIR=`pwd`
readonly BUILD_DIR="$CURRENT_DIR/build"
readonly PAYLOAD_DIR="$BUILD_DIR/payload_dir"
readonly CONTENT_DIR="$PAYLOAD_DIR/Payload/GladinetCloud.app"
readonly ENTITLE_MAIN="$BUILD_DIR/entitlement.plist"
readonly ENTITLE_DOCPROV="$BUILD_DIR/entitlement_doc.plist"
readonly ENTITLE_FILEPROV="$BUILD_DIR/entitlement_file.plist"
readonly ENTITLE_ACTIONEXT="$BUILD_DIR/entitlement_actionext.plist"
readonly ENTITLE_CORELIB="$BUILD_DIR/entitlement_corelib.plist"
readonly CORELIB2_PLIST_FILE="$CONTENT_DIR/Frameworks/corelib2.framework/Info.plist"

# all the temporary folder will be under build/outpkgdir and build/inpkgdir
if [ -d "$BUILD_DIR" ]; then
  # Control will enter here if $DIRECTORY exists.
  rm -rf "$BUILD_DIR"
fi

if [ ! -d "$PARAM1_DIR" ]; then
    echo "input branding directory not found!"
    exit 1
fi

readonly branding_info_file=$PARAM1_DIR/common.sh
if [ ! -f "$branding_info_file" ]; then
    echo "input branding common.sh file not found!"
    exit 1
fi

source "$branding_info_file"

readonly SIGN_APP_STR=$CERTIFICATENAME

if [ ! -f "$PARAM2_PKG" ]; then
    echo "input ipa file not found!"
    exit 1
fi


mkdir -p "$PAYLOAD_DIR"



# input will be a package .pkg and we will expand it to a folder at $INSTALLER_DIR
function installer_expand()
{
    local installerPkg=$1
    local targetDir=$2
    unzip "$installerPkg" -d "$targetDir"
}

function installer_collapse()
{
    local targetDir=$1
    local targetPkg=$2

    local baseName=`basename "$targetDir"`

    pushd "$targetDir"
   

    rm -f "$targetPkg"
	  zip -r "$targetPkg" .

    popd

}

function to_iospng()
{
    local sourceFile=$1
    local targetFile=$2

    if [ -f "$sourceFile" ]; then
        chmod +w "$targetFile"
        rm -f "$targetFile"
        $PNGCRUSH "$sourceFile" "$targetFile"
    fi

}

function direct_to_iospng()
{
    local sourceFile=$1
    # replace sourceFile
    local bra_file_png="$PARAM1_DIR/$sourceFile"
    local pkg_file_png="$CONTENT_DIR/$sourceFile"
    to_iospng "$bra_file_png" "$pkg_file_png"

}

function direct_to_docprov_iospng()
{
    local sourceFile=$1
    # replace sourceFile
    local bra_file_png="$PARAM1_DIR/$sourceFile"
    local pkg_file_png="$CONTENT_DIR/PlugIns/docprovider.appex/$sourceFile"
    to_iospng "$bra_file_png" "$pkg_file_png"

}

function direct_to_actionext_iospng()
{
    local sourceFile=$1
    # replace sourceFile
    local bra_file_png="$PARAM1_DIR/$sourceFile"
    local pkg_file_png="$CONTENT_DIR/PlugIns/actionext.appex/$sourceFile"
    to_iospng "$bra_file_png" "$pkg_file_png"

}

installer_expand $PARAM2_PKG $PAYLOAD_DIR

codesign -d --entitlements :- "$CONTENT_DIR" > "$ENTITLE_MAIN"
$PLISTBUDDY -c "Set :application-identifier '$FULLIOSID'" "$ENTITLE_MAIN"
$PLISTBUDDY -c "Set :com.apple.developer.team-identifier '$IOSTEAMID'" "$ENTITLE_MAIN"
$PLISTBUDDY -c "Set :com.apple.security.application-groups:0 '$IOSGROUPID'" "$ENTITLE_MAIN"

codesign -d --entitlements :- "$CONTENT_DIR/PlugIns/docprovider.appex" > "$ENTITLE_DOCPROV"
$PLISTBUDDY -c "Set :application-identifier '$FULLIOSID.docprovider'" "$ENTITLE_DOCPROV"
$PLISTBUDDY -c "Set :com.apple.developer.team-identifier '$IOSTEAMID'" "$ENTITLE_DOCPROV"
$PLISTBUDDY -c "Set :com.apple.security.application-groups:0 '$IOSGROUPID'" "$ENTITLE_DOCPROV"

codesign -d --entitlements :- "$CONTENT_DIR/PlugIns/docproviderFileProvider.appex" > "$ENTITLE_FILEPROV"
$PLISTBUDDY -c "Set :application-identifier '$FULLIOSID.docproviderFileProvider'" "$ENTITLE_FILEPROV"
$PLISTBUDDY -c "Set :com.apple.developer.team-identifier '$IOSTEAMID'" "$ENTITLE_FILEPROV"
$PLISTBUDDY -c "Set :com.apple.security.application-groups:0 '$IOSGROUPID'" "$ENTITLE_FILEPROV"

codesign -d --entitlements :- "$CONTENT_DIR/PlugIns/actionext.appex" > "$ENTITLE_ACTIONEXT"
$PLISTBUDDY -c "Set :application-identifier '$FULLIOSID.actionext'" "$ENTITLE_ACTIONEXT"
$PLISTBUDDY -c "Set :com.apple.developer.team-identifier '$IOSTEAMID'" "$ENTITLE_ACTIONEXT"
$PLISTBUDDY -c "Set :com.apple.security.application-groups:0 '$IOSGROUPID'" "$ENTITLE_ACTIONEXT"

codesign -d --entitlements :- "$CONTENT_DIR/Frameworks/corelib2.framework" > "$ENTITLE_CORELIB"
#$PLISTBUDDY -c "Set :application-identifier '$FULLIOSID.docproviderFileProvider'" "$ENTITLE_FILEPROV"
#$PLISTBUDDY -c "Set :com.apple.developer.team-identifier '$IOSTEAMID'" "$ENTITLE_FILEPROV"
#$PLISTBUDDY -c "Set :com.apple.security.application-groups:0 '$IOSGROUPID'" "$ENTITLE_FILEPROV"



readonly PNGCRUSH="xcrun -sdk iphoneos pngcrush -iphone"


readonly APPICON_INPUTDIR="$PARAM1_DIR/Images.xcassets/AppIcon.appiconset"
readonly LAUNCHI_INPUTDIR="$PARAM1_DIR/Images.xcassets/LaunchImage.launchimage"

# replace AppIcon - 29
readonly bra_appicon29_png="$APPICON_INPUTDIR/Logo_Gladinet29.png"
readonly pkg_appicon29_png="$CONTENT_DIR/AppIcon29x29.png"
to_iospng "$bra_appicon29_png" "$pkg_appicon29_png"

readonly pkg_appicon29_ipad_png="$CONTENT_DIR/AppIcon29x29~ipad.png"
to_iospng "$bra_appicon29_png" "$pkg_appicon29_ipad_png"

# replace AppIcon - 58
readonly bra_appicon58_png="$APPICON_INPUTDIR/Logo_Gladinet58.png"
readonly pkg_appicon58_png="$CONTENT_DIR/AppIcon29x29@2x.png"
to_iospng "$bra_appicon58_png" "$pkg_appicon58_png"


# replace AppIcon - 58 - ipad
#readonly bra_appicon58_png="$APPICON_INPUTDIR/Logo_Gladinet58.png"
readonly pkg_appicon58_ipad_png="$CONTENT_DIR/AppIcon29x29@2x~ipad.png"
to_iospng "$bra_appicon58_png" "$pkg_appicon58_ipad_png"


# replace AppIcon - 80
readonly bra_appicon80_png="$APPICON_INPUTDIR/Logo_Gladinet80.png"
readonly pkg_appicon80_png="$CONTENT_DIR/AppIcon40x40@2x.png"
to_iospng "$bra_appicon80_png" "$pkg_appicon80_png"

# replace AppIcon - 87
readonly bra_appicon87_png="$APPICON_INPUTDIR/Logo_Gladinet87.png"
readonly pkg_appicon87_png="$CONTENT_DIR/AppIcon29x29@3x.png"
to_iospng "$bra_appicon87_png" "$pkg_appicon87_png"

# replace AppIcon - 80 - ipad
#readonly bra_appicon80_png="$APPICON_INPUTDIR/Logo_Gladinet80.png"
readonly pkg_appicon80_ipad_png="$CONTENT_DIR/AppIcon40x40@2x~ipad.png"
to_iospng "$bra_appicon80_png" "$pkg_appicon80_ipad_png"


# replace AppIcon - 40 
readonly bra_appicon40_png="$APPICON_INPUTDIR/Logo_Gladinet40.png"
readonly pkg_appicon40_ipad_png="$CONTENT_DIR/AppIcon40x40~ipad.png"
to_iospng "$bra_appicon40_png" "$pkg_appicon40_ipad_png"


# replace AppIcon - 100
readonly bra_appicon100_png="$APPICON_INPUTDIR/Logo_Gladinet100.png"
readonly pkg_appicon100_ipad_png="$CONTENT_DIR/AppIcon50x50@2x~ipad.png"
to_iospng "$bra_appicon100_png" "$pkg_appicon100_ipad_png"


# replace AppIcon - 50
readonly bra_appicon50_png="$APPICON_INPUTDIR/Logo_Gladinet50.png"
readonly pkg_appicon50_ipad_png="$CONTENT_DIR/AppIcon50x50~ipad.png"
to_iospng "$bra_appicon50_png" "$pkg_appicon50_ipad_png"


# replace AppIcon - 114
readonly bra_appicon114_png="$APPICON_INPUTDIR/Logo_Gladinet114.png"
readonly pkg_appicon114_ipad_png="$CONTENT_DIR/AppIcon57x57@2x.png"
to_iospng "$bra_appicon114_png" "$pkg_appicon114_ipad_png"


# replace AppIcon - 120
readonly bra_appicon120_png="$APPICON_INPUTDIR/Logo_Gladinet120.png"
readonly pkg_appicon120_ipad_png="$CONTENT_DIR/AppIcon60x60@2x.png"
readonly pkg_appicon120_3x_png="$CONTENT_DIR/AppIcon40x40@3x.png"
to_iospng "$bra_appicon120_png" "$pkg_appicon120_ipad_png"
to_iospng "$bra_appicon120_png" "$pkg_appicon120_3x_png"

# replace AppIcon - 180
readonly bra_appicon180_png="$APPICON_INPUTDIR/Logo_Gladinet180.png"
readonly pkg_appicon180_ipad_png="$CONTENT_DIR/AppIcon60x60@3x.png"
to_iospng "$bra_appicon180_png" "$pkg_appicon180_ipad_png"


# replace AppIcon - 144
readonly bra_appicon144_png="$APPICON_INPUTDIR/Logo_Gladinet144.png"
readonly pkg_appicon144_ipad_png="$CONTENT_DIR/AppIcon72x72@2x~ipad.png"
to_iospng "$bra_appicon144_png" "$pkg_appicon144_ipad_png"


# replace AppIcon - 72
readonly bra_appicon72_png="$APPICON_INPUTDIR/Logo_Gladinet72.png"
readonly pkg_appicon72_ipad_png="$CONTENT_DIR/AppIcon72x72~ipad.png"
to_iospng "$bra_appicon72_png" "$pkg_appicon72_ipad_png"

# replace AppIcon - 76
readonly bra_appicon76_png="$APPICON_INPUTDIR/Logo_Gladinet76.png"
readonly pkg_appicon76_ipad_png="$CONTENT_DIR/AppIcon76x76~ipad.png"
to_iospng "$bra_appicon76_png" "$pkg_appicon76_ipad_png"

# replace AppIcon - 57
readonly bra_appicon57_png="$APPICON_INPUTDIR/Logo_Gladinet57.png"
readonly pkg_appicon57_png="$CONTENT_DIR/AppIcon57x57.png"
to_iospng "$bra_appicon57_png" "$pkg_appicon57_png"

# replace AppIcon - 152
readonly bra_appicon152_png="$APPICON_INPUTDIR/Logo_Gladinet152.png"
readonly pkg_appicon152_png="$CONTENT_DIR/AppIcon76x76@2x~ipad.png"
to_iospng "$bra_appicon152_png" "$pkg_appicon152_png"

# replace Default.png

direct_to_iospng "Default.png"
direct_to_iospng "Default@2x.png"
direct_to_iospng "Default-568h@2x.png"
direct_to_iospng "Full_Logo_Black_Glow.png"
direct_to_docprov_iospng "Full_Logo_Black_Glow.png"
direct_to_actionext_iospng "Full_Logo_Black_Glow.png"
direct_to_iospng "icon.png"

direct_to_iospng "Logo_Gladinet29.png"
direct_to_iospng "Logo_Gladinet40.png"
direct_to_iospng "Logo_Gladinet50.png"
direct_to_iospng "Logo_Gladinet57.png"
direct_to_iospng "Logo_Gladinet58.png"
direct_to_iospng "Logo_Gladinet72.png"
direct_to_iospng "Logo_Gladinet76.png"
direct_to_iospng "Logo_Gladinet80.png"
direct_to_iospng "Logo_Gladinet100.png"
direct_to_iospng "Logo_Gladinet114.png"
direct_to_iospng "Logo_Gladinet120.png"
direct_to_iospng "Logo_Gladinet144.png"
direct_to_iospng "Logo_Gladinet152.png"


# replace launch image 640_1136
readonly bra_li640_1136_png="$LAUNCHI_INPUTDIR/Default-568h@2x.png"
readonly pkg_li640_1136_png="$CONTENT_DIR/LaunchImage-568h@2x.png"
to_iospng "$bra_li640_1136_png" "$pkg_li640_1136_png"

readonly pkg_li640_1136_old_png="$CONTENT_DIR/launch640_1136.png"
to_iospng "$bra_li640_1136_png" "$pkg_li640_1136_old_png"

readonly pkg_li640_1136_700_png="$CONTENT_DIR/LaunchImage-700-568h@2x.png"
to_iospng "$bra_li640_1136_png" "$pkg_li640_1136_700_png"

# replace launch image 2048_1536
readonly bra_li2048_1536_png="$LAUNCHI_INPUTDIR/li2048x1536.png"
readonly pkg_li2048_1536_png="$CONTENT_DIR/LaunchImage-700-Landscape@2x~ipad.png"
to_iospng "$bra_li2048_1536_png" "$pkg_li2048_1536_png"

# replace launch image 1024_768 - LaunchImage-700-Landscape~ipad.png
readonly bra_li1024_768_png="$LAUNCHI_INPUTDIR/li1024x748.png"
readonly pkg_li1024_768_png="$CONTENT_DIR/LaunchImage-700-Landscape~ipad.png"
to_iospng "$bra_li1024_768_png" "$pkg_li1024_768_png"
#LaunchImage-Landscape~ipad.png
readonly pkg_li1024_768_old_png="$CONTENT_DIR/LaunchImage-Landscape~ipad.png"
to_iospng "$bra_li1024_768_png" "$pkg_li1024_768_old_png"


# replace launch image 1536 2048 LaunchImage-700-Portrait@2x~ipad.png
readonly bra_li1536_2048_png="$LAUNCHI_INPUTDIR/li1536x2048.png"
readonly pkg_li1536_2048_png="$CONTENT_DIR/LaunchImage-700-Portrait@2x~ipad.png"
to_iospng "$bra_li1536_2048_png" "$pkg_li1536_2048_png"

# replace launch image 768 1024 
readonly bra_li768_1024_png="$LAUNCHI_INPUTDIR/li1536x2048.png"
readonly pkg_li768_1024_png="$CONTENT_DIR/LaunchImage-700-Portrait~ipad.png"
to_iospng "$bra_li768_1024_png" "$pkg_li768_1024_png"


# replace launch image 640 960
readonly bra_li640_960_png="$LAUNCHI_INPUTDIR/Default@2x.png"
readonly pkg_li640_960_png="$CONTENT_DIR/LaunchImage-700@2x.png"
to_iospng "$bra_li640_960_png" "$pkg_li640_960_png"

readonly pkg_li640_960_old_png="$CONTENT_DIR/launch640_960.png"
to_iospng "$bra_li640_960_png" "$pkg_li640_960_old_png"
readonly pkg_li640_960_new_png="$CONTENT_DIR/LaunchImage@2x.png"
to_iospng "$bra_li640_960_png" "$pkg_li640_960_new_png"



# 2048 1496
# replace launch image 640 960
readonly bra_li2048_1496_png="$LAUNCHI_INPUTDIR/li2048x1496.png"
readonly pkg_li2048_1496_png="$CONTENT_DIR/LaunchImage-Landscape@2x~ipad.png"
to_iospng "$bra_li2048_1496_png" "$pkg_li2048_1496_png"


# 1536 2008
readonly bra_li1536_2008_png="$LAUNCHI_INPUTDIR/li1536x2008.png"
readonly pkg_li1536_2008_png="$CONTENT_DIR/LaunchImage-Portrait@2x~ipad.png"
to_iospng "$bra_li1536_2008_png" "$pkg_li1536_2008_png"

#768 1004
readonly bra_li768_1004_png="$LAUNCHI_INPUTDIR/li768x1004.png"
readonly pkg_li768_1004_png="$CONTENT_DIR/LaunchImage-Portrait~ipad.png"
to_iospng "$bra_li768_1004_png" "$pkg_li768_1004_png"


#320 480
readonly bra_li320_480_png="$LAUNCHI_INPUTDIR/Default.png"
readonly pkg_li320_480_png="$CONTENT_DIR/LaunchImage.png"
to_iospng "$bra_li320_480_png" "$pkg_li320_480_png"

readonly pkg_li320_480_old_png="$CONTENT_DIR/launch320_480.png"
to_iospng "$bra_li320_480_png" "$pkg_li320_480_old_png"

# xcrun -sdk iphoneos pngcrush -d ~/iospng2 -revert-iphone-optimizations *.png

# remove the current signature.
if [ -d "$CONTENT_DIR/_CodeSignature" ]; then
  # Control will enter here if $DIRECTORY exists.
  rm -rf "$CONTENT_DIR/_CodeSignature"
fi

if [ -d "$CONTENT_DIR/CodeResources" ]; then
  # Control will enter here if $DIRECTORY exists.
  rm -rf "$CONTENT_DIR/CodeResources"
fi

#now one plugin

readonly ACTIONEXT_PLIST_FILE="$CONTENT_DIR/PlugIns/actionext.appex/Info.plist"

 #   <key>CFBundleDisplayName</key>
 #   <string>Gladinet Document Provider</string>
 #   <key>CFBundleIdentifier</key>
 #   <string>com.gladinet.iosbrowser.docprovider</string>
 #   <key>CSAccessPoint</key>
 #   <string>https://gcloud.gladinet.com/namespace/n.svc/</string>
chmod +w "$ACTIONEXT_PLIST_FILE"
$PLISTBUDDY -c "Set :CFBundleIdentifier '$IOSPACKAGEID.actionext'" "$ACTIONEXT_PLIST_FILE"
$PLISTBUDDY -c "Set :CFBundleDisplayName 'Save to $PRODUCTNAME'" "$ACTIONEXT_PLIST_FILE"
$PLISTBUDDY -c "Set :CSAccessPoint 'https://$ACCESSPOINT/namespace/n.svc/'" "$ACTIONEXT_PLIST_FILE"

#plutil -convert xml1 some_file.plist
#to convert so can be read
readonly DOCPROVIDER_PLIST_FILE="$CONTENT_DIR/PlugIns/docprovider.appex/Info.plist"

 #   <key>CFBundleDisplayName</key>
 #   <string>Gladinet Document Provider</string>
 #   <key>CFBundleIdentifier</key>
 #   <string>com.gladinet.iosbrowser.docprovider</string>
 #   <key>CSAccessPoint</key>
 #   <string>https://gcloud.gladinet.com/namespace/n.svc/</string>
chmod +w "$DOCPROVIDER_PLIST_FILE"
$PLISTBUDDY -c "Set :CFBundleIdentifier '$IOSPACKAGEID.docprovider'" "$DOCPROVIDER_PLIST_FILE"
$PLISTBUDDY -c "Set :CFBundleDisplayName '$PRODUCTNAME'" "$DOCPROVIDER_PLIST_FILE"
$PLISTBUDDY -c "Set :CSAccessPoint 'https://$ACCESSPOINT/namespace/n.svc/'" "$DOCPROVIDER_PLIST_FILE"

#now the other plugin
readonly FILEPROVIDER_PLIST_FILE="$CONTENT_DIR/PlugIns/docproviderFileProvider.appex/Info.plist"

#   <key>CFBundleIdentifier</key>
#   <string>com.gladinet.iosbrowser.docproviderFileProvider</string>
chmod +w "$FILEPROVIDER_PLIST_FILE"
$PLISTBUDDY -c "Set :CFBundleIdentifier '$IOSPACKAGEID.docproviderFileProvider'" "$FILEPROVIDER_PLIST_FILE"
$PLISTBUDDY -c "Set :NSExtension:NSExtensionFileProviderDocumentGroup '$IOSGROUPID'" "$FILEPROVIDER_PLIST_FILE"
 

#    <key>GroupName</key>
#    <string>group.com.gladinet.iosbrowser</string>
chmod +w "$CORELIB2_PLIST_FILE"
$PLISTBUDDY -c "Set :GroupName '$IOSGROUPID'" "$CORELIB2_PLIST_FILE"

# now let's replace some stuff 
# /Users/jerry/testpkg/build/payload_dir/Privatier Cloud Mac Client.app/Contents/Resources
readonly PLIST_FILE="$CONTENT_DIR/Info.plist"
chmod +w "$PLIST_FILE"
$PLISTBUDDY -c "Set :CFBundleIdentifier '$IOSPACKAGEID'" "$PLIST_FILE"
$PLISTBUDDY -c "Set :CFBundleName '$PRODUCTNAMENOS'" "$PLIST_FILE"
$PLISTBUDDY -c "Set :CFBundleDisplayName '$PRODUCTNAME'" "$PLIST_FILE"
$PLISTBUDDY -c "Set :CSAccessPoint 'https://$ACCESSPOINT/namespace/n.svc/'" "$PLIST_FILE"
$PLISTBUDDY -c "Set :CSCopyright '$COPYRIGHTSTR'" "$PLIST_FILE"

readonly VERSION_OVERRIDE='7.7.36023' 
$PLISTBUDDY -c "Set :CFBundleShortVersionString '$VERSION_OVERRIDE'" "$PLIST_FILE"
$PLISTBUDDY -c "Set :CFBundleVersion '$VERSION_OVERRIDE'" "$PLIST_FILE"

$PLISTBUDDY -c "Set :CFBundleShortVersionString '$VERSION_OVERRIDE'" "$FILEPROVIDER_PLIST_FILE"
$PLISTBUDDY -c "Set :CFBundleVersion '$VERSION_OVERRIDE'" "$FILEPROVIDER_PLIST_FILE"

$PLISTBUDDY -c "Set :CFBundleShortVersionString '$VERSION_OVERRIDE'" "$DOCPROVIDER_PLIST_FILE"
$PLISTBUDDY -c "Set :CFBundleVersion '$VERSION_OVERRIDE'" "$DOCPROVIDER_PLIST_FILE"

$PLISTBUDDY -c "Set :CFBundleShortVersionString '$VERSION_OVERRIDE'" "$ACTIONEXT_PLIST_FILE"
$PLISTBUDDY -c "Set :CFBundleVersion '$VERSION_OVERRIDE'" "$ACTIONEXT_PLIST_FILE"


readonly ENTITLE_FILE="$CONTENT_DIR/archived-expanded-entitlements.xcent"
chmod +w "$ENTITLE_FILE"
#$PLISTBUDDY -c "Set :application-identifier '$FULLIOSID'" "$ENTITLE_FILE"
#$PLISTBUDDY -c "Set :keychain-access-groups:0 '$FULLIOSID'" "$ENTITLE_FILE"
$PLISTBUDDY -c "Set :com.apple.security.application-groups:0 '$IOSGROUPID'" "$ENTITLE_FILE"

readonly DOCPROVIDER_XCENT_FILE="$CONTENT_DIR/PlugIns/docprovider.appex/archived-expanded-entitlements.xcent"
chmod +w "$DOCPROVIDER_XCENT_FILE"
$PLISTBUDDY -c "Set :com.apple.security.application-groups:0 '$IOSGROUPID'" "$DOCPROVIDER_XCENT_FILE"

readonly FILEPROVIDER_XCENT_FILE="$CONTENT_DIR/PlugIns/docproviderFileProvider.appex/archived-expanded-entitlements.xcent"
chmod +w "$FILEPROVIDER_XCENT_FILE"
$PLISTBUDDY -c "Set :com.apple.security.application-groups:0 '$IOSGROUPID'" "$FILEPROVIDER_XCENT_FILE"

# copy mobile provision file
readonly MP_INPUTDIR="$PARAM1_DIR/main.mobileprovision"
readonly MP_OUTPUTDIR="$CONTENT_DIR/embedded.mobileprovision"
chmod +w "$MP_OUTPUTDIR"
rm -f "$MP_OUTPUTDIR"
cp "$MP_INPUTDIR" "$MP_OUTPUTDIR"


readonly MPDP_INPUTDIR="$PARAM1_DIR/docprovider.mobileprovision"
readonly MPDP_OUTPUTDIR="$CONTENT_DIR/PlugIns/docprovider.appex/embedded.mobileprovision"
chmod +w "$MPDP_OUTPUTDIR"
rm -f "$MPDP_OUTPUTDIR"
cp "$MPDP_INPUTDIR" "$MPDP_OUTPUTDIR"

readonly MPFP_INPUTDIR="$PARAM1_DIR/fileprovider.mobileprovision"
readonly MPFP_OUTPUTDIR="$CONTENT_DIR/PlugIns/docproviderFileProvider.appex/embedded.mobileprovision"
chmod +w "$MPFP_OUTPUTDIR"
rm -f "$MPFP_OUTPUTDIR"
cp "$MPFP_INPUTDIR" "$MPFP_OUTPUTDIR"

readonly MPAE_INPUTDIR="$PARAM1_DIR/actionext.mobileprovision"
readonly MPAE_OUTPUTDIR="$CONTENT_DIR/PlugIns/actionext.appex/embedded.mobileprovision"
chmod +w "$MPAE_OUTPUTDIR"
rm -f "$MPAE_OUTPUTDIR"
cp "$MPAE_INPUTDIR" "$MPAE_OUTPUTDIR"

#xcrun codesign --verify --verbose [MYFramework.framework/MYFramework]
/usr/bin/codesign  --verbose -f -s "$SIGN_APP_STR" --entitlements "$ENTITLE_CORELIB" "$CONTENT_DIR/Frameworks/corelib2.framework"

/usr/bin/codesign  --verbose -f -s "$SIGN_APP_STR" --entitlements "$ENTITLE_ACTIONEXT" "$CONTENT_DIR/PlugIns/actionext.appex"
/usr/bin/codesign  --verbose -f -s "$SIGN_APP_STR" --entitlements "$ENTITLE_DOCPROV" "$CONTENT_DIR/PlugIns/docprovider.appex"
/usr/bin/codesign  --verbose -f -s "$SIGN_APP_STR" --entitlements "$ENTITLE_FILEPROV" "$CONTENT_DIR/PlugIns/docproviderFileProvider.appex"

/usr/bin/codesign  --verbose -f -s "$SIGN_APP_STR" --entitlements "$ENTITLE_MAIN" "$CONTENT_DIR"

installer_collapse "$PAYLOAD_DIR" "$CURRENT_DIR/output.ipa"