﻿<%@ Page Title="Gladinet Cloud - User Manager" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="UserMgrPage.aspx.cs" Inherits="GladinetPayFlow.UserMgrPage"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
        .gridobject{

         }
        .titlecol
        {
            background-color: #f0f0f0;
            font-size: 14px;
        }
        .actiontbl{
        display: table;
        }
        .actioncol{
        display: table-cell;margin-top:5px;
        }
        .actioncol .gladinet-icons {
        padding-left:5px;
        padding-right:5px;
        }
		.actioncol .tooltip{
            margin:20px 0px 0px 5px !important;  /*tooltip positioning*/ 
		}
        
        
        .securityicon
        {
            background-image: url(images/security2.png);
        }
        .whitelisticon
        {
            background-image: url(images/whitelist.png);
        }
        
        
      
        .dark {
            color: #565656 !important;
        }
        .smallbtn {
            padding-left: 3px !important;
            padding-right: 3px !important;
        }

        .tentv {
            border-style: dashed !important;
            border-color: #cccccc;
            border-width: 1px;
            border-radius: 4px;
        }

        .tent 
        {
            background-image: url(/management/images/usermgrbg.jpg);
            background-size: 100% auto;
            background-position: right bottom;
            background-repeat: no-repeat;
        }

        .badge
        {
            background-color:white; border:1px solid #d0d0d0; color:#868686;font-weight:100;

        }
        .x-tree-icon.x-hide {
            display:none;
        }
        .x-tree-node-text .gladinet-icons {
            padding-right: 5px;
			margin-top: -3px;
        } 
        .x-tree-node-text {
			cursor:pointer !important;
        } 
		.x-tree-arrows .x-grid-tree-node-expanded .x-tree-expander {
			background-position: -22px center;
		}
		.x-tree-expander-over .x-tree-expander {
			background-position: -22px center !important;
		}
        .tooltip {margin-top:10px;}
        .x-gridview-1022-table.x-grid-table .gladinet-icons.md-24 {
            font-size: 24px;
            line-height: 24px;
            min-width: 34px;
        }
        .x-docked {
            z-index: unset;
        }
        .centerCell .x-grid-cell-inner {
            text-align: center !important;
            font-weight:100 !important;
        }
        #errmsgdiv{font-weight:100;}
    </style>
    <script type="text/javascript">
        var eleClassName = "gridobject col-2";
        function CloseQuickWindow(u, t)
        {
            try{
                var e = document.getElementById("ShortWindow");
                e.src = "/portal/WaitWin.htm";

            }catch(ee){

            }
            try{
                $('#ShortWindowModal').modal('hide');
                
            }catch(e){

            }

        }

        function OpenQuickWindow(u, t)
        {
            var e = document.getElementById("ShortTitle");
            e.innerHTML = "&nbsp;&nbsp;";

            e = document.getElementById("ShortBody");            
            if(document.documentElement.clientHeight<750)
                e.style.height = "500px"
            else
                e.style.height = "600px"

            e = document.getElementById("ShortWindow");
            e.src = u;
            $('#ShortWindowModal').modal({ backdrop: 'static', keyboard: false });

        }
        function CanScan() {
        
            gConfirm("<asp:Localize meta:resourcekey="str_confirm1" runat="server">It may take a long time to process accounts with significant storage usage. Continue?</asp:Localize> ", "", function(btn1) {

                    if (btn1 != 'ok')
                        return;
                        var btn = document.getElementById('MainContent_LinkButton3');
                        Wait("<asp:Localize meta:resourcekey="str_scaning" runat="server">Scanning...</asp:Localize>");
                        btn.click();
                });

        }

        function getScrollXY() {
            var scrOfX = 0, scrOfY = 0;
            if (typeof (window.pageYOffset) == 'number') {
                //Netscape compliant
                scrOfY = window.pageYOffset;
                scrOfX = window.pageXOffset;
            } else if (document.body && (document.body.scrollLeft || document.body.scrollTop)) {
                //DOM compliant
                scrOfY = document.body.scrollTop;
                scrOfX = document.body.scrollLeft;
            } else if (document.documentElement && (document.documentElement.scrollLeft || document.documentElement.scrollTop)) {
                //IE6 standards compliant mode
                scrOfY = document.documentElement.scrollTop;
                scrOfX = document.documentElement.scrollLeft;
            }
            //return [scrOfX, scrOfY];
            return scrOfY;
        }



        var activewin;
        function OnSetQuotaShowDialog(userId, oldQuota, guid) {
            
            if(parent.OpenQuickWindow){
                parent.OpenQuickWindow("/portal/SetUserQuotaPage.aspx?userid=" + userId + "&guid=" + guid + "&oldquota=" + oldQuota +"&vdid=<%=SessionDomainId %>&rurl=usermgr", "<asp:Localize meta:resourcekey="js_string1" runat="server">Configure User Home Directory</asp:Localize>");
                return;
            }
            OpenQuickWindow("/portal/SetUserQuotaPage.aspx?userid=" + userId + "&guid=" + guid + "&oldquota=" + oldQuota +"&vdid=<%=SessionDomainId %>&rurl=usermgr", "<asp:Localize meta:resourcekey="js_string1" runat="server">Configure User Home Directory</asp:Localize>");

            


        }

            function OnShowUserStorage(guid) {
                if(parent.OpenQuickWindow){
                    parent.OpenQuickWindow('/management/UserStorageStat.aspx?child=1&vdid=<%=SessionDomainId%>&uid=' +  guid, "<asp:Localize meta:resourcekey="str_ucstorage" runat="server">User Storage Usage</asp:Localize>");
                    return;
                }
                OpenQuickWindow('/management/UserStorageStat.aspx?child=1&vdid=<%=SessionDomainId%>&uid=' +  guid, "<asp:Localize meta:resourcekey="str_ucstorage" runat="server">User Storage Usage</asp:Localize>");
           


        }
        function ClearErrorMsg() {

            var d = document.getElementById("errmsgdiv");
            if (d) {
                d.style.display = 'none';
            }
        }

        
        
        //parent.setActivePanel("UserMgr");

        function onDelUser(id, name) {
            //decode html entities
            var txt = document.createElement("textarea");
            txt.innerHTML = id;
            var h = "UserMgrPage.aspx?op=delete&id=" + encodeURIComponent(txt.value).replace('+', ':')+"&vdid=<%=SessionDomainId %>";
            
            gConfirm("<asp:Localize meta:resourcekey="js_string2" runat="server">Do you really want to delete (</asp:Localize>" + unescape(name) + ")?","", 
                function(btn, text) {
                    
                    if (btn != 'ok')
                        return;
                    
                    <% if (m_ShowPurage){ %>
                     gConfirm1("<asp:Localize meta:resourcekey='PurgeUserStorage2' runat='server'>Do you want to purge the user's home directory storage? (You won't be able to recover files once it is purged)</asp:Localize>", "", function(btn1, text1) {
                        if (btn1 == 'ok')
                            h += "&ConfirmPurge=1";
                        Wait("<asp:Localize meta:resourcekey="js_string3" runat="server">Deleting</asp:Localize>");
                        window.location = h;

                    });
                    <% }else{ %>
                    
                        Wait("<asp:Localize meta:resourcekey="js_string3" runat="server">Deleting</asp:Localize>");
                        window.location = h;
                    <% } %>        
                    
                    
                        
                });

        }
        
        var gSelUser = "";
        function DelSelUsers() {
            var domainid = document.getElementById('MainContent_HiddenSelectedUserId');
            var ps = document.getElementById('MainContent_PurgeStorage');
            domainid.value = gSelUser;
            ps.value = "0";

            gConfirm("<asp:Localize meta:resourcekey="str_delselusers" runat="server">Do you really want to delete selected users</asp:Localize>","", function(btn, text) {
                
                if (btn == 'ok') {
                    <% if (m_ShowPurage){ %>
                        gConfirm1("<asp:Localize meta:resourcekey='PurgeUserStorage3' runat='server'>Do you want to purge the selected user(s)' home directory storage? (You won't be able to recover files once they are purged)</asp:Localize>", "", function(btn1, text1) {
                            if (btn1 == 'ok'){
                                ps.value = "1";
                            }
                            document.getElementById('MainContent_DelUsers').click();
                        });
                    <% } else { %>
                        document.getElementById('MainContent_DelUsers').click();
                    <% } %>
                }
                    
            });

        }

        
        function closeCancelActiveWin() {
            activewin.close();
        }

        function closeActiveWin() {
            window.location = "UserMgrPage.aspx?vdid=<%=SessionDomainId %>";
        }

        function ResetPassword(t) {

            var uri = "ResetUserPassword.aspx?t=";

            uri += t;

            activewin = new Ext.Window({
                id: 'resetpwd_win',
                title: "<asp:Localize meta:resourcekey="js_string4" runat="server">Reset Password</asp:Localize>",
                width: 650,
                height: 410,
                layout: 'fit',
                plain: true,
                modal: true,
                maximizable: true,
                resizable: true,
                layout: 'fit',
                bodyPadding: 5,
                bodyStyle: 'background:#dfe8f6;border:0px; ',
                items: [{
                    xtype: "component",
                    autoEl: {
                        tag: "iframe",
                        src: uri
                    }
                }]
            });
            activewin.show();
        }

        function OnAddUserWizard() {
            Wait('...'); 
            if (parent.SetRelativePageTitle) {
                parent.SetRelativePageTitle("<asp:Localize meta:resourcekey="str_adduser" runat="server">Add User</asp:Localize>", '/management/adduserwizard/AddUserType.aspx?vdid=<%=SessionDomainId %>');
            } else {   
                window.location = '/management/adduserwizard/AddUserType.aspx?vdid=<%=SessionDomainId %>';
            }
            return;
        }
        function OnAddUserOld() {

            activewin = new Ext.Window({
                id: 'On_Add_User',
                title: "<asp:Localize meta:resourcekey="js_string6" runat="server">Create New User</asp:Localize>",
                width: 680,
                height: maxh(576),
                constrain: true,
                plain: true,
                modal: true,
                maximizable: true,
                resizable: false,
                maximized: false,
                shadow: 'drop',
                shadowOffset: 20,
                layout: 'fit',
                bodyPadding: 3,
                html: "<iframe id='openwin' src='AddUserPage.aspx' scrolling='auto' style='width:100%;height:100%;margin:0;padding:0'></iframe>",
                defaults: {
                    border: false
                }
            });
            activewin.show();



        }

        function OnAddUser() {

            activewin = new Ext.Window({
                id: 'On_Add_User',
                title: "<asp:Localize meta:resourcekey="js_create_user" runat="server">Create New User</asp:Localize>",
                width: 880,
                height: maxh(560),
                constrain: true,
                plain: true,
                modal: true,
                maximizable: true,
                resizable: false,
                maximized: false,
                shadow: 'drop',
                shadowOffset: 20,
                layout: 'fit',
                bodyPadding: 3,
                html: "<iframe id='openwin' src='/management/AddUserWizard/SingleUserInfo.aspx' scrolling='auto' style='width:100%;height:100%;margin:0;padding:0'></iframe>",
                defaults: {
                    border: false
                }
            });
            activewin.show();



        }
        function OnLDAPAddUser() {
            var closeAction = new Ext.Action({
                text: "<asp:Localize meta:resourcekey="js_string7" runat="server">Close</asp:Localize>",
                width: 108
            });

            activewin = new Ext.Window({
                id: 'On_Ads_AddUser',
                title: "<asp:Localize meta:resourcekey="js_string8" runat="server">Add Active Directory User(s)</asp:Localize>",
                width: 718,
                height: maxh(780),
                constrain: true,
                y: 0,
                plain: true,
                modal: true,
                maximizable: true,
                constrain: true,
                maximized: false,
                layout: 'fit',
                bodyPadding: 3,
                html: "<iframe id='openwin' src='LDAPUserPage.aspx' scrolling='auto' style='width:100%;height:100%;margin:0;padding:0'></iframe>",
                defaults: {
                    border: false
                },
                buttons: [closeAction],
                listeners: {
                    "close": function () {
                        window.location = window.location;
                    }
                }
            });
            closeAction.setHandler(function () { activewin.close(); });

            activewin.show();



        }
        
        function OnBatchAddUser() {

            activewin = new Ext.Window({
                id: 'pubs_win',
                title: "<asp:Localize meta:resourcekey="js_string11" runat="server">Batch Create New User(s)</asp:Localize>",
                width: 680,
                height: maxh(726),
                plain: true,
                modal: true,
                maximizable: true,
                constrain: true,
                y: 0,
                maximized: false,
                layout: 'fit',
                bodyPadding: 3,
                html: "<iframe id='openwin' src='BatchAddUserPage.aspx' scrolling='auto' style='width:100%;height:100%;margin:0;padding:0;border:0;'></iframe>",
                defaults: {
                    border: false
                }
            });
            activewin.show();



        }

        function OnManageAdmin() {
            if (parent.OnManageAdmin)
                parent.OnManageAdmin();
            else
                parent.parent.OnManageAdmin();
        }

        function OnDeviceList(id) {
            var uri = "/portal/SearchDevicesPage.aspx?id=";

            uri += id;
            uri += "&vdid=<%=SessionDomainId %>"

            parent.SetRelativePageTitle("<asp:Localize meta:resourcekey="js_string12" runat="server">Device Manager</asp:Localize>",uri);
            window.location = uri;

            return;

            var Html = "<iframe id='openwin' src='"+uri;
            Html += "' scrolling='auto' style='width:100%;height:100%;margin:0;padding:0;border:0;'></iframe>";
            activewin = new Ext.Window({
                id: 'device_win',
                title: "<asp:Localize meta:resourcekey="js_string12" runat="server">Device Manager</asp:Localize>",
                width: 950,
                height: maxh(510),
                plain: true,
                modal: true,
                constrain: true,
                maximizable: true,
                maximized: false,
                bodyPadding: 0,
                resizable: true,
                shadow: 'drop',
                iconCls: 'publish',
                bodyStyle: 'background:#f0f0f0;border:0px; ',
                shadowOffset: 10,
                html: Html,
                defaults: {
                    border: false
                }
            });
            
            activewin.show();
        }


        function OnViewStorageList(id) {
            window.open("/portal/RawWebAppPage.aspx?vu=" + id+"&vdid=<%=SessionDomainId %>", "_blank", "location=no,menubar=no,toolbar=no,resizable=yes", true);
        }
        function OnTokenList(id) {
            var uri = "/management/DeviceTokenMgr.aspx?id=";

            uri += id;
            uri += "&vdid=<%=SessionDomainId %>";

            parent.SetRelativePageTitle("<asp:Localize meta:resourcekey="str_tokenmgr" runat="server">Token Manager</asp:Localize>",uri);
            window.location = uri;

            return;
            var Html = "<iframe id='openwin' src='"+uri;
            Html += "' scrolling='auto' style='width:100%;height:100%;margin:0;padding:0;border:0;'></iframe>";
            activewin = new Ext.Window({
                id: 'token_win',
                title: "<asp:Localize meta:resourcekey="str_tokenmgr" runat="server">Token Manager</asp:Localize>",
                width: 850,
                height: maxh(510),
                plain: true,
                modal: true,
                constrain: true,
                maximizable: true,
                maximized: false,
                bodyPadding: 0,
                resizable: true,
                shadow: 'drop',
                iconCls: 'publish',
                bodyStyle: 'background:#f0f0f0;border:0px; ',
                shadowOffset: 10,
                html: Html,
                defaults: {
                    border: false
                }
            });
            
            activewin.show();
        }

        function OnEditGroup(t, f, l, e) {
           
            parent.SetRelativePageTitle(f,"/portal/EditUserInfo.aspx?uid=" + t + "&vdid=<%=SessionDomainId %>");
            window.location = "/portal/EditUserInfo.aspx?uid=" + t + "&vdid=<%=SessionDomainId %>";
            //parent.OnEditGroup(t, f, l, e);

        }

        function OnChangeName(t, f, l) {

            var uri = "EditUserPage.aspx?uid=";

            uri += t;
            uri += "&firstname=";
            uri += f;
            uri += "&lastname=";
            uri += l;



            activewin = new Ext.Window({
                id: 'resetuname_win',
                title: "<asp:Localize meta:resourcekey="js_string13" runat="server">Change User Name</asp:Localize>",
                width: 550,
                height: 250,
                layout: 'fit',
                plain: true,
                modal: true,
                maximizable: true,
                resizable: true,
                layout: 'fit',
                bodyPadding: 5,
                bodyStyle: 'background:#dfe8f6;border:0px; ',
                items: [{
                    xtype: "component",
                    autoEl: {
                        tag: "iframe",
                        src: uri
                    }
                }],
                listeners: {
                    "close": function () {
                        window.location = window.location;
                    }
                }
            });
            activewin.show();
        }
        function OnChangeEmail(t) {

            var uri = "ChangeEmailPage.aspx?uid=";

            uri += t;



            activewin = new Ext.Window({
                id: 'resetacct_win',
                title: "<asp:Localize meta:resourcekey="js_string14" runat="server">Change Email</asp:Localize>",
                width: 550,
                height: 310,
                layout: 'fit',
                plain: true,
                modal: true,
                maximizable: true,
                resizable: true,
                layout: 'fit',
                bodyPadding: 5,
                bodyStyle: 'background:#dfe8f6;border:0px; ',
                items: [{
                    xtype: "component",
                    autoEl: {
                        tag: "iframe",
                        src: uri
                    }
                }],
                listeners: {
                    "close": function () {
                        window.location = window.location;
                    }
                }
            });
            activewin.show();
        }
        function OnClickGuest() {
            window.location = "/management/GuestUserMgrPage.aspx";
        }
        function OnClickGroup() {
            window.location = "/portal/GroupMgrPage.aspx";
        }

        function OnSuspend(did) {
            var domainid = document.getElementById('MainContent_HiddenUserId');
            var btn = document.getElementById('MainContent_SuspendUser');
            domainid.value = did;
            
            btn.click();
        }

        function OnResume(did) {
            var domainid = document.getElementById('MainContent_HiddenUserId');
            var btn = document.getElementById('MainContent_ResumeUser');
            domainid.value = did;
            btn.click();
        }

        function onMigrateADUser(em) {
            var domainid = document.getElementById('MainContent_HiddenUserId');
            var btn = document.getElementById('MainContent_MigrateUser');
            domainid.value = em;
            btn.click();
        }

        function EditImportedGroupList() {
            
            parent.parent.EditImportedGroupListWithDomain('<%=SessionDomainId %>');
        }


    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">    
<asp:Localize ID="LocAccDen" meta:resourcekey="str_accDen" Visible="false" runat="server">Access denied.</asp:Localize>
<asp:Localize ID="LocCanRetUseInf" meta:resourcekey="str_canRetUseInf" Visible="false" runat="server">Cannot retrieve user information.</asp:Localize>
<asp:Localize ID="LocCanDelDelAdm" meta:resourcekey="str_canDelDelAdm" Visible="false" runat="server">Cannot delete delegated administrator</asp:Localize>
<asp:Localize ID="LocFaiToLoaTheUseLis" meta:resourcekey="str_faiToLoaTheUseLis" Visible="false" runat="server">Failed to load the user list</asp:Localize>                                         
<asp:Localize ID="LocQUAOfTOTUseFou" meta:resourcekey="str_qUAOfTOTUseFou" Visible="false" runat="server">[$QUANT] of [$TOTALQUANT] users found</asp:Localize>
<asp:Localize runat="server" ID="LocScaWasSuc" meta:resourcekey="str_scaWasSuc" Visible="false">Scan was successful</asp:Localize>
<asp:Localize runat="server" ID="LocFaiToGetTenInf" meta:resourcekey="str_faiToGetTenInf" Visible="false">Failed to get tenant info</asp:Localize>
<asp:Localize runat="server" ID="LocUpnIsMis" meta:resourcekey="str_upnIsMis" Visible="false">UPN is missing</asp:Localize>
<asp:Localize runat="server" ID="LocFaiToFinAdUseWitTheSamEma" meta:resourcekey="str_faiToFinAdUseWitTheSamEma" Visible="false">failed to find ad user with the same email.</asp:Localize>
<asp:Localize runat="server" ID="LocNoAdIsCon" meta:resourcekey="str_noAdIsCon" Visible="false">No AD is configured.</asp:Localize>
<asp:Localize runat="server" ID="LocFaiToLoaUse" meta:resourcekey="str_faiToLoaUse" Visible="false">Failed to load user</asp:Localize>
<asp:Localize ID="LocScnScsMsg" meta:resourcekey="str_scnScsMsg" runat="server" Visible="false">Scan was successful</asp:Localize>
<asp:Localize ID="LocOf" meta:resourcekey="str_of" runat="server" Visible="false">of</asp:Localize>
<asp:Localize ID="LocUsd" meta:resourcekey="str_usd" runat="server" Visible="false">used</asp:Localize>   
<asp:Localize ID="LocNoUsrFndHlp" meta:resourcekey="str_noUsrFndHlp" runat="server" Visible="false">No users were found. Search for * to return all users.</asp:Localize>

    <div style="width: 100%; padding: 5px; border-bottom: 1px solid #cccccc ;" class="meubardrop1">
        <table width="100%">
              <tr>
                  <td style="width:180px">
                            <span class="gladbtn" style="font-weight: 400!important; font-size: 20px!important; text-transform: uppercase; color:#808080!important;"><asp:Localize meta:resourcekey="str_users" runat="server">Users</asp:Localize></span>
                        </td>
                  <td>
                      <table >
                     <tr>
                         <td>
                               <a href="#" onclick="OnIconView();return false;" style="color:white;display:none;"  id="iconview">
            <button type="button" class="btn navbar-btn navbar-left" style="padding: 2px;  margin-left: 5px;">   
                 <i class="gladinet-icons md-24 md-dark hand center toolbtn" style="display: inline-block; margin-top: 12px;" >&#0164;</i>
                
            </button>  
            </a>          
        <a href="#" onclick="OnListView();return false;" style="color:white;"  id="listview">
            <button type="button" class="btn navbar-btn navbar-left" style="padding: 2px;  margin-left: 5px;">   
               <i class="gladinet-icons md-24 md-dark hand center toolbtn" style="display: inline-block; margin-top: 12px;" >&#0186;</i>
                
            </button>  
            </a>          
                         </td>
                         <td style="padding-left: 20px;">
                              <%if (m_CanAdd){ %>
         
              <asp:Localize  Visible="False" meta:resourcekey="asp_string5" id="CrORMir" runat="server">Create or Migrate User</asp:Localize>
                            <a href="#" onclick="OnAddUserWizard();return false;" style="font-size: 12px;" title="<%=asp_string5.Text %>">
                                 <button type="button" class="btn btn-primary gladbtn navbar-btn navbar-right smallbtn" style="margin-right:8px;">   <span class="fa fa-plus sectextcolor" aria-hidden="true" style="font-size: 14px; margin-left: 15px; margin-top: 12px; cursor: pointer; display: inline-block; position: absolute;" ></span>

                                                                                    <i class="gladinet-icons md-24 md-dark hand center toolbtn" style="display: inline-block; margin-top: 0px;" >M</i>
                                     <asp:Localize ID="Localize6" meta:resourcekey="str_adduser" runat="server" Visible="False">Add User</asp:Localize>
                                 </button>
                                </a>
                       
         
          <%} %>  
                         </td>
                         
                              <%if (m_ShowWhiteList && !EditingTenant){ %>
                              <td style="display:none;">
          
              <asp:LinkButton ID="LinkButton2" runat="server" Font-Size="Larger" ForeColor="Green" CssClass="btn"
                                OnClientClick="parent.EditWhiteList();return false;" meta:resourcekey="LinkButton2Resource1">
                                <asp:Localize ID="asp_string2" Visible="False" meta:resourcekey="asp_string2" runat="server">White List</asp:Localize>
                                <img src="images/whitelist.png" title="<%=asp_string2.Text %>" />
                            </asp:LinkButton>
                            </td>
          
              <%} %>
                         
                        <td ><input type="hidden" runat="server" id="hidViewType" />
                            <asp:LinkButton ID="AllUsers" runat="server" class="btn btn-default smallbtn"
                                OnClick="AllUsers_Click"><i class="gladinet-icons md-24 md-dark hand center toolbtn" style="display: inline-block; margin-top: 0px;" >&#0181;</i></asp:LinkButton>
                        </td><td >
                            <div class="dropdown" style="padding-right:30px;">
                <button class="btn btn-default dropdown-toggle smallbtn" type="button" data-toggle="dropdown"><i class="gladinet-icons md-24 md-dark hand center toolbtn" style="display: inline-block; margin-top: 0px;" >S</i>&nbsp;<span class="caret sectextcolor"></span></button>
                                <ul class="dropdown-menu" style="padding: 10px;">
                                    <li>
                                        <asp:LinkButton ID="ExportUser" runat="server" Font-Size="12px" ForeColor="#808080"
                                            OnClick="ExportUser_Click">
                                            <asp:Localize ID="Localize2" meta:resourcekey="str_exportuser" runat="server">Export Users</asp:Localize>
                                        </asp:LinkButton>
                                    </li>
                                    <li>
                                        <asp:LinkButton ID="ShowDisabled" runat="server" ForeColor="#808080"
                                            Font-Size="12px" OnClick="ShowDisabled_Click">
                                            <asp:Localize ID="Localize5" meta:resourcekey="str_showdeleted" runat="server">Show Disabled Users</asp:Localize>
                                        </asp:LinkButton>
                                    </li>
                                    <li>
                                        <asp:LinkButton ID="ShowTwoFAUsers" runat="server" ForeColor="#808080"
                                            Font-Size="12px" OnClick="ShowTwoFAUsers_Click">
                                            <asp:Localize meta:resourcekey="str_shwTwoFAEblUsr" runat="server">Show 2FA-Enabled Users</asp:Localize>
                                        </asp:LinkButton>
                                    </li>
                                    <%if (m_ShowImportGroup)
                                    { %>
                                    <li style="display: none;">
                                        <asp:LinkButton ID="LinkButton4" runat="server" Font-Size="12px" ForeColor="#808080"
                                            OnClientClick="EditImportedGroupList();return false;" meta:resourcekey="LinkButton2Resource1">
                                            <asp:Localize meta:resourcekey="str_importadg" ID="str_importadg" runat="server">Import AD Group</asp:Localize>

                                        </asp:LinkButton>
                                    </li>
                                    <%} %>
                                    <li style="display:none;">
                                        <asp:LinkButton ID="RefreshBtn" runat="server" ForeColor="#808080" Font-Size="12px"
                                            OnClick="RefreshBtn_Click">
                                            <asp:Localize ID="Localize3" meta:resourcekey="str_refresh" runat="server">Refresh</asp:Localize>
                                        </asp:LinkButton>
                                    </li>
                                    <% if (SessionIsInstalledApp)
                                        { %>
                                    <li>
                                        <asp:LinkButton ID="LinkButton3" runat="server" ForeColor="#808080" Style="display: none;"
                                            Font-Size="12px" OnClick="LinkButton3_Click">
                                            aa<asp:Localize ID="Localize4" meta:resourcekey="str_scantenant" runat="server">Scan Tenant Storage</asp:Localize>
                                        </asp:LinkButton>

                                        <% if (IsServo) { %>
                                        <asp:LinkButton ID="LinkButton6B" runat="server" ForeColor="#808080"
                                            Font-Size="12px" OnClientClick="CanScan(); return false;"><asp:Localize  meta:resourcekey="str_scnBckStg" runat="server">Scan Backend Storage</asp:Localize></asp:LinkButton>
                                        <% } else { %>
                                        <asp:LinkButton ID="LinkButton6" runat="server" ForeColor="#808080"
                                            Font-Size="12px" OnClientClick="CanScan(); return false;"><asp:Localize  meta:resourcekey="str_scantenant" runat="server">Scan Tenant Storage</asp:Localize></asp:LinkButton>
                                        <% } %>
                                    </li>
                                    <% } %>
                                </ul>
            </div>                             
                         </td>
                         <td>
                            <asp:TextBox ID="Contains" runat="server" Width="228px" CssClass="form-control dark"
                                meta:resourcekey="ContainsResource1"></asp:TextBox>
                            </td><td>
                                <asp:LinkButton ID="LinkButton7" runat="server" OnClick="FileterUsers_Click" ><i class="gladinet-icons md-24 md-dark hand center toolbtn" style="display: inline-block; margin-top: 2px;" >&#0167;</i></asp:LinkButton>
                                          
                            <asp:Button ID="Button1" OnClick="FileterUsers_Click" runat="server" Text="Search" CssClass="btn btn-default nbtn" Visible="False"
                                 meta:resourcekey="Button1Resource2"  />
                         </td>
                         

                     </tr>
                 </table>
                  </td>
                  <td>
                        <asp:Label ID="UserCount" runat="server" Text="0 User" CssClass="badge hollowbadge" style="font-size:12px;"></asp:Label>
                  </td>
                  <td  id="DelSelDiv" style="display: none;">
                      <%if(m_CanDelete){%>
                      <asp:LinkButton ID="LinkButton5" runat="server" ForeColor="#008000" 
                                                            Font-Size="12px" OnClientClick="DelSelUsers();return false;">
                    <asp:Localize meta:resourcekey="str_delusers" runat="server">Delete Selected User(s)</asp:Localize>
                </asp:LinkButton>  
                      <%}%>         
                  </td>
                  <td align="right">
                      <div class="navbar-right sectextcolor" style="width:40px; font-size:32px;  font-weight:100; cursor:pointer;padding-top:5px;" onclick="ReturnLast();">&times;</div>
                  </td>
                  </tr>
            </table>
    </div>
      
    
            <div id="ShortWindowModal" class="modal fade" role="dialog" >
            <div class="modal-dialog " style="width: 850px; max-width:850px; padding:0px!important;">

                <!-- Modal content-->
                <div class="modal-content" style="padding:0px!important;">
                    <div class="modal-header" >
                        <img src="<%=WebAppIcon %>" style="float:left; max-height:32px; max-width:32px;"/>
                        
                        <h4 class="modal-title" style="color: #; " id="ShortTitle"></h4>
                        <button type="button" class="close" data-dismiss="modal">&times;</button>
                    </div>
                    <div class="modal-body" style="height: 600px;padding-top:0px;padding:0px!important;" id="ShortBody">
                         <iframe id='ShortWindow' width="100%"  style="padding:0px;"
        frameborder="0" border="0" height="100%"></iframe>
                    </div>
                </div>

            </div>
        </div>
    <%if (!string.IsNullOrEmpty(ErrorMsg.Text))
      { %>
    <div class="alert alert-warning" id='errmsgdiv'>
        <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a> <b>
            <asp:Label ID="ErrorMsg" runat="server" Style="color: Red;" meta:resourcekey="ErrorMsgResource1"></asp:Label>
        </b>
    </div>
    <%} %>
    <table width="100%" style="padding: 2px;  margin-top: 12px;background-color: transparent;"
        cellspacing="0" cellpadding="0" id="grid-table">
        <tr style=" display: none;">
            <td valign="top" style="height: 32px; padding: 5px; border-top: 0px solid #c0c0c0;
                border-left: 0px solid #c0c0c0; border-right: 0px solid #c0c0c0; border-bottom: 3px solid #c0c0c0;
                vertical-align: top;">
                <table width="100%" align="center" style="height: 32px; background-color: transparent;">
                    <tr>
                        <td colspan="3" valign="bottom">
                            <table>
                                <tr>
                                    <td></td>
                                    <td style="color: #008000; padding-left: 10px;"></td>
                                    <td style="color: #008000; padding-left: 10px;"></td>
                                    <td style="color: #008000; padding-left: 10px;"></td>
                                    <td style="color: #008000; padding-left: 10px;"></td>
                                </tr>
                            </table>
                        </td>
                        <td height="30px" colspan="3" valign="bottom" style="padding-bottom: 4px; padding-right: 20px;"
                            align="right"></td>
                        <td style="border-left: 1px solid #e0e0e0; width: 100px; padding-left: 5px;">
                            <table>
                                <tr>
                                    <td valign="top">
                                        <table width="90%" align="center" border="0" cellspacing="0" cellpadding="0">
                                            <tr>
                                                <td align="left">
                                                    <table style="display: none;">
                                                        <tr>
                                                            <td width="32px">
                                                                <img width="32px" src="images/admin.png" />
                                                            </td>
                                                            <td>
                                                                <a href="#" onclick="OnManageAdmin();return false;" style="font-size: 14px; color: #d08000;">
                                                                    <asp:Localize ID="Localize1" meta:resourcekey="asp_string3" runat="server">Manage Delegate Administrators</asp:Localize>
                                                                </a>
                                                            </td>
                                                        </tr>
                                                    </table>
                                                </td>
                                                <td></td>
                                            </tr>
                                        </table>
                                    </td>
                                    <%if (m_CanAdd)
                                      { %>
                                    <td align="right" style="padding: 5px;" width="42px">
                                        <asp:Localize ID="asp_string5" Visible="False" meta:resourcekey="asp_string5" runat="server">Create or Migrate User</asp:Localize>
                                        <a href="#" onclick="OnAddUserWizard();return false;" style="font-size: 12px;" title="<%=asp_string5.Text %>">
                                            <img width="32px" src="images/adduser.png" /></a>
                                    </td>
                                    <%if (m_ShowWizard && !EditingTenant)
                                      { %>
                                    <td align="right" style="padding: 5px;" width="42px">
                                        <asp:Localize ID="asp_string6" Visible="False" meta:resourcekey="asp_string6" runat="server">Batch Create or Migrate AD User Wizard</asp:Localize>
                                        <a href="#" onclick="OnAddUserWizard();return false;" style="font-size: 12px;" title="<%=asp_string6.Text %>">
                                            <img width="32px" src="/portal/images/wizard.png" /></a>
                                    </td>
                                    <%} %>
                                    <%} %>
                                    <%if (m_CanSetPerm && !m_SimpleMode && !EditingTenant)
                                      { %>
                                    <td align="right" style="padding: 5px; display: none;" width="42px">
                                        <asp:LinkButton ID="LinkButton1" runat="server" Font-Size="Larger" ForeColor="Green"
                                            OnClientClick="parent.SetAcls('/UserManager');return false;" meta:resourcekey="LinkButton1Resource1">
                                            <asp:Localize ID="asp_string1" Visible="False" meta:resourcekey="asp_string1" runat="server">Security</asp:Localize>
                                            <img src="images/security2.png" title="<%=asp_string1.Text %>" />
                                        </asp:LinkButton>
                                    </td>
                                    <%} %>
                                    <td align="right" style="padding: 5px;" width="42px"></td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
        <%if (m_ShowTab)
          { %>
        <asp:Panel ID="LastNamePanel" runat="server">
            <tr>
                <td style="padding-left: 5px; padding-right: 5px; height: 12px; border-left: 1px solid #c0c0c0;
                    border-right: 1px solid #c0c0c0; border-top: 0px solid #c0c0c0; border-bottom: 0px solid #c0c0c0;">
                    <table width="100%">
                        <tr>
                            <td align="center">
                                <asp:Button ID="ButtonA" runat="server" Text="A" Width="100%" OnClick="ButtonA_Click" />
                            </td>
                            <td align="center">
                                <asp:Button ID="ButtonB" runat="server" Text="B" Width="100%" OnClick="ButtonB_Click" />
                            </td>
                            <td align="center">
                                <asp:Button ID="ButtonC" runat="server" Text="C" Width="100%" OnClick="ButtonC_Click" />
                            </td>
                            <td align="center">
                                <asp:Button ID="ButtonD" runat="server" Text="D" Width="100%" OnClick="ButtonD_Click" />
                            </td>
                            <td align="center">
                                <asp:Button ID="ButtonE" runat="server" Text="E" Width="100%" OnClick="ButtonE_Click" />
                            </td>
                            <td align="center">
                                <asp:Button ID="ButtonF" runat="server" Text="F" Width="100%" OnClick="ButtonF_Click" />
                            </td>
                            <td align="center">
                                <asp:Button ID="ButtonG" runat="server" Text="G" Width="100%" OnClick="ButtonG_Click" />
                            </td>
                            <td align="center">
                                <asp:Button ID="ButtonH" runat="server" Text="H" Width="100%" OnClick="ButtonH_Click" />
                            </td>
                            <td align="center">
                                <asp:Button ID="ButtonI" runat="server" Text="I" Width="100%" OnClick="ButtonI_Click" />
                            </td>
                            <td align="center">
                                <asp:Button ID="ButtonJ" runat="server" Text="J" Width="100%" OnClick="ButtonJ_Click" />
                            </td>
                            <td>
                                <asp:Button ID="ButtonK" runat="server" Text="K" Width="100%" OnClick="ButtonK_Click" />
                            </td>
                            <td align="center">
                                <asp:Button ID="ButtonL" runat="server" Text="L" Width="100%" OnClick="ButtonL_Click" />
                            </td>
                            <td align="center">
                                <asp:Button ID="ButtonM" runat="server" Text="M" Width="100%" OnClick="ButtonM_Click" />
                            </td>
                            <td align="center">
                                <asp:Button ID="ButtonN" runat="server" Text="N" Width="100%" OnClick="ButtonN_Click" />
                            </td>
                            <td align="center">
                                <asp:Button ID="ButtonO" runat="server" Text="O" Width="100%" OnClick="ButtonO_Click" />
                            </td>
                            <td align="center">
                                <asp:Button ID="ButtonP" runat="server" Text="P" Width="100%" OnClick="ButtonP_Click" />
                            </td>
                            <td align="center">
                                <asp:Button ID="ButtonQ" runat="server" Text="Q" Width="100%" OnClick="ButtonQ_Click" />
                            </td>
                            <td align="center">
                                <asp:Button ID="ButtonR" runat="server" Text="R" Width="100%" OnClick="ButtonR_Click" />
                            </td>
                            <td align="center">
                                <asp:Button ID="ButtonS" runat="server" Text="S" Width="100%" OnClick="ButtonS_Click" />
                            </td>
                            <td align="center">
                                <asp:Button ID="ButtonT" runat="server" Text="T" Width="100%" OnClick="ButtonT_Click" />
                            </td>
                            <td align="center">
                                <asp:Button ID="ButtonU" runat="server" Text="U" Width="100%" OnClick="ButtonU_Click" />
                            </td>
                            <td align="center">
                                <asp:Button ID="ButtonV" runat="server" Text="V" Width="100%" OnClick="ButtonV_Click" />
                            </td>
                            <td align="center">
                                <asp:Button ID="ButtonW" runat="server" Text="W" Width="100%" OnClick="ButtonW_Click" />
                            </td>
                            <td>
                                <asp:Button ID="ButtonX" runat="server" Text="X" Width="100%" OnClick="ButtonX_Click" />
                            </td>
                            <td align="center">
                                <asp:Button ID="ButtonY" runat="server" Text="Y" Width="100%" OnClick="ButtonY_Click" />
                            </td>
                            <td align="center">
                                <asp:Button ID="ButtonZ" runat="server" Text="Z" Width="100%" OnClick="ButtonZ_Click" />
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
        </asp:Panel>
        <%} %>
        <tr>
            <td valign="top" id="grid-example" style="padding: 5px; border-bottom: 0px solid #c0c0c0; background-color: transparent;
                border-left: 0px solid #c0c0c0; border-right: 0px solid #c0c0c0;">
                <div  id="tcontainercontainer" style="overflow-y: auto; overflow-x:hidden; background-color: transparent; padding:10px;" >
                    <div class="row" id="tcontainer" style="background-color: transparent;" ></div>
                </div>
            </td>
        </tr>
    </table>
    <div style="display: none;">
        <asp:HiddenField ID="HiddenUserId" runat="server" />
        <asp:HiddenField ID="PurgeStorage" runat="server" />
        <asp:HiddenField ID="HiddenSelectedUserId" runat="server" />
        <asp:Button ID="DelUsers" runat="server" Text="Button" OnClick="DelUsers_Click" />
        <asp:Button ID="ScanUser" runat="server" Text="Button" OnClick="ScanUser_Click" />
        <asp:Button ID="ConvertADUser" runat="server" Text="Button" OnClick="ConvertADUser_Click" />
        <asp:Button ID="SuspendUser" runat="server" Text="Button" OnClick="SuspendUser_Click" />
        <asp:Button ID="ResumeUser" runat="server" Text="Button" OnClick="ResumeUser_Click" />
        <asp:Button ID="MigrateUser" runat="server" Text="Button" OnClick="MigrateUser_Click" />
        <asp:Button ID="DeleteGroup" runat="server" Text="Button" OnClick="DelGroup_Click" />
        
    </div>
    <script type="text/javascript">
        var myData = [
            <asp:Repeater ID="UsersRepeater" runat="server" OnItemCommand="UsersRepeater_ItemCommand"
        OnItemDataBound="OnUserItemBound">
        <ItemTemplate>         
        <%#(Container.ItemIndex == 0)? "": "," %>      ['<%#(((RepeaterItem)Container).ItemIndex+1) %>'
        ,'<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "FirstName").ToString().Replace("'","%27").Replace("\n"," "))%>&nbsp;<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "LastName").ToString().Replace("'","%27").Replace("\n"," "))%>'
        , '<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem,"Email").ToString().Replace("'","%27").Replace("\n"," ")) %>', 
        '<%# FormatBytes((long)DataBinder.Eval(Container.DataItem, "QuotaUsed"))%> <%# FormatGBytesOfUsed((long)DataBinder.Eval(Container.DataItem, "Quota"))%>',
         '',
         '<%#DataBinder.Eval(Container.DataItem,"IsAdmin") %>','<%#DataBinder.Eval(Container.DataItem,"Quota") %>',
         '<%#DataBinder.Eval(Container.DataItem,"UserGuid") %>',
         '<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem,"FirstName").ToString().Replace("'","%27").Replace("\n"," ")) %>',
         '<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem,"LastName").ToString().Replace("'","%27").Replace("\n"," ")) %>',
         '<%#DataBinder.Eval(Container.DataItem,"LastVisit").ToString().Replace("'","%27").Replace("\n"," ") %>'
        ,'<%#DataBinder.Eval(Container.DataItem,"UserType").ToString().Replace("'","%27").Replace("\n"," ") %>'
        ,'<%#DataBinder.Eval(Container.DataItem,"ForceOffline") %>'
        ,'<%#DataBinder.Eval(Container.DataItem,"ForceVersioned") %>'
        ,'<%#DataBinder.Eval(Container.DataItem,"EncId") %>'
        ,'<%#DataBinder.Eval(Container.DataItem,"IsActivated") %>'
        ,'<%#DataBinder.Eval(Container.DataItem,"ADDomain").ToString().Replace("'","%27").Replace("\n"," ") %>'
        ,'<%#DataBinder.Eval(Container.DataItem,"QuotaUsed") %>'
        ,'<%#DataBinder.Eval(Container.DataItem,"TwoFAEnabled") %>'
        ] 
        </ItemTemplate>
    </asp:Repeater>      
        ];
    </script>
    <script type="text/javascript">
        function SwitchToNativeUser(em) {
            activewin = new Ext.Window({
                id: 'win_ad_2_natibe',
                title: "<asp:Localize meta:resourcekey="str_ad2n" runat="server">Convert to Native User</asp:Localize>",
                width: 680,
                height: 480,
                plain: true,
                modal: true,
                maximizable: false,
                maximized: false,
                layout: 'fit',
                bodyPadding: 3,
                html: "<iframe id='openwin' src='/Portal/AD2Native.aspx?t=" +  em + "' scrolling='auto' style='width:100%;height:100%;margin:0;padding:0;border:0'></iframe>",
                defaults: {
                    border: false
                }
            });
            activewin.show();
            
        }

        function SwitchToProxiedADUser(uid) {
           
                window.location = "/management/AddUserWizard/ConvertUser.aspx?vdid=<%=SessionDomainId%>&uid=" + uid;
                   }
        function SwitchToADUser(uid) {
            var btn = document.getElementById('MainContent_ConvertADUser');
            var userid = document.getElementById('MainContent_HiddenUserId');

            if (confirm("Do you really want to convert the user to AD user who has the same email?")) {
                userid.value = uid;
                Wait("Please wait");
                btn.click();
            }

        }
        function CreateAddIcon() {
            var container = document.getElementById("tcontainer");
            var tdiv = document.createElement("div");
            tdiv.className =  eleClassName;
            tdiv.style.padding = "10px";
            tdiv.style.paddingRight = "10px";
            
           

            var tbl = document.createElement("table");
            tbl.style.width = "100%";
            tbl.style.height = "300px";
            tbl.className = "viewcard";
            
            tdiv.appendChild(tbl);
            
            tbl.style.cursor = "hand";
            tbl.onclick = function () {
                OnAddUserWizard();
            };

            var tbody = document.createElement("tbody");
            tbl.appendChild(tbody);
              
            
            var theadr = document.createElement("tr");
            tbody.appendChild(theadr);
            //theadr.style.backgroundColor = "#35BAF6";
            theadr.style.backgroundColor = "white";
              

            var ttitled = document.createElement("td");
            theadr.appendChild(ttitled);
            ttitled.style.height = "48px";
            ttitled.style.paddingLeft = "5px";
            ttitled.style.color = "#";
            ttitled.align = "center";
            ttitled.style.fontSize = "16px";
            ttitled.style.borderBottom = "0px solid #d0d0d0";

            ttitled.innerHTML = "&nbsp;";
            var tbodyr = document.createElement("tr");
            tbody.appendChild(tbodyr);
              
            tbodyr.style.backgroundColor = "white";
            var tbodyd = document.createElement("td");
            tbodyr.appendChild(tbodyd);
            tbodyd.style.padding = "3px";

            tbodyd.align = "center";
            tbodyd.vAlign = "middle";
            tbodyd.innerHTML = "<div class='toolbtn' style='width:150px;padding:5px; padding-top:10px;font-size: 16px; cursor:pointer;color:#868686'><span style='font-size: 80px; cursor:pointer;' class='secpaneltextcolor'>+</span><br/><%=CrORMir.Text%></div>";
            tbodyd.style.cursor = "hand";
            container.appendChild(tdiv);
        }

        var menuidindex = 1;
        var menu = null;

        function DeleteGroup(o, index) {
            OnDeletGroup(myData[index][7] ,myData[index][1]);
        }

        function DeletePGroup(o, index) {
            OnDeletGroup(myData[index][7] ,myData[index][1]);
        }

        function OnDeletGroup( id, name) {
            var btn = document.getElementById('MainContent_DeleteGroup');
            var userid = document.getElementById('MainContent_HiddenUserId');

            if (confirm("Do you really want to delete the group:"+name+"?")) {
                userid.value = id;
                Wait("Please wait");
                btn.click();
            }
        }
        function abortClickBubbleUp(event){
            try{
                event.preventDefault();
                event.stopPropagation();
            }catch(ex){}
        }
        function UserMenu(o,index) {
            var rect = o.getBoundingClientRect();
          
            var DelAction = new Ext.Action({
                text: "<span style='color:#565656; font-weight:100!important'>"+"<asp:Localize meta:resourcekey="str_deluser" runat="server">Delete User</asp:Localize>"+"</span>",
                handler: function () {
                    onDelUser(myData[index][2],myData[index][2]);
                },
                scope: this,
                iconCls: 'cm-publish16'
            });

            <%if (!m_CanDelete) {%>
            DelAction = "";        
            <%}%>       
            var SetQuotaAction = new Ext.Action({
                text: "<span style='color:#565656; font-weight:100!important'>"+"<asp:Localize meta:resourcekey="str_setquota" runat="server">Set Quota</asp:Localize>"+"</span>",
                handler: function () {
                    OnSetQuotaShowDialog(myData[index][14], myData[index][6], myData[index][7]);                            
                    

                },
                scope: this,
                iconCls: 'cm-publish16'
            });
            var EditAction = new Ext.Action({
                text: "<span style='color:#565656; font-weight:100!important'>"+"<asp:Localize meta:resourcekey="str_mgr" runat="server">Manage User</asp:Localize>"+"</span>",
                handler: function () {
                    OnEditGroup(myData[index][7],myData[index][2]);    
                },
                scope: this,
                iconCls: 'cm-publish16'
            });

            var SwitchToNativeAction = new Ext.Action({
                text: "<span style='color:#565656; font-weight:100!important'>"+"<asp:Localize meta:resourcekey="str_cnative" runat="server">Convert to native user</asp:Localize>"+"</span>",
                handler: function () {
                    SwitchToNativeUser(myData[index][2]);    
                },
                scope: this,
                iconCls: 'cm-publish16'
            });

            var SwitchToADAction = new Ext.Action({
                text: "<asp:Localize meta:resourcekey="str_cad" runat="server">Convert to AD user</asp:Localize>",
                handler: function () {
                    SwitchToADUser(myData[index][7]);    
                },
                scope: this,
                iconCls: 'cm-publish16'
            });

            var SwitchToProxiedADAction = new Ext.Action({
                text: "<span style='color:#565656; font-weight:100!important'>"+"<asp:Localize meta:resourcekey="str_cporixed" runat="server">Convert to proxied AD user</asp:Localize>"+"</span>",
                    handler: function () {
                    SwitchToProxiedADUser(myData[index][7]);    
                },
                scope: this,
                iconCls: 'cm-publish16'
                });
            var ViewSD = new Ext.Action({
                text: "<span style='color:#565656; font-weight:100!important'>"+"<asp:Localize meta:resourcekey="str_usage" runat="server">Storage Usage Detail</asp:Localize>"+"</span>",
                handler: function () {
                    OnShowUserStorage( myData[index][7]);                            
                },
                scope: this,
                iconCls: 'cm-publish16'
            });
            var DeviceList = new Ext.Action({
                text: "<span style='color:#565656; font-weight:100!important'>"+"<asp:Localize meta:resourcekey="js_string23" runat="server">Device List</asp:Localize>"+"</span>",
                handler: function () {
                    OnDeviceList(myData[index][7]);

                },
                scope: this,
                iconCls: 'cm-publish16'
            });
            var TokenManager = new Ext.Action({
                text: "<span style='color:#565656; font-weight:100!important'>"+"<asp:Localize meta:resourcekey="str_tokenmgr" runat="server">Token Manager</asp:Localize>"+"</span>",
                handler: function () {
                    OnTokenList(myData[index][7]);
                },
                scope: this,
                iconCls: 'cm-publish16'
            });
            var ViewUserStorage = new Ext.Action({
                text: "<span style='color:#565656; font-weight:100!important'>"+"<asp:Localize meta:resourcekey="str_viewstorage" runat="server">View User Storage</asp:Localize>"+"</span>",
                handler: function () {
                    OnViewStorageList(myData[index][7]);
                             
                },
                scope: this,
                iconCls: 'cm-publish16'
            });
            var ForceScan = new Ext.Action({
                text: "<span style='color:#565656; font-weight:100!important'>"+"<asp:Localize meta:resourcekey="str_forcescan" runat="server">Force full scan for storage quota usage</asp:Localize>"+"</span>",
                handler: function() {

                    var btn = document.getElementById('MainContent_ScanUser');
                    var userid = document.getElementById('MainContent_HiddenUserId');

                    gConfirm("<asp:Localize meta:resourcekey="str_confirm1" runat="server">It may take a long time to process for accounts that have significant storage usage , continue?</asp:Localize> ", "", function(btn1) {

                    if (btn1 != 'ok')
                        return;
                        userid.value = myData[index][7];

                        Wait("<asp:Localize meta:resourcekey="str_scaning" runat="server">Scanning...</asp:Localize>");
                        btn.click();
                });

        },
                scope: this,
                iconCls: 'cm-publish16'
        });
        if (menu != null) {
            menu.close();
            menu = null;
        }

        var EnableUser = new Ext.Action({
            text: "<span style='color:#565656; font-weight:100!important'>"+"<asp:Localize meta:resourcekey="str_enable" runat="server">Enable User</asp:Localize>"+"</span>",
            handler: function () {
                OnResume(myData[index][7]);
                             
            },
            scope: this,
            iconCls: 'cm-publish16'
        });
        var DisableUser = new Ext.Action({
            text: "<span style='color:#565656; font-weight:100!important'>"+"<span style='color:#565656; font-weight:100!important'>"+"<asp:Localize meta:resourcekey="str_disable" runat="server">Disable User</asp:Localize>"+"</span>",
            handler: function () {
                OnSuspend(myData[index][7]);
                             
            },
            scope: this,
            iconCls: 'cm-publish16'
        });
       

        if (myData[index][15] != 'True') {
            DisableUser.hide();
        } else {
            EnableUser.hide();
        }

        if (myData[index][5] == 'True') {
           
            menu = new Ext.menu.Menu({
                id: 'grid-ctx',
                items: [ViewSD,ViewUserStorage,ForceScan,'-',DeviceList,TokenManager]
            });
        } else {
            var storageMenu = {
                text: "<span style='color:#565656; font-weight:100!important' onclick='abortClickBubbleUp(event)'>"+"<asp:Localize meta:resourcekey="str_homes" runat="server">Home Storage</asp:Localize>"+"</span>",
                menu: [ViewSD,ViewUserStorage,ForceScan,SetQuotaAction]
            };

            var mgrMenu = {
                text: "<span style='color:#565656; font-weight:100!important' onclick='abortClickBubbleUp(event)'>"+"<asp:Localize meta:resourcekey="str_mgr" runat="server">Manage User</asp:Localize>"+"</span>",
                menu: [EditAction,EnableUser, DisableUser,SwitchToADAction,SwitchToProxiedADAction,SwitchToNativeAction, DelAction]
            };
            <%if (m_CanEdit) {%>
            menu = new Ext.menu.Menu({
                id: 'grid-ctx',
                items: [mgrMenu,'-',storageMenu,'-',DeviceList,TokenManager ]
            });           
            <% } else { %>  
            menu = new Ext.menu.Menu({
                id: 'grid-ctx',
                items: [storageMenu,'-',DeviceList,TokenManager ]
            });           
            <% } %>
        }
        <% if (!m_CanEdit){ %>
        DelAction.hide();
        SetQuotaAction.hide();
        DisableUser.hide();
            EnableUser.hide();
        <% } %>
        <% if (!m_CanConvert)
           { %>
        SwitchToADAction.hide();
            SwitchToProxiedADAction.hide();
        SwitchToNativeAction.hide();
        <% } %>

        if (myData[index][11] == "569E5E4B-A5A2-4305-BADC-2815ED469D2A" || myData[index][11] == "18C17928-BD40-4ABC-ADD3-D90BD2D4AF37" ) {
            SwitchToADAction.hide();
            SwitchToProxiedADAction.hide();
        } else if (myData[index][11] == "9379F3BF-16C4-4B24-8FF7-5164142F0A47") {
            SwitchToNativeAction.hide();
        } else if (myData[index][11] == "19DEA6B4-2167-4E35-8A21-703ED3CC196E") {
            SwitchToADAction.hide();
            SwitchToProxiedADAction.hide();
        } else {
            SwitchToADAction.hide();
            SwitchToNativeAction.hide();
            SwitchToProxiedADAction.hide();
        }
        
        menu.showAt({ x: rect.left+4, y: rect.top+18 });
        }

        function getUserType(v) {
            
            if( v == "569E5E4B-A5A2-4305-BADC-2815ED469D2A")
                return "<asp:Localize meta:resourcekey="str_ADUSer" runat="server">AD User</asp:Localize>";
            if( v == "18C17928-BD40-4ABC-ADD3-D90BD2D4AF37")
                return "<asp:Localize meta:resourcekey="str_ADUser1" runat="server">AD User</asp:Localize>";
            if( v == "19DEA6B4-2167-4E35-8A21-703ED3CC196E")
                return "<asp:Localize meta:resourcekey="str_proxiedad" runat="server">Proxied AD User</asp:Localize>";
            if( v == "EC37CFCB-3D31-46B8-BB17-FF1D54E7CFAB")
                return "<asp:Localize meta:resourcekey="str_proxiedad" runat="server">Proxied AD User</asp:Localize>";

            if( v == "9379F3BF-16C4-4B24-8FF7-5164142F0A47")
                return "<asp:Localize meta:resourcekey="str_nativeuser" runat="server">Native User</asp:Localize>";
            return v;
        }

        function CreateIconView() {
            var container = document.getElementById("tcontainer");
            var count = myData.length;
            <% if (m_CanAdd){ %>
            CreateAddIcon();
            <% }%>

            
            for (var i = 0; i < count; ++i) {
                try {
                    var tdiv = document.createElement("div");
                    tdiv.className = eleClassName;
                    tdiv.style.padding = "10px";
                    tdiv.style.paddingRight = "10px";


                    var divp1 = document.createElement("div");
                    divp1.className = "viewcard ";
                    divp1.style.height = "100%";
                    divp1.style.width = "100%";
                    tdiv.appendChild(divp1);
                    divp1.style.borderRadius = "2px";
                    divp1.style.boxShadow = "0px!important;";
                    divp1.style.backgroundImage = "url(/management/images/usermgrbg.jpg)";
                    var divp2 = document.createElement("div");

                    divp2.style.height = "300px";
                    divp2.style.width = "100%";
                    divp1.appendChild(divp2);

                    divp2.style.backgroundColor = "rgba(255,255,255,0.7)";
                    divp1 = divp2;
                    //divp1.style.backgroundColor = "#43a047";
                    var divph = document.createElement("div");

                    var emailStr = myData[i][2];
                    
                    divph.className = "panel-body";
                    divph.style.boxShadow = "0px!important;";

                    //if (myData[i][11] == "569E5E4B-A5A2-4305-BADC-2815ED469D2A")
                    {

                        //divph.style.backgroundImage = "url('/storage/avarta.dn?u="+myData[i][7]+ "&w=64&h=64')";
                        //divph.style.backgroundRepeat = "no-repeat";
                    }
                    divph.align = "right";

                    if (emailStr == "[GROUP]") {
                        <% if (m_CanDelete){ %>
                        divph.innerHTML =
                            "<span class='fa fa-remove secpaneltextcolor' style='cursor: pointer;' onclick='DeleteGroup(this,\"" + i + "\")' />&nbsp;";
                        <% }%>
                    } else if (emailStr == "[PROXIED GROUP]") {
                        <% if (m_CanDelete){ %>
                        divph.innerHTML =
                            "<span class='fa fa-remove secpaneltextcolor' style='cursor: pointer;' onclick='DeletePGroup(this,\"" + i + "\")' />&nbsp;";
                        <% }%>
                    } else {
                        var divimg = document.createElement("img");
                        divimg.src = "/storage/avarta.dn?u=" + myData[i][7] + "&w=64&h=64";
                        divimg.style.position = "absolute";
                        divimg.style.padding = "5px";
                        divimg.style.borderRadius = "50%";

                        divp1.appendChild(divimg);
                        divph.innerHTML =
                            "<span class='fa fa-bars secpaneltextcolor' style='cursor: pointer;' onclick='UserMenu(this,\"" + i + "\")' />&nbsp;";
                    }

                    divp1.appendChild(divph);
                    var divpb = document.createElement("div");
                    divp1.appendChild(divpb);


                    var tbl = document.createElement("table");

                    tbl.style.width = "100%";
                    //tbl.style.height = "300px";
                    //tbl.className = "panel";
                    divpb.appendChild(tbl);
                    tbl.border = "0";


                    var tbody = document.createElement("tbody");
                    tbl.appendChild(tbody);
                    tbody.style.border = "0px solid #e0e0e0";


                    var theadr = document.createElement("tr");


                    var ttitled = document.createElement("td");
                    theadr.appendChild(ttitled);
                    ttitled.style.height = "48px";
                    ttitled.style.paddingLeft = "5px";
                    ttitled.style.color = "#808080";
                    //ttitled.style.color = "#f0f0f0";
                    //ttitled.className = "x-tab-default-active x-window-header-text-container-default x-header-text";
                    ttitled.style.fontSize = "16px";
                    ttitled.style.borderBottom = "1px solid #e0e0e0";
                    ttitled.align = "right";

                    ttitled.innerHTML = "<span class='fa fa-bars' onclick='UserMenu(this,\"" +
                        i +
                        "\")' />&nbsp;";

                    var tbodyr = document.createElement("tr");
                    tbody.appendChild(tbodyr);

                    // tbodyr.style.backgroundColor = "white";
                    var tbodyd = document.createElement("td");
                    tbodyr.appendChild(tbodyd);
                    tbodyd.style.padding = "0px";
                    tbodyr.id = "" + i;

                    if (emailStr != "[GROUP]" && emailStr != "[PROXIED GROUP]") {

                        tbodyr.onclick = function() {
                            <% if (m_CanEdit) { %>
                            var index = this.id;
                            OnEditGroup(myData[index][7], myData[index][2]);
                            <% } %>

                        }
                        tbodyr
                            .title =
                            "<asp:Localize meta:resourcekey="str_clkToMng" runat="server">Click to Manage</asp:Localize>";
                    }

                    tbodyr.style.cursor = "point";

                    var tblc = document.createElement("table");
                    tblc.style.width = "100%";
                    var tcbody = document.createElement("tbody");
                    tblc.appendChild(tcbody);
                    tbodyd.appendChild(tblc);
                    tblc.border = "0";


                    var titletr = document.createElement("tr");
                    tcbody.appendChild(titletr);
                    var titletd = document.createElement("td");
                    titletr.appendChild(titletd);
                    titletd.style.height = "140px";
                    titletd.style.borderBottom = "1px solid #f0f0f0";
                    //titletd.style.backgroundColor = "white";
                    titletd.style.whiteSpace == 'nowrap';
                    titletd.align = "center";
                    titletd.vAlign = "middle";
                    //titletd.style.overflowX = "scroll";
                    titletd.style.cursor = "point";

                    var userNameStr = unescape(myData[i][1]).replace('&nbsp;', ' ');


                    var emailStr = decodeURIComponent(myData[i][2]);

                    //titletd.style.backgroundColor = "white";

                    titletd
                        .innerHTML =
                        "<span style='font-size: 22px; color:#8e8e8e;cursor: pointer;' class='sectextcolor'>" +
                        userNameStr +
                        "</span><br/>" +
                        "<span style='font-size: 10px;color:#;cursor: pointer;'>" +
                        emailStr +
                        "</span>";
                    titletd.colSpan = "2";
                    if (myData[i][15] != 'True' && emailStr != "[GROUP]" && emailStr != "[PROXIED GROUP]") {
                        titletd
                            .innerHTML +=
                            "<br/><span style='font-size: 14px; color:#808080;cursor: pointer;  padding-right:5px;'>" +
                            "</span>" +
                            "<span style='font-size: 12px;cursor: pointer;' class='badge btn-danger'><asp:Localize runat="server" meta:resourcekey="str_Dis">Disabled</asp:Localize></span>";
                    }

                    var stastictr = document.createElement("tr");

                    tcbody.appendChild(stastictr);
                    var stastictd = document.createElement("td");
                    stastictr.appendChild(stastictd);
                    stastictd.style.height = "130px";


                    stastictd.style.whiteSpace = 'nowrap';
                    stastictd.style.paddingTop = "10px";
                    stastictd.align = "center";
                    stastictd.vAlign = "top";

                    if (emailStr != "[GROUP]" && emailStr != "[PROXIED GROUP]") {
                        stastictd.innerHTML = "<span style='font-size: 14px; color:#808080;  padding-right:5px;'>" +
                            "</span>" +
                            "<span style='font-size: 12px;color:#8e8e8e;' class='' title='Last Login Time'>" +
                            myData[i][10] +
                            "</span><br style='line-space:3px;'/>" +
                            "<br/><span style='font-size: 14px; color:#8e8e8e;  padding-right:5px;'>" +
                            "</span>" +
                            "<span style='font-size: 12px; background-color:white!important; color:#565656!important; font-weight:100; ' class='badge btn-success' title='" +
                            myData[i][16] +
                            "'>" +
                            getUserType(myData[i][11]) +
                            "</span><br/>" +
                            "<span style='font-size: 14px; color:#8e8e8e;  padding-right:5px;'>" +
                            "</span>" +
                            "<span style='font-size: 12px; background-color:white!important; color:#565656!important; font-weight:100; ' class='badge '>" +
                            myData[i][3] +
                            "</span><br/>";
                    } else {
                        stastictd.innerHTML = "<span style='font-size: 14px; color:#808080;  padding-right:5px;'>" +
                            "</span>" +
                            "<br style='line-space:3px;'/>" +
                            "<br/><span style='font-size: 14px; color:#808080;  padding-right:5px;'>" +
                            "</span>" +
                            "<span style='font-size: 12px; background-color:white!important; color:#565656!important; font-weight:100; ' class='badge btn-success' title='" +
                            myData[i][16] +
                            "'>" +
                            getUserType(myData[i][11]) +
                            "</span><br/>" +
                            "<span style='font-size: 14px; color:#808080;  padding-right:5px;'>" +
                            "</span><br/>";
                    }


                    stastictr = document.createElement("tr");
                    tcbody.appendChild(stastictr);
                    stastictd = document.createElement("td");
                    stastictr.appendChild(stastictd);


                    stastictd.style.height = "10px";
                    stastictd.style.width = "50%";
                    stastictd.style.borderRight = "0px solid #f0f0f0";
                    stastictd.style.whiteSpace == 'nowrap';
                    stastictd.id = "strorage_" + myData[i][7];
                    stastictd.align = 'center';
                    stastictd.style.paddingBottom = "10px";


                    container.appendChild(tdiv);


                    if (myData[i][6] != 0 && emailStr != "[GROUP]" && emailStr != "[PROXIED GROUP]") {

                        var Storagebar = Ext.create('Ext.ProgressBar',
                        {
                            height: 5,
                            width: '95%',
                            text: '',
                            color: "#4D0099",
                            id: "storagep_"+i+"_" + myData[i][10],
                            cls: 'roundbar',
                            renderTo: "strorage_" + myData[i][7]
                        });
                        var pct = myData[i][17] / (myData[i][6] * 1024 * 1024 * 1024);
                        Storagebar.updateProgress(pct, "");
                        if (Storagebar.getEl()) {
                            if (pct > 0.9)
                                Storagebar.getEl().child(".x-progress-bar", true).style.backgroundColor = "red";
                            else if (pct > 0.5)
                                Storagebar.getEl().child(".x-progress-bar", true).style.backgroundColor = "#f49e69";
                            else
                                Storagebar.getEl().child(".x-progress-bar", true).style.backgroundColor = "#35BAF6";

                        }
                    }
                } catch (ee) {
                    
                }

            }
          
        }
        Ext.require([
            'Ext.grid.*',
            'Ext.data.*',
            'Ext.util.*',
            'Ext.state.*'
        ]);

        function AdjustGrodObj()
        {
            try{
                if(document.documentElement.clientWidth > 1900)
                    eleClassName = "gridobject col-2";
                else if(document.documentElement.clientWidth > 1300)
                    eleClassName = "gridobject col-3";
                else if(document.documentElement.clientWidth > 800)
                    eleClassName = "gridobject col-4";
                else
                    eleClassName = "gridobject col-4";
            }catch(e){

            }

            try{
                var elements = document.getElementsByClassName("gridobject");
                if(elements && elements.length != 0){
                    for(var i=0; i< elements.length; ++i){
                        elements[i].className = eleClassName;
                    }
                }
            }catch(e){

            }
            try{
                var container = document.getElementById("tcontainercontainer");
                container.style.height = (documentElement.clientHeight-130) + "px";
            }catch(ee){

            }
        }
        var grid = null;
        Ext.onReady(function () {

            AdjustGrodObj();
            Ext.QuickTips.init();
            //document.getElementById("MainContentDiv").style.backgroundColor = "#f8f8f8";
            var store = Ext.create('Ext.data.ArrayStore', {
                fields: [
                    { name: 'index' },
                    { name: 'fullname' },
                    { name: 'email' },
                    { name: 'quota' },
                    { name: 'action' },
                    { name: 'isadmin' },
                    {name: 'allocated'},
                    {name: 'userguid'},
                    {name: 'firstname'},
                    {name: 'lastname'},
                    {name: 'lastvisit', sortType: 'asDate'},
                    {name: 'usertype'},
                    {name: 'offline'},
                    {name: 'versioned'},
                    {name: 'encid'},
                    {name: 'isactive'},
                    {name: 'addomain'},
                    { name: 'used', sortType: 'asInt' },
                    { name: 'twofaenabled' }
                ],
                data: myData
            });

            var d = document.getElementById("grid-example");
            var h = 400;
      
            try {
                h = d.offsetHeight-9;  // in IE8, this is very narrow like = 1
                h1 = document.body.offsetHeight;
                if (h1 > 300) {
                    h1 = h1 - 12; // paddings , margins, whatever
                }
                if (h<50) {
                    // this shall only happen for IE8
                    gridY = Ext.get("grid-example").getY();
                    h = h1 - gridY;
                    if (h<218) {
                        h=218;
                    }
                }
            } catch (err) {
            }
          
            d.style.height = h + "px";
            var container = document.getElementById("tcontainercontainer");
            container.style.height = h + "px";
            isMobileBrowserOrNarrow();

            grid = Ext.create('Ext.grid.Panel', {
                frame: false,
                border: 1,
                width: "100%",
                store: store,
                stripeRows: true,
                columnLines: false,               
                height:h,
                multiSelect: true,
                minHeight : 218,
                columns: [
                {
                    text: '',
                    width: 50,
                    flex:0, 
                    sortable: false,
                    hideable: true,
                    hidden: true,
                    dataIndex: 'index',
                    getClass: function (v, meta, rec) {
                        return 'x-col-hdide';
                    }
                },
                {
                    text: "<span style='color:#565656; font-weight:100'><asp:Localize meta:resourcekey="js_string16" runat="server">Full Name</asp:Localize></span>",
                    flex:8,
                    sortable: true,
                    dataIndex: 'fullname',
                    renderer: function (value, metaData, record, rowIndex) {
                        return "<span style='color:#808080; font-weight:100'>" + unescape(value) + "<br/>"+decodeURIComponent(record.data.email)+"</span>";
                    }

                },
                {
                    text: "<span style='color:#565656; font-weight:100'><asp:Localize runat="server" meta:resourcekey="str_Ema">Email</asp:Localize></span>",
                    flex: 6,
                    sortable: true,
                    hidden: true,
                    dataIndex: 'email',
                    renderer: function (value, metaData, record, rowIndex) {

                        return unescape(value) ;
                    }

                },
                {
                    text: "<span style='color:#565656; font-weight:100'><asp:Localize meta:resourcekey="str_type" runat="server">Type</asp:Localize><span>",
                    width:140,
                    sortable: true,
                    dataIndex: 'usertype',
                    renderer: function (value, metaData, record, rowIndex) {
                        var v = unescape(value) ;
                        if( v == "569E5E4B-A5A2-4305-BADC-2815ED469D2A")
                            return "<span style='color:#808080; font-weight:100'>"+"<asp:Localize meta:resourcekey="str_ADUSer" runat="server">AD User</asp:Localize>"+"</span>";
                        if( v == "18C17928-BD40-4ABC-ADD3-D90BD2D4AF37")
                            return "<span style='color:#808080; font-weight:100'>"+"<asp:Localize meta:resourcekey="str_ADUser1" runat="server">AD User</asp:Localize>"+"</span>";
                        if( v == "19DEA6B4-2167-4E35-8A21-703ED3CC196E")
                            return "<span style='color:#808080; font-weight:100'>"+"<asp:Localize meta:resourcekey="str_proxiedad" runat="server">Proxied AD User</asp:Localize>"+"</span>";
                        if( v == "EC37CFCB-3D31-46B8-BB17-FF1D54E7CFAB")
                            return "<span style='color:#808080; font-weight:100'>"+"<asp:Localize meta:resourcekey="str_proxiedad" runat="server">Proxied AD User</asp:Localize>"+"</span>";

                        if( v == "9379F3BF-16C4-4B24-8FF7-5164142F0A47")
                            return "<span style='color:#808080; font-weight:100'>"+"<asp:Localize meta:resourcekey="str_nativeuser" runat="server">Native User</asp:Localize>"+"</span>";

                            return "<span style='color:#808080; font-weight:100'>"+unescape(value) +"</span>";
                    }

                },
                {
                    text: "<span style='color:#565656; font-weight:100'><asp:Localize runat="server" meta:resourcekey="str_AdInf">AD Info</asp:Localize></span>",
                    flex: 1,
                    sortable: true,
                    hidden: true,
                    dataIndex: 'addomain',
                    renderer: function (value, metaData, record, rowIndex) {

                        return "<span style='color:#808080; font-weight:100'>"+unescape(value) +"</span>";
                    }

                },
                {
        text: "<span style='color:#565656; font-weight:100'><asp:Localize meta:resourcekey="js_string18" runat="server">Storage Usage</asp:Localize></span>",
                    width: 175,
                    flex:0,
                    sortable: true,
                    dataIndex: 'used',
                    renderer: function (value, metaData, record, rowIndex) {
                        if (record.data.email == "[GROUP]"|| record.data.email == "[PROXIED GROUP]")
                            return "";
                        return "<span style='color:#808080; font-weight:100'>"+unescape(record.data.quota)+"</span>" ;
                    }
                },{
                    text: "<span style='color:#565656; font-weight:100'><asp:Localize meta:resourcekey="str_forcedversion" runat="server">Force Versioned</asp:Localize></span>",
                    tooltip: "<asp:Localize meta:resourcekey="str_forcedver1" runat="server">Force Versioned</asp:Localize>",
                    width: 175,
                    flex:1,
                    sortable: true,
                    hidden: true,
                    dataIndex: 'versioned'
                },{
        text: "<span style='color:#565656; font-weight:100'><asp:Localize meta:resourcekey="str_fulldrivesync" runat="server">Full Drive Sync</asp:Localize></span>",
                    tooltip: "<asp:Localize meta:resourcekey="str_fulldrivesync" runat="server">Full Drive Sync</asp:Localize>",
                    width: 175,
                    flex:1,
                    sortable: true,
                    hidden: true,
                    dataIndex: 'offline'
                },{
                    text: "<span style='color:#565656; font-weight:100'><asp:Localize meta:resourcekey="js_string19" runat="server">Last Login</asp:Localize></span>",
                    width: 175,
                    sortable: true,
                    flex:0,
                    dataIndex: 'lastvisit',
                    renderer: function (value, metaData, record, rowIndex) {
                        if (record.data.email == "[GROUP]"|| record.data.email == "[PROXIED GROUP]")
                            return "";
                        return "<span style='color:#808080; font-weight:100'>"+value+"</span>";
                    }
                    }, {
                    text: "<span style='color:#565656; font-weight:100'><asp:Localize meta:resourcekey="str_2faebl" runat="server">2FA-Enabled</asp:Localize></span>",
                    tooltip: "<asp:Localize meta:resourcekey="str_2faebl" runat="server">2FA-Enabled</asp:Localize>",
                    width: 75,
                    flex:1,
                    sortable: true,
                    dataIndex: 'twofaenabled',
                    tdCls: "centerCell",
                    renderer: function (value, metaData, record, rowIndex) {
                        if (record.data.email == "[GROUP]"|| record.data.email == "[PROXIED GROUP]")
                            return ""

                        if( value == 'True' ){
                            return "<asp:Localize meta:resourcekey="str_yes" runat="server">Yes</asp:Localize>";                       
                        }else{
                            return "<asp:Localize meta:resourcekey="str_no" runat="server">No</asp:Localize>";                         
                        }
                              
                    }
           } , {
        text: "<span style='color:#565656; font-weight:100'><asp:Localize meta:resourcekey="str_active" runat="server">Active</asp:Localize></span>",
                    tooltip: "<asp:Localize meta:resourcekey="str_active" runat="server">Active</asp:Localize>",
                    width: 75,
                    flex:1,
                    sortable: true,
                    dataIndex: 'isactive',
                    tdCls: "centerCell",
                    renderer: function (value, metaData, record, rowIndex) {
                        if (record.data.email == "[GROUP]"|| record.data.email == "[PROXIED GROUP]")
                            return ""
                          
                        if (record.data.isadmin != 'True')
                        { 
                            <% if (m_CanEdit)
                               { %>
                            
                            if( value == 'True' ){
                                return "<input type='checkbox' checked onclick='OnSuspend(\"" +record.data.userguid +  "\")'/>";                       
                            }else{
                                return "<input type='checkbox' onclick='OnResume(\"" +record.data.userguid +  "\")'/>";                       
                            }
                            <% }
                               else
                               { %>
                            if( value == 'True' ){
                                return "<input disabled type='checkbox' checked onclick='OnSuspend(\"" +record.data.userguid +  "\")'/>";                       
                            }else{
                                return "<input disabled type='checkbox' onclick='OnResume(\"" +record.data.userguid +  "\")'/>";                       
                            }

                            <% } %>
                        }
                              
                          
                    }
           } , {

                    sortable: false,
                    width:200,
                    renderer: function (value, metaData, record, rowIndex) {
                                
                        var rec = grid.getStore().getAt(rowIndex);
                        var d = rec.data;
                        var ndeNme = d.nodename;
                         
                        var delTTip = "data-toggle=\"tooltip\" data-placement=\"bottom\" data-original-title=\"<asp:Localize meta:resourcekey="js_string20" runat="server">Delete User</asp:Localize>\"";
                        var setQtTTip = "data-toggle=\"tooltip\" data-placement=\"bottom\" data-original-title=\"<asp:Localize meta:resourcekey="js_string21" runat="server">Set Quota</asp:Localize>\"";
                        var stgUsageTTip = "data-toggle=\"tooltip\" data-placement=\"bottom\" data-original-title=\"<asp:Localize meta:resourcekey="str_storagedetail" runat="server">Storage Usage Detail</asp:Localize>\"";
                        var editTTip = "data-toggle=\"tooltip\" data-placement=\"bottom\" data-original-title=\"<asp:Localize meta:resourcekey="js_string22" runat="server">Edit</asp:Localize>\"";
                        var dvcLstTTip = "data-toggle=\"tooltip\" data-placement=\"bottom\" data-original-title=\"<asp:Localize meta:resourcekey="js_string23" runat="server">Device List</asp:Localize>\"";
                        var tokenTTip = "data-toggle=\"tooltip\" data-placement=\"bottom\" data-original-title=\"<asp:Localize meta:resourcekey="str_tokenmgr" runat="server">Token Manager</asp:Localize>\"";
                        var viewStgTTip = "data-toggle=\"tooltip\" data-placement=\"bottom\" data-original-title=\"<asp:Localize meta:resourcekey="str_viewstorage" runat="server">View User Storage</asp:Localize>\"";
                        <%
                        //TODO: ADD MIGRATE AD USER STRING TO RESOURCES
                        %>
                        var migADUsrTTip = "data-toggle=\"tooltip\" data-placement=\"bottom\" data-original-title=\"Migrate AD User\"";
                        var frcScnTTip = "data-toggle=\"tooltip\" data-placement=\"bottom\" data-original-title=\"<asp:Localize meta:resourcekey="str_forcescan" runat="server">Force full scan for storage quota usage</asp:Localize>\"";
                        
                        //==================================================================
                        var delBtn = "";
                        if (rec.data.email == "[GROUP]"|| rec.data.email == "[PROXIED GROUP]")
                            delBtn = "<div class=\"actioncol\"><i class=\"gladinet-icons md-24 md-dark hand\" onclick=\"OnDeletGroup(&quot;"+d.userguid+"&quot;,&quot;"+d.fullname+"&quot;)\" "+delTTip+">n</i></div>";  
                        else
                            delBtn = "<div class=\"actioncol\"><i class=\"gladinet-icons md-24 md-dark hand\" onclick=\"onDelUser(&quot;"+d.email+"&quot;,&quot;"+d.email+"&quot;)\" "+delTTip+">n</i></div>";

                        <%if(!m_CanDelete){%> 
                        delBtn = "";
                        <%}%> 
                        if (d.isadmin == 'True') delBtn = ""; 
                        //==================================================================
                        var setQtBtn = "<div style='display:none;' class=\"actioncol\"><i class=\"gladinet-icons md-24 md-dark hand\" onclick=\"OnSetQuotaShowDialog('"+d.encid+"','"+d.allocated+"','"+d.userguid+"')\" "+setQtTTip+">Ă</i></div>";
                        <%if(!m_CanEdit){ %>
                        setQtBtn = "";
                        <%} %>

                        if (d.email == "[GROUP]"|| rec.data.email == "[PROXIED GROUP]")
                            setQtBtn = ""; 
                        <%if( !SessionHasStorage){%>
                            setQtBtn = "";
                        <%} %>
                        if (d.isadmin == 'True') setQtBtn = "";
                        //==================================================================                         
                        var stgUsageBtn = "<div class=\"actioncol\"><i class=\"gladinet-icons md-24 md-dark hand\" onclick=\"OnShowUserStorage('"+d.userguid+"')\" "+stgUsageTTip+">ă</i></div>";
                        if (rec.data.email == "[GROUP]"|| rec.data.email == "[PROXIED GROUP]") stgUsage = "";
                        <%if(!SessionIsInstalledApp){ %>
                        setQtBtn = "";
                        <%} %>
                        //==================================================================
                        var editBtn = "<div class=\"actioncol\"><i class=\"gladinet-icons md-24 md-dark hand\" onclick=\"OnEditGroup('"+d.userguid+"','"+d.email+"',&quot;"+d.lastname+"&quot;,'"+d.email+"')\" "+editTTip+">/</i></div>";
                        <% if (!m_CanEdit) { %>
                        editBtn = "";
                        <%} %>
                        //if (d.isadmin == 'True') editBtn = "";
                        if (rec.data.email == "[GROUP]"|| rec.data.email == "[PROXIED GROUP]") editBtn = "";
                        //==================================================================
                        var dvcLstBtn = "<div style='display:none;' class=\"actioncol\"><i class=\"gladinet-icons md-24 md-dark hand\" onclick=\"OnDeviceList('"+d.userguid+"')\" "+dvcLstTTip+">Ą</i></div>";
                        if (rec.data.email == "[GROUP]" || rec.data.email == "[PROXIED GROUP]") dvcLstBtn = "";
                        //==================================================================
                        var tokenBtn = "<div style='display:none;' class=\"actioncol\"><i class=\"gladinet-icons md-24 md-dark hand\" onclick=\"OnTokenList('"+d.userguid+"')\" "+tokenTTip+">ą</i></div>";
                        if (rec.data.email == "[GROUP]"|| rec.data.email == "[PROXIED GROUP]") tokenBtn = "";
                        //==================================================================
                        var viewStgBtn = "<div class=\"actioncol\"><i class=\"gladinet-icons md-24 md-dark hand\" onclick=\"OnViewStorageList('"+d.userguid+"')\" "+viewStgTTip+">0</i></div>";
                        <%if(!SessionIsAdmin && !SessionIsClusterAdmin){ %>
                        viewStgBtn = "";
                        <%} %>
                        if (rec.data.email == "[GROUP]"|| rec.data.email == "[PROXIED GROUP]") viewStgBtn = "";
                        //==================================================================
                        var migADUsrBtn = "<div class=\"actioncol\"><i class=\"gladinet-icons md-24 md-dark hand\" onclick=\"onMigrateADUser('"+d.email+"')\" "+migADUsrTTip+">0</i></div>";
                       <%if(!m_MultiAdDomain ){ %>
                        migADUsrBtn = "";
                       <%} %>
                       if (rec.data.email == "[GROUP]"|| rec.data.email == "[PROXIED GROUP]") migADUsrBtn = "";
                        //==================================================================
                       var frcScnBtn = "<div class=\"actioncol\"><i class=\"gladinet-icons md-24 md-dark hand\" onclick=\"forceScan('"+d.userguid+"')\" "+frcScnTTip+">Ç</i></div>";
                        <%if(!SessionIsInstalledApp){ %>
                        frcScnBtn = "";
                        <%} %>
                        if (rec.data.email == "[GROUP]" || rec.data.email == "[PROXIED GROUP]") frcScnBtn = "";
                        //==================================================================
                        return "<div class=\"actiontbl\">"+delBtn+setQtBtn+stgUsageBtn+editBtn+dvcLstBtn+tokenBtn+viewStgBtn+migADUsrBtn+frcScnBtn+"</div>";
                    }
        }
        ],
        renderTo: 'grid-example',
            features: [{
            ftype: 'rowbody',
               
            setupRowData: function(record, rowIndex, rowValues) {
                var headerCt = this.view.headerCt,
                    colspan = headerCt.getColumnCount();
                // Usually you would style the my-body-class in CSS file
                if (g_isMobileBrowserOrNarrow) {
                    var myRowBodyTpl =  new Ext.XTemplate( '<p>{fullname:this.formatName} &lt;{email}&gt; - {usertype:this.formatType}</p>',
                        '<p>{quota}, {lastvisit}</p>',
                        {
                            formatSize: function(v){
                  
                                return Ext.util.Format.fileSize(v);
                            },
                            formatName: function(v) {
                                return decodeURIComponent(v);
                            },
                            formatType: function (value) {
                                var v = unescape(value) ;
                                if( v == "569E5E4B-A5A2-4305-BADC-2815ED469D2A")
                                    return "AD User";
                                if( v == "18C17928-BD40-4ABC-ADD3-D90BD2D4AF37")
                                    return "AD User";
                                if( v == "19DEA6B4-2167-4E35-8A21-703ED3CC196E")
                                    return "Proxied AD User";
                                if( v == "EC37CFCB-3D31-46B8-BB17-FF1D54E7CFAB")
                                    return "Proxied AD User";

                                if( v == "9379F3BF-16C4-4B24-8FF7-5164142F0A47")
                                    return "Native User";

                                return v ;
                            }
                        });

                    rowValues.rowBody = myRowBodyTpl.applyTemplate(record.getData()); 
                    rowValues.rowBodyCls = 'x-grid-rowbody-tr';
                } else {
                    rowValues.rowBody = '';
                    rowValues.rowBodyCls = 'x-grid-row-body-hidden';
                }
					
            }
        },
        {
            ftype: 'rowwrap'
        }]
        });

        grid.hide();

        grid.on('selectionchange', function (grid, selected, options) {
            var e = document.getElementById("DelSelDiv");
            if (selected.length == 0) {
                e.style.display = 'none';
                gSelUser = "";
            } else {
                e.style.display = '';
                gSelUser = "";
                for (var i = 0; i < selected.length; ++i) {
                    if (selected[i].data.isadmin != 'True') {
                        gSelUser += selected[i].data.userguid;
                        gSelUser += ";";
                    } else {
                        
                    }
                }
            }

        }, this);
        CreateIconView();
        
        try {
            var defaultListView = "<%=m_LstViewStg.ToString().ToLower() %>" == "true";
            var view = localStorage.getItem("usermgrstate");
            if (PageGetUIState("usermgr") == "1" || defaultListView || view == "1") {
                OnListView();
            }

        } catch (e) {
            alert(e);
        }

        
        try {
            parent.ClearRelativePageTitle();
        } catch (e) {
            
        }
        //Ext.EventManager.onWindowResize(grid.doLayout, grid);
        Ext.EventManager.onWindowResize(function () {
            
            grid.setWidth(document.documentElement.clientWidth-15  );
            grid.doComponentLayout();
        });
        });
        

        function OnResize(){
            AdjustGrodObj();
        }
        function forceScan(userguid){
            var userid = document.getElementById('MainContent_HiddenUserId');
            userid.value = userguid;
            gConfirm("<asp:Localize meta:resourcekey="str_confirm1" runat="server">It may take a long time to process for accounts that have significant storage usage , continue?</asp:Localize> ", "", function(btn1) {
                if (btn1 != 'ok')
                    return;
                var btn = document.getElementById('MainContent_ScanUser');
                Wait("<asp:Localize meta:resourcekey="str_scaning" runat="server">Scanning...</asp:Localize>");
                btn.click();
            });
        }
        function OnIconView() {
            $("#<%=hidViewType.ClientID%>").val("icon");
            //document.getElementById("MainContentDiv").style.backgroundColor = "#f8f8f8";
            var container = document.getElementById("tcontainercontainer");
            container.style.display = "";
            grid.hide();

            var e = document.getElementById("listview");
            e.style.display = "";
            e = document.getElementById("iconview");
            e.style.display = "none";
            
            localStorage.setItem("usermgrstate","0");
            PageSetUIState("usermgr", "0");
        }

        function OnListView() {
            $("#<%=hidViewType.ClientID%>").val("list");
            document.getElementById("MainContentDiv").style.backgroundColor = "white";
            var container = document.getElementById("tcontainercontainer");
            container.style.display = "none";
            grid.show();

            var e = document.getElementById("listview");
            e.style.display = "none";
            e = document.getElementById("iconview");
            e.style.display = "";
            
            localStorage.setItem("usermgrstate","1");
            PageSetUIState("usermgr", "1");
          
        }

        try {
            
            if(parent.SetCurrentRelativeTitle)
                parent.SetCurrentRelativeTitle('User Manager');
            else
                parent.ClearSubMenu('');
        } catch (e) {
            
        }

        function ReturnLast() {
            parent.ReturnLast();
        }

        //parent.LoadInitPage();

        var oldOnload = window.onload;
        window.onload = function () {

            if (oldOnload) oldOnload();
            //fix for tooltips to work inside of popovers
            $('body').tooltip({ selector: '[data-toggle=tooltip]' });
            //initialize tooltips
            $('[data-toggle="tooltip"]').tooltip({ "html": true });


        }

       
    </script>
</asp:Content>
