﻿<%@ Page Title="Gladinet Cloud - Local File Servers" Language="C#" MasterPageFile="~/WebAppPanel.master" AutoEventWireup="true"
    CodeBehind="SvrAgentGroup.aspx.cs" Inherits="GladinetPayFlow.SvrAgentGroup" culture="auto" meta:resourcekey="PageResource1" uiculture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
        .titlecol
        {
            background-color: #f0f0f0;
            font-size: 14px;
        }


         td
        {
            font-size: 14px;
            font-family: Verdana,sans-serif;
            font-weight: 100;
        }
        
        b
        {
            font-weight: 500;
        }
        
        label
        {
            font-weight: 500;
        }
        .usericon 
        {
        	background-image:url("images/addaduser.png");
        }
        </style>
    <script type="text/javascript">



        function ClearErrorMsg() {
            
            var d = document.getElementById("errmsgdiv");
            if (d) {
                d.style.display = 'none';
            }
        }
        setTimeout("ClearErrorMsg()", 30000);

        function OnCancel() {
            parent.closeCancelActiveWin();
        }

        function SelectAll() {
            var Users = document.getElementsByTagName("input");

            for (var i = 0; i < Users.length; ++i) {
                if (Users[i].type == "checkbox") {
                    Users[i].checked = true;
                }
            }
        }

        function DeSelectAll() {
            var Users = document.getElementsByTagName("input");

            for (var i = 0; i < Users.length; ++i) {
                if (Users[i].type == "checkbox") {
                    Users[i].checked = false;
                }
            }
        }

        function ReSelectAll() {
            var Users = document.getElementsByTagName("input");

            for (var i = 0; i < Users.length; ++i) {
                if (Users[i].type == "checkbox") {
                    Users[i].checked = !Users[i].checked;
                }
            }
        }

        function OnGroupSelected() {
            var Users = document.getElementsByTagName("input");
            var UserList = "";

            for (var i = 0; i < Users.length; ++i) {
                if (Users[i].type == "checkbox" && Users[i].checked) {
                    if (-1 == Users[i].name.indexOf('uu_'))
                        continue;
                    if (UserList != "")
                        UserList += "\n";
                    UserList += unescape(Users[i].value);

                }
            }    
            
            try{    
                var dashboardFrame = parent.document.getElementById("main_body").contentWindow.document.getElementById("servers_f").contentWindow;
                if(dashboardFrame.document.location.href.toLowerCase().indexOf("/management/editrole.aspx")>-1){
                    //if this page was opened in a popup from the edit roles page, then invoke OnGroupSelected(GroupList)    
                    dashboardFrame.OnGroupSelected(UserList);
                    parent.CloseQuickWindow("",""); 
                    return;
                }
            }catch(ex) {
                console.log("Could not locate dashboard iframe, ex:" +ex);
            }

            //old behavior
            if (parent.SetSelectedGroup)
                parent.SetSelectedGroup(UserList);
            else
                parent.parent.SetSelectedGroup(UserList);


        }
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
    <nav class="navbar navbar-default" role="navigation">
      <div class="container-fluid">
          <div class=" navbar-right" style="padding-right: 20px;padding-top: 10px;color: white;">
              <asp:LinkButton  ID="Refresh" OnClientClick="Wait('Loading Groups');"
                                            runat="server" OnClick="Refresh_Click" CssClass="btn btn-success" ForeColor="#565656"
                                            meta:resourcekey="RefreshResource1">
                                          <span class="gladinet-icons secpaneltextcolor" style="padding-right:5px;line-height:14px;font-size:22px;">&#xB5;</span>
                                            <asp:Localize ID="Localize1" meta:resourcekey="asp_string3" runat="server" >Refresh</asp:Localize>
                                        </asp:LinkButton>
           </div>
      </div>
    </nav>
    <table width="99%"  style="background-color: white; margin-top: 0px;" id="mainwnd"
        align="center">
        <tr>
            <td>
                <table width="100%" style="padding-top: 8px;display: none;">
                    <tr>
                        <td align="right" style="padding: 10px; border: 1px solid #d0d0d0;">
                            <table>
                                <tr style="display: none;">
                                    <td style="vertical-align: top;">
                                        <asp:Localize meta:resourcekey="asp_string1" runat="server">LDAP Filter:</asp:Localize>
                                    </td>
                                    <td style="padding-bottom: 2px;">
                                        <asp:TextBox ID="LDAPFilter" Width="380px" Text="(objectCategory=group)" runat="server"
                                            CssClass="x-form-field x-form-text" ></asp:TextBox>
                                    </td>
                                    <td>
                                    </td>
                                </tr>
                                <tr>
                                    <td style="vertical-align: top; display: none;">
                                        <asp:Localize meta:resourcekey="asp_string2" runat="server">Under:</asp:Localize>
                                    </td>
                                    <td style="display: none;">
                                        <asp:TextBox ID="OU" Width="380px" runat="server" CssClass="x-form-field x-form-text"
                                            meta:resourcekey="OUResource1"></asp:TextBox><br />
                                        <span style="color: #a0a0a0"><sub>(i.e. OU=Team, OU=Dev)</sub></span>
                                    </td>
                                    <td style="vertical-align: top; text-align: right;">
                                        
                                    </td>
                                </tr>
                            </table>
                    </tr>
                </table>
                <table width="100%" align="center" style="display: <%=( m_ResultPage||m_UserCount==0)? "none" :""%>;">
                    <tr>
                        <td>
                            <div id="grid-example">
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td height="5px">&nbsp;</td>
                    </tr>
                    <tr>
                        <td style="height: 40px; background-color:white; border-top:1px solid #c0c0c0;">
                            <table width="100%">
                                <tr>
                                    <td>
                                        <a href="#" onclick="SelectAll();return false;" style="padding-left: 10px; padding-right: 10px;
                                            color: #008000">
                                            <asp:Localize meta:resourcekey="asp_string4" runat="server">Select All</asp:Localize></a>
                                    </td>
                                    <td>
                                        <a href="#" onclick="DeSelectAll();return false;" style="padding-right: 10px; color: #008000">
                                            <asp:Localize meta:resourcekey="asp_string5" runat="server">Deselect All</asp:Localize></a>
                                    </td>
                                    <td>
                                        <a href="#" onclick="ReSelectAll();return false;" style="padding-right: 10px; color: #008000">
                                            <asp:Localize meta:resourcekey="asp_string6" runat="server">Undo Selection</asp:Localize></a>
                                    </td>
                                    <td align="right" style="padding-right: 10px">
                                        
                                                    <asp:LinkButton ID="LinkButton3" CssClass="btn btn-primary gladbtn" runat="server" OnClientClick="OnGroupSelected();return false;" ForeColor="#565656"
                                                        ><span class="fa fa-name"></span><asp:Localize meta:resourcekey="asp_string7" runat="server">Add Selected Groups</asp:Localize></asp:LinkButton>
                                        
                                    </td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                </table>
                <table width="100%" align="center" style="display: <%=( !m_ResultPage&&m_UserCount==0)? "" :"none"%>;">
                    <tr>
                        <td style="padding: 40px">
                            <p class='idea_flex' style="height: 140px; display: <%=( !string.IsNullOrEmpty(ErrorMsg.Text)||!string.IsNullOrEmpty(EmptyList.Text))? "" :"none"%>;">
                                <b>
                                    <asp:Label ID="ErrorMsg" runat="server" Style="color: Red;" meta:resourcekey="ErrorMsgResource1"></asp:Label></b><br />
                                <asp:Label ID="EmptyList" runat="server" Font-Size="14px" meta:resourcekey="EmptyListResource1"></asp:Label>
                            </p>
                            <asp:Panel ID="Panel1" runat="server" meta:resourcekey="Panel1Resource1">
                                <div class='idea_flex' style="display: <%=( !string.IsNullOrEmpty(ErrorMsg.Text)&&!string.IsNullOrEmpty(EmptyList.Text))? "none" :""%>; background-color: white;">
                                    <asp:Localize meta:resourcekey="asp_string8" runat="server">Click 'Query Groups' above to load group list from your installed Cloud Server Agent.</asp:Localize>
                                </div>
                            </asp:Panel>
                        </td>
                    </tr>
                </table>
                <table width="90%" align="center" style="display: <%=( !m_ResultPage)? "none" :""%>;">
                    <tr style="border-top: 1px solid #f0f0f0; padding: 5px 5px 5px 5px;">
                        <td style="padding: 5px; border-bottom: 1px solid #e0e0e0;">
                            &nbsp;
                        </td>
                        <td style="padding: 5px; border-bottom: 1px solid #e0e0e0;">
                            &nbsp;
                        </td>
                        <td style="padding: 5px; border-bottom: 1px solid #e0e0e0;">
                            &nbsp;
                        </td>
                    </tr>
                    <asp:Repeater ID="ResultsList" runat="server">
                        <ItemTemplate>
                            <tr style="border-top: 1px solid #f0f0f0; padding: 5px 5px 5px 5px;">
                                <td style="padding: 5px; border-bottom: 1px solid #e0e0e0; border-left: 1px solid #e0e0e0;
                                    border-right: 1px solid #e0e0e0;">
                                    <%#(((RepeaterItem)Container).ItemIndex+1) %>
                                </td>
                                <td style="padding: 5px; border-bottom: 1px solid #e0e0e0;">
                                    <b>
                                        <%#DataBinder.Eval(Container.DataItem, "Name")%></b>
                                </td>
                                <td style="padding: 5px; border-bottom: 1px solid #e0e0e0; border-right: 1px solid #e0e0e0;">
                                    <%#DataBinder.Eval(Container.DataItem,"Value") %>
                                </td>
                            </tr>
                        </ItemTemplate>
                    </asp:Repeater>
                </table>
            </td>
        </tr>
    </table>

 <script type="text/javascript">
  var myData = [
 <asp:Repeater ID="UsersRepeater" runat="server" >
        <ItemTemplate>
       <%#(Container.ItemIndex == 0)? "": "," %>     ['<%#(((RepeaterItem)Container).ItemIndex+1) %>',
       '<%#DataBinder.Eval(Container.DataItem, "GroupName").ToString().Replace("'","%27")%>', 
       '<%#DataBinder.Eval(Container.DataItem,"Sid").ToString().Replace("'","%27") %>', 
       '<%#DataBinder.Eval(Container.DataItem,"KeyValue").ToString().Replace("'","%27") %>']
        
        </ItemTemplate>
    </asp:Repeater>      
    ];
    </script>
  <script type="text/javascript">

      Ext.require([
          'Ext.grid.*',
          'Ext.data.*',
          'Ext.util.*',
          'Ext.state.*'
      ]);

      var h = document.documentElement.offsetHeight-160;
      
      Ext.onReady(function () {

          Ext.QuickTips.init();

          var store = Ext.create('Ext.data.ArrayStore', {
              fields: [
                  { name: 'index' },
                  { name: 'grpname' },
                  { name: 'sid' },
                  { name: 'keyvalue' }
              ],
              data: myData
          });



          var grid = Ext.create('Ext.grid.Panel', {
              store: store,
              stripeRows: true,
              border:false,
              columnLines: true,
              scroll: true,
              layout: 'fit',
              height: h,
              columns: [
                  {
                      text: '',
                      width: 50,
                      sortable: false,
                      dataIndex: 'index',
                      getClass: function (v, meta, rec) {
                          return 'x-col-hdide';
                      }
                  },
                  {
                      text: "<asp:Localize meta:resourcekey="js_string1" runat="server">Group Name</asp:Localize>",
                flex: 1,
                sortable: true,
                dataIndex: 'grpname',
                renderer: function (value, metaData, record, rowIndex) {
                    return "<span style='font-size:16px; font-weight:100; color:#565656'>" + value + "</span>";
                }

            },
            
            {
                text: '',
                width: 50,
                sortable: true,
                dataIndex: 'keyvalue',
                renderer: function (value, metaData, record, rowIndex) {
                    var d = record.data;
                    return "<input type='checkbox' name='uu_user_" + d.grpname + "' value='" + value + "' />";
                }
            }
        ],
              renderTo: 'grid-example'
          });

          Ext.EventManager.onWindowResize(grid.doLayout, grid);
      });

  </script>
</asp:Content>
