﻿<%@ Page Title="Gladinet Cloud - Update HPCloud Storage Account" Language="C#" MasterPageFile="UpdateStorageConfig.master"
    AutoEventWireup="true" CodeBehind="HPCloud_Update.aspx.cs" Inherits="GladinetPayFlow.StorageConfig.HPCloudUpdate" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
        .style1
        {
            color: #339966;
        }
    </style>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
<asp:Localize ID="LocUse" meta:resourcekey="str_use" runat="server" Visible="False">Username</asp:Localize>
<asp:Localize ID="LocAccKey" meta:resourcekey="str_accKey" runat="server" Visible="False">Access Key</asp:Localize>
<asp:Localize ID="LocAPIKey" meta:resourcekey="str_aPIKey" runat="server" Visible="False">API Key</asp:Localize>
<asp:Localize ID="LocAccID" meta:resourcekey="str_accID" runat="server" Visible="False">Account ID</asp:Localize>
<asp:Localize ID="LocSesExpPleRefPagOrLogIn" meta:resourcekey="str_sesExpPleRefPagOrLogIn" runat="server" Visible="False">Session expired. Please refresh page or log in again.</asp:Localize>
<asp:Label ID="LabelStorage" runat="server" Text="Label Storage" Visible=false></asp:Label>
    <table
<%if (!SessionAttaching)
  { %>
     width="904" 
<%} %>
     align="center" style="background: WHITE; padding: 15px;" cellspacing="0" id="input_panel">
        <tr>
            <td width="504" style="padding: 10px; vertical-align: top;">


                <b><asp:Localize meta:resourcekey="str_speThe" runat="server">Specify the</asp:Localize>
                    <asp:Label ID="LabelStorage1" runat="server" Text="Label Storage 1"></asp:Label>
                    &nbsp; <asp:Localize meta:resourcekey="str_rooFolToUseThiWilBecTheRoo" runat="server">root folder to use. This will become the root folder of your Gladinet Cloud
                    account.</asp:Localize>&nbsp; </b>&nbsp;<br />


                <b>
                    <asp:Label ID="ErrorMsg" runat="server" Style="color: Red;"></asp:Label></b>
                <br />
                <asp:Panel ID="PanelEndPoint" runat="server">
                    <table width="100%" align="center" style="display: block;">
                        <tr>
                            <td><asp:Localize meta:resourcekey="str_ideSerV20ApiEnd" runat="server">Identity Service v2.0 API End-Point:</asp:Localize></td>
                        </tr>
                        <tr>
                            <td>
                                <asp:TextBox ID="TextBoxEndPoint" runat="server" Width="461px">https://region-a.geo-1.identity.hpcloudsvc.com:35357/v2.0/</asp:TextBox><br />
                               
                            </td>
                        </tr>
                    </table>
                </asp:Panel>
                <table width="100%" align="center" style="display: block;">
                     <tr>
                        <td height="15px">
                            <asp:Label ID="Label2" runat="server" Text="Region"></asp:Label>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <asp:TextBox ID="TxtRegion" runat="server" Width="393px" Text="region-a.geo-1"></asp:TextBox><br />
                            <asp:RequiredFieldValidator ID="RequiredFieldValidator4" runat="server" ErrorMessage="Region Required"
                                ControlToValidate="TxtRegion" ForeColor="#CC0000" CssClass="errmsg"></asp:RequiredFieldValidator>
                        </td>
                    </tr>
                    <tr>
                        <td height="15px">
                            <asp:Label ID="LabelAccessKey" runat="server" Text="Tenant ID"></asp:Label>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <asp:TextBox ID="TxtAccessKey" runat="server" Width="393px"></asp:TextBox><br />
                            <asp:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server" ErrorMessage="Tenant ID Required"
                                ControlToValidate="TxtAccessKey" ForeColor="#CC0000" CssClass="errmsg"></asp:RequiredFieldValidator>
                        </td>
                    </tr>
                    <tr>
                        <td height="15px">
                            <asp:Label ID="Label1" runat="server" Text="Tenant Name"></asp:Label>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <asp:TextBox ID="TxtUsername" runat="server" Width="393px"></asp:TextBox><br />
                            <asp:RequiredFieldValidator ID="RequiredFieldValidator3" runat="server" ErrorMessage="Tenant Name Required"
                                ControlToValidate="TxtUsername" ForeColor="#CC0000" CssClass="errmsg"></asp:RequiredFieldValidator>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <asp:Label ID="LabelSecret" runat="server" Text="Password"></asp:Label>
                        </td>
                    </tr>
                    <tr>
                        <td height="15px">
                            <asp:TextBox ID="TxtSecretKey" runat="server" Width="395px" TextMode="Password" 
                                ViewStateMode="Enabled"></asp:TextBox>
                            <br />
                            <asp:RequiredFieldValidator ID="RequiredFieldValidator2" runat="server" ControlToValidate="TxtSecretKey"
                                ErrorMessage="Password Required" ForeColor="#CC0000" CssClass="errmsg"></asp:RequiredFieldValidator>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <asp:Button ID="BtnTestConnection" runat="server" meta:resourcekey="str_tesCon" Text="Test Connection" OnClick="BtnTestConnection_Click" />
                            <asp:HiddenField ID="HiddenFieldGoodConnection" runat="server" />
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <asp:Panel ID="PanelPickBucket" runat="server">
                                <table width="100%" border="0">
                                    <tr>
                                        <td class="style1">
                                            <p class='green' style="height:auto;">
                                                <asp:Localize meta:resourcekey="str_conTesSuc" runat="server">Connection test successful!</asp:Localize> (<asp:Label ID="LabelExpire" runat="server" Text=" "></asp:Label>)<br />
                                                 <asp:Label ID="LabelStorageUrl" runat="server" Text=" "></asp:Label><br />
                                               
                                                 </p>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td><asp:Localize meta:resourcekey="str_selACon" runat="server">Select a Container</asp:Localize></td>
                                    </tr>
                                    <tr>
                                        <td height="32">
                                            <asp:DropDownList ID="DropDownListBuckets" runat="server" AutoPostBack="True" OnSelectedIndexChanged="DropDownListBuckets_SelectedIndexChanged">
                                                <asp:ListItem>{Test Connection First}</asp:ListItem>
                                            </asp:DropDownList>
                                            &nbsp;
                                            <br />
                                            <asp:Panel ID="PanelCreateBucket" runat="server">
                                                <asp:Localize meta:resourcekey="str_newConNam" runat="server">New Container Name:</asp:Localize>&nbsp;
                                                <asp:TextBox ID="TxtNewBucket" runat="server" Width="252px"></asp:TextBox>
                                                <br />
                                                <asp:Button ID="BtnCreateBucket" runat="server" meta:resourcekey="str_creCon" Text="Create Container" OnClick="BtnCreateBucket_Click" />
                                            </asp:Panel>
                                            <br />
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <asp:Panel ID="PanelPickFolder" runat="server">
                                                <asp:Panel ID="PanelFolderDropDown" runat="server" Visible="False">
                                                    <table width="100%" border="0">
                                                        <tr>
                                                            <td height="32"><asp:Localize meta:resourcekey="str_selAFolLeaItBlaForTheRoo" runat="server">Select a Folder (Leave it blank for the root folder in the bucket)</asp:Localize></td>
                                                        </tr>
                                                        <tr>
                                                            <td>
                                                                <asp:DropDownList ID="DropDownListFolder" runat="server">
                                                                </asp:DropDownList>
                                                            </td>
                                                        </tr>
                                                    </table>
                                                </asp:Panel>
                                                <table width="100%">
                                                    <tr>
                                                        <td style="text-align: center">
                                                            <div class="linkbutton">
                                                                <asp:LinkButton ID="LinkButtonNext" runat="server" Font-Bold="true" Font-Size="16px"
                                                                    OnClick="ButtonFinish_Click" OnClientClick="showLoader(this.parentNode)" CssClass="linkbuttona" meta:resourcekey="str_next">Next</asp:LinkButton>
                                                            </div>
                                                            <div style="display: none" id='blueloader'>
                                                                <img alt='loading ...' src="../images/blueloader.gif" width="160" height="20" /></div>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </asp:Panel>
                                        </td>
                                    </tr>
                                </table>
                            </asp:Panel>
                        </td>
                    </tr>
                    <tr>
                        <td>&nbsp;</td>
                    </tr>
                </table>
            </td>
<%if (!SessionAttaching)
  { %>

            <td width="10">&nbsp;</td>
            <td style="border-left: 1px solid #D0D0D0; padding-left: 10px;" valign="top">
                <asp:Image ID="ImageStorage" runat="server" ImageUrl="~/StorageConfig/images/hpcloud.jpeg" />
                &nbsp;<div style="margin: 6px;">
                    Please provide an access information.
                    <br />
                    The test connection button will test your Cloud Storage connection.
                    You may then select a container as your root folder.<br />
                    &nbsp;</div>
            </td>
        </tr>
        <tr>
            <td colspan="2"></td>
            <td style="border-left: 1px solid #D0D0D0; padding-left: 10px;">&nbsp;</td>
        </tr>
<%} %>
    </table>
<%if (!SessionAttaching)
  { %>

    <table width="100%" align="center">
        <tr>
            <td height="5px" colspan="2">&nbsp;</td>
        </tr>
        <tr>
            <td height="10px" colspan="2" style="border-top: 1px solid #D0D0D0;">&nbsp;</td>
        </tr>
        <tr>
            <td colspan="2" align="right" style="padding-right: 15px;">&nbsp;&nbsp;&nbsp;&nbsp;</td>
        </tr>
    </table>
         <script type="text/javascript">
         function EnableCompactMode() {
             var d = document.getElementById("input_panel");
             if (d)
                 d.height="550";

//             d = document.getElementById("spliter");
//             if (d)
//                 d.style.display = 'none';
             ShowRowPage();

         }
<%} %>
    <% if (string.Compare(DisplayMode,"compact",true)==0)
        { %>
            EnableCompactMode();
        <%} %>

         
        
    </script>

</asp:Content>
