﻿<%@ Page Title="Shared Objects Report" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="ShareReportPage.aspx.cs" Inherits="GladinetPayFlow.ShareReportPage" culture="auto" meta:resourcekey="PageResource1" uiculture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
        .titlecol
        {
            background-color: #f0f0f0;
            font-size: 14px;
        }
        .emailSort,.createdSort,.permissionsSort,.expirationSort{white-space:nowrap;}
        .resetSortLabel,.pathSortLabel,.emailSortLabel,.createdSortLabel{text-decoration:none;cursor:pointer;}
        .creatorSortLabel,.permissionsSortLabel,.expirationSortLabel{text-decoration:none;cursor:pointer;}
        .resetSortLabel:hover,.pathSortLabel:hover,.emailSortLabel:hover,.createdSortLabel:hover{text-decoration:underline;}
        .creatorSortLabel:hover,.permissionsSortLabel:hover,.expirationSortLabel:hover{text-decoration:underline;}
        .defaultModeCol{display:table-row;}
        .sortModeCol{display:none;}
        #headerRow td {font-weight:300;}
        .lnk{cursor:pointer;text-decoration:underline;}
    </style>
    <script type="text/javascript">




        function ClearErrorMsg() {

            var d = document.getElementById("errmsgdiv");
            if (d) {
                d.style.display = 'none';
            }
        }
        setTimeout("ClearErrorMsg()", 30000);
        //parent.setActivePanel("PubMgr");

        function Unpublish(id, name) {
            var h = "PubMgrPage.aspx?op=delete&id=" + id;

            if (confirm("<asp:Localize meta:resourcekey="js_string1" runat="server">Do you really want to delete (</asp:Localize>" + unescape(name) + ")?"))
                window.location = h;
        }




        var ActiveWin;
        var MainWnd;
        function closeActiveWin() {


            window.location = window.location;

        }

        function closeCancelActiveWin() {
            ActiveWin.close();
        }

        function PrintFile() {
            
         var originalContents = document.body.innerHTML;
            
         var printReport = document.getElementById('previewcontent').innerHTML;
            document.body.innerHTML = printReport;
            document.body.style.overflow = "visible";
            window.print();

            document.body.innerHTML = originalContents;
            

        }

        function DeleteACL(pl, path, sid, em, oid, filReqName) {
            var b = document.getElementById("MainContent_DeleteAcl");
            var t = document.getElementById("MainContent_ShareAclType");
            var p = document.getElementById("MainContent_ShareLoc");
            var s = document.getElementById("MainContent_ShareId");
            var e = document.getElementById("MainContent_ShareAclEmail");
            var o = document.getElementById("MainContent_OwnerId");
            var f = document.getElementById("MainContent_FileRequestName");

            t.value = pl;
            p.value = path;
            s.value = sid;
            e.value = em;
            o.value = oid;
            f.value = filReqName;
        
            gConfirm("<asp:Localize  meta:resourcekey="str_confirmd" runat="server" >Please confirm the deletion.</asp:Localize>", "", function() {
               
                      
               
                b.click();

            });
        }
        function SelectAll() {
            var Users = document.getElementsByTagName("input");

            for (var i = 0; i < Users.length; ++i) {
                if (Users[i].type == "checkbox") {
                    Users[i].checked = true;
                }
            }
        }

        function DeSelectAll() {
            var Users = document.getElementsByTagName("input");

            for (var i = 0; i < Users.length; ++i) {
                if (Users[i].type == "checkbox") {
                    Users[i].checked = false;
                }
            }
        }

        function ReSelectAll() {
            var Users = document.getElementsByTagName("input");

            for (var i = 0; i < Users.length; ++i) {
                if (Users[i].type == "checkbox") {
                    Users[i].checked = !Users[i].checked;
                }
            }
        }
        function EditACL(rowId) {
            //passing only ID and then retrieving the values might be safer due to possible inner quotes or single quotes
            var loc = encodeURIComponent($("#pubsRpt_loc_" + rowId).html());
            var email = $("#pubsRpt_email_" + rowId).html(); 
            var isDir = $("#pubsRpt_isDir_" + rowId).html().toLowerCase();
            var uri = "/management/AddShareUser.aspx?noedit&e=" + email + "&noback=1&child=1&src=browser&location="+loc+"&folder="+isDir;
            top.OpenQuickWindow(uri, "Edit User Share");
        }
        function resetSort() {
            try{
                parent.SetPage(9);
            }catch(ex){
                location.reload(true);
            }
        }
        var _currSortCol = "";
        var _currSortDir = "";
        function sortBy(col) {
            $(".defaultModeRow").hide();
            $(".sortModeCol").show();
            if(_currSortCol!=col){
                _currSortCol = col;
                _currSortDir = "asc";
            } else if(_currSortCol==col){
                _currSortCol = col;
                if(_currSortDir=="asc"){
                    _currSortDir = "desc";
                }else{
                    _currSortDir = "asc";
                }
            }
            var sortedTableRows = $(".usrRptRow").slice(0).sort(function (a, b) {
                //sort string ascending algorithm
                var x = $(a).find("."+col+"Sort")[0].innerHTML.toLowerCase();
                var y = $(b).find("."+col+"Sort")[0].innerHTML.toLowerCase();
                if(_currSortDir=="desc"){
                    if (y < x) { return -1; }
                    if (y > x) { return 1; }
                } else {
                    if (x < y) { return -1; }
                    if (x > y) { return 1; }
                }
                return 0;
            });   
            $("#previewTbl tr").remove();
            var newHeader = '<tr id="headerRow">';
            newHeader += '<td colspan="2" class="resetSortLabel" onclick="resetSort()"><asp:Localize meta:resourcekey="str_resSor" runat="server">Reset Sort</asp:Localize></td>';
            newHeader += '<td onclick="sortBy(\'email\')" class="emailSortLabel" title="<%=LocSrtByEml.Text %>"><%=LocEml.Text %></td>';
            newHeader += '<td onclick="sortBy(\'path\')" class="pathSortLabel" title="<%=LocSrtByPth.Text %>"><%=LocPth.Text %></td>';
            newHeader += '<td onclick="sortBy(\'creator\')" class="creatorSortLabel" title="<%=LocSrtByCtr.Text %>"><%=LocCtr.Text %></td>';
            newHeader += '<td onclick="sortBy(\'created\')" class="createdSortLabel" title="<%=LocSrtByCrt.Text %>"><%=LocCrt.Text %></td>';
            newHeader += '<td onclick="sortBy(\'permissions\')" class="permissionsSortLabel" title="<%=LocSrtByPrm.Text %>"><%=LocPrm.Text %></td>';
            newHeader += '<td onclick="sortBy(\'expiration\')" class="expirationSortLabel" title="<%=LocSrtByExpDte.Text %>"><%=LocExp.Text %></td>';
            newHeader += '</tr>';
            $("#previewTbl").find('tbody').append(newHeader);
            $("#previewTbl").find('tbody').append(sortedTableRows);
            AdjustGridTable();
        }     
        function cfmDelSelected(){
            $('#DeleteConfirmModal').modal({ backdrop: 'static', keyboard: false });
        }
        function deleteSelectedConfirmed(){
            $('#DeleteConfirmModal').modal('hide');
            $("#<%=DelSelected.ClientID %>")[0].click();
        }
        function searchForShare(){
            $('#SearchShareModal').modal({ backdrop: 'static', keyboard: false });
        }
        function searchConfirmed(){
            $('#SearchShareModal').modal('hide');
            $("#<%=BtnSearch.ClientID %>")[0].click();
        }
        function resetSearch(){
            $("#<%=TxtSearchPath.ClientID %>").val("");
            $("#<%=BtnSearch.ClientID %>")[0].click();
        }
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
    <asp:Localize runat="server" ID="LocEvn" meta:resourcekey="str_evn" Visible="false">Everyone</asp:Localize>
<asp:Localize runat="server" ID="LocAllADUsr" meta:resourcekey="str_allADUsr" Visible="false">All AD Users</asp:Localize>
<asp:Localize runat="server" ID="LocUknUsr" meta:resourcekey="str_uknUsr" Visible="false">Unknown User</asp:Localize>
<asp:Localize runat="server" ID="LocExd" meta:resourcekey="str_exd" Visible="false">Expired</asp:Localize>
    
<asp:Localize runat="server" ID="LocBts" meta:resourcekey="str_bts" Visible="false">Bytes</asp:Localize>
<asp:Localize runat="server" ID="LocFldLodShrObjLst" meta:resourcekey="str_fldLodShrObjLst" Visible="false">Failed to get shared object list</asp:Localize>
<asp:Localize ID="LocPbcLnk" meta:resourcekey="str_pbcLnk" runat="server" Visible="false">Public Link</asp:Localize>
<asp:Localize ID="LocFulCtr" meta:resourcekey="str_fulCtr" runat="server" Visible="false">Full Control</asp:Localize>
<asp:Localize ID="LocViwOly" meta:resourcekey="str_viwOly" runat="server" Visible="false">View Only</asp:Localize>
<asp:Localize ID="LocDwnOly" meta:resourcekey="str_dwnOly" runat="server" Visible="false">View/Read Only</asp:Localize>
<asp:Localize ID="LocFilReq" meta:resourcekey="str_filReq" runat="server" Visible="false">File Request</asp:Localize>
<asp:Localize ID="LocUkn" meta:resourcekey="str_ukn" runat="server" Visible="false">Unknown</asp:Localize>
<asp:Localize ID="LocNa" meta:resourcekey="str_na" runat="server" Visible="false">N/A</asp:Localize>
<asp:Localize ID="LocNvr" meta:resourcekey="str_nvr" runat="server" Visible="false">Never</asp:Localize>
<asp:Localize ID="LocEvrOne" meta:resourcekey="str_evrOne" runat="server" Visible="false">Everyone</asp:Localize>
<asp:Localize ID="LocGrp" meta:resourcekey="str_grp" runat="server" Visible="false">[Group]</asp:Localize>
    
<asp:Localize ID="LocSrtByEml" meta:resourcekey="str_srtByEml" runat="server" Visible="false">Sort by Email</asp:Localize>
<asp:Localize ID="LocSrtByPth" meta:resourcekey="str_srtByPth" runat="server" Visible="false">Sort by Path</asp:Localize>
<asp:Localize ID="LocSrtByCtr" meta:resourcekey="str_srtByCtr" runat="server" Visible="false">Sort by Creator</asp:Localize>
<asp:Localize ID="LocSrtByCrt" meta:resourcekey="str_srtByCrt" runat="server" Visible="false">Sort by Date Created</asp:Localize>
<asp:Localize ID="LocSrtByPrm" meta:resourcekey="str_srtByPrm" runat="server" Visible="false">Sort by Permissions</asp:Localize>
<asp:Localize ID="LocSrtByExpDte" meta:resourcekey="str_srtByExpDte" runat="server" Visible="false">Sort by Expiration Date</asp:Localize>
<asp:Localize ID="LocRstSrt" meta:resourcekey="str_rstSrt" runat="server" Visible="false">Reset Sort</asp:Localize>

<asp:Localize ID="LocEml" meta:resourcekey="str_eml" runat="server" Visible="false">Email</asp:Localize>
<asp:Localize ID="LocPth" meta:resourcekey="str_pth" runat="server" Visible="false">Path</asp:Localize>
<asp:Localize ID="LocCtr" meta:resourcekey="str_ctr" runat="server" Visible="false">Creator</asp:Localize>
<asp:Localize ID="LocCrt" meta:resourcekey="str_crt" runat="server" Visible="false">Created</asp:Localize>
<asp:Localize ID="LocPrm" meta:resourcekey="str_prm" runat="server" Visible="false">Permissions</asp:Localize>
<asp:Localize ID="LocExp" meta:resourcekey="str_exp" runat="server" Visible="false">Expiration</asp:Localize>
<asp:Localize ID="LocNoShrWerFou" meta:resourcekey="str_noShrWerFou" runat="server" Visible="false">No shares were found</asp:Localize>
     
<asp:Localize ID="LocSrcResMsg" meta:resourcekey="str_srcResMsg" runat="server" Visible="false">Found [X] share(s) containing [WORD] out of [Y] total.</asp:Localize>
<asp:Localize ID="LocRstSrc" meta:resourcekey="str_rstSrc" runat="server" Visible="false">Reset Search</asp:Localize>


    <asp:Localize ID="LocShdObj" meta:resourcekey="str_shdObj" runat="server" Visible="false">Shared Object(s)</asp:Localize>
    <div 
        <%if (IsChildUi) { %>
        style="width:100%;border-bottom:1px solid #eeeeee"
        <%}else { %>
        class=" meubardrop"
        <%} %>
        >
        <table width="100%"  style="background-color: white;margin-top: 0px; border:0px;" align="center" cellspacing="0" cellpadding="0">
            <tr >
            <td align="left" style="padding-left: 10px;border-top:0px solid white;" colspan="2">
                <asp:Label ID="PubFolderCount" runat="server" 
                    meta:resourcekey="PubFolderCountResource1" CssClass="badge hollowbadge"></asp:Label>
            </td>
            <td  style="padding-left: 10px;border-top:0px solid white;" >
                <table>
                                    <tr>
                                        <td>
                                            <a href="#" onclick="SelectAll();return false;" class="btn btn-primary gladbtn"><asp:Localize  meta:resourcekey="selectall" runat="server" Text="Select All"></asp:Localize></a>
                                        </td>
                                        <td>
                                            <a href="#" onclick="DeSelectAll();return false;" style="padding-right: 10px; color: #008000; font-size:16px;font-weight:100;" class="btn btn-primary gladbtn">
                                                <asp:Localize  meta:resourcekey="deselectall" runat="server" Text="Deselect All"></asp:Localize></a>
                                        </td>
                                        <td>
                                            <a href="#" onclick="ReSelectAll();return false;" style="padding-right: 10px; color: #008000; font-size:16px;font-weight:100;" class="btn btn-primary gladbtn">
                                                <asp:Localize  meta:resourcekey="undoselect" runat="server" Text="Undo Selection"></asp:Localize></a>
                                        </td>
                                        <td>
                                            <input type="button" value="<%=DelSelected.Text %>" class="btn btn-primary gladbtn" onclick="cfmDelSelected()" />
                                            <div style="display:none">
                                            <asp:LinkButton ID="DelSelected" runat="server"  OnClick="DelSelected_Click"  meta:resourcekey="str_dltSld"  CssClass="btn btn-primary gladbtn" >Delete Selected</asp:LinkButton>
                                            </div>
                                        </td>
                                        <td>
                                            <a href="#" onclick="searchForShare();return false;" style="padding-right: 10px; color: #008000; font-size:16px;font-weight:100;" class="btn btn-primary gladbtn">
                                                <asp:Localize  meta:resourcekey="str_src" runat="server" Text="Search"></asp:Localize></a>
                                        </td>
                                        
                                    </tr>
                                </table>
            </td>
            <td style="text-align:right;border-top:0px solid white;">
                <div id="errmsgdiv">
                    <b>
                        <asp:Label ID="ErrorMsg" runat="server" Style="color: Red;" 
                        meta:resourcekey="ErrorMsgResource1"></asp:Label></b>
                </div>
                <asp:Panel ID="BtnPanel" runat="server">
                
                        <table>
                                <tr >
                                    <td width="32px">
                                        <img width="32px" src="images/pubfolder.png" />
                                    </td>
                                    <td>
                                        <a href="PubMgrPage.aspx?vdid=<%=SessionDomainId %>"  style="font-size: 14px;"><asp:Localize meta:resourcekey="asp_string1" runat="server">Manage Team Folder</asp:Localize></a>
                                    </td>
                                </tr>
                            </table>          
                            </asp:Panel>      
            </td>
                <td align="right">
                    <table>
                        <tr>
                            <td>
                                            <asp:LinkButton ID="exportcsv" runat="server" onclick="exportcsv_Click" cssclass="btn btn-primary gladbtn" ><asp:Localize ID="Localize1" meta:resourcekey="str_dwnCsvFil" runat="server">Download as CSV file</asp:Localize></asp:LinkButton>
                                        </td>
            <td align="right" width="48px" height="48px" onclick='PrintFile();return false;' style="border-top:0px solid white;">
                 <span class="glyphicon glyphicon-print secpaneltextcolor" style="font-size:24px;margin-top:3px; cursor:pointer;"></span>
            </td>
                        </tr>
                    </table>
                </td>
                
        </tr>
        </table>
    </div>
    <div id="previewContentDiv" style="width:100%;margin-top: 20px; overflow:auto;" >
     <table width="99%" class="table" style="background-color: white; border:0px;" align="center" cellspacing="0" cellpadding="0">
  
        
         <tr>
             <td colspan="5" id="previewcontent" style="font-size: 16px;">
                 <table width="100%" id="previewTbl">
                     <asp:Literal ID="LtlMsg" runat="server" />
        <asp:Repeater ID="PubsRepeater" runat="server" OnItemDataBound="OnPubItemBound">
            <ItemTemplate>
                <tr class="defaultModeRow">
                    <td width="32px" style="border-top: 0px solid #d0d0d0; border-bottom: 1px solid #d0d0d0;border-left: 0px solid #d0d0d0;  padding-left:6px;">                         
                        <i class="gladinet-icons md-24 md-dark hand center toolbtnb"><%#GetShareTypeIcon(DataBinder.Eval(Container.DataItem, "IsPublicUrl"),DataBinder.Eval(Container.DataItem, "IsFileRequest"))%></i>
                    </td>
                    <td style="border-top: 0px solid #d0d0d0; border-bottom: 1px solid #d0d0d0;border-left: 0px; padding: 10px; font-size: 16px; font-weight: 100;" >
                        <span id="pubsRpt_loc_<%# Container.ItemIndex %>" class="pathSort" title="Sort by Path" onclick="sortBy('path')"><%#DataBinder.Eval(Container.DataItem, "PathLocation")%></span>
                        <span id="pubsRpt_isDir_<%# Container.ItemIndex %>" style="display:none;"><%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem,"IsDir").ToString()) %></span>
                    </td>
                    <td style="border-right: 0px solid #d0d0d0; border-bottom: 1px solid #d0d0d0; border-top: 0px solid #d0d0d0; padding: 10px;font-size: 16px; font-weight: 100;" width="200px" align="right" nowrap="nowrap">
                        <%#DataBinder.Eval(Container.DataItem, "Memo")%>
                    </td>
                </tr>
                <tr class="sortableRow">
                <td colspan="4" style="padding-left:38px;">
                    <table width="100%" style="background-color: white; border:0px dotted #cccccc;" class=" table-striped" >
                                <tbody class="PermTable">
                                    <tr style="background-color: white;" class="PermTableHeaderRow">
                                        <td style=" border-bottom: 1px solid #d0d0d0; " width="32px"></td>
                                        <td style=" border-bottom: 1px solid #d0d0d0; " width="32px"></td>
                                        <td style=" border-bottom: 1px solid #d0d0d0; ">
                                            <span class="emailSortLabel" title="<%=LocSrtByEml.Text %>" onclick="sortBy('email')"><%=LocEml.Text %></span>
                                        </td>
                                        <td width="150px" style=" border-bottom: 1px solid #d0d0d0; " class="sortModeCol">
                                            <span class="pathSortLabel" title="<%=LocSrtByPth.Text %>" onclick="sortBy('path')"><%=LocPth.Text %></span>
                                        </td>
                                        <td width="150px" style=" border-bottom: 1px solid #d0d0d0; " class="sortModeCol">
                                            <span class="creatorSortLabel" title="<%=LocSrtByCtr.Text %>" onclick="sortBy('creator')"><%=LocCtr.Text %></span>
                                        </td>
                                        <td width="150px" style=" border-bottom: 1px solid #d0d0d0; ">
                                            <span class="createdSortLabel" title="<%=LocSrtByCrt.Text %>" onclick="sortBy('created')"><%=LocCrt.Text %></span>
                                        </td>
                                        <td width="150px" style=" border-bottom: 1px solid #d0d0d0; ">
                                            <span class="permissionsSortLabel" title="<%=LocSrtByPrm.Text %>" onclick="sortBy('permissions')"><%=LocPrm.Text %></span>
                                        </td>
                                        <td width="150px" style=" border-bottom: 1px solid #d0d0d0; ">
                                            <span class="expirationSortLabel" title="<%=LocSrtByExpDte.Text %>" onclick="sortBy('expiration')"><%=LocExp.Text %></span>
                                        </td>                                        
                                        
                                    </tr>
                                    <asp:Repeater ID="UserRepeater" runat="server">
                                        <ItemTemplate>

                                            <tr style="padding-top: 5px;"  
                                                id='<%# DataBinder.Eval(Container.DataItem, "UserEmail") %>' class="usrRptRow">
                                                <td style=" border-bottom: 0px solid #d0d0d0; " width="32px">
                                                <% if (m_CanDelete){ %>
                                                <input type='checkbox' name="su_<%# DataBinder.Eval(Container.DataItem, "ShareUid") %>;<%# DataBinder.Eval(Container.DataItem, "PublicLink") %>;<%# DataBinder.Eval(((RepeaterItem)Container.Parent.Parent).DataItem, "PathLocation") %>;<%# DataBinder.Eval(Container.DataItem, "UserEmail") %>;<%# DataBinder.Eval(Container.DataItem, "ShareLink") %>" value="1"/>
                                                <% } %>

                                                </td>
                                            <td style=" border-bottom: 0px solid #d0d0d0; " width="32px">

                                                <% if (m_CanDelete){ %>
                                                <div class="toolbtn" style="font-size: 14px; color: #560000; cursor: pointer;" onclick='DeleteACL("<%# DataBinder.Eval(Container.DataItem, "PublicLink") %>", "<%# DataBinder.Eval(((RepeaterItem)Container.Parent.Parent).DataItem, "PathLocation").ToString().Replace("'", "&apos;") %>", "<%# DataBinder.Eval(Container.DataItem, "ShareUid") %>",  "<%# DataBinder.Eval(Container.DataItem, "UserEmail") %>",  "<%# DataBinder.Eval(((RepeaterItem)Container.Parent.Parent).DataItem, "OwnerUid") %>","<%# DataBinder.Eval(Container.DataItem, "ShareLink") %>"); return false;'>
                                                    <i class="gladinet-icons md-24 md-dark hand center toolbtnb">n</i>                                                    
                                                </div>
                                                <% } %>
                                            </td>
                                                
                                                <td align="left">
                                                    <div style="display:none"><!- This feature has been disabled until further testing ->
                                                    <%# LocPbcLnk.Text.Equals(DataBinder.Eval(Container.DataItem,"PublicLink")) == true ? "" : 
                                                            "<div class=\"gladinet-icons md-24 md-dark hand center toolbtnb\" onclick=\"EditACL('" + 
                                                            ((RepeaterItem)Container.Parent.Parent).ItemIndex + "')\">/</div>&nbsp;&nbsp;" %>
                                                    </div>
                                                    <span id="pubsRpt_email_<%# ((RepeaterItem)Container.Parent.Parent).ItemIndex %>" class="emailSort"><%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem,"UserEmail").ToString()) %></span>
                                                    
                                                </td>
                                                <td align="left" class="sortModeCol">
                                                    <span class="pathSort"><%# DataBinder.Eval(Container.DataItem, "PathLoc") %></span>
                                                </td>
                                                <td align="left" class="sortModeCol">
                                                    <span class="creatorSort"><%# DataBinder.Eval(Container.DataItem, "Creator") %></span> 
                                                </td>
                                                <td align="left">
                                                    <span class="createdDisplay"><%# DataBinder.Eval(Container.DataItem, "CreateTime") %></span>
                                                    <span class="createdSort" style="display:none;"><%# DataBinder.Eval(Container.DataItem, "CreateTime", "{0: yyyyMMddhhmmsstt}") %></span>
                                                </td>
                                                <td align="left">
                                                    <span class="permissionsSort"><%# DataBinder.Eval(Container.DataItem, "PublicLink") %></span>

                                                </td>
                                                <td align="left">
                                                    <span class="expirationSort" title="<%# DataBinder.Eval(Container.DataItem, "Expiration") %>"><%# DataBinder.Eval(Container.DataItem, "DisplayExpireTime") %></span><span style="display:none;" class="expTmeSrt"><%# DataBinder.Eval(Container.DataItem, "Expiration") %></span>
                                                </td>
                                               
                                            </tr>
                                        </ItemTemplate>
                                    </asp:Repeater>
                                    </tbody>
                                </table>
                </td>
                </tr>
                <tr>
                <td colspan="3" height=3px>&nbsp;</td>
                </tr>
                
            </ItemTemplate>
        </asp:Repeater>             
                 </table>
             </td>
         </tr>

        
    </table>
        </div>

  <div id="DeleteConfirmModal" class="modal fade" role="dialog" style="width:750px;margin-left:auto;margin-right:auto;">
      <div class="modal-dialog">
      <!-- Modal content-->
        <div class="modal-content">
          <div class="modal-header">
              <%=DelSelected.Text %>
          </div>
          <div class="modal-body" style="font-weight: 100; color: #565656;">
            <asp:Localize runat="server" meta:resourcekey="str_delSelCfm">Are you sure you want to delete the selected shares?</asp:Localize>
          </div>
          <div class="modal-footer" style="font-size: 16px;">
            <button type="button" id="DeleteMySharesBtn" class="btn btn-primary gladbtn" onclick="deleteSelectedConfirmed()"><span style="font-size: 16px; font-weight: 200;"><asp:Localize meta:resourcekey="str_prd" runat="server">Proceed</asp:Localize></span></button>
            <button type="button" id="DeleteShareModalCloseBtn" class="btn btn-default" data-dismiss="modal"><span style="font-size: 16px; font-weight: 200;"><asp:Localize meta:resourcekey="str_cnl" runat="server">Cancel</asp:Localize></span></button>
          </div>
        </div>
    </div>
  </div>

  <div id="SearchShareModal" class="modal fade" role="dialog" style="width:750px;margin-left:auto;margin-right:auto;">
      <div class="modal-dialog">
      <!-- Modal content-->
        <div class="modal-content">
          <div class="modal-header">
              <asp:Localize meta:resourcekey="str_srcShr" runat="server">Search Shares</asp:Localize>
          </div>
          <div class="modal-body" style="font-weight: 100; color: #565656;">
            <p><asp:Localize runat="server" meta:resourcekey="str_etrFlnOrVph">Enter a filename or virtual path:</asp:Localize></p>
            <p><asp:TextBox id="TxtSearchPath" runat="server" CssClass="form-control dark" ></asp:TextBox></p>
              <div style="display:none">
                  <asp:Button ID="BtnSearch" runat="server" Text="Search" OnClick="BtnSearch_Click" />
              </div>
          </div>
          <div class="modal-footer" style="font-size: 16px;">
            <button type="button" class="btn btn-primary gladbtn" onclick="searchConfirmed()"><span style="font-size: 16px; font-weight: 200;"><asp:Localize meta:resourcekey="str_src" runat="server">Search</asp:Localize></span></button>
            <button type="button" class="btn btn-default" data-dismiss="modal"><span style="font-size: 16px; font-weight: 200;"><asp:Localize meta:resourcekey="str_cnl" runat="server">Cancel</asp:Localize></span></button>
          </div>
        </div>
    </div>
  </div>

    <div style="display: none;">
        <asp:HiddenField ID="ShareAclType" runat="server" />
        <asp:HiddenField ID="ShareLoc" runat="server" />
        <asp:HiddenField ID="ShareId" runat="server" />
        <asp:HiddenField ID="OwnerId" runat="server" />
        <asp:HiddenField ID="ShareAclEmail" runat="server" />
        <asp:HiddenField ID="FileRequestName" runat="server" />
        <asp:Button ID="DeleteAcl" runat="server" Text="Button" OnClick="DeleteAcl_Click" />

    </div>
        <script type="text/javascript">
        function AdjustGridTable(){
            
            var e = document.getElementById("previewcontent");
            
            e.style.height = (document.documentElement.offsetHeight-80)+"px";

            e = document.getElementById("previewContentDiv");
            
            e.style.height = (document.documentElement.offsetHeight-80)+"px";
        }
        AdjustGridTable();
        </script>

</asp:Content>
