﻿<%@ Page Title="Gladinet Cloud - User Manager" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="SelectUser.aspx.cs" Inherits="GladinetPayFlow.SelectUser" culture="auto" meta:resourcekey="PageResource1" uiculture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    
    <style type="text/css">
         td
        {
            font-size: 14px;
            font-family: Verdana,sans-serif;
            font-weight: 100;
        }
        
        b
        {
            font-weight: 500;
        }
        
        label
        {
            font-weight: 500;
        }
         .titlecol
         {
             background-color: #f0f0f0;
             font-size: 14px;
         }
        
        html, body
        {
            height: 100%;
        }
        .main, #aspnetForm
        {
            height: 100%;
        }

        .wrapper
        {
            
            width:100%;
            height: auto !important;
            
            padding: 0px;
            background-color: white;
            margin: 0 auto -71px; /* the bottom margin is the negative value of the footer's height */
        }
        .footer, .push
        {
            height: 68px; /* .push must be the same height as .footer */
        }
        
        .btnsmall {
            padding-left: 3px !important;
            padding-right: 3px !important;
        }
    </style>
    <script type="text/javascript">
        function getScrollXY() {
            var scrOfX = 0, scrOfY = 0;
            if (typeof (window.pageYOffset) == 'number') {
                //Netscape compliant
                scrOfY = window.pageYOffset;
                scrOfX = window.pageXOffset;
            } else if (document.body && (document.body.scrollLeft || document.body.scrollTop)) {
                //DOM compliant
                scrOfY = document.body.scrollTop;
                scrOfX = document.body.scrollLeft;
            } else if (document.documentElement && (document.documentElement.scrollLeft || document.documentElement.scrollTop)) {
                //IE6 standards compliant mode
                scrOfY = document.documentElement.scrollTop;
                scrOfX = document.documentElement.scrollLeft;
            }
            //return [scrOfX, scrOfY];
            return scrOfY;
        }



        var activewin;
        function ClearErrorMsg() {

            var d = document.getElementById("errmsgdiv");
            if (d) {
                d.style.display = 'none';
            }
        }
        setTimeout("ClearErrorMsg()", 30000);
        //parent.setActivePanel("UserMgr");

        function onDelUser(id, name) {
            var h = "UserMgrPage.aspx?op=delete&id=" + id;

            if (confirm("<asp:Localize meta:resourcekey="js_string2" runat="server">Do you really want to delete (</asp:Localize>" + name + ")?"))
            window.location = h;

        }
         
        function ReturnLast() {
            closeCancelActiveWin();
        }
    
        function closeCancelActiveWin()
        {
            activewin.close();  

            //show footer with apply button if there is a sub-page being displayed 
            $("#mainFooter").show();
        }

        function closeActiveWin() {
            window.location =  window.location;
        }

        function OnAddUser() {

            activewin = new Ext.Window({
                id: 'On_Add_User',
                title: "<asp:Localize meta:resourcekey="js_string3" runat="server">Create New User</asp:Localize>",
                width: 480,
                height: 550,
                plain: true,
                modal: true,
                maximizable: true,
                resizable: false,
                maximized: false,
                shadow: 'drop',
                shadowOffset: 20,
                layout: 'fit',
                bodyPadding: 3,
                html: "<iframe id='openwin' src='AddUserPage.aspx' scrolling='auto' style='width:100%;height:100%;margin:0;padding:0'></iframe>",
                defaults: {
                    border: false
                }
            });
            activewin.show();

            //hide footer with apply button if there is a sub-page being displayed 
            $("#mainFooter").hide();

        }
        function OnAddUserWizard() {
            activewin = new Ext.Window({
                id: 'newuser_win',
                title: "<asp:Localize meta:resourcekey="str_migrateuser" runat="server">Migrate Users</asp:Localize>",
                width: 880,
                height: maxh(560),
                plain: true,
                modal: true,
                maximizable: false,
                maximized: true,
                header: false,
                
                border: false,
                bodyPadding: 0,
                html: "<iframe id='openwin' src='/management/adduserwizard/AddUserType.aspx?vdid=<%=SessionDomainId %>&reff=%2Fportal%2FSelectUser.aspx' scrolling='auto' style='width:100%;height:100%;margin:0;padding:0;border:0;'></iframe>"
            });
            activewin.on({
                scope: this,
                close: function () {
                    this.OnNewUserCommitted();
                }
            });

            activewin.show(); 

            //hide footer with apply button if there is a sub-page being displayed 
            $("#mainFooter").hide();
        }

        function OnBatchAddUser() {

            activewin = new Ext.Window({
                id: 'pubs_win',
                title: "<asp:Localize meta:resourcekey="js_string6" runat="server">Batch Create New Users</asp:Localize>",
                width: 680,
                height: 550,
                plain: true,
                modal: true,
                maximizable: true,
                constrain: true,
                maximized: false,
                layout: 'fit',
                bodyPadding: 3,
                html: "<iframe id='openwin' src='BatchAddUserPage.aspx' scrolling='auto' style='width:100%;height:100%;margin:0;padding:0'></iframe>",
                defaults: {
                    border: false
                }
            });
            activewin.show();
            
            //hide footer with apply button if there is a sub-page being displayed 
            $("#mainFooter").hide();

        }

        function SelectAll() {
            var Users = document.getElementsByTagName("input");

            for (var i = 0; i < Users.length; ++i) {
                if (Users[i].type == "checkbox") {
                    Users[i].checked = true;
                }
            }
        }

        function DeSelectAll() {
            var Users = document.getElementsByTagName("input");

            for (var i = 0; i < Users.length; ++i) {
                if (Users[i].type == "checkbox") {
                    Users[i].checked = false;
                }
            }
        }

        function ReSelectAll() {
            var Users = document.getElementsByTagName("input");

            for (var i = 0; i < Users.length; ++i) {
                if (Users[i].type == "checkbox") {
                    Users[i].checked = !Users[i].checked;
                }
            }
        }

        function OnNewUserCommitted() {
            try {
                if (parent.RefreshCommittedNewUser)
                    parent.RefreshCommittedNewUser();
                else
                    parent.parent.RefreshCommittedNewUser();
            } catch (e) {
                console.log("OnNewUserCommitted failed: " + e);
            }
        }
        var _onUserSelectedAlreadyCalled = false;
        function OnUserSelected() {

            var Users = document.getElementsByTagName("input");
            var UserList = "";
            for (var i = 0; i < Users.length; ++i) {
                if (Users[i].type == "checkbox" && Users[i].checked) {
                    
                    if (UserList != "")
                        UserList += "\n";
                    UserList += unescape( Users[i].name);
                    
                }
            }
            var setSelUsrFunc = null;
            var par = parent;
            //every time the add user is clicked a new nested iframe is created
            for (var i = 0; i < 10; i++) {   
                if (par.SetSelectedUser) {
                    setSelUsrFunc = par.SetSelectedUser;
                    break;
                } else {
                   par = par.parent;
                }
            }              
            if(setSelUsrFunc)  {      
                if (_onUserSelectedAlreadyCalled === false) {   
                    //prevent recursion from parent calling back this OnUserSelected function
                    _onUserSelectedAlreadyCalled = true;
                    setSelUsrFunc(UserList);
                }   
            } 
            else{
                console.log("[portal/SelectUser]:SetSelectedUser is undefined on parent frames")
            }
        }

        function OnLDAPAddUser() {
            var closeAction = new Ext.Action({
                text: 'Close',
                width: 108
            });

            activewin = new Ext.Window({
                id: 'On_Ads_AddUser',
                title: "<asp:Localize meta:resourcekey="js_string7" runat="server">Add Active Directory User(s)</asp:Localize>",
                width: 680,
                height: 550,
                plain: true,
                modal: true,
                maximizable: true,
                constrain: true,
                maximized: false,
                layout: 'fit',
                bodyPadding: 3,
                html: "<iframe id='openwin' src='LDAPUserPage.aspx' scrolling='auto' style='width:100%;height:100%;margin:0;padding:0'></iframe>",
                defaults: {
                    border: false
                },
                listeners: {
                    "close": function () {
                        window.location = window.location;
                    }
                }
            });


            activewin.show();
            
            //hide footer with apply button if there is a sub-page being displayed 
            $("#mainFooter").hide();

        }
        function AddUserGroup() {
            activewin = new Ext.Window({
                id: 'On_Add_Group',
                title: "<asp:Localize meta:resourcekey="js_string8" runat="server">Create New User</asp:Localize>",
                width: 480,
                height: 450,
                plain: true,
                modal: true,
                maximizable: true,
                resizable: false,
                maximized: false,
                shadow: 'drop',
                shadowOffset: 20,
                layout: 'fit',
                bodyPadding: 3,
                html: "<iframe id='openwin' src='EditGroup.aspx' scrolling='auto' style='width:100%;height:100%;margin:0;padding:0'></iframe>",
                defaults: {
                    border: false
                }
            });
            activewin.show();
           
            //hide footer with apply button if there is a sub-page being displayed 
            $("#mainFooter").hide();
        }

    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
    <asp:Localize runat="server" ID="LocEvn" meta:resourcekey="str_evn" Visible="false">Everyone</asp:Localize>
<asp:Localize runat="server" ID="LocAllADUsr" meta:resourcekey="str_allADUsr" Visible="false">All AD Users</asp:Localize>
<asp:Localize runat="server" ID="LocUkn" meta:resourcekey="str_ukn" Visible="false">Unknown</asp:Localize>
<asp:Localize runat="server" ID="LocNa" meta:resourcekey="str_na" Visible="false">N/A</asp:Localize>
<asp:Localize runat="server" ID="LocUknUsr" meta:resourcekey="str_uknUsr" Visible="false">Unknown User</asp:Localize>
    <asp:Localize ID="LocEvrone" meta:resourcekey="str_evrone" runat="server" Visible="False">Everyone</asp:Localize>
        <div style="width:100%; border-bottom:1px solid #cccccc;">
      <table style="width:100%;">
          <tr>
              <td>
                  <div id="errmsgdiv">
                                        <b>
                                            <asp:Label ID="ErrorMsg" runat="server" Style="color: Red;" meta:resourcekey="ErrorMsgResource1"></asp:Label></b>
                                    </div>           
              </td>
                         <% if (HasResult & !IsMobile()){ %>
              <td>
          <div class=" navbar-left" >
               <table>
                            <tr>
                            
                                <td>
                                    <a href="#" onclick="SelectAll();return false;" style="padding-left: 10px; padding-right: 10px;color: #008000">
                                        <asp:Localize ID="Localize1" meta:resourcekey="asp_string1" runat="server">Select All</asp:Localize></a>
                                </td>
                                <td>
                                    <a href="#" onclick="DeSelectAll();return false;" style="padding-right: 10px; color: #008000">
                                        <asp:Localize ID="Localize2" meta:resourcekey="asp_string2" runat="server">Deselect All</asp:Localize></a>
                                </td>
                                <td>
                                    <a href="#" onclick="ReSelectAll();return false;" style="padding-right: 10px; color: #008000">
                                        <asp:Localize ID="Localize3" meta:resourcekey="asp_string3" runat="server">Reverse Selection</asp:Localize></a>
                                </td>
                            </tr>
                        </table>
          </div>
                  </td>
          <%} %>

              <td>
                  
                    <table align="right">
                   <tr>
                                <%if (!GroupOnly && m_CanAdd&& !HasGuest){ %>
                                <td align="right"  width="40" style="display: none;">
                                    <%if (!NoGroup){ %>
                                    <asp:Localize ID="asp_string4" Visible="False" meta:resourcekey="asp_string4" runat="server">Create New Group</asp:Localize>
                                    <a href="javascript:AddUserGroup();" onclick="AddUserGroup();return false;" style="font-size: 14px;"
                                        title="<%=asp_string4.Text %>">
                                        <img width="32px" src="images/group.png" /></a>
                                    <%} %>
                                </td>
                                <td align="right"  style="padding-right: 10px;">
                                    <asp:Localize ID="asp_string5" Visible="False" meta:resourcekey="asp_string5" runat="server">Create a New User</asp:Localize>
                                    <a href="#" onclick="OnAddUserWizard();return false;" style="font-size: 12px;" title="<%=asp_string5.Text %>">
                                        <button class="btn btn-primary gladbtn">
                                        <i class="gladinet-icons md-32 md-dark hand center">&#x01b4;</i>
                                                                            </button>
                                    </a>
                                </td>
                                    <%if (m_ShowWizard){ %>
                                    <td align="right"  width="52px">
                                        <asp:Localize ID="asp_string6" Visible="False" meta:resourcekey="asp_string6" runat="server">Batch Create and Migrate AD User Wizard</asp:Localize>
                                        <a href="#" onclick="OnAddUserWizard();return false;" style="font-size: 12px;" title="<%=asp_string6.Text %>">
                                            <img width="32px" src="/portal/images/wizard.png" /></a>
                                    </td>
                                    <%} %>
                                <%} %>
                                <td>
                                    
                                </td>
                            </tr>
              </table>
                  
              </td>
              <td align="right">
                  <asp:Panel ID="SearchPanel" runat="server" DefaultButton="LinkButton1" style="padding-right:60px;">
              <table align="right">
                                        <tr>
                                            <td  valign="bottom">
                                                <asp:Label ID="UserCount" runat="server" Text="0 User" Visible="False" meta:resourcekey="UserCountResource1"></asp:Label>
                                            </td>
                                            <td   align="right" nowrap="nowrap">
                                                <asp:LinkButton ID="AllUsers" runat="server" Font-Size="Larger" ForeColor="Green"
                                                    OnClick="AllUsers_Click" meta:resourcekey="AllUsersResource1">
                                                    <asp:Label ID="AllUser" runat="server" Text="All Users & Groups" meta:resourcekey="AllUserResource1"></asp:Label>
                                                </asp:LinkButton>
                                                </td>
                                            <%if (!HasGuest)
                                                { %>
                                            <td>
                                                <asp:TextBox ID="Contains" runat="server" CssClass="form-control" meta:resourcekey="ContainsResource1"  Width="250px"></asp:TextBox>
                                                </td><td>
                                                
                                                    <asp:LinkButton ID="LinkButton1" runat="server" OnClick="FileterUsers_Click" CssClass="btn btn-default btnsmall"><i class="gladinet-icons md-24 md-dark hand center">&#xA7;</i></asp:LinkButton>
                                                    
                                            </td>
                                            <%} %>
                                        </tr>
                                    </table>
                  </asp:Panel>
              </td>
          </tr>
      </table>
          
    </div>
    
                    
                       
                        <table width="100%" align="center" style="margin-top: 18px;">
                            <tr>
                                <td>
                                    <div id="grid-example" style="width:100vw;">
                                    </div>
                                </td>
                            </tr>
                        </table>
    

    <div id="mainFooter" class="footer" style="border-left: 0; border-right: 0;  border-bottom: 0; vertical-align: middle; margin: 0;height:68px;position:absolute;width:100vw;text-align:right;display:block;bottom:0px!important;right:40px;z-index:99999">
        <table width="100%" style="height: 64px; text-align: right; padding-right: 64px;"
            align="right">
     
            <tr>
                <td>
                </td>
                <td width="32px">
                    
                </td>
                <td width="160px" style="padding-right: 10px;">
                    <asp:Button ID="Button3" OnClick="FileterUsers_Click" OnClientClick="OnUserSelected();return false;" CssClass="btn btn-primary gladbtn"
                        runat="server" Text="Apply" style="background-color:#fafafa;" Width="128px" meta:resourcekey="Button3Resource1" />
                </td>
            </tr>
        </table>
    </div>
    <script type="text/javascript">
  var myData = [
 <asp:Repeater ID="UsersRepeater" runat="server" OnItemCommand="UsersRepeater_ItemCommand"
        OnItemDataBound="OnUserItemBound">
        <ItemTemplate>
       <%#(Container.ItemIndex == 0)? "": "," %>     ['<%#(((RepeaterItem)Container).ItemIndex+1) %>','<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "FirstName").ToString().Replace("'","%27"))%>&nbsp;<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "LastName").ToString().Replace("'","%27"))%>', '<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem,"Email").ToString().Replace("'","%27")) %>','<%#DataBinder.Eval(Container.DataItem, "UserGuid")%>,<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem,"Email").ToString().Replace("'","%27")) %>,<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "FirstName").ToString().Replace("'","%27"))%> <%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "LastName").ToString().Replace("'","%27"))%>']
        
        </ItemTemplate>
    </asp:Repeater>      
    ];
    </script>
  <script type="text/javascript">

      Ext.require([
          'Ext.grid.*',
          'Ext.data.*',
          'Ext.util.*',
          'Ext.state.*'
      ]);
      Ext.onReady(function () {

          Ext.QuickTips.init();

          var store = Ext.create('Ext.data.ArrayStore', {
              fields: [
                  { name: 'index' },
                  { name: 'fullname' },
                  { name: 'email' },
                  { name: 'check' }
              ],
              sortOnLoad: true,
              sorters: [{ direction: "ASC", property: "fullname"}],
              data: myData
          });


           var d = document.getElementById("grid-example");
          var h = 400;
        try {
            h = d.offsetHeight-10;  // in IE8, this is very narrow like = 1
            h1 = document.body.offsetHeight;
            if (h1 > 300) {
                h1 = h1 - 76; // paddings , margins, whatever
            }
            if (h<50) {
                // this shall only happen for IE8
                gridY = Ext.get("grid-example").getY();
                h = h1 - gridY;
                if (h<218) {
                  h=218;
                }
            }
           } catch (err) {
           }

          var grid = Ext.create('Ext.grid.Panel', {
              
              frame: false,
              border:false,
              store: store,
              stripeRows: true,
              columnLines: false,
              scroll: true,
              layout: 'fit',
              minHeight : 218,
              height:h+5, 


              columns: [
                 
                   {
                         text: '',
                         width: 50,
                         sortable: false,
                         dataIndex: 'check',
                         renderer: function (value, metaData, record, rowIndex) {
                             var p = value.split(',');
                             return "<img style='border-radius: 50%;' src='/storage/avarta.dn?u="+p[0]+ "&w=32&h=32&d=<%=SessionDomainId%>'/>"  ;
                         }
                     },
                  {
                      text: "<asp:Localize meta:resourcekey="js_string10" runat="server">Full Name</asp:Localize>",
                      flex: 1,
                      sortable: true,
                      dataIndex: 'fullname',
                      renderer: function (value, metaData, record, rowIndex) {
                          return "<span style='font-size:14px; font-weight:100; color:#404040'>" + unescape( value) + "</span>";
                      }

                  },
                  {
                      text: "<asp:Localize meta:resourcekey="js_string11" runat="server">Email</asp:Localize>",
                flex: 1,
                sortable: true,
                dataIndex: 'email',
                renderer: function (value, metaData, record, rowIndex) {
                    return "<span style='font-size:14px; font-weight:100; color:#404040'>" + unescape( value) + "</span>";
                }
            },
            {
                text: '',
                width: 45,
                sortable: true,
                dataIndex: 'check',
                renderer: function (value, metaData, record, rowIndex) {                    
                    return "<input type='checkbox' name='" + value + "' value='1' />";
                }
            }
        ],
              renderTo: 'grid-example'
          });

          Ext.EventManager.onWindowResize(grid.doLayout, grid);
          var inp = document.getElementById("MainContent_Contains");
          inp.focus();

      });
  </script>

 
</asp:Content>
