﻿<%@ Page Title="Gladinet Cloud - Account Info" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="SearchHelp.aspx.cs" Inherits="GladinetPayFlow.SearchHelp" culture="auto" meta:resourcekey="PageResource1" uiculture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
        .titlecol
        {
            background-color: #e0e0e0;
            font-size: 14px;
            padding-left: 5px;
        }
        
        .shareheader
        {
            background-image: url(images/share.png);
            background-repeat: no-repeat;
            background-position: 0 0;
            padding: 5px;
            padding-left: 38px;
        }
        .pubheader
        {
            background-image: url(images/pubfolder32.png);
            background-repeat: no-repeat;
            background-position: 0 0;
            padding: 5px;
            padding-left: 38px;
        }
        
        .rootfolder
        {
            background-image: url(images/teamdrive48.png);
            background-repeat: no-repeat;
            background-position: 0 0;
        }
        
        .dark {
            color: #565656!important;
            background-color: white !important;
        }
        
       
    </style>
    <script type="text/javascript">
        function ClearErrorMsg() {

            var d = document.getElementById("errmsgdiv");
            if (d !== null && d !== undefined) {
                d.style.display = 'none';
            }
        }
        setTimeout("ClearErrorMsg()", 30000);
        //document.body.style.backgroundColor = "White";

        function closeCancelActiveWin() {
            ActiveWin.close();
        }


        function AddPubFolder() {

            parent.parent.AddNewPubFolder();
        }

        function ManagePubFolder() {

            parent.parent.OpenPubManager();
        }

        function ManageShareFolder() {

            parent.parent.OpenShareManager();
        }

        function OnSearch() {
            var e = document.getElementById("MainContent_FileName");
            var f = document.getElementById("MainContent_Field");
            var p = document.getElementById("MainContent_PageCount");
            
            parent.SearchFile(e.value + "^" + f.value + "^" + p.value);
        }

        function OpenFileAuditTrace() {
            parent.parent.OpenFileAuditTrace();
        }
        function AttachFolder() {

            var uri = "<iframe id='openwin' src='/management/SelectProvider.aspx?src=mgr";
            uri += "' scrolling='auto' style='width:100%;height:100%;margin:0;padding:0'></iframe>";

            parent.OpenHtmlWindowShort('add_pub_y', 'Attach Cloud Storage', uri, 760, 600);
        }

        function AddVersionFolder() {

            var uri = "<iframe id='openwin' src='/portal/AddVersionedFolder.aspx?src=mgr";
            uri += "' scrolling='auto' style='width:100%;height:100%;margin:0;padding:0'></iframe>";

            parent.OpenHtmlWindowShort('add_pub_x', 'Create Versioned Folder', uri, 600, 300);
        }

        function gEncodeUri(str) {
            return encodeURI(str).replace(/&/g, '%26').replace(/#/g, '|').replace('+', ':').replace(/'/g, '%27');
        }

        function Unpublish(id, name) {
            var h = "RootFolderInfo.aspx?op=delete&id=" + id;

            if (confirm("Do you really want to unpublish (" + unescape(name) + ")?"))
                window.location = h;
        }

        function EditPubFolder(location) {

            parent.parent.EditPubFolder(location);

        }

        function OnEdit(ShareId, isDir) {
            var uri = "<iframe id='openwin' src=\"/portal/AddSharePage.aspx?src=filebrowser&folder=";
            uri += isDir;
            uri += "&location=/";

            uri += gEncodeUri(unescape(ShareId));
            uri += "\" scrolling='auto' style='width:100%;height:100%;margin:0;padding:0'></iframe>";

            parent.OpenHtmlWindow('edit_pub', 'Edit Share', uri);
        }


        function StopShare(id) {

            var h = "RootFolderInfo.aspx?op=stop&id=" + gEncodeUri(unescape(id));

            if (confirm("Do you really want to delete?"))
                window.location = h;
        }

    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
    <table width="100%" class="x-body" style="margin:0px; padding:0px;" cellpadding="0" cellspacing="0" height="100%">
        <tr style="display: none;">
            <td  class="x-panel-header-light" style="border:0px; border-bottom: 1px solid #d0d0d0;
                height: 58px;">
                <table align="center">
                    <tr>
                        <td align="center">
                            <table width="100%">
                                <tr>
                                    <td>
                                        <asp:Image ID="WebAppIcon" runat="server" Height="48px" Width="48px" 
                                            meta:resourcekey="WebAppIconResource1" />
                                    </td>
                                    <td style="padding-left: 10px; font-size: 16px; font-weight: bold">
                                        <asp:Localize meta:resourcekey="asp_string1" runat="server">Search</asp:Localize>
                                    </td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                </table>
            </td>
            <td>
            </td>
        </tr>
        <tr>
                            <td colspan="2" align="right" style="padding-bottom: 20px; height: 40px;">
                                <button type="button" class="btn btn-default btn-lg" data-toggle="modal" data-target="#myModal"> <span class="glyphicon glyphicon-info-sign" style="font-size: 18px; color: #565656;"></span></button>
                            </td>
                        </tr>
        <tr>
            <td style="border-bottom: 0px solid #d0d0d0; padding: 10px; background-color: white" valign="top">
                <asp:Panel ID="SearchPanel" runat="server" DefaultButton="SearchBtn">
                    <table width="100%" border="0">
                        
                        <tr>
                            <td style="font-size: 16px; font-weight: 100;">
                            <asp:Localize meta:resourcekey="str_sby" runat="server">Search By</asp:Localize>      
                                        
                                        <td>

                                            <asp:DropDownList ID="Field" runat="server" CssClass="browser-default custom-select secsubbordercolor">
                                            </asp:DropDownList>
                                        </td>
                        </tr>
                        <tr>

                            <td style="font-size: 16px; font-weight: 100; ">
                                <asp:Localize meta:resourcekey="str_ss" runat="server" ID="str_ss">Search String</asp:Localize>



                            </td>
                            <td width="220px">
                                <asp:TextBox ID="FileName" runat="server" CssClass="form-control" />
                            </td>

                        </tr>
                        <tr>
                                        <td  style="font-size: 16px; font-weight: 100;">
                                            <asp:Localize meta:resourcekey="str_onlyret" runat="server">Only return top</asp:Localize></td>
                                        <td>
                                            <asp:DropDownList ID="PageCount" runat="server" CssClass="browser-default custom-select secsubbordercolor">
                                            </asp:DropDownList>
                                                                <asp:Localize meta:resourcekey="str_rows" id="str_rows" Visible="False" runat="server">Rows</asp:Localize></td>
                                        
                                        
                        
                                        
                        <tr>
                            <td height="10px">&nbsp;</td>
                        </tr>
                        <tr>
                            <td colspan="2" onclick="OnSearch()" align="right" style="border-top: 1px solid #f8f8f8;">
                                <asp:LinkButton ID="SearchBtn" OnClientClick="OnSearch();return false;" runat="server" CssClass="btn btn-primary btn-lg">
                                    <asp:Localize meta:resourcekey="asp_string1" runat="server">Search</asp:Localize>
                                </asp:LinkButton>
                            </td>

                        </tr>
                    </table>
                                
                </asp:Panel>
            </td>
        </tr>
        <tr>
            <td style="padding: 10px; background-color: white;" align="left" valign="top">
                <div id="myModal" class="modal fade" role="dialog">
  <div class="modal-dialog">

    <!-- Modal content-->
    <div class="modal-content">
      <div class="modal-header">
          <h4 class="modal-title"><asp:Localize meta:resourcekey="asp_string2" runat="server">Wildcard Searches</asp:Localize></h4>
        <button type="button" class="close" data-dismiss="modal">&times;</button>
        
      </div>
      <div class="modal-body">
         <p>
                    <asp:Localize meta:resourcekey="asp_string3" runat="server">Search supports single and multiple character wildcard searches within single terms
                        (not within phrase queries).</asp:Localize></p>
                <p>
                    <asp:Localize meta:resourcekey="asp_string4" runat="server">To perform a single character wildcard search use the "?" symbol.</asp:Localize></p>
                <p>
                    <asp:Localize meta:resourcekey="asp_string5" runat="server">To perform a multiple character wildcard search use the "*" symbol.</asp:Localize></p>
                <p>
                    <asp:Localize meta:resourcekey="asp_string6" runat="server">The single character wildcard search looks for terms that match that with the single
                        character replaced. For example, to search for "text" or "test" you can use the
                        search:</asp:Localize></p>
                <pre class="code">te?t</pre>
                <p>
                    <asp:Localize meta:resourcekey="asp_string7" runat="server">Multiple character wildcard searches looks for 0 or more characters. For example,
                        to search for test, tests or tester, you can use the search:</asp:Localize>
                </p>
                <pre class="code">test*</pre>
                <p>
                    <asp:Localize meta:resourcekey="asp_string8" runat="server">You can also use the wildcard searches in the middle of a term.</asp:Localize></p>
                <pre class="code">te*t</pre>
                <p>
                    <b><asp:Localize meta:resourcekey="str_headstart" runat="server">Note: It will be slow if you use a * or ? symbol as the first character of a search.</asp:Localize></b></p>
                    <div style="display: none">
           <hr size=1 noshade/>
                <h3 class="boxed">
                    <asp:Localize meta:resourcekey="asp_string10" runat="server">Boolean Operators</asp:Localize></h3>
                <div class="section">
                    <p>
                        <asp:Localize meta:resourcekey="asp_string11" runat="server">Boolean operators allow terms to be combined through logic operators. Search supports
                            AND, "+", OR, NOT and "-" as Boolean operators(Note: Boolean operators must be ALL
                            CAPS).</asp:Localize></p>
                    <a name="N10103"></a><a name="OR"></a>
                    <h4 class="boxed">
                    </h4>
                    <p>
                        <asp:Localize meta:resourcekey="asp_string12" runat="server">The OR operator is the default conjunction operator. This means that if there is
                            no Boolean operator between two terms, the OR operator is used. The OR operator
                            links two terms and finds a matching document if either of the terms exist in a
                            document. This is equivalent to a union using sets. The symbol || can be used in
                            place of the word OR.</asp:Localize></p>
                    <p>
                        <asp:Localize meta:resourcekey="asp_string13" runat="server">To search for documents that contain either "alice bob" or just "alice" use the
                            query:</asp:Localize></p>
                    <pre class="code"><asp:Localize runat="server" meta:resourcekey="str_AliBobAli">"alice bob" alice</asp:Localize></pre>
                    <p><asp:Localize runat="server" meta:resourcekey="str_Or">or</asp:Localize></p>
                    <pre class="code"><asp:Localize runat="server" meta:resourcekey="str_AliBobOrAli">"alice bob" OR alice</asp:Localize></pre>
                    <a name="N10116"></a><a name="AND"></a>
                    <h4 class="boxed"><asp:Localize runat="server" meta:resourcekey="str_And">AND</asp:Localize></h4>
                    <p>
                        <asp:Localize meta:resourcekey="asp_string14" runat="server">The AND operator matches documents where both terms exist anywhere in the text of
                            a single document. This is equivalent to an intersection using sets. The symbol
                            &amp;&amp; can be used in place of the word AND.</asp:Localize></p>
                    <p>
                        <asp:Localize meta:resourcekey="asp_string15" runat="server">To search for documents that contain "alice" and "bob" use the query:</asp:Localize>
                    </p>
                    <pre class="code"><asp:Localize runat="server" meta:resourcekey="str_AliAndBob">"alice" AND "bob"</asp:Localize></pre>
                </div>
                </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal"><asp:Localize meta:resourcekey="str_closebtn" runat="server">Close</asp:Localize></button>
      </div>
    </div>

  </div>
</div>
                
               
                <div style="display: none;">
                    <asp:Localize meta:resourcekey="str_fname" ID="StrFName" Visible="False" runat="server">File Name</asp:Localize>
                    <asp:Localize meta:resourcekey="str_fpath" ID="StrFPath" runat="server">FullPath</asp:Localize>
                    <asp:Localize meta:resourcekey="str_tag" ID="StrTag" runat="server">Tag</asp:Localize>
                </div>
            </td>
        </tr>
    </table>
</asp:Content>
