﻿<%@ Page Title="Share File and Folder" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="ReqFile.aspx.cs" Inherits="GladinetPayFlow.ReqFile" Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
        .loginbox {
            border-radius: 3px 3px 3px 3px;
            border: 0px solid #c0c0c0;
            padding: 8px;
            box-shadow: 0 4px 4px 0 rgba(0,0,0,0.14), 0 6px 2px -4px rgba(0,0,0,0.12), 0 2px 10px 0 rgba(0,0,0,0.2);
            background-color: white;
        }



        .envelope {
            border-radius: 6px 6px 6px 6px;
        }

        .loginimage {
            border-radius: 2px 2px 2px 2px;
            border: 0px solid #F0F0F0;
            padding: 2px;
            background-color: white;
        }

        .textbox {
            border: 1px solid #D0D0D0;
            padding: 8px;
            padding-top: 0px;
            padding-bottom: 0px;
            -moz-box-shadow: 0 0 5px #ccc;
            -webkit-box-shadow: 0 0 5px#ccc;
            box-shadow: 0 0 5px #ccc;
            background-color: white;
        }

        .loginbtnbox {
            border-radius: 3px 3px 3px 3px;
            border: 1px solid #c0c0c0;
            padding: 2px;
            color: white;
            font-weight: 700;
        }

        div.x-panel-header-light {
            background-image: url('<%=bgImage%>');
            -webkit-background-size: cover;
            -moz-background-size: cover;
            -o-background-size: cover;
            background-size: cover;
        }

        #stampsharenex {
            background-image: url('<%=m_ShareStamp%>');
            background-repeat: no-repeat;
            background-position: right top;
        }
    </style>
    <script type="text/javascript">
    
        var UploadingIndex;
        var CompleteBytes;
        var TotalBytes;
        var StopUploading;
        var UploadingCount;
        var gNextTaskId = 1;
        var G_SuffixMap = new Ext.util.MixedCollection();
        var gTotalTaskCount = 0;
        var gTaskQueue = [];
        var gTotalBytes = 0;
        var gCurrentTaskItem = null;
        var OutstandingReq = null;
        var gFailedTaskQueue = null;
        var gGenerateUniqueFileNames = ("<%=GenerateUniqueFileNames%>"=="True");
        document.title = "<%:TenantName%>" + " Share File and Folder";
    function showHelpText(helptext) {
        var hctl = document.getElementById("HelpCtrl");
        var htext = document.getElementById("HelpText");


        htext.innerHTML = "<asp:Localize meta:resourcekey="js_string1" runat="server">Your friends, co-workers or clients can share files and folders with you through Gladinet Cloud.</asp:Localize>";
   


        hctl.style.display = 'block';
        hctl.style.left = ((document.body.offsetWidth - 600) / 2 +100) + "px";
        hctl.style.top = "366px";

        hctl.style.left = (event.clientX - 300) + "px";
        hctl.style.top = (event.clientY - 150) + "px";

    }

    function closeHelpText() {
        var hctl = document.getElementById("HelpCtrl");

        hctl.style.display = 'none';
    }
    
    function ResetLocalCache(dir) {
        try {
            localStorage.removeItem("_" + dir);
            localStorage.removeItem("<%=UploaTicket %>" + "_" + dir);
        } catch (e) {
        }

    }

    function allowDrop(ev) {

        ev.preventDefault();
        var e = document.getElementById("subtaskpanel");
        e.style.border = "2px dashed #008000";
    }

    function onLeve(ev) {
        ev.preventDefault();
        var e = document.getElementById("subtaskpanel");
        e.style.border = "1px solid #f0f0f0";
        
    }
    function drop(ev) {
        ev.preventDefault();

        var e = document.getElementById("subtaskpanel");
        e.style.border = "1px solid #f0f0f0";

        OnDragDropped(ev.dataTransfer);

        
        }

        function CloseUI() {
            top.location.href = top.location.href;
        }


    ResetLocalCache("");
    ResetLocalCache("/");
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
    <input type="hidden" id="hidCollectedInfo" value="" runat="server" />
<asp:Localize ID="LocMisInf" meta:resourcekey="str_misInf" runat="server" Visible="False">Missing information</asp:Localize>
<asp:Localize ID="LocReqAFilLin" meta:resourcekey="str_reqAFilLin" runat="server" Visible="False">Request a file link</asp:Localize>
    <asp:Localize runat="server" ID="LocFstNme" meta:resourcekey="str_fstNme" Visible="false">First Name:</asp:Localize>
    <asp:Localize runat="server" ID="LocLstNme" meta:resourcekey="str_lstNme" Visible="false">Last Name:</asp:Localize>          
    <asp:Localize runat="server" ID="LocComp" meta:resourcekey="str_comp" Visible="false">Company:</asp:Localize>
    <asp:Localize runat="server" ID="LocNA" meta:resourcekey="str_na" Visible="false">(Not Available)</asp:Localize>    
    <asp:Localize runat="server" ID="LocInvEml" meta:resourcekey="str_invEml" Visible="false">Invalid Email</asp:Localize>
    <%if(!FrameOnly ) { %>
    <table style="width: 100%; height: 100%">

        <tr>
            <td style="height: 220px; padding: 10px; padding-top: 30px!important;" class="topnavmenubarcolor" valign="top">
                <table width="100%">
                    <tr>
                        <td>
                            <table>
                                <tr>
                        <%if (IsServo){ %>
                        <td  >
                            <img src="<%=WebAppIcon%>" />
                        </td>
                        <%} %>
                        <td>
                            <span style="color: white; font-size: 24px;"><%=TenantName%></span>
                        </td>

                                </tr>
                            </table>
                        </td>
                    </tr>
                    <tr>
                        <td >
                            <span style="color: #f0f0f0; font-size: 12px;">&copy;<%:this.copyright%></span>
                <%if (!string.IsNullOrEmpty(ExpireMessage.Text))
                    { %>
                <br />
                <span style="color: #dd0000; font-size: 24px;">
                    <asp:Label ID="ExpireMessage" runat="server" meta:resourcekey="ExpireMessageResource1"></asp:Label>
                </span>
                <%}
                                                                    else
                                                                    { %><br />
                <span style="color: #f0f0f0; font-size: 12px;">
                    <asp:Localize ID="Localize1" meta:resourcekey="asp_string11" runat="server"
                        Text="Expiration :"></asp:Localize>
                    <asp:Label ID="LabelExpiration" runat="server" Text="12/1/2011" meta:resourcekey="LabelExpirationResource1"></asp:Label></span>
                <%}%>
                        </td>
                    </tr>
                    <tr>
                        <td><span style="color: #f0f0f0; font-size: 12px;"><%=CustomURL %></span></td>
                    </tr>

                </table>
                
                
                
            </td>
        </tr>
        <tr>
            <td class="gladactiverow" >&nbsp;</td>
        </tr>
    </table>
    <%}%>


    <table align="center" width="100%" style="position: absolute; <%if(!FrameOnly && !IsMobile()) { %>            
        top: 170px; <%}else{%>
        top: 10px; <%}%>">
        <tr>
            <td align="center">
                <%if(!FrameOnly && !IsMobile()) { %>
                <div class="loginbox" style="width: 90%; max-width: 760px; padding: 0px!important;">
                    <%}else {%>
                    <div style="width: 100%; padding: 0px; background-color: white;">
                        <%}%>
                        <asp:Panel ID="NormalPanel" runat="server">

                            <table width="100%" align="center" id="LoginTabelParent">
                                <tr>
                                    <td align="center">
                                        <div style="height: 470px; border: 0px; padding: 0px;" id="outbox">
                                            <table width="100%" style="margin-top: 0px;" border="0">

                                                <%if(!FrameOnly) { %>
                                                <tr>
                                                    <td align="left" style="font-size: 20px; height: 48px; padding-left: 0px; padding-bottom: 0px; <%if (!IsMobile()){ %>   
                                                        border-bottom: 0px solid #dddddd 
                                                    <%} %>"
                                                        valign="middle"
                                                        colspan="3">
                                                        <span class="sectextcolor" style="padding: 8px; padding-left: 10px; padding-right: 18px;">

                                                            <asp:Localize meta:resourcekey="str_invti" runat="server"
                                                                Text="File Upload Invitation"></asp:Localize>
                                                        </span>


                                                    </td>
                                                </tr>
                                                <%} %>



                                                <tr>
                                                    <td class="style8" align='center' colspan="3">
                                                        <%if (!string.IsNullOrEmpty(ErrorMessage.Text))
          { %>
                                                        <asp:Label ID="ErrorMessage" runat="server" CssClass="errmsg" meta:resourcekey="ErrorMessageResource1"></asp:Label>
                                                        <% } %>
                                                    </td>
                                                </tr>




                                                <asp:Panel ID="PasswordPanel" runat="server" DefaultButton="Button2" meta:resourcekey="PasswordPanelResource1">
                                                    <tr>
                                                        <td colspan="4" align="center" style="padding-bottom: 5px; padding: 10px; padding-top: 60px;">
                                                            <table>
                                                                <tr align="center">
                                                                    <td style="font-size: 14px; padding: 5px; padding-bottom: 15px;">
                                                                        <asp:Localize meta:resourcekey="str_pwdhint" runat="server"
                                                                            Text="The link you are trying to access is password protected, please enter the password below:"></asp:Localize>
                                                                    </td>
                                                                </tr>
                                                                <tr>
                                                                    <td align="center">
                                                                        <asp:TextBox ID="Password" runat="server" TextMode="Password" meta:resourcekey="PasswordResource1" Width="100%"
                                                                            CssClass="form-control"></asp:TextBox>
                                                                    </td>
                                                                </tr>
                                                                <tr>
                                                                    <td align="right" style="padding: 0px; padding-top: 40px;">
                                                                        <asp:Button ID="Button2" runat="server" OnClick="ClickOpen"
                                                                            Text="Continue" CssClass="btn btn-primary gladbtn" Width="168px"
                                                                            meta:resourcekey="Button2Resource1" />
                                                                    </td>
                                                                </tr>
                                                            </table>
                                                        </td>
                                                    </tr>

                                                </asp:Panel>
                                                <asp:Panel ID="InfoPanel" runat="server" DefaultButton="Button2" meta:resourcekey="PasswordPanelResource1">
                                                    <tr>
                                                        <td colspan="4" align="center" style="padding-bottom: 5px; padding: 10px; padding-top: 60px;">
                                                            <table style="width: 600px">
                                                                <tr align="center">
                                                                    <td style="font-size: 14px; padding: 5px; padding-bottom: 25px; color: #565656; font-weight: 100;" colspan="2">
                                                                        <asp:Localize meta:resourcekey="str_infohint" runat="server"
                                                                            Text="Please enter your information below, your information will be used for internal tracking purpose only. It will not be shared with third parties :"></asp:Localize>
                                                                    </td>
                                                                </tr>
                                                                <tr>
                                                                    <td align="center" style="color: #565656; font-weight: 100;">
                                                                        <asp:Localize meta:resourcekey="str_email" runat="server"
                                                                            Text="Email"></asp:Localize>
                                                                    </td>
                                                                    <td width="400px">
                                                                        <asp:TextBox ID="UEmail" runat="server" CssClass="form-control"></asp:TextBox>
                                                                    </td>
                                                                </tr>

                                                                <tr>
                                                                    <td align="center" style="color: #565656; font-weight: 100;">
                                                                        <asp:Localize meta:resourcekey="str_firstname" runat="server"
                                                                            Text="First Name"></asp:Localize>
                                                                    </td>
                                                                    <td>
                                                                        <asp:TextBox ID="UFirstName" runat="server" CssClass="form-control"></asp:TextBox>
                                                                    </td>
                                                                </tr>

                                                                <tr>
                                                                    <td align="center" style="color: #565656; font-weight: 100;">
                                                                        <asp:Localize meta:resourcekey="str_lastname" runat="server"
                                                                            Text="Last Name"></asp:Localize>
                                                                    </td>
                                                                    <td>
                                                                        <asp:TextBox ID="ULastName" runat="server" CssClass="form-control"></asp:TextBox>
                                                                    </td>
                                                                </tr>
                                                                <tr>
                                                                    <td align="center" style="color: #565656; font-weight: 100;">
                                                                        <asp:Localize meta:resourcekey="str_company" runat="server"
                                                                            Text="Company"></asp:Localize>
                                                                    </td>
                                                                    <td>
                                                                        <asp:TextBox ID="UCompany" runat="server" CssClass="form-control"></asp:TextBox>
                                                                    </td>
                                                                </tr>
                                                                <tr>

                                                                    <td align="right" style="padding: 0px; padding-top: 40px;" colspan="2">
                                                                        <asp:Button ID="Button1" runat="server" OnClick="ClickOpen"
                                                                            Text="Continue" CssClass="btn btn-primary gladbtn" Width="168px"
                                                                            meta:resourcekey="Button2Resource1" />
                                                                    </td>
                                                                </tr>
                                                            </table>
                                                        </td>
                                                    </tr>
                                                </asp:Panel>
                                                <asp:Panel ID="NoPwdPanel" runat="server" meta:resourcekey="NoPwdPanelResource1">
                                                    <%if (!FrameOnly)
                                                    { %>
                                                    <tr>
                                                        <td colspan="3" align="right" style="vertical-align: bottom; height: 10px;"></td>
                                                    </tr>
                                                    <%} %>
                                                    <tr>
                                                        <td colspan="4" align="center" style="padding: 15px;">
                                                            
                                                            <table width="100%" id="adv_upload">
                                                                <tr>
                                                                    <td height="340px" valign="top" style="overflow: auto; padding-bottom: 5px;">
                                                                        <div class="" style="height: 330px; border-radius: 3px; padding: 2px; border: 1px solid #eeeeee; overflow: auto" id="subtaskpanel" ondrop="drop(event)" ondragover="allowDrop(event)" ondragleave="onLeve(event)">
                                                                        </div>
                                                                    </td>
                                                                </tr>
                                                                <tr>
                                                                    <td align="right" style="border-top: 0px solid #c0c0c0;">
                                                                        <table width="100%">
                                                                            <tr>
                                                                                <td style="">

                                                                                    <div style="position: absolute; padding-left: 80px; font-size: 16px; font-weight: 100; color: #565656; top: 280px" id="hint">
                                                                                        <%if (!IsMobile())
                                                                                        { %>
                                                                                        <asp:Localize meta:resourcekey="str_hint" runat="server">Drag & drop files to the above box area, or click the "SELECT FILES" button</asp:Localize>
                                                                                        <%} %>
                                                                                    </div>

                                                                                </td>
                                                                                <td align="right">
                                                                                    <button class="btn btn-primary gladbtn" onclick="CloseUI();return false;" id="btnCloseUI">
                                                                                        <asp:Localize meta:resourcekey="str_close" runat="server">Close</asp:Localize></button>
                                                                                    <button class="btn btn-primary gladbtn" onclick="SelectFiles();return false;" id="btn1">
                                                                                        <asp:Localize meta:resourcekey="str_selfile" runat="server">Select Files</asp:Localize></button>
                                                                                    <button class="btn btn-primary gladbtn" onclick="OnContinueProcessTaskQueue();return false;" id="btn2" style="display: none;">
                                                                                        <asp:Localize meta:resourcekey="str_up" runat="server">Upload</asp:Localize></button>
                                                                                    <button class="btn btn-default" onclick="Restart();return false;" id="btn3" style="display: none;">
                                                                                        <asp:Localize meta:resourcekey="str_rs" runat="server">Restart</asp:Localize></button>
                                                                                    <button class="btn btn-default" onclick="OnClose();return false;" style="display:none;">
                                                                                        <asp:Localize meta:resourcekey="str_close" runat="server">Close</asp:Localize></button>
                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </td>
                                                                </tr>
                                                            </table>
                                                        </td>
                                                    </tr>
                                                </asp:Panel>


                                            </table>
                                        </div>
                                    </td>
                                </tr>
                            </table>
                        </asp:Panel>

                        <asp:Panel ID="Expired" runat="server" Visible="False">
                            <table width="100%">
                                <tr>
                                    <td style="border-bottom: 1px solid #c0c0c0; padding-left: 10px;">
                                        <h1 style="color: #565656;"><%=StrReqFile.Text%></h1>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div style="padding: 20px; height: 300px; padding-top: 100px;">
                                            <div class="alert alert-danger">
                                                <h4>Link is no longer valid: <asp:Label ID="BadReason" runat="server" Text=""></asp:Label></h4>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td style="border-top: 1px solid #f0f0f0; color: #808080; font-size: 16px; padding: 5px;" align="right"><%=TenantName%></td>
                                </tr>
                            </table>


                        </asp:Panel>
                    </div>
            </td>
        </tr>
    </table>



    <%if (!FrameOnly)
        { %>
    <table style="position: absolute; top: 10px; right: 10px;">
        <tr>
            <td height="38" align="center" style="color: white; font-size: 10px;"
                class="iconviewitemcolor1"></td>
        </tr>
    </table>
    <div style="position: absolute; right: 20px; bottom: 10px;">
        <span style="color: white"></span>
    </div>
    <%}%>
    <div style="display: none;">
        <asp:Label ID="LabelReceiver" runat="server" Text="Label"></asp:Label>
        <asp:Localize meta:resourcekey="str_reqfile" runat="server" ID="StrReqFile" Visible="false"
            Text="Request a File"></asp:Localize>
        <asp:Localize meta:resourcekey="str_nomatch" runat="server" ID="PwdNoMatch" Visible="false"
            Text="Password Not Match"></asp:Localize>
    </div>



    <% if (!MustLogin && PasswordPanel.Visible)
        { %>
    <script type="text/javascript">
        document.body.onkeypress = function () {
            var chCode = ('charCode' in event) ? event.charCode : event.keyCode;
            if (chCode == 13) {
                var r = document.getElementById("MainContent_Button2");
                r.click();
            }
            
        }
    </script>
    <% } %>

    <script type="text/javascript">

        function RemoveTaskItemFromQ(tid) {
            var temp = [];
            try {
                while (true) {
                    var t = gTaskQueue.shift();
                    if (t == null || t === undefined) {
                        break;
                    }
                    if (t[1] == tid) {
                        
                        continue;
                    }

                    temp.push(t);
                }

                gTaskQueue = temp;
            } catch (ex) {

            }
        }

        function RemoveTaskItemFromFailedQ(tid) {
            var temp = [];
            var task = null;

            
            if (gFailedTaskQueue == null || gFailedTaskQueue.length == 0)
                return;
            
            try {
                while (true) {
                    var t = gFailedTaskQueue.shift();
                    if (t == null || t === undefined) {
                        break;
                    }
                    if (t[1] == tid) {
                        continue;
                    }

                    temp.push(t);
                }

                gFailedTaskQueue = temp;
            } catch (ex) {

            }
        }
        function GetShortString(src, MaxLen) {
            if (src.length <= MaxLen)
                return src;
            var len = (MaxLen - 3) / 2;
            var p1 = src.substring(0, len);
            var p2 = src.substring(src.length - len);
            return p1 + "..." + p2;

        }
        function DeleteFailedTaskItem(tid) {
            var temp = [];
            var task = null;


            if (gFailedTaskQueue == null || gFailedTaskQueue.length == 0)
                return;
            try {
                while (true) {
                    var t = gFailedTaskQueue.shift();
                    if (t == null || t === undefined) {
                        break;
                    }
                    if (t[1] == tid) {
                        task = t;
                        var pa = document.getElementById("subtaskpanel");
                        var ee = document.getElementById(t[1]);
                        pa.removeChild(ee);
                        if (t[2] == "PUT")
                            gTotalBytes -= t[4].size;
                        --gTotalTaskCount;
                        

                        continue;
                    }

                    temp.push(t);
                }

                gFailedTaskQueue = temp;
            } catch (ex) {

            }

            if (task == null)
                return false;
            
            return true;
        }
        function DeleteTaskItem(tid) {
            var temp = [];
            var task = null;

            try {

                
                if (gCurrentTaskItem != null && gCurrentTaskItem[1] == tid) {
                    var t = gCurrentTaskItem;
                    try {
                        if (t[8] == OutstandingReq) {
                            OutstandingReq.abort();
                        }
                    } catch (eee) {

                    }
                    if (t[2] == "PUT")
                        gTotalBytes -= t[4].size;
                    var pa = document.getElementById("subtaskpanel");
                    var ee = document.getElementById(t[1]);
                    pa.removeChild(ee);
                    --gTotalTaskCount;
                    RemoveTaskItemFromQ(tid);
                    RemoveTaskItemFromFailedQ(tid);
                    

                    

                    return;
                }
            } catch (ex1) {

            }
            
            if (DeleteFailedTaskItem(tid))
                return;
            
            if (gTaskQueue == null || gTaskQueue.length == 0) {                
                return;
            }
            try {
                while (true) {
                    var t = gTaskQueue.shift();
                    if (t == null || t === undefined) {
                        break;
                    }
                    if (t[1] == tid) {
                        task = t;
                        try {
                            if (t[8] == OutstandingReq) {
                                OutstandingReq.abort();
                            }
                        } catch (eee) {

                        }
                        if (t[2] == "PUT")
                            gTotalBytes -= t[4].size;

                        var pa = document.getElementById("subtaskpanel");
                        var ee = document.getElementById(t[1]);
                        pa.removeChild(ee);
                        --gTotalTaskCount;                        
                        continue;
                    }

                    temp.push(t);
                }

                gTaskQueue = temp;
            } catch (ex) {

            }
            

        }

        function GetNextTaskId() {
            return "taskitem_" + (gNextTaskId++);
        }

        function AddTaskItem(TaskItem) {
            var e1 = document.getElementById("hint");
            e1.style.display = "none";

            var pa = document.getElementById("subtaskpanel");
            var taskdiv = document.createElement("div");
            taskdiv.style.borderBottom = "1px solid #f0f0f0";
            taskdiv.style.padding = '5px';
            taskdiv.style.paddingTop = '15px';
            taskdiv.id = TaskItem[1];
            taskdiv.className = "fileTask";

            var tb = document.createElement("table");
            tb.style.width = "100%";
            var tr = document.createElement("tr");
            var td = document.createElement("td");
            //icon
            td.style.width = "32px";
            td.style.height = "32px";
            td.valign = "center";

            var suffix = 'fileunknown';
            if (TaskItem[2] == "PUT") {
                var lasti = TaskItem[5].lastIndexOf('.');
                if (lasti > 0) {
                    var str = TaskItem[5].substr(lasti);
                    if (G_SuffixMap.containsKey(str.toLowerCase())) {
                        suffix = G_SuffixMap.get(str.toLowerCase());
                    }
                }
            } else {
                suffix = "filefolder";
            }

            td.innerHTML = "<img class='" + suffix + "' src='/portal/s.gif' width='64px' height='48px' />";
            tr.appendChild(td);

            //task content
            td = document.createElement("td");

            var ctb = document.createElement("table");
            ctb.style.width = "100%";

            var ctr = document.createElement("tr");
            ctb.appendChild(ctr);

            //task name
            var ctd = document.createElement("td");
            ctd.style.fontSize = "10px";
            if (TaskItem[2] == "PUT")
                ctd.innerHTML = "Upload";
            else if (TaskItem[2] == "MKCOL")
                ctd.innerHTML = "Create Folder";
            ctr.appendChild(ctd);

            //file name
            ctr = document.createElement("tr");
            ctb.appendChild(ctr);
            ctd = document.createElement("td");
            ctd.className = "fileName";
            ctr.appendChild(ctd);
            if (TaskItem[2] == "PUT")
                ctd.innerHTML = TaskItem[5];
            else
                ctd.innerHTML = TaskItem[3];

            //progressbar
            ctr = document.createElement("tr");
            ctb.appendChild(ctr);
            ctd = document.createElement("td");
            ctr.appendChild(ctd);
            ctd.id = TaskItem[1] + "_prog";


            td.appendChild(ctb);
            tr.appendChild(td);

            //action btn
            td = document.createElement("td");
            td.style.width = "32px";
            td.valign = "center";
            td.innerHTML = "<span style='display:none;' onclick='DeleteTaskItem(\"" + TaskItem[1] + "\")'>X</span>";
            td.id = TaskItem[1] + "_action";
            tr.appendChild(td);

            tb.appendChild(tr);

            ctr = document.createElement("tr");
            ctb.appendChild(ctr);
            ctd = document.createElement("td");
            ctr.appendChild(ctd);
            ctd.style.fontSize = "10px";
            ctd.className = "fileStatus";
            ctd.id = TaskItem[1] + "_progtext";

            taskdiv.appendChild(tb);



            pa.appendChild(taskdiv);


            TaskItem[0] = Ext.create('Ext.ProgressBar', {
                height: 3,
                width: '90%',
                text: "Uploading...",
                cls: 'roundbar',
                border: 0,
                renderTo: TaskItem[1] + "_prog"

            });
            
            TaskItem[0].getEl().child(".x-progress-bar", true).style.backgroundColor = "rgb(62,198,198)";
            
            if (TaskItem[2] == "PUT")
                gTotalBytes += TaskItem[4].size;
            
            ++gTotalTaskCount;
            
            gTaskQueue.push(TaskItem);


        }

        function getNewFileName(n) {
            return n;
        }

        function AddFilesToTaskQ(Files) {
            
            UploadingIndex   = 0;
            CompleteBytes = 0;
            TotalBytes = 0;
            StopUploading = false;
            gFailedTaskQueue = [];

            UploadingCount = Files.length;
            if (UploadingCount == 0) {
                return;
            }

            for (var i = 0; i < Files.length; ++i) {
                var newFileName;
                var file = Files[i];

                if (file.fname != undefined && file.fname != null) {
                    newFileName = getNewFileName(file.fname);

                } else if (file.webkitRelativePath != undefined && file.webkitRelativePath != null && file.webkitRelativePath != "") {
                    newFileName = getNewFileName(file.webkitRelativePath);

                } else {
                    newFileName = getNewFileName(file.name);
                }

                if (newFileName == null || newFileName == undefined)
                    continue;

                if (file.size == 0) {
                    alert("empty file ignore:" + newFileName);
                    continue;
                }

                
                
                

                TotalBytes += file.size;

                var oldSize = 0;
                var cdir = "<%=UploadFolder %>";
                if (newFileName.indexOf("/") == 0) {
                    cdir = cdir + newFileName;
                } else {
                    cdir = cdir  +"/" + newFileName;
                }
                
                if (gGenerateUniqueFileNames) {
                    //example: "Documents/CentreStack_API_Documentation_10_1b.pdf"
                    const lastDotIndex = cdir.lastIndexOf(".");
                    if (lastDotIndex > -1) {
                        const baseName = cdir.slice(0, lastDotIndex);
                        const fileExtension = cdir.slice(lastDotIndex);
                        cdir = baseName + "_" + getUnixTicks() + fileExtension;
                    }
                    //example: "Documents/CentreStack_API_Documentation_10_1b_638286456851234567.pdf"
                }

                var TaskItem = [];
                TaskItem[0] = ""; //status
                TaskItem[1] = GetNextTaskId();
                TaskItem[2] = "PUT";
                TaskItem[3] = cdir; 
                TaskItem[4] = file;
                TaskItem[5] = newFileName;
                TaskItem[6] = oldSize;
                TaskItem[7] = "/";
                TaskItem[8] = null;
                TaskItem[9] = 0;
                
                AddTaskItem(TaskItem);

            }

        }
        function getUnixTicks() {
            const unixMillis = Date.now();
            const ticks = unixMillis * 10000 + 621355968000000000;
            return ticks;
        }
        function detectBrowser() {
            var N = navigator.appName, ua = navigator.userAgent, tem;
            var M = ua.match(/(opera|chrome|safari|firefox|msie)\/?\s*(\.?\d+(\.\d+)*)/i);
            if (M && (tem = ua.match(/version\/([\.\d]+)/i)) != null) M[2] = tem[1];
            M = M ? [M[1], M[2]] : [N, navigator.appVersion, '-?'];
            return M;
        }
        function ChangeSelectFilesLinkText(linkText) {
            var e = document.getElementById("btn1");
            e.innerText = linkText;
        }
        function CloseTask() {
            //var e = document.getElementById("btn1");
            //e.style.display = "none";

            e = document.getElementById("btn2");
            e.style.display = "none";

            e = document.getElementById("btn3");
            e.style.display = "";

            e = document.getElementById("btnCloseUI");
            e.style.display = "";

        }

        function Restart() {

            var e1 = document.getElementById("hint");
            e1.style.display = "";

            var e = document.getElementById("btn1");
            e.style.display = "";
            ChangeSelectFilesLinkText("SELECT FILES");

            e = document.getElementById("btn2");
            e.style.display = "none";

            e = document.getElementById("btn3");
            e.style.display = "none";
            
            e = document.getElementById("btnCloseUI");
            e.style.display = "";

            UploadingIndex = 0;
            CompleteBytes = 0;
            TotalBytes = 0;
            StopUploading = 0;
            UploadingCount =0;
            gNextTaskId = 1;
            
            gTotalTaskCount = 0;
            gTaskQueue = [];
            gTotalBytes = 0;
            gCurrentTaskItem = null;
            OutstandingReq = null;
            gFailedTaskQueue = [];

            var pa = document.getElementById("subtaskpanel");
            pa.innerHTML = "";
        }

        function FormatFileSize(size) {
            if (size < 1024) { //pow(2,10)
                return size + " bytes";
            } else if (size < 1048576) { //pow(2,20)
                return (Math.round(((size * 10) / 1024)) / 10) + " KB";
            } else if (size < 1073741824) { //pow(2,30)
                return (Math.round(((size * 10) / 1048576)) / 10) + " MB";
            } else if (size < 1099511627776) { //pow(2,40)
                return (Math.round(((size * 100) / 1073741824)) / 100) + " GB";
            } else if (size < 1125899906842624) { //pow(2,50)
                return (Math.round(((size * 100) / 1099511627776)) / 100) + " TB";
            } else { //pow(2,60)
                return (Math.round(((size * 100) / 1125899906842624)) / 100) + " PB";
            }
        }

        function OnTaskStatusChange(TaskItem, Completed, Total) {
            try {
                if (Total != 0) {
                    TaskItem[0].updateProgress(Completed * 1.0 / Total, "");

                    var ee = document.getElementById(TaskItem[1] + "_progtext");
                    ee.innerHTML = FormatFileSize(Completed) + "/" + FormatFileSize(Total);
                }
            } catch (e) {

            }

        }

        function OnTaskAborted(TaskItem) {
            var ee = document.getElementById(TaskItem[1] + "_progtext");
            ee.style.fontSize = "10px";
            ee.style.color = "#008000";
            ee.innerHTML = "<span>" + reason + "</span> &nbsp;&nbsp;<a href='#' style='display:none;' onclick='RetryTask(\"" + TaskItem[1] + "\");return false;'>" + "Retry" + "</a>";

        }

        function OnTaskFailed(TaskItem, reason) {

            



            var ee = document.getElementById(TaskItem[1] + "_progtext");
            ee.style.fontSize = "10px";
            ee.style.color = "#008000";
            ee.innerHTML = "<span>" + reason + "</span> &nbsp;&nbsp;<a href='#' style='display:none;' onclick='RetryTask(\"" + TaskItem[1] + "\");return false;'>" + "Retry" + "</a>";

            
            gFailedTaskQueue.push(TaskItem);
            OnContinueProcessTaskQueue();
        }

        function utf8Encode(s) {
            var f = s;
            try {
                s = s.replace(/\r\n/g, "\n");

                var utftext = "";
                for (var n = 0; n < s.length; n++) {
                    var c = s.charCodeAt(n);
                    if (c < 128) {
                        utftext += String.fromCharCode(c);
                    }
                    else if ((c > 127) && (c < 2048)) {
                        utftext += String.fromCharCode((c >> 6) | 192);
                        utftext += String.fromCharCode((c & 63) | 128);
                    }
                    else {
                        utftext += String.fromCharCode((c >> 12) | 224);
                        utftext += String.fromCharCode(((c >> 6) & 63) | 128);
                        utftext += String.fromCharCode((c & 63) | 128);
                    }
                }
            } catch (e) {
                utftext = f;

            }
            return utftext;
        }

        function HandlePutFile(TaskItem) {
     
    
    
            var file = TaskItem[4];
    
            if (file.size > 20 * 1024 * 1024) {
                SessionUploadFile(TaskItem);
                return;
            }
    
            UploadFileInSinglePart(TaskItem);

            

        }
        
        function CompleteSessionUpload(TaskItem, x)
        {
            var file = TaskItem[4];
            var Total = file.size;;

            var newFileName = TaskItem[5];
            var oldSize = TaskItem[6];
            var altpath = TaskItem[3];

            TaskItem[8] = null;
            TaskItem[9] = 0;


            var url = "/storage/u.svc/enduploadsession";

            Ext.Ajax.request({
                url: url, //todo refactor to a file
                success: function (response) {
                    var x = Ext.decode(response.responseText);
                    if (x === null || x === undefined) {
                        OnTaskFailed(TaskItem, "Failed to commit");
                        return;
                    }

                    if (!x.Success) {
                        OnTaskFailed(TaskItem, x.Reason);
                        return;
                    }

                    OnTaskCompleted(TaskItem);
                },
                failure: function (response) {
                    OnTaskFailed(TaskItem, "Failed to commit");
                },
                method: 'POST',
                xmlData: "<?xml version='1.0' encoding='utf-8' ?><EndUploadSession  xmlns=\"http://tempuri.org/\"><SessionId>"+x.SessionId+"</SessionId></EndUploadSession>",
                headers: {
                    'x-glad-token': "<%=UploaTicket %>",
                    'x-glad-origin': 'WebUploader',
                    "x-glad-sctx": x.SessionContext,
                    'x-glad-hostid': "File Request (<%=UFirstName.Text%> <%=ULastName.Text%> <%=UCompany.Text%>)",
                    'x-glad-requser': "<%=UEmail.Text%>"

                }
            });
        }

        function escapeXml(unsafe) {
            return unsafe.replace(/[<>&'"]/g, function (c) {
                switch (c) {
                    case '<': return '&lt;';
                    case '>': return '&gt;';
                    case '&': return '&amp;';
                    case '\'': return '&apos;';
                    case '"': return '&quot;';
                }
            });
        }
        var gchunksize = 8 *1024*1024;
        function SessionUploadFileParts(TaskItem, x, offset) {
            var file = TaskItem[4];
            var Total = file.size;;
            var Length = Total - offset;
            var ChunkSize = gchunksize;

            
            if (x.ChunkSize) {
                ChunkSize = x.ChunkSize;
        
            }
            if (Length > ChunkSize)
                Length = ChunkSize;


            var xhr = new XMLHttpRequest();
            OutstandingReq = xhr;
            TaskItem[8] = xhr;

            xhr.onloadend = function (e) {
                if (xhr.status > 300) {
                    var Reason;

                    if (xhr.status == 403)
                        Reason = "Access Denied:" + file.name;
                    else if (xhr.status == 422)
                        Reason = file.name + "," + "Virus detected";
                    else
                        Reason = "Failed to upload:" + file.name;
                    if (TaskItem[9] < 3) {
                        TaskItem[9] = TaskItem[9] + 1;
                        SessionUploadFileParts(TaskItem, x, offset);
                    } else {
                        OnTaskFailed(TaskItem, Reason);
                    }
                    return;
                }
                TaskItem[9] = 0;
                offset = offset + Length;
                x.SessionContext = xhr.responseText;
                if (offset == Total) {
                    CompleteSessionUpload(TaskItem, x);
                } else {
                    SessionUploadFileParts(TaskItem, x, offset);
                }
        
            };

            try {
                xhr.upload.onprogress = function (oEvent) {
                    try {
                        var total = oEvent.totalSize || oEvent.total;
                        var done = oEvent.position || oEvent.loaded;
                        if (oEvent !== undefined && oEvent !== null && total > 0) {
                            OnTaskStatusChange(TaskItem, done + offset, Total);
                        }
                    } catch (eeee) {

                    }


                };

                xhr.onerror = function (e) {
                    if (TaskItem[9] < 3) {
                        TaskItem[9] = TaskItem[9] + 1;
                        SessionUploadFileParts(TaskItem, x, offset);
                    } else {
                        OnTaskFailed(TaskItem, "Failed to upload");
                    }
                    return;

                };
                xhr.onabort = function (e) {
                    OnTaskAborted(TaskItem);
                    return;
                };
                xhr.onload = function (e) {
                    return;
                };


            } catch (e) {

            }

            xhr.open('PUT', "/storage/part.up", true);
            //xhr.setRequestHeader("Content-Length", "" + Length);
            xhr.setRequestHeader("x-glad-offset", "" + offset);
            xhr.setRequestHeader("x-glad-sessionid", x.SessionId);
            if (x.SessionContext)
                xhr.setRequestHeader("x-glad-sctx", x.SessionContext);
            xhr.setRequestHeader("Content-Type", "application/octet-stream");


            var blob = file.slice(offset, offset + Length);
            xhr.send(blob);
        }

        function SessionUploadFile(TaskItem)
        {
            var file = TaskItem[4];
            var Total = file.size;;

            var newFileName = TaskItem[5];
            var oldSize = TaskItem[6];
            var altpath = TaskItem[3];

            TaskItem[8] = null;
            TaskItem[9] = 0;

    
    
            //new FileReader(); use file reader later
            OnTaskStatusChange(TaskItem, 0, file.size);
    
            var url = "/storage/u.svc/beginuploadsession";

            var lu = "";
            if (file.lastModifiedDate != null && file.lastModifiedDate != undefined) {
                lu = file.lastModifiedDate.toUTCString();
            }
    

            Ext.Ajax.request({
                url: url, //todo refactor to a file
                success: function (response) {
                    var x = Ext.decode(response.responseText);
                    if (x === null || x === undefined) {                
                        UploadFileInSinglePart(TaskItem);
                        
                        //OnTaskFailed(TaskItem, "failed to begin upload session: null response");
                        return;
                    }

                    if (!x.Success) {                
                        UploadFileInSinglePart(TaskItem);
                        
                        //OnTaskFailed(TaskItem, "failed to begin upload session:"+x.Reason);
                        return;
                    }
                    
                    SessionUploadFileParts(TaskItem, x, 0);
                },
                failure: function (response) {            
                    UploadFileInSinglePart(TaskItem);
                    
                    //OnTaskFailed(TaskItem, "failed to begin upload session");
                },
                method: 'POST',
                xmlData: "<?xml version='1.0' encoding='utf-8' ?><BeginUploadSession  xmlns=\"http://tempuri.org/\"><Path>" + escapeXml(altpath) + "</Path><Size>" + Total + "</Size><OrigSize>" + oldSize + "</OrigSize><LastModified>" + lu + "</LastModified></BeginUploadSession>",
                headers: {            
                    'x-glad-token':  "<%=UploaTicket %>",
                    'x-glad-origin': 'WebUploader',
                    'x-glad-hostid': "File Request (<%=UFirstName.Text%> <%=ULastName.Text%> <%=UCompany.Text%>)",
                    'x-glad-requser': "<%=UEmail.Text%>"


                }
            });
        }

        function UploadFileInSinglePart(TaskItem) {


            var fileReader;
            var file = TaskItem[4];
            var Total = file.size; ;

            var newFileName = TaskItem[5];
            var oldSize = TaskItem[6];
            var altpath = TaskItem[3];

            if (file.size > 1500 * 1024 * 1024) {
                OnTaskFailed(TaskItem, "File is larger than 1.5GB");
                return;                
            }
            //new FileReader(); use file reader later
            OnTaskStatusChange(TaskItem, 0, file.size);

            var xhr = new XMLHttpRequest();
            OutstandingReq = xhr;
            TaskItem[8] = xhr;

            xhr.onloadend = function (e) {

                if (xhr.status > 300) {
                    var Reason;

                    if (xhr.status == 403)
                        Reason = "No permission to upload:" + file.name;
                    else if (xhr.status == 422)
                        Reason = file.name + ", virus detected" ;
                    else
                        Reason = "Unable to upload:" + file.name;
                    OnTaskFailed(TaskItem, Reason);
                    return;
                }

                OnTaskCompleted(TaskItem);

            };

            try {
                xhr.upload.onprogress = function (oEvent) {
                    try {
                        var total = oEvent.totalSize || oEvent.total;
                        var done = oEvent.position || oEvent.loaded;
                        if (oEvent !== undefined && oEvent !== null && total > 0) {
                            OnTaskStatusChange(TaskItem, done, total);
                        }
                    } catch (eeee) {

                    }


                };

                xhr.onerror = function (e) {
                    OnTaskFailed(TaskItem, "Failed");
                    return;

                };
                xhr.onabort = function (e) {
                    OnTaskAborted(TaskItem);
                    return;
                };
                xhr.onload = function (e) {
                    return;
                };


            } catch (e) {

            }

            xhr.open('PUT', "/storage/proxiedupload.up", true);
            //xhr.setRequestHeader("Content-Length", "" + Total);

            while (altpath.indexOf("+") != -1)
                altpath = altpath.replace('+', '|');

            xhr.setRequestHeader("Content-Type", "application/octet-stream");
            xhr.setRequestHeader("x-glad-token", "<%=UploaTicket %>");
            try {
                xhr.setRequestHeader("x-glad-altpath", altpath);
            } catch (e) {
                altpath = utf8Encode(altpath);
                xhr.setRequestHeader("x-glad-altpath", altpath);
            }

            
            xhr.setRequestHeader("x-glad-requser",   "<%=UEmail.Text%>");
            xhr.setRequestHeader("x-glad-hostid",   "File Request (<%=UFirstName.Text%> <%=ULastName.Text%> <%=UCompany.Text%>)");




            xhr.send(file);
            return;

        }


        function OnContinueProcessTaskQueue() {
            

            var e = null;//document.getElementById("btn1");
            //e.style.display = "none";
            ChangeSelectFilesLinkText("ADD MORE FILES");

            e = document.getElementById("btn2");
            e.style.display = "none";

            e = document.getElementById("btn3");
            e.style.display = "none";
            e = document.getElementById("btnCloseUI");
            e.style.display = "";

            var t = gTaskQueue.shift();
            if (t == null || t === undefined) {                
                CloseTask();      
                sendEmailIfDone();          
                return;
            }

            gCurrentTaskItem = t;
            if (t[2] == "PUT") {
                HandlePutFile(t);
            } else if (t[2] == "MKCOL") {
               
            }
        }
        function sendEmailIfDone(){
            var uploadedFilesArr = [];
            $(".fileTask").each(function(){
                var status = $(this).find(".fileStatus");
                var filename = $(this).find(".fileName");
                if(status.length==1 && filename.length==1){
                    if(status[0].innerText=="Done"){
                        uploadedFilesArr.push(filename[0].innerText);
                    }
                }
            });
            if(uploadedFilesArr.length>0){
                var xhr = new XMLHttpRequest();
                xhr.open('POST', 'ReqFile.aspx');
                xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
                xhr.onload = function() {
                    if (xhr.status !== 200) {
                        alert('Post to itself failed: ' + xhr.status);
                    }
                };
                var userData = $("#<%=hidCollectedInfo.ClientID%>").val();
                xhr.send(encodeURI("id=<%=m_reqID%>&filestable=" + uploadedFilesArr.join("\n") + "&usrfrmdta=" + userData));
            }
        }

        function OnTaskCompleted(TaskItem) {
            try {
                
                var ee = document.getElementById(TaskItem[1] + "_prog");
                ee.style.fontSize = "10px";
                ee.style.color = "#008000";
                ee.style.display = "none";
                ee = document.getElementById(TaskItem[1] + "_progtext");
                ee.innerHTML = "Done";
                
                ee = document.getElementById(TaskItem[1] + "_action");
                ee.innerHTML = "";
            } catch (e) {

            }
            OnContinueProcessTaskQueue();
        }

        function onFileSelected() {
            gTotalTaskCount = 0;
            AddFilesToTaskQ(FileSelector.files);
            
            if (gTotalTaskCount > 0) {
                var e = document.getElementById("btn2");
                e.style.display = "";
                e = document.getElementById("btn3");
                e.style.display = "";
                e = document.getElementById("btnCloseUI");
                e.style.display = "";
                
                //e = document.getElementById("btn1");
                //e.style.display = "none";
                ChangeSelectFilesLinkText("ADD MORE FILES");
            }
        }

        function OnClose() {
            window.location = "/portal/loginpage.aspx";
        }
        function SelectFiles() {
            FileSelector = document.createElement('input');
            FileSelector.setAttribute('type', 'file');
            FileSelector.setAttribute('multiple', 'multiple');
            FileSelector.onchange = onFileSelected;

            try {
                var bs = detectBrowser();
                if (bs.indexOf("Chrome") == -1 && bs.indexOf("Firefox") == -1) {
                    document.body.appendChild(FileSelector);
                } else {
                }
            } catch (e) {
                alert(e);
            }

            FileSelector.click();
        }


        var str = [];
        var pending = 0;
        var files = [];

        function ConvertFileObject() {
            var fobj = str.pop();
            if (fobj) {
                try {
                    var fullpath = fobj.fullPath;
                    fobj.file(function (f) {
                        if (fullpath) {
                            Object.defineProperty(f, 'fname', {
                                value: fullpath,
                                writable: false,
                            });
                            Object.defineProperty(f, 'webkitRelativePath', {
                                value: fullpath,
                                writable: false,
                            });
                        }
                        files.push(f);
                        var tmp = new Array();
                        tmp.push(f);
                        AddFilesToTaskQ(tmp); 
                        ConvertFileObject();
                    });

                }catch(ex){
                    console.log("ConvertFileObject handled ex:", ex);
                }
            } else {
                
                if (gTotalTaskCount > 0) {
                    var e = document.getElementById("btn2");
                    e.style.display = "";
                    e = document.getElementById("btn3");
                    e.style.display = "";
                    e = document.getElementById("btnCloseUI");
                    e.style.display = "";

                    //e = document.getElementById("btn1");
                    //e.style.display = "none";
                    ChangeSelectFilesLinkText("ADD MORE FILES");
                }
            } 
        }
        function AvdHTML5Handler(dt) {


            try {
                var items = dt.items;

                if (items == null || items == undefined)
                    return false;
                str = [];
                pending = 0;
                files = [];



                for (var i = 0; i < items.length; i++) {


                    var item = items[i].webkitGetAsEntry();
                    if (item) {

                        if (item.isDirectory) {
                            traverseDirectory(item, ConvertFileObject);
                        }
                        else if (item.isFile) {
                            if (item.fullPath) {
                                Object.defineProperty(item, 'fname', {
                                  value: item.fullPath,
                                  writable: false,
                                });
                                Object.defineProperty(item, 'webkitRelativePath', {
                                  value: item.fullPath,
                                  writable: false,
                                });
                            }
                            str.push(item);

                        }

                    }
                }

                if (pending == 0) {
                    ConvertFileObject();
                }
            } catch (e) {
                alert(e.message);
                return false;
            }

            return true;
        }
        
       function traverseDirectory(item, callback) {
            var dirReader = item.createReader();
            var readEntries = function() {
                dirReader.readEntries(function(results) {
                    for (var i = 0; i < results.length; i++) {
                        var entry = results[i];
                        if (entry.isFile) {
                            if (entry.fullPath) {
                                Object.defineProperty(entry, 'fname', {
                                    value: entry.fullPath,
                                    writable: false,
                                });
                                Object.defineProperty(entry, 'webkitRelativePath', {
                                    value: entry.fullPath,
                                    writable: false,
                                });
                            }
                            str.push(entry);
                            callback();
                        } else if (entry.isDirectory) {
                            
                            traverseDirectory(entry, callback);
                        }
                    }
                    readEntries(); // Continue reading more entries
                }, function(error) {
                    console.error('Read entries error:', error);
                    callback();
                });
            };
            readEntries();
        }

        function OnDragDropped(dt) {

            if (AvdHTML5Handler(dt))
                return;

            AddFilesToTaskQ(dt.files);
            if (gTotalTaskCount > 0) {
                var e = document.getElementById("btn2");
                e.style.display = "";
                e = document.getElementById("btn3");
                e.style.display = "";
                e = document.getElementById("btnCloseUI");
                e.style.display = "";

                //e = document.getElementById("btn1");
                //e.style.display = "none";
                ChangeSelectFilesLinkText("ADD MORE FILES");
            }
        }


        G_SuffixMap.add(".png", "filepic");
        G_SuffixMap.add(".gif", "filepic");
        G_SuffixMap.add(".bmp", "filepic");
        G_SuffixMap.add(".jpg", "filepic");
        G_SuffixMap.add(".jpeg", "filepic");
        G_SuffixMap.add(".tiff", "filepic");
        G_SuffixMap.add(".tif", "filepic");
        G_SuffixMap.add(".cr2", "filepic");
        G_SuffixMap.add(".nef", "filepic");
        G_SuffixMap.add(".raf", "filepic");

        G_SuffixMap.add(".aac", "filemusic");
        G_SuffixMap.add(".mid", "filemusic");
        G_SuffixMap.add(".mp3", "filemusic");
        G_SuffixMap.add(".mpa", "filemusic");
        G_SuffixMap.add(".wav", "filemusic");
        G_SuffixMap.add(".wma", "filemusic");
        G_SuffixMap.add(".ra", "filemusic");
        G_SuffixMap.add(".aif", "filemusic");
        G_SuffixMap.add(".m4a", "filemusic");


        G_SuffixMap.add(".asf", "filemovie");
        G_SuffixMap.add(".avi", "filemovie");
        G_SuffixMap.add(".flv", "filemovie");
        G_SuffixMap.add(".mov", "filemovie");
        G_SuffixMap.add(".mp4", "filemovie");
        G_SuffixMap.add(".mpg", "filemovie");
        G_SuffixMap.add(".mpeg", "filemovie");
        G_SuffixMap.add(".rm", "filemovie");
        G_SuffixMap.add(".swf", "filemovie");
        G_SuffixMap.add(".wmv", "filemovie");
        G_SuffixMap.add(".divx", "filemovie");
        G_SuffixMap.add(".3gp", "filemovie");
        G_SuffixMap.add(".m4v", "filemovie");
        G_SuffixMap.add(".mp2", "filemovie");
        G_SuffixMap.add(".m4b", "filemovie");

        G_SuffixMap.add(".doc", "filedoc");
        G_SuffixMap.add(".docx", "filedoc");


        G_SuffixMap.add(".htm", "filehtm");
        G_SuffixMap.add(".html", "filehtm");
        G_SuffixMap.add(".asp", "filehtm");
        G_SuffixMap.add(".aspx", "filehtm");
        G_SuffixMap.add(".jsp", "filehtm");
        G_SuffixMap.add(".xhtml", "filehtm");

        G_SuffixMap.add(".txt", "filetext");
        G_SuffixMap.add(".log", "filetext");

        G_SuffixMap.add(".xls", "filexls");
        G_SuffixMap.add(".xlsx", "filexls");

        G_SuffixMap.add(".pdf", "filepdf");
        G_SuffixMap.add(".pptx", "fileppt");
        G_SuffixMap.add(".ppt", "fileppt");
        G_SuffixMap.add(".pps", "fileppt");

        G_SuffixMap.add(".dll", "filedll");
        G_SuffixMap.add(".drv", "filedll");
        G_SuffixMap.add(".sys", "filedll");

        G_SuffixMap.add(".exe", "fileexe");

        G_SuffixMap.add(".zip", "filezip");
        G_SuffixMap.add(".rar", "filezip");
        G_SuffixMap.add(".7z", "filezip");
        G_SuffixMap.add(".gz", "filezip");
        G_SuffixMap.add(".gzip", "filezip");
        G_SuffixMap.add(".zipx", "filezip");
        G_SuffixMap.add(".sitx", "filezip");
        G_SuffixMap.add(".sit", "filezip");
        G_SuffixMap.add(".tgz", "filezip");

        G_SuffixMap.add(".jar", "filejar");
        G_SuffixMap.add(".tar", "filejar");
        G_SuffixMap.add(".apk", "filejar");
        G_SuffixMap.add(".ipa", "filejar");
        G_SuffixMap.add(".pkg", "filejar");
        G_SuffixMap.add(".cab", "filejar");
        G_SuffixMap.add(".deb", "filejar");
        G_SuffixMap.add(".rpm", "filejar");

        G_SuffixMap.add(".cer", "filecert");
        G_SuffixMap.add(".csr", "filecert");
        G_SuffixMap.add(".p12", "filecert");
        G_SuffixMap.add(".pfx", "filecert");
        G_SuffixMap.add(".der", "filecert");
        G_SuffixMap.add(".keystore", "filecert");
        G_SuffixMap.add(".keychain", "filecert");

        G_SuffixMap.add(".csv", "filecsv");

        G_SuffixMap.add(".eml", "filemail");
        G_SuffixMap.add(".msg", "filemail");
        G_SuffixMap.add(".pst", "filemail");

        G_SuffixMap.add(".rtf", "filegendocs");
        G_SuffixMap.add(".pages", "filepage");
        G_SuffixMap.add(".numbers", "filenumber");
        G_SuffixMap.add(".tex", "filegendocs");
        G_SuffixMap.add(".wpd", "filegendocs");
        G_SuffixMap.add(".wps", "filegendocs");
        G_SuffixMap.add(".qxd", "filegendocs");
        G_SuffixMap.add(".ico", "filegendocs");
        G_SuffixMap.add(".icns", "filegendocs");
        G_SuffixMap.add(".key", "filekeynote");



        G_SuffixMap.add(".java", "filejava");
        G_SuffixMap.add(".class", "filejava");

        G_SuffixMap.add(".xml", "filexml");
        G_SuffixMap.add(".config", "filexml");

        G_SuffixMap.add(".msi", "filemsi");
        G_SuffixMap.add(".msu", "filemsi");

        G_SuffixMap.add(".bin", "filebin");
        G_SuffixMap.add(".dat", "filebin");
        G_SuffixMap.add(".dmp", "filebin");
        G_SuffixMap.add(".hqx", "filebin");

        G_SuffixMap.add(".bat", "filecmd");
        G_SuffixMap.add(".cmd", "filecmd");
        G_SuffixMap.add(".sh", "filecmd");

        G_SuffixMap.add(".psd", "filepsd");
        G_SuffixMap.add(".eps", "fileeps");
        G_SuffixMap.add(".ps", "fileeps");

        G_SuffixMap.add(".ai", "fileai");

        G_SuffixMap.add(".iso", "filedisk");
        G_SuffixMap.add(".dmg", "filedisk");

        G_SuffixMap.add(".pub", "filepub");

        G_SuffixMap.add(".dwg", "filecad");

        G_SuffixMap.add(".qbb", "fileqbook");
        G_SuffixMap.add(".qbw", "fileqbook");
        G_SuffixMap.add(".iif", "fileqbook");

        G_SuffixMap.add(".indd", "fileindd");

        G_SuffixMap.add(".swf", "fileflash");
        G_SuffixMap.add(".flv", "fileflash");
        G_SuffixMap.add(".fla", "fileflash");

        G_SuffixMap.add(".c", "filec");

        G_SuffixMap.add(".chm", "filechm");
        G_SuffixMap.add(".cpp", "filecpp");
        G_SuffixMap.add(".cs", "filecsharp");
        G_SuffixMap.add(".h", "fileheader");
        G_SuffixMap.add(".js", "filejs");
        G_SuffixMap.add(".lnk", "filelnk");

        G_SuffixMap.add(".mdb", "filemdb");
        G_SuffixMap.add(".accdb", "filemdb");

        G_SuffixMap.add(".m", "fileobjc");
        G_SuffixMap.add(".odp", "fileodp");
        G_SuffixMap.add(".ods", "fileods");
        G_SuffixMap.add(".odt", "fileodt");
        G_SuffixMap.add(".php", "filephp");
        G_SuffixMap.add(".py", "filepython");
        G_SuffixMap.add(".vb", "filevb");

        G_SuffixMap.add(".vcd", "filevcd");

        G_SuffixMap.add(".fnt", "filefont");
        G_SuffixMap.add(".fon", "filefont");
        G_SuffixMap.add(".otf", "filefont");
        G_SuffixMap.add(".ttf", "filefont");
        G_SuffixMap.add(".cur", "filefont");

        G_SuffixMap.add(".pl", "filecode");
        G_SuffixMap.add(".rss", "filecode");
        G_SuffixMap.add(".sql", "filecode");
        G_SuffixMap.add(".swift", "filecode");

        G_SuffixMap.add(".vsd", "filevisio");
        G_SuffixMap.add(".vsdx", "filevisio");

        G_SuffixMap.add(".xps", "filexps");
        G_SuffixMap.add(".skp", "filesketch");
        G_SuffixMap.add(".odg", "fileodg");
        G_SuffixMap.add(".odf", "fileodf");

        function SetupUploadPanel() {
            var ie8 = false;

            try {
                var bs = detectBrowser();
                
                if (bs[0].indexOf("MSIE") != -1 && (bs[1].indexOf("8") == 0 || bs[1].indexOf("9") == 0)) {
                    ie8 = true;
                } else {
                }
            } catch (e) {

            }

            

            if (!ie8 && FileReader !== undefined && FileReader !== null) {
            } else {
                var e = document.getElementById("basic_upload");
                e.style.display = "";

                e = document.getElementById("adv_upload");
                e.style.display = "none";
            }


            try {
                if (FileReader !== undefined && FileReader !== null) {
                    var e = document.getElementById("hint");
                    e.style.display = "";
                } else {
             
                }
            } catch (e) {
                dd = false;
            }
        }

        SetupUploadPanel();
        <%if (FrameOnly)
        { %>
        var ee = document.getElementById("outbox");
        ee.style.height = (document.documentElement.offsetHeight-25)+"px";
        
        ee = document.getElementById("subtaskpanel");
        ee.style.height = (document.documentElement.offsetHeight-105)+"px";
        
        <%}
        else
        {%>
        function OnResize(){
            var ee = document.getElementById("TopPadding");
            var height = Math.floor((document.documentElement.offsetHeight-500)/2);
            if(!ee) return;
            if(height < 0){
                ee.style.height = "0px";
            }else{
                ee.style.height = height +"px";
            }

        }

        function setFocuse()
        {
            try{
                var ee = document.getElementById("MainContent_Password");
                ee.focus();
            }catch(eee){

            }
        }
        setTimeout(function(){
            setFocuse();   
        },200);
        
        OnResize();
        <%}%>
    </script>
</asp:Content>
