﻿<%@ Page Title="Gladinet Cloud - Pending Purged Folders" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="PendingPurgedVerFolder.aspx.cs" Inherits="GladinetPayFlow.PendingPurgedVerFolder"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
        .titlecol
        {
            background-color: #f0f0f0;
            font-size: 14px;
        }
    </style>
    <script type="text/javascript">




        function ClearErrorMsg() {

            var d = document.getElementById("errmsgdiv");
            if (d) {
                d.style.display = 'none';
            }
        }
        setTimeout("ClearErrorMsg()", 30000);



        var ActiveWin;
        var MainWnd;
        function closeActiveWin() {


            window.location = window.location;

        }

        function closeCancelActiveWin() {
            ActiveWin.close();
        }

        function gEncodeUri(str) {
            var s = encodeURI(str).replace(/&/g, '%26').replace(/#/g, '|').replace('+', ':');
            while (true) {
                var i = s.indexOf('+');
                if (i == -1)
                    break;
                s = s.replace('+', ':');
            }

            return s;

        }

        function OpenFile(file) {
            var f = document.getElementById('rightpanel');
            f.src = "File.aspx?f=" + gEncodeUri(unescape(file));

        }

        function OnWipeDevice(id, name) {
            var ng = document.getElementById("MainContent_DeviceId");
            var btn = document.getElementById("MainContent_WipeDevice");
            var nf = document.getElementById("MainContent_FilePath");

            if (confirm("<asp:Localize meta:resourcekey="str_restorhint" runat="server">Restore the deleted versioned folder</asp:Localize>:(" + unescape(name) + ")?")) {
                Wait("<asp:Localize meta:resourcekey="str_restoring" runat="server">Restoring...</asp:Localize>");
            ng.value = id;
            nf.value = name;
            btn.click();
            }
        }

        function OnDeleteDevice(id, name) {
            var ng = document.getElementById("MainContent_DeviceId");
            var btn = document.getElementById("MainContent_DeleteDevice");

            if (confirm("<asp:Localize meta:resourcekey="str_deldev" runat="server">Do you really want to delete the device entry</asp:Localize> (" + unescape(name) + ")?")) {
                Wait("<asp:Localize meta:resourcekey="str_delentry" runat="server">Wiping...</asp:Localize>");
                ng.value = id;
                btn.click();
            }
        }

        
    function OnAgentAttachedFolders(id, name) {
        Wait("Please wait");
        window.location = "/management/DeviceAttachedFolders.aspx?f=c&id=" + id + "&name=" + name;
    }

    function OnAgentTasks(id, name) {
        Wait("Please wait");
        window.location = "/management/DeviceTasks.aspx?f=c&id=" + id + "&name=" + name;
    }

    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
<asp:Localize runat="server" ID="LocNoFolSel" meta:resourcekey="str_noFolSel" Visible="false">No folder selected</asp:Localize>
<asp:Localize runat="server" ID="LocFaiToRes" meta:resourcekey="str_faiToRes" Visible="false">Failed to restore</asp:Localize>
<asp:Localize runat="server" ID="LocFaiToVerTheFol" meta:resourcekey="str_faiToVerTheFol" Visible="false">Failed to verify the folder</asp:Localize>
<asp:Localize runat="server" ID="LocFolWitTheSamNamAlrExi" meta:resourcekey="str_folWitTheSamNamAlrExi" Visible="false">Folder/file with the same name already exists</asp:Localize>
    <asp:Localize ID="LocVsnFldToPrg" meta:resourcekey="str_vsnFldToPrg" runat="server" Visible="false">Versioned Folder(s) to be purged</asp:Localize>
    <div 
        <%if (IsChildUi) { %>
        style="width:100%;border-bottom:1px solid #eeeeee"
        <%}else { %>
        class=" meubardrop"
        <%} %>
        >
        <table width="100%">
            <tr>
                <td style="padding-left:10px;">
                    <asp:Label ID="ResultCount" runat="server" meta:resourcekey="ResultCountResource1" CssClass="badge"></asp:Label>
                </td>
                <td>
                    <b>
                                    <asp:Label ID="ErrorMsg" runat="server" Style="color: Red;" meta:resourcekey="ErrorMsgResource1"></asp:Label></b>
                </td>
                <td align="right">
                     <asp:Button ID="Button1" runat="server" Text="Refresh" OnClick="Button1_Click"  CssClass="btn btn-primary gladbtn"
                                             meta:resourcekey="asp_rfs" />
                </td>
            </tr>
        </table>
    </div>
   
    <table width="100%" style="padding: 2px; background-color: white; margin: 0px; margin-top: 20px" cellspacing="0" id="grid-table"
                    cellpadding="0">
                   
                    
                    <tr>
                        <td colspan="3" style="vertical-align: top;" id="result_div">
                        </td>
                    </tr>
                   
                </table>
    
    <div style="display: none;">
        <asp:HiddenField ID="InstanceId" runat="server" />
    <asp:Localize meta:resourcekey="str_daysgao" ID="StrDaysAgo" runat="server" Visible="False"> Days ago</asp:Localize>
    <asp:Localize meta:resourcekey="str_hoursago" ID="StrHoursAgo" runat="server" Visible="False"> Hours ago</asp:Localize>
    <asp:Localize meta:resourcekey="str_minsago" ID="StrMinsAgo" runat="server" Visible="False"> Minutes ago</asp:Localize>
    <asp:Localize meta:resourcekey="str_lessmin" ID="StrLessMin" runat="server" Visible="False">Less than 1 minute ago</asp:Localize>

    </div>
    <asp:HiddenField ID="DeviceId" runat="server" />
    <asp:HiddenField ID="FilePath" runat="server" />
    <div style="display: none;">
        <asp:Button ID="WipeDevice" runat="server" OnClick="WipeDevice_Click" />
        <asp:Button ID="DeleteDevice" runat="server" OnClick="DeleteDevice_Click" />
    </div>
    <script type="text/javascript">    
var myData = [
 <asp:Repeater ID="PubsRepeater" runat="server" enableviewstate="false" >
        <ItemTemplate>         
        <%#(Container.ItemIndex == 0)? "": "," %>      ['<%#(((RepeaterItem)Container).ItemIndex+1) %>',        
        '<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem,"OwnerName").ToString().Replace("'","%27")) %>',
        '<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem,"FilePath").ToString().Replace("'","%27")) %>',
        '<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem,"OwnerId").ToString().Replace("'","%27")) %>'
         ] 
        </ItemTemplate>
    </asp:Repeater>      
    ];
    </script>
    <script type="text/javascript">

        function OnChange(id) {
          
            var idc = document.getElementById("MainContent_InstanceId");
            var db = document.getElementById("MainContent_DenyBtn");
            var ab = document.getElementById("MainContent_AllowBtn");
            idc.value = id;

            var e = document.getElementById(id);
            if (e.checked) {
              
                ab.click();
            } else {
          
                db.click();
            }

        }

        var grid;
      
        function AdjustGridTable () {
           
            var h = 400;
          
            try {

                var myTable = Ext.get('grid-table');
           
                var tableY = myTable.getY();
           
                h = document.body.offsetHeight-tableY-60;
           
                var ee = document.getElementById('tinfo');
                ee.style.height = h + "px";

            } catch (err) {
            }
            grid.setWidth(document.documentElement.clientWidth - 2);
            grid.setHeight(h);
            grid.doComponentLayout();

            var e = document.getElementById("result_div");
            e.style.height = h + "px";

        }

        Ext.require([
            'Ext.grid.*',
            'Ext.data.*',
            'Ext.util.*',
            'Ext.state.*'
        ]);
        Ext.onReady(function () {

            Ext.QuickTips.init();

            var store = Ext.create('Ext.data.ArrayStore', {
                fields: [
                    { name: 'index' },
                    { name: 'owner' },
                    { name: 'filepath' },
                    { name: 'oid' }
                ],
                data: myData
            });


            grid = Ext.create('Ext.grid.Panel', {
                store: store,
                stripeRows: true,
                border: true,
                columnLines: true,
                minHeight: 208,              
                minButtonWidth: 28,
                viewConfig: {
                    emptyText: "<asp:Localize meta:resourcekey="str_no_folder" runat="server">No pending purged folders were found</asp:Localize>",
                    deferEmptyText: false
                },
          
                columns: [
                    {
                        text: '',
                        width: 50,
                        sortable: false,
                        hideable: false,
                        dataIndex: 'index',
                        getClass: function (v, meta, rec) {
                            return 'x-col-hide';
                        }
                    },
                    {
                        text: "<asp:Localize meta:resourcekey="str_fowner" runat="server">Folder Owner</asp:Localize>",                      
                        width:178,
                        sortable: true,
                        dataIndex: 'owner',
                        renderer: function (value, metaData, record, rowIndex) {
                            return unescape(value);
                        }

                    },
                    {
                        text: "<asp:Localize meta:resourcekey="str_fname" runat="server">Folder Name</asp:Localize>",
                        flex: 1,
                        minWidth: 175,
                        sortable: true,
                        dataIndex: 'filepath',
                        renderer: function (value, metaData, record, rowIndex) {
                            return unescape(value);
                        }
                    }, {
                        xtype: 'actioncolumn',
                        width: 110,
                        hideable: false,
                        items:
                        [
                            {
                                icon: 'images/restore.png', // Use a URL in the icon config
                                tooltip: "<asp:Localize meta:resourcekey="str_restore" runat="server">Restore</asp:Localize>",
                              width: 30,
                              handler: function(grid, rowIndex, colIndex) {
                                  var rec = grid.getStore().getAt(rowIndex);
                                  var d = rec.data;

                                  OnWipeDevice(d.oid, d.filepath);
                              },
                              getClass: function(v, meta, rec) {
                                 
                           
                              }
                          }
                  ]
              }
                  ],
              renderTo: 'result_div'
          });

          //Ext.EventManager.onWindowResize(grid.doLayout, grid);
           AdjustGridTable ();
             
             Ext.EventManager.onWindowResize(AdjustGridTable);     
      });
    </script>
</asp:Content>
