var _presentation_editor_themes = [];

_presentation_editor_themes[0] = {
    Name: "pixel",
    Url: "/theme1/",
    Thumbnail: "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEcAAAAoCAMAAACbzBeiAAAABGdBTUEAALGPC/xhBQAAAMBQTFRFmOCTQ1nWj7/TdiU++xcZWWMsnZ8a/4CAAQTj5ciV4H9pxOdQ4HqaV2Z4trzE6LY1htyt3VqHMUPvAAC/IaxsmKKtBAve/exXRb+LdYCT+dVm8fL054pfsjJ/AIM7xwUw5khM+7bBEzHWCqhe3t8A/eGf1djdXtaVITRK0wcMExP/Rl7x/dhJQVJmLy//7+8A8icz/+5/AKJK/hn/S6zFziFPeH/7//lALb50ALBQ/u0s/gEB//4CAAD/DyQ+////gX379gAAAatJREFUSMft1ttSwjAUhWFGBTnYVpEIJZ6FGoEoKCAI7Lz/W7lXeqDDjBcNNzryXWDE9p8klDGlNXylZrBisxtWv2Yj1n1gtQVbwjMMYMNeofTbOm34ZLbzAvdsdscCNCasi4saT2yR6jyy5pA1oYTLbGcUBMFuB+/32QSDuNNhWWc4Z2gNc50yUcW90wVcFhBROeuMbQdLxd/bGNhOK7W7rgtWx15XiCc0GzPs8wkGwRvrAQaNd3YLGLQuWRX7XL1i246iSpmO9+70SPUqRM4dkwgpNEaRb9ykHakoQkzHv/ra0yp06AhbiAg1zpBAVBTv6PgmTXYSHnI+eYU7mIhkgpTEfDyJ93ThTkiZZDFRqB06inRMxTdHnhc5zMePl2NH8dYIp3V52y1V9jlSxqUjafv8hTw1SW4dYe/LPjmBSUXCIyVEoU7y1Jhkjdr4ihtSUVj4OdwhI4kXs2/H+Xt66PyhzsYyH5ax/8KXZmWZqWXsMWD9TzuH5+fnzjzhT7b6Z+yU4WeN9VPnOUfznFJ6Ugxz5812/rSJw2aQnjXTo2aHD5rT5KA5wO3f+3BfEST7FDcAAAAASUVORK5CYII="
};

_presentation_editor_themes[1] = {
    Name: "classic",
    Url: "/theme2/",
    Thumbnail: "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEcAAAAoCAMAAACbzBeiAAAABGdBTUEAALGPC/xhBQAAAMBQTFRFn39aiHltoJCAaFpWrJyGuqaMeWtiZlhV3dXB9vPquqaB6uTXlyEJrreV0L5A1oYthzYkiH9s+vfyw7GRxrST49rH7eLL8Ovfd2hf6t/K8+/j1capx7aW7OTR5d7K8Ora2Mqt6d3Fy7ue7+fU5tnA0MKnwK2K4tW/2s+46OHP49nD3M2yzLua08Sm0cGkz7+jybia59zC4dO408Wr4NS81ses2c2z28+11smw2cuwzr6g///+3tK65Ni+4tW83tC3GGjdVwAAB5NJREFUSMd1VmmXqkoS5M293Wo721WBiwiyyr4XVRTU8v//1QTtmw/vnJmyQeyjUZGZkVlhfGG99nW7Xm+v2+txvd0eeKhv1/6BD/VaP+q6r9dbX0dtva4rrr6uH/3j9bpeP75eO8KX8Xp9vg6//++qH4ePun51f/xof35+/v7E+r3ff++v9zq8fnzj7LC3vu/XqO36aL26bruuTVvXNe5u06xuMFVt0PMmqKq5CwIepPPSNU3btG30APnD67XjgHzUr23ftEE3903QuEHqBu4YNKlbVSvljZ5dPgajS7XQVcDGmfKKzwufsEv6+H24Xo2dTR9h63rmpAk4QDj25RXDV8eqSoNZBfOouR6ZlEJrUpGR6WbKlykI5rTdOfVX4+vr2vePtenc+7aZ89hwPlVV11ZjpdQi9DgCQTFN9awWMglGEiWU5IRpl800cLsu6uudzwMladuGb9t24th9RxjHXJORyhGcpJrx21EyWQopF0mUdKUii6YLaC9B2nZ1D5zbjtI0xfbcNjmOiqej1lqNKpEDUWqQIqFDomWYKJloPUhJM4KHXOtKc55OMxgZN5SqA5B72Ux7s0fNVJLg++MgB5kMMsQDsBRwrCQUg9Tf8EKmSqR0YsE8r6iv8brWa9e5c7ltzNwuml1HVQmdICuSUDWoIQebwZfaUhLsclkqycgwKkI0W2kwu223PoxX3bfrNQ3ApV22rUD4AwktOQyVlZR55phZlg2lmXllmIUWy1SYyU5mUoxkHCmlc9p33brH1aV1S7ctY6O9XaTOwjIpLqfLdldW6Je+4xS+5zumFYbDsSyHpVwS5PGoBUF6gmluIF8DIqyb2fURkh4RXDLQ0fG2OBxOm22aZenHRWGWZqi82HJ8rRMrIXIoFRl1qtmCuNBzN6Ovb3t6TtuZ6ZFcNjsJlThtXmmdt4sXFwLX04+fvu8VjlV6YSmHHDcpBFQ102p253aNjK91bZt5DwtlWc77exI+L5ZTxtvl6T3vcezHJ68onk8EVyI6p0zIwLQSehlZtde96Xuj7+turiCd/64zQR5CK0aCLnFsmbETx/YTKLF/DE0rK0tZLhXKD0UykVcc7brWBsredvO2Xd4LD9CcFV9OHuKKfdt+gsnpXNj+s/D8InYsZ5BZOeziQNeyRSO7PyPjcVhXZHlLNVVcDfG2lSGBtjPrCRz7CaD7835/FvcYgXmxUw7+UEooXlI0nhYTd9c/aqP++ulWd9RYq0QlQm7bPXO2TTlP4DwLO7/b99P9fvcRW4zS5YVvldJJZKZIkuuFIrA2Wo3H2rpoUZ/lKmfVIO1tI/m2Oc4ROSvu5/sZbE5noNn32Cs8x3eGshSCYBIJtrBqTtf2x8Po148GVaILYVIMweBtm22BlI88b6cTqNjn0/mSHW3b8yAhE/kZx1DLQSA7OqdpOh9+AefHzxmq0SP+TUQmB5SJgNR2B/rlbp/su/m82zbybEICll9kvhiyhLEMc0QsjE5z26xGfT2sEyZFhdm0oNPDcpBj1tHp9fXR375eH+liRMfrx8fr9fHxMXVRDAWZocUlBDRRzeZg6v7WGegNF4+Ye1RLRomV5az0j5aTHZFVlMo+I88F0gMJmYXpOZlvSTIp/q3pirEgbSLE1TZdt89MDZmj14WGNJTlQCtDUZyfRyCh7OezXcTnp1kcPWGWIiEEf2wiOeNL0DSdUTdRU02aVdhilIMOVciHIXT8rDjGXvyMz/enfX9CgcXRLArLcpiPzifhQCRT+bLQmU9tZKDbW84pHamgC8MAnuTeioPnmB7oxPut8M97yePYC/OwCB1hhgkRQ56JJaeMBmkEPl2aRpyzhaJifJwwjoGylKXlQCoxeKDf8eaXpnlEejw55Uk5LjJHgXOKYT/vE3HnE3BUT4tcEApJK6UyDGjLISV+hWFRFMc95bFjmqEfmtkw4cQop1LLjCyCVSxN9/x07Rw0fHI7miPVvB1xoCQKoYWJWYZOVqI9EeSRej7JSmQmw4lB8pJCbYrkfJpQ+NWI6nb69/di//pe+T+/1/Dre5l//17kH98L50QSZolgR0Xl3uwLGmyZpr2/6q574/A3jn7jZG+c7I0zvHEEZh0XOAoykYlcUaF5Pk2Y9KvRP9rmjaPfOPSNQ944+i84qJBSOa0yUYoU9aXLwvkyYUKDz/onTve/+Ii/xIXuhviyURAiKKJCsaYF52mDuYrBkU4YsnAhu8OYONOCqlwoShRTBNrP96OqzPNcow80YzQXXLM8X3JwQXZAJzJufRR1zY408RmWhUONkCUT4yIynSvYHpWwGdodRQ7N0J6jsFWVT8u8LDsOBhBwro9HBKS1SdN1btw5nYJ5j3mBeaEMjoEp0NRsXCBVBhtU7a0w8QkY++YTfMuhx7l8+/Wzj+Dn6h7n2epGiLLnAWbAvFQLr2ApoHyeAnyGXYNWlm5uU2zbzlObdmn38XmIdt/ybVAfj/qxM1vrLurqdqcGcu7cRDCS86/Pw+FvGMBNN69wFTAYbb92CKdbIzhLGFvjT9f7bRPhNx89fMy1hsWFGematcOsc9M2avG09njVPawlfDAuZLbeMW7Xx+0/1I7KC+vsEo4AAAAASUVORK5CYII="
};

_presentation_editor_themes[2] = {
    Name: "official",
    Url: "/theme3/",
    Thumbnail: "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEcAAAAoCAMAAACbzBeiAAAABGdBTUEAALGPC/xhBQAAAMBQTFRFe31/paankpKTycnKtra3m5uccHBxvb/B3d7fQEBAX19f2trcSkpLsLCwampq8vLz2ODqg4OE7e3u0dPV2+Pq6+/0MzMzVlZW6e705Orx6u/19/j7+vv8+fr7/f3++/z99vf65uzy7fH18PP28/X44efu3eTt2ODq2eLr/f3+LS0tk6rEytXjDAwMqbvRJiYnCAgI8vX4AwMDGBgY4efv5erx3OPsCKHZ+WobfJhKwq2NUG6UeXt+AAAA2ODqj6bC0NC7CQAAACp0Uk5T/Pv9/Pz8/fn7/v76/vz9+/v9+/r5/v7++Pf2+Pr5+/r3+Pf39/j6/vz7BS7D5QAAAu5JREFUSMel1td22kAQBmCMCb1XIa16d0IASZDGKO//VpnZlTDYUbH5fY5sX+g7s7NF20jvcqakqU9JC/L3f2ncM0mSuK7nefhYLpfTaeB/yvE807Ic28HYliVvUXtPVTrTpWsZCtM1is5Uw+HUW6nCCRadjqFr4Ws0pjq2bLpeENR3pm4PYBTeR2MKrym4LanM8ZfuIDrAMHwbHUfHS/LrOP5ya8+gvYu67yFm2NYdVOwQo+6htYFLWF1RsTN1LaUDMRtBrGZvz5v94XA80gRk30KFTuDJjt6HcchieBLM0w54euq12ddZK3L8YGupkx08h2EbepxZRHAZTAaNCL5kBd20qMihctgX2NP7AAtyxrDh3gb6NPtiRXrZ7Bc6rmywNczoxTWODtNtDbgz4x4NzJa2eUEFDg3LWEC0mGNmsJtk0zRoNfvxq/Pa6SLHQ6cN11BHwufhgf6+caQqJ0DHjmG/5olhjW+OIog3s9FcjItWUHU95DzBIRtOC3DetBj6jP5rk6NxR9TjlzjY5yFsso2uIxG62bRh2ze0MxScL9FnP/32vbDPLi6XkZ4t5Asc5hOxbnC6cOeKciwzm6+vxY7XgNhhGTQAaOK6OYybszX04AUZJWtPpbOHsaPkUA9X5GQc4Wy9jCaHqEujysohp3BcNLCtbDuKensYzp87XWqxqMbCLudtLtlfnmtKtmOo7O5YJYUJRr6WU7bfOYQVGQpK4pTnJ71QciYvp+T8CThkcUllDDEdnyoqWAwN6pYpOw9ziCSMioRCiFAEU+M8TP1ktTK3MpXkOIZhEEKloELF3DGl34sVxpQsSbaoKBH6oqIiiqn3vUiT0ykxTUna4gMp/oPtpVpEMbW+Xxee808e6QeP9IvH+83j/+H5iGMKxxROIJz0A85JOK5w3Eeds3DOwvE/4uR3KHEfO2FWSfGVrMY9ikPIHI/HVfrAvS5NEoSSBJ3jIw4uoxP/fTyeHnSStCp1xkWX3k85/wBlQzU+YfRNpwAAAABJRU5ErkJggg=="
};

_presentation_editor_themes[3] = {
    Name: "green",
    Url: "/theme4/",
    Thumbnail: "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEcAAAAoCAMAAACbzBeiAAAABGdBTUEAALGPC/xhBQAAAMBQTFRFXGRJiYmJGRkZqNlCe6osnJycMDEuJjcA7O7quLi4a2xpOE8Am8Q2FR4AP2cAltMP09PTiLQqQUFBDA4Iqchs5PDIwdmMSHQAb6QNtdZojro4gJ7CnIXA86RH57wpg7UP0JKnpbWSocVdqc1ST34A4O3EVYcAqctgnMNCdLAAfrgBeKsNuNKEaKEBbqgBsM51v9p+YZgByuGXbJkBAAAA1eax+/z4cJ4Ac6EAt9R2XY4AeakAfa4BZpIAdqUA////U3+GngAAA2JJREFUSMel1ml7okgQB3BixnsSHIl47OGuIiKEu5Cz4ft/q63qBoKJk2Um/xc+vpDfU91d0iWt15rm+75t2w7mYr1YP15fPc/crlaBF6hp6h0O1mYXRa573LnH3FKj1DDc6GDFYcgwGUWXNE3TnwVTlpf3zqvruuhYwvm+PeZ77qTkIBQ2EDq6nvFiyktxMRtH3p5OQcqdc+2k5BRvTtJAjDvIZBot6VIUpnC8V684n1a3TnrrnK2kC0k6VcXC/FLEjJGzx3rQoXWlgUrO+cYJGqdMOpJECmMhFjMG0M3Ny4Y7b/uc/tQpbx1U4pjtEwAY55t35/W+HrN19mXZSOQwziSlNYc5QPjx3NOfOXkXklhIjMXYE2hjmN919vt7TiGgmENSrbA1KLkGyq84HKr3CJ2Eb/QYxkWhgKQa5wBjqKtVFEQRflVVwyA18LaBZxwj7Ks0OKlH40cHkmJ+XowBaJk5h2XFM11Ko8HsWn0ar8jzvF6ZJJjwGZ7iZB8CLDgDw6qawcP/OQV3CBJOGD7BPElKcwQz+sUSpoQtezh1QRJfVKgDZHRwM1BoMcPlpKoWPZy2IO6EIbZOk6H40WK27OcIqHYUeOIZDWDElaW06FVP0XHCcI2djEeY56cp3+mpMuy5rrqJagebJyEmP1UD3OmrMqj6Ot16MoB14zyAMpnw3Z7iEq89nLytZw5K3DgLwLZRYLZ4WIIyHPZ2HHSoecrawd4Z4f6A8nAdiGbqtz+OI8f8xdE41RUzWUzo48pTTa4f0nFyvj/0Ypbxz5rcOO+e+cTJ23ouGLnj9M7NeQnnYprJ1xxfQCZG/i1HvIKkzPdbyDS/4GR0uTs19MtO+38nh6532/k9p36z0n3q/8vj/MVT/c1T/cNT/clT/cFz931ITijR9f4FRzBMzAnCsYVjCEcVTiCcrXA+3BfoyPW8gdCNsxHOWTipcHbC2R5lOYi8x0cv2u6xURw79hnzad5Y8wGo3ex6Tkgv53b+ObRzy2Pr0D1I3YLzDj6FD0trDrUSOt/uOzTX3dynXYacuiIhNY7TdTZv86HccRzBkJNJz8/rbkn+J85h93JwrHb+cd6qycgRkKipcVzuuPccNXJrx7ZbhjsEtSW9+Oi4rn04ndQ7jr1BZ7fzosOmo+j6f9+cHOFK6GkgAAAAAElFTkSuQmCC"
};

_presentation_editor_themes[4] = {
    Name: "lines",
    Url: "/theme5/",
    Thumbnail: "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEcAAAAoCAMAAACbzBeiAAAABGdBTUEAALGPC/xhBQAAAMBQTFRFp5d/uqKMlId2xrijGxkVOzUub2NWDg0LUkpA/fXn28q447qGhzYk1oYt0L5AlyEJrreVh35r07CK7N3P27iR9ergAAAA9uW61bih9ejP5tK/7dzA5M2u++K79N+2++TT3b2f79u35cy1+ui/7NGq+ePF5cml3MCp9NS68+HA9OXH+unJ1bKX48Ki9d/M7cqs7NTA8tnF6tW14b2T8c+z+u7U68+58NWt+uDM/e/c6suz//HW5MWu/uvD/u7J/e/OyQ4cIAAABZNJREFUSMdt1ol2qloMBmDrANZzp1alyKDMCJSxQHED8v5vdf9s0Oo6J6u11mU+k4CQ2fv7J4WMX8PwfT+OYyOm8DRLw5+u8zxP07wpNA0vsw6xkQ3kvI8/77PJ8T8/d0jlWYg0TVlRFJ7nWJbjOEXhTIEXC7NmjHWKQbFDAbI8OrIsGxu8Rp/F8NH0/hQZqoq8uqZs1fkewzRVVc3qura2XRcjyZdvjuzj3w1aKJBU46Pp/WVhmmGIvCzjuSbF0TwGQRgEaoaA0yHJp2nA2e1kmorSkZNldWEScy7NIDgc4OT58Yjs4xRBiMjzHA5687y48/3O35FjdHHnKbHnmbKanfGx30fTLJEB53gcnTA4flAcw/AQhgmgHE6KSVqd33W7HRzfwnQzjLZY+jzLxO85cMOqgpAkSA/D4GOMCPohIWjPyhRQTYeOnK+YnC2O0FwS8nzsQOfOnpwG2YeDi0cbP1HEHUD7smSpk8KxrNHB6ZDCcVaSmHHmQ6d6ostF192wsW37ULn2GGCq6kTQ/lyWqeNlXVdvvr5mv746q2PkvCxFaY56Po66butBNDqHk93Difq+J+daVdXQwElQT4lTAo5ijY7GuLN+E6RVoH986BTu3YEwVD0P2x7IOTVNQn2V6beT4YxU4NB8uCOL2kKSFnAIelmtV0vhqEcnIobhOkL93Un25/PosKmeuMaMt6mwdsOVtLZ5OTNpHg2C9Gbbpwuyq9+cJifH+ann1y9yyq23fHHtmSQW5NhraTEMC2mlu6fL9frotC13XHdfnkucsXnJFGXHHZaW6Xa+SnU7WEpvHzTl2VqNqo206qOKO+3w47TDiaCxnu+snPoiB32thJfFYiFIywCO67rRQljdnCtyr/2Vamq5AyaZ+srZg8PShbjmIUkvut67vbxab6ie/nIZRofioZ6GHPSlwlF+6lkLaaq7brOW1lTPizgf2slB/oU7T32NjuPAyerJ8dinaKRpAOdFkgy918Vlf3cGctrrWNDQDsNTPXnNMmU67h0T1mlZYiqNu5QEvdckMapaHK/e/s15qIeuMDlLb/OxcA7Obw4mZPS2KAn+fC2Js/nUF5yenPbZcbhzO3/eltJSMMixBFGSREGfiZI4v6A2fDnQyK2e8Xi1f+wLDqvLLb4tNB+XvtiY51kO29ethlIeHTpy7aW6Oxj0z3w6zMeB8837wnexx+c2GMTr6/WKetpn50LO6cGp0VfMHcamesKmieBENye6DqNDD6NzmZzk3leNOd8cZ5uW37iGk6Ojr6gZKnKiez3EoENyhstUz/lhPl/cYVs6XuGhSTAf/e5cqRQ+n2EK7pweHLW2FCWOJwd91XASOBFGzZ1qqgcdXabvxdjXgMYS7pRjXzSfm5OyEncmOIGNS2HUHB6cWz3jnHEFOo3XsZuT3erhx73GfJKkCW2Cmmhy9typRieK2ooYutCTUxTjfEbH+otH/TeP8B8e0RuP6F8el/94RFHFHX6dP2fnunCyminPTjk6wZ+c6tHhN7Bkj5s4g8MwZ4Mc/9mZ6glHJ3xycFeeGNwHsVSwQsssS7EM48FhT/U8O4e7gwjH+zI5TMP9dIOlB/cdg7YrpWOdqtL9X8WmEQR5khz2FZ4kp5A2BhxLfPGwtdDzaU+oGW1MN2dH2xwcWLTW5LTqqEGuAjoEKv4A225VPGKDMoMwCQNaW/je0mme5fsbn+8bsi/Tc7/DwLKML27mOVNz9bAlcots/sADL6u0RtU17VF+TEX45Hzupr3OjzULUYxRF5mqbgtarShbhc1fN4HQ2obpIp/vdahj2g9pz4Tl06DQcoq+mVXgPE1TjTY9TVEKTaO1UeOYZdHSYxi0sT7smfe9l1a0zsPK65GHNvHEsjRswFb3s/dqGt6FSXzeEsn5H59/wVjgjSJ8AAAAAElFTkSuQmCC"
};

_presentation_editor_themes[5] = {
    Name: "office",
    Url: "/theme6/",
    Thumbnail: "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEcAAAAoCAMAAACbzBeiAAAABGdBTUEAALGPC/xhBQAAAMBQTFRFoLvayNjqa5TGdZzL3+fzX4vC097ut8vkXIe/9Pf7gKTPja3TU4S7VYS9////WIW+qsPf1ODuUYK8WYfA////VoW/VIW/UoK9VIS+U4O+UYO+UYG9T4G9UIK+O2GNLUtuCA4VJT5cOF2IEyAvRG+jMVB1IzlVRXKnHTBIITZPP2eXQWueFyY4DBQeNlmCBgsQS3q0AgUHKURjSXevAAECTX66DxomGyxBgGSi95ZGm7tZS6zGwFBNAAAA////T4G9QT7IqgAAAB50Uk5T+/z6+/z4+vv3/Pv6+Pr99/z9/Pv+/P79/f3+/f7+fHXHHQAAAqpJREFUSMfd1Ol2okAQBWCzuishpJteKsYlxl1E1NlK3v+tprobspw5TmDir7kRDRz8zqUaqaTnSeX/d7az2e4czgJxdQbnJdng4gxOjONN8vJ1Z4mPB+x/2XnE9W5FWz703mSxmK7KOxOcprt1PunnDdoMdyWdaIOzNB3j0O7NE+yPolE/weeSzjMuzfcR52Zvigd79ICTks4eY/cxtffAYJSt4aGcM8dkvqXEuI7ckd1o0JusyzpjfI2dyOxgB13WoYVa7m2ecE/7qwSfDvFqW/i6wDkr3GSXM0Czbk842bmaxRylK9lPND9/R0S6zZaNxl7E0ZD12SY4yA/2qVqU3TcxFvnlgs77xG+/h3SE2KP7ZjPtxXsc2ml9xmiZ9Vni+O34kO7IaJrQai1X0adPACoDkHI49VyNZo8FniGgbBmZyq88n7XU5sVBn+5TZJVovmDK2D5K/ZMCZjBE2DJaQKXVavm6tKK0mw2kUqVSUJ9ut9tqtVWpKqCBFCBCcVAMVAiV2+ZNrdttt3yliyGKFJ5tUoPgKb1Y5XisV5u1Wq3bbvs+6L9P1lyLhaQC2kiRWro+R4o7rfbLxv9hk36zSX/a6O82SgL4BtFSkMa4lqHUQtg+udN0Tts5vnOUc1TmKCmVAslpRowkzqRmoQIm3zmBc7rO4c7hzuG5A1xy5UsmpHkDEIKuSqSNd87ROQ3nPDhHfHB8nxjGrMStpGQY6vtqYJ0PCTq3XuPm5p7yQGmHFBEKLlhIguBcCCa4UiwMQQnG9L1XPx7/dKwV3FablzkVmj8KfZMJAoWgf41EdeCyWg+Opxxn1e+85lWOGY9RpZAY6sSMxK+86447+7Rj0wmC6wuv0mhkEm3UiijRaHp3tkkh57Vbp1O/M/G8C/NB+8GHM4o5n+c3u/xcVJtT6zEAAAAASUVORK5CYII="
};

_presentation_editor_themes[6] = {
    Name: "safari",
    Url: "/theme7/",
    Thumbnail: "data:image/png;base64,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"
};

_presentation_editor_themes[7] = {
    Name: "dotted",
    Url: "/theme8/",
    Thumbnail: "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEcAAAAoCAMAAACbzBeiAAAABGdBTUEAALGPC/xhBQAAAMBQTFRFVYCrPG2fKUhnG0p4EDNXG1WOMWaaLl6NGERwLVV8PWqVRXyyBhAZID5cEiU4AgUIFi9IBQoQQ3+7HVycLGyqDBkneK7kSITAbqbdUo3HO3i1daziWqKuf4+pYZrSSmasnZCgKX/VcanfTonDSIO+I2Kia6PaPHm2aKDYVY/JOHWyGE2DRYG8QX66H1+fUIvFYpzSXpjQW5XOWJHLZZ3VS4bBPnu3NXKwAAAAJWSkMXCuLm2rIWGhK2qoKGemHl6ebuSxuAAAAAF0Uk5T/YPqVscAAARjSURBVEjH7ZTXduM2EIbhXtbqlCWSiZKInaIEsYAAG/D+b7WDAS3bu96L7Dm5y4dzhGn4CQwJkdfX15DWnPMCLCaVUhYYMEv6+loxRvevIzu2ew11HVfZvuZhyEIIhrsszBgj7raFtUputq7rem29yd13tnSziV23Vqp2XamCrevVpetWReXGLXUtmW/aKvfcyiX7feL7RbVHdoWxPNCWMAfwhHK/Z21UgFcVMdphFahj6Le7va4u/PhoFSQuWObnW6By9LIeLKo3yMDIWVLpFPWzahv3SiVbKvtkGxc6nLE4Ue05klWeE30oVYdhWN0dDitZV2CGRbnTU1jyti3DcGlKNp2js1UJvzLIQkfJsFhCZeVVoNOnSayZCvGMRszSLuB61s9YxnG+TH1MJCyPYVsBjeu+hzh4Me3YeQhIVlYGX8zEVDvFoJcPYJVtl9qYLG2dga4FRZX1vTeuqfrByzsVVTY573Asm1sxn4lvYOtdDMtid34fHELOeQfvTV7iVPX+zlHKPtvl7kxyTQHfy4t4nIprdL3cUHJo7REM7KGuoxjfNE2dl5Cz8xJruSSFxpbqRizYs1iU2suio551pVIcLJZGzBRG2tDb84uyrnXIt6LS60k5MheTMlmIh3KD7enKpMQ2t3b5Aa2clXanGqrdzZGWGRzWpiRBvG8z8ZwkEzHl+CE8rufrl8kyrT2TZ13fRDBrnSi5oI+bLAPlJ4TalLWNuhUvg02vhDigjHii9kRc29QMhidk1F4OQ4oRzxpqm+or5aFPqN/pmrW4rT3qrcVcyraeimfqPYupY8khox7FTZ4gfxl6EaceDyTTPiMpPuogxP034FrM4PKypyn8Xok13mDwM7gxwZEhjuwgmeorxC5wcy/UXFx42vh6PM/XRmdAP1r6Jq6Pcjpu9CmkidTRxl9qnabjC/GyRha4mF9N51cPaDbH7BMSXyIYdWQC8HEGUUaOmicxc9Dgj0LcKHUzuz4e77WOVR8NXa96XYNfRXt8J9IBh9SaqZjrKZJqtRBTtZotwAMdHtUjuI2TrmngQGOwlR0UaGVJIs7be+hK5ET4/zMXs7t7sUgjB87lpE6Ew3xVCu00NbFI9/rEnQiEGnIC51YseJqmli69E2IC7Zo/TNZi9jgZrFSDp4F/mE+0bzHemvf1IubwR8/N3tfihd/MxGzSwhFX0ESdMjoWH2m7Vk8nvEEYQR3ZIp2UcjDm8DC03eoOV2MAutJb7YgFAg3M+GCzQuvI7iusk+mJ+jmFmQYMEDpZGCLqJIcvaUaZ5qcMbkOdjD3GSN/IDwTAaKo3HfkjzRcJ0rwT9OZBxhtlgo/5PviQCj6GSX/hrR/KuEbz9EP+9F75Fscw9GccF1ZjZHWxPuVHe6U+xYn6kZX6HVDnjKh/kNWfiPoLUX8g6m/kSwl8MDkARudgdA5G52B0DkbnYHQOv4RojA4xOsToEKNDjA4xOuTX/HQu9W/P9Ys+q9/v8/86/7nOd6tpJotYgU3YAAAAAElFTkSuQmCC"
};

_presentation_editor_themes[8] = {
    Name: "corner",
    Url: "/theme9/",
    Thumbnail: "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEcAAAAoCAMAAACbzBeiAAAABGdBTUEAALGPC/xhBQAAAMBQTFRFsrW4L05yNVmDGCc4J0FgPmiYT4C9yNjq0d7t3OXxmrfYpL3ck7HW5+32uc3ke6DNcZjJiKrSXYzDrsTg7/P5ZI/F9vf6V4jAVIO+UYO+TX+8ToG+ToG9HTBGysrKzc3Np6ennp6eR3SslZWVGhwggoKCh4eHTExMNDQ0KSoqQEBAeHh41dXVurq6srKyXl5eMjIya2tr39/f7+/vCAkKExQWVVZX+/z9S6zGgGSiwFBN95ZGm7tZAAAAT4G9////FmtL4AAAAB10Uk5T/f79/v398/z8/Pr7+v37+/z7+/v9+/78+Pz+/f6Rd1TwAAACKElEQVRIx62WiXLaMBCGaRNuDBh8SJbapNxHMMH46LXo/d+qK8kcbTIUBf0zZkar+T/t7EpClcOlCHfFx1T5i8NDxwaHsqGwwKlxv7DAGVWrDWGB8wAQW+CMIIW5Bc4j5Ckkd3NqGVRyWN/NqUJWxPiV8f14O5/vYmMO+QI7UWTwrMPPKSitCkNOlMJXIdawUtEXgHUSJFOAb2Yc8gmW2v8iozvI1WyOSRpx+ARmcrjQxmSjGzeDrRGHVDGRPWoGWaAnimQz3mZlXrdy+COcpCrylKtCG3IIVnn5qpTBAqMxwCSfxpieEYd/hnSvxxuQfZvAVjV8bch5ONcTEWJftg3LbsKhI4DNMbDG1IKySrh/5gYcrPLpPIgEYCy2kO7G0wWs4PV2To1nl9tthTsy2MluLePg5hsAOZT73pv4/mmTGJ53znqBuFeK0ynscFo2OITTlmeH49rhsF7DTn38YWCBc2D6LhM/lcRvJfFDSXxXEr+UrufD7+AURRF4ntOsyEeP5hQ3c47mZqPe7Q7brY7bU+dUc+r/53iO02yczb1+3/cHYRhSqu8fzlno9zvDbr3peF6AwhVRHsop19VeF70nM6WMsSiK8CvvZ44DOvD7PdfttNrtoVK7jU5p1eteeFnEFSDCBDglpHY4/n/JlBBFaRgOUL70SaO2am/EGFfeSJnJ5VPu/E6gnCuYzJNpX1RaeaTm/vW+y9FpEU2TQPVLrlivcD6uP+N9bqG+bWHuAAAAAElFTkSuQmCC"
};

_presentation_editor_themes[9] = {
    Name: "turtle",
    Url: "/theme6/",
    Thumbnail: "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEcAAAAoCAMAAACbzBeiAAAABGdBTUEAALGPC/xhBQAAAMBQTFRF9vb28vLyY2NjnZ2dISEhLi4u0dHReXl5paWlmZmZHR0dycnJhoaGfX19qKioNTU1wcHBYGBgb29vPj4+JSUlvLy8UFBQFxcXExMTkZGRdHR0W1tbRUVFxMTEVlZWAQEBS0tLsrKyaWlp/f390tLStra2/Pz83Nzc9vb2CgoKBAQE7+/v6enp4uLi8/PzKSkp1tbW2dnZ5ubm7Ozsz8/P+vr639/fm7tZwFBNT4G9gGSiS6zG95ZGAAAAzMzM////gsg65QAAAAJ0Uk5T/v6mqd4QAAACIklEQVRIx93V2XaqMBQGYOhca61aZ6sIiMg8pz3D3nn/tzokKLVWIax6df4LJC74Vtg7BIleJtL/77hpql/CWQEYF3Bi24LVBZw29C2F/NwZwHAJ9z92ujDZqDDOdsPksbcaaWpzpwca3YyhU4weLOB5yxo6vgVPlM7glY/ubNCGC2OmwHVD5xqC/LgGCLOEhEt4Q5YVXDV0XqBd/MzZ/epUzY9m0oZ5MycCJXQc964P1oLPBEM0pr0xjOLYaeDMoMwzQ4YjVmhlwp8v3Ig6eaOC24BlAgFJdNWG1mg2HWpFnQSgwlHBekJMo8jrACClLVimDJjv6h0KOquynnoLriQE6PD7A3gtqkWEHNf+fNOfweoubF4l1GDvoFfvZF4fJvljRXxsKDDL1429vNcCuIXBzsGkxskI4k2xaliD1/gCN7hY2nm7BtOFrRhikJRimTgf7s+7D48Gfk3lOpIOLvQplfF8UknQ2VY7mGZiDq1x0BRy1myTrnQiISeqdYiQw2bt1dZHT0gUx36FE7P9o8qR+cdyP3vP0Y+dXzzxBw++8+BvHvzDg395KPlaL3d7wvHrHfJtjmtve+zQeud0F/2TTtjU4ZvBvs7kc62yD8bxlS77NJ5v5N4plK1ftnPjxJEwg6hzhyuZxzsakqScmeya/D9TrmHyN1zaKYedWB9YkizzTX5budAdKvnHyneLMWmlE/N9lZwrn1muM7OSyRv2D0s/kOUmeyJWAAAAAElFTkSuQmCC"
};