/*
 * (c) Copyright Ascensio System SIA 2010-2015
 *
 * This program is a free software product. You can redistribute it and/or 
 * modify it under the terms of the GNU Affero General Public License (AGPL) 
 * version 3 as published by the Free Software Foundation. In accordance with 
 * Section 7(a) of the GNU AGPL its Section 15 shall be amended to the effect 
 * that Ascensio System SIA expressly excludes the warranty of non-infringement
 * of any third-party rights.
 *
 * This program is distributed WITHOUT ANY WARRANTY; without even the implied 
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR  PURPOSE. For 
 * details, see the GNU AGPL at: http://www.gnu.org/licenses/agpl-3.0.html
 *
 * You can contact Ascensio System SIA at Lubanas st. 125a-25, Riga, Latvia,
 * EU, LV-1021.
 *
 * The  interactive user interfaces in modified source and object code versions
 * of the Program must display Appropriate Legal Notices, as required under 
 * Section 5 of the GNU AGPL version 3.
 *
 * Pursuant to Section 7(b) of the License you must retain the original Product
 * logo when distributing the program. Pursuant to Section 7(e) we decline to
 * grant you any rights under trademark law for use of our trademarks.
 *
 * All the Product's GUI elements, including illustrations and icon sets, as
 * well as technical writing content are licensed under the terms of the
 * Creative Commons Attribution-ShareAlike 4.0 International. See the License
 * terms at http://creativecommons.org/licenses/by-sa/4.0/legalcode
 *
 * Version: 1.0 (build:32)
 */
Ext.define("Common.plugin.GridScrollPane",{extend:"Common.plugin.ScrollPane",alias:"plugin.gridscrollpane",areaSelector:".x-grid-view",settings:{enableKeyboardNavigation:!0,keyboardSpeed:.001},init:function(e){var t=this,n;t.callParent(arguments),n=t.cmp.getStore(),n&&n.on("datachanged",t.updateScrollPane,t,{buffer:10}),t.cmp.on("viewready",t.onViewReady,t,{single:!0})},onKeyDown:function(e,t){var n=this,r=n.cmp.getStore(),i=function(e){var t=n.cmp.getView().getNode(r.getAt(e)),i=Ext.create("Ext.Element",t);if(t){var s=Ext.getDom(n.cmp.getTargetEl())||Ext.getBody().dom,o=i.getOffsetsTo(s),u=o[1]+s.scrollTop,a=u+t.offsetHeight,f=s.clientHeight,l=parseInt(s.scrollTop,10),c=l+f;t.offsetHeight>f||u<l?n.jspApi&&n.jspApi.scrollByY(u,!1):a>c&&n.jspApi&&n.jspApi.scrollByY(a-f,!1)}};switch(e.getKey()){case e.UP:case e.DOWN:var s=n.cmp.getSelectionModel().getLastSelected(),o=s?r.indexOf(s):-1;i(o);break;case e.PAGE_UP:case e.PAGE_DOWN:break;case e.HOME:i(0);break;case e.END:i(r.count()-1)}},onViewReady:function(){var e=this;e.cmp.getView().getEl().on("keydown",e.onKeyDown,e,{stopEvent:!0})}}),Ext.define("Common.plugin.ComboBoxScrollPane",{extend:"Common.plugin.ScrollPane",alias:"plugin.comboboxscrollpane",areaSelector:".list-ct",init:function(e){e.on("expand",this.onExpand,this)},onExpand:function(e){var t=this;if(!t.picker){t.picker=e.getPicker(),t.picker.on({viewready:t.onViewReady,resize:function(){t.updateScrollPane()},beforecontainerclick:function(){return!1},beforeitemmouseenter:function(t,n,r,i,s,o){if(e.scrolllocked)return!1},scope:t}),t.cmp.on("afterlayout",t.onViewReady,t,{single:!0}),e.on("keydown",t.onKeyDown,t);var n=e.getStore();n.on("datachanged",t.onDataChanged,t,{buffer:10})}},onKeyDown:function(e,t,n){var r=this,i=function(e){var t=r.picker,n=t.all.item(e);if(n){var i=Ext.getDom(t.getTargetEl())||Ext.getBody().dom,s=n.dom,o=n.getOffsetsTo(i),u=o[1]+i.scrollTop,a=u+s.offsetHeight,f=i.clientHeight,l=parseInt(i.scrollTop,10),c=l+f;s.offsetHeight>f||u<l?r.jspApi&&r.jspApi.scrollByY(u,!1):a>c&&r.jspApi&&r.jspApi.scrollByY(a-f,!1)}};switch(t.getKey()){case t.UP:var s=r.picker,o=s.all,u=s.highlightedItem,a=u?s.indexOf(u):-1,f=a>0?a-1:o.getCount()-1;i(f);break;case t.DOWN:var s=r.picker,o=s.all,u=s.highlightedItem,a=u?s.indexOf(u):-1,f=a<o.getCount()-1?a+1:0;i(f);break;case t.PAGE_UP:case t.PAGE_DOWN:break;case t.HOME:i(0);break;case t.END:i(r.picker.all.getCount()-1)}},onViewReady:function(){var e=this;e.initScrollPane(e.picker.getEl().dom)},onDataChanged:function(){var e=this;e.picker.getWidth()&&e.picker.getHeight()&&e.initScrollPane(e.picker.getEl().dom)}}),Ext.define("Common.component.util.RGBColor",{alternateClassName:"Common.util.RGBColor",constructor:function(e){this.ok=!1,e.charAt(0)=="#"&&(e=e.substr(1,6)),e=e.replace(/ /g,""),e=e.toLowerCase();var t=[{re:/^rgb\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3})\)$/,process:function(e){return[parseInt(e[1]),parseInt(e[2]),parseInt(e[3])]}},{re:/^hsb\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3})\)$/,process:function(e){var t={},n=Math.round(e[1]),r=Math.round(e[2]*255/100),i=Math.round(e[3]*255/100);if(r==0)t.r=t.g=t.b=i;else{var s=i,o=(255-r)*i/255,u=(s-o)*(n%60)/60;n==360&&(n=0),n<60?(t.r=s,t.b=o,t.g=o+u):n<120?(t.g=s,t.b=o,t.r=s-u):n<180?(t.g=s,t.r=o,t.b=o+u):n<240?(t.b=s,t.r=o,t.g=s-u):n<300?(t.b=s,t.g=o,t.r=o+u):n<360?(t.r=s,t.g=o,t.b=s-u):(t.r=0,t.g=0,t.b=0)}return[Math.round(t.r),Math.round(t.g),Math.round(t.b)]}},{re:/^(\w{2})(\w{2})(\w{2})$/,process:function(e){return[parseInt(e[1],16),parseInt(e[2],16),parseInt(e[3],16)]}},{re:/^(\w{1})(\w{1})(\w{1})$/,process:function(e){return[parseInt(e[1]+e[1],16),parseInt(e[2]+e[2],16),parseInt(e[3]+e[3],16)]}}];for(var n=0;n<t.length;n++){var r=t[n].re,i=t[n].process,s=r.exec(e);if(s){var o=i(s);this.r=o[0],this.g=o[1],this.b=o[2],this.ok=!0}}this.r=this.r<0||isNaN(this.r)?0:this.r>255?255:this.r,this.g=this.g<0||isNaN(this.g)?0:this.g>255?255:this.g,this.b=this.b<0||isNaN(this.b)?0:this.b>255?255:this.b,this.isEqual=function(e){return this.r==e.r&&this.g==e.g&&this.b==e.b},this.toRGB=function(){return"rgb("+this.r+", "+this.g+", "+this.b+")"},this.toRGBA=function(e){return e===undefined&&(e=1),"rgba("+this.r+", "+this.g+", "+this.b+", "+e+")"},this.toHex=function(){var e=this.r.toString(16),t=this.g.toString(16),n=this.b.toString(16);return e.length==1&&(e="0"+e),t.length==1&&(t="0"+t),n.length==1&&(n="0"+n),"#"+e+t+n},this.toHSB=function(){var e={h:0,s:0,b:0},t=Math.min(this.r,this.g,this.b),n=Math.max(this.r,this.g,this.b),r=n-t;return e.b=n,e.s=n!=0?255*r/n:0,e.s!=0?this.r==n?e.h=0+(this.g-this.b)/r:this.g==n?e.h=2+(this.b-this.r)/r:e.h=4+(this.r-this.g)/r:e.h=0,e.h*=60,e.h<0&&(e.h+=360),e.s*=100/255,e.b*=100/255,e.h=parseInt(e.h),e.s=parseInt(e.s),e.b=parseInt(e.b),e}}}),Ext.define("Common.component.HSBColorPicker",{extend:"Ext.Component",alias:"widget.hsbcolorpicker",requires:["Common.component.util.RGBColor","Ext.XTemplate"],baseCls:"cmp-hsb-colorpicker",allowEmptyColor:!1,changeSaturation:!0,showCurrentColor:!0,config:{color:"#ff0000"},renderTpl:['<div class="{baseCls}-root">','<tpl if="showCurrentColor">','<div class="{baseCls}-top-panel">','<span class="{baseCls}-color-value">','<span class="transparent-color"></span>',"</span>",'<div class="{baseCls}-color-text"></div>',"</div>","</tpl>","<div>",'<div class="{baseCls}-cnt-hb">','<div class="{baseCls}-cnt-hb-arrow"></div>',"</div>",'<tpl if="changeSaturation">','<div class="{baseCls}-cnt-root">','<div class="{baseCls}-cnt-sat">','<div class="{baseCls}-cnt-sat-arrow"></div>',"</div>","</div>","</tpl>","</div>",'<tpl if="allowEmptyColor">','<div class="{baseCls}-empty-color">{textNoColor}</div>',"</tpl>","</div>"],constructor:function(e){return this.initConfig(e),this.callParent(arguments),this},initComponent:function(){var e=this,t,n,r,i,s,o,u,a,f=0,l=100,c=100,h=function(t,n){var r=new Common.util.RGBColor(Ext.String.format("hsb({0}, {1}, {2})",t.h,t.s,t.b)),i=r.toHex();e.color=n?"transparent":i,p(),e.fireEvent("changecolor",e,e.color)},p=function(){s&&o&&(e.color=="transparent"?o.show():(s.setStyle("background-color",e.color),o.hide())),r&&r.setStyle("background-color",(new Common.util.RGBColor(Ext.String.format("hsb({0}, 100, 100)",f))).toHex()),u&&(u.dom.innerHTML=e.color=="transparent"?e.textNoColor:e.color.toUpperCase()),t&&n&&(t.setLeft(l+"%"),t.setTop(100-c+"%"),n.setTop(parseInt(f*100/360)+"%"))},d=function(e,n,i){if(t&&r){var s=[Math.max(0,Math.min(100,parseInt((e.getX()-r.getX())/r.getWidth()*100))),Math.max(0,Math.min(100,parseInt((e.getY()-r.getY())/r.getHeight()*100)))];t.setLeft(s[0]+"%"),t.setTop(s[1]+"%"),l=s[0],c=100-s[1],h({h:f,s:l,b:c})}},v=function(e,t,r){if(n&&i){var s=Math.max(0,Math.min(100,parseInt((e.getY()-i.getY())/i.getHeight()*100)));n.setTop(s+"%"),f=parseInt(360*s/100),h({h:f,s:l,b:c})}},m=function(e,t,n){Ext.getDoc().on("mouseup",g),Ext.getDoc().on("mousemove",d)},g=function(e,t,n){Ext.getDoc().un("mouseup",g),Ext.getDoc().un("mousemove",d),d(e,t,n)},y=function(e,t,n){Ext.getDoc().on("mouseup",b),Ext.getDoc().on("mousemove",v),v(e,t,n)},b=function(e,t,n){Ext.getDoc().un("mouseup",b),Ext.getDoc().un("mousemove",v)},w=function(t){var n=(new Common.util.RGBColor(e.color)).toHSB();h(n,!0)},E=function(h){var d=e.getEl(),v;d&&(t=d.down("."+e.baseCls+"-cnt-hb-arrow"),n=d.down("."+e.baseCls+"-cnt-sat-arrow"),r=d.down("."+e.baseCls+"-cnt-hb"),i=d.down("."+e.baseCls+"-cnt-sat"),s=d.down("."+e.baseCls+"-color-value"),u=d.down("."+e.baseCls+"-color-text"),a=d.down("."+e.baseCls+"-empty-color"),s&&(o=s.child(".transparent-color")),r&&(r.un("mousedown"),r.on("mousedown",m,e)),i&&(i.un("mousedown"),i.on("mousedown",y,e)),a&&(a.un("click"),a.on("click",w,e)),e.color=="transparent"?v={h:0,s:100,b:100}:v=(new Common.util.RGBColor(e.color)).toHSB(),f=v.h,l=v.s,c=v.b,f==l&&f==c&&f==0&&(l=100),p())};e.setColor=function(t){if(e.color==t)return;var n;t=="transparent"?n={h:0,s:100,b:100}:n=(new Common.util.RGBColor(t)).toHSB(),f=n.h,l=n.s,c=n.b,f==l&&f==c&&f==0&&(l=100),e.color=t,p()},e.on("afterrender",E,this),e.callParent(arguments),this.addEvents("changecolor")},onRender:function(e,t){var n=this;Ext.applyIf(n.renderData,n.getTemplateArgs()),n.callParent(arguments)},getTemplateArgs:function(){var e=this;return{allowEmptyColor:e.allowEmptyColor,changeSaturation:e.changeSaturation,textNoColor:e.textNoColor,showCurrentColor:e.showCurrentColor}},textNoColor:"No Color"}),Ext.define("Common.view.ExtendedColorDialog",{extend:"Ext.window.Window",alias:"widget.commonextendedcolordialog",cls:"common-extendedcolordialog",requires:["Ext.window.Window","Common.component.HSBColorPicker"],modal:!0,closable:!0,resizable:!1,preventHeader:!0,closeAction:"destroy",plain:!0,height:276,width:326,minWidth:188,padding:"16px",layout:{type:"vbox",align:"stretch"},listeners:{beforehide:function(){this._modalresult===undefined&&this.fireEvent("onmodalresult",0)},show:function(){this.textColor.focus(!1,500)}},constructor:function(e){return this.callParent(arguments),this.initConfig(e),this},initComponent:function(){function r(e){if(!n.stopevents){var t=(n.spinR.getValue()==null?0:n.spinR.getValue()).toString(16),r=(n.spinG.getValue()==null?0:n.spinG.getValue()).toString(16),i=(n.spinB.getValue()==null?0:n.spinB.getValue()).toString(16),s=(t.length==1?"0"+t:t)+(r.length==1?"0"+r:r)+(i.length==1?"0"+i:i);n.colorsPicker.setColor("#"+s),e!="hex"&&n.textColor.setValue(s.toUpperCase()),n.colorNew.getEl().setStyle("background-color","#"+s)}}var e=Ext.create("Ext.Button",{text:this.addButtonText,width:80,cls:"asc-blue-button",listeners:{click:function(){this._modalresult=1,this.fireEvent("onmodalresult",this._modalresult),this.close()},scope:this}}),t=Ext.create("Ext.Button",{text:this.cancelButtonText,width:80,cls:"asc-darkgray-button",listeners:{click:function(){this._modalresult=0,this.fireEvent("onmodalresult",this._modalresult),this.close()},scope:this}}),n=this;n.hexRe=/\s*#?([0-9a-fA-F][0-9a-fA-F]?)([0-9a-fA-F][0-9a-fA-F]?)([0-9a-fA-F][0-9a-fA-F]?)\s*/,this.colorsPicker=Ext.widget("hsbcolorpicker",{height:198,color:"#000000",width:220,changeSaturation:!0,showCurrentColor:!1,style:"margin-top:2px;margin-right:6px;",listeners:{render:function(e){$("."+this.baseCls+"-cnt-root").css("margin-right","0")},changecolor:function(e,t){n.colorNew.getEl().setStyle("background-color",t),n.stopevents=!0;var r=t.match(n.hexRe);n.spinR.setValue(parseInt(r[1],16)),n.spinG.setValue(parseInt(r[2],16)),n.spinB.setValue(parseInt(r[3],16)),n.textColor.setValue((r[1]+r[2]+r[3]).toUpperCase()),n.stopevents=!1}}}),this.spinR=Ext.widget("numberfield",{fieldLabel:"R",labelWidth:10,width:80,minValue:0,maxValue:255,value:0,style:"margin-bottom:4px;",listeners:{change:r}}),this.spinG=Ext.widget("numberfield",{fieldLabel:"G",labelWidth:10,width:80,minValue:0,maxValue:255,value:0,style:"margin-bottom:4px;",listeners:{change:r}}),this.spinB=Ext.widget("numberfield",{fieldLabel:"B",labelWidth:10,width:80,minValue:0,maxValue:255,value:0,style:"margin-bottom:16px;",listeners:{change:r}}),this.colorSaved=Ext.widget("box",{id:"field-start-color",height:20}),this.colorNew=Ext.widget("box",{height:20}),this.textColor=Ext.widget("textfield",{fieldLabel:"#",labelWidth:10,maskRe:/[a-fA-F0-9]/,maxLength:6,enforceMaxLength:!0,validator:function(e){if(!/^[a-fA-F0-9]{0,6}$/.test(e))return"Incorrect color value";e="000000"+e;var t=e.match(/([a-fA-F0-9]{2})([a-fA-F0-9]{2})([a-fA-F0-9]{2})$/i);return n.stopevents=!0,n.spinR.setValue(parseInt(t[1],16)),n.spinG.setValue(parseInt(t[2],16)),n.spinB.setValue(parseInt(t[3],16)),n.stopevents=!1,this.rendered&&r("hex"),!0},listeners:{afterrender:function(e){e.inputEl.setStyle("text-align","right")}}}),this.addEvents("onmodalresult"),this.items=[{xtype:"container",height:202,layout:{type:"hbox",align:"stretch"},items:[this.colorsPicker,{xtype:"container",width:68,layout:{type:"vbox",align:"stretch"},items:[{xtype:"label",text:this.textNew,style:"text-align:center;width:100%;margin-bottom:2px;"},this.colorNew,this.colorSaved,{xtype:"label",text:this.textCurrent,style:"text-align:center;width:100%;margin-top:2px;margin-bottom:14px;"},this.spinR,this.spinG,this.spinB,this.textColor]}]},{xtype:"tbspacer",height:14},{xtype:"container",layout:{type:"hbox",align:"middle",pack:"center"},items:[e,{xtype:"tbspacer",width:10},t]}],this.callParent(arguments)},getColor:function(){var e=/#?([a-fA-F0-9]{6})/.exec(this.colorsPicker.getColor());return e?e[1]:null},setColor:function(e){function r(){e=="transparent"?t.colorSaved.addCls("color-transparent"):(t.colorSaved.removeCls("color-transparent"),t.colorSaved.getEl().setStyle("background-color","#"+e)),t.colorNew.getEl().setStyle("background-color","#"+n)}var t=this,n=/#?([a-fA-F0-9]{6})/.test(e)?e:"ff0000";t.colorsPicker.setColor("#"+n),t.colorSaved.rendered?r():t.colorSaved.on("afterrender",r,{single:!0}),t.stopevents=!0;var i=t.hexRe.exec(n);t.spinR.setValue(parseInt(i[1],16)),t.spinG.setValue(parseInt(i[2],16)),t.spinB.setValue(parseInt(i[3],16)),t.textColor.setValue((i[1]+i[2]+i[3]).toUpperCase()),t.stopevents=!1},cancelButtonText:"Cancel",addButtonText:"Add",textNew:"New",textCurrent:"Current"}),Ext.define("Common.component.DataViewPicker",{extend:"Ext.container.Container",requires:["Ext.data.Store","Ext.data.Model","Ext.view.View","Ext.XTemplate","Ext.container.Container","Common.plugin.DataViewScrollPane"],uses:["Common.component.GroupedDataView"],alias:"widget.cmddataviewpicker",layout:{type:"fit"},constructor:function(e){if(!e||!e.viewData)throw Error("Common.component.DataViewPicker creation failed: required parameters are missing.");return this.initConfig(e),this.callParent(arguments),this},initComponent:function(){var e=this,t=Ext.apply({},e.initialConfig);e.selectedRec=null,Ext.define("DataModel",{extend:"Ext.data.Model",fields:[{name:"imageUrl"},{name:"title"},{name:"data"},{name:"uid"}]}),e.store=Ext.isDefined(t.store)?t.store:Ext.create("Ext.data.Store",{storeId:Ext.id(),model:"DataModel",data:t.viewData});var n=Ext.isDefined(t.dataTpl)?t.dataTpl:Ext.create("Ext.XTemplate",'<tpl for=".">','<div class="thumb-wrap">',e.itemWidth!==undefined&&e.itemHeight!==undefined?'<img src="{imageUrl}" width="'+e.itemWidth+'" height="'+e.itemHeight+'"/>':'<img src="{imageUrl}" />','<tpl if="title">','<span class="title">{title}</span>',"</tpl>","</div>","</tpl>");if(e.isGroupedDataView)var r=Ext.create("Common.component.GroupedDataView",{store:e.store,listeners:{itemclick:function(t,n,r,i,s,o){e.selectedRec=n,e.fireEvent("select",e,n,r,i)},beforecontainerclick:function(e,t,n){return!1},selectionchange:function(t,n,i){var s=r.getPlugin("scrollpane"),o=r.getNode(n[0]);s&&o&&s.scrollToElement(o),e.fireEvent("selectionchange",e,t,n)},itemkeydown:function(e,t,n,r,i,s){i.getKey()==i.ENTER&&e.fireEvent("itemclick",e,t,n,r,i,s)}},plugins:[{ptype:"dataviewscrollpane",areaSelector:".grouped-data-view",pluginId:"scrollpane",settings:{enableKeyboardNavigation:!0,keyboardSpeed:.001,contentWidth:e.contentWidth}}]});else var r=Ext.create("Ext.view.View",{store:e.store,tpl:n,singleSelect:!0,trackOver:!0,autoScroll:!0,overItemCls:"x-item-over",itemSelector:"div.thumb-wrap",emptyText:"",cls:"storage-data-view",listeners:{itemclick:function(t,n,r,i,s,o){e.selectedRec=n,e.fireEvent("select",e,n,r,i)},beforecontainerclick:function(e,t,n){return!1},selectionchange:function(t,n,r){e.fireEvent("selectionchange",e,t,n)},itemkeydown:function(e,t,n,r,i,s){i.getKey()==i.ENTER&&e.fireEvent("itemclick",e,t,n,r,i,s)},itemmouseenter:function(t,n,r,i,s,o){e.fireEvent("itemmouseenter",e,n,r,i,s,o)},itemmouseleave:function(t,n,r,i,s,o){e.fireEvent("itemmouseleave",e,n,r,i,s,o)}},plugins:[{ptype:"dataviewscrollpane",areaSelector:".storage-data-view",pluginId:"scrollpane",settings:{enableKeyboardNavigation:!0,keyboardSpeed:.001,contentWidth:e.contentWidth}}]});e.addEvents("select","itemmouseenter","itemmouseleave"),e.handler&&e.on("select",e.handler,e.scope,e),e.getSelectedRec=function(){return e.isGroupedDataView?r.getSelected():r.getSelectionModel().getSelection()[0]},e.selectByIndex=function(t,n){if(r.rendered)if(t<0)r.getSelectionModel().deselectAll(!1),e.selectedRec=null;else{var i=Ext.isDefined(n)?n:!0;e.selectedRec=e.store.getAt(t),r.getSelectionModel().select(e.store.getAt(t),!1,i)}else r.on("afterrender",Ext.bind(function(t){e.selectByIndex(t)},this,[t]),{single:!0})},e.selectGroupItem=function(t,n){return!e.isGroupedDataView||!r?null:(e.selectedRec=r.selectGroupItem(t,n),e.selectedRec)},e.updateScrollPane=function(){var t=r.getPlugin("scrollpane");t&&r.getEl()&&r.getEl().getWidth()>0&&(t.settings&&(t.settings.contentWidth=e.contentWidth),t.updateScrollPane(r.getEl().dom),e.checkScrolls(),e.arrangeItems&&e.arrangeItems.call(e))},e.checkScrolls=function(){var t=r.getPlugin("scrollpane");if(t&&r.getEl()){var n=e.getEl().down(".jspPane");if(n.getHeight()>0&&e.getEl().getHeight()>0)var i=0,s=setInterval(function(){n.getHeight()>e.getEl().getHeight()&&(e.getEl().down(".jspVerticalBar")?clearInterval(s):(t.updateScrollPane(r.getEl().dom),clearInterval(s))),i++>3&&clearInterval(s)},100)}},e.showUpdated=function(){e.updateScrollPane(),r&&r.getEl()&&(r.getEl().focus(50),e.selectedRec?r.getSelectionModel().select(e.selectedRec,!1,!1):r.getSelectionModel().deselectAll(!1))},r.getStore().on("datachanged",e.updateScrollPane,e,{buffer:10}),r.on("viewready",e.updateScrollPane,e),e.on("resize",e.updateScrollPane,e),e.on("afterlayout",e.updateScrollPane,e),e.items=[r],this.callParent(arguments)}}),Ext.define("Common.component.MenuDataViewPicker",{extend:"Ext.menu.Menu",alias:"widget.cmdmenudataviewpicker",requires:["Common.component.DataViewPicker"],hideOnClick:!0,hideMode:"display",constructor:function(e){if(!e||!e.viewData)throw Error("Common.component.MenuDataViewPicker creation failed: required parameters are missing.");return this.initConfig(e),this.callParent(arguments),this},initComponent:function(){var e=this,t=Ext.apply({},e.initialConfig);delete t.listeners,Ext.apply(e,{plain:!0,showSeparator:!1,items:Ext.applyIf({xtype:"cmddataviewpicker",padding:Ext.isDefined(t.pickerpadding)?t.pickerpadding:"2px 4px 1px 2px",store:t.store},t)}),e.callParent(arguments),e.picker=e.down("cmddataviewpicker"),e.relayEvents(e.picker,["select","itemmouseenter","itemmouseleave"]),e.hideOnClick&&e.on("select",e.hidePickerOnSelect,e),e.on("resize",function(t,n,r,i){e.applyContentWidth&&n>=20&&(e.picker.contentWidth=n-20),e.picker.setSize(n,r)},this),e.on("show",function(t){e.picker.showUpdated()},this)},hidePickerOnSelect:function(e,t,n){Ext.menu.Manager.hideAll()}}),Ext.define("Common.component.ThemeColorPalette",{extend:"Ext.ColorPalette",alias:"widget.cmpthemecolorpalette",allowReselect:!0,dyncolorscount:12,width:193,maxWidth:200,baseCls:"cmp-theme-colorpalette",requires:["Common.view.ExtendedColorDialog"],renderTpl:['<div style="padding: 12px;">','<tpl for="colors">','<tpl if="this.isBlankSeparator(values)"><div class="palette-color-spacer" style="width:100%;height:8px;float:left;"></div></tpl>','<tpl if="this.isSeparator(values)"></div><div class="palette-color-separator" style="width:100%;height:1px;float:left;border-bottom: 1px solid #E0E0E0"></div><div style="padding: 12px;"></tpl>','<tpl if="this.isColor(values)">','<a href="#" class="palette-color color-{.}" style="background:#{.} "hidefocus="on">','<em><span style="background:#{.}; border: 1px solid rgba(0, 0, 0, 0.2);" unselectable="on">&#160;</span></em>',"</a>","</tpl>",'<tpl if="this.isTransparent(values)">','<a href="#" class="color-{.}" hidefocus="on">','<em><span unselectable="on">&#160;</span></em>',"</a>","</tpl>",'<tpl if="this.isCustom(values)">','<a href="#" id="{id}" class="palette-color-custom {cls}" hidefocus="on">','<em><span style="background:#FFFFFF;background-image:url({image});" unselectable="on">&#160;</span></em>',"</a>","</tpl>",'<tpl if="this.isEffect(values)">','<a href="#" effectid="{effectId}" effectvalue="{effectValue}" class="palette-color-effect color-{color}" style="background:#{color}" hidefocus="on">','<em><span style="background:#{color}; border: 1px solid rgba(0, 0, 0, 0.2);" unselectable="on">&#160;</span></em>',"</a>","</tpl>",'<tpl if="this.isCaption(values)"><div class="palette-color-caption" style="width:100%;float:left;font-size: 11px;">{.}</div></tpl>',"</tpl>","</div>",{isBlankSeparator:function(e){return typeof e=="string"&&e=="-"},isSeparator:function(e){return typeof e=="string"&&e=="--"},isColor:function(e){return typeof e=="string"&&/[0-9A-F]{6}/.test(e)},isTransparent:function(e){return typeof e=="string"&&e=="transparent"},isCaption:function(e){return typeof e=="string"&&e!="-"&&e!="--"&&!/[0-9A-F]{6}|transparent/.test(e)},isEffect:function(e){return typeof e=="object"&&e.effectId!==undefined},isCustom:function(e){return typeof e=="object"&&e.effectId===undefined}}],constructor:function(e){return this.initConfig(e),this.callParent(arguments),this},initComponent:function(){this.callParent(arguments)},onRender:function(e){this.callParent(arguments);if(this.dynamiccolors){var t=e.down(".x-color-picker");if(t){var n=-1,r='<div class="palette-color-spacer" style="width:100%;height:8px;float:left;"></div><div style="padding: 12px;">';while(++n<this.dyncolorscount)r+=Ext.String.format('<a href="#" class="color-dynamic-{0} dynamic-empty-color" style="background:#ffffff" color="" hidefocus="on"><em><span unselectable="on">&#160;</span></em></a>',n);r+="</div>",Ext.DomHelper.insertHtml("beforeEnd",t.dom,r)}}var i=this.el.up(".x-menu");i&&Ext.menu.Manager.menus[i.id].addListener("beforeshow",this.updateCustomColors,this),this.updateCustomColors()},afterRender:function(e){this.callParent(arguments),this.updateColorsArr&&this.updateColors(this.updateColorsArr[0],this.updateColorsArr[1]),this.lastvalue&&this.select(this.lastvalue,!0)},setCustomColor:function(e){e=/#?([a-fA-F0-9]{6})/.exec(e);if(e){var t=this.getEl();if(t){this._saveCustomColor(e[1]),$("#"+t.id+" a."+this.selectedCls).removeClass(this.selectedCls);var n=t.down(".dynamic-empty-color");n||(this.updateCustomColors(),n=t.down(".color-dynamic-"+(this.dyncolorscount-1))),n.removeCls("dynamic-empty-color").addCls(this.selectedCls).dom.setAttribute("color",e[1]),n.down("span").setStyle("background-color","#"+e[1]).setStyle("border","none")}}},select:function(e,t){if(!this.rendered){this.lastvalue=e;return}var n=this.getEl();n&&$("#"+n.id+" a."+this.selectedCls).removeClass(this.selectedCls);if(typeof e=="object"){var r;e.effectId!==undefined?(r=n.down('a[effectid="'+e.effectId+'"]'),r?(r.addCls(this.selectedCls),this.value=r.dom.className.match(this.colorRe)[1].toUpperCase()):this.value=!1):e.effectValue!==undefined&&(r=n.down('a[effectvalue="'+e.effectValue+'"].color-'+e.color.toUpperCase()),r?(r.addCls(this.selectedCls),this.value=r.dom.className.match(this.colorRe)[1].toUpperCase()):this.value=!1)}else{/#?[a-fA-F0-9]{6}/.test(e)&&(e=/#?([a-fA-F0-9]{6})/.exec(e)[1].toUpperCase(),this.value=e);if(/^[a-fA-F0-9]{6}|transparent$/.test(e)&&Ext.Array.contains(this.colors,e)){Ext.Array.contains(this.colors,this.value)||(this.value=!1);if(e!=this.value||this.allowReselect)this.value&&(this.value=="transparent"?n.down("a.color-transparent").removeCls(this.selectedCls):n.down("a.palette-color.color-"+this.value).removeCls(this.selectedCls)),e=="transparent"?n.down("a.color-transparent").addCls(this.selectedCls):n.down("a.palette-color.color-"+e).addCls(this.selectedCls),this.value=e,t!==!0&&this.fireEvent("select",this,e)}else if(n){var i=n.down("#"+e)||n.down('a[color="'+e+'"]');i?(i.addCls(this.selectedCls),this.value=e.toUpperCase()):n.down("a."+this.selectedCls)?this.value=!1:this.dynamiccolors}else this.lastvalue=e}},handleClick:function(e,t){var n=this,r,i;if(t.className.search("palette-color-custom")<0)if(t.className.search("color-transparent")<0)if(t.className.search("color-dynamic")<0){i=Ext.get(t.parentNode).down("a.palette-color-custom"),i&&i.removeCls(n.selectedCls);if(!/^[a-fA-F0-9]{6}$/.test(this.value)||!Ext.Array.contains(this.colors,this.value))this.value=!1;if(t.className.search("palette-color-effect")<0)this.callParent(arguments);else{r=t.className.match(n.colorRe)[1];var s=t.getAttribute("effectid");r&&(n.fireEvent("select",n,{color:r,effectId:s}),this.value=r.toUpperCase()),$("#"+this.getEl().id+" a."+n.selectedCls).removeClass(n.selectedCls),Ext.get(t).addCls(n.selectedCls)}}else/dynamic-empty-color/.test(t.className)?setTimeout(function(){n.addNewColor(),Ext.menu.Manager.hideAll()},10):(r=t.getAttribute("color"),r&&n.fireEvent("select",n,r),this.value=r.toUpperCase(),$("#"+this.getEl().id+" a."+n.selectedCls).removeClass(n.selectedCls),Ext.get(t).addCls(n.selectedCls));else{e.stopEvent(),i=Ext.get(t.parentNode).down("a."+n.selectedCls);if(!i||i.id!=t.id)i&&i.removeCls(n.selectedCls),Ext.get(t).addCls(n.selectedCls),n.value="transparent";n.fireEvent("select",n,"transparent")}else e.stopEvent(),i=Ext.get(t.parentNode).down("a."+n.selectedCls),!i||i.id!=t.id?(i&&i.removeCls(n.selectedCls),Ext.get(t.id).addCls(n.selectedCls),n.value=!1,n.fireEvent("select",n,t.id)):n.fireEvent("select",n,i.id)},addNewColor:function(){var e=this,t=Ext.create("Common.view.ExtendedColorDialog",{});t.addListener("onmodalresult",function(n){e._isdlgopen=!1,n==1&&(e.setCustomColor(t.getColor()),e.fireEvent("select",e,t.getColor()))},!1),e._isdlgopen=!0,t.setColor(e.value),t.show()},isDialogOpen:function(){return this._isdlgopen==1},updateColors:function(e,t){if(!this.rendered){this.updateColorsArr=[e,t.length==0&&this.updateColorsArr?this.updateColorsArr[1]:t];return}var n=this,r=this.getEl();n.aColorElements===undefined&&(n.aColorElements=r.query("a.palette-color")),n.aEffectElements===undefined&&(n.aEffectElements=r.query("a.palette-color-effect"));var i,s=0,o=0;for(var u=0;u<n.colors.length;u++)if(typeof n.colors[u]=="string"&&/[0-9A-F]{6}/.test(n.colors[u])){if(s>=t.length)continue;i=Ext.get(n.aColorElements[s]),i.removeCls("color-"+n.colors[u]),n.colors[u]=t[s].toUpperCase(),i.addCls("color-"+n.colors[u]),i.applyStyles({background:"#"+n.colors[u]}),i.down("span").applyStyles({background:"#"+n.colors[u]}),s++}else if(typeof n.colors[u]=="object"&&n.colors[u].effectId!==undefined){if(o>=e.length)continue;i=Ext.get(n.aEffectElements[o]),e[o].color=e[o].color.toUpperCase(),n.colors[u].color!==e[o].color&&(i.removeCls("color-"+n.colors[u].color),i.addCls("color-"+e[o].color),i.applyStyles({background:"#"+e[o].color}),i.down("span").applyStyles({background:"#"+e[o].color})),n.colors[u].effectId!==e[o].effectId&&i.set({effectid:e[o].effectId}),n.colors[u].effectValue!==e[o].effectValue&&i.set({effectvalue:e[o].effectValue}),n.colors[u]=e[o],o++}this.updateColorsArr=undefined},updateCustomColors:function(){var e=this.getEl();if(e){var t=localStorage["asc."+window.storagename+".colors.custom"];t=t?t.split(","):[];var n=-1,r,i=t.length<this.dyncolorscount?t.length:this.dyncolorscount;while(++n<i)r=e.down(".color-dynamic-"+n),r.removeCls("dynamic-empty-color").dom.setAttribute("color",t[n]),r.down("span").setStyle("background-color","#"+t[n]).setStyle("border","none")}},_saveCustomColor:function(e){var t=localStorage["asc."+window.storagename+".colors.custom"];t=t?t.split(","):[],t.push(e)>this.dyncolorscount&&t.shift(),localStorage["asc."+window.storagename+".colors.custom"]=t.join().toUpperCase()},_menuBeforeShow:function(){this.updateCustomColors()}}),Ext.define("Common.component.MultiSliderGradient",{extend:"Ext.slider.Multi",requires:[],uses:[],alias:"widget.cmdmultislidergradient",cls:"asc-multi-slider-gradient",values:[0,100],increment:1,minValue:0,maxValue:100,clickRange:[1,20],colorValues:["#000000","#ffffff"],currentThumb:0,initComponent:function(){var e=this,t=Ext.apply({},e.initialConfig);if(e.initialConfig.listeners&&e.initialConfig.listeners.change){var n=e.initialConfig.listeners.change;e.initialConfig.listeners.change=function(t,r,i){e.changeGradientStyle(),n.call(e,t,r,i)}}this.styleStr="",Ext.isChrome&&Ext.chromeVersion<10||Ext.isSafari&&Ext.safariVersion<5.1?this.styleStr="-webkit-gradient(linear, left top, right top, color-stop({1}%,{0}), color-stop({3}%,{2})); /* Chrome,Safari4+ */":Ext.isChrome||Ext.isSafari?this.styleStr="-webkit-linear-gradient(left, {0} {1}%, {2} {3}%)":Ext.isGecko?this.styleStr="-moz-linear-gradient(left, {0} {1}%, {2} {3}%)":Ext.isOpera&&Ext.operaVersion>11?this.styleStr="-o-linear-gradient(left, {0} {1}%, {2} {3}%)":Ext.isIE&&(this.styleStr="-ms-linear-gradient(left, {0} {1}%, {2} {3}%)"),this.callParent(arguments),this.addEvents("thumbclick"),this.addEvents("thumbdblclick")},listeners:{afterrender:function(e){var t=this,n="";if(t.thumbs){for(var r=0;r<t.thumbs.length;r++)t.thumbs[r]&&t.thumbs[r].tracker&&(t.thumbs[r].tracker.addListener("mousedown",Ext.bind(t.setActiveThumb,t,[r,!0]),t),t.thumbs[r].tracker.el.addListener("dblclick",function(){t.fireEvent("thumbdblclick",t)},t));t.setActiveThumb(0),t.innerEl&&(Ext.isEmpty(t.styleStr)||(n=Ext.String.format(t.styleStr,t.colorValues[0],0,t.colorValues[1],100),t.innerEl.setStyle("background",n)),Ext.isIE&&(n=Ext.String.format("progid:DXImageTransform.Microsoft.gradient( startColorstr={0}, endColorstr={1},GradientType=1 )",t.colorValues[0],t.colorValues[1]),t.innerEl.setStyle("filter",n)),n=Ext.String.format("linear-gradient(to right, {0} {1}%, {2} {3}%)",t.colorValues[0],0,t.colorValues[1],100),t.innerEl.setStyle("background",n))}}},setActiveThumb:function(e,t){this.currentThumb=e,this.thumbs[e].el.addCls("active-thumb");for(var n=0;n<this.thumbs.length;n++){if(e==n)continue;this.thumbs[n].el.removeCls("active-thumb")}t&&this.fireEvent("thumbclick",this,e)},setColorValue:function(e,t){var n=t!==undefined?t:this.currentThumb;this.colorValues[n]=e,this.changeGradientStyle()},getColorValue:function(e){var t=e!==undefined?e:this.currentThumb;return this.colorValues[t]},changeGradientStyle:function(){if(this.innerEl){var e;Ext.isEmpty(this.styleStr)||(e=Ext.String.format(this.styleStr,this.colorValues[0],this.getValue(0),this.colorValues[1],this.getValue(1)),this.innerEl.setStyle("background",e)),Ext.isIE&&(e=Ext.String.format("progid:DXImageTransform.Microsoft.gradient( startColorstr={0}, endColorstr={1},GradientType=1 )",this.colorValues[0],this.colorValues[1]),this.innerEl.setStyle("filter",e)),e=Ext.String.format("linear-gradient(to right, {0} {1}%, {2} {3}%)",this.colorValues[0],this.getValue(0),this.colorValues[1],this.getValue(1)),this.innerEl.setStyle("background",e)}},getNearest:function(e,t){var n=this,r=t=="top"?n.innerEl.getHeight()-e[t]:e[t],i=n.reverseValue(r),s=n.maxValue-n.minValue+5,o=0,u=null,a=n.thumbs,f=0,l=a.length,c,h,p;for(;f<l;f++){c=n.thumbs[f],h=c.value,p=Math.abs(h-i);if(Math.abs(p<=s)){if(n.constrainThumbs){var d=n.thumbs[f+1],v=n.thumbs[f-1];if(v!==undefined&&i<v.value)continue;if(d!==undefined&&i>d.value)continue}u=c,o=f,s=p}}return u}}),Ext.define("Common.component.ComboDataView",{extend:"Ext.container.Container",requires:["Ext.data.Model","Ext.data.Store","Ext.view.View","Ext.XTemplate"],alias:"widget.commoncombodataview",padding:4,itemWidth:80,itemHeight:40,menuHeight:100,menuMaxHeight:500,minWidth:150,emptyComboText:"No styles",handleGlobalResize:!1,constructor:function(e){if(!e||!e.viewData||!e.itemWidth||!e.itemHeight)throw Error("ComboDataView creation failed: required parameters are missing.");return this.initConfig(e),this.callParent(arguments),this},initComponent:function(){var e=this,t=Ext.apply({},e.initialConfig),n=0,r=0,i=0,s=0,o=0,u=0,a=!0,f=Ext.util.CSS.getRule(".storage-combodataview");f&&(n=parseInt(f.style.borderWidth),isNaN(n)&&(n=0)),Ext.define("DataModel",{extend:"Ext.data.Model",fields:[{name:"imageUrl"},{name:"title"},{name:"data"},{name:"uid"}]});var l=Ext.create("Ext.data.Store",{storeId:Ext.id(),model:Ext.isDefined(t.store)?t.store.model:"DataModel",data:t.viewData}),c=Ext.isDefined(t.dataTpl)?t.dataTpl:Ext.create("Ext.XTemplate",'<tpl for=".">','<div class="thumb-wrap">','<img src="{imageUrl}" width="'+e.itemWidth+'" height="'+e.itemHeight+'"/>','<tpl if="title">','<span class="title">{title}</span>',"</tpl>","</div>","</tpl>");this.dataMenu=Ext.widget("cmdmenudataviewpicker",{width:e.width,height:e.menuHeight,cls:"x-dataview-combo-menu",viewData:t.viewData,dataTpl:t.dataTpl,store:t.store,itemWidth:e.itemWidth,itemHeight:e.itemHeight,constrain:!1,pickerpadding:e.padding-1,listeners:{hide:function(t,n){e.fireEvent("menuhide",e,t)}}});var h=Ext.widget("dataview",{store:l,tpl:c,singleSelect:!0,trackOver:!0,style:"overflow:auto",overItemCls:"x-item-over",itemSelector:"div.thumb-wrap",emptyText:'<div class="emptyText">'+e.emptyComboText+"</div>",deferEmptyText:!1,cls:"x-view-context",listeners:{itemclick:function(n,r,i,s,o,u){t.repeatedselect&&n.getSelectionModel().getLastSelected()!==null&&n.getSelectionModel().getLastSelected().id==r.id&&e.fireEvent("select",e,r)},afterrender:Ext.bind(function(e,t){l.getCount()>0&&(e.select(l.getAt(0)),this.dataMenu.picker.selectByIndex(0))},this),beforecontainerclick:function(e,t,n){return!1},itemdblclick:function(t,n,r,i,s,o){e.fireEvent("releasecapture",e)}}}),p=Ext.widget("container",{flex:1,height:e.height-2*(e.padding+n),items:[h]}),d=Ext.widget("button",{cls:"x-btn-combodataview",height:e.height-2*(e.padding+n),handler:Ext.bind(function(t,r){a&&e.getDataViewCSSRules();var i=Math.floor(e.getEl().getWidth()/(e.itemWidth+s+o)),f=e.dataMenu.picker.store.getCount(),l=Math.ceil(f/i);if(l>1){var c=l*(e.itemHeight+2*u+s+o)+6,h=Math.min(e.menuMaxHeight,Ext.Element.getViewportHeight()-this.getPosition()[1]-6);c>h&&(c=h),e.dataMenu.show(),e.dataMenu.setSize(e.getEl().getWidth(),c),e.dataMenu.showBy(p,"tl-tl",[-e.padding+n,-e.padding+n])}},this)});this.fillComboView=function(t,n,r){if(Ext.isDefined(t)){var i=e.dataMenu.picker.store;if(i){if(r||l.find("uid",t.data.uid)<0){a&&e.getDataViewCSSRules(),l.removeAll();var u=i.indexOf(t),f=i.getCount(),c=Math.floor(p.getWidth()/(e.itemWidth+s+o)),d=[];p.getHeight()/e.itemHeight>2&&(c*=Math.floor(p.getHeight()/e.itemHeight));if(u<0)return;u=Math.floor(u/c)*c;for(var v=u,m=0;v<f&&m<c;v++,m++){var g=i.getAt(v),y={};for(var b=0;b<g.fields.length;b++)y[g.fields.items[b].name]=g.data[g.fields.items[b].name];d.push(y)}l.add(d)}if(n){var w=l.find("uid",t.data.uid);w>-1&&h.select(l.getAt(w),!1,!0)}}}},this.selectByIndex=function(t){t<0&&h.getSelectionModel().deselectAll(!1),e.dataMenu.picker.selectByIndex(t,!1)};var v=function(t,n){e.fillComboView(n,!0),n&&e.fireEvent("select",e,n)},m=function(t,n,r){var i=n[0];i&&(e.dataMenu.picker.selectByIndex(e.dataMenu.picker.store.findExact("uid",i.get("uid")),!1),e.fireEvent("select",e,i))},g=function(t,n,r){e.fillComboView(r[0],!0)},y=function(t,n){if(e.dataMenu){e.dataMenu.setWidth(t),e.dataMenu.hide();var r=e.dataMenu.picker;if(r){var i=r.getSelectedRec();e.fillComboView(i||r.store.getAt(0),!!i,!0)}}};e.handleGlobalResize?(e.on("afterrender",function(e){var t=e.getEl().down(".x-box-inner");t&&t.addCls("combodataview-auto-width")},this),Ext.EventManager.onWindowResize(function(){var t=e.getEl();t&&(e.doLayout(),y(t.getWidth()))},this)):e.on("resize",function(e,t,n){y(t,n)},this),this.dataMenu.addListener("select",v,e),this.dataMenu.picker.addListener("selectionchange",g,e),h.addListener("selectionchange",m,e),e.addEvents("select","menuhide","releasecapture"),e.addListener("afterrender",function(){Ext.util.CSS.refreshCache();var t=Ext.util.CSS.getRule(".x-dataview-combo-menu .storage-data-view .thumb-wrap");t&&(s=parseInt(t.style.paddingLeft),isNaN(s)&&(s=0),o=parseInt(t.style.paddingRight),isNaN(o)&&(o=0),u=parseInt(t.style.marginRight),isNaN(u)&&(u=0),a=!1),Ext.defer(function(){e.dataMenu.showAt([-1e4,-1e4]),e.fireEvent("releasecapture",e)},100)},this),e.getDataViewCSSRules=function(){if(e.dataMenu.picker.getEl()){var t=e.dataMenu.picker.getEl().down(".thumb-wrap");t&&(s=parseInt(t.getStyle("paddingLeft")),isNaN(s)&&(s=0),o=parseInt(t.getStyle("paddingRight")),isNaN(o)&&(o=0),u=parseInt(t.getStyle("marginRight")),isNaN(u)&&(u=0),a=!1)}},Ext.apply(e,{layout:{type:"hbox",align:"stretch"},cls:"storage-combodataview",items:[p,d]},t),this.callParent(arguments)}}),Ext.define("Common.view.ImageFromUrlDialog",{extend:"Ext.window.Window",alias:"widget.commonimagefromurldialog",requires:["Ext.window.Window"],modal:!0,closable:!0,resizable:!1,preventHeader:!0,plain:!0,height:114,width:350,padding:"20px",layout:"vbox",layoutConfig:{align:"stretch"},listeners:{show:function(){this.txtUrl.focus(!1,500)}},constructor:function(e){return this.callParent(arguments),this.initConfig(e),this},initComponent:function(){var e=Ext.create("Ext.Button",{id:"imgdialog-button-ok",text:this.okButtonText,width:80,cls:"asc-blue-button",listeners:{click:function(){if(!this.txtUrl.isValid())return;this._modalresult=1,this.fireEvent("onmodalresult",this._modalresult),this.close()},scope:this}}),t=Ext.create("Ext.Button",{id:"imgdialog-button-cancel",text:this.cancelButtonText,width:80,cls:"asc-darkgray-button",listeners:{click:function(){this._modalresult=0,this.fireEvent("onmodalresult",this._modalresult),this.close()},scope:this}});this.txtUrl=Ext.create("Ext.form.Text",{id:"imgdialog-text-url",width:310,msgTarget:"side",validateOnBlur:!1,allowBlank:!1,value:"",blankText:this.txtEmpty,regex:/(((^https?)|(^ftp)):\/\/([\-\wа-яё]+\.)+[\wа-яё]{2,3}(\/[%\-\wа-яё]+(\.[\wа-яё]{2,})?)*(([\wа-яё\-\.\?\\\/+@&#;`~=%!]*)(\.[\wа-яё]{2,})?)*\/?)/i,regexText:this.txtNotUrl,listeners:{specialkey:function(n,r){r.getKey()==r.ENTER?e.fireEvent("click"):r.getKey()==r.ESC&&t.fireEvent("click")}}}),this.addEvents("onmodalresult"),this.items=[{xtype:"label",text:this.textUrl,width:"100%",style:"text-align:left"},{xtype:"tbspacer",height:3},this.txtUrl,{xtype:"tbspacer",height:3},{xtype:"container",width:310,layout:"hbox",layoutConfig:{align:"stretch"},items:[{xtype:"tbspacer",flex:1},e,{xtype:"tbspacer",width:5},t]}],this.callParent(arguments)},textUrl:"Paste an image URL:",cancelButtonText:"Cancel",okButtonText:"Ok",txtEmpty:"This field is required",txtNotUrl:'This field should be a URL in the format "http://www.example.com"'}),Ext.define("Common.view.CopyWarning",{extend:"Ext.window.Window",alias:"widget.commoncopywarning",requires:["Ext.window.Window"],modal:!0,closable:!0,resizable:!1,constrain:!0,plain:!0,width:410,height:270,layout:{type:"border"},onEsc:function(){this.close()},initComponent:function(){this.items=[{xtype:"container",region:"center",layout:{type:"vbox",align:"center"},items:[{xtype:"box",padding:"15px 0 0 0",html:'<p style="font-size: 14pt; text-align: center;font-family: Arial;">'+this.textTitle+"</p><br>"+'<p style="height:52px; text-align: center; font-size: 8pt; font-family: Arial; color: #636363;padding: 10px 30px 0 30px;">'+this.textMsg+"</p>"},{xtype:"container",width:300,height:70,padding:"15px 0 0 0",layout:{type:"hbox",align:"stretch"},defaults:{xtype:"container",width:"50%"},items:[{layout:{type:"vbox",align:"center"},items:[{xtype:"box",html:'<p style="text-align: center; font-size: 18pt;font-family: Arial;">Ctrl+C</p><p style="text-align: center;font-family: Arial;">'+this.textToCopy+"</p>"}]},{style:"left: 50%;",layout:{type:"vbox",align:"center"},items:[{xtype:"box",html:'<p style="text-align: center; font-size: 18pt;font-family: Arial;">Ctrl+V</p><p style="text-align: center;font-family: Arial;">'+this.textToPaste+"</p>"}]}]}]},{xtype:"container",region:"south",height:58,style:"border-top: 1px solid #E5E5E5",padding:"16px 0 0 0",layout:{type:"vbox",align:"center"},items:[{xtype:"button",cls:"asc-blue-button",width:85,text:Ext.Msg.buttonText.ok,handler:Ext.bind(function(e){this.close()},this)}]}],this.callParent(arguments)},textTitle:"ONLYOFFICE Docs Copy & Paste Functions",textMsg:"For the security reasons the right-click menu copy and paste functions are disabled. You can still do the same using your keyboard:",textToCopy:"to copy",textToPaste:"to paste"}),Ext.define("Common.view.AbstractSettingsPanel",{extend:"Ext.panel.Panel",alias:"widget.commonabstractsettingspanel",bodyPadding:"0 0 0 15px",preventHeader:!0,constructor:function(e){return this.controls=[],this.callParent(arguments),this.initConfig(e),this},initComponent:function(){var e=this;this.initialHeight=this.height,e.callParent(arguments)},SuspendEvents:function(){for(var e=0;e<this.controls.length;e++)this.controls[e].suspendEvents(!1)},ResumeEvents:function(){for(var e=0;e<this.controls.length;e++)this.controls[e].resumeEvents()}}),Ext.define("Common.component.SynchronizeTip",{extend:"Ext.container.Container",alias:"widget.commonsynchronizetip",cls:"asc-synchronizetip",requires:["Ext.button.Button","Ext.form.Label"],layout:{type:"vbox",align:"stretch"},width:240,height:95,hideMode:"visibility",constructor:function(e){return this.initConfig(e),this.callParent(arguments),this},initComponent:function(){var e=this;e.addEvents("dontshowclick"),e.addEvents("closeclick");var t=Ext.widget("button",{cls:"btn-close-tip",iconCls:"icon-close-tip",listeners:{click:function(){e.fireEvent("closeclick",e)}}});e.items=[{xtype:"container",html:'<div class="tip-arrow"></div>'},{xtype:"container",flex:1,style:"padding-left: 15px;",layout:{type:"hbox",align:"stretch"},items:[{xtype:"container",flex:1,style:"margin-top: 15px;line-height: 1.2;",html:"<div>"+e.textSynchronize+"</div>"},t]},{xtype:"container",cls:"show-link",items:[{xtype:"label",text:e.textDontShow,listeners:{afterrender:function(t){t.getEl().on("click",function(t,n){e.fireEvent("dontshowclick",e)})},scope:this}}]}],e.callParent(arguments)},textDontShow:"Don't show this message again",textSynchronize:"The document has changed. <br/>Refresh the document to see the updates."}),Ext.define("Common.model.Group",{extend:"Ext.data.Model",fields:["group","groupname"],proxy:{type:"memory"},hasMany:{model:"Common.model.GroupItem",name:"getGroupItems"}}),Ext.define("Common.model.GroupItem",{extend:"Ext.data.Model",fields:["group","groupitem","iconcls"],proxy:{type:"memory"},belongsTo:{model:"Common.model.Group",name:"group"}}),Ext.define("Common.component.GroupedDataView",{extend:"Ext.DataView",alias:"widget.cmdgroupeddataview",requires:["Common.model.GroupItem","Common.model.Group","Ext.XTemplate"],selModel:{enableKeyNav:!1},tpl:new Ext.XTemplate('<tpl for=".">','<div class="asc-grouped-data">','<div class="group-description">','<span class="description-text">{[values[this.fieldGroupName]]}</span>',"</div>",'<div class="group-items-container">','<tpl for="getGroupItems">','<div class="group-item">','<span class="{iconcls}"></span>',"</div>","</tpl>","</div>","</div>",'<div class="asc-grouped-data-selector"></div>',"</tpl>",{compiled:!0,fieldGroupName:"groupname"}),itemSelector:"div.group-item",trackOver:!0,overItemCls:"group-item-over",cls:"grouped-data-view",listeners:{beforecontainerclick:function(e,t,n){return!1},viewready:function(){this.delayedSelection&&(this.getSelectionModel().doSingleSelect(this.delayedSelection),this.delayedSelection=undefined)}},constructor:function(e){return e.selModel&&(e.selModel.enableKeyNav=!1),this.initConfig(e),this.callParent(arguments),this},initComponent:function(){this.callParent(arguments)},updateIndexes:function(e,t){var n=this.all.elements,r=[],i;this.store.each(function(e,t,n){Ext.Array.insert(r,r.length,e.getGroupItems().getRange())}),e=e||0,t=t||(t===0?0:n.length-1);for(i=e;i<=t;i++)n[i].viewIndex=i,n[i].viewRecordId=r[i].internalId,n[i].boundView||(n[i].boundView=this.id)},getRecord:function(e){var t,n,r=-1,i=this.store.getCount();while(!t&&++r<i)n=this.store.getAt(r),n&&(t=n.getGroupItems().data.getByKey(Ext.getDom(e).viewRecordId));return t},onRender:function(e){this.callParent(arguments);var t=this;t.el.set({tabIndex:-1}),t.keyNav=Ext.create("Ext.util.KeyNav",t.el,{down:Ext.pass(t.onNavKey,[1,1],t),right:Ext.pass(t.onNavKey,[1,null],t),left:Ext.pass(t.onNavKey,[-1,null],t),up:Ext.pass(t.onNavKey,[-1,-1],t),scope:t})},onNavKey:function(e,t){e=e||1;var n=this.getSelectionModel().getSelection()[0],r=this.all.elements.length,i;if(n){if(t){var s=this.getIndexInStore(n);e=this.getShiftedStep(s,t)}i=this.indexOf(this.getNode(n))+e}else i=0;i<0?i=r-1:i>=r&&(i=0);var o=this.getRecord(this.all.elements[i]);this.getSelectionModel().doSingleSelect(o)},getIndexInStore:function(e){var t=[],n,r,i=-1,s=this.store.getCount();while(++i<s){n=this.store.getAt(i),r=n.getGroupItems().indexOf(e);if(!(r<0)){t=[i,r,n.getGroupItems().getCount()];break}}return t},getShiftedStep:function(e,t){var n=e[0]+t;n<0?n=this.store.getCount()-1:n<this.store.getCount()||(n=0);var r=this.store.getAt(n);if(t>0){var i=e[1]<r.getGroupItems().getCount()?e[1]:r.getGroupItems().getCount()-1;i+=e[2]-e[1]}else i=e[1]<r.getGroupItems().getCount()?e[1]-r.getGroupItems().getCount():-1,i-=e[1];return i},refresh:function(){this.callParent(arguments)},selectGroupItem:function(e,t){var n=this.store.findRecord("group",e);return n&&(n=n.getGroupItems().findRecord("groupitem",t),this.rendered?n&&this.getSelectionModel().doSingleSelect(n):this.delayedSelection=n),n},getSelected:function(){return this.delayedSelection||this.getSelectionModel().getSelection()[0]}}),Ext.define("DE.model.ShapeModel",{extend:"Ext.data.Model",fields:[{name:"imageUrl"},{name:"data"}]}),Ext.define("DE.model.ShapeGroup",{extend:"Ext.data.Model",fields:[{name:"groupName"},{name:"groupId"},{name:"groupStore"}]}),Ext.define("DE.store.ShapeGroups",{extend:"Ext.data.Store",model:"DE.model.ShapeGroup"}),Ext.define("DE.component.CellStyler",{extend:"Ext.container.Container",requires:["Common.component.util.RGBColor"],alias:"widget.decellstyler",clickOffset:10,overwriteStyle:!0,maxBorderSize:6,halfBorderSize:!1,defaultBorderSize:1,defaultBorderColor:"#ccc",initComponent:function(){var e=this,t=Ext.apply({},e.initialConfig),n=undefined,r=e.defaultBorderSize,i=new Common.util.RGBColor(e.defaultBorderColor),s={top:r,right:r,bottom:r,left:r},o={top:i,right:i,bottom:i,left:i},u=function(){if(Ext.isDefined(n)){var t=e.halfBorderSize?(s.left%2?s.left-1:s.left)*.5:s.left,r=e.halfBorderSize?(s.right%2?s.right+1:s.right)*.5:s.right,i=e.halfBorderSize?(s.top%2?s.top-1:s.top)*.5:s.top,u=e.halfBorderSize?(s.bottom%2?s.bottom+1:s.bottom)*.5:s.bottom,a="inset "+(t>.1&&t<1?1:t)+"px"+" 0"+" 0 "+o.left.toRGBA(t<1?.5:1)+", "+"inset "+ -1*(r>.1&&r<1?1:r)+"px "+" 0"+" 0 "+o.right.toRGBA(r<1?.5:1)+", "+"inset "+"0 "+(i>.1&&i<1?1:i)+"px"+" 0 "+o.top.toRGBA(i<1?.5:1)+", "+"inset "+"0 "+ -1*(u>.1&&u<1?1:u)+"px"+" 0 "+o.bottom.toRGBA(u<1?.5:1);n.setStyle("box-shadow",a)}};e.setBordersSize=function(t,n){n=n>e.maxBorderSize?e.maxBorderSize:n,t.indexOf("t")>-1&&(s.top=n),t.indexOf("r")>-1&&(s.right=n),t.indexOf("b")>-1&&(s.bottom=n),t.indexOf("l")>-1&&(s.left=n),u()},e.setBordersColor=function(e,t){var n=new Common.util.RGBColor(t);e.indexOf("t")>-1&&(o.top=n),e.indexOf("r")>-1&&(o.right=n),e.indexOf("b")>-1&&(o.bottom=n),e.indexOf("l")>-1&&(o.left=n),u()},e.getBorderSize=function(e){switch(e){case"t":return s.top;case"r":return s.right;case"b":return s.bottom;case"l":return s.left}return null},e.getBorderColor=function(e){switch(e){case"t":return o.top.toHex();case"r":return o.right.toHex();case"b":return o.bottom.toHex();case"l":return o.left.toHex()}return null},e.setVirtualBorderSize=function(t){r=t>e.maxBorderSize?e.maxBorderSize:t},e.setVirtualBorderColor=function(e){var t=new Common.util.RGBColor(e);if(i.isEqual(t))return;i=t},e.getVirtualBorderSize=function(){return r},e.getVirtualBorderColor=function(){return i.toHex()},e.addListener("afterrender",function(){var t=e.getEl();t&&(n=t.down(".cell-content"),u()),t.on("click",function(n){var a={x:n.browserEvent.offsetX||(Ext.isDefined(n.browserEvent.layerX)?n.browserEvent.layerX:0),y:n.browserEvent.offsetY||(Ext.isDefined(n.browserEvent.layerY)?n.browserEvent.layerY:0)},f=function(e,t,n,r,i){var s,o,u=0;for(s=0,o=e-1;s<e;o=s++)(n[s]<=i&&i<n[o]||n[o]<=i&&i<n[s])&&r<(t[o]-t[s])*(i-n[s])/(n[o]-n[s])+t[s]&&(u=!u);return u},l=t.getWidth(),c=t.getHeight();f(4,[0,l,l-e.clickOffset,e.clickOffset],[0,0,e.clickOffset,e.clickOffset],a.x,a.y)?(e.overwriteStyle?s.top!=r||!o.top.isEqual(i)?(s.top=r,o.top=i):s.top=0:(s.top=s.top>0?0:r,o.top=i),e.fireEvent("borderclick",e,"t",s.top,o.top.toHex())):f(4,[l,l,l-e.clickOffset,l-e.clickOffset],[0,c,c-e.clickOffset,e.clickOffset],a.x,a.y)?(e.overwriteStyle?s.right!=r||!o.right.isEqual(i)?(s.right=r,o.right=i):s.right=0:(s.right=s.right>0?0:r,o.right=i),e.fireEvent("borderclick",e,"r",s.right,o.right.toHex())):f(4,[0,e.clickOffset,l-e.clickOffset,l],[c,c-e.clickOffset,c-e.clickOffset,c],a.x,a.y)?(e.overwriteStyle?s.bottom!=r||!o.bottom.isEqual(i)?(s.bottom=r,o.bottom=i):s.bottom=0:(s.bottom=s.bottom>0?0:r,o.bottom=i),e.fireEvent("borderclick",e,"b",s.bottom,o.bottom.toHex())):f(4,[0,e.clickOffset,e.clickOffset,0],[0,e.clickOffset,c-e.clickOffset,c],a.x,a.y)&&(e.overwriteStyle?s.left!=r||!o.left.isEqual(i)?(s.left=r,o.left=i):s.left=0:(s.left=s.left>0?0:r,o.left=i),e.fireEvent("borderclick",e,"l",s.left,o.left.toHex())),u()})}),Ext.apply(e,{cls:"tablestyler-cell",html:'<div class="cell-content" style="width: 100%; height: 100%;"><div class="content-text"></div></div>'},t),e.callParent(arguments)}}),Ext.define("DE.component.TableStyler",{extend:"Ext.container.Container",requires:["Ext.util.CSS","Common.component.util.RGBColor"],uses:["DE.component.CellStyler"],alias:"widget.detablestyler",rows:2,columns:2,cellPadding:10,tablePadding:10,overwriteStyle:!0,maxBorderSize:6,spacingMode:!1,defaultBorderSize:1,defaultBorderColor:"#ccc",constructor:function(e){return this.initConfig(e),this.callParent(arguments),this},initComponent:function(){var e=this,t=Ext.apply({},e.initialConfig),n=e.defaultBorderSize>e.maxBorderSize?e.maxBorderSize:e.defaultBorderSize,r=new Common.component.util.RGBColor(e.defaultBorderColor),i,s,o,u,a,f,l,c,h={top:n,right:n,bottom:n,left:n},p={top:r,right:r,bottom:r,left:r},d=[];for(var v=0;v<this.rows;v++){v>0&&d.push({xtype:"container",height:e.spacingMode?this.cellPadding:0});var m=d.push({xtype:"container",layout:{type:"hbox",align:"stretch"},flex:1,items:[]});for(var g=0;g<this.columns;g++)g>0&&d[m-1].items.push({xtype:"container",width:e.spacingMode?this.cellPadding:0}),d[m-1].items.push({xtype:"decellstyler",overwriteStyle:e.overwriteStyle,halfBorderSize:!e.spacingMode,defaultBorderSize:e.spacingMode?n:0,defaultBorderColor:r.toHex(),id:e.getId()+"-cell-"+g+"-"+v,col:g,row:v,flex:1,listeners:{borderclick:function(t,n,r,i){var s,o,u;if(n=="t"){if(t.row>0)for(s=0;s<e.columns;s++)u=e.getCell(s,t.row-1),u.setBordersSize("b",r),u.setBordersColor("b",i);for(s=0;s<e.columns;s++)u=e.getCell(s,t.row),t.halfBorderSize&&t.row<1?u.setBordersSize("t",0):u.setBordersSize("t",r),u.setBordersColor("t",i)}else if(n=="b"){if(t.row<e.rows-1)for(s=0;s<e.columns;s++)u=e.getCell(s,t.row+1),u.setBordersSize("t",r),u.setBordersColor("t",i);for(s=0;s<e.columns;s++)u=e.getCell(s,t.row),t.halfBorderSize&&t.row>=e.rows-1?u.setBordersSize("b",0):u.setBordersSize("b",r),u.setBordersColor("b",i)}else if(n=="l"){if(t.col>0)for(o=0;o<e.rows;o++)u=e.getCell(t.col-1,o),u.setBordersSize("r",r),u.setBordersColor("r",i);for(o=0;o<e.rows;o++)u=e.getCell(t.col,o),t.halfBorderSize&&t.col<1?u.setBordersSize("l",0):u.setBordersSize("l",r),u.setBordersColor("l",i)}else if(n=="r"){if(t.col<e.columns-1)for(o=0;o<e.rows;o++)u=e.getCell(t.col+1,o),u.setBordersSize("l",r),u.setBordersColor("l",i);for(o=0;o<e.rows;o++)u=e.getCell(t.col,o),t.halfBorderSize&&t.col>=e.columns-1?u.setBordersSize("r",0):u.setBordersSize("r",r),u.setBordersColor("r",i)}}}})}var y=function(){i&&i.setStyle("border-bottom",(h.top>.1&&h.top<1?1:h.top)+"pt solid "+p.top.toRGBA(h.top<1?.2:1)),s&&s.setStyle("border-right",(h.right>.1&&h.right<1?1:h.right)+"pt solid "+p.right.toRGBA(h.right<1?.2:1)),o&&o.setStyle("border-bottom",(h.bottom>.1&&h.bottom<1?1:h.bottom)+"pt solid "+p.bottom.toRGBA(h.bottom<1?.2:1)),u&&u.setStyle("border-right",(h.left>.1&&h.left<1?1:h.left)+"pt solid "+p.left.toRGBA(h.left<1?.2:1))};e.addListener("afterrender",function(){var t=e.getId();i=Ext.get(t+"-table-top-border"),s=Ext.get(t+"-table-right-border"),o=Ext.get(t+"-table-bottom-border"),u=Ext.get(t+"-table-left-border"),a=Ext.get(t+"-table-top-border-selector"),f=Ext.get(t+"-table-right-border-selector"),l=Ext.get(t+"-table-bottom-border-selector"),c=Ext.get(t+"-table-left-border-selector"),a.on("click",function(t){e.overwriteStyle?h.top!=n||!p.top.isEqual(r)?(h.top=n,p.top=r):h.top=0:(h.top=h.top>0?0:n,p.top=r),i.setStyle("border-bottom",(h.top>.1&&h.top<1?1:h.top)+"pt solid "+p.top.toRGBA(h.top<1?.2:1)),e.fireEvent("borderclick",e,"t",h.top,p.top.toHex())},e),f.on("click",function(t){e.overwriteStyle?h.right!=n||!p.right.isEqual(r)?(h.right=n,p.right=r):h.right=0:(h.right=h.right>0?0:n,p.right=r),s.setStyle("border-right",(h.right>.1&&h.right<1?1:h.right)+"pt solid "+p.right.toRGBA(h.right<1?.2:1)),e.fireEvent("borderclick",e,"r",h.right,p.right.toHex())},e),l.on("click",function(t){e.overwriteStyle?h.bottom!=n||!p.bottom.isEqual(r)?(h.bottom=n,p.bottom=r):h.bottom=0:(h.bottom=h.bottom>0?0:n,p.bottom=r),o.setStyle("border-bottom",(h.bottom>.1&&h.bottom<1?1:h.bottom)+"pt solid "+p.bottom.toRGBA(h.bottom<1?.2:1)),e.fireEvent("borderclick",e,"b",h.bottom,p.bottom.toHex())},e),c.on("click",function(t){e.overwriteStyle?h.left!=n||!p.left.isEqual(r)?(h.left=n,p.left=r):h.left=0:(h.left=h.left>0?0:n,p.left=r),u.setStyle("border-right",(h.left>.1&&h.left<1?1:h.left)+"pt solid "+p.left.toRGBA(h.left<1?.2:1)),e.fireEvent("borderclick",e,"l",h.left,p.left.toHex())},e)}),e.getVirtualBorderSize=function(){return n},e.getVirtualBorderColor=function(){return r.toHex()},e.setVirtualBorderSize=function(t){t=t>e.maxBorderSize?e.maxBorderSize:t,n=t;for(var r=0;r<e.rows;r++)for(var i=0;i<e.columns;i++){var s=e.getCell(i,r);s.setVirtualBorderSize(t)}},e.setVirtualBorderColor=function(t){var n=new Common.component.util.RGBColor(t);if(r.isEqual(n))return;r=n;for(var i=0;i<e.rows;i++)for(var s=0;s<e.columns;s++){var o=e.getCell(s,i);o.setVirtualBorderColor(r.toHex())}},e.setBordersSize=function(t,n){n=n>e.maxBorderSize?e.maxBorderSize:n,t.indexOf("t")>-1&&(h.top=n),t.indexOf("r")>-1&&(h.right=n),t.indexOf("b")>-1&&(h.bottom=n),t.indexOf("l")>-1&&(h.left=n),y()},e.setBordersColor=function(e,t){var n=new Common.component.util.RGBColor(t);e.indexOf("t")>-1&&(p.top=n),e.indexOf("r")>-1&&(p.right=n),e.indexOf("b")>-1&&(p.bottom=n),e.indexOf("l")>-1&&(p.left=n),y()},e.getBorderSize=function(e){switch(e){case"t":return h.top;case"r":return h.right;case"b":return h.bottom;case"l":return h.left}return null},e.getBorderColor=function(e){switch(e){case"t":return p.top.toHex();case"r":return p.right.toHex();case"b":return p.bottom.toHex();case"l":return p.left.toHex()}return null},Ext.apply(e,{layout:{type:"vbox",align:"stretch"},cls:"table-styler",style:"background-color: #fff;",items:[{xtype:"container",layout:{type:"hbox",align:"stretch"},height:this.tablePadding,style:"overflow: visible;",items:[{xtype:"container",style:"border-bottom: 1pt dotted gray; border-right: 1pt dotted gray;",width:this.tablePadding},{xtype:"container",layout:"absolute",flex:1,items:[{xtype:"container",style:"z-index: 1;",id:e.getId()+"-table-top-border-selector",x:0,y:e.tablePadding*.5,height:e.tablePadding,anchor:"100%",html:'<table width="100%" height="100%"><tr><td id="'+e.getId()+"-table-top-border"+'" style="height:50%; border-bottom: '+h.top+"px solid "+p.top.toHex()+';"></td>'+"</tr>"+"<tr>"+"<td></td>"+"</tr>"+"</table>"}]},{xtype:"container",style:"border-bottom: 1pt dotted gray; border-left: 1pt dotted gray;",width:this.tablePadding}]},{xtype:"container",flex:1,layout:{type:"hbox",align:"stretch"},style:"overflow: visible;",items:[{xtype:"container",layout:"absolute",width:this.tablePadding,items:[{xtype:"container",style:"z-index: 1;",id:e.getId()+"-table-left-border-selector",x:e.tablePadding*.5,y:0,width:e.tablePadding,anchor:"auto 100%",html:'<table width="100%" height="100%"><tr><td id="'+e.getId()+"-table-left-border"+'" style="border-right: '+h.left+"pt solid "+p.left.toHex()+';"></td>'+'<td width="50%"></td>'+"</tr>"+"</table>"}]},{xtype:"container",layout:{type:"vbox",align:"stretch"},padding:e.spacingMode?this.cellPadding:0,flex:1,items:d},{xtype:"container",layout:"absolute",width:this.tablePadding,items:[{xtype:"container",style:"z-index: 1;",id:e.getId()+"-table-right-border-selector",x:-1*e.tablePadding*.5,y:0,width:e.tablePadding,anchor:"auto 100%",html:'<table width="100%" height="100%"><tr><td id="'+e.getId()+"-table-right-border"+'" style="border-right: '+h.right+"pt solid "+p.right.toHex()+';"></td>'+'<td width="50%"></td>'+"</tr>"+"</table>"}]}]},{xtype:"container",layout:{type:"hbox",align:"stretch"},style:"overflow: visible;",height:this.tablePadding,items:[{xtype:"container",style:"border-top: 1pt dotted gray; border-right: 1pt dotted gray;",width:this.tablePadding},{xtype:"container",layout:"absolute",flex:1,items:[{xtype:"container",style:"z-index: 1;",id:e.getId()+"-table-bottom-border-selector",x:0,y:-1*e.tablePadding*.5,height:e.tablePadding,anchor:"100%",html:'<table width="100%" height="100%"><tr><td id="'+e.getId()+"-table-bottom-border"+'" style="height:50%; border-bottom: '+h.bottom+"px solid "+p.bottom.toHex()+';"></td>'+"</tr>"+"<tr>"+"<td></td>"+"</tr>"+"</table>"}]},{xtype:"container",style:"border-top: 1pt dotted gray; border-left: 1pt dotted gray;",width:this.tablePadding}]}]},t),this.callParent(arguments)},getCell:function(e,t){return Ext.getCmp(this.getId()+"-cell-"+e+"-"+t)}}),Ext.define("DE.component.ComboDropFonts",{extend:"Ext.form.field.ComboBox",alias:"widget.decombodropfonts",queryMode:"local",matchFieldWidth:!1,displayField:"name",showlastused:!1,listeners:{expand:function(e){var t=this,n=t.getPlugin("scrollpane");if(n)var r=new Ext.util.DelayedTask(function(){var e=t.picker.getNode(t.lastSelection[0]);e&&n.scrollToElement(e,!1,!1)});r.delay(10)}},constructor:function(e){var t=this;t.iconHeight=FONT_THUMBNAIL_HEIGHT,t.iconWidth=302,this.addEvents("createpicker");var n=Ext.create("Ext.XTemplate",'<tpl for=".">','<a class="font-item" style="display: block;">','<img id="{[Ext.id()]}" src="{[this.getImageUri(values)]}" width="{[this.getImageWidth()]}" height="{[this.getImageHeight()]}" style="vertical-align: middle;margin: 0 0 0 -10px;">',"</a>","</tpl>",{getImageUri:function(e){if(e.cloneid)return t.picker.listEl.down("#"+e.cloneid).dom.src;var n=document.createElement("canvas");n.width=t.spriteThumbs.width,n.height=t.iconHeight;var r=n.getContext("2d");return r.save(),r.translate(0,-FONT_THUMBNAIL_HEIGHT*e.imgidx),r.drawImage(t.spriteThumbs,0,0),r.restore(),n.toDataURL()},getImageWidth:function(){return t.iconWidth},getImageHeight:function(){return t.iconHeight}});return Ext.apply(e,{listConfig:{id:Ext.isDefined(e.listId)?e.listId:"combo-fonts-list",emptyText:"no fonts found",mode:"local",width:326,maxHeight:468,height:468,minHeight:150,itemTpl:n,blockRefresh:!0,listeners:{viewready:function(e){t.spriteThumbs=undefined}}}}),this.initConfig(e),this.callParent(arguments),this},initComponent:function(){this.addListener("beforequery",this._beforeQuery,this),this.callParent(arguments)},onRender:function(e){this.callParent(arguments),this.el.set({"data-qtip":this.tooltip}),this.validate()},createPicker:function(){return this.callParent(arguments),this.showlastused&&this.fireEvent("createpicker",this,this.picker),this.picker},fillFonts:function(e){this._loadSprite();if(this.getStore().getCount()){var t=this.getStore().findRecord("name","Times New Roman");t?this.select(t):this.select(this.getStore().getAt(0))}},_loadSprite:function(){var e=this;e.spriteThumbs=new Image,e.spriteThumbs.src=window.g_standart_fonts_thumbnail},_beforeQuery:function(e){e.forceAll=!0,e.cancel=!0;if(e.combo){e.combo.expand();var t=e.combo.getPicker(),n=e.combo.store.find("name",e.query);if(n<0)$("#"+t.id+" ."+t.overItemCls).removeClass(t.overItemCls);else{var r=t.getNode(e.combo.store.getAt(n));if(r){t.highlightItem(r);var i=t.listEl.getHeight()/2-30,s=t.listEl.getTop(),o=Ext.get(r).getY()-s-i;if(Math.abs(o)>i){var u=$("#"+t.listEl.id).data("jsp");u&&u.scrollByY(o,!0)}}}}}}),Ext.define("DE.component.DimensionPicker",{extend:"Ext.Component",requires:"Ext.XTemplate",alias:"widget.dedimensionpicker",baseCls:"x-dimension-picker",itemSize:18,minRows:5,minColumns:5,maxRows:20,maxColumns:20,stalign:"bottom",padding:4,clickEvent:"click",value:null,renderTpl:['<div style="width: 100%; height: 100%;">','<div class="{baseCls}-observecontainer">','<div class="{baseCls}-mousecatcher"></div>','<div class="{baseCls}-unhighlighted"></div>','<div class="{baseCls}-highlighted"></div>',"</div>",'<div class="{baseCls}-status">0x0</div>',"</div>"],constructor:function(e){return this.initConfig(e),this.callParent(arguments),this},initComponent:function(){var e=this,t=undefined,n=undefined,r=undefined,i=undefined,s=undefined,o=0,u=0,a=function(t,n,r){var i=[t.browserEvent.layerX||(Ext.isDefined(t.browserEvent.offsetX)?t.browserEvent.offsetX:0),t.browserEvent.layerY||(Ext.isDefined(t.browserEvent.offsetY)?t.browserEvent.offsetY:0)];e.setTableSize(Math.floor(i[0]/this.itemSize),Math.floor(i[1]/this.itemSize))},f=function(t,n,r){var i=[t.browserEvent.layerX||(Ext.isDefined(t.browserEvent.offsetX)?t.browserEvent.offsetX:0),t.browserEvent.layerY||(Ext.isDefined(t.browserEvent.offsetY)?t.browserEvent.offsetY:0)];e.setTableSize(Math.ceil(i[0]/this.itemSize),Math.ceil(i[1]/this.itemSize))},l=function(t,n,r){var i=[t.browserEvent.layerX||(Ext.isDefined(t.browserEvent.offsetX)?t.browserEvent.offsetX:0),t.browserEvent.layerY||(Ext.isDefined(t.browserEvent.offsetY)?t.browserEvent.offsetY:0)];e.setTableSize(Math.ceil(i[0]/this.itemSize),Math.ceil(i[1]/this.itemSize))},c=function(t){e.fireEvent("select",e,o,u)};this.setTableSize=function(n,a){n>this.maxColumns&&(n=this.maxColumns),a>this.maxRows&&(a=this.maxRows);if(o!=n||u!=a)o=n,u=a,i.setSize(o+"em",u+"em"),r.setSize((o<e.minColumns?e.minColumns:o+1>e.maxColumns?e.maxColumns:o+1)+"em",(u<e.minRows?e.minRows:u+1>e.maxRows?e.maxRows:u+1)+"em"),t.setWidth(r.getWidth()),s.update(Ext.String.format("{0} x {1}",o,u)),s.setWidth(r.getWidth()),e.fireEvent("change",e,o,u)};var h=function(h){t=e.getEl(),t&&(n=t.down("."+e.baseCls+"-mousecatcher"),r=t.down("."+e.baseCls+"-unhighlighted"),i=t.down("."+e.baseCls+"-highlighted"),s=t.down("."+e.baseCls+"-status"),t.setStyle({width:e.minColumns+"em"}),n.setSize(e.maxColumns+"em",e.maxRows+"em"),r.setSize(e.minColumns+"em",e.minRows+"em"),s.update(Ext.String.format("{0} x {1}",o,u)),s.setWidth(r.getWidth())),n.on("mousemove",a,e),i.on("mousemove",f,e),r.on("mousemove",l,e),i.on("click",c,e)};this.getColumnsCount=function(){return o},this.getRowsCount=function(){return u},e.on("afterrender",h,this),e.callParent(arguments),e.addEvents("change","select")}}),Ext.define("DE.component.MenuDimensionPicker",{extend:"Ext.menu.Menu",alias:"widget.demenudimensionpicker",requires:["DE.component.DimensionPicker"],hideOnClick:!0,minWidth:10,minHeight:10,maxWidth:1e3,maxHeight:1e3,minRows:5,minColumns:5,maxRows:20,maxColumns:20,baseCls:"dimension-picker-menu",initComponent:function(){var e=this,t=Ext.apply({},e.initialConfig);delete t.listeners,Ext.apply(e,{plain:!0,showSeparator:!1,items:Ext.applyIf({xtype:"dedimensionpicker",minRows:this.minRows,minColumns:this.minColumns,maxRows:this.maxRows,maxColumns:this.maxColumns},t)}),e.callParent(arguments),e.picker=e.down("dedimensionpicker"),e.relayEvents(e.picker,["select"]),e.hideOnClick&&e.on("select",e.hidePickerOnSelect,e);var n=function(t,n,r){var i=n<e.picker.minColumns?e.picker.minColumns:n+1>e.picker.maxColumns?e.picker.maxColumns:n+1,s=r<e.picker.minRows?e.picker.minRows:r+1>e.picker.maxRows?e.picker.maxRows:r+1;i=i*e.picker.itemSize+2*e.picker.padding,s=s*e.picker.itemSize+2*e.picker.padding+e.picker.itemSize,e.setSize(i,s)};e.picker.addListener("change",n,this)},show:function(e,t,n){var r=this;r.callParent(arguments),r.picker.setTableSize(0,0),this.setSize(r.picker.minColumns*r.picker.itemSize+2*r.picker.padding,r.picker.minRows*r.picker.itemSize+2*r.picker.padding+r.picker.itemSize)},hidePickerOnSelect:function(e,t,n){Ext.menu.Manager.hideAll()}}),Ext.define("DE.view.DocumentLanguage",{extend:"Ext.window.Window",alias:"widget.dedocumentlanguage",requires:["Ext.window.Window","Ext.form.field.ComboBox","Common.plugin.ComboBoxScrollPane","Common.component.util.LanguageName"],modal:!0,closable:!0,closeAction:"hide",resizable:!1,preventHeader:!0,plain:!0,height:114,width:350,padding:"20px",layout:"vbox",layoutConfig:{align:"stretch"},constructor:function(e){return this.callParent(arguments),this.initConfig(e),this},initComponent:function(){var e=Ext.create("Ext.Button",{id:"langdialog-button-ok",text:this.okButtonText,width:80,cls:"asc-blue-button",listeners:{click:function(){this._modalresult=1,this.fireEvent("onmodalresult",this._modalresult),this.close()},scope:this}}),t=Ext.create("Ext.Button",{id:"langdialog-button-cancel",text:this.cancelButtonText,width:80,cls:"asc-darkgray-button",listeners:{click:function(){this._modalresult=0,this.fireEvent("onmodalresult",this._modalresult),this.close()},scope:this}});this.cmbLangs=Ext.create("Ext.form.field.ComboBox",{store:this.langs,mode:"local",triggerAction:"all",editable:!1,enableKeyEvents:!0,width:310,listConfig:{maxHeight:200},listeners:{select:Ext.bind(function(e,t,n){this.langNum=t[0].index},this),specialkey:function(n,r){r.getKey()==r.ENTER?e.fireEvent("click"):r.getKey()==r.ESC&&t.fireEvent("click")}},plugins:[{ptype:"comboboxscrollpane",pluginId:"scrollpane",settings:{enableKeyboardNavigation:!0}}]}),this.addEvents("onmodalresult"),this.items=[{xtype:"label",text:this.textLang,width:"100%",style:"text-align:left"},{xtype:"tbspacer",height:3},this.cmbLangs,{xtype:"tbspacer",height:3},{xtype:"container",width:310,layout:"hbox",layoutConfig:{align:"stretch"},items:[{xtype:"tbspacer",flex:1},e,{xtype:"tbspacer",width:5},t]}],this.callParent(arguments)},setSettings:function(e){this.langNum=undefined;if(e){var t=this.cmbLangs.findRecord("field1",e);t?this.cmbLangs.select(t):(this.cmbLangs.picker&&this.cmbLangs.picker.selModel&&(this.cmbLangs.picker.selModel.deselectAll(),this.cmbLangs.picker.selModel.lastSelected=null),this.cmbLangs.setValue(Common.util.LanguageName.getLocalLanguageName(e)[1]))}},getSettings:function(){return this.langNum!==undefined?this.langs[this.langNum][0]:undefined},textLang:"Select document language",cancelButtonText:"Cancel",okButtonText:"Ok"}),Ext.define("DE.view.InsertTableDialog",{extend:"Ext.window.Window",alias:"widget.deinserttabledialog",requires:["Ext.window.Window"],modal:!0,closable:!1,resizable:!1,preventHeader:!0,plain:!0,height:172,width:236,padding:"20px",layout:{type:"vbox",align:"stretch"},listeners:{show:function(){this.udColumns.focus(!1,500)}},initComponent:function(){var e=this;this.addEvents("onmodalresult"),this.items=[{xtype:"label",text:this.labelTitle||this.txtTitle,style:"margin: 0 0 15px 0; font-size: 15px;"},{xtype:"container",height:32,layout:{type:"hbox",align:"stretch"},items:[{xtype:"label",padding:"4px 0 0 0",width:130,text:this.txtColumns},this.udColumns=Ext.widget("numberfield",{minValue:1,maxValue:63,value:2,step:1,width:64,allowDecimals:!1,validateOnBlur:!1,msgTarget:"side",minText:this.txtMinText,maxText:this.txtMaxText,listeners:{specialkey:Ext.bind(function(e,t){t.getKey()==t.ENTER?this.btnOk.fireEvent("click"):t.getKey()==t.ESC&&this.btnCancel.fireEvent("click")},this)}})]},{xtype:"container",height:42,layout:{type:"hbox",align:"stretch"},items:[{xtype:"label",padding:"4px 0 0 0",width:130,text:this.txtRows},this.udRows=Ext.widget("numberfield",{minValue:1,maxValue:100,value:2,step:1,width:64,allowDecimals:!1,validateOnBlur:!1,msgTarget:"side",minText:this.txtMinText,maxText:this.txtMaxText,listeners:{specialkey:Ext.bind(function(e,t){t.getKey()==t.ENTER?this.btnOk.fireEvent("click"):t.getKey()==t.ESC&&this.btnCancel.fireEvent("click")},this)}})]},{xtype:"container",height:30,layout:{type:"vbox",align:"center"},items:[{xtype:"container",width:182,layout:{type:"hbox",align:"middle"},items:[this.btnOk=Ext.widget("button",{cls:"asc-blue-button",width:86,height:22,margin:"0 5px 0 0",text:this.okButtonText,listeners:{click:function(e){var t=this.udColumns.isValid(),n=this.udRows.isValid();if(!t||!n)return;this.fireEvent("onmodalresult",this,1,[this.udColumns.value,this.udRows.value]),this.close()},scope:this}}),this.btnCancel=Ext.widget("button",{cls:"asc-darkgray-button",width:86,height:22,text:this.cancelButtonText,listeners:{click:function(e){this.fireEvent("onmodalresult",this,0),this.close()},scope:this}})]}]}],this.callParent(arguments)},txtTitle:"Table size",txtColumns:"Number of Columns",txtRows:"Number of Rows",textInvalidRowsCols:"You need to specify valid rows and columns count.",cancelButtonText:"Cancel",okButtonText:"Ok",txtMinText:"The minimum value for this field is {0}",txtMaxText:"The maximum value for this field is {0}"}),Ext.define("DE.view.HyperlinkSettingsDialog",{extend:"Ext.window.Window",alias:"widget.dehyperlinksettingsdialog",requires:["Ext.window.Window"],modal:!0,closable:!0,resizable:!1,preventHeader:!0,plain:!0,height:216,width:350,padding:"20px 20px 18px 20px",layout:"vbox",layoutConfig:{align:"stretch"},listeners:{show:function(){this.txtUrl.focus(!1,500)}},constructor:function(e){return this.callParent(arguments),this.initConfig(e),this},initComponent:function(){this.isTextChanged=!1;var e=Ext.create("Ext.Button",{id:"addhyperlink-button-ok",text:this.okButtonText,width:80,cls:"asc-blue-button",listeners:{click:function(){if(!this.txtUrl.isValid()||!this.txtDisplay.isValid())return;this._modalresult=1,this.fireEvent("onmodalresult",this._modalresult),this.close()},scope:this}}),t=Ext.create("Ext.Button",{id:"addhyperlink-button-cancel",text:this.cancelButtonText,width:80,cls:"asc-darkgray-button",listeners:{click:function(){this._modalresult=0,this.fireEvent("onmodalresult",this._modalresult),this.close()},scope:this}});this.txtUrl=Ext.create("Ext.form.Text",{id:"addhyperlink-text-url",width:310,msgTarget:"side",validateOnChange:!1,allowBlank:!1,value:"http://",blankText:this.txtEmpty,regex:/(([\-\wа-яё]+\.)+[\wа-яё]{2,3}(\/[%\-\wа-яё]+(\.[\wа-яё]{2,})?)*(([\wа-яё\-\.\?\\\/+@&#;`~=%!]*)(\.[\wа-яё]{2,})?)*\/?)/i,regexText:this.txtNotUrl,listeners:{specialkey:function(n,r){r.getKey()==r.ENTER?e.fireEvent("click"):r.getKey()==r.ESC&&t.fireEvent("click")}}}),this.txtDisplay=Ext.create("Ext.form.Text",{id:"addhyperlink-text-display",width:310,msgTarget:"side",validateOnBlur:!1,allowBlank:!1,blankText:this.txtEmpty,value:"",listeners:{specialkey:function(n,r){r.getKey()==r.ENTER?e.fireEvent("click"):r.getKey()==r.ESC&&t.fireEvent("click")},change:function(e,t,n){this.isTextChanged=!0},scope:this}}),this.txtTooltip=Ext.create("Ext.form.Text",{id:"addhyperlink-text-tooltip",width:310,msgTarget:"side",validateOnBlur:!1,allowBlank:!0,value:"",listeners:{specialkey:function(n,r){r.getKey()==r.ENTER?e.fireEvent("click"):r.getKey()==r.ESC&&t.fireEvent("click")}}}),this.addEvents("onmodalresult"),this.items=[{xtype:"label",text:this.textUrl,width:"100%",style:"text-align:left"},{xtype:"tbspacer",height:3},this.txtUrl,{xtype:"tbspacer",height:3},{xtype:"label",text:this.textDisplay,width:"100%",style:"text-align:left"},{xtype:"tbspacer",height:3},this.txtDisplay,{xtype:"tbspacer",height:3},{xtype:"label",text:this.textTooltip,width:"100%",style:"text-align:left"},{xtype:"tbspacer",height:3},this.txtTooltip,{xtype:"tbspacer",height:8},{xtype:"container",width:310,layout:"hbox",layoutConfig:{align:"stretch"},items:[{xtype:"tbspacer",flex:1},e,{xtype:"tbspacer",width:5},t]}],this.callParent(arguments)},setSettings:function(e){e&&(e.get_Value()?this.txtUrl.setValue(e.get_Value()):this.txtUrl.setValue(""),e.get_Text()!==null?(this.txtDisplay.setValue(e.get_Text()),this.txtDisplay.setDisabled(!1)):(this.txtDisplay.setValue(this.textDefault),this.txtDisplay.setDisabled(!0)),this.isTextChanged=!1,this.txtTooltip.setValue(e.get_ToolTip()))},getSettings:function(){var e=new CHyperlinkProperty,t=this.txtUrl.getValue().trim();return/(((^https?)|(^ftp)):\/\/)/i.test(t)||(t="http://"+t),e.put_Value(t),!this.txtDisplay.isDisabled()&&this.isTextChanged?e.put_Text(this.txtDisplay.getValue()):e.put_Text(null),e.put_ToolTip(this.txtTooltip.getValue()),e},textUrl:"Link to",textDisplay:"Display",cancelButtonText:"Cancel",okButtonText:"Ok",txtEmpty:"This field is required",txtNotUrl:'This field should be a URL in the format "http://www.example.com"',textTooltip:"ScreenTip text",textDefault:"Selected text"}),Ext.define("DE.view.ShapeSettingsAdvancedCnt",{extend:"Ext.container.Container",alias:"widget.peshapesettingsadvancedcnt",requires:["Ext.form.field.ComboBox","Ext.data.Model","Ext.data.Store","Ext.Array","Ext.button.Button"],cls:"image-advanced-container",height:330,width:320,layout:{type:"vbox",align:"stretch"},initComponent:function(){var e=this;this._originalProps=null,this._changedProps=null,this._beginSizeIdx=0,this._endSizeIdx=0,this._arrCapType=[[c_oAscLineCapType.Flat,this.textFlat],[c_oAscLineCapType.Round,this.textRound],[c_oAscLineCapType.Square,this.textSquare]],this.cmbCapType=Ext.create("Ext.form.field.ComboBox",{id:"shape-advanced-cap-type",width:100,editable:!1,store:this._arrCapType,queryMode:"local",triggerAction:"all",listeners:{select:Ext.bind(function(t,n,r){this._changedProps&&(this._changedProps.get_stroke()===null&&this._changedProps.put_stroke(new CAscStroke),this._changedProps.get_stroke().put_linecap(e._arrCapType[n[0].index][0]))},this)}}),this.cmbCapType.setValue(this._arrCapType[0][1]),this._arrJoinType=[[c_oAscLineJoinType.Round,this.textRound],[c_oAscLineJoinType.Bevel,this.textBevel],[c_oAscLineJoinType.Miter,this.textMiter]],this.cmbJoinType=Ext.create("Ext.form.field.ComboBox",{id:"shape-advanced-join-type",width:100,editable:!1,store:this._arrJoinType,queryMode:"local",triggerAction:"all",listeners:{select:Ext.bind(function(t,n,r){this._changedProps&&(this._changedProps.get_stroke()===null&&this._changedProps.put_stroke(new CAscStroke),this._changedProps.get_stroke().put_linejoin(e._arrJoinType[n[0].index][0]))},this)}}),this.cmbJoinType.setValue(this._arrJoinType[0][1]),this.styleURL="resources/img/right-panels/Begin-EndStyle.png",this.styleURL2x="resources/img/right-panels/Begin-EndStyle@2x.png";var t=[],n=[],r=[c_oAscLineBeginType.None,c_oAscLineBeginType.Triangle,c_oAscLineBeginType.Arrow,c_oAscLineBeginType.Stealth,c_oAscLineBeginType.Diamond,c_oAscLineBeginType.Oval],i=[c_oAscLineBeginSize.small_small,c_oAscLineBeginSize.small_mid,c_oAscLineBeginSize.small_large,c_oAscLineBeginSize.mid_small,c_oAscLineBeginSize.mid_mid,c_oAscLineBeginSize.mid_large,c_oAscLineBeginSize.large_small,c_oAscLineBeginSize.large_mid,c_oAscLineBeginSize.large_large];for(var s=0;s<6;s++){var o={value:s,imagewidth:44,imageheight:20,offsetx:80*s+10,offsety:0};o.borderstyle=Ext.String.format("background:url({0}) {3}px {4}px; width:{1}px; height:{2}px; background-image: -webkit-image-set(url({0}) 1x, url({5}) 2x);",this.styleURL,o.imagewidth,o.imageheight,-o.offsetx,-o.offsety,this.styleURL2x),t.push(o)}t[0].type=c_oAscLineBeginType.None,t[1].type=c_oAscLineBeginType.Triangle,t[2].type=c_oAscLineBeginType.Arrow,t[3].type=c_oAscLineBeginType.Stealth,t[4].type=c_oAscLineBeginType.Diamond,t[5].type=c_oAscLineBeginType.Oval;for(s=0;s<9;s++){var o={value:s,imagewidth:44,imageheight:20,offsetx:90,offsety:20*(s+1)};o.borderstyle=Ext.String.format("background:url({0}) {3}px {4}px; width:{1}px; height:{2}px; background-image: -webkit-image-set(url({0}) 1x, url({5}) 2x);",this.styleURL,o.imagewidth,o.imageheight,-o.offsetx,-o.offsety,this.styleURL2x),n.push(o)}n[0].type=c_oAscLineBeginSize.small_small,n[1].type=c_oAscLineBeginSize.small_mid,n[2].type=c_oAscLineBeginSize.small_large,n[3].type=c_oAscLineBeginSize.mid_small,n[4].type=c_oAscLineBeginSize.mid_mid,n[5].type=c_oAscLineBeginSize.mid_large,n[6].type=c_oAscLineBeginSize.large_small,n[7].type=c_oAscLineBeginSize.large_mid,n[8].type=c_oAscLineBeginSize.large_large;var u=Ext.create("Ext.data.Store",{model:"DE.model.ModelBorders",data:t}),a=Ext.create("Ext.data.Store",{model:"DE.model.ModelBorders",data:n});for(s=0;s<t.length;s++){var o=t[s];o.borderstyle=Ext.String.format("background:url({0}) {3}px {4}px; width:{1}px; height:{2}px; background-image: -webkit-image-set(url({0}) 1x, url({5}) 2x);",this.styleURL,o.imagewidth,o.imageheight,-o.offsetx,-(o.offsety+200),this.styleURL2x)}for(s=0;s<n.length;s++){var o=n[s];o.borderstyle=Ext.String.format("background:url({0}) {3}px {4}px; width:{1}px; height:{2}px; background-image: -webkit-image-set(url({0}) 1x, url({5}) 2x);",this.styleURL,o.imagewidth,o.imageheight,-o.offsetx,-(o.offsety+200),this.styleURL2x)}var f=Ext.create("Ext.data.Store",{model:"DE.model.ModelBorders",data:t}),l=Ext.create("Ext.data.Store",{model:"DE.model.ModelBorders",data:n});this._updateSizeArr=function(t,r,i,s){var o=Ext.String.format("background:url({0}) repeat scroll 0 -1px","resources/img/controls/text-bg.gif");if(r.data.value>0){for(var u=0;u<n.length;u++)n[u].offsetx=r.data.value*80+10,n[u].borderstyle=Ext.String.format("background:url({0}) {3}px {4}px; width:{1}px; height:{2}px; background-image: -webkit-image-set(url({0}) 1x, url({5}) 2x);",e.styleURL,n[u].imagewidth,n[u].imageheight,-n[u].offsetx,-(n[u].offsety+200*i),this.styleURL2x);t.menu.picker.store.loadData(n),t.setDisabled(!1),s!==null?(t.menu.picker.selectByIndex(s,!0),e._selectStyleItem(t,t.menu.picker.store.getAt(s),i)):Ext.DomHelper.applyStyles(t.btnEl,o)}else Ext.DomHelper.applyStyles(t.btnEl,o),t.setDisabled(!0)},this._selectStyleItem=function(t,n,r){var i;t.btnEl&&(i=Ext.String.format("background:url({0}) repeat scroll {1}px {2}px, url({3}) repeat scroll 0 -1px;",e.styleURL,-(n.data.offsetx-20),-(n.data.offsety+200*r),"resources/img/controls/text-bg.gif"),i+=Ext.String.format("background-image: -webkit-image-set(url({0}) 1x, url({1}) 2x), -webkit-image-set(url({2}) 1x, url({3}) 2x);",e.styleURL,e.styleURL2x,"resources/img/controls/text-bg.gif","resources/img/controls/text-bg@2x.gif"),Ext.DomHelper.applyStyles(t.btnEl,i))};var c=Ext.create("Ext.XTemplate",'<tpl for=".">','<div class="thumb-wrap">','<img src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" align="left" style="{borderstyle}"" />',"</div>","</tpl>");this._btnBeginStyle=Ext.create("Ext.button.Button",{width:100,cls:"btn-combo-style",pressedCls:"",menu:this.BeginStyleMenu=Ext.create("Common.component.MenuDataViewPicker",{width:115,height:92,cls:"arrow-view",dataTpl:c,viewData:[],store:u,contentWidth:95,listeners:{select:Ext.bind(function(t,n){e._changedProps&&(this._changedProps.get_stroke()===null&&this._changedProps.put_stroke(new CAscStroke),this._changedProps.get_stroke().put_linebeginstyle(n.data.type));if(this._beginSizeIdx===null||this._beginSizeIdx===undefined)this._beginSizeIdx=4;e._updateSizeArr(e._btnBeginSize,n,0,this._beginSizeIdx),e._selectStyleItem(e._btnBeginStyle,n,0)},e),hide:function(){e.fireEvent("editcomplete",e)}}}),listeners:{afterRender:function(){e._selectStyleItem(this,this.menu.picker.store.getAt(1),0)}}}),this._btnEndStyle=Ext.create("Ext.button.Button",{width:100,cls:"btn-combo-style",pressedCls:"",menu:this.EndStyleMenu=Ext.create("Common.component.MenuDataViewPicker",{width:115,height:92,cls:"arrow-view",dataTpl:c,viewData:[],store:f,contentWidth:95,listeners:{select:Ext.bind(function(t,n){e._changedProps&&(this._changedProps.get_stroke()===null&&this._changedProps.put_stroke(new CAscStroke),this._changedProps.get_stroke().put_lineendstyle(n.data.type));if(this._endSizeIdx===null||this._endSizeIdx===undefined)this._endSizeIdx=4;e._updateSizeArr(e._btnEndSize,n,1,this._endSizeIdx),e._selectStyleItem(e._btnEndStyle,n,1)},e),hide:function(){e.fireEvent("editcomplete",e)}}}),listeners:{afterRender:function(){e._selectStyleItem(this,this.menu.picker.store.getAt(1),1)}}}),this._btnBeginSize=Ext.create("Ext.button.Button",{width:100,cls:"btn-combo-style",pressedCls:"",menu:this.BeginSizeMenu=Ext.create("Common.component.MenuDataViewPicker",{width:167,height:92,cls:"arrow-view",dataTpl:c,viewData:[],store:a,contentWidth:147,listeners:{select:Ext.bind(function(t,n){e._changedProps&&(this._changedProps.get_stroke()===null&&this._changedProps.put_stroke(new CAscStroke),this._changedProps.get_stroke().put_linebeginsize(n.data.type)),this._beginSizeIdx=n.data.value,e._selectStyleItem(e._btnBeginSize,n,0)},e),hide:function(){e.fireEvent("editcomplete",e)}}}),listeners:{afterRender:function(){e._selectStyleItem(this,this.menu.picker.store.getAt(1),0)}}}),this._btnEndSize=Ext.create("Ext.button.Button",{width:100,cls:"btn-combo-style",pressedCls:"",menu:this.BeginSizeMenu=Ext.create("Common.component.MenuDataViewPicker",{width:167,height:92,cls:"arrow-view",dataTpl:c,viewData:[],store:l,contentWidth:147,listeners:{select:Ext.bind(function(t,n){e._changedProps&&(this._changedProps.get_stroke()===null&&this._changedProps.put_stroke(new CAscStroke),this._changedProps.get_stroke().put_lineendsize(n.data.type)),this._endSizeIdx=n.data.value,e._selectStyleItem(e._btnEndSize,n,1)},e),hide:function(){e.fireEvent("editcomplete",e)}}}),listeners:{afterRender:function(){e._selectStyleItem(this,this.menu.picker.store.getAt(1),1)}}}),this._spacer=Ext.create("Ext.toolbar.Spacer",{width:"100%",height:10,html:'<div style="width: 100%; height: 40%; border-bottom: 1px solid #C7C7C7"></div>'}),this.items=[{xtype:"label",style:"font-weight: bold;margin-top: 1px; padding-left:10px;height:13px;",text:this.textLineStyle},{xtype:"tbspacer",height:8},{xtype:"container",height:40,padding:"0 10",layout:{type:"table",columns:2,tdAttrs:{style:"padding-right: 40px;vertical-align: middle;"}},items:[{xtype:"label",text:this.textCapType,width:85},{xtype:"label",text:this.textJoinType,width:85},{xtype:"tbspacer",height:2},{xtype:"tbspacer",height:2},this.cmbCapType,this.cmbJoinType]},this._spacer.cloneConfig({style:"margin: 16px 0 11px 0;",height:6}),{xtype:"label",style:"font-weight: bold;margin-top: 1px; padding-left:10px;height:13px;",text:this.textArrows},{xtype:"tbspacer",height:8},{xtype:"container",height:86,padding:"0 10",layout:{type:"table",columns:2,tdAttrs:{style:"padding-right: 40px;vertical-align: middle;"}},items:[{xtype:"label",text:this.textBeginStyle,width:85},{xtype:"label",text:this.textEndStyle,width:85},{xtype:"tbspacer",height:2},{xtype:"tbspacer",height:2},this._btnBeginStyle,this._btnEndStyle,{xtype:"tbspacer",height:5},{xtype:"tbspacer",height:5},{xtype:"label",text:this.textBeginSize,width:85},{xtype:"label",text:this.textEndSize,width:85},{xtype:"tbspacer",height:2},{xtype:"tbspacer",height:2},this._btnBeginSize,this._btnEndSize]}],this.callParent(arguments)},afterRender:function(){this.callParent(arguments)},setSettings:function(e){this._originalProps=e,this._changedProps=null},_setDefaults:function(e){if(e){var t=e.get_stroke();if(t){var n=t.get_linejoin();for(var r=0;r<this._arrJoinType.length;r++)if(n==this._arrJoinType[r][0]){this.cmbJoinType.setValue(this._arrJoinType[r][1]);break}n=t.get_linecap();for(r=0;r<this._arrCapType.length;r++)if(n==this._arrCapType[r][0]){this.cmbCapType.setValue(this._arrCapType[r][1]);break}var i=t.get_canChangeArrows();this._btnBeginStyle.setDisabled(!i),this._btnEndStyle.setDisabled(!i),this._btnBeginSize.setDisabled(!i),this._btnEndSize.setDisabled(!i);var s=Ext.String.format("background:url({0}) repeat scroll 0 -1px","resources/img/controls/text-bg.gif");if(i){n=t.get_linebeginsize();var o=this._btnBeginSize.menu.picker.store.findRecord("type",n);o!==null?this._beginSizeIdx=o.data.value:(this._beginSizeIdx=null,Ext.DomHelper.applyStyles(this._btnBeginSize.btnEl,s)),n=t.get_linebeginstyle(),o=this._btnBeginStyle.menu.picker.store.findRecord("type",n),o!==null?(this._btnBeginStyle.menu.picker.selectByIndex(o.data.value,!1),this._updateSizeArr(this._btnBeginSize,o,0,this._beginSizeIdx),this._selectStyleItem(this._btnBeginStyle,o,0)):Ext.DomHelper.applyStyles(this._btnBeginStyle.btnEl,s),n=t.get_lineendsize(),o=this._btnEndSize.menu.picker.store.findRecord("type",n),o!==null?this._endSizeIdx=o.data.value:(this._endSizeIdx=null,Ext.DomHelper.applyStyles(this._btnEndSize.btnEl,s)),n=t.get_lineendstyle(),o=this._btnEndStyle.menu.picker.store.findRecord("type",n),o!==null?(this._btnEndStyle.menu.picker.selectByIndex(o.data.value,!1),this._updateSizeArr(this._btnEndSize,o,1,this._endSizeIdx),this._selectStyleItem(this._btnEndStyle,o,1)):Ext.DomHelper.applyStyles(this._btnEndStyle.btnEl,s)}else Ext.DomHelper.applyStyles(this._btnBeginStyle.btnEl,s),Ext.DomHelper.applyStyles(this._btnEndStyle.btnEl,s),Ext.DomHelper.applyStyles(this._btnBeginSize.btnEl,s),Ext.DomHelper.applyStyles(this._btnEndSize.btnEl,s)}}this._changedProps=new CAscShapeProp},getSettings:function(){return this._changedProps},textRound:"Round",textMiter:"Miter",textSquare:"Square",textFlat:"Flat",textBevel:"Bevel",textTitle:"Shape - Advanced Settings",cancelButtonText:"Cancel",okButtonText:"Ok",txtNone:"None",textWeightArrows:"Weights & Arrows",textArrows:"Arrows",textLineStyle:"Line Style",textCapType:"Cap Type",textJoinType:"Join Type",textBeginStyle:"Begin Style",textBeginSize:"Begin Size",textEndStyle:"End Style",textEndSize:"End Size"}),Ext.define("DE.view.ImageSettingsAdvanced",{extend:"Ext.window.Window",alias:"widget.deimagesettingsadvanced",requires:["Common.component.MetricSpinner","Ext.window.Window","Ext.form.field.Radio","DE.view.ShapeSettingsAdvancedCnt","Ext.util.Cookies"],cls:"asc-advanced-settings-window",modal:!0,resizable:!1,plain:!0,constrain:!0,height:442,width:516,layout:{type:"vbox",align:"stretch"},_defaults:{sizeOriginal:{width:0,height:0},sizeMax:{width:55.88,height:55.88},properties:null},listeners:{show:function(){this.btnWrapInline.pressed&&this._DisableElem(c_oAscWrapStyle2.Inline)}},initComponent:function(){function t(e){e.pressed&&a.getLayout().setActiveItem(e.card)}var e=this;this.addEvents("onmodalresult"),this._state={HAlignTypeIdx:0,HAlignFromIdx:0,HPositionFromIdx:0,VAlignTypeIdx:0,VAlignFromIdx:0,VPositionFromIdx:0,spnXChanged:!1,spnYChanged:!1},this._changedProps=null,this._objectType=c_oAscTypeSelectElement.Image,this.Margins=undefined,this._nRatio=1,this._spnWidth=Ext.create("Common.component.MetricSpinner",{id:"image-advanced-spin-width",readOnly:!1,maxValue:55.88,minValue:0,step:.1,defaultUnit:"cm",value:"3 cm",width:80,listeners:{change:Ext.bind(function(e,t,n,r){if(this._btnRatio.pressed){var i=e.getNumberValue(),s=i/this._nRatio;s>this._defaults.sizeMax.height&&(s=this._defaults.sizeMax.height,i=s*this._nRatio,this._spnWidth.suspendEvents(!1),this._spnWidth.setValue(i),this._spnWidth.resumeEvents()),this._spnHeight.suspendEvents(!1),this._spnHeight.setValue(s),this._spnHeight.resumeEvents()}this._changedProps&&(this._changedProps.put_Width(Common.MetricSettings.fnRecalcToMM(e.getNumberValue())),this._changedProps.put_Height(Common.MetricSettings.fnRecalcToMM(this._spnHeight.getNumberValue())))},this)}}),this._spnHeight=Ext.create("Common.component.MetricSpinner",{id:"image-advanced-span-height",readOnly:!1,maxValue:55.88,minValue:0,step:.1,defaultUnit:"cm",value:"3 cm",width:80,listeners:{change:Ext.bind(function(e,t,n,r){var i=e.getNumberValue(),s=null;this._btnRatio.pressed&&(s=i*this._nRatio,s>this._defaults.sizeMax.width&&(s=this._defaults.sizeMax.width,i=s/this._nRatio,this._spnHeight.suspendEvents(!1),this._spnHeight.setValue(i),this._spnHeight.resumeEvents()),this._spnWidth.suspendEvents(!1),this._spnWidth.setValue(s),this._spnWidth.resumeEvents()),this._changedProps&&(this._changedProps.put_Height(Common.MetricSettings.fnRecalcToMM(e.getNumberValue())),this._changedProps.put_Width(Common.MetricSettings.fnRecalcToMM(this._spnWidth.getNumberValue())))},this)}}),this._btnOriginalSize=Ext.create("Ext.Button",{id:"image-advanced-button-original-size",text:this.textOriginalSize,width:100,height:22,style:"margin: 0 0 0 7px",listeners:{click:function(e,t){this._spnWidth.suspendEvents(!1),this._spnHeight.suspendEvents(!1),this._spnWidth.setValue(this._defaults.sizeOriginal.width),this._spnHeight.setValue(this._defaults.sizeOriginal.height),this._spnWidth.resumeEvents(),this._spnHeight.resumeEvents(),this._nRatio=this._defaults.sizeOriginal.width/this._defaults.sizeOriginal.height,this._changedProps&&(this._changedProps.put_Height(Common.MetricSettings.fnRecalcToMM(this._spnHeight.getNumberValue())),this._changedProps.put_Width(Common.MetricSettings.fnRecalcToMM(this._spnWidth.getNumberValue())))},scope:this}}),this._btnRatio=Ext.create("Ext.Button",{id:"image-advanced-button-ratio",iconCls:"advanced-btn-ratio",enableToggle:!0,width:22,height:22,style:"margin: 0 0 0 6px;",tooltip:this.textKeepRatio,toggleHandler:Ext.bind(function(e){e.pressed&&this._spnHeight.getNumberValue()>0&&(this._nRatio=this._spnWidth.getNumberValue()/this._spnHeight.getNumberValue())},this)}),this._spacer=Ext.create("Ext.toolbar.Spacer",{width:"100%",height:10,html:'<div style="width: 100%; height: 40%; border-bottom: 1px solid #C7C7C7"></div>'}),this.btnWrapInline=Ext.create("Ext.Button",{id:"image-advanced-button-wrap-inline",cls:"asc-right-panel-wrapbtn btn-wrap-inline",posId:c_oAscWrapStyle2.Inline,margin:"0 10 0 0",text:"",tooltip:this.textWrapInlineTooltip,enableToggle:!0,allowDepress:!1,toggleGroup:"imgAdvWrapGroup",pressed:!0,toggleHandler:Ext.bind(function(e){this._DisableElem(e.posId),this._changedProps&&this._changedProps.put_WrappingStyle(e.posId)},this)}),this.btnWrapSquare=Ext.create("Ext.Button",{id:"image-advanced-button-wrap-square",cls:"asc-right-panel-wrapbtn btn-wrap-square",posId:c_oAscWrapStyle2.Square,margin:"0 10 0 0",text:"",tooltip:this.textWrapSquareTooltip,enableToggle:!0,allowDepress:!1,toggleGroup:"imgAdvWrapGroup",toggleHandler:Ext.bind(function(e){this._DisableElem(e.posId),this._changedProps&&this._changedProps.put_WrappingStyle(e.posId)},this)}),this.btnWrapTight=Ext.create("Ext.Button",{id:"image-advanced-button-wrap-tight",cls:"asc-right-panel-wrapbtn btn-wrap-tight",posId:c_oAscWrapStyle2.Tight,margin:"0 10 0 0",text:"",tooltip:this.textWrapTightTooltip,enableToggle:!0,allowDepress:!1,toggleGroup:"imgAdvWrapGroup",toggleHandler:Ext.bind(function(e){this._DisableElem(e.posId),this._changedProps&&this._changedProps.put_WrappingStyle(e.posId)},this)}),this.btnWrapThrough=Ext.create("Ext.Button",{id:"image-advanced-button-wrap-through",cls:"asc-right-panel-wrapbtn btn-wrap-through",posId:c_oAscWrapStyle2.Through,margin:"0 10 0 0",text:"",tooltip:this.textWrapThroughTooltip,enableToggle:!0,allowDepress:!1,toggleGroup:"imgAdvWrapGroup",toggleHandler:Ext.bind(function(e){this._DisableElem(e.posId),this._changedProps&&this._changedProps.put_WrappingStyle(e.posId)},this)}),this.btnWrapTopBottom=Ext.create("Ext.Button",{id:"image-advanced-button-wrap-topbottom",cls:"asc-right-panel-wrapbtn btn-wrap-topbottom",posId:c_oAscWrapStyle2.TopAndBottom,margin:"0 10 0 0",text:"",tooltip:this.textWrapNoneTopbottom,enableToggle:!0,allowDepress:!1,toggleGroup:"imgAdvWrapGroup",toggleHandler:Ext.bind(function(e){this._DisableElem(e.posId),this._changedProps&&this._changedProps.put_WrappingStyle(e.posId)},this)}),this.btnWrapBehind=Ext.create("Ext.Button",{id:"image-advanced-button-wrap-behind",cls:"asc-right-panel-wrapbtn btn-wrap-behind",posId:c_oAscWrapStyle2.Behind,margin:"0 10 0 0",text:"",tooltip:this.textWrapBehindTooltip,enableToggle:!0,allowDepress:!1,toggleGroup:"imgAdvWrapGroup",toggleHandler:Ext.bind(function(e){this._DisableElem(e.posId),this._changedProps&&this._changedProps.put_WrappingStyle(e.posId)},this)}),this.btnWrapInFront=Ext.create("Ext.Button",{id:"image-advanced-button-wrap-infront",cls:"asc-right-panel-wrapbtn btn-wrap-infront",posId:c_oAscWrapStyle2.InFront,margin:"0 10 0 0",text:"",tooltip:this.textWrapInFrontTooltip,enableToggle:!0,allowDepress:!1,toggleGroup:"imgAdvWrapGroup",toggleHandler:Ext.bind(function(e){this._DisableElem(e.posId),this._changedProps&&this._changedProps.put_WrappingStyle(e.posId)},this)}),this._spnTop=Ext.create("Common.component.MetricSpinner",{id:"image-span-top",readOnly:!1,maxValue:55.87,minValue:0,step:.1,defaultUnit:"cm",value:"0 cm",width:85,listeners:{change:Ext.bind(function(e,t,n,r){this._changedProps&&((this._changedProps.get_Paddings()===null||this._changedProps.get_Paddings()===undefined)&&this._changedProps.put_Paddings(new CPaddings),this._changedProps.get_Paddings().put_Top(Common.MetricSettings.fnRecalcToMM(e.getNumberValue())))},this)}}),this._spnBottom=Ext.create("Common.component.MetricSpinner",{id:"image-span-bottom",readOnly:!1,maxValue:55.87,minValue:0,step:.1,defaultUnit:"cm",value:"0 cm",width:85,listeners:{change:Ext.bind(function(e,t,n,r){this._changedProps&&((this._changedProps.get_Paddings()===null||this._changedProps.get_Paddings()===undefined)&&this._changedProps.put_Paddings(new CPaddings),this._changedProps.get_Paddings().put_Bottom(Common.MetricSettings.fnRecalcToMM(e.getNumberValue())))},this)}}),this._spnLeft=Ext.create("Common.component.MetricSpinner",{id:"image-span-left",readOnly:!1,maxValue:55.87,minValue:0,step:.1,defaultUnit:"cm",value:"0.32 cm",width:85,listeners:{change:Ext.bind(function(e,t,n,r){this._changedProps&&((this._changedProps.get_Paddings()===null||this._changedProps.get_Paddings()===undefined)&&this._changedProps.put_Paddings(new CPaddings),this._changedProps.get_Paddings().put_Left(Common.MetricSettings.fnRecalcToMM(e.getNumberValue())))},this)}}),this._spnRight=Ext.create("Common.component.MetricSpinner",{id:"image-span-right",readOnly:!1,maxValue:55.87,minValue:0,step:.1,defaultUnit:"cm",value:"0.32 cm",width:85,listeners:{change:Ext.bind(function(e,t,n,r){this._changedProps&&((this._changedProps.get_Paddings()===null||this._changedProps.get_Paddings()===undefined)&&this._changedProps.put_Paddings(new CPaddings),this._changedProps.get_Paddings().put_Right(Common.MetricSettings.fnRecalcToMM(e.getNumberValue())))},this)}}),this._spnX=Ext.create("Common.component.MetricSpinner",{id:"image-span-x",readOnly:!1,maxValue:55.87,minValue:-55.87,step:.1,defaultUnit:"cm",value:"0 cm",width:115,disabled:!0,listeners:{change:Ext.bind(function(e,t,n,r){this._changedProps&&((this._changedProps.get_PositionH()===null||this._changedProps.get_PositionH()===undefined)&&this._changedProps.put_PositionH(new CImagePositionH),this._changedProps.get_PositionH().put_UseAlign(!1),this._changedProps.get_PositionH().put_RelativeFrom(this._arrHRelative[this._state.HPositionFromIdx][0]),this._changedProps.get_PositionH().put_Value(Common.MetricSettings.fnRecalcToMM(e.getNumberValue())),this._state.spnXChanged=!0)},this)}}),this._spnY=Ext.create("Common.component.MetricSpinner",{id:"image-span-y",readOnly:!1,maxValue:55.87,minValue:-55.87,step:.1,defaultUnit:"cm",value:"0 cm",width:115,disabled:!0,listeners:{change:Ext.bind(function(e,t,n,r){this._changedProps&&((this._changedProps.get_PositionV()===null||this._changedProps.get_PositionV()===undefined)&&this._changedProps.put_PositionV(new CImagePositionV),this._changedProps.get_PositionV().put_UseAlign(!1),this._changedProps.get_PositionV().put_RelativeFrom(this._arrVRelative[this._state.VPositionFromIdx][0]),this._changedProps.get_PositionV().put_Value(Common.MetricSettings.fnRecalcToMM(e.getNumberValue())),this._state.spnYChanged=!0)},this)}}),this._arrHAlign=[[c_oAscAlignH.Left,this.textLeft],[c_oAscAlignH.Center,this.textCenter],[c_oAscAlignH.Right,this.textRight]],this.cmbHAlign=Ext.create("Ext.form.field.ComboBox",{id:"image-combo-halign",width:115,editable:!1,store:this._arrHAlign,queryMode:"local",triggerAction:"all",listeners:{select:Ext.bind(function(e,t,n){this._changedProps&&((this._changedProps.get_PositionH()===null||this._changedProps.get_PositionH()===undefined)&&this._changedProps.put_PositionH(new CImagePositionH),this._changedProps.get_PositionH().put_UseAlign(!0),this._changedProps.get_PositionH().put_RelativeFrom(this._arrHRelative[this._state.HAlignFromIdx][0]),this._changedProps.get_PositionH().put_Align(this._arrHAlign[t[0].index][0]),this._state.HAlignTypeIdx=t[0].index)},this)}}),this.cmbHAlign.setValue(this._arrHAlign[0][0]),this._arrHRelative=[[c_oAscRelativeFromH.Character,this.textCharacter],[c_oAscRelativeFromH.Column,this.textColumn],[c_oAscRelativeFromH.LeftMargin,this.textLeftMargin],[c_oAscRelativeFromH.Margin,this.textMargin],[c_oAscRelativeFromH.Page,this.textPage],[c_oAscRelativeFromH.RightMargin,this.textRightMargin]],this.cmbHRelative=Ext.create("Ext.form.field.ComboBox",{id:"image-combo-hrelative",width:115,editable:!1,store:this._arrHRelative,queryMode:"local",triggerAction:"all",listeners:{select:Ext.bind(function(e,t,n){this._changedProps&&((this._changedProps.get_PositionH()===null||this._changedProps.get_PositionH()===undefined)&&this._changedProps.put_PositionH(new CImagePositionH),this._changedProps.get_PositionH().put_UseAlign(!0),this._changedProps.get_PositionH().put_RelativeFrom(this._arrHRelative[t[0].index][0]),this._changedProps.get_PositionH().put_Align(this._arrHAlign[this._state.HAlignTypeIdx][0]),this._state.HAlignFromIdx=t[0].index)},this)}}),this.cmbHRelative.setValue(this._arrHRelative[0][0]),this.cmbHPosition=Ext.create("Ext.form.field.ComboBox",{id:"image-combo-hposition",width:115,editable:!1,store:this._arrHRelative,queryMode:"local",triggerAction:"all",disabled:!0,listeners:{select:Ext.bind(function(e,t,n){if(this._changedProps){(this._changedProps.get_PositionH()===null||this._changedProps.get_PositionH()===undefined)&&this._changedProps.put_PositionH(new CImagePositionH),this._changedProps.get_PositionH().put_UseAlign(!1),this._changedProps.get_PositionH().put_RelativeFrom(this._arrHRelative[t[0].index][0]),this._state.HPositionFromIdx=t[0].index;if(!this._state.spnXChanged){var r=this._defaults.properties.get_Value_X(this._arrHRelative[t[0].index][0]);this._spnX.suspendEvents(!1),this._spnX.setValue(Common.MetricSettings.fnRecalcFromMM(r)),this._spnX.resumeEvents()}this._changedProps.get_PositionH().put_Value(Common.MetricSettings.fnRecalcToMM(this._spnX.getNumberValue()))}},this)}}),this.cmbHPosition.setValue(this._arrHRelative[0][0]),this._arrVAlign=[[c_oAscAlignV.Top,this.textTop],[c_oAscAlignV.Center,this.textCenter],[c_oAscAlignV.Bottom,this.textBottom]],this.cmbVAlign=Ext.create("Ext.form.field.ComboBox",{id:"image-combo-valign",width:115,editable:!1,store:this._arrVAlign,queryMode:"local",triggerAction:"all",listeners:{select:Ext.bind(function(e,t,n){this._changedProps&&((this._changedProps.get_PositionV()===null||this._changedProps.get_PositionV()===undefined)&&this._changedProps.put_PositionV(new CImagePositionV),this._changedProps.get_PositionV().put_UseAlign(!0),this._changedProps.get_PositionV().put_RelativeFrom(this._arrVRelative[this._state.VAlignFromIdx][0]),this._changedProps.get_PositionV().put_Align(this._arrVAlign[t[0].index][0]),this._state.VAlignTypeIdx=t[0].index)},this)}}),this.cmbVAlign.setValue(this._arrVAlign[0][0]),this._arrVRelative=[[c_oAscRelativeFromV.Line,this.textLine],[c_oAscRelativeFromV.Margin,this.textMargin],[c_oAscRelativeFromV.BottomMargin,this.textBottomMargin],[c_oAscRelativeFromV.Paragraph,this.textParagraph],[c_oAscRelativeFromV.Page,this.textPage],[c_oAscRelativeFromV.TopMargin,this.textTopMargin]],this.cmbVRelative=Ext.create("Ext.form.field.ComboBox",{id:"image-combo-vrelative",width:115,editable:!1,store:this._arrVRelative,queryMode:"local",triggerAction:"all",listeners:{select:Ext.bind(function(e,t,n){this._changedProps&&((this._changedProps.get_PositionV()===null||this._changedProps.get_PositionV()===undefined)&&this._changedProps.put_PositionV(new CImagePositionV),this._changedProps.get_PositionV().put_UseAlign(!0),this._changedProps.get_PositionV().put_RelativeFrom(this._arrVRelative[t[0].index][0]),this._changedProps.get_PositionV().put_Align(this._arrVAlign[this._state.VAlignTypeIdx][0]),this._state.VAlignFromIdx=t[0].index,this.chMove.suspendEvents(!1),this.chMove.setValue(this._arrVRelative[t[0].index][0]==c_oAscRelativeFromV.Line||this._arrVRelative[t[0].index][0]==c_oAscRelativeFromV.Paragraph),this.chMove.resumeEvents())},this)}}),this.cmbVRelative.setValue(this._arrVRelative[0][0]),this.cmbVPosition=Ext.create("Ext.form.field.ComboBox",{id:"image-combo-vposition",width:115,editable:!1,store:this._arrVRelative,queryMode:"local",triggerAction:"all",disabled:!0,listeners:{select:Ext.bind(function(e,t,n){if(this._changedProps){(this._changedProps.get_PositionV()===null||this._changedProps.get_PositionV()===undefined)&&this._changedProps.put_PositionV(new CImagePositionV),this._changedProps.get_PositionV().put_UseAlign(!1),this._changedProps.get_PositionV().put_RelativeFrom(this._arrVRelative[t[0].index][0]),this._state.VPositionFromIdx=t[0].index;if(!this._state.spnYChanged){var r=this._defaults.properties.get_Value_Y(this._arrVRelative[t[0].index][0]);this._spnY.suspendEvents(!1),this._spnY.setValue(Common.MetricSettings.fnRecalcFromMM(r)),this._spnY.resumeEvents()}this._changedProps.get_PositionV().put_Value(Common.MetricSettings.fnRecalcToMM(this._spnY.getNumberValue())),this.chMove.suspendEvents(!1),this.chMove.setValue(this._arrVRelative[t[0].index][0]==c_oAscRelativeFromV.Line||this._arrVRelative[t[0].index][0]==c_oAscRelativeFromV.Paragraph),this.chMove.resumeEvents()}},this)}}),this.cmbVPosition.setValue(this._arrVRelative[0][0]),this.radioHAlign=Ext.create("Ext.form.field.Radio",{boxLabel:"",name:"asc-radio-horizontal",checked:!0,listeners:{change:Ext.bind(function(e,t,n,r){this._changedProps&&((this._changedProps.get_PositionH()===null||this._changedProps.get_PositionH()===undefined)&&this._changedProps.put_PositionH(new CImagePositionH),this._changedProps.get_PositionH().put_UseAlign(e.getValue()),e.getValue()&&(this._changedProps.get_PositionH().put_Align(this._arrHAlign[this._state.HAlignTypeIdx][0]),this._changedProps.get_PositionH().put_RelativeFrom(this._arrHRelative[this._state.HAlignFromIdx][0]))),e.getValue()&&(this.cmbHAlign.setDisabled(!1),this.cmbHRelative.setDisabled(!1),this._spnX.setDisabled(!0),this.cmbHPosition.setDisabled(!0))},this)}}),this.radioHPosition=Ext.create("Ext.form.field.Radio",{boxLabel:"",name:"asc-radio-horizontal",listeners:{change:Ext.bind(function(e,t,n,r){this._changedProps&&((this._changedProps.get_PositionH()===null||this._changedProps.get_PositionH()===undefined)&&this._changedProps.put_PositionH(new CImagePositionH),this._changedProps.get_PositionH().put_UseAlign(!e.getValue()),e.getValue()&&(this._changedProps.get_PositionH().put_Value(Common.MetricSettings.fnRecalcToMM(this._spnX.getNumberValue())),this._changedProps.get_PositionH().put_RelativeFrom(this._arrHRelative[this._state.HPositionFromIdx][0]))),e.getValue()&&(this.cmbHAlign.setDisabled(!0),this.cmbHRelative.setDisabled(!0),this._spnX.setDisabled(!1),this.cmbHPosition.setDisabled(!1))},this)}}),this.radioVAlign=Ext.create("Ext.form.field.Radio",{boxLabel:"",name:"asc-radio-vertical",checked:!0,listeners:{change:Ext.bind(function(e,t,n,r){this._changedProps&&((this._changedProps.get_PositionV()===null||this._changedProps.get_PositionV()===undefined)&&this._changedProps.put_PositionV(new CImagePositionV),this._changedProps.get_PositionV().put_UseAlign(e.getValue()),e.getValue()&&(this._changedProps.get_PositionV().put_Align(this._arrVAlign[this._state.VAlignTypeIdx][0]),this._changedProps.get_PositionV().put_RelativeFrom(this._arrVRelative[this._state.VAlignFromIdx][0]))),e.getValue()&&(this.cmbVAlign.setDisabled(!1),this.cmbVRelative.setDisabled(!1),this._spnY.setDisabled(!0),this.cmbVPosition.setDisabled(!0))},this)}}),this.radioVPosition=Ext.create("Ext.form.field.Radio",{boxLabel:"",name:"asc-radio-vertical",listeners:{change:Ext.bind(function(e,t,n,r){this._changedProps&&((this._changedProps.get_PositionV()===null||this._changedProps.get_PositionV()===undefined)&&this._changedProps.put_PositionV(new CImagePositionV),this._changedProps.get_PositionV().put_UseAlign(!e.getValue()),e.getValue()&&(this._changedProps.get_PositionV().put_Value(Common.MetricSettings.fnRecalcToMM(this._spnY.getNumberValue())),this._changedProps.get_PositionV().put_RelativeFrom(this._arrVRelative[this._state.VPositionFromIdx][0]))),e.getValue()&&(this.cmbVAlign.setDisabled(!0),this.cmbVRelative.setDisabled(!0),this._spnY.setDisabled(!1),this.cmbVPosition.setDisabled(!1))},this)}}),this.chMove=Ext.create("Common.component.IndeterminateCheckBox",{id:"image-checkbox-move",boxLabel:this.textMove,listeners:{change:Ext.bind(function(e,t,n,r){if(this._changedProps){var i=this.cmbVPosition.getStore().getAt(e.getValue()=="checked"?3:4);this.cmbVRelative.isDisabled()?(this.cmbVPosition.select(i),this.cmbVPosition.fireEvent("select",this.cmbVPosition,[i])):(this.cmbVRelative.select(i),this.cmbVRelative.fireEvent("select",this.cmbVRelative,[i]))}},this)}}),this.chOverlap=Ext.create("Common.component.IndeterminateCheckBox",{id:"image-checkbox-overlap",boxLabel:this.textOverlap,listeners:{change:Ext.bind(function(e,t,n,r){this._changedProps&&this._changedProps.put_AllowOverlap(e.getValue()=="checked")},this)}}),this._spnMarginTop=Ext.create("Common.component.MetricSpinner",{id:"image-margin-top",readOnly:!1,maxValue:55.87,minValue:0,step:.1,defaultUnit:"cm",value:"0 cm",width:100,listeners:{change:Ext.bind(function(e,t,n,r){this._changedProps&&(this.Margins===undefined&&(this.Margins=new CPaddings),this.Margins.put_Top(Common.MetricSettings.fnRecalcToMM(e.getNumberValue())))},this)}}),this._spnMarginBottom=Ext.create("Common.component.MetricSpinner",{id:"image-margin-bottom",readOnly:!1,maxValue:55.87,minValue:0,step:.1,defaultUnit:"cm",value:"0 cm",width:100,listeners:{change:Ext.bind(function(e,t,n,r){this._changedProps&&(this.Margins===undefined&&(this.Margins=new CPaddings),this.Margins.put_Bottom(Common.MetricSettings.fnRecalcToMM(e.getNumberValue())))},this)}}),this._spnMarginLeft=Ext.create("Common.component.MetricSpinner",{id:"image-margin-left",readOnly:!1,maxValue:9.34,minValue:0,step:.1,defaultUnit:"cm",value:"0.19 cm",width:100,listeners:{change:Ext.bind(function(e,t,n,r){this._changedProps&&(this.Margins===undefined&&(this.Margins=new CPaddings),this.Margins.put_Left(Common.MetricSettings.fnRecalcToMM(e.getNumberValue())))},this)}}),this._spnMarginRight=Ext.create("Common.component.MetricSpinner",{id:"image-margin-right",readOnly:!1,maxValue:9.34,minValue:0,step:.1,defaultUnit:"cm",value:"0.19 cm",width:100,listeners:{change:Ext.bind(function(e,t,n,r){this._changedProps&&(this.Margins===undefined&&(this.Margins=new CPaddings),this.Margins.put_Right(Common.MetricSettings.fnRecalcToMM(e.getNumberValue())))},this)}});var n=Ext.widget("button",{width:160,height:27,cls:"asc-dialogmenu-btn",text:this.textSize,textAlign:"right",enableToggle:!0,allowDepress:!1,toggleGroup:"imageadvanced",pressed:!0,card:"card-size",listeners:{click:t}});this.btnTextWrap=Ext.widget("button",{width:160,height:27,cls:"asc-dialogmenu-btn",text:this.textBtnWrap,textAlign:"right",enableToggle:!0,allowDepress:!1,toggleGroup:"imageadvanced",card:"card-wrap",listeners:{click:t}}),this.btnPosition=Ext.widget("button",{width:160,height:27,cls:"asc-dialogmenu-btn",text:this.textPosition,textAlign:"right",enableToggle:!0,allowDepress:!1,toggleGroup:"imageadvanced",card:"card-position",listeners:{click:t}}),this.btnShape=Ext.widget("button",{width:160,height:27,cls:"asc-dialogmenu-btn",text:this.textShape,textAlign:"right",enableToggle:!0,allowDepress:!1,toggleGroup:"imageadvanced",card:"card-shape",listeners:{click:t}}),this.btnMargins=Ext.widget("button",{width:160,height:27,cls:"asc-dialogmenu-btn",textAlign:"right",text:this.strMargins,enableToggle:!0,allowDepress:!1,toggleGroup:"imageadvanced",card:"card-margins",listeners:{click:t}}),this._contDistance=Ext.create("Ext.Container",{cls:"image-advanced-container",padding:"0 10",layout:"vbox",layoutConfig:{align:"stretch"},height:104,width:200,items:[{xtype:"tbspacer",height:8},{xtype:"container",layout:{type:"table",columns:2,tdAttrs:{style:"padding-right: 8px;"}},defaults:{xtype:"container",layout:"vbox",layoutConfig:{align:"stretch"},height:40,style:"float:left;"},items:[{width:113,items:[{xtype:"label",text:this.textTop,width:85},{xtype:"tbspacer",height:3},this._spnTop]},{items:[{xtype:"label",text:this.textLeft,width:85},{xtype:"tbspacer",height:3},this._spnLeft]}]},{xtype:"tbspacer",height:8},{xtype:"container",layout:{type:"table",columns:2,tdAttrs:{style:"padding-right: 8px;"}},defaults:{xtype:"container",layout:"vbox",layoutConfig:{align:"stretch"},height:40,style:"float:left;"},items:[{width:113,items:[{xtype:"label",text:this.textBottom,width:85},{xtype:"tbspacer",height:3},this._spnBottom]},{items:[{xtype:"label",text:this.textRight,width:85},{xtype:"tbspacer",height:3},this._spnRight]}]},{xtype:"tbspacer",height:7}]}),this._contPosition=Ext.create("Ext.Container",{cls:"image-advanced-container",padding:"0 10",layout:"vbox",layoutConfig:{align:"stretch"},height:238,width:200,items:[{xtype:"label",style:"font-weight: bold;margin-top: 1px; height:13px;",text:this.textHorizontal},{xtype:"tbspacer",height:12},{xtype:"container",layout:{type:"table",columns:3,tdAttrs:{style:"padding-right: 8px;"}},defaults:{xtype:"container",layout:"vbox",layoutConfig:{align:"stretch"},height:40,style:"float:left;"},items:[{width:15,items:[{xtype:"tbspacer",height:15},this.radioHAlign]},{width:130,items:[{xtype:"label",text:this.textAlignment,width:85},{xtype:"tbspacer",height:2},this.cmbHAlign]},{items:[{xtype:"label",text:this.textRelative,width:85},{xtype:"tbspacer",height:2},this.cmbHRelative]}]},{xtype:"tbspacer",height:8},{xtype:"container",layout:{type:"table",columns:3,tdAttrs:{style:"padding-right: 8px;"}},defaults:{xtype:"container",layout:"vbox",layoutConfig:{align:"stretch"},height:40,style:"float:left;"},items:[{width:15,items:[{xtype:"tbspacer",height:15},this.radioHPosition]},{width:130,items:[{xtype:"label",text:this.textPosition,width:85},{xtype:"tbspacer",height:2},this._spnX]},{items:[{xtype:"label",text:this.textRightOf,width:85},{xtype:"tbspacer",height:2},this.cmbHPosition]}]},{xtype:"tbspacer",height:10},{xtype:"label",style:"font-weight: bold;margin-top: 1px; height:13px;",text:this.textVertical},{xtype:"tbspacer",height:12},{xtype:"container",layout:{type:"table",columns:3,tdAttrs:{style:"padding-right: 8px;"}},defaults:{xtype:"container",layout:"vbox",layoutConfig:{align:"stretch"},height:40,style:"float:left;"},items:[{width:15,items:[{xtype:"tbspacer",height:15},this.radioVAlign]},{width:130,items:[{xtype:"label",text:this.textAlignment,width:85},{xtype:"tbspacer",height:2},this.cmbVAlign]},{items:[{xtype:"label",text:this.textRelative,width:85},{xtype:"tbspacer",height:2},this.cmbVRelative]}]},{xtype:"tbspacer",height:8},{xtype:"container",layout:{type:"table",columns:3,tdAttrs:{style:"padding-right: 8px;"}},defaults:{xtype:"container",layout:"vbox",layoutConfig:{align:"stretch"},height:40,style:"float:left;"},items:[{width:15,items:[{xtype:"tbspacer",height:15},this.radioVPosition]},{width:130,items:[{xtype:"label",text:this.textPosition,width:85},{xtype:"tbspacer",height:2},this._spnY]},{items:[{xtype:"label",text:this.textBelow,width:85},{xtype:"tbspacer",height:2},this.cmbVPosition]}]}]}),this._contOptions=Ext.create("Ext.Container",{cls:"image-advanced-container",padding:"0 10",layout:"vbox",layoutConfig:{align:"stretch"},height:45,width:200,items:[{xtype:"label",style:"font-weight: bold;margin-top: 1px; height:13px;",text:this.textOptions},{xtype:"tbspacer",height:8},{xtype:"container",height:30,layout:{type:"table",columns:2,tdAttrs:{style:"padding-right: 25px;vertical-align: middle;"}},items:[this.chMove,this.chOverlap]}]});var r={xtype:"container",itemId:"card-size",width:330,layout:{type:"vbox",align:"stretch"},items:[{xtype:"container",padding:"0 10",layout:{type:"table",columns:2},defaults:{xtype:"container",layout:"vbox",layoutConfig:{align:"stretch"},height:43,style:"float:left;"},items:[{width:108,items:[{xtype:"label",text:this.textWidth,width:80},{xtype:"tbspacer",height:3},{xtype:"container",width:108,layout:{type:"hbox"},items:[this._spnWidth,this._btnRatio]}]},{width:195,margin:"0 0 0 7",items:[{xtype:"label",text:this.textHeight,width:80},{xtype:"tbspacer",height:3},{xtype:"container",width:195,layout:{type:"hbox"},items:[this._spnHeight,this._btnOriginalSize]}]}]}]},i={xtype:"container",itemId:"card-wrap",width:330,layout:{type:"vbox",align:"stretch"},items:[{xtype:"label",style:"font-weight: bold;margin-top: 1px; padding-left:10px;height:13px;",text:this.textWrap},{xtype:"tbspacer",height:10},{xtype:"container",padding:"0 10",items:[this.btnWrapInline,this.btnWrapSquare,this.btnWrapTight,this.btnWrapThrough]},{xtype:"tbspacer",height:10},{xtype:"container",padding:"0 10",items:[this.btnWrapTopBottom,this.btnWrapInFront,this.btnWrapBehind]},this._spacer.cloneConfig({style:"margin: 13px 0 11px 0;",height:6}),{xtype:"label",style:"font-weight: bold;margin-top: 1px; padding-left:10px;height:13px;",text:this.textDistance},{xtype:"tbspacer",height:10},this._contDistance]},s={xtype:"container",itemId:"card-position",width:330,layout:{type:"vbox",align:"stretch"},items:[this._contPosition,this._spacer.cloneConfig({style:"margin: 16px 0 11px 0;",height:6}),this._contOptions]},o={xtype:"container",itemId:"card-shape",width:330,layout:{type:"vbox",align:"stretch"},items:[this._contShape=Ext.create("DE.view.ShapeSettingsAdvancedCnt")]},u={xtype:"container",itemId:"card-margins",width:330,layout:{type:"vbox",align:"stretch"},items:[{xtype:"container",padding:"0 10",layout:{type:"table",columns:2,tdAttrs:{style:"padding-right: 40px;vertical-align: middle;"}},items:[{xtype:"label",text:this.textTop,width:85},{xtype:"label",text:this.textLeft,width:85},{xtype:"tbspacer",height:2},{xtype:"tbspacer",height:2},this._spnMarginTop,this._spnMarginLeft,{xtype:"tbspacer",height:5},{xtype:"tbspacer",height:5},{xtype:"label",text:this.textBottom,width:85},{xtype:"label",text:this.textRight,width:85},{xtype:"tbspacer",height:2},{xtype:"tbspacer",height:2},this._spnMarginBottom,this._spnMarginRight]}]},a=Ext.create("Ext.container.Container",{height:330,flex:1,padding:"12px 18px 0 10px",layout:"card",items:[r,i,s,o,u]});this.items=[{xtype:"container",height:346,layout:{type:"hbox",align:"stretch"},items:[{xtype:"container",width:160,padding:"5px 0 0 0",layout:{type:"vbox",align:"stretch"},defaults:{xtype:"container",layout:{type:"hbox",align:"middle",pack:"end"}},items:[{height:30,items:n},{height:30,items:this.btnTextWrap},{height:30,items:this.btnPosition},{height:30,items:this.btnShape},{height:30,items:this.btnMargins}]},{xtype:"box",cls:"advanced-settings-separator",height:"100%",width:8},a]},this._spacer.cloneConfig({style:"margin: 0 18px"}),{xtype:"container",height:40,layout:{type:"vbox",align:"center",pack:"center"},items:[{xtype:"container",width:182,height:24,layout:{type:"hbox",align:"middle"},items:[this.btnOk=Ext.widget("button",{cls:"asc-blue-button",width:86,height:22,margin:"0 5px 0 0",text:this.okButtonText,listeners:{click:function(e){this.fireEvent("onmodalresult",this,1,this.getSettings()),this.close()},scope:this}}),this.btnCancel=Ext.widget("button",{cls:"asc-darkgray-button",width:86,height:22,text:this.cancelButtonText,listeners:{click:function(e){this.fireEvent("onmodalresult",this,0),this.close()},scope:this}})]}]}],this.callParent(arguments)},afterRender:function(){this.callParent(arguments),this._setDefaults(this._defaults.properties)},setSizeOriginal:function(e){this._defaults.sizeOriginal.width=Common.MetricSettings.fnRecalcFromMM(e.width),this._defaults.sizeOriginal.height=Common.MetricSettings.fnRecalcFromMM(e.height)},setSizeMax:function(e){this._defaults.sizeMax.width=Common.MetricSettings.fnRecalcFromMM(e.width),this._defaults.sizeMax.height=Common.MetricSettings.fnRecalcFromMM(e.height)},setSettings:function(e){this._defaults.properties=e,this._changedProps=null},_setDefaults:function(e){if(e){this._objectType=c_oAscTypeSelectElement.Image;var t=e.get_WrappingStyle();if(e.get_CanBeFlow())switch(t){case c_oAscWrapStyle2.Inline:this.btnWrapInline.toggle(!0,!1);break;case c_oAscWrapStyle2.Square:this.btnWrapSquare.toggle(!0,!1);break;case c_oAscWrapStyle2.Tight:this.btnWrapTight.toggle(!0,!1);break;case c_oAscWrapStyle2.Through:this.btnWrapThrough.toggle(!0,!1);break;case c_oAscWrapStyle2.TopAndBottom:this.btnWrapTopBottom.toggle(!0,!1);break;case c_oAscWrapStyle2.Behind:this.btnWrapBehind.toggle(!0,!1);break;case c_oAscWrapStyle2.InFront:this.btnWrapInFront.toggle(!0,!1);break;default:this.btnWrapInline.toggle(!1,!1),this.btnWrapSquare.toggle(!1,!1),this.btnWrapTight.toggle(!1,!1),this.btnWrapThrough.toggle(!1,!1),this.btnWrapTopBottom.toggle(!1,!1),this.btnWrapBehind.toggle(!1,!1),this.btnWrapInFront.toggle(!1,!1)}else this.btnWrapInline.toggle(!0,!1),this.btnWrapSquare.setDisabled(!0),this.btnWrapTight.setDisabled(!0),this.btnWrapThrough.setDisabled(!0),this.btnWrapTopBottom.setDisabled(!0),this.btnWrapBehind.setDisabled(!0),this.btnWrapInFront.setDisabled(!0);this._spnWidth.suspendEvents(!1),this._spnHeight.suspendEvents(!1),this._spnWidth.setMaxValue(this._defaults.sizeMax.width),this._spnHeight.setMaxValue(this._defaults.sizeMax.height),this._spnWidth.setValue(Common.MetricSettings.fnRecalcFromMM(e.get_Width()).toFixed(2)),this._spnHeight.setValue(Common.MetricSettings.fnRecalcFromMM(e.get_Height()).toFixed(2)),this._spnWidth.resumeEvents(),this._spnHeight.resumeEvents();if(e.get_Paddings()){var n={Top:e.get_Paddings().get_Top(),Right:e.get_Paddings().get_Right(),Bottom:e.get_Paddings().get_Bottom(),Left:e.get_Paddings().get_Left()};n.Top!==null&&n.Top!==undefined&&this._spnTop.setValue(Common.MetricSettings.fnRecalcFromMM(n.Top)),n.Left!==null&&n.Left!==undefined&&this._spnLeft.setValue(Common.MetricSettings.fnRecalcFromMM(n.Left)),n.Bottom!==null&&n.Bottom!==undefined&&this._spnBottom.setValue(Common.MetricSettings.fnRecalcFromMM(n.Bottom)),n.Right!==null&&n.Right!==undefined&&this._spnRight.setValue(Common.MetricSettings.fnRecalcFromMM(n.Right))}var r=e.get_PositionH();if(r)if(r.get_UseAlign()){t=r.get_Align();for(var i=0;i<this._arrHAlign.length;i++)if(t==this._arrHAlign[i][0]){this.cmbHAlign.setValue(this._arrHAlign[i][1]),this._state.HAlignTypeIdx=i;break}t=r.get_RelativeFrom();for(i=0;i<this._arrHRelative.length;i++)if(t==this._arrHRelative[i][0]){this.cmbHRelative.setValue(this._arrHRelative[i][1]),this._state.HAlignFromIdx=i;break}}else{this.radioHPosition.setValue(!0),t=r.get_Value(),this._spnX.setValue(Common.MetricSettings.fnRecalcFromMM(t)),t=r.get_RelativeFrom();for(i=0;i<this._arrHRelative.length;i++)if(t==this._arrHRelative[i][0]){this.cmbHPosition.setValue(this._arrHRelative[i][1]),this._state.HPositionFromIdx=i;break}}r=e.get_PositionV();if(r){if(r.get_UseAlign()){t=r.get_Align();for(i=0;i<this._arrVAlign.length;i++)if(t==this._arrVAlign[i][0]){this.cmbVAlign.setValue(this._arrVAlign[i][1]),this._state.VAlignTypeIdx=i;break}}else this.radioVPosition.setValue(!0),t=r.get_Value(),this._spnY.setValue(Common.MetricSettings.fnRecalcFromMM(t));t=r.get_RelativeFrom();for(i=0;i<this._arrVRelative.length;i++)if(t==this._arrVRelative[i][0]){this.cmbVRelative.setValue(this._arrVRelative[i][1]),this.cmbVPosition.setValue(this._arrVRelative[i][1]),this._state.VAlignFromIdx=i,this._state.VPositionFromIdx=i;break}(t==c_oAscRelativeFromV.Line||t==c_oAscRelativeFromV.Paragraph)&&this.chMove.setValue(!0)}this.chOverlap.setValue(e.get_AllowOverlap()!==null&&e.get_AllowOverlap()!==undefined?e.get_AllowOverlap():"indeterminate"),e.get_Height()>0&&(this._nRatio=e.get_Width()/e.get_Height());var s=e.get_ShapeProperties();this._btnOriginalSize.setVisible(!s),this._btnOriginalSize.setDisabled(e.get_ImageUrl()===null||e.get_ImageUrl()===undefined),this.btnShape.setVisible(s!==null),this.btnMargins.setVisible(s!==null),this.btnTextWrap.setDisabled(e.get_FromGroup());if(s){this._objectType=c_oAscTypeSelectElement.Shape,this._contShape._setDefaults(s),this.setTitle(this.textTitleShape),t=window.localStorage.getItem("de-settings-shaperatio");var o=s.get_paddings();if(o){var u=o.get_Left();this._spnMarginLeft.setValue(null!==u&&undefined!==u?Common.MetricSettings.fnRecalcFromMM(u):""),u=o.get_Top(),this._spnMarginTop.setValue(null!==u&&undefined!==u?Common.MetricSettings.fnRecalcFromMM(u):""),u=o.get_Right(),this._spnMarginRight.setValue(null!==u&&undefined!==u?Common.MetricSettings.fnRecalcFromMM(u):""),u=o.get_Bottom(),this._spnMarginBottom.setValue(null!==u&&undefined!==u?Common.MetricSettings.fnRecalcFromMM(u):"")}}else this.setTitle(this.textTitle),t=window.localStorage.getItem("de-settings-imageratio"),t===null&&(t=1);t!==null&&parseInt(t)==1&&this._btnRatio.toggle(!0),this._changedProps=new CImgProperty}},getSettings:function(){var e=this._btnRatio.pressed?1:0;this._objectType==c_oAscTypeSelectElement.Shape?window.localStorage.setItem("de-settings-shaperatio",e):window.localStorage.setItem("de-settings-imageratio",e);var t=this._changedProps;this._objectType==c_oAscTypeSelectElement.Shape&&(t.put_ShapeProperties(this._contShape.getSettings()),this.Margins&&((t.get_ShapeProperties()===null||t.get_ShapeProperties()===undefined)&&t.put_ShapeProperties(new CAscShapeProp),t.get_ShapeProperties().put_paddings(this.Margins)));if(this._defaults.properties.get_WrappingStyle()===c_oAscWrapStyle2.Inline&&t.get_WrappingStyle()!==undefined&&t.get_WrappingStyle()!==c_oAscWrapStyle2.Inline){if(t.get_PositionH()===null||t.get_PositionH()===undefined){t.put_PositionH(new CImagePositionH),t.get_PositionH().put_UseAlign(!1),t.get_PositionH().put_RelativeFrom(c_oAscRelativeFromH.Column);var n=this._defaults.properties.get_Value_X(c_oAscRelativeFromH.Column);t.get_PositionH().put_Value(n)}if(t.get_PositionV()===null||t.get_PositionV()===undefined)t.put_PositionV(new CImagePositionV),t.get_PositionV().put_UseAlign(!1),t.get_PositionV().put_RelativeFrom(c_oAscRelativeFromV.Paragraph),n=this._defaults.properties.get_Value_Y(c_oAscRelativeFromV.Paragraph),t.get_PositionV().put_Value(n)}return t},_DisableElem:function(e){var t=e==c_oAscWrapStyle2.Inline||e==c_oAscWrapStyle2.Behind||e==c_oAscWrapStyle2.InFront||e==c_oAscWrapStyle2.TopAndBottom,n=e==c_oAscWrapStyle2.Inline||e==c_oAscWrapStyle2.Behind||e==c_oAscWrapStyle2.InFront||e==c_oAscWrapStyle2.Tight||e==c_oAscWrapStyle2.Through,r=e==c_oAscWrapStyle2.Inline;this._spnLeft.setDisabled(t),this._spnRight.setDisabled(t),this._spnTop.setDisabled(n),this._spnBottom.setDisabled(n),this._contPosition.setDisabled(r),this._contOptions.setDisabled(r),this.btnPosition.setDisabled(e==c_oAscWrapStyle2.Inline)},updateMetricUnit:function(){var e=this.query("commonmetricspinner");if(e)for(var t=0;t<e.length;t++){var n=e[t];n.setDefaultUnit(Common.MetricSettings.metricName[Common.MetricSettings.getCurrentMetric()]),n.setStep(Common.MetricSettings.getCurrentMetric()==Common.MetricSettings.c_MetricUnits.cm?.01:1)}this._defaults.sizeMax.width=Common.MetricSettings.fnRecalcFromMM(this._defaults.sizeMax.width*10),this._defaults.sizeMax.height=Common.MetricSettings.fnRecalcFromMM(this._defaults.sizeMax.height*10)},textTop:"Top",textLeft:"Left",textBottom:"Bottom",textRight:"Right",textOriginalSize:"Default Size",textPosition:"Position",textDistance:"Distance From Text",textSize:"Size",textWrap:"Wrapping Style",textWidth:"Width",textHeight:"Height",textWrapInlineTooltip:"Inline",textWrapSquareTooltip:"Square",textWrapTightTooltip:"Tight",textWrapThroughTooltip:"Through",textWrapNoneTopbottom:"Top and Bottom",textWrapBehindTooltip:"Behind",textWrapInFrontTooltip:"In Front",textTitle:"Image - Advanced Settings",textKeepRatio:"Constant Proportions",cancelButtonText:"Cancel",okButtonText:"Ok",textBtnWrap:"Text Wrapping",textCenter:"Center",textCharacter:"Character",textColumn:"Column",textLeftMargin:"Left Margin",textMargin:"Margin",textPage:"Page",textRightMargin:"Right Margin",textLine:"Line",textBottomMargin:"Bottom Margin",textParagraph:"Paragraph",textTopMargin:"Top Margin",textHorizontal:"Horizontal",textVertical:"Vertical",textAlignment:"Alignment",textRelative:"relative to",textRightOf:"to the right Of",textBelow:"below",textOverlap:"Allow overlap",textMove:"Move object with text",textOptions:"Options",textShape:"Shape Settings",textTitleShape:"Shape - Advanced Settings",textTitleChart:"Chart - Advanced Settings",strMargins:"Margins"}),Ext.define("DE.view.TableSettingsAdvanced",{extend:"Ext.window.Window",alias:"widget.detablesettingsadvanced",requires:["Ext.Array","Ext.Button","Ext.container.Container","Ext.form.field.ComboBox","Ext.window.Window","Common.component.ThemeColorPalette","Common.component.MetricSpinner","DE.component.TableStyler","Common.component.IndeterminateCheckBox","Common.plugin.ComboBoxScrollPane"],cls:"asc-advanced-settings-window",modal:!0,resizable:!1,plain:!0,constrain:!0,height:466,width:516,layout:{type:"vbox",align:"stretch"},initComponent:function(){var e=this;this.addEvents("onmodalresult"),this.controls=[],this._originalProps=null,this._changedProps=null,this._cellBackground=null,this._state={HAlignTypeIdx:0,HAlignFromIdx:0,HPositionFromIdx:0,VAlignTypeIdx:0,VAlignFromIdx:0,VPositionFromIdx:0,spnXChanged:!1,spnYChanged:!1,fromWrapInline:!1,verticalPropChanged:!1,horizontalPropChanged:!1,alignChanged:!1},this._allTable=!1,this.TableMargins={Left:.19,Right:.19,Top:0,Bottom:0},this.CellMargins={Left:.19,Right:.19,Top:null,Bottom:null,Flag:0},this.TableBorders={},this.CellBorders={},this.ChangedTableBorders=undefined,this.ChangedCellBorders=undefined,this.BorderSize={ptValue:0,pxValue:0},this.TableColor={Value:1,Color:"transparent"},this.CellColor={Value:1,Color:"transparent"},this.IndeterminateColor="#C8C8C8",this.IndeterminateSize=4.5,this.ThemeValues=[6,15,7,16,0,1,2,3,4,5],this._marginsChange=function(e,t,n,r,i,s){i=="table"?this.TableMargins[s]=e.getNumberValue():this.CellMargins[s]=e.getNumberValue()},this._chWidth=Ext.create("Ext.form.field.Checkbox",{id:"tableadv-checkbox-width",boxLabel:this.textWidth,checked:!0,width:85,listeners:{change:Ext.bind(function(e,t,n,r){this._nfWidth.setDisabled(!t),this._changedProps&&(t&&this._nfWidth.getNumberValue()>0?this._changedProps.put_Width(Common.MetricSettings.fnRecalcToMM(this._nfWidth.getNumberValue())):this._changedProps.put_Width(null))},this)}}),this._nfWidth=Ext.widget("commonmetricspinner",{id:"tableadv-number-width",readOnly:!1,step:.1,width:85,defaultUnit:"cm",value:"10 cm",maxValue:55.88,minValue:0,listeners:{change:Ext.bind(function(e,t,n,r){this._changedProps&&this._changedProps.put_Width(Common.MetricSettings.fnRecalcToMM(e.getNumberValue()))},this)}}),this._chAllowSpacing=Ext.create("Ext.form.field.Checkbox",{id:"tableadv-checkbox-spacing",boxLabel:this.textAllowSpacing,checked:!0,listeners:{change:Ext.bind(function(e,t,n,r){this._nfSpacing.setDisabled(!t),this._tableBackContainer.setVisible(t||this._allTable),this._cellBackContainer.setVisible(t||!this._allTable),this._tablePresetsContainer.setVisible(t),this._cellPresetsContainer.setVisible(!t),t?(this.bordersImagePanel.getLayout().setActiveItem(this._tableBordersImageSpacing),this._UpdateBordersSpacing_()):(this.bordersImagePanel.getLayout().setActiveItem(this._tableBordersImage),this._UpdateBordersNoSpacing_()),this._changedProps&&(t&&this._nfSpacing.getNumberValue()>0?this._changedProps.put_Spacing(Common.MetricSettings.fnRecalcToMM(this._nfSpacing.getNumberValue())):this._changedProps.put_Spacing(null))},this)}}),this._nfSpacing=Ext.widget("commonmetricspinner",{id:"tableadv-number-spacing",readOnly:!1,step:.1,width:85,defaultUnit:"cm",value:"0.5 cm",maxValue:2.14,minValue:0,listeners:{change:Ext.bind(function(e,t,n,r){this._changedProps&&this._changedProps.put_Spacing(Common.MetricSettings.fnRecalcToMM(e.getNumberValue()))},this)}}),this._chAutofit=Ext.create("Ext.form.field.Checkbox",{id:"tableadv-checkbox-autofit",boxLabel:this.textAutofit,checked:!0,colspan:3,listeners:{change:Ext.bind(function(e,t,n,r){this._changedProps&&this._changedProps.put_TableLayout(e.getValue()?c_oAscTableLayout.AutoFit:c_oAscTableLayout.Fixed)},this)}}),this._chCellMargins=Ext.create("Common.component.IndeterminateCheckBox",{id:"tableadv-checkbox-margins",boxLabel:this.textCheckMargins,checked:!0,style:"margin-left:10px;",listeners:{change:Ext.bind(function(e,t,n,r){n=="checked"&&this._originalProps&&this._originalProps.get_CellMargins().get_Flag()==1&&(e.suspendEvents(!1),e.setValue("indeterminate"),e.resumeEvents()),this.fillMargins.call(this,e.getValue()),this.CellMargins.Flag=e.getValue(),this._changedProps&&(this._changedProps.get_CellMargins()===undefined&&this._changedProps.put_CellMargins(new CMargins),this._changedProps.get_CellMargins().put_Left(this.CellMargins.Left!==null?Common.MetricSettings.fnRecalcToMM(this.CellMargins.Left):null),this._changedProps.get_CellMargins().put_Top(this.CellMargins.Top!==null?Common.MetricSettings.fnRecalcToMM(this.CellMargins.Top):null),this._changedProps.get_CellMargins().put_Bottom(this.CellMargins.Bottom!==null?Common.MetricSettings.fnRecalcToMM(this.CellMargins.Bottom):null),this._changedProps.get_CellMargins().put_Right(this.CellMargins.Right!==null?Common.MetricSettings.fnRecalcToMM(this.CellMargins.Right):null),this.CellMargins.Flag=="indeterminate"?this._changedProps.get_CellMargins().put_Flag(1):this.CellMargins.Flag=="checked"?this._changedProps.get_CellMargins().put_Flag(0):this._changedProps.get_CellMargins().put_Flag(2))},this)}}),this.controls.push(this._chCellMargins),this._spnMarginTop=Ext.create("Common.component.MetricSpinner",{id:"tableadv-number-margin-top",readOnly:!1,maxValue:55.87,minValue:0,step:.1,defaultUnit:"cm",value:"0 cm",width:85,listeners:{change:Ext.bind(function(e,t,n,r){this._marginsChange(e,t,n,r,"cell","Top"),this._changedProps&&(this._changedProps.get_CellMargins()===undefined&&this._changedProps.put_CellMargins(new CMargins),this._changedProps.get_CellMargins().put_Top(this.CellMargins.Top!==null?Common.MetricSettings.fnRecalcToMM(this.CellMargins.Top):null),this.CellMargins.Flag=="indeterminate"?this._changedProps.get_CellMargins().put_Flag(1):this.CellMargins.Flag=="checked"?this._changedProps.get_CellMargins().put_Flag(0):this._changedProps.get_CellMargins().put_Flag(2))},this)}}),this.controls.push(this._spnMarginTop),this._spnMarginBottom=Ext.create("Common.component.MetricSpinner",{id:"tableadv-number-margin-bottom",readOnly:!1,maxValue:55.87,minValue:0,step:.1,defaultUnit:"cm",value:"0 cm",width:85,listeners:{change:Ext.bind(function(e,t,n,r){this._marginsChange(e,t,n,r,"cell","Bottom"),this._changedProps&&(this._changedProps.get_CellMargins()===undefined&&this._changedProps.put_CellMargins(new CMargins),this._changedProps.get_CellMargins().put_Bottom(this.CellMargins.Bottom!==null?Common.MetricSettings.fnRecalcToMM(this.CellMargins.Bottom):null),this.CellMargins.Flag=="indeterminate"?this._changedProps.get_CellMargins().put_Flag(1):this.CellMargins.Flag=="checked"?this._changedProps.get_CellMargins().put_Flag(0):this._changedProps.get_CellMargins().put_Flag(2))},this)}}),this.controls.push(this._spnMarginBottom),this._spnMarginLeft=Ext.create("Common.component.MetricSpinner",{id:"tableadv-number-margin-left",readOnly:!1,maxValue:9.34,minValue:0,step:.1,defaultUnit:"cm",value:"0.19 cm",width:85,listeners:{change:Ext.bind(function(e,t,n,r){this._marginsChange(e,t,n,r,"cell","Left"),this._changedProps&&(this._changedProps.get_CellMargins()===undefined&&this._changedProps.put_CellMargins(new CMargins),this._changedProps.get_CellMargins().put_Left(this.CellMargins.Left!==null?Common.MetricSettings.fnRecalcToMM(this.CellMargins.Left):null),this.CellMargins.Flag=="indeterminate"?this._changedProps.get_CellMargins().put_Flag(1):this.CellMargins.Flag=="checked"?this._changedProps.get_CellMargins().put_Flag(0):this._changedProps.get_CellMargins().put_Flag(2))},this)}}),this.controls.push(this._spnMarginLeft),this._spnMarginRight=Ext.create("Common.component.MetricSpinner",{id:"tableadv-number-margin-right",readOnly:!1,maxValue:9.34,minValue:0,step:.1,defaultUnit:"cm",value:"0.19 cm",width:85,listeners:{change:Ext.bind(function(e,t,n,r){this._marginsChange(e,t,n,r,"cell","Right"),this._changedProps&&(this._changedProps.get_CellMargins()===undefined&&this._changedProps.put_CellMargins(new CMargins),this._changedProps.get_CellMargins().put_Right(this.CellMargins.Right!==null?Common.MetricSettings.fnRecalcToMM(this.CellMargins.Right):null),this.CellMargins.Flag=="indeterminate"?this._changedProps.get_CellMargins().put_Flag(1):this.CellMargins.Flag=="checked"?this._changedProps.get_CellMargins().put_Flag(0):this._changedProps.get_CellMargins().put_Flag(2))},this)}}),this.controls.push(this._spnMarginRight),this._spnTableMarginTop=Ext.create("Common.component.MetricSpinner",{id:"tableadv-number-margin-table-top",readOnly:!1,maxValue:55.87,minValue:0,step:.1,defaultUnit:"cm",value:"0 cm",width:85,listeners:{change:Ext.bind(function(e,t,n,r){this._marginsChange(e,t,n,r,"table","Top"),this._changedProps&&(this._changedProps.get_DefaultMargins()===undefined&&this._changedProps.put_DefaultMargins(new CPaddings),this._changedProps.get_DefaultMargins().put_Top(this.TableMargins.Top!==null?Common.MetricSettings.fnRecalcToMM(this.TableMargins.Top):null),this.TableMargins.isChanged=!0)},this)}}),this.controls.push(this._spnTableMarginTop),this._spnTableMarginBottom=Ext.create("Common.component.MetricSpinner",{id:"tableadv-number-margin-table-bottom",readOnly:!1,maxValue:55.87,minValue:0,step:.1,defaultUnit:"cm",value:"0 cm",width:85,listeners:{change:Ext.bind(function(e,t,n,r){this._marginsChange(e,t,n,r,"table","Bottom"),this._changedProps&&(this._changedProps.get_DefaultMargins()===undefined&&this._changedProps.put_DefaultMargins(new CPaddings),this._changedProps.get_DefaultMargins().put_Bottom(this.TableMargins.Bottom!==null?Common.MetricSettings.fnRecalcToMM(this.TableMargins.Bottom):null),this.TableMargins.isChanged=!0)},this)}}),this.controls.push(this._spnTableMarginBottom),this._spnTableMarginLeft=Ext.create("Common.component.MetricSpinner",{id:"tableadv-number-margin-table-left",readOnly:!1,maxValue:9.34,minValue:0,step:.1,defaultUnit:"cm",value:"0.19 cm",width:85,listeners:{change:Ext.bind(function(e,t,n,r){this._marginsChange(e,t,n,r,"table","Left"),this._changedProps&&(this._changedProps.get_DefaultMargins()===undefined&&this._changedProps.put_DefaultMargins(new CPaddings),this._changedProps.get_DefaultMargins().put_Left(this.TableMargins.Left!==null?Common.MetricSettings.fnRecalcToMM(this.TableMargins.Left):null),this.TableMargins.isChanged=!0)},this)}}),this.controls.push(this._spnTableMarginLeft),this._spnTableMarginRight=Ext.create("Common.component.MetricSpinner",{id:"tableadv-number-margin-table-right",readOnly:!1,maxValue:9.34,minValue:0,step:.1,defaultUnit:"cm",value:"0.19 cm",width:85,listeners:{change:Ext.bind(function(e,t,n,r){this._marginsChange(e,t,n,r,"table","Right"),this._changedProps&&(this._changedProps.get_DefaultMargins()===undefined&&this._changedProps.put_DefaultMargins(new CPaddings),this._changedProps.get_DefaultMargins().put_Right(this.TableMargins.Right!==null?Common.MetricSettings.fnRecalcToMM(this.TableMargins.Right):null),this.TableMargins.isChanged=!0)},this)}}),this.controls.push(this._spnTableMarginRight),this._spnIndentLeft=Ext.create("Common.component.MetricSpinner",{id:"tableadv-number-indent",readOnly:!1,maxValue:38.09,minValue:-38.09,step:.1,defaultUnit:"cm",value:"0 cm",width:85,style:"margin-bottom: 0;",listeners:{change:Ext.bind(function(e,t,n,r){this._changedProps&&this._changedProps.put_TableIndent(Common.MetricSettings.fnRecalcToMM(e.getNumberValue()))},this)}}),this._btnAlignLeft=Ext.create("Ext.Button",{id:"tableadv-button-align-left",cls:"asc-right-panel-btn btn-table-align-left",posId:c_tableAlign.TABLE_ALIGN_LEFT,margin:"2px 2px 2px 0",text:"",tooltip:this.textLeftTooltip,enableToggle:!0,allowDepress:!1,toggleGroup:"advtablealignGroup",pressed:!0,toggleHandler:Ext.bind(function(e){this._changedProps&&e.pressed&&(this._changedProps.put_TableAlignment(e.posId),this._changedProps.put_TableIndent(Common.MetricSettings.fnRecalcToMM(this._spnIndentLeft.getNumberValue())),this._spnIndentLeft.setDisabled(!e.pressed),this._state.alignChanged=!0)},this)}),this._btnAlignCenter=Ext.create("Ext.Button",{id:"tableadv-button-align-center",cls:"asc-right-panel-btn btn-table-align-center",posId:c_tableAlign.TABLE_ALIGN_CENTER,margin:"2px",text:"",tooltip:this.textCenterTooltip,enableToggle:!0,allowDepress:!1,toggleGroup:"advtablealignGroup",toggleHandler:Ext.bind(function(e){this._changedProps&&e.pressed&&(this._changedProps.put_TableAlignment(e.posId),this._changedProps.put_TableIndent(0),this._spnIndentLeft.setDisabled(e.pressed),this._state.alignChanged=!0)},this)}),this._btnAlignRight=Ext.create("Ext.Button",{id:"tableadv-button-align-right",cls:"asc-right-panel-btn btn-table-align-right",posId:c_tableAlign.TABLE_ALIGN_RIGHT,margin:"2px",text:"",tooltip:this.textRightTooltip,enableToggle:!0,allowDepress:!1,toggleGroup:"advtablealignGroup",toggleHandler:Ext.bind(function(e){this._changedProps&&e.pressed&&(this._changedProps.put_TableAlignment(e.posId),this._changedProps.put_TableIndent(0),this._spnIndentLeft.setDisabled(e.pressed),this._state.alignChanged=!0)},this)}),this._btnWrapNone=Ext.create("Ext.Button",{id:"tableadv-button-wrap-none",cls:"asc-right-panel-btn btn-wrap-none",posId:c_tableWrap.TABLE_WRAP_NONE,margin:"2px 2px 2px 0",text:"",tooltip:this.textWrapNoneTooltip,enableToggle:!0,allowDepress:!1,toggleGroup:"advtablewrapGroup",pressed:!0,toggleHandler:Ext.bind(function(e){this._ShowHideElem(!e.pressed),this._changedProps&&e.pressed&&(this._state.alignChanged&&(this._state.HAlignTypeIdx===0?this._btnAlignLeft.toggle(!0,!1):this._state.HAlignTypeIdx==1?this._btnAlignCenter.toggle(!0,!1):this._state.HAlignTypeIdx==2&&this._btnAlignRight.toggle(!0,!1),this._state.alignChanged=!1),this._changedProps.put_TableWrap(e.pressed?c_tableWrap.TABLE_WRAP_NONE:c_tableWrap.TABLE_WRAP_PARALLEL),this._btnAlignLeft.pressed?this._changedProps.put_TableAlignment(c_tableAlign.TABLE_ALIGN_LEFT):this._btnAlignCenter.pressed?this._changedProps.put_TableAlignment(c_tableAlign.TABLE_ALIGN_CENTER):this._changedProps.put_TableAlignment(c_tableAlign.TABLE_ALIGN_RIGHT),this._spnIndentLeft.setDisabled(!this._btnAlignLeft.pressed),this._changedProps.put_TableIndent(Common.MetricSettings.fnRecalcToMM(this._spnIndentLeft.getNumberValue())))},this)}),this._btnWrapParallel=Ext.create("Ext.Button",{id:"tableadv-button-wrap-parallel",cls:"asc-right-panel-btn btn-wrap-parallel",posId:c_tableWrap.TABLE_WRAP_PARALLEL,margin:"2px",text:"",tooltip:this.textWrapParallelTooltip,enableToggle:!0,allowDepress:!1,toggleGroup:"advtablewrapGroup",toggleHandler:Ext.bind(function(e){this._ShowHideElem(e.pressed),this._changedProps&&e.pressed&&(this._changedProps.put_TableWrap(e.pressed?c_tableWrap.TABLE_WRAP_PARALLEL:c_tableWrap.TABLE_WRAP_NONE),this._changedProps.put_TableAlignment(null),this._changedProps.put_TableIndent(null),this._state.fromWrapInline&&!this._state.verticalPropChanged&&this.radioVPosition.setValue(!0),this._state.alignChanged?(this._btnAlignLeft.pressed?this._state.HAlignTypeIdx=0:this._btnAlignCenter.pressed?this._state.HAlignTypeIdx=1:this._state.HAlignTypeIdx=2,this.cmbHAlign.setValue(this._arrHAlign[this._state.HAlignTypeIdx][1]),this.radioHAlign.setValue(!0),(this._changedProps.get_PositionH()===null||this._changedProps.get_PositionH()===undefined)&&this._changedProps.put_PositionH(new CTablePositionH),this._changedProps.get_PositionH().put_UseAlign(!0),this._changedProps.get_PositionH().put_Align(this._arrHAlign[this._state.HAlignTypeIdx][0]),this._changedProps.get_PositionH().put_RelativeFrom(this._arrHRelative[this._state.HAlignFromIdx][0]),this._state.alignChanged=!1,this._state.horizontalPropChanged=!0):this._state.fromWrapInline&&!this._state.horizontalPropChanged&&this.radioHPosition.setValue(!0))},this)}),this._spnDistanceTop=Ext.create("Common.component.MetricSpinner",{id:"tableadv-number-distance-top",readOnly:!1,maxValue:55.87,minValue:0,step:.1,defaultUnit:"cm",value:"1 cm",width:85,listeners:{change:Ext.bind(function(e,t,n,r){this._changedProps&&(this._changedProps.get_TablePaddings()===undefined&&this._changedProps.put_TablePaddings(new CPaddings),this._changedProps.get_TablePaddings().put_Top(Common.MetricSettings.fnRecalcToMM(e.getNumberValue())))},this)}}),this._spnDistanceBottom=Ext.create("Common.component.MetricSpinner",{id:"tableadv-number-distance-bottom",readOnly:!1,maxValue:55.87,minValue:0,step:.1,defaultUnit:"cm",value:"1 cm",width:85,listeners:{change:Ext.bind(function(e,t,n,r){this._changedProps&&(this._changedProps.get_TablePaddings()===undefined&&this._changedProps.put_TablePaddings(new CPaddings),this._changedProps.get_TablePaddings().put_Bottom(Common.MetricSettings.fnRecalcToMM(e.getNumberValue())))},this)}}),this._spnDistanceLeft=Ext.create("Common.component.MetricSpinner",{id:"tableadv-number-distance-left",readOnly:!1,maxValue:55.87,minValue:0,step:.1,defaultUnit:"cm",value:"1 cm",width:85,listeners:{change:Ext.bind(function(e,t,n,r){this._changedProps&&(this._changedProps.get_TablePaddings()===undefined&&this._changedProps.put_TablePaddings(new CPaddings),this._changedProps.get_TablePaddings().put_Left(Common.MetricSettings.fnRecalcToMM(e.getNumberValue())))},this)}}),this._spnDistanceRight=Ext.create("Common.component.MetricSpinner",{id:"tableadv-number-distance-right",readOnly:!1,maxValue:55.87,minValue:0,step:.1,defaultUnit:"cm",value:"1 cm",width:85,listeners:{change:Ext.bind(function(e,t,n,r){this._changedProps&&(this._changedProps.get_TablePaddings()===undefined&&this._changedProps.put_TablePaddings(new CPaddings),this._changedProps.get_TablePaddings().put_Right(Common.MetricSettings.fnRecalcToMM(e.getNumberValue())))},this)}}),this._spnX=Ext.create("Common.component.MetricSpinner",{id:"tableadv-span-x",readOnly:!1,maxValue:55.87,minValue:-55.87,step:.1,defaultUnit:"cm",value:"1 cm",width:85,disabled:!0,listeners:{change:Ext.bind(function(e,t,n,r){this._changedProps&&((this._changedProps.get_PositionH()===null||this._changedProps.get_PositionH()===undefined)&&this._changedProps.put_PositionH(new CTablePositionH),this._changedProps.get_PositionH().put_UseAlign(!1),this._changedProps.get_PositionH().put_RelativeFrom(this._arrHRelative[this._state.HPositionFromIdx][0]),this._changedProps.get_PositionH().put_Value(Common.MetricSettings.fnRecalcToMM(e.getNumberValue())),this._state.spnXChanged=!0)},this)}}),this._spnY=Ext.create("Common.component.MetricSpinner",{id:"tableadv-span-y",readOnly:!1,maxValue:55.87,minValue:-55.87,step:.1,defaultUnit:"cm",value:"1 cm",width:85,disabled:!0,listeners:{change:Ext.bind(function(e,t,n,r){this._changedProps&&((this._changedProps.get_PositionV()===null||this._changedProps.get_PositionV()===undefined)&&this._changedProps.put_PositionV(new CTablePositionV),this._changedProps.get_PositionV().put_UseAlign(!1),this._changedProps.get_PositionV().put_RelativeFrom(this._arrVRelative[this._state.VPositionFromIdx][0]),this._changedProps.get_PositionV().put_Value(Common.MetricSettings.fnRecalcToMM(e.getNumberValue())),this._state.spnYChanged=!0)},this)}}),this._arrHAlign=[[c_oAscXAlign.Left,this.textLeft],[c_oAscXAlign.Center,this.textCenter],[c_oAscXAlign.Right,this.textRight]],this.cmbHAlign=Ext.create("Ext.form.field.ComboBox",{id:"tableadv-combo-halign",width:115,editable:!1,store:this._arrHAlign,queryMode:"local",triggerAction:"all",listeners:{select:Ext.bind(function(e,t,n){this._changedProps&&((this._changedProps.get_PositionH()===null||this._changedProps.get_PositionH()===undefined)&&this._changedProps.put_PositionH(new CTablePositionH),this._changedProps.get_PositionH().put_UseAlign(!0),this._changedProps.get_PositionH().put_RelativeFrom(this._arrHRelative[this._state.HAlignFromIdx][0]),this._changedProps.get_PositionH().put_Align(this._arrHAlign[t[0].index][0]),this._state.HAlignTypeIdx=t[0].index,this._state.alignChanged=!0)},this)}}),this.cmbHAlign.setValue(this._arrHAlign[0][0]),this._arrHRelative=[[c_oAscHAnchor.Margin,this.textMargin],[c_oAscHAnchor.Page,this.textPage],[c_oAscHAnchor.Text,this.textAnchorText]],this.cmbHRelative=Ext.create("Ext.form.field.ComboBox",{id:"tableadv-combo-hrelative",width:115,editable:!1,store:this._arrHRelative,queryMode:"local",triggerAction:"all",listeners:{select:Ext.bind(function(e,t,n){this._changedProps&&((this._changedProps.get_PositionH()===null||this._changedProps.get_PositionH()===undefined)&&this._changedProps.put_PositionH(new CTablePositionH),this._changedProps.get_PositionH().put_UseAlign(!0),this._changedProps.get_PositionH().put_RelativeFrom(this._arrHRelative[t[0].index][0]),this._changedProps.get_PositionH().put_Align(this._arrHAlign[this._state.HAlignTypeIdx][0]),this._state.HAlignFromIdx=t[0].index)},this)}}),this.cmbHRelative.setValue(this._arrHRelative[0][0]),this.cmbHPosition=Ext.create("Ext.form.field.ComboBox",{id:"tableadv-combo-hposition",width:115,editable:!1,store:this._arrHRelative,queryMode:"local",triggerAction:"all",disabled:!0,listeners:{select:Ext.bind(function(e,t,n){if(this._changedProps){(this._changedProps.get_PositionH()===null||this._changedProps.get_PositionH()===undefined)&&this._changedProps.put_PositionH(new CTablePositionH),this._changedProps.get_PositionH().put_UseAlign(!1),this._changedProps.get_PositionH().put_RelativeFrom(this._arrHRelative[t[0].index][0]),this._state.HPositionFromIdx=t[0].index;if(!this._state.spnXChanged){var r=this._originalProps.get_Value_X(this._arrHRelative[t[0].index][0]);this._spnX.suspendEvents(!1),this._spnX.setValue(Common.MetricSettings.fnRecalcFromMM(r)),this._spnX.resumeEvents()}this._changedProps.get_PositionH().put_Value(Common.MetricSettings.fnRecalcToMM(this._spnX.getNumberValue()))}},this)}}),this.cmbHPosition.setValue(this._arrHRelative[0][0]),this._arrVAlign=[[c_oAscYAlign.Top,this.textTop],[c_oAscYAlign.Center,this.textCenter],[c_oAscYAlign.Bottom,this.textBottom]],this.cmbVAlign=Ext.create("Ext.form.field.ComboBox",{id:"tableadv-combo-valign",width:115,editable:!1,store:this._arrVAlign,queryMode:"local",triggerAction:"all",listeners:{select:Ext.bind(function(e,t,n){this._changedProps&&((this._changedProps.get_PositionV()===null||this._changedProps.get_PositionV()===undefined)&&this._changedProps.put_PositionV(new CTablePositionV),this._changedProps.get_PositionV().put_UseAlign(!0),this._changedProps.get_PositionV().put_RelativeFrom(this._arrVRelative[this._state.VAlignFromIdx][0]),this._changedProps.get_PositionV().put_Align(this._arrVAlign[t[0].index][0]),this._state.VAlignTypeIdx=t[0].index)},this)}}),this.cmbVAlign.setValue(this._arrVAlign[0][0]),this._arrVRelative=[[c_oAscVAnchor.Margin,this.textMargin],[c_oAscVAnchor.Page,this.textPage],[c_oAscVAnchor.Text,this.textAnchorText]],this.cmbVRelative=Ext.create("Ext.form.field.ComboBox",{id:"tableadv-combo-vrelative",width:115,editable:!1,store:this._arrVRelative,queryMode:"local",triggerAction:"all",listeners:{select:Ext.bind(function(e,t,n){this._changedProps&&((this._changedProps.get_PositionV()===null||this._changedProps.get_PositionV()===undefined)&&this._changedProps.put_PositionV(new CTablePositionV),this._changedProps.get_PositionV().put_UseAlign(!0),this._changedProps.get_PositionV().put_RelativeFrom(this._arrVRelative[t[0].index][0]),this._changedProps.get_PositionV().put_Align(this._arrVAlign[this._state.VAlignTypeIdx][0]),this._state.VAlignFromIdx=t[0].index,this.chMove.suspendEvents(!1),this.chMove.setValue(this._arrVRelative[t[0].index][0]==c_oAscVAnchor.Text),this.chMove.resumeEvents())},this)}}),this.cmbVRelative.setValue(this._arrVRelative[0][0]),this.cmbVPosition=Ext.create("Ext.form.field.ComboBox",{id:"tableadv-combo-vposition",width:115,editable:!1,store:this._arrVRelative,queryMode:"local",triggerAction:"all",disabled:!0,listeners:{select:Ext.bind(function(e,t,n){if(this._changedProps){(this._changedProps.get_PositionV()===null||this._changedProps.get_PositionV()===undefined)&&this._changedProps.put_PositionV(new CTablePositionV),this._changedProps.get_PositionV().put_UseAlign(!1),this._changedProps.get_PositionV().put_RelativeFrom(this._arrVRelative[t[0].index][0]),this._state.VPositionFromIdx=t[0].index;if(!this._state.spnYChanged){var r=this._originalProps.get_Value_Y(this._arrVRelative[t[0].index][0]);this._spnY.suspendEvents(!1),this._spnY.setValue(Common.MetricSettings.fnRecalcFromMM(r)),this._spnY.resumeEvents()}this._changedProps.get_PositionV().put_Value(Common.MetricSettings.fnRecalcToMM(this._spnY.getNumberValue())),this.chMove.suspendEvents(!1),this.chMove.setValue(this._arrVRelative[t[0].index][0]==c_oAscVAnchor.Text),this.chMove.resumeEvents()}},this)}}),this.cmbVPosition.setValue(this._arrVRelative[0][0]),this.radioHAlign=Ext.create("Ext.form.field.Radio",{boxLabel:"",name:"asc-radio-horizontal",checked:!0,listeners:{change:Ext.bind(function(e,t,n,r){this._changedProps&&((this._changedProps.get_PositionH()===null||this._changedProps.get_PositionH()===undefined)&&this._changedProps.put_PositionH(new CTablePositionH),this._changedProps.get_PositionH().put_UseAlign(e.getValue()),e.getValue()&&(this._changedProps.get_PositionH().put_Align(this._arrHAlign[this._state.HAlignTypeIdx][0]),this._changedProps.get_PositionH().put_RelativeFrom(this._arrHRelative[this._state.HAlignFromIdx][0]))),e.getValue()&&(this.cmbHAlign.setDisabled(!1),this.cmbHRelative.setDisabled(!1),this._spnX.setDisabled(!0),this.cmbHPosition.setDisabled(!0),this._state.horizontalPropChanged=!0,this._state.alignChanged=!0)},this)}}),this.radioHPosition=Ext.create("Ext.form.field.Radio",{boxLabel:"",name:"asc-radio-horizontal",listeners:{change:Ext.bind(function(e,t,n,r){if(this._changedProps){(this._changedProps.get_PositionH()===null||this._changedProps.get_PositionH()===undefined)&&this._changedProps.put_PositionH(new CTablePositionH),this._changedProps.get_PositionH().put_UseAlign(!e.getValue());if(e.getValue()){if(!this._state.spnXChanged){var i=this._originalProps.get_Value_X(this._arrHRelative[this._state.HPositionFromIdx][0]);this._spnX.suspendEvents(!1),this._spnX.setValue(Common.MetricSettings.fnRecalcFromMM(i)),this._spnX.resumeEvents()}this._changedProps.get_PositionH().put_Value(Common.MetricSettings.fnRecalcToMM(this._spnX.getNumberValue())),this._changedProps.get_PositionH().put_RelativeFrom(this._arrHRelative[this._state.HPositionFromIdx][0])}}e.getValue()&&(this.cmbHAlign.setDisabled(!0),this.cmbHRelative.setDisabled(!0),this._spnX.setDisabled(!1),this.cmbHPosition.setDisabled(!1),this._state.alignChanged=!1)},this)}}),this.radioVAlign=Ext.create("Ext.form.field.Radio",{boxLabel:"",name:"asc-radio-vertical",checked:!0,listeners:{change:Ext.bind(function(e,t,n,r){this._changedProps&&((this._changedProps.get_PositionV()===null||this._changedProps.get_PositionV()===undefined)&&this._changedProps.put_PositionV(new CTablePositionV),this._changedProps.get_PositionV().put_UseAlign(e.getValue()),e.getValue()&&(this._changedProps.get_PositionV().put_Align(this._arrVAlign[this._state.VAlignTypeIdx][0]),this._changedProps.get_PositionV().put_RelativeFrom(this._arrVRelative[this._state.VAlignFromIdx][0]),this._state.verticalPropChanged=!0)),e.getValue()&&(this.cmbVAlign.setDisabled(!1),this.cmbVRelative.setDisabled(!1),this._spnY.setDisabled(!0),this.cmbVPosition.setDisabled(!0))},this)}}),this.radioVPosition=Ext.create("Ext.form.field.Radio",{boxLabel:"",name:"asc-radio-vertical",listeners:{change:Ext.bind(function(e,t,n,r){if(this._changedProps){(this._changedProps.get_PositionV()===null||this._changedProps.get_PositionV()===undefined)&&this._changedProps.put_PositionV(new CTablePositionV),this._changedProps.get_PositionV().put_UseAlign(!e.getValue());if(e.getValue()){if(!this._state.spnYChanged){var i=this._originalProps.get_Value_Y(this._arrVRelative[this._state.VPositionFromIdx][0]);this._spnY.suspendEvents(!1),this._spnY.setValue(Common.MetricSettings.fnRecalcFromMM(i)),this._spnY.resumeEvents()}this._changedProps.get_PositionV().put_Value(Common.MetricSettings.fnRecalcToMM(this._spnY.getNumberValue())),this._changedProps.get_PositionV().put_RelativeFrom(this._arrVRelative[this._state.VPositionFromIdx][0])}}e.getValue()&&(this.cmbVAlign.setDisabled(!0),this.cmbVRelative.setDisabled(!0),this._spnY.setDisabled(!1),this.cmbVPosition.setDisabled(!1))},this)}}),this.chMove=Ext.create("Common.component.IndeterminateCheckBox",{id:"tableadv-checkbox-move",boxLabel:this.textMove,listeners:{change:Ext.bind(function(e,t,n,r){if(this._changedProps){var i=this.cmbVPosition.getStore().getAt(e.getValue()=="checked"?2:1);this.cmbVRelative.isDisabled()?(this.cmbVPosition.select(i),this.cmbVPosition.fireEvent("select",this.cmbVPosition,[i])):(this.cmbVRelative.select(i),this.cmbVRelative.fireEvent("select",this.cmbVRelative,[i]))}},this)}}),this.chOverlap=Ext.create("Common.component.IndeterminateCheckBox",{id:"tableadv-checkbox-overlap",boxLabel:this.textOverlap,listeners:{change:Ext.bind(function(e,t,n,r){this._changedProps&&this._changedProps.put_AllowOverlap(e.getValue()=="checked")},this)}}),this._spacer=Ext.create("Ext.toolbar.Spacer",{width:"100%",height:10,html:'<div style="width: 100%; height: 40%; border-bottom: 1px solid #C7C7C7"></div>'});var t=[[c_tableBorder.BORDER_INNER,"cm","asc-advanced-settings-position-btn btn-adv-position-inner","tableadv-button-border-inner",this.tipInner],[c_tableBorder.BORDER_OUTER,"lrtb","asc-advanced-settings-position-btn btn-adv-position-outer","tableadv-button-border-outer",this.tipOuter],[c_tableBorder.BORDER_ALL,"lrtbcm","asc-advanced-settings-position-btn btn-adv-position-all","tableadv-button-border-all",this.tipAll],[c_tableBorder.BORDER_NONE,"","asc-advanced-settings-position-btn btn-adv-position-none","tableadv-button-border-none",this.tipNone]];this._btnsBorderPosition=[],Ext.Array.forEach(t,function(e,t){var n=Ext.create("Ext.Button",{id:e[3],cls:e[2],posId:e[0],strId:e[1],marginBottom:4,text:"",tooltip:e[4],listeners:{click:Ext.bind(function(e,t){this._ApplyBorderPreset(e.strId)},this)}});this._btnsBorderPosition.push(n)},this),this._tableBordersImageSpacing=Ext.widget("detablestyler",{id:"id-detablestyler-spacing",width:200,height:200,rows:this.tableStylerRows,columns:this.tableStylerColumns,spacingMode:!0}),this._tableBordersImage=Ext.widget("detablestyler",{id:"id-detablestyler",width:200,height:200,rows:this.tableStylerRows,columns:this.tableStylerColumns,spacingMode:!1});var n=[[c_tableBorder.BORDER_INNER,"cm","","asc-advanced-settings-position-btn btn-adv-position-inner-none","tableadv-button-border-inner-none",this.tipCellInner],[c_tableBorder.BORDER_OUTER,"lrtb","","asc-advanced-settings-position-btn btn-adv-position-outer-none","tableadv-button-border-outer-none",this.tipCellOuter],[c_tableBorder.BORDER_ALL,"lrtbcm","","asc-advanced-settings-position-btn btn-adv-position-all-none","tableadv-button-border-all-none",this.tipCellAll],[c_tableBorder.BORDER_NONE,"","","asc-advanced-settings-position-btn btn-adv-position-none-none","tableadv-button-border-none-none",this.tipNone],[c_tableBorder.BORDER_ALL_TABLE,"lrtbcm","lrtb","asc-advanced-settings-position-btn btn-adv-position-all-table","tableadv-button-border-all-table",this.tipTableOuterCellAll],[c_tableBorder.BORDER_NONE_TABLE,"","lrtb","asc-advanced-settings-position-btn btn-adv-position-none-table","tableadv-button-border-none-table",this.tipOuter],[c_tableBorder.BORDER_INNER_TABLE,"cm","lrtb","asc-advanced-settings-position-btn btn-adv-position-inner-table","tableadv-button-border-inner-table",this.tipTableOuterCellInner],[c_tableBorder.BORDER_OUTER_TABLE,"lrtb","lrtb","asc-advanced-settings-position-btn btn-adv-position-outer-table","tableadv-button-border-outer-table",this.tipTableOuterCellOuter]];this._btnsTableBorderPosition=[],Ext.Array.forEach(n,function(e,t){var n=Ext.create("Ext.Button",{id:e[4],cls:e[3],posId:e[0],strCellId:e[1],strTableId:e[2],text:"",tooltip:e[5],listeners:{click:Ext.bind(function(e,t){this._ApplyBorderPreset(e.strCellId,e.strTableId)},this)}});this._btnsTableBorderPosition.push(n)},this);var r=[{borderstyle:"",text:this.txtNoBorders,value:0,offsety:0},{text:"0.5 pt",value:.5,pxValue:.5,offsety:0},{text:"1 pt",value:1,pxValue:1,offsety:20},{text:"1.5 pt",value:1.5,pxValue:2,offsety:40},{text:"2.25 pt",value:2.25,pxValue:3,offsety:60},{text:"3 pt",value:3,pxValue:4,offsety:80},{text:"4.5 pt",value:4.5,pxValue:5,offsety:100},{text:"6 pt",value:6,pxValue:6,offsety:120}];for(var i=1;i<r.length;i++)r[i].borderstyle=Ext.String.format("background:url({0}) 0 {1}px; width:69px; height:20px; margin-right:5px;","resources/img/right-panels/BorderSize.png",-r[i].offsety);var s=Ext.create("Ext.data.Store",{model:"DE.model.ModelBorders",data:r}),o=Ext.create("Ext.XTemplate",'<tpl for="."><span style="display: inline-block; margin-top: 3px; font-size: 11px; height: 17px;">{text}</span><img src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" align="right" style="{borderstyle}"></tpl>');this.cmbBorderSize=Ext.create("Ext.form.field.ComboBox",{width:93,height:21,editable:!1,queryMode:"local",matchFieldWidth:!1,displayField:"text",store:s,listConfig:{mode:"local",width:145,itemTpl:o},listeners:{select:Ext.bind(function(t,n,r){this.BorderSize={ptValue:n[0].data.value,pxValue:n[0].data.pxValue},this._tableBordersImage.setVirtualBorderSize(this.BorderSize.pxValue),this._tableBordersImageSpacing.setVirtualBorderSize(this.BorderSize.pxValue);if(t.inputEl)if(n[0].data.value>0){t.inputEl.set({type:"image"}),t.inputEl.set({src:"data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw=="});var i=Ext.String.format("background:url({0}) no-repeat scroll 0 {1}px, url({2}) repeat scroll 0 0 white","resources/img/right-panels/BorderSize.png",-n[0].data.offsety,"resources/img/controls/text-bg.gif");Ext.DomHelper.applyStyles(t.inputEl,i)}else{var i=Ext.String.format("background: url({0}) repeat scroll 0 0 white","resources/img/controls/text-bg.gif");Ext.DomHelper.applyStyles(t.inputEl,i),t.inputEl.set({type:"text"}),t.inputEl.set({value:e.txtNoBorders}),t.onItemClick(t.picker,n[0])}},this),afterRender:function(){if(this.inputEl){Ext.DomHelper.applyStyles(this.inputEl,"padding-left:7px"),this.inputEl.set({type:"image"}),this.inputEl.set({src:"data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw=="});var e=Ext.String.format("background:url({0}) repeat scroll 0 {1}px, url({2}) repeat scroll 0 0 white","resources/img/right-panels/BorderSize.png",-20,"resources/img/controls/text-bg.gif");Ext.DomHelper.applyStyles(this.inputEl,e)}}},plugins:[{ptype:"comboboxscrollpane",pluginId:"scrollpane",settings:{enableKeyboardNavigation:!0}}]});var u=this.cmbBorderSize.getStore().getAt(2);this.cmbBorderSize.select(u),this.BorderSize={ptValue:u.data.value,pxValue:u.data.pxValue},this._btnBorderColor=Ext.create("Ext.button.Button",{id:"tableadv-button-border-color",arrowCls:"",width:45,height:22,color:"000000",menu:{showSeparator:!1,items:[this.colorsBorder=Ext.create("Common.component.ThemeColorPalette",{value:"000000",width:165,height:214,dynamiccolors:!0,dyncolorscount:10,colors:[this.textThemeColors,"-",{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},{color:"000000",effectId:5},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},"-",{color:"3D55FE",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},{color:"000000",effectId:5},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},"-","--","-",this.textStandartColors,"-","3D55FE","5301B3","980ABD","B2275F","F83D26","F86A1D","F7AC16","F7CA12","FAFF44","D6EF39","-","--"],listeners:{select:{fn:function(t,n,r,i){Ext.menu.Manager.hideAll();var s=Ext.String.format("#{0}",typeof n=="object"?n.color:n);e._btnBorderColor.color=n,e._tableBordersImage.setVirtualBorderColor(s),e._tableBordersImageSpacing.setVirtualBorderColor(s),e._btnBorderColor.btnEl&&Ext.DomHelper.applyStyles(e._btnBorderColor.btnEl,{"background-color":s})}}}}),{cls:"menu-item-noicon menu-item-color-palette-theme",text:this.textNewColor,listeners:{click:function(t,n){e.colorsBorder.addNewColor()}}}]},listeners:{render:function(e){var t=Ext.String.format("background-color:#{0}",typeof e.color=="object"?e.color.color:e.color);Ext.DomHelper.applyStyles(e.btnEl,t)}},setColor:function(e){var t,n;this.color=e,e=="transparent"||e.color=="transparent"?(t="1px solid #BEBEBE",n=e):(t="none",n=Ext.String.format("#{0}",typeof e=="object"?e.color:e)),this.btnEl!==undefined&&Ext.DomHelper.applyStyles(this.btnEl,{"background-color":n,border:t})}}),this._btnBackColor=Ext.create("Ext.button.Button",{id:"tableadv-button-back-color",arrowCls:"",width:50,height:22,color:"transparent",menu:{showSeparator:!1,items:[this.colorsBack=Ext.create("Common.component.ThemeColorPalette",{value:"000000",width:165,height:214,dynamiccolors:!0,dyncolorscount:10,colors:[this.textThemeColors,"-",{color:"3366FF",effectId:1},{color:"0000FF",effectId:2},{color:"000090",effectId:3},{color:"660066",effectId:4},{color:"800000",effectId:5},{color:"FF0000",effectId:1},{color:"FF6600",effectId:1},{color:"FFFF00",effectId:2},{color:"CCFFCC",effectId:3},{color:"008000",effectId:4},"-",{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},{color:"000000",effectId:5},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},"-","--","-",this.textStandartColors,"-","transparent","5301B3","980ABD","B2275F","F83D26","F86A1D","F7AC16","F7CA12","FAFF44","D6EF39","-","--"],listeners:{select:{fn:function(t,n,r,i){Ext.menu.Manager.hideAll();var s,o;n=="transparent"?(e._btnBackColor.color="transparent",s="transparent",o="1px solid #BEBEBE"):(e._btnBackColor.color=n,s=Ext.String.format("#{0}",typeof n=="object"?n.color:n),o="none"),e._btnBackColor.btnEl&&Ext.DomHelper.applyStyles(e._btnBackColor.btnEl,{"background-color":s,border:o}),e.CellColor={Value:1,Color:e._btnBackColor.color},e._cellBackground===null&&(e._cellBackground=new CBackground),e.CellColor.Color=="transparent"?(e._cellBackground.put_Value(1),e._cellBackground.put_Color(new CAscColor(0,0,0))):(e._cellBackground.put_Value(0),e._cellBackground.put_Color(e.getRgbColor(e.CellColor.Color)))}}}}),{cls:"menu-item-noicon menu-item-color-palette-theme",text:e.textNewColor,listeners:{click:function(t,n){e.colorsBack.addNewColor()}}}]},listeners:{render:function(e){var t,n;e.color=="transparent"?(t="1px solid #BEBEBE",n=e.color):(t="none",n=Ext.String.format("#{0}",typeof e.color=="object"?e.color.color:e.color)),Ext.DomHelper.applyStyles(e.btnEl,{"background-color":n,border:t})}},setColor:function(e){var t,n;this.color=e,e=="transparent"?(t="1px solid #BEBEBE",n=e):(t="none",n=Ext.String.format("#{0}",typeof e=="object"?e.color:e)),this.btnEl!==undefined&&Ext.DomHelper.applyStyles(this.btnEl,{"background-color":n,border:t})}}),this._btnTableBackColor=Ext.create("Ext.button.Button",{id:"tableadv-button-table-back-color",arrowCls:"",width:50,height:22,color:"transparent",menu:{showSeparator:!1,items:[this.colorsTableBack=Ext.create("Common.component.ThemeColorPalette",{value:"000000",width:165,height:214,dynamiccolors:!0,dyncolorscount:10,colors:[this.textThemeColors,"-",{color:"3366FF",effectId:1},{color:"0000FF",effectId:2},{color:"000090",effectId:3},{color:"660066",effectId:4},{color:"800000",effectId:5},{color:"FF0000",effectId:1},{color:"FF6600",effectId:1},{color:"FFFF00",effectId:2},{color:"CCFFCC",effectId:3},{color:"008000",effectId:4},"-",{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},{color:"000000",effectId:5},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},"-","--","-",this.textStandartColors,"-","transparent","5301B3","980ABD","B2275F","F83D26","F86A1D","F7AC16","F7CA12","FAFF44","D6EF39","-","--"],listeners:{select:{fn:function(t,n,r,i){Ext.menu.Manager.hideAll();var s,o;n=="transparent"?(e._btnTableBackColor.color="transparent",s="transparent",o="1px solid #BEBEBE"):(e._btnTableBackColor.color=n,s=Ext.String.format("#{0}",typeof n=="object"?n.color:n),o="none"),e._btnTableBackColor.btnEl&&Ext.DomHelper.applyStyles(e._btnTableBackColor.btnEl,{"background-color":s,border:o}),e.TableColor.Color=e._btnTableBackColor.color;if(e._changedProps){var u=e._changedProps.get_TableBackground();u===undefined&&(u=new CBackground,e._changedProps.put_TableBackground(u)),e.TableColor.Color=="transparent"?(u.put_Value(1),u.put_Color(new CAscColor(0,0,0))):(u.put_Value(0),u.put_Color(e.getRgbColor(e.TableColor.Color)))}}}}}),{cls:"menu-item-noicon menu-item-color-palette-theme",text:e.textNewColor,listeners:{click:function(t,n){e.colorsTableBack.addNewColor()}}}]},listeners:{render:function(e){var t,n;e.color=="transparent"?(t="1px solid #BEBEBE",n=e.color):(t="none",n=Ext.String.format("#{0}",typeof e.color=="object"?e.color.color:e.color)),Ext.DomHelper.applyStyles(e.btnEl,{"background-color":n,border:t})}},setColor:function(e){var t,n;this.color=e,e=="transparent"?(t="1px solid #BEBEBE",n=e):(t="none",n=Ext.String.format("#{0}",typeof e=="object"?e.color:e)),this.btnEl!==undefined&&Ext.DomHelper.applyStyles(this.btnEl,{"background-color":n,border:t})}}),this.btnWidthSpaces=Ext.widget("button",{width:160,height:27,cls:"asc-dialogmenu-btn",text:this.textWidthSpaces,textAlign:"right",enableToggle:!0,allowDepress:!1,toggleGroup:"advtablecardGroup",pressed:!0,listeners:{click:function(e){e.pressed&&this.mainCard.getLayout().setActiveItem("card-width")},scope:this}}),this.btnCellProps=Ext.widget("button",{width:160,height:27,cls:"asc-dialogmenu-btn",text:this.textCellProps,textAlign:"right",enableToggle:!0,allowDepress:!1,toggleGroup:"advtablecardGroup",listeners:{click:function(e){e.pressed&&(this.mainCard.getLayout().setActiveItem("card-cell"),this.CellMargins.Flag=="checked"&&this.TableMargins.isChanged&&(this.CellMargins.Left=this.TableMargins.Left,this.CellMargins.Top=this.TableMargins.Top,this.CellMargins.Right=this.TableMargins.Right,this.CellMargins.Bottom=this.TableMargins.Bottom,this.SuspendEvents(),this._spnMarginRight.setValue(this.CellMargins.Right),this._spnMarginLeft.setValue(this.CellMargins.Left),this._spnMarginBottom.setValue(this.CellMargins.Bottom),this._spnMarginTop.setValue(this.CellMargins.Top),this.ResumeEvents()),this.TableMargins.isChanged=!1)},scope:this}}),this.btnTextWrap=Ext.widget("button",{width:160,height:27,cls:"asc-dialogmenu-btn",text:this.textWrap,textAlign:"right",enableToggle:!0,allowDepress:!1,toggleGroup:"advtablecardGroup",listeners:{click:function(e){e.pressed&&this.mainCard.getLayout().setActiveItem("card-wrap")},scope:this}}),this.btnBorders=Ext.widget("button",{width:160,height:27,cls:"asc-dialogmenu-btn",textAlign:"right",text:this.textBordersBackgroung,enableToggle:!0,allowDepress:!1,toggleGroup:"advtablecardGroup",listeners:{click:function(e){e.pressed&&this.mainCard.getLayout().setActiveItem("card-borders")},scope:this}}),this.btnPosition=Ext.widget("button",{width:160,height:27,cls:"asc-dialogmenu-btn",text:this.textPosition,textAlign:"right",enableToggle:!0,allowDepress:!1,toggleGroup:"advtablecardGroup",card:"card-position",disabled:!0,listeners:{click:function(e){e.pressed&&this.mainCard.getLayout().setActiveItem("card-position")},scope:this}}),this._WidthSpacingContainer={xtype:"container",itemId:"card-width",layout:{type:"vbox",align:"stretch"},items:[{xtype:"container",height:86,padding:"0 10",layout:{type:"table",columns:3,tdAttrs:{style:"vertical-align: middle;"}},items:[this._chWidth,{xtype:"tbspacer",width:40,height:1},this._chAllowSpacing,{xtype:"tbspacer",height:6},{xtype:"tbspacer",height:6},{xtype:"tbspacer",height:6},this._nfWidth,{xtype:"tbspacer",width:40,height:1},this._nfSpacing,{xtype:"tbspacer",height:8},{xtype:"tbspacer",height:8},{xtype:"tbspacer",height:8},this._chAutofit]},this._spacer.cloneConfig({style:"margin: 15px 0 10px 0;"}),{xtype:"label",style:"font-weight: bold;margin-top: 1px; padding-left:10px;height:13px;",text:this.textDefaultMargins},{xtype:"tbspacer",height:8},{xtype:"container",height:84,padding:"0 10",layout:{type:"table",columns:2,tdAttrs:{style:"padding-right: 40px;vertical-align: middle;"}},items:[{xtype:"label",text:this.textTop,width:85},{xtype:"label",text:this.textLeft,width:85},{xtype:"tbspacer",height:2},{xtype:"tbspacer",height:2},this._spnTableMarginTop,this._spnTableMarginLeft,{xtype:"tbspacer",height:5},{xtype:"tbspacer",height:5},{xtype:"label",text:this.textBottom,width:85},{xtype:"label",text:this.textRight,width:85},{xtype:"tbspacer",height:2},{xtype:"tbspacer",height:2},this._spnTableMarginBottom,this._spnTableMarginRight]}]},this._CellPropsContainer={xtype:"container",itemId:"card-cell",layout:{type:"vbox",align:"stretch"},items:[{xtype:"label",style:"font-weight: bold;margin-top: 1px; padding-left:10px;height:13px;",text:this.textMargins},{xtype:"tbspacer",height:8},this._chCellMargins,{xtype:"tbspacer",height:5},{xtype:"container",height:86,padding:"0 10",layout:{type:"table",columns:2,tdAttrs:{style:"padding-right: 40px;vertical-align: middle;"}},items:[{xtype:"label",text:this.textTop,width:85},{xtype:"label",text:this.textLeft,width:85},{xtype:"tbspacer",height:2},{xtype:"tbspacer",height:2},this._spnMarginTop,this._spnMarginLeft,{xtype:"tbspacer",height:5},{xtype:"tbspacer",height:5},{xtype:"label",text:this.textBottom,width:85},{xtype:"label",text:this.textRight,width:85},{xtype:"tbspacer",height:2},{xtype:"tbspacer",height:2},this._spnMarginBottom,this._spnMarginRight]}]},this._WrapContainer={xtype:"container",itemId:"card-wrap",layout:{type:"vbox",align:"stretch"},items:[{xtype:"container",height:40,padding:"0 10",layout:"hbox",items:[this._btnWrapNone,{xtype:"tbspacer",width:3},this._btnWrapParallel]},this._spacer.cloneConfig({style:"margin: 15px 0 10px 0;"}),{xtype:"container",height:218,hidden:!0,hideId:"element-parallel",layout:{type:"vbox",align:"stretch"},items:[{xtype:"label",style:"font-weight: bold;margin-top: 1px; padding-left:10px;height:13px;",text:this.textDistance},{xtype:"tbspacer",height:10},{xtype:"container",height:92,padding:"0 10",layout:{type:"table",columns:2,tdAttrs:{style:"padding-right: 40px;vertical-align: middle;"}},items:[{xtype:"label",text:this.textTop,width:85},{xtype:"label",text:this.textLeft,width:85},{xtype:"tbspacer",height:3},{xtype:"tbspacer",height:3},this._spnDistanceTop,this._spnDistanceLeft,{xtype:"tbspacer",height:6},{xtype:"tbspacer",height:6},{xtype:"label",text:this.textBottom,width:85},{xtype:"label",text:this.textRight,width:85},{xtype:"tbspacer",height:3},{xtype:"tbspacer",height:3},this._spnDistanceBottom,this._spnDistanceRight]}]},{xtype:"container",height:100,hideId:"element-none",layout:{type:"vbox",align:"stretch"},items:[{xtype:"label",style:"font-weight: bold;margin-top: 1px; padding-left:10px;height:13px;",text:this.textAlign},{xtype:"tbspacer",height:7},{xtype:"container",height:45,layout:"hbox",align:"middle",padding:"0 10",items:[this._btnAlignLeft,{xtype:"tbspacer",width:3},this._btnAlignCenter,{xtype:"tbspacer",width:3},this._btnAlignRight]},{xtype:"tbspacer",height:10},{xtype:"container",height:22,padding:"0 10",layout:{type:"table",columns:2,tdAttrs:{style:"padding-right: 8px;vertical-align: middle;"}},items:[{xtype:"label",text:this.textIndLeft,style:"display: block;"},this._spnIndentLeft]}]}]},this._BordersContainer={xtype:"container",itemId:"card-borders",layout:{type:"vbox",align:"stretch"},items:[{xtype:"container",layout:{type:"hbox",align:"middle"},height:28,padding:"2px 5px 0 10px",style:"vertical-align: middle;",items:[{xtype:"label",text:this.textBorderWidth},{xtype:"tbspacer",width:6},this.cmbBorderSize,{xtype:"tbspacer",flex:1},{xtype:"label",text:this.textBorderColor},{xtype:"tbspacer",width:6},this._btnBorderColor]},this._spacer.cloneConfig({style:"margin: 15px 0 10px 0;"}),{xtype:"label",text:this.textBorderDesc,style:"padding-left:10px;height:13px;"},{xtype:"tbspacer",height:20},{xtype:"container",layout:{type:"hbox",align:"top"},height:210,width:200,padding:"0 10",style:"vertical-align: top;",items:[this.bordersImagePanel=Ext.create("Ext.container.Container",{layout:"card",activeItem:0,width:200,height:210,style:"padding-bottom:10px;",items:[this._tableBordersImage,this._tableBordersImageSpacing]}),{xtype:"tbspacer",width:25},{xtype:"container",layout:"hbox",height:210,width:100,items:[this._cellPresetsContainer=Ext.create("Ext.container.Container",{height:210,width:100,layout:{type:"table",columns:1,tdAttrs:{style:"padding-bottom: 4px; vertical-align: middle;"}},items:[{xtype:"tbspacer",height:5},this._btnsBorderPosition[2],this._btnsBorderPosition[3],this._btnsBorderPosition[0],this._btnsBorderPosition[1]]}),this._tablePresetsContainer=Ext.create("Ext.container.Container",{height:210,width:100,layout:{type:"table",columns:2,tdAttrs:{style:"padding-right: 10px; padding-bottom: 4px; vertical-align: middle;"}},items:[{xtype:"tbspacer",height:5},{xtype:"tbspacer",height:5},this._btnsTableBorderPosition[2],this._btnsTableBorderPosition[4],this._btnsTableBorderPosition[3],this._btnsTableBorderPosition[5],this._btnsTableBorderPosition[0],this._btnsTableBorderPosition[6],this._btnsTableBorderPosition[1],this._btnsTableBorderPosition[7]]})]}]},{xtype:"tbspacer",height:10},{xtype:"container",height:23,width:344,padding:"0 0 0 10",layout:"hbox",items:[this._cellBackContainer=Ext.create("Ext.container.Container",{height:23,width:154,layout:"hbox",items:[{xtype:"label",text:this.textBackColor,margin:"2px 2px 0 0"},this._btnBackColor]}),this._tableBackContainer=Ext.create("Ext.container.Container",{height:23,width:154,margin:"0 0 0 1px",layout:{type:"hbox"},items:[{xtype:"label",text:this.textTableBackColor,margin:"2px 2px 0 0"},this._btnTableBackColor]}),{xtype:"tbspacer",flex:1}]}]},this._contPosition=Ext.create("Ext.Container",{cls:"tableadv-advanced-container",padding:"0 10",layout:"vbox",layoutConfig:{align:"stretch"},height:238,width:200,items:[{xtype:"label",style:"font-weight: bold;margin-top: 1px; height:13px;",text:this.textHorizontal},{xtype:"tbspacer",height:12},{xtype:"container",layout:{type:"table",columns:3,tdAttrs:{style:"padding-right: 8px;"}},defaults:{xtype:"container",layout:"vbox",layoutConfig:{align:"stretch"},height:40,style:"float:left;"},items:[{width:15,items:[{xtype:"tbspacer",height:15},this.radioHAlign]},{width:130,items:[{xtype:"label",text:this.textAlignment,width:85},{xtype:"tbspacer",height:2},this.cmbHAlign]},{items:[{xtype:"label",text:this.textRelative,width:85},{xtype:"tbspacer",height:2},this.cmbHRelative]}]},{xtype:"tbspacer",height:8},{xtype:"container",layout:{type:"table",columns:3,tdAttrs:{style:"padding-right: 8px;"}},defaults:{xtype:"container",layout:"vbox",layoutConfig:{align:"stretch"},height:40,style:"float:left;"},items:[{width:15,items:[{xtype:"tbspacer",height:15},this.radioHPosition]},{width:130,items:[{xtype:"label",text:this.textPosition,width:85},{xtype:"tbspacer",height:2},this._spnX]},{items:[{xtype:"label",text:this.textRightOf,width:85},{xtype:"tbspacer",height:2},this.cmbHPosition]}]},{xtype:"tbspacer",height:10},{xtype:"label",style:"font-weight: bold;margin-top: 1px; height:13px;",text:this.textVertical},{xtype:"tbspacer",height:12},{xtype:"container",layout:{type:"table",columns:3,tdAttrs:{style:"padding-right: 8px;"}},defaults:{xtype:"container",layout:"vbox",layoutConfig:{align:"stretch"},height:40,style:"float:left;"},items:[{width:15,items:[{xtype:"tbspacer",height:15},this.radioVAlign]},{width:130,items:[{xtype:"label",text:this.textAlignment,width:85},{xtype:"tbspacer",height:2},this.cmbVAlign]},{items:[{xtype:"label",text:this.textRelative,width:85},{xtype:"tbspacer",height:2},this.cmbVRelative]}]},{xtype:"tbspacer",height:8},{xtype:"container",layout:{type:"table",columns:3,tdAttrs:{style:"padding-right: 8px;"}},defaults:{xtype:"container",layout:"vbox",layoutConfig:{align:"stretch"},height:40,style:"float:left;"},items:[{width:15,items:[{xtype:"tbspacer",height:15},this.radioVPosition]},{width:130,items:[{xtype:"label",text:this.textPosition,width:85},{xtype:"tbspacer",height:2},this._spnY]},{items:[{xtype:"label",text:this.textBelow,width:85},{xtype:"tbspacer",height:2},this.cmbVPosition]}]}]}),this._contOptions=Ext.create("Ext.Container",{cls:"tableadv-advanced-container",padding:"0 10",layout:"vbox",layoutConfig:{align:"stretch"},height:45,width:200,items:[{xtype:"label",style:"font-weight: bold;margin-top: 1px; height:13px;",text:this.textOptions},{xtype:"tbspacer",height:8},{xtype:"container",height:30,layout:{type:"table",columns:2,tdAttrs:{style:"padding-right: 25px;vertical-align: middle;"}},items:[this.chMove,this.chOverlap]}]});var a={xtype:"container",itemId:"card-position",width:330,layout:{type:"vbox",align:"stretch"},items:[this._contPosition,this._spacer.cloneConfig({style:"margin: 16px 0 11px 0;",height:6}),this._contOptions]};this.items=[{xtype:"container",height:370,layout:{type:"hbox",align:"stretch"},items:[{xtype:"container",width:160,padding:"5px 0 0 0",layout:{type:"vbox",align:"stretch"},defaults:{xtype:"container",layout:{type:"hbox",align:"middle",pack:"end"}},items:[{height:30,items:[this.btnWidthSpaces]},{height:30,items:[this.btnTextWrap]},{height:30,items:[this.btnBorders]},{height:30,items:[this.btnPosition]},{height:30,items:[this.btnCellProps]}]},{xtype:"box",cls:"advanced-settings-separator",height:"100%",width:8},this.mainCard=Ext.create("Ext.container.Container",{height:370,flex:1,padding:"12px 18px 0 10px",layout:"card",items:[this._WidthSpacingContainer,this._WrapContainer,this._BordersContainer,a,this._CellPropsContainer]})]},this._spacer.cloneConfig({style:"margin: 0 18px"}),{xtype:"container",height:40,layout:{type:"vbox",align:"center",pack:"center"},items:[{xtype:"container",width:182,height:24,layout:{type:"hbox",align:"middle"},items:[this.btnOk=Ext.widget("button",{cls:"asc-blue-button",width:86,height:22,margin:"0 5px 0 0",text:this.okButtonText,listeners:{click:function(e){this.fireEvent("onmodalresult",this,1),this.close()},scope:this}}),this.btnCancel=Ext.widget("button",{cls:"asc-darkgray-button",width:86,height:22,text:this.cancelButtonText,listeners:{click:function(e){this.fireEvent("onmodalresult",this,0),this.close()},scope:this}})]}]}],this.callParent(arguments)},afterRender:function(){this.callParent(arguments),this._setDefaults(this._originalProps);if(this.borderProps!==undefined){this._btnBorderColor.setColor(this.borderProps.borderColor);var e=Ext.String.format("#{0}",typeof this.borderProps.borderColor=="object"?this.borderProps.borderColor.color:this.borderProps.borderColor);this._tableBordersImageSpacing.setVirtualBorderColor(e),this._tableBordersImage.setVirtualBorderColor(e);var t=this.cmbBorderSize.getStore().findRecord("value",this.borderProps.borderSize.ptValue);t&&(this.cmbBorderSize.select(t),this.cmbBorderSize.fireEvent("select",this.cmbBorderSize,[t])),this.colorsBorder.select(this.borderProps.borderColor)}this.setTitle(this.textTitle),this.colorProps!==undefined&&this.sendThemeColors(this.colorProps[0],this.colorProps[1]);for(var n=0;n<this._tableBordersImageSpacing.rows;n++)for(var r=0;r<this._tableBordersImageSpacing.columns;r++)this._tableBordersImageSpacing.getCell(r,n).addListener("borderclick",function(e,t,n,r){this.ChangedCellBorders===undefined&&(this.ChangedCellBorders=new CBorders),this._UpdateCellBordersStyle(e,t,n,r,this.CellBorders,this.ChangedCellBorders)},this);this._tableBordersImageSpacing.addListener("borderclick",function(e,t,n,r){this.ChangedTableBorders===undefined&&(this.ChangedTableBorders=new CBorders),this._UpdateTableBordersStyle(e,t,n,r,this.TableBorders,this.ChangedTableBorders)},this);for(n=0;n<this._tableBordersImage.rows;n++)for(r=0;r<this._tableBordersImage.columns;r++)this._tableBordersImage.getCell(r,n).addListener("borderclick",function(e,t,n,r){this._allTable?this.ChangedTableBorders===undefined&&(this.ChangedTableBorders=new CBorders):this.ChangedCellBorders===undefined&&(this.ChangedCellBorders=new CBorders),this._UpdateCellBordersStyle(e,t,n,r,this._allTable?this.TableBorders:this.CellBorders,this._allTable?this.ChangedTableBorders:this.ChangedCellBorders)},this);this._tableBordersImage.addListener("borderclick",function(e,t,n,r){this._allTable?this.ChangedTableBorders===undefined&&(this.ChangedTableBorders=new CBorders):this.ChangedCellBorders===undefined&&(this.ChangedCellBorders=new CBorders),this._UpdateTableBordersStyle(e,t,n,r,this._allTable?this.TableBorders:this.CellBorders,this._allTable?this.ChangedTableBorders:this.ChangedCellBorders)},this)},setSettings:function(e){this._originalProps=new CTableProp(e.tableProps),this.borderProps=e.borderProps,this.colorProps=e.colorProps,this._changedProps=null},_setDefaults:function(e){if(e){this._allTable=!e.get_CellSelect();var t,n=e.get_Width();n!==null&&this._nfWidth.setValue(Common.MetricSettings.fnRecalcFromMM(n)),this._chWidth.setValue(n!==null),this._nfWidth.setDisabled(!this._chWidth.getValue());var r=e.get_Spacing();r!==null&&this._nfSpacing.setValue(Common.MetricSettings.fnRecalcFromMM(r)),this._chAllowSpacing.suspendEvents(!1),this._chAllowSpacing.setValue(r!==null),this._nfSpacing.setDisabled(!this._chAllowSpacing.getValue()),this._chAllowSpacing.resumeEvents();var i=e.get_TableLayout();this._chAutofit.setDisabled(i===undefined),this._chAutofit.setValue(i===c_oAscTableLayout.AutoFit),this._TblWrapStyleChanged(e.get_TableWrap()),this._btnWrapParallel.setDisabled(!e.get_CanBeFlow());var s=e.get_TableAlignment();s!==null&&(this._TblAlignChanged(s),this._spnIndentLeft.setValue(s!==c_tableAlign.TABLE_ALIGN_LEFT?0:Common.MetricSettings.fnRecalcFromMM(e.get_TableIndent())),this._spnIndentLeft.setDisabled(s!==c_tableAlign.TABLE_ALIGN_LEFT)),this._state.alignChanged=!1;var o=e.get_TablePaddings();o&&(this._spnDistanceTop.setValue(Common.MetricSettings.fnRecalcFromMM(o.get_Top())),this._spnDistanceLeft.setValue(Common.MetricSettings.fnRecalcFromMM(o.get_Left())),this._spnDistanceBottom.setValue(Common.MetricSettings.fnRecalcFromMM(o.get_Bottom())),this._spnDistanceRight.setValue(Common.MetricSettings.fnRecalcFromMM(o.get_Right())));var u=e.get_PositionH();if(u){t=u.get_RelativeFrom();for(var a=0;a<this._arrHRelative.length;a++)if(t==this._arrHRelative[a][0]){this.cmbHRelative.setValue(this._arrHRelative[a][1]),this.cmbHPosition.setValue(this._arrHRelative[a][1]),this._state.HPositionFromIdx=a,this._state.HAlignFromIdx=a;break}if(u.get_UseAlign()){t=u.get_Align();for(var a=0;a<this._arrHAlign.length;a++)if(t==this._arrHAlign[a][0]){this.cmbHAlign.setValue(this._arrHAlign[a][1]),this._state.HAlignTypeIdx=a;break}t=this._originalProps.get_Value_X(this._arrHRelative[this._state.HPositionFromIdx][0]),this._spnX.setValue(Common.MetricSettings.fnRecalcFromMM(t))}else this.radioHPosition.setValue(!0),t=u.get_Value(),this._spnX.setValue(Common.MetricSettings.fnRecalcFromMM(t))}else t=this._originalProps.get_Value_X(this._arrHRelative[this._state.HPositionFromIdx][0]),this._spnX.setValue(Common.MetricSettings.fnRecalcFromMM(t));u=e.get_PositionV();if(u){t=u.get_RelativeFrom();for(a=0;a<this._arrVRelative.length;a++)if(t==this._arrVRelative[a][0]){this.cmbVRelative.setValue(this._arrVRelative[a][1]),this.cmbVPosition.setValue(this._arrVRelative[a][1]),this._state.VAlignFromIdx=a,this._state.VPositionFromIdx=a;break}t==c_oAscVAnchor.Text&&this.chMove.setValue(!0);if(u.get_UseAlign()){t=u.get_Align();for(a=0;a<this._arrVAlign.length;a++)if(t==this._arrVAlign[a][0]){this.cmbVAlign.setValue(this._arrVAlign[a][1]),this._state.VAlignTypeIdx=a;break}t=e.get_Value_Y(this._arrVRelative[this._state.VPositionFromIdx][0]),this._spnY.setValue(Common.MetricSettings.fnRecalcFromMM(t))}else this.radioVPosition.setValue(!0),t=u.get_Value(),this._spnY.setValue(Common.MetricSettings.fnRecalcFromMM(t))}else t=e.get_Value_Y(this._arrVRelative[this._state.VPositionFromIdx][0]),this._spnY.setValue(Common.MetricSettings.fnRecalcFromMM(t));this.chOverlap.setValue(e.get_AllowOverlap()!==null?e.get_AllowOverlap():"indeterminate"),this._state.verticalPropChanged=!1,this._state.horizontalPropChanged=!1;var f=e.get_DefaultMargins();f&&(this.TableMargins={Left:f.get_Left()!==null?Common.MetricSettings.fnRecalcFromMM(f.get_Left()):null,Right:f.get_Right()!==null?Common.MetricSettings.fnRecalcFromMM(f.get_Right()):null,Top:f.get_Top()!==null?Common.MetricSettings.fnRecalcFromMM(f.get_Top()):null,Bottom:f.get_Bottom()!==null?Common.MetricSettings.fnRecalcFromMM(f.get_Bottom()):null}),f=e.get_CellMargins();var l=undefined;f&&(this.CellMargins={Left:f.get_Left()!==null?Common.MetricSettings.fnRecalcFromMM(f.get_Left()):null,Right:f.get_Right()!==null?Common.MetricSettings.fnRecalcFromMM(f.get_Right()):null,Top:f.get_Top()!==null?Common.MetricSettings.fnRecalcFromMM(f.get_Top()):null,Bottom:f.get_Bottom()!==null?Common.MetricSettings.fnRecalcFromMM(f.get_Bottom()):null},l=f.get_Flag(),l==1?(this.CellMargins.Flag="indeterminate",this._chCellMargins.setValue(this.CellMargins.Flag)):l==0?(this.CellMargins.Flag="checked",this._chCellMargins.setValue(1)):(this.CellMargins.Flag="unchecked",this._chCellMargins.setValue(0))),l===0&&(this.CellMargins.Left===null&&(this.CellMargins.Left=this.TableMargins.Left),this.CellMargins.Top===null&&(this.CellMargins.Top=this.TableMargins.Top),this.CellMargins.Right===null&&(this.CellMargins.Right=this.TableMargins.Right),this.CellMargins.Bottom===null&&(this.CellMargins.Bottom=this.TableMargins.Bottom)),this.fillMargins(this.CellMargins.Flag),this.TableBorders=new CBorders(e.get_TableBorders()),this.CellBorders=new CBorders(e.get_CellBorders()),this._UpdateBordersNoSpacing_(),this._UpdateBordersSpacing_();var c=this.CellBorders.get_InsideV()===null&&this.CellBorders.get_InsideH()===null;this._btnsBorderPosition[0].setDisabled(c&&!this._allTable),this._btnsTableBorderPosition[0].setDisabled(c&&!this._allTable),this._btnsTableBorderPosition[6].setDisabled(c&&!this._allTable);var h=e.get_TableBackground();if(h&&h.get_Value()==0){var p=h.get_Color();p?p.get_type()==c_oAscColor.COLOR_TYPE_SCHEME?this.TableColor={Value:1,Color:{color:this.getHexColor(p.get_r(),p.get_g(),p.get_b()),effectValue:p.get_value()}}:this.TableColor={Value:1,Color:this.getHexColor(p.get_r(),p.get_g(),p.get_b())}:this.TableColor={Value:1,Color:"transparent"}}else this.TableColor={Value:0,Color:"transparent"};h=e.get_CellsBackground();if(h)if(h.get_Value()==0){var p=h.get_Color();p?p.get_type()==c_oAscColor.COLOR_TYPE_SCHEME?this.CellColor={Value:1,Color:{color:this.getHexColor(p.get_r(),p.get_g(),p.get_b()),effectValue:p.get_value()}}:this.CellColor={Value:1,Color:this.getHexColor(p.get_r(),p.get_g(),p.get_b())}:this.CellColor={Value:1,Color:"transparent"}}else this.CellColor={Value:1,Color:"transparent"};else this.CellColor={Value:0,Color:"transparent"};this._btnBackColor.setColor(this.CellColor.Color);if(typeof this.CellColor.Color=="object"){for(var a=0;a<10;a++)if(this.ThemeValues[a]==this.CellColor.Color.effectValue){this.colorsBack.select(this.CellColor.Color,!0);break}}else this.colorsBack.select(this.CellColor.Color,!0);this._btnTableBackColor.setColor(this.TableColor.Color);if(typeof this.TableColor.Color=="object"){for(var a=0;a<10;a++)if(this.ThemeValues[a]==this.TableColor.Color.effectValue){this.colorsTableBack.select(this.TableColor.Color,!0);break}}else this.colorsTableBack.select(this.TableColor.Color,!0);this._tableBackContainer.setVisible(this._chAllowSpacing.getValue()||this._allTable),this._cellBackContainer.setVisible(this._chAllowSpacing.getValue()||!this._allTable),this._tablePresetsContainer.setVisible(this._chAllowSpacing.getValue()),this._cellPresetsContainer.setVisible(!this._chAllowSpacing.getValue()),this._chAllowSpacing.getValue()?(this.bordersImagePanel.getLayout().setActiveItem(this._tableBordersImageSpacing),this._UpdateBordersSpacing_()):(this.bordersImagePanel.getLayout().setActiveItem(this._tableBordersImage),this._UpdateBordersNoSpacing_())}this._changedProps=new CTableProp,this._cellBackground=null,this.ChangedTableBorders=undefined,this.ChangedCellBorders=undefined},getSettings:function(){return this._cellBackground&&(this._allTable?this._changedProps.get_Spacing()===null||this._changedProps.get_Spacing()===undefined&&this._originalProps.get_Spacing()===null?this._changedProps.put_CellsBackground(null):this._changedProps.put_CellsBackground(this._cellBackground):this._changedProps.put_CellsBackground(this._cellBackground)),this.ChangedTableBorders===null?this._changedProps.put_TableBorders(this.TableBorders):this.ChangedTableBorders!==undefined&&this._changedProps.put_TableBorders(this.ChangedTableBorders),this.ChangedCellBorders===null?this._changedProps.put_CellBorders(this.CellBorders):this.ChangedCellBorders!==undefined&&this._changedProps.put_CellBorders(this.ChangedCellBorders),{tableProps:this._changedProps,borderProps:{borderSize:this.BorderSize,borderColor:this._btnBorderColor.color}}},_ShowHideElem:function(e){var t=Ext.ComponentQuery.query('[hideId="element-parallel"]',this);for(var n=0;n<t.length;n++)e?t[n].show():t[n].hide();this.btnPosition.setDisabled(!e),t=Ext.ComponentQuery.query('[hideId="element-none"]',this);for(n=0;n<t.length;n++)e?t[n].hide():t[n].show()},_TblWrapStyleChanged:function(e){e==c_tableWrap.TABLE_WRAP_NONE?this._btnWrapNone.toggle(!0,!1):this._btnWrapParallel.toggle(!0,!1),this._state.fromWrapInline=e==c_tableWrap.TABLE_WRAP_NONE},_TblAlignChanged:function(e){e==c_tableAlign.TABLE_ALIGN_LEFT?this._btnAlignLeft.toggle(!0,!1):e==c_tableAlign.TABLE_ALIGN_CENTER?this._btnAlignCenter.toggle(!0,!1):this._btnAlignRight.toggle(!0,!1)},SuspendEvents:function(){for(var e=0;e<this.controls.length;e++)this.controls[e].suspendEvents(!1)},ResumeEvents:function(){for(var e=0;e<this.controls.length;e++)this.controls[e].resumeEvents()},fillMargins:function(e){this.SuspendEvents(),this._spnMarginLeft.setValue(this.CellMargins.Left!==null?this.CellMargins.Left:""),this._spnMarginTop.setValue(this.CellMargins.Top!==null?this.CellMargins.Top:""),this._spnMarginRight.setValue(this.CellMargins.Right!==null?this.CellMargins.Right:""),this._spnMarginBottom.setValue(this.CellMargins.Bottom!==null?this.CellMargins.Bottom:"");var t=e=="checked";this._spnMarginTop.setDisabled(t),this._spnMarginBottom.setDisabled(t),this._spnMarginLeft.setDisabled(t),this._spnMarginRight.setDisabled(t),this._spnTableMarginLeft.setValue(this.TableMargins.Left!==null?this.TableMargins.Left:""),this._spnTableMarginTop.setValue(this.TableMargins.Top!==null?this.TableMargins.Top:""),this._spnTableMarginRight.setValue(this.TableMargins.Right!==null?this.TableMargins.Right:""),this._spnTableMarginBottom.setValue(this.TableMargins.Bottom!==null?this.TableMargins.Bottom:""),this.ResumeEvents()},_UpdateBordersSpacing_:function(){this.SuspendEvents();var e=this.TableBorders,t=this.BorderSize,n=this._btnBorderColor.color;this._UpdateTableBorderSpacing_(e.get_Left(),"l"),this._UpdateTableBorderSpacing_(e.get_Top(),"t"),this._UpdateTableBorderSpacing_(e.get_Right(),"r"),this._UpdateTableBorderSpacing_(e.get_Bottom(),"b"),e=this.CellBorders;for(var r=0;r<this._tableBordersImageSpacing.rows;r++)this._UpdateCellBorderSpacing_(e.get_Left(),"l",this._tableBordersImageSpacing.getCell(0,r));for(r=0;r<this._tableBordersImageSpacing.rows;r++)this._UpdateCellBorderSpacing_(e.get_Right(),"r",this._tableBordersImageSpacing.getCell(this._tableBordersImageSpacing.columns-1,r));for(r=0;r<this._tableBordersImageSpacing.columns;r++)this._UpdateCellBorderSpacing_(e.get_Top(),"t",this._tableBordersImageSpacing.getCell(r,0));for(r=0;r<this._tableBordersImageSpacing.columns;r++)this._UpdateCellBorderSpacing_(e.get_Bottom(),"b",this._tableBordersImageSpacing.getCell(r,this._tableBordersImageSpacing.rows-1));this._allTable&&e.get_InsideV()===null&&e.put_InsideV(new CBorder);if(e.get_InsideV()!==null)for(r=0;r<this._tableBordersImageSpacing.rows;r++)this._UpdateCellBorderSpacing_(e.get_InsideV(),"r",this._tableBordersImageSpacing.getCell(0,r)),this._UpdateCellBorderSpacing_(e.get_InsideV(),"l",this._tableBordersImageSpacing.getCell(1,r));this._allTable&&e.get_InsideH()===null&&e.put_InsideH(new CBorder);if(e.get_InsideH()!==null)for(r=0;r<this._tableBordersImageSpacing.columns;r++)this._UpdateCellBorderSpacing_(e.get_InsideH(),"b",this._tableBordersImageSpacing.getCell(r,0)),this._UpdateCellBorderSpacing_(e.get_InsideH(),"t",this._tableBordersImageSpacing.getCell(r,1));this._tableBordersImageSpacing.setVirtualBorderSize(t.pxValue);var i=Ext.String.format("#{0}",typeof n=="object"?n.color:n);this._tableBordersImageSpacing.setVirtualBorderColor(i),this.ResumeEvents()},_UpdateCellBorderSpacing_:function(e,t,n){null!==e&&undefined!==e?null!==e.get_Value()&&null!==e.get_Size()&&null!==e.get_Color()?1==e.get_Value()?(n.setBordersSize(t,this._BorderPt2Px(e.get_Size()*72/25.4)),n.setBordersColor(t,"rgb("+e.get_Color().get_r()+","+e.get_Color().get_g()+","+e.get_Color().get_b()+")")):n.setBordersSize(t,0):(n.setBordersSize(t,this.IndeterminateSize),n.setBordersColor(t,this.IndeterminateColor)):(n.setBordersSize(t,this.IndeterminateSize),n.setBordersColor(t,this.IndeterminateColor))},_UpdateTableBorderSpacing_:function(e,t){null!==e&&undefined!==e?null!==e.get_Value()&&null!==e.get_Size()&&null!==e.get_Color()?1==e.get_Value()?(this._tableBordersImageSpacing.setBordersSize(t,this._BorderPt2Px(e.get_Size()*72/25.4)),this._tableBordersImageSpacing.setBordersColor(t,"rgb("+e.get_Color().get_r()+","+e.get_Color().get_g()+","+e.get_Color().get_b()+")")):this._tableBordersImageSpacing.setBordersSize(t,0):(this._tableBordersImageSpacing.setBordersSize(t,this.IndeterminateSize),this._tableBordersImageSpacing.setBordersColor(t,this.IndeterminateColor)):(this._tableBordersImageSpacing.setBordersSize(t,this.IndeterminateSize),this._tableBordersImageSpacing.setBordersColor(t,this.IndeterminateColor))},_UpdateBordersNoSpacing_:function(){this.SuspendEvents();var e=this._allTable?this.TableBorders:this.CellBorders,t=this.BorderSize,n=this._btnBorderColor.color;this._UpdateTableBorderNoSpacing_(e.get_Left(),"l"),this._UpdateTableBorderNoSpacing_(e.get_Top(),"t"),this._UpdateTableBorderNoSpacing_(e.get_Right(),"r"),this._UpdateTableBorderNoSpacing_(e.get_Bottom(),"b"),this._allTable&&e.get_InsideV()==null&&e.put_InsideV(new CBorder);if(e.get_InsideV()!==null)for(var r=0;r<this._tableBordersImage.rows;r++)this._UpdateCellBorderNoSpacing_(e.get_InsideV(),"r",this._tableBordersImage.getCell(0,r)),this._UpdateCellBorderNoSpacing_(e.get_InsideV(),"l",this._tableBordersImage.getCell(1,r));this._allTable&&e.get_InsideH()==null&&e.put_InsideH(new CBorder);if(e.get_InsideH()!==null)for(r=0;r<this._tableBordersImage.columns;r++)this._UpdateCellBorderNoSpacing_(e.get_InsideH(),"b",this._tableBordersImage.getCell(r,0)),this._UpdateCellBorderNoSpacing_(e.get_InsideH(),"t",this._tableBordersImage.getCell(r,1));this._tableBordersImage.setVirtualBorderSize(t.pxValue);var i=Ext.String.format("#{0}",typeof n=="object"?n.color:n);this._tableBordersImage.setVirtualBorderColor(i),this.ResumeEvents()},_UpdateCellBorderNoSpacing_:function(e,t,n){null!==e&&undefined!==e?null!==e.get_Value()&&null!==e.get_Size()&&null!==e.get_Color()?1==e.get_Value()?(n.setBordersSize(t,this._BorderPt2Px(e.get_Size()*72/25.4)),n.setBordersColor(t,"rgb("+e.get_Color().get_r()+","+e.get_Color().get_g()+","+e.get_Color().get_b()+")")):n.setBordersSize(t,0):(n.setBordersSize(t,this.IndeterminateSize),n.setBordersColor(t,this.IndeterminateColor)):(n.setBordersSize(t,this.IndeterminateSize),n.setBordersColor(t,this.IndeterminateColor))},_UpdateTableBorderNoSpacing_:function(e,t){null!==e&&undefined!==e?null!==e.get_Value()&&null!==e.get_Size()&&null!==e.get_Color()?1==e.get_Value()?(this._tableBordersImage.setBordersSize(t,this._BorderPt2Px(e.get_Size()*72/25.4)),this._tableBordersImage.setBordersColor(t,"rgb("+e.get_Color().get_r()+","+e.get_Color().get_g()+","+e.get_Color().get_b()+")")):this._tableBordersImage.setBordersSize(t,0):(this._tableBordersImage.setBordersSize(t,this.IndeterminateSize),this._tableBordersImage.setBordersColor(t,this.IndeterminateColor)):(this._tableBordersImage.setBordersSize(t,this.IndeterminateSize),this._tableBordersImage.setBordersColor(t,this.IndeterminateColor))},_BorderPt2Px:function(e){return e==0?0:e<.6?.5:e<=1?1:e<=1.5?2:e<=2.25?3:e<=3?4:e<=4.5?5:6},_ApplyBorderPreset:function(e,t){var n;this._allTable&&t===undefined?(n=this.TableBorders,this.ChangedTableBorders=null):(n=this.CellBorders,this.ChangedCellBorders=null),this._UpdateBorderStyle(n.get_Left(),e.indexOf("l")>-1),this._UpdateBorderStyle(n.get_Top(),e.indexOf("t")>-1),this._UpdateBorderStyle(n.get_Right(),e.indexOf("r")>-1),this._UpdateBorderStyle(n.get_Bottom(),e.indexOf("b")>-1),this._UpdateBorderStyle(n.get_InsideV(),e.indexOf("c")>-1),this._UpdateBorderStyle(n.get_InsideH(),e.indexOf("m")>-1);if(t===undefined){this._UpdateBordersNoSpacing_(),this._allTable&&(n=this.CellBorders,this.ChangedCellBorders=null,this._UpdateBorderStyle(n.get_Left(),e.indexOf("l")>-1),this._UpdateBorderStyle(n.get_Top(),e.indexOf("t")>-1),this._UpdateBorderStyle(n.get_Right(),e.indexOf("r")>-1),this._UpdateBorderStyle(n.get_Bottom(),e.indexOf("b")>-1),this._UpdateBorderStyle(n.get_InsideV(),e.indexOf("c")>-1),this._UpdateBorderStyle(n.get_InsideH(),e.indexOf("m")>-1));return}n=this.TableBorders,this.ChangedTableBorders=null,this._UpdateBorderStyle(n.get_Left(),t.indexOf("l")>-1),this._UpdateBorderStyle(n.get_Top(),t.indexOf("t")>-1),this._UpdateBorderStyle(n.get_Right(),t.indexOf("r")>-1),this._UpdateBorderStyle(n.get_Bottom(),t.indexOf("b")>-1),this._UpdateBordersSpacing_()},_UpdateCellBordersStyle:function(e,t,n,r,i,s){var o=i;e.col==0&&t.indexOf("l")>-1&&(this._UpdateBorderStyle(o.get_Left(),n>0),s&&s.put_Left(new CBorder(o.get_Left()))),e.col==this.tableStylerColumns-1&&t.indexOf("r")>-1&&(this._UpdateBorderStyle(o.get_Right(),n>0),s&&s.put_Right(new CBorder(o.get_Right()))),e.row==0&&t.indexOf("t")>-1&&(this._UpdateBorderStyle(o.get_Top(),n>0),s&&s.put_Top(new CBorder(o.get_Top()))),e.row==this.tableStylerRows-1&&t.indexOf("b")>-1&&(this._UpdateBorderStyle(o.get_Bottom(),n>0),s&&s.put_Bottom(new CBorder(o.get_Bottom())));if(e.col==0&&t.indexOf("r")>-1||e.col==this.tableStylerColumns-1&&t.indexOf("l")>-1)this._UpdateBorderStyle(o.get_InsideV(),n>0),s&&s.put_InsideV(new CBorder(o.get_InsideV()));if(e.row==0&&t.indexOf("b")>-1||e.row==this.tableStylerRows-1&&t.indexOf("t")>-1)this._UpdateBorderStyle(o.get_InsideH(),n>0),s&&s.put_InsideH(new CBorder(o.get_InsideH()))},_UpdateTableBordersStyle:function(e,t,n,r,i,s){var o=i;t.indexOf("l")>-1&&(this._UpdateBorderStyle(o.get_Left(),n>0),s&&s.put_Left(new CBorder(o.get_Left()))),t.indexOf("t")>-1&&(this._UpdateBorderStyle(o.get_Top(),n>0),s&&s.put_Top(new CBorder(o.get_Top()))),t.indexOf("r")>-1&&(this._UpdateBorderStyle(o.get_Right(),n>0),s&&s.put_Right(new CBorder(o.get_Right()))),t.indexOf("b")>-1&&(this._UpdateBorderStyle(o.get_Bottom(),n>0),s&&s.put_Bottom(new CBorder(o.get_Bottom())))},_UpdateBorderStyle:function(e,t){if(null==e)return 0;if(t&&this.BorderSize.ptValue>0){var n=parseFloat(this.BorderSize.ptValue);e.put_Value(1),e.put_Size(n*25.4/72);var r=this.getRgbColor(this._btnBorderColor.color);e.put_Color(r)}else e.put_Color(new CAscColor),e.put_Value(0);return e.get_Value()},getRgbColor:function(e){var t=typeof e=="object"?e.color:e;t=t.replace(/#/,""),t.length==3&&(t=t.replace(/(.)/g,"$1$1")),t=parseInt(t,16);var n=new CAscColor;return n.put_type(typeof e=="object"?c_oAscColor.COLOR_TYPE_SCHEME:c_oAscColor.COLOR_TYPE_SRGB),n.put_r(t>>16),n.put_g((t&65280)>>8),n.put_b(t&255),n.put_a(255),e.effectId!==undefined&&n.put_value(e.effectId),n},getHexColor:function(e,t,n){return e=e.toString(16),t=t.toString(16),n=n.toString(16),e.length==1&&(e="0"+e),t.length==1&&(t="0"+t),n.length==1&&(n="0"+n),e+t+n},sendThemeColors:function(e,t){this.colorsBorder.updateColors(e,t),this.colorsBack.updateColors(e,t),this.colorsTableBack.updateColors(e,t)},updateMetricUnit:function(){var e=this.query("commonmetricspinner");if(e)for(var t=0;t<e.length;t++){var n=e[t];n.setDefaultUnit(Common.MetricSettings.metricName[Common.MetricSettings.getCurrentMetric()]),n.setStep(Common.MetricSettings.getCurrentMetric()==Common.MetricSettings.c_MetricUnits.cm?.1:1)}},textWidth:"Width",textAllowSpacing:"Allow spacing between cells",textAlign:"Alignment",textIndLeft:"Indent from Left",textWidthSpaces:"Width & Spaces",textWrap:"Text Wrapping",textMargins:"Cell Margins",textTop:"Top",textLeft:"Left",textBottom:"Bottom",textRight:"Right",textDistance:"Distance From Text",textPosition:"Position",textWrapParallelTooltip:"Flow table",textWrapNoneTooltip:"Inline table",textLeftTooltip:"Left",textRightTooltip:"Right",textCenterTooltip:"Center",textTitle:"Table - Advanced Settings",textDefaultMargins:"Default Margins",textCheckMargins:"Use default margins",textBordersBackgroung:"Borders & Background",textOnlyCells:"For selected cells only",textBorderWidth:"Border Size",textBorderColor:"Border Color",textBackColor:"Cell Background",textPreview:"Preview",textBorderDesc:"Click on diagramm or use buttons to select borders",textTableBackColor:"Table Background",cancelButtonText:"Cancel",okButtonText:"Ok",txtNoBorders:"No borders",textNewColor:"Add New Custom Color",textThemeColors:"Theme Colors",textStandartColors:"Standart Colors",textCenter:"Center",textMargin:"Margin",textPage:"Page",textHorizontal:"Horizontal",textVertical:"Vertical",textAlignment:"Alignment",textRelative:"relative to",textRightOf:"to the right Of",textBelow:"below",textOverlap:"Allow overlap",textMove:"Move object with text",textOptions:"Options",textAnchorText:"Text",textAutofit:"Automatically resize to fit contents",textCellProps:"Cell Properties",tipAll:"Set Outer Border and All Inner Lines",tipNone:"Set No Borders",tipInner:"Set Inner Lines Only",tipOuter:"Set Outer Border Only",tipCellAll:"Set Borders for Inner Cells Only",tipTableOuterCellAll:"Set Outer Border and Borders for All Inner Cells",tipCellInner:"Set Vertical and Horizontal Lines for Inner Cells Only",tipTableOuterCellInner:"Set Outer Border and Vertical and Horizontal Lines for Inner Cells",tipCellOuter:"Set Outer Borders for Inner Cells Only",tipTableOuterCellOuter:"Set Table Outer Border and Outer Borders for Inner Cells"}),Ext.define("DE.view.ParagraphSettingsAdvanced",{extend:"Ext.window.Window",alias:"widget.deparagraphsettingsadvanced",requires:["Ext.Array","Ext.form.field.ComboBox","Ext.window.Window","Common.component.ThemeColorPalette","Common.component.MetricSpinner","DE.component.TableStyler","Common.component.IndeterminateCheckBox","Common.plugin.GridScrollPane","Ext.grid.Panel","Common.plugin.ComboBoxScrollPane"],cls:"asc-advanced-settings-window",modal:!0,resizable:!1,plain:!0,constrain:!0,height:390,width:516,layout:{type:"vbox",align:"stretch"},initComponent:function(){var e=this;this.addEvents("onmodalresult"),this.Borders={},this.BorderSize={ptValue:0,pxValue:0},this.paragraphShade="transparent",this._changedProps=null,this.ChangedBorders=undefined,this.checkGroup=0,this._noApply=!0,this._tabListChanged=!1,this.Margins=undefined,this.ThemeValues=[6,15,7,16,0,1,2,3,4,5],this.numFirstLine=Ext.create("Common.component.MetricSpinner",{id:"paragraphadv-spin-first-line",readOnly:!1,step:.1,width:85,defaultUnit:"cm",value:"0 cm",maxValue:55.87,minValue:-55.87,listeners:{change:Ext.bind(function(e,t,n,r){this._changedProps&&((this._changedProps.get_Ind()===null||this._changedProps.get_Ind()===undefined)&&this._changedProps.put_Ind(new CParagraphInd),this._changedProps.get_Ind().put_FirstLine(Common.MetricSettings.fnRecalcToMM(e.getNumberValue())))},this)}}),this.numIndentsLeft=Ext.widget("commonmetricspinner",{id:"paragraphadv-spin-indent-left",readOnly:!1,step:.1,width:85,defaultUnit:"cm",value:"0 cm",maxValue:55.87,minValue:-55.87,listeners:{change:Ext.bind(function(e,t,n,r){this._changedProps&&((this._changedProps.get_Ind()===null||this._changedProps.get_Ind()===undefined)&&this._changedProps.put_Ind(new CParagraphInd),this._changedProps.get_Ind().put_Left(Common.MetricSettings.fnRecalcToMM(e.getNumberValue())))},this)}}),this.numIndentsRight=Ext.widget("commonmetricspinner",{id:"paragraphadv-spin-indent-right",readOnly:!1,step:.1,width:85,defaultUnit:"cm",value:"0 cm",maxValue:55.87,minValue:-55.87,listeners:{change:Ext.bind(function(e,t,n,r){this._changedProps&&((this._changedProps.get_Ind()===null||this._changedProps.get_Ind()===undefined)&&this._changedProps.put_Ind(new CParagraphInd),this._changedProps.get_Ind().put_Right(Common.MetricSettings.fnRecalcToMM(e.getNumberValue())))},this)}}),this._spacer=Ext.create("Ext.toolbar.Spacer",{width:"100%",height:10,html:'<div style="width: 100%; height: 40%; border-bottom: 1px solid #C7C7C7"></div>'}),this.chBreakBefore=Ext.create("Common.component.IndeterminateCheckBox",{id:"paragraphadv-checkbox-break-before",boxLabel:this.strBreakBefore,listeners:{change:Ext.bind(function(e,t,n,r){this._changedProps&&this._changedProps.put_PageBreakBefore(e.getValue()=="checked")},this)}}),this.chKeepLines=Ext.create("Common.component.IndeterminateCheckBox",{id:"paragraphadv-checkbox-keep-lines",boxLabel:this.strKeepLines,listeners:{change:Ext.bind(function(e,t,n,r){this._changedProps&&this._changedProps.put_KeepLines(e.getValue()=="checked")},this)}}),this.chOrphan=Ext.create("Common.component.IndeterminateCheckBox",{id:"paragraphadv-checkbox-orphan",boxLabel:this.strOrphan,listeners:{change:Ext.bind(function(e,t,n,r){this._changedProps&&this._changedProps.put_WidowControl(e.getValue()=="checked")},this)}}),this.chKeepNext=Ext.create("Common.component.IndeterminateCheckBox",{id:"paragraphadv-checkbox-keep-next",boxLabel:this.strKeepNext,listeners:{change:Ext.bind(function(e,t,n,r){this._changedProps&&this._changedProps.put_KeepNext(e.getValue()=="checked")},this)}});var t=[[c_tableBorder.BORDER_OUTER,"lrtb","asc-advanced-settings-position-btn btn-adv-paragraph-outer","paragraphadv-button-border-outer",this.tipOuter],[c_tableBorder.BORDER_ALL,"lrtbm","asc-advanced-settings-position-btn btn-adv-paragraph-all","paragraphadv-button-border-all",this.tipAll],[c_tableBorder.BORDER_NONE,"","asc-advanced-settings-position-btn btn-adv-paragraph-none","paragraphadv-button-border-none",this.tipNone],[c_tableBorder.BORDER_VERTICAL_LEFT,"l","asc-advanced-settings-position-btn btn-adv-paragraph-left","paragraphadv-button-border-left",this.tipLeft],[c_tableBorder.BORDER_VERTICAL_RIGHT,"r","asc-advanced-settings-position-btn btn-adv-paragraph-right","paragraphadv-button-border-right",this.tipRight],[c_tableBorder.BORDER_HORIZONTAL_TOP,"t","asc-advanced-settings-position-btn btn-adv-paragraph-top","paragraphadv-button-border-top",this.tipTop],[c_tableBorder.BORDER_HORIZONTAL_CENTER,"m","asc-advanced-settings-position-btn btn-adv-paragraph-inner-hor","paragraphadv-button-border-inner-hor",this.tipInner],[c_tableBorder.BORDER_HORIZONTAL_BOTTOM,"b","asc-advanced-settings-position-btn btn-adv-paragraph-bottom","paragraphadv-button-border-bottom",this.tipBottom]];this._btnsBorderPosition=[],Ext.Array.forEach(t,function(e,t){var n=Ext.create("Ext.Button",{id:e[3],cls:e[2],posId:e[0],strId:e[1],text:"",tooltip:e[4],listeners:{click:Ext.bind(function(e,t){this._ApplyBorderPreset(e.strId)},this)}});this._btnsBorderPosition.push(n)},this),this._BordersImage=Ext.widget("detablestyler",{id:"id-deparagraphstyler",width:200,height:170,rows:this.tableStylerRows,columns:this.tableStylerColumns,spacingMode:!1});var n=[{borderstyle:"",text:this.txtNoBorders,value:0,offsety:0},{text:"0.5 pt",value:.5,pxValue:.5,offsety:0},{text:"1 pt",value:1,pxValue:1,offsety:20},{text:"1.5 pt",value:1.5,pxValue:2,offsety:40},{text:"2.25 pt",value:2.25,pxValue:3,offsety:60},{text:"3 pt",value:3,pxValue:4,offsety:80},{text:"4.5 pt",value:4.5,pxValue:5,offsety:100},{text:"6 pt",value:6,pxValue:6,offsety:120}];for(var r=1;r<n.length;r++)n[r].borderstyle=Ext.String.format("background:url({0}) 0 {1}px; width:69px; height:20px; margin-right:5px;","resources/img/right-panels/BorderSize.png",-n[r].offsety);var i=Ext.create("Ext.data.Store",{model:"DE.model.ModelBorders",data:n}),s=Ext.create("Ext.XTemplate",'<tpl for="."><span style="display: inline-block; margin-top: 3px; font-size: 11px; height: 17px;">{text}</span><img src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" align="right" style="{borderstyle}"></tpl>');this.cmbBorderSize=Ext.create("Ext.form.field.ComboBox",{width:93,height:21,editable:!1,queryMode:"local",matchFieldWidth:!1,displayField:"text",store:i,listConfig:{mode:"local",width:145,itemTpl:s},listeners:{select:Ext.bind(function(t,n,r){this.BorderSize={ptValue:n[0].data.value,pxValue:n[0].data.pxValue},this._BordersImage.setVirtualBorderSize(this.BorderSize.pxValue);if(t.inputEl)if(n[0].data.value>0){t.inputEl.set({type:"image"}),t.inputEl.set({src:"data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw=="});var i=Ext.String.format("background:url({0}) no-repeat scroll 0 {1}px, url({2}) repeat scroll 0 0 white","resources/img/right-panels/BorderSize.png",-n[0].data.offsety,"resources/img/controls/text-bg.gif");Ext.DomHelper.applyStyles(t.inputEl,i)}else{var i=Ext.String.format("background: url({0}) repeat scroll 0 0 white","resources/img/controls/text-bg.gif");Ext.DomHelper.applyStyles(t.inputEl,i),t.inputEl.set({type:"text"}),t.inputEl.set({value:e.txtNoBorders}),t.onItemClick(t.picker,n[0])}},this),afterRender:function(){if(this.inputEl){Ext.DomHelper.applyStyles(this.inputEl,"padding-left:7px"),this.inputEl.set({type:"image"}),this.inputEl.set({src:"data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw=="});var e=Ext.String.format("background:url({0}) repeat scroll 0 {1}px, url({2}) repeat scroll 0 0 white","resources/img/right-panels/BorderSize.png",-20,"resources/img/controls/text-bg.gif");Ext.DomHelper.applyStyles(this.inputEl,e)}}},plugins:[{ptype:"comboboxscrollpane",pluginId:"scrollpane",settings:{enableKeyboardNavigation:!0}}]});var o=this.cmbBorderSize.getStore().getAt(2);this.cmbBorderSize.select(o),this.BorderSize={ptValue:o.data.value,pxValue:o.data.pxValue},this._btnBorderColor=Ext.create("Ext.button.Button",{id:"paragraphadv-button-border-color",arrowCls:"",width:45,height:22,color:"000000",menu:{showSeparator:!1,items:[this.colorsBorder=Ext.create("Common.component.ThemeColorPalette",{value:"000000",width:165,height:214,dynamiccolors:!0,dyncolorscount:10,colors:[this.textThemeColors,"-",{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},{color:"000000",effectId:5},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},"-",{color:"3D55FE",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},{color:"000000",effectId:5},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},"-","--","-",this.textStandartColors,"-","3D55FE","5301B3","980ABD","B2275F","F83D26","F86A1D","F7AC16","F7CA12","FAFF44","D6EF39","-","--"],listeners:{select:{fn:function(t,n,r,i){Ext.menu.Manager.hideAll();var s=Ext.String.format("#{0}",typeof n=="object"?n.color:n);e._btnBorderColor.color=n,e._BordersImage.setVirtualBorderColor(s),e._btnBorderColor.btnEl&&Ext.DomHelper.applyStyles(e._btnBorderColor.btnEl,{"background-color":s})}}}}),{cls:"menu-item-noicon menu-item-color-palette-theme",text:this.textNewColor,listeners:{click:function(t,n){e.colorsBorder.addNewColor()}}}]},listeners:{render:function(e){var t=Ext.String.format("background-color:#{0}",typeof e.color=="object"?e.color.color:e.color);Ext.DomHelper.applyStyles(e.btnEl,t)}},setColor:function(e){var t,n;this.color=e,e=="transparent"||e.color=="transparent"?(t="1px solid #BEBEBE",n=e):(t="none",n=Ext.String.format("#{0}",typeof e=="object"?e.color:e)),this.btnEl!==undefined&&Ext.DomHelper.applyStyles(this.btnEl,{"background-color":n,border:t})}}),this._btnBackColor=Ext.create("Ext.button.Button",{id:"paragraphadv-button-back-color",arrowCls:"",width:50,height:22,color:"transparent",menu:{showSeparator:!1,items:[this.colorsBack=Ext.create("Common.component.ThemeColorPalette",{value:"000000",width:165,height:214,dynamiccolors:!0,dyncolorscount:10,colors:[this.textThemeColors,"-",{color:"3366FF",effectId:1},{color:"0000FF",effectId:2},{color:"000090",effectId:3},{color:"660066",effectId:4},{color:"800000",effectId:5},{color:"FF0000",effectId:1},{color:"FF6600",effectId:1},{color:"FFFF00",effectId:2},{color:"CCFFCC",effectId:3},{color:"008000",effectId:4},"-",{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},{color:"000000",effectId:5},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},"-","--","-",this.textStandartColors,"-","transparent","5301B3","980ABD","B2275F","F83D26","F86A1D","F7AC16","F7CA12","FAFF44","D6EF39","-","--"],listeners:{select:{fn:function(t,n,r,i){Ext.menu.Manager.hideAll();var s,o;e._btnBackColor.color=n,n=="transparent"?(s="transparent",o="1px solid #BEBEBE"):(s=Ext.String.format("#{0}",typeof n=="object"?n.color:n),o="none"),e._btnBackColor.btnEl&&Ext.DomHelper.applyStyles(e._btnBackColor.btnEl,{"background-color":s,border:o}),e.paragraphShade=e._btnBackColor.color,e._changedProps&&((e._changedProps.get_Shade()===undefined||e._changedProps.get_Shade()===null)&&e._changedProps.put_Shade(new CParagraphShd),e._btnBackColor.color=="transparent"?e._changedProps.get_Shade().put_Value(shd_Nil):(e._changedProps.get_Shade().put_Value(shd_Clear),e._changedProps.get_Shade().put_Color(e.getRgbColor(e._btnBackColor.color))))}}}}),{cls:"menu-item-noicon menu-item-color-palette-theme",text:e.textNewColor,listeners:{click:function(t,n){e.colorsBack.addNewColor()}}}]},listeners:{render:function(e){var t,n;e.color=="transparent"?(t="1px solid #BEBEBE",n=e.color):(t="none",n=Ext.String.format("#{0}",typeof e.color=="object"?e.color.color:e.color)),Ext.DomHelper.applyStyles(e.btnEl,{"background-color":n,border:t})}},setColor:function(e){var t,n;this.color=e,e=="transparent"?(t="1px solid #BEBEBE",n=e):(t="none",n=Ext.String.format("#{0}",typeof e=="object"?e.color:e)),this.btnEl!==undefined&&Ext.DomHelper.applyStyles(this.btnEl,{"background-color":n,border:t})}}),this.chStrike=Ext.create("Common.component.IndeterminateCheckBox",{id:"paragraphadv-checkbox-strike",width:140,boxLabel:this.strStrike,listeners:{change:Ext.bind(function(e,t,n,r){this._changedProps&&this.checkGroup!=1&&this._changedProps.put_Strikeout(e.getValue()=="checked"),this.checkGroup=0,e.getValue()=="checked"&&(this.checkGroup=1,this.chDoubleStrike.setValue(0),this._changedProps&&this._changedProps.put_DStrikeout(!1),this.checkGroup=0);if(this.api&&!this._noApply){var i=this._originalProps?this._originalProps:new CParagraphProp;i.put_Strikeout(e.getValue()=="checked"),i.put_DStrikeout(this.chDoubleStrike.getValue()=="checked"),this.api.SetDrawImagePlaceParagraph("paragraphadv-font-img",i)}},this)}}),this.chDoubleStrike=Ext.create("Common.component.IndeterminateCheckBox",{id:"paragraphadv-checkbox-double-strike",width:140,boxLabel:this.strDoubleStrike,listeners:{change:Ext.bind(function(e,t,n,r){this._changedProps&&this.checkGroup!=1&&this._changedProps.put_DStrikeout(e.getValue()=="checked"),this.checkGroup=0,e.getValue()=="checked"&&(this.checkGroup=1,this.chStrike.setValue(0),this._changedProps&&this._changedProps.put_Strikeout(!1),this.checkGroup=0);if(this.api&&!this._noApply){var i=this._originalProps?this._originalProps:new CParagraphProp;i.put_DStrikeout(e.getValue()=="checked"),i.put_Strikeout(this.chStrike.getValue()=="checked"),this.api.SetDrawImagePlaceParagraph("paragraphadv-font-img",i)}},this)}}),this.chSuperscript=Ext.create("Common.component.IndeterminateCheckBox",{id:"paragraphadv-checkbox-superscript",width:140,boxLabel:this.strSuperscript,listeners:{change:Ext.bind(function(e,t,n,r){this._changedProps&&this.checkGroup!=2&&this._changedProps.put_Superscript(e.getValue()=="checked"),this.checkGroup=0,e.getValue()=="checked"&&(this.checkGroup=2,this.chSubscript.setValue(0),this._changedProps&&this._changedProps.put_Subscript(!1),this.checkGroup=0);if(this.api&&!this._noApply){var i=this._originalProps?this._originalProps:new CParagraphProp;i.put_Superscript(e.getValue()=="checked"),i.put_Subscript(this.chSubscript.getValue()=="checked"),this.api.SetDrawImagePlaceParagraph("paragraphadv-font-img",i)}},this)}}),this.chSubscript=Ext.create("Common.component.IndeterminateCheckBox",{id:"paragraphadv-checkbox-subscript",width:140,boxLabel:this.strSubscript,listeners:{change:Ext.bind(function(e,t,n,r){this._changedProps&&this.checkGroup!=2&&this._changedProps.put_Subscript(e.getValue()=="checked"),this.checkGroup=0,e.getValue()=="checked"&&(this.checkGroup=2,this.chSuperscript.setValue(0),this._changedProps&&this._changedProps.put_Superscript(!1),this.checkGroup=0);if(this.api&&!this._noApply){var i=this._originalProps?this._originalProps:new CParagraphProp;i.put_Subscript(e.getValue()=="checked"),i.put_Superscript(this.chSuperscript.getValue()=="checked"),this.api.SetDrawImagePlaceParagraph("paragraphadv-font-img",i)}},this)}}),this.chSmallCaps=Ext.create("Common.component.IndeterminateCheckBox",{id:"paragraphadv-checkbox-small-caps",width:140,boxLabel:this.strSmallCaps,listeners:{change:Ext.bind(function(e,t,n,r){this._changedProps&&this.checkGroup!=3&&this._changedProps.put_SmallCaps(e.getValue()=="checked"),this.checkGroup=0,e.getValue()=="checked"&&(this.checkGroup=3,this.chAllCaps.setValue(0),this._changedProps&&this._changedProps.put_AllCaps(!1),this.checkGroup=0);if(this.api&&!this._noApply){var i=this._originalProps?this._originalProps:new CParagraphProp;i.put_SmallCaps(e.getValue()=="checked"),i.put_AllCaps(this.chAllCaps.getValue()=="checked"),this.api.SetDrawImagePlaceParagraph("paragraphadv-font-img",i)}},this)}}),this.chAllCaps=Ext.create("Common.component.IndeterminateCheckBox",{id:"paragraphadv-checkbox-all-caps",width:140,boxLabel:this.strAllCaps,listeners:{change:Ext.bind(function(e,t,n,r){this._changedProps&&this.checkGroup!=3&&this._changedProps.put_AllCaps(e.getValue()=="checked"),this.checkGroup=0,e.getValue()=="checked"&&(this.checkGroup=3,this.chSmallCaps.setValue(0),this._changedProps&&this._changedProps.put_SmallCaps(!1),this.checkGroup=0);if(this.api&&!this._noApply){var i=this._originalProps?this._originalProps:new CParagraphProp;i.put_AllCaps(e.getValue()=="checked"),i.put_SmallCaps(this.chSmallCaps.getValue()=="checked"),this.api.SetDrawImagePlaceParagraph("paragraphadv-font-img",i)}},this)}}),this.numSpacing=Ext.create("Common.component.MetricSpinner",{id:"paragraphadv-spin-spacing",readOnly:!1,step:.01,width:100,defaultUnit:"cm",value:"0 cm",maxValue:55.87,minValue:-55.87,listeners:{change:Ext.bind(function(e,t,n,r){this._changedProps&&this._changedProps.put_TextSpacing(Common.MetricSettings.fnRecalcToMM(e.getNumberValue()));if(this.api&&!this._noApply){var i=this._originalProps?this._originalProps:new CParagraphProp;i.put_TextSpacing(Common.MetricSettings.fnRecalcToMM(e.getNumberValue())),this.api.SetDrawImagePlaceParagraph("paragraphadv-font-img",i)}},this)}}),this.numPosition=Ext.widget("commonmetricspinner",{id:"paragraphadv-spin-position",readOnly:!1,step:.01,width:100,defaultUnit:"cm",value:"0 cm",maxValue:55.87,minValue:-55.87,listeners:{change:Ext.bind(function(e,t,n,r){this._changedProps&&this._changedProps.put_Position(Common.MetricSettings.fnRecalcToMM(e.getNumberValue()));if(this.api&&!this._noApply){var i=this._originalProps?this._originalProps:new CParagraphProp;i.put_Position(Common.MetricSettings.fnRecalcToMM(e.getNumberValue())),this.api.SetDrawImagePlaceParagraph("paragraphadv-font-img",i)}},this)}}),this.fontImage=Ext.create("Ext.container.Container",{id:"paragraphadv-font-img",width:"100%",height:80,style:"background-color:#ffffff; border:1px solid #CDCDCD;"}),this.numTab=Ext.widget("commonmetricspinner",{id:"paragraphadv-spin-tab",readOnly:!1,step:.1,width:180,defaultUnit:"cm",value:"1.25 cm",maxValue:55.87,minValue:0}),this.numDefaultTab=Ext.widget("commonmetricspinner",{id:"paragraphadv-spin-default-tab",readOnly:!1,step:.1,width:107,defaultUnit:"cm",value:"1.25 cm",maxValue:55.87,minValue:0,listeners:{change:Ext.bind(function(e,t,n,r){this._changedProps&&this._changedProps.put_DefaultTab(parseFloat(Common.MetricSettings.fnRecalcToMM(e.getNumberValue()).toFixed(1)))},this)}}),this.btnAddTab=Ext.create("Ext.Button",{width:90,text:this.textSet,enableToggle:!1,listeners:{click:Ext.bind(function(e,t){var n=this.numTab.getNumberValue(),r=this.radioLeft.getValue()?1:this.radioCenter.getValue()?3:2,s=i.findBy(function(e,t){return Math.abs(e.data.tabPos-n)<.001},this);if(s<0){var o=i.add({tabPos:n,tabStr:n+" "+Common.MetricSettings.metricName[Common.MetricSettings.getCurrentMetric()],tabAlign:r});i.sort(),this.tabList.getSelectionModel().select(o)}else{var o=i.getAt(s);o.set("tabAlign",r)}},this)}}),this.btnRemoveTab=Ext.create("Ext.Button",{width:90,text:this.textRemove,enableToggle:!1,listeners:{click:Ext.bind(function(e,t){var n=this.tabList.getSelectionModel().getSelection();if(n.length>0){var r=n[0].index;i.remove(n),r>i.count()-1&&(r=i.count()-1),r>-1&&this.tabList.getSelectionModel().select(r)}},this)}}),this.btnRemoveAll=Ext.create("Ext.Button",{width:90,text:this.textRemoveAll,enableToggle:!1,listeners:{click:Ext.bind(function(e,t){i.removeAll()},this)}}),this.radioLeft=Ext.create("Ext.form.field.Radio",{boxLabel:this.textTabLeft,name:"asc-radio-tab",checked:!0}),this.radioCenter=Ext.create("Ext.form.field.Radio",{boxLabel:this.textTabCenter,name:"asc-radio-tab",checked:!1}),this.radioRight=Ext.create("Ext.form.field.Radio",{boxLabel:this.textTabRight,name:"asc-radio-tab",checked:!1}),Ext.define("DE.model.TabDataModel",{extend:"Ext.data.Model",fields:[{name:"tabPos",name:"tabStr",name:"tabAlign"}]});var i=Ext.create("Ext.data.Store",{model:"DE.model.TabDataModel",data:[],sorters:["tabPos"],listeners:{datachanged:Ext.bind(function(e,t){this._noApply||(this._tabListChanged=!0)},this),update:Ext.bind(function(e,t){this._noApply||(this._tabListChanged=!0)},this),clear:Ext.bind(function(e,t){this._noApply||(this._tabListChanged=!0)},this)}});this.tabList=Ext.create("Ext.grid.Panel",{activeItem:0,id:"paragraphadv-tab-list",store:i,mode:"local",scroll:!1,columns:[{flex:1,dataIndex:"tabStr"}],height:80,width:180,hideHeaders:!0,viewConfig:{stripeRows:!1},plugins:[{pluginId:"scrollpane",ptype:"gridscrollpane"}],listeners:{select:function(e,t,n,r){this.numTab.setValue(t.data.tabPos),t.data.tabAlign==1?this.radioLeft.setValue(!0):t.data.tabAlign==3?this.radioCenter.setValue(!0):this.radioRight.setValue(!0)},scope:this}}),this._spnMarginTop=Ext.create("Common.component.MetricSpinner",{id:"paraadv-number-margin-top",readOnly:!1,maxValue:55.87,minValue:0,step:.1,defaultUnit:"cm",value:"0 cm",width:100,listeners:{change:Ext.bind(function(e,t,n,r){this._noApply||(this.Margins===undefined&&(this.Margins={}),this.Margins.Top=Common.MetricSettings.fnRecalcToMM(e.getNumberValue()))},this)}}),this._spnMarginBottom=Ext.create("Common.component.MetricSpinner",{id:"paraadv-number-margin-bottom",readOnly:!1,maxValue:55.87,minValue:0,step:.1,defaultUnit:"cm",value:"0 cm",width:100,listeners:{change:Ext.bind(function(e,t,n,r){this._noApply||(this.Margins===undefined&&(this.Margins={}),this.Margins.Bottom=Common.MetricSettings.fnRecalcToMM(e.getNumberValue()))},this)}}),this._spnMarginLeft=Ext.create("Common.component.MetricSpinner",{id:"paraadv-number-margin-left",readOnly:!1,maxValue:9.34,minValue:0,step:.1,defaultUnit:"cm",value:"0.19 cm",width:100,listeners:{change:Ext.bind(function(e,t,n,r){this._noApply||(this.Margins===undefined&&(this.Margins={}),this.Margins.Left=Common.MetricSettings.fnRecalcToMM(e.getNumberValue()))},this)}}),this._spnMarginRight=Ext.create("Common.component.MetricSpinner",{id:"paraadv-number-margin-right",readOnly:!1,maxValue:9.34,minValue:0,step:.1,defaultUnit:"cm",value:"0.19 cm",width:100,listeners:{change:Ext.bind(function(e,t,n,r){this._noApply||(this.Margins===undefined&&(this.Margins={}),this.Margins.Right=Common.MetricSettings.fnRecalcToMM(e.getNumberValue()))},this)}}),this.btnIndents=Ext.widget("button",{width:160,height:27,cls:"asc-dialogmenu-btn",text:this.strParagraphIndents,textAlign:"right",enableToggle:!0,allowDepress:!1,toggleGroup:"advtablecardGroup",pressed:!0,listeners:{click:function(e){e.pressed&&this.mainCard.getLayout().setActiveItem("card-indents")},scope:this}}),this.btnFont=Ext.widget("button",{width:160,height:27,cls:"asc-dialogmenu-btn",text:this.strParagraphFont,textAlign:"right",enableToggle:!0,allowDepress:!1,toggleGroup:"advtablecardGroup",listeners:{click:function(e){e.pressed&&this.mainCard.getLayout().setActiveItem("card-font")},scope:this}}),this.btnBorders=Ext.widget("button",{width:160,height:27,cls:"asc-dialogmenu-btn",textAlign:"right",text:this.strBorders,enableToggle:!0,allowDepress:!1,toggleGroup:"advtablecardGroup",listeners:{click:function(e){e.pressed&&this.mainCard.getLayout().setActiveItem("card-borders")},scope:this}}),this.btnTabs=Ext.widget("button",{width:160,height:27,cls:"asc-dialogmenu-btn",textAlign:"right",text:this.strTabs,enableToggle:!0,allowDepress:!1,toggleGroup:"advtablecardGroup",listeners:{click:function(e){e.pressed&&(this.mainCard.getLayout().setActiveItem("card-tabs"),this.tabList.getPlugin("scrollpane").updateScrollPane())},scope:this}}),this.btnMargins=Ext.widget("button",{width:160,height:27,cls:"asc-dialogmenu-btn",textAlign:"right",text:this.strMargins,enableToggle:!0,allowDepress:!1,toggleGroup:"advtablecardGroup",listeners:{click:function(e){e.pressed&&this.mainCard.getLayout().setActiveItem("card-margins")},scope:this}}),this._BordersContainer={xtype:"container",itemId:"card-borders",layout:{type:"vbox",align:"stretch"},height:285,items:[{xtype:"container",layout:{type:"hbox",align:"middle"},height:28,padding:"2px 10px 0 10px",style:"vertical-align: middle;",items:[{xtype:"label",text:this.textBorderWidth},{xtype:"tbspacer",width:4},this.cmbBorderSize,{xtype:"tbspacer",flex:1},{xtype:"label",text:this.textBorderColor},{xtype:"tbspacer",width:4},this._btnBorderColor]},{xtype:"tbspacer",height:10},{xtype:"label",text:this.textBorderDesc,style:"padding-left:10px;height:13px;"},{xtype:"tbspacer",height:20},{xtype:"container",layout:{type:"hbox",align:"top"},height:180,width:200,padding:"0 10",style:"vertical-align: top;",items:[this.bordersImagePanel=Ext.create("Ext.container.Container",{layout:"card",activeItem:0,width:200,height:180,style:"padding-bottom:10px;",items:[this._BordersImage]}),{xtype:"tbspacer",width:25},{xtype:"container",layout:"hbox",height:180,width:100,items:[this._PresetsContainer=Ext.create("Ext.container.Container",{height:180,width:100,layout:{type:"table",columns:2,tdAttrs:{style:"padding-right: 10px; padding-bottom: 4px; vertical-align: middle;"}},items:[{xtype:"tbspacer",height:5},{xtype:"tbspacer",height:5},this._btnsBorderPosition[5],this._btnsBorderPosition[6],this._btnsBorderPosition[7],this._btnsBorderPosition[0],this._btnsBorderPosition[3],this._btnsBorderPosition[1],this._btnsBorderPosition[4],this._btnsBorderPosition[2]]})]}]},{xtype:"tbspacer",height:5},{xtype:"container",height:23,padding:"0 10",layout:"hbox",items:[this._BackContainer=Ext.create("Ext.container.Container",{height:23,width:150,layout:"hbox",margin:"0 4px 0 0",items:[{xtype:"label",text:this.textBackColor,margin:"2px 4px 0 0"},this._btnBackColor]})]}]},this._IndentsContainer={xtype:"container",itemId:"card-indents",width:340,layout:{type:"vbox",align:"stretch"},items:[{xtype:"container",padding:"0 10",layout:{type:"table",columns:5},defaults:{xtype:"container",layout:"vbox",layoutConfig:{align:"stretch"},height:40,style:"float:left;"},items:[{items:[{xtype:"label",text:this.strIndentsFirstLine,width:85},{xtype:"tbspacer",height:3},this.numFirstLine]},{xtype:"tbspacer",width:23,height:3},{items:[{xtype:"label",text:this.strIndentsLeftText,width:85},{xtype:"tbspacer",height:3},this.numIndentsLeft]},{xtype:"tbspacer",width:23,height:3},{items:[{xtype:"label",text:this.strIndentsRightText,width:85},{xtype:"tbspacer",height:3},this.numIndentsRight]}]},this._spacer.cloneConfig({style:"margin: 16px 0 11px 0;",height:6}),{xtype:"container",height:25,padding:"0 10",layout:{type:"table",columns:3,tdAttrs:{style:"vertical-align: middle;"}},items:[this.chBreakBefore,{xtype:"tbspacer",width:10,height:3},this.chKeepLines,this.chOrphan,{xtype:"tbspacer",width:10,height:3},this.chKeepNext]}]},this._FontContainer={xtype:"container",itemId:"card-font",width:340,layout:{type:"vbox",align:"stretch"},items:[{xtype:"label",style:"font-weight: bold;margin-top: 1px; padding-left:10px;height:13px;",text:this.textEffects},{xtype:"tbspacer",height:8},{xtype:"container",height:85,width:"100%",padding:"0 10",layout:{type:"table",columns:3,tdAttrs:{style:"vertical-align: middle;"}},items:[this.chStrike,{xtype:"tbspacer",width:20,height:2},this.chSubscript,this.chDoubleStrike,{xtype:"tbspacer",width:20,height:2},this.chSmallCaps,this.chSuperscript,{xtype:"tbspacer",width:20,height:2},this.chAllCaps]},{xtype:"label",style:"font-weight: bold;margin-top: 1px; padding-left:10px;height:13px;",text:this.textCharacterSpacing},{xtype:"tbspacer",height:8},{xtype:"container",height:46,padding:"0 10",layout:{type:"table",columns:3,tdAttrs:{style:"vertical-align: middle;"}},items:[{xtype:"label",text:this.textSpacing,width:85},{xtype:"tbspacer",width:60,height:2},{xtype:"label",text:this.textPosition,width:85},{xtype:"tbspacer",height:2},{xtype:"tbspacer",height:2},{xtype:"tbspacer",height:2},this.numSpacing,{xtype:"tbspacer",width:60,height:2},this.numPosition]},{xtype:"tbspacer",height:10},{xtype:"container",height:85,padding:"0 10",items:[this.fontImage]}]},this._TabsContainer={xtype:"container",itemId:"card-tabs",width:340,layout:{type:"vbox",align:"stretch"},items:[{xtype:"container",padding:"0 0 0 10",layout:{type:"table",columns:3,tdAttrs:{style:"padding-right: 7px;"}},defaults:{xtype:"container",layout:"vbox",layoutConfig:{align:"stretch"},style:"float:left;"},items:[{height:50,colspan:2,items:[{xtype:"label",text:this.textTabPosition,width:85},{xtype:"tbspacer",height:3},this.numTab]},{height:50,items:[{xtype:"label",text:this.textDefault,width:107},{xtype:"tbspacer",height:3},this.numDefaultTab]},{height:95,colspan:3,items:[this.tabList]},{height:100,colspan:3,items:[{xtype:"label",text:this.textAlign,width:85},{xtype:"tbspacer",height:3},this.radioLeft,this.radioCenter,this.radioRight]},this.btnAddTab,this.btnRemoveTab,this.btnRemoveAll]}]},this._MarginsContainer={xtype:"container",itemId:"card-margins",width:340,layout:{type:"vbox",align:"stretch"},items:[{xtype:"container",padding:"0 10",layout:{type:"table",columns:2,tdAttrs:{style:"padding-right: 40px;vertical-align: middle;"}},items:[{xtype:"label",text:this.textTop,width:85},{xtype:"label",text:this.textLeft,width:85},{xtype:"tbspacer",height:2},{xtype:"tbspacer",height:2},this._spnMarginTop,this._spnMarginLeft,{xtype:"tbspacer",height:5},{xtype:"tbspacer",height:5},{xtype:"label",text:this.textBottom,width:85},{xtype:"label",text:this.textRight,width:85},{xtype:"tbspacer",height:2},{xtype:"tbspacer",height:2},this._spnMarginBottom,this._spnMarginRight]}]},this.items=[{xtype:"container",height:300,layout:{type:"hbox",align:"stretch"},items:[{xtype:"container",width:160,padding:"5px 0 0 0",layout:{type:"vbox",align:"stretch"},defaults:{xtype:"container",layout:{type:"hbox",align:"middle",pack:"end"}},items:[{height:30,items:[this.btnIndents]},{height:30,items:[this.btnBorders]},{height:30,items:[this.btnFont]},{height:30,items:[this.btnTabs]},{height:30,items:[this.btnMargins]}]},{xtype:"box",cls:"advanced-settings-separator",height:"100%",width:8},this.mainCard=Ext.create("Ext.container.Container",{height:300,flex:1,padding:"12px 18px 0 10px",layout:"card",items:[this._IndentsContainer,this._BordersContainer,this._FontContainer,this._TabsContainer,this._MarginsContainer]})]},this._spacer.cloneConfig({style:"margin: 0 18px"}),{xtype:"container",height:40,layout:{type:"vbox",align:"center",pack:"center"},items:[{xtype:"container",width:182,height:24,layout:{type:"hbox",align:"middle"},items:[this.btnOk=Ext.widget("button",{cls:"asc-blue-button",width:86,height:22,margin:"0 5px 0 0",text:this.okButtonText,listeners:{click:function(e){this.fireEvent("onmodalresult",this,1,this.getSettings()),this.close()},scope:this}}),this.btnCancel=Ext.widget("button",{cls:"asc-darkgray-button",width:86,height:22,text:this.cancelButtonText,listeners:{click:function(e){this.fireEvent("onmodalresult",this,0),this.close()},scope:this}})]}]}],this.callParent(arguments)},afterRender:function(){this.callParent(arguments),this._setDefaults(this._originalProps);if(this.borderProps!==undefined){this._btnBorderColor.setColor(this.borderProps.borderColor);var e=Ext.String.format("#{0}",typeof this.borderProps.borderColor=="object"?this.borderProps.borderColor.color:this.borderProps.borderColor);this._BordersImage.setVirtualBorderColor(e);var t=this.cmbBorderSize.getStore().findRecord("value",this.borderProps.borderSize.ptValue);t&&(this.cmbBorderSize.select(t),this.cmbBorderSize.fireEvent("select",this.cmbBorderSize,[t])),this.colorsBorder.select(this.borderProps.borderColor)}this.setTitle(this.textTitle),this.colorProps!==undefined&&this.sendThemeColors(this.colorProps[0],this.colorProps[1]);for(var n=0;n<this._BordersImage.rows;n++)for(var r=0;r<this._BordersImage.columns;r++)this._BordersImage.getCell(r,n).addListener("borderclick",function(e,t,n,r){this.ChangedBorders===undefined&&(this.ChangedBorders=new CParagraphBorders),this._UpdateCellBordersStyle(e,t,n,r,this.Borders)},this);this._BordersImage.addListener("borderclick",function(e,t,n,r){this.ChangedBorders===undefined&&(this.ChangedBorders=new CParagraphBorders),this._UpdateTableBordersStyle(e,t,n,r,this.Borders)},this)},setSettings:function(e){this._originalProps=new CParagraphProp(e.paragraphProps),this.borderProps=e.borderProps,this.colorProps=e.colorProps,this._changedProps=null,this.api=e.api},_setDefaults:function(e){if(e){this._originalProps=new CParagraphProp(e),this.numFirstLine.setValue(e.get_Ind()!==null&&e.get_Ind().get_FirstLine()!==null?Common.MetricSettings.fnRecalcFromMM(e.get_Ind().get_FirstLine()):""),this.numIndentsLeft.setValue(e.get_Ind()!==null&&e.get_Ind().get_Left()!==null?Common.MetricSettings.fnRecalcFromMM(e.get_Ind().get_Left()):""),this.numIndentsRight.setValue(e.get_Ind()!==null&&e.get_Ind().get_Right()!==null?Common.MetricSettings.fnRecalcFromMM(e.get_Ind().get_Right()):""),this.chKeepLines.setValue(e.get_KeepLines()!==null&&e.get_KeepLines()!==undefined?e.get_KeepLines():"indeterminate"),this.chBreakBefore.setValue(e.get_PageBreakBefore()!==null&&e.get_PageBreakBefore()!==undefined?e.get_PageBreakBefore():"indeterminate"),this.chKeepNext.setValue(e.get_KeepNext()!==null&&e.get_KeepNext()!==undefined?e.get_KeepNext():"indeterminate"),this.chOrphan.setValue(e.get_WidowControl()!==null&&e.get_WidowControl()!==undefined?e.get_WidowControl():"indeterminate"),this.Borders=new CParagraphBorders(e.get_Borders());if(this.Borders){var t=this.Borders.get_Left(),n=null!==t&&undefined!==t&&null!==t.get_Space()&&undefined!==t.get_Space()?Common.MetricSettings.fnRecalcFromMM(t.get_Space()):"";this._spnMarginLeft.setValue(n),t=this.Borders.get_Top(),n=null!==t&&undefined!==t&&null!==t.get_Space()&&undefined!==t.get_Space()?Common.MetricSettings.fnRecalcFromMM(t.get_Space()):"",this._spnMarginTop.setValue(n),t=this.Borders.get_Right(),n=null!==t&&undefined!==t&&null!==t.get_Space()&&undefined!==t.get_Space()?Common.MetricSettings.fnRecalcFromMM(t.get_Space()):"",this._spnMarginRight.setValue(n),t=this.Borders.get_Bottom(),n=null!==t&&undefined!==t&&null!==t.get_Space()&&undefined!==t.get_Space()?Common.MetricSettings.fnRecalcFromMM(t.get_Space()):"",this._spnMarginBottom.setValue(n)}var r=e.get_Shade();if(r!==null&&r!==undefined&&r.get_Value()===shd_Clear){var i=r.get_Color();i?i.get_type()==c_oAscColor.COLOR_TYPE_SCHEME?this.paragraphShade={color:this.getHexColor(i.get_r(),i.get_g(),i.get_b()),effectValue:i.get_value()}:this.paragraphShade=this.getHexColor(i.get_r(),i.get_g(),i.get_b()):this.paragraphShade="transparent"}else this.paragraphShade="transparent";this._btnBackColor.setColor(this.paragraphShade);if(typeof this.paragraphShade=="object"){for(var s=0;s<10;s++)if(this.ThemeValues[s]==this.paragraphShade.effectValue){this.colorsBack.select(this.paragraphShade,!0);break}}else this.colorsBack.select(this.paragraphShade,!0);this._UpdateBorders(),this._noApply=!0,this.chStrike.setValue(e.get_Strikeout()!==null&&e.get_Strikeout()!==undefined?e.get_Strikeout():"indeterminate"),this.chDoubleStrike.setValue(e.get_DStrikeout()!==null&&e.get_DStrikeout()!==undefined?e.get_DStrikeout():"indeterminate"),this.chSubscript.setValue(e.get_Subscript()!==null&&e.get_Subscript()!==undefined?e.get_Subscript():"indeterminate"),this.chSuperscript.setValue(e.get_Superscript()!==null&&e.get_Superscript()!==undefined?e.get_Superscript():"indeterminate"),this.chSmallCaps.setValue(e.get_SmallCaps()!==null&&e.get_SmallCaps()!==undefined?e.get_SmallCaps():"indeterminate"),this.chAllCaps.setValue(e.get_AllCaps()!==null&&e.get_AllCaps()!==undefined?e.get_AllCaps():"indeterminate"),this.numSpacing.setValue(e.get_TextSpacing()!==null&&e.get_TextSpacing()!==undefined?Common.MetricSettings.fnRecalcFromMM(e.get_TextSpacing()):""),this.numPosition.setValue(e.get_Position()!==null&&e.get_Position()!==undefined?Common.MetricSettings.fnRecalcFromMM(e.get_Position()):""),this.api.SetDrawImagePlaceParagraph("paragraphadv-font-img",this._originalProps),this.numDefaultTab.setValue(e.get_DefaultTab()!==null&&e.get_DefaultTab()!==undefined?Common.MetricSettings.fnRecalcFromMM(parseFloat(e.get_DefaultTab().toFixed(1))):"");var o=e.get_Tabs();if(o){var u=[],a=o.get_Count();for(var s=0;s<a;s++){var f=o.get_Tab(s),l={tabPos:Common.MetricSettings.fnRecalcFromMM(parseFloat(f.get_Pos().toFixed(1))),tabAlign:f.get_Value()};l.tabStr=parseFloat(Ext.Number.toFixed(l.tabPos,3))+" "+Common.MetricSettings.metricName[Common.MetricSettings.getCurrentMetric()],u.push(l)}this.tabList.getStore().loadData(u),this.tabList.getStore().sort(),this.tabList.getStore().count()>0&&this.tabList.getSelectionModel().select(0)}this._noApply=!1,this._changedProps=new CParagraphProp,this.ChangedBorders=undefined}},getSettings:function(){this.ChangedBorders===null?this._changedProps.put_Borders(this.Borders):this.ChangedBorders!==undefined&&this._changedProps.put_Borders(this.ChangedBorders);if(this.Margins){var e=this._changedProps.get_Borders();if(e===undefined||e===null)this._changedProps.put_Borders(new CParagraphBorders),e=this._changedProps.get_Borders();this.Margins.Left!==undefined&&((e.get_Left()===undefined||e.get_Left()===null)&&e.put_Left(new CBorder(this.Borders.get_Left())),e.get_Left().put_Space(this.Margins.Left)),this.Margins.Top!==undefined&&((e.get_Top()===undefined||e.get_Top()===null)&&e.put_Top(new CBorder(this.Borders.get_Top())),e.get_Top().put_Space(this.Margins.Top)),this.Margins.Right!==undefined&&((e.get_Right()===undefined||e.get_Right()===null)&&e.put_Right(new CBorder(this.Borders.get_Right())),e.get_Right().put_Space(this.Margins.Right)),this.Margins.Bottom!==undefined&&((e.get_Bottom()===undefined||e.get_Bottom()===null)&&e.put_Bottom(new CBorder(this.Borders.get_Bottom())),e.get_Bottom().put_Space(this.Margins.Bottom),(e.get_Between()===undefined||e.get_Between()===null)&&e.put_Between(new CBorder(this.Borders.get_Between())),e.get_Between().put_Space(this.Margins.Bottom))}return this._tabListChanged&&((this._changedProps.get_Tabs()===null||this._changedProps.get_Tabs()===undefined)&&this._changedProps.put_Tabs(new CParagraphTabs),this.tabList.getStore().each(function(e,t){var n=new CParagraphTab(Common.MetricSettings.fnRecalcToMM(e.data.tabPos),e.data.tabAlign);this._changedProps.get_Tabs().add_Tab(n)},this)),{paragraphProps:this._changedProps,borderProps:{borderSize:this.BorderSize,borderColor:this._btnBorderColor.color}}},_UpdateBorders:function(){var e=this.BorderSize,t=this._btnBorderColor.color;this._UpdateBorder(this.Borders.get_Left(),"l"),this._UpdateBorder(this.Borders.get_Top(),"t"),this._UpdateBorder(this.Borders.get_Right(),"r"),this._UpdateBorder(this.Borders.get_Bottom(),"b");if(this.Borders.get_Between()!==null)for(var n=0;n<this._BordersImage.columns;n++)this._UpdateCellBorder(this.Borders.get_Between(),"b",this._BordersImage.getCell(n,0)),this._UpdateCellBorder(this.Borders.get_Between(),"t",this._BordersImage.getCell(n,1));this._BordersImage.setVirtualBorderSize(e.pxValue);var r=Ext.String.format("#{0}",typeof t=="object"?t.color:t);this._BordersImage.setVirtualBorderColor(r)},_UpdateCellBorder:function(e,t,n){null!==e&&undefined!==e?null!==e.get_Value()&&null!==e.get_Size()&&null!==e.get_Color()&&1==e.get_Value()?(n.setBordersSize(t,this._BorderPt2Px(e.get_Size()*72/25.4)),n.setBordersColor(t,"rgb("+e.get_Color().get_r()+","+e.get_Color().get_g()+","+e.get_Color().get_b()+")")):n.setBordersSize(t,0):n.setBordersSize(t,0)},_UpdateBorder:function(e,t){null!==e&&undefined!==e?null!==e.get_Value()&&null!==e.get_Size()&&null!==e.get_Color()&&1==e.get_Value()?(this._BordersImage.setBordersSize(t,this._BorderPt2Px(e.get_Size()*72/25.4)),this._BordersImage.setBordersColor(t,"rgb("+e.get_Color().get_r()+","+e.get_Color().get_g()+","+e.get_Color().get_b()+")")):this._BordersImage.setBordersSize(t,0):this._BordersImage.setBordersSize(t,0)},_BorderPt2Px:function(e){return e==0?0:e<.6?.5:e<=1?1:e<=1.5?2:e<=2.25?3:e<=3?4:e<=4.5?5:6},_ApplyBorderPreset:function(e){this.ChangedBorders=null,this.Borders.put_Left(this._UpdateBorderStyle(this.Borders.get_Left(),e.indexOf("l")>-1)),this.Borders.put_Top(this._UpdateBorderStyle(this.Borders.get_Top(),e.indexOf("t")>-1)),this.Borders.put_Right(this._UpdateBorderStyle(this.Borders.get_Right(),e.indexOf("r")>-1)),this.Borders.put_Bottom(this._UpdateBorderStyle(this.Borders.get_Bottom(),e.indexOf("b")>-1)),this.Borders.put_Between(this._UpdateBorderStyle(this.Borders.get_Between(),e.indexOf("m")>-1)),this._UpdateBorders()},_UpdateBorderStyle:function(e,t){null==e&&(e=new CBorder);if(t&&this.BorderSize.ptValue>0){var n=parseFloat(this.BorderSize.ptValue);e.put_Value(1),e.put_Size(n*25.4/72);var r=this.getRgbColor(this._btnBorderColor.color);e.put_Color(r)}else e.put_Color(new CColor),e.put_Value(0);return e},_UpdateCellBordersStyle:function(e,t,n,r,i){var s=i;e.col==0&&t.indexOf("l")>-1&&(s.put_Left(this._UpdateBorderStyle(s.get_Left(),n>0)),this.ChangedBorders&&this.ChangedBorders.put_Left(new CBorder(s.get_Left()))),e.col==this.tableStylerColumns-1&&t.indexOf("r")>-1&&(s.put_Right(this._UpdateBorderStyle(s.get_Right(),n>0)),this.ChangedBorders&&this.ChangedBorders.put_Right(new CBorder(s.get_Right()))),e.row==0&&t.indexOf("t")>-1&&(s.put_Top(this._UpdateBorderStyle(s.get_Top(),n>0)),this.ChangedBorders&&this.ChangedBorders.put_Top(new CBorder(s.get_Top()))),e.row==this.tableStylerRows-1&&t.indexOf("b")>-1&&(s.put_Bottom(this._UpdateBorderStyle(s.get_Bottom(),n>0)),this.ChangedBorders&&this.ChangedBorders.put_Bottom(new CBorder(s.get_Bottom())));if(e.row==0&&t.indexOf("b")>-1||e.row==this.tableStylerRows-1&&t.indexOf("t")>-1)s.put_Between(this._UpdateBorderStyle(s.get_Between(),n>0)),this.ChangedBorders&&this.ChangedBorders.put_Between(new CBorder(s.get_Between()))},_UpdateTableBordersStyle:function(e,t,n,r,i){var s=i;t.indexOf("l")>-1&&(s.put_Left(this._UpdateBorderStyle(s.get_Left(),n>0)),this.ChangedBorders&&this.ChangedBorders.put_Left(new CBorder(s.get_Left()))),t.indexOf("t")>-1&&(s.put_Top(this._UpdateBorderStyle(s.get_Top(),n>0)),this.ChangedBorders&&this.ChangedBorders.put_Top(new CBorder(s.get_Top()))),t.indexOf("r")>-1&&(s.put_Right(this._UpdateBorderStyle(s.get_Right(),n>0)),this.ChangedBorders&&this.ChangedBorders.put_Right(new CBorder(s.get_Right()))),t.indexOf("b")>-1&&(s.put_Bottom(this._UpdateBorderStyle(s.get_Bottom(),n>0)),this.ChangedBorders&&this.ChangedBorders.put_Bottom(new CBorder(s.get_Bottom())))},getRgbColor:function(e){var t=typeof e=="object"?e.color:e;t=t.replace(/#/,""),t.length==3&&(t=t.replace(/(.)/g,"$1$1")),t=parseInt(t,16);var n=new CAscColor;return n.put_type(typeof e=="object"?c_oAscColor.COLOR_TYPE_SCHEME:c_oAscColor.COLOR_TYPE_SRGB),n.put_r(t>>16),n.put_g((t&65280)>>8),n.put_b(t&255),n.put_a(255),e.effectId!==undefined&&n.put_value(e.effectId),n},getHexColor:function(e,t,n){return e=e.toString(16),t=t.toString(16),n=n.toString(16),e.length==1&&(e="0"+e),t.length==1&&(t="0"+t),n.length==1&&(n="0"+n),e+t+n},sendThemeColors:function(e,t){t&&e&&(this.colorsBorder.updateColors(e,t),this.colorsBack.updateColors(e,t))},updateMetricUnit:function(){var e=this.query("commonmetricspinner");if(e)for(var t=0;t<e.length;t++){var n=e[t];n.setDefaultUnit(Common.MetricSettings.metricName[Common.MetricSettings.getCurrentMetric()]),n.id=="paragraphadv-spin-spacing"||n.id=="paragraphadv-spin-position"?n.setStep(Common.MetricSettings.getCurrentMetric()==Common.MetricSettings.c_MetricUnits.cm?.01:1):n.setStep(Common.MetricSettings.getCurrentMetric()==Common.MetricSettings.c_MetricUnits.cm?.1:1)}},textTitle:"Paragraph - Advanced Settings",strIndentsFirstLine:"First line",strIndentsLeftText:"Left",strIndentsRightText:"Right",strParagraphIndents:"Indents & Placement",strParagraphPosition:"Placement",strParagraphFont:"Font",strBreakBefore:"Page break before",strKeepLines:"Keep lines together",strBorders:"Borders & Fill",textBorderWidth:"Border Size",textBorderColor:"Border Color",textBackColor:"Background Color",textBorderDesc:"Click on diagramm or use buttons to select borders",cancelButtonText:"Cancel",okButtonText:"Ok",txtNoBorders:"No borders",textNewColor:"Add New Custom Color",textEffects:"Effects",textCharacterSpacing:"Character Spacing",textSpacing:"Spacing",textPosition:"Position",strDoubleStrike:"Double strikethrough",strStrike:"Strikethrough",strSuperscript:"Superscript",strSubscript:"Subscript",strSmallCaps:"Small caps",strAllCaps:"All caps",textThemeColors:"Theme Colors",textStandartColors:"Standart Colors",strOrphan:"Orphan control",strKeepNext:"Keep with next",strTabs:"Tab",textSet:"Specify",textRemove:"Remove",textRemoveAll:"Remove All",textTabLeft:"Left",textTabRight:"Right",textTabCenter:"Center",textAlign:"Alignment",textTabPosition:"Tab Position",textDefault:"Default Tab",textTop:"Top",textLeft:"Left",textBottom:"Bottom",textRight:"Right",strMargins:"Margins",tipTop:"Set Top Border Only",tipLeft:"Set Left Border Only",tipBottom:"Set Bottom Border Only",tipRight:"Set Right Border Only",tipAll:"Set Outer Border and All Inner Lines",tipNone:"Set No Borders",tipInner:"Set Horizontal Inner Lines Only",tipOuter:"Set Outer Border Only"});var c_oAscFrameWrap={None:-1,Inline:!1,Flow:!0};Ext.define("DE.view.DropcapSettingsAdvanced",{extend:"Ext.window.Window",alias:"widget.dedropcapsettingsadvanced",requires:["Ext.Array","Ext.form.field.ComboBox","Ext.window.Window","Common.component.ThemeColorPalette","Common.component.MetricSpinner","DE.component.TableStyler","Common.component.IndeterminateCheckBox","DE.component.ComboDropFonts","Common.plugin.ComboBoxScrollPane"],cls:"asc-advanced-settings-window",modal:!0,resizable:!1,plain:!0,constrain:!0,height:490,width:516,layout:{type:"vbox",align:"stretch"},listeners:{show:function(){!this.isFrame&&this.btnNone.pressed?this._DisableElem(c_oAscDropCap.None):this.isFrame&&this.btnFrameNone.pressed&&this._DisableElem(c_oAscFrameWrap.None)}},initComponent:function(){var e=this;this.addEvents("onmodalresult"),this.Borders={},this.BorderSize={ptValue:0,pxValue:0},this.paragraphShade="transparent",this._changedProps=null,this.ChangedBorders=undefined,this._noApply=!0,this.Margins=undefined,this.ThemeValues=[6,15,7,16,0,1,2,3,4,5],this._spacer=Ext.create("Ext.toolbar.Spacer",{width:"100%",height:10,html:'<div style="width: 100%; height: 40%; border-bottom: 1px solid #C7C7C7"></div>'});var t=[[c_tableBorder.BORDER_OUTER,"lrtb","asc-advanced-settings-position-btn btn-adv-paragraph-outer","paragraphadv-button-border-outer"],[c_tableBorder.BORDER_ALL,"lrtbm","asc-advanced-settings-position-btn btn-adv-paragraph-all","paragraphadv-button-border-all"],[c_tableBorder.BORDER_NONE,"","asc-advanced-settings-position-btn btn-adv-paragraph-none","paragraphadv-button-border-none"],[c_tableBorder.BORDER_VERTICAL_LEFT,"l","asc-advanced-settings-position-btn btn-adv-paragraph-left","paragraphadv-button-border-left"],[c_tableBorder.BORDER_VERTICAL_RIGHT,"r","asc-advanced-settings-position-btn btn-adv-paragraph-right","paragraphadv-button-border-right"],[c_tableBorder.BORDER_HORIZONTAL_TOP,"t","asc-advanced-settings-position-btn btn-adv-paragraph-top","paragraphadv-button-border-top"],[c_tableBorder.BORDER_HORIZONTAL_CENTER,"m","asc-advanced-settings-position-btn btn-adv-paragraph-inner-hor","paragraphadv-button-border-inner-hor"],[c_tableBorder.BORDER_HORIZONTAL_BOTTOM,"b","asc-advanced-settings-position-btn btn-adv-paragraph-bottom","paragraphadv-button-border-bottom"]];this._btnsBorderPosition=[],Ext.Array.forEach(t,function(e,t){var n=Ext.create("Ext.Button",{id:e[3],cls:e[2],posId:e[0],strId:e[1],text:"",listeners:{click:Ext.bind(function(e,t){this._ApplyBorderPreset(e.strId)},this)}});this._btnsBorderPosition.push(n)},this),this._BordersImage=Ext.widget("detablestyler",{id:"id-dedropgraphstyler",width:200,height:170,rows:this.tableStylerRows,columns:this.tableStylerColumns,spacingMode:!1});var n=[{borderstyle:"",text:this.txtNoBorders,value:0,offsety:0},{text:"0.5 pt",value:.5,pxValue:.5,offsety:0},{text:"1 pt",value:1,pxValue:1,offsety:20},{text:"1.5 pt",value:1.5,pxValue:2,offsety:40},{text:"2.25 pt",value:2.25,pxValue:3,offsety:60},{text:"3 pt",value:3,pxValue:4,offsety:80},{text:"4.5 pt",value:4.5,pxValue:5,offsety:100},{text:"6 pt",value:6,pxValue:6,offsety:120}];for(var r=1;r<n.length;r++)n[r].borderstyle=Ext.String.format("background:url({0}) 0 {1}px; width:69px; height:20px; margin-right:5px;","resources/img/right-panels/BorderSize.png",-n[r].offsety);var i=Ext.create("Ext.data.Store",{model:"DE.model.ModelBorders",data:n}),s=Ext.create("Ext.XTemplate",'<tpl for="."><span style="display: inline-block; margin-top: 3px; font-size: 11px; height: 17px;">{text}</span><img src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" align="right" style="{borderstyle}"></tpl>');this.cmbBorderSize=Ext.create("Ext.form.field.ComboBox",{width:93,height:21,editable:!1,queryMode:"local",matchFieldWidth:!1,displayField:"text",store:i,listConfig:{mode:"local",width:145,itemTpl:s},listeners:{select:Ext.bind(function(t,n,r){this.BorderSize={ptValue:n[0].data.value,pxValue:n[0].data.pxValue},this._BordersImage.setVirtualBorderSize(this.BorderSize.pxValue);if(t.inputEl)if(n[0].data.value>0){t.inputEl.set({type:"image"}),t.inputEl.set({src:"data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw=="});var i=Ext.String.format("background:url({0}) no-repeat scroll 0 {1}px, url({2}) repeat scroll 0 0 white","resources/img/right-panels/BorderSize.png",-n[0].data.offsety,"resources/img/controls/text-bg.gif");Ext.DomHelper.applyStyles(t.inputEl,i)}else{var i=Ext.String.format("background: url({0}) repeat scroll 0 0 white","resources/img/controls/text-bg.gif");Ext.DomHelper.applyStyles(t.inputEl,i),t.inputEl.set({type:"text"}),t.inputEl.set({value:e.txtNoBorders}),t.onItemClick(t.picker,n[0])}},this),afterRender:function(){if(this.inputEl){Ext.DomHelper.applyStyles(this.inputEl,"padding-left:7px"),this.inputEl.set({type:"image"}),this.inputEl.set({src:"data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw=="});var e=Ext.String.format("background:url({0}) repeat scroll 0 {1}px, url({2}) repeat scroll 0 0 white","resources/img/right-panels/BorderSize.png",-20,"resources/img/controls/text-bg.gif");Ext.DomHelper.applyStyles(this.inputEl,e)}}},plugins:[{ptype:"comboboxscrollpane",pluginId:"scrollpane",settings:{enableKeyboardNavigation:!0}}]});var o=this.cmbBorderSize.getStore().getAt(2);this.cmbBorderSize.select(o),this.BorderSize={ptValue:o.data.value,pxValue:o.data.pxValue},this._btnBorderColor=Ext.create("Ext.button.Button",{id:"dropadv-button-border-color",arrowCls:"",width:45,height:22,color:"000000",menu:{showSeparator:!1,items:[this.colorsBorder=Ext.create("Common.component.ThemeColorPalette",{value:"000000",width:165,height:214,dynamiccolors:!0,dyncolorscount:10,colors:[this.textThemeColors,"-",{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},{color:"000000",effectId:5},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},"-",{color:"3D55FE",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},{color:"000000",effectId:5},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},"-","--","-",this.textStandartColors,"-","3D55FE","5301B3","980ABD","B2275F","F83D26","F86A1D","F7AC16","F7CA12","FAFF44","D6EF39","-","--"],listeners:{select:{fn:function(t,n,r,i){Ext.menu.Manager.hideAll();var s=Ext.String.format("#{0}",typeof n=="object"?n.color:n);e._btnBorderColor.color=n,e._BordersImage.setVirtualBorderColor(s),e._btnBorderColor.btnEl&&Ext.DomHelper.applyStyles(e._btnBorderColor.btnEl,{"background-color":s})}}}}),{cls:"menu-item-noicon menu-item-color-palette-theme",text:this.textNewColor,listeners:{click:function(t,n){e.colorsBorder.addNewColor()}}}]},listeners:{render:function(e){var t=Ext.String.format("background-color:#{0}",typeof e.color=="object"?e.color.color:e.color);Ext.DomHelper.applyStyles(e.btnEl,t)}},setColor:function(e){var t,n;this.color=e,e=="transparent"||e.color=="transparent"?(t="1px solid #BEBEBE",n=e):(t="none",n=Ext.String.format("#{0}",typeof e=="object"?e.color:e)),this.btnEl!==undefined&&Ext.DomHelper.applyStyles(this.btnEl,{"background-color":n,border:t})}}),this._btnBackColor=Ext.create("Ext.button.Button",{id:"dropadv-button-back-color",arrowCls:"",width:50,height:22,color:"transparent",menu:{showSeparator:!1,items:[this.colorsBack=Ext.create("Common.component.ThemeColorPalette",{value:"000000",width:165,height:214,dynamiccolors:!0,dyncolorscount:10,colors:[this.textThemeColors,"-",{color:"3366FF",effectId:1},{color:"0000FF",effectId:2},{color:"000090",effectId:3},{color:"660066",effectId:4},{color:"800000",effectId:5},{color:"FF0000",effectId:1},{color:"FF6600",effectId:1},{color:"FFFF00",effectId:2},{color:"CCFFCC",effectId:3},{color:"008000",effectId:4},"-",{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},{color:"000000",effectId:5},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},"-","--","-",this.textStandartColors,"-","transparent","5301B3","980ABD","B2275F","F83D26","F86A1D","F7AC16","F7CA12","FAFF44","D6EF39","-","--"],listeners:{select:{fn:function(t,n,r,i){Ext.menu.Manager.hideAll();var s,o;e._btnBackColor.color=n,n=="transparent"?(s="transparent",o="1px solid #BEBEBE"):(s=Ext.String.format("#{0}",typeof n=="object"?n.color:n),o="none"),e._btnBackColor.btnEl&&Ext.DomHelper.applyStyles(e._btnBackColor.btnEl,{"background-color":s,border:o}),e.paragraphShade=e._btnBackColor.color,e._changedProps&&((e._changedProps.get_Shade()===undefined||e._changedProps.get_Shade()===null)&&e._changedProps.put_Shade(new CParagraphShd),e._btnBackColor.color=="transparent"?e._changedProps.get_Shade().put_Value(shd_Nil):(e._changedProps.get_Shade().put_Value(shd_Clear),e._changedProps.get_Shade().put_Color(e.getRgbColor(e._btnBackColor.color))))}}}}),{cls:"menu-item-noicon menu-item-color-palette-theme",text:e.textNewColor,listeners:{click:function(t,n){e.colorsBack.addNewColor()}}}]},listeners:{render:function(e){var t,n;e.color=="transparent"?(t="1px solid #BEBEBE",n=e.color):(t="none",n=Ext.String.format("#{0}",typeof e.color=="object"?e.color.color:e.color)),Ext.DomHelper.applyStyles(e.btnEl,{"background-color":n,border:t})}},setColor:function(e){var t,n;this.color=e,e=="transparent"?(t="1px solid #BEBEBE",n=e):(t="none",n=Ext.String.format("#{0}",typeof e=="object"?e.color:e)),this.btnEl!==undefined&&Ext.DomHelper.applyStyles(this.btnEl,{"background-color":n,border:t})}}),this._spnMarginTop=Ext.create("Common.component.MetricSpinner",{id:"dropadv-number-margin-top",readOnly:!1,maxValue:55.87,minValue:0,step:.1,defaultUnit:"cm",value:"0 cm",width:100,listeners:{change:Ext.bind(function(e,t,n,r){this._noApply||(this.Margins===undefined&&(this.Margins={}),this.Margins.Top=Common.MetricSettings.fnRecalcToMM(e.getNumberValue()))},this)}}),this._spnMarginBottom=Ext.create("Common.component.MetricSpinner",{id:"dropadv-number-margin-bottom",readOnly:!1,maxValue:55.87,minValue:0,step:.1,defaultUnit:"cm",value:"0 cm",width:100,listeners:{change:Ext.bind(function(e,t,n,r){this._noApply||(this.Margins===undefined&&(this.Margins={}),this.Margins.Bottom=Common.MetricSettings.fnRecalcToMM(e.getNumberValue()))},this)}}),this._spnMarginLeft=Ext.create("Common.component.MetricSpinner",{id:"dropadv-number-margin-left",readOnly:!1,maxValue:9.34,minValue:0,step:.1,defaultUnit:"cm",value:"0.19 cm",width:100,listeners:{change:Ext.bind(function(e,t,n,r){this._noApply||(this.Margins===undefined&&(this.Margins={}),this.Margins.Left=Common.MetricSettings.fnRecalcToMM(e.getNumberValue()))},this)}}),this._spnMarginRight=Ext.create("Common.component.MetricSpinner",{id:"dropadv-number-margin-right",readOnly:!1,maxValue:9.34,minValue:0,step:.1,defaultUnit:"cm",value:"0.19 cm",width:100,listeners:{change:Ext.bind(function(e,t,n,r){this._noApply||(this.Margins===undefined&&(this.Margins={}),this.Margins.Right=Common.MetricSettings.fnRecalcToMM(e.getNumberValue()))},this)}}),this.btnNone=Ext.create("Ext.Button",{id:"drop-advanced-button-none",cls:"asc-right-panel-wrapbtn btn-drop-none",posId:c_oAscDropCap.None,margin:"0 10 0 0",text:"",tooltip:this.textNone,enableToggle:!0,allowDepress:!1,toggleGroup:"dropAdvGroup",pressed:!0,toggleHandler:Ext.bind(function(e){this._changedProps&&e.pressed&&(this._DisableElem(e.posId),this._changedProps.put_DropCap(e.posId))},this)}),this.btnInText=Ext.create("Ext.Button",{id:"drop-advanced-button-intext",cls:"asc-right-panel-wrapbtn btn-drop-text",posId:c_oAscDropCap.Drop,margin:"0 10 0 0",text:"",tooltip:this.textInText,enableToggle:!0,allowDepress:!1,toggleGroup:"dropAdvGroup",toggleHandler:Ext.bind(function(e){this._changedProps&&e.pressed&&(this._DisableElem(e.posId),this._changedProps.put_DropCap(e.posId))},this)}),this.btnInMargin=Ext.create("Ext.Button",{id:"drop-advanced-button-inmargin",cls:"asc-right-panel-wrapbtn btn-drop-margin",posId:c_oAscDropCap.Margin,margin:"0 10 0 0",text:"",tooltip:this.textInMargin,enableToggle:!0,allowDepress:!1,toggleGroup:"dropAdvGroup",toggleHandler:Ext.bind(function(e){this._changedProps&&e.pressed&&(this._DisableElem(e.posId),this._changedProps.put_DropCap(e.posId))},this)}),this.spnRowHeight=Ext.widget("numberfield",{id:"dropadv-spin-row-height",width:140,minValue:1,maxValue:10,value:3,allowDecimals:!1,step:1,listeners:{afterRender:function(){this.inputEl&&Ext.DomHelper.applyStyles(this.inputEl,"text-align:right;")},change:Ext.bind(function(e,t,n,r){this._changedProps&&e.isValid()&&this._changedProps.put_Lines(e.getValue())},this)}}),this.numDistance=Ext.create("Common.component.MetricSpinner",{id:"dropadv-spin-dist",readOnly:!1,step:.1,width:140,defaultUnit:"cm",value:"0 cm",maxValue:55.87,minValue:0,listeners:{change:Ext.bind(function(e,t,n,r){this._changedProps&&this._changedProps.put_HSpace(Common.MetricSettings.fnRecalcToMM(e.getNumberValue()))},this)}}),this.cmbFonts=Ext.create("DE.component.ComboDropFonts",{id:"dropadv-combo-fonts",margin:"0",width:290,colspan:2,cls:"asc-toolbar-combo",editable:!0,selectOnFocus:!0,showlastused:!1,enableKeyEvents:!0,tooltip:this.tipFontName,listId:"dropcap-combo-fonts-list",store:this.fontStore,plugins:[{ptype:"comboboxscrollpane",pluginId:"scrollpane",settings:{enableKeyboardNavigation:!0}}],listeners:{select:Ext.bind(function(e,t,n){this._changedProps&&this._changedProps.put_FontFamily(t[0].data.name)},this)}}),this.cmbFonts.fillFonts(),this.btnFrameNone=Ext.create("Ext.Button",{id:"drop-advanced-frame-none",cls:"asc-right-panel-btn btn-frame-none",posId:c_oAscFrameWrap.None,margin:"0 10 0 0",text:"",tooltip:this.textNone,enableToggle:!0,allowDepress:!1,toggleGroup:"frameAdvGroup",pressed:!0,toggleHandler:Ext.bind(function(e){this._changedProps&&e.pressed&&(this._DisableElem(e.posId),this._changedProps.put_Wrap(e.posId))},this)}),this.btnFrameInline=Ext.create("Ext.Button",{id:"drop-advanced-frame-inline",cls:"asc-right-panel-btn btn-frame-inline",posId:c_oAscFrameWrap.Inline,margin:"0 10 0 0",text:"",tooltip:this.textInline,enableToggle:!0,allowDepress:!1,toggleGroup:"frameAdvGroup",toggleHandler:Ext.bind(function(e){this._changedProps&&e.pressed&&(this._DisableElem(e.posId),this._changedProps.put_Wrap(e.posId))},this)}),this.btnFrameFlow=Ext.create("Ext.Button",{id:"drop-advanced-frame-flow",cls:"asc-right-panel-btn btn-frame-flow",posId:c_oAscFrameWrap.Flow,margin:"0 10 0 0",text:"",tooltip:this.textFlow,enableToggle:!0,allowDepress:!1,toggleGroup:"frameAdvGroup",toggleHandler:Ext.bind(function(e){this._changedProps&&e.pressed&&(this._DisableElem(e.posId),this._changedProps.put_Wrap(e.posId))},this)}),this._arrWidth=[this.textAuto,this.textExact],this.cmbWidth=Ext.create("Ext.form.field.ComboBox",{id:"dropadv-combo-width",width:120,editable:!1,store:this._arrWidth,mode:"local",triggerAction:"all",style:"margin-bottom: 0;",listeners:{select:Ext.bind(function(e,t,n){this._changedProps&&(this._spnWidth.suspendEvents(!1),this._spnWidth.setValue(t[0].index==0?"":1),this._spnWidth.resumeEvents(),this._changedProps.put_W(t[0].index==0?undefined:Common.MetricSettings.fnRecalcToMM(this._spnWidth.getNumberValue())))},this)}}),this.cmbWidth.setValue(this._arrWidth[0]),this._spnWidth=Ext.create("Common.component.MetricSpinner",{id:"dropadv-spin-width",readOnly:!1,maxValue:55.88,minValue:.02,step:.1,defaultUnit:"cm",value:"",width:85,style:"margin-bottom: 0;",listeners:{change:Ext.bind(function(e,t,n,r){this._changedProps&&(this.cmbWidth.suspendEvents(!1),this.cmbWidth.setValue(this._arrWidth[1]),this.cmbWidth.resumeEvents(),this._changedProps.put_W(Common.MetricSettings.fnRecalcToMM(e.getNumberValue())))},this)}}),this._arrHeight=[this.textAuto,this.textExact,this.textAtLeast],this.cmbHeight=Ext.create("Ext.form.field.ComboBox",{id:"dropadv-combo-height",width:120,editable:!1,store:this._arrHeight,mode:"local",triggerAction:"all",style:"margin-bottom: 0;",listeners:{select:Ext.bind(function(e,t,n){this._changedProps&&(this._spnHeight.suspendEvents(!1),this._spnHeight.setValue(t[0].index==0?"":1),this._spnHeight.resumeEvents(),this._changedProps.put_HRule(t[0].index==0?linerule_Auto:t[0].index==1?linerule_Exact:linerule_AtLeast),t[0].index>0&&this._changedProps.put_H(Common.MetricSettings.fnRecalcToMM(this._spnHeight.getNumberValue())))},this)}}),this.cmbHeight.setValue(this._arrHeight[0]),this._spnHeight=Ext.create("Common.component.MetricSpinner",{id:"dropadv-spin-height",readOnly:!1,maxValue:55.88,minValue:.02,step:.1,defaultUnit:"cm",value:"",width:85,style:"margin-bottom: 0;",listeners:{change:Ext.bind(function(e,t,n,r){if(this._changedProps){var i=linerule_Auto;this.cmbHeight.getValue()==this._arrHeight[1]?i=linerule_Exact:this.cmbHeight.getValue()==this._arrHeight[2]&&(i=linerule_AtLeast),i==linerule_Auto&&(this.cmbHeight.suspendEvents(!1),this.cmbHeight.setValue(this._arrHeight[2]),i=linerule_AtLeast,this.cmbHeight.resumeEvents()),this._changedProps.put_HRule(i),this._changedProps.put_H(Common.MetricSettings.fnRecalcToMM(e.getNumberValue()))}},this)}}),this._spnX=Ext.create("Common.component.MetricSpinner",{id:"dropadv-spin-x",readOnly:!1,maxValue:55.87,minValue:0,step:.1,defaultUnit:"cm",value:"0 cm",width:85,style:"margin-bottom: 0;",listeners:{change:Ext.bind(function(e,t,n,r){this._changedProps&&this._changedProps.put_HSpace(Common.MetricSettings.fnRecalcToMM(e.getNumberValue()))},this)}}),this._spnY=Ext.create("Common.component.MetricSpinner",{id:"dropadv-spin-y",readOnly:!1,maxValue:55.87,minValue:0,step:.1,defaultUnit:"cm",value:"0 cm",width:85,style:"margin-bottom: 0;",listeners:{change:Ext.bind(function(e,t,n,r){this._changedProps&&this._changedProps.put_VSpace(Common.MetricSettings.fnRecalcToMM(e.getNumberValue()))},this)}}),this._arrHAlign=[[c_oAscXAlign.Left,this.textLeft],[c_oAscXAlign.Center,this.textCenter],[c_oAscXAlign.Right,this.textRight]],this.cmbHAlign=Ext.create("Ext.form.field.ComboBox",{id:"dropadv-combo-halign",width:120,editable:!0,disableKeyFilter:!0,store:this._arrHAlign,queryMode:"local",triggerAction:"all",style:"margin-bottom: 0;",minChars:20,listeners:{change:Ext.bind(function(e,t,n,r){this._changedProps&&(this._changedProps.put_XAlign(undefined),this._changedProps.put_X(Common.MetricSettings.fnRecalcToMM(parseFloat(e.getValue()))))},this),select:Ext.bind(function(e,t,n){this._changedProps&&this._changedProps.put_XAlign(this._arrHAlign[t[0].index][0])},this)}}),this.cmbHAlign.setValue(this._arrHAlign[0][0]),this._arrHRelative=[[c_oAscHAnchor.Margin,this.textMargin],[c_oAscHAnchor.Page,this.textPage],[c_oAscHAnchor.Text,this.textColumn]],this.cmbHRelative=Ext.create("Ext.form.field.ComboBox",{id:"dropadv-combo-hrelative",width:85,editable:!1,store:this._arrHRelative,queryMode:"local",triggerAction:"all",style:"margin-bottom: 0;",listeners:{select:Ext.bind(function(e,t,n){this._changedProps&&this._changedProps.put_HAnchor(this._arrHRelative[t[0].index][0])},this)}}),this.cmbHRelative.setValue(this._arrHRelative[1][0]),this._arrVAlign=[[c_oAscYAlign.Top,this.textTop],[c_oAscYAlign.Center,this.textCenter],[c_oAscYAlign.Bottom,this.textBottom]],this.cmbVAlign=Ext.create("Ext.form.field.ComboBox",{id:"dropadv-combo-valign",width:120,editable:!0,disableKeyFilter:!0,store:this._arrVAlign,queryMode:"local",triggerAction:"all",style:"margin-bottom: 0;",minChars:20,listeners:{change:Ext.bind(function(e,t,n,r){this._changedProps&&(this._changedProps.put_YAlign(undefined),this._changedProps.put_Y(Common.MetricSettings.fnRecalcToMM(parseFloat(e.getValue()))))},this),select:Ext.bind(function(e,t,n){this._changedProps&&this._changedProps.put_YAlign(this._arrVAlign[t[0].index][0])},this)}}),this.cmbVAlign.setValue(this._arrVAlign[0][0]),this._arrVRelative=[[c_oAscVAnchor.Margin,this.textMargin],[c_oAscVAnchor.Page,this.textPage],[c_oAscVAnchor.Text,this.textParagraph]],this.cmbVRelative=Ext.create("Ext.form.field.ComboBox",{id:"dropadv-combo-vrelative",width:85,editable:!1,store:this._arrVRelative,queryMode:"local",triggerAction:"all",style:"margin-bottom: 0;",listeners:{select:Ext.bind(function(e,t,n){this._changedProps&&(this._changedProps.put_VAnchor(this._arrVRelative[t[0].index][0]),this.chMove.suspendEvents(!1),this.chMove.setValue(this._arrVRelative[t[0].index][0]==c_oAscVAnchor.Text),this.chMove.resumeEvents())},this)}}),this.cmbVRelative.setValue(this._arrVRelative[2][0]),this.chMove=Ext.create("Common.component.IndeterminateCheckBox",{id:"dropadv-checkbox-move",boxLabel:this.textMove,colspan:3,checked:!0,listeners:{change:Ext.bind(function(e,t,n,r){if(this._changedProps){var i=this.cmbVRelative.getStore().getAt(e.getValue()=="checked"?2:1);this.cmbVRelative.select(i),this.cmbVRelative.fireEvent("select",this.cmbVRelative,[i])}},this)}}),this.btnBorders=Ext.widget("button",{width:160,height:27,cls:"asc-dialogmenu-btn",textAlign:"right",text:this.strBorders,enableToggle:!0,allowDepress:!1,toggleGroup:"advtablecardGroup",listeners:{click:function(e){e.pressed&&this.mainCard.getLayout().setActiveItem("card-borders")},scope:this}}),this.btnMargins=Ext.widget("button",{width:160,height:27,cls:"asc-dialogmenu-btn",textAlign:"right",text:this.strMargins,enableToggle:!0,allowDepress:!1,toggleGroup:"advtablecardGroup",listeners:{click:function(e){e.pressed&&this.mainCard.getLayout().setActiveItem("card-margins")},scope:this}}),this.btnFrame=Ext.widget("button",{width:160,height:27,cls:"asc-dialogmenu-btn",textAlign:"right",text:this.textFrame,enableToggle:!0,allowDepress:!1,toggleGroup:"advtablecardGroup",pressed:!0,listeners:{click:function(e){e.pressed&&this.mainCard.getLayout().setActiveItem(this.isFrame?"card-frame":"card-drop")},scope:this}}),this._BordersContainer={xtype:"container",itemId:"card-borders",layout:{type:"vbox",align:"stretch"},height:285,items:[{xtype:"container",layout:{type:"hbox",align:"middle"},height:28,padding:"2px 10px 0 10px",style:"vertical-align: middle;",items:[{xtype:"label",text:this.textBorderWidth},{xtype:"tbspacer",width:4},this.cmbBorderSize,{xtype:"tbspacer",flex:1},{xtype:"label",text:this.textBorderColor},{xtype:"tbspacer",width:4},this._btnBorderColor]},{xtype:"tbspacer",height:10},{xtype:"label",text:this.textBorderDesc,style:"padding-left:10px;height:13px;"},{xtype:"tbspacer",height:20},{xtype:"container",layout:{type:"hbox",align:"top"},height:180,width:200,padding:"0 10",style:"vertical-align: top;",items:[this.bordersImagePanel=Ext.create("Ext.container.Container",{layout:"card",activeItem:0,width:200,height:180,style:"padding-bottom:10px;",items:[this._BordersImage]}),{xtype:"tbspacer",width:25},{xtype:"container",layout:"hbox",height:180,width:100,items:[this._PresetsContainer=Ext.create("Ext.container.Container",{height:180,width:100,layout:{type:"table",columns:2,tdAttrs:{style:"padding-right: 10px; padding-bottom: 4px; vertical-align: middle;"}},items:[{xtype:"tbspacer",height:5},{xtype:"tbspacer",height:5},this._btnsBorderPosition[5],this._btnsBorderPosition[6],this._btnsBorderPosition[7],this._btnsBorderPosition[0],this._btnsBorderPosition[3],this._btnsBorderPosition[1],this._btnsBorderPosition[4],this._btnsBorderPosition[2]]})]}]},{xtype:"tbspacer",height:5},{xtype:"container",height:23,padding:"0 10",layout:"hbox",items:[this._BackContainer=Ext.create("Ext.container.Container",{height:23,width:250,layout:"hbox",margin:"0 4px 0 0",items:[{xtype:"label",text:this.textBackColor,margin:"2px 4px 0 0"},this._btnBackColor]})]}]},this._MarginsContainer={xtype:"container",itemId:"card-margins",width:330,layout:{type:"vbox",align:"stretch"},items:[{xtype:"container",padding:"0 10",layout:{type:"table",columns:2,tdAttrs:{style:"padding-right: 40px;vertical-align: middle;"}},items:[{xtype:"label",text:this.textTop,width:85},{xtype:"label",text:this.textLeft,width:85},{xtype:"tbspacer",height:2},{xtype:"tbspacer",height:2},this._spnMarginTop,this._spnMarginLeft,{xtype:"tbspacer",height:5},{xtype:"tbspacer",height:5},{xtype:"label",text:this.textBottom,width:85},{xtype:"label",text:this.textRight,width:85},{xtype:"tbspacer",height:2},{xtype:"tbspacer",height:2},this._spnMarginBottom,this._spnMarginRight]}]},this._DropcapContainer={xtype:"container",itemId:"card-drop",width:330,layout:{type:"vbox",align:"stretch"},items:[{xtype:"label",style:"font-weight: bold;margin-top: 1px; padding-left:10px;height:13px;",text:this.textPosition},{xtype:"tbspacer",height:10},{xtype:"container",padding:"0 10",items:[this.btnNone,this.btnInText,this.btnInMargin]},{xtype:"tbspacer",height:20},{xtype:"label",style:"font-weight: bold;margin-top: 1px; padding-left:10px;height:13px;",text:this.textParameters},{xtype:"tbspacer",height:10},{xtype:"container",padding:"0 10",layout:{type:"table",columns:2,tdAttrs:{style:"padding-right: 10px;vertical-align: middle;"}},items:[{xtype:"label",text:this.textFont,width:140,colspan:2},this.cmbFonts,{xtype:"tbspacer",height:10,colspan:2},{xtype:"label",text:this.textRowHeight,width:140},{xtype:"label",text:this.textDistance,width:140},{xtype:"tbspacer",height:2},{xtype:"tbspacer",height:2},this.spnRowHeight,this.numDistance]}]},this._FrameContainer={xtype:"container",itemId:"card-frame",width:330,layout:{type:"vbox",align:"stretch"},items:[{xtype:"label",style:"font-weight: bold;margin-top: 1px; padding-left:10px;height:13px;",text:this.textPosition},{xtype:"tbspacer",height:10},{xtype:"container",padding:"0 10",items:[this.btnFrameNone,this.btnFrameInline,this.btnFrameFlow]},this._spacer.cloneConfig({style:"margin: 13px 0 8px 0;",height:6}),{xtype:"container",padding:"0 10",layout:{type:"table",columns:3,tdAttrs:{style:"padding-right: 10px;vertical-align: middle;"}},items:[{xtype:"tbspacer",height:1,width:70},{xtype:"tbspacer",height:1,colspan:2},{xtype:"label",text:this.textWidth,width:70},this.cmbWidth,this._spnWidth,{xtype:"tbspacer",height:8,colspan:3},{xtype:"label",text:this.textHeight,width:70},this.cmbHeight,this._spnHeight]},this._spacer.cloneConfig({style:"margin: 12px 0 6px 0;",height:6}),{xtype:"label",style:"font-weight: bold;margin-top: 1px; padding-left:10px;height:13px;",text:this.textHorizontal},{xtype:"container",padding:"0 10",layout:{type:"table",columns:3,tdAttrs:{style:"padding-right: 10px;vertical-align: middle;"}},items:[{xtype:"tbspacer",colspan:2},{xtype:"label",text:this.textRelative,width:70},{xtype:"tbspacer",height:2,width:70},{xtype:"tbspacer",height:2,colspan:2},{xtype:"label",text:this.textPosition,width:70},this.cmbHAlign,this.cmbHRelative,{xtype:"tbspacer",height:8,colspan:3},{xtype:"tbspacer",width:70},{xtype:"label",text:this.textDistance,width:120,style:"float: right; text-align: right;"},this._spnX]},this._spacer.cloneConfig({style:"margin: 13px 0 6px 0;",height:6}),{xtype:"label",style:"font-weight: bold;margin-top: 1px; padding-left:10px;height:13px;",text:this.textVertical},{xtype:"container",padding:"0 10",layout:{type:"table",columns:3,tdAttrs:{style:"padding-right: 10px;vertical-align: middle;"}},items:[{xtype:"tbspacer",colspan:2},{xtype:"label",text:this.textRelative,width:70},{xtype:"tbspacer",height:2,width:70},{xtype:"tbspacer",height:2,colspan:2},{xtype:"label",text:this.textPosition,width:70},this.cmbVAlign,this.cmbVRelative,{xtype:"tbspacer",height:8,colspan:3},{xtype:"tbspacer",width:70},{xtype:"label",text:this.textDistance,width:120,style:"float: right; text-align: right;"},this._spnY,this.chMove]}]},this.items=[this.mainBody=Ext.create("Ext.container.Container",{height:400,layout:{type:"hbox",align:"stretch"},items:[{xtype:"container",width:160,padding:"5px 0 0 0",layout:{type:"vbox",align:"stretch"},defaults:{xtype:"container",layout:{type:"hbox",align:"middle",pack:"end"}},items:[{height:30,items:[this.btnFrame]},{height:30,items:[this.btnBorders]},{height:30,items:[this.btnMargins]}]},{xtype:"box",cls:"advanced-settings-separator",height:"100%",width:8},this.mainCard=Ext.create("Ext.container.Container",{height:300,flex:1,padding:"12px 18px 0 10px",layout:"card",items:[this._FrameContainer,this._DropcapContainer,this._BordersContainer,this._MarginsContainer]})]}),this._spacer.cloneConfig({style:"margin: 0 18px"}),{xtype:"container",height:40,layout:{type:"vbox",align:"center",pack:"center"},items:[{xtype:"container",width:182,height:24,layout:{type:"hbox",align:"middle"},items:[this.btnOk=Ext.widget("button",{cls:"asc-blue-button",width:86,height:22,margin:"0 5px 0 0",text:this.okButtonText,listeners:{click:function(e){this.fireEvent("onmodalresult",this,1,this.getSettings()),this.close()},scope:this}}),this.btnCancel=Ext.widget("button",{cls:"asc-darkgray-button",width:86,height:22,text:this.cancelButtonText,listeners:{click:function(e){this.fireEvent("onmodalresult",this,0),this.close()},scope:this}})]}]}],this.callParent(arguments)},afterRender:function(){this.callParent(arguments),this._setDefaults(this._originalProps);if(this.borderProps!==undefined){this._btnBorderColor.setColor(this.borderProps.borderColor);var e=Ext.String.format("#{0}",typeof this.borderProps.borderColor=="object"?this.borderProps.borderColor.color:this.borderProps.borderColor);this._BordersImage.setVirtualBorderColor(e);var t=this.cmbBorderSize.getStore().findRecord("value",this.borderProps.borderSize.ptValue);t&&(this.cmbBorderSize.select(t),this.cmbBorderSize.fireEvent("select",this.cmbBorderSize,[t])),this.colorsBorder.select(this.borderProps.borderColor)}this.setTitle(this.isFrame?this.textTitleFrame:this.textTitle),this.colorProps!==undefined&&this.sendThemeColors(this.colorProps[0],this.colorProps[1]);for(var n=0;n<this._BordersImage.rows;n++)for(var r=0;r<this._BordersImage.columns;r++)this._BordersImage.getCell(r,n).addListener("borderclick",function(e,t,n,r){this.ChangedBorders===undefined&&(this.ChangedBorders=new CParagraphBorders),this._UpdateCellBordersStyle(e,t,n,r,this.Borders)},this);this._BordersImage.addListener("borderclick",function(e,t,n,r){this.ChangedBorders===undefined&&(this.ChangedBorders=new CParagraphBorders),this._UpdateTableBordersStyle(e,t,n,r,this.Borders)},this),this.isFrame||(this.btnFrame.setText(this.strDropcap),this.setHeight(390),this.mainBody.setHeight(300),this.mainCard.getLayout().setActiveItem("card-drop"))},setSettings:function(e){this._originalProps=new CParagraphProp(e.paragraphProps),this.borderProps=e.borderProps,this.colorProps=e.colorProps,this.isFrame=e.isFrame,this._changedProps=null,this.api=e.api},_setDefaults:function(e){if(e){this._noApply=!0,this._originalProps=new CParagraphProp(e);var t=e.get_FramePr();if(t){var n;if(this.isFrame){n=t.get_W(),this.cmbWidth.setValue(n===undefined?this._arrWidth[0]:this._arrWidth[1]),this._spnWidth.setValue(n!==undefined?Common.MetricSettings.fnRecalcFromMM(n):""),n=t.get_HRule(),n!==undefined?(this.cmbHeight.setValue(n===linerule_Exact?this._arrHeight[1]:this._arrHeight[2]),this._spnHeight.setValue(Common.MetricSettings.fnRecalcFromMM(t.get_H()))):(this.cmbHeight.setValue(this._arrHeight[0]),this._spnHeight.setValue("")),n=t.get_HSpace(),this._spnX.setValue(n!==undefined?Common.MetricSettings.fnRecalcFromMM(n):0),n=t.get_VSpace(),this._spnY.setValue(n!==undefined?Common.MetricSettings.fnRecalcFromMM(n):0),n=t.get_HAnchor();for(var r=0;r<this._arrHRelative.length;r++)if(n==this._arrHRelative[r][0]){this.cmbHRelative.setValue(this._arrHRelative[r][1]);break}n=t.get_XAlign();if(n!==undefined){for(var r=0;r<this._arrHAlign.length;r++)if(n==this._arrHAlign[r][0]){this.cmbHAlign.setValue(this._arrHAlign[r][1]);break}}else n=t.get_X(),this.cmbHAlign.setValue(Common.MetricSettings.fnRecalcFromMM(n!==undefined?n:0)+" "+Common.MetricSettings.metricName[Common.MetricSettings.getCurrentMetric()]);n=t.get_VAnchor();for(var r=0;r<this._arrVRelative.length;r++)if(n==this._arrVRelative[r][0]){this.cmbVRelative.setValue(this._arrVRelative[r][1]);break}this.chMove.setValue(n==c_oAscVAnchor.Text),n=t.get_YAlign();if(n!==undefined){for(var r=0;r<this._arrVAlign.length;r++)if(n==this._arrVAlign[r][0]){this.cmbVAlign.setValue(this._arrVAlign[r][1]);break}}else n=t.get_Y(),this.cmbVAlign.setValue(Common.MetricSettings.fnRecalcFromMM(n!==undefined?n:0)+" "+Common.MetricSettings.metricName[Common.MetricSettings.getCurrentMetric()]);n=t.get_Wrap(),n===!1?this.btnFrameInline.toggle(!0,!1):this.btnFrameFlow.toggle(!0,!1)}else{this.spnRowHeight.setValue(t.get_Lines()!==null?t.get_Lines():""),this.numDistance.setValue(t.get_HSpace()!==null?Common.MetricSettings.fnRecalcFromMM(t.get_HSpace()):""),n=t.get_DropCap(),n==c_oAscDropCap.Drop?this.btnInText.toggle(!0,!1):n==c_oAscDropCap.Margin?this.btnInMargin.toggle(!0,!1):this.btnNone.toggle(!0,!1),n=t.get_FontFamily();if(n){var i=this.cmbFonts.store.findRecord("name",n.get_Name(),0,!1,!1,!0);this.cmbFonts.clearValue(),i?this.cmbFonts.select(i):this.cmbFonts.setRawValue(n.get_Name())}}this.Borders=new CParagraphBorders(t.get_Borders());if(this.Borders){var s=this.Borders.get_Left(),o=null!==s&&undefined!==s&&null!==s.get_Space()&&undefined!==s.get_Space()?Common.MetricSettings.fnRecalcFromMM(s.get_Space()):"";this._spnMarginLeft.setValue(o),s=this.Borders.get_Top(),o=null!==s&&undefined!==s&&null!==s.get_Space()&&undefined!==s.get_Space()?Common.MetricSettings.fnRecalcFromMM(s.get_Space()):"",this._spnMarginTop.setValue(o),s=this.Borders.get_Right(),o=null!==s&&undefined!==s&&null!==s.get_Space()&&undefined!==s.get_Space()?Common.MetricSettings.fnRecalcFromMM(s.get_Space()):"",this._spnMarginRight.setValue(o),s=this.Borders.get_Bottom(),o=null!==s&&undefined!==s&&null!==s.get_Space()&&undefined!==s.get_Space()?Common.MetricSettings.fnRecalcFromMM(s.get_Space()):"",this._spnMarginBottom.setValue(o)}var u=t.get_Shade();if(u!==null&&u!==undefined&&u.get_Value()===shd_Clear){var a=u.get_Color();a?a.get_type()==c_oAscColor.COLOR_TYPE_SCHEME?this.paragraphShade={color:this.getHexColor(a.get_r(),a.get_g(),a.get_b()),effectValue:a.get_value()}:this.paragraphShade=this.getHexColor(a.get_r(),a.get_g(),a.get_b()):this.paragraphShade="transparent"}else this.paragraphShade="transparent";this._btnBackColor.setColor(this.paragraphShade);if(typeof this.paragraphShade=="object"){for(var r=0;r<10;r++)if(this.ThemeValues[r]==this.paragraphShade.effectValue){this.colorsBack.select(this.paragraphShade,!0);break}}else this.colorsBack.select(this.paragraphShade,!0);this._UpdateBorders()}this._noApply=!1,this._changedProps=new CParagraphFrame,this.isFrame&&t&&t.get_W()!==undefined&&this._changedProps.put_W(t.get_W()),this.ChangedBorders=undefined}},getSettings:function(){this.ChangedBorders===null?this._changedProps.put_Borders(this.Borders):this.ChangedBorders!==undefined&&this._changedProps.put_Borders(this.ChangedBorders);if(this.Margins){var e=this._changedProps.get_Borders();if(e===undefined||e===null)this._changedProps.put_Borders(new CParagraphBorders),e=this._changedProps.get_Borders();this.Margins.Left!==undefined&&((e.get_Left()===undefined||e.get_Left()===null)&&e.put_Left(new CBorder(this.Borders.get_Left())),e.get_Left().put_Space(this.Margins.Left)),this.Margins.Top!==undefined&&((e.get_Top()===undefined||e.get_Top()===null)&&e.put_Top(new CBorder(this.Borders.get_Top())),e.get_Top().put_Space(this.Margins.Top)),this.Margins.Right!==undefined&&((e.get_Right()===undefined||e.get_Right()===null)&&e.put_Right(new CBorder(this.Borders.get_Right())),e.get_Right().put_Space(this.Margins.Right)),this.Margins.Bottom!==undefined&&((e.get_Bottom()===undefined||e.get_Bottom()===null)&&e.put_Bottom(new CBorder(this.Borders.get_Bottom())),e.get_Bottom().put_Space(this.Margins.Bottom),(e.get_Between()===undefined||e.get_Between()===null)&&e.put_Between(new CBorder(this.Borders.get_Between())),e.get_Between().put_Space(this.Margins.Bottom))}return this._changedProps.put_FromDropCapMenu(!this.isFrame),{paragraphProps:this._changedProps,borderProps:{borderSize:this.BorderSize,borderColor:this._btnBorderColor.color}}},_UpdateBorders:function(){var e=this.BorderSize,t=this._btnBorderColor.color;this._UpdateBorder(this.Borders.get_Left(),"l"),this._UpdateBorder(this.Borders.get_Top(),"t"),this._UpdateBorder(this.Borders.get_Right(),"r"),this._UpdateBorder(this.Borders.get_Bottom(),"b");if(this.Borders.get_Between()!==null)for(var n=0;n<this._BordersImage.columns;n++)this._UpdateCellBorder(this.Borders.get_Between(),"b",this._BordersImage.getCell(n,0)),this._UpdateCellBorder(this.Borders.get_Between(),"t",this._BordersImage.getCell(n,1));this._BordersImage.setVirtualBorderSize(e.pxValue);var r=Ext.String.format("#{0}",typeof t=="object"?t.color:t);this._BordersImage.setVirtualBorderColor(r)},_UpdateCellBorder:function(e,t,n){null!==e&&undefined!==e?null!==e.get_Value()&&null!==e.get_Size()&&null!==e.get_Color()&&1==e.get_Value()?(n.setBordersSize(t,this._BorderPt2Px(e.get_Size()*72/25.4)),n.setBordersColor(t,"rgb("+e.get_Color().get_r()+","+e.get_Color().get_g()+","+e.get_Color().get_b()+")")):n.setBordersSize(t,0):n.setBordersSize(t,0)},_UpdateBorder:function(e,t){null!==e&&undefined!==e?null!==e.get_Value()&&null!==e.get_Size()&&null!==e.get_Color()&&1==e.get_Value()?(this._BordersImage.setBordersSize(t,this._BorderPt2Px(e.get_Size()*72/25.4)),this._BordersImage.setBordersColor(t,"rgb("+e.get_Color().get_r()+","+e.get_Color().get_g()+","+e.get_Color().get_b()+")")):this._BordersImage.setBordersSize(t,0):this._BordersImage.setBordersSize(t,0)},_BorderPt2Px:function(e){return e==0?0:e<.6?.5:e<=1?1:e<=1.5?2:e<=2.25?3:e<=3?4:e<=4.5?5:6},_ApplyBorderPreset:function(e){this.ChangedBorders=null,this.Borders.put_Left(this._UpdateBorderStyle(this.Borders.get_Left(),e.indexOf("l")>-1)),this.Borders.put_Top(this._UpdateBorderStyle(this.Borders.get_Top(),e.indexOf("t")>-1)),this.Borders.put_Right(this._UpdateBorderStyle(this.Borders.get_Right(),e.indexOf("r")>-1)),this.Borders.put_Bottom(this._UpdateBorderStyle(this.Borders.get_Bottom(),e.indexOf("b")>-1)),this.Borders.put_Between(this._UpdateBorderStyle(this.Borders.get_Between(),e.indexOf("m")>-1)),this._UpdateBorders()},_UpdateBorderStyle:function(e,t){null==e&&(e=new CBorder);if(t&&this.BorderSize.ptValue>0){var n=parseFloat(this.BorderSize.ptValue);e.put_Value(1),e.put_Size(n*25.4/72);var r=this.getRgbColor(this._btnBorderColor.color);e.put_Color(r)}else e.put_Color(new CColor),e.put_Value(0);return e},_UpdateCellBordersStyle:function(e,t,n,r,i){var s=i;e.col==0&&t.indexOf("l")>-1&&(s.put_Left(this._UpdateBorderStyle(s.get_Left(),n>0)),this.ChangedBorders&&this.ChangedBorders.put_Left(new CBorder(s.get_Left()))),e.col==this.tableStylerColumns-1&&t.indexOf("r")>-1&&(s.put_Right(this._UpdateBorderStyle(s.get_Right(),n>0)),this.ChangedBorders&&this.ChangedBorders.put_Right(new CBorder(s.get_Right()))),e.row==0&&t.indexOf("t")>-1&&(s.put_Top(this._UpdateBorderStyle(s.get_Top(),n>0)),this.ChangedBorders&&this.ChangedBorders.put_Top(new CBorder(s.get_Top()))),e.row==this.tableStylerRows-1&&t.indexOf("b")>-1&&(s.put_Bottom(this._UpdateBorderStyle(s.get_Bottom(),n>0)),this.ChangedBorders&&this.ChangedBorders.put_Bottom(new CBorder(s.get_Bottom())));if(e.row==0&&t.indexOf("b")>-1||e.row==this.tableStylerRows-1&&t.indexOf("t")>-1)s.put_Between(this._UpdateBorderStyle(s.get_Between(),n>0)),this.ChangedBorders&&this.ChangedBorders.put_Between(new CBorder(s.get_Between()))},_UpdateTableBordersStyle:function(e,t,n,r,i){var s=i;t.indexOf("l")>-1&&(s.put_Left(this._UpdateBorderStyle(s.get_Left(),n>0)),this.ChangedBorders&&this.ChangedBorders.put_Left(new CBorder(s.get_Left()))),t.indexOf("t")>-1&&(s.put_Top(this._UpdateBorderStyle(s.get_Top(),n>0)),this.ChangedBorders&&this.ChangedBorders.put_Top(new CBorder(s.get_Top()))),t.indexOf("r")>-1&&(s.put_Right(this._UpdateBorderStyle(s.get_Right(),n>0)),this.ChangedBorders&&this.ChangedBorders.put_Right(new CBorder(s.get_Right()))),t.indexOf("b")>-1&&(s.put_Bottom(this._UpdateBorderStyle(s.get_Bottom(),n>0)),this.ChangedBorders&&this.ChangedBorders.put_Bottom(new CBorder(s.get_Bottom())))},getRgbColor:function(e){var t=typeof e=="object"?e.color:e;t=t.replace(/#/,""),t.length==3&&(t=t.replace(/(.)/g,"$1$1")),t=parseInt(t,16);var n=new CAscColor;return n.put_type(typeof e=="object"?c_oAscColor.COLOR_TYPE_SCHEME:c_oAscColor.COLOR_TYPE_SRGB),n.put_r(t>>16),n.put_g((t&65280)>>8),n.put_b(t&255),n.put_a(255),e.effectId!==undefined&&n.put_value(e.effectId),n},getHexColor:function(e,t,n){return e=e.toString(16),t=t.toString(16),n=n.toString(16),e.length==1&&(e="0"+e),t.length==1&&(t="0"+t),n.length==1&&(n="0"+n),e+t+n},sendThemeColors:function(e,t){t&&e&&(this.colorsBorder.updateColors(e,t),this.colorsBack.updateColors(e,t))},updateMetricUnit:function(){var e=this.query("commonmetricspinner");if(e)for(var t=0;t<e.length;t++){var n=e[t];n.setDefaultUnit(Common.MetricSettings.metricName[Common.MetricSettings.getCurrentMetric()]),n.setStep(Common.MetricSettings.getCurrentMetric()==Common.MetricSettings.c_MetricUnits.cm?.1:1)}},_DisableElem:function(e){var t=e===c_oAscDropCap.None||e===c_oAscFrameWrap.None;this.btnBorders.setDisabled(t),this.btnMargins.setDisabled(t),this.isFrame?(t=e==c_oAscFrameWrap.None,this.cmbHAlign.setDisabled(t),this.cmbHRelative.setDisabled(t),this._spnX.setDisabled(t),this.cmbVAlign.setDisabled(t),this.cmbVRelative.setDisabled(t),this._spnY.setDisabled(t),this.chMove.setDisabled(t),this.cmbWidth.setDisabled(t),this.cmbHeight.setDisabled(t),this._spnWidth.setDisabled(t),this._spnHeight.setDisabled(t)):(t=e==c_oAscDropCap.None,this.spnRowHeight.setDisabled(t),this.numDistance.setDisabled(t),this.cmbFonts.setDisabled(t))},textTitle:"Drop Cap - Advanced Settings",strBorders:"Borders & Fill",textBorderWidth:"Border Size",textBorderColor:"Border Color",textBackColor:"Background Color",textBorderDesc:"Click on diagramm or use buttons to select borders",cancelButtonText:"Cancel",okButtonText:"Ok",txtNoBorders:"No borders",textNewColor:"Add New Custom Color",textPosition:"Position",textThemeColors:"Theme Colors",textStandartColors:"Standart Colors",textAlign:"Alignment",textTop:"Top",textLeft:"Left",textBottom:"Bottom",textRight:"Right",textCenter:"Center",strMargins:"Margins",strDropcap:"Drop Cap",textNone:"None",textInText:"In text",textInMargin:"In margin",textParameters:"Parameters",textRowHeight:"Height in rows",textDistance:"Distance from text",textFont:"Font",textInline:"Inline frame",textFlow:"Flow frame",textFrame:"Frame",textWidth:"Width",textHeight:"Height",textAuto:"Auto",textExact:"Exactly",textAtLeast:"At least",textMove:"Move with text",textHorizontal:"Horizontal",textVertical:"Vertical",textRelative:"Relative to",textColumn:"Column",textMargin:"Margin",textPage:"Page",textParagraph:"Paragraph",tipFontName:"Font Name",textTitleFrame:"Frame - Advanced Settings"}),Ext.define("DE.view.ImageSettings",{extend:"Common.view.AbstractSettingsPanel",alias:"widget.deimagesettings",height:298,requires:["Ext.ComponentQuery","Ext.container.Container","Ext.button.Button","Ext.form.Checkbox","Ext.form.Text","Ext.form.Label","Ext.toolbar.Spacer","Common.view.ImageFromUrlDialog","DE.view.ImageSettingsAdvanced","Common.component.MenuDataViewPicker"],constructor:function(e){return this.callParent(arguments),this.initConfig(e),this},initComponent:function(){this.title=this.txtTitle,this._initSettings=!0,this._state={WrappingStyle:c_oAscWrapStyle2.Inline,CanBeFlow:!0,Width:0,Height:0,FromGroup:!1},this._nRatio=1,this._noApply=!1,this._originalProps=null;var e=Ext.create("Ext.XTemplate",'<tpl for=".">','<div class="thumb-wrap" data-qtip="{tip}">','<img src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" style="{imgstyle}" class="item-wraplist"/>','<tpl if="title">','<span class="title">{title}</span>',"</tpl>","</div>","</tpl>"),t=[{offsetx:0,data:c_oAscWrapStyle2.Inline,iconcls:"wrap-subtype wrap-inline",tip:this.txtInline},{offsetx:50,data:c_oAscWrapStyle2.Square,iconcls:"wrap-subtype wrap-square",tip:this.txtSquare},{offsetx:100,data:c_oAscWrapStyle2.Tight,iconcls:"wrap-subtype wrap-tight",tip:this.txtTight},{offsetx:150,data:c_oAscWrapStyle2.Through,iconcls:"wrap-subtype wrap-through",tip:this.txtThrough},{offsetx:200,data:c_oAscWrapStyle2.TopAndBottom,iconcls:"wrap-subtype wrap-topAndBottom",tip:this.txtTopAndBottom},{offsetx:250,data:c_oAscWrapStyle2.InFront,iconcls:"wrap-subtype wrap-inFront",tip:this.txtInFront},{offsetx:300,data:c_oAscWrapStyle2.Behind,iconcls:"wrap-subtype wrap-behind",tip:this.txtBehind}];for(var n=0;n<t.length;n++)t[n].imgstyle=Ext.String.format("background-position: {0}px 0;",-t[n].offsetx);this.btnWrapType=Ext.widget("button",{id:"image-button-wrap",width:72,height:58,cls:"btn-wrap-types",iconCls:"wrap-subtype wrap-inline",pressedCls:"disablepressed",menuAlign:"tl-bl?",menu:Ext.create("Common.component.MenuDataViewPicker",{width:257,height:133,cls:"wrap-view",dataTpl:e,viewData:t,contentWidth:237,listeners:{select:Ext.bind(function(e,t){this.btnWrapType.setIconCls(t.data.iconcls);if(this.api&&!this._noApply){var n=new CImgProperty;n.put_WrappingStyle(t.data.data);if(this._state.WrappingStyle===c_oAscWrapStyle2.Inline&&t.data.data!==c_oAscWrapStyle2.Inline){n.put_PositionH(new CImagePositionH),n.get_PositionH().put_UseAlign(!1),n.get_PositionH().put_RelativeFrom(c_oAscRelativeFromH.Column);var r=this._originalProps.get_Value_X(c_oAscRelativeFromH.Column);n.get_PositionH().put_Value(r),n.put_PositionV(new CImagePositionV),n.get_PositionV().put_UseAlign(!1),n.get_PositionV().put_RelativeFrom(c_oAscRelativeFromV.Paragraph),r=this._originalProps.get_Value_Y(c_oAscRelativeFromV.Paragraph),n.get_PositionV().put_Value(r)}this.api.ImgApply(n)}this.fireEvent("editcomplete",this)},this),hide:Ext.bind(function(){this.fireEvent("editcomplete",this)},this)}})}),this.btnWrapType.menu.picker.selectByIndex(0),this._btnOriginalSize=Ext.create("Ext.Button",{id:"image-button-original-size",text:this.textOriginalSize,width:100,listeners:{click:this.setOriginalSize,scope:this}}),this._btnInsertFromFile=Ext.create("Ext.Button",{id:"image-button-from-file",text:this.textFromFile,width:85,listeners:{click:function(e){this.api&&this.api.ChangeImageFromFile(),this.fireEvent("editcomplete",this)},scope:this}}),this._btnInsertFromUrl=Ext.create("Ext.Button",{id:"image-button-from-url",text:this.textFromUrl,width:85,listeners:{click:function(e){var t=Ext.create("Common.view.ImageFromUrlDialog");t.addListener("onmodalresult",Ext.bind(this._onOpenImageFromURL,[this,t]),!1),t.addListener("close",Ext.bind(function(e,t){this.fireEvent("editcomplete",this)},this)),t.show()},scope:this}}),this._SizePanel=Ext.create("Ext.container.Container",{layout:"vbox",layoutConfig:{align:"stretch"},height:61,width:200,items:[{xtype:"tbspacer",height:8},{xtype:"container",layout:{type:"table",columns:2,tdAttrs:{style:"padding-right: 8px;"}},defaults:{xtype:"container",layout:"vbox",layoutConfig:{align:"stretch"},height:16,style:"float:left;"},items:[{items:[this.labelWidth=Ext.create("Ext.form.Label",{text:this.textWidth,width:85})]},{items:[this.labelHeight=Ext.create("Ext.form.Label",{text:this.textHeight,width:85})]}]},{xtype:"tbspacer",height:8},this._btnOriginalSize,{xtype:"tbspacer",height:3}]}),this._WrapPanel=Ext.create("Ext.container.Container",{layout:"vbox",layoutConfig:{align:"stretch"},height:70,width:200,items:[{xtype:"tbspacer",height:6},{xtype:"container",height:63,width:200,layout:"hbox",items:[this.btnWrapType]}]}),this._UrlPanel=Ext.create("Ext.container.Container",{layout:"vbox",layoutConfig:{align:"stretch"},height:36,width:200,items:[{xtype:"tbspacer",height:8},{xtype:"container",layout:{type:"table",columns:2,tdAttrs:{style:"padding-right: 8px;"}},items:[this._btnInsertFromFile,this._btnInsertFromUrl]},{xtype:"tbspacer",height:2}]}),this.items=[{xtype:"tbspacer",height:9},{xtype:"label",style:"font-weight: bold;margin-top: 1px;",text:this.textSize},this._SizePanel,{xtype:"tbspacer",height:5},{xtype:"tbspacer",width:"100%",height:10,style:"padding-right: 10px;",html:'<div style="width: 100%; height: 40%; border-bottom: 1px solid #C7C7C7"></div>'},{xtype:"label",style:"font-weight: bold;margin-top: 1px;",text:this.textWrap},this._WrapPanel,{xtype:"tbspacer",height:5},{xtype:"tbspacer",width:"100%",height:10,style:"padding-right: 10px;",html:'<div style="width: 100%; height: 40%; border-bottom: 1px solid #C7C7C7"></div>'},{xtype:"label",style:"font-weight: bold;margin-top: 1px;",text:this.textInsert},this._UrlPanel,{xtype:"tbspacer",height:8},{xtype:"tbspacer",width:"100%",height:10,style:"padding-right: 10px;",html:'<div style="width: 100%; height: 40%; border-bottom: 1px solid #C7C7C7"></div>'},{xtype:"tbspacer",height:3},{xtype:"container",height:20,width:"100%",items:[{xtype:"box",html:'<div style="width:100%;text-align:center;padding-right:15px;"><label id="image-advanced-link" class="asc-advanced-link">'+this.textAdvanced+"</label></div>",listeners:{afterrender:function(e){document.getElementById("image-advanced-link").onclick=Ext.bind(this._openAdvancedSettings,this)},scope:this}}]}],this.addEvents("editcomplete"),this.callParent(arguments)},setOriginalSize:function(){if(this.api){var e=this.api.get_OriginalSizeImage(),t=e.get_ImageWidth(),n=e.get_ImageHeight();this.labelWidth.setText(this.textWidth+": "+Ext.util.Format.round(Common.MetricSettings.fnRecalcFromMM(t),1)+" "+Common.MetricSettings.metricName[Common.MetricSettings.getCurrentMetric()]),this.labelHeight.setText(this.textHeight+": "+Ext.util.Format.round(Common.MetricSettings.fnRecalcFromMM(n),1)+" "+Common.MetricSettings.metricName[Common.MetricSettings.getCurrentMetric()]);var r=new CImgProperty;r.put_Width(t),r.put_Height(n),this.api.ImgApply(r),this.fireEvent("editcomplete",this)}},setApi:function(e){if(e==undefined)return;this.api&&this.api.asc_unregisterCallback("asc_onImgWrapStyleChanged",Ext.bind(this._ImgWrapStyleChanged,this)),this.api=e,this.api.asc_registerCallback("asc_onImgWrapStyleChanged",Ext.bind(this._ImgWrapStyleChanged,this))},ChangeSettings:function(e){this._initSettings&&(this.createDelayedElements(),this._initSettings=!1);if(e){this._originalProps=new CImgProperty(e);var t=e.get_WrappingStyle();if(this._state.WrappingStyle!==t){this._noApply=!0;var n=this.btnWrapType.menu.picker.store.find("data",t);this.btnWrapType.menu.picker.selectByIndex(n,!1),n>=0?this.btnWrapType.setIconCls(this.btnWrapType.menu.viewData[n].iconcls):this.btnWrapType.setIconCls(""),this._noApply=!1,this._state.WrappingStyle=t}t=e.get_CanBeFlow();var r=e.get_FromGroup();if(this._state.CanBeFlow!==t||this._state.FromGroup!==r)this.btnWrapType.setDisabled(!t||r),this._state.CanBeFlow=t,this._state.FromGroup=r;this.SuspendEvents(),t=e.get_Width(),Math.abs(this._state.Width-t)>.001&&(this.labelWidth.setText(this.textWidth+": "+Ext.util.Format.round(Common.MetricSettings.fnRecalcFromMM(t),1)+" "+Common.MetricSettings.metricName[Common.MetricSettings.getCurrentMetric()]),this._state.Width=t),t=e.get_Height(),Math.abs(this._state.Height-t)>.001&&(this.labelHeight.setText(this.textHeight+": "+Ext.util.Format.round(Common.MetricSettings.fnRecalcFromMM(t),1)+" "+Common.MetricSettings.metricName[Common.MetricSettings.getCurrentMetric()]),this._state.Height=t),this._btnOriginalSize.setDisabled(e.get_ImageUrl()===null||e.get_ImageUrl()===undefined),this.ResumeEvents()}},_ImgWrapStyleChanged:function(e){if(this._state.WrappingStyle!==e){this._noApply=!0;var t=this.btnWrapType.menu.picker.store.find("data",e);this.btnWrapType.menu.picker.selectByIndex(t,!1),t>=0&&this.btnWrapType.setIconCls(this.btnWrapType.menu.viewData[t].iconcls),this._state.WrappingStyle=e,this._noApply=!1}},_onOpenImageFromURL:function(e){var t=this[0],n=this[1].txtUrl;if(e==1&&t.api){var r=n.value.replace(/ /g,"");if(r!=""){var i=new CImgProperty;i.put_ImageUrl(n.value),t.api.ImgApply(i)}}},_openAdvancedSettings:function(e){var t=this,n;if(t.api){var r=t.api.getSelectedElements();if(r&&Ext.isArray(r)){var i,s;for(var o=r.length-1;o>=0;o--){i=r[o].get_ObjectType(),s=r[o].get_ObjectValue();if(c_oAscTypeSelectElement.Image==i){n=Ext.create("DE.view.ImageSettingsAdvanced",{}),n.updateMetricUnit(),n.setSettings(s);break}}}}if(n){var u;this._btnOriginalSize.isDisabled()||(u=this.api.get_OriginalSizeImage(),u&&n.setSizeOriginal({width:u.get_ImageWidth(),height:u.get_ImageHeight()})),u=this.api.GetSectionInfo(),n.setSizeMax({width:u.get_PageWidth()-(u.get_MarginLeft()+u.get_MarginRight()),height:u.get_PageHeight()-(u.get_MarginTop()+u.get_MarginBottom())}),n.addListener("onmodalresult",Ext.bind(function(e,n,r){n==1&&r&&t.api.ImgApply(r)},this),!1),n.addListener("close",function(){t.fireEvent("editcomplete",t)},!1),n.show()}},updateMetricUnit:function(){var e=Common.MetricSettings.fnRecalcFromMM(this._state.Width);this.labelWidth.setText(this.textWidth+": "+Ext.util.Format.round(e,1)+" "+Common.MetricSettings.metricName[Common.MetricSettings.getCurrentMetric()]),e=Common.MetricSettings.fnRecalcFromMM(this._state.Height),this.labelHeight.setText(this.textHeight+": "+Ext.util.Format.round(e,1)+" "+Common.MetricSettings.metricName[Common.MetricSettings.getCurrentMetric()])},createDelayedElements:function(){this.updateMetricUnit()},textSize:"Size",textWrap:"Wraping Style",textKeepRatio:"Constant Proportions",textWidth:"Width",textHeight:"Height",textOriginalSize:"Default Size",textApply:"Apply",textUrl:"Image URL",textInsert:"Insert Image",textUndock:"Undock from panel",textFromUrl:"From URL",textFromFile:"From File",textAdvanced:"Show advanced settings",txtTitle:"Picture",txtInline:"Inline",txtSquare:"Square",txtTight:"Tight",txtThrough:"Through",txtTopAndBottom:"Top and bottom",txtBehind:"Behind",txtInFront:"In front"}),Ext.define("DE.view.HeaderFooterSettings",{extend:"Common.view.AbstractSettingsPanel",alias:"widget.deheaderfootersettings",height:298,requires:["Ext.button.Button","Ext.form.Label","Ext.form.field.Checkbox","Ext.container.Container","Ext.toolbar.Spacer","Common.component.MetricSpinner"],constructor:function(e){return this.callParent(arguments),this.initConfig(e),this},initComponent:function(){this.title=this.txtTitle,this._initSettings=!0,this._state={PositionType:c_pageNumPosition.PAGE_NUM_POSITION_TOP,Position:12.5,DiffFirst:!1,DiffOdd:!1};var e=[[c_pageNumPosition.PAGE_NUM_POSITION_TOP,c_pageNumPosition.PAGE_NUM_POSITION_LEFT,"asc-right-panel-btn btn-colontitul-tl","headerfooter-button-top-left",this.textTopLeft],[c_pageNumPosition.PAGE_NUM_POSITION_TOP,c_pageNumPosition.PAGE_NUM_POSITION_CENTER,"asc-right-panel-btn btn-colontitul-tc","headerfooter-button-top-center",this.textTopCenter],[c_pageNumPosition.PAGE_NUM_POSITION_TOP,c_pageNumPosition.PAGE_NUM_POSITION_RIGHT,"asc-right-panel-btn btn-colontitul-tr","headerfooter-button-top-right",this.textTopRight],[c_pageNumPosition.PAGE_NUM_POSITION_BOTTOM,c_pageNumPosition.PAGE_NUM_POSITION_LEFT,"asc-right-panel-btn btn-colontitul-bl","headerfooter-button-bottom-left",this.textBottomLeft],[c_pageNumPosition.PAGE_NUM_POSITION_BOTTOM,c_pageNumPosition.PAGE_NUM_POSITION_CENTER,"asc-right-panel-btn btn-colontitul-bc","headerfooter-button-bottom-center",this.textBottomCenter],[c_pageNumPosition.PAGE_NUM_POSITION_BOTTOM,c_pageNumPosition.PAGE_NUM_POSITION_RIGHT,"asc-right-panel-btn btn-colontitul-br","headerfooter-button-bottom-right",this.textBottomRight]];this._btnsPosition=[],Ext.Array.forEach(e,function(e){var t=Ext.create("Ext.Button",{id:e[3],cls:e[2],posWhere:e[0],posAlign:e[1],margin:"2px 12px 2px 0",text:"",tooltip:e[4],listeners:{click:Ext.bind(function(e){this.api&&this.api.put_PageNum(e.posWhere,e.posAlign),this.fireEvent("editcomplete",this)},this)}});this._btnsPosition.push(t)},this),this._numPosition=Ext.create("Common.component.MetricSpinner",{id:"headerfooter-spin-position",readOnly:!1,step:.1,width:85,defaultUnit:"cm",value:"1.25 cm",maxValue:55.88,minValue:0,listeners:{change:Ext.bind(function(e,t,n,r){this.api&&this.api.put_HeadersAndFootersDistance(Common.MetricSettings.fnRecalcToMM(e.getNumberValue())),this.fireEvent("editcomplete",this)},this)}}),this.controls.push(this._numPosition),this._lblPosition=Ext.create("Ext.form.Label",{text:this.textHeaderFromTop,width:150,height:14,style:"text-align:left"}),this._chDiffFirst=Ext.create("Ext.form.field.Checkbox",{id:"headerfooter-check-diff-first",boxLabel:this.textDiffFirst,listeners:{change:Ext.bind(function(e,t,n,r){this.api&&this.api.HeadersAndFooters_DifferentFirstPage(e.getValue()),this.fireEvent("editcomplete",this)},this)}}),this.controls.push(this._chDiffFirst),this._chDiffOdd=Ext.create("Ext.form.field.Checkbox",{id:"headerfooter-check-diff-odd",boxLabel:this.textDiffOdd,listeners:{change:Ext.bind(function(e,t,n,r){this.api&&this.api.HeadersAndFooters_DifferentOddandEvenPage(e.getValue()),this.fireEvent("editcomplete",this)},this)}}),this.controls.push(this._chDiffOdd),this._PageNumPanel=Ext.create("Ext.container.Container",{layout:"vbox",layoutConfig:{align:"stretch"},height:103,width:"100%",items:[{xtype:"tbspacer",height:9},{xtype:"container",layout:{type:"table",columns:3},items:[this._btnsPosition[0],this._btnsPosition[1],this._btnsPosition[2],{xtype:"tbspacer",height:11},{xtype:"tbspacer",height:11},{xtype:"tbspacer",height:11},this._btnsPosition[3],this._btnsPosition[4],this._btnsPosition[5]]}]}),this._PositionPanel=Ext.create("Ext.container.Container",{layout:"vbox",layoutConfig:{align:"stretch"},height:50,width:195,items:[{xtype:"tbspacer",height:8},{xtype:"container",height:40,layout:"vbox",layoutConfig:{align:"stretch"},style:"float:left;",items:[this._lblPosition,{xtype:"tbspacer",height:3},this._numPosition]}]}),this._OptionsPanel=Ext.create("Ext.container.Container",{layout:"vbox",layoutConfig:{align:"stretch"},height:53,width:"100%",items:[{xtype:"tbspacer",height:6},this._chDiffFirst,this._chDiffOdd]}),this.items=[{xtype:"tbspacer",height:9},{xtype:"label",style:"font-weight: bold;margin-top: 1px;",text:this.textPageNum},this._PageNumPanel,{xtype:"tbspacer",height:5},{xtype:"tbspacer",width:"100%",height:10,style:"padding-right: 10px;",html:'<div style="width: 100%; height: 40%; border-bottom: 1px solid #C7C7C7"></div>'},{xtype:"label",style:"font-weight: bold;margin-top: 1px;",text:this.textPosition},this._PositionPanel,{xtype:"tbspacer",height:5},{xtype:"tbspacer",width:"100%",height:10,style:"padding-right: 10px;",html:'<div style="width: 100%; height: 40%; border-bottom: 1px solid #C7C7C7"></div>'},{xtype:"label",style:"font-weight: bold;margin-top: 1px;",text:this.textOptions},this._OptionsPanel,{xtype:"tbspacer",height:7}],this.callParent(arguments)},setApi:function(e){this.api=e},updateMetricUnit:function(){var e=this.query("commonmetricspinner");if(e)for(var t=0;t<e.length;t++){var n=e[t];n.setDefaultUnit(Common.MetricSettings.metricName[Common.MetricSettings.getCurrentMetric()]),n.setStep(Common.MetricSettings.getCurrentMetric()==Common.MetricSettings.c_MetricUnits.cm?.01:1)}},ChangeSettings:function(e){this._initSettings&&(this.createDelayedElements(),this._initSettings=!1);if(e){this.SuspendEvents();var t=e.get_Type();this._state.PositionType!==t&&(t==c_pageNumPosition.PAGE_NUM_POSITION_BOTTOM?this._lblPosition.setText(this.textHeaderFromBottom):this._lblPosition.setText(this.textHeaderFromTop),this._state.PositionType=t),t=e.get_Position(),Math.abs(this._state.Position-t)>.001&&(this._numPosition.setValue(Common.MetricSettings.fnRecalcFromMM(t)),this._state.Position=t),t=e.get_DifferentFirst(),this._state.DiffFirst!==t&&(this._chDiffFirst.setValue(t),this._state.DiffFirst=t),t=e.get_DifferentEvenOdd(),this._state.DiffOdd!==t&&(this._chDiffOdd.setValue(t),this._state.DiffOdd=t),this.ResumeEvents()}},createDelayedElements:function(){this.updateMetricUnit()},textHeaderFromTop:"Header from Top",textHeaderFromBottom:"Header from Bottom",textPosition:"Position",textOptions:"Options",textDiffFirst:"Different First Page",textDiffOdd:"Different Odd and even Pages",textPageNum:"Insert Page Number",textTopLeft:"Top Left",textTopRight:"Top Right",textTopCenter:"Top Center",textBottomLeft:"Bottom Left",textBottomRight:"Bottom Right",textBottomCenter:"Bottom Center",textUndock:"Undock from panel",txtTitle:"Header and Footer"}),Ext.define("DE.view.ParagraphSettings",{extend:"Common.view.AbstractSettingsPanel",alias:"widget.deparagraphsettings",height:261,requires:["Ext.DomHelper","Ext.button.Button","Ext.form.field.Number","Ext.form.Label","Ext.container.Container","Ext.toolbar.Spacer","Common.component.MetricSpinner","Common.component.IndeterminateCheckBox","Ext.form.field.ComboBox","DE.view.ParagraphSettingsAdvanced","Common.component.ThemeColorPalette"],constructor:function(e){return this.callParent(arguments),this.initConfig(e),this},setApi:function(e){this.api=e,e&&this.api.asc_registerCallback("asc_onParaSpacingLine",Ext.bind(this._onLineSpacing,this))},initComponent:function(){this.title=this.txtTitle,this._initSettings=!0,this._state={LineRuleIdx:1,LineHeight:1.5,LineSpacingBefore:0,LineSpacingAfter:.35,AddInterval:!1,BackColor:"#000000"},this.ThemeValues=[6,15,7,16,0,1,2,3,4,5],this._arrLineRule=[this.textAtLeast,this.textAuto,this.textExact],this._arrLineDefaults=[[5,"cm",.03,.01],[1,"",.5,.01],[5,"cm",.03,.01]],this.cmbLineRule=Ext.create("Ext.form.field.ComboBox",{id:"table-combo-line-rule",width:85,editable:!1,store:this._arrLineRule,mode:"local",triggerAction:"all",listeners:{select:Ext.bind(function(e,t,n){this.api&&this.api.put_PrLineSpacing(t[0].index,this._arrLineDefaults[t[0].index][0]),this.numLineHeight.setDefaultUnit(this._arrLineDefaults[t[0].index][1]),this.numLineHeight.setMinValue(this._arrLineDefaults[t[0].index][2]),this.numLineHeight.setStep(this._arrLineDefaults[t[0].index][3]),this.fireEvent("editcomplete",this)},this)}}),this.cmbLineRule.setValue(this._arrLineRule[1]),this.controls.push(this.cmbLineRule),this.numLineHeight=Ext.widget("commonmetricspinner",{id:"paragraph-spin-line-height",readOnly:!1,step:.01,width:85,value:"1.5",defaultUnit:"",maxValue:132,minValue:.5,listeners:{change:Ext.bind(function(e,t,n,r){if(this.cmbLineRule.getValue()=="")return;var i=c_paragraphLinerule.LINERULE_AUTO;for(var s=0;s<this._arrLineRule.length;s++)if(this.cmbLineRule.getValue()==this._arrLineRule[s]){i=s;break}this.api&&this.api.put_PrLineSpacing(i,i==c_paragraphLinerule.LINERULE_AUTO?e.getNumberValue():Common.MetricSettings.fnRecalcToMM(e.getNumberValue())),this.fireEvent("editcomplete",this)},this)}}),this.controls.push(this.numLineHeight),this.numSpacingBefore=Ext.create("Common.component.MetricSpinner",{id:"paragraph-spin-spacing-before",readOnly:!1,step:.1,width:85,defaultUnit:"cm",value:"0 cm",maxValue:55.88,minValue:0,allowAuto:!0,autoText:this.txtAutoText,listeners:{change:Ext.bind(function(e,t,n,r){if(this.api){var i=e.getNumberValue();i<0?this.api.put_LineSpacingBeforeAfter(0,-1):this.api.put_LineSpacingBeforeAfter(0,Common.MetricSettings.fnRecalcToMM(e.getNumberValue()))}this.fireEvent("editcomplete",this)},this)}}),this.controls.push(this.numSpacingBefore),this.numSpacingAfter=Ext.create("Common.component.MetricSpinner",{id:"paragraph-spin-spacing-after",readOnly:!1,step:.1,width:85,defaultUnit:"cm",value:"0.35 cm",maxValue:55.88,minValue:0,allowAuto:!0,autoText:this.txtAutoText,listeners:{change:Ext.bind(function(e,t,n,r){if(this.api){var i=e.getNumberValue();i<0?this.api.put_LineSpacingBeforeAfter(1,-1):this.api.put_LineSpacingBeforeAfter(1,Common.MetricSettings.fnRecalcToMM(e.getNumberValue()))}this.fireEvent("editcomplete",this)},this)}}),this.controls.push(this.numSpacingAfter),this.chAddInterval=Ext.create("Common.component.IndeterminateCheckBox",{id:"paragraph-checkbox-add-interval",listeners:{change:Ext.bind(function(e,t,n,r){this.api&&this.api.put_AddSpaceBetweenPrg(e.getValue()=="checked"),this.fireEvent("editcomplete",this)},this)}}),this.controls.push(this.chAddInterval),this._SpacingPanel=Ext.create("Ext.container.Container",{layout:"vbox",layoutConfig:{align:"stretch"},height:139,width:190,items:[{xtype:"tbspacer",height:8},{xtype:"container",height:41,layout:{type:"table",columns:2,tdAttrs:{style:"padding-right: 8px;vertical-align: middle;"}},items:[{xtype:"label",text:this.strLineHeight,style:"display: block;",width:85},{xtype:"label",text:this.textAt,style:"display: block;",width:85},{xtype:"tbspacer",height:2},{xtype:"tbspacer",height:2},this.cmbLineRule,this.numLineHeight]},{xtype:"tbspacer",height:10},{xtype:"container",layout:{type:"table",columns:2,tdAttrs:{style:"padding-right: 8px;"}},defaults:{xtype:"container",layout:"vbox",layoutConfig:{align:"stretch"},height:48,style:"float:left;"},items:[{items:[{xtype:"label",text:this.strSpacingBefore,width:85},{xtype:"tbspacer",height:3},this.numSpacingBefore]},{items:[{xtype:"label",text:this.strSpacingAfter,width:85},{xtype:"tbspacer",height:3},this.numSpacingAfter]}]},{xtype:"container",height:32,width:"100%",layout:"hbox",items:[this.chAddInterval,{xtype:"label",text:this.strSomeParagraphSpace,margin:"1px 0 0 4px",flex:1,listeners:{afterrender:Ext.bind(function(e){e.getEl().on("click",Ext.bind(function(){this.chAddInterval.setValue(this.chAddInterval.getValue()=="indeterminate"?!1:this.chAddInterval.getValue()!="checked")},this),this),e.getEl().on("dblclick",Ext.bind(function(){this.chAddInterval.setValue(this.chAddInterval.getValue()=="indeterminate"?!1:this.chAddInterval.getValue()!="checked")},this),this)},this)}},{xtype:"tbspacer",width:5}]}]}),this._btnBackColor=Ext.create("Ext.button.Button",{id:"paragraph-button-back-color",arrowCls:"",width:50,height:22,color:"transparent",menu:{showSeparator:!1,items:[this.colorsBack=Ext.create("Common.component.ThemeColorPalette",{value:"000000",width:165,height:214,dynamiccolors:!0,dyncolorscount:10,colors:[this.textThemeColors,"-",{color:"3366FF",effectId:1},{color:"0000FF",effectId:2},{color:"000090",effectId:3},{color:"660066",effectId:4},{color:"800000",effectId:5},{color:"FF0000",effectId:1},{color:"FF6600",effectId:1},{color:"FFFF00",effectId:2},{color:"CCFFCC",effectId:3},{color:"008000",effectId:4},"-",{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},{color:"000000",effectId:5},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},"-","--","-",this.textStandartColors,"-","transparent","5301B3","980ABD","B2275F","F83D26","F86A1D","F7AC16","F7CA12","FAFF44","D6EF39","-","--"],listeners:{select:{fn:function(e,t,n,r){Ext.menu.Manager.hideAll();var i,s;this._btnBackColor.color=t,t=="transparent"?(i="transparent",s="1px solid #BEBEBE"):(i=Ext.String.format("#{0}",typeof t=="object"?t.color:t),s="none"),this._btnBackColor.btnEl&&Ext.DomHelper.applyStyles(this._btnBackColor.btnEl,{"background-color":i,border:s}),this.BackColor=this._btnBackColor.color,this.api&&(t=="transparent"?this.api.put_ParagraphShade(!1):this.api.put_ParagraphShade(!0,this.getRgbColor(t))),this.fireEvent("editcomplete",this)},scope:this}}}),{cls:"menu-item-noicon menu-item-color-palette-theme",text:this.textNewColor,listeners:{click:Ext.bind(function(e,t){this.colorsBack.addNewColor()},this)}}]},listeners:{render:function(e){var t,n;e.color=="transparent"?(t="1px solid #BEBEBE",n=e.color):(t="none",n=Ext.String.format("#{0}",typeof e.color=="object"?e.color.color:e.color)),Ext.DomHelper.applyStyles(e.btnEl,{"background-color":n,border:t})}},setColor:function(e){var t,n;this.color=e,e=="transparent"?(t="1px solid #BEBEBE",n=e):(t="none",n=Ext.String.format("#{0}",typeof e=="object"?e.color:e)),this.btnEl!==undefined&&Ext.DomHelper.applyStyles(this.btnEl,{"background-color":n,border:t})}}),this.controls.push(this.colorsBack),this._ColorContainer=Ext.create("Ext.container.Container",{height:25,width:195,layout:"hbox",items:[this._btnBackColor,{xtype:"tbspacer",width:5},{xtype:"label",text:this.textBackColor,margin:"2px 0 0 0",flex:1},{xtype:"tbspacer",width:5}]}),this.items=[{xtype:"tbspacer",height:9},{xtype:"label",style:"font-weight: bold;margin-top: 1px;",text:this.strParagraphSpacing},this._SpacingPanel,{xtype:"tbspacer",height:7},{xtype:"tbspacer",width:"100%",height:10,style:"padding-right: 10px;",html:'<div style="width: 100%; height: 40%; border-bottom: 1px solid #C7C7C7"></div>'},{xtype:"tbspacer",height:3},this._ColorContainer,{xtype:"tbspacer",height:10},{xtype:"tbspacer",width:"100%",height:10,style:"padding-right: 10px;",html:'<div style="width: 100%; height: 40%; border-bottom: 1px solid #C7C7C7"></div>'},{xtype:"tbspacer",height:3},{xtype:"container",height:20,width:"100%",items:[{xtype:"box",html:'<div style="width:100%;text-align:center;padding-right:15px;"><label id="paragraph-advanced-link" class="asc-advanced-link">'+this.textAdvanced+"</label></div>",listeners:{afterrender:function(e){document.getElementById("paragraph-advanced-link").onclick=Ext.bind(this._openAdvancedSettings,this)},scope:this}}]}],this.addEvents("editcomplete"),this.callParent(arguments)},getHexColor:function(e,t,n){return e=e.toString(16),t=t.toString(16),n=n.toString(16),e.length==1&&(e="0"+e),t.length==1&&(t="0"+t),n.length==1&&(n="0"+n),e+t+n},getRgbColor:function(e){var t=typeof e=="object"?e.color:e;t=t.replace(/#/,""),t.length==3&&(t=t.replace(/(.)/g,"$1$1")),t=parseInt(t,16);var n=new CAscColor;return n.put_type(typeof e=="object"?c_oAscColor.COLOR_TYPE_SCHEME:c_oAscColor.COLOR_TYPE_SRGB),n.put_r(t>>16),n.put_g((t&65280)>>8),n.put_b(t&255),n.put_a(255),e.effectId!==undefined&&n.put_value(e.effectId),n},_onLineSpacing:function(e){var t=e.get_LineRule(),n=e.get_Line();this.numLineHeight.suspendEvents(!1),this.cmbLineRule.suspendEvents(!1),this._state.LineRuleIdx!==t&&(this.cmbLineRule.setValue(t!==null?this._arrLineRule[t]:""),this.numLineHeight.setMinValue(this._arrLineDefaults[t!==null?t:1][2]),this.numLineHeight.setDefaultUnit(this._arrLineDefaults[t!==null?t:1][1]),this.numLineHeight.setStep(this._arrLineDefaults[t!==null?t:1][3]),this._state.LineRuleIdx=t);if(Math.abs(this._state.LineHeight-n)>.001||(this._state.LineHeight===null||n===null)&&this._state.LineHeight!==n){var r="";t==c_paragraphLinerule.LINERULE_AUTO?r=n:t!==null&&n!==null&&(r=Common.MetricSettings.fnRecalcFromMM(n)),this.numLineHeight.setValue(r!==null?r:""),this._state.LineHeight=n}this.numLineHeight.resumeEvents(),this.cmbLineRule.resumeEvents()},ChangeSettings:function(e){this._initSettings&&(this.createDelayedElements(),this._initSettings=!1);if(e){this.SuspendEvents();var t={Line:e.get_Spacing().get_Line(),Before:e.get_Spacing().get_Before(),After:e.get_Spacing().get_After(),LineRule:e.get_Spacing().get_LineRule()},n={ContextualSpacing:e.get_ContextualSpacing()};this._state.LineRuleIdx!==t.LineRule&&(this.cmbLineRule.setValue(t.LineRule!==null?this._arrLineRule[t.LineRule]:""),this.numLineHeight.setMinValue(this._arrLineDefaults[t.LineRule!==null?t.LineRule:1][2]),this.numLineHeight.setDefaultUnit(this._arrLineDefaults[t.LineRule!==null?t.LineRule:1][1]),this.numLineHeight.setStep(this._arrLineDefaults[t.LineRule!==null?t.LineRule:1][3]),this._state.LineRuleIdx=t.LineRule);if(Math.abs(this._state.LineHeight-t.Line)>.001||(this._state.LineHeight===null||t.Line===null)&&this._state.LineHeight!==t.Line){var r="";t.LineRule==c_paragraphLinerule.LINERULE_AUTO?r=t.Line:t.LineRule!==null&&t.Line!==null&&(r=Common.MetricSettings.fnRecalcFromMM(t.Line)),this.numLineHeight.setValue(r!==null?r:""),this._state.LineHeight=t.Line}if(Math.abs(this._state.LineSpacingBefore-t.Before)>.001||(this._state.LineSpacingBefore===null||t.Before===null)&&this._state.LineSpacingBefore!==t.Before)this.numSpacingBefore.setValue(t.Before!==null?t.Before<0?t.Before:Common.MetricSettings.fnRecalcFromMM(t.Before):""),this._state.LineSpacingBefore=t.Before;if(Math.abs(this._state.LineSpacingAfter-t.After)>.001||(this._state.LineSpacingAfter===null||t.After===null)&&this._state.LineSpacingAfter!==t.After)this.numSpacingAfter.setValue(t.After!==null?t.After<0?t.After:Common.MetricSettings.fnRecalcFromMM(t.After):""),this._state.LineSpacingAfter=t.After;this._state.AddInterval!==n.ContextualSpacing&&(this.chAddInterval.setValue(n.ContextualSpacing!==null&&n.ContextualSpacing!==undefined?n.ContextualSpacing:"indeterminate"),this._state.AddInterval=n.ContextualSpacing);var i=e.get_Shade();if(i!==null&&i!==undefined&&i.get_Value()===shd_Clear){var s=i.get_Color();s?s.get_type()==c_oAscColor.COLOR_TYPE_SCHEME?this.BackColor={color:this.getHexColor(s.get_r(),s.get_g(),s.get_b()),effectValue:s.get_value()}:this.BackColor=this.getHexColor(s.get_r(),s.get_g(),s.get_b()):this.BackColor="transparent"}else this.BackColor="transparent";var o=typeof this.BackColor,u=typeof this._state.BackColor;if(o!==u||o=="object"&&(this.BackColor.effectValue!==this._state.BackColor.effectValue||this._state.BackColor.color.indexOf(this.BackColor.color)<0)||o!="object"&&this._state.BackColor.indexOf(this.BackColor)<0){this._btnBackColor.setColor(this.BackColor);if(typeof this.BackColor=="object"){for(var a=0;a<10;a++)if(this.ThemeValues[a]==this.BackColor.effectValue){this.colorsBack.select(this.BackColor,!1);break}}else this.colorsBack.select(this.BackColor,!1);this._state.BackColor=this.BackColor}this.ResumeEvents()}},_openAdvancedSettings:function(e){var t=this,n;if(t.api){var r=t.api.getSelectedElements();if(r&&Ext.isArray(r)){var i,s;for(var o=r.length-1;o>=0;o--){i=r[o].get_ObjectType(),s=r[o].get_ObjectValue();if(c_oAscTypeSelectElement.Paragraph==i){var u={tableStylerRows:2,tableStylerColumns:1};n=Ext.create("DE.view.ParagraphSettingsAdvanced",u),n.updateMetricUnit(),n.setSettings({paragraphProps:s,borderProps:t.borderAdvancedProps,api:t.api,colorProps:[t.effectcolors,t.standartcolors]});break}}}}n&&(n.addListener("onmodalresult",Ext.bind(function(e,n,r){n==1&&r&&(t.borderAdvancedProps=r.borderProps,t.api.paraApply(r.paragraphProps))},this),!1),n.addListener("close",function(){t.fireEvent("editcomplete",t)},!1),n.show())},SendThemeColors:function(e,t){this.effectcolors=e,t&&t.length>0&&(this.standartcolors=t),this.colorsBack.updateColors(e,t)},updateMetricUnit:function(){var e=this.query("commonmetricspinner");if(e)for(var t=0;t<e.length;t++){var n=e[t];if(n.id=="paragraph-spin-line-height")continue;n.setDefaultUnit(Common.MetricSettings.metricName[Common.MetricSettings.getCurrentMetric()]),n.setStep(Common.MetricSettings.getCurrentMetric()==Common.MetricSettings.c_MetricUnits.cm?.01:1)}this._arrLineDefaults[2][1]=this._arrLineDefaults[0][1]=Common.MetricSettings.metricName[Common.MetricSettings.getCurrentMetric()],this._arrLineDefaults[2][2]=this._arrLineDefaults[0][2]=parseFloat(Common.MetricSettings.fnRecalcFromMM(.3).toFixed(2)),this._arrLineDefaults[2][3]=this._arrLineDefaults[0][3]=Common.MetricSettings.getCurrentMetric()==Common.MetricSettings.c_MetricUnits.cm?.01:1,this._state.LineRuleIdx!==null&&(this.numLineHeight.setDefaultUnit(this._arrLineDefaults[this._state.LineRuleIdx][1]),this.numLineHeight.setStep(this._arrLineDefaults[this._state.LineRuleIdx][3]))},createDelayedElements:function(){this.updateMetricUnit()},strParagraphSpacing:"Spacing",strSomeParagraphSpace:"Don't add interval between paragraphs of the same style",strLineHeight:"Line Spacing",strSpacingBefore:"Before",strSpacingAfter:"After",textUndock:"Undock from panel",textAuto:"Multiple",textAtLeast:"At least",textExact:"Exactly",textAdvanced:"Show advanced settings",textAt:"At",txtTitle:"Paragraph",txtAutoText:"Auto",textThemeColors:"Theme Colors",textStandartColors:"Standart Colors",textBackColor:"Background color",textNewColor:"Add New Custom Color"}),Ext.define("DE.model.ModelBorders",{extend:"Ext.data.Model",fields:[{type:"string",name:"borderstyle"},{type:"string",name:"text"},{type:"string",name:"url"},{type:"float",name:"value"},{type:"int",name:"imagewidth"},{type:"int",name:"imageheight"}]}),Ext.define("DE.view.TableSettings",{extend:"Common.view.AbstractSettingsPanel",alias:"widget.detablesettings",height:612,requires:["Common.component.ThemeColorPalette","Ext.button.Button","Ext.form.Label","Ext.form.field.ComboBox","Ext.container.Container","Ext.toolbar.Spacer","Ext.Array","Ext.menu.Menu","Ext.menu.Manager","DE.view.InsertTableDialog","Ext.data.Model","Ext.data.Store","Ext.XTemplate","DE.view.TableSettingsAdvanced","Common.component.ComboDataView","Common.plugin.ComboBoxScrollPane"],constructor:function(e){return this.callParent(arguments),this.initConfig(e),this},initComponent:function(){this.title=this.txtTitle,this._initedSettings=!1,this._state={TemplateId:0,CheckHeader:!1,CheckTotal:!1,CheckBanded:!1,CheckFirst:!1,CheckLast:!1,CheckColBanded:!1,WrapStyle:-1,CanBeFlow:!0,TableAlignment:-1,TableIndent:0,BackColor:"#000000",RepeatRow:!1},this._originalLook=new CTablePropLook;var e=this,t=218;this._originalProps=null,this.CellBorders={},this.CellColor={Value:1,Color:"transparent"},this.BorderSize=0,this._noApply=!1,this.ThemeValues=[6,15,7,16,0,1,2,3,4,5];var n=!1;this._cmbTableTemplate=Ext.create("Common.component.ComboDataView",{id:"table-combo-template",width:185,height:64,itemWidth:70,itemHeight:50,menuMaxHeight:300,repeatedselect:!0,viewData:[],emptyComboText:this.textEmptyTemplate,listeners:{select:function(t,n){if(e.api&&!e._noApply){var r=new CTableProp;r.put_TableStyle(n.data.data.templateId),e.api.tblApply(r)}e.fireEvent("editcomplete",e)},menuhide:function(){e.fireEvent("editcomplete",e)},releasecapture:function(t){e.fireEvent("editcomplete",e)}}}),this.controls.push(this._cmbTableTemplate),this._chHeader=Ext.create("Ext.form.field.Checkbox",{id:"table-checkbox-header",boxLabel:this.textHeader,checked:!1,width:85,listeners:{change:Ext.bind(function(t,n,r,i){if(e.api){var s=new CTableProp,o=e._originalLook?e._originalLook:new CTablePropLook;o.put_FirstRow(n),s.put_TableLook(o),e.api.tblApply(s)}e.fireEvent("editcomplete",e)},e)}}),this.controls.push(this._chHeader),this._chTotal=Ext.create("Ext.form.field.Checkbox",{id:"table-checkbox-total",boxLabel:this.textTotal,checked:!1,width:85,listeners:{change:Ext.bind(function(t,n,r,i){if(e.api){var s=new CTableProp,o=e._originalLook?e._originalLook:new CTablePropLook;o.put_LastRow(n),s.put_TableLook(o),e.api.tblApply(s)}e.fireEvent("editcomplete",e)},e)}}),this.controls.push(this._chTotal),this._chBanded=Ext.create("Ext.form.field.Checkbox",{id:"table-checkbox-banded",boxLabel:this.textBanded,checked:!1,width:85,listeners:{change:Ext.bind(function(t,n,r,i){if(e.api){var s=new CTableProp,o=e._originalLook?e._originalLook:new CTablePropLook;o.put_BandHor(n),s.put_TableLook(o),e.api.tblApply(s)}e.fireEvent("editcomplete",e)},e)}}),this.controls.push(this._chBanded),this._chFirst=Ext.create("Ext.form.field.Checkbox",{id:"table-checkbox-first",boxLabel:this.textFirst,checked:!1,width:85,listeners:{change:Ext.bind(function(t,n,r,i){if(e.api){var s=new CTableProp,o=e._originalLook?e._originalLook:new CTablePropLook;o.put_FirstCol(n),s.put_TableLook(o),e.api.tblApply(s)}e.fireEvent("editcomplete",e)},e)}}),this.controls.push(this._chFirst),this._chLast=Ext.create("Ext.form.field.Checkbox",{id:"table-checkbox-last",boxLabel:this.textLast,checked:!1,width:85,listeners:{change:Ext.bind(function(t,n,r,i){if(e.api){var s=new CTableProp,o=e._originalLook?e._originalLook:new CTablePropLook;o.put_LastCol(n),s.put_TableLook(o),e.api.tblApply(s)}e.fireEvent("editcomplete",e)},e)}}),this.controls.push(this._chLast),this._chColBanded=Ext.create("Ext.form.field.Checkbox",{id:"table-checkbox-col-banded",boxLabel:this.textBanded,checked:!1,width:85,listeners:{change:Ext.bind(function(t,n,r,i){if(e.api){var s=new CTableProp,o=e._originalLook?e._originalLook:new CTablePropLook;o.put_BandVer(n),s.put_TableLook(o),e.api.tblApply(s)}e.fireEvent("editcomplete",e)},e)}}),this.controls.push(this._chColBanded),this._TemplatePanel=Ext.create("Ext.container.Container",{layout:"vbox",layoutConfig:{align:"stretch"},height:185,width:"100%",items:[{xtype:"container",height:86,layout:{type:"table",columns:2,tdAttrs:{style:"padding-right: 8px;vertical-align: middle;"}},items:[{xtype:"label",text:this.textRows,style:"display: block;font-weight: bold;",width:85},{xtype:"label",text:this.textColumns,style:"display: block;font-weight: bold;",width:85},{xtype:"tbspacer",height:4},{xtype:"tbspacer",height:4},this._chHeader,this._chFirst,this._chTotal,this._chLast,this._chBanded,this._chColBanded]},{xtype:"tbspacer",height:8},{xtype:"label",text:this.textTemplate,style:"font-weight: bold;margin-bottom: 8px;"},this._cmbTableTemplate]}),this._btnWrapNone=Ext.create("Ext.Button",{id:"table-button-wrap-none",cls:"asc-right-panel-btn btn-wrap-none",posId:c_tableWrap.TABLE_WRAP_NONE,margin:"2px 2px 2px 0",text:"",tooltip:this.textWrapNoneTooltip,enableToggle:!0,allowDepress:!1,toggleGroup:"tablewrapGroup",pressed:!0,toggleHandler:Ext.bind(function(e){if(this.api&&e.pressed&&!this._noApply){var t=new CTableProp;t.put_TableWrap(e.pressed?c_tableWrap.TABLE_WRAP_NONE:c_tableWrap.TABLE_WRAP_PARALLEL),this._state.TableAlignment<0&&(this._state.TableAlignment=c_tableAlign.TABLE_ALIGN_LEFT),t.put_TableAlignment(this._state.TableAlignment),t.put_TableIndent(this._state.TableIndent),t.put_CellSelect(!0),this.api.tblApply(t)}if(n){n=!1;return}n=!0,this.fireEvent("editcomplete",this)},this)}),this.controls.push(this._btnWrapNone),this._btnWrapParallel=Ext.create("Ext.Button",{id:"table-button-wrap-parallel",cls:"asc-right-panel-btn btn-wrap-parallel",posId:c_tableWrap.TABLE_WRAP_PARALLEL,margin:"2px",text:"",tooltip:this.textWrapParallelTooltip,enableToggle:!0,allowDepress:!1,toggleGroup:"tablewrapGroup",toggleHandler:Ext.bind(function(e){if(this.api&&e.pressed&&!this._noApply){var t=new CTableProp;t.put_TableWrap(e.pressed?c_tableWrap.TABLE_WRAP_PARALLEL:c_tableWrap.TABLE_WRAP_NONE),t.put_CellSelect(!0),this.api.tblApply(t)}if(n){n=!1;return}n=!0,this.fireEvent("editcomplete",this)},this)}),this.controls.push(this._btnWrapParallel);var r=[[c_tableBorder.BORDER_VERTICAL_LEFT,"l","asc-right-panel-small-btn btn-position-left","table-button-border-left",this.tipLeft],[c_tableBorder.BORDER_VERTICAL_CENTER,"c","asc-right-panel-small-btn btn-position-inner-vert","table-button-border-inner-vert",this.tipInnerVert],[c_tableBorder.BORDER_VERTICAL_RIGHT,"r","asc-right-panel-small-btn btn-position-right","table-button-border-right",this.tipRight],[c_tableBorder.BORDER_HORIZONTAL_TOP,"t","asc-right-panel-small-btn btn-position-top","table-button-border-top",this.tipTop],[c_tableBorder.BORDER_HORIZONTAL_CENTER,"m","asc-right-panel-small-btn btn-position-inner-hor","table-button-border-inner-hor",this.tipInnerHor],[c_tableBorder.BORDER_HORIZONTAL_BOTTOM,"b","asc-right-panel-small-btn btn-position-bottom","table-button-border-bottom",this.tipBottom],[c_tableBorder.BORDER_INNER,"cm","asc-right-panel-small-btn btn-position-inner","table-button-border-inner",this.tipInner],[c_tableBorder.BORDER_OUTER,"lrtb","asc-right-panel-small-btn btn-position-outer","table-button-border-outer",this.tipOuter],[c_tableBorder.BORDER_ALL,"lrtbcm","asc-right-panel-small-btn btn-position-all","table-button-border-all",this.tipAll],[c_tableBorder.BORDER_NONE,"","asc-right-panel-small-btn btn-position-none","table-button-border-none",this.tipNone]];this._btnsBorderPosition=[],Ext.Array.forEach(r,function(e,t){var n=Ext.create("Ext.Button",{id:e[3],cls:e[2],posId:e[0],strId:e[1],text:"",tooltip:e[4],enableToggle:!1,listeners:{click:Ext.bind(function(e,t){this._UpdateBordersStyle(e.strId,!0);if(this.api){var n=new CTableProp;n.put_CellBorders(this.CellBorders),n.put_CellSelect(!0),this.api.tblApply(n)}this.fireEvent("editcomplete",this)},this)}});this._btnsBorderPosition.push(n)},this);var i=[{borderstyle:"",text:this.txtNoBorders,value:0,offsety:0},{text:"0.5 pt",value:.5,offsety:0},{text:"1 pt",value:1,offsety:20},{text:"1.5 pt",value:1.5,offsety:40},{text:"2.25 pt",value:2.25,offsety:60},{text:"3 pt",value:3,offsety:80},{text:"4.5 pt",value:4.5,offsety:100},{text:"6 pt",value:6,offsety:120}];for(var s=1;s<i.length;s++)i[s].borderstyle=Ext.String.format("background:url({0}) 0 {1}px; width:69px; height:20px; margin-right:5px;","resources/img/right-panels/BorderSize.png",-i[s].offsety);var o=Ext.create("Ext.data.Store",{model:"DE.model.ModelBorders",data:i}),u=Ext.create("Ext.XTemplate",'<tpl for="."><span style="display: inline-block; margin-top: 3px; font-size: 11px; height: 17px;">{text}</span><img src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" align="right" style="{borderstyle}"></tpl>');this.cmbBorderSize=Ext.create("Ext.form.field.ComboBox",{width:93,height:21,editable:!1,queryMode:"local",matchFieldWidth:!1,displayField:"text",store:o,listConfig:{mode:"local",width:145,itemTpl:u},listeners:{select:Ext.bind(function(t,n,r){this.BorderSize=n[0].data.value;if(t.inputEl)if(n[0].data.value>0){t.inputEl.set({type:"image"}),t.inputEl.set({src:"data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw=="});var i=Ext.String.format("background:url({0}) no-repeat scroll 0 {1}px, url({2}) repeat scroll 0 0 white","resources/img/right-panels/BorderSize.png",-n[0].data.offsety,"resources/img/controls/text-bg.gif");Ext.DomHelper.applyStyles(t.inputEl,i)}else{var i=Ext.String.format("background: url({0}) repeat scroll 0 0 white","resources/img/controls/text-bg.gif");Ext.DomHelper.applyStyles(t.inputEl,i),t.inputEl.set({type:"text"}),t.inputEl.set({value:e.txtNoBorders}),t.onItemClick(t.picker,n[0])}},this),afterRender:function(){if(this.inputEl){Ext.DomHelper.applyStyles(this.inputEl,"padding-left:7px"),this.inputEl.set({type:"image"}),this.inputEl.set({src:"data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw=="});var e=Ext.String.format("background:url({0}) repeat scroll 0 {1}px, url({2}) repeat scroll 0 0 white","resources/img/right-panels/BorderSize.png",-20,"resources/img/controls/text-bg.gif");Ext.DomHelper.applyStyles(this.inputEl,e)}}},plugins:[{ptype:"comboboxscrollpane",pluginId:"scrollpane",settings:{enableKeyboardNavigation:!0}}]});var a=this.cmbBorderSize.getStore().getAt(2);this.cmbBorderSize.select(a),this.BorderSize=a.data.value,this._btnBorderColor=Ext.create("Ext.button.Button",{id:"table-button-border-color",arrowCls:"",width:45,height:22,color:"000000",menu:{showSeparator:!1,items:[this.borderColor=Ext.create("Common.component.ThemeColorPalette",{value:"000000",width:165,height:214,dynamiccolors:!0,dyncolorscount:10,colors:[this.textThemeColors,"-",{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},{color:"000000",effectId:5},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},"-",{color:"3D55FE",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},{color:"000000",effectId:5},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},"-","--","-",this.textStandartColors,"-","3D55FE","5301B3","980ABD","B2275F","F83D26","F86A1D","F7AC16","F7CA12","FAFF44","D6EF39","-","--"],listeners:{select:{fn:function(t,n,r,i){e._btnBorderColor.color=n,e._btnBorderColor.btnEl&&Ext.DomHelper.applyStyles(e._btnBorderColor.btnEl,{"background-color":Ext.String.format("#{0}",typeof n=="object"?n.color:n)}),Ext.menu.Manager.hideAll()}}}}),{cls:"menu-item-noicon menu-item-color-palette-theme",text:this.textNewColor,listeners:{click:function(t,n){e.borderColor.addNewColor()}}}]},listeners:{render:function(e){var t=Ext.String.format("background-color:#{0}",typeof e.color=="object"?e.color.color:e.color);Ext.DomHelper.applyStyles(e.btnEl,t)}},setColor:function(e){var t,n;this.color=e,e=="transparent"||e.color=="transparent"?(t="1px solid #BEBEBE",n=e):(t="none",n=Ext.String.format("#{0}",typeof e=="object"?e.color:e)),this.btnEl!==undefined&&Ext.DomHelper.applyStyles(this.btnEl,{"background-color":n,border:t})}}),this._btnBackColor=Ext.create("Ext.button.Button",{id:"table-button-back-color",arrowCls:"",width:45,height:22,color:"transparent",menu:{showSeparator:!1,items:[this.colorsBack=Ext.create("Common.component.ThemeColorPalette",{value:"000000",width:165,height:214,dynamiccolors:!0,dyncolorscount:10,colors:[this.textThemeColors,"-",{color:"3366FF",effectId:1},{color:"0000FF",effectId:2},{color:"000090",effectId:3},{color:"660066",effectId:4},{color:"800000",effectId:5},{color:"FF0000",effectId:1},{color:"FF6600",effectId:1},{color:"FFFF00",effectId:2},{color:"CCFFCC",effectId:3},{color:"008000",effectId:4},"-",{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},{color:"000000",effectId:5},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},"-","--","-",this.textStandartColors,"-","transparent","5301B3","980ABD","B2275F","F83D26","F86A1D","F7AC16","F7CA12","FAFF44","D6EF39","-","--"],listeners:{select:{fn:function(t,n,r,i){Ext.menu.Manager.hideAll();var s,o;n=="transparent"?(e._btnBackColor.color="transparent",s="transparent",o="1px solid #BEBEBE"):(e._btnBackColor.color=n,s=Ext.String.format("#{0}",typeof n=="object"?n.color:n),o="none"),e._btnBackColor.btnEl&&Ext.DomHelper.applyStyles(e._btnBackColor.btnEl,{"background-color":s,border:o}),e.CellColor={Value:1,Color:e._btnBackColor.color};if(e.api){var u=new CTableProp,a=new CBackground;u.put_CellsBackground(a),e.CellColor.Color=="transparent"?a.put_Value(1):(a.put_Value(0),a.put_Color(e.getRgbColor(e.CellColor.Color))),u.put_CellSelect(!0),e.api.tblApply(u)}e.fireEvent("editcomplete",e)}}}}),{cls:"menu-item-noicon menu-item-color-palette-theme",text:e.textNewColor,listeners:{click:function(t,n){e.colorsBack.addNewColor()}}}]},listeners:{render:function(e){var t,n;e.color=="transparent"?(t="1px solid #BEBEBE",n=e.color):(t="none",n=Ext.String.format("#{0}",typeof e.color=="object"?e.color.color:e.color)),Ext.DomHelper.applyStyles(e.btnEl,{"background-color":n,border:t})}},setColor:function(e){var t,n;this.color=e,e=="transparent"?(t="1px solid #BEBEBE",n=e):(t="none",n=Ext.String.format("#{0}",typeof e=="object"?e.color:e)),this.btnEl!==undefined&&Ext.DomHelper.applyStyles(this.btnEl,{"background-color":n,border:t})}}),this.controls.push(this.colorsBack),this.chRepeatRow=Ext.create("Common.component.IndeterminateCheckBox",{id:"table-checkbox-repeat-row",listeners:{change:Ext.bind(function(e,t,n,r){if(this.api){var i=new CTableProp;i.put_RowsInHeader(e.getValue()=="checked"?1:0),this.api.tblApply(i)}this.fireEvent("editcomplete",this)},this)}}),this.controls.push(this.chRepeatRow),this._WrapPanel=Ext.create("Ext.container.Container",{layout:"vbox",layoutConfig:{align:"stretch"},height:49,width:"100%",items:[{xtype:"tbspacer",height:5},{xtype:"container",height:43,width:"100%",layout:"hbox",items:[this._btnWrapNone,{xtype:"tbspacer",width:3},this._btnWrapParallel]}]}),this._BordersPanel=Ext.create("Ext.container.Container",{layout:"vbox",layoutConfig:{align:"stretch"},height:167,width:"100%",items:[{xtype:"tbspacer",height:8},{xtype:"container",layout:{type:"hbox",align:"middle"},height:26,width:190,style:"vertical-align: middle;",items:[this.cmbBorderSize,{xtype:"tbspacer",flex:1},{xtype:"label",text:this.textBorderColor},{xtype:"tbspacer",width:7},this._btnBorderColor,{xtype:"tbspacer",width:5}]},{xtype:"tbspacer",height:8},{xtype:"container",height:30,width:190,layout:"hbox",items:[{xtype:"label",height:30,flex:1,text:this.textSelectBorders},{xtype:"tbspacer",width:5}]},{xtype:"tbspacer",height:8},{xtype:"container",layout:{type:"hbox",align:"middle"},width:190,items:[this._btnsBorderPosition[8],this._btnsBorderPosition[9],this._btnsBorderPosition[6],this._btnsBorderPosition[7],{xtype:"tbspacer",flex:1}]},{xtype:"tbspacer",height:8},{xtype:"container",layout:{type:"hbox",align:"middle"},width:190,items:[this._btnsBorderPosition[0],this._btnsBorderPosition[1],this._btnsBorderPosition[2],this._btnsBorderPosition[3],this._btnsBorderPosition[4],this._btnsBorderPosition[5],{xtype:"tbspacer",flex:1}]},{xtype:"tbspacer",height:12},{xtype:"container",height:25,width:190,layout:"hbox",items:[{xtype:"label",text:this.textBackColor,margin:"2px 0 0 0",style:"text-align: right;",flex:1},{xtype:"tbspacer",width:7},this._btnBackColor,{xtype:"tbspacer",width:5}]}]});var f=Ext.widget("menu",{showSeparator:!1,bodyCls:"no-icons",listeners:{hide:function(t,n){e.fireEvent("editcomplete",e)},show:function(t,n){e.api&&(e.mnuMerge.setDisabled(!e.api.CheckBeforeMergeCells()),e.mnuSplit.setDisabled(!e.api.CheckBeforeSplitCells()))}},items:[{text:e.selectRowText,listeners:{click:function(t){e.api&&e.api.selectRow()}}},{text:e.selectColumnText,listeners:{click:function(t){e.api&&e.api.selectColumn()}}},{text:e.selectCellText,listeners:{click:function(t){e.api&&e.api.selectCell()}}},{text:e.selectTableText,listeners:{click:function(t){e.api&&e.api.selectTable()}}},{xtype:"menuseparator"},{text:e.insertRowAboveText,listeners:{click:function(t){e.api&&e.api.addRowAbove()}}},{text:e.insertRowBelowText,listeners:{click:function(t){e.api&&e.api.addRowBelow()}}},{text:e.insertColumnLeftText,listeners:{click:function(t){e.api&&e.api.addColumnLeft()}}},{text:e.insertColumnRightText,listeners:{click:function(t){e.api&&e.api.addColumnRight()}}},{xtype:"menuseparator"},{text:e.deleteRowText,listeners:{click:function(t){e.api&&e.api.remRow()}}},{text:e.deleteColumnText,listeners:{click:function(t){e.api&&e.api.remColumn()}}},{text:e.deleteTableText,listeners:{click:function(t){e.api&&e.api.remTable()}}},{xtype:"menuseparator"},e.mnuMerge=Ext.create("Ext.menu.Item",{text:e.mergeCellsText,listeners:{click:function(t){e.api&&e.api.MergeCells()}}}),e.mnuSplit=Ext.create("Ext.menu.Item",{text:e.splitCellsText,listeners:{click:function(t){if(e.api){var n=Ext.create("DE.view.InsertTableDialog",{labelTitle:this.splitCellTitleText});n.addListener("onmodalresult",Ext.bind(function(t,n,r){n&&e.api.SplitCell(r[0],r[1]),e.fireEvent("editcomplete",e)},this),!1),n.show()}}}})]});this._btnEdit=Ext.create("Ext.button.Button",{id:"table-button-edit",width:45,iconCls:"btn-edit-table",cls:"asc-right-panel-edit-btn",menu:f}),this._EditContainer=Ext.create("Ext.container.Container",{layout:"vbox",layoutConfig:{align:"stretch"},height:38,width:"100%",items:[{xtype:"tbspacer",height:5},{xtype:"container",height:40,width:200,layout:"hbox",items:[{xtype:"label",text:this.textEdit,margin:"2px 0 0 0",style:"font-weight: bold;margin-top: 1px;",flex:1},{xtype:"tbspacer",width:7},this._btnEdit,{xtype:"tbspacer",width:20}]}]}),this._HeaderContainer=Ext.create("Ext.container.Container",{height:40,width:"100%",layout:"hbox",items:[this.chRepeatRow,{xtype:"label",text:this.strRepeatRow,margin:"1 5 0 4",flex:1,listeners:{afterrender:Ext.bind(function(e){e.getEl().on("click",Ext.bind(function(){this.chRepeatRow.setValue(this.chRepeatRow.getValue()=="indeterminate"?!1:this.chRepeatRow.getValue()!="checked")},this),this),e.getEl().on("dblclick",Ext.bind(function(){this.chRepeatRow.setValue(this.chRepeatRow.getValue()=="indeterminate"?!1:this.chRepeatRow.getValue()!="checked")},this),this)},this)}},{xtype:"tbspacer",width:5}]}),this.items=[{xtype:"tbspacer",height:7},this._TemplatePanel,{xtype:"tbspacer",height:5},{xtype:"tbspacer",width:"100%",height:10,style:"padding-right: 10px;",html:'<div style="width: 100%; height: 40%; border-bottom: 1px solid #C7C7C7"></div>'},{xtype:"label",style:"font-weight: bold;margin-top: 1px;",text:this.textBorders},this._BordersPanel,{xtype:"tbspacer",height:5},{xtype:"tbspacer",width:"100%",height:10,style:"padding-right: 10px;",html:'<div style="width: 100%; height: 40%; border-bottom: 1px solid #C7C7C7"></div>'},{xtype:"label",style:"font-weight: bold;margin-top: 1px;",text:this.textWrap},this._WrapPanel,{xtype:"tbspacer",height:5},{xtype:"tbspacer",width:"100%",height:10,style:"padding-right: 10px;",html:'<div style="width: 100%; height: 40%; border-bottom: 1px solid #C7C7C7"></div>'},this._EditContainer,{xtype:"tbspacer",width:"100%",height:10,style:"padding-right: 10px;",html:'<div style="width: 100%; height: 40%; border-bottom: 1px solid #C7C7C7"></div>'},this._HeaderContainer,{xtype:"tbspacer",width:"100%",height:10,style:"padding-right: 10px;",html:'<div style="width: 100%; height: 40%; border-bottom: 1px solid #C7C7C7"></div>'},{xtype:"tbspacer",height:3},{xtype:"container",height:20,width:"100%",items:[{xtype:"box",html:'<div style="width:100%;text-align:center;padding-right:15px"><label id="table-advanced-link" class="asc-advanced-link">'+this.textAdvanced+"</label></div>",listeners:{afterrender:function(e){document.getElementById("table-advanced-link").onclick=Ext.bind(this._openAdvancedSettings,this)},scope:this}}]}],this.addEvents("editcomplete"),this.callParent(arguments)},setApi:function(e){this.api=e,e&&(this.api.asc_registerCallback("asc_onTblWrapStyleChanged",Ext.bind(this._TblWrapStyleChanged,this)),this.api.asc_registerCallback("asc_onTblAlignChanged",Ext.bind(this._TblAlignChanged,this)),this.api.asc_registerCallback("asc_onInitTableTemplates",Ext.bind(this._onInitTemplates,this)))},getRgbColor:function(e){var t=typeof e=="object"?e.color:e;t=t.replace(/#/,""),t.length==3&&(t=t.replace(/(.)/g,"$1$1")),t=parseInt(t,16);var n=new CAscColor;return n.put_type(typeof e=="object"?c_oAscColor.COLOR_TYPE_SCHEME:c_oAscColor.COLOR_TYPE_SRGB),n.put_r(t>>16),n.put_g((t&65280)>>8),n.put_b(t&255),n.put_a(255),e.effectId!==undefined&&n.put_value(e.effectId),n},getHexColor:function(e,t,n){return e=e.toString(16),t=t.toString(16),n=n.toString(16),e.length==1&&(e="0"+e),t.length==1&&(t="0"+t),n.length==1&&(n="0"+n),e+t+n},ChangeSettings:function(e){!this._initedSettings&&this.effectcolors&&this.standartcolors&&(this.borderColor.updateColors(this.effectcolors,this.standartcolors),this.colorsBack.updateColors(this.effectcolors,this.standartcolors)),this._initedSettings=!0;if(e){this._originalProps=new CTableProp(e),this._originalProps.put_CellSelect(!0),this._TblWrapStyleChanged(e.get_TableWrap());var t=e.get_CanBeFlow();this._state.CanBeFlow!==t&&(this._btnWrapParallel.setDisabled(!t),this._state.CanBeFlow=t),this._TblAlignChanged(e.get_TableAlignment()),this._state.TableIndent=e.get_TableAlignment()!==c_tableAlign.TABLE_ALIGN_LEFT?0:e.get_TableIndent(),this.SuspendEvents(),t=e.get_TableStyle();if(this._state.TemplateId!==t||this._isTemplatesChanged){var n=this._cmbTableTemplate.dataMenu.picker.store.findBy(function(e,n){return e.data.data.templateId===t},this);this._cmbTableTemplate.selectByIndex(n),this._isTemplatesChanged&&(n>=0?this._cmbTableTemplate.fillComboView(this._cmbTableTemplate.dataMenu.picker.store.getAt(n),!0,!0):this._cmbTableTemplate.fillComboView(this._cmbTableTemplate.dataMenu.picker.store.getAt(0),!1,!0)),this._state.TemplateId=t}this._isTemplatesChanged=!1;var r=e.get_TableLook();r&&(t=r.get_FirstRow(),this._state.CheckHeader!==t&&(this._chHeader.setValue(t),this._state.CheckHeader=t,this._originalLook.put_FirstRow(t)),t=r.get_LastRow(),this._state.CheckTotal!==t&&(this._chTotal.setValue(t),this._state.CheckTotal=t,this._originalLook.put_LastRow(t)),t=r.get_BandHor(),this._state.CheckBanded!==t&&(this._chBanded.setValue(t),this._state.CheckBanded=t,this._originalLook.put_BandHor(t)),t=r.get_FirstCol(),this._state.CheckFirst!==t&&(this._chFirst.setValue(t),this._state.CheckFirst=t,this._originalLook.put_FirstCol(t)),t=r.get_LastCol(),this._state.CheckLast!==t&&(this._chLast.setValue(t),this._state.CheckLast=t,this._originalLook.put_LastCol(t)),t=r.get_BandVer(),this._state.CheckColBanded!==t&&(this._chColBanded.setValue(t),this._state.CheckColBanded=t,this._originalLook.put_BandVer(t)));var i=e.get_CellsBackground();if(i)if(i.get_Value()==0){var s=i.get_Color();s?s.get_type()==c_oAscColor.COLOR_TYPE_SCHEME?this.CellColor={Value:1,Color:{color:this.getHexColor(s.get_r(),s.get_g(),s.get_b()),effectValue:s.get_value()}}:this.CellColor={Value:1,Color:this.getHexColor(s.get_r(),s.get_g(),s.get_b())}:this.CellColor={Value:1,Color:"transparent"}}else this.CellColor={Value:1,Color:"transparent"};else this.CellColor={Value:0,Color:"transparent"};var o=typeof this.CellColor.Color,u=typeof this._state.BackColor;if(o!==u||o=="object"&&(this.CellColor.Color.effectValue!==this._state.BackColor.effectValue||this._state.BackColor.color.indexOf(this.CellColor.Color.color)<0)||o!="object"&&this._state.BackColor.indexOf(this.CellColor.Color)<0){this._btnBackColor.setColor(this.CellColor.Color);if(typeof this.CellColor.Color=="object"){for(var a=0;a<10;a++)if(this.ThemeValues[a]==this.CellColor.Color.effectValue){this.colorsBack.select(this.CellColor.Color,!1);break}}else this.colorsBack.select(this.CellColor.Color,!1);this._state.BackColor=this.CellColor.Color}t=e.get_RowsInHeader(),this._state.RepeatRow!==t&&(t!==null?this.chRepeatRow.setValue(t>0?1:0):this.chRepeatRow.setValue("indeterminate"),this._state.RepeatRow=t),this.ResumeEvents()}},_UpdateBordersStyle:function(e){this.CellBorders=new CBorders;var t=this.CellBorders,n=e!="";if(e.indexOf("l")>-1||!n)(t.get_Left()===null||t.get_Left()===undefined)&&t.put_Left(new CBorder),this._UpdateBorderStyle(t.get_Left(),n);if(e.indexOf("t")>-1||!n)(t.get_Top()===null||t.get_Top()===undefined)&&t.put_Top(new CBorder),this._UpdateBorderStyle(t.get_Top(),n);if(e.indexOf("r")>-1||!n)(t.get_Right()===null||t.get_Right()===undefined)&&t.put_Right(new CBorder),this._UpdateBorderStyle(t.get_Right(),n);if(e.indexOf("b")>-1||!n)(t.get_Bottom()===null||t.get_Bottom()===undefined)&&t.put_Bottom(new CBorder),this._UpdateBorderStyle(t.get_Bottom(),n);if(e.indexOf("c")>-1||!n)(t.get_InsideV()===null||t.get_InsideV()===undefined)&&t.put_InsideV(new CBorder),this._UpdateBorderStyle(t.get_InsideV(),n);if(e.indexOf("m")>-1||!n)(t.get_InsideH()===null||t.get_InsideH()===undefined)&&t.put_InsideH(new CBorder),this._UpdateBorderStyle(t.get_InsideH(),n)},_UpdateBorderStyle:function(e,t){null==e&&(e=new CBorder);if(t&&this.BorderSize>0){var n=parseFloat(this.BorderSize);e.put_Value(1),e.put_Size(n*25.4/72);var r=this.getRgbColor(this._btnBorderColor.color);e.put_Color(r)}else e.put_Value(0)},_TblWrapStyleChanged:function(e){this._state.WrapStyle!==e&&(this._noApply=!0,this._btnWrapNone.toggle(e==c_tableWrap.TABLE_WRAP_NONE,!0),this._btnWrapParallel.toggle(e==c_tableWrap.TABLE_WRAP_PARALLEL,!0),this._noApply=!1,this._state.WrapStyle=e)},_TblAlignChanged:function(e){this._state.TableAlignment=e},_openAdvancedSettings:function(e){var t=this,n;if(t.api){var r=t.api.getSelectedElements();if(r&&Ext.isArray(r)){var i,s;for(var o=r.length-1;o>=0;o--){i=r[o].get_ObjectType(),s=r[o].get_ObjectValue();if(c_oAscTypeSelectElement.Table==i){var u={tableStylerRows:s.get_CellBorders().get_InsideH()===null&&s.get_CellSelect()==1?1:2,tableStylerColumns:s.get_CellBorders().get_InsideV()===null&&s.get_CellSelect()==1?1:2};n=Ext.create("DE.view.TableSettingsAdvanced",u),n.updateMetricUnit(),n.setSettings({tableProps:s,borderProps:t.borderAdvancedProps,colorProps:[this.effectcolors,this.standartcolors]});break}}}}n&&(n.addListener("onmodalresult",Ext.bind(function(e,r,i){if(r==1){var s=n.getSettings();t.borderAdvancedProps=s.borderProps,t.api.tblApply(s.tableProps)}t.fireEvent("editcomplete",t)},this),!1),n.addListener("close",function(){t.fireEvent("editcomplete",t)},!1),n.show())},_onInitTemplates:function(e){var t=this;this._isTemplatesChanged=!0;var n=t._cmbTableTemplate.dataMenu.picker.store.getCount();if(n>0&&n==e.length){var r=t._cmbTableTemplate.dataMenu.picker.store.data.items;Ext.each(e,function(e,t){r[t].data.imageUrl=e.get_Image()}),t._cmbTableTemplate.dataMenu.picker.store.fireEvent("datachanged",t._cmbTableTemplate.dataMenu.picker.store)}else{t._cmbTableTemplate.dataMenu.picker.store.removeAll();var i=[];Ext.each(e,function(e){i.push({imageUrl:e.get_Image(),uid:Ext.id(),data:{templateId:e.get_Id()}})}),t._cmbTableTemplate.dataMenu.picker.store.loadData(i)}},SendThemeColors:function(e,t){this.effectcolors=e,t&&t.length>0&&(this.standartcolors=t),this._initedSettings&&(this.borderColor.updateColors(e,t),this.colorsBack.updateColors(e,t))},textWrap:"Text Wrapping",textBorders:"Border's Style",textBorderColor:"Color",textBackColor:"Background color",textWrapParallelTooltip:"Flow table",textWrapNoneTooltip:"Inline table",textUndock:"Undock from panel",textEdit:"Rows & Columns",selectRowText:"Select Row",selectColumnText:"Select Column",selectCellText:"Select Cell",selectTableText:"Select Table",insertRowAboveText:"Insert Row Above",insertRowBelowText:"Insert Row Below",insertColumnLeftText:"Insert Column Left",insertColumnRightText:"Insert Column Right",deleteRowText:"Delete Row",deleteColumnText:"Delete Column",deleteTableText:"Delete Table",mergeCellsText:"Merge Cells",splitCellsText:"Split Cell...",splitCellTitleText:"Split Cell",textSelectBorders:"Select borders that you want to change",textAdvanced:"Show advanced settings",txtTitle:"Table",txtNoBorders:"No borders",textOK:"OK",textCancel:"Cancel",textNewColor:"Add New Custom Color",textTemplate:"Select From Template",textRows:"Rows",textColumns:"Columns",textHeader:"Header",textTotal:"Total",textBanded:"Banded",textFirst:"First",textLast:"Last",textEmptyTemplate:"No templates",strRepeatRow:"Repeat as header row at the top of each page",textThemeColors:"Theme Colors",textStandartColors:"Standart Colors",tipTop:"Set Outer Top Border Only",tipLeft:"Set Outer Left Border Only",tipBottom:"Set Outer Bottom Border Only",tipRight:"Set Outer Right Border Only",tipAll:"Set Outer Border and All Inner Lines",tipNone:"Set No Borders",tipInner:"Set Inner Lines Only",tipInnerVert:"Set Vertical Inner Lines Only",tipInnerHor:"Set Horizontal Inner Lines Only",tipOuter:"Set Outer Border Only"}),Ext.define("DE.view.ShapeSettings",{extend:"Common.view.AbstractSettingsPanel",alias:"widget.deshapesettings",height:412,requires:["Ext.button.Button","Ext.form.Label","Ext.form.field.ComboBox","Ext.container.Container","Ext.toolbar.Spacer","Ext.Array","Ext.menu.Menu","Ext.menu.Manager","Ext.data.Model","Ext.data.Store","Ext.XTemplate","Ext.Img","Ext.slider.Single","Common.component.DataViewPicker","Common.component.MetricSpinner","Common.view.ImageFromUrlDialog","Common.component.ThemeColorPalette","DE.view.ImageSettingsAdvanced","Common.plugin.MenuExpand","Common.component.ComboDataView","Common.component.MultiSliderGradient","Common.plugin.ComboBoxScrollPane"],constructor:function(e){return this.callParent(arguments),this.initConfig(e),this},initComponent:function(){this.title=this.txtTitle,this._initSettings=!0;var e=this;this._originalProps=null,this._noApply=!0,this.imgprops=null,this._sendUndoPoint=!0,this._state={Transparency:null,FillType:c_oAscFill.FILL_TYPE_SOLID,ShapeColor:"ffffff",BlipFillType:c_oAscFillBlipType.STRETCH,StrokeType:c_oAscStrokeType.STROKE_COLOR,StrokeWidth:this._pt2mm(1),StrokeColor:"000000",FGColor:"000000",BGColor:"ffffff",GradColor:"000000",GradFillType:c_oAscFillGradType.GRAD_LINEAR,WrappingStyle:c_oAscWrapStyle2.Inline,CanBeFlow:!0,FromGroup:!1,DisabledFillPanels:!1},this.OriginalFillType=c_oAscFill.FILL_TYPE_SOLID,this.ShapeColor={Value:1,Color:"ffffff"},this.BlipFillType=c_oAscFillBlipType.STRETCH,this.GradFillType=c_oAscFillGradType.GRAD_LINEAR,this.GradColor={values:[0,100],colors:["000000","ffffff"],currentIdx:0},this.GradLinearDirectionIdx=3,this.GradRadialDirectionIdx=0,this.PatternFillType=0,this.FGColor={Value:1,Color:"000000"},this.BGColor={Value:1,Color:"ffffff"},this.BorderColor={Value:1,Color:"transparent"},this.BorderSize=0,this.textureNames=[this.txtCanvas,this.txtCarton,this.txtDarkFabric,this.txtGrain,this.txtGranite,this.txtGreyPaper,this.txtKnit,this.txtLeather,this.txtBrownPaper,this.txtPapyrus,this.txtWood],this.ThemeValues=[6,15,7,16,0,1,2,3,4,5];var t=[{borderstyle:"",text:this.txtNoBorders,value:0,offsety:-1},{text:"0.5 pt",value:.5,offsety:0},{text:"1 pt",value:1,offsety:20},{text:"1.5 pt",value:1.5,offsety:40},{text:"2.25 pt",value:2.25,offsety:60},{text:"3 pt",value:3,offsety:80},{text:"4.5 pt",value:4.5,offsety:100},{text:"6 pt",value:6,offsety:120}];for(var n=1;n<t.length;n++)t[n].borderstyle=Ext.String.format("background:url({0}) 0 {1}px; width:69px; height:20px; margin-right:5px;","resources/img/right-panels/BorderSize.png",-t[n].offsety);var r=Ext.create("Ext.data.Store",{model:"DE.model.ModelBorders",data:t}),i=Ext.create("Ext.XTemplate",'<tpl for="."><span style="display: inline-block; margin-top: 3px; font-size: 11px; height: 17px;">{text}</span><img src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" align="right" style="{borderstyle}"></tpl>');this.cmbBorderSize=Ext.create("Ext.form.field.ComboBox",{width:92,height:21,editable:!1,queryMode:"local",matchFieldWidth:!1,displayField:"text",store:r,style:"margin-right: 8px;",listConfig:{mode:"local",width:145,itemTpl:i},listeners:{select:Ext.bind(function(t,n,r){this.BorderSize=n[0].data.value;if(this.api&&!this._noApply){var i=new CAscShapeProp,s=new CAscStroke;this.BorderSize<.01?s.put_type(c_oAscStrokeType.STROKE_NONE):(s.put_type(c_oAscStrokeType.STROKE_COLOR),this.BorderColor.Color=="transparent"||this.BorderColor.Color.color=="transparent"?s.put_color(this.getRgbColor({color:"000000",effectId:0})):this._state.StrokeType==c_oAscStrokeType.STROKE_NONE&&s.put_color(this.getRgbColor(this.colorValue2EffectId(this.BorderColor.Color))),s.put_width(this._pt2mm(this.BorderSize))),i.put_stroke(s),this.imgprops.put_ShapeProperties(i),this.api.ImgApply(this.imgprops)}if(t.inputEl)if(n[0].data.offsety<0){var o=Ext.String.format("background: url({0}) repeat scroll 0 0 white","resources/img/controls/text-bg.gif");Ext.DomHelper.applyStyles(t.inputEl,o),t.inputEl.set({type:"text"}),t.inputEl.set({value:e.txtNoBorders}),t.onItemClick(t.picker,n[0])}else{t.inputEl.set({type:"image"}),t.inputEl.set({src:"data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw=="});var o=Ext.String.format("background:url({0}) no-repeat scroll 0 {1}px, url({2}) repeat scroll 0 0 white","resources/img/right-panels/BorderSize.png",-n[0].data.offsety,"resources/img/controls/text-bg.gif");Ext.DomHelper.applyStyles(t.inputEl,o)}this.fireEvent("editcomplete",this)},this),afterRender:function(){if(this.inputEl){Ext.DomHelper.applyStyles(this.inputEl,"padding-left:7px"),this.inputEl.set({type:"image"}),this.inputEl.set({src:"data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw=="});var e=Ext.String.format("background:url({0}) repeat scroll 0 {1}px, url({2}) repeat scroll 0 0 white","resources/img/right-panels/BorderSize.png",-20,"resources/img/controls/text-bg.gif");Ext.DomHelper.applyStyles(this.inputEl,e)}}},plugins:[{ptype:"comboboxscrollpane",pluginId:"scrollpane",settings:{enableKeyboardNavigation:!0}}]});var s=this.cmbBorderSize.getStore().getAt(2);this.cmbBorderSize.select(s),this.BorderSize=s.data.value,this._btnBorderColor=Ext.create("Ext.button.Button",{id:"shape-button-border-color",arrowCls:"",width:45,height:22,color:"000000",style:"margin-bottom:5px;",menu:{showSeparator:!1,items:[this.colorsBorder=Ext.create("Common.component.ThemeColorPalette",{value:"000000",width:165,height:214,dynamiccolors:!0,dyncolorscount:10,colors:[this.textThemeColors,"-",{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},{color:"000000",effectId:5},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},"-",{color:"3D55FE",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},{color:"000000",effectId:5},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},"-","--","-",this.textStandartColors,"-","3D55FE","5301B3","980ABD","B2275F","F83D26","F86A1D","F7AC16","F7CA12","FAFF44","D6EF39","-","--"],listeners:{select:Ext.bind(function(e,t,n){Ext.menu.Manager.hideAll(),this._btnBorderColor.color=t,this._btnBorderColor.btnEl&&Ext.DomHelper.applyStyles(this._btnBorderColor.btnEl,{"background-color":Ext.String.format("#{0}",typeof t=="object"?t.color:t)}),this.BorderColor={Value:1,Color:t};if(this.api&&this.BorderSize>0&&!this._noApply){var r=new CAscShapeProp,i=new CAscStroke;this.BorderSize<.01?i.put_type(c_oAscStrokeType.STROKE_NONE):(i.put_type(c_oAscStrokeType.STROKE_COLOR),i.put_color(this.getRgbColor(this.BorderColor.Color)),i.put_width(this._pt2mm(this.BorderSize))),r.put_stroke(i),this.imgprops.put_ShapeProperties(r),this.api.ImgApply(this.imgprops)}this.fireEvent("editcomplete",this)},this)}}),{cls:"menu-item-noicon menu-item-color-palette-theme",text:this.textNewColor,listeners:{click:function(t,n){e.colorsBorder.addNewColor()}}}]},listeners:{render:function(e){var t=Ext.String.format("background-color:#{0}",typeof e.color=="object"?e.color.color:e.color);Ext.DomHelper.applyStyles(e.btnEl,t)}},setColor:function(e){var t,n;this.color=e,e=="transparent"||e.color=="transparent"?(t="1px solid #BEBEBE",n=e):(t="none",n=Ext.String.format("#{0}",typeof e=="object"?e.color:e)),this.btnEl!==undefined&&Ext.DomHelper.applyStyles(this.btnEl,{"background-color":n,border:t})}}),this.controls.push(this.colorsBorder),this._btnBackColor=Ext.create("Ext.button.Button",{id:"shape-button-back-color",arrowCls:"",width:45,height:22,color:"ffffff",menu:{showSeparator:!1,items:[this.colorsBack=Ext.create("Common.component.ThemeColorPalette",{value:"ffffff",width:165,height:214,dynamiccolors:!0,dyncolorscount:10,colors:[this.textThemeColors,"-",{color:"3366FF",effectId:1},{color:"0000FF",effectId:2},{color:"000090",effectId:3},{color:"660066",effectId:4},{color:"800000",effectId:5},{color:"FF0000",effectId:1},{color:"FF6600",effectId:1},{color:"FFFF00",effectId:2},{color:"CCFFCC",effectId:3},{color:"008000",effectId:4},"-",{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},{color:"000000",effectId:5},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},"-","--","-",this.textStandartColors,"-","transparent","5301B3","980ABD","B2275F","F83D26","F86A1D","F7AC16","F7CA12","FAFF44","D6EF39","-","--"],listeners:{select:Ext.bind(function(e,t,n){Ext.menu.Manager.hideAll();var r,i;t=="transparent"?(this._btnBackColor.color="transparent",r="transparent",i="1px solid #BEBEBE"):(this._btnBackColor.color=t,r=Ext.String.format("#{0}",typeof t=="object"?t.color:t),i="none"),this._btnBackColor.btnEl&&Ext.DomHelper.applyStyles(this._btnBackColor.btnEl,{"background-color":r,border:i}),this.ShapeColor={Value:1,Color:this._btnBackColor.color};if(this.api&&!this._noApply){var s=new CAscShapeProp,o=new CAscFill;this.ShapeColor.Color=="transparent"?(o.put_type(c_oAscFill.FILL_TYPE_NOFILL),o.put_fill(null)):(o.put_type(c_oAscFill.FILL_TYPE_SOLID),o.put_fill(new CAscFillSolid),o.get_fill().put_color(this.getRgbColor(this.ShapeColor.Color))),s.put_fill(o),this.imgprops.put_ShapeProperties(s),this.api.ImgApply(this.imgprops)}this.fireEvent("editcomplete",this)},this)}}),{cls:"menu-item-noicon menu-item-color-palette-theme",text:this.textNewColor,listeners:{click:function(t,n){e.colorsBack.addNewColor()}}}]},listeners:{render:function(e){var t,n;e.color=="transparent"?(t="1px solid #BEBEBE",n=e.color):(t="none",n=Ext.String.format("#{0}",typeof e.color=="object"?e.color.color:e.color)),Ext.DomHelper.applyStyles(e.btnEl,{"background-color":n,border:t})}},setColor:function(e){var t,n;this.color=e,e=="transparent"?(t="1px solid #BEBEBE",n=e):(t="none",n=Ext.String.format("#{0}",typeof e=="object"?e.color:e)),this.btnEl!==undefined&&Ext.DomHelper.applyStyles(this.btnEl,{"background-color":n,border:t})}}),this.controls.push(this.colorsBack),this._arrFillSrc=[this.textColor,this.textGradientFill,this.textImageTexture,this.textPatternFill,this.textNoFill],this.cmbFillSrc=Ext.create("Ext.form.field.ComboBox",{id:"shape-combo-fill-src",width:190,editable:!1,store:this._arrFillSrc,queryMode:"local",triggerAction:"all",listeners:{select:Ext.bind(function(e,t,n){this._ShowHideElem([t[0].index==0,t[0].index==2,t[0].index==3,t[0].index==1,t[0].index>=0&&t[0].index<4],[this._FillColorContainer,this._FillImageContainer,this._PatternContainer,this._GradientContainer,this._TransparencyContainer],[this._FillColorContainerHeight,this._FillImageContainerHeight,this._PatternContainerHeight,this._GradientContainerHeight,this._TransparencyContainerHeight]);switch(t[0].index){case 0:this._state.FillType=c_oAscFill.FILL_TYPE_SOLID;if(!this._noApply){var r=new CAscShapeProp,i=new CAscFill;this.ShapeColor.Color=="transparent"?(i.put_type(c_oAscFill.FILL_TYPE_NOFILL),i.put_fill(null)):(i.put_type(c_oAscFill.FILL_TYPE_SOLID),i.put_fill(new CAscFillSolid),i.get_fill().put_color(this.getRgbColor(this.ShapeColor.Color))),r.put_fill(i),this.imgprops.put_ShapeProperties(r),this.api.ImgApply(this.imgprops)}break;case 1:this._state.FillType=c_oAscFill.FILL_TYPE_GRAD;if(!this._noApply){var r=new CAscShapeProp,i=new CAscFill;i.put_type(c_oAscFill.FILL_TYPE_GRAD),i.put_fill(new CAscFillGrad),i.get_fill().put_grad_type(this.GradFillType),this.GradFillType==c_oAscFillGradType.GRAD_LINEAR&&(i.get_fill().put_linear_angle(l[this.GradLinearDirectionIdx].data.type*6e4),i.get_fill().put_linear_scale(!0)),this.OriginalFillType!==c_oAscFill.FILL_TYPE_GRAD&&(i.get_fill().put_positions([this.GradColor.values[0]*1e3,this.GradColor.values[1]*1e3]),i.get_fill().put_colors([this.getRgbColor(this.GradColor.colors[0]),this.getRgbColor(this.GradColor.colors[1])])),r.put_fill(i),this.imgprops.put_ShapeProperties(r),this.api.ImgApply(this.imgprops)}break;case 2:this._state.FillType=c_oAscFill.FILL_TYPE_BLIP;break;case 3:this._state.FillType=c_oAscFill.FILL_TYPE_PATT;if(!this._noApply){var r=new CAscShapeProp,i=new CAscFill;i.put_type(c_oAscFill.FILL_TYPE_PATT),i.put_fill(new CAscFillHatch),i.get_fill().put_pattern_type(this.PatternFillType),i.get_fill().put_color_fg(this.getRgbColor(this.FGColor.Color)),i.get_fill().put_color_bg(this.getRgbColor(this.BGColor.Color)),r.put_fill(i),this.imgprops.put_ShapeProperties(r),this.api.ImgApply(this.imgprops)}break;case 4:this._state.FillType=c_oAscFill.FILL_TYPE_NOFILL;if(!this._noApply){var r=new CAscShapeProp,i=new CAscFill;i.put_type(c_oAscFill.FILL_TYPE_NOFILL),i.put_fill(null),r.put_fill(i),this.imgprops.put_ShapeProperties(r),this.api.ImgApply(this.imgprops)}}this.fireEvent("editcomplete",this)},this)}}),this.cmbFillSrc.setValue(this._arrFillSrc[0]),this._FillColorContainer=Ext.create("Ext.container.Container",{layout:"vbox",layoutConfig:{align:"stretch"},height:25,width:190,items:[this._btnBackColor]}),this._FillColorContainerHeight=this._FillColorContainer.height,this._btnInsertFromFile=Ext.create("Ext.Button",{id:"shape-button-fill-from-file",text:this.textFromFile,width:90,listeners:{click:function(e){this.api&&this.api.ChangeShapeImageFromFile(),this.fireEvent("editcomplete",this)},scope:this}}),this._btnInsertFromUrl=Ext.create("Ext.Button",{id:"shape-button-fill-from-url",text:this.textFromUrl,width:90,listeners:{click:function(e){var t=Ext.create("Common.view.ImageFromUrlDialog");t.addListener("onmodalresult",Ext.bind(this._onOpenImageFromURL,[this,t]),!1),t.addListener("close",Ext.bind(function(e,t){this.fireEvent("editcomplete",this)},this)),t.show()},scope:this}}),this._arrFillType=[this.textStretch,this.textTile],this.cmbFillType=Ext.create("Ext.form.field.ComboBox",{id:"shape-combo-fill-type",width:90,editable:!1,store:this._arrFillType,queryMode:"local",triggerAction:"all",listeners:{select:Ext.bind(function(e,t,n){t[0].index==0?this.BlipFillType=c_oAscFillBlipType.STRETCH:t[0].index==1&&(this.BlipFillType=c_oAscFillBlipType.TILE);if(this.api&&this._fromTextureCmb!==!0&&this.OriginalFillType==c_oAscFill.FILL_TYPE_BLIP){var r=new CAscShapeProp,i=new CAscFill;i.put_type(c_oAscFill.FILL_TYPE_BLIP),i.put_fill(new CAscFillBlip),i.get_fill().put_type(this.BlipFillType),r.put_fill(i),this.imgprops.put_ShapeProperties(r),this.api.ImgApply(this.imgprops)}this.fireEvent("editcomplete",this)},this)}}),this.cmbFillType.setValue(this._arrFillType[0]),this.controls.push(this.cmbFillType),this._btnTexture=Ext.create("Ext.button.Button",{text:this.textSelectTexture,width:90,cls:"btn-combo-style",pressedCls:"",textAlign:"left",menu:this.textureMenu=Ext.create("Common.component.MenuDataViewPicker",{width:242,height:182,cls:"texture-view",viewData:[],contentWidth:222,listeners:{select:Ext.bind(function(e,t){this._fromTextureCmb=!0,this.cmbFillType.setValue(this._arrFillType[1]),this._fromTextureCmb=!1;if(this.api){var n=new CAscShapeProp,r=new CAscFill;r.put_type(c_oAscFill.FILL_TYPE_BLIP),r.put_fill(new CAscFillBlip),r.get_fill().put_type(c_oAscFillBlipType.TILE),r.get_fill().put_texture_id(t.data.data.type),n.put_fill(r),this.imgprops.put_ShapeProperties(n),this.api.ImgApply(this.imgprops)}this._btnTexture.setText(t.data.name),this.fireEvent("editcomplete",this)},this),hide:function(){e.fireEvent("editcomplete",e)},show:function(e){e.picker.selectByIndex(-1,!1)}}})}),this.controls.push(this._btnTexture),this.textureImage=Ext.create("Ext.container.Container",{id:"shape-texture-img",width:50,height:50}),Ext.define("DE.model.PatternDataModel",{extend:"Ext.data.Model",fields:[{name:"imageUrl"},{name:"imageStyle"},{name:"imageCls"},{name:"title"},{name:"data"},{name:"uid"}]});var o=Ext.create("Ext.XTemplate",'<tpl for=".">','<div class="thumb-wrap">','<img src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" style="{imageStyle}" class="{imageCls}"/>',"</div>","</tpl>");this.patternViewData=[];var u=Ext.create("Ext.data.Store",{storeId:Ext.id(),model:"DE.model.PatternDataModel",data:this.patternViewData});this._cmbPattern=Ext.create("Common.component.ComboDataView",{id:"shape-combo-pattern",width:190,height:42,itemWidth:28,itemHeight:28,menuMaxHeight:300,repeatedselect:!0,store:u,dataTpl:o,viewData:[],emptyComboText:this.textEmptyPattern,listeners:{select:function(t,n){if(e.api&&!e._noApply){e.PatternFillType=n.data.data.type;var r=new CAscShapeProp,i=new CAscFill;i.put_type(c_oAscFill.FILL_TYPE_PATT),i.put_fill(new CAscFillHatch),i.get_fill().put_pattern_type(n.data.data.type),e.OriginalFillType!==c_oAscFill.FILL_TYPE_PATT&&(i.get_fill().put_color_fg(e.getRgbColor(e.FGColor.Color)),i.get_fill().put_color_bg(e.getRgbColor(e.BGColor.Color))),r.put_fill(i),e.imgprops.put_ShapeProperties(r),e.api.ImgApply(e.imgprops)}e.fireEvent("editcomplete",e)},menuhide:function(){e.fireEvent("editcomplete",e)},releasecapture:function(t){e.fireEvent("editcomplete",e)}}}),this.controls.push(this._cmbPattern),this._cmbPattern.addCls("shape-pattern"),this._cmbPattern.dataMenu.picker.contentWidth=170,this._cmbPattern.dataMenu.picker.needArrangeSlideItems=!0,this._cmbPattern.dataMenu.picker.arrangeItems=this._arrangeSlideItems,this._cmbPattern.dataMenu.picker.resizeSlideItems=this._resizeSlideItems,this._btnFGColor=Ext.create("Ext.button.Button",{id:"shape-button-foreground-color",arrowCls:"",width:45,height:22,color:"000000",style:"margin-bottom:5px;",menu:{showSeparator:!1,items:[this.colorsFG=Ext.create("Common.component.ThemeColorPalette",{value:"000000",width:165,height:214,dynamiccolors:!0,dyncolorscount:10,colors:[this.textThemeColors,"-",{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},{color:"000000",effectId:5},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},"-",{color:"3D55FE",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},{color:"000000",effectId:5},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},"-","--","-",this.textStandartColors,"-","3D55FE","5301B3","980ABD","B2275F","F83D26","F86A1D","F7AC16","F7CA12","FAFF44","D6EF39","-","--"],listeners:{select:Ext.bind(function(e,t,n){Ext.menu.Manager.hideAll(),this._btnFGColor.color=t,this._btnFGColor.btnEl&&Ext.DomHelper.applyStyles(this._btnFGColor.btnEl,{"background-color":Ext.String.format("#{0}",typeof t=="object"?t.color:t)}),this.FGColor={Value:1,Color:t};if(this.api&&!this._noApply){var r=new CAscShapeProp,i=new CAscFill;i.put_type(c_oAscFill.FILL_TYPE_PATT),i.put_fill(new CAscFillHatch),i.get_fill().put_color_fg(this.getRgbColor(this.FGColor.Color)),this.OriginalFillType!==c_oAscFill.FILL_TYPE_PATT&&(i.get_fill().put_pattern_type(this.PatternFillType),i.get_fill().put_color_bg(this.getRgbColor(this.BGColor.Color))),r.put_fill(i),this.imgprops.put_ShapeProperties(r),this.api.ImgApply(this.imgprops)}this.fireEvent("editcomplete",this)},this)}}),{cls:"menu-item-noicon menu-item-color-palette-theme",text:this.textNewColor,listeners:{click:function(t,n){e.colorsFG.addNewColor()}}}]},listeners:{render:function(e){var t=Ext.String.format("background-color:#{0}",typeof e.color=="object"?e.color.color:e.color);Ext.DomHelper.applyStyles(e.btnEl,t)}},setColor:function(e){var t,n;this.color=e,e=="transparent"||e.color=="transparent"?(t="1px solid #BEBEBE",n=e):(t="none",n=Ext.String.format("#{0}",typeof e=="object"?e.color:e)),this.btnEl!==undefined&&Ext.DomHelper.applyStyles(this.btnEl,{"background-color":n,border:t})}}),this.controls.push(this.colorsFG),this._btnBGColor=Ext.create("Ext.button.Button",{id:"shape-button-background-color",arrowCls:"",width:45,height:22,color:"ffffff",style:"margin-bottom:5px;",menu:{showSeparator:!1,items:[this.colorsBG=Ext.create("Common.component.ThemeColorPalette",{value:"ffffff",width:165,height:214,dynamiccolors:!0,dyncolorscount:10,colors:[this.textThemeColors,"-",{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},{color:"000000",effectId:5},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},"-",{color:"3D55FE",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},{color:"000000",effectId:5},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},"-","--","-",this.textStandartColors,"-","3D55FE","5301B3","980ABD","B2275F","F83D26","F86A1D","F7AC16","F7CA12","FAFF44","D6EF39","-","--"],listeners:{select:Ext.bind(function(e,t,n){Ext.menu.Manager.hideAll(),this._btnBGColor.color=t,this._btnBGColor.btnEl&&Ext.DomHelper.applyStyles(this._btnBGColor.btnEl,{"background-color":Ext.String.format("#{0}",typeof t=="object"?t.color:t)}),this.BGColor={Value:1,Color:t};if(this.api&&!this._noApply){var r=new CAscShapeProp,i=new CAscFill;i.put_type(c_oAscFill.FILL_TYPE_PATT),i.put_fill(new CAscFillHatch),this.OriginalFillType!==c_oAscFill.FILL_TYPE_PATT&&(i.get_fill().put_pattern_type(this.PatternFillType),i.get_fill().put_color_fg(this.getRgbColor(this.FGColor.Color))),i.get_fill().put_color_bg(this.getRgbColor(this.BGColor.Color)),r.put_fill(i),this.imgprops.put_ShapeProperties(r),this.api.ImgApply(this.imgprops)}this.fireEvent("editcomplete",this)},this)}}),{cls:"menu-item-noicon menu-item-color-palette-theme",text:this.textNewColor,listeners:{click:function(t,n){e.colorsBG.addNewColor()}}}]},listeners:{render:function(e){var t=Ext.String.format("background-color:#{0}",typeof e.color=="object"?e.color.color:e.color);Ext.DomHelper.applyStyles(e.btnEl,t)}},setColor:function(e){var t,n;this.color=e,e=="transparent"||e.color=="transparent"?(t="1px solid #BEBEBE",n=e):(t="none",n=Ext.String.format("#{0}",typeof e=="object"?e.color:e)),this.btnEl!==undefined&&Ext.DomHelper.applyStyles(this.btnEl,{"background-color":n,border:t})}}),this.controls.push(this.colorsBG),this._PatternContainer=Ext.create("Ext.container.Container",{layout:"vbox",layoutConfig:{align:"stretch"},height:141,width:190,hidden:!0,items:[{xtype:"tbspacer",height:5},{xtype:"label",text:this.strPattern},{xtype:"tbspacer",height:2},this._cmbPattern,{xtype:"tbspacer",height:10},{xtype:"container",layout:{type:"hbox",align:"middle"},width:190,height:27,items:[{xtype:"label",text:this.strForeground,flex:1},this._btnFGColor]},{xtype:"tbspacer",height:10},{xtype:"container",layout:{type:"hbox",align:"middle"},width:190,height:27,items:[{xtype:"label",text:this.strBackground,flex:1},this._btnBGColor]}]}),this._PatternContainerHeight=this._PatternContainer.height;var a=Ext.bind(function(e){this._cmbPattern.dataMenu.picker.store.getCount()>0&&(this._cmbPattern.fillComboView(this._cmbPattern.dataMenu.picker.store.getAt(0),!0),this.PatternFillType=this.patternViewData[0].data.type,this._cmbPattern.dataMenu.picker.updateScrollPane(),this._PatternContainer.un("show",a))},this);this._PatternContainer.on("show",a),this._arrGradType=[this.textLinear,this.textRadial],this.cmbGradType=Ext.create("Ext.form.field.ComboBox",{id:"shape-combo-grad-type",width:90,editable:!1,store:this._arrGradType,queryMode:"local",triggerAction:"all",listeners:{select:Ext.bind(function(e,t,n){t[0].index==0?(this.GradFillType=c_oAscFillGradType.GRAD_LINEAR,this.btnDirection.menu.picker.store.loadData(l),this.btnDirection.menu.picker.selectByIndex(this.GradLinearDirectionIdx),this.GradLinearDirectionIdx>=0?this.btnDirection.setIconCls(l[this.GradLinearDirectionIdx].iconcls):this.btnDirection.setIconCls("")):t[0].index==1&&(this.GradFillType=c_oAscFillGradType.GRAD_PATH,this.btnDirection.menu.picker.store.loadData(c),this.btnDirection.menu.picker.selectByIndex(this.GradRadialDirectionIdx),this.GradRadialDirectionIdx>=0?this.btnDirection.setIconCls(c[this.GradRadialDirectionIdx].iconcls):this.btnDirection.setIconCls(""));if(this.api&&!this._noApply){var r=new CAscShapeProp,i=new CAscFill;i.put_type(c_oAscFill.FILL_TYPE_GRAD),i.put_fill(new CAscFillGrad),i.get_fill().put_grad_type(this.GradFillType),this.GradFillType==c_oAscFillGradType.GRAD_LINEAR&&(i.get_fill().put_linear_angle(l[this.GradLinearDirectionIdx].data.type*6e4),i.get_fill().put_linear_scale(!0)),i.get_fill().put_positions([this.GradColor.values[0]*1e3,this.GradColor.values[1]*1e3]),i.get_fill().put_colors([this.getRgbColor(this.GradColor.colors[0]),this.getRgbColor(this.GradColor.colors[1])]),r.put_fill(i),this.imgprops.put_ShapeProperties(r),this.api.ImgApply(this.imgprops)}this.fireEvent("editcomplete",this)},this)}}),this.cmbGradType.setValue(this._arrGradType[0]);var f=Ext.create("Ext.XTemplate",'<tpl for=".">','<div class="thumb-wrap">','<img src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" style="{imgstyle}" class="item-gradient"/>',"</div>",'<tpl if="separator">','<div class="gradient-separator"></div>',"</tpl>","</tpl>"),l=[{offsetx:0,offsety:0,data:{type:45,subtype:-1},iconcls:"gradient-subtype gradient-left-top"},{offsetx:50,offsety:0,data:{type:90,subtype:4},iconcls:"gradient-subtype gradient-top"},{offsetx:100,offsety:0,data:{type:135,subtype:5},iconcls:"gradient-subtype gradient-right-top"},{offsetx:0,offsety:50,data:{type:0,subtype:6},iconcls:"gradient-subtype gradient-left",separator:!0},{offsetx:100,offsety:50,data:{type:180,subtype:1},iconcls:"gradient-subtype gradient-right"},{offsetx:0,offsety:100,data:{type:315,subtype:2},iconcls:"gradient-subtype gradient-left-bottom"},{offsetx:50,offsety:100,data:{type:270,subtype:3},iconcls:"gradient-subtype gradient-bottom"},{offsetx:100,offsety:100,data:{type:225,subtype:7},iconcls:"gradient-subtype gradient-right-bottom"}];for(var n=0;n<l.length;n++)l[n].imgstyle=Ext.String.format("background-position: {0}px {1}px;",-l[n].offsetx,-l[n].offsety);var c=[{offsetx:100,offsety:150,data:{type:2,subtype:5},iconcls:"gradient-subtype gradient-radial-center"}];for(var n=0;n<c.length;n++)c[n].imgstyle=Ext.String.format("background-position: {0}px {1}px;",-c[n].offsetx,-c[n].offsety);this.btnDirection=Ext.widget("button",{id:"shape-button-direction",width:72,height:58,cls:"btn-wrap-types",iconCls:"gradient-subtype gradient-left",pressedCls:"disablepressed",menuAlign:"tl-bl?",menu:Ext.create("Common.component.MenuDataViewPicker",{width:195,height:190,minWidth:50,cls:"gradient-view",dataTpl:f,viewData:l,contentWidth:175,listeners:{select:Ext.bind(function(t,n,r,i){this.btnDirection.setIconCls(n.data.iconcls),this.GradFillType==c_oAscFillGradType.GRAD_LINEAR?this.GradLinearDirectionIdx=i:this.GradRadialDirectionIdx=i;if(this.api&&!this._noApply){if(this.GradFillType==c_oAscFillGradType.GRAD_LINEAR){var s=new CAscShapeProp,o=new CAscFill;o.put_type(c_oAscFill.FILL_TYPE_GRAD),o.put_fill(new CAscFillGrad),o.get_fill().put_grad_type(this.GradFillType),o.get_fill().put_linear_angle(n.data.data.type*6e4),o.get_fill().put_linear_scale(!0),this.OriginalFillType!==c_oAscFill.FILL_TYPE_GRAD&&(o.get_fill().put_positions([this.GradColor.values[0]*1e3,this.GradColor.values[1]*1e3]),o.get_fill().put_colors([this.getRgbColor(this.GradColor.colors[0]),this.getRgbColor(this.GradColor.colors[1])])),s.put_fill(o),this.imgprops.put_ShapeProperties(s),this.api.ImgApply(e.imgprops)}Ext.menu.Manager.hideAll()}this.fireEvent("editcomplete",this)},this),hide:Ext.bind(function(){this.fireEvent("editcomplete",this)},this),beforeshow:Ext.bind(function(e){if(e.rendered){var t=e.getHeight();this.GradFillType==c_oAscFillGradType.GRAD_LINEAR&&Math.abs(t-190)>0&&(e.picker.contentWidth=175,e.setSize(195,190)),this.GradFillType==c_oAscFillGradType.GRAD_PATH&&Math.abs(t-70)>0&&(e.picker.contentWidth=50,e.setSize(70,70))}},this)}})}),this.btnDirection.menu.picker.selectByIndex(this.GradLinearDirectionIdx),this.controls.push(this.btnDirection),this._btnGradColor=Ext.create("Ext.button.Button",{id:"shape-button-gradient-color",arrowCls:"",width:45,height:22,color:"000000",style:"margin-bottom:5px;",menu:{showSeparator:!1,items:[this.colorsGrad=Ext.create("Common.component.ThemeColorPalette",{value:"000000",width:165,height:214,dynamiccolors:!0,dyncolorscount:10,colors:[this.textThemeColors,"-",{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},{color:"000000",effectId:5},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},"-",{color:"3D55FE",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},{color:"000000",effectId:5},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},"-","--","-",this.textStandartColors,"-","3D55FE","5301B3","980ABD","B2275F","F83D26","F86A1D","F7AC16","F7CA12","FAFF44","D6EF39","-","--"],listeners:{select:Ext.bind(function(t,n,r){Ext.menu.Manager.hideAll(),this._btnGradColor.color=n,this._btnGradColor.btnEl&&Ext.DomHelper.applyStyles(this._btnGradColor.btnEl,{"background-color":Ext.String.format("#{0}",typeof n=="object"?n.color:n)}),this.GradColor.colors[this.GradColor.currentIdx]=n,this.sldrGradient.setColorValue(Ext.String.format("#{0}",typeof n=="object"?n.color:n));if(this.api&&!this._noApply){var i=new CAscShapeProp,s=new CAscFill;s.put_type(c_oAscFill.FILL_TYPE_GRAD),s.put_fill(new CAscFillGrad),s.get_fill().put_grad_type(this.GradFillType),s.get_fill().put_colors([this.getRgbColor(this.GradColor.colors[0]),this.getRgbColor(this.GradColor.colors[1])]),this.OriginalFillType!==c_oAscFill.FILL_TYPE_GRAD&&(this.GradFillType==c_oAscFillGradType.GRAD_LINEAR&&(s.get_fill().put_linear_angle(l[this.GradLinearDirectionIdx].data.type*6e4),s.get_fill().put_linear_scale(!0)),s.get_fill().put_positions([this.GradColor.values[0]*1e3,this.GradColor.values[1]*1e3])),i.put_fill(s),this.imgprops.put_ShapeProperties(i),this.api.ImgApply(e.imgprops)}this.fireEvent("editcomplete",this)},this)}}),{cls:"menu-item-noicon menu-item-color-palette-theme",text:this.textNewColor,listeners:{click:function(t,n){e.colorsGrad.addNewColor()}}}]},listeners:{render:function(e){var t=Ext.String.format("background-color:#{0}",typeof e.color=="object"?e.color.color:e.color);Ext.DomHelper.applyStyles(e.btnEl,t)}},setColor:function(e){var t,n;this.color=e,e=="transparent"||e.color=="transparent"?(t="1px solid #BEBEBE",n=e):(t="none",n=Ext.String.format("#{0}",typeof e=="object"?e.color:e)),this.btnEl!==undefined&&Ext.DomHelper.applyStyles(this.btnEl,{"background-color":n,border:t})}}),this.controls.push(this.colorsGrad);var h=!1,p,d=function(){if(h){var t=new CAscShapeProp,n=new CAscFill;n.put_type(c_oAscFill.FILL_TYPE_GRAD),n.put_fill(new CAscFillGrad),n.get_fill().put_grad_type(e.GradFillType),n.get_fill().put_positions([e.GradColor.values[0]*1e3,e.GradColor.values[1]*1e3]),e.OriginalFillType!==c_oAscFill.FILL_TYPE_GRAD&&(e.GradFillType==c_oAscFillGradType.GRAD_LINEAR&&(n.get_fill().put_linear_angle(l[e.GradLinearDirectionIdx].data.type*6e4),n.get_fill().put_linear_scale(!0)),n.get_fill().put_colors([e.getRgbColor(e.GradColor.colors[0]),e.getRgbColor(e.GradColor.colors[1])])),t.put_fill(n),e.imgprops.put_ShapeProperties(t),e.api.ImgApply(e.imgprops),h=!1}};this.sldrGradient=Ext.create("Common.component.MultiSliderGradient",{animate:!1,width:140,values:[0,100],increment:1,minValue:0,maxValue:100,useTips:!1,hideLabel:!0,cls:"asc-multi-slider-gradient",listeners:{change:Ext.bind(function(e,t,n){this.GradColor.values=e.getValues(),h=!0,this.api&&!this._noApply&&this._sendUndoPoint&&(this.api.setStartPointHistory(),this._sendUndoPoint=!1,p=setInterval(d,100))},this),changecomplete:Ext.bind(function(e,t,n){clearInterval(p),d(),this.api.setEndPointHistory(),this._sendUndoPoint=!0,Ext.menu.Manager.hideAll()},this),thumbclick:Ext.bind(function(e,t){this.GradColor.currentIdx=t;var n=this.GradColor.colors[this.GradColor.currentIdx];this._btnGradColor.setColor(n),this.colorsGrad.select(n,!1)},this),thumbdblclick:Ext.bind(function(e){this._btnGradColor.showMenu()},this)}}),this.controls.push(this.sldrGradient),this._GradientContainer=Ext.create("Ext.container.Container",{layout:"vbox",layoutConfig:{align:"stretch"},height:150,width:190,hidden:!0,items:[{xtype:"tbspacer",height:5},{xtype:"container",layout:"hbox",width:190,items:[{xtype:"container",layout:"vbox",width:100,height:80,items:[{xtype:"label",text:this.textStyle},{xtype:"tbspacer",height:2},this.cmbGradType,{xtype:"tbspacer",flex:1}]},{xtype:"tbspacer",flex:1},{xtype:"container",layout:"vbox",height:80,items:[{xtype:"label",text:this.textDirection},{xtype:"tbspacer",height:2},this.btnDirection]}]},{xtype:"tbspacer",height:3},{xtype:"label",text:this.textGradient,style:"margin-top: 1px;font-weight: bold;"},{xtype:"tbspacer",height:7},{xtype:"container",layout:{type:"hbox",align:"top"},width:190,height:35,items:[this.sldrGradient,{xtype:"tbspacer",flex:1},this._btnGradColor]}]}),this._GradientContainerHeight=this._GradientContainer.height;var v=function(){if(h!==undefined){var t=new CAscShapeProp,n=new CAscFill;n.put_transparent(h*2.55),t.put_fill(n),e.imgprops.put_ShapeProperties(t),e.api.ImgApply(e.imgprops),h=undefined}};this.numTransparency=Ext.create("Common.component.MetricSpinner",{id:"shape-spin-transparency",readOnly:!1,step:1,width:65,defaultUnit:"%",value:"100 %",maxValue:100,minValue:0,listeners:{change:Ext.bind(function(e,t,n,r){this.sldrTransparency.suspendEvents(!1),this.sldrTransparency.setValue(e.getNumberValue()),this.sldrTransparency.resumeEvents();if(this.api){var i=e.getNumberValue(),s=new CAscShapeProp,o=new CAscFill;o.put_transparent(i*2.55),s.put_fill(o),this.imgprops.put_ShapeProperties(s),this.api.ImgApply(this.imgprops)}this.fireEvent("editcomplete",this)},this)}}),this.controls.push(this.numTransparency),this.sldrTransparency=Ext.create("Ext.slider.Single",{animate:!1,width:80,value:100,increment:1,minValue:0,maxValue:100,useTips:!1,hideLabel:!0,cls:"asc-slider",listeners:{change:Ext.bind(function(e,t,n,r){h=t,this.numTransparency.suspendEvents(!1),this.numTransparency.setValue(t),this.numTransparency.resumeEvents(),this._sendUndoPoint&&(this.api.setStartPointHistory(),this._sendUndoPoint=!1,p=setInterval(v,100))},this),changecomplete:Ext.bind(function(e,t,n,r){clearInterval(p),v(),this.api.setEndPointHistory(),this._sendUndoPoint=!0},this)}}),this.controls.push(this.sldrTransparency);var m=Ext.create("Ext.XTemplate",'<tpl for=".">','<div class="thumb-wrap" data-qtip="{tip}">','<img src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" style="{imgstyle}" class="item-wraplist"/>','<tpl if="title">','<span class="title">{title}</span>',"</tpl>","</div>","</tpl>"),g=[{offsetx:0,data:c_oAscWrapStyle2.Inline,iconcls:"wrap-subtype wrap-inline",tip:this.txtInline},{offsetx:50,data:c_oAscWrapStyle2.Square,iconcls:"wrap-subtype wrap-square",tip:this.txtSquare},{offsetx:100,data:c_oAscWrapStyle2.Tight,iconcls:"wrap-subtype wrap-tight",tip:this.txtTight},{offsetx:150,data:c_oAscWrapStyle2.Through,iconcls:"wrap-subtype wrap-through",tip:this.txtThrough},{offsetx:200,data:c_oAscWrapStyle2.TopAndBottom,iconcls:"wrap-subtype wrap-topAndBottom",tip:this.txtTopAndBottom},{offsetx:250,data:c_oAscWrapStyle2.InFront,iconcls:"wrap-subtype wrap-inFront",tip:this.txtInFront},{offsetx:300,data:c_oAscWrapStyle2.Behind,iconcls:"wrap-subtype wrap-behind",tip:this.txtBehind}];for(var n=0;n<g.length;n++)g[n].imgstyle=Ext.String.format("background-position: {0}px 0;",-g[n].offsetx);this.btnWrapType=Ext.widget("button",{id:"shape-button-wrap",width:72,height:58,cls:"btn-wrap-types",iconCls:"wrap-subtype wrap-inline",pressedCls:"disablepressed",menuAlign:"tl-bl?",menu:Ext.create("Common.component.MenuDataViewPicker",{width:257,height:133,cls:"wrap-view",dataTpl:m,viewData:g,contentWidth:237,listeners:{select:Ext.bind(function(e,t){this.btnWrapType.setIconCls(t.data.iconcls);if(this.api&&!this._noApply){var n=new CImgProperty;n.put_WrappingStyle(t.data.data);if(this._state.WrappingStyle===c_oAscWrapStyle2.Inline&&t.data.data!==c_oAscWrapStyle2.Inline){n.put_PositionH(new CImagePositionH),n.get_PositionH().put_UseAlign(!1),n.get_PositionH().put_RelativeFrom(c_oAscRelativeFromH.Column);var r=this._originalProps.get_Value_X(c_oAscRelativeFromH.Column);n.get_PositionH().put_Value(r),n.put_PositionV(new CImagePositionV),n.get_PositionV().put_UseAlign(!1),n.get_PositionV().put_RelativeFrom(c_oAscRelativeFromV.Paragraph),r=this._originalProps.get_Value_Y(c_oAscRelativeFromV.Paragraph),n.get_PositionV().put_Value(r)}this.api.ImgApply(n)}this.fireEvent("editcomplete",this)},this),hide:Ext.bind(function(){this.fireEvent("editcomplete",this)},this)}})}),this.btnWrapType.menu.picker.selectByIndex(0),this._TransparencyContainer=Ext.create("Ext.container.Container",{layout:"vbox",layoutConfig:{align:"stretch"},height:55,width:190,items:[{xtype:"tbspacer",height:10},{xtype:"label",text:this.strTransparency,style:"margin-top: 1px;font-weight: bold;"},{xtype:"tbspacer",height:2},{xtype:"container",layout:{type:"hbox",align:"middle"},width:190,height:27,items:[{xtype:"label",text:"0",style:"margin: 2px 3px 0 0"},this.sldrTransparency,{xtype:"label",text:"100",style:"margin: 2px 0 0 3px"},{xtype:"tbspacer",flex:1},this.numTransparency]}]}),this._TransparencyContainerHeight=this._TransparencyContainer.height,this._FillImageContainer=Ext.create("Ext.container.Container",{layout:"vbox",layoutConfig:{align:"stretch"},height:120,width:190,hidden:!0,items:[{xtype:"container",layout:"hbox",width:190,items:[this._btnInsertFromFile,{xtype:"tbspacer",flex:1},this._btnInsertFromUrl]},{xtype:"tbspacer",height:11},{xtype:"container",layout:"hbox",width:190,items:[{xtype:"container",layout:"vbox",width:90,height:80,items:[this.cmbFillType,{xtype:"tbspacer",flex:1},{xtype:"label",text:this.textTexture},{xtype:"tbspacer",height:2},this._btnTexture]},{xtype:"tbspacer",flex:1},{xtype:"container",cls:"texture-img-container",layout:"vbox",width:90,height:80,items:[this.textureImage]}]}]}),this._FillImageContainerHeight=this._FillImageContainer.height,this._FillPanel=Ext.create("Ext.container.Container",{layout:"vbox",layoutConfig:{align:"stretch"},height:45,width:190,items:[{xtype:"label",text:this.strFill,style:"margin-top: 1px;font-weight: bold;"},{xtype:"tbspacer",height:7},this.cmbFillSrc]}),this._btnChangeShape=Ext.create("Ext.button.Button",{id:"shape-button-change",width:45,iconCls:"btn-icon-change-shape",cls:"asc-right-panel-edit-btn",tooltip:this.tipShapeArrange,menu:{showSeparator:!1,bodyCls:"no-icons",items:[],listeners:{hide:{fn:function(){e.fireEvent("editcomplete",e)}}},plugins:[{ptype:"menuexpand"}]}}),this._StrokePanel=Ext.create("Ext.container.Container",{layout:"vbox",layoutConfig:{align:"stretch"},height:51,width:190,items:[{xtype:"tbspacer",height:8},{xtype:"container",height:41,layout:{type:"table",columns:2,tdAttrs:{style:"vertical-align: middle;"}},items:[{xtype:"label",text:this.strSize,style:"display: block;",width:80},{xtype:"label",text:this.strColor,style:"display: block;",width:80},{xtype:"tbspacer",height:2},{xtype:"tbspacer",height:2},this.cmbBorderSize,this._btnBorderColor]}]}),this._WrapPanel=Ext.create("Ext.container.Container",{layout:"vbox",layoutConfig:{align:"stretch"},height:70,width:190,items:[{xtype:"tbspacer",height:6},{xtype:"container",height:63,width:190,layout:"hbox",items:[this.btnWrapType]}]}),this._ChangeContainer=Ext.create("Ext.container.Container",{layout:"vbox",layoutConfig:{align:"stretch"},height:36,width:195,items:[{xtype:"tbspacer",height:3},{xtype:"container",height:30,width:190,layout:"hbox",items:[{xtype:"label",text:this.strChange,margin:"2px 0 0 0",style:"font-weight: bold;margin-top: 1px;",flex:1},{xtype:"tbspacer",width:7},this._btnChangeShape,{xtype:"tbspacer",width:5}]}]}),this.items=[{xtype:"tbspacer",height:7},this._FillPanel,{xtype:"tbspacer",height:7},this._FillColorContainer,this._FillImageContainer,this._PatternContainer,this._GradientContainer,this._TransparencyContainer,{xtype:"tbspacer",height:5},{xtype:"tbspacer",width:"100%",height:10,style:"padding-right: 10px;",html:'<div style="width: 100%; height: 40%; border-bottom: 1px solid #C7C7C7"></div>'},{xtype:"label",style:"font-weight: bold;margin-top: 1px;",text:this.strStroke},this._StrokePanel,{xtype:"tbspacer",height:5},{xtype:"tbspacer",width:"100%",height:10,style:"padding-right: 10px;",html:'<div style="width: 100%; height: 40%; border-bottom: 1px solid #C7C7C7"></div>'},{xtype:"label",style:"font-weight: bold;margin-top: 1px;",text:this.textWrap},this._WrapPanel,{xtype:"tbspacer",height:5},{xtype:"tbspacer",width:"100%",height:10,style:"padding-right: 10px;",html:'<div style="width: 100%; height: 40%; border-bottom: 1px solid #C7C7C7"></div>'},this._ChangeContainer,{xtype:"tbspacer",width:"100%",height:10,style:"padding-right: 10px;",html:'<div style="width: 100%; height: 40%; border-bottom: 1px solid #C7C7C7"></div>'},{xtype:"tbspacer",height:3},{xtype:"container",height:20,width:195,items:[{xtype:"box",html:'<div style="width:100%;text-align:center;padding-right:15px;"><label id="shape-advanced-link" class="asc-advanced-link">'+this.textAdvanced+"</label></div>",listeners:{afterrender:function(e){document.getElementById("shape-advanced-link").onclick=Ext.bind(this._openAdvancedSettings,this)},scope:this}}]}],this.addEvents("editcomplete"),this.callParent(arguments)},setApi:function(e){this.api=e;if(this.api){this.api.asc_registerCallback("asc_onImgWrapStyleChanged",Ext.bind(this._ImgWrapStyleChanged,this)),this.api.SetInterfaceDrawImagePlaceShape("shape-texture-img");var t=this.api.get_PropertyStandartTextures();t&&this._onInitStandartTextures(t)}},getRgbColor:function(e){var t=typeof e=="object"?e.color:e;t=t.replace(/#/,""),t.length==3&&(t=t.replace(/(.)/g,"$1$1")),t=parseInt(t,16);var n=new CAscColor;return n.put_type(typeof e=="object"?c_oAscColor.COLOR_TYPE_SCHEME:c_oAscColor.COLOR_TYPE_SRGB),n.put_r(t>>16),n.put_g((t&65280)>>8),n.put_b(t&255),n.put_a(255),e.effectId!==undefined&&n.put_value(e.effectId),n},colorValue2EffectId:function(e){if(typeof e=="object"&&e.effectValue!==undefined&&this.effectcolors){var t=e.effectValue;for(var n=0;n<this.effectcolors.length;n++)if(this.effectcolors[n].effectValue===e.effectValue&&e.color.toUpperCase()===this.effectcolors[n].color.toUpperCase()){e.effectId=this.effectcolors[n].effectId;break}}return e},getHexColor:function(e,t,n){return e=e.toString(16),t=t.toString(16),n=n.toString(16),e.length==1&&(e="0"+e),t.length==1&&(t="0"+t),n.length==1&&(n="0"+n),e+t+n},_pt2mm:function(e){return e*25.4/72},_mm2pt:function(e){return e*72/25.4},FillAutoShapes:function(){var e=Ext.getStore("ShapeGroups"),t=this,n=e.getCount();t._btnChangeShape.menu.removeAll();for(var r=0;r<n;r++){if(r==n-2)continue;var i=e.getAt(r),s=Ext.widget("menuitem",{text:i.data.groupName,hideOnClick:!1,cls:"menu-item-noicon",menuAlign:"tl-tl?",menu:Ext.create("Common.component.MenuDataViewPicker",{width:i.data.groupWidth,height:i.data.groupHeight,store:i.data.groupStore,viewData:[],contentWidth:i.data.groupWidth-20,listeners:{select:Ext.bind(function(e,n){t.api&&t.api.ChangeShapeType(n.data.data.shapeType)},this),hide:function(){t.fireEvent("editcomplete",t)},show:function(e){e.picker.selectByIndex(-1,!1)}},plugins:[{ptype:"menuexpand"}]}),deferExpandMenu:function(){if(!this.menu.rendered||!this.menu.isVisible())this.parentMenu.activeChild=this.menu,this.menu.parentItem=this,this.menu.parentMenu=this.menu.ownerCt=this.parentMenu,this.menu.showBy(this,this.menuAlign,[-this.menu.width,0])}});t._btnChangeShape.menu.add(s)}},_onOpenImageFromURL:function(e){var t=this[0],n=this[1].txtUrl;if(e==1&&t.api){var r=n.value.replace(/ /g,"");if(r!=""&&t.BlipFillType!==null){var i=new CAscShapeProp,s=new CAscFill;s.put_type(c_oAscFill.FILL_TYPE_BLIP),s.put_fill(new CAscFillBlip),s.get_fill().put_type(t.BlipFillType),s.get_fill().put_url(n.value),i.put_fill(s),t.imgprops.put_ShapeProperties(i),t.api.ImgApply(t.imgprops)}}},_ShowHideElem:function(e,t,n){var r=this.getHeight(),i=0;for(var s=0;s<e.length;s++)e[s]&&!t[s].isVisible()&&(t[s].show(),i+=n[s]),!e[s]&&t[s].isVisible()&&(i-=n[s],t[s].hide());this.setHeight(r+i),this.initialHeight=r+i,this.ownerCt.setHeight(this.initialHeight)},ChangeSettings:function(e){this.imgprops==null?this.imgprops=new CImgProperty:this.imgprops.put_ImageUrl(null),this._initSettings&&this.createDelayedElements(),this._initSettings=!1;if(e&&e.get_ShapeProperties()){var t=e.get_ShapeProperties();this._originalProps=new CImgProperty(e),this.SuspendEvents(),this._noApply=!0,this.disableFillPanels(!t.get_CanFill());var n=e.get_WrappingStyle();if(this._state.WrappingStyle!==n){var r=this.btnWrapType.menu.picker.store.find("data",n);this.btnWrapType.menu.picker.selectByIndex(r,!1),r>=0?this.btnWrapType.setIconCls(this.btnWrapType.menu.viewData[r].iconcls):this.btnWrapType.setIconCls(""),this._state.WrappingStyle=n}n=e.get_CanBeFlow();var i=e.get_FromGroup();if(this._state.CanBeFlow!==n||this._state.FromGroup!==i)this.btnWrapType.setDisabled(!n||i),this._state.CanBeFlow=n,this._state.FromGroup=i;var s=null,o=t.get_fill(),u=o.get_type(),a=null,f=o.get_transparent();if(Math.abs(this._state.Transparency-f)>.001||Math.abs(this.numTransparency.getNumberValue()-f)>.001||(this._state.Transparency===null||f===null)&&(this._state.Transparency!==f||this.numTransparency.getNumberValue()!==f))f!==undefined&&(this.sldrTransparency.setValue(f===null?100:f/255*100),this.numTransparency.setValue(this.sldrTransparency.getValue())),this._state.Transparency=f;if(o===null||u===null||u==c_oAscFill.FILL_TYPE_NOFILL)this.OriginalFillType=c_oAscFill.FILL_TYPE_NOFILL;else if(u==c_oAscFill.FILL_TYPE_SOLID)o=o.get_fill(),a=o.get_color(),a?a.get_type()==c_oAscColor.COLOR_TYPE_SCHEME?this.ShapeColor={Value:1,Color:{color:this.getHexColor(a.get_r(),a.get_g(),a.get_b()),effectValue:a.get_value()}}:this.ShapeColor={Value:1,Color:this.getHexColor(a.get_r(),a.get_g(),a.get_b())}:this.ShapeColor={Value:0,Color:"transparent"},this.OriginalFillType=c_oAscFill.FILL_TYPE_SOLID,this.FGColor=this.ShapeColor.Color!=="transparent"?{Value:1,Color:this.colorValue2EffectId(this.ShapeColor.Color)}:{Value:1,Color:"000000"},this.BGColor={Value:1,Color:"ffffff"};else if(u==c_oAscFill.FILL_TYPE_BLIP)o=o.get_fill(),this.BlipFillType=o.get_type(),this._state.BlipFillType!==this.BlipFillType&&(this.BlipFillType==c_oAscFillBlipType.STRETCH?this.cmbFillType.setValue(this._arrFillType[0]):this.BlipFillType==c_oAscFillBlipType.TILE?this.cmbFillType.setValue(this._arrFillType[1]):this.cmbFillType.setValue(""),this._state.BlipFillType=this.BlipFillType),this.OriginalFillType=c_oAscFill.FILL_TYPE_BLIP;else if(u==c_oAscFill.FILL_TYPE_PATT){o=o.get_fill(),this.PatternFillType=o.get_pattern_type();if(this._state.PatternFillType!==this.PatternFillType){var l=this._cmbPattern.dataMenu.picker.store.findBy(function(e,t){return e.data.data.type===this.PatternFillType},this);this._cmbPattern.selectByIndex(l),this._state.PatternFillType=this.PatternFillType}a=o.get_color_fg(),a?a.get_type()==c_oAscColor.COLOR_TYPE_SCHEME?this.FGColor={Value:1,Color:{color:this.getHexColor(a.get_r(),a.get_g(),a.get_b()),effectValue:a.get_value()}}:this.FGColor={Value:1,Color:this.getHexColor(a.get_r(),a.get_g(),a.get_b())}:this.FGColor={Value:1,Color:"000000"},a=o.get_color_bg(),a?a.get_type()==c_oAscColor.COLOR_TYPE_SCHEME?this.BGColor={Value:1,Color:{color:this.getHexColor(a.get_r(),a.get_g(),a.get_b()),effectValue:a.get_value()}}:this.BGColor={Value:1,Color:this.getHexColor(a.get_r(),a.get_g(),a.get_b())}:this.BGColor={Value:1,Color:"ffffff"},this.OriginalFillType=c_oAscFill.FILL_TYPE_PATT,this.ShapeColor=this.FGColor.Color!=="transparent"?{Value:1,Color:this.colorValue2EffectId(this.FGColor.Color)}:{Value:1,Color:"ffffff"}}else if(u==c_oAscFill.FILL_TYPE_GRAD){o=o.get_fill();var c=o.get_grad_type();if(this._state.GradFillType!==c||this.GradFillType!==c)this.GradFillType=c,s=undefined,this.GradFillType==c_oAscFillGradType.GRAD_LINEAR?s=this.cmbGradType.getStore().getAt(0):this.GradFillType==c_oAscFillGradType.GRAD_PATH?s=this.cmbGradType.getStore().getAt(1):(this.cmbGradType.setValue(""),this.btnDirection.setIconCls("")),s&&(this.cmbGradType.select(s),this.cmbGradType.fireEvent("select",this.cmbGradType,[s])),this._state.GradFillType=this.GradFillType;if(this.GradFillType==c_oAscFillGradType.GRAD_LINEAR){var n=Math.floor(o.get_linear_angle()/6e4),h,r=this.btnDirection.menu.picker.store.findBy(function(e,t){return h=e.data.iconcls,e.data.data.type===n},this);r!==this.GradLinearDirectionIdx&&(this.GradLinearDirectionIdx=r,this.btnDirection.menu.picker.selectByIndex(this.GradLinearDirectionIdx,!1),this.GradLinearDirectionIdx>=0?this.btnDirection.setIconCls(h):this.btnDirection.setIconCls(""))}var p=o.get_colors();p&&p.length>0&&(a=p[0],a?a.get_type()==c_oAscColor.COLOR_TYPE_SCHEME?(this.GradColor.colors[0]={color:this.getHexColor(a.get_r(),a.get_g(),a.get_b()),effectValue:a.get_value()},this.colorValue2EffectId(this.GradColor.colors[0])):this.GradColor.colors[0]=this.getHexColor(a.get_r(),a.get_g(),a.get_b()):this.GradColor.colors[0]="000000",a=p[1],a?a.get_type()==c_oAscColor.COLOR_TYPE_SCHEME?(this.GradColor.colors[1]={color:this.getHexColor(a.get_r(),a.get_g(),a.get_b()),effectValue:a.get_value()},this.colorValue2EffectId(this.GradColor.colors[1])):this.GradColor.colors[1]=this.getHexColor(a.get_r(),a.get_g(),a.get_b()):this.GradColor.colors[1]="ffffff");var d=o.get_positions();if(d&&d.length>0){var v=d[0];v!==null&&(v/=1e3,this.GradColor.values[0]=v),v=d[1],v!==null&&(v/=1e3,this.GradColor.values[1]=v)}this.sldrGradient.setColorValue(Ext.String.format("#{0}",typeof this.GradColor.colors[0]=="object"?this.GradColor.colors[0].color:this.GradColor.colors[0]),0),this.sldrGradient.setColorValue(Ext.String.format("#{0}",typeof this.GradColor.colors[1]=="object"?this.GradColor.colors[1].color:this.GradColor.colors[1]),1),this.sldrGradient.setValue(0,this.GradColor.values[0]),this.sldrGradient.setValue(1,this.GradColor.values[1]),this.OriginalFillType=c_oAscFill.FILL_TYPE_GRAD}if(this._state.FillType!==this.OriginalFillType){switch(this.OriginalFillType){case c_oAscFill.FILL_TYPE_SOLID:s=this.cmbFillSrc.getStore().getAt(0);break;case c_oAscFill.FILL_TYPE_GRAD:s=this.cmbFillSrc.getStore().getAt(1);break;case c_oAscFill.FILL_TYPE_BLIP:s=this.cmbFillSrc.getStore().getAt(2);break;case c_oAscFill.FILL_TYPE_PATT:s=this.cmbFillSrc.getStore().getAt(3);break;case c_oAscFill.FILL_TYPE_NOFILL:s=this.cmbFillSrc.getStore().getAt(4)}s&&(this.cmbFillSrc.select(s),this.cmbFillSrc.fireEvent("select",this.cmbFillSrc,[s])),this._state.FillType=this.OriginalFillType}this._btnTexture.setText(this.textSelectTexture);var m=typeof this.ShapeColor.Color,g=typeof this._state.ShapeColor;if(m!==g||m=="object"&&(this.ShapeColor.Color.effectValue!==this._state.ShapeColor.effectValue||this._state.ShapeColor.color.indexOf(this.ShapeColor.Color.color)<0)||m!="object"&&this._state.ShapeColor.indexOf(this.ShapeColor.Color)<0){this._btnBackColor.setColor(this.ShapeColor.Color);if(typeof this.ShapeColor.Color=="object"){for(var y=0;y<10;y++)if(this.ThemeValues[y]==this.ShapeColor.Color.effectValue){this.colorsBack.select(this.ShapeColor.Color,!1);break}}else this.colorsBack.select(this.ShapeColor.Color,!1);this._state.ShapeColor=this.ShapeColor.Color}var b=t.get_stroke(),w=b.get_type();b?w==c_oAscStrokeType.STROKE_COLOR?(a=b.get_color(),a?a.get_type()==c_oAscColor.COLOR_TYPE_SCHEME?this.BorderColor={Value:1,Color:{color:this.getHexColor(a.get_r(),a.get_g(),a.get_b()),effectValue:a.get_value()}}:this.BorderColor={Value:1,Color:this.getHexColor(a.get_r(),a.get_g(),a.get_b())}:this.BorderColor={Value:1,Color:"transparent"}):this.BorderColor={Value:1,Color:"transparent"}:(w=null,this.BorderColor={Value:0,Color:"transparent"}),m=typeof this.BorderColor.Color,g=typeof this._state.StrokeColor;if(m!==g||m=="object"&&(this.BorderColor.Color.effectValue!==this._state.StrokeColor.effectValue||this._state.StrokeColor.color.indexOf(this.BorderColor.Color.color)<0)||m!="object"&&(this._state.StrokeColor.indexOf(this.BorderColor.Color)<0||typeof this._btnBorderColor.color=="object")){this._btnBorderColor.setColor(this.BorderColor.Color);if(typeof this.BorderColor.Color=="object"){for(var y=0;y<10;y++)if(this.ThemeValues[y]==this.BorderColor.Color.effectValue){this.colorsBorder.select(this.BorderColor.Color,!1);break}}else this.colorsBorder.select(this.BorderColor.Color,!1);this._state.StrokeColor=this.BorderColor.Color}if(this._state.StrokeType!==w||w==c_oAscStrokeType.STROKE_COLOR){if(w==c_oAscStrokeType.STROKE_COLOR){var E=b.get_width();if(Math.abs(this._state.StrokeWidth-E)>.001||(this._state.StrokeWidth===null||E===null)&&this._state.StrokeWidth!==E){this._state.StrokeWidth=E;var r=-1;E!==null&&(E=this._mm2pt(E),Ext.each(this.cmbBorderSize.getStore().data.items,function(e,t){if(E<e.data.value+.01&&E>e.data.value-.01)return r=t,!1})),r>-1?(s=this.cmbBorderSize.getStore().getAt(r),this.cmbBorderSize.select(s),this.cmbBorderSize.fireEvent("select",this.cmbBorderSize,[s])):(s={borderstyle:"",text:"",value:E,offsety:-1},s=this.cmbBorderSize.getStore().add(s),this.cmbBorderSize.select(s[0]),this.cmbBorderSize.fireEvent("select",this.cmbBorderSize,[s[0]]),this.cmbBorderSize.getStore().remove(s[0]))}}else w==c_oAscStrokeType.STROKE_NONE?(this._state.StrokeWidth=0,s=this.cmbBorderSize.getStore().getAt(0),this.cmbBorderSize.select(s),this.cmbBorderSize.fireEvent("select",this.cmbBorderSize,[s])):(this._state.StrokeWidth=null,s={borderstyle:"",text:"",value:-1,offsety:-1},s=this.cmbBorderSize.getStore().add(s),this.cmbBorderSize.select(s[0]),this.cmbBorderSize.fireEvent("select",this.cmbBorderSize,[s[0]]),this.cmbBorderSize.getStore().remove(s[0]));this._state.StrokeType=w}m=typeof this.FGColor.Color,g=typeof this._state.FGColor;if(m!==g||m=="object"&&(this.FGColor.Color.effectValue!==this._state.FGColor.effectValue||this._state.FGColor.color.indexOf(this.FGColor.Color.color)<0)||m!="object"&&this._state.FGColor.indexOf(this.FGColor.Color)<0){this._btnFGColor.setColor(this.FGColor.Color);if(typeof this.FGColor.Color=="object"){for(var y=0;y<10;y++)if(this.ThemeValues[y]==this.FGColor.Color.effectValue){this.colorsFG.select(this.FGColor.Color,!1);break}}else this.colorsFG.select(this.FGColor.Color,!1);this._state.FGColor=this.FGColor.Color}m=typeof this.BGColor.Color,g=typeof this._state.BGColor;if(m!==g||m=="object"&&(this.BGColor.Color.effectValue!==this._state.BGColor.effectValue||this._state.BGColor.color.indexOf(this.BGColor.Color.color)<0)||m!="object"&&this._state.BGColor.indexOf(this.BGColor.Color)<0){this._btnBGColor.setColor(this.BGColor.Color);if(typeof this.BGColor.Color=="object"){for(var y=0;y<10;y++)if(this.ThemeValues[y]==this.BGColor.Color.effectValue){this.colorsBG.select(this.BGColor.Color,!1);break}}else this.colorsBG.select(this.BGColor.Color,!1);this._state.BGColor=this.BGColor.Color}a=this.GradColor.colors[this.GradColor.currentIdx],m=typeof a,g=typeof this._state.GradColor;if(m!==g||m=="object"&&(a.effectValue!==this._state.GradColor.effectValue||this._state.GradColor.color.indexOf(a.color)<0)||m!="object"&&this._state.GradColor.indexOf(a)<0){this._btnGradColor.setColor(a);if(typeof a=="object"){for(var y=0;y<10;y++)if(this.ThemeValues[y]==a.effectValue){this.colorsGrad.select(a,!1);break}}else this.colorsGrad.select(a,!1);this._state.GradColor=a}this._noApply=!1,this.ResumeEvents()}},_ImgWrapStyleChanged:function(e){if(this._state.WrappingStyle!==e){this._noApply=!0;var t=this.btnWrapType.menu.picker.store.find("data",e);this.btnWrapType.menu.picker.selectByIndex(t,!1),t>=0&&this.btnWrapType.setIconCls(this.btnWrapType.menu.viewData[t].iconcls),this._state.WrappingStyle=e,this._noApply=!1}},SendThemeColors:function(e,t){this.effectcolors=e,t&&t.length>0&&(this.standartcolors=t),this._initSettings||(this.colorsBorder.updateColors(e,t),this.colorsBack.updateColors(e,t),this.colorsFG.updateColors(e,t),this.colorsBG.updateColors(e,t),this.colorsGrad.updateColors(e,t))},_openAdvancedSettings:function(e){var t=this,n;if(t.api){var r=t.api.getSelectedElements();if(r&&Ext.isArray(r)){var i,s;for(var o=r.length-1;o>=0;o--){i=r[o].get_ObjectType(),s=r[o].get_ObjectValue();if(c_oAscTypeSelectElement.Image==i){n=Ext.create("DE.view.ImageSettingsAdvanced",{}),n.updateMetricUnit(),n.setSettings(s);break}}}}n&&(n.addListener("onmodalresult",Ext.bind(function(e,t,n){t==1&&n&&this.api.ImgApply(n)},this),!1),n.addListener("close",function(){t.fireEvent("editcomplete",t)},!1),n.show())},_onInitStandartTextures:function(e){var t=this;if(!Ext.isEmpty(e)){var n=this.textureMenu.picker.store;if(n){n.removeAll();var r=[];Ext.each(e,function(e){r.push({imageUrl:e.get_image(),name:t.textureNames[e.get_id()],data:{type:e.get_id()}})}),n.add(r)}}},_arrangeSlideItems:function(){if(!this.needArrangeSlideItems)return;var e=this;if(this.getEl()){var t=this.getEl().down(".jspPane");if(t&&t.getHeight()>0&&this.getEl().getHeight()>0)var n=0,r=setInterval(function(){e.needArrangeSlideItems&&e.resizeSlideItems();if(!e.needArrangeSlideItems){clearInterval(r),e.doLayout();return}n++>5&&clearInterval(r)},100)}},_resizeSlideItems:function(){var e=5,t="div.thumb-wrap",n=this.getEl(),r=n.query(t),i=0;while(i<r.length){var s=0;for(var o=i;o<i+e;o++){if(o>=r.length)break;var u=Ext.get(r[o]),a=u.getHeight();if(a<28)return;a<s?u.setHeight(s):s=a}i+=e}r.length>0&&(this.needArrangeSlideItems=!1)},hideMenus:function(){this._btnBorderColor.hideMenu(),this._btnBackColor.hideMenu(),this._btnTexture.hideMenu(),this._btnChangeShape.hideMenu(),this._btnBGColor.hideMenu(),this._btnFGColor.hideMenu(),this._cmbPattern.dataMenu.hide(),this.btnDirection.hideMenu(),this._btnGradColor.hideMenu()},createDelayedElements:function(){var e=[0,1,3,2,4,53,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,22,23,24,25,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,49,50,51,52];this.patternViewData=[];for(var t=0;t<13;t++)for(var n=0;n<4;n++){var r=t*4+n;this.patternViewData[r]={offsetx:n*28,offsety:t*28,data:{type:e[r]}}}this.patternViewData.splice(this.patternViewData.length-2,2);for(var t=0;t<this.patternViewData.length;t++)this.patternViewData[t].imageCls="item-combo-pattern",this.patternViewData[t].imageStyle=Ext.String.format("background-position: {0}px {1}px;",-this.patternViewData[t].offsetx,-this.patternViewData[t].offsety),this.patternViewData[t].uid=Ext.id();this._cmbPattern.dataMenu.picker.store.loadData(this.patternViewData),this.FillAutoShapes(),this.effectcolors&&this.standartcolors&&(this.colorsBorder.updateColors(this.effectcolors,this.standartcolors),this.colorsBack.updateColors(this.effectcolors,this.standartcolors),this.colorsFG.updateColors(this.effectcolors,this.standartcolors),this.colorsBG.updateColors(this.effectcolors,this.standartcolors),this.colorsGrad.updateColors(this.effectcolors,this.standartcolors))},disableFillPanels:function(e){this._state.DisabledFillPanels!==e&&(this._state.DisabledFillPanels=e,this._FillPanel.setDisabled(e),this._FillColorContainer.setDisabled(e),this._FillImageContainer.setDisabled(e),this._PatternContainer.setDisabled(e),this._GradientContainer.setDisabled(e),this._TransparencyContainer.setDisabled(e))},txtTitle:"Autoshape",txtNoBorders:"No Line",strStroke:"Stroke",strColor:"Color",strSize:"Size",strChange:"Change Autoshape",strFill:"Fill",textColor:"Color Fill",textImageTexture:"Picture or Texture",textTexture:"From Texture",textFromUrl:"From URL",textFromFile:"From File",textStretch:"Stretch",textTile:"Tile",txtCanvas:"Canvas",txtCarton:"Carton",txtDarkFabric:"Dark Fabric",txtGrain:"Grain",txtGranite:"Granite",txtGreyPaper:"Grey Paper",txtKnit:"Knit",txtLeather:"Leather",txtBrownPaper:"Brown Paper",txtPapyrus:"Papyrus",txtWood:"Wood",textNewColor:"Add New Custom Color",textThemeColors:"Theme Colors",textStandartColors:"Standart Colors",textAdvanced:"Show advanced settings",strTransparency:"Opacity",textNoFill:"No Fill",textSelectTexture:"Select",textGradientFill:"Gradient Fill",textPatternFill:"Pattern",strBackground:"Background color",strForeground:"Foreground color",strPattern:"Pattern",textEmptyPattern:"No Pattern",textLinear:"Linear",textRadial:"Radial",textDirection:"Direction",textStyle:"Style",textGradient:"Gradient",textWrap:"Wraping Style",txtInline:"Inline",txtSquare:"Square",txtTight:"Tight",txtThrough:"Through",txtTopAndBottom:"Top and bottom",txtBehind:"Behind",txtInFront:"In front"}),Ext.define("DE.view.RightPanel",{extend:"Ext.container.Container",alias:"widget.derightpanel",width:220,layout:{type:"auto"},autoScroll:!0,cls:"asc-right-panel-container",preventHeader:!0,requires:["Ext.toolbar.Toolbar","Ext.container.Container","Common.plugin.ScrollPane","DE.view.TableSettings","DE.view.ParagraphSettings","DE.view.ImageSettings","DE.view.HeaderFooterSettings","DE.view.ShapeSettings","Ext.Button"],uses:["Ext.DomHelper","Ext.util.Cookies"],listeners:{afterrender:function(){var e=this.ownerCt;Ext.isDefined(e)&&e.addListener("resize",Ext.bind(this.resizeRightPanels,this))}},resizeRightPanels:function(e){this.doComponentLayout()},constructor:function(e){return this.callParent(arguments),this.initConfig(e),this},initComponent:function(){var e=this;e.editMode=!0,e.minimizedMode=!0,e.plugins=[{ptype:"scrollpane",pluginId:"scrollpane",areaSelector:".x-container",settings:{enableKeyboardNavigation:!0,verticalGutter:0}}],e.callParent(arguments)},updateScrollPane:function(){var e=this;e.getPlugin("scrollpane").updateScrollPane()},onFocusObject:function(e){if(!this.editMode)return;var t=!0;for(var n=0;n<this._settings.length;n++)this._settings[n]&&(this._settings[n].hidden=1,this._settings[n].locked=!1);for(n=0;n<e.length;n++){var r=e[n].get_ObjectType();if(r>=this._settings.length||this._settings[r]===undefined)continue;var i=e[n].get_ObjectValue();r==c_oAscTypeSelectElement.Image&&i.get_ShapeProperties()!==null&&(r=c_oAscTypeSelectElement.Shape),this._settings[r].props=i,this._settings[r].hidden=0,this._settings[r].locked=i.get_Locked()}if(this._settings[c_oAscTypeSelectElement.Header].locked)for(n=0;n<this._settings.length;n++)this._settings[n]&&(this._settings[n].locked=!0);var s=-1,o,u=-1;for(n=0;n<this._settings.length;n++){if(this._settings[n]===undefined)continue;this._settings[n].hidden?(this._settings[n].btn.isDisabled()||this._settings[n].btn.setDisabled(!0),this.TabPanel.getLayout().getActiveItem()==this._settings[n].panel&&(o=-1)):(this._settings[n].btn.isDisabled()&&this._settings[n].btn.setDisabled(!1),s=n,this._settings[n].needShow?(this._settings[n].needShow=!1,u=n):this.TabPanel.getLayout().getActiveItem()==this._settings[n].panel&&(o=n),this._settings[n].panel.isDisabled()!==this._settings[n].locked&&this._settings[n].panel.setDisabled(this._settings[n].locked))}if(!this.minimizedMode){var a;u>-1?a=u:s>=0&&o<0?a=s:o>=0&&(a=o),a!==undefined&&(this._settings[a].btn.pressed?this._settings[a].panel.ChangeSettings.call(this._settings[a].panel,this._settings[a].props):this._settings[a].btn.toggle())}this._settings[c_oAscTypeSelectElement.Image].needShow=!1,this._settings[c_oAscTypeSelectElement.Shape].needShow=!1},onInsertTable:function(){this._settings[c_oAscTypeSelectElement.Table].needShow=!0},onInsertImage:function(){this._settings[c_oAscTypeSelectElement.Image].needShow=!0},onInsertShape:function(){this._settings[c_oAscTypeSelectElement.Shape].needShow=!0},FillAutoShapes:function(){this.ShapePanel.FillAutoShapes()},SendThemeColors:function(e,t){this.effectcolors=e,t&&t.length>0&&(this.standartcolors=t),this.ShapePanel&&this.TablePanel&&this.ParagraphPanel&&(this.ShapePanel.SendThemeColors(e,t),this.TablePanel.SendThemeColors(e,t),this.ParagraphPanel.SendThemeColors(e,t))},setApi:function(e){return this.api=e,this},setMode:function(e){this.editMode=e.isEdit},updateMetricUnit:function(){this.HeaderFooterPanel.updateMetricUnit(),this.ParagraphPanel.updateMetricUnit(),this.ImagePanel.updateMetricUnit()},createDelayedElements:function(){var e=this;e.panelHolder=Ext.create("Ext.container.Container",{layout:{type:"anchor"},items:[e.TabPanel=Ext.create("Ext.panel.Panel",{hidden:!0,id:"view-tab-panel",cls:"asc-right-tabpanel",preventHeader:!0,layout:"card",items:[e.ParagraphPanel=Ext.create("DE.view.ParagraphSettings",{id:"view-paragraph-settings",cls:"asc-right-panel",type:c_oAscTypeSelectElement.Paragraph}),e.TablePanel=Ext.create("DE.view.TableSettings",{id:"view-table-settings",cls:"asc-right-panel",type:c_oAscTypeSelectElement.Table}),e.ImagePanel=Ext.create("DE.view.ImageSettings",{id:"view-image-settings",cls:"asc-right-panel",type:c_oAscTypeSelectElement.Image}),e.HeaderFooterPanel=Ext.create("DE.view.HeaderFooterSettings",{id:"view-headerfooter-settings",cls:"asc-right-panel",type:c_oAscTypeSelectElement.Header}),e.ShapePanel=Ext.create("DE.view.ShapeSettings",{id:"view-shape-settings",cls:"asc-right-panel",type:c_oAscTypeSelectElement.Shape})],listeners:{afterlayout:function(){e.updateScrollPane()}}})],listeners:{afterlayout:function(){e.updateScrollPane()}}}),e.add(e.panelHolder),e._settings=[],e._settings[c_oAscTypeSelectElement.Paragraph]={panel:e.ParagraphPanel,btn:e.btnText,hidden:1,locked:!1},e._settings[c_oAscTypeSelectElement.Table]={panel:e.TablePanel,btn:e.btnTable,hidden:1,locked:!1},e._settings[c_oAscTypeSelectElement.Image]={panel:e.ImagePanel,btn:e.btnImage,hidden:1,locked:!1},e._settings[c_oAscTypeSelectElement.Header]={panel:e.HeaderFooterPanel,btn:e.btnHeaderFooter,hidden:1,locked:!1,needShow:!0},e._settings[c_oAscTypeSelectElement.Shape]={panel:e.ShapePanel,btn:e.btnShape,hidden:1,locked:!1},this.api&&(this.HeaderFooterPanel.setApi(this.api),this.ImagePanel.setApi(this.api),this.ParagraphPanel.setApi(this.api),this.TablePanel.setApi(this.api),this.ShapePanel.setApi(this.api),this.api.asc_registerCallback("asc_onFocusObject",Ext.bind(this.onFocusObject,this)));if(this.editMode&&this.api){var t=this.api.getSelectedElements();t.length>0&&this.onFocusObject(t)}this.effectcolors&&this.standartcolors&&(this.ShapePanel.SendThemeColors(this.effectcolors,this.standartcolors),this.TablePanel.SendThemeColors(this.effectcolors,this.standartcolors),this.ParagraphPanel.SendThemeColors(this.effectcolors,this.standartcolors))}});var SCALE_MIN=40,MENU_SCALE_PART=260,RIGHTMENU_TOOLBAR_ID="rightmenu-toolbar-id",RIGHTMENU_PANEL_ID="rightmenu-panel-id";Ext.define("DE.view.RightMenu",{extend:"Ext.panel.Panel",alias:"widget.derightmenu",requires:["Ext.toolbar.Toolbar","Ext.button.Button","Ext.container.Container","Ext.toolbar.Spacer","DE.view.RightPanel","Ext.util.Cookies"],cls:"rm-style",id:RIGHTMENU_PANEL_ID,bodyCls:"rm-body",width:SCALE_MIN,buttonCollection:[],listeners:{afterrender:function(){var e=this.ownerCt;Ext.isDefined(e)&&e.addListener("resize",Ext.bind(this.resizeMenu,this))}},initComponent:function(){this.dockedItems=this.buildDockedItems(),this._rightSettings=Ext.widget("derightpanel",{id:"view-right-panel-settings",btnText:this.btnText,btnTable:this.btnTable,btnImage:this.btnImage,btnHeaderFooter:this.btnHeaderFooter,btnShape:this.btnShape}),this.items=[this._rightSettings],this.addEvents("editcomplete"),this.callParent(arguments)},buildDockedItems:function(){var e=this;return e.btnText=Ext.create("Ext.Button",{id:"id-right-menu-text",cls:"asc-main-menu-buttons",iconCls:"asc-main-menu-btn menuText",asctype:c_oAscTypeSelectElement.Paragraph,enableToggle:!0,allowDepress:!0,style:"margin-bottom: 8px;",disabled:!0,toggleGroup:"tabpanelbtnsGroup"}),e.btnTable=Ext.create("Ext.Button",{id:"id-right-menu-table",cls:"asc-main-menu-buttons",iconCls:"asc-main-menu-btn menuTable",asctype:c_oAscTypeSelectElement.Table,enableToggle:!0,allowDepress:!0,style:"margin-bottom: 8px;",disabled:!0,toggleGroup:"tabpanelbtnsGroup"}),e.btnImage=Ext.create("Ext.Button",{id:"id-right-menu-image",cls:"asc-main-menu-buttons",iconCls:"asc-main-menu-btn menuImage",asctype:c_oAscTypeSelectElement.Image,enableToggle:!0,allowDepress:!0,style:"margin-bottom: 8px;",disabled:!0,toggleGroup:"tabpanelbtnsGroup"}),e.btnHeaderFooter=Ext.create("Ext.Button",{id:"id-right-menu-header",cls:"asc-main-menu-buttons",iconCls:"asc-main-menu-btn menuHeaderFooter",asctype:c_oAscTypeSelectElement.Header,enableToggle:!0,allowDepress:!0,style:"margin-bottom: 8px;",disabled:!0,toggleGroup:"tabpanelbtnsGroup"}),e.btnShape=Ext.create("Ext.button.Button",{id:"id-right-menu-shape",cls:"asc-main-menu-buttons",iconCls:"asc-main-menu-btn menuShape",asctype:c_oAscTypeSelectElement.Shape,enableToggle:!0,allowDepress:!0,style:"margin-bottom: 8px;",disabled:!0,toggleGroup:"tabpanelbtnsGroup"}),this.rightToolbar=Ext.create("Ext.toolbar.Toolbar",{cls:"rm-default-toolbar",width:this.width||SCALE_MIN,vertical:!0,dock:"right",defaultType:"button",style:"padding-top: 15px;",items:[e.btnText,e.btnTable,e.btnImage,e.btnHeaderFooter,e.btnShape]}),this.rightToolbar},resizeMenu:function(e,t,n,r){for(var i=0;i<this.items.length;i++)this.items.items[i].el&&n!=this.items.items[i].getHeight()&&this.items.items[i].setHeight(n);this.doComponentLayout()},setApi:function(e){return this.api=e,this.api.asc_registerCallback("asc_onСoAuthoringDisconnect",Ext.bind(this.onCoAuthoringDisconnect,this)),this},disableMenu:function(e){var t,n,r=this.rightToolbar;if(Ext.isDefined(r))for(n=0;n<r.items.length;n++)t=r.items.items[n],Ext.isDefined(t)&&t.componentCls==="x-btn"&&(t.pressed&&t.toggle(!1),t.setDisabled(e))},onCoAuthoringDisconnect:function(){this.disableMenu(!0),this._rightSettings&&(this._rightSettings.setDisabled(!0),this._rightSettings.setMode({isEdit:!1}))},createDelayedElements:function(){var e=this;e._rightSettings.setHeight(e.getHeight());var t=function(t,n){if(n&&!e._rightSettings.minimizedMode){t.addCls("asc-main-menu-btn-selected");var r=e._rightSettings._settings[t.asctype].panel,i=e._rightSettings._settings[t.asctype].props;e._rightSettings.TabPanel.getLayout().setActiveItem(r),e._rightSettings.TabPanel.setHeight(r.initialHeight),i&&r.ChangeSettings.call(r,i)}},n=function(n){n.pressed?e._rightSettings.minimizedMode?(e._rightSettings.TabPanel.hidden&&e._rightSettings.TabPanel.setVisible(!0),e.setWidth(MENU_SCALE_PART),e._rightSettings.minimizedMode=!1,t(n,n.pressed),window.localStorage.setItem("de-hidden-right-settings",0)):n.addCls("asc-main-menu-btn-selected"):(e.setWidth(SCALE_MIN),e._rightSettings.minimizedMode=!0,n.removeCls("asc-main-menu-btn-selected"),window.localStorage.setItem("de-hidden-right-settings",1)),e.fireEvent("editcomplete",e)},r,i=[e.txtParagraphSettings,e.txtTableSettings,e.txtImageSettings,e.txtHeaderFooterSettings,e.txtShapeSettings];for(var s=this.rightToolbar.items.items.length;s--;)r=this.rightToolbar.items.items[s],r.on({click:n,toggle:t}),r.setTooltip(i[s])},txtParagraphSettings:"Paragraph Settings",txtImageSettings:"Image Settings",txtTableSettings:"Table Settings",txtHeaderFooterSettings:"Header and Footer Settings",txtShapeSettings:"Shape Settings",txtChartSettings:"Chart Settings"}),Ext.define("DE.view.Toolbar",{extend:"Ext.toolbar.Toolbar",alias:"widget.detoolbar",cls:"de-toolbar",height:68,minWidth:1175,_state:{clrhighlight:undefined,clrtext:undefined},layout:{type:"hbox",align:"middle"},requires:["Ext.data.Store","Ext.data.Model","Common.component.MenuDataViewPicker","Common.component.SplitColorButton","Common.component.ComboDataView","DE.component.DimensionPicker","Common.plugin.ComboBoxScrollPane","Ext.form.field.ComboBox","Common.view.ComboFonts","Ext.Array","Ext.util.Cookies","Common.component.SynchronizeTip","Common.component.ThemeColorPalette","Common.plugin.MenuExpand","Ext.util.Cookies"],constructor:function(e){return this.initConfig(e),this.callParent(arguments),this},initComponent:function(){function r(t,n){n==="menu"&&(e.mnuHighlightTransparent.setChecked(!1),e.btnHighlightColor.setColor(t),e.btnHighlightColor.toggle(!0,!0),Ext.menu.Manager.hideAll());if(t=="transparent")e.api.SetMarkerFormat(!0,!1);else{var r=t[0]+t[1],i=t[2]+t[3],s=t[4]+t[5];e.api.SetMarkerFormat(!0,!0,parseInt(r,16),parseInt(i,16),parseInt(s,16))}e.fireEvent("editcomplete",e),Common.component.Analytics.trackEvent("ToolBar","Highlight Color")}var e=this;this.addEvents("editcomplete"),this.addEvents("inserttable","insertimage","insertshape"),this.paragraphControls=[],this.synchTooltip=undefined,this.ThemeValues=[6,15,7,16,0,1,2,3,4,5],this.SchemeNames=[this.txtScheme1,this.txtScheme2,this.txtScheme3,this.txtScheme4,this.txtScheme5,this.txtScheme6,this.txtScheme7,this.txtScheme8,this.txtScheme9,this.txtScheme10,this.txtScheme11,this.txtScheme12,this.txtScheme13,this.txtScheme14,this.txtScheme15,this.txtScheme16,this.txtScheme17,this.txtScheme18,this.txtScheme19,this.txtScheme20,this.txtScheme21];var t=window.localStorage.getItem("de-hide-synch");this.showSynchTip=!t||parseInt(t)!=1,this.needShowSynchTip=!1,this.cmbFont=Ext.create("Common.view.ComboFonts",{id:"toolbar-combo-fonts",margin:"0 4 0 0",width:128,cls:"asc-toolbar-combo",editable:!0,selectOnFocus:!0,tooltip:this.tipFontName,showlastused:!0,enableKeyEvents:!0,preventMark:!0,validateOnBlur:!1,validateOnChange:!1,plugins:[{ptype:"comboboxscrollpane",pluginId:"scrollpane",settings:{enableKeyboardNavigation:!0}}]}),this.paragraphControls.push(this.cmbFont),Ext.define("DE.view.FontSize",{extend:"Ext.data.Model",fields:[{type:"int",name:"sizevalue"},{type:"string",name:"sizestring"}]});var n=Ext.create("Ext.data.Store",{model:"DE.view.FontSize",data:[]});this.cmbFontSize=Ext.create("Ext.form.field.ComboBox",{id:"toolbar-combo-font-size",store:n,displayField:"sizestring",queryMode:"local",typeAhead:!1,selectOnFocus:!0,margin:"0 4 0 0",width:60,cls:"asc-toolbar-combo",listConfig:{maxHeight:400},preventMark:!0,validateOnBlur:!1,validateOnChange:!1,listeners:{render:{fn:function(t){t.el.set({"data-qtip":e.tipFontSize}),t.validate()}}}}),this.paragraphControls.push(this.cmbFontSize),this.btnBold=Ext.create("Ext.Button",{id:"toolbar-button-bold",tooltip:this.textBold+" (Ctrl+B)",iconCls:"asc-toolbar-btn btn-bold",enableToggle:!0}),this.paragraphControls.push(this.btnBold),this.btnItalic=Ext.create("Ext.Button",{id:"toolbar-button-italic",tooltip:this.textItalic+" (Ctrl+I)",iconCls:"asc-toolbar-btn btn-italic",enableToggle:!0}),this.paragraphControls.push(this.btnItalic),this.btnUnderline=Ext.create("Ext.Button",{id:"toolbar-button-underline",tooltip:this.textUnderline+" (Ctrl+U)",iconCls:"asc-toolbar-btn btn-underline",enableToggle:!0}),this.paragraphControls.push(this.btnUnderline),this.btnStrikeout=Ext.create("Ext.Button",{id:"toolbar-strikeout",tooltip:this.textStrikeout,iconCls:"asc-toolbar-btn btn-strike",enableToggle:!0}),this.paragraphControls.push(this.btnStrikeout),this.btnSuperscript=Ext.create("Ext.Button",{id:"toolbar-button-superscript",tooltip:this.textSuperscript,iconCls:"asc-toolbar-btn btn-superscript",enableToggle:!0,toggleGroup:"subscriptGroup"}),this.paragraphControls.push(this.btnSuperscript),this.btnSubscript=Ext.create("Ext.Button",{id:"toolbar-button-subscript",tooltip:this.textSubscript,iconCls:"asc-toolbar-btn btn-subscript",enableToggle:!0,toggleGroup:"subscriptGroup"}),this.paragraphControls.push(this.btnSubscript),this.btnPrint=Ext.create("Ext.Button",{id:"toolbar-button-print",tooltip:this.tipPrint+" (Ctrl+P)",iconCls:"asc-toolbar-btn btn-print"}),this.btnSave=Ext.create("Ext.Button",{id:"toolbar-button-save",tooltip:this.tipSave+" (Ctrl+S)",iconCls:"asc-toolbar-btn btn-save"}),this.btnCopy=Ext.create("Ext.Button",{id:"toolbar-button-copy",tooltip:this.tipCopy+" (Ctrl+C)",iconCls:"asc-toolbar-btn btn-copy"}),this.btnPaste=Ext.create("Ext.Button",{id:"toolbar-button-paste",tooltip:this.tipPaste+" (Ctrl+V)",iconCls:"asc-toolbar-btn btn-paste"}),this.btnUndo=Ext.create("Ext.Button",{id:"toolbar-button-undo",tooltip:this.tipUndo+" (Ctrl+Z)",iconCls:"asc-toolbar-btn btn-undo"}),this.btnRedo=Ext.create("Ext.Button",{id:"toolbar-button-redo",tooltip:this.tipRedo+" (Ctrl+Y)",iconCls:"asc-toolbar-btn btn-redo"}),this.btnIncFontSize=Ext.create("Ext.Button",{id:"toolbar-button-increase-font",tooltip:this.tipIncFont+" (Ctrl+])",iconCls:"asc-toolbar-btn btn-incfont"}),this.paragraphControls.push(this.btnIncFontSize),this.btnDecFontSize=Ext.create("Ext.Button",{id:"toolbar-button-decrease-font",tooltip:this.tipDecFont+" (Ctrl+[)",iconCls:"asc-toolbar-btn btn-decfont"}),this.paragraphControls.push(this.btnDecFontSize),this._clearColorPalette=function(e){e&&e.getEl()&&e.getEl().down("a.color-"+e.getValue()).removeCls(e.selectedCls)},this.btnHighlightColor=Ext.widget("cmdsplitcolorbutton",{id:"toolbar-button-highlight-color",tooltip:this.tipHighlightColor,color:"FFFF00",horizontalOffset:4,verticalOffset:2,enableToggle:!0,iconCls:"asc-toolbar-btn btn-selectcolor",menu:{showSeparator:!1,items:[this.colorsHighlight=Ext.create("Ext.ColorPalette",{id:"menu-palette-highlight-color",cls:"color-palette-highlight",height:126,width:132,value:"FFFF00",allowReselect:!0,style:"padding: 6px;",colors:["FFFF00","00FF00","00FFFF","FF00FF","0000FF","FF0000","00008B","008B8B","006400","800080","8B0000","808000","FFFFFF","D3D3D3","A9A9A9","000000"],listeners:{select:function(e,t,n){r(t,"menu")},afterrender:function(t){e.mnuHighlightTransparent.checked&&e._clearColorPalette(t)}}}),"-",this.mnuHighlightTransparent=Ext.widget("menucheckitem",{cls:"menu-item-highlightcolor-nocolor",text:this.strMenuNoFill,checked:!1,iconCls:"menu-item-nocolor",handler:function(n){r("transparent","menu"),n.setChecked(!0),e._clearColorPalette(e.colorsHighlight)}})],listeners:{hide:{fn:function(){e.fireEvent("editcomplete",e)}}}},listeners:{click:function(t){t.pressed?(r(t.getColor()),Common.component.Analytics.trackEvent("ToolBar","Highlight Color")):e.api.SetMarkerFormat(!1)}}}),this.paragraphControls.push(this.btnHighlightColor),this.hotKeys=new Ext.util.KeyMap(document,[{key:Ext.EventObject.ESC,ctrl:!1,shift:!1,fn:function(){e.btnHighlightColor.pressed&&(e.btnHighlightColor.toggle(!1,!0),e.api.SetMarkerFormat(!1))}}]),this.btnFontColor=Ext.widget("cmdsplitcolorbutton",{id:"toolbar-button-font-color",tooltip:this.tipFontColor,color:"000000",horizontalOffset:3,verticalOffset:2,split:!0,listeners:{changecolor:function(t,n){e.fireEvent("editcomplete",e)},click:function(t){e.colorsText.fireEvent("select",e.colorsText,e.colorsText.currentColor)}},iconCls:"asc-toolbar-btn btn-fontcolor"}),this.paragraphControls.push(this.btnFontColor),this.btnMarkers=Ext.create("Ext.button.Split",{id:"toolbar-btn-markers",tooltip:this.tipMarkers,enableToggle:!0,toggleGroup:"markersGroup",iconCls:"asc-toolbar-btn btn-setmarkers",split:!0}),this.paragraphControls.push(this.btnMarkers),this.btnNumbers=Ext.create("Ext.button.Split",{id:"toolbar-btn-numbering",tooltip:this.tipNumbers,enableToggle:!0,toggleGroup:"markersGroup",iconCls:"asc-toolbar-btn btn-numbering",split:!0}),this.paragraphControls.push(this.btnNumbers),this.btnMultilevels=Ext.create("Ext.Button",{id:"toolbar-btn-multilevels",tooltip:this.tipMultilevels,iconCls:"asc-toolbar-btn btn-multilevels",split:!0}),this.paragraphControls.push(this.btnMultilevels),this.btnAlignLeft=Ext.create("Ext.Button",{id:"toolbar-button-align-left",tooltip:this.tipAlignLeft+" (Ctrl+L)",enableToggle:!0,toggleGroup:"alignGroup",allowDepress:!1,iconCls:"asc-toolbar-btn btn-align-left"}),this.paragraphControls.push(this.btnAlignLeft),this.btnAlignCenter=Ext.create("Ext.Button",{id:"toolbar-button-align-center",tooltip:this.tipAlignCenter+" (Ctrl+E)",enableToggle:!0,toggleGroup:"alignGroup",allowDepress:!1,iconCls:"asc-toolbar-btn btn-align-center"}),this.paragraphControls.push(this.btnAlignCenter),this.btnAlignRight=Ext.create("Ext.Button",{id:"toolbar-button-align-right",tooltip:this.tipAlignRight+" (Ctrl+R)",enableToggle:!0,toggleGroup:"alignGroup",allowDepress:!1,iconCls:"asc-toolbar-btn btn-align-right"}),this.paragraphControls.push(this.btnAlignRight),this.btnAlignJust=Ext.create("Ext.button.Button",{id:"toolbar-button-align-just",tooltip:this.tipAlignJust+" (Ctrl+J)",enableToggle:!0,toggleGroup:"alignGroup",allowDepress:!1,iconCls:"asc-toolbar-btn btn-align-just"}),this.paragraphControls.push(this.btnAlignJust),this.btnHorizontalAlign=Ext.create("Ext.Button",{id:"toolbar-button-halign",tooltip:this.tipHAligh,iconCls:"asc-toolbar-btn btn-halign",cls:"halign-left",icls:"halign-left",menu:{showSeparator:!1,id:"toolbar-menu-horalign",defaults:{cls:"toolbar-menu-icon-item",group:"halignGroup",checked:!1},items:[{iconCls:"mnu-icon-item mnu-align-left",text:this.tipAlignLeft+" (Ctrl+L)",icls:"halign-left",halign:1,checked:!0},{iconCls:"mnu-icon-item mnu-align-center",text:this.tipAlignCenter+" (Ctrl+E)",icls:"halign-center",halign:2},{iconCls:"mnu-icon-item mnu-align-right",text:this.tipAlignRight+" (Ctrl+R)",icls:"halign-right",halign:0},{iconCls:"mnu-icon-item mnu-align-just",text:this.tipAlignJust+" (Ctrl+J)",icls:"halign-just",halign:3}]}}),this.paragraphControls.push(this.btnHorizontalAlign),this.btnDecLeftOffset=Ext.create("Ext.button.Button",{id:"toolbar-button-dec-left-offset",tooltip:this.tipDecPrLeft+" (Ctrl+Shift+M)",iconCls:"asc-toolbar-btn btn-decoffset"}),this.paragraphControls.push(this.btnDecLeftOffset),this.btnIncLeftOffset=Ext.create("Ext.button.Button",{id:"toolbar-button-inc-left-offset",tooltip:this.tipIncPrLeft+" (Ctrl+M)",iconCls:"asc-toolbar-btn btn-incoffset"}),this.paragraphControls.push(this.btnIncLeftOffset),this.btnShowHidenChars=Ext.create("Ext.button.Split",{id:"toolbar-button-show-hidden",tooltip:this.tipShowHiddenChars,enableToggle:!0,pressed:!1,iconCls:"asc-toolbar-btn btn-hidenchars",menu:{listeners:{hide:function(){e.fireEvent("editcomplete",e)}},items:[this.mniShowHiddenChars=Ext.widget("menucheckitem",{text:this.mniHiddenChars,hideOnClick:!0,listeners:{checkchange:function(t,n){var r=n;e.btnShowHidenChars.toggle(r,!0),e.api&&e.api.put_ShowParaMarks(n),e.fireEvent("editcomplete",e),Common.component.Analytics.trackEvent("ToolBar","Hidden Characters")}}}),this.mniShowHiddenBorders=Ext.widget("menucheckitem",{text:this.mniHiddenBorders,hideOnClick:!0,listeners:{checkchange:function(t,n){e.api&&e.api.put_ShowTableEmptyLine(n),e.fireEvent("editcomplete",e)}}})]},listeners:{toggle:function(t,n){n?(e.mniShowHiddenChars.setChecked(!0,!0),Common.component.Analytics.trackEvent("ToolBar","Hidden Characters")):e.mniShowHiddenChars.setChecked(!1,!0),e.api&&e.api.put_ShowParaMarks(n),e.fireEvent("editcomplete",e)}}}),this.btnLineSpace=Ext.create("Ext.button.Button",{id:"toolbar-button-line-space",tooltip:this.tipLineSpace,iconCls:"asc-toolbar-btn btn-linespace",menu:{id:"toolbar-menu-line-space",width:76,defaults:{group:"linespace",checked:!1},items:[{text:"1.0",linespace:1,checked:!0},{text:"1.15",linespace:1.15},{text:"1.5",linespace:1.5},{text:"2.0",linespace:2},{text:"2.5",linespace:2.5},{text:"3.0",linespace:3}]}}),this.paragraphControls.push(this.btnLineSpace),this.btnInsertTable=Ext.create("Ext.button.Button",{id:"toolbar-button-insert-table",tooltip:this.tipInsertTable,iconCls:"asc-toolbar-btn btn-inserttable",menu:{showSeparator:!1,id:"toolbar-menu-insert-table",items:[{xtype:"container",width:200,items:[{xtype:"dedimensionpicker",minRows:8,minColumns:10,maxRows:8,maxColumns:10,stalign:"top",padding:"10px"}]},{text:this.mniCustomTable,id:"toolbar-insert-custom-table",cls:"menu-item-noicon"}]}}),this.btnInsertImage=Ext.create("Ext.button.Button",{id:"toolbar-button-insert-image",tooltip:this.tipInsertImage,iconCls:"asc-toolbar-btn btn-insertimage",menu:{showSeparator:!1,id:"toolbar-menu-insertimage",items:[{text:this.mniImageFromFile,cls:"menu-item-noicon",from:"file"},{text:this.mniImageFromUrl,cls:"menu-item-noicon",from:"url"}]}}),this.paragraphControls.push(this.btnInsertImage),this.btnPageBreak=Ext.create("Ext.button.Button",{id:"toolbar-button-page-break",tooltip:this.tipPageBreak,iconCls:"asc-toolbar-btn btn-pagebreak"}),this.paragraphControls.push(this.btnPageBreak),this.btnEditHeader=Ext.create("Ext.button.Button",{id:"toolbar-button-edit-header",tooltip:this.tipEditHeader,iconCls:"asc-toolbar-btn btn-editheader",menu:{showSeparator:!1,id:"toolbar-menu-edit-header",items:[{text:this.mniEditHeader,cls:"menu-item-noicon",place:"Header"},{text:this.mniEditFooter,cls:"menu-item-noicon",place:"Footer"},{xtype:"menuseparator"}]}}),this.btnInsertHyperlink=Ext.create("Ext.button.Button",{id:"toolbar-button-insert-hyperlink",tooltip:this.tipInsertHyperlink+" (Ctrl+K)",iconCls:"asc-toolbar-btn btn-inserthyperlink"}),this.paragraphControls.push(this.btnInsertHyperlink),this.btnClearStyle=Ext.create("Ext.button.Button",{id:"toolbar-button-clear-style",tooltip:this.tipClearStyle,iconCls:"asc-toolbar-btn btn-clearstyle"}),this.paragraphControls.push(this.btnClearStyle),this.btnCopyStyle=Ext.create("Ext.button.Button",{id:"toolbar-button-copy-style",tooltip:this.tipCopyStyle+" (Ctrl+Shift+C)",iconCls:"asc-toolbar-btn btn-copystyle",enableToggle:!0}),this.btnPageSize=Ext.create("Ext.button.Button",{id:"toolbar-button-pagesize",tooltip:this.tipPageSize,iconCls:"asc-toolbar-btn btn-pagesize",pagesize:[210,297],split:!0}),this.btnPageOrient=Ext.create("Ext.button.Button",{enableToggle:!0,tooltip:this.tipPageOrient,id:"toolbar-button-pageorient",iconCls:"asc-toolbar-btn btn-pageorient"}),e.btnNewDocument=Ext.create("Ext.Button",{id:"toolbar-button-newdocument",tooltip:this.tipNewDocument,iconCls:"asc-toolbar-btn btn-newdocument"}),e.btnOpenDocument=Ext.create("Ext.Button",{id:"toolbar-button-opendocument",tooltip:this.tipOpenDocument,iconCls:"asc-toolbar-btn btn-opendocument"}),this.btnInsertShape=Ext.create("Ext.button.Button",{id:"toolbar-button-insert-shape",tooltip:this.tipInsertShape,iconCls:"asc-toolbar-btn btn-insertshape",enableToggle:!0,menu:{showSeparator:!1,id:"toolbar-menu-insert-shape",items:[],plugins:[{ptype:"menuexpand"}]}}),this.paragraphControls.push(this.btnInsertShape),this.btnInsertText=Ext.create("Ext.button.Button",{id:"toolbar-button-insert-text",tooltip:this.tipInsertText,iconCls:"asc-toolbar-btn btn-text",enableToggle:!0}),this.paragraphControls.push(this.btnInsertText),this.btnColorSchemas=Ext.create("Ext.button.Button",{id:"toolbar-button-color-schemas",tooltip:this.tipColorSchemas,iconCls:"asc-toolbar-btn btn-colorschemas",split:!0}),this.btnFitPage=Ext.widget("menucheckitem",{id:"toolbar-menu-fit-page",text:this.textFitPage,checked:!1,hideOnClick:!0}),this.btnFitWidth=Ext.widget("menucheckitem",{id:"toolbar-menu-fit-width",text:this.textFitWidth,checked:!1,hideOnClick:!0}),this.btnZoomIn=Ext.widget("button",{id:"toolbar-menu-zoomin",cls:"asc-toolbar-btn-zoom",iconCls:"asc-statusbar-btn btn-zoomin"}),this.btnZoomOut=Ext.widget("button",{id:"toolbar-menu-zoomout",cls:"asc-toolbar-btn-zoom",iconCls:"asc-statusbar-btn btn-zoomout"}),this.txtZoom=Ext.widget("label",{id:"toolbar-menu-zoom-text",text:"100%",style:"white-space:nowrap; text-align: center;"}),this.btnHide=Ext.create("Ext.button.Button",{id:"toolbar-button-hide",tooltip:this.tipViewSettings,iconCls:"asc-toolbar-btn btn-hidebars",split:!0}),this.btnAdvSettings=Ext.create("Ext.button.Button",{id:"toolbar-button-settings",tooltip:this.tipAdvSettings,iconCls:"asc-toolbar-btn btn-settings"}),this.btnDropCap=Ext.create("Ext.Button",{id:"toolbar-button-dropcap",tooltip:this.tipDropCap,iconCls:"asc-toolbar-btn btn-dropcap",cls:"dropcap-text",icls:"dropcap-text",menu:{showSeparator:!1,id:"toolbar-menu-dropcap",items:[{cls:"toolbar-menu-icon-item",group:"dropcapGroup",iconCls:"mnu-icon-item mnu-dropcap-none",text:this.textNone,icls:"dropcap-none",dropcap:c_oAscDropCap.None,checked:!0},{cls:"toolbar-menu-icon-item",group:"dropcapGroup",iconCls:"mnu-icon-item mnu-dropcap-text",text:this.textInText,icls:"dropcap-text",dropcap:c_oAscDropCap.Drop,checked:!1},{cls:"toolbar-menu-icon-item",group:"dropcapGroup",iconCls:"mnu-icon-item mnu-dropcap-margin",text:this.textInMargin,icls:"dropcap-margin",dropcap:c_oAscDropCap.Margin,checked:!1},{xtype:"menuseparator"},{id:"mnu-dropcap-advanced",text:this.mniEditDropCap,cls:"menu-item-noicon"}]}}),this.paragraphControls.push(this.btnDropCap);var i=function(e,t,n){return Ext.String.format('<div class="toolbar-btn-placeholder x-btn-default-toolbar-small-icon x-btn-default-toolbar-small document-loading" id="{0}" style="{2}"><span class="replaceme x-btn-icon asc-toolbar-btn {1}">&nbsp;</span></div>',e,t,n||"")},s=function(e,t,n,r){return Ext.String.format('<div class="toolbar-btn-placeholder x-btn-default-toolbar-small-icon x-btn-default-toolbar-small document-loading x-btn-split x-btn-split-right{3}" id="{0}" style="width: 34px; {2}"><span class="replaceme x-btn-icon asc-toolbar-btn {1}">&nbsp;</span></div>',e,t,n||"",r?" "+r:"")},o=function(e,t){return Ext.String.format('<div class="x-toolbar-separator x-toolbar-item x-toolbar-separator-horizontal manual {0}" style="{1}" role="presentation" tabindex="-1"></div>',e,t||"")},u=function(e,t,n){return Ext.String.format('<div id="{0}" class="x-container storage-combodataview x-container-default x-box-layout-ct toolbar-combo-placeholder x-item-disabled" role="presentation" tabindex="-1" style="{2}"><div class="x-trigger-index-0 x-form-trigger x-form-arrow-trigger x-form-trigger-last x-unselectable" role="button"></div>{1}</div>',e,t||"",n||"")},a=function(e,t,n){return Ext.String.format('<div id="{0}" class="x-container storage-combodataview x-container-default x-box-layout-ct toolbar-dataview-placeholder x-item-disabled" role="presentation" tabindex="-1" style="{1}"><div class="x-btn x-btn-combodataview x-box-item x-btn-default-small" style="height: 44px; margin: 0; top: 4px;"></div></div>',e,n||"")},f=window.localStorage.getItem("de-compact-toolbar")&&parseInt(window.localStorage.getItem("de-compact-toolbar"))==1||!1;this.setHeight(f?38:68),this.html=['<div id="id-toolbar-short" style="'+(f?"display: table;":"display: none;")+'width: 100%; height: 22px; margin-top: 3px;" >','<div class="toolbar-group">','<div class="toolbar-row">',i("id-toolbar-short-btn-print","btn-print","margin: 0 4px 0 0;"),i("id-toolbar-short-btn-save","btn-save"),"</div>","</div>",'<div class="toolbar-group separator">',o("short"),"</div>",'<div class="toolbar-group">','<div class="toolbar-row">',i("id-toolbar-short-btn-undo","btn-undo","margin: 0 4px 0 0;"),i("id-toolbar-short-btn-redo","btn-redo","margin: 0 1px 0 3px;"),"</div>","</div>",'<div class="toolbar-group separator">',o("short"),"</div>",'<div class="toolbar-group">','<div class="toolbar-row" style="width: 200px; margin-top: 2px;">',u("id-toolbar-short-field-fontname","Arial","display: inline; float: left; line-height: 20px; padding: 0; width: 127px; height: 22px; margin-right: 4px;"),u("id-toolbar-short-field-fontsize","11","display: inline; float: left; padding: 0; line-height: 20px; width: 59px; height: 22px; margin-right: 2px;"),"</div>","</div>",'<div class="toolbar-group" style="padding-left: 0">','<div class="toolbar-row" style="margin-top: 2px;">',i("id-toolbar-short-btn-bold","btn-bold","margin: 0 2px 0 0;"),i("id-toolbar-short-btn-italic","btn-italic","margin: 0 2px 0 0;"),i("id-toolbar-short-btn-underline","btn-underline","margin: 0 4px 0 0;"),s("id-toolbar-short-btn-highlight","btn-selectcolor","margin: 0 4px 0 0;"),s("id-toolbar-short-btn-fontcolor","btn-fontcolor","margin: 0 0 0 0;"),"</div>","</div>",'<div class="toolbar-group separator">',o("short"),"</div>",'<div class="toolbar-group">','<div class="toolbar-row" style="margin-top: 2px;">',s("id-toolbar-short-btn-halign","btn-align-left","margin: 0 4px 0 0;"),s("id-toolbar-short-btn-setmarkers","btn-setmarkers","margin: 0 4px 0 0;"),s("id-toolbar-short-btn-numbering","btn-numbering","margin: 0 4px 0 0;"),s("id-toolbar-short-btn-multilevels","btn-multilevels","margin: 0;"),"</div>","</div>",'<div class="toolbar-group separator">',o("short"),"</div>",'<div class="toolbar-group">','<div class="toolbar-row" style="margin-top: 2px;">',i("id-toolbar-short-btn-decoffset","btn-decoffset","margin: 0 4px 0 0;"),i("id-toolbar-short-btn-incoffset","btn-incoffset","margin: 0 4px 0 0;"),s("id-toolbar-short-btn-linespace","btn-linespace","margin: 0 2px 0 0;"),s("id-toolbar-short-btn-hidenchars","btn-hidenchars","margin: 0;"),"</div>","</div>",'<div class="toolbar-group separator">',o("short"),"</div>",'<div class="toolbar-group">','<div class="toolbar-row" style="margin-top: 2px;">',s("id-toolbar-short-btn-inserttable","btn-inserttable","margin: 0 2px 0 0;"),s("id-toolbar-short-btn-insertimage","btn-insertimage","margin: 0 2px 0 0;"),i("id-toolbar-short-btn-text","btn-text","margin: 0 4px 0 0;"),i("id-toolbar-short-btn-pagebreak","btn-pagebreak","margin: 0 4px 0 0;"),i("id-toolbar-short-btn-inserthyperlink","btn-inserthyperlink","margin: 0 4px 0 0;"),s("id-toolbar-short-btn-editheader","btn-editheader","margin: 0 2px 0 0;"),s("id-toolbar-short-btn-insertshape","btn-insertshape","margin: 0;"),"</div>","</div>",'<div class="toolbar-group separator">',o("short"),"</div>",'<div class="toolbar-group">','<div class="toolbar-row" style="margin-top: 2px;">',i("id-toolbar-short-btn-pageorient","btn-pageorient","margin: 0 4px 0 0;"),s("id-toolbar-short-btn-pagesize","btn-pagesize","margin: 0;"),"</div>","</div>",'<div class="toolbar-group separator">',o("short"),"</div>",'<div class="toolbar-group">','<div class="toolbar-row" style="margin-top: 2px;">',i("id-toolbar-short-btn-clearstyle","btn-clearstyle","margin: 0 4px 0 0;"),i("id-toolbar-short-btn-copystyle","btn-copystyle","margin: 0;"),"</div>","</div>",'<div class="toolbar-group" style="width: 100%;"></div>','<div class="toolbar-group">','<div class="toolbar-row" style="margin-top: 2px;">',s("id-toolbar-short-btn-hidebars","btn-hidebars","margin: 0 4px 0 0;"),"</div>","</div>","</div>",'<div id="id-toolbar-full" style="'+(f?"display: none;":"display: table;")+'width: 100%; margin-top: 3px;" >','<div class="toolbar-group" id="id-toolbar-full-group-native">','<div class="toolbar-row">',i("id-toolbar-full-btn-newdocument","btn-newdocument"),"</div>",'<div class="toolbar-row">',i("id-toolbar-full-btn-opendocument","btn-opendocument"),"</div>","</div>",'<div class="toolbar-group">','<div class="toolbar-row">',i("id-toolbar-full-btn-print","btn-print"),"</div>",'<div class="toolbar-row">',i("id-toolbar-full-btn-save","btn-save"),"</div>","</div>",'<div class="toolbar-group separator">',o("long"),"</div>",'<div class="toolbar-group">','<div class="toolbar-row">',i("id-toolbar-full-btn-copy","btn-copy","margin: 0 6px 0 0;"),i("id-toolbar-full-btn-paste","btn-paste"),"</div>",'<div class="toolbar-row">',i("id-toolbar-full-btn-undo","btn-undo","margin: 0 6px 0 0;"),i("id-toolbar-full-btn-redo","btn-redo"),"</div>","</div>",'<div class="toolbar-group separator">',o("long"),"</div>",'<div class="toolbar-group">','<div class="toolbar-row" style="width:239px;">',u("id-toolbar-full-field-fontname","Arial","display: inline; float: left; line-height: 20px; padding: 0; width: 127px; height: 22px; margin-right: 4px;"),u("id-toolbar-full-field-fontsize","11","display: inline; float: left; padding: 0; line-height: 20px; width: 59px; height: 22px; margin-right: 2px;"),i("id-toolbar-full-btn-incfont","btn-incfont"),i("id-toolbar-full-btn-decfont","btn-decfont","margin: 0 0 0 2px;"),"</div>",'<div class="toolbar-row">',i("id-toolbar-full-btn-bold","btn-bold","margin: 0 1px 0 0;"),i("id-toolbar-full-btn-italic","btn-italic","margin: 0 2px 0 0;"),i("id-toolbar-full-btn-underline","btn-underline","margin: 0 2px 0 0;"),i("id-toolbar-full-btn-strikeout","btn-strike","margin: 0 2px 0 0;"),i("id-toolbar-full-btn-superscript","btn-superscript","margin: 0 2px 0 0;"),i("id-toolbar-full-btn-subscript","btn-subscript","margin: 0 10px 0 0;"),o("short","position: absolute; margin-top: 2px;"),s("id-toolbar-full-btn-highlight","btn-selectcolor","margin: 0 4px 0 14px;"),s("id-toolbar-full-btn-fontcolor","btn-fontcolor","margin: 0 0 0 2px;"),"</div>","</div>",'<div class="toolbar-group separator">',o("long"),"</div>",'<div class="toolbar-group">','<div class="toolbar-row">',s("id-toolbar-full-btn-setmarkers","btn-setmarkers","margin: 0 2px 0 0;"),s("id-toolbar-full-btn-numbering","btn-numbering","margin: 0 2px 0 0;"),s("id-toolbar-full-btn-multilevels","btn-multilevels","margin: 0 2px 0 0;"),"</div>",'<div class="toolbar-row">',i("id-toolbar-full-btn-align-left","btn-align-left","margin: 0 6px 0 0;"),i("id-toolbar-full-btn-align-center","btn-align-center","margin: 0 6px 0 0;"),i("id-toolbar-full-btn-align-right","btn-align-right","margin: 0 6px 0 0;"),i("id-toolbar-full-btn-align-just","btn-align-just","margin: 0;"),"</div>","</div>",'<div class="toolbar-group separator">',o("long"),"</div>",'<div class="toolbar-group">','<div class="toolbar-row">',i("id-toolbar-full-btn-decoffset","btn-decoffset","margin: 0 14px 0 0;"),i("id-toolbar-full-btn-incoffset","btn-incoffset"),"</div>",'<div class="toolbar-row">',s("id-toolbar-full-btn-linespace","btn-linespace","margin: 0 2px 0 0;"),s("id-toolbar-full-btn-hidenchars","btn-hidenchars","margin: 0 0 0 0;"),"</div>","</div>",'<div class="toolbar-group separator">',o("long"),"</div>",'<div class="toolbar-group">','<div class="toolbar-row">',s("id-toolbar-full-btn-inserttable","btn-inserttable","margin: 0 2px 0 0"),s("id-toolbar-full-btn-insertimage","btn-insertimage","margin: 0 2px 0 0"),i("id-toolbar-full-btn-text","btn-text","margin: 0 12px 0 0"),s("id-toolbar-full-btn-dropcap","btn-dropcap",undefined,"dropcap-text"),"</div>",'<div class="toolbar-row">',i("id-toolbar-full-btn-pagebreak","btn-pagebreak","margin: 0 14px 0 0"),i("id-toolbar-full-btn-inserthyperlink","btn-inserthyperlink","margin: 0 14px 0 0"),s("id-toolbar-full-btn-editheader","btn-editheader","margin: 0 2px 0 0;"),s("id-toolbar-full-btn-insertshape","btn-insertshape","margin: 0 0 0 0;"),"</div>","</div>",'<div class="toolbar-group separator">',o("long"),"</div>",'<div class="toolbar-group">','<div class="toolbar-row">',i("id-toolbar-full-btn-pageorient","btn-pageorient"),"</div>",'<div class="toolbar-row">',s("id-toolbar-full-btn-pagesize","btn-pagesize"),"</div>","</div>",'<div class="toolbar-group separator">',o("long"),"</div>",'<div class="toolbar-group">','<div class="toolbar-row">',i("id-toolbar-full-btn-clearstyle","btn-clearstyle"),"</div>",'<div class="toolbar-row">',i("id-toolbar-full-btn-copystyle","btn-copystyle"),"</div>","</div>",'<div class="toolbar-group separator">',o("long"),"</div>",'<div class="toolbar-group">','<div class="toolbar-row">',s("id-toolbar-full-btn-colorschemas","btn-colorschemas"),"</div>","</div>",'<div class="toolbar-group" id="id-toolbar-full-group-styles" style="width: 100%;">',a("id-toolbar-full-field-styles","","margin: 0 10px; height: 54px;"),"</div>",'<div class="toolbar-group">','<div class="toolbar-row">',s("id-toolbar-full-btn-hidebars","btn-hidebars","margin: 0 5px 0 0;"),"</div>",'<div class="toolbar-row">',i("id-toolbar-full-btn-settings","btn-settings"),"</div>","</div>","</div>"],this.items=[],this.listStyles=Ext.create("Common.component.ComboDataView",{id:"toolbar-combo-view-styles",flex:1,height:54,itemWidth:80,itemHeight:40,menuMaxHeight:500,minWidth:125,repeatedselect:!0,handleGlobalResize:!0,viewData:[]}),this.paragraphControls.push(this.listStyles),this.callParent(arguments)},setApi:function(e){this.api=e;if(this.api)return this.api.asc_registerCallback("asc_onMarkerFormatChanged",Ext.bind(this._onStartHighlight,this)),this.api.asc_registerCallback("asc_onTextHighLight",Ext.bind(this._onHighlightColor,this)),this.api.asc_registerCallback("asc_onCollaborativeChanges",Ext.bind(this._onCollaborativeChanges,this)),this},_onStartHighlight:function(e){this.btnHighlightColor.toggle(e,!0)},_onHighlightColor:function(e){this.colorsHighlight.suspendEvents(!1);var t=this.api.get_TextProps().get_TextPr();t&&(e=t.get_HighLight(),e==-1?this._state.clrhighlight!=-1&&(this.mnuHighlightTransparent.setChecked(!0),this.colorsHighlight.getEl()&&(this._state.clrhighlight=-1,this._clearColorPalette(this.colorsHighlight))):e!==null?this._state.clrhighlight!=e.get_hex()&&(this.mnuHighlightTransparent.setChecked(!1),this._state.clrhighlight=e.get_hex().toUpperCase(),Ext.Array.contains(this.colorsHighlight.colors,this._state.clrhighlight)&&this.colorsHighlight.select(this._state.clrhighlight,!1)):this._state.clrhighlight!==e&&(this.mnuHighlightTransparent.setChecked(!1),this._clearColorPalette(this.colorsHighlight),this._state.clrhighlight=e)),this.colorsHighlight.resumeEvents()},_onTextColor:function(e){var t;e&&(e.get_type()==c_oAscColor.COLOR_TYPE_SCHEME?t={color:this.getHexColor(e.get_r(),e.get_g(),e.get_b()),effectValue:e.get_value()}:t=this.getHexColor(e.get_r(),e.get_g(),e.get_b()));var n=typeof t,r=typeof this._state.clrtext;if(n!==r||n=="object"&&(t.effectValue!==this._state.clrtext.effectValue||this._state.clrtext.color.indexOf(t.color)<0)||n!="object"&&this._state.clrtext.indexOf(t)<0){this.colorsText.suspendEvents(!1);if(typeof t=="object"){for(var i=0;i<10;i++)if(this.ThemeValues[i]==t.effectValue){this.colorsText.select(t,!1);break}}else this.colorsText.select(t,!1);this.colorsText.resumeEvents(),this._state.clrtext=t}},getHexColor:function(e,t,n){return e=e.toString(16),t=t.toString(16),n=n.toString(16),e.length==1&&(e="0"+e),t.length==1&&(t="0"+t),n.length==1&&(n="0"+n),e+t+n},getRgbColor:function(e){var t=typeof e=="object"?e.color:e;t=t.replace(/#/,""),t.length==3&&(t=t.replace(/(.)/g,"$1$1")),t=parseInt(t,16);var n=new CAscColor;return n.put_type(typeof e=="object"?c_oAscColor.COLOR_TYPE_SCHEME:c_oAscColor.COLOR_TYPE_SRGB),n.put_r(t>>16),n.put_g((t&65280)>>8),n.put_b(t&255),n.put_a(255),e.effectId!==undefined&&n.put_value(e.effectId),n},_onSendThemeColorSchemes:function(e){var t=this;t.btnColorSchemas.menu.removeAll();var n=Ext.create("Ext.XTemplate",'<a class="x-menu-item-link">','<span class="colors">','<tpl for="colors">','<span class="color" style="background: {color};"></span>',"</tpl>","</span>",'<span class="text">{text}</span>',"</a>");for(var r=0;r<e.length;r++){var i=e[r],s=i.get_colors(),o=[];for(var u=2;u<7;u++){var a="#"+this.getHexColor(s[u].get_r(),s[u].get_g(),s[u].get_b());o.push({color:a})}var f=Ext.create("Ext.menu.Item",{cls:"menu-item-noicon asc-color-schemas-menu",data:{text:r<21?t.SchemeNames[r]:i.get_name(),colors:o},tpl:n,schemaType:r});r==21&&t.btnColorSchemas.menu.add(Ext.create("Ext.menu.Separator",{})),t.btnColorSchemas.menu.add(f)}},_onSendThemeColors:function(e,t){var n=[];if(t)for(var r=0;r<t.length;r++){var i=this.getHexColor(t[r].get_r(),t[r].get_g(),t[r].get_b());n.push(i)}var s=[],o,u;for(r=0;r<6;r++)for(var a=0;a<10;a++){var f=r+a*6,i={color:this.getHexColor(e[f].get_r(),e[f].get_g(),e[f].get_b()),effectId:f,effectValue:this.ThemeValues[a]};s.push(i),typeof this.colorsText.currentColor=="object"&&o===undefined&&this.colorsText.currentColor.effectId==f&&(o=i)}this.colorsText.updateColors(s,n),this.colorsText.currentColor===undefined?(this.btnFontColor.setColor(s[1].color,!1),this.colorsText.currentColor=s[1]):o!==undefined&&(this.btnFontColor.setColor(o.color,!1),this.colorsText.currentColor=o),this.effectcolors=s,n&&n.length>0&&(this.standartcolors=n)},_onInsertPageNumber:function(e,t){this.api&&this.api.put_PageNum(t.data.data.type,t.data.data.subtype),setTimeout(function(){e.selectByIndex(-1)},100),this.fireEvent("editcomplete",this),Ext.menu.Manager.hideAll(),Common.component.Analytics.trackEvent("ToolBar","Page Number")},_onCollaborativeChanges:function(){if(!this.btnSave.rendered){this.needShowSynchTip=!0;return}var e=this.btnSave.getEl().down(".asc-toolbar-btn");e.removeCls("btn-save"),e.addCls("btn-synch"),this.showSynchTip&&this.isVisible()?(this.btnSave.setTooltip(""),this.synchTooltip===undefined&&this._createSynchTip(),this.synchTooltip.show()):this.btnSave.setTooltip(this.tipSynchronize+" (Ctrl+S)")},_onLockHeaderFooters:function(){this.pageNumHeaderFooter.setDisabled(!0),this.mnuInsertPageNum.setDisabled(this.pageNumCurrentPos.isDisabled())},_onUnLockHeaderFooters:function(){this.pageNumHeaderFooter.setDisabled(!1),this.mnuInsertPageNum.setDisabled(!1)},_createSynchTip:function(){var e=this.btnSave.getPosition();e[0]+=this.btnSave.getWidth(),e[1]+=this.btnSave.getHeight()/2,this.synchTooltip=Ext.getBody().createChild({tag:"div",cls:"synch-tip-root",style:"top: "+e[1]+"px; left: "+e[0]+"px; width: 250px;"});if(this.synchTooltip){var t=Ext.widget("commonsynchronizetip",{renderTo:this.synchTooltip});t.getEl().alignTo(this.synchTooltip,"tl"),t.addListener("dontshowclick",function(){this.showSynchTip=!1,this.synchTooltip.hide(),this.btnSave.setTooltip(this.tipSynchronize+" (Ctrl+S)"),window.localStorage.setItem("de-hide-synch",1)},this),t.addListener("closeclick",function(){this.synchTooltip.hide(),this.btnSave.setTooltip(this.tipSynchronize+" (Ctrl+S)")},this)}},setMode:function(e){e.isDisconnected?(this.btnNewDocument.setDisabled(!0),this.btnOpenDocument.setDisabled(!0),this.btnSave.setDisabled(!0),this.btnCopy.setDisabled(!0),this.btnPaste.setDisabled(!0),this.btnUndo.setDisabled(!0),this.btnRedo.setDisabled(!0),this.btnIncFontSize.setDisabled(!0),this.btnDecFontSize.setDisabled(!0),this.btnBold.setDisabled(!0),this.btnItalic.setDisabled(!0),this.btnUnderline.setDisabled(!0),this.btnStrikeout.setDisabled(!0),this.btnSuperscript.setDisabled(!0),this.btnSubscript.setDisabled(!0),this.btnHighlightColor.setDisabled(!0),this.btnFontColor.setDisabled(!0),this.btnMarkers.setDisabled(!0),this.btnNumbers.setDisabled(!0),this.btnMultilevels.setDisabled(!0),this.btnAlignLeft.setDisabled(!0),this.btnAlignCenter.setDisabled(!0),this.btnAlignRight.setDisabled(!0),this.btnAlignJust.setDisabled(!0),this.btnDecLeftOffset.setDisabled(!0),this.btnIncLeftOffset.setDisabled(!0),this.btnLineSpace.setDisabled(!0),this.btnShowHidenChars.setDisabled(!0),this.btnInsertTable.setDisabled(!0),this.btnInsertImage.setDisabled(!0),this.btnInsertText.setDisabled(!0),this.btnDropCap.setDisabled(!0),this.btnPageBreak.setDisabled(!0),this.btnInsertHyperlink.setDisabled(!0),this.btnEditHeader.setDisabled(!0),this.btnInsertShape.setDisabled(!0),this.btnPageOrient.setDisabled(!0),this.btnPageSize.setDisabled(!0),this.btnClearStyle.setDisabled(!0),this.btnCopyStyle.setDisabled(!0),this.btnColorSchemas.setDisabled(!0),this.btnHorizontalAlign.setDisabled(!0),this.cmbFont.setDisabled(!0),this.cmbFontSize.setDisabled(!0),this.listStyles.setDisabled(!0)):this.api&&(this.mniShowHiddenChars.setChecked(this.api.get_ShowParaMarks(),!0),this.mniShowHiddenBorders.setChecked(this.api.get_ShowTableEmptyLine(),!0),this.btnShowHidenChars.toggle(this.mniShowHiddenChars.checked,!0));if(!e.nativeApp){var t=Ext.get("id-toolbar-full-group-native");t&&(t.setVisibilityMode(Ext.Element.DISPLAY),t.hide())}},synchronizeChanges:function(){var e=this.btnSave.getEl().down(".asc-toolbar-btn");e.hasCls("btn-synch")&&(e.removeCls("btn-synch"),e.addCls("btn-save"),this.synchTooltip&&this.synchTooltip.hide(),this.btnSave.setTooltip(this.tipSave+" (Ctrl+S)"))},_arrangeSlideItems:function(){if(!this.needArrangeSlideItems)return;var e=this;if(this.getEl()){var t=this.getEl().down(".jspPane");if(t&&t.getHeight()>0&&this.getEl().getHeight()>0)var n=0,r=setInterval(function(){e.needArrangeSlideItems&&e.resizeSlideItems();if(!e.needArrangeSlideItems){clearInterval(r),e.doLayout();return}n++>5&&clearInterval(r)},100)}},_resizeSlideItems:function(){var e=3,t="div.group-item",n=this.getEl(),r=n.query(t),i=0;while(i<r.length){var s=0;for(var o=i;o<i+e;o++){if(o>=r.length)break;var u=Ext.get(r[o]),a=u.getHeight();if(a<50)return;a<s?u.setHeight(s):s=a}i+=e}r.length>0&&(this.needArrangeSlideItems=!1)},changeViewMode:function(e){var t=this,n=Ext.get("id-toolbar-full"),r=Ext.get("id-toolbar-short");n&&r&&(e?(r.setStyle({display:"table"}),n.setStyle({display:"none"}),this.setHeight(38),this.rendererComponents("short")):(r.setStyle({display:"none"}),n.setStyle({display:"table"}),this.setHeight(68),this.rendererComponents("full"),Ext.defer(function(){var e=t.listStyles.rendered&&t.listStyles.getEl()&&t.listStyles.getEl().up("#id-toolbar-full-group-styles")&&t.listStyles.getEl().up("#id-toolbar-full-group-styles").isVisible();t.listStyles.dataMenu.picker.store.getCount()>0&&e&&(t.listStyles.doComponentLayout(),t.listStyles.fillComboView(t.listStyles.dataMenu.picker.getSelectedRec(),!0))},100)))},rendererComponents:function(e){var t=this,n=function(e,t){var n=Ext.get(e);if(n&&!n.down("button")){n.removeCls(["x-btn-default-toolbar-small-icon","x-btn-default-toolbar-small","x-btn-disabled","x-btn-split","x-btn-split-right","document-loading"]);var r=n.down("span");r&&r.remove(),t.addCls("x-btn-default-toolbar-small x-btn-default-toolbar-small-icon "),t.rendered?n.dom.appendChild(document.getElementById(t.getId())):t.render(n),t.removeCls(["x-btn-default-small","x-btn-default-small-icon"])}},r=function(e,t){var n=Ext.get(e);if(n&&!n.down("input")){if(/toolbar-combo-placeholder|toolbar-dataview-placeholder/.test(n.dom.className))for(var r=n.dom.childNodes.length,i;r--;)i=n.dom.childNodes[r],i.parentNode.removeChild(i);n.removeCls(["x-container","storage-combodataview","x-container-default","x-box-layout-ct","toolbar-combo-placeholder","toolbar-dataview-placeholder","x-item-disabled"]),t.rendered?n.dom.appendChild(document.getElementById(t.getId())):t.render(n)}},i=e==="short"?"short":"full";n("id-toolbar-"+i+"-btn-newdocument",t.btnNewDocument),n("id-toolbar-"+i+"-btn-opendocument",t.btnOpenDocument),n("id-toolbar-"+i+"-btn-print",t.btnPrint),n("id-toolbar-"+i+"-btn-save",t.btnSave),n("id-toolbar-"+i+"-btn-copy",t.btnCopy),n("id-toolbar-"+i+"-btn-paste",t.btnPaste),n("id-toolbar-"+i+"-btn-undo",t.btnUndo),n("id-toolbar-"+i+"-btn-redo",t.btnRedo),n("id-toolbar-"+i+"-btn-incfont",t.btnIncFontSize),n("id-toolbar-"+i+"-btn-decfont",t.btnDecFontSize),n("id-toolbar-"+i+"-btn-bold",t.btnBold),n("id-toolbar-"+i+"-btn-italic",t.btnItalic),n("id-toolbar-"+i+"-btn-underline",t.btnUnderline),n("id-toolbar-"+i+"-btn-strikeout",t.btnStrikeout),n("id-toolbar-"+i+"-btn-superscript",t.btnSuperscript),n("id-toolbar-"+i+"-btn-subscript",t.btnSubscript),n("id-toolbar-"+i+"-btn-highlight",t.btnHighlightColor),n("id-toolbar-"+i+"-btn-fontcolor",t.btnFontColor),n("id-toolbar-"+i+"-btn-setmarkers",t.btnMarkers),n("id-toolbar-"+i+"-btn-numbering",t.btnNumbers),n("id-toolbar-"+i+"-btn-multilevels",t.btnMultilevels),n("id-toolbar-"+i+"-btn-align-left",t.btnAlignLeft),n("id-toolbar-"+i+"-btn-align-center",t.btnAlignCenter),n("id-toolbar-"+i+"-btn-align-right",t.btnAlignRight),n("id-toolbar-"+i+"-btn-align-just",t.btnAlignJust),n("id-toolbar-"+i+"-btn-decoffset",t.btnDecLeftOffset),n("id-toolbar-"+i+"-btn-incoffset",t.btnIncLeftOffset),n("id-toolbar-"+i+"-btn-linespace",t.btnLineSpace),n("id-toolbar-"+i+"-btn-hidenchars",t.btnShowHidenChars),n("id-toolbar-"+i+"-btn-inserttable",t.btnInsertTable),n("id-toolbar-"+i+"-btn-insertimage",t.btnInsertImage),n("id-toolbar-"+i+"-btn-text",t.btnInsertText),n("id-toolbar-"+i+"-btn-dropcap",t.btnDropCap),n("id-toolbar-"+i+"-btn-pagebreak",t.btnPageBreak),n("id-toolbar-"+i+"-btn-inserthyperlink",t.btnInsertHyperlink),n("id-toolbar-"+i+"-btn-editheader",t.btnEditHeader),n("id-toolbar-"+i+"-btn-insertshape",t.btnInsertShape),n("id-toolbar-"+i+"-btn-pageorient",t.btnPageOrient),n("id-toolbar-"+i+"-btn-pagesize",t.btnPageSize),n("id-toolbar-"+i+"-btn-clearstyle",t.btnClearStyle),n("id-toolbar-"+i+"-btn-copystyle",t.btnCopyStyle),n("id-toolbar-"+i+"-btn-colorschemas",t.btnColorSchemas),n("id-toolbar-"+i+"-btn-hidebars",t.btnHide),n("id-toolbar-"+i+"-btn-settings",t.btnAdvSettings),n("id-toolbar-"+i+"-btn-halign",t.btnHorizontalAlign),r("id-toolbar-"+i+"-field-fontname",t.cmbFont),r("id-toolbar-"+i+"-field-fontsize",t.cmbFontSize),r("id-toolbar-"+i+"-field-styles",t.listStyles)},createDelayedElements:function(){var e=[],t=this,n=window.localStorage.getItem("de-compact-toolbar")&&parseInt(window.localStorage.getItem("de-compact-toolbar"))==1||!1;t.rendererComponents(n?"short":"full");var r=Ext.create("Ext.XTemplate",'<tpl for=".">','<div class="thumb-wrap">','<img src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" style="{imgstyle}" class="{imgcls}"/>',"</div>","</tpl>"),i=[{offsety:0,data:{type:0,subtype:-1},imgcls:"item-markerlist"},{offsety:38,data:{type:0,subtype:1},imgcls:"item-markerlist"},{offsety:76,data:{type:0,subtype:2},imgcls:"item-markerlist"},{offsety:114,data:{type:0,subtype:3},imgcls:"item-markerlist"},{offsety:152,data:{type:0,subtype:4},imgcls:"item-markerlist"},{offsety:190,data:{type:0,subtype:5},imgcls:"item-markerlist"},{offsety:228,data:{type:0,subtype:6},imgcls:"item-markerlist"},{offsety:266,data:{type:0,subtype:7},imgcls:"item-markerlist"}];for(var s=0;s<i.length;s++)i[s].imgstyle=Ext.String.format("background-position: 0 {0}px;",-i[s].offsety);this.btnMarkers.menu=Ext.create("Common.component.MenuDataViewPicker",{width:194,height:108,contentWidth:174,dataTpl:r,viewData:i}),e.push(this.btnMarkers),i=[{offsety:0,data:{type:1,subtype:-1},imgcls:"item-numberlist"},{offsety:518,data:{type:1,subtype:4},imgcls:"item-numberlist"},{offsety:592,data:{type:1,subtype:5},imgcls:"item-numberlist"},{offsety:666,data:{type:1,subtype:6},imgcls:"item-numberlist"},{offsety:296,data:{type:1,subtype:1},imgcls:"item-numberlist"},{offsety:370,data:{type:1,subtype:2},imgcls:"item-numberlist"},{offsety:444,data:{type:1,subtype:3},imgcls:"item-numberlist"},{offsety:740,data:{type:1,subtype:7},imgcls:"item-numberlist"}];for(var s=0;s<i.length;s++)i[s].imgstyle=Ext.String.format("background-position:0 {0}px;",-i[s].offsety);this.btnNumbers.menu=Ext.create("Common.component.MenuDataViewPicker",{width:336,height:180,contentWidth:316,dataTpl:r,viewData:i}),e.push(this.btnNumbers),i=[{offsety:0,data:{type:2,subtype:-1},imgcls:"item-multilevellist"},{offsety:74,data:{type:2,subtype:1},imgcls:"item-multilevellist"},{offsety:148,data:{type:2,subtype:2},imgcls:"item-multilevellist"},{offsety:222,data:{type:2,subtype:3},imgcls:"item-multilevellist"}];for(var s=0;s<i.length;s++)i[s].imgstyle=Ext.String.format("background-position:0 {0}px;",-i[s].offsety);this.btnMultilevels.menu=Ext.create("Common.component.MenuDataViewPicker",{width:173,height:180,contentWidth:153,dataTpl:r,viewData:i}),e.push(this.btnMultilevels),this.btnFontColor.menu=Ext.create("Ext.menu.Menu",{showSeparator:!1,items:[this.colorsText=Ext.create("Common.component.ThemeColorPalette",{id:"menu-palette-font-color",value:"000000",width:165,height:214,dynamiccolors:!0,dyncolorscount:10,currentColor:undefined,colors:[t.textThemeColors,"-",{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},{color:"000000",effectId:5},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},"-",{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},{color:"000000",effectId:5},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},"-","--","-",t.textStandartColors,"-","3D55FE","5301B3","980ABD","B2275F","F83D26","F86A1D","F7AC16","F7CA12","FAFF44","D6EF39","-","--"],listeners:{select:{fn:function(e,n,r){typeof n=="object"?t.btnFontColor.setColor(n.color):t.btnFontColor.setColor(n),Ext.menu.Manager.hideAll(),t.colorsText.currentColor=n,t.api.put_TextColor(t.getRgbColor(n)),Common.component.Analytics.trackEvent("ToolBar","Text Color")}}}}),{cls:"menu-item-noicon menu-item-color-palette-theme",text:this.textNewColor,listeners:{click:function(e,n){t.colorsText.addNewColor()}}}],listeners:{hide:function(){t.fireEvent("editcomplete",t)}}}),e.push(this.btnFontColor),i=[{offsety:132,data:{type:c_pageNumPosition.PAGE_NUM_POSITION_TOP,subtype:c_pageNumPosition.PAGE_NUM_POSITION_LEFT}},{offsety:99,data:{type:c_pageNumPosition.PAGE_NUM_POSITION_TOP,subtype:c_pageNumPosition.PAGE_NUM_POSITION_CENTER}},{offsety:66,data:{type:c_pageNumPosition.PAGE_NUM_POSITION_TOP,subtype:c_pageNumPosition.PAGE_NUM_POSITION_RIGHT}},{offsety:33,data:{type:c_pageNumPosition.PAGE_NUM_POSITION_BOTTOM,subtype:c_pageNumPosition.PAGE_NUM_POSITION_LEFT}},{offsety:0,data:{type:c_pageNumPosition.PAGE_NUM_POSITION_BOTTOM,subtype:c_pageNumPosition.PAGE_NUM_POSITION_CENTER}},{offsety:165,data:{type:c_pageNumPosition.PAGE_NUM_POSITION_BOTTOM,subtype:c_pageNumPosition.PAGE_NUM_POSITION_RIGHT}}];for(var s=0;s<i.length;s++)i[s].imgstyle=Ext.String.format("background-image:url({0});","resources/img/toolbar/colontitules.png"),i[s].imgstyle+=Ext.String.format("background-image:-webkit-image-set(url({0}) 1x, url({1}) 2x);","resources/img/toolbar/colontitules.png","resources/img/toolbar/colontitules@2x.png"),i[s].imgstyle+=Ext.String.format("background-position:0 {0}px; width:33px; height:33px;",-i[s].offsety);this.mnuInsertPageNum=Ext.widget("menuitem",{text:this.textInsertPageNumber,cls:"menu-item-noicon",hideOnClick:!1,menu:{showSeparator:!1,items:[t.pageNumHeaderFooter=Ext.widget("container",{style:"text-align:center;padding: 8px 0 0 0;",cls:"pagenum-container",items:[{xtype:"cmddataviewpicker",padding:"4px 4px 1px 12px",cls:"menu-insertpagenum",width:175,height:110,contentWidth:155,dataTpl:r,viewData:i,listeners:{select:t._onInsertPageNumber,scope:t}}]}),t.pageNumCurrentPos=Ext.widget("menuitem",{text:this.textToCurrent,cls:"menu-item-noicon",listeners:{click:{fn:function(){t.api&&t.api.put_PageNum(-1),t.fireEvent("editcomplete",t),Common.component.Analytics.trackEvent("ToolBar","Page Number")}}}})],listeners:{hide:{fn:function(){t.fireEvent("editcomplete",t)}}}}}),this.btnEditHeader.menu.add(this.mnuInsertPageNum),this.paragraphControls.push(this.pageNumCurrentPos);var o=Ext.create("Ext.XTemplate",'<tpl if="plain">{text}</tpl><tpl if="!plain"><a id="{id}-itemEl" class="'+Ext.baseCSSPrefix+'menu-item-link menu-item-usetitle" href="{href}" hidefocus="true" unselectable="on">'+'<img id="{id}-iconEl" src="{icon}" class="'+Ext.baseCSSPrefix+'menu-item-icon {iconCls}" />'+'<div class="menu-item-title"><span class="'+Ext.baseCSSPrefix+'menu-item-text" style="font-weight:bold;">{[this.getTText(values.text)]}</span></div>'+'<div class="menu-item-decript"><span class="'+Ext.baseCSSPrefix+'menu-item-text">{[this.getDText(values.text)]}</span></div>'+"</a>"+"</tpl>",{getTText:function(e){return/^.*(?=\|)/.exec(e)||e},getDText:function(e){var t=/\|(.*)$/.exec(e);return t?t[1]:""}});this.btnPageSize.menu=Ext.create("Ext.menu.Menu",{showSeparator:!1,id:"menu-page-size",defaults:{group:"pagesize",checked:!1,renderTpl:o,checkHandler:function(e,n){t.api&&n&&(t.btnPageSize.pagesize[0]=e.pagesize[0],t.btnPageSize.pagesize[1]=e.pagesize[1],t.api.change_DocSize(e.pagesize[0],e.pagesize[1]),Common.component.Analytics.trackEvent("ToolBar","Page Size")),t.fireEvent("editcomplete",t)}},items:[{text:"US Letter|21,59cm x 27,94cm",pagesize:[215.9,279.4]},{text:"US Legal|21,59cm x 35,56cm",pagesize:[215.9,355.6]},{checked:!0,text:"A4|21cm x 29,7cm",pagesize:[210,297]},{text:"A5|14,81cm x 20,99cm",pagesize:[148.1,209.9]},{text:"B5|17,6cm x 25,01cm",pagesize:[176,250.1]},{text:"Envelope #10|10,48cm x 24,13cm",pagesize:[104.8,241.3]},{text:"Envelope DL|11,01cm x 22,01cm",pagesize:[110.1,220.1]},{text:"Tabloid|27,94cm x 43,17cm",pagesize:[279.4,431.7]},{text:"A3|29,7cm x 42,01cm",pagesize:[297,420.1]},{text:"Tabloid Oversize|30,48cm x 45,71cm",pagesize:[304.8,457.1]},{text:"ROC 16K|19,68cm x 27,3cm",pagesize:[196.8,273]},{text:"Envelope Choukei 3|11,99cm x 23,49cm",pagesize:[119.9,234.9]},{text:"Super B/A3|33,02cm x 48,25cm",pagesize:[330.2,482.5]}]}),e.push(this.btnPageSize),this.btnColorSchemas.menu=Ext.create("Ext.menu.Menu",{showSeparator:!1,id:"toolbar-menu-color-schemas",items:[]}),e.push(this.btnColorSchemas);var u=window.localStorage.getItem("de-compact-toolbar"),a=u!==null&&parseInt(u)==1;u=window.localStorage.getItem("de-hidden-title");var f=u!==null&&parseInt(u)==1;u=window.localStorage.getItem("de-hidden-status");var l=u!==null&&parseInt(u)==1;this.btnHide.menu=Ext.create("Ext.menu.Menu",{id:"menu-hide-bars",showSeparator:!1,defaults:{checked:!1,targetbar:undefined,hideOnClick:!0},items:[{id:"mnu-hide-bars-toolbar",text:this.textCompactView,checked:a},{text:this.textHideStatusBar,checked:l,checkHandler:function(e,n){e.targetbar===undefined&&(e.targetbar=Ext.ComponentQuery.query("documentstatusinfo")[0]),e.targetbar&&(n?e.targetbar.hide():e.targetbar.show()),window.localStorage.setItem("de-hidden-status",n?1:0),t.fireEvent("editcomplete",t)}},{xtype:"menuseparator"},this.btnFitPage,this.btnFitWidth,{xtype:"container",layout:{type:"hbox",align:"middle"},width:165,style:"font-size:11px; padding:6px 2px 3px 32px;",items:[{xtype:"label",text:t.textZoom},{xtype:"tbspacer",flex:1},this.btnZoomOut,{xtype:"tbspacer",width:1},this.txtZoom,this.btnZoomIn,{xtype:"tbspacer",width:5}]}]}),e.push(this.btnHide);for(s=0;s<e.length;s++){var c=e[s];c.menu.ownerCt=c,c.mon(e[s].menu,{scope:c,show:c.onMenuShow,hide:c.onMenuHide}),c.rendered&&c.initAria()}var h=[{sizevalue:8,sizestring:"8"},{sizevalue:9,sizestring:"9"},{sizevalue:10,sizestring:"10"},{sizevalue:11,sizestring:"11"},{sizevalue:12,sizestring:"12"},{sizevalue:14,sizestring:"14"},{sizevalue:16,sizestring:"16"},{sizevalue:18,sizestring:"18"},{sizevalue:20,sizestring:"20"},{sizevalue:22,sizestring:"22"},{sizevalue:24,sizestring:"24"},{sizevalue:26,sizestring:"26"},{sizevalue:28,sizestring:"28"},{sizevalue:36,sizestring:"36"},{sizevalue:48,sizestring:"48"},{sizevalue:72,sizestring:"72"}];this.cmbFontSize.store.loadData(h),this.cmbFontSize.select(this.cmbFontSize.store.getAt(3));if(this.api){this.api.asc_registerCallback("asc_onTextColor",Ext.bind(this._onTextColor,this)),this.api.asc_registerCallback("asc_onLockHeaderFooters",Ext.bind(this._onLockHeaderFooters,this)),this.api.asc_registerCallback("asc_onUnLockHeaderFooters",Ext.bind(this._onUnLockHeaderFooters,this));var p=this.api.get_PropertyThemeColorSchemes();p&&this._onSendThemeColorSchemes(p)}this.needShowSynchTip&&(this.needShowSynchTip=!1,this._onCollaborativeChanges())},textBold:"Bold",textItalic:"Italic",textUnderline:"Underline",textStrikeout:"Strikeout",textSuperscript:"Superscript",textSubscript:"Subscript",strMenuNoFill:"No Fill",tipFontName:"Font Name",tipFontSize:"Font Size",tipCopy:"Copy",tipPaste:"Paste",tipUndo:"Undo",tipRedo:"Redo",tipPrint:"Print",tipSave:"Save",tipIncFont:"Increment font size",tipDecFont:"Decrement font size",tipHighlightColor:"Highlight color",tipFontColor:"Font color",tipMarkers:"Bullets",tipNumbers:"Numbering",tipMultilevels:"Outline",tipAlignLeft:"Align Left",tipAlignRight:"Align Right",tipAlignCenter:"Align Center",tipAlignJust:"Justified",tipDecPrLeft:"Decrease Indent",tipIncPrLeft:"Increase Indent",tipShowHiddenChars:"Nonprinting Characters",tipLineSpace:"Paragraph Line Spacing",tipPrColor:"Background color",tipInsertTable:"Insert Table",tipInsertImage:"Insert Picture",tipPageBreak:"Insert Page Break",tipInsertNum:"Insert Page Number",tipClearStyle:"Clear Style",tipCopyStyle:"Copy Style",tipPageSize:"Page Size",tipPageOrient:"Page Orientation",tipBack:"Back",tipInsertShape:"Insert Autoshape",mniImageFromFile:"Picture from file",mniImageFromUrl:"Picture from url",mniCustomTable:"Insert Custom Table",textTitleError:"Error",textInsertPageNumber:"Insert page number",textToCurrent:"To Current Position",tipEditHeader:"Edit Document Header or Footer",mniEditHeader:"Edit Document Header",mniEditFooter:"Edit Document Footer",tipInsertHyperlink:"Add Hyperlink",mniHiddenChars:"Nonprinting Characters",mniHiddenBorders:"Hidden Table Borders",tipNewDocument:"New Document",tipOpenDocument:"Open Document",tipSynchronize:"The document has been changed by another user. Please click to save your changes and reload the updates.",textNewColor:"Add New Custom Color",tipInsertChart:"Insert Chart",textLine:"Line Chart",textColumn:"Column Chart",textBar:"Bar Chart",textArea:"Area Chart",textPie:"Pie Chart",textPoint:"Point Chart",textStock:"Stock Chart",textThemeColors:"Theme Colors",textStandartColors:"Standart Colors",tipColorSchemas:"Change Color Scheme",tipInsertText:"Insert Text",tipHAligh:"Horizontal Align",tipViewSettings:"View Settings",tipAdvSettings:"Advanced Settings",textCompactView:"View Compact Toolbar",textHideTitleBar:"Hide Title Bar",textHideStatusBar:"Hide Status Bar",textHideLines:"Hide Lines",textFitPage:"Fit Page",textFitWidth:"Fit Width",textZoom:"Zoom",mniEditDropCap:"Drop Cap Settings",textNone:"None",textInText:"In Text",textInMargin:"In Margin",tipDropCap:"Insert drop cap",txtScheme1:"Office",txtScheme2:"Grayscale",txtScheme3:"Apex",txtScheme4:"Aspect",txtScheme5:"Civic",txtScheme6:"Concourse",txtScheme7:"Equity",txtScheme8:"Flow",txtScheme9:"Foundry",txtScheme10:"Median",txtScheme11:"Metro",txtScheme12:"Module",txtScheme13:"Opulent",txtScheme14:"Oriel",txtScheme15:"Origin",txtScheme16:"Paper",txtScheme17:"Solstice",txtScheme18:"Technic",txtScheme19:"Trek",txtScheme20:"Urban",txtScheme21:"Verve"}),Ext.define("DE.controller.Toolbar",function(){var e=function(e,t){switch(t){case c_oAscAsyncAction.Save:this.getToolbar().btnSave.disable(),Ext.ComponentQuery.query("defile")[0].btnSave.disable()}},t=function(e,t){switch(t){case c_oAscAsyncAction.Save:this.getToolbar().btnSave.enable(),Ext.ComponentQuery.query("defile")[0].btnSave.enable()}};return{extend:"Ext.app.Controller",requires:["Common.view.ImageFromUrlDialog","Common.view.CopyWarning","DE.view.HyperlinkSettingsDialog","DE.view.InsertTableDialog","Common.plugin.MenuExpand","Ext.util.Cookies","DE.view.DropcapSettingsAdvanced"],views:["Toolbar"],refs:[{ref:"toolbar",selector:"detoolbar"},{ref:"cmbFontSize",selector:"#toolbar-combo-font-size"},{ref:"menuLineSpace",selector:"#toolbar-menu-line-space"},{ref:"btnPageSize",selector:"#toolbar-button-pagesize"},{ref:"listStyles",selector:"#toolbar-combo-view-styles"},{ref:"btnInsertShape",selector:"#toolbar-button-insert-shape"},{ref:"btnHorizontalAlign",selector:"#toolbar-button-halign"},{ref:"btnDropCap",selector:"#toolbar-button-dropcap"},{ref:"mnuDropCapAdvanced",selector:"#mnu-dropcap-advanced"}],flg:{},init:function(){this._state={bullets:{type:undefined,subtype:undefined},prstyle:undefined,prstyleNoStyles:!0,undo:undefined,redo:undefined,prcontrolsdisable:undefined,dropcap:c_oAscDropCap.None},this._isAddingShape=!1,this.control({detoolbar:{afterrender:function(e){e.ownerCt.addListener("resize",Ext.bind(this.resizeToolbar,this)),Ext.FocusManager.unsubscribe(e)}},"#toolbar-combo-fonts":{select:function(e,t,n){this.api&&this.api.put_TextPrFontName(t[0].data.name),this.getToolbar().fireEvent("editcomplete",this),Common.component.Analytics.trackEvent("ToolBar","Font Name")},collapse:function(e,t){this.getToolbar().fireEvent("editcomplete",this.getToolbar())}},"#toolbar-combo-font-size":{select:this._fontsizeSelect,beforequery:this._fontsizeBeforeQuery,collapse:this._fontsizeCollapse,specialkey:this._fontsizeSpecialKey},"#toolbar-button-bold":{click:this._clickBold},"#toolbar-button-italic":{click:this._clickItalic},"#toolbar-button-underline":{click:this._clickUnderline},"#toolbar-strikeout":{click:this._clickStrikeout},"#toolbar-button-superscript":{click:this._clickSuperscript},"#toolbar-button-subscript":{click:this._clickSubscript},"#toolbar-button-print":{click:this._handlePrint},"#toolbar-button-save":{click:this._handleSave},"#toolbar-button-copy":{click:{fn:this.handleCopyPaste,action:"copy"}},"#toolbar-button-paste":{click:{fn:this.handleCopyPaste,action:"paste"}},"#toolbar-button-undo":{click:this._handleUndo},"#toolbar-button-redo":{click:this._handleRedo},"#toolbar-button-increase-font":{click:this._handleIncrease},"#toolbar-button-decrease-font":{click:this._handleDecrease},"#toolbar-btn-markers":{click:function(e){var t={data:{data:{type:0,subtype:e.pressed?0:-1}}};this._onSelectBullets(e.menu.picker,t,e.id,e.pressed),this.getToolbar().fireEvent("editcomplete",this.getToolbar())}},"#toolbar-btn-numbering":{click:function(e){var t={data:{data:{type:1,subtype:e.pressed?0:-1}}};this._onSelectBullets(e.menu.picker,t,e.id,e.pressed),this.getToolbar().fireEvent("editcomplete",this.getToolbar())}},"#toolbar-button-align-left":{click:Ext.bind(this._handleHorizontalAlign,this,[1])},"#toolbar-button-align-center":{click:Ext.bind(this._handleHorizontalAlign,this,[2])},"#toolbar-button-align-right":{click:Ext.bind(this._handleHorizontalAlign,this,[0])},"#toolbar-button-align-just":{click:Ext.bind(this._handleHorizontalAlign,this,[3])},"#toolbar-button-dec-left-offset":{click:function(e){this.api&&this.api.DecreaseIndent(),this.getToolbar().fireEvent("editcomplete",this.getToolbar()),Common.component.Analytics.trackEvent("ToolBar","Indent")}},"#toolbar-button-inc-left-offset":{click:function(e){this.api&&this.api.IncreaseIndent(),this.getToolbar().fireEvent("editcomplete",this.getToolbar()),Common.component.Analytics.trackEvent("ToolBar","Indent")}},"#toolbar-menu-insertimage":{click:function(e,t,n){t.from=="file"?(this.getToolbar().fireEvent("insertimage",this.getToolbar()),this.api&&this.api.AddImage(),this.getToolbar().fireEvent("editcomplete",this.getToolbar()),Common.component.Analytics.trackEvent("ToolBar","Image")):this._mnuOpenImageFromURL()},hide:function(){this.getToolbar().fireEvent("editcomplete",this.getToolbar())}},"#toolbar-menu-line-space":{hide:function(e){this.getToolbar().fireEvent("editcomplete",this.getToolbar())}},"#toolbar-menu-line-space menuitem":{click:function(e){this.api&&this.api.put_PrLineSpacing(c_paragraphLinerule.LINERULE_AUTO,e.linespace),Common.component.Analytics.trackEvent("ToolBar","Line Spacing")}},"#toolbar-button-page-break":{click:function(e){this.api&&this.api.put_AddPageBreak(),this.getToolbar().fireEvent("editcomplete",this.getToolbar()),Common.component.Analytics.trackEvent("ToolBar","Page Break")}},"#toolbar-menu-edit-header":{hide:function(e){this.getToolbar().fireEvent("editcomplete",this.getToolbar())}},"#toolbar-menu-edit-header menuitem":{click:function(e){if(e.place=="Header")this.api.GoToHeader(this.api.getCurrentPage());else{if(e.place!="Footer")return;this.api.GoToFooter(this.api.getCurrentPage())}this.getToolbar().fireEvent("editcomplete",this.getToolbar()),Common.component.Analytics.trackEvent("ToolBar","Edit "+e.place)}},"#toolbar-button-insert-hyperlink":{click:function(e){this._handleHyperlinkOptions()}},"#toolbar-button-clear-style":{click:function(e){this.api&&this.api.ClearFormating(),this.getToolbar().fireEvent("editcomplete",this.getToolbar())}},"#toolbar-button-copy-style":{click:function(e){this.api&&this.api.SetPaintFormat(e.pressed),this.getToolbar().fireEvent("editcomplete",this.getToolbar())}},"#menu-page-size menuitem":{click:function(e){this.getToolbar().fireEvent("editcomplete",this.getToolbar())}},"#menu-page-size":{hide:function(e){this.getToolbar().fireEvent("editcomplete",this.getToolbar())}},"#toolbar-button-pageorient":{click:function(e){this.api&&this.api.change_PageOrient(!e.pressed),this.getToolbar().fireEvent("editcomplete",this.getToolbar()),Common.component.Analytics.trackEvent("ToolBar","Page Orientation")}},"#toolbar-button-newdocument":{click:function(e){this.api&&this.api.OpenNewDocument(),this.getToolbar().fireEvent("editcomplete",this.getToolbar()),Common.component.Analytics.trackEvent("ToolBar","New Document")}},"#toolbar-button-opendocument":{click:function(e){this.api&&this.api.LoadDocumentFromDisk(),this.getToolbar().fireEvent("editcomplete",this.getToolbar()),Common.component.Analytics.trackEvent("ToolBar","Open Document")}},"#toolbar-combo-view-styles":{select:function(e,t){this.api&&this.api.put_Style(t.data.title),this.getToolbar().fireEvent("editcomplete",this.getToolbar()),Common.component.Analytics.trackEvent("ToolBar","Style")},menuhide:function(){this.getToolbar().fireEvent("editcomplete",this.getToolbar())},releasecapture:function(e){this.getToolbar().fireEvent("editcomplete",this.getToolbar())},render:function(e){this.styles&&(this._onInitEditorStyles(this.styles),delete this.styles)},afterrender:function(e){this.getListStyles().dataMenu.picker.store.getCount()>0&&this.getListStyles().fillComboView(this.getListStyles().dataMenu.picker.store.getAt(0),!0)}},"#toolbar-button-insert-shape":{click:function(e){e.pressed?this.getToolbar().btnInsertText.pressed&&(this.getToolbar().btnInsertText.toggle(!1,!0),this.api&&this._addAutoshape(!1)):(this.api&&this._addAutoshape(!1),e.hideMenu(),this.getToolbar().fireEvent("editcomplete",this.getToolbar()))},afterrender:Ext.bind(function(e){var t=this;e.getEl().on("mousedown",function(e,n,r){t._toggleFromMenuHide=!1},t)},this)},"#toolbar-menu-insert-shape":{hide:function(){this.getBtnInsertShape().pressed&&!this._isAddingShape&&this._toggleFromMenuHide&&(this._toggleFromMenuHide=!1,this.getBtnInsertShape().toggle(!1,!1)),this._isAddingShape=!1,this.getToolbar().fireEvent("editcomplete",this.getToolbar(),this.getBtnInsertShape())},show:function(){this._toggleFromMenuHide=!0}},"#toolbar-button-insert-text":{click:function(e){this.api&&this._addAutoshape(e.pressed,"textRect"),this.getBtnInsertShape().pressed&&this.getBtnInsertShape().toggle(!1,!0),this.getToolbar().fireEvent("editcomplete",this.getToolbar(),this.getBtnInsertShape()),Common.component.Analytics.trackEvent("ToolBar","Add Text")}},"#toolbar-menu-insert-table":{hide:function(){this.getToolbar().fireEvent("editcomplete",this.getToolbar())}},"#toolbar-menu-insert-table dedimensionpicker":{beforerender:function(e){if(e.stalign=="top"){var t=e.renderTpl.splice(6,1);e.renderTpl.splice(1,0,t[0])}},select:function(e,t,n){this.api&&(this.getToolbar().fireEvent("inserttable",this.getToolbar()),this.api.put_Table(t,n)),this.getToolbar().fireEvent("editcomplete",this.getToolbar()),Ext.menu.Manager.hideAll(),Common.component.Analytics.trackEvent("ToolBar","Table")},afterrender:function(e){$("#"+e.id).mouseleave(function(){Ext.getCmp(this.id).setTableSize(0,0)})}},"#toolbar-insert-custom-table":{click:function(e){var t=Ext.create("DE.view.InsertTableDialog",{}),n=this;t.addListener("onmodalresult",function(e,t,r){t&&n.api&&(n.getToolbar().fireEvent("inserttable",n.getToolbar()),n.api.put_Table(r[0],r[1])),n.getToolbar().fireEvent("editcomplete",n.getToolbar()),Common.component.Analytics.trackEvent("ToolBar","Table")},!1),t.show()}},"#toolbar-menu-color-schemas":{hide:function(){this.getToolbar().fireEvent("editcomplete",this.getToolbar())},click:this._handleMenuSchemas},"#toolbar-menu-horalign":{click:this._handleMenuHorizontalAlign},"#toolbar-menu-horalign menuitem":{beforecheckchange:function(e){e.checked||this._clearChecked(this.getBtnHorizontalAlign().menu.items.items)}},"#toolbar-button-settings":{click:function(){Ext.menu.Manager.hideAll();var e=!1,t=Ext.getCmp("main-menu-file-options");t&&(t.activeBtn===t.btnDocumentSettings&&(e=!0),t.activeBtn=t.btnDocumentSettings);var n=Ext.getCmp("view-main-menu");n&&(n.currentFullScaleMenuBtn==undefined||n.currentFullScaleMenuBtn.id!="id-menu-file"?n.selectMenu("menuFile"):e?n.closeFullScaleMenu():t._onShow())}},"#toolbar-menu-fit-page":{click:function(e){this.api&&(e.checked?this.api.zoomFitToPage():this.api.zoomCustomMode()),this.getToolbar().fireEvent("editcomplete",this.getToolbar())}},"#toolbar-menu-fit-width":{click:function(e){this.api&&(e.checked?this.api.zoomFitToWidth():this.api.zoomCustomMode()),this.getToolbar().fireEvent("editcomplete",this.getToolbar())}},"#toolbar-menu-zoomin":{click:function(){this.api&&this.api.zoomIn(),this.getToolbar().fireEvent("editcomplete",this.getToolbar())}},"#toolbar-menu-zoomout":{click:function(){this.api&&this.api.zoomOut(),this.getToolbar().fireEvent("editcomplete",this.getToolbar())}},"#toolbar-menu-zoom-text":{afterrender:function(e){e.setWidth(Ext.util.TextMetrics.measure(e.getEl(),"100%").width)}},"#menu-hide-bars":{hide:function(){this.getToolbar().fireEvent("editcomplete",this.getToolbar())}},"#toolbar-menu-dropcap":{click:this._handleDropCap,hide:Ext.bind(function(){this.getToolbar().fireEvent("editcomplete",this.getToolbar())},this)},"#toolbar-menu-dropcap menuitem":{beforecheckchange:function(e){e.checked||this._clearChecked(this.getBtnDropCap().menu.items.items)}},"#mnu-dropcap-advanced":{click:this._handleDropCapAdvanced},"#mnu-hide-bars-toolbar":{click:function(e){this.getToolbar().changeViewMode(e.checked),window.localStorage.setItem("de-compact-toolbar",e.checked?1:0);if(this._state.prstyleNoStyles&&!e.checked&&this.getListStyles().dataMenu.picker.store.getCount()>0){var t=this.getListStyles().dataMenu.picker.store.findBy(function(e,t){return e.data.title===this._state.prstyle},this);this.getListStyles().selectByIndex(t>=0?t:0)}this._state.prstyleNoStyles=!1,this.getToolbar().fireEvent("editcomplete",this.getToolbar())}}})},setApi:function(e){this.api=e},resizeToolbar:function(e,t,n){var r=this.getToolbar().getWidth();r!==t&&this.getToolbar().setWidth(t),this.shapeMenuExpandLeft=t<1072},_getApiTextSize:function(){var e=12,t=this.api.get_TextProps();return t&&t.get_TextPr&&(e=t.get_TextPr().get_FontSize()),e},_fontsizeCollapse:function(e,t){if(!this.flg.setFontSize){var n=e.getRawValue(),r=this._getApiTextSize();r&&n!=r&&(e.getStore().clearFilter(!1),e.setValue(r))}this.getToolbar().fireEvent("editcomplete",this.getToolbar())},_fontsizeSelect:function(e,t,n){this.flg.setFontSize=!0,this.api&&this.api.put_TextPrFontSize(t[0].data.sizevalue),this.getToolbar().fireEvent("editcomplete",this.getToolbar()),this.flg.setFontSize=!1,Common.component.Analytics.trackEvent("ToolBar","Font Size")},_fontsizeBeforeQuery:function(e,t){e.forceAll=!0,e.cancel=!0,e.combo.expand();var n=e.combo.getPicker(),r=e.combo.store.find("sizestring",e.query,undefined,undefined,undefined,!0);if(r<0)n.clearHighlight(),n.highlightedItem=undefined;else{var i=e.combo.store.getAt(r);(i=n.getNode(i))&&n.highlightItem(i)}},_fontsizeSpecialKey:function(e,t,n){if(t.getKey()==t.ENTER){var r=e.getPicker().highlightedItem,i=!1;if(r)var s=e.getPicker().getRecord(r).data.sizestring;else s=/^\+?(\d*\.?\d+)$|^\+?(\d+\.?\d*)$/.exec(e.getValue()),s?(s=s[0]?parseFloat(s[0]):parseFloat(s[1]),s=s>100?100:s<1?1:Math.floor((s+.4)*2)/2):(s=this._getApiTextSize(),i=!0);e.getStore().clearFilter(!1),e.setRawValue(s),this.flg.setFontSize=!0,e.collapse(),i?Ext.Msg.show({title:this.textWarning,msg:this.textFontSizeErr,icon:Ext.Msg.WARNING,buttons:Ext.Msg.OK,fn:function(){this.getToolbar().fireEvent("editcomplete",this.getToolbar())},scope:this}):this.api.put_TextPrFontSize(s),this.flg.setFontSize=!1}},_onFontSize:function(e){if(!this.flg.setFontSize){var t=Ext.isNumber(e)?String(e):"";this.getCmbFontSize().getValue()!=t&&this.getCmbFontSize().setValue(t)}},_onBold:function(e){this.getToolbar().btnBold.toggle(e===!0,!0)},_clickBold:function(e){this.api&&this.api.put_TextPrBold(e.pressed),this.getToolbar().fireEvent("editcomplete",this),Common.component.Analytics.trackEvent("ToolBar","Bold")},_onItalic:function(e){this.getToolbar().btnItalic.toggle(e===!0,!0)},_clickItalic:function(e){this.api&&this.api.put_TextPrItalic(e.pressed),this.getToolbar().fireEvent("editcomplete",this),Common.component.Analytics.trackEvent("ToolBar","Italic")},_onUnderline:function(e){this.getToolbar().btnUnderline.toggle(e===!0,!0)},_clickUnderline:function(e){this.api&&this.api.put_TextPrUnderline(e.pressed),this.getToolbar().fireEvent("editcomplete",this),Common.component.Analytics.trackEvent("ToolBar","Underline")},_onStrikeout:function(e){this.getToolbar().btnStrikeout.toggle(e===!0,!0)},_clickStrikeout:function(e){this.api&&this.api.put_TextPrStrikeout(e.pressed),this.getToolbar().fireEvent("editcomplete",this),Common.component.Analytics.trackEvent("ToolBar","Strikeout")},_clickSuperscript:function(e){this.getToolbar().btnSubscript.pressed||(this.api&&this.api.put_TextPrBaseline(e.pressed?1:0),this.getToolbar().fireEvent("editcomplete",this),Common.component.Analytics.trackEvent("ToolBar","Superscript"))},_clickSubscript:function(e){this.getToolbar().btnSuperscript.pressed||(this.api&&this.api.put_TextPrBaseline(e.pressed?2:0),this.getToolbar().fireEvent("editcomplete",this),Common.component.Analytics.trackEvent("ToolBar","Subscript"))},_onVerticalAlign:function(e){this.getToolbar().btnSuperscript.toggle(!1,!0),this.getToolbar().btnSubscript.toggle(!1,!0);switch(e){case 1:this.getToolbar().btnSuperscript.toggle(!0,!0);break;case 2:this.getToolbar().btnSubscript.toggle(!0,!0)}},_handlePrint:function(e){this.api&&this.api.asc_Print(),this.getToolbar().fireEvent("editcomplete",this.getToolbar()),Common.component.Analytics.trackEvent("Print"),Common.component.Analytics.trackEvent("ToolBar","Print")},_handleSave:function(e){this.api&&this.api.asc_Save(),Common.component.Analytics.trackEvent("Save"),Common.component.Analytics.trackEvent("ToolBar","Save"),this.getToolbar().fireEvent("editcomplete",this.getToolbar())},handleCopyPaste:function(e,t,n){var r=this;if(r.api){var i=n.action=="copy"?r.api.Copy():r.api.Paste();i||Ext.create("Common.view.CopyWarning",{listeners:{close:function(e,t){r.getToolbar().fireEvent("editcomplete",r.getToolbar())}}}).show(),Common.component.Analytics.trackEvent("ToolBar","Copy Warning")}else r.getToolbar().fireEvent("editcomplete",r.getToolbar())},_handleUndo:function(e){this.api&&this.api.Undo(),this.getToolbar().fireEvent("editcomplete",this.getToolbar()),Common.component.Analytics.trackEvent("ToolBar","Undo")},_handleRedo:function(e){this.api&&this.api.Redo(),this.getToolbar().fireEvent("editcomplete",this.getToolbar()),Common.component.Analytics.trackEvent("ToolBar","Redo")},_onCanRevert:function(e,t){t=="undo"?(this._state.undo!==e&&this.getToolbar().btnUndo.setDisabled(!e),this._state.undo=e):(this._state.redo!==e&&this.getToolbar().btnRedo.setDisabled(!e),this._state.redo=e)},_handleIncrease:function(e){this.api&&this.api.FontSizeIn(),this.getToolbar().fireEvent("editcomplete",this.getToolbar()),Common.component.Analytics.trackEvent("ToolBar","Font Size")},_handleDecrease:function(e){this.api&&this.api.FontSizeOut(),this.getToolbar().fireEvent("editcomplete",this.getToolbar()),Common.component.Analytics.trackEvent("ToolBar","Font Size")},_onSelectBullets:function(e,t,n,r){var i=Ext.getCmp(n);i&&(typeof r=="boolean"?i.toggle(r,!0):i.toggle(!(t.data.data.subtype<0),!0)),this.api&&this.api.put_ListType(t.data.data.type,t.data.data.subtype),Common.component.Analytics.trackEvent("ToolBar","List Type")},_clearBullets:function(){this.getToolbar().btnMarkers.toggle(!1,!0),this.getToolbar().btnNumbers.toggle(!1,!0),this.getToolbar().btnMultilevels.toggle(!1,!0),this.getToolbar().btnMarkers.menu.picker.selectByIndex(0),this.getToolbar().btnNumbers.menu.picker.selectByIndex(0),this.getToolbar().btnMultilevels.menu.picker.selectByIndex(0)},_onBullets:function(e){var t=e.get_ListType();if(this._state.bullets.type!=t||this._state.bullets.subtype!=e.get_ListSubType()||this.getToolbar().btnMarkers.pressed&&t!==0||this.getToolbar().btnNumbers.pressed&&t!==1||this.getToolbar().btnMultilevels.pressed&&t!==2){this._state.bullets.type=t,this._state.bullets.subtype=e.get_ListSubType(),this._clearBullets();switch(this._state.bullets.type){case 0:this.getToolbar().btnMarkers.toggle(!0,!0),this.getToolbar().btnMarkers.menu.picker.selectByIndex(this._state.bullets.subtype);break;case 1:var n=0;switch(this._state.bullets.subtype){case 1:n=4;break;case 2:n=5;break;case 3:n=6;break;case 4:n=1;break;case 5:n=2;break;case 6:n=3;break;case 7:n=7}this.getToolbar().btnNumbers.toggle(!0,!0),this.getToolbar().btnNumbers.menu.picker.selectByIndex(n);break;case 2:this.getToolbar().btnMultilevels.toggle(!0,!0),this.getToolbar().btnMultilevels.menu.picker.selectByIndex(this._state.bullets.subtype)}}},_clearChecked:function(e){for(var t=0;t<e.length;t++)e[t].setChecked&&e[t].setChecked(!1,!0)},_handleHorizontalAlign:function(e){this.api&&this.api.put_PrAlign(e),this.getToolbar().fireEvent("editcomplete",this.getToolbar()),Common.component.Analytics.trackEvent("ToolBar","Align")},_handleMenuHorizontalAlign:function(e,t,n){this.getBtnHorizontalAlign().removeCls(this.getBtnHorizontalAlign().icls),this.getBtnHorizontalAlign().icls=t.checked?t.icls:"halign-left",this.getBtnHorizontalAlign().addCls(this.getBtnHorizontalAlign().icls),this.api&&t.checked&&this.api.put_PrAlign(t.halign),this.getToolbar().fireEvent("editcomplete",this.getToolbar()),Common.component.Analytics.trackEvent("ToolBar","Horizontal Align")},_onParagraphAlign:function(e){var t=-1,n,r=this.getToolbar();switch(e){case 0:t=2,n="halign-right";break;case 1:t=0,n="halign-left";break;case 2:t=1,n="halign-center";break;case 3:t=3,n="halign-just";break;default:t=-255,n="halign-left"}t<0?t==-255&&this._clearChecked(this.getBtnHorizontalAlign().menu.items.items):this.getBtnHorizontalAlign().menu.items.items[t].setChecked(!0),this.getBtnHorizontalAlign().removeCls(this.getBtnHorizontalAlign().icls),this.getBtnHorizontalAlign().icls=n,this.getBtnHorizontalAlign().addCls(n);if(e===null||e===undefined){r.btnAlignRight.rendered&&r.btnAlignRight.toggle(!1,!0),r.btnAlignLeft.rendered&&r.btnAlignLeft.toggle(!1,!0),r.btnAlignCenter.rendered&&r.btnAlignCenter.toggle(!1,!0),r.btnAlignJust.rendered&&r.btnAlignJust.toggle(!1,!0);return}switch(e){case 0:r.btnAlignRight.rendered&&r.btnAlignRight.toggle(!0,!1);break;case 1:r.btnAlignLeft.rendered&&r.btnAlignLeft.toggle(!0,!1);break;case 2:r.btnAlignCenter.rendered&&r.btnAlignCenter.toggle(!0,!1);break;case 3:r.btnAlignJust.rendered&&r.btnAlignJust.toggle(!0,!1)}},_mnuOpenImageFromURL:function(){var e=Ext.create("Common.view.ImageFromUrlDialog",{});e.addListener("onmodalresult",Ext.bind(this._onOpenImageFromURL,[this,e]),!1),e.addListener("close",Ext.bind(function(e,t){this.getToolbar().fireEvent("editcomplete",this.getToolbar())},this)),e.show()},_onOpenImageFromURL:function(e){var t=this[0],n=this[1].txtUrl;if(e==1&&t.api){var r=n.value.replace(/ /g,"");r!=""?(t.getToolbar().fireEvent("insertimage",t.getToolbar()),t.api.AddImageUrl(n.value),Common.component.Analytics.trackEvent("ToolBar","Image")):Ext.MessageBox.show({msg:t.textEmptyImgUrl,buttons:Ext.Msg.OK,icon:Ext.Msg.ERROR,width:300,fn:Ext.bind(function(e,n,r){t.getToolbar().fireEvent("editcomplete",t.getToolbar())},t)})}},_onLineSpacing:function(e){if(e.get_Line()===null||e.get_LineRule()===null||e.get_LineRule()!=1){Ext.each(this.getMenuLineSpace().items.items,function(e){e.setChecked(!1,!0)},this);return}var t=e.get_Line();Math.abs(t-1)<1e-4?this.getMenuLineSpace().items.items[0].setChecked(!0,!0):Math.abs(t-1.15)<1e-4?this.getMenuLineSpace().items.items[1].setChecked(!0,!0):Math.abs(t-1.5)<1e-4?this.getMenuLineSpace().items.items[2].setChecked(!0,!0):Math.abs(t-2)<1e-4?this.getMenuLineSpace().items.items[3].setChecked(!0,!0):Math.abs(t-2.5)<1e-4?this.getMenuLineSpace().items.items[4].setChecked(!0,!0):Math.abs(t-3)<1e-4?this.getMenuLineSpace().items.items[5].setChecked(!0,!0):Ext.each(this.getMenuLineSpace().items.items,function(e){e.setChecked(!1,!0)},this)},_handleHyperlinkOptions:function(e){var t,n,r,i=this;if(i.api){r=i.api.can_AddHyperlink();if(r!==!1)t=Ext.create("DE.view.HyperlinkSettingsDialog"),n=new CHyperlinkProperty,n.put_Text(r),t.setSettings(n);else{var s=i.api.getSelectedElements();if(s&&Ext.isArray(s))for(var o=0;o<s.length;o++)s[o].get_ObjectType()==c_oAscTypeSelectElement.Hyperlink&&(n=s[o].get_ObjectValue());n&&(t=Ext.create("DE.view.HyperlinkSettingsDialog"),t.setSettings(n))}}t&&(t.addListener("onmodalresult",function(e){e==1&&(n=t.getSettings(),r!==!1?i.api.add_Hyperlink(n):i.api.change_Hyperlink(n)),i.getToolbar().fireEvent("editcomplete",i.getToolbar())},!1),t.addListener("close",function(){i.getToolbar().fireEvent("editcomplete",i.getToolbar())},!1),t.show()),Common.component.Analytics.trackEvent("ToolBar","Add Hyperlink")},_onCanAddHyperlink:function(e){var t=!e||this._state.prcontrolsdisable;t!=this.getToolbar().btnInsertHyperlink.isDisabled()&&this.getToolbar().btnInsertHyperlink.setDisabled(t)},_onFocusObject:function(e){var t,n,r=-1,i,s=!1,o=!1,u=!1,a=undefined,f=!0,l=undefined;while(++r<e.length){i=e[r].get_ObjectType(),t=e[r].get_ObjectValue(),i==c_oAscTypeSelectElement.Paragraph?(s=t.get_Locked(),u=t.get_CanAddTable(),l=t):i==c_oAscTypeSelectElement.Header&&(o=t.get_Locked());if(i===c_oAscTypeSelectElement.Table||i===c_oAscTypeSelectElement.Header||i===c_oAscTypeSelectElement.Image)a=!1;a!==!1&&i==c_oAscTypeSelectElement.Paragraph&&(a=!0)}var c=s||o;this._state.prcontrolsdisable!=c&&(this._state.prcontrolsdisable=c,Ext.each(this.getToolbar().paragraphControls,function(e){e.setDisabled(c)},this));if(a&&l){var h=l.get_FramePr(),p=c_oAscDropCap.None;h!==undefined?(p=h.get_DropCap(),a=p===c_oAscDropCap.Drop||p===c_oAscDropCap.Margin,f=!1):a=l.get_CanAddDropCap(),a&&this._onDropCap(p)}c=c||!a,c!==this.getToolbar().btnDropCap.isDisabled()&&this.getToolbar().btnDropCap.setDisabled(c),!this.getToolbar().btnDropCap.isDisabled()&&f!==this.getMnuDropCapAdvanced().isDisabled()&&this.getMnuDropCapAdvanced().setDisabled(f),c=!u||o,c!=this.getToolbar().btnInsertTable.isDisabled()&&this.getToolbar().btnInsertTable.setDisabled(c),c=this.getToolbar().pageNumCurrentPos.isDisabled()&&this.getToolbar().pageNumHeaderFooter.isDisabled(),c!=this.getToolbar().mnuInsertPageNum.isDisabled()&&this.getToolbar().mnuInsertPageNum.setDisabled(c)},_onStyleChange:function(e){this.getToolbar().btnCopyStyle.toggle(e,!0)},_onPageSize:function(e,t){var n=e,r=t;this.getBtnPageSize()&&Ext.each(this.getBtnPageSize().menu.items.items,function(e){Math.abs(e.pagesize[0]-n)<.01&&Math.abs(e.pagesize[1]-r)<.01&&(e.setChecked(!0,!0),this.getBtnPageSize().pagesize[0]=n,this.getBtnPageSize().pagesize[1]=r)},this)},_onPageOrient:function(e){this.getToolbar()&&this.getToolbar().btnPageOrient.toggle(!e,!0)},_onLockDocumentProps:function(){this.getToolbar().btnPageOrient.setDisabled(!0),this.getBtnPageSize().setDisabled(!0)},_onUnLockDocumentProps:function(){this.getToolbar().btnPageOrient.setDisabled(!1),this.getBtnPageSize().setDisabled(!1)},_onLockDocumentSchema:function(){this.getToolbar().btnColorSchemas.setDisabled(!0)},_onUnLockDocumentSchema:function(){this.getToolbar().btnColorSchemas.setDisabled(!1)},_onParagraphStyleChange:function(e){if(this._state.prstyle!=e){this._state.prstyle=e;var t=this.getListStyles().rendered&&this.getListStyles().getEl()&&this.getListStyles().getEl().up("#id-toolbar-full-group-styles")&&this.getListStyles().getEl().up("#id-toolbar-full-group-styles").isVisible();if(t){this.getListStyles().suspendEvents(!1);var n=this.getListStyles().dataMenu.picker.store.findBy(function(t,n){return t.data.title===e},this);this.getListStyles().selectByIndex(n),this.getListStyles().resumeEvents()}}},_onInitEditorStyles:function(e){window.styles_loaded=!1;var t=this;if(!t.getListStyles()){t.styles=e;return}var n=document.createElement("canvas"),r=document.createElement("canvas");n.id="bigimgdefaultstyles",r.id="bigimgdocstyles";var i=!(e.get_DefaultStylesImage().length>0),s=!(e.get_DocStylesImage().length>0),o=function(){if(i&&s){t.getListStyles().dataMenu.picker.store.removeAll(),Ext.each(e.get_MergedStyles(),function(i){var s=document.createElement("canvas");s.width=e.get_STYLE_THUMBNAIL_WIDTH(),s.height=e.get_STYLE_THUMBNAIL_HEIGHT();var o=s.getContext("2d");o.save(),o.translate(0,-i.get_ThumbnailOffset()*e.get_STYLE_THUMBNAIL_HEIGHT()),o.drawImage(i.get_Type()==c_oAscStyleImage.Default?n:r,0,0),o.restore(),t.getListStyles().dataMenu.picker.store.add({imageUrl:s.toDataURL(),title:i.get_Name(),uid:Ext.id()})});var o=t.getListStyles().rendered&&t.getListStyles().getEl()&&t.getListStyles().getEl().up("#id-toolbar-full-group-styles")&&t.getListStyles().getEl().up("#id-toolbar-full-group-styles").isVisible();t.getListStyles().dataMenu.picker.store.getCount()>0&&o&&(t.getListStyles().fillComboView(t.getListStyles().dataMenu.picker.store.getAt(0),!0),t.getListStyles().selectByIndex(0),t.getToolbar().fireEvent("editcomplete",this))}window.styles_loaded=!0},u=new Image,a=new Image;u.onload=function(){n.width=u.width,n.height=u.height,n.getContext("2d").drawImage(u,0,0),i=!0,o()},a.onload=function(){r.width=a.width,r.height=a.height,r.getContext("2d").drawImage(a,0,0),s=!0,o()},u.src=e.get_DefaultStylesImage(),a.src=e.get_DocStylesImage()},FillAutoShapes:function(){var e=Ext.getStore("ShapeGroups"),t=this;t.getBtnInsertShape().menu.removeAll();for(var n=0;n<e.getCount()-1;n++){var r=e.getAt(n),i=Ext.widget("menuitem",{text:r.data.groupName,hideOnClick:!1,cls:"menu-item-noicon",menu:Ext.create("Common.component.MenuDataViewPicker",{width:r.data.groupWidth,height:r.data.groupHeight,store:r.data.groupStore,viewData:[],contentWidth:r.data.groupWidth-20,listeners:{select:Ext.bind(function(e,n){t.api&&(t._addAutoshape(!0,n.data.data.shapeType),t._isAddingShape=!0,Common.component.Analytics.trackEvent("ToolBar","Add Shape"))},this),hide:function(){t.getToolbar().fireEvent("editcomplete",t.getToolbar(),t.getBtnInsertShape())},show:function(e){e.picker.selectByIndex(-1,!1)}},plugins:[{ptype:"menuexpand"}]}),deferExpandMenu:function(){if(!this.menu.rendered||!this.menu.isVisible())this.parentMenu.activeChild=this.menu,this.menu.parentItem=this,this.menu.parentMenu=this.menu.ownerCt=this.parentMenu,t.shapeMenuExpandLeft?this.menu.showBy(this,"tr-tl?",[-this.menu.width,0]):this.menu.showBy(this,"tl-tr?")}});t.getBtnInsertShape().menu.add(i)}},_onEndAddShape:function(){this.getToolbar().fireEvent("insertshape",this.getToolbar()),this.getBtnInsertShape().pressed&&this.getBtnInsertShape().toggle(!1,!0),this.getToolbar().btnInsertText.pressed&&this.getToolbar().btnInsertText.toggle(!1,!0),Ext.FocusManager.removeListener("componentfocus",this.checkInsertAutoshape,this)},_addAutoshape:function(e,t){e?(this.api.StartAddShape(t,!0),Ext.FocusManager.addListener("componentfocus",this.checkInsertAutoshape,this)):(this.api.StartAddShape("",!1),Ext.FocusManager.removeListener("componentfocus",this.checkInsertAutoshape,this))},checkInsertAutoshape:function(e,t){(this.getToolbar().btnInsertText.pressed||this.getBtnInsertShape().pressed)&&t.id!="editor_sdk"&&(this.getToolbar().btnInsertText.pressed&&t.id!=this.getToolbar().btnInsertText.id||this.getBtnInsertShape().pressed&&t.id!=this.getBtnInsertShape().id)&&(this._toggleFromMenuHide=!1,this._isAddingShape=!1,this._addAutoshape(!1),this.getBtnInsertShape().toggle(!1,!1),this.getToolbar().btnInsertText.toggle(!1,!1),this.getToolbar().fireEvent("editcomplete",this.getToolbar()))},getHexColor:function(e,t,n){return e=e.toString(16),t=t.toString(16),n=n.toString(16),e.length==1&&(e="0"+e),t.length==1&&(t="0"+t),n.length==1&&(n="0"+n),e+t+n},onCoAuthoringDisconnect:function(){this.getToolbar().setMode({isDisconnected:!0})},onZoomChange:function(e,t){this.getToolbar().btnFitPage.setChecked(t==2,!0),this.getToolbar().btnFitWidth.setChecked(t==1,!0),this.getToolbar().txtZoom.setText(e+"%")},_handleDropCap:function(e,t,n){if(t.dropcap===undefined)return;if(this.api&&t.checked)if(t.dropcap===c_oAscDropCap.None)this.api.removeDropcap(!0);else{var r=this.api.getSelectedElements(),i=-1;while(++i<r.length)if(r[i].get_ObjectType()==c_oAscTypeSelectElement.Paragraph){var s=r[i].get_ObjectValue(),o=s.get_FramePr();o!==undefined?(o=new CParagraphFrame,o.put_FromDropCapMenu(!0),o.put_DropCap(t.dropcap),this.api.put_FramePr(o)):this.api.asc_addDropCap(t.dropcap===c_oAscDropCap.Drop);break}}this.getToolbar().fireEvent("editcomplete",this.getToolbar()),Common.component.Analytics.trackEvent("ToolBar","Drop Cap")},_onDropCap:function(e){if(this._state.dropcap===e)return;var t=-1;switch(e){case c_oAscDropCap.None:t=0;break;case c_oAscDropCap.Drop:t=1;break;case c_oAscDropCap.Margin:t=2}t<0?this._clearChecked(this.getBtnDropCap().menu.items.items):this.getBtnDropCap().menu.items.items[t].setChecked(!0),this._state.dropcap=e},_handleDropCapAdvanced:function(){var e,t,n,r=this;if(r.fontstore===undefined){r.fontstore=Ext.create("Ext.data.Store",{storeId:Ext.id(),model:"Common.model.Font"});var i=r.getToolbar().cmbFont.getStore().data.items,s=[];Ext.each(i,function(e,t){e.data.cloneid||s.push(Ext.clone(e.data))}),r.fontstore.loadData(s)}if(r.api){var o=r.api.getSelectedElements();if(o&&Ext.isArray(o))for(var u=0;u<o.length;u++)if(o[u].get_ObjectType()==c_oAscTypeSelectElement.Paragraph){t=o[u].get_ObjectValue();break}if(t){var a={tableStylerRows:2,tableStylerColumns:1,fontStore:r.fontstore};e=Ext.create("DE.view.DropcapSettingsAdvanced",a),e&&(e.updateMetricUnit(),e.setSettings({paragraphProps:t,borderProps:r.borderAdvancedProps,api:r.api,colorProps:[r.getToolbar().effectcolors,r.getToolbar().standartcolors]}),e.addListener("onmodalresult",Ext.bind(function(e,t,n){t==1&&n&&(r.borderAdvancedProps=n.borderProps,n.paragraphProps&&n.paragraphProps.get_DropCap()===c_oAscDropCap.None?r.api.removeDropcap(!0):r.api.put_FramePr(n.paragraphProps)),r.getToolbar().fireEvent("editcomplete",r.getToolbar())},r),!1),e.addListener("close",function(){r.getToolbar().fireEvent("editcomplete",r.getToolbar())},!1),e.show())}}},_handleMenuSchemas:function(e,t){this.api.ChangeColorScheme(t.schemaType),Common.component.Analytics.trackEvent("ToolBar","Color Scheme")},loadStyles:function(){var e=this.api.get_PropertyEditorStyles();e&&this._onInitEditorStyles(e)},createDelayedElements:function(){var n=this.getToolbar().btnMarkers;n.menu.addListener("select",Ext.bind(this._onSelectBullets,this,[n.id,2],2),this),n.menu.addListener("hide",Ext.bind(function(){this.getToolbar().fireEvent("editcomplete",this.getToolbar())},this)),n=this.getToolbar().btnNumbers,n.menu.addListener("select",Ext.bind(this._onSelectBullets,this,[n.id,2],2),this),n.menu.addListener("hide",Ext.bind(function(){this.getToolbar().fireEvent("editcomplete",this.getToolbar())},this)),n=this.getToolbar().btnMultilevels,n.menu.addListener("select",Ext.bind(this._onSelectBullets,this,[n.id,2],2),this),n.menu.addListener("hide",Ext.bind(function(){this.getToolbar().fireEvent("editcomplete",this.getToolbar())},this)),this.api.asc_registerCallback("asc_onFontSize",Ext.bind(this._onFontSize,this)),this.api.asc_registerCallback("asc_onBold",Ext.bind(this._onBold,this)),this.api.asc_registerCallback("asc_onItalic",Ext.bind(this._onItalic,this)),this.api.asc_registerCallback("asc_onUnderline",Ext.bind(this._onUnderline,this)),this.api.asc_registerCallback("asc_onStrikeout",Ext.bind(this._onStrikeout,this)),this.api.asc_registerCallback("asc_onVerticalAlign",Ext.bind(this._onVerticalAlign,this)),this.api.asc_registerCallback("asc_onCanUndo",Ext.bind(this._onCanRevert,this,["undo"],!0)),this.api.asc_registerCallback("asc_onCanRedo",Ext.bind(this._onCanRevert,this,["redo"],!0)),this.api.asc_registerCallback("asc_onListType",Ext.bind(this._onBullets,this)),this.api.asc_registerCallback("asc_onPrAlign",Ext.bind(this._onParagraphAlign,this)),this.api.asc_registerCallback("asc_onParaSpacingLine",Ext.bind(this._onLineSpacing,this)),this.api.asc_registerCallback("asc_onCanAddHyperlink",Ext.bind(this._onCanAddHyperlink,this)),this.api.asc_registerCallback("asc_onFocusObject",Ext.bind(this._onFocusObject,this)),this.api.asc_registerCallback("asc_onPaintFormatChanged",Ext.bind(this._onStyleChange,this)),this.api.asc_registerCallback("asc_onDocSize",Ext.bind(this._onPageSize,this)),this.api.asc_registerCallback("asc_onPageOrient",Ext.bind(this._onPageOrient,this)),this.api.asc_registerCallback("asc_onLockDocumentProps",Ext.bind(this._onLockDocumentProps,this)),this.api.asc_registerCallback("asc_onUnLockDocumentProps",Ext.bind(this._onUnLockDocumentProps,this)),this.api.asc_registerCallback("asc_onParaStyleName",Ext.bind(this._onParagraphStyleChange,this)),this.api.asc_registerCallback("asc_onEndAddShape",Ext.bind(this._onEndAddShape,this)),this.api.asc_registerCallback("asc_onLockDocumentSchema",Ext.bind(this._onLockDocumentSchema,this)),this.api.asc_registerCallback("asc_onUnLockDocumentSchema",Ext.bind(this._onUnLockDocumentSchema,this)),this.api.asc_registerCallback("asc_onСoAuthoringDisconnect",Ext.bind(this.onCoAuthoringDisconnect,this)),this.api.asc_registerCallback("asc_onZoomChange",Ext.bind(this.onZoomChange,this)),this.api.asc_registerCallback("asc_onStartAction",Ext.bind(e,this)),this.api.asc_registerCallback("asc_onEndAction",Ext.bind(t,this)),this._onPageSize(this.api.get_DocumentWidth(),this.api.get_DocumentHeight())},textEmptyImgUrl:"You need to specify image URL.",textWarning:"Warning",textFontSizeErr:"The entered value must be more than 0"}}());