﻿<%@ Page Title="Login" Language="C#" MasterPageFile="~/WebAppPanel.master" AutoEventWireup="true" CodeBehind="MLoginPage.aspx.cs"
    Inherits="GladinetPayFlow.MLoginPage" Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <script type="text/javascript">
        if (top != self) { top.location.replace(self.location.href); }
        var Base64 = {

            // private property
            _keyStr: "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=",

            // public method for encoding
            encode: function (input) {
                var output = "";
                var chr1, chr2, chr3, enc1, enc2, enc3, enc4;
                var i = 0;

                input = Base64._utf8_encode(input);

                while (i < input.length) {

                    chr1 = input.charCodeAt(i++);
                    chr2 = input.charCodeAt(i++);
                    chr3 = input.charCodeAt(i++);

                    enc1 = chr1 >> 2;
                    enc2 = ((chr1 & 3) << 4) | (chr2 >> 4);
                    enc3 = ((chr2 & 15) << 2) | (chr3 >> 6);
                    enc4 = chr3 & 63;

                    if (isNaN(chr2)) {
                        enc3 = enc4 = 64;
                    } else if (isNaN(chr3)) {
                        enc4 = 64;
                    }

                    output = output +
        this._keyStr.charAt(enc1) + this._keyStr.charAt(enc2) +
        this._keyStr.charAt(enc3) + this._keyStr.charAt(enc4);

                }

                return output;
            },

            // public method for decoding
            decode: function (input) {
                var output = "";
                var chr1, chr2, chr3;
                var enc1, enc2, enc3, enc4;
                var i = 0;

                input = input.replace(/[^A-Za-z0-9\+\/\=]/g, "");

                while (i < input.length) {

                    enc1 = this._keyStr.indexOf(input.charAt(i++));
                    enc2 = this._keyStr.indexOf(input.charAt(i++));
                    enc3 = this._keyStr.indexOf(input.charAt(i++));
                    enc4 = this._keyStr.indexOf(input.charAt(i++));

                    chr1 = (enc1 << 2) | (enc2 >> 4);
                    chr2 = ((enc2 & 15) << 4) | (enc3 >> 2);
                    chr3 = ((enc3 & 3) << 6) | enc4;

                    output = output + String.fromCharCode(chr1);

                    if (enc3 != 64) {
                        output = output + String.fromCharCode(chr2);
                    }
                    if (enc4 != 64) {
                        output = output + String.fromCharCode(chr3);
                    }

                }

                output = Base64._utf8_decode(output);

                return output;

            },

            // private method for UTF-8 encoding
            _utf8_encode: function (string) {
                string = string.replace(/\r\n/g, "\n");
                var utftext = "";

                for (var n = 0; n < string.length; n++) {

                    var c = string.charCodeAt(n);

                    if (c < 128) {
                        utftext += String.fromCharCode(c);
                    }
                    else if ((c > 127) && (c < 2048)) {
                        utftext += String.fromCharCode((c >> 6) | 192);
                        utftext += String.fromCharCode((c & 63) | 128);
                    }
                    else {
                        utftext += String.fromCharCode((c >> 12) | 224);
                        utftext += String.fromCharCode(((c >> 6) & 63) | 128);
                        utftext += String.fromCharCode((c & 63) | 128);
                    }

                }

                return utftext;
            },

            // private method for UTF-8 decoding
            _utf8_decode: function (utftext) {
                var string = "";
                var i = 0;
                var c = c1 = c2 = 0;

                while (i < utftext.length) {

                    c = utftext.charCodeAt(i);

                    if (c < 128) {
                        string += String.fromCharCode(c);
                        i++;
                    }
                    else if ((c > 191) && (c < 224)) {
                        c2 = utftext.charCodeAt(i + 1);
                        string += String.fromCharCode(((c & 31) << 6) | (c2 & 63));
                        i += 2;
                    }
                    else {
                        c2 = utftext.charCodeAt(i + 1);
                        c3 = utftext.charCodeAt(i + 2);
                        string += String.fromCharCode(((c & 15) << 12) | ((c2 & 63) << 6) | (c3 & 63));
                        i += 3;
                    }

                }

                return string;
            }

        }

        if (typeof String.prototype.trim !== 'function') {
            String.prototype.trim = function () {
                return this.replace(/^\s+|\s+$/g, '');
            }
        }

        function BeforeSubmit() {
            var e = document.getElementById("MainContent_Password");
            if (e.value.indexOf("!0!0!") == -1) {
                e.value = "!0!0!" + Base64.encode(e.value.trim());
            }
            Wait('One minute...');
        }     
    </script>
    <style type="text/css">
        .loginbox
        {
            border-radius: 6px 6px 6px 6px;
            border: 1px solid #c0c0c0;
            padding: 8px;
            -moz-box-shadow: 0 0 8px #909090;
            -webkit-box-shadow: 0 0 8px #909090;
            box-shadow: 0 0 8px #909090;
            background-color: white;
        }
        .loginimage
        {
            border-radius: 2px 2px 2px 2px;
            border: 0px solid #F0F0F0;
            padding: 2px;
            background-color: white;
        }
        .textbox
        {
            border: 1px solid #D0D0D0;
            padding: 8px;
            padding-top: 0px;
            padding-bottom: 0px;
            -moz-box-shadow: 0 0 5px #ccc;
            -webkit-box-shadow: 0 0 5px#ccc;
            box-shadow: 0 0 5px #ccc;
            background-color: white;
        }
        
        .loginbtnbox
        {
            border-radius: 3px 3px 3px 3px;
            border: 1px solid #c0c0c0;
            padding: 2px;
            color: white;
            font-weight: 700;
        }
        
        td.x-panel-header-light
        {
            background-image: url('<%=bgImage%>');
            -webkit-background-size: cover;
            -moz-background-size: cover;
            -o-background-size: cover;
            background-size: cover;
        }
        input[type='submit']
        {
            -webkit-appearance: none;
            -moz-appearance: none;
            appearance: none;
        }
    </style>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
<asp:Localize runat="server" ID="LocUsr" meta:resourcekey="str_usr" Visible="false">User</asp:Localize>
<asp:Localize runat="server" ID="LocAutCodHasBeeSenToYouBacEma" meta:resourcekey="str_autCodHasBeeSenToYouBacEma" Visible="false">Auth code has been sent to your backup email</asp:Localize>
<asp:Localize runat="server" ID="LocInvCapTex" meta:resourcekey="str_invCapTex" Visible="false">invalid CAPTCHA text</asp:Localize>
<asp:Localize runat="server" ID="LocSysIntErrDecFai" meta:resourcekey="str_sysIntErrDecFai" Visible="false">system internal error: decode failed.</asp:Localize>
<asp:Localize runat="server" ID="LocInvAutCod" meta:resourcekey="str_invAutCod" Visible="false">Invalid Auth Code</asp:Localize>
<asp:Localize runat="server" ID="LocAutCodIsMis" meta:resourcekey="str_autCodIsMis" Visible="false">Auth code is missing</asp:Localize>
    <table class="x-panel-header-light" style="width: 100%; height: 100%; margin: 0; padding: 0; border: 0px; vertical-align: top;">
        <tr>
            <td class="x-panel-header-light" valign="top">
                <asp:Panel ID="Panel1" runat="server" DefaultButton="Button1">
                <table width="100%">
                    <asp:Panel ID="PhonePanel" runat="server" Visible="False">
                    
                                    <tr>
                                        <td class='idea_flex'>
                                            <table width="100%">
                                            <asp:Panel ID="IOSPanel" runat="server" meta:resourcekey="IOSPanelResource1" Visible="False">                    
                                            <tr>
                                                <td>
                                                        <table width="100%">
                                                            <tr>
                                                                <td  style="text-align: right;">
                                                                    <img src="images/ios_appstore_48x48.png" />
                                                                </td>
                                                                <td style="text-align: left; padding-left:8px;">
                                                                    <a target="_blank" href="<%=m_IOSLink%>" style="text-align: left;font-size:46px;">
                                                                        <asp:Localize ID="Localize5" meta:resourcekey="string18" runat="server" 
                                                                        Text="View in Apple App Store"></asp:Localize>
                                                                    </a>
                                                                </td>
                                                            </tr>
                                                        </table>
                                                </td>
                                            </tr>
                                            </asp:Panel>
                                            <asp:Panel ID="AndroidPanel" runat="server"  Visible="False"
                                                meta:resourcekey="AndroidPanelResource1">                    
                                            <tr>
                                                <td align="center">
                                                        <table width="100%">
                                                            <tr>
                                                                <td  style="text-align: right;">
                                                                    <img src="images/android_appstore_96x96.png" />
                                                                </td>
                                                                <td style="text-align: left; padding-left:8px;">
                                                                    <a target="_blank" href="<%=m_AndroidLink%>" style="text-align: left;font-size:38px;">
                                                                        <asp:Localize ID="Localize6" meta:resourcekey="string19" runat="server" 
                                                                        Text="Available in &quot;Google Play&quot; Market Store."></asp:Localize>
                                                                    </a>
                                                                </td>
                                                            </tr>
                                                        </table>
                                                </td>
                                            </tr>
                                            </asp:Panel>
                                            <asp:Panel ID="WindowsPhome" runat="server" Visible="False"
                                                meta:resourcekey="WindowsPhomeResource1">                    
                                            <tr>
                                                <td align="center">
                                                        <table width="100%">
                                                            <tr>
                                                                <td  style="text-align: right;">
                                                                    <img src="images/wphone_appstore.png" />
                                                                </td>
                                                                <td style="text-align: left">
                                                                    <a target="_blank" href="<%=m_WindowsPhoneLink%>" style="text-align: left;font-size:32px;">
                                                                        <asp:Localize ID="Localize7" meta:resourcekey="string20" runat="server" 
                                                                        Text="Available in &quot;Windows Phone&quot; Store. Windows Phone 8+"></asp:Localize>
                                                                    </a>
                                                                </td>
                                                            </tr>
                                                        </table>
                                                </td>
                                            </tr>
                                            
                                            </asp:Panel>
                                        </table>
                                        </td>
                                    </tr>
                    </asp:Panel>
                </table>
                    <div id="TopPadding">
                        &nbsp;</div>
                    <table width="100%" id="LoginTabelParent">
                        <tr>
                            <td style="padding-left: 20px; padding-right: 20px; padding-top: 20px;" valign="top">
                                <table width="100%" align="center" style="padding: 10px;">
                                    <tr>
                                        <td class="textbox" style="padding-top: 45px;">
                                            <asp:Panel ID="UserPwdPanel" runat="server" Visible="True">
                                                <table width="100%">
                                                    <tr>
                                                        <td align="center" style="vertical-align: top; padding: 4px; padding-bottom: 42px; padding-top: 8px;">
                                                            <asp:Image ID="LogoImage" runat="server" Width="100%" AlternateText="Logo" />
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td height="60px" style="border-bottom: 1px solid #ddd;">
                                                            <table width="100%">
                                                                <tr>
                                                                    <td width="128px" style="vertical-align: middle;">
                                                                        <img width="128px" src="images/usergray128.png" title="Normally UserName is your email address. It could also be your Active Directory user name or login name when configured with Active Directory integration." />
                                                                        <asp:Localize Visible="false" ID="Localize1" meta:resourcekey="asp_string1" runat="server" Text="User Name"></asp:Localize>
                                                                    </td>
                                                                    <td align="left" style="vertical-align: middle;">
                                                                        <asp:TextBox ID="UserName" runat="server" Width="88%" Height="86px" BackColor="Transparent" Style="border: 1px solid #d8d8d8;
                                                                            font-size: 64px;"></asp:TextBox>
                                                                        <div style="color: #D00000">
                                                                            <asp:RequiredFieldValidator runat="server" ID="reqName" ControlToValidate="UserName" ValidationGroup="UserInfoG" ErrorMessage="User name is required!"
                                                                                Display="Dynamic" meta:resourcekey="reqNameResource1" />
                                                                        </div>
                                                                        <div style="padding-top: 15px;">
                                                                            <asp:Label ID="Already_login_in" runat="server" Style="color: #808080; font-size: 18px;" meta:resourcekey="Already_login_in"
                                                                                Visible="False">currently logged in from the same browser</asp:Label></div>
                                                                        <div style="padding-top: 5px;">
                                                                            <asp:LinkButton ID="SigninAsNew" runat="server" ForeColor="Green" CausesValidation="False" Style="font-size: 32px;" Visible="False"
                                                                                OnClick="SigninAsNew_Click" meta:resourcekey="SigninAsNewResource1">Sign in as a different user</asp:LinkButton>
                                                                        </div>
                                                                    </td>
                                                                </tr>
                                                            </table>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td height="60px">
                                                            <table width="100%">
                                                                <tr>
                                                                    <td width="128px" style="vertical-align: middle;">
                                                                        <img width="128px" src="images/lockgray128.png" title="<%:Localize3.Text%>" /><asp:Localize Visible="false" ID="Localize3"
                                                                            meta:resourcekey="asp_string2" runat="server" Text="Password"></asp:Localize>
                                                                    </td>
                                                                    <td align="left" style="vertical-align: middle;">
                                                                        <asp:TextBox ID="Password" runat="server" Width="88%" TextMode="Password" BackColor="Transparent" Style="border: 1px solid #d8d8d8;
                                                                            font-size: 64px;" Height="86px" meta:resourcekey="asp_string2"></asp:TextBox>
                                                                        <div style="color: #D00000">
                                                                            <asp:RequiredFieldValidator runat="server" ID="RequiredFieldValidator2" ControlToValidate="Password" ValidationGroup="UserInfoG"
                                                                                ErrorMessage="Password is required!" Display="Dynamic" meta:resourcekey="RequiredFieldValidator2Resource1" />
                                                                        </div>
                                                                    </td>
                                                                </tr>
                                                            </table>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            &nbsp;<br />
                                                            &nbsp;
                                                        </td>
                                                    </tr>
                                                </table>
                                            </asp:Panel>
                                            <asp:Panel ID="TwoFactorPanel" runat="server" Visible="False">
                                                <table width="100%" style="padding: 6px;">
                                                    <tr>
                                                        <td style="padding-top: 10px; font-size: 32px; font-weight: 900">
                                                            <asp:Localize meta:resourcekey="str_twoentercode2" runat="server">Enter Authenticator Code </asp:Localize>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            &nbsp;
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td style="padding-top: 5px;">
                                                            <asp:TextBox ID="AuthCode" runat="server" CssClass="x-form-field x-form-text" Height="88px" Style="font-size: 48px;" Width="98%"
                                                                Text="6-digit code" ForeColor="#999999"></asp:TextBox>
                                                            <script type="text/javascript">
                                                                var txtsearch = document.getElementById("MainContent_AuthCode");
                                                                var oldTextValue = "";
                                                                if (oldTextValue.length == 0) {
                                                                    oldTextValue = txtsearch.value;
                                                                }
                                                                txtsearch.onfocus = function () {
                                                                    if (this.value == oldTextValue) {
                                                                        this.value = "";
                                                                    }
                                                                };

                                                                txtsearch.onblur = function () {
                                                                    if (this.value.length == 0) {
                                                                        this.value = oldTextValue;
                                                                    }
                                                                }
                                                            </script>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            &nbsp;
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td style="padding-top: 10px; font-size: 32px;">
                                                            <asp:Localize meta:resourcekey="str_donthave" runat="server">I don't have my phone with me, please</asp:Localize>
                                                            <asp:LinkButton ID="SendEmailCode" ForeColor="#008000" runat="server" Style="font-size: 48px;" OnClick="SendEmailCode_Click"><b><asp:Localize meta:resourcekey="str_send" runat="server">send</asp:Localize></b></asp:LinkButton>
                                                            <asp:Localize meta:resourcekey="str_backupemail" runat="server">code to my backup email.</asp:Localize>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td align="right" style="padding-top: 20px;">
                                                            <a href="/Portal/mloginpage.aspx" style="font-size: 48px; color: #008000">
                                                                <asp:Localize meta:resourcekey="str_cancel" runat="server">Cancel</asp:Localize></a>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </asp:Panel>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="height: 3px;">
                                            <asp:Panel ID="CaptPanel" Visible="false" runat="server">
                                                <div class="textbox">
                                                    <table width="100%">
                                                        <tr>
                                                            <td style="font-size: 32px;">
                                                                <asp:Localize ID="Localize4" meta:resourcekey="enter_capt" runat="server">Please enter the string displayed in the box below:</asp:Localize>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td>
                                                                <asp:TextBox ID="capt" runat="server" Width="88%" CssClass="x-form-field x-form-text" Style="font-size: 48px;" Height="58px"></asp:TextBox>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td>
                                                                <table width="100%">
                                                                    <tr>
                                                                        <td>
                                                                            <img width="100%" src="/storage/captcha.dn?f=<%=FSessionId.Value %>" />
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td style="font-size: 32px;">
                                                                            Not Clear?
                                                                            <asp:LinkButton ID="LinkButton1" runat="server" OnClick="LinkButton1_Click" Style="font-size: 32px; color: #008000">Refresh</asp:LinkButton>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </td>
                                                        </tr>
                                                    </table>
                                                </div>
                                            </asp:Panel>
                                        </td>
                                    </tr>
                                    
                                    <tr>
                                        <td style="padding-top: 32px;">
                                            <asp:Button ID="Button1" runat="server" Text="Sign In" Font-Size="64px" OnClick="Button1_Click" OnClientClick="BeforeSubmit();"
                                                CausesValidation="false" Width="100%" Height="90px" CssClass="x-tab-bar-default loginbtnbox" meta:resourcekey="Button1Resource1" />
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="padding-top: 10px;">
                                            <table width="100%" style="font-size: 28px">
                                                <tr>
                                                    <td>
                                                        <%if (m_ShowFogetPwd)
                                                          { %>
                                                        <a href="<%=ForgetPwd.Value%>" target="_blank"><span style="font-size: 28px">
                                                            <asp:Localize ID="Localize2" meta:resourcekey="asp_string3" runat="server" Text="Forgot your password?"></asp:Localize></a></span>
                                                        <%} %>
                                                    </td>
                                                    <td>
                                                        <asp:HyperLink ID="SignupLink" runat="server" Font-Size="28px">Sign up for a free trial.</asp:HyperLink>
                                                    </td>
                                                </tr>
                                            </table>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <% if (!TwoFactorPanel.Visible)
                                               { %>
                                            <asp:Label ID="LoginPageNote" runat="server" Text="" Style="font-size: 32px;"></asp:Label>
                                            <% } %>
                                        </td>
                                    </tr>
                                    <tr style="display: none;">
                                        <td height="25px">
                                            &nbsp;
                                            <div id="errmsgdiv">
                                                <asp:Label ID="ErrorMsg" runat="server" Style="color: Red;" meta:resourcekey="ErrorMsgResource1"></asp:Label>
                                            </div>
                                        </td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                    </table>
                </asp:Panel>
                <table width="100%">
                    <tr>
                        <td height="38" align="center" style="padding-top: 20px; font-size: 28px;">
                            &copy;<%:this.copyright%>
                            (Build
                            <%:this.version %>)
                        </td>
                    </tr>
                </table>
                
            </td>
        </tr>
    </table>
    <asp:HiddenField ID="ForgetPwd" runat="server" />
    <asp:Label Visible="false" ID="ProductLable" runat="server" Font-Size="16px" ForeColor="Black" meta:resourcekey="ProductLableResource1"></asp:Label>
    <script type="text/javascript">
        if (top != self) top.location.replace(location);
        function DisplayError() {

            var d = document.getElementById("MainContent_ErrorMsg");
            if (d) {
                if (d.innerHTML != "") {
                    alert(d.innerHTML);
                }
            }
        }
        DisplayError();
        try {
            var d = document.getElementById("LoginTabelParent");
            var tdd = document.getElementById("TopPadding");

            if ((document.documentElement.clientHeight - 10) > d.offsetHeight) {
                tdd.style.height = ((document.documentElement.clientHeight - 80) - d.offsetHeight) / 2 + "px";
            } else {
                tdd.style.height = "0px";
            }
        } catch (e) {
        }
        //document.body.style = "background-color:#9bdff0;";
    </script>
    <script type="text/javascript">

        function adjustLogin() {
        }

        Ext.onReady(function () {

            Ext.QuickTips.init();

            adjustLogin();


            Ext.EventManager.onWindowResize(function () {
                adjustLogin();
            });
        });
    </script>
    <asp:HiddenField ID="FSessionId" runat="server" />
    <asp:HiddenField ID="OpenShare" runat="server" />
</asp:Content>
