﻿<%@ Page Title="Gladinet Cloud - User Manager" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="LDAPSelectUser.aspx.cs" Inherits="GladinetPayFlow.LDAPSelectUser" culture="auto" meta:resourcekey="PageResource1" uiculture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">

    <style type="text/css">
         td
        {
            font-size: 14px;
            font-family: Verdana,sans-serif;
            font-weight: 100;
        }
        
        b
        {
            font-weight: 500;
        }
        
        label
        {
            font-weight: 500;
        }
         .titlecol
         {
             background-color: #f0f0f0;
             font-size: 14px;
         }
        

        
        .style1
        {
            height: 25px;
        }
        *
        {
            margin: 0;
        }
        
        .wrapper
        {
            
            padding: 0px;
            background-color: white;
            margin: 0 auto -69px; /* the bottom margin is the negative value of the footer's height */
        }
        .footer, .push
        {
            height: 68px; /* .push must be the same height as .footer */
        }
    </style>
    <script type="text/javascript">
        function getScrollXY() {
            var scrOfX = 0, scrOfY = 0;
            if (typeof (window.pageYOffset) == 'number') {
                //Netscape compliant
                scrOfY = window.pageYOffset;
                scrOfX = window.pageXOffset;
            } else if (document.body && (document.body.scrollLeft || document.body.scrollTop)) {
                //DOM compliant
                scrOfY = document.body.scrollTop;
                scrOfX = document.body.scrollLeft;
            } else if (document.documentElement && (document.documentElement.scrollLeft || document.documentElement.scrollTop)) {
                //IE6 standards compliant mode
                scrOfY = document.documentElement.scrollTop;
                scrOfX = document.documentElement.scrollLeft;
            }
            //return [scrOfX, scrOfY];
            return scrOfY;
        }



        var activewin;
        function ClearErrorMsg() {

            var d = document.getElementById("errmsgdiv");
            if (d) {
                d.style.display = 'none';
            }
        }
        setTimeout("ClearErrorMsg()", 30000);
        //parent.setActivePanel("UserMgr");

        function onDelUser(id, name) {
            var h = "UserMgrPage.aspx?op=delete&id=" + id;

            if (confirm("<asp:Localize meta:resourcekey="js_string6" runat="server">Confirm you want to delete (</asp:Localize>" + name + ")?"))
                window.location = h;

        }

    
        function closeCancelActiveWin()
        {
            activewin.close();
        }

        function closeActiveWin() {
            window.location =  window.location;
        }

        function OnAddUser() {

            activewin = new Ext.Window({
                id: 'On_Add_User',
                title: "<asp:Localize meta:resourcekey="js_string3" runat="server">Create New User</asp:Localize>",
                width: 480,
                height: 450,
                plain: true,
                modal: true,
                maximizable: true,
                resizable: false,
                maximized: false,
                shadow: 'drop',
                shadowOffset: 20,
                layout: 'fit',
                bodyPadding: 3,
                html: "<iframe id='openwin' src='AddUserPage.aspx' scrolling='auto' style='width:100%;height:100%;margin:0;padding:0'></iframe>",
                defaults: {
                    border: false
                }
            });
            activewin.show();



        }

        

        function SetLocation(loc) {
            var e = document.getElementById("MainContent_OU");            
            e.value = loc;
            activewin.close();
        }
        function SelectAll() {
            var Users = document.getElementsByTagName("input");

            for (var i = 0; i < Users.length; ++i) {
                if (Users[i].type == "checkbox") {
                    Users[i].checked = true;
                }
            }
        }

        function DeSelectAll() {
            var Users = document.getElementsByTagName("input");

            for (var i = 0; i < Users.length; ++i) {
                if (Users[i].type == "checkbox") {
                    Users[i].checked = false;
                }
            }
        }

        function ReSelectAll() {
            var Users = document.getElementsByTagName("input");

            for (var i = 0; i < Users.length; ++i) {
                if (Users[i].type == "checkbox") {
                    Users[i].checked = !Users[i].checked;
                }
            }
        }

        function OnUserSelected() {
            var Users = document.getElementsByTagName("input");
            var UserList = "";
            
            for (var i = 0; i < Users.length; ++i) {
                if (Users[i].type == "checkbox" && Users[i].checked) {
                    if (-1 == Users[i].name.indexOf(','))
                        continue;
                    if (UserList != "")
                        UserList += "\n";
                    UserList += unescape( Users[i].name);
                    
                }
            }

            
            if( parent.SetSelectedUser )
                parent.SetSelectedUser(UserList);
            else
                parent.parent.SetSelectedUser(UserList);


        }

        function SetSearchLocation() {
            activewin = new Ext.Window({
                id: 'On_Set_Location',
                title: "<asp:Localize meta:resourcekey="js_string1" runat="server">Select Search Location</asp:Localize>",
                width: 480,
                height: 450,
                plain: true,
                modal: true,
                maximizable: true,
                resizable: false,
                maximized: false,
                shadow: 'drop',
                shadowOffset: 20,
                layout: 'fit',
                bodyPadding: 3,
                html: "<iframe id='openwin' src='LDAPLocation.aspx' scrolling='auto' style='width:100%;height:100%;margin:0;padding:0'></iframe>",
                defaults: {
                    border: false
                }
            });
            activewin.show();

        }

        function DrillDownConatiner(ou) {
            var e = document.getElementById("MainContent_SelectedOU");
            var b = document.getElementById("MainContent_BrowseContainer");

            e.value = ou;
            b.click();
            
        }

        function DrillDownOU(ou) {

            var e = document.getElementById("MainContent_SelectedOU");
            var b = document.getElementById("MainContent_BrowseOU");
            
            e.value = ou;
            b.click();

        }

        function OnSearch() {
            var e = document.getElementById("MainContent_Button1");
            e.click();
        }

        function OnBrowse() {
            var e = document.getElementById("MainContent_Button2");
            e.click();
        }

    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
<asp:Localize ID="LocBroGro" meta:resourcekey="str_broGro" runat="server" Visible="False">Browse Groups</asp:Localize>
<asp:Localize runat="server" ID="LocMisSeaTex" meta:resourcekey="str_misSeaTex" Visible="false">Missing search text</asp:Localize>
<asp:Localize runat="server" ID="LocNotFndInOU" meta:resourcekey="str_notFndInOU" Visible="false">No matches were found in organizational unit</asp:Localize>
<asp:Localize runat="server" ID="LocNotFnd" meta:resourcekey="str_notFnd" Visible="false">No matches were found.</asp:Localize>


<nav class="navbar navbar-default" role="navigation">
      <div class="container-fluid">
         <% if (LocationPanel.Visible)
            { %>
          <div class=" navbar-left"  style="vertical-align: middle; padding-top: 0px;" >
              <asp:LinkButton ID="LinkButton2" OnClick="BrowseOUUP_Click" ToolTip="Up one level"
                                                        runat="server" meta:resourcekey="LinkButton2Resource1">
                   <i class="gladinet-icons md-24 md-dark hand center " style="display: inline-block; margin-top:-15px;font-size: 32px; "  >&#xA6;</i>
              </asp:LinkButton>
          </div>
          <% } %>
          <%if(!DomainList.Visible) { %>
          <p class="navbar-text" style="font-size: 18px; color:#565656">
              <%=DomainList.SelectedValue %>
        </p>
          <% } %>
          <asp:Panel ID="EmptyPanel" runat="server" Visible="False" meta:resourcekey="EmptyPanelResource1">
                                        <div class='navbar-text'  style="color: red;margin-bottom:15px;">
                                            <asp:Localize ID="Localize6" meta:resourcekey="asp_string4" runat="server" Text="Not Found" Visible="false"></asp:Localize>

                                            <asp:Literal ID="ltlEmptyMsg" runat="server" />

                                        </div>
                                    </asp:Panel>
          
          <p class="navbar-text">
              <div id="errmsgdiv">
                                        <b>
                                            <asp:Label ID="ErrorMsg" runat="server" Style="color: Red;" meta:resourcekey="ErrorMsgResource1"></asp:Label></b>
                                    </div>
          </p>
          
          <div class=" navbar-right"  >
              <table>
                  <tr>
                      <td style="padding-right: 20px; padding-left: 5px; font-size: 14px; display: none;">
                                                            <asp:CheckBox ID="Users" runat="server" Text="Users" Checked="True" meta:resourcekey="UsersResource1" />
                                                            <asp:CheckBox ID="Groups" runat="server" Text="Groups" Checked="True" meta:resourcekey="GroupsResource1" />
                                                        </td>
                                                        <td style="display: none; padding-right: 20px; font-size: 14px; padding: 2px;" align="left">
                                                            <span style="font-size: 16px; vertical-align: middle">
                                                                <asp:Localize ID="Localize4" meta:resourcekey="asp_string1" runat="server" Text="Location(/ou/...):"></asp:Localize></span>
                                                            <asp:TextBox ID="OU" runat="server" meta:resourcekey="OUResource1" CssClass="x-form-field x-form-text"></asp:TextBox><asp:LinkButton
                                                                ID="LinkButton1" runat="server" Font-Size="12pt" ForeColor="#009000" OnClientClick="SetSearchLocation();return false"
                                                                Font-Underline="True" meta:resourcekey="LinkButton1Resource1"><asp:Localize ID="Localize5" meta:resourcekey="asp_string2" runat="server">Browse</asp:Localize></asp:LinkButton>
                                                        </td>
                                                        <td style=" font-size: 14px; padding: 2px;padding-right: 20px;" align="left">
                                                            <span style="font-size: 14px; vertical-align: top；">
                                                                <asp:DropDownList ID="DomainList" runat="server"  CssClass="browser-default custom-select secsubbordercolor">
                                                                </asp:DropDownList>
                                                            </span>
                                                            </td>
                      <td style="padding-right: 5px;">
              
                                                                <button class="btn btn-default nbtn" data-toggle="modal" data-target="#SearchModel"  onclick="return false;">
                                                                    <i class="gladinet-icons md-24 md-dark hand center toolbtn" style="display: inline-block; margin-top: 0px;font-size: 18px; "  title="<%=Button1.Text %>">&#xA7;</i>
                                                                            </button>

                          
                      </td >
                      <td style="padding-right: 5px;">
              <a href="#" onclick="OnBrowse();return false;">
                                                                <button class="btn btn-default nbtn" onclick="OnBrowse();return false;">
                                                            <span class="fa fa-book md-dark sectextcolor" aria-hidden="true" style="font-size: 18px;  cursor: pointer" title="<%=Button2.Text %>">
                                                                            </span>
                                                                            </button>
                                                                            </a>
                          
                      </td>
                  </tr>
              </table>
          </div>
      </div>
      </nav>
    <div id="SearchModel" class="modal fade" role="dialog">
                              <div class="modal-dialog">

                                  <!-- Modal content-->
                                  <div class="modal-content">
                                      <div class="modal-header">
                                          <button type="button" class="close" data-dismiss="modal">&times;</button>

                                      </div>

                                      <div class="modal-body">
                                          <table width="100%">
                                              <tr>
                                                  <td style="padding-top: 20px;">
                                                      <span style="font-size: 14px; vertical-align: top">
                                                          <asp:DropDownList ID="SearchType" runat="server" CssClass="browser-default custom-select secsubbordercolor">
                                                          </asp:DropDownList>
                                                      </span>
                                                  </td>

                                              </tr>
                                              <tr>
                                                  <td style="padding-top:10px;">
                                                      <asp:TextBox ID="Contains" runat="server" meta:resourcekey="ContainsResource1" 
                                                          CssClass="form-control"></asp:TextBox>
                                                  </td>
                                              </tr>
                                          </table>
                                      </div>
                                      <div class="modal-footer">
                                          <button type="button" class="btn btn-primary gladbtn" data-dismiss="modal" onclick="OnSearch();return false;"><%=Button1.Text %></button>
                                          <button type="button" class="btn btn-default" data-dismiss="modal"><asp:Localize meta:resourcekey="str_cls" runat="server">Close</asp:Localize></button>
                                      </div>
                                  </div>
                          </div>
          </div>
    <div  style="height:452px; background-color: white; margin-top: -18px;">
      
                        <table width="100%" align="center">
                            <tr>
                                <td class="style1">
                                    
                                    
                                   
                                        <div id="grid-example">
                                        </div>
                                        <asp:Panel ID="ResultPanel" runat="server" meta:resourcekey="ResultPanelResource1">
                                    </asp:Panel>
                                    
                                </td>
                            </tr>
                        </table>
                    
    </div>

    <div class="footer x-panel-header-light" style="border-left: 0; border-right: 0;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     border-bottom: 0; vertical-align: middle;">
        <table width="100%" style="height: 64px; text-align: right; padding-right: 64px;"
            align="right">
            <tr>
                <td align="right">
                    <table width="100%">
                        <tr>
                            <td>
                                
                                        <table  style="background: transparent; display: none;">
                                                       <asp:Panel ID="LocationPanel" runat="server" meta:resourcekey="LocationPanelResource1">
          </asp:Panel>

                                            <tr>
                                                <td width="18px">
                                                    
                                                </td>
                                                <td>
                                                    <b><asp:Localize meta:resourcekey="str_curLoc" runat="server">Current Location:</asp:Localize></b>
                                                    <asp:Label ID="CurrentOu" runat="server" Text="/" meta:resourcekey="CurrentOuResource1"></asp:Label>
                                                </td>
                                            </tr>
                                        </table>
                                    
                            </td>
                        <td>
                            <table>
                                    <tr>
                                        <td>
                                            <a href="#" onclick="SelectAll();return false;" style="padding-left: 10px; padding-right: 10px;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       color: #008000">
                                                <asp:Localize ID="Localize1" meta:resourcekey="asp_string5" runat="server" Text="Select All"></asp:Localize></a>
                                        </td>
                                        <td>
                                            <a href="#" onclick="DeSelectAll();return false;" style="padding-right: 10px; color: #008000">
                                                <asp:Localize ID="Localize2" meta:resourcekey="asp_string6" runat="server" Text="Deselect All"></asp:Localize></a>
                                        </td>
                                        <td>
                                            <a href="#" onclick="ReSelectAll();return false;" style="padding-right: 10px; color: #008000">
                                                <asp:Localize ID="Localize3" meta:resourcekey="asp_string7" runat="server" Text="Undo Selection"></asp:Localize></a>
                                        </td>
                                    </tr>
                                </table>
                        </td>
                            <td width="160px">
                                <asp:Button ID="Button4" OnClick="FileterUsers_Click" OnClientClick="OnUserSelected();return false;" CssClass="btn btn-primary gladbtn"
                                    runat="server" Text="Apply" Width="128px" meta:resourcekey="Button3Resource1" />
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>
    </div>
    
    <div style="display: none;">
                        <asp:Label ID="UserCount" runat="server" Text="0 User" Visible="False" meta:resourcekey="UserCountResource1"></asp:Label>
                        <asp:Button ID="Button2" OnClick="Browse_Click" runat="server" OnClientClick="Wait('Searching...');"
                                                                Text="Browse User" Width="108px" Height="32px" meta:resourcekey="Button2Resource1" />
                        <asp:Button ID="Button1" OnClick="FileterUsers_Click" runat="server" OnClientClick="Wait('Searching...');" 
                                                                Text="Search" Width="68px" Height="32px" meta:resourcekey="Button1Resource2" />
                        <asp:HiddenField ID="SelectedOU" runat="server" />
                        <br />
                        <asp:Button ID="BrowseOU" runat="server" Text="Button" OnClick="BrowseOU_Click" meta:resourcekey="BrowseOUResource1" />
        <asp:Button ID="BrowseContainer" runat="server" Text="Button" OnClick="BrowseContaineriner_Click" meta:resourcekey="BrowseOUResource1" />
                    </div>
    <script type="text/javascript">
  var myData = [
 <asp:Repeater ID="UsersRepeater" runat="server" >
        <ItemTemplate>
        <%#(Container.ItemIndex == 0)? "": "," %>    ['<%#(((RepeaterItem)Container).ItemIndex+1) %>','<%#DataBinder.Eval(Container.DataItem, "FirstName").ToString().Replace("'","%27")%>&nbsp;<%#DataBinder.Eval(Container.DataItem, "LastName").ToString().Replace("'","%27")%>', '<%#DataBinder.Eval(Container.DataItem,"Email").ToString().Replace("'","%27") %>','<%#DataBinder.Eval(Container.DataItem, "UserGuid")%>,<%#DataBinder.Eval(Container.DataItem,"Email").ToString().Replace("'","%27") %>,<%#DataBinder.Eval(Container.DataItem, "FirstName").ToString().Replace("'","%27")%> <%#DataBinder.Eval(Container.DataItem, "LastName").ToString().Replace("'","%27")%>']
        
        </ItemTemplate>
    </asp:Repeater>      
    ];
    </script>
  <script type="text/javascript">

      Ext.require([
          'Ext.grid.*',
          'Ext.data.*',
          'Ext.util.*',
          'Ext.state.*'
      ]);
      Ext.onReady(function () {        
          
          document.forms[0].onkeypress = function (e) {
              if (e.which == 13) {
                  var txt = document.getElementById("<%=Contains.ClientID%>");
                  var valid = false;
                  if(txt){
                      if(txt.value != ""){
                          valid = true;
                      }
                  }
                  if(valid){
                      OnSearch();
                  }else{
                      return false;
                  }
              }
          }

          Ext.QuickTips.init();

          var store = Ext.create('Ext.data.ArrayStore', {
              fields: [
                  { name: 'index' },
                  { name: 'fullname', sortType: 'asUCString' },
                  { name: 'email' },
                  { name: 'check' }
              ],
              data: myData,
              sortOnLoad: true,
              sorters: [{ direction: "ASC", property: "fullname"}]
          });

          try {

              var grid = Ext.create('Ext.grid.Panel', {
                  store: store,
                  stripeRows: true,
                  columnLines: false,
                  scroll: true,
                  layout: 'fit',
                  height: 460,
                  border: false,
                  
                  columns: [
                  {
                      text: '',
                      width: 50,
                      sortable: false,
                      dataIndex: 'index',
                      getClass: function (v, meta, rec) {
                          return 'x-col-hdide';
                      }
                  },
                   {
                         text: '',
                         width: 50,
                         sortable: false,
                         dataIndex: 'check',
                         renderer: function (value, metaData, record, rowIndex) {
                             var p = value.split(',');
                             return "<img style='border-radius: 50%;' src='/storage/avarta.dn?u="+p[0]+ "&w=32&h=32&d=<%=SessionDomainId%>'/>"  ;
                         }
                     },
                  {
                      text: "<asp:Localize meta:resourcekey="js_string4" runat="server">Full Name</asp:Localize>",
                      flex: 1,
                      sortable: true,
                      dataIndex: 'fullname',
                      renderer: function (value, metaData, record, rowIndex) {
                          return "<span style='font-weight:100; color:#565656;'>" + unescape(value) + "</span>";
                      }

                  },
                  {
                      text: "<asp:Localize meta:resourcekey="js_string5" runat="server">Email</asp:Localize>",
                      flex: 1,
                      sortable: true,
                      dataIndex: 'email',
                      renderer: function (value, metaData, record, rowIndex) {
                          return "<span style='font-weight:100; color:#565656;'>" + unescape(value) + "</span>";
                      }
                  },
            {
                text: '',
                width: 110,
                sortable: true,
                dataIndex: 'check',
                renderer: function (value, metaData, record, rowIndex) {
                    var d = record.data;
                    if (d.email == "Organizational-Unit") {

                        return "<a href='#' style='font-weight:100; color:#565656; font-size:16px;' onclick='DrillDownOU(\"" + d.fullname + "\");return false;'><asp:Localize meta:resourcekey="str_bwr" runat="server">Browse</asp:Localize></a>";
                    }
                    else if (d.email == "CONTAINER") {
                        return "<a href='#' style='font-weight:100; color:#565656; font-size:16px;' onclick='DrillDownConatiner(\"" + d.fullname + "\");return false;'><asp:Localize meta:resourcekey="str_bwr" runat="server">Browse</asp:Localize></a>";                        
                    }
                    return "<input type='checkbox' name='" + value + "' value='1' />";
                }
            }
        ],
                  renderTo: 'grid-example'
              });

              Ext.EventManager.onWindowResize(grid.doLayout, grid);

              var inp = document.getElementById("MainContent_Contains");
              inp.focus();
          } catch (e) {
          }
      });
  </script>

    
</asp:Content>
