﻿<%@ Page Language="C#" AutoEventWireup="true" MasterPageFile="~/WebAppPanel.master" UICulture="en" Culture="en-US"
    CodeBehind="Invoice.aspx.cs" Inherits="GladinetPayFlow.GladinetInvoice" %>

<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
<asp:Localize ID="LocFaiToChePro" meta:resourcekey="str_faiToChePro" runat="server" Visible="False">Failed to check profile</asp:Localize>
<asp:Localize runat="server" ID="LocFaiToLoaDasInf" meta:resourcekey="str_faiToLoaDasInf" Visible="false">Failed to load dashboard info.</asp:Localize>
    <asp:Label ID="ErrorMsg" runat="server" ForeColor="Red"></asp:Label>
    <br />
    <table width="704" align="center">
        <tr>
            <td>
                <h3><asp:Localize runat="server" meta:resourcekey="str_PayRep">Payment Report</asp:Localize></h3>
            </td>
        </tr>
        <tr>
            <td width="60%" style="vertical-align: top">
                Product & Service: Gladinet Cloud
                <br />
                Storage Plan :
                <%:this.m_StoragePlan %>
                <br />
                User Plan :
                <%:this.m_UserPlan %>
            </td>
            <td width="40%">
                Bill To :
                <br />
                <%:this.m_paypalUser.Firstname %>
                <%:this.m_paypalUser.Lastname %>
                <br />
                <%:this.m_paypalUser.Street %>
                <br />
                <%:this.m_paypalUser.State %>,
                <%:this.m_paypalUser.Zip %>
                <br />
                <%:this.m_paypalUser.Country %>
                <br />
                Email :
                <%:this.m_paypalUser.Email %>
            </td>
        </tr>
    </table>
    <table width="704" align="center">
        <tr>
            <td>
                <h4><asp:Localize runat="server" meta:resourcekey="str_PayHis">Payment History</asp:Localize></h4>
            </td>
        </tr>
        <tr>
            <td id="grid-example">
            </td>
        </tr>
    </table>
    <script type="text/javascript">
  var myData = [
 <asp:Repeater ID="PubsRepeater" runat="server" >
        <ItemTemplate>
       <%#(Container.ItemIndex == 0)? "": "," %>     
       ['<%#(((RepeaterItem)Container).ItemIndex+1) %>',
       '<%#DataBinder.Eval(Container.DataItem, "P_PNREF").ToString().Replace("'","%27")%>', 
       '<%#DataBinder.Eval(Container.DataItem,"P_TRASTIME") %>',
       '<%#DataBinder.Eval(Container.DataItem,"P_AMT") %>'
       ]
        
        </ItemTemplate>
    </asp:Repeater>      
    ];
    </script>
    <script type="text/javascript">

        Ext.require([
    'Ext.grid.*',
    'Ext.data.*',
    'Ext.util.*',
    'Ext.state.*'
]);
        Ext.onReady(function () {

            Ext.QuickTips.init();


            var store = Ext.create('Ext.data.ArrayStore', {
                fields: [
            { name: 'index' },
           { name: 'transid' },
           { name: 'datetime' },
           { name: 'amt' }
        ],
                data: myData
            });



            var grid = Ext.create('Ext.grid.Panel', {
                title: 'Payments',
                frame: false,
                border: 1,
                store: store,
                stripeRows: true,
                columnLines: true,
                height: 300,
                columns: [
            {
                text: '',
                width: 50,
                sortable: false,
                dataIndex: 'index',
                getClass: function (v, meta, rec) {
                    return 'x-col-hdide';
                }
            },
            {
                text: 'Transaction ID',
                flex: 1,
                sortable: true,
                dataIndex: 'transid',
                renderer: function (value, metaData, record, rowIndex) {
                    return "<b>" + unescape(value) + "</b>";
                }

            },
            {
                text: 'Date & Time',
                flex: 1,
                sortable: true,
                dataIndex: 'datetime',
                renderer: function (value, metaData, record, rowIndex) {
                    return "<b>" + unescape(value) + "</b>";
                }

            },
            {
                text: 'Amount',
                flex: 1,
                sortable: true,
                dataIndex: 'amt',
                renderer: function (value, metaData, record, rowIndex) {
                    return "<b>" + unescape(value) + "</b>";
                }

            }, {
                xtype: 'actioncolumn',
                width: 60,
                items:
                [

                    {
                        icon: 'images/printer.png',  // Use a URL in the icon config
                        tooltip: 'Invoice',
                        handler: function (grid, rowIndex, colIndex) {
                            var rec = grid.getStore().getAt(rowIndex);
                            var d = rec.data;

                            window.open("/portal/InvoicePage.aspx?t=" + d.transid, "_blank", "location=no,menubar=no,toolbar=no", true);

                        },
                        getClass: function (v, meta, rec) {


                        }

                    }
                 ]
            }
        ],
                renderTo: 'grid-example'
            });
            Ext.EventManager.onWindowResize(grid.doLayout, grid);

        });
    </script>
</asp:Content>
