﻿<%@ Page Title="Group Policy" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="GroupPolicyPage.aspx.cs" Inherits="GladinetPayFlow.GroupPolicyPage" culture="auto" meta:resourcekey="PageResource1" uiculture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <script type="text/javascript">


        Ext.onReady(function () {
            Ext.define('GroupAccordion', {
                extend: 'Ext.panel.Panel',
                alias: 'widget.policygroup',

                requires: [
                    'Ext.layout.container.Accordion',
                    'Ext.grid.*'
                ],
                xtype: 'layout-accordion',
                title: 'Group Policy',


                layout: 'accordion',
                renderTo: 'allgroup',

                height: 640,
                defaults: {
                    bodyPadding: 2
                },
                fbar: {
                    xtype:'panel',
                    contentEl: 'buttons'
                },

                initComponent: function () {
                    Ext.apply(this, {
                        items: [{
                                title: "<asp:Localize meta:resourcekey="string1" runat="server">Security</asp:Localize>",
                                contentEl: 'group1',
                                autoScroll: true
                            }, {
                                title: "<asp:Localize meta:resourcekey="string2" runat="server">Windows Client/Server Agent/Web Client Settings</asp:Localize>",
                                contentEl: 'group2',
                                autoScroll: true
                            }, {
                                title: "<asp:Localize meta:resourcekey="string3" runat="server">Retention Policy</asp:Localize>",
                                contentEl: 'group3',
                                autoScroll: true
                            }, {
                                title: "<asp:Localize meta:resourcekey="string4" runat="server">Team-User Home Directory Settings</asp:Localize>",
                                contentEl: 'group4',
                                autoScroll: true
                            }, {
                                title: "<asp:Localize meta:resourcekey="string5" runat="server">Password Policy for Non-AD User</asp:Localize>",
                                contentEl: 'group5',
                                autoScroll: true
                            }, {
                                title: "<asp:Localize meta:resourcekey="string6" runat="server">Access Policy</asp:Localize>",
                            contentEl: 'group6',
                            autoScroll: true
                        }]
                    });
                    this.callParent();
                }
            });

            var panel = Ext.create('widget.policygroup');

            Ext.EventManager.onWindowResize(function (w, h) {
                panel.doComponentLayout();
            });
        });
    </script>
    <style type="text/css">
        .titlecol
        {
            background-color: #f0f0f0;
            font-size: 14px;
        }
        .policygroup
        {
            -moz-border-radius: 5px 5px;
            -webkit-border-radius: 5px 5px;
            -o-border-radius: 5px 5px;
            -ms-border-radius: 5px 5px;
            -khtml-border-radius: 5px 5px;
            border-radius: 5px 5px;
            border: 1px solid #d0d0d0;
            padding-left: 2px;
            background-color: #f0f0f0;
            color: #008000;
            box-shadow: 0pt 0pt 4px 0pt rgb(136, 136, 136);
            padding-bottom: 5px;
        }
    </style>
    <script type="text/javascript">

        function ClearErrorMsg() {

            var d = document.getElementById("errmsgdiv");
            if (d) {
                d.style.display = 'none';
            }
        }
        setTimeout("ClearErrorMsg()", 8000);



        function closeCancelActiveWin() {
        }

        function closeActiveWin() {
            window.location = "AddUserPage.aspx";
        }

        function OnCancelApply() {
            parent.closeActiveWin();
        }

        function dummy(e) {
            if (window.event) {
                window.event.cancelBubble = true;
            } else {
                e.stopPropagation();
            }

        }
        var lastexpand = "";
        function Toggle(name) {
            var d = document.getElementById(name);
            var i = document.getElementById(name + "icon");


            if (lastexpand != "" && name != lastexpand) {

                var ld = document.getElementById(lastexpand);
                var li = document.getElementById(lastexpand + "icon");
                ld.style.display = 'none';
                li.src = "images/expand.png";

                lastexpand = "";
            }

            if (d.style.display == 'none') {
                d.style.display = '';
                i.src = "images/collapse.gif";
                lastexpand = name;
            } else {
                d.style.display = 'none';
                i.src = "images/expand.png";
            }
        }
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
    <asp:Label ID="ErrorMsg" runat="server" ForeColor="Red" 
        meta:resourcekey="ErrorMsgResource1"></asp:Label>
    <div id='allgroup' style="padding: 64px; overflow: auto; width: 90%;">
    </div>
    <table width="100%" id='group1' class="checkout3">
        <tr>
            <td colspan="2" style="padding-top: 8px; padding-left: 8px; background-color: white;
                color: black;" id="ext">
                <asp:Panel ID="Attach" runat="server" meta:resourcekey="AttachResource1">
                    <asp:CheckBox ID="AllowAttach" runat="server" 
                        Text="Allow user to attach external cloud storage" 
                        meta:resourcekey="AllowAttachResource1" />
                    <p class="idea_flex" height="40px" style="margin: 8px;">
                        <asp:Localize meta:resourcekey="string7" runat="server">This setting will not take effect until your user logs in next time.</asp:Localize></p>
                </asp:Panel>
                <asp:CheckBox ID="DisableVersion" runat="server" 
                    Text="Disable versioned folder" meta:resourcekey="DisableVersionResource1" /><br />
                <p style="font-size: 10px; color: #a0a0a0; margin-left: 16px;">
                    <asp:Localize meta:resourcekey="string8" runat="server">When this setting is set, the feature of version-folder will be hidden.</asp:Localize></p>
                <asp:CheckBox ID="DisableUserList" runat="server" 
                    Text="Don't show user list in create share wizard" 
                    meta:resourcekey="DisableUserListResource1" /><br />
                <p style="font-size: 10px; color: #a0a0a0; margin-left: 16px;">
                    <asp:Localize meta:resourcekey="string9" runat="server">When this setting is set, the system will not populate the user list to recipient dropdown list.</asp:Localize></p>
                <asp:CheckBox ID="DisableHomeDirShare" runat="server" 
                    Text="Disable team-user share home directory content externally" 
                    meta:resourcekey="DisableHomeDirShareResource1" /><br />
                <p style="font-size: 10px; color: #a0a0a0; margin-left: 16px;">
                    <asp:Localize meta:resourcekey="string10" runat="server">When this setting is not set, you can enable/disable the sharing on per-user basis.</asp:Localize></p>
                <p style="padding-top: 8px;">
                    <asp:CheckBox ID="ShareMustLogin" runat="server" 
                        Text="User must log in to access file/folder shared to him/her." 
                        meta:resourcekey="ShareMustLoginResource1" /><br />
                    <p style="font-size: 10px; color: #a0a0a0; margin-left: 16px;">
                        <asp:Localize meta:resourcekey="string11" runat="server">When this setting is set, user must log in to his/her account to access received
                            share in "Files shared with me" folder.</asp:Localize></p>
                <p style="padding-top: 8px;">
                    <asp:CheckBox ID="RemoveTeamFolderSuffix" runat="server" 
                        Text="Dont append '(Team Folder)' to published folder." 
                        meta:resourcekey="RemoveTeamFolderSuffixResource1" /><br />
                    <p style="font-size: 10px; color: #a0a0a0; margin-left: 16px;">
                        <asp:Localize meta:resourcekey="string12" runat="server">When this setting is NOT set, system will automatically append '(Team Folder)' for
                            team user.</asp:Localize></p>
                <asp:CheckBox ID="AllowGoogleAppLogin" runat="server" 
                    Text="Enable authenticating user with Google Apps credential" 
                    meta:resourcekey="AllowGoogleAppLoginResource1" /><br />
                <p style="font-size: 10px; color: #a0a0a0; margin-left: 16px;">
                    <asp:Localize meta:resourcekey="string13" runat="server">When this setting is set, user can log in to the system with Google Apps credential.</asp:Localize></p>
                <p style="padding-top: 8px;">
                    <asp:Label ID="Label1" runat="server" 
                        Text="only allow sending share to specified domain (i.e. company.com;company1.com)" 
                        meta:resourcekey="Label1Resource1"></asp:Label><br />
                    <asp:TextBox ID="ShareDomainWhiteList" runat="server" Width="90%" 
                        meta:resourcekey="ShareDomainWhiteListResource1"></asp:TextBox>
                <p style="font-size: 10px; color: #a0a0a0; margin-left: 16px;">
                    <asp:Localize meta:resourcekey="string14" runat="server">When this setting is NOT set, your team users can share files with any email address.
                        When this setting is set, team users can only send share to the email addresses
                        in the specified domain.</asp:Localize></p>
                <p style="padding-top: 8px;">
                    <asp:Label ID="Label3" runat="server" 
                        Text="Don't create guest user account if recipent is from following domains (i.e. company.com;company1.com)" 
                        meta:resourcekey="Label3Resource1"></asp:Label><br />
                    <asp:TextBox ID="NoGuestDomainList" runat="server" Width="90%" 
                        meta:resourcekey="NoGuestDomainListResource1"></asp:TextBox>

                <table>
                    <tr>
                        <td width="32px">
                            <img width="32px" src="images/whitelist.png" />
                        </td>
                        <td align="left">
                            <asp:LinkButton ID="LinkButton3" runat="server" Font-Size="Larger" ForeColor="Green"
                                OnClientClick="parent.parent.EditNoCacheList();return false;" 
                                meta:resourcekey="LinkButton3Resource1"><asp:Localize meta:resourcekey="string15" runat="server">List of Users with Cache Disabled</asp:Localize> </asp:LinkButton>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>
    <table id='group2' width="100%" class="checkout3">
        <tr>
            <td colspan="2" style="padding-top: 8px; padding-left: 8px; background-color: white;
                color: black;" id="client">
                <p class="idea_flex" height="40px" style="margin: 8px;">
                    <asp:Localize meta:resourcekey="string16" runat="server">Following setting will apply to all clients (Desktop Client/File Server Client).</asp:Localize></p>
                <asp:CheckBox ID="EnableDistributedLocking" runat="server" 
                    Text="Enable distributed locking when accessing files" 
                    meta:resourcekey="EnableDistributedLockingResource1" /><br />
                <p style="line-height: 16px; font-size: 10px; color: #a0a0a0; margin-left: 16px;">
                    <asp:Localize meta:resourcekey="string17" runat="server">When set, the file will be locked when accessed, this will prevent multiple users
                        editing the same file at the same time. This may not take effect if the application
                        used to access the file does not support locking.</asp:Localize></p>
                <span style="width: 20px">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span><asp:CheckBox
                    ID="ForceLock" runat="server" Text="Lock file exclusively" 
                    meta:resourcekey="ForceLockResource1" /><br />
                <p style="line-height: 16px; font-size: 10px; color: #a0a0a0; margin-left: 16px;">
                    <span style="width: 20px">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>
                    <asp:Localize meta:resourcekey="string18" runat="server">When
                        set, the locked file will be locked exclusively. When not set, other user trying
                        to open a locked file will be notified about the lock status, but can still open
                        the file.</asp:Localize></p>
                <span style="width: 20px">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span><asp:CheckBox
                    ID="DelaySync" runat="server" Text="Delay sync until file is unlocked" 
                    meta:resourcekey="DelaySyncResource1" /><br />
                <p style="line-height: 16px; font-size: 10px; color: #a0a0a0; margin-left: 16px;">
                <span style="width: 20px">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>
                    <asp:Localize meta:resourcekey="string19" runat="server">When set, the sync of modified file will be delayed until the file is unlocked (the editing process exits)</asp:Localize></p>
                <span style="width: 20px">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>
                <asp:Localize meta:resourcekey="string20" runat="server">Apply lock only to following process (lower case):</asp:Localize><asp:TextBox Width="350px" ID="LockProcess"
                    runat="server" Text="winword.exe;excel.exe;powerpnt.exe;" 
                    meta:resourcekey="LockProcessResource1"></asp:TextBox>
                <br style="line-height: 5px" />
                <asp:CheckBox ID="DisableAttach" runat="server" 
                    Text="Disable backup/attach local folder from client device" 
                    meta:resourcekey="DisableAttachResource1" /><br />
                <p style="line-height: 16px; font-size: 10px; color: #a0a0a0; margin-left: 16px;">
                    <asp:Localize meta:resourcekey="string21" runat="server">When set, the functionality of backup or attaching local folder from a client device
                        is disabled</asp:Localize></p>
                <br style="line-height: 3px" />
                <asp:CheckBox ID="DisableFolderDownload" runat="server" 
                    Text="Disable folder download from web client" 
                    meta:resourcekey="DisableFolderDownloadResource1" /><br />
                <p style="line-height: 16px; font-size: 10px; color: #a0a0a0; margin-left: 16px;">
                    <asp:Localize meta:resourcekey="string22" runat="server">When set, the functionality of downloading a folder as zip file from web client
                        is disabled</asp:Localize></p>
                <br style="line-height: 3px" />
                <asp:CheckBox ID="NoSharesFolder" runat="server" 
                    Text="Hide 'Files shared with me' folder" 
                    meta:resourcekey="NoSharesFolderResource1" /><br />
                <p style="line-height: 16px; font-size: 10px; color: #a0a0a0; margin-left: 16px;">
                    <asp:Localize meta:resourcekey="string23" runat="server">When set, the folder 'Files shared with me' will be hidden</asp:Localize></p>
                <br style="line-height: 3px" />
                <asp:CheckBox ID="AddShortCutToDocuments" Checked="True" runat="server" 
                    Text="Create shortcut in documents library" 
                    meta:resourcekey="AddShortCutToDocumentsResource1" /><br />
                <p style="line-height: 16px; font-size: 10px; color: #a0a0a0; margin-left: 16px;">
                    <asp:Localize meta:resourcekey="string24" runat="server">When set, the windows client will create a shortcut to the mapped drive in documents
                        library</asp:Localize></p>
                <br style="line-height: 3px" />
                <asp:CheckBox ID="DisableDDHandler" runat="server" 
                    Text="Disable drag & drop handler" 
                    meta:resourcekey="DisableDDHandlerResource1" /><br />
                <p style="line-height: 16px; font-size: 10px; color: #a0a0a0; margin-left: 16px;">
                    <asp:Localize meta:resourcekey="string25" runat="server">When set, drag & drop files(or folders) to cloud drive will write files to local
                        cache first. Then upload in background</asp:Localize></p>
                <p style="padding-top: 8px;">
                    <asp:Label ID="Label2" runat="server" 
                        Text="Files with following extension will be excluded from attached local folder (i.e.[.pst][.abc]):" 
                        meta:resourcekey="Label2Resource1"></asp:Label><br />
                    <asp:TextBox ID="DropExcludeList" runat="server" Width="90%" Text="[.pst]" 
                        meta:resourcekey="DropExcludeListResource1"></asp:TextBox>
                <div style="display: none">
                    <asp:Localize meta:resourcekey="string26" runat="server">Files Stored Locally Only (Separate by ;):</asp:Localize><asp:TextBox ID="LocalOnlyList" Text="thumbs.db;desktop.ini;picasa.ini;"
                        Width="250px" runat="server" meta:resourcekey="LocalOnlyListResource1"></asp:TextBox><br />
                    <asp:Localize meta:resourcekey="string27" runat="server">Extensions of Files Stored Locally Only (Separate by ;):</asp:Localize><asp:TextBox ID="LocalOnlyExtList"
                        Text=".lnk;" runat="server" meta:resourcekey="LocalOnlyExtListResource1"></asp:TextBox><br />
                    <asp:CheckBox ID="ShowExplorerBar" runat="server" Checked="True" Text="Show Gladinet Explorer Menu Bar"
                        Visible="False" meta:resourcekey="ShowExplorerBarResource1" /><br />
                </div>
            </td>
        </tr>
    </table>
    <table id='group3' width="100%" class="checkout3">
        <tr>
            <td colspan="2" style="padding-top: 8px; padding-left: 8px; background-color: white;
                color: black;" id="ren">
                <asp:Localize meta:resourcekey="string28" runat="server">Keep Last n version of file in versioned folder. n is </asp:Localize>
                <asp:TextBox ID="VersionCount" Text="0" runat="server" 
                    meta:resourcekey="VersionCountResource1"></asp:TextBox>
                <br />
                <p style="line-height: 16px; font-size: 10px; color: #a0a0a0; margin-left: 16px;">
                    <asp:Localize meta:resourcekey="string29" runat="server">0 - let system decide, also apply to attached local folder</asp:Localize>
                </p>
                <br />
                <br />
                <asp:Localize meta:resourcekey="string30" runat="server">Keep deleted file in versioned folder for n days. n is</asp:Localize>
                <asp:TextBox ID="TrashDays" Text="90" runat="server" 
                    meta:resourcekey="TrashDaysResource1"></asp:TextBox>
                <br />
                <p style="line-height: 16px; font-size: 10px; color: #a0a0a0; margin-left: 16px;">
                    <asp:Localize meta:resourcekey="string31" runat="server">0 - don't purge deleted files</asp:Localize>
                </p>
            </td>
        </tr>
    </table>
    <table id='group4' width="100%" class="checkout3">
        <tr>
            <td colspan="2" style="padding-top: 8px; padding-left: 8px; background-color: white;
                color: black;" id="homedir">
                <table>
                    <tr>
                        <td colspan="2">
                            <asp:Localize meta:resourcekey="string32" runat="server">Default storage quota for new user (GB, 0-unlimited):</asp:Localize><asp:TextBox ID="DefaultHomeSize"
                                Text="0" runat="server" meta:resourcekey="DefaultHomeSizeResource1"></asp:TextBox>
                        </td>
                    </tr>
                    <tr>
                        <td colspan="2" style="padding-top: 10px;">
                            <asp:CheckBox ID="CreateDefaultDir" Checked="True" runat="server" 
                                Text="Create default folder(Documents, Pictures)" 
                                meta:resourcekey="CreateDefaultDirResource1" />
                        </td>
                    </tr>
                    <tr style="display:none;">
                        <td colspan="2" style="padding-top: 10px;">
                            <asp:CheckBox ID="VisibleHomeDir" runat="server" 
                                Text="Make user's home directory visible to administrator" 
                                meta:resourcekey="VisibleHomeDirResource1" />
                        </td>
                    </tr>
                    <tr style="display: none;">
                        <td colspan="2" style="padding-right: 40px;">
                            <span style="color: #808080">
                                <asp:Localize meta:resourcekey="string33" runat="server">administrator will see the users' home directory under
                                                             administrator's "Users" directory.</asp:Localize>
                            </span><br />
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>
     <table id='group5' width="100%" class="checkout3">
            <tr>
                <td colspan="2" style="padding-top: 8px; padding-left: 8px; background-color: white;
                    color: black;" id="Td1">
                    <table>
                        <tr>
                            <td>
                                <asp:CheckBox ID="EnforcePasswordPolicy" runat="server" 
                                    Text="Enforce password policy for non AD users" AutoPostBack=True 
                                    oncheckedchanged="EnforcePasswordPolicy_CheckedChanged" 
                                    meta:resourcekey="EnforcePasswordPolicyResource1" />
                            </td>
                        </tr>
                        <asp:Panel ID="PwdPolicyPanel" runat="server" Visible=False 
                            meta:resourcekey="PwdPolicyPanelResource1">                        
                        <tr>
                            <td colspan="2">
                                <p><asp:Localize meta:resourcekey="string34" runat="server">Password minimal length:</asp:Localize></p>
                                <asp:TextBox ID="PasswordLength" runat="server" Text="8" 
                                    meta:resourcekey="PasswordLengthResource1"></asp:TextBox>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2" >
                                <asp:CheckBox ID="MustHaveUpperCase" Checked=True runat="server" 
                                    Text="Must contains upper case character" 
                                    meta:resourcekey="MustHaveUpperCaseResource1" />
                             </td>
                        </tr>
                        <tr>
                            <td colspan="2" >
                                <asp:CheckBox ID="MustHaveLowerCase" Checked=True  runat="server" 
                                    Text="Must contains lower case character" 
                                    meta:resourcekey="MustHaveLowerCaseResource1" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2" >
                                <asp:CheckBox ID="MustHaveNumer"  Checked=True  runat="server" 
                                    Text="Must contains base10 digit  (0-9)" 
                                    meta:resourcekey="MustHaveNumerResource1" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2" >
                                <asp:CheckBox ID="MustHaveNonalphanumeric"  Checked=True  runat="server" 
                                    Text="Must contains non-alphanumeric characters: ~!@#$%^&*_-+=`|\\(){}[]:;'<>,.?/ " 
                                    meta:resourcekey="MustHaveNonalphanumericResource1" />
                            </td>
                        </tr>

                        </asp:Panel>
                    </table>
                </td>
            </tr>
        </table>
    <table id='group6' width="100%" class="checkout3">
    <tr>
                        <td width="32px">
                            <img width="32px" src="images/whitelist.png" />
                        </td>
                        <td align="left">
                            <asp:LinkButton ID="LinkButton1" runat="server" Font-Size="Larger" ForeColor="Green"
                                OnClientClick="parent.parent.EditNoDownloadList();return false;" 
                                meta:resourcekey="LinkButton1Resource1"><asp:Localize meta:resourcekey="string35" runat="server">List of Users with Client Download Disabled</asp:Localize> </asp:LinkButton>
                        </td>
                    </tr>            
        </table>
        <table width="100%" id='buttons'>
        <tr>
                <td align="right" style="padding: 10px;">
                    <asp:Button ID="ApplylNow" runat="server" Text="Apply" Font-Size="12px" Height="26px"
                        Width="128px" OnClientClick="Wait('Applying Settings');this.style.display='none'"
                        OnClick="ApplylNow_Click" meta:resourcekey="ApplylNowResource1" />&nbsp;&nbsp;&nbsp;&nbsp;
                    <asp:Button ID="CancelAChange" runat="server" Text="Cancel" Font-Size="12px" Height="26px"
                        OnClientClick="parent.closeActiveWin();return false;" Width="128px" 
                        Visible="False" meta:resourcekey="CancelAChangeResource1" />
                </td>
            </tr>
        </table>

</asp:Content>
