﻿<%@ Page Title="Gladinet Cloud - Group Manager" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="GroupMgrPage.aspx.cs" Inherits="GladinetPayFlow.GroupMgrPage" culture="auto" meta:resourcekey="PageResource1" uiculture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
        .titlecol
        {
            background-color: #f0f0f0;
            font-size: 14px;
        }

                .actioncol{
        margin-top:5px;
        }
        .actioncol .gladinet-icons {
        padding-left:10px;
        }
		.actioncol .tooltip{
            margin:20px 0px 0px 5px !important;  /*tooltip positioning*/ 
		}


        .securityicon 
        {
        	background-image: url(images/security2.png);
        }
        .groupicon 
        {
        	background-image: url(images/group.png);
        }
    </style>
    <script type="text/javascript">




        function ClearErrorMsg() {

            var d = document.getElementById("errmsgdiv");
            if (d) {
                d.style.display = 'none';
            }
        }
        setTimeout("ClearErrorMsg()", 30000);
        //parent.setActivePanel("PubMgr");

        function Unpublish(id, name) {
            var h = "GroupMgrPage.aspx?op=delete&id=" + id+"&vdid=<%=SessionDomainId %>";


            gConfirm("<asp:Localize meta:resourcekey="string1" runat="server">Do you really want to delete (</asp:Localize>" + unescape(name) + ")?", "", function(btn1) {

                    if (btn1 != 'ok')
                        return;
            Wait("Deleting");
            window.location = h;
                });
        }




        var ActiveWin;
        var MainWnd;
        function closeActiveWin() {


            window.location = window.location;

        }

        function closeCancelActiveWin() {            
            window.location = window.location;
        }

        function AddUserGroup() {
            window.location = "/portal/EditGroup.aspx?src=mgr&vdid=<%=SessionDomainId%>";
           

        }

        function EditGroup(groupid) {
            window.location = "/portal/EditGroup.aspx?groupid="+groupid+"&vdid=<%=SessionDomainId%>";

        }

        function OnClickUser() {
            window.location = "/portal/UserMgrPage.aspx";
        }

        function OnClickGuest() {
            window.location = "/management/GuestUserMgrPage.aspx";
        }
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
    <asp:Localize ID="LocGstUsr" meta:resourcekey="str_gstUsr" runat="server" Visible="false">Guest User</asp:Localize>
 <div style="padding:5px; min-height:48px;border-bottom:1px solid #cccccc;" >
          <table width="100%">
              <tr>
                  <td>
                      <table>
                          <tr>
                              <td style="padding:5px;">
                                  <%if (m_CanAdd){ %>
                      <a href="javascript:;" onclick="AddUserGroup();return false;" style="font-size: 12px;" >
                                 <button type="button" class="btn btn-primary gladbtn navbar-btn navbar-right" style="margin-right:-2px;" title="<%=LocCreateNewGroup.Text %>">   <span class="fa fa-plus sectextcolor" aria-hidden="true" style="font-size: 14px; margin-left: 11px; margin-top: 14px; cursor: pointer; display: inline-block; position: absolute;" >
                                                                            </span>

                                                                                    <i class="gladinet-icons md-24 md-dark hand center toolbtn" style="display: inline-block; margin-top: 0px;" >G</i>
                                   
                                 </button>
                                </a>
                                  <%} %>
                              </td>
                              <td style="padding:5px;">
                                   <asp:LinkButton ID="ExportBtn" runat="server" OnClick="exportcsv_Click">
                <i class="gladinet-icons md-24 md-dark hand center toolbtn" style="display: inline-block; " title="<%=LocDldCsvFil.Text %>">&#0178;</i>
                    </asp:LinkButton>
                              </td>

                              <td style="padding:5px; padding-left:14px;">
                                   
                <i class="gladinet-icons md-24 md-dark hand center toolbtn" style="display: inline-block; " data-toggle="modal" data-target="#searchModal" title="Search">&#xA7;</i>
                    <div class="modal fade" id="searchModal" tabindex="-1" role="dialog" aria-labelledby="searchModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="searchModalLabel"><%=SearchBtn.Text %></h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
          <table width="100%" border="0">
              <tr>

        <td>
                            <asp:TextBox ID="Filter" runat="server"  CssClass="form-control dark"
                                meta:resourcekey="ContainsResource1"></asp:TextBox>
                                </td>
                                </tr>
          </table>

      </div>
      <div class="modal-footer">
         <asp:Button ID="AllGroups" runat="server" Text="All Groups" CssClass="btn btn-primary gladbtn"
                                                        meta:resourcekey="AllBtnResource1" onclick="AllGroups_Click" />
        <asp:LinkButton ID="SearchBtn" OnClick="SearchBtn_Click" runat="server" Text="Search" CssClass="btn btn-primary gladbtn " 
                                 meta:resourcekey="Button1Resource2" />
          <button type="button" class="btn btn-secondary gladbtn" data-dismiss="modal">Close</button>
      </div>
    </div>
  </div>
</div>
                              </td>
                          </tr>
                      </table>
                  </td>
                  <td align="center">
                      <asp:Label ID="PubFolderCount" runat="server" meta:resourcekey="PubFolderCountResource1" CssClass="badge hollowbadge"></asp:Label>
                  </td>
                  <td>
                      <b>
                                                <asp:Label ID="ErrorMsg" runat="server" Style="color: Red;" meta:resourcekey="ErrorMsgResource1"></asp:Label></b>
                  </td>
                  <td align="right">
                      <div class="navbar-right sectextcolor" style="width:40px; font-size:32px;  font-weight:100; cursor:pointer;padding-top:5px;" onclick="ReturnLast();">&times;</div>
                  </td>
                </tr>
              </table>
     </div>


                            <table width="100%" style=" padding: 0px; background-color: white; margin-top: 0px;" cellspacing="0" cellpadding="0" id="grid-table">
                                <tr style="background-color: #f0f0f0; display: none; ">
                                    <td align="left" style="padding-left: 5px; border-bottom: 3px solid #e0e0e0;">
                                       
                                    </td>
                                    <td style="padding-left: 5px; border-bottom: 3px solid #e0e0e0;">
                                        <div id="errmsgdiv">
                                            
                                        </div>
                                    </td>
                                    <td style="padding-left: 5px; border-bottom: 3px solid #e0e0e0;" align="right">
                                        
                                        <table>
                                            <tr>
                                                <td>
                                                   
                                                </td>
                                                <td>
                                                    
                                                </td>
                                                <td>
                                                 
                                                    
                                                </td>
                                            </tr>
                                        </table>
                                    </td>
                                    
                                    <td align="right" padding="0px" style="padding-left: 5px;width:200px; border-bottom: 0px solid #e0e0e0;">
                                        <table>
                                            <tr>
                                                <%if (m_CanSetPerm && !EditingTenant)
                                                  { %>
                                                <td align="left" style="padding-right: 15px;">
                                                    <asp:LinkButton ID="LinkButton1" runat="server" Font-Size="Larger" ForeColor="Green"
                                                        OnClientClick="parent.SetAcls('/GroupManager');return false;" CssClass="x-btn x-btn-toolbar x-toolbar-item x-btn-default-toolbar-large x-icon-text-left x-btn-icon-text-left x-btn-default-toolbar-large-icon-text-left"
                                                        meta:resourcekey="LinkButton1Resource1">
                            <span unselectable="on"
        class="x-btn-wrap"><span class="x-btn-button">
            <span unselectable="on" class="x-btn-inner x-btn-inner-center" style="color:#008000;font-weight:400;">
                <asp:Localize meta:resourcekey="string2" runat="server">Security</asp:Localize></span><span style="" unselectable="on" class="x-btn-icon-el securityicon"
                   role="img">&nbsp;</span></span></span>  
                                                    </asp:LinkButton>
                                                </td>
                                                <%} %>
                                                <%if (m_CanAdd)
                                                  { %>
                                                <td>
                                                    <asp:LinkButton ID="LinkButton2" runat="server" Font-Size="Larger" ForeColor="Green"
                                                        OnClientClick="AddUserGroup();return false;" CssClass="x-btn x-btn-toolbar x-toolbar-item x-btn-default-toolbar-large x-icon-text-left x-btn-icon-text-left x-btn-default-toolbar-large-icon-text-left"
                                                        meta:resourcekey="LinkButton2Resource1">
                            <span unselectable="on"
        class="x-btn-wrap"><span class="x-btn-button">
            <span unselectable="on" class="x-btn-inner x-btn-inner-center" style="color:#008000;font-weight:400;">
                <asp:Localize meta:resourcekey="string3" runat="server">Create New Group</asp:Localize></span><span style="" unselectable="on" class="x-btn-icon-el groupicon"
                   role="img">&nbsp;</span></span></span>  
                                                    </asp:LinkButton>
                                                </td>
                                                <%} %>

                                            </tr>
                                        </table>
                                    </td>
                                </tr>
                               
                                <tr>
                                    <td colspan="5" style="padding-top: 0px">
                                        <div id="grid-example">
                                        </div>
                               
                                    </td>
                                </tr>
                            </table>
             
    <asp:Localize ID="LocCreateNewGroup" meta:resourcekey="string3" runat="server" Visible="false">Create New Group</asp:Localize>
                            <asp:Localize ID="LocDldCsvFil" meta:resourcekey="strDldCsvFil" runat="server" Visible="false">Download as CSV file</asp:Localize>
                        <asp:Localize ID="LocAdUsr" meta:resourcekey="strAdUsr" runat="server" Visible="false">AD User</asp:Localize>
                        <asp:Localize ID="LocPrxAdUsr" meta:resourcekey="strPrxAdUsr" runat="server" Visible="false">Proxied AD User</asp:Localize>
                        <asp:Localize ID="LocNtvUsr" meta:resourcekey="strNtvUsr" runat="server" Visible="false">Native User</asp:Localize>
                        <asp:Localize ID="LocNaUsr" meta:resourcekey="strNaUsr" runat="server" Visible="false">NA</asp:Localize>
    <input type="hidden" id="current_share" name="current_share" />
    <asp:Localize meta:resourcekey="js_edit_group" runat="server" Visible="false" ID="js_edit_group">Edit Group</asp:Localize>
    <asp:Localize meta:resourcekey="js_view_group" runat="server" Visible="false" ID="js_view_group">View Group</asp:Localize>
<script type="text/javascript">
  var myData = [
 <asp:Repeater ID="PubsRepeater" runat="server" >
        <ItemTemplate>
       <%#(Container.ItemIndex == 0)? "": "," %>     ['<%#(((RepeaterItem)Container).ItemIndex+1) %>','<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "GroupName").ToString().Replace("'","%27"))%>', '<%#DataBinder.Eval(Container.DataItem,"GroupId") %>']
        
        </ItemTemplate>
    </asp:Repeater>      
    ];
    </script>
  <script type="text/javascript">
     function ReturnLast() {
            parent.ReturnLast();
      }
  var grid;
       function AdjustGridTable () {
           
        var h = 400;
          
        try {

            var myTable = Ext.get('grid-table');
           
            var tableY = myTable.getY();
           
            h = document.body.offsetHeight-tableY-60;
           
              var ee = document.getElementById('tinfo');
              ee.style.height = h + "px";

          } catch (err) {
          }
              grid.setWidth(document.documentElement.clientWidth - 2);
              grid.setHeight(h);
              grid.doComponentLayout();

          var e = document.getElementById("grid-example");
          e.style.height = h + "px";

      }
      Ext.require([
          'Ext.grid.*',
          'Ext.data.*',
          'Ext.util.*',
          'Ext.state.*'
      ]);
      Ext.onReady(function () {

          Ext.QuickTips.init();


          var store = Ext.create('Ext.data.ArrayStore', {
              fields: [
                  { name: 'index' },
                  { name: 'groupname' },
                  { name: 'gid' }
              ],
              data: myData
          });

           
          var h = 400;
          
          

          grid = Ext.create('Ext.grid.Panel', {              
              frame: false,
              border:false,
              store: store,
              stripeRows: true,
              columnLines: false,
              minHeight : 218,
              height:h, 
              emptyText: "<span style='color:#404040; font-weight:100'><asp:Localize meta:resourcekey="string4" runat="server">No groups have been created</asp:Localize></span>",
              columns: [
                  {
                      text: '',
                      width: 50,
                      sortable: false,
                      dataIndex: 'index',
                      getClass: function (v, meta, rec) {
                          return 'x-col-hdide';
                      }
                  },
                  {
                      text: "<span style='color:#404040; font-weight:100'><asp:Localize meta:resourcekey="js_group_name" runat="server">Group Name</asp:Localize></span>",
                      flex: 1,
                      sortable: true,
                      dataIndex: 'groupname',
                      renderer: function (value, metaData, record, rowIndex) {
                          return  "<span style='color:#565656; font-weight:100'>" + unescape(value) +"</span>";
                      }

      }, {


          sortable: false,
          width:90,
          renderer: function (value, metaData, record, rowIndex) {
                                
              var rec = grid.getStore().getAt(rowIndex);
              var d = rec.data;
              var ndeNme = d.gid;
              var editBtn = "", unpublishBtn = "";
              var editTTip = "data-toggle=\"tooltip\" data-placement=\"bottom\" data-original-title=\"<%=js_edit_group.Text%>\"";
              editBtn = "<div class=\"actioncol\"><i class=\"gladinet-icons md-24 md-dark hand\" onclick=\"EditGroup('"+ndeNme+"')\" "+editTTip+">/</i>";
              
              var unpublishTTip = "data-toggle=\"tooltip\" data-placement=\"bottom\" data-original-title=\"Delete Group\"";
              unpublishBtn = "<i class=\"gladinet-icons md-24 md-dark hand\" onclick=\"Unpublish('"+ndeNme+"','"+ d.groupname+"')\" "+unpublishTTip+">n</i></div>";
              <%if (!m_CanEdit) {%>   
                editBtn = "<div class=\"actioncol\"><i class=\"gladinet-icons md-24 md-dark hand\" onclick=\"EditGroup('"+ndeNme+"')\" data-toggle=\"tooltip\" data-placement=\"bottom\" data-original-title=\"<%=js_edit_group.Text%>\">&#xDB;</i>";
              <%}%>       
              <%if (!m_CanDelete) {%>   
                unpublishBtn = "";
              <%}%>  
              return editBtn+"&nbsp;&nbsp;"+unpublishBtn;
          }
          }
        ],
              renderTo: 'grid-example'
          });
          //Ext.EventManager.onWindowResize(grid.doLayout, grid);
           AdjustGridTable ();
             //Ext.EventManager.onWindowResize(grid.doLayout, grid);
             Ext.EventManager.onWindowResize(AdjustGridTable);

      });
  </script>
</asp:Content>
