﻿<%@ Page Title="Gladinet Cloud - Account Info" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="FolderInfo.aspx.cs" Inherits="GladinetPayFlow.FolderInfo"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
          li{
            padding-right:10px;
            font-size:12px!important;
        }
        .circle
        {
            width: 32px;
            height: 32px;
            -webkit-border-radius: 16px;
            -moz-border-radius: 16px;
            border-radius: 16px;
            align-content: center;
            vertical-align: middle;
            cursor: default;
        }
        
        .titlecol
        {
            background-color: #f0f0f0;
            font-size: 14px;
            padding-left: 5px;
        }
        
        td
        {
            font-size: 12px;
            font-weight: 100;
        }
        
        b
        {
            font-weight: 300;
        }
        
        label
        {
            font-size: 10px !important;
        }
        
        .ltitle {
            color: #565656 !important;
            font-size: 14px!important;
        }
        .readonly
        {
            width: 32px;
            height: 32px;
            -webkit-border-radius: 16px;
            -moz-border-radius: 16px;
            border-radius: 16px;
            border-style: dotted !important;
            align-content: center;
            vertical-align: middle;
            cursor: default;
        }
        
        .readwrite
        {
            width: 32px;
            height: 32px;
            -webkit-border-radius: 16px;
            -moz-border-radius: 16px;
            border-radius: 16px;
            border-style: solid;
            align-content: center;
            vertical-align: middle;
            cursor: default;
        }
        
        .owner
        {
            width: 32px;
            height: 32px;
            -webkit-border-radius: 16px;
            -moz-border-radius: 16px;
            border-radius: 16px;
            align-content: center;
            vertical-align: middle;
            text-decoration: underline !important;
            cursor: default;
        }
        
       
    </style>
    <script type="text/javascript">
        function gEncodeUri(str) {

            var s = encodeURI(str).replace(/&/g, '%26').replace(/#/g, '|').replace('+', ':').replace(/'/g, '%27');

            while (true) {
                var i = s.indexOf('+');
                if (i == -1)
                    break;
                s = s.replace('+', ':');
            }

            return s;


        }

        function UnlinkFolder(did,dname) {
            var b = document.getElementById("MainContent_UnlinkBtn");
            var d = document.getElementById("MainContent_DeviceId");
            
        
            gConfirm("<asp:Localize meta:resourcekey="str_uhint" runat="server">Unlink the folder from device:</asp:Localize>"+dname+"?", "", function() {


                d.value = did;
                b.click();

            });
            
        }

        function StartEditTag() {
            var e = document.getElementById("TagDisplay");
            var e1 = document.getElementById("TagEdit");

            e.style.display = 'none';
            e1.style.display = 'block';
        }

        function CancelEditTag() {
            var e = document.getElementById("TagDisplay");
            var e1 = document.getElementById("TagEdit");

            e.style.display = 'block';
            e1.style.display = 'none';
        }
        function ClearErrorMsg() {

            var d = document.getElementById("errmsgdiv");
            if (d !== null && d !== undefined) {
                d.style.display = 'none';
            }
        }
        setTimeout("ClearErrorMsg()", 30000);
        //document.body.style.backgroundColor = "White";



        function closeCancelActiveWin() {
            ActiveWin.close();
        }

        function downloadByKey() {
            var cdir = XSSDecode("<%=XSSUrlEncode(FullPath.Text)%>");

            var uri = "/storage/download.dn?f=";
            uri += gEncodeUri(cdir);
            window.open(uri, "_blank", "location=no,menubar=no,toolbar=no", true);

        }

        function shareByKey() {
            var cdir = XSSDecode("<%=XSSUrlEncode(FullPath.Text)%>");
            var uri = "<iframe id='openwin' src='/portal/AddSharePage.aspx?src=filebrowser&location=";
            uri += gEncodeUri(cdir);
            uri += "&folder=false&size=" + "0";
            uri += "' scrolling='no' style='width:100%;height:100%;margin:0;padding:0;background-color: #dfe8f6; border:0px solid black;'></iframe>";

            parent.parent.OpenHtmlWindow('link_win_2', "<asp:Localize meta:resourcekey="js_string1" runat="server">Edit Share</asp:Localize>"+ " - <%=DisplayPath.Text%>", uri);


        }

        function showRevisions() {
            var cdir = XSSDecode("<%=XSSUrlEncode(FullPath.Text)%>");

            var uri = "<iframe id='openwin' src='FileVersion.aspx?f=";
            uri += gEncodeUri(cdir);
            uri += "&folder=false&size=" + "0";
            uri += "' scrolling='no' style='width:100%;height:100%;margin:0;padding:0;background-color: #dfe8f6; border:0px solid black;'></iframe>";

            parent.parent.OpenHtmlWindow('link_win_1', "<asp:Localize meta:resourcekey="js_string2" runat="server">Manage Revisions</asp:Localize>", uri);

        }

        function EditPubFolder() {
            var location = "/<%=FullPath.Text%>";
            parent.parent.EditPubFolder(location);

        }

        function FolderPerm() {
            var location = "/<%=FullPath.Text%>";

            parent.parent.EditFolderPermission(location);
        }


        function SubUserFolderPerm() {
            var location = "<%=AbsolutePath%>";

            parent.parent.EditFolderPermission(location);

        }
        function SubUserEditPubFolder() {
            var location = "<%=AbsolutePath%>";
            parent.parent.EditPubFolder(location);

        }

        function RestoreFolder() {
            var location = "<%=FullPath.Text%>";

            parent.parent.RestoreFolder(escape(location));
        }

        function OnEdit() {
            var ShareId = XSSDecode("<%=XSSUrlEncode(FullPath.Text)%>");
            var uri = "/portal/AddSharePage.aspx?src=filebrowser&folder=";
            uri += "true";
            uri += "&location=/";

            uri += gEncodeUri(ShareId.replace("%27", "'"));
            

            if (parent.parent.OpenHtmlWindow) {
                parent.parent.OpenMainWindow(uri, "<asp:Localize meta:resourcekey="js_string3" runat="server">Edit Share</asp:Localize>"+ " - <%=DisplayPath.Text%>");
            } else {
                parent.OpenMainWindow(uri,"<asp:Localize meta:resourcekey="js_string3" runat="server">Edit Share</asp:Localize>"+ " - <%=DisplayPath.Text%>");
            }
        }
        function OnAddLink() {
            var ShareId = XSSDecode("<%=XSSUrlEncode(FullPath.Text)%>");
            var uri = "/management/adduserwizard/SelectDevice.aspx?src=filebrowser&folder=";            
            uri += "&location=";

            uri += gEncodeUri(ShareId.replace("%27", "'"));
            
            
            if (parent.parent.OpenQuickWindowMaxWidth){ 
                parent.parent.OpenQuickWindowMaxWidth(uri, "Add Link"+ " - <%=DisplayPath.Text%>");
            }else if (parent.parent.OpenMainWindow) {
                parent.parent.OpenMainWindow(uri, "Add Link"+ " - <%=DisplayPath.Text%>");
            } else {
                parent.OpenMainWindow(uri,"AddLink"+ " - <%=DisplayPath.Text%>");
            }
        }

        function StartEditDesc() {
            var d = document.getElementById("desc_display");
            var c = document.getElementById("desc_change");

            d.style.display = "none";
            c.style.display = "";
        }

        function StopEditDesc() {
            var d = document.getElementById("desc_display");
            var c = document.getElementById("desc_change");

            d.style.display = "";
            c.style.display = "none";
        }

        function StartEditCom() {
            var c = document.getElementById("com_change");


            c.style.display = "";
        }

        function StopEditCom() {
            var c = document.getElementById("com_change");


            c.style.display = "none";
        }

        function ShowAct() {
            var b = document.getElementById("MainContent_ShowActivities");
            b.click();


        }
        function ShowTeam() {
            var b = document.getElementById("MainContent_ShowTeam");
            b.click();

        }
        function ShowPolicy() {
            var b = document.getElementById("MainContent_ShowPolicy");
            b.click();

        }

        function ShowActivity() {
            var b = document.getElementById("MainContent_LinkButton5");
            b.click();

        }

        function ShowPanel() {
            var b = document.getElementById("MainContent_LinkButton4");
            b.click();

        }

        var toggleBtnStateRight = true;

        function Toggle() {
            var e = document.getElementById("managetd");
            var ee = document.getElementById("previewtr");
            if (e.style.display == "none") {

                e.style.display = "";
                ee.style.display = "none";
                //var Ele_e = Ext.get("managetd");
                //Ele_e.slideIn('l', { duration: 300 });
                try {
                    localStorage.setItem("managepanel", "1");
                } catch (ee) {
                    alert(ee.message);
                }

            } else {
                e.style.display = "none";
                ee.style.display = "";
                //var Ele_e = Ext.get("previewtr");
                //Ele_e.slideIn('r', { duration: 300 });
                try {
                    localStorage.setItem("managepanel", "0");
                } catch (ee) {
                    alert(ee.message);
                }

            }

            var togBtn = Ext.get("info_togglebtn");
            if (toggleBtnStateRight) {
                togBtn.removeCls("fb_inforight32");
                togBtn.addCls("fb_infoleft32");
            } else {
                togBtn.removeCls("fb_infoleft32");
                togBtn.addCls("fb_inforight32");
            }

            toggleBtnStateRight = !toggleBtnStateRight;
        }

        function OnAvLoad(id) {
            var i = document.getElementById("i_" + id);
            if (i.width == 1)
                return;

            var e = document.getElementById("av_" + id);
            e.style.display = "none";
            i.style.display = "";
        }
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
<asp:Localize ID="LocTraCan" meta:resourcekey="str_traCan" runat="server" Visible="False">Trash Can</asp:Localize>
<asp:Localize ID="LocNoUseWasAddInTheAllLis" meta:resourcekey="str_noUseWasAddInTheAllLis" runat="server" Visible="False">No user was added in the allowed list</asp:Localize>
<asp:Localize ID="LocFilShaWitMe" meta:resourcekey="str_filShaWitMe" runat="server" Visible="False">Files shared with me</asp:Localize>
<asp:Localize runat="server" ID="LocSuc" meta:resourcekey="str_suc" Visible="false">Succeed</asp:Localize>
<asp:Localize runat="server" ID="LocFai" meta:resourcekey="str_fai" Visible="false">Failed</asp:Localize>
<asp:Localize runat="server" ID="LocFaiToRes" meta:resourcekey="str_faiToRes" Visible="false">Failed to resolve</asp:Localize>

    <table width="100%" class="x-body" border="0" cellpadding="0" cellspacing="0" style="background-color: white;">
        <tr style="">
            <td class="checkout3 x-panel-header-light x-panel-header-text-container-light" style="padding-top: 0px;
                background-color: white; padding-bottom: 0px; border-top: 0; border-left: 0;
                border-right: 0; border-bottom: 0px solid #e0e0e0;">
                <table align="center" width="100%" cellspacing="0" cellpadding="0">
                    <tr>
                        <td align="center" style="padding-left: 0px; padding-bottom: 0px;">
                            <table width="100%"  cellspacing="0" cellpadding="0">
                                <tr id="TitleTR" style="display: none;">
                                    <td colspan="2" align="center" style="padding: 5px; background-color: white; border-bottom: 1px solid #c0c0c0;">
                                        <table>
                                            </table>
                                    </td>
                                </tr>
                                
                                <tr >
                                    <td style="padding-left: 10px; padding-top: 20px; padding-bottom: 3px; border-bottom: 1px solid #e0e0e0;
                                        background-color: white; ">
                                        <table style="display:none;">
                                            <tr>
                                                <td style="padding-left: 0px; border-bottom: 0px solid #e0e0e0" width="32px" valign="bottom">
                                                    <i class="gladinet-icons md-32 md-dark hand center toolbtn" style="display: inline-block; margin-top: -3px;">#</i>
                                                </td>
                                                <td class="InputLabel" style="padding-left: 5px; border-bottom: 0px solid #e0e0e0;
                                                    font-size: 14px; color: #404040;" align="left" valign="bottom">
                                                    
                                                </td>
                                            </tr>
                                        </table>
                                    </td>
                                    <td align="right" style="border-bottom: 0px solid #e0e0e0; background-color: white; width:20px;"
                                        valign="bottom">
                                        <asp:Localize meta:resourcekey="str_share" ID="str_share" runat="server" Visible="false">Sharing and Collaboration</asp:Localize>
                                        <asp:Localize meta:resourcekey="str_act1" ID="str_act" runat="server" visible="false">Activities</asp:Localize>
                                        <% if (!SimpleMode && !m_NoRecent)
                                           { %>
                                        <% if (SessionDisplayMode == 0)
                                           { %>
                                       <table>
                                            <tr>
                                                <td style="padding-top: 10px;" valign="bottom">
                                                <div class="gladtab_lg_active gladtablight" id="page_1" >
                                                    <%=str_act.Text%>
                                                </div>
                                            </td>
                                                                                        <td style="padding-top: 10px;" valign="bottom">
                                                <div class="gladtab_lg_inactive gladtablight" onclick="ShowPanel();return false;">
                                                    
                                                    <%=str_share.Text%>
                                                </div>
                                            </td>
                                                <td style="width:10px;border-bottom:1px solid #e0e0e0; ">&nbsp;</td>
                                            </tr>
                                        </table>
                                        <% } %>
                                        <% if (SessionDisplayMode == 1)
                                           { %>
                                        <table>
                                            <tr>
                                                <td style="padding-top: 10px;" valign="bottom">
                                                <div class="gladtab_lg_inactive gladtablight"  onclick="ShowActivity();return false;" >
                                                    <%=str_act.Text%>
                                                </div>
                                            </td>
                                                                                        <td style="padding-top: 10px;" valign="bottom">
                                                <div class="gladtab_lg_active gladtablight" >
                                                    
                                                    <%=str_share.Text%>
                                                </div>
                                            </td>
                                                <td style="width:10px;border-bottom:1px solid #e0e0e0; ">&nbsp;</td>
                                            </tr>
                                        </table>
                                        <% } %>
                                        <% } %>
                                    </td>
                                </tr>
                                <tr>
                                    <td colspan="3">
                                        <div style="display: none; position: absolute; background-color: white; margin-top: 10px;
                                            width: 99%; height: 650px;" id="advinfo">
                                            <asp:LinkButton ID="LinkButton5" runat="server" OnClick="Act_Click">
                                            </asp:LinkButton>
                                            <asp:LinkButton ID="LinkButton4" runat="server" OnClick="SharePanel_Click">
                                            </asp:LinkButton>
                                        </div>
                                    </td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                    <% if (!string.IsNullOrEmpty(ErrorMsg.Text))
                       { %>
                    <tr>
                        <td>
                            <b>
                                <asp:Label ID="ErrorMsg" runat="server" Style="color: Red;" meta:resourcekey="ErrorMsgResource1"></asp:Label>&nbsp;</b>
                        </td>
                    </tr>
                    <% } %>
                    <tr>
                        <td style="font-size:16px; font-weight:100!important; color:#565656; padding:5px; border-bottom:1px solid #f0f0f0;">
                            <asp:Label ID="DisplayPath" runat="server" meta:resourcekey="DisplayPathResource1"></asp:Label>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>
    <table width="100%" align="center" border="0" cellspacing="0" cellpadding="0" class="x-body"
        style="background-color: white;">
        <%if (SessionDisplayMode == 0)
          {%>
        <tr id="previewtr">
            <td valign="top" style="padding: 10px">
                <table width="100%">
                    <tr>
                        <td valign="top">
                            <div style="width:100%;height:calc(100vh - 210px);overflow:auto;">
                            <table width="100%" border="0" align="center">
                                <asp:Repeater ID="ChangesRepeater" runat="server">
                                    <ItemTemplate>
                                        <tr>
                                            <td  style="padding-top: 10px; background-color: white;border-bottom: 1px solid #e0e0e0;">
                                                <table width="95%">
                                                    <tr>
                                                        <td width="20px">
                                                            <div id="av_<%#DataBinder.Eval(Container.DataItem, "ChangeId")%>"  class="circle" title="<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "UserEmail").ToString())%>"
                                                                style="background-color: white; border: 1px solid <%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "AbbrevColor").ToString())%>;
                                                                color: <%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "AbbrevColor").ToString())%>;
                                                                font-size: 16px; padding-top: 3px;" align="center" valign="middle">
                                                                <b>
                                                                    <%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "AbbrevName").ToString())%></b>
                                                            </div>
                                                            <img style="border-radius: 50%; display: none;" id="i_<%#DataBinder.Eval(Container.DataItem, "ChangeId")%>" src="/storage/avarta.dn?u=<%#DataBinder.Eval(Container.DataItem, "UserId")%>&w=32&h=32&d=<%=SessionDomainId %>" onload="OnAvLoad('<%#DataBinder.Eval(Container.DataItem, "ChangeId")%>')"/>
                                                        </td>
                                                        <td style="font-size: 14px; text-align: left; padding-left: 13px;font-weight: 100;text-transform: uppercase; color: #565656;">
                                                            <%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "Action").ToString())%>
                                                        </td>
                                                        <td align="right"><span style=" font-weight:400;" class="sectextcolor"><%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "UserEmail").ToString())%></span></td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                        </td>
                                                        <td colspan="2" style="padding-top: 2px; padding-left: 5px; font-size: 10px; color: #808080;font-weight: 100;">
                                                            <%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "TraceTime").ToString())%> 
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                        </td>
                                                        <td colspan="2" style="padding-top: 3px; padding-bottom: 3px; font-size: 14px; color: #868686;font-weight: 100;
                                                            text-align: center;" align="center">
                                                            <%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "FileName").ToString())%>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td height="10px">&nbsp;
                                                
                                            </td>
                                        </tr>
                                    </ItemTemplate>
                                </asp:Repeater>
                                <tr>
                                    <td align="right" style="font-size: 16px;">
                                        &nbsp;<asp:LinkButton ID="MoreResults" ForeColor="#008000" Style="font-size: 14px;"
                                            runat="server" OnClick="MoreResults_Click"><asp:Localize meta:resourcekey="str_more" runat="server">More...</asp:Localize></asp:LinkButton>
                                    </td>
                                </tr>
                                <asp:Panel ID="EmptyPanel" runat="server" Visible="False">
                                    <tr>
                                        <td align="center" style="font-size: 16px; color: 000040">
                                            <img src="images/empty.png" /><br />
                                            <span class="sectextcolor" style="font-size: 18px;">
                                            <asp:Localize meta:resourcekey="str_norecords" runat="server">No recorded activity</asp:Localize>
                                                </span>
                                        </td>
                                    </tr>
                                </asp:Panel>
                            </table>
                            </div>
                        </td>
                    </tr>
                </table>
                <table width="100%" id="Table1" style="display: none;">
                    <tr>
                        <td style="padding: 5px;">
                            <asp:TextBox ID="TextBox1" Width="100%" runat="server" Height="47px" TextMode="MultiLine"
                                MaxLength="512" Rows="3" CssClass="x-form-field x-form-text" meta:resourcekey="NewCommentsResource1"></asp:TextBox>
                        </td>
                    </tr>
                    <tr>
                        <td align="right">
                            <asp:Button ID="Button3" runat="server" Text="Add" OnClick="AddComment_Click" Width="128px"
                                meta:resourcekey="AddCommentResource1" />
                            <asp:Button ID="Button4" runat="server" Text="Cancel" OnClientClick="StopEditCom();return false;"
                                Width="128px" meta:resourcekey="Button2Resource1" />
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
        <%} %>
        <%if (SessionDisplayMode == 1)
          {%>
        <tr id="managetd">
            <td>
                <table width="100%">
                    <asp:Panel ID="RestorePanel" runat="server">
                        <tr>
                            <td style="border-top: 0px solid #e0e0e0; border-bottom: 1px solid #e0e0e0; padding: 2px;
                                padding-bottom: 2px; align-content: center" align="center">
                                <asp:LinkButton ID="LinkButton3" runat="server" ForeColor="#008000" Style="font-size: 12px;"
                                    OnClick="LinkButton3_Click" OnClientClick="RestoreFolder();return false;">Restore folder (and subfolder) to previous date</asp:LinkButton>
                            </td>
                        </tr>
                    </asp:Panel>
                                                                                <%if (!Impersonated && !SessionIsGuest){ %>
                                                            <%if (!SessionFromClient ){ %>
                                                                <%if (Subscribe.Visible ){ %>
                                                            <tr style="display:none;">
                                                                <td style="border-bottom: 1px solid #e0e0e0; padding: 10px; padding-bottom: 10px;
                                                                    font-size: 12px;">
                                                                    <asp:CheckBox ID="Subscribe" runat="server" Text="&nbsp;I want to receive notification for changes made in this folder (and subfolder)"
                                                                         AutoPostBack="True" OnCheckedChanged="Subscribe_CheckedChanged"
                                                                        meta:resourcekey="SubscribeResource1" />
                                                                </td>
                                                            </tr>
                                                            <%} %>
                                                            <%}else{ %>
                                                            <tr>
                                                                <td style="border-top: 0px solid #e0e0e0; padding: 10px; padding-bottom: 10px; background-color: white;">
                                                                    <asp:LinkButton ID="LinkButton2" runat="server" ForeColor="#008000" Style="font-size: 14px;"
                                                                        OnClick="LinkButton2_Click">Force Refresh</asp:LinkButton>
                                                                </td>
                                                            </tr>
                                                            <%} %>
                                                            <%} %>

                    <tr>
                        <td style="background-color: white;">
                            <table width="100%" align="center" border="0" cellspacing="0" cellpadding="0" class="x-body">
                                <%if (!SessionIsGuest )
                                  { %>
                                <tr>
                                    <td valign="top" style="
                                        <% if (TeamPeerPanel.Visible){ %>
                                        padding: 10px; padding-bottom: 20px;
                                        border-bottom: 1px solid #d0d0d0;
                                        <% }%>
                                           background-color: white;">
                                        
                                        <asp:Panel ID="TeamPeerPanel" runat="server" meta:resourcekey="TeamPeerPanelResource1">
                                            <table width="100%">
                                                <tr>
                                                    <td style="padding: 5px; padding-top: 10px;">
                                                        <table width="100%">
                                                            <tr>
                                                                <td width="32px">
                                                                     <i class="gladinet-icons md-24 md-dark hand center toolbtn" style="display: inline-block; margin-top: -3px;">+</i>
                                                                </td>
                                                                <td style="padding-left: 5px">
                                                                    <asp:Label ID="TeamMemberCount" runat="server" Font-Bold="True" meta:resourcekey="TeamMemberCountResource1"></asp:Label>
                                                                </td>
                                                                <td align="right" style="padding-right: 10px">
                                                                    <a href='#' onclick='SubUserEditPubFolder();return false;' style="font-size: 12px;
                                                                        color: #008000"><span class="gladinet-icons md-18 md-dark hand center toolbtn" title="<%=Localize13.Text %>">/</span>
                                                                        <asp:Localize ID="Localize13" meta:resourcekey="str_edtstr" runat="server" Visible="False">Edit</asp:Localize></a>
                                                                </td>
                                                            </tr>
                                                            <asp:Panel ID="SubUserPermPanel" Visible="False" runat="server">
                                                                <tr>
                                                                    <td colspan="2" class="text-muted">
                                                                        <asp:Localize ID="Localize3" meta:resourcekey="str_click" runat="server">Click</asp:Localize>
                                                                        '<a href='#' onclick='SubUserFolderPerm();return false;' style="font-size: 14px;
                                                                            color: #008000">
                                                                            <asp:Localize ID="Localize4" meta:resourcekey="string5" runat="server">Permissions</asp:Localize></a>'
                                                                        to
                                                                        <asp:Localize ID="Localize5" meta:resourcekey="string6" runat="server">Set folder level permission for your team users.</asp:Localize>
                                                                    </td>
                                                                </tr>
                                                            </asp:Panel>
                                                        </table>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td style="padding-top: 20px;">
                                                        
                                                            <div class="row" style="align-content: center; margin: 0; opacity: 0.85; "  align="center">
                                                                <asp:Repeater ID="TeamMemberRepeater" runat="server">
                                                                    <ItemTemplate>
                                                                        <div class="col-2 col-xs-2 col-sm-2 col-md-2 col-lg-2" >
                                                                            <div title="<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "FirstName").ToString())%> <%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "LastName").ToString())%> - <%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "AbbrevRight").ToString())%> "
                                                                                class="<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "AbbrevClass").ToString())%>"
                                                                                style="background-color: white; border: 1px solid <%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "AbbrevColor").ToString())%>;
                                                                                color: <%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "AbbrevColor").ToString())%>;
                                                                                font-size: 16px; padding-top: 3px;" align="center" valign="middle">
                                                                                <%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "AbbrevName").ToString())%>
                                                                            </div>
                                                                        </div>
                                                                    </ItemTemplate>
                                                                </asp:Repeater>
                                                            </div>
                                                        
                                                    </td>
                                                </tr>
                                            </table>
                                        </asp:Panel>
                                        <asp:Panel ID="TeamFolderPanel" runat="server" meta:resourcekey="TeamFolderPanelResource1">
                                            <table width="100%">
                                                <tr>
                                                    <td style="border-bottom: 0px solid #d0d0d0; padding: 5px; padding-top: 10px;">
                                                        <table width="100%">
                                                            <tr>
                                                                <td width="32px">
                                                                    <i class="gladinet-icons md-24 md-dark hand center toolbtn" style="display: inline-block; margin-top: -3px;">+</i>
                                                                </td>
                                                                <td style="padding-left: 5px">
                                                                    <asp:Label ID="PubFolderCount" runat="server" CssClass="ltitle" meta:resourcekey="PubFolderCountResource1"></asp:Label>
                                                                </td>
                                                                <td align="right" style="padding-right: 10px">
                                                                    <a href='#' onclick='EditPubFolder();return false;' style="font-size: 12px; color: #008000">
                                                                        <span class="gladinet-icons md-18 md-dark hand center toolbtn" title="<%=Localize1.Text %>">/</span>
                                                                        <asp:Localize ID="Localize1" meta:resourcekey="str_edtstr" runat="server" Visible="False">Edit</asp:Localize>
                                                                    </a>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td colspan="3" style="color: #808080;">
                                                                    <asp:Localize ID="Localize2" meta:resourcekey="string4" runat="server" Visible="False">Click 'Edit' to invite team member to collaborate on this folder.</asp:Localize>
                                                                    <asp:Panel ID="PermissionPanel" runat="server" meta:resourcekey="PermissionPanelResource1">
                                                                        <asp:Localize ID="Localize31" meta:resourcekey="str_click" runat="server">Click</asp:Localize>
                                                                        '<a href='#' onclick='FolderPerm();return false;' style="font-size: 14px; color: #008000">
                                                                            <asp:Localize ID="Localize41" meta:resourcekey="string5" runat="server">Permissions</asp:Localize></a>'
                                                                        to
                                                                        <asp:Localize ID="Localize51" meta:resourcekey="string6" runat="server">Set folder level permission for your team users.</asp:Localize>
                                                                    </asp:Panel>
                                                                </td>
                                                            </tr>
                                                        </table>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td style="padding-top: 20px;">
                                                            
                                                            <div class="row" style=" margin: 0; opacity: 0.85;"
                                                                >
                                                                <asp:Repeater ID="PubsRepeater" runat="server">
                                                                    <ItemTemplate>
                                                        
                                                                        <div class="col-2 col-xs-2 col-sm-2 col-md-2 col-lg-2" >
                                                                            <div title="<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "FirstName").ToString())%> <%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "LastName").ToString())%> - <%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "AbbrevRight").ToString())%> "
                                                                                class="<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "AbbrevClass").ToString())%>"
                                                                                style="background-color: white; border: 1px solid <%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "AbbrevColor").ToString())%>;
                                                                                color: <%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "AbbrevColor").ToString())%>;
                                                                                font-size: 16px; padding-top: 3px;" align="center" valign="middle">
                                                                                <%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "AbbrevName").ToString())%>
                                                                            </div>
                                                                        </div>
                                                                            
                                                                    </ItemTemplate>
                                                                </asp:Repeater>
                                                            </div>
                                                        
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td height="30px">&nbsp;
                                                        
                                                    </td>
                                                </tr>
                                            </table>
                                        </asp:Panel>
                                        <asp:Panel ID="QuotaPanel" runat="server" meta:resourcekey="TeamPeerPanelResource1" Visible="False">
                                         <table align="center" >
                                             <tr>
                                                 <td>
                                                     <div class="alert alert-success" style="padding-top: 3px;padding-bottom: 3px; border-radius: 3px; background-color: white; color: #565656; border: 1px dashed #404040; ">
                                                     <asp:Label ID="FolderUsed" runat="server" Text="" CssClass="badge"></asp:Label> of <asp:Label ID="FolderQuota" runat="server" Text="" CssClass="badge"></asp:Label> <asp:Localize meta:resourcekey="str_used" runat="server">used</asp:Localize>
                                                         </div>
                                                 </td>
                                             </tr>
                                            </table>
                                        </asp:Panel>
                                    </td>
                                </tr>
                                <%} %>

                                <%if (!SessionFromClient)
                                  { %>
                                <%if (!SessionIsGuest)
                                  { %>
                                <tr>
                                    <td valign="top" style="padding: 10px; padding-top: 30px; background-color: white;">
                                        <asp:Panel ID="SharesPanel" runat="server" meta:resourcekey="SharesPanelResource1">
                                            <table width="100%">
                                                <tr>
                                                    <td style="border-bottom: 1px solid #d0d0d0; padding: 5px;" colspan="3">
                                                        <table width="100%">
                                                            <tr>
                                                                <td width="32px">
                                                                    <i class="gladinet-icons md-24 md-dark hand center toolbtn" style="display: inline-block; margin-top: -3px;" onclick='OnEdit();return false;' >k</i>
                                                                </td>
                                                                <td style="padding-left: 5px">
                                                                    <asp:Label ID="SharesCount" runat="server" CssClass="ltitle"   meta:resourcekey="SharesCountResource1"></asp:Label>
                                                                </td>
                                                                <td align="right" style="padding-right: 10px">
                                                                    <a href='#' onclick='OnEdit();return false;' style="font-size: 12px; color: #008000">
                                                                        <span class="gladinet-icons md-18 md-dark hand center toolbtn" title="<%=Localize6.Text %>">/</span>
                                                                        <asp:Localize ID="Localize6" meta:resourcekey="str_editstr" runat="server" Visible="False">Edit</asp:Localize>
                                                                    </a>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td colspan="2" style="color: #808080;">
                                                                    <asp:Localize ID="Localize7" meta:resourcekey="string7" runat="server" Visible="False">Click 'Edit' to send links to share with anyone.</asp:Localize>
                                                                </td>
                                                            </tr>
                                                        </table>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td>
                                                        <table width="100%" class="table-striped">
                                                            <asp:Repeater ID="UsersRepeater" runat="server">
                                                                <ItemTemplate>
                                                                    <tr style="color:#808080; font-weight:100;">
                                                                        <td>
                                                                        
                                                                                <%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "UserEmail").ToString())%>
                                                                        
                                                                        </td>
                                                                        <td>
                                                                        
                                                                                Full Control:<%#DataBinder.Eval(Container.DataItem, "CanWrite")%>
                                                                        </td>
                                                                        <td>
                                                                            
                                                                                <%#DataBinder.Eval(Container.DataItem, "DisplayExpireTime")%>
                                                                            
                                                                        </td>
                                                                    </tr>
                                                                </ItemTemplate>
                                                            </asp:Repeater>
                                                        </table>
                                                    </td>
                                                </tr>
                                            </table>
                                        </asp:Panel>
                                    </td>
                                </tr>
                                <tr>
                                    <td valign="top" style="padding: 10px; padding-top: 30px; background-color: white;">
                                        <asp:Panel ID="SyncPanel" runat="server" >
                                            <table width="100%">
                                                <tr>
                                                    <td style="border-bottom: 1px solid #d0d0d0; padding: 5px;" colspan="3">
                                                        <table width="100%">
                                                            <tr>
                                                                <td width="32px">
                                                                    <i class="gladinet-icons md-24 md-dark hand center toolbtn" style="display: inline-block; margin-top: -3px;">`</i>
                                                                </td>
                                                                <td style="padding-left: 5px">
                                                                    <asp:Label ID="SyncLabel" runat="server" CssClass="ltitle"   meta:resourcekey="SharesCountResource1"></asp:Label>
                                                                </td>
                                                                <td align="right" style="padding-right: 10px">
                                                                    <a href='#' onclick='OnAddLink();return false;' style="font-size: 12px; color: #008000">
                                                                        
                                                                        <span class="gladinet-icons md-18 md-dark hand center toolbtn" title="<%=str_link.Text %>">&#xB1;</span>
                                                                            
                                                                        <asp:Localize meta:resourcekey="str_link" id="str_link" runat="server" Visible="False">Link to a local folder</asp:Localize>
                                                                    </a>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td colspan="2" style="color: #808080;">
                                                                </td>
                                                            </tr>
                                                        </table>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td>
                                                        <table width="100%" border="0">
                                                            <asp:Repeater ID="LinkedFolderList" runat="server">
                                                                <ItemTemplate>
                                                                    <tr class='x-grid-row  <%# (Container.ItemIndex % 2 == 0)? "": "x-grid-row-alt" %>'>
                                                                        <td width="32px" align="center" >
                                                                            <i class="gladinet-icons md-24 md-dark hand center toolbtn" onclick='UnlinkFolder("<%#DataBinder.Eval(Container.DataItem, "HostId")%>", "<%#DataBinder.Eval(Container.DataItem, "HostName")%>");return false;' style="<%#DataBinder.Eval(Container.DataItem, "DisplayTrash")%> margin-top: -3px; font-size: 16px;">n</i>
                                                                        </td>
                                                                        <td>
                                                                            <div class="x-grid-cell-inner x-unselectable" style="text-align: left; font-weight: 100 !important; color: #868686;">
                                                                                <%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "HostName").ToString())%>
                                                                            </div>
                                                                        </td>
                                                                        <td>
                                                                            <div class="x-grid-cell-inner x-unselectable" style="text-align: right; font-weight: 100 !important; color: #868686;">
                                                                                <%#DataBinder.Eval(Container.DataItem, "LocalFolder")%></div>
                                                                        </td>
                                                                    </tr>
                                                                </ItemTemplate>
                                                            </asp:Repeater>
                                                        </table>
                                                    </td>
                                                </tr>
                                            </table>
                                        </asp:Panel>
                                    </td>
                                </tr>
                                <%} %>
                                <%if(!IsServo && !m_NotSupported) { %>
                                <tr>
                                    <td style="background-color: white; padding-top: 20px;">
                                        <div class="panel-group">
                                            <div class="panel panel-default" style="background-color: white; border: 0px; box-shadow: 0px 0px 1px #a0a0a0!important;">
                                                <div style="background-color: white; border: 0px; padding-right: 20px; color: #008000;
                                                    font-size: 14px;">
                                                    <h4 class="panel-title" align="right">
                                                        <a data-toggle="collapse" href="#collapse1"><span class="gladinet-icons md-18 md-dark hand center toolbtn"
                                                            style="font-size: 18px;" title="<asp:Localize meta:resourcekey="str_mor" runat="server">More</asp:Localize>">&#xD8;</span></a>
                                                    </h4>
                                                </div>
                                                <div id="collapse1" class="panel-collapse collapse">
                                                    <div class="panel-body" style="background-color: white; border: 0px;overflow-y: auto;height:calc(100vh - 390px);">
                                                        <table width="100%">
                                                            <%if (!Impersonated && !SessionIsGuest && !m_ReadOnlyCookie)
                                                              { %>
                                                            <tr>
                                                                <td style="border-bottom: 1px solid #e0e0e0; padding: 10px; padding-bottom: 10px;">
                                                                    <table width="100%" id="desc_display">
                                                                        <tr style="vertical-align:top;">
                                                                            <td width="80px">
                                                                                <strong>
                                                                                    <asp:Localize ID="Localize8" meta:resourcekey="string1" runat="server">Description</asp:Localize></strong>:
                                                                            </td>
                                                                            <td style="border-bottom:0px solid #A0A0A0;font-weight:100;white-space:pre-wrap;white-space:-moz-pre-wrap;white-space:-pre-wrap;white-space:-o-pre-wrap;word-wrap:break-word;max-width:150px;padding-left:5px;" title="<%:Server.HtmlEncode((Description.Text.Trim().Length > 120) ? Description.Text.Trim() : "")%>"><%:GetShortString(Description.Text.Trim(), 120)%></td>
                                                                            <td style="text-align:right;">
                                                                                <a href="#" onclick="StartEditDesc();return false;" style="font-size: 12px; color: #008000">
                                                                                    <asp:Localize ID="Localize9" meta:resourcekey="string2" runat="server">Edit</asp:Localize></a>
                                                                            </td>
                                                                        </tr>
                                                                    </table>
                                                                    <table width="100%" id="desc_change" style="display: none">
                                                                        <tr>
                                                                            <td width="80px">
                                                                                <strong>
                                                                                    <asp:Localize ID="Localize10" meta:resourcekey="string3" runat="server">Description</asp:Localize></strong>:
                                                                            </td>
                                                                            <td style="border-bottom: 0px solid #A0A0A0">
                                                                                <asp:TextBox ID="Description" Width="100%" runat="server" Height="25px" MaxLength="255"
                                                                                    CssClass="x-form-field x-form-text" meta:resourcekey="DescriptionResource1"></asp:TextBox>
                                                                            </td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td colspan="2" style="padding-left: 10px; padding-top: 10px" align="right">
                                                                                <asp:Button ID="UpdateDesc" runat="server" Text="Update" Width="60px" OnClick="UpdateDesc_Click"
                                                                                    meta:resourcekey="UpdateDescResource1" />
                                                                                <asp:Button ID="Button1" runat="server" Text="Cancel" Width="60px" OnClientClick="StopEditDesc();return false"
                                                                                    meta:resourcekey="Button1Resource1" />
                                                                            </td>
                                                                        </tr>
                                                                    </table>
                                                                </td>
                                                            </tr>
                                                            <%} %>
                                                            <% if(!m_dontShowComments && !IsServo) { %>
                                                            <tr>
                                                                <td valign="top" style="padding: 10px; padding-top: 30px; background-color: white;">
                                                                    <table width="100%">
                                                                        <tr>
                                                                            <td style="border-bottom: 1px solid #d0d0d0; padding: 5px;" colspan="3">
                                                                                <table width="100%">
                                                                                    <tr>
                                                                                        <td>
                                                                                            <b>
                                                                                                <asp:Localize ID="Localize11" meta:resourcekey="string8" runat="server">Comments</asp:Localize></b>:
                                                                                        </td>
                                                                                        <td align="right">
                                                                                            <%if (!m_ReadOnlyCookie)
                                                                                              { %>
                                                                                            <a href="#" onclick="StartEditCom();return false;" style="font-size: 12px; color: #008000">
                                                                                                <asp:Localize ID="Localize12" meta:resourcekey="string9" runat="server">Add Comment</asp:Localize></a>
                                                                                            <%} %>
                                                                                        </td>
                                                                                    </tr>
                                                                                </table>
                                                                                <table width="100%" id="com_change" style="display: none;">
                                                                                    <tr>
                                                                                        <td style="padding: 5px;">
                                                                                            <asp:TextBox ID="NewComments" Width="100%" runat="server" Height="47px" TextMode="MultiLine"
                                                                                                MaxLength="512" Rows="3" CssClass="x-form-field x-form-text" meta:resourcekey="NewCommentsResource1"></asp:TextBox>
                                                                                        </td>
                                                                                    </tr>
                                                                                    <tr>
                                                                                        <td align="right">
                                                                                            <asp:Button ID="AddComment" runat="server" Text="Add" OnClick="AddComment_Click"
                                                                                                Width="128px" meta:resourcekey="AddCommentResource1" />
                                                                                            <asp:Button ID="Button2" runat="server" Text="Cancel" OnClientClick="StopEditCom();return false;"
                                                                                                Width="128px" meta:resourcekey="Button2Resource1" />
                                                                                        </td>
                                                                                    </tr>
                                                                                </table>
                                                                            </td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td valign="top">
                                                                                <table width="100%" border="0" align="center">
                                                                                    <asp:Repeater ID="CommentsReapter" runat="server">
                                                                                        <ItemTemplate>
                                                                                            <tr>
                                                                                                <td colspan="2" style="padding-top: 10px; font-size: 14px;max-width:430px;overflow-wrap:break-word">
                                                                                                    <%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "Comment").ToString())%>
                                                                                                </td>
                                                                                            </tr>
                                                                                            <tr>
                                                                                                <td style="padding-top: 1px; color: #404040; font-size: 10px; border-bottom: 1px solid #e0e0e0">
                                                                                                    <%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "User").ToString())%>
                                                                                                </td>
                                                                                                <td style="padding-top: 1px; color: #404040; font-size: 8px; border-bottom: 1px solid #e0e0e0;text-align:right;">
                                                                                                    <%#DataBinder.Eval(Container.DataItem, "Time")%>
                                                                                                </td>
                                                                                            </tr>
                                                                                        </ItemTemplate>
                                                                                    </asp:Repeater>
                                                                                </table>
                                                                            </td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td>&nbsp;
                                                                                
                                                                            </td>
                                                                        </tr>
                                                                    </table>
                                                                </td>
                                                            </tr>

                                                            <%}%>


                                                            <%}%>
                                                        </table>
                                                    </div>
                                                    <div class="panel-footer">
                                                        &nbsp;</div>
                                                </div>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                                <%} %>
                            </table>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
        <%} %>
    </table>
    <%if (SessionDisplayMode == 2)
      {%>
    <table width="100%">
        <tr>
            <td style="font-size: 12px"><asp:Localize runat="server" meta:resourcekey="str_Tag">Tags:</asp:Localize></td>
            <td align="right">
                <asp:LinkButton ID="EditTag" runat="server" ForeColor="#008000" OnClientClick="StartEditTag();return false;">Edit</asp:LinkButton>
            </td>
        </tr>
        <tr>
            <td colspan="2">
                <div id="TagDisplay">
                    <asp:Label ID="Tags" runat="server" Text="" ForeColor="#008000" Font-Size="12px">None</asp:Label>
                </div>
                <div id="TagEdit" class="checkout3" style="display: none; width: 100%;">
                    <table width="100%">
                        <tr>
                            <td>
                                <asp:TextBox ID="NewTag" runat="server" Width="95%"></asp:TextBox>
                            </td>
                        </tr>
                        <tr>
                            <td align="right" style="padding: 5px;">
                                <asp:Button ID="SaveEdit" runat="server" meta:resourcekey="str_sav" Text="Save" OnClick="SaveEdit_Click" /><asp:Button
                                    ID="CancelEdit" runat="server" OnClientClick="CancelEditTag();return false;"
                                    meta:resourcekey="str_can" Text="Cancel" />
                            </td>
                        </tr>
                    </table>
                </div>
            </td>
        </tr>
        <tr>
            <td colspan="2" style="height: 10px;">&nbsp;
                
            </td>
        </tr>
        <tr>
            <td style="border-bottom: 1px solid #e0e0e0"><asp:Localize runat="server" meta:resourcekey="str_Pol">Policies</asp:Localize></td>
            <td align="right" style="border-bottom: 1px solid #e0e0e0">
                <asp:LinkButton ID="LinkButton1" runat="server" ForeColor="#008000" OnClientClick="parent.parent.OnAddPolicy();return false;">Add</asp:LinkButton>
            </td>
        </tr>
        <tr>
            <td valign="top" colspan="2" align="center">
                <table width="100%" border="0" align="center">
                    <asp:Repeater ID="PolicyRepeater" runat="server">
                        <ItemTemplate>
                            <tr>
                                <td style="padding-top: 1px; color: #404040; font-size: 12px;">
                                    <%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "PolicyName").ToString())%>
                                </td>
                                <td style="padding-top: 1px; color: #404040; font-size: 12px;">
                                    <%#DataBinder.Eval(Container.DataItem, "PolicyType")%>
                                </td>
                            </tr>
                            <tr>
                                <td colspan="2" style="padding-top: 8px; font-size: 8px; border-bottom: 1px solid #e0e0e0">
                                    <%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "PolicyDescription").ToString())%>
                                </td>
                            </tr>
                        </ItemTemplate>
                    </asp:Repeater>
                </table>
            </td>
        </tr>
    </table>
    <%} %>
    <table width="100%" style="display: none">
        <tr>
            <td align="center">
                <asp:Label ID="FullPath" runat="server" Width="90%" Visible="" Font-Size="12px" meta:resourcekey="FullPathResource1"></asp:Label>
            </td>
        </tr>
    </table>
    <div style="display: none">
        <asp:Button ID="ShowActivities" runat="server" Text="Act" OnClick="ShowActivities_Click" />
        <asp:Button ID="ShowTeam" runat="server" Text="Team" OnClick="ShowTeam_Click" />
        <asp:Button ID="ShowPolicy" runat="server" Text="Policy" OnClick="Button5_Click" />
        <asp:Localize meta:resourcekey="str_trashcan" ID="StrTrashCan" runat="server">Trash Can</asp:Localize>
        <asp:Localize meta:resourcekey="str_daysgao" ID="StrDaysAgo" runat="server"> Days ago</asp:Localize>
        <asp:Localize meta:resourcekey="str_hoursago" ID="StrHoursAgo" runat="server"> Hours ago</asp:Localize>
        <asp:Localize meta:resourcekey="str_minsago" ID="StrMinsAgo" runat="server"> Minutes ago</asp:Localize>
        <asp:Localize meta:resourcekey="str_lessmin" ID="StrLessMin" runat="server">Less than 1 minute ago</asp:Localize>
        <asp:Localize meta:resourcekey="str_renamed" ID="StrRenamed" runat="server" Visible="False">renamed</asp:Localize>
        <asp:Localize meta:resourcekey="str_upload" ID="StrUpload" runat="server" Visible="False">uploaded file </asp:Localize>
        <asp:Localize meta:resourcekey="str_delete" ID="StrDelete" runat="server" Visible="False">deleted file </asp:Localize>
        <asp:Localize meta:resourcekey="str_setPrm" ID="StrSetPrm" runat="server" Visible="False">set permissions </asp:Localize>
           <asp:Localize meta:resourcekey="str_access" ID="StrAccess" Visible="False" runat="server">access file</asp:Localize>
           <asp:Localize meta:resourcekey="str_updTemFld" ID="StrUpdTemFld" Visible="False" runat="server">update team folder</asp:Localize>
        <asp:Localize meta:resourcekey="str_createfolder" ID="StrCreateFolder" runat="server">created folder </asp:Localize>
        <asp:Localize meta:resourcekey="str_addcomments" ID="StrAddComment" runat="server">add comment</asp:Localize>
        <asp:Localize meta:resourcekey="str_you" ID="StrYou" runat="server">You</asp:Localize>
         <asp:Localize meta:resourcekey="str_me" ID="StrMe" runat="server" Visible="False">ME</asp:Localize>
        <asp:Localize meta:resourcekey="str_deletefolder" id="str_deletedfolder" Visible="False" runat="server">deleted folder</asp:Localize>
        <asp:Button runat="server" Text="Button" id="UnlinkBtn" OnClick="UnlinkBtn_Click"></asp:Button><asp:HiddenField ID="DeviceId" runat="server" />
        <asp:Localize meta:resourcekey="StrMoveFolder" id="StrMoveFolder" runat="server">Moved Folder</asp:Localize>
        <asp:Localize meta:resourcekey="StrCopyFolder" id="StrCopyFolder" runat="server">Copied Folder</asp:Localize>
    </div>
    
    <script type="text/javascript">
        

        var e = document.getElementById("MainContentDiv");
        e.style.backgroundColor = "white";

        try {

            if (parent.parent.gEmbedded == "true") {
                e = document.getElementById("TitleTR");
                e.style.display = "none";

            }
        } catch (p) {

        }
    </script>
</asp:Content>
