﻿<%@ Page Title="Publish Folder" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="AddPubPage.aspx.cs" Inherits="GladinetPayFlow.AddPubPage"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">

    <style type="text/css">
         .gridobject{

         }
         li a,
li a:after,
 li a:before {
  transition: all .5s;
}
li a:hover {
  color: #555;
}
         .ripple{
             overflow:hidden;
         }

        .ripple-effect{
            position: absolute;
            border-radius: 50%;
            width: 50px;
            height: 50px;
            background: white;

    
            animation: ripple-animation 2s;
        }


        @keyframes ripple-animation {

            from {
                transform: scale(1);
                opacity: 0.4;
            }
            to {
                transform: scale(100);
                opacity: 0;
            }
        }
        td {
            font-size: 14px;
            font-family: Verdana,sans-serif;
            font-weight: 100;
        }

        b {
            font-weight: 500;
        }


        .fadeindiv {
            transition-property: display;
             transition-duration: 5.5s;
             transition-timing-function: linear;
        }
        .titlecol {
            background-color: white;
            font-size: 14px;
        }

        .btndelete {
            width: 36px;
        }

        

        .whitehead {
            background-color: white !important;
        }

        .tentu {
            padding-bottom: 10px !important;
        }
        .wrapper {
            padding: 0px;
            background-color: white;
            margin: 0 auto -69px; /* the bottom margin is the negative value of the footer's height */
        }

        .footer, .push {
            height: 68px; /* .push must be the same height as .footer */
        }

        #data_grid .x-grid-cell {
            font-size: 12px;
            font-family: tahoma,arial,verdana,sans-serif;
            font-weight: 200;
        }

        .x-body {
            font-size: 12px;
        }

        .x-panel-header-text-default {
            color: #333333;
            font-family: tahoma,arial,verdana,sans-serif;
            font-size: 11px;
            font-weight: bold;
            line-height: 17px;
        }

        #data_grid .x-grid-row {
            font-size: 8pt !important;
            font-weight: bold !important;
            height: 10px;
        }


        .btnbig {
            font-size: 16px !important;
        }

        

       

        .x-grid-header-ct {
            border: 0px solid #c0c0c0;
        }

        .x-grid-header-ct .x-box-inner {
            border-bottom: 0px solid #c0c0c0;
        }

        .x-grid-header-ct .x-box-inner .x-column-header-inner {
            border-right: 0px solid #000;
            border-left: 0px solid #000;
            font-weight: 100;
            font-size: 18px;
        }


        .readonly
        {
            border-style: dotted !important;
            border-color: #cccccc;
            border-width: 1px;
            border-radius: 8px;
        }
        
        .readwrite
        {
            border-style: solid;
            border-color: #cccccc;
            border-width: 1px;
            border-radius: 8px;
        }
        
        .owner
        {
            border-style: solid;
            border-color: #808080;
            border-width: 1px;
            border-radius: 8px;
        }

        .uncommited{
            border-style: dotted !important;
            border-color: #ff8f00;
            border-width: 1px;
            border-radius: 8px;
        }
        .gladdropdownlink .fa.fa-plus-square::before{
            content: "\f146";/*minus sign*/
        }
        .gladdropdownlink.collapsed .fa.fa-plus-square::before{
            content: "\f0fe";/*plus sign*/
        }
    </style>
    <script type="text/javascript">
        var UserCount = 0;
        var grid;
        <%if (m_AclList != null)
        { %>
        UserCount = <%=m_AclList.Count%>;
        <%} %>
        
        function CloseQuickWindow(u, t)
        {
            try{
                var e = document.getElementById("ShortWindow");
                e.src = "/portal/WaitWin.htm";

            }catch(ee){

            }
            try{
                $('#ShortWindowModal').modal('hide');
                
            }catch(e){

            }

        }

        function OpenQuickWindow(u, t)
        {
            if(parent.OpenQuickWindow){
               parent.OpenQuickWindow(u,t);
                return;
            }
            var e = document.getElementById("ShortTitle");
            e.innerHTML = "&nbsp;&nbsp;";

            e = document.getElementById("ShortBody");            
            if(document.documentElement.clientHeight<750)
                e.style.height = "500px"
            else
                e.style.height = "600px"

            e = document.getElementById("ShortWindow");
            e.src = u;
            $('#ShortWindowModal').modal({ backdrop: 'static', keyboard: false });

        }
        function LocalOpenQuickWindow(u, t)
        {
            var e = document.getElementById("ShortTitle");
            e.innerHTML = "&nbsp;&nbsp;";

            e = document.getElementById("ShortBody");            
            if(document.documentElement.clientHeight<750)
                e.style.height = "500px"
            else
                e.style.height = "600px"

            e = document.getElementById("ShortWindow");
            e.src = u;
            $('#ShortWindowModal').modal({ backdrop: 'static', keyboard: false });

        }

        function OpenSelfQuickWindow(u, t)
        {
            
            var e = document.getElementById("ShortTitle");
            e.innerHTML = "&nbsp;&nbsp;";

            e = document.getElementById("ShortBody");            
            if(document.documentElement.clientHeight<750)
                e.style.height = "500px"
            else
                e.style.height = "600px"

            e = document.getElementById("ShortWindow");
            e.src = u;
            $('#ShortWindowModal').modal({ backdrop: 'static', keyboard: false });

        }

        function AddFolder() {
            LocalOpenQuickWindow("/management/AddWorkSpaceFolder.aspx?tid=<%=PubFolderId.Value%>&vdid=<%=SessionDomainId%>", "Add Folder");
        }
        
        function Toggle(name) {
            var d = document.getElementById(name);
            if (d.style.display == 'none')
                d.style.display = 'block';
            else
                d.style.display = 'none';
        }

        function TogglePubUser() {
            var d = document.getElementById("pubusers");
            var t = document.getElementById("pubusersc");
            if (d.style.display == 'none') {
                d.style.display = 'block';
                t.style.height = "350px";
            } else {
                t.style.height = "350px";
                d.style.display = 'none';
            }
        }
        function UnlinkFolder(did,dname) {
            var b = document.getElementById("MainContent_UnlinkBtn");
            var d = document.getElementById("MainContent_DeviceId");
            
        
            gConfirm("<asp:Localize meta:resourcekey="str_uhint" runat="server">Unlink the folder from device:</asp:Localize>"+dname+"?", "", function() {


                d.value = did;
                b.click();

            });
            
        }

        function RemoveFolder(name)
        {
            var b = document.getElementById("MainContent_RemoveFolder");
            var d = document.getElementById("MainContent_DeviceId");
            
        
            gConfirm("Do you want to remove folder: "+name+"?", "", function() {


                d.value = name;
                b.click();

            });

        }
        function RenameFolder(fldIdx) 
        {
            var fldName = $("#folderRepeaterName_"+fldIdx).html().trim();
            var fldPath = $("#folderRepeaterValue_"+fldIdx).html().trim();
            $("#inpNewName").val(fldName); 
            $("#inpOldName").val(fldName); 
            $("#inpRptIdx").val(fldIdx); 
            
            $('#RenameModel').modal({ backdrop: 'static', keyboard: false });
        }

        function ApplyRenameFolder()
        {
            var indx = $("#inpRptIdx").val(); 
            var btn = $("#<%=btnRenameFolder.ClientID%>");
            var oldVal = $("#inpOldName").val();
            var newVal = $("#inpNewName").val();
            if(oldVal!=newVal){
                $("#<%=OldFolderName.ClientID%>").val($("#inpOldName").val());
                $("#<%=NewFolderName.ClientID%>").val($("#inpNewName").val());
                $("#<%=NewFolderPath.ClientID%>").val($("#folderRepeaterValue_"+indx).html().trim());
                btn[0].click();
            }else{
                $('#RenameModel').modal("hide");
            }
        }

        function ScanlinkFolder(did, dname){
            var ShareId = XSSDecode("<%=XSSUrlEncode(TopFolderName.Value)%>");
            var uri = "/management/DeviceSyncScan.aspx?nr=1&f=c&id="+did;            
            uri += "&name=";

            uri += gEncodeUri(ShareId.replace("%27", "'"));
            
 var url = "<iframe id='sync_perm_window_wiz' src='";
    url +=uri;
    url += "' scrolling='auto' style='width:100%;height:100%;margin:0;padding:0;border:0;'></iframe>";
    activewin = new Ext.Window({
        id: 'sync_perm_win',
        title: "Sync scan"+ " - <%=TopFolderName.Value%>",
        width: 1080,
        height: maxh(660),
        plain: true,
        modal: true,
        maximizable: false,
        maximized: false,
        layout: 'fit',
        bodyPadding: 0,
        html: url,
        defaults: {
            border: false
        }
    });
   
    activewin.show();
        }
                function OnAddLink() {
            var ShareId = XSSDecode("<%=XSSUrlEncode(TopFolderName.Value)%>");
            var uri = "/management/adduserwizard/SelectDevice.aspx?src=filebrowser&w=quickwin&vdid=<%=SessionDomainId%>&folder=";            
            uri += "&location=";

            uri += gEncodeUri(ShareId.replace("%27", "'"));
                     OpenQuickWindow(uri,"<asp:Localize meta:resourcekey="str_addlink" runat="server">Add Link</asp:Localize>"+ " - <%=TopFolderName.Value%>");
            return;
            
 var url = "<iframe id='sync_perm_window_wiz' src='";
    url +=uri;
    url += "' scrolling='auto' style='width:100%;height:100%;margin:0;padding:0;border:0;'></iframe>";
    activewin = new Ext.Window({
        id: 'sync_perm_win',
        title: "<asp:Localize meta:resourcekey="str_addlink" runat="server">Add Link</asp:Localize>"+ " - <%=TopFolderName.Value%>",
        width: 1080,
        height: maxh(660),
        plain: true,
        modal: true,
        maximizable: false,
        maximized: false,
        layout: 'fit',
        bodyPadding: 0,
        html: url,
        defaults: {
            border: false
        }
    });
   
    activewin.show();
           
        }


    function SyncPermShare() {
        
            
            var url = "/management/adduserwizard/SyncPermsWelcome.aspx?sid=";
                url += "<%=PubFolderId.Value%>";
               url += "&l=" + "<%=LocalDirLoc.Value.Replace("&amp;", "|").Replace("&", "|")%>";
            url += "&h=" + "<%=BackendHostId.Value%>";
            url += "&vdid=" + "<%=SessionDomainId%>";
            OpenQuickWindow(url,"<%=str_syncperm.Text %>");
        }

        function ToggleUIInfo(id) {
            var e1 = document.getElementById("p_" + id);
            if (e1.style.display == "none")
                HideUInfo(id);
            else
                ShowUInfo(id);
        }
        function ShowUInfo(id) {
            var e1 = document.getElementById("p_" + id);
            var e2 = document.getElementById("info_" + id);

            e1.style.display = "none";
            e2.style.display = "";

            e1 = document.getElementById("sui_" + id);
            e1.className = "fa fa-remove secpaneltextcolor";
        }
        function HideUInfo(id) {
            var e1 = document.getElementById("p_" + id);
            var e2 = document.getElementById("info_" + id);

            e2.style.display = "none";
            e1.style.display = "";
            e1 = document.getElementById("sui_" + id);
            e1.className = "fa fa-edit secpaneltextcolor";
            
        }

        function RemoveUser(id) {
            ShowSavePanel();
            var e1 = document.getElementById("m_" + id);
            e1.parentNode.removeChild(e1);
        }

         
        function OnIconView() {
            Wait("Please wait...");
            var btn = document.getElementById('MainContent_IconViewBtn');
            btn.click();
        }

        function OnListView() {
            Wait("Please wait...");
            var btn = document.getElementById('MainContent_ListViewBtn');
            btn.click();

        }
        function OnCommit() {
            Wait("Please wait...");
            var btn = document.getElementById('MainContent_Commit');
            btn.click();
            
        }

        function OnSaveChanges() {            
            Wait("Please wait...");
            var btn = document.getElementById('MainContent_PublishNow');
            btn.click();

        }
        function OnCancelChanges() {
            //window.location = window.location;
            OnRefresh();
        }

        function ClearErrorMsg() {

            var d = document.getElementById("errmsgdiv");
            if (d) {
                d.style.display = 'none';
            }
        }
        

        function OnSelFolder() {
            var d = document.getElementById("SelFolderControl");

            d.style.display = 'block';
            d.style.left = (document.body.offsetWidth - 550) / 2  + "px";
            d.style.top = "0px";
        }

        var folder = "";
        function setcurfoldersel(f) {
            folder = f;
        }

        function OnAvLoad(id) {
            
            var i = document.getElementById("i_" + id);
            if (i.width == 1 )
                return;
           
            i.style.display = "";
            var e = document.getElementById("av_" + id);
            e.style.display = "none";
        }


        function setfoldercursel() {
            cancelfoldercursel();
            var d = document.getElementById("MainContent_Location");
            d.value = "/" + folder;
            // now look for share name, remove all slash, keep the last part, if last part is empty, change it to PublishFolder

            var indexSlash = folder.lastIndexOf("/");
            var ShareName = folder;
            if (indexSlash >= 0) {
                if ((indexSlash + 1) < folder.length) {
                    ShareName = folder.substring(indexSlash + 1);
                } else {
                    ShareName = "<asp:Localize meta:resourcekey="js_publish_folder" runat="server">Publish Folder</asp:Localize>";
                }
            }
            var e = document.getElementById("MainContent_ShareName");
            e.value =  ShareName;
        }
        function cancelfoldercursel() {
            var d = document.getElementById("SelFolderControl");

            d.style.display = 'none';

        }
        function OnRefresh() {
            Wait("<asp:Localize meta:resourcekey="str_rlg" runat="server">Reloading...</asp:Localize>");
            var b = document.getElementById("MainContent_RefreshCurPage");
            b.click();
           
        }
        var activewin;
        function closeCancelActiveWin() {
        
            OnRefresh();
        }


        function OnCancelPub() {
            parent.closeActiveWin();
        }

        function OnAddUser() {
            OpenQuickWindow("SelectUser.aspx", "<asp:Localize meta:resourcekey="js_create_new_user" runat="server">Create New User</asp:Localize>");
            return;
            activewin = new Ext.Window({
                id: 'pubs_win',
                title: "<asp:Localize meta:resourcekey="js_create_new_user" runat="server">Create New User</asp:Localize>",
                width: 1000,
                height: maxh(600),
                plain: true,
                modal: true,
                maximizable: true,
                constrain: true,
                maximized: true,
                header: false,
                layout: 'fit',
                bodyPadding: 3,
                html: "<iframe id='openwin' src='SelectUser.aspx' scrolling='auto' style='width:100%;height:100%;margin:0;padding:0'></iframe>",
                defaults: {
                    border: false
                }
            });
            activewin.show();



        }
            function MigrateStorage(){
                window.location = '/management/AddTeamFolderStorageMigrateTask.aspx?f=' + gEncodeUri('<%=BackendFolderName.Value.Replace("'","\\'")%>') + '&vdid=<%=SessionDomainId%>';
            }

            function EditCloudStorage() {
                
                OpenSelfQuickWindow('/management/SelectProvider.aspx?s=1&f=' + gEncodeUri('<%=BackendFolderName.Value.Replace("'","\\'")%>') + '&vdid=<%=SessionDomainId%>', "<%= str_sss.Text %>");
                return;
            try {
                activewin = new Ext.Window({
                    id: 'pubs_win1',
                    title: "<%= str_sss.Text %>",
                    preventHeader: true,
                    width: 1000,
                    height: maxh(700),
                    plain: true,
                        
                    maximizable: true,
                       
                    maximized: false,
                        
                       
                    bodyPadding: 0,
                    html:
                        "<iframe id='openwin1' src='/management/SelectProvider.aspx?f=" + gEncodeUri('<%=BackendFolderName.Value.Replace("'","\\'")%>') + "&vdid=<%=SessionDomainId%>' scrolling='auto' style='width:100%;height:100%;margin:0;padding:0; border:0px;'></iframe>",
                    defaults: {
                        border: false,
                        header: false
                    }
                });

                activewin.show();
            } catch (e) {
                alert(e);
            }
        }

        function EditStorage() {
            OpenQuickWindow('/management/AddLocalStorage.aspx?s=1&f=' + gEncodeUri('<%=BackendFolderName.Value.Replace("'","\\'")%>') + '&vdid=<%=SessionDomainId%>' , "<%= str_sss.Text %>");
            return;

            try {
                activewin = new Ext.Window({
                    id: 'pubs_win1',
                    title: "<%= str_sss.Text %>",
                    preventHeader: true,
                    width: 1000,
                    height: maxh(700),
                    plain: true,
                        
                    maximizable: true,
                       
                    maximized: false,
                        
                       
                    bodyPadding: 0,
                    html:
                        "<iframe id='openwin1' src='/management/AddLocalStorage.aspx?f=" + gEncodeUri('<%=BackendFolderName.Value.Replace("'","\\'")%>') + "&vdid=<%=SessionDomainId%>' scrolling='auto' style='width:100%;height:100%;margin:0;padding:0; border:0px;'></iframe>",
                    defaults: {
                        border: false,
                        header: false
                    }
                });

                activewin.show();
            } catch (e) {
                alert(e);
            }
        }

        function gEncodeUri(str) {
            return str.replace(/&/g, '%26').replace(/#/g, '|').replace('+', ':').replace(/'/g, '%27');
        }
        function GetSanitizedLocation(){
            console.log("GetSanitizedLocation",gEncodeUri(XSSDecode("<%=XSSUrlEncode(Location.Text) %>")) )
            return gEncodeUri(XSSDecode("<%=XSSUrlEncode(Location.Text) %>"));
        }

        function GetPermsSanitizedLocation(){
            console.log("GetPermsSanitizedLocation",gEncodeUri(XSSDecode("<%=XSSUrlEncode(FolderPermLoc.Value) %>")) )
            return gEncodeUri(XSSDecode("<%=XSSUrlEncode(FolderPermLoc.Value) %>"));
        }
        function OnClickPerm() {
            window.location = "/portal/folderperms.aspx?location=" + GetPermsSanitizedLocation() +"&vdid=<%=SessionDomainId %>";
        }

        function SelectUser() {
            
            try {
                if (parent.parent.OnSelectUser) {
                 
                 
                    parent.parent.OnSelectUserWithDomain('<%=SessionDomainId %>');
                    return;
                }
            } catch (e) {
                
            }


            
            
            parent.OnSelectUserWithDomain('<%=SessionDomainId %>');
            

        }

        function SelectSAGroup() {
            try {
                <%if (!string.IsNullOrEmpty(PageReturnUrl))
        { %>
                parent.parent.CurrentActiveIFrame = "main_body";
                <%}%>
            } catch (e) {
                
            }

            parent.parent.OnSvrAgentGroup();

        }
        function SelectLDAPUser() {

            try {
                if (parent.parent.OnLDAPSelectUserWithDomain) {
                    <%if (!string.IsNullOrEmpty(PageReturnUrl))
        { %>
                    parent.parent.CurrentActiveIFrame = "main_body";
                    <%}%>

                    parent.parent.OnLDAPSelectUserWithDomain('<%=SessionDomainId %>');
                    return;
                }
            } catch (e) {
                
            }

            <%if (!string.IsNullOrEmpty(PageReturnUrl))
        { %>
            parent.CurrentActiveIFrame = "main_body";
                  <%}%>

            parent.OnLDAPSelectUserWithDomain('<%=SessionDomainId %>');
            

        }
        function DeletePubNow() {
            var b = document.getElementById("MainContent_DeleteNow");
            
        
            gConfirm("<asp:Localize  meta:resourcekey="js_string5" runat="server" >Confirm deletion. this will remove the storage/team folder, but data will not be purged.</asp:Localize>", "", function() {
               
                      
               
                b.click();

            });
        }
        function folderPermsLoadedEvent(){
            var frm = document.getElementById("permframe");
            if(frm.src=="about:blank"){
                document.getElementById("permframe").src = "/portal/FolderPerms.aspx?orig=pub&child=1&src=etf&location=" + GetPermsSanitizedLocation() + "&vdid=<%=SessionDomainId %>";
                var goToTab = $("#<%=hidGoToTab.ClientID%>").val();
                if(goToTab!=""){
                    SetPage(goToTab);
                    $("#<%=hidGoToTab.ClientID%>").val("");
                }
            }
        }
        function SetPage(p, skipReload) {
            var saveButtonOnCollaboratorsIsVisible = $("#SaveBtnDiv").is(":visible");
            var saveButtonOnFolderPermissionsIsVisible = $("#permframe").contents().find("#SaveBtnDiv").is(":visible");

            if(saveButtonOnCollaboratorsIsVisible){
                gConfirm("<asp:Localize  meta:resourcekey="js_savChg" runat="server">Save changes?</asp:Localize>", "", function() {
                    $("#<%=hidGoToTab.ClientID%>").val(p);
                    OnSaveChanges();
                });
                $('#myConfirmModel').on('hidden.bs.modal', function () {
                    $("#SaveBtnDiv").hide();
                    SetPage(p);
                });
                return;
            }
            if(saveButtonOnFolderPermissionsIsVisible){
                gConfirm("<asp:Localize  meta:resourcekey="js_savChg" runat="server">Save changes?</asp:Localize>", "", function() {                    
                    $("#<%=hidGoToTab.ClientID%>").val(p);
                    document.getElementById("permframe").contentWindow.OnSaveChanges();
                });
                $('#myConfirmModel').on('hidden.bs.modal', function () {
                    $("#permframe").contents().find("#SaveBtnDiv").hide();
                    SetPage(p);
                });
                return;
            }
            
            var e = document.getElementById("page_1");
            e.className = "gladtab_lg_inactive";

            if (p == 1) {
                e = document.getElementById("colctrl");
                e.style.display = "";
            } else {
                e = document.getElementById("colctrl");
                e.style.display = "none";
            }

            try {
                e = document.getElementById("page_2");
                e.className = "gladtab_lg_inactive";
            } catch (ee) {
                    
            }

            try {
                e = document.getElementById("page_3");
                e.className = "gladtab_lg_inactive";
            } catch (ee) {
                    
            }
            try {
                e = document.getElementById("page_6");
                e.className = "gladtab_lg_inactive";
            } catch (ee) {
                    
            }

            try {
                e = document.getElementById("page_4");
                e.className = "gladtab_lg_inactive";
            } catch (ee) {
                    
            }
            try {
                e = document.getElementById("page_5");
                e.className = "gladtab_lg_inactive";
            } catch (ee) {
                    
            }
            try {
                e = document.getElementById("page_7");
                e.className = "gladtab_lg_inactive";
            } catch (ee) {
                    
            }
            try {
                e = document.getElementById("page_8");
                e.className = "gladtab_lg_inactive";
            } catch (ee) {
                    
            }
            try {
                e = document.getElementById("page_9");
                e.className = "gladtab_lg_inactive";
            } catch (ee) {
                    
            }
            try {
                e = document.getElementById("page_10");
                e.className = "gladtab_lg_inactive";
            } catch (ee) {
                    
            }
            
            e = document.getElementById("page_" + p);
            e.className = "gladtab_lg_active";


            e = document.getElementById("page_1_div");
            e.style.display = "none";

            try {
                e = document.getElementById("page_2_div");
                e.style.display = "none";
            } catch (ee) {
                    
            }

            try {
                e = document.getElementById("page_3_div");
                e.style.display = "none";
            } catch (e) {
                    
            }
            try {
                e = document.getElementById("page_6_div");
                e.style.display = "none";
            } catch (e) {
                    
            }
            try {
                e = document.getElementById("page_10_div");
                e.style.display = "none";
            } catch (e) {
                    
            }

            try {
                e = document.getElementById("page_4_div");
                e.style.display = "none";
            } catch (e) {
                    
            }
            try {
                e = document.getElementById("page_5_div");
                e.style.display = "none";
            } catch (e) {
                    
            }
            try {
                e = document.getElementById("page_7_div");
                e.style.display = "none";
            } catch (e) {
                    
            }

            try {
                e = document.getElementById("page_8_div");
                e.style.display = "none";
            } catch (e) {
                    
            }

            try {
                e = document.getElementById("page_9_div");
                e.style.display = "none";
            } catch (e) {
                    
            }
            e = document.getElementById("MainContent_CurrentPage");
            e.value = p;
            
            
            
            e = document.getElementById("page_" + p + "_div");
            e.style.display = "";

            if (p == 2) {
                // Folder permissions page
                var prmfrm = document.getElementById("permframe");
                if (prmfrm) {
                    prmfrm.src = prmfrm.src;
                }
            }
            else if (p == 1 || p == 3 || p == 4 || p == 5) {
                if ("1" != skipReload) {
                    // 1: Collaborators page
                    // 3: Settings page
                    // 4: Two-Way Sync page
                    // 5: Storage page
                    window.location.href = "AddPubPage.aspx?v=" + p + "&src=filebrowser&vdid=<%=SessionDomainId%>&location=" + GetSanitizedLocation();
                }
            }
            else if (p == 6) {
                // External sharing page
                try {
                    e = document.getElementById("page_6_div");
                    e.src = "/portal/TeamFolderShares.aspx?child=1&src=browser&tn=<%=PubFolderId.Value %>&folder=true&vdid=<%=SessionDomainId%>&edittenant=1";
                } catch (e) {

                }

            }else if (p == 8){
                try {
                    e = document.getElementById("page_8_div");
                    var location = "<%=PathLoc.Text%>";

                    e.src = "/portal/RestoreFolder.aspx?f="+gEncodeUri(location)+"&vdid=<%=SessionDomainId%>&edittenant=1";
                } catch (e) {

                }

            }
            else if (p == 10){
                // Access policy page
                try {
                    e = document.getElementById("page_10_div");


                    e.src = '/management/AccessPolicy/TFAssignedPolicy.aspx?vdid=<%=SessionDomainId %>&child=1&tid=<%=PubFolderId.Value %>';

                } catch (e) {

                }

            } else if (p == 9) {
                // 9: Backup and restore
                var bkpfrm = document.getElementById("page_9_div");
                if (bkpfrm) {
                    bkpfrm.src = bkpfrm.src;
                }
            }
          
        }
        function EditPerm() {
            var b = document.getElementById("MainContent_EditPerm");
            Wait('...');
            b.click();
        }

        function LoadPerm(k) {
            var b = document.getElementById("MainContent_LoadPerm");
            var f = document.getElementById("MainContent_FolderPermLoc");
            
            f.value = k;
            b.click();
        }

        function ShowSavePanel() {
            var e = document.getElementById("SaveBtnDiv");
            e.style.display = "";
            return false;
        }

        function RestoreFolder() {
            var location = "<%=PathLoc.Text%>";

            OpenQuickWindow("/portal/RestoreFolder.aspx?f="+gEncodeUri(location)+"&vdid=<%=SessionDomainId%>&edittenant=1","Restore Folder");
        }
        var _resizing = false;
        document.onmousemove = function(event) {
            if(_resizing){
                var xPos = event.pageX;
                console.log("track "+event.pageX);
                document.getElementById("col1").style.width = xPos-20 +"px";
            }
        };
        document.onmouseup = function(event) {
            _resizing = false;
        };
        function startResizing(event){
            _resizing = true;
        }
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
    <input id="hidGoToTab" type="hidden" value="" runat="server" />
<asp:Localize ID="LocS3GovCloWes" meta:resourcekey="str_s3GovCloWes" runat="server" Visible="False">S3 Gov Cloud West</asp:Localize>
<asp:Localize ID="LocS3GovCloEas" meta:resourcekey="str_s3GovCloEas" runat="server" Visible="False">S3 Gov Cloud East</asp:Localize>
<asp:Localize ID="LocOpe" meta:resourcekey="str_ope" runat="server" Visible="False">OpenStack</asp:Localize>
<asp:Localize ID="LocWinAzu" meta:resourcekey="str_winAzu" runat="server" Visible="False">Windows Azure</asp:Localize>
<asp:Localize ID="LocNir" meta:resourcekey="str_nir" runat="server" Visible="False">Nirvanix</asp:Localize>
<asp:Localize ID="LocEMCATM2" meta:resourcekey="str_eMCATM2" runat="server" Visible="False">EMC ATMOS 2</asp:Localize>
<asp:Localize ID="LocMicOne" meta:resourcekey="str_micOne" runat="server" Visible="False">Microsoft OneDrive</asp:Localize>
<asp:Localize ID="LocGooDri" meta:resourcekey="str_gooDri" runat="server" Visible="False">Google Drive</asp:Localize>
<asp:Localize ID="LocWeb" meta:resourcekey="str_web" runat="server" Visible="False">WebDAV</asp:Localize>
<asp:Localize ID="LocSha" meta:resourcekey="str_sha" runat="server" Visible="False">SharePoint</asp:Localize>
<asp:Localize runat="server" ID="LocCanPubRooFol" meta:resourcekey="str_canPubRooFol" Visible="false">Can't publish root folder</asp:Localize>
<asp:Localize runat="server" ID="LocTheTeaFolCanConTheKeyWorTeaFol" meta:resourcekey="str_theTeaFolCanConTheKeyWorTeaFol" Visible="false">The team folder cannot contain the key word '(Team Folder)'</asp:Localize>
<asp:Localize runat="server" ID="LocBadStoId" meta:resourcekey="str_badStoId" Visible="false">Bad storage id</asp:Localize>
<asp:Localize runat="server" ID="LocBadEndPoi" meta:resourcekey="str_badEndPoi" Visible="false">Bad end point</asp:Localize>
<asp:Localize runat="server" ID="LocBadLoc" meta:resourcekey="str_badLoc" Visible="false">Bad location</asp:Localize>
<asp:Localize runat="server" ID="LocEvn" meta:resourcekey="str_evn" Visible="false">Everyone</asp:Localize>
<asp:Localize runat="server" ID="LocAllADUsr" meta:resourcekey="str_allADUsr" Visible="false">All AD Users</asp:Localize>
<asp:Localize runat="server" ID="LocUkn" meta:resourcekey="str_ukn" Visible="false">Unknown</asp:Localize>
<asp:Localize runat="server" ID="LocNa" meta:resourcekey="str_na" Visible="false">N/A</asp:Localize>
<asp:Localize runat="server" ID="LocUknUsr" meta:resourcekey="str_uknUsr" Visible="false">Unknown User</asp:Localize>
<asp:Localize runat="server" ID="LocTfCntHveTemFld" meta:resourcekey="str_tfCntHveTemFld" Visible="false">The team folder cannot contain the key word '(Team Folder)'</asp:Localize>
<asp:Localize runat="server" ID="LocFilShrOrLclDsk" meta:resourcekey="str_filShrOrLclDsk" Visible="false">File Share  (or Local Disk)</asp:Localize>
<asp:Localize runat="server" ID="LocLclStg" meta:resourcekey="str_lclStg" Visible="false">Local Storage</asp:Localize>
<asp:Localize runat="server" ID="LocS3Stg" meta:resourcekey="str_s3Stg" Visible="false">S3 Storage</asp:Localize>
<asp:Localize runat="server" ID="LocGogCldStg" meta:resourcekey="str_gogCldStg" Visible="false">Google Cloud Storage</asp:Localize>
<asp:Localize runat="server" ID="LocInPlcVsdFld" meta:resourcekey="str_inPlcVsdFld" Visible="false">In-Place Versioned Folder</asp:Localize>
<asp:Localize runat="server" ID="LocAthLclFld" meta:resourcekey="str_athLclFld" Visible="false">Attached Local Folder</asp:Localize>
<asp:Localize runat="server" ID="LocAthFld" meta:resourcekey="str_athFld" Visible="false">Attached Folder</asp:Localize>
<asp:Localize runat="server" ID="LocWsbStg" meta:resourcekey="str_wsbStg" Visible="false">Wasabi Storage</asp:Localize>
<asp:Localize runat="server" ID="LocOpnStkWthKtn" meta:resourcekey="str_opnStkWthKtn" Visible="false">OpenStack with KeyStone</asp:Localize>
<asp:Localize runat="server" ID="LocShrPntOln" meta:resourcekey="str_shrPntOln" Visible="false">SharePoint Online</asp:Localize>
<asp:Localize runat="server" ID="LocS3Cne" meta:resourcekey="str_s3Cne" Visible="false">S3 Clone</asp:Localize>
<asp:Localize runat="server" ID="LocBadPat" meta:resourcekey="str_badPat" Visible="false">Bad Path</asp:Localize>
<asp:Localize runat="server" ID="LocSubFol" meta:resourcekey="str_subFol" Visible="false">Sub-Folder</asp:Localize>
<asp:Localize runat="server" ID="LocRegFol" meta:resourcekey="str_regFol" Visible="false">Regular Folder</asp:Localize>
<asp:Localize runat="server" ID="LocAttFol" meta:resourcekey="str_attFol" Visible="false">Attached Folder</asp:Localize>
<div style="float: right;position: absolute; bottom:50px;right:50px;z-index: 9999; background: transparent; display: none; " id="SaveBtnDiv" >
<div style=" border-radius: 50%; width: 50px; height: 50px; background-color: #0288d1;  box-shadow: 3px 3px 3px #cccccc ; align-content: center; padding-top: 10px; padding-left: 9px; " class="savebtn" title="<asp:Localize meta:resourcekey="str_savechanges" runat="server">Save changes</asp:Localize>" onclick="OnSaveChanges();">
    
    <img  src="/webui/images/save_white_32.png"/>
</div>
    <div style="height:5px"></div>
    <div style=" border-radius: 50%; width: 50px; height: 50px; background-color: #ffa000;  box-shadow: 3px 3px 3px #cccccc; align-content: center; padding-top: 10px; padding-left: 9px; " class="savebtn" title="Discard changes" onclick="OnCancelChanges();">
    <img  src="/webui/images/discard_white_32.png"/>
</div>

    </div>

     <div width="100%" style="background-color: white; border: 0px; padding-bottom: 30px; padding-top:10px; align-content: right; border-bottom: 0px solid #c0c0c0;" class="meubardrop">
                        <table width="100%" style="border-collapse: collapse;" cellpadding="0" cellspacing="0" border="0">
                            <tr>
                                
                               
                                
                                <td align="left" style=" width: 100px;" valign="bottom">
                                    <table style="border-collapse: collapse; " cellpadding="0" cellspacing="0">
                                        
                                        <tr>
                                            <td style="width: 10px; border-bottom: 1px solid #cccccc;">&nbsp;</td>
                                            <td width="32px" align="center"  style="padding-top: 10px;border-bottom: 1px solid #cccccc;" valign="middle">
                                                 <%if (IsListView) { %>
                                        <i class="gladinet-icons md-24 md-dark hand center toolbtn" style="display: inline-block; margin-top: 0px;" onclick="OnIconView();return false;" id="iconview">&#0164;</i>

                                    <%}else{ %>
                                        <i class="gladinet-icons md-24 md-dark hand center toolbtn" style="display: inline-block; margin-top: 0px;" onclick="OnListView();return false;" id="listview">&#0186;</i>

                                    <%} %>
                                            </td>
                                            <td style="width: 10px; border-bottom: 1px solid #cccccc;">&nbsp;</td>
                                            <td style="padding-top: 10px;" valign="bottom">
                                                <div class="gladtab_lg_inactive" id="page_1"  onclick="SetPage(1);return false;" title="<asp:Localize meta:resourcekey="str_clbTolTip" runat="server">Collaborators are the users who are assigned to this team share and can access the share from their own accounts. Detailed access permissions are defined at the folder and sub-folder levels.</asp:Localize>">
                                                    <asp:Localize meta:resourcekey="str_clb" ID="str_clb" runat="server">Collaborators</asp:Localize>
                                                </div>
                                            </td>
                                             <% if (WorkSpace.Checked){ %>
                                            <td style="padding-top: 10px;" valign="bottom">
                                                <div class="gladtab_lg_inactive" id="page_7" onclick="SetPage(7);return false;">
                                                    <asp:Localize meta:resourcekey="str_folders" ID="str_folders" runat="server">Folders</asp:Localize>
                                                </div>
                                            </td>
                                            <% } %>
                                            <% if ( !PathLoc.Text.Contains("73659E5F-F5F0-4D49-A637-B47A73515D72") && !string.IsNullOrEmpty(PubFolderId.Value)){ %>
                                            <td style="padding-top: 10px;" valign="bottom">
                                                <div class="gladtab_lg_inactive" id="page_6" onclick="SetPage(6);return false;" style="font-weight:100!important;">
                                                   <asp:Localize meta:resourcekey="str_extsharing" ID="str_extsharing" runat="server">External Sharing</asp:Localize>
                                                </div>
                                            </td>
                                            <td style="padding-top: 10px;" valign="bottom">
                                                <div class="gladtab_lg_inactive" id="page_10" onclick="SetPage(10);return false;" style="font-weight:100!important;">
                                                   <asp:Localize meta:resourcekey="str_tfaccessp" id="str_tfaccessp" runat="server">Access Policy</asp:Localize>
                                                </div>
                                            </td>
                                            <% } %>
                                            <% if (!CreateNew.Checked && !WorkSpace.Checked){ %>
                                            <td style="padding-top: 10px;" valign="bottom">
                                                <div class="gladtab_lg_inactive" id="page_2" onclick="SetPage(2);return false;" title="<asp:Localize meta:resourcekey="str_fldTolTip" runat="server">Folder and sub-folder permissions</asp:Localize>">
                                                    <asp:Localize meta:resourcekey="str_fldPrm" ID="str_fldPrm" runat="server">Folder Permissions</asp:Localize>
                                                </div>
                                            </td>
                                            <% } %>
                                            <% if (PermsPanel.Visible){ %>
                                            <td style="padding-top: 10px;" valign="bottom">
                                                <div class="gladtab_lg_inactive" id="page_3" onclick="SetPage(3);return false;">
                                                    <asp:Localize meta:resourcekey="str_stg" id="str_stg" runat="server">Settings</asp:Localize>
                                                </div>
                                            </td>
                                            <% } %>
                                            <% if (TwoWayPanel.Visible&& !PathLoc.Text.Contains("73659E5F-F5F0-4D49-A637-B47A73515D72")){ %>        
                                            <td style="padding-top: 10px;" valign="bottom">
                                                <div class="gladtab_lg_inactive" id="page_4" onclick="SetPage(4);return false;">
                                                    <asp:Localize meta:resourcekey="str_twoWaySnc" ID="str_twoWaySnc" runat="server">Two-way Sync</asp:Localize>
                                                </div>
                                            </td>
                                            <% } %>
                                            <% if (m_ShowAdvanced && !ParentSharePanel.Visible && !WorkSpace.Checked && !PathLoc.Text.Contains("73659E5F-F5F0-4D49-A637-B47A73515D72")){ %>
                                            <td style="padding-top: 10px;" valign="bottom">
                                                <div class="gladtab_lg_inactive" id="page_5" onclick="SetPage(5);return false;">
                                                   <asp:Localize meta:resourcekey="str_str" ID="str_str" runat="server">Storage</asp:Localize>
                                                </div>
                                            </td>
                                            <% } %>
                                            <%if (RetentionPanel.Visible||InplaceVer.Checked){ %>
                                            <td style="padding-top: 10px; display:none;" valign="bottom">
                                                <div class="gladtab_lg_inactive" id="page_8" onclick="SetPage(8);return false;">
                                                    <asp:Localize ID="Localize19" meta:resourcekey="str_restore" runat="server" 
                                                                                                                 Text="Restore folder (and subfolder) to previous date"></asp:Localize>
                                                </div>
                                            </td>
                                            <% } %>
                                            <%if ((m_EnableBackup|| RetentionPanel.Visible||InplaceVer.Checked) && !string.IsNullOrEmpty(PubFolderId.Value)){ %>
                                            <td style="padding-top: 10px; display:;" valign="bottom">
                                                <div class="gladtab_lg_inactive" id="page_9" onclick="SetPage(9);return false;">
                                                    <asp:Localize ID="Localize18" meta:resourcekey="str_cloudbackup" runat="server" 
                                                                                                                 Text="Cloud Backup"></asp:Localize>
                                                </div>
                                            </td>
                                            <% } %>
                                        </tr>
                                    </table>
                                </td>
                                    
                                <td align="right" valign="bottom" style="padding-bottom:1px; height:40px;" >
                                    <table width="100%" style="border-collapse: collapse; " cellpadding="0" cellspacing="0">
                                        <tr>
                                            <td style="width: 20px;border-bottom: 1px solid #cccccc;">&nbsp;</td>
                                 <td style=" border-bottom: 1px solid #cccccc;width:40px;padding-top:10px;" id="colctrl">
                                   <% if (!ParentSharePanel.Visible){ %>

                                    <span class="fa fa-plus sectextcolor" aria-hidden="true" style="font-size: 14px; margin-left: 15px; margin-top: -7px; cursor: pointer; display: inline-block; position: absolute;" onclick="SelectUser();return false;" title="<%=Localize7.Text %>"></span>

                                    <i class="gladinet-icons md-24 md-dark hand center toolbtn" style="display: inline-block; margin-top: -10px;" onclick="SelectUser();return false;" title="<%=Localize7.Text %>">M</i>
                                    <asp:Localize ID="Localize7" meta:resourcekey="string5" runat="server" Visible="False"
                                        Text="Add User"></asp:Localize>

                                    <button type="button" class="btn btn-default " style="font-size: 14px; padding-left: 3px; padding-right: 3px; display: none;" data-toggle="modal" data-target="#myModal" title="<%= AdvancedSettings.Text %>">
                                        <span class="fa fa-question-sign" aria-hidden="true" style="font-size: 14px;"></span>
                                        <asp:Localize meta:resourcekey="str_advanced" ID="AdvancedSettings"
                                            runat="server" Visible="False" Text="Advanced Settings"></asp:Localize>
                                    </button>
                                    <% } %>
                                </td>
                                <td style="width:30px;border-bottom: 1px solid #cccccc; " valign="bottom">
                                   <%if(m_CanDelete) { %>
                                    <i class="gladinet-icons md-24 md-dark hand center toolbtn" style="display: inline-block; margin-top: -12px;" title="<%=DeleteNow.Text%>" onclick="DeletePubNow();return false;">n</i>
                                     <% } %>
                                </td>
                                <td style="border-bottom: 1px solid #cccccc; padding-right:10px;">
                                    <div style="float: right; font-size: 32px; font-weight: 100; cursor: pointer;" class="sectextcolor" onclick="ReturnLast();">&times;</div>
                                </td>
                                        </tr>
                                    </table>
                                </td>
                                
                            </tr>
                        </table>
                    </div>
    
    <div class="wrapper" style="text-align: center; width: 100%;  overflow: auto; margin-top:18px;" id="maindivw">
        <table cellspacing="0" cellpadding="0" align="left" style="width: 100%; padding: 0px;">
            
            <tr>
                <td style="">
                   
                            <table width="100%" align="center" style="height: 100%;" border="0">


                                <tr style="display: none;">
                                    <td  align="left" style="padding-top: 10px; padding-bottom: 8px;">
                                        <div style="border-bottom: 1px solid #c0c0c0; box-shadow: 0px 3px 3px #cccccc !important; width: 100%;">
                                        <table width="100%">
                                            <tr>
                                                <td style="padding-right: 10px; padding-left: 10px;">
                                                    <input type="checkbox" name="pub_to_all" onclick="Toggle('pubusers')" style="display: none;" />
                                                    
                                                    <% if (SessionStartFromServer)
                                                        { %>
                                                    <h3 style="display: none;">
                                                        <asp:Localize ID="Localize6"
                                                            Visible="True" meta:resourcekey="string4" runat="server"
                                                            Text="Assign access permission for your team members"></asp:Localize>
                                                    </h3>
                                                    <% } %>
                                                    
                                                </td>
                                                <td width="24px"></td>
                                                <td align="right" style="padding-bottom: 5px; width: 570px;">
                                                    
                                                    <table border="0" style="display: none;">
                                                        <tr>
                                                            <td style="padding-right: 10px;"></td>
                                                            <% if (m_AllowLDAPUser)
                                                                { %>
                                                            <td style="padding-left: 5px; display: none;">
                                                                <a href="javascript:;" onclick="SelectLDAPUser();return false;" style="font-size: 12px;">
                                                                    <button class="btn btn-default">
                                                                        <span class="fa fa-plus" aria-hidden="true" style="font-size: 14px;"></span>
                                                                        <asp:Localize ID="Localize61" meta:resourcekey="string6" runat="server"
                                                                            Text="Add AD User"></asp:Localize>
                                                                    </button>
                                                                </a>
                                                            </td>
                                                            <% } %>
                                                            <% if (m_AllowSvrAgentGroup && !EditingTenant)
                                                                { %>
                                                            <td style="padding-left: 5px; display: none;">
                                                                <a href="javascript:;" onclick="SelectSAGroup();return false;" style="font-size: 12px;">
                                                                    <button class="btn btn-default">
                                                                        <span class="fa fa-plus" aria-hidden="true" style="font-size: 14px;"></span>
                                                                        <asp:Localize ID="Localize12" meta:resourcekey="string7" runat="server"
                                                                            Text="Proxy(AD) Group"></asp:Localize>
                                                                    </button>
                                                                </a>
                                                            </td>
                                                            <% } %>


                                                            <td style="padding-left: 5px; padding-right: 5px;"></td>
                                                        </tr>
                                                    </table>
                                                </td>
                                                <td >
                                                   
                                                </td>
                                            </tr>
                                        </table>
                                            </div>
                                    </td>
                                </tr>




                                <tr>
                                    <td class="InputLabel" colspan="2" valign="top" id="pubusersc" style="padding-top: 0px;">
                                        <div id="pubusers" width="100%" >
                                            <table width="100%" style="background-color: white;" id="PermTable" >
                                                <tbody>

                                                    <tr>
                                                        <td style="padding: 0px; padding-top: 0px;">
                                                            <div id="page_1_div" style="overflow: auto; display:none;">
                                                                <table width="95%" >
                                                                    <% if (ParentSharePanel.Visible){ %>
                                                                    <tr>
                                                                        <td style="padding: 5px; border-bottom: 0px solid #f0f0f0; padding-bottom: 10px; font-size: 14px; font-weight: 100;">This folder is not published as team folder, but can be accessed by following user/group(s)
                                                                                because parent folder(<asp:Label ForeColor="Black" Font-Bold="True" ID="ParentFolder"
                                                                                    runat="server" meta:resourcekey="ParentFolderResource1"></asp:Label>) is published as a team folder.
                                                                             <asp:Panel ID="ParentSharePanel" runat="server" Visible="False"
                                                                                 meta:resourcekey="ParentSharePanelResource1">
                                                                                 <div style="border: 0px solid #c0c0c0; border-bottom: 0px solid #c0c0c0; padding: 5px; padding-bottom: 23px; padding-top: 23px; background-color: white; width:90%;">
                                                                                     <table align="center" >
                                                                                         <tr>
                                                                                             <td colspan="2" style="font-size: 12px"></td>
                                                                                         </tr>
                                                                                         <tr>
                                                                                             <td align="center" width="50%">
                                                                                                 <asp:LinkButton ID="LinkButton3" OnClientClick="Wait('One minute...');" CssClass="btn btn-info btnbig"
                                                                                                     runat="server" OnClick="LinkButton1_Click"
                                                                                                     meta:resourcekey="LinkButton3Resource1">Edit Parent Folder</asp:LinkButton>
                                                                                             </td>
                                                                                             <td style="font-size: 18px;">
                                                                                                 <%if (m_CanAdd)                                                                                                     { %>
                                                                                                 <asp:LinkButton ID="LinkButton2" runat="server" CssClass="btn btn-info btnbig"
                                                                                                     OnClientClick="Wait('One minute...');" OnClick="LinkButton2_Click"
                                                                                                     meta:resourcekey="LinkButton2Resource1">Publish Current Folder as Team Folder</asp:LinkButton>
                                                                                                 <%}%>
                                                                                             </td>
                                                                                         </tr>
                                                                                     </table>
                                                                                 </div>
                                                                             </asp:Panel>
                                                                        </td>
                                                                    </tr>
                                                                    <% } else {%>
                                                                    
                                                                    
                                                                    
                                                                    <tr>
                                                                        <td id="grid-example" colspan="2" valign="top" >
                                                                    
                                                                            <%if(!IsListView) { %>        
                                                                            <div style="overflow: auto" id="userviewcontainer">
                                                                            <div class="row " style="align-content: center; padding-left: 10px; padding-bottom: 10px; padding-top: 10px; width: 95%; " id="userview">
                                                                                <% if (!ParentSharePanel.Visible) { %>
                                                                                <div class="gridobject col-2" style="padding-bottom: 10px;  " >
                                                                                    <div class="addnewbox  iconobj " style="display: inline-block; width: 100%; max-width: 240px; cursor: pointer;" onclick='SelectUser();return false;' title="<%=emptytext.Text %>">
                                                                                        <div class="panel-body"  >
                                                                                            <table width="100%" >
                                                                                                <tr>
                                                                                                    <td style="height: 220px!important; padding-top: 10px;" align="center" valign="middle">
                                                                                                        <div  style="cursor: pointer; padding-top: 10px;"   >
                                                                                                        <span style='font-size: 90px; curor: hand; ' class="secpaneltextcolor">+</span>
                                                                                                        <p class="text-muted" style="font-size: small; padding-top: 10px;">
                                                                                                            <asp:Localize meta:resourcekey="str_addcollab" runat="server">Add Collaborators</asp:Localize>
                                                                                                        </p>
                                                                                                            </div>
                                                                                                    </td>
                                                                                                </tr>

                                                                                            </table>

                                                                                        </div>

                                                                                    </div>
                                                                                    
                                                                                </div>
                                                                                <% } %>
                                                                                <asp:Repeater ID="UserList" runat="server">
                                                                                <ItemTemplate>
                                                                                    <div class="gridobject col-2" id="m_<%#DataBinder.Eval(Container.DataItem, "UserGuid")%>" style="padding-bottom: 10px;">
                                                                                        <div class=" <%#DataBinder.Eval(Container.DataItem, "AbbrevClass")%> iconobj  boxbordercolor" style="max-width: 240px; display: inline-block; width: 100%; cursor: pointer; border-radius: 4px !important;" title="<%#DataBinder.Eval(Container.DataItem, "FirstName")%>  <%#DataBinder.Eval(Container.DataItem, "LastName")%>">
                                                                                            <div class=" " style=" padding: 0px !important;"
                                                                                                
                                                                                                >
                                                                                                <div style="border-right: 1px solid #cccccc;border-bottom: 1px solid #cccccc;  position: relative; width: 32px; height: 32px; border-radius: 0px 0px 70% 0px; cursor: pointer; " class="toolbtn secsubbordercolor" onclick='ToggleUIInfo("<%#DataBinder.Eval(Container.DataItem, "UserGuid")%>");'>
                                                                                                     <span class="fa fa-edit secpaneltextcolor" id="sui_<%#DataBinder.Eval(Container.DataItem, "UserGuid")%>" ></span>
                                                                                                </div>
                                                                                                <table width="100%" border="0">
                                                                                                    
                                                                                                    <tr>
                                                                                                        <td style="height: 200px!important; padding-top: 15px;" align="center" valign="top">
                                                                                                            <div style="padding: 2px; width: 128; height: 128px; " id="p_<%#DataBinder.Eval(Container.DataItem, "UserGuid")%>">
                                                                                                                <div id="av_<%#DataBinder.Eval(Container.DataItem, "UserGuid")%>" style="padding-top: 50px;" >
                                                                                                                    
                                                                                                                    <i  class="gladinet-icons  md-dark hand center" style="font-size: 96px; font-weight: 100;"><%#DataBinder.Eval(Container.DataItem, "DefaultAvarta")%></i>
                                                                                                                </div>
                                                                                                                


                                                                                                                <img style="display: none; border-radius: 50%;" id="i_<%#DataBinder.Eval(Container.DataItem, "UserGuid")%>" src="/storage/avarta.dn?u=<%#DataBinder.Eval(Container.DataItem, "UserGuid")%>&w=128&h=128&d=<%=SessionDomainId %>" onload="OnAvLoad('<%#DataBinder.Eval(Container.DataItem, "UserGuid")%>')" />

                                                                                                            </div>
                                                                                                            <div class="fadeindiv" style="padding: 2px; width: 100%;display: none;"  id="info_<%#DataBinder.Eval(Container.DataItem, "UserGuid")%>">
                                                                                                                <table width="100%">
                                                                                                                    
                                                                                                                    <tr>
                                                                                                                        <td  colspan="2" style="font-weight: 100; font-size: 16px; color: #565656; border-bottom: 1px solid #f0f0f0; padding: 3px;" align="center" title="<%#DataBinder.Eval(Container.DataItem, "Email")%>">
                                                                                                                            
                                                                                                                            <%#GetShortString(DataBinder.Eval(Container.DataItem, "Email").ToString(),16)%>
                                                                                                                        </td>
                                                                                                                       

                                                                                                                    </tr>
                                                                                                                    <tr>
                                                                                                                        <td colspan="2" height="5px">&nbsp;</td>
                                                                                                                    </tr>
                                                                                                                    <tr
                                                                                                                         <% if (ParentSharePanel.Visible || !ShowShareAcl.Checked){ %>
                                                                                                                          style="display:none" 
                                                                                                                        <% } %>
                                                                                                                        >
                                                                                                                        <td>
                                                                                                                            <asp:Localize meta:resourcekey="js_read" runat="server">Read</asp:Localize>
                                                                                                                        </td>
                                                                                                                        <td width="32px">
                                                                                                                            <input type="checkbox" onclick="ShowSavePanel();"
                                                                                                                                <%#DataBinder.Eval(Container.DataItem, "ReadRight")%>
                                                                                                                                name="uu_read_<%#DataBinder.Eval(Container.DataItem, "UserGuid")%>_<%#DataBinder.Eval(Container.DataItem, "FirstName")%>  <%#DataBinder.Eval(Container.DataItem, "LastName")%>"  value="1"
                                                                                                                                <% if (!m_CanEdit){ %>
                                                                                                                                disabled
                                                                                                                                <% } %>
                                                                                                                                
                                                                                                                                />
                                                                                                                        </td>
                                                                                                                    </tr>
                                                                                                                    <tr
                                                                                                                         <% if (ParentSharePanel.Visible || !ShowShareAcl.Checked){ %>
                                                                                                                          style="display:none" 
                                                                                                                        <% } %>
                                                                                                                        >
                                                                                                                        <td>
                                                                                                                            <asp:Localize meta:resourcekey="js_write" runat="server">Write</asp:Localize>
                                                                                                                        </td>
                                                                                                                        <td width="32px">
                                                                                                                            <input type="checkbox" onclick="ShowSavePanel();"
                                                                                                                                <%#DataBinder.Eval(Container.DataItem, "WriteRight")%>
                                                                                                                                name="uu_write_<%#DataBinder.Eval(Container.DataItem, "UserGuid")%>_<%#DataBinder.Eval(Container.DataItem, "FirstName")%>  <%#DataBinder.Eval(Container.DataItem, "LastName")%>"  value="1"
                                                                                                                                <% if (!m_CanEdit){ %>
                                                                                                                                disabled
                                                                                                                                <% } %>
                                                                                                                                />
                                                                                                                        </td>
                                                                                                                    </tr>
                                                                                                                      <% if (!ParentSharePanel.Visible) { %>
                                                                                                                          
                                                                                                                        
                                                                                                                    <tr style=" <%#DataBinder.Eval(Container.DataItem, "OwnerDisplay")%>">
                                                                                                                        <td>
                                                                                                                            <asp:Localize meta:resourcekey="js_string10" runat="server">Owner</asp:Localize>
                                                                                                                        </td>
                                                                                                                        <td width="32px">
                                                                                                                            <input type="checkbox" 
                                                                                                                                <%#DataBinder.Eval(Container.DataItem, "OwnerRight")%>
                                                                                                                                onclick='OnCommit();'
                                                                                                                                name="uu_owner_<%#DataBinder.Eval(Container.DataItem, "UserGuid")%>_<%#DataBinder.Eval(Container.DataItem, "FirstName")%>  <%#DataBinder.Eval(Container.DataItem, "LastName")%>"  value="1"
                                                                                                                                <% if (!m_CanEdit){ %>
                                                                                                                                disabled
                                                                                                                                <% } %>

                                                                                                                                />
                                                                                                                        </td>
                                                                                                                    </tr>
                                                                                                                    
                                                                                                                    <tr style="display:none;">
                                                                                                                        <td>
                                                                                                                            <asp:Localize meta:resourcekey="str_ntf" runat="server">Notifications</asp:Localize>
                                                                                                                        </td>
                                                                                                                        <td width="32px">
                                                                                                                            <input type="checkbox" 
                                                                                                                                <%# (Convert.ToBoolean(DataBinder.Eval(Container.DataItem, "NotificationsRight")) ? "checked" : "") %>
                                                                                                                                onclick='ShowSavePanel();'
                                                                                                                                name="uu_ntf_<%#DataBinder.Eval(Container.DataItem, "UserGuid")%>_<%#DataBinder.Eval(Container.DataItem, "FirstName")%>  <%#DataBinder.Eval(Container.DataItem, "LastName")%>"  value="1"
                                                                                                                                <% if (!m_CanEdit){ %>
                                                                                                                                disabled
                                                                                                                                <% } %>

                                                                                                                                />
                                                                                                                        </td>
                                                                                                                    </tr>


                                                                                                                    <tr>
                                                                                                         <td colspan="2" style="font-weight: 100; font-size: 16px; color: #565656; border-top: 1px solid #f0f0f0; padding: 3px;" align="right">
                                                                                                                             <button class="btn btn-primary gladbtn"  onclick='RemoveUser("<%#DataBinder.Eval(Container.DataItem, "UserGuid")%>");' style="padding: 0px; margin: 0px; font-weight: 100;">Remove</button>
                                                                                                                         </td>
                                                                                                    </tr>
                                                                                                                    <% } %>
                                                                                                                </table>
                                                                                                            </div>
                                                                                                        </td>
                                                                                                    </tr>
                                                                                                    <tr>
                                                                                                        <td style="font-weight: 100!important; font-size: 16px; color: #868686;" >
                                                                                                            <%#GetShortString(DataBinder.Eval(Container.DataItem, "FirstName").ToString()+" "+DataBinder.Eval(Container.DataItem, "LastName"),16)%>
                                                                                                            
                                                                                                        </td>
                                                                                                    </tr>

                                                                                                </table>

                                                                                            </div>

                                                                                        </div>

                                                                                    </div>
                                                                                </ItemTemplate>
                                                                                </asp:Repeater>
                                                                            </div>
                                                                                </div>
                                                                            <% } %>
                                                                        </td>
                                                                    </tr>
                                                                    <% } %>
                                                                </table>
                                                            </div>
                                                            <div id="page_2_div" style="display: none; border:0px solid green;overflow:hidden;">
                                                                <div id="pubusersex" style="background-color: white; overflow: hidden; border: 0px solid #f0f0f0;">
                                                                    <table width="100%">
                                                                        <tr>
                                                                            <td height="48px" style="border-bottom: 1px solid #c0c0c0;">
                                                                                <table>
                                                                                    <tr>
                                                                                        <td>
                                                                                            <button class="btn btn-primary gladbtn" onclick='LoadPerm("<%=RootPermPath.Value %>"); return false;' style="padding-left: 3px; padding-right: 3px; font-size: 14px; font-weight: 100;"><%=RootPermPath.Value %></button>
                                                                                        </td>
                                                                                        <asp:Repeater ID="CrumbRepeater" runat="server">
                                                                                            <ItemTemplate>
                                                                                                <td>
                                                                                                    <button class="btn btn-primary gladbtn" onclick='LoadPerm("<%# DataBinder.Eval(Container.DataItem, "OrigKey").ToString().Replace("'","|") %>"); return false;' style="padding-left: 3px; padding-right: 3px; font-size: 14px; font-weight: 100;">> <%# DataBinder.Eval(Container.DataItem, "Key") %></button>
                                                                                                </td>
                                                                                            </ItemTemplate>
                                                                                        </asp:Repeater>
                                                                                        <% if (HasSubFolder.Value == "1")
                                                                                            { %>
                                                                                        <td>
                                                                                            <div class="dropdown"  >
                                                                                                <button class="btn btn-primary gladbtn dropdown-toggle" type="button" data-toggle="dropdown" style="padding-left: 3px; padding-right: 3px; font-size: 14px!important;">
                                                                                                    <span class="caret" style="font-size: 16px!important;"></span>
                                                                                                </button>
                                                                                                <ul class="dropdown-menu" style="padding:10px;overflow-y:auto; max-height:400px;" id="crumbdiv">
                                                                                                    <asp:Repeater ID="Subfolders" runat="server">
                                                                                                        <ItemTemplate>
                                                                                                            <li><a href="javascript:;" onclick='LoadPerm("<%# DataBinder.Eval(Container.DataItem, "OrigKey").ToString().Replace("'","|") %>"); return false;' style="font-size: 16px; font-weight: 100;" class="sectextcolor"><%# DataBinder.Eval(Container.DataItem, "Key") %></a></li>
                                                                                                        </ItemTemplate>
                                                                                                    </asp:Repeater>
                                                                                                </ul>
                                                                                            </div>
                                                                                        </td>
                                                                                        <% } %>
                                                                                    </tr>
                                                                                </table>
                                                                            </td>
                                                                            <td width="128px" style="border-bottom: 1px solid #c0c0c0;">
                                                                                
                                                                                <% bool isNotRoot = (FolderPermLoc.Value != "/");
                                                                                   bool isTenantRoot = (string.Compare(PathLoc.Text, user.Common.TenantRoot) == 0 || string.Compare(PathLoc.Text, "/" + user.Common.TenantRoot) == 0);
                                                                                   if (!isTenantRoot && isNotRoot || isTenantRoot) { %>
                                                                                <a href="#" onclick="document.getElementById('permframe').contentWindow.SelectUser();;return false;" style="font-size: 12px;" title="<%=AddUserText.Text %>">
                                                    <button class="btn btn-default" style="padding-left: 3px; padding-right: 3px;">
                                                                            <span class="fa fa-plus sectextcolor" aria-hidden="true" style="font-size: 14px; margin-left: -5px; margin-top: 17px; display: inline-block; position: absolute;">
                                                                            </span>
                                                        <i class="gladinet-icons md-24 md-dark hand center toolbtn" style="display: inline-block; margin-top: 0px;" >M</i>
                                                <asp:Localize meta:resourcekey="string4" runat="server" id="AddUserText" Text="Add User" Visible="False"></asp:Localize>
                                                </button>
                                                </a>
                                                                                 <i class="gladinet-icons md-24 md-dark hand center toolbtn" style="display: none; margin-top: 0px;" onclick="EditPerm();return false;">c</i>&nbsp; &nbsp;
                                                                                <% } %>

                                                                                <%if(SyncPermBtnPanel.Visible) { %>
                                                                                <i class="gladinet-icons md-24 md-dark hand" title="<%=str_syncperm.Text %>" onclick="SyncPermShare();">Ö</i>
                                                                                
                                                                                <% } %>
                                                                                <asp:Localize meta:resourcekey="str_syncperm" id="str_syncperm" Visible="false" runat="server">Sync folder permissions</asp:Localize>
                                                                            </td>
                                                                        </tr>
                                                                    </table>
                                                                    <iframe id="permframe" style="width:100%; border:0px solid red;height:calc(100vh - 170px);" src="about:blank" frameborder="0" border="0" onload="folderPermsLoadedEvent()"></iframe>
                                                                </div>
                                                            </div>
                                                            <iframe id='page_6_div' width="100%" src=""  style="padding:0px;" frameborder="0" border="0" height="100%"></iframe>
                                                            <iframe id='page_10_div' width="100%" src=""  style="padding:0px;" frameborder="0" border="0" height="100%"></iframe>
                                                            <iframe id='page_8_div' width="100%" src=""  style="padding:0px;" frameborder="0" border="0" height="100%"></iframe>
                                                            <div id="page_3_div" style="display: none; overflow: auto;">
                                                            <table width="100%">
                                                        <tr>

                                                            <td width="120px">
                                                                <span style="color: #565656; font-weight: 200;">
                                                                    <asp:Localize ID="Localize4" meta:resourcekey="string2" runat="server"
                                                                        Text="Display Name:"></asp:Localize>
                                                                </span>
                                                            </td>
                                                            <td>
                                                                <asp:TextBox ID="ShareName" MaxLength="96" runat="server" Width="250px" CssClass="form-control" oninput="ShowSavePanel();"  
                                                                    meta:resourcekey="ShareNameResource1"></asp:TextBox>
                                                            </td>
                                                            <td width="150px">
                                                                <asp:RequiredFieldValidator runat="server" ID="reqName" ControlToValidate="ShareName"
                                                                    ErrorMessage="name is required!" Display="Dynamic" CssClass="errmsg" ValidationGroup="PublishFolder"
                                                                    meta:resourcekey="reqNameResource1" />
                                                            </td>

                                                        </tr>
                                                    </table>
                                                                <table width="100%">
                                                                   

                                                                            <% if (m_ShowAdvanced && !ParentSharePanel.Visible)
                                                                                { %>
                                                                        <tr>
                                                                            <td style="padding-top: 14px; padding-bottom: 4px; padding-left:10px;" align="left">
                                                                                 
                                                                                <div class="panel-group">
                                                                                    <div class="panel panel-default" style="background-color: white; box-shadow: 0px 0px 1px #a0a0a0!important">
                                                                                        <div class="panel-heading whitehead">
                                                                                            <h4 class="panel-title">
                                                                                                <a data-toggle="collapse" href="#collapse1" class="gladdropdownlink collapsed"><span class="fa fa-plus-square" ></span><span
                                                                                                    >&nbsp;<asp:Localize meta:resourcekey="str_settings" runat="server">Settings</asp:Localize></span>
                                                                                                </a>
                                                                                            </h4>
                                                                                        </div>
                                                                                        <div id="collapse1" class="panel-collapse collapse">
                                                                                            <div class="panel-body">
                                                                                                <table>
                                                                                                    <tr style="padding-top: 0px; padding-bottom: 0px;">
                                                                                                        <td style="padding-top: 0px; padding-bottom: 0px;">
                                                                                                            <asp:CheckBox ID="DisableSharing" ToolTip="When checked, the assigned user cannot share the content of the team folder with others"
                                                                                                                runat="server" Text=" Disable further sharing" meta:resourcekey="DisableSharingResource1" onclick="ShowSavePanel();"/>
                                                                                                        </td>
                                                                                                    </tr>
                                                                                                    <tr style="padding-top: 0px; padding-bottom: 0px;">
                                                                                                        <td style="padding-top: 0px; padding-bottom: 0px;">
                                                                                                            <asp:CheckBox ID="DisableSharingRoot" ToolTip="When checked, the assigned user cannot share the content of the team folder itself with others"
                                                                                                                runat="server" Text=" Disable sharing of the team folder" meta:resourcekey="DisableSharingRootResource1" onclick="ShowSavePanel();"/>
                                                                                                        </td>
                                                                                                    </tr>
                                                                                                    <tr>
                                                                                                        <td>
                                                                                                            <asp:CheckBox ID="EnabledVersion" Checked="True" ToolTip="When checked the team folder will has versoning support at the cost of additional storage space"
                                                                                                                runat="server" Text=" Enable versioning" meta:resourcekey="EnabledVersionResource1"  onclick="ShowSavePanel();"/>
                                                                                                        </td>
                                                                                                    </tr>
                                                                                                    <tr>
                                                                                                        <td>
                                                                                                            <asp:CheckBox ID="AllowCIFS" ToolTip="When checked, a CIFS share will be created on your cloud server instance, so your user can access it as normal file server share"
                                                                                                                runat="server" Text=" Create CIFS Share" meta:resourcekey="AllowCIFSResource1" onclick="ShowSavePanel();"/>
                                                                                                        </td>
                                                                                                    </tr>
                                                                                                    <tr>
                                                                                                        <td>
                                                                                                            <asp:CheckBox ID="DisableCache" ToolTip="When checked, user can not enable offline access to the folder from client to prevent syncing down large amount of data"
                                                                                                                runat="server" Text="Disable Offline Access" meta:resourcekey="DisableCacheResource1" onclick="ShowSavePanel();"/>
                                                                                                        </td>
                                                                                                    </tr>

                                                                                                </table>
                                                                                            </div>
                                                                                        </div>
                                                                                    </div>
                                                                                </div>

                                                                                <div class="panel-group">
                                                                                    <div class="panel panel-default" style="background-color: white; box-shadow: 0px 0px 1px #a0a0a0!important">
                                                                                        <div class="panel-heading whitehead">
                                                                                            <h4 class="panel-title">
                                                                                                <a data-toggle="collapse" href="#collapse2" class="gladdropdownlink collapsed"><span class="fa fa-plus-square" ></span><span
                                                                                                    >&nbsp;<asp:Localize meta:resourcekey="str_permissions" runat="server">Permissions</asp:Localize></span>
                                                                                                </a>
                                                                                            </h4>
                                                                                        </div>
                                                                                        <div id="collapse2" class="panel-collapse collapse">
                                                                                            <div class="panel-body">
                                                                                                <table>
                                                                                                    <tr>
                                                                                                        <td>
                                                                                                            <asp:Panel ID="SyncPermPanel" runat="server" Visible="False">

                                                                                                                <asp:CheckBox ID="AutoPermSync" ToolTip="When checked, the permission of source folder will be synced to cloud automatically" onclick="ShowSavePanel();"
                                                                                                                    runat="server" Text="Synchronize folder permission automatically"
                                                                                                                    meta:resourcekey="AutoPermSyncResource1" />
                                                                                                                <p class="text-muted" style="font-size: smaller">
                                                                                                                    <asp:Localize meta:resourcekey="str_synchint" runat="server">when checked, the permission from the source folders will be synchronized to cloud automatically. The setting will not take effect until a restart of the client that owns the source folder. The current folder permission will be overwritten from the source folder permission.</asp:Localize>
                                                                                                                </p>
                                                                                                                <asp:Panel ID="MatchSAPanel" runat="server" Visible="False">
                                                                                                                    <asp:DropDownList ID="ExistingSAList" runat="server" CssClass="browser-default custom-select secsubbordercolor" Width="200px"></asp:DropDownList>
                                                                                                                    &nbsp;&nbsp;&nbsp;
                                                                                                                    <p class="text-muted" style="font-size: smaller">
                                                                                                                    <asp:Localize meta:resourcekey="str_sahint" runat="server">Please identify the file server that owns the above network share (If you don't see the file server in the list, please install server agent on the file server)</asp:Localize>
                                                                                                                </p>
                                                                                                                    </asp:Panel>
                                                                                                                <br />
                                                                                                                &nbsp;&nbsp;&nbsp;<asp:CheckBox ID="ImportAllowedUser" ToolTip="When checked, only user who has access to the teamfolder will be created if user doesn't exist " onclick="ShowSavePanel();"
                                                                                                                    runat="server" Text="Only import user who has access to team folder" />
                                                                                                                
                                                                                                            </asp:Panel>
                                                                                                        </td>
                                                                                                    </tr>
                                                                                                    <tr>
                                                                                                        <td>
                                                                                                            <asp:CheckBox ID="HideDeniedFolder" runat="server" onclick="ShowSavePanel();"
                                                                                                                Text="Hide folders to which users don't have permissions"
                                                                                                                meta:resourcekey="HideDeniedFolderResource1" />
                                                                                                        </td>
                                                                                                    </tr>
                                                                                                    <tr>
                                                                                                        <td>
                                                                                                            <asp:CheckBox ID="DenyFolderCreation" runat="server" onclick="ShowSavePanel();"
                                                                                                                Text="Disable folder creation" meta:resourcekey="str_disFolCre"
                                                                                                                 />
                                                                                                        </td>
                                                                                                    </tr>
                                                                                                </table>
                                                                                            </div>
                                                                                        </div>
                                                                                    </div>
                                                                                </div>

                                                                                <div class="panel-group" style="display:none;">
                                                                                    <div class="panel panel-default" style="background-color: white; box-shadow: 0px 0px 1px #a0a0a0!important">
                                                                                        <div class="panel-heading whitehead">
                                                                                            <h4 class="panel-title">
                                                                                                <a data-toggle="collapse" href="#collapse3" class="gladdropdownlink collapsed"><span class="fa fa-plus-square" ></span><span
                                                                                                    >&nbsp;<asp:Localize meta:resourcekey="str_secroom" runat="server">Secure Data Room</asp:Localize></span>
                                                                                                </a>
                                                                                            </h4>
                                                                                        </div>
                                                                                        <div id="collapse3" class="panel-collapse collapse">
                                                                                            <div class="panel-body">
                                                                                                <table>
                                                                                                    <tr>
                                                                                                        <td>
                                                                                                            <asp:CheckBox ID="WebOnlyTeamFolder" runat="server" onclick="ShowSavePanel();"
                                                                                                                Text="Secure Data Room (Can be viewed only from the web portal)" meta:resourcekey="str_secDtaRom" />
                                                                                                        </td>
                                                                                                    </tr>


                                                                                                </table>
                                                                                            </div>
                                                                                        </div>
                                                                                    </div>
                                                                                </div>

                                                                                <div class="panel-group" style="display:none;">
                                                                                    <div class="panel panel-default" style="background-color: white; box-shadow: 0px 0px 1px #a0a0a0!important">
                                                                                        <div class="panel-heading whitehead">
                                                                                            <h4 class="panel-title">
                                                                                                <a data-toggle="collapse" href="#collapse4" class="gladdropdownlink collapsed"><span class="fa fa-plus-square" ></span><span
                                                                                                   >&nbsp;<asp:Localize meta:resourcekey="str_whitelist" runat="server">IP White List</asp:Localize></span>
                                                                                                </a>
                                                                                            </h4>
                                                                                        </div>
                                                                                        <div id="collapse4" class="panel-collapse collapse">
                                                                                            <div class="panel-body">
                                                                                                <table>

                                                                                                    <tr>
                                                                                                        <td style="border-top: 1px solid #f0f0f0; padding-top: 5px;">
                                                                                                            <asp:Localize meta:resourcekey="str_only" runat="server"
                                                                                                                Text="Only allow the access of the team folder from following IPs"></asp:Localize>

                                                                                                        </td>
                                                                                                    </tr>
                                                                                                    <tr>
                                                                                                        <td>
                                                                                                            <asp:TextBox ID="IPWhiteList" runat="server" CssClass="form-control" onkeypress="ShowSavePanel();"
                                                                                                                Width="100%" meta:resourcekey="IPWhiteListResource1"></asp:TextBox>
                                                                                                            <p class="text-muted" style="font-size: smaller;">
                                                                                                                <asp:Localize ID="Localize11" meta:resourcekey="str_iphint" runat="server"
                                                                                                                    Text="(IP/Mask;IP/Mask, i.e. 254.234.234.128/255.255.255.0; 192.234.234.128/255.255.255.0    empty: no restriction)"></asp:Localize>
                                                                                                            </p>
                                                                                                        </td>
                                                                                                    </tr>
                                                                                                </table>
                                                                                            </div>
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                            </td>
                                                                        </tr>



                                                                    <% }%>
                                                                    <asp:Panel ID="QuotaPanel"
                                                                        runat="server" meta:resourcekey="QuotaPanelResource1">

                                                                        <tr>
                                                                            <td style="border-top: 0px solid #f0f0f0; padding: 2px; padding-left:10px;" align="left">
                                                                                <div class="panel-group">
                                                                                    <div class="panel panel-default" style="background-color: white; box-shadow: 0px 0px 1px #a0a0a0!important">
                                                                                        <div class="panel-heading whitehead">
                                                                                            <h4 class="panel-title">
                                                                                                <a data-toggle="collapse" href="#collapse5" class="gladdropdownlink collapsed"><span class="fa fa-plus-square" style="  font-weight: 100;"></span><span
                                                                                                    >&nbsp;<asp:Localize meta:resourcekey="str_qutAndRetPol" runat="server">Quota and Retention Policy</asp:Localize></span>
                                                                                                </a>
                                                                                            </h4>
                                                                                        </div>
                                                                                        <div id="collapse5" class="panel-collapse collapse">
                                                                                            <div class="panel-body" >
                                                                                                <table>
                                                                                                        <%if (RetentionPanel.Visible||InplaceVer.Checked){ %>
                                                                                                        <tr>
                                                                                                            <td nowrap="nowrap" align="left">

                                                                                                                <asp:Localize ID="Localize8" meta:resourcekey="str_keeplastn"
                                                                                                                    runat="server" Text="Keep Last n versions of each file:"></asp:Localize>

                                                                                                            </td>
                                                                                                            <td>
                                                                                                                <asp:TextBox ID="KeepVers" MaxLength="7" runat="server" Width="80px" onkeypress="ShowSavePanel();"
                                                                                                                    CssClass="form-control" ></asp:TextBox>
                                                                                                            </td>
                                                                                                        </tr>
                                                                                                        <tr>
                                                                                                            <td nowrap="nowrap" align="left" style="padding-left: 0px;">

                                                                                                                <asp:Localize ID="Localize9" meta:resourcekey="keepdeldays" runat="server" Text="Keep deleted files for n days:"></asp:Localize>

                                                                                                            </td>
                                                                                                            <td align="left">
                                                                                                                <asp:TextBox ID="KeepDays" MaxLength="7" runat="server" Width="80px" onkeypress="ShowSavePanel();"
                                                                                                                    CssClass="form-control" ></asp:TextBox>
                                                                                                            </td>

                                                                                                        </tr>
                                                                                                     <tr>
                                                                                                     <td nowrap="nowrap" align="left" style="padding-left: 0px; padding-right:5px;">
                                                                                                         <asp:Localize ID="Localize16" meta:resourcekey="str_ppdays" runat="server" 
                                                                                                            Text="Purge previous versions that are more than n day(s) old:"></asp:Localize>
                                                                                                            <p class="text-muted">
                                                                                                             <asp:Localize ID="Localize17" meta:resourcekey="str_purgepdays" runat="server" 
                                                                                                                 Text="Purge old versions that meets the criteria, regardless if it exceeds version limit. 0 - do not purge based on file time"></asp:Localize>
                                                                                                        </p>
                                                                                                     </td>
                                                                                                     <td align="left">
                                                                                                         <asp:TextBox onkeypress="ShowSavePanel();" 
                                                                                                            ID="PurgePreDays"  Text="0" runat="server"  CssClass="form-control"
                                                                                                            meta:resourcekey="PurgeVerDaysResource1"></asp:TextBox>
                                                                                                                               

                                                                                                     </td>
                                                                                                 </tr>
                                                                                                    
                                                                                                        <%} %>
                                                                                                    <tr>
                                                                                                        <td nowrap="nowrap" align="left">

                                                                                                            <asp:Localize ID="Localize10" meta:resourcekey="asp_string10"
                                                                                                                runat="server" Text="Storage Quota(GB, 0-Unlimited)"></asp:Localize>
                                                                                                        </td>
                                                                                                        <td align="left" width="40px" style="padding-left:5px;">
                                                                                                            <asp:TextBox ID="Quota" MaxLength="7" runat="server" Width="80px" Text="0" onkeypress="ShowSavePanel();"
                                                                                                                CssClass="form-control" meta:resourcekey="QuotaResource1"></asp:TextBox>
                                                                                                        </td>
                                                                                                        </tr>
                                                                                                        <tr>
                                                                                                        <td colspan="2" align="left" style="padding-left: 20px;">

                                                                                                            <asp:CheckBox ID="HideFromAdmin" runat="server" Text="Private Team Folder" onclick="ShowSavePanel();"
                                                                                                                meta:resourcekey="HideFromAdminResource1" />

                                                                                                        </td>
                                                                                                    </tr>
                                                                                                    <tr>
                                                                                                            <td nowrap="nowrap" align="left" style="padding-left: 20px;">

                                                                                                                <asp:Localize ID="Localize15" meta:resourcekey="autodeldays" runat="server" Text="Automatically delete file that has not been changed more than n days"></asp:Localize>

                                                                                                            </td>
                                                                                                            <td align="left">
                                                                                                                <asp:TextBox ID="AutoDelDays" MaxLength="7" runat="server" Width="80px" onkeypress="ShowSavePanel();"
                                                                                                                    CssClass="form-control" meta:resourcekey="KeepDaysResource1"></asp:TextBox>
                                                                                                            </td>

                                                                                                        </tr>
                                                                                                    <%if (!RetentionPanel.Visible){ %>
                                                                                                    <tr>
                                                                                                        <td colspan="2" align="left" style="padding-left: 0px;">

                                                                                                            <asp:CheckBox ID="InplaceVer" runat="server" Text="In place versioning" onclick="ShowSavePanel();"
                                                                                                                meta:resourcekey="InplaceVerResource1" />

                                                                                                        </td>
                                                                                                    </tr>
                                                                                                    <%} %>
                                                                                                </table>
                                                                                            </div>
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                            </td>
                                                                        </tr>
                                                                    </asp:Panel>
                                                                </table>
                                                            </div>
                                                            <div id="page_4_div" style="display: none; align-content:center; align-items:center">
                                                                <table width="100%">
                                                                    <tr>
                                                                        <td align="center">
                                                                <div style="width:100%; max-width:800px;min-height:400px;padding:10px;" >
                                                                <%if (HasLinksPanel.Visible)                                                                    { %>
                                                                <table width="100%">
                                                                        <tr>
                                                                            <td height="48px" style="border-bottom: 1px solid #f0f0f0;">

                                                                            </td>
                                                                            <td width="68px" style="border-bottom: 1px solid #f0f0f0;" onclick='OnAddLink();return false;' title="<%=str_link.Text %>">
                                                                                
                                                                                    
                                                                          <span class="fa fa-plus sectextcolor" aria-hidden="true" style="font-size: 14px; margin-left: 5px; margin-top: -1px; cursor: pointer; position:relative;" >
                                                                            </span>

                                                                                    <i class="gladinet-icons md-24 md-dark hand center toolbtn" style="display: inline-block; margin-top: 6px; margin-left:-35px;" >`</i>
                                                                        
                                                                            
                                                                        <asp:Localize meta:resourcekey="str_link" id="str_link" runat="server" Visible="False">Link to a local folder</asp:Localize>
                                                                    
                                                                </td>
                                                                                
                                                                            
                                                                        </tr>

                                                                    </table>
                                                                <table width="100%" border="0">
                                                            <asp:Repeater ID="LinkedFolderList" runat="server">
                                                                <ItemTemplate>
                                                                    <tr class='x-grid-row  <%# (Container.ItemIndex % 2 == 0)? "": "x-grid-row-alt" %>'>
                                                                        <td width="32px" align="center" >
                                                                            <i class="gladinet-icons md-24 md-dark hand center toolbtn" onclick='UnlinkFolder("<%#DataBinder.Eval(Container.DataItem, "HostId")%>", "<%#DataBinder.Eval(Container.DataItem, "HostName")%>");return false;' style="<%#DataBinder.Eval(Container.DataItem, "DisplayTrash")%> margin-top: -3px; font-size: 16px;">n</i>
                                                                        </td>
                                                                        <td width="32px" align="center" >
                                                                            <i class="gladinet-icons md-24 md-dark hand center toolbtn" onclick='ScanlinkFolder("<%#DataBinder.Eval(Container.DataItem, "HostId")%>", "<%#DataBinder.Eval(Container.DataItem, "HostName")%>");return false;' style="<%#DataBinder.Eval(Container.DataItem, "DisplayTrash")%> margin-top: -3px; font-size: 16px;">&#xBF;</i>
                                                                        </td>
                                                                        <td>
                                                                            <div class="x-grid-cell-inner x-unselectable" style="text-align: left; font-weight: 100 !important; color: #868686;">
                                                                                <%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "HostName").ToString())%>
                                                                            </div>
                                                                        </td>
                                                                        <td>
                                                                            <div class="x-grid-cell-inner x-unselectable" style="text-align: right; font-weight: 100 !important; color: #868686;">
                                                                                <%#DataBinder.Eval(Container.DataItem, "LocalFolder")%></div>
                                                                        </td>
                                                                    </tr>
                                                                </ItemTemplate>
                                                            </asp:Repeater>
                                                        </table>
                                                                <%}else { %>
                                                                <table width="100%">
                                                                    <tr>
                                                                        <td style="padding:40px;" align="center">
                                                                           <p class="sectextcolor"><asp:Localize meta:resourcekey="str_nolinkyet" runat="server"> Currently this team folder is not setup to sync to a local device yet.</asp:Localize></p>
                                                                            <br /><br />
                                                                                                                                                
                                                                            <asp:Localize meta:resourcekey="str_clickadd" runat="server">Aside from on-demand access to the team folder, you can also keep your team folder always in-sync with your on-premise devices for offline access.   Click</asp:Localize> <a href='#' onclick='OnAddLink();return false;' style="font-size: 12px; color: #008000">
                                                                                <asp:Localize meta:resourcekey="str_here" runat="server">here</asp:Localize>
                                                                            </a> <asp:Localize meta:resourcekey="str_addhint" runat="server">to start adding devices to sync this team folder to a local folder on each device added.</asp:Localize>
                                                                        
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                                   
                                                                <%} %>
                                                                    </div>
                                                                            
                                                                        </td>
                                                                    </tr>
                                                                </table>

                                                            </div>
                                                            <div id="page_5_div" style="display: none; padding: 20px;">
                                                                <table align="center">
                                                                                                <tr>
                                                                                                    <td width="128px" align="center" valign="middle">
                                                                                                        <i class="gladinet-icons md-63  hand iconviewitemcolor" style="display: block; margin-top: 20px;" ><%=StorageIcon.Text%></i>
                                                                                                        <asp:Label ID="StorageIcon" runat="server" visible="false"></asp:Label>
                                                                                                    </td>
                                                                                                    <td>
                                                                                            <table width="100%" >

                                                                                                <tr style="border-bottom:1px solid #f0f0f0;" class="filerow">
                                                                                                    <td style="padding: 3px;color: #565656; font-weight: 100; font-size:16px; width: 180px;" align="left">
                                                                                                        <asp:Localize meta:resourcekey="str_pth" runat="server">Path</asp:Localize>
                                                                                                    </td>
                                                                                                     <td width="30px"></td>
                                                                                                    <td style="padding: 3px;color: #565656; font-weight: 100; font-size:16px;" align="left">
                                                                                                        <asp:Label ID="PathLoc" runat="server" meta:resourcekey="PathLocResource1"></asp:Label>
                                                                                                    </td>
                                                                                                   
                                                                                                </tr>
                                                                                                <tr style="border-bottom:1px solid #f0f0f0;" class="filerow">
                                                                                                    <td style="padding: 3px; color: #565656; font-weight:100!important; font-size:16px; width: 180px;" align="left">
                                                                                                        <asp:Localize meta:resourcekey="str_strTpe" runat="server">Storage Type</asp:Localize>
                                                                                                    </td>
                                                                                                    <td>
                                                                                                          <%if(MigrateStoragePanel.Visible) { %>
                                                                                                            <button type="button" class="btn btn-default " style="font-size: 14px; padding-top: 1px; padding-bottom: 1px; padding-left: 3px; padding-right: 3px;" onclick="MigrateStorage()" title="<%= str_mtbs.Text %>">
                                                                                                                <i class="gladinet-icons md-24 md-dark hand center toolbtn"  style=" margin-top: -3px; font-size: 16px;">&#xDC;</i>

                                                                                                            </button>
                                                                                                        
                                                                                                         <asp:Localize meta:resourcekey="str_mtbs" ID="str_mtbs" runat="server" Visible="False">Migrate teamfolder backend storage</asp:Localize>
                                                                                                        <%} %>
                                                                                                        </td>
                                                                                                    <td style="padding: 3px;color: #565656; font-weight: 100;" align="left">
                                                                                                          
                                                                                                    <asp:Label ID="StorageType" runat="server" meta:resourcekey="PathLocResource1"></asp:Label>
                                                                                                    </td>
                                                                                                    
                                                                                                </tr>
                                                                                                <tr style="border-bottom:1px solid #f0f0f0;" class="filerow">
                                                                                                    <td style="padding: 3px; color: #565656; font-weight: 100; font-size:16px; width: 180px;" align="left">
                                                                                                        <asp:Localize meta:resourcekey="str_stg" runat="server">Settings</asp:Localize>
                                                                                                    </td> <td align="left" style="  padding: 0px;">
                                                                                                        <%if(EditStoragePanel.Visible) { %>
                                                                                                            <button type="button" class="btn btn-default " style="font-size: 14px; padding-top: 1px; padding-bottom: 1px; padding-left: 3px; padding-right: 3px;" onclick="EditStorage()" title="<%= str_sss.Text %>">
                                                                                                                <i class="gladinet-icons md-24 md-dark hand center toolbtn"  style=" margin-top: -3px; font-size: 16px;">c</i>
                                                                                                                <asp:Localize meta:resourcekey="str_sss" ID="str_sss" runat="server" Visible="False">Storage Settings</asp:Localize>
                                                                                                            </button>
                                                                                                        <%} %>
                                                                                                          <%if(EditCloudStoragePanel.Visible) { %>
                                                                                                            <button type="button" class="btn btn-default " style="font-size: 14px; padding-top: 1px; padding-bottom: 1px; padding-left: 3px; padding-right: 3px;" onclick="EditCloudStorage()" title="<%= str_sss.Text %>">
                                                                                                                <i class="gladinet-icons md-24 md-dark hand center toolbtn"  style=" margin-top: -3px; font-size: 16px;">c</i>
                                                                                                                <asp:Localize meta:resourcekey="str_sss" ID="Localize14" runat="server" Visible="False">Storage Settings</asp:Localize>
                                                                                                            </button>
                                                                                                        <%} %>
                                                                                                         
                                                                                                         
                                                                                                    </td>
                                                                                                    <td style="padding: 3px;color: #565656; font-weight: 100;" align="left">
                                                                                                        <asp:Label ID="StorageSettings" runat="server" meta:resourcekey="PathLocResource1"></asp:Label>
                                                                                                    </td>
                                                                                                    
                                                                                                </tr>
                                                                                            </table>            
                                                                                                    </td>
                                                                                                </tr>
                                                                                            </table>
                                                            </div>
                                                            <div id="page_7_div" style="display: none; padding: 20px;">
                                                                <table width="100%">
                                                                        
                                                                    <tr>
                                                                        <td colspan="2">
                                                                            <table width="100%" style="background-color: white;" >
                                                                            

                                                                                <tr style="background-color: white; border-bottom: 2px solid #cccccc;">
                                                                                    <td id="col1" style="padding: 10px; font-size: 16px; font-weight: 100; width:100px;color: #868686;" align="left"><asp:Localize runat="server" meta:resourcekey="str_Nam">Name</asp:Localize></td>
                                                                                    <td style="width:1px;background-color:#dcdada;cursor:col-resize;padding:0;" onmousedown="startResizing(event)"></td>
                                                                                    <td style="padding: 10px; font-size: 16px; font-weight: 100;color: #868686;" align="left" colspan="2"><asp:Localize runat="server" meta:resourcekey="str_Loc">Location</asp:Localize></td>
                                                                                    <td width="48px">
                                                                                         <i class="gladinet-icons md-24 md-dark hand center toolbtn" style="display: inline-block; margin-top: 0px;line-height:24px;" onclick="AddFolder();return false;" title="<asp:Localize runat="server" meta:resourcekey="str_addFld">Add Folder</asp:Localize>">&#xAB;</i>&nbsp; &nbsp;
                                                                                    </td>
                                                                                </tr>
                                                                                <asp:Repeater ID="FolderRepeater" runat="server">
                                                                                    <ItemTemplate>
                                                                                        <tr class="filerow" style="border-bottom:1px solid #f0f0f0; padding:10px; ">
                                                                                            
                                                                                            <td style="color: #868686;padding: 10px;" align="left" id="folderRepeaterName_<%# Container.ItemIndex + 1 %>" colspan="2">
                                                                                                <%# DataBinder.Eval(Container.DataItem, "Name") %>
                                                                                            </td>

                                                                                            <td style="color: #868686;padding: 10px;" align="left" id="folderRepeaterValue_<%# Container.ItemIndex + 1 %>">
                                                                                                <%# DataBinder.Eval(Container.DataItem, "Value") %>
                                                                                            </td>
                                                                                            <td style="width:48px;">
                                                                                                <i class="gladinet-icons md-24 md-dark hand center toolbtn" style="display: inline-block; margin-top: 0px;" onclick='RenameFolder("<%# Container.ItemIndex + 1 %>");return false;' title="<asp:Localize meta:resourcekey="str_ren" runat="server">Rename</asp:Localize>">&#xDF;</i>
                                                                                            </td>
                                                                                            <td style="width:48px;">
                                                                                                <i class="gladinet-icons md-24 md-dark hand center toolbtn" style="display: inline-block; margin-top: 0px;" onclick='RemoveFolder("<%# DataBinder.Eval(Container.DataItem, "Name") %>");return false;' title="<asp:Localize meta:resourcekey="str_rem" runat="server">Remove</asp:Localize>">n</i>
                                                                                            </td>

                                                                                        </tr>
                                                                                    </ItemTemplate>
                                                                                </asp:Repeater>
                                                                            
                                                                        </table>
                                                                        </td>
                                                                    </tr>
                                                                    </table>
                                                                </div>
                                                            <iframe id='page_9_div' width="100%" src="/management/TeamFolderBackupRestore.aspx?tid=<%=PubFolderId.Value %>&vdid=<%=SessionDomainId %>"  style="padding:0px; display:none;" frameborder="0" border="0" height="100%"></iframe>
                                                        </td>
                                                    </tr>

                                                </tbody>
                                            </table>
                                            <table id='non_user' width="100%" style="display: none;">
                                                <tr>
                                                    <td style="padding-top: 50px;">
                                                        <div class="guide" style="margin: 6px; margin-left: 26px; margin-right: 26px; vertical-align: middle; padding-top: 8px; padding-bottom: 8px; height: auto; width: 510px;">
                                                            <asp:Localize ID="Localize13" meta:resourcekey="string8" runat="server"
                                                                Text="No user is assigned to access the team folder, please click 'Add User' above to add user(s) to the team folder. The folder will automatically appear under the root folder of each assigned user's cloud drive with the display name."></asp:Localize>
                                                            (<asp:Label ID="ProductLable" runat="server" meta:resourcekey="ProductLableResource1"></asp:Label>)
                                                        </div>
                                                    </td>
                                                </tr>
                                            </table>
                                        
                   

                        <asp:Localize meta:resourcekey="str_tsht" ID="str_thome" runat="server" Visible="False">Tenant Home Storage</asp:Localize>
                        <asp:HiddenField ID="PubFolderId" runat="server" />
                        <asp:HiddenField ID="BackendFolderName" runat="server" />
                    <asp:HiddenField ID="LocalDirLoc" runat="server" />
                        <asp:HiddenField ID="BackendHostId" runat="server" />
                        <asp:HiddenField ID="RootPermPath" runat="server" />
                        <asp:HiddenField ID="StorageIconValue" runat="server" />
                    <asp:HiddenField ID="CurrentPage" runat="server" />
                   
                </td>
            </tr>

            <%if (!CreateNew.Checked && m_CanEdit && string.IsNullOrEmpty(PageReturnUrl)){ %>
            <tr>
                <td style="background: transparent; display: none;">
                    <table cellspacing="0" cellpadding="0" align="left" style="width: 100%">
                        <tr>
                            <td style="background-color: white; cursor: hand; padding: 3px; border: 1px solid #d0d0d0; border-right: 2px solid #a0a0a0; width: 200px; border-bottom: 0px solid #C0C0C0;"
                                align="center" class="tabhead tabheadfront">
                                <b style='font-size: 14px;'>
                                    <asp:Localize ID="Localize1" meta:resourcekey="asp_string8" runat="server"
                                        Text="Team Folder"></asp:Localize></b>
                            </td>
                            <td class="tabhead" style="background-color: white; padding: 3px; background: #E0e0e0; border: 1px solid #f0f0f0; width: 200px; border-right: 1px solid white; border-bottom: 0px solid GRAY;"
                                onclick="OnClickPerm();" align="center">
                                <asp:Localize ID="Localize2" meta:resourcekey="asp_string9" runat="server"
                                    Text="Permissions"></asp:Localize>
                            </td>
                            <td>&nbsp;
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
            <%} %>
        </table>
       
    </div>
    <div class="footer " style="border-left: 0; background-color: white; border-right: 0; border-bottom: 0; vertical-align: middle; margin: 0; display: none; ">
        <table width="100%" style=" text-align: right; padding-right: 64px;"
            align="right">
            <tr>
                <td align="left" style="padding-top: 15px; padding-left: 10px; font-weight: 100; border-top: 1px solid #f0f0f0;">
                    <asp:Panel ID="PermsPanel" runat="server" meta:resourcekey="PermsPanelResource1"></asp:Panel>
                    <asp:Panel ID="TwoWayPanel" runat="server" meta:resourcekey="PermsPanelResource1" Visible="False"></asp:Panel>
                    <asp:CheckBox ID="ShowShareAcl" runat="server" Text="Show share level permission" OnCheckedChanged="ShowShareAcl_CheckedChanged" AutoPostBack="true" />
                    <asp:CheckBox ID="WorkSpace" runat="server" Visible="False"  />
                    <asp:Button ID="RefreshCurPage" runat="server" Text="Del" OnClick="RefreshNow_Click" />
                </td>
                <td align="right" colspan="2" style="padding-top: 15px; padding-right: 10px; border-top: 1px solid #f0f0f0;">
                    <div style="display: none" id='blueloader'>
                    </div>
                    <%if (SessionStartFromServer)
                        { %>
                    <asp:Button ID="Button1" runat="server"
                        OnClientClick="Wait('wait');return true;" TabIndex="7" CssClass="btn btn-default" meta:resourcekey="str_bac" Text="Back"
                        CausesValidation="False" OnClick="ServerList_Click"></asp:Button>
                    <%} %>
                    <% if (m_CanEdit && !ParentSharePanel.Visible)
                        { %>
                    <%if(!CreateNew.Checked) { %>
                    <button class="btn btn-danger" width="128px" onclick="DeletePubNow();return false;"><%=DeleteNow.Text%></button>
                    <% } %>
                    <asp:Button ID="PublishNow" runat="server" Text="Apply" OnClick="PublishNow_Click"
                        Width="128px" OnClientClick="Wait('Applying settings');" CssClass="btn btn-primary gladbtn"
                        meta:resourcekey="PublishNowResource1" />
                    <% } %>

                    &nbsp;&nbsp;&nbsp;&nbsp;
                    <asp:Button ID="CancelPublish" runat="server" Text="Cancel" Width="128px" CausesValidation="False"
                        CssClass="btn btn-default" meta:resourcekey="CancelPublishResource1" OnClick="CancelPublish_Click1" />
                </td>
            </tr>
        </table>
    </div>

    <asp:Panel ID="SharePanel" runat="server"
        meta:resourcekey="SharePanelResource1">
        <div style="border: 0px solid #c0c0c0; padding: 0px; background-color: white; display: none;">
            <table width="100%" align="center" style="">
                <tr style="display: none;">
                    <td class="InputLabel" colspan='2'>
                        <b>
                            <asp:Localize ID="Localize3" meta:resourcekey="string1" runat="server"
                                Text="Folder to be published:"></asp:Localize></b>
                        
                    </td>
                </tr>
                <tr>
                    <td class="InputLabel" colspan='2' style="padding: 5px; padding-top: 5px; padding-left: 0px; border-bottom: 0px solid #e0e0e0; background-color: #fcfcfc;"></td>
                </tr>
                <tr style="display: <%=( string.Compare(SessionCallFrom, "filebrowser", true) != 0 )? "block" :"none"%>;">
                    <td style="padding-top: 8px;">
                        <asp:CheckBox ID="CreateNew" Visible="False" runat="server" Text="Create and publish a new Team Folder (Uncheck to select an existing folder)"
                            AutoPostBack="True" meta:resourcekey="CreateNewResource1" />
                    </td>
                </tr>
                <tr style="display: none;">
                    <td class="InputLabel" width="100%" colspan="2" style="padding-top: 3px; padding-bottom: 5px;">
                        <table>
                            <tr>
                                <td>
                                    <asp:Localize ID="Localize5" meta:resourcekey="string3" runat="server"
                                        Text="Location:"></asp:Localize>
                                </td>
                                <td>
                                    <asp:TextBox ID="Location" runat="server" class="InputText" Width="350px" CssClass="x-form-field x-form-text"
                                        meta:resourcekey="LocationResource1"></asp:TextBox>
                                </td>
                                <td style="padding-left: 5px">
                                    <asp:Button ID="Browse" runat="server" Text="Browse" OnClientClick="OnSelFolder();return false;"
                                        Width="88px" meta:resourcekey="BrowseResource1" />
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>
            </table>
        </div>
    </asp:Panel>
    <div id="myModal" class="modal fade" role="dialog">
        <div class="modal-dialog">

            <!-- Modal content-->
            <div class="modal-content" style="width: 100%;">
                <div class="modal-header" style="background-color: #e0e0e0">
                        <h4 class="modal-title"><span class="fa fa-question-sign"></span></h4>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    
                </div>
                <div class="modal-body" style="font-size: 16px; color: #565656; font-weight: 100;">
                    <asp:Localize meta:resourcekey="str_clbDefMsg" runat="server">Collaborators are users that are assigned to this team share and can access the share from their own accounts. The detailed access permissions are defined in the folder and sub-folder permissions.</asp:Localize>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal"><asp:Localize meta:resourcekey="str_cls" runat="server">Close</asp:Localize></button>
                </div>
            </div>

        </div>
        <asp:HiddenField ID="ReturnURL" runat="server" />
        <asp:HiddenField ID="FolderPermLoc" runat="server" />
    </div>
     <div id="myConfirmModel2" class="modal fade" role="dialog"  >
        <div class="modal-dialog " >

            <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header" style="display: none;">

                    <span style="color:#808080;font-size: 24px;" class="fa fa-exclamation-sign"></span>
                    <span style="color:#808080;font-size: 24px;" ><%=ProductLable.Text%></span>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>                     
                </div>
                <div class="modal-body"  style="height:200px;">
                    <table width="100%">
                        <tr>
                            <td id="ConfirmBodyex" style=" padding-top: 20px; font-size: 16px; height: 180px; color:#565656;" align="center" valign="middle" ></td>
                        </tr>
            
                    </table>
                </div>
       
                <div class="modal-footer">
                    <table width="100%">
                        <tr>
                            <td align="center">
                                <button type="button" class="btn btn-link" data-dismiss="modal" style="width:100px;font-weight: 400; font-size:16px;"  ><asp:Localize runat="server" meta:resourcekey="str_Ok">Ok</asp:Localize></button>            
                            </td>
                        </tr>
                    </table>
                    
                </div>

            </div>

        </div>
    </div>
  <div id="RenameModel" class="modal fade" role="dialog">
      <div class="modal-dialog">
      <!-- Modal content-->
        <div class="modal-content">
          <div class="modal-header">
          </div>
          <div class="modal-body" style="font-weight: 100; color: #565656;">
              <input ID="inpNewName" type="text" class="form-control" onchange="event.preventDefault();return false;" />
              <input ID="inpRptIdx" type="text" style="display:none;" />
              <input ID="inpOldName" type="text" style="display:none;" />
          </div>
          <div class="modal-footer" style="font-size: 16px;">
            <button type="button" id="renameModalApplyBtn" class="btn btn-primary gladbtn" onclick="ApplyRenameFolder()"><span style="font-size: 16px; font-weight: 200;"><asp:Localize meta:resourcekey="str_ren" runat="server">Rename</asp:Localize></span></button>
            <button type="button" id="renameModalCloseBtn" class="btn btn-default" data-dismiss="modal"><span style="font-size: 16px; font-weight: 200;"><asp:Localize meta:resourcekey="str_close" runat="server">Close</asp:Localize></span></button>
          </div>
        </div>
    </div>
  </div>
        <div id="ShortWindowModal" class="modal fade" role="dialog" >
            <div class="modal-dialog " style="width: 850px; max-width:850px; padding:0px!important;">

                <!-- Modal content-->
                <div class="modal-content" style="padding:0px!important;">
                    <div class="modal-header" >
                        <img src="<%=WebAppIcon %>" style="float:left; max-height:32px; max-width:32px;"/>
                        <h4 class="modal-title" style="color: #808080; " id="ShortTitle"></h4>
                        <button type="button" class="close" data-dismiss="modal">&times;</button>
                        
                    </div>
                    <div class="modal-body" style="height: 600px;padding-top:0px;padding:0px!important;" id="ShortBody">
                         <iframe id='ShortWindow' width="100%"  style="padding:0px;"
        frameborder="0" border="0" height="100%"></iframe>
                    </div>
                </div>

            </div>
        </div>
    <div style="display: none;">
        <asp:Button ID="DeleteNow" runat="server" Text="Delete" OnClick="DeleteNow_Click"
                        Width="128px" OnClientClick="Wait('Applying settings');" CssClass="btn btn-primary gladbtn"
                        meta:resourcekey="DeleteNowResource1" />
        <asp:Button runat="server" Text="Button" id="UnlinkBtn" OnClick="UnlinkBtn_Click"></asp:Button><asp:HiddenField ID="DeviceId" runat="server" />
        <asp:Button runat="server" Text="Button" id="btnRenameFolder" OnClick="btnRenameFolder_Click"></asp:Button>
        <asp:Button runat="server" Text="Button" id="RemoveFolder" OnClick="RemoveFolder_Click"></asp:Button>
        <asp:Localize meta:resourcekey="str_allow" id="str_allow" visible="False" runat="server">Allow</asp:Localize>
        <asp:Localize meta:resourcekey="str_deny" id="str_deny" runat="server" Visible="False">Deny</asp:Localize>
        <asp:Button ID="LoadPerm" runat="server" Text="LoadPerm" OnClick="LoadPerm_Click" />
        <asp:HiddenField ID="HasSubFolder" runat="server" />
        <asp:HiddenField ID="TopFolderName" runat="server" />
        
        <asp:TextBox ID="OldFolderName" runat="server" />
        <asp:TextBox ID="NewFolderName" runat="server" />
        <asp:TextBox ID="NewFolderPath" runat="server" />

        <asp:Button ID="EditPerm" runat="server" Text="EditPerm" OnClick="EditPerm_Click" />
                                                                                                                <asp:Panel ID="EditStoragePanel" runat="server" Visible="False">
                                                                                                        </asp:Panel>
        <asp:Panel ID="EditCloudStoragePanel" runat="server" Visible="False">
                                                                                                        </asp:Panel>
                <asp:Panel ID="MigrateStoragePanel" runat="server" Visible="False">
                                                                                                        </asp:Panel>

        <asp:Localize meta:resourcekey="str_empty" id="emptytext" runat="server">The team folder will not be visible to users until the users are added as collaborators to the team folder.</asp:Localize>
                    <asp:Button ID="IconViewBtn" runat="server" Text="Button" 
         onclick="IconViewBtn_Click" />
    <asp:Button ID="ListViewBtn" runat="server" Text="Button" 
         onclick="ListViewBtn_Click" />
                            <asp:Button ID="Commit" runat="server" Text="Apply" OnClick="Commit_Click"
                        Width="128px" OnClientClick="Wait('Applying settings');" CssClass="btn btn-primary gladbtn"
                        meta:resourcekey="PublishNowResource1" />
        <asp:Panel ID="SyncPermBtnPanel" runat="server"></asp:Panel>
        <asp:Panel ID="HasLinksPanel" runat="server" Visible="False"></asp:Panel>
        <asp:Panel ID="RetentionPanel" runat="server"
            meta:resourcekey="RetentionPanelResource1">
                                                   
        </asp:Panel>
         <asp:Label ID="ErrorMsg" runat="server" CssClass="errmsg" meta:resourcekey="ErrorMsgResource1"></asp:Label>
    </div>
    
    <script type="text/javascript">
    
        var myData = [
       <asp:Repeater ID="UsersRepeater" runat="server">
              <ItemTemplate>
             <%#(Container.ItemIndex == 0)? "": "," %>   [  '<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "FirstName").ToString().Replace("'","%27"))%>&nbsp;<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "LastName").ToString().Replace("'","%27"))%>', 
       '<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem,"Email").ToString().Replace("'","%27")) %>','<%#DataBinder.Eval(Container.DataItem, "UserGuid")%>',
       '<%#DataBinder.Eval(Container.DataItem, "ReadRight")%>','<%#DataBinder.Eval(Container.DataItem, "WriteRight")%>','<%#DataBinder.Eval(Container.DataItem, "TeamFolderOwner")%>','<%#DataBinder.Eval(Container.DataItem, "NotificationsRight")%>','']
        
        </ItemTemplate>
    </asp:Repeater>      
        ];

        Ext.require([
            'Ext.grid.*',
            'Ext.data.*',
            'Ext.util.*',
            'Ext.state.*'
        ]);

        function AdjustAlert() {
            
        }


        function RemoveAt(g) {
            ShowSavePanel();
            var rowIndex = grid.getStore().findExact('userguid', g);
            
            grid.getStore().removeAt(rowIndex);
            --UserCount;
            AdjustAlert();
        }

        function AdjustGrodObj()
        {
            try{
                if(document.documentElement.clientWidth > 1900)
                    eleClassName = "gridobject col-2";
                else if(document.documentElement.clientWidth > 1300)
                    eleClassName = "gridobject col-3";
                else if(document.documentElement.clientWidth > 800)
                    eleClassName = "gridobject col-4";
                else
                    eleClassName = "gridobject col-6";
            }catch(e){

            }

            try{
                var elements = document.getElementsByClassName("gridobject");
                if(elements && elements.length != 0){
                    for(var i=0; i< elements.length; ++i){
                        elements[i].className = eleClassName;
                    }
                }
            }catch(e){

            }

        }

        Ext.onReady(function () {
            SetPage("<%=m_CurPage %>","1");

            AdjustGrodObj();
            Ext.QuickTips.init();
            DisplayError();
            Ext.define('User', {
                extend: 'Ext.data.Model',
                fields: [
                    { name: 'fullname' ,    type: 'string' },
                    { name: 'email'   ,   type: 'string'},
                    { name: 'userguid'   ,  type: 'string' },
                    { name: 'readright'  ,    type: 'string'},
                    { name: 'writeright'  ,    type: 'string'},
                    { name: 'owner'  },
                    { name: 'notifications'  },
                    { name: 'hostid'  }
                ]
            });
        
               <%if(m_ShowSaveBtn){%>
            try {
                setTimeout("ShowSavePanel();",200);
            } catch (eeee) {
                
            }
        <%}%>

            var store = Ext.create('Ext.data.ArrayStore', {
                model:'User',
                data: myData
            });

   
            function AdjustPanel() {
                return;
                var Perm = document.getElementById("PermTable");
                var nu = document.getElementById("non_user");

                if (store.getCount() == 0) {
                    Perm.style.display = 'none';
                    nu.style.display = '';
                } else {
                    
                    Perm.style.display = '';
                    nu.style.display = 'none';
            
            
                }
            }

            var vheight = 315;
      <% if (m_ShowAdvanced)
        { %>  
            vheight = 295;
            <% } %>

      <%if (!string.IsNullOrEmpty(PageReturnUrl))
        { %>
            vheight = 375;
      <%}%>

            vheight = document.documentElement.clientHeight - 240;
            <% if (ParentSharePanel.Visible)
        { %>
            vheight -= 65;
       <% } %>
            vheight -= 10;
            <% if (ParentSharePanel.Visible)
        { %>
            vheight -= 100;
            <% } %>
            var e = document.getElementById("maindivw");
            e.style.height = (document.documentElement.clientHeight - 120) + "px";
            e.style.width = (document.documentElement.clientWidth - 9) + "px";
            e = document.getElementById("page_4_div");
            e.style.height = (document.documentElement.clientHeight - 180) + "px";
            e = document.getElementById("page_2_div");
            e.style.height = (document.documentElement.clientHeight - 120) + "px";
            e = document.getElementById("page_1_div");
            e.style.height = (document.documentElement.clientHeight - 160) + "px";
            e = document.getElementById("page_9_div");
            e.style.height = (document.documentElement.clientHeight - 160) + "px";

            
            e = document.getElementById("pubusersex");
            e.style.height = (document.documentElement.clientHeight - 140) + "px";
            e = document.getElementById("permframe");
            //e.style.height = (document.documentElement.clientHeight - 185) + "px";

            
            e = document.getElementById("pubusers");
            e.style.height = (document.documentElement.clientHeight - 180) + "px";
            try {
                e = document.getElementById("userviewcontainer");
                e.style.height = (document.documentElement.clientHeight - 210) + "px";
                e.style.width= (document.documentElement.clientWidth - 15) + "px";
            }catch (eee){}

            try {
                e = document.getElementById("page_3_div");
                e.style.height = (document.documentElement.clientHeight - 180) + "px";
            } catch (eeee) {
                    
            }
            try {
                e = document.getElementById("page_6_div");
                e.style.height = (document.documentElement.clientHeight - 165) + "px";
            } catch (eeee) {
                    
            }
            try {
                e = document.getElementById("page_10_div");
                e.style.height = (document.documentElement.clientHeight - 165) + "px";
            } catch (eeee) {
                    
            }

            try {
                e = document.getElementById("page_8_div");
                e.style.height = (document.documentElement.clientHeight - 165) + "px";
            } catch (eeee) {
                    
            }
            try {
                e = document.getElementById("page_5_div");
                e.style.height = (document.documentElement.clientHeight - 165) + "px";
            } catch (eeee) {
                
            }
            try {
                e = document.getElementById("page_7_div");
                e.style.height = (document.documentElement.clientHeight - 165) + "px";
            } catch (eeee) {
                
            }
            <%if(IsListView) { %>
            grid = Ext.create('Ext.grid.Panel', {
                store: store,
                stripeRows: true,
                columnLines: false,
                scroll: true,
                layout: 'fit',
                height: vheight+20,
                border:false,
                id:'data_grid',
                viewConfig: {
                    emptyText: "<%=emptytext.Text%>",
                deferEmptyText: false
            },
                columns: [
                 {
                     text: "",
                     width: 50,
                     sortable: true,
                     dataIndex: 'userguid',
                     renderer: function (value, metaData, record, rowIndex) {
                         var d= record.data;

                         if (d.fullname.indexOf("[Group]") != -1 ||
                             d.fullname.indexOf("[Proxy(AD)") != -1 ||
                             d.fullname.indexOf("[Proxied") != -1) {
                             return "";
                         }
                         
                         return "<img style='border-radius: 50%;' src='/storage/avarta.dn?u="+unescape(value)+ "&w=32&h=32&d=<%=SessionDomainId%>'/>"  ;
                     }

                 },
              {
                  text: "<asp:Localize meta:resourcekey="js_user_name" runat="server">User Name</asp:Localize>",
                    flex: 1,
            sortable: true,
            dataIndex: 'fullname',
            renderer: function (value, metaData, record, rowIndex) {
                return "<span style='font-size:14px; font-weight:100'>" + unescape(value) + "</span>";
            }

        },
              {
                  text: "<asp:Localize meta:resourcekey="js_email" runat="server">Email</asp:Localize>",
             flex: 1,
         sortable: true,
         dataIndex: 'email',
         renderer: function (value, metaData, record, rowIndex) {
             var d= record.data;
             var s= "<span style='font-size:14px; font-weight:100'>" + unescape(value) + "</span>";
                  <% if (!ShowShareAcl.Checked)
        { %>
                 s += "<div style='display:none;'>";
                 s += '<input onclick="ShowSavePanel();" id="' +d.userguid +'" type="checkbox" ' +d.readright +' name="uu_read_' +d.userguid +'_' +d.fullname.replace('_', '^')+'_' +d.hostid +'"  value="1">';
                 s +='<input  onclick="ShowSavePanel();"  id="' +d.userguid +'" type="checkbox" ' +d.writeright +' name="uu_write_' +d.userguid +'_' +d.fullname.replace('_', '^')+'_' +d.hostid +'"  value="1">';
                 s += "</div>";
                     <% } %>
                 return s;
             }
             }
        <% if (!ParentSharePanel.Visible)
        { %>
            <% if (ShowShareAcl.Checked)
        { %>
              ,
        {
            text: "<asp:Localize meta:resourcekey="js_read" runat="server">Read</asp:Localize>",
            width: 60,
            sortable: true,
                   
            dataIndex: 'readright',
            renderer: function (value, metaData, record, rowIndex) {
                var d= record.data;
                              <% if (!m_CanEdit)
        { %>
                return '<input  onclick="ShowSavePanel();" disabled id="' + d.userguid + '" type="checkbox" '+ value + ' onclick=OnReadChange(' + rowIndex + ') name="uu_read_'+d.userguid+'_'+d.fullname.replace('_','^')+'_' +d.hostid+'"  value="1">';
                              <% }
        else
        { %>
                return '<input  onclick="ShowSavePanel();" id="' + d.userguid + '" type="checkbox" '+ value + ' onclick=OnReadChange(' + rowIndex + ') name="uu_read_'+d.userguid+'_'+d.fullname.replace('_','^')+'_' +d.hostid+'"  value="1">';
                              <% } %>
            }
        },
        {
        text: "<asp:Localize meta:resourcekey="js_write" runat="server">Write</asp:Localize>",
        width: 60,
        sortable: true,
        dataIndex: 'writeright',                
        renderer: function (value, metaData, record, rowIndex) {
            var d= record.data;
                                  <% if (!m_CanEdit)
        { %>
            return '<input  onclick="ShowSavePanel();" disabled id="' + d.userguid + '" type="checkbox" '+ value + ' onclick=OnWriteChange(' + rowIndex + ')  name="uu_write_'+d.userguid+'_'+d.fullname.replace('_','^')+'_' +d.hostid+'"  value="1">' ;
                                  <% }
        else
        { %>
            return '<input  onclick="ShowSavePanel();" id="' + d.userguid + '" type="checkbox" '+ value + ' onclick=OnWriteChange(' + rowIndex + ')  name="uu_write_'+d.userguid+'_'+d.fullname.replace('_','^')+'_' +d.hostid+'"  value="1">' ;
            <% } %>
        }
        }
                <% } %>
              ,
        {
            text: "<asp:Localize meta:resourcekey="js_string10" runat="server">Owner</asp:Localize>",
            width: 95,
            sortable: true,
            dataIndex: 'owner',
            renderer: function (value, metaData, record, rowIndex) {
                var d= record.data;

                if (d.fullname.indexOf("[Group]") != -1 || d.fullname.indexOf("[Proxy(AD)") != -1|| d.fullname.indexOf("[Proxied") != -1|| d.email.indexOf("[Built") != -1) {
                    value = false;
                    return '<input  onclick="ShowSavePanel();"  style="display:none;" id="' + d.userguid + '" type="checkbox"  onclick=OnOwnerChange(' + rowIndex + ')  name="uu_owner_' + d.userguid + '_' + d.fullname.replace('_','^')+'_' +d.hostid + '"  value="1">';
                } else {
                                  <% if (!m_CanEdit)
        { %>
                    if (value == "False")
                        return '<input  onclick="ShowSavePanel();" disabled id="' + d.userguid + '" type="checkbox"  onclick=OnOwnerChange(' + rowIndex + ')  name="uu_owner_' + d.userguid + '_' + d.fullname.replace('_','^') +'_' +d.hostid+ '"  value="1">';
                    return '<input  onclick="ShowSavePanel();" disabled id="' + d.userguid + '" type="checkbox" checked onclick=OnOwnerChange(' + rowIndex + ')  name="uu_owner_' + d.userguid + '_' + d.fullname.replace('_','^')+'_' +d.hostid + '"  value="1">';

                                  <% }
        else
        {%>
                         
                    if (value == "False")
                        return '<input  onclick="ShowSavePanel();" id="' + d.userguid + '" type="checkbox"  onclick=OnOwnerChange(' + rowIndex + ')  name="uu_owner_' + d.userguid + '_' + d.fullname.replace('_','^') +'_' +d.hostid+ '"  value="1">';
                    return '<input  onclick="ShowSavePanel();" id="' + d.userguid + '" type="checkbox" checked onclick=OnOwnerChange(' + rowIndex + ')  name="uu_owner_' + d.userguid + '_' + d.fullname.replace('_','^')+'_' +d.hostid + '"  value="1">';
                    <% } %>
                }
            }
        }


        ,
        {
            text: "<asp:Localize meta:resourcekey="str_ntf" runat="server">Notifications</asp:Localize>",
            width: 95,
            sortable: true,
            dataIndex: 'notifications',
            renderer: function (value, metaData, record, rowIndex) {
                var d= record.data;
                <% if (!m_CanEdit) { %>
                    if (value == "True")
                        return '<input  onclick="ShowSavePanel();" disabled id="' + d.userguid + '" type="checkbox" checked name="uu_ntf_' + d.userguid + '_' + d.fullname.replace('_','^') +'_' +d.hostid+ '"  value="1">';
                    return '<input  onclick="ShowSavePanel();" disabled id="' + d.userguid + '" type="checkbox" name="uu_ntf_' + d.userguid + '_' + d.fullname.replace('_','^')+'_' +d.hostid + '"  value="1">';

                <% } else {%>
                    if (value == "True")
                        return '<input  onclick="ShowSavePanel();" id="' + d.userguid + '" type="checkbox" checked name="uu_ntf_' + d.userguid + '_' + d.fullname.replace('_','^') +'_' +d.hostid+ '"  value="1">';
                    return '<input  onclick="ShowSavePanel();" id="' + d.userguid + '" type="checkbox" name="uu_ntf_' + d.userguid + '_' + d.fullname.replace('_','^')+'_' +d.hostid + '"  value="1">';
               <% } %>
            }
        }


        <% if (m_CanEdit)
        { %>
        ,
        {
        text: "",
            width: 60,
        sortable: true,
        dataIndex: 'writeright',
        renderer: function (value, metaData, record, rowIndex) {
            var d= record.data;
            var s = "<a href='#'   onclick='RemoveAt(\""+d.userguid+"\");return false;'><i class=\"gladinet-icons md-24 md-dark hand center toolbtn\" style=\"display: inline-block; margin-top: 3px; font-size:18px;\" >n</i></a>";
            
            return s;
        }
        }

        <%} %>
            <%} %>
        ],
        renderTo: 'grid-example'
        });
       

        
        <% } %>
        Ext.EventManager.onWindowResize(function () {
            AdjustGrodObj();

            var e = document.getElementById("maindivw");
            e.style.height = (document.documentElement.clientHeight - 105) + "px";
            e.style.width = (document.documentElement.clientWidth - 9) + "px";
            e = document.getElementById("page_4_div");
            e.style.height = (document.documentElement.clientHeight - 165) + "px";
            e.style.width = (document.documentElement.clientWidth - 9) + "px";
            e = document.getElementById("page_2_div");
            e.style.height = (document.documentElement.clientHeight - 105) + "px";
            e.style.width = (document.documentElement.clientWidth - 9) + "px";

            e = document.getElementById("page_1_div");
            e.style.height = (document.documentElement.clientHeight - 145) + "px";
            e.style.width = (document.documentElement.clientWidth - 9) + "px";

            e = document.getElementById("pubusersex");
            e.style.height = (document.documentElement.clientHeight - 115) + "px";
            e.style.width = (document.documentElement.clientWidth - 9) + "px";
            e = document.getElementById("pubusers");
            e.style.height = (document.documentElement.clientHeight - 165) + "px";
            try {
                e = document.getElementById("userviewcontainer");
                e.style.height = (document.documentElement.clientHeight - 195) + "px";
                e.style.width= (document.documentElement.clientWidth - 15) + "px";
            }catch (eee){}

            try {
                e = document.getElementById("page_3_div");
                e.style.height = (document.documentElement.clientHeight - 165) + "px";
            } catch (eeee) {
                    
            }
            try {
                e = document.getElementById("page_6_div");
                e.style.height = (document.documentElement.clientHeight - 165) + "px";
            } catch (eeee) {
                    
            }
            try {
                e = document.getElementById("page_10_div");
                e.style.height = (document.documentElement.clientHeight - 165) + "px";
            } catch (eeee) {
                    
            }

            try {
                e = document.getElementById("page_8_div");
                e.style.height = (document.documentElement.clientHeight - 165) + "px";
            } catch (eeee) {
                    
            }

            try {
                e = document.getElementById("page_5_div");
                e.style.height = (document.documentElement.clientHeight - 165) + "px";
            } catch (eeee) {
                
            }
            try {
                e = document.getElementById("page_7_div");
                e.style.height = (document.documentElement.clientHeight - 165) + "px";
            } catch (eeee) {
                
            }
            if(grid)
            grid.doLayout();
        });

            AdjustAlert();
        });

            function GetShortString(src, MaxLen) {
                if (src.length <= MaxLen)
                    return src;
                src = src.replace('[BuiltInGroup]', '');
                if (src.length <= MaxLen)
                    return src;
                var len = (MaxLen - 3) / 2;
                var p1 = src.substring(0, len);
                var p2 = src.substring(src.length - len);
                return p1 + "..." + p2;

            }
        function AddUserIcon(userid, email, fullname, isgroup, hid) {
            var uv = document.getElementById("userview");
            var append = "";

            if (isgroup)
                append = "_" + hid;
            
            var userdiv = document.createElement("div");
            userdiv.className =  "col-xs-12 col-sm-4 col-md-3 col-lg-2 text-center topbuffer tentu";
            userdiv.id = "m_" + userid;

            userdiv.style.paddingBottom = "10px!important";

            var userpanel = document.createElement("div");
            userpanel.className = "iconobj";
            userpanel.style.maxWidth = "240px";
            userdiv.appendChild(userpanel);
            userpanel.style.padding = "0px!important";

            var userpanelbody = document.createElement("div");
            userpanelbody.className = "tent uncommited";
            userpanelbody.style.maxWidth = "240px";
            userpanel.appendChild(userpanelbody);
            userpanel.title = "not saved";
          
            
            var divbtn = document.createElement("div");
            userpanelbody.appendChild(divbtn);
            divbtn.style = "border-right: 1px solid #ff8f00;border-bottom: 1px solid #ff8f00;  position: relative; width: 32px; height: 32px; border-radius: 0px 0px 70% 0px;";
            
            divbtn.className = "toolbtn";
            
            

            var sp = document.createElement("span");
            sp.id = "sui_" + userid;
            sp.style.cursor = "pointer";
            divbtn.onclick = function() {
                ToggleUIInfo(userid);
            }
            sp.className = "fa fa-edit";
            sp.style.color = "#ff8f00";
            divbtn.appendChild(sp);

            var usertable = document.createElement("table");
            usertable.style.width = "100%";
            
            userpanelbody.appendChild(usertable);
            var tbody = document.createElement("tbody");
            usertable.appendChild(tbody);
            userpanelbody.style.paddingLeft = "0px!important";
            //user info row
            var uitr = document.createElement("tr");
            tbody.appendChild(uitr);
            var uitd = document.createElement("td");
            uitr.appendChild(uitd);
            uitd.style = "height: 200px!important; padding-top: 15px;";
            uitd.align = "center";
            uitd.valign = "top";

            //avarta div
            var pdiv = document.createElement("div");
            pdiv.style = "padding: 2px; width: 128; height: 128px; ";
            pdiv.style.height = "128px";
            pdiv.id = "p_" + userid;
            uitd.appendChild(pdiv);

            var defav = document.createElement("div");
            
            defav.id = "av_" + userid;
            defav.style.paddingTop = "10px";
            pdiv.appendChild(defav);

            if(email === "N/A")
                defav.innerHTML = '<i  class="gladinet-icons  md-dark hand center" style="font-size: 96px; font-weight: 100;">G</i>';
            else
                defav.innerHTML = '<i  class="gladinet-icons  md-dark hand center" style="font-size: 96px; font-weight: 100;">M</i>';
            var realav = document.createElement("img");
            realav.src = "/storage/avarta.dn?u="+userid+"&w=128&h=128&d=<%=SessionDomainId %>";
            realav.id = "i_" + userid;
            realav.onload = function() {
                OnAvLoad(userid);
            };
            realav.style = "display: none; border-radius: 50%;";
            pdiv.appendChild(realav);


            //acl info div
            var infodiv = document.createElement("div");
            infodiv.style = "padding: 2px; width: 100%;display: none;";
            infodiv.id = "info_" + userid;
            uitd.appendChild(infodiv);


            var acltable = document.createElement("table");
            acltable.style.width = "100%";
            infodiv.appendChild(acltable);
            var acltbody = document.createElement("tbody");
            acltable.appendChild(acltbody);

            //email row
            var etr = document.createElement("tr");
            acltbody.appendChild(etr);
            var etd = document.createElement("td");
            etr.appendChild(etd);
            etd.style="font-weight: 100; font-size: 16px; color: #565656; border-bottom: 1px solid #f0f0f0; padding: 3px;";
            etd.align = "center";
            etd.colSpan = "2";
            etd.innerHTML = GetShortString(email,17);
            etd.title = email;


            //space row
            etr = document.createElement("tr");
            acltbody.appendChild(etr);
            etd = document.createElement("td");
            etr.appendChild(etd);
            etd.style="font-weight: 100; font-size: 4px; color: #565656; border-bottom: 0px solid #f0f0f0; padding: 3px;";
            etd.colSpan = "2";
            etd.innerHTML = "&nbsp;";

            //read row
            etr = document.createElement("tr");
            acltbody.appendChild(etr);
            etd = document.createElement("td");
            etr.appendChild(etd);                        
            etd.innerHTML = "Read";
            etd = document.createElement("td");
            etd.width = "32px";
            etr.appendChild(etd);                        
            var ip = document.createElement("input");
            etd.appendChild(ip);
            ip.type = "checkbox";
            ip.onclick = function() {
                
                    ShowSavePanel();
                
            }
            ip.checked = "checked";
            ip.name = "uu_read_" + userid + "_" + fullname+append;
            ip.value = "1";
            <% if (!m_CanEdit){ %>
            ip.disabled = "disabled";
            <% }%>
             <% if (ParentSharePanel.Visible || !ShowShareAcl.Checked){ %>
                etr.style="display:none" 
                <% } %>

            //write row
            etr = document.createElement("tr");
            acltbody.appendChild(etr);
            etd = document.createElement("td");
            etr.appendChild(etd);                        
            etd.innerHTML = "Write";
            etd = document.createElement("td");
            etd.width = "32px";
            etr.appendChild(etd);                        
            ip = document.createElement("input");
            etd.appendChild(ip);
            ip.type = "checkbox";
            ip.onclick = function() {
                
                ShowSavePanel();
                
            }
            ip.checked = "checked";
            ip.name = "uu_write_" + userid + "_" + fullname+append;
            ip.value = "1";
            <% if (!m_CanEdit){ %>
            ip.disabled = "disabled";
            <% }%>
             <% if (ParentSharePanel.Visible || !ShowShareAcl.Checked){ %>
                etr.style="display:none" 
            <% } %>

            //owner row
            etr = document.createElement("tr");
            acltbody.appendChild(etr);
            etd = document.createElement("td");
            etr.appendChild(etd);                        
            etd.innerHTML = "Owner";
            etd = document.createElement("td");
            etd.width = "32px";
            etr.appendChild(etd);                        
            ip = document.createElement("input");
            etd.appendChild(ip);
            ip.type = "checkbox";
            ip.onclick = function() {
                
                ShowSavePanel();
                
            }
            ip.name = "uu_owner_" + userid + "_" + fullname+append;
            ip.value = "1";
            <% if (!m_CanEdit){ %>
            ip.disabled = "disabled";
            <% }%>
            
            if (fullname.indexOf("[Group]") != -1 ||
                             fullname.indexOf("[Proxy(AD)") != -1 ||
                             fullname.indexOf("[Proxied") != -1) {
                etr.style="display:none" ;
            }




            //notifications row
            etr = document.createElement("tr");
            acltbody.appendChild(etr);
            etd = document.createElement("td");
            etr.appendChild(etd);                        
            etd.innerHTML = "<asp:Localize meta:resourcekey="str_ntf" runat="server">Notifications</asp:Localize>";
            etd = document.createElement("td");
            etd.width = "32px";
            etr.appendChild(etd);                        
            ip = document.createElement("input");
            etd.appendChild(ip);
            ip.type = "checkbox";
            ip.onclick = function() {
                
                ShowSavePanel();
                
            }
            ip.name = "uu_ntf_" + userid + "_" + fullname+append;
            ip.value = "1";
            <% if (!m_CanEdit){ %>
            ip.disabled = "disabled";
            <% }%>



               //remove row
            etr = document.createElement("tr");
            acltbody.appendChild(etr);
            etd = document.createElement("td");
            etr.appendChild(etd);           
            etd.colSpan = "2";
            etd.style ="font-weight: 100; font-size: 16px; color: #565656; border-top: 1px solid #f0f0f0; padding: 3px;";
            etd.align = "right";
            var ebutton = document.createElement("button");
            ebutton.className = "btn btn-primary gladbtn";
            ebutton.style = "padding: 0px; margin: 0px; font-weight: 100;";
            ebutton.onclick = function() {
                RemoveUser(userid);
            };
            ebutton.innerHTML = "Remove";
            etd.appendChild(ebutton);
            

            
            //user name row
            var untr = document.createElement("tr");
            tbody.appendChild(untr);
            var untd = document.createElement("td");
            untr.appendChild(untd);
            untd.style = "font-weight: 100; font-size: 16px; color: #565656;";
            untd.innerHTML = GetShortString(fullname,17);


            //now finally add the user
            uv.appendChild(userdiv);
        }
        function OnIocnViewUserSelected(users) {
            

            for(i=0; i<users.length; ++i){
                var para = users[i].split(',');
                
                var eid = document.getElementById("m_"+para[0]);
                if (eid) {
                    
                    continue;
                }

                AddUserIcon(para[0], para[1], para[2]);
            }
        }
        function OnIocnViewGroupSelected(users) {

            
            for(i=0; i<users.length; ++i){
                var para = users[i].split(';');
                
                var eid = document.getElementById("m_"+para[2]);
                if (eid) {
                    
                    continue;
                }
                
                AddUserIcon(para[2], "N/A", "[Proxied Group]"+para[0], true, para[3]);
            }
        }

        function OnNewUserCommitted() {
            OnCancelChanges();
        }

        function OnUserSelected(UserList) {
            
            var ed = document.getElementById("page_2_div");
            if(ed.style.display != "none"){
                ed = document.getElementById("permframe");
                
                ed.contentWindow.OnUserSelected(UserList);
                return;
            }
            var users = UserList.split("\n");
            if(UserList == "")
                return;
            ShowSavePanel();
            <% if (!IsListView){ %>
            OnIocnViewUserSelected(users);
                return;
            <% }%>

               for(i=0; i<users.length; ++i){
                var para = users[i].split(',');
                
                var eid = document.getElementById(para[0]);
                if (eid) {
                    
                    continue;
                }
               
                try {
                    var instance = Ext.create('User',
                    {
                        fullname: para[2],
                        email: para[1],
                        userguid: para[0],
                        readright: 'Checked',
                        writeright: 'Checked',
                        owner: 'False'
                    });
                    grid.getStore().add(instance);
                    ++UserCount;
                } catch (eee) {
                    alert(eee);
                }
            }
            AdjustAlert();
            //AdjustPanel();
        }

        function OnGroupSelected(UserList) {
            var ed = document.getElementById("page_2_div");
            if(ed.style.display != "none"){
                ed = document.getElementById("permframe");
                
                ed.contentWindow.OnGroupSelected(UserList);
                return;
            }
            var users = UserList.split("\n");
            if(UserList == "")
                return;
            ShowSavePanel();
             <% if (!IsListView){ %>
            OnIocnViewGroupSelected(users);
                return;
            <% }%>
            
            for(i=0; i<users.length; ++i){
                var para = users[i].split(';');
                var eid = document.getElementById(para[0]);                
                if (eid)
                    continue;
                
                
                try {
                    var instance = Ext.create('User',
                    {
                        fullname:
                            "<asp:Localize meta:resourcekey="js_ad_group" runat="server">[Proxy(AD) Group] </asp:Localize>" + para[0],
                        email: "N/A",
                        userguid: para[2],
                        readright: 'Checked',
                        writeright: 'Checked',
                        hostid: para[3]
                    });
                    grid.getStore().add(instance);
                    ++UserCount;
                } catch (eee) {
                    alert(eee);
                }
            }

            try{
                document.getElementById("MainContent_ShareName").focus();
            }catch(e){
            }

            AdjustAlert();
            //AdjustPanel();
        }
        function OnReadChange(index){
            var rec = grid.getStore().getAt(index);
            var d = rec.data;

            if( d.readright == 'Checked' )
                d.readright = '';
            else
                d.readright = 'Checked';

        }        

        function OnWriteChange(index){
            var rec = grid.getStore().getAt(index);
            var d = rec.data;

            if( d.writeright == 'Checked' )
                d.writeright = '';
            else
                d.writeright = 'Checked';

        }        

        function OnOwnerChange(index){
            var rec = grid.getStore().getAt(index);
            var d = rec.data;
            d.owner = !d.owner;

        }        
       
        <%if(m_SetLastLink){%>
            try {
                parent.SetLastLink("<%=ShareName.Text%>","/portal/AddPubPage.aspx?vdid=<%=SessionDomainId%>&location=" + GetSanitizedLocation());
            } catch (eeee) {
                
            }
        <%}%>



        function DisplayError() {
            
            var d = document.getElementById("MainContent_ErrorMsg");
            if (d) {
                if (d.innerHTML != "") {
                    var e = document.getElementById("ConfirmBodyex");
                    e.innerHTML = d.innerHTML;
        
                    $('#myConfirmModel2').modal({ backdrop: 'static', keyboard: false });
                }
            }
        }
        
        function ReturnLast()
        {
          
            parent.ReturnLastSub();
        }
        function closeActiveWin() {
            
            OnRefresh();
        }

        

    </script>
</asp:Content>
