﻿<%@ Page Title="Gladinet Cloud - Background Tasks" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="TenantTasks.aspx.cs" Inherits="GladinetPayFlow.TenantTasks"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
        .titlecol
        {
            background-color: #f0f0f0;
            font-size: 14px;
        }
    </style>
    <script type="text/javascript">
        function getScrollXY() {
            var scrOfX = 0, scrOfY = 0;
            if (typeof (window.pageYOffset) == 'number') {
                //Netscape compliant
                scrOfY = window.pageYOffset;
                scrOfX = window.pageXOffset;
            } else if (document.body && (document.body.scrollLeft || document.body.scrollTop)) {
                //DOM compliant
                scrOfY = document.body.scrollTop;
                scrOfX = document.body.scrollLeft;
            } else if (document.documentElement && (document.documentElement.scrollLeft || document.documentElement.scrollTop)) {
                //IE6 standards compliant mode
                scrOfY = document.documentElement.scrollTop;
                scrOfX = document.documentElement.scrollLeft;
            }
            //return [scrOfX, scrOfY];
            return scrOfY;
        }

         function ViewFailedTask(tid)
        {
            window.location = "/management/MigSubtasks.aspx?vdid=<%=SessionDomainId%>&tid="+tid;
        }


        function ClearErrorMsg() {

            var d = document.getElementById("errmsgdiv");
            if (d) {
                d.style.display = 'none';
            }
        }
        setTimeout("ClearErrorMsg()", 30000);
        //parent.setActivePanel("UserMgr");

        function ViewTaskDetail(id, t)
        {
            window.location= "TenantTaskDetail.aspx?&vdid=<%=SessionDomainId%>&id="+id;
        }

       

        function OpenHtmlWindowShort(id, title, Html, w, h) {

            activewin = new Ext.Window({
                id: id,
                title: title,
                width: w,
                height: maxh(h),
                plain: true,
                modal: true,
                constrain: true,
                maximizable: false,
                maximized: false,
                bodyPadding: 5,
                resizable: false,
                shadow: 'drop',
                iconCls: 'publish',
                bodyStyle: 'background:#dfe8f6;border:0px; ',
                shadowOffset: 10,
                html: Html,
                defaults: {
                    border: false
                }
            });
            activewin.show();

        }


        function closeCancelActiveWin() {
            activewin.close();
        }

        function closeActiveWin() {
            window.location = "/management/AttachedFolders.aspx";
        }

        function OnWipeDevice(id, name) {
            var ng = document.getElementById("ctl00_MainContent_DeviceId");
            var btn = document.getElementById("ctl00_MainContent_WipeDevice");

            if (confirm("<asp:Localize meta:resourcekey="str_confirmdel" runat="server">Confirm delete the task(</asp:Localize>" + unescape(name) + ")?")) {

                Wait('<asp:Localize meta:resourcekey="js_string12" runat="server">Detaching...</asp:Localize>');
                ng.value = id;
                btn.click();
            }
        }

        function OnloadLog(id, name) {
            var ng = document.getElementById("ctl00_MainContent_DeviceId");
            var btn = document.getElementById("ctl00_MainContent_TaskLog");
            ng.value = id;
            btn.click();
        }

        function OnAttachFolder() {
            window.location = "/management/AddAttachedFolder.aspx?id=<%=HiddenInstanceId.Value%>&name=<%=HiddenDeviceName.Value %>";
        }
        function OnDeviceList() {
            window.location = "<%=PageReturnUrl %>";
        }

        function OpenSubTask(tid, t) {
            window.location = "DeviceSubTasks.aspx?id=<%=HiddenInstanceId.Value%>&tid="+tid+"&t=" + t;
        }

    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">

    <nav class="navbar navbar-default" role="navigation" style="border-bottom: 1px solid #c0c0c0;  box-shadow: 3px 3px 3px white;">
               <div class="container-fluid" style=" border-bottom: 0px solid #c0c0c0; box-shadow: 0px!important;">
                   
                   <button type="button" class="btn btn-default navbar-btn navbar-left " title="<%=STRDevList.Text %>" onclick="OnDeviceList()" style="display: none;"> 
                <span class="fa fa-menu-left"></span>  
                       <asp:Localize meta:resourcekey="str_devlist" ID="STRDevList" runat="server" 
                           Text="Return"></asp:Localize>
             </button>

                   <p class="navbar-text dark">
                        <asp:Label ID="UserCount" runat="server" meta:resourcekey="UserCountResource1"></asp:Label>
                            <asp:Label ID="GuestQuota" runat="server" Visible="False" Text="0 available guest user quota"
                                meta:resourcekey="GuestQuotaResource1"></asp:Label>
                   </p>
                   <div id="errmsgdiv" class="navbar-text">
                       <b>
                          <asp:Label ID="ErrorMsg" runat="server" Style="color: Red;" meta:resourcekey="ErrorMsgResource1"></asp:Label></b>
                   </div>
                   <div  class=" navbar-right dark" style="margin-right: 8px;">
                       <table>
                           <tr>
                               <td>
                       <span class="fa fa-refresh" aria-hidden="true"></span>
                                   <asp:Localize runat="server" ID="LocPlsWat" meta:resourcekey="str_plsWat" Visible="False">Please Wait</asp:Localize> 
                       <asp:LinkButton ID="RefreshBtn"  runat="server" 
                           OnClick="LinkButton2_Click"  ><asp:Localize meta:resourcekey="str_rsf" runat="server">Refresh</asp:Localize> <asp:Label ID="DeviceName" Visible="False" runat="server" Text="Label" meta:resourcekey="DeviceNameResource1"></asp:Label></asp:LinkButton>
                                   <%
                                       RefreshBtn.OnClientClick = String.Format("Wait('{0}');return true;", LocPlsWat.Text);
                                   %>
                               </td>
                               <td>
                        <div class="dropdown">
                <button class="btn btn-default dropdown-toggle" type="button" data-toggle="dropdown"><span class="fa fa-plus" style="color: #808080"></span>&nbsp;<span class="caret"></span></button>
                <ul class="dropdown-menu" style="margin-left:-100px; padding:5px;">
                        <li style="font-weight:100!important;"><asp:LinkButton ID="InitialDataSeeding" runat="server" Font-Size="12px" ForeColor="#404040" 
                                                                OnClick="InitialDataSeeding_Click"><asp:Localize meta:resourcekey="str_addnewseed" runat="server">Add New Data Seeding Task</asp:Localize></asp:LinkButton>    
                        </li>
                        <li><asp:LinkButton ID="AddScanTask" runat="server" Font-Size="12px" ForeColor="#404040" 
                                                                OnClick="AddScanTask_Click"><asp:Localize meta:resourcekey="str_addnewscan" runat="server">Add New Storage Scan Task</asp:Localize></asp:LinkButton>    
                        </li>
                    <%if (SessionIsClusterAdmin)
                        { %>
                    <li><asp:LinkButton ID="AddStorageMigrateTask" runat="server" Font-Size="12px" ForeColor="#404040" 
                                                                OnClick="AddStorageMigrateTask_Click"><asp:Localize meta:resourcekey="str_addnewmig" runat="server">Add New Home Storage Migration Task</asp:Localize> (Beta)</asp:LinkButton>    
                        </li>
                    <li><asp:LinkButton ID="AddAnchorMigrateTask" runat="server" Font-Size="12px" ForeColor="#404040" 
                                                                OnClick="AddAnchorMigrateTask_Click"><asp:Localize meta:resourcekey="str_addnewanc" runat="server">Add New Anchor Migration Task</asp:Localize> (Beta)</asp:LinkButton>    
                        </li>
                       <%} %>
                  </ul>
            </div>  
                                   
                               </td>
                           </tr>
                       </table>
                   </div>
               </div>
           </nav>
    <table id="grid-table" width="95%" align="center" style="background-color: transparent;
        margin-top: 18px;" cellspacing="0" cellpadding="0">
        <tr>
            <td id="grid-example" valign="top" style="background-color: transparent; padding: 10px; padding-top: 30px;">
                <div class="row " align="center">
                    <asp:Repeater ID="UsersRepeater" runat="server" OnItemCommand="UsersRepeater_ItemCommand"
                        OnItemDataBound="OnUserItemBound">
                        <ItemTemplate>
                            <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 text-center topbuffer">
                                <div class=" panel panel-default " style=" align-content: center; border-radius:3px; border:1px solid #e0e0e0;"
                                    align="center">
                                    <table width="100%">
                                        <tr>
                                            <td width="80px;" valign="middle" align="center" style="border-right: 1px dashed #d0d0d0; ">
                                                <table width="100%">
                                                    <tr>
                                                       <td style="padding: 5px;padding-top: 10px;" align="center">
                                                 <span class='fa <%# DataBinder.Eval(Container.DataItem, "SyncStatusIcon") %>  ' 
                                                     title='<%# DataBinder.Eval(Container.DataItem, "SyncStatusString") %>' 
                                                     style='color:<%# DataBinder.Eval(Container.DataItem, "SyncStatusColor") %>; font-size: 32px; cursor: pointer;'></span>
                                                           
                                                       </td>
                                                    </tr>
                                                    <tr>
                                                        <td align="center">
                                                        <table>
                                                            <tr>
                                                                <td style="<%# DataBinder.Eval(Container.DataItem, "ResumeDisplay") %>">
                                                                    <a class="btn btn-primary gladbtn" href="#" onclick="ResumeTask('<%# DataBinder.Eval(Container.DataItem, "TaskId") %>');return false;" style="font-size: 10px;padding:2px; font-weight: 100;"><asp:Localize meta:resourcekey="str_res" runat="server">Resume</asp:Localize></a>
                                                                </td>
                                                                <td style="<%# DataBinder.Eval(Container.DataItem, "PauseDisplay") %>">
                                                                    <a class="btn btn-primary gladbtn" href="#" onclick="PauseTask('<%# DataBinder.Eval(Container.DataItem, "TaskId") %>');return false;" style="font-size: 10px; padding:2px; font-weight: 100;"><asp:Localize meta:resourcekey="str_pse" runat="server">Pause</asp:Localize></a>
                                                                </td>

                                                                <td style="<%# DataBinder.Eval(Container.DataItem, "StartDisplay") %>">
                                                                    <a class="btn btn-primary gladbtn" href="#" onclick="StartTask('<%# DataBinder.Eval(Container.DataItem, "TaskId") %>');return false;" style="font-size: 10px; padding:2px; font-weight: 100;"><asp:Localize meta:resourcekey="str_rst" runat="server">Re-start</asp:Localize></a>
                                                                </td>
                                                            </tr>
                                                        </table>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </td>
                                            <td>
                                                <table width="100%" >
                                                    <tr>
                                                       <td colspan="4" style="padding-left: 10px;">
                                                           <table width="100%">
                                                               <tr>
                                                                   <td>
                                                           <h4 style="color: #404040; font-weight: 100;">
                                                                <%#DataBinder.Eval(Container.DataItem,"TaskDesc") %>
                                                            </h4>            
                                                                   </td>
                                                                   
                                                               </tr>
                                                           </table>
                                                           
                                                       </td> 
                                                    </tr>
                                                    <tr>
                                                        
                                                        <td colspan="4" style="padding: 5px; padding-right: 10px; color: #808080;" valign="bottom" align="left" >
                                                            <div class="progress" style="<%#DataBinder.Eval(Container.DataItem,"SyncProgressBarDisplay")%>">
                                                                <div class="progress-bar  <%#DataBinder.Eval(Container.DataItem,"SyncProgressBarType") %>" role="progressbar" aria-valuenow="40"
                                                                    aria-valuemin="0" aria-valuemax="100" style="width:<%#DataBinder.Eval(Container.DataItem,"SyncProgressPercent") %>%">

                                                                  </div>
                                                                </div>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        
                                                        
                                                        <td style="border-top:1px dashed #d0d0d0;padding: 5px; " class="text-muted" width="120px">
                                                            <asp:Localize meta:resourcekey="str_totTsk" runat="server">Total Tasks</asp:Localize>:<%#DataBinder.Eval(Container.DataItem,"TotalTaskCount") %></td>
                                                        <td  style="border-top:1px dashed #d0d0d0;padding: 5px; " class="text-muted" width="120px">
                                                            <asp:Localize meta:resourcekey="str_pndTsk" runat="server">Pending Tasks</asp:Localize>: <%#DataBinder.Eval(Container.DataItem,"PendingTaskCount") %>
                                                        </td>
                                                        <td  style="border-top:1px dashed #d0d0d0;padding: 5px; " class="text-muted" width="120px">
                                                             <asp:Localize meta:resourcekey="str_fldTsk" runat="server">Failed Tasks</asp:Localize>:<%#DataBinder.Eval(Container.DataItem,"FailedTaskCount") %>
                                                            <button class="btn btn-primary gladbtn" onclick="ViewFailedTask('<%# DataBinder.Eval(Container.DataItem, "TaskId") %>');return false"><span class='gladinet-icons md-24 md-dark hand center toolbtn' >&#xBF;</span></button>
                                                        </td>
                                                        <td  style="border-top:1px dashed #d0d0d0;padding: 5px; " class="text-muted" width="120px">
                                                            <asp:Localize meta:resourcekey="str_skdTsk" runat="server">Skipped Tasks</asp:Localize>:<%#DataBinder.Eval(Container.DataItem,"SkippedTaskCount") %>
                                                            </td>
                                                    </tr>
                                                </table>
                                            </td>
                                            <td width="64px" align="center" style=" border-right: 1px solid #f0f0f0;border-left: 1px solid #f0f0f0;">
                                                                       <span title="View Detail" class="fa fa-eye sectextcolor" style="font-size: 24px;cursor: pointer;" onclick='ViewTaskDetail("<%# DataBinder.Eval(Container.DataItem, "TaskId") %>","<%#DataBinder.Eval(Container.DataItem,"TaskDesc").ToString().Replace("\\","_") %>");'></span>
                                                                   </td>
                                            <td width="64px" align="center" style="border-right: 1px solid #f0f0f0;border-left: 1px solid #c0c0c0;">
                                                                       <span title="<asp:Localize meta:resourcekey="str_dwdLogFil" runat="server">Download log file</asp:Localize>" class="fa fa-file sectextcolor" style="font-size: 24px;cursor: pointer;" onclick='OnloadLog("<%# DataBinder.Eval(Container.DataItem, "TaskId") %>","<%#DataBinder.Eval(Container.DataItem,"TaskDesc").ToString().Replace("\\","_") %>");'></span>
                                                                   </td>
                                            <td width="64px" align="center" style="">
                                                                       <span class="fa fa-remove sectextcolor" style="font-size: 24px;  cursor: pointer;" onclick='OnWipeDevice("<%# DataBinder.Eval(Container.DataItem, "TaskId") %>","<%#DataBinder.Eval(Container.DataItem,"TaskDesc").ToString().Replace("\\","_") %>");'></span>
                                                                   </td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </ItemTemplate>
                    </asp:Repeater>
                </div>
            </td>
        </tr>
                                                                    <tr style="display: none;">
                                                                <td>
                                                                    <asp:Button ID="Resume" runat="server" Text="Resume" CssClass="btn btn-primary gladbtn" 
                                                                        onclick="Resume_Click" meta:resourcekey="asp_res" />
                                                                    <asp:Button ID="Pause" runat="server" Text="Pause" CssClass="btn btn-primary gladbtn" 
                                                                        onclick="Pause_Click" meta:resourcekey="asp_pse" />
                                                                    <asp:Button ID="Start" runat="server" Text="Start" CssClass="btn btn-primary gladbtn" 
                                                                        onclick="Start_Click" meta:resourcekey="asp_str" />

                                                                </td>
                                                            </tr>

    </table>
    <asp:HiddenField ID="DeviceId" runat="server" />
    <asp:HiddenField ID="HiddenTaskId" runat="server" />
    <div style="display: none;">
        <asp:Button ID="WipeDevice" runat="server" OnClick="WipeDevice_Click" meta:resourcekey="WipeDeviceResource1" />
        <asp:Button ID="TaskLog" runat="server" OnClick="TaskLog_Click" meta:resourcekey="WipeDeviceResource1" />
    </div>
    <script type="text/javascript">
        var grid;
        function AdjustGridTable() {
            

            var e = document.getElementById("grid-example");
            e.style.height = (document.documentElement.offsetHeight - 120) + "px";
        }

        Ext.onReady(function () {
            Ext.EventManager.onWindowResize(AdjustGridTable);
            AdjustGridTable();
        });

        function ResumeTask(tid) {
            var b = document.getElementById("ctl00_MainContent_Resume");
            var t = document.getElementById("ctl00_MainContent_HiddenTaskId");

            t.value = tid;
            Wait('<%=LocPlsWat.Text%>');
            b.click();
        }

        function PauseTask(tid) {
            var b = document.getElementById("ctl00_MainContent_Pause");
            var t = document.getElementById("ctl00_MainContent_HiddenTaskId");

            t.value = tid;
            Wait('<%=LocPlsWat.Text%>');
            b.click();

        }

        function StartTask(tid) {
            var b = document.getElementById("ctl00_MainContent_Start");
            var t = document.getElementById("ctl00_MainContent_HiddenTaskId");

            t.value = tid;
            Wait('<%=LocPlsWat.Text%>');
            b.click();

            

        }


    </script>
    <asp:HiddenField ID="HiddenInstanceId" runat="server" />
    <asp:HiddenField ID="HiddenDeviceName" runat="server" />
    <asp:HiddenField ID="backtotarget" runat="server" />    
    <asp:HiddenField ID="HiddenTaskType" runat="server" />
</asp:Content>
