﻿<%@ Page Title="Client Management Console" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="TenantTaskDetail.aspx.cs" Inherits="GladinetPayFlow.TenantTaskDetail"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
        td {
            font-size: 15px;
            font-weight: 100;
        }

        b {
            font-weight: 500;
        }

        .badgefont {
            font-size: 15px;
        }


        .err {
            color: red;
        }

        .smallbtn {
            padding-left: 3px !important;
            padding-right: 3px !important;
            font-weight: 100 !important;
        }
    </style>
    <script type="text/javascript">
        function ReturnLast() {
        window.location = "<%=PageReturnUrl %>";
    }
        function ViewFailedTask()
        {
            window.location = "/management/MigSubtasks.aspx?vdid=<%=SessionDomainId%>&tid=<%=HiddenTaskId.Value %>";
        }
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
    
<asp:Localize ID="LocTasPen" meta:resourcekey="str_tasPen" runat="server" Visible="False">task pending</asp:Localize>
<asp:Localize ID="LocRun" meta:resourcekey="str_run" runat="server" Visible="False">Running</asp:Localize>
<asp:Localize ID="LocTasPau" meta:resourcekey="str_tasPau" runat="server" Visible="False">Task paused</asp:Localize>
<asp:Localize ID="LocTasFai" meta:resourcekey="str_tasFai" runat="server" Visible="False">Task Failed:</asp:Localize>
<asp:Localize ID="LocFaiToRetSynSta" meta:resourcekey="str_faiToRetSynSta" runat="server" Visible="False">Failed to retrieve sync status</asp:Localize>
<asp:Localize ID="LocCom" meta:resourcekey="str_com" runat="server" Visible="False">Completed</asp:Localize>
<asp:Localize ID="LocUnk" meta:resourcekey="str_unk" runat="server" Visible="False">unknown</asp:Localize>
<asp:Localize ID="LocNotFou" meta:resourcekey="str_notFou" runat="server" Visible="False">Not found</asp:Localize>
    <div style="background-color: white; width: 100%; font-size: 16px; padding: 0px;">
        <table width="100%">

            <tr>
                <td style="padding-bottom: 5px; padding: 10px; font-size: 18px; font-weight: 100; color: #404040; height: 60px; border-bottom: 0px solid #cccccc" align="center">
                    <asp:Label ID="TaskName" runat="server"></asp:Label>
                </td>
                <td>
                    <asp:Label ID="ErrorMsg" ForeColor="Red" runat="server"></asp:Label>
                </td>
                <td width="30px" style="padding-right:10px;">
                    <div style="float:right; font-size:32px;  font-weight:100; cursor:pointer;" class="sectextcolor" onclick="ReturnLast();">&times;</div>
                </td>
            </tr>
            <tr>
                <td colspan="2" style="height:20px; color:red;" id="PollRes" align="center">&nbsp;</td>
            </tr>
            <tr>
                <td id="main_body_td" style="background-color: white; padding: 10px; overflow: hidden;" align="center" colspan="3">
                    <div style="padding:5px; max-width:900px;" >
                    <table width="100%" style="max-width: 900px">
                        <tr>
                            <td width="40%" style="padding-top:0px;" valign="top">
                                <table width="100%">
                                    <tr>
                                        <td colspan="2" style="font-size:24px;padding-bottom:10px;" align="center" >
                                            <asp:Localize runat="server" meta:resourcekey="str_smr">Summary</asp:Localize>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="padding: 5px; border-bottom: 1px solid #f0f0f0;font-size:18px; color:#565656;"><asp:Localize runat="server" meta:resourcekey="str_sts">Status</asp:Localize></td>
                                        <td style="padding: 5px; border-bottom: 1px solid #f0f0f0;font-size:18px; color:#565656;" class="sectextcolor" id="iTaskStatus" colspan="2">
                                            <asp:Label ID="TaskStatus" runat="server" Text=""></asp:Label>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="padding: 5px; border-bottom: 1px solid #f0f0f0;font-size:18px; color:#565656;"><asp:Localize runat="server" meta:resourcekey="str_ttlTsk">Total Tasks</asp:Localize></td>
                                        <td style="padding: 5px; border-bottom: 1px solid #f0f0f0;font-size:18px; color:#565656;" class="sectextcolor" id="iTotalTask" colspan="2">
                                            <asp:Label ID="TotalTask" runat="server" Text=""></asp:Label>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="padding: 5px; border-bottom: 1px solid #f0f0f0;font-size:18px; color:#565656;"><asp:Localize runat="server" meta:resourcekey="str_pndTsk">Pending Tasks</asp:Localize></td>
                                        <td style="padding: 5px; border-bottom: 1px solid #f0f0f0;font-size:18px; color:#565656;" class="sectextcolor" id="iPendingTask" colspan="2">
                                            <asp:Label ID="PendingTask" runat="server" Text=""></asp:Label>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="padding: 5px; border-bottom: 1px solid #f0f0f0;font-size:18px; color:#565656;"><asp:Localize runat="server" meta:resourcekey="str_fldTsk">Failed Tasks</asp:Localize></td>
                                        <td style="padding: 5px; border-bottom: 1px solid #f0f0f0;font-size:18px; color:#565656;" class="sectextcolor" id="iFailedTask">
                                            <asp:Label ID="FailedTask" runat="server" Text=""></asp:Label>
                                        </td>
                                        <td width="32px" style="padding: 5px; border-bottom: 1px solid #f0f0f0;" >
                                             <button class="btn btn-primary gladbtn" onclick="ViewFailedTask();return false"><span class='gladinet-icons md-24 md-dark hand center toolbtn' >&#xBF;</span></button>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="padding: 5px; border-bottom: 1px solid #f0f0f0;font-size:18px; color:#565656;"><asp:Localize runat="server" meta:resourcekey="str_skpTsk">Skipped Tasks</asp:Localize></td>
                                        <td style="padding: 5px; border-bottom: 1px solid #f0f0f0;font-size:18px; color:#565656;" class="sectextcolor" id="iSkippedTask" colspan="2">
                                            <asp:Label ID="SkippedTask" runat="server" Text=""></asp:Label>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td colspan="3" style="padding:10px; padding-top:20px;" align="right">
                                            <table>
                                                            <tr>
                                                                <td id="tdr" style="display:none;">                                                                    
                                                                    <asp:Button ID="Resume" runat="server" Text="Resume" CssClass="btn btn-primary gladbtn" OnClick="Resume_Click" />
                                                                </td>
                                                                <td id="tdp" style="display:none;">
                                                                    <asp:Button ID="Pause" runat="server" Text="Pause" CssClass="btn btn-primary gladbtn" OnClick="Pause_Click"  />
                                                                </td>

                                                                <td id="tds" style="display:none;">
                                                                    <asp:Button ID="Start" runat="server" Text="ReStart" CssClass="btn btn-primary gladbtn" OnClick="Start_Click"  />
                                                                </td>
                                                            </tr>
                                                        </table>
                                        </td>
                                    </tr>
                                </table>
                            </td>
                            <td style="width:3px; ">&nbsp;</td>
                            <td valign="top" style="padding-top:0px; border-left:1px solid #f0f0f0;">
                                <table width="100%" >
                                    <tr>
                                        <td  colspan="2" style="font-size:24px; padding-bottom:10px;" align="center">
                                            <asp:Localize runat="server" meta:resourcekey="str_prg">Progress</asp:Localize>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td colspan="2" id="ProcessStatus" style="padding:5px;" class="sectextcolor">

                                        </td>
                                    </tr>
                                    <tr>
                                        <td width="120px" style="padding:5px;font-size:18px; color:#565656;"><asp:Localize runat="server" meta:resourcekey="str_ovl">Overall</asp:Localize></td>
                                        <td >
                                            <div class="progress" style="width:100%;">
                                                                <div class="progress-bar  <%#SyncProgressBarType.Value %>" role="progressbar" aria-valuenow="40" id="iTaskProgress"
                                                                    aria-valuemin="0" aria-valuemax="100" style="width:<%=SyncProgressPercent.Value %>%">

                                                                  </div>
                                                                </div>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td colspan="2" style="height:250px; overflow-y:auto;padding:5px;" valign="top">
                                            <table width="100%">
                                                <tbody id="Running">

                                                </tbody>
                                            </table>
                                        </td>
                                    </tr>

                                    </table>
                            </td>
                        </tr>
                    </table>
                        </div>
                </td>
            </tr>
        </table>
    </div>
    <div style="display: none;">
        
        <asp:HiddenField ID="SyncProgressBarType" runat="server" />
        <asp:HiddenField ID="HiddenTaskId" runat="server" />
        <asp:HiddenField ID="SyncProgressPercent" runat="server" />
        
    </div>
    <script type="text/javascript">



        function stringStartsWith(s, p) {
            return (s.indexOf(p) == 0);
        }
        function GetShortString(src, MaxLen) {
            if (src.length <= MaxLen)
                return src;
            src = src.replace('[BuiltInGroup]', '');
            if (src.length <= MaxLen)
                return src;
            var len = (MaxLen - 3) / 2;
            var p1 = src.substring(0, len);
            var p2 = src.substring(src.length - len);
            return p1 + "..." + p2;

        }

        function FormatFileSize(size) {
            if (size < 1024) { //pow(2,10)
                return size + " B";
            } else if (size < 1048576) { //pow(2,20)
                return (Math.round(((size * 10) / 1024)) / 10) + " KB";
            } else if (size < 1073741824) { //pow(2,30)
                return (Math.round(((size * 10) / 1048576)) / 10) + " MB";
            } else if (size < 1099511627776) { //pow(2,40)
                return (Math.round(((size * 100) / 1073741824)) / 100) + " GB";
            } else if (size < 1125899906842624) { //pow(2,50)
                return (Math.round(((size * 100) / 1099511627776)) / 100) + " TB";
            } else { //pow(2,60)
                return (Math.round(((size * 100) / 1125899906842624)) / 100) + " PB";
            }
        }
        function AddRunningTask(res)
        {
            try{
                var e = document.getElementById("Running");
                e.innerHTML = "";

                var count = Math.floor((res.length - 8) / 4);
                for (var i = 0; i < count; ++i) {
                    var etr = document.createElement("tr");
                    etr.style.fontSize = "12px";
                    etr.style.borderBottom = "1px solid #f0f0f0";
                    var ttd = document.createElement("td");
                    ttd.innerHTML = res[8 + i * 4];
                    etr.appendChild(ttd);
                    ttd.style.width = "60px";
                    ttd.className = "sectextcolor";

                    var ntd = document.createElement("td");
                    ntd.innerHTML = GetShortString(res[8 + i * 4 + 1], 20);
                    etr.appendChild(ntd);


                    var ptd = document.createElement("td");
                    ptd.align = "right";
                    ptd.fontSize = "10px";
                    ptd.className = "sectextcolor";
                    if (res[8 + i * 4 + 2] != 0) {
                        ptd.innerHTML = FormatFileSize(res[8 + i * 4 + 3]) + "/" + FormatFileSize(res[8 + i * 4 + 2]);
                    }
                    etr.appendChild(ptd);

                    e.appendChild(etr);
                }
            } catch (eee) {

            }
        } 
        function onChangeTaskStatus(s)
        {
            var tdr = document.getElementById("tdr");
            var tdp = document.getElementById("tdp");
            var tds = document.getElementById("tds");

            if (s == "Task Pending") {
                tdr.style.display = "none";
                tdp.style.display = "";
                tds.style.display = "none";
            }
            else if (s == "Task Running") {
                tdr.style.display = "none";
                tdp.style.display = "";
                tds.style.display = "none";
            } else if (s == "Task Paused") {
                tdr.style.display = "";
                tdp.style.display = "none";
                tds.style.display = "none";
            } else if (s == "Completed") {
                tdr.style.display = "none";
                tdp.style.display = "none";
                tds.style.display = "none";
            } else {
                tdr.style.display = "";
                tdp.style.display = "none";
                tds.style.display = "";
            }
        }
        function OnPollRes(m) {
            try{
                var e = document.getElementById("PollRes")
                if (stringStartsWith(m, "bad^")) {
                    e.innerHTML = m.substring(4);
                    setTimeout("Poll()", 3000);
                    return;
                }
                e.innerHTML = "&nbsp;";

                var res = m.split("|");
                
                e = document.getElementById("iTotalTask");
                e.innerHTML = res[0];
                if (res.length >= 8) 
                    e.innerHTML = res[7];

                e = document.getElementById("iPendingTask");
                e.innerHTML = res[1];

                e = document.getElementById("iFailedTask");
                e.innerHTML = res[2];
                e = document.getElementById("iSkippedTask");
                e.innerHTML = res[3];
                e = document.getElementById("iTaskStatus");
                e.innerHTML = res[4];

                e = document.getElementById("iTaskProgress");
                e.style.width = res[5]+"%";
                
                e = document.getElementById("ProcessStatus");
                if (res.length >= 7) {                    
                    e.innerHTML = res[6];
                } else {
                    e.innerHTML = "";

                }

                if(res.length >= 9){
                    AddRunningTask(res);
                } else {
                    var e = document.getElementById("Running");
                    e.innerHTML = "";

                }

                onChangeTaskStatus(res[4]);
            } catch (ee) {

            }
            setTimeout("Poll()", 1000);
        }

        function Poll() {


            try {
                Ext.Ajax.request({
                    url: '/management/TenantTaskDetail.aspx?id=<%=HiddenTaskId.Value %>&poll=1',
                    success: function (response) {
                        var resp = response.responseText;
                        if (resp.indexOf("<!DOCTYPE html>") > -1 || resp.indexOf("<script") > -1) {  
                            console.log("Unhandled server error:", resp);
                            OnPollRes('bad^unknown');
                        } else {   
                            OnPollRes(resp);
                        }
                    },
                    failure: function () {
                        OnPollRes('bad^unknown');
                    },
                    method: 'GET'
                });

            } catch (e) {
                alert(e);
            }


        }

        function OnPageLoaded() {
            try {
                closeWait();
            } catch (e) {

            }
        }
        Ext.onReady(function () {
            AdjustSize();

            setTimeout("Poll()", 2000);
            Ext.EventManager.onWindowResize(function () {
                AdjustSize();
            });

        });

    </script>
</asp:Content>
