﻿<%@ Page Title="Gladinet Cloud - Published Folders" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="TenantShareMgrPage.aspx.cs" Inherits="GladinetPayFlow.TenantShareMgrPage"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    
    <style type="text/css">
        .titlecol
        {
            background-color: #f0f0f0;
            font-size: 14px;
        }
        
        
        .securityicon
        {
            background-image: url(images/security2.png);
        }
        .groupicon
        {
            background-image: url(images/group.png);
        }
        

    </style>
    <script type="text/javascript">




        function ClearErrorMsg() {

            var d = document.getElementById("errmsgdiv");
            if (d) {
                d.style.display = 'none';
            }
        }
        setTimeout("ClearErrorMsg()", 30000);
        //parent.setActivePanel("PubMgr");




        function gEncodeUri(str) {
            var s = encodeURI(str).replace(/&/g, '%26').replace(/#/g, '|').replace('+', ':');
            while (true) {
                var i = s.indexOf('+');
                if (i == -1)
                    break;
                s = s.replace('+', ':');
            }

            return s;

        }



        var ActiveWin;
        function OnEdit(ShareId, isDir) {

            var uri = "<iframe id='openwin' src=\"/portal/AddSharePage.aspx?src=filebrowser&folder=";
            uri += isDir;
            uri += "&location=/";


            uri += encodeURIComponent(ShareId.replace("%27", "'"));
            uri += "&vdid=<%=SessionDomainId %>";
            uri += "\" scrolling='auto' style='width:100%;height:100%;margin:0;padding:0;border:0;'></iframe>";
            var maxed = false;
            if (document.documentElement.offsetHeight < 628)
                maxed = true;

            ActiveWin = new Ext.Window({
                id: 'pubs_win',
                title: "<asp:Localize meta:resourcekey="str_sendshare" runat="server">Create link and send</asp:Localize>",
                width: 820,
                height: 640,
                plain: true,
                modal: true,
                maximizable: true,
                maximized: maxed,
                constrainHeader: true,
                bodyPadding: 5,
                resizable: false,
                html: uri,
                defaults: {
                    border: false
                }
            });
            ActiveWin.show();

        }



        function ViewShare(oid, id) {
            id = gEncodeUri(unescape(id));
            var uri = "<iframe id='openwin' src=\"/management/ViewSharePage.aspx?u=";
            uri += oid;
            uri += "&location=" + id;
            uri += "&vdid=<%=SessionDomainId %>";

            uri += "\" scrolling='auto' style='width:100%;height:100%;margin:0;padding:0'></iframe>";

            ActiveWin = new Ext.Window({
                id: 'pubs_win',
                title: "<asp:Localize meta:resourcekey="str_viwShr" runat="server">View Share</asp:Localize>",
                width: 720,
                height: maxh(540),
                plain: true,
                modal: true,
                maximizable: true,
                maximized: false,
                constrainHeader: true,
                bodyPadding: 5,
                resizable: false,
                html: uri,
                defaults: {
                    border: false
                }
            });
            ActiveWin.show();
        }

        function UnpublishUrl(id) {
            id = gEncodeUri(unescape(id));
            var h = "TenantShareMgrPage.aspx?op=delpub&id=" + id+"&oid=1&vdid=<%=SessionDomainId %>";

           
            gConfirm("<asp:Localize meta:resourcekey="js_string7" runat="server">Confirm you want to delete?</asp:Localize>", "", function (btn1) {

                if (btn1 != 'ok')
                    return;
            Wait('Deleting...');
                window.location = h;
            });
        }

        function Unpublish(oid, id) {
            id = gEncodeUri(unescape(id));
            var h = "TenantShareMgrPage.aspx?op=delete&id=" + id + "&oid=" + oid+"&vdid=<%=SessionDomainId %>";

            gConfirm("<asp:Localize meta:resourcekey="js_string7" runat="server">Confirm you want to delete?</asp:Localize>", "", function (btn1) {

                if (btn1 != 'ok')
                    return;
                Wait('Deleting...');
                window.location = h;
            });

            
        }

        //parent.HelpSrc = "PubMgrHelp.htm";


        function closeActiveWin() {


            window.location = window.location;

        }

        function closeCancelActiveWin() {
            ActiveWin.close();
        }

        function OnClickTeam() {
            window.location = "/portal/PubMgrPage.aspx";
        }

        function OnClickStorage() {
            window.location = "/management/StorageMgr.aspx";
        }

    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
<asp:Localize runat="server" ID="LocFaiToGetShaObjLis" meta:resourcekey="str_faiToGetShaObjLis" Visible="false">Failed to get shared object list.</asp:Localize>
   <nav class="navbar navbar-default " role="navigation">
       <div class="container-fluid">
           <p class="navbar-text">
               <asp:Label ID="PubFolderCount" runat="server" meta:resourcekey="PubFolderCountResource1" CssClass="badge"></asp:Label>
           </p>

           <p class="navbar-text">
               <b>
                   <asp:Label ID="ErrorMsg" runat="server" Style="color: Red;" meta:resourcekey="ErrorMsgResource1"></asp:Label></b>
           </p>
           <div class="navbar-form navbar-right">
               <table border="0" style="margin-top: -15px;">
                   <tr>
                      
                       <td>
               <asp:LinkButton ID="AllUsers" runat="server"  CssClass="btn btn-default nbtn"
                    OnClick="AllUsers_Click" meta:resourcekey="AllUsersResource1" 
                   Text="All Shares"></asp:LinkButton>               
               <asp:TextBox ID="Contains" runat="server" Width="228px" CssClass="form-control dark" meta:resourcekey="ContainsResource1"></asp:TextBox>
               <asp:Button ID="Serach" runat="server" Text="Search"  OnClick="Serach_Click" CssClass="btn btn-default nbtn" meta:resourcekey="SerachResource1" />
                           
                       </td>
                        <td>
                            <asp:LinkButton ID="ExportShares" runat="server"  Text="Export Shares" CssClass="btn btn-default"
                                            OnClick="ExportShare_Click" 
                    meta:resourcekey="ExportSharesResource1"></asp:LinkButton>      
                       </td>
                   </tr>
               </table>
           </div>
       </div>
    </nav>
    <table width="100%" style="padding: 2px; background-color: white; margin-top: -13px" cellspacing="0" cellpadding="0" id="grid-table">
        <tr style="background-color: #f0f0f0; display: none;">
            <td valign="top" style="height: 32px; padding: 2px; border: 0px solid #c0c0c0; border-bottom: 3px solid #e0e0e0;">
                <table width="96%" cellspacing="0" cellpadding="0" style="height: 32px;">
                    <tr>
                        <td align="left" style="height: 32px">
                        </td>
                        <td>
                            <div id="errmsgdiv">
                            </div>
                        </td>
                        <td align="right">
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
        <tr>
            <td style="padding:0px;padding-top: 0px; border-bottom: 0px solid #c0c0c0; border-left: 0px solid #c0c0c0; border-right: 0px solid #c0c0c0;"
                id="grid-example">
            </td>
        </tr>
        <tr>
            <td  style="height: 40px; vertical-align: middle; display: none;">
                <div class='idea_flex'>
                <asp:Localize ID="Localize4" meta:resourcekey="as_string5" runat="server" 
                        Text=" Securely send links of files and folders to share with people."></asp:Localize>
                </div>
            </td>
        </tr>
    </table>
    <input type="hidden" id="current_share" name="current_share" />
    <script type="text/javascript">
  var myData = [
 <asp:Repeater ID="PubsRepeater" runat="server" >
        <ItemTemplate>
       <%#(Container.ItemIndex == 0)? "": "," %>     
       ['<%#(((RepeaterItem)Container).ItemIndex+1) %>',
       '<%#DataBinder.Eval(Container.DataItem, "PathLocation").ToString().Replace("'","%27")%>', 
       '<%#DataBinder.Eval(Container.DataItem, "Memo").ToString().Replace("'","%27")%>', 
       '<%#DataBinder.Eval(Container.DataItem,"OwnerUid") %>',
       '<%#DataBinder.Eval(Container.DataItem,"IsDir") %>',
       '<%#DataBinder.Eval(Container.DataItem,"IsPublicUrl") %>',
       '<%#DataBinder.Eval(Container.DataItem, "ShareName").ToString().Replace("'","%27")%>'
       ]
        
        </ItemTemplate>
    </asp:Repeater>      
    ];
    </script>
    <script type="text/javascript">

        Ext.require([
          'Ext.grid.*',
          'Ext.data.*',
          'Ext.util.*',
          'Ext.state.*'
      ]);
        var grid;
function AdjustGridTable () {
           
        var h = 400;
          
        try {

            var myTable = Ext.get('grid-table');
           
            var tableY = myTable.getY();
           
            h = document.body.offsetHeight-tableY-68;
           
              var ee = document.getElementById('tinfo');
              ee.style.height = h + "px";

          } catch (err) {
          }
              grid.setWidth(document.documentElement.clientWidth - 8);
              grid.setHeight(h);
              grid.doComponentLayout();

          var e = document.getElementById("grid-example");
          e.style.height = h + "px";

      }

        Ext.onReady(function () {

            Ext.QuickTips.init();


            var store = Ext.create('Ext.data.ArrayStore', {
                fields: [
                  { name: 'index' },
                  { name: 'path' },
                  { name: 'ownername' },
                  { name: 'oid' },
                  { name: 'isdir' },
                  { name: 'ispublic' },
                  { name: 'sharename' }
              ],
                data: myData
            });

            var d = document.getElementById("grid-example");
            var h = 370;
            //if (d.offsetHeight > h)
            h = d.offsetHeight - 10;

            grid = Ext.create('Ext.grid.Panel', {                
                frame: false,
                border: false,
                store: store,
                stripeRows: true,
                columnLines: true,
                minHeight: 218,
                height: h,
                columns: [
                  {
                      text: '',
                      width: 50,
                      sortable: false,
                      dataIndex: 'index',
                      getClass: function (v, meta, rec) {
                          return 'x-col-hdide';
                      }
                  },
                  {
                      text: "<asp:Localize meta:resourcekey="js_string2" runat="server">Shared Object Path</asp:Localize>",
                      flex: 1,
                      sortable: true,
                      dataIndex: 'path',
                      renderer: function (value, metaData, record, rowIndex) {
                          return "<b>" + unescape(value) + "</b>";
                      }

                  }, {
                      text: "<asp:Localize meta:resourcekey="js_string3" runat="server">Owner Name</asp:Localize>",
                        width: 160,
                        sortable: true,
                        dataIndex: 'ownername',
                        renderer: function (value, metaData, record, rowIndex) {
                            return "<b>" + unescape(value) + "</b>";
                        }

                    },
                    {
                        text: "<asp:Localize meta:resourcekey="str_type" runat="server">Type</asp:Localize>",
                        width: 102,
                        sortable: false,
                        dataIndex: 'ispublic',
                        renderer: function (value, metaData, record, rowIndex) {
                            if (value == 'True')
                                return "<asp:Localize meta:resourcekey="str_puburl" runat="server">Public Url</asp:Localize>";

                            return "<asp:Localize meta:resourcekey="str_share" runat="server">Share</asp:Localize>";
                        }

                    }, {
                      xtype: 'actioncolumn',
                      width: 80,
                      items:
                      [

                          {
                              icon: 'images/adduser.png',  // Use a URL in the icon config
                              tooltip: "<asp:Localize meta:resourcekey="js_string4" runat="server">Edit Share</asp:Localize>",
                              handler: function (grid, rowIndex, colIndex) {
                                  var rec = grid.getStore().getAt(rowIndex);
                                  var d = rec.data;

                                  OnEdit(unescape(d.path), d.isdir);

                              },
                              getClass: function (v, meta, rec) {
                                  var d = rec.data;
                                  var sid = "<%=SessionUserId %>"

                                  if (sid != d.oid) {
                                      return 'x-col-hdide';
                                  }
                                  if(d.ispublic == 'True')
                                    return 'x-col-hdide';

                              }

                          },
                          {
                              icon: 'images/accountuser.png',  // Use a URL in the icon config
                              tooltip: "<asp:Localize meta:resourcekey="js_string5" runat="server">View Share</asp:Localize>",
                              handler: function (grid, rowIndex, colIndex) {
                                  var rec = grid.getStore().getAt(rowIndex);
                                  var d = rec.data;

                                  ViewShare(d.oid, d.path);
                              }
                        ,
                              getClass: function (v, meta, rec) {
                                  var d = rec.data;
                                  var sid = "<%=SessionUserId %>"

                                  if (sid == d.oid) {
                                      return 'x-col-hdide';
                                  }

                                  if(d.ispublic == 'True')
                                    return 'x-col-hdide';

                              }
                          },
                          {
                              icon: 'images/trash.png',  // Use a URL in the icon config
                              tooltip: "<asp:Localize meta:resourcekey="js_string6" runat="server">Delete Share</asp:Localize>",
                              handler: function (grid, rowIndex, colIndex) {
                                  var rec = grid.getStore().getAt(rowIndex);
                                  var d = rec.data;

                                  if(d.ispublic == 'True')
                                    UnpublishUrl(unescape(d.sharename));
                                  else
                                    Unpublish(d.oid, d.path);
                              }
                        ,
                              getClass: function (v, meta, rec) {
                                <% if (!m_CanDelete)
                                   { %>
                                   return 'x-col-hdide';
                                <% } %>
                              }
                          }
                 ]
                  }
        ],
                renderTo: 'grid-example'
            });
              AdjustGridTable ();
             //Ext.EventManager.onWindowResize(grid.doLayout, grid);
             Ext.EventManager.onWindowResize(AdjustGridTable);

        });
    </script>
</asp:Content>
