﻿<%@ Page Title="Gladinet Cloud Cluster" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="TenantDashboard.aspx.cs" Inherits="GladinetPayFlow.TenantDashboard" culture="auto" meta:resourcekey="PageResource1" uiculture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
        .style1
        {
            width: 388px;
        }
        
        .style2
        {
            min-width: 16px;
            text-align: center;
        }
        
        .pricetable
        {
            border: 1px solid #cccccc;
        }
        
        .plain9BlackOnNone
        {
            border-bottom: 1px solid #cccccc;
            border-right: 1px solid #cccccc;
        }
        .style3
        {
            border-bottom: 1px solid #cccccc;
            border-right: 1px solid #cccccc;
            width: 121px;
        }
       
    </style>
</asp:Content>

<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
<div id="tabs" ></div>
<script type="text/javascript">
    
    

    

    Ext.require([
    'Ext.tab.*'
    ]);
    var tabs;
    Ext.onReady(function () {


        tabs = Ext.createWidget('tabpanel', {
            renderTo: 'tabs',
            resizeTabs: true,
            enableTabScroll: true,
            width: '100%',
            plain:true,
            height: document.documentElement.clientHeight ,
            defaults: {
                autoScroll: true,
                bodyPadding: 10
            }
        });
        
        tabs.add({
            title: "<asp:Localize meta:resourcekey="str_tenDas" runat="server">Tenant Dashboard</asp:Localize>",
            iconCls: 'tabs',
            html: '<iframe id="audit" src="ConsoleHelpPage.aspx?edittenant=1&vdid=<%=TargetDomainId.Value%>" frameborder="0" width="100%"  border="0" height="98%"></iframe>',
            closable: false
        });
        
        tabs.add({
            title: "<asp:Localize meta:resourcekey="str_tenPla" runat="server">Tenant Plan</asp:Localize>",
            iconCls: 'tabs',
            html: '<iframe id="audit" src="UpgradePlanPage.aspx?mode=1&userid=<%=TargetAdminId.Value%>" frameborder="0" width="100%"  border="0" height="98%"></iframe>',
            closable: false
        });

        tabs.add({
            title: "<asp:Localize meta:resourcekey="str_tenADSet" runat="server">Tenant AD Settings</asp:Localize>",
            iconCls: 'tabs',
            html: '<iframe id="audit" src="/management/LDAPCfgPage.aspx?c=1&g=<%=TargetDomainId.Value%>" frameborder="0" width="100%"  border="0" height="98%"></iframe>',
            closable: false
        });

        tabs.add({
            title: "<asp:Localize meta:resourcekey="str_tenBra" runat="server">Tenant Branding</asp:Localize>",
            iconCls: 'tabs',
            html: '<iframe id="audit" src="BrandingMgrPage.aspx?mode=edit&brid=<%=TargetDomainId.Value%>" frameborder="0" width="100%"  border="0" height="98%"></iframe>',
            closable: false
        });

        tabs.add({
            title: "<asp:Localize meta:resourcekey="str_uplRep" runat="server">Upload Report</asp:Localize>",
            iconCls: 'tabs',
            html: '<iframe id="audit" src="DomainUploadStat.aspx?id=<%=TargetDomainId.Value%>" frameborder="0" width="100%"  border="0" height="98%"></iframe>',
            closable: false
        });

        
        tabs.add({
            title: "<asp:Localize meta:resourcekey="str_stoSta" runat="server">Storage Statistics</asp:Localize>",
            iconCls: 'tabs',
            html: '<iframe id="audit" src="DomainStorageStat.aspx?id=<%=TargetDomainId.Value%>" frameborder="0" width="100%"  border="0" height="98%"></iframe>',
            closable: false
        });
        

        tabs.setActiveTab(0);
    });

  Ext.EventManager.onWindowResize(function () {
  
            tabs.setHeight(document.documentElement.clientHeight);
            tabs.doComponentLayout();

        });

</script>
    <asp:HiddenField ID="TargetDomainId" runat="server" />
    <asp:HiddenField ID="TargetAdminId" runat="server" />
</asp:Content>
