﻿<%@ Page Title="Tenant Manager" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="TeamsMgrPage.aspx.cs" Inherits="GladinetPayFlow.TeamsMgrPage"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">

    <style type="text/css">
         .gridobject{

         }
         .titlecol {
             background-color: #f0f0f0;
             font-size: 14px;
         }

        .x-progress-warn .x-progress-bar {
            background-color: #f49e69;
        }

        .x-progress .x-progress-bar {
            background-color: #35BAF6;
        }

        
        .tentv {
            border-style: dashed !important;
            border-color: #cccccc;
            border-width: 1px;
            border-radius: 4px;
        }
        .securityicon {
            background-image: url(/portal/images/security2.png);
        }

        #Form1, .main, #aspnetForm {
            overflow: auto;
        }

        .numlbl {
            background-position: center;
            background-repeat: no-repeat;
            border-radius: 12px 12px 12px 12px;
            border: 0px solid;
            padding-left: 8px;
            padding-right: 8px;
            padding-top: 0px;
            padding-bottom: 0px;
            white-space: nowrap;
            overflow: hidden;
            height: 24px;
        }

        .btn-primary gladbtn {
            color: #fff;
            background-color: #337ab7;
            border-color: #2e6da4;
        }

        .btn-success {
            color: #fff;
            background-color: #5cb85c;
            border-color: #4cae4c;
        }

        .dark {
            color: #565656 !important;
        }


        .actioncol{
        margin-top:5px;
        }
        .actioncol .gladinet-icons {
        padding-left:10px;
        }
		.actioncol .tooltip{
            margin:20px 0px 0px 5px !important;  /*tooltip positioning*/ 
		}

        #grid-table{
            @grid-columns:4;
        }

        #DeleteTenantNameBox::placeholder{color:lightgray;opacity:1;}
        #DeleteTenantNameBox:-ms-input-placeholder{color:lightgray;}
        #DeleteTenantNameBox::-ms-input-placeholder{color:lightgray;}
        .x-menu-item-disabled a:hover{text-decoration:none;}
    </style>
    <script type="text/javascript">
        var eleClassName = "gridobject col-2";
        function getScrollXY() {
            var scrOfX = 0, scrOfY = 0;
            if (typeof (window.pageYOffset) == 'number') {
                //Netscape compliant
                scrOfY = window.pageYOffset;
                scrOfX = window.pageXOffset;
            } else if (document.body && (document.body.scrollLeft || document.body.scrollTop)) {
                //DOM compliant
                scrOfY = document.body.scrollTop;
                scrOfX = document.body.scrollLeft;
            } else if (document.documentElement && (document.documentElement.scrollLeft || document.documentElement.scrollTop)) {
                //IE6 standards compliant mode
                scrOfY = document.documentElement.scrollTop;
                scrOfX = document.documentElement.scrollLeft;
            }
            //return [scrOfX, scrOfY];
            return scrOfY;
        }

        function ReturnLast() {
            <%if(IsCSBiz) {%>
            parent.LoadInitPage();
            <%}else {%>
            window.location = "ClusterDashboard.aspx";
            <%}%>
            }


        var activewin;
        function UpgardeTeam(userId) {
            Wait("Please wait");
            parent.SetRelativePageTitle('Edit', 'TenantWebAppPage.aspx?id=' + userId);
            var ee = document.getElementById('tinfo');
            ee.src = 'TenantWebAppPage.aspx?id=' + userId;
            return;
            
            activewin = new Ext.Window({
                id: 'plan_win',
                title: "<asp:Localize meta:resourcekey="js_string39" runat="server">Manage Tenant</asp:Localize>",
                width: 800,
                height: maxh(760),
                plain: true,
                modal: true,
                maximizable: false,
                maximized: true,
                constrainHeader: true,
                constrain: true,
                layout: 'fit',
                bodyPadding: 3,
                html: "<iframe id='openwin' src='TenantWebAppPage.aspx?id=" + userId + "' scrolling='auto' style='width:100%;height:100%;margin:0;padding:0'></iframe>",
                defaults: {
                    border: false
                }
            });
            activewin.show();


        }

        function OpenTenantPortal(did) {
            
            UpgardeTeam(did);
            return;

            activewin = new Ext.Window({
                id: 'ot_win',
                title: "<asp:Localize meta:resourcekey="str_opnTntWebPtl" runat="server">Open Tenant Web Portal</asp:Localize>",
                width: 300,
                height: maxh(260),
                plain: true,
                modal: true,
                maximizable: false,
                maximized: false,
                constrainHeader: true,
                constrain: true,
                layout: 'fit',
                bodyPadding: 3,
                html: "<iframe id='openwin' src='/portal/LocalOpenTenantPage.aspx?did=" + did + "' scrolling='auto' style='width:100%;height:100%;margin:0;padding:0'></iframe>",
                defaults: {
                    border: false
                }
            });
            activewin.show();

        }


        function ShowDashboard(userId, name) {
            Wait("Please wait");
            <%if (IsCSBiz){ %>
            parent.SetSecondPageTitleNoLoading(name.replace("%27","'"), '/management/CSBiz/CSBizTenantDashboard.aspx?id=' + userId);
            window.location = '/management/CSBiz/CSBizTenantDashboard.aspx?id=' + userId;

            <%}else { %>
            parent.SetRelativePageTitle(name.replace("%27","'"), 'TenantWebAppPage.aspx?id=' + userId);
            window.location = 'TenantWebAppPage.aspx?id=' + userId;
            <%} %>
            return;

        }
        function OnSuspend(did) {
            var domainid = document.getElementById('ctl00_MainContent_PageDomainId');
            var btn = document.getElementById('ctl00_MainContent_SubspendTenant');
            domainid.value = did;
            btn.click();
        }

        function OnResume(did) {
            var domainid = document.getElementById('ctl00_MainContent_PageDomainId');
            var btn = document.getElementById('ctl00_MainContent_ResumeTenant');
            domainid.value = did;
            btn.click();
        }

        function ResetPassword(email) {

            var uri = "/portal/ResetUserPassword.aspx?t=";

            uri += email;

            activewin = new Ext.Window({
                id: 'resetpwd_win',
                title: "<asp:Localize meta:resourcekey="js_string2" runat="server">Reset Password</asp:Localize>",
                width: 680,
                height: maxh(460),
                layout: 'fit',
                plain: true,
                modal: true,
                maximizable: true,
                constrainHeader: true,
                constrain: true,
                resizable: true,
                layout: 'fit',
                bodyPadding: 5,
                bodyStyle: 'background:#dfe8f6;border:0px; ',
                items: [{
                    xtype: "component",
                    autoEl: {
                        tag: "iframe",
                        src: uri
                    }
                }]
            });
            activewin.show();
        }

        function EditTeamAds(userId) {
            
            activewin = new Ext.Window({
                id: 'ldap_win',
                title: "<asp:Localize meta:resourcekey="js_string3" runat="server">Edit LDAP Configuration</asp:Localize>",
                width: 800,
                height: maxh(680),
                plain: true,
                modal: true,
                maximizable: true,
                maximized: false,
                constrainHeader: true,
                constrain: true,
                layout: 'fit',
                bodyPadding: 3,
                html: "<iframe id='openwin' src='/management/LDAPCfgPage.aspx?c=1&r=close&g=" + userId + "' scrolling='auto' style='width:100%;height:100%;margin:0;padding:0'></iframe>",
                defaults: {
                    border: false
                }
            });
            activewin.show();


        }

        function OnAddTeam() {
            Wait("Please wait");
            parent.SetRelativePageTitle("<asp:Localize meta:resourcekey="str_newTnt" runat="server">New Tenant</asp:Localize>","AddTenantAdmin.aspx");
            window.location = "AddTenantType.aspx";
        }

        function MigrateAnchor() {
            
            Wait("Please wait");
            parent.SetRelativePageTitle("<%=str_addAnchor.Text%>","AddAnchorTenant.aspx");
            window.location = "AddAnchorTenant.aspx";
        }


        function OnPurchaseTeam() {
            activewin = new Ext.Window({
                id: 'pur_team',
                title: "<asp:Localize meta:resourcekey="js_string4" runat="server">Purchase</asp:Localize>",
                width: 940,
                height: maxh( 700),
                plain: true,
                modal: true,
                maximizable: true,
                maximized: false,
                layout: 'fit',
                bodyPadding: 3,
                html: "<iframe id='openwin' src='ResellerPurchase.aspx' scrolling='auto' style='width:100%;height:100%;margin:0;padding:0'></iframe>",
                defaults: {
                    border: false
                }
            });
            activewin.show();
        }

        function ClearErrorMsg() {

            var d = document.getElementById("errmsgdiv");
            if (d) {
                d.style.display = 'none';
            }
        }
        setTimeout("ClearErrorMsg()", 30000);
        //parent.setActivePanel("UserMgr");

       

    
        function closeCancelActiveWin()
        {
            activewin.close();
        }

        function closeActiveWin() {
            window.location =  window.location;
        }

        function InvokeDownload(uri) {
            activewin.close();
            if (confirm("An executable will be downloaded to facilitate the operation, you need to run the executable once it is downloaded, do you want to continue?")) {
                var e = document.getElementById("downloadframe");
                e.src = uri;
            }
        }

        function ShowErrorMsg(err) {
            activewin.close();
            alert(err);
        }


    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
    <asp:Localize ID="LocUld" meta:resourcekey="str_uld" runat="server" Visible="false">Unlimited</asp:Localize>
    <%if(!IsMobile()) { %>
    <div class="meubardrop navbar navbar-default" role="navigation" style="height:64px!important; padding-top:5px!important; " id="navmenu">
        
            
           

            <div class="navbar-form navbar-left" >
                <table style="margin-top:-12px;" border="0">
                    <tr>

                        <td>
 <button type="button" class="btn " onclick="OnIconView();return false;" id="iconview" style="padding: 2px!important;  display: none;">
                <i class="gladinet-icons md-24 md-dark hand center toolbtn" style="display: inline-block; margin-top: 3px;" >&#0164;</i>

            </button>


            <button type="button" class="btn " onclick="OnListView();return false;" id="listview" style="padding: 2px; ">
                 <i class="gladinet-icons md-24 md-dark hand center toolbtn" style="display: inline-block; margin-top: 3px;" >&#0186;</i>

            </button>
                        </td>


                        
                        <td>
                            <asp:Panel ID="Panel1" runat="server" Visible="False">
                                <br style="margin-bottom: 3px;" />
                                <asp:Localize ID="LocLst" meta:resourcekey="str_lst" runat="server" Visible="False">Listing</asp:Localize>
                                <asp:LinkButton ID="LinkButton2" runat="server" Font-Size="Larger" ForeColor="Green" OnClick="LinkButton2_Click" OnClientClick="Wait('<%=LocLst.Text %>')" meta:resourcekey="LinkButton2Resource1">All Tenants with storage usage larger than</asp:LinkButton>
                                <asp:TextBox ID="StorageUsageFilter" runat="server" Width="75px" Text="0" CssClass="x-form-field x-form-text"
                                    meta:resourcekey="StorageUsageFilterResource1"></asp:TextBox>GB
                            </asp:Panel>

                        </td>
                        <td width="32px" valign="middle">
                            <% if (!SessionIsDelegateClusterAdmin)
                                { %>

                            <button type="button" onclick="OnAddTeam();return false;" class="btn btn-default   nbtn" style="margin-right: 8px;">
                                

                                <i class="gladinet-icons md-24 md-dark hand center toolbtn" style="display: inline-block; margin-top: 3px;"  title="<%=str_addtent.Text %>" >&#0177;</i>

                            </button>

                            <% } %>
                            <asp:Localize meta:resourcekey="str_addtent" ID="str_addtent" runat="server" Visible="False">Add Tenant</asp:Localize>
                            <asp:Localize ID="asp_string8" Visible="False" meta:resourcekey="asp_string8" runat="server">Create a new tenant for your customer. Enough user credit line and/or storage credit line is required.</asp:Localize>
                        </td>
                        <td width="32px" valign="middle" >
                            <button type="button" data-toggle="modal" data-target="#Search" class="btn nbtn" style="margin-right: 8px;">
                                
                                <i class="gladinet-icons md-24 md-dark hand center toolbtn" style="display: inline-block; margin-top: 3px;"  title="<%=str_search.Text %>" >&#0167;</i>
                            </button>
                        <asp:Localize meta:resourcekey="str_search" id="str_search" Visible="False" runat="server">Search</asp:Localize>    
                            
                        </td>
                        
                        <td width="32px" valign="middle" style="padding-top: 3px;">
                            <asp:LinkButton ID="AllTeams" runat="server" CssClass="navbar-link dark"
                                OnClick="AllTeams_Click" meta:resourcekey="AllTeamsResource1">
                                
                                <i class="gladinet-icons md-24 md-dark hand center toolbtn" style="display: inline-block; margin-top: 0px;"  title="<%=str_refresh.Text %>" >&#0181;</i>
                            </asp:LinkButton>
                            
                            <% 
                                AllTeams.OnClientClick = String.Format("Wait('{0}')",LocLst.Text);
                            %>

                            <asp:Localize meta:resourcekey="str_refresh" ID="str_refresh" Visible="False" runat="server">Refresh</asp:Localize>
                        </td>
                        
                        <td width="32px" valign="middle" style="padding-top: 3px;">
                            <asp:LinkButton ID="ExportTenant" runat="server"
                                OnClick="ExportTenant_Click"
                                CssClass="navbar-link dark">
                                
                                <i class="gladinet-icons md-24 md-dark hand center toolbtn" style="display: inline-block; margin-top: 0px;"  title="<%=Localize5.Text %>" >&#0178;</i>
                            </asp:LinkButton>
                            <asp:Localize ID="Localize5" meta:resourcekey="str_export1" runat="server" Visible="False">Export Tenants</asp:Localize>
                        </td>
                    </tr>
                </table>




            </div>
        
            <%if (m_ResellerMode)
                { %>
            <p class="navbar-text dark">
                <asp:Localize ID="Localize1" meta:resourcekey="asp_string2" runat="server">User Line:</asp:Localize>
                <asp:Label ID="UserLine" runat="server" meta:resourcekey="UserLineResource1" CssClass="numlbl btn-primary gladbtn"></asp:Label>
            </p>
            <p class="navbar-text dark">
                <asp:Localize ID="Localize2" meta:resourcekey="asp_string3" runat="server">User Line Used:</asp:Localize>
                <asp:Label ID="UserLineUsed" runat="server" meta:resourcekey="UserLineUsedResource1" CssClass="numlbl btn-success"></asp:Label>
            </p>

            <p class="navbar-text">
                <asp:Localize ID="Localize3" meta:resourcekey="asp_string4" runat="server">Storage Line:</asp:Localize>
                <asp:Label ID="StorageLine" runat="server" ForeColor="Green" meta:resourcekey="StorageLineResource1"></asp:Label>
            </p>
            <p class="navbar-text dark">
                <asp:Localize ID="Localize4" meta:resourcekey="asp_string5" runat="server">Storage Line Used:</asp:Localize>
                <asp:Label ID="StorageLineUsed" runat="server" ForeColor="Green" meta:resourcekey="StorageLineUsedResource1"></asp:Label>
            </p>
            <%} %>
            <p class="navbar-text dark" style="padding-top: 5px;">
                <asp:Label ID="TenantCount" runat="server" meta:resourcekey="UserCountResource1" CssClass="badge hollowbadge"></asp:Label>
                <asp:Localize meta:resourcekey="str_users" id="str_users" Visible="False" runat="server">Users</asp:Localize>
                <asp:Localize meta:resourcekey="str_totLic" id="LocTotLic" Visible="False" runat="server">Users</asp:Localize>
            </p>
            <p class="navbar-text dark" style="padding-top: 5px;">
                <asp:Label ID="LblTotalLicenses" runat="server" CssClass="badge hollowbadge"></asp:Label>

            </p>
            <p class="navbar-text dark" style="padding-top: 5px;">
                <asp:Label ID="UserCount" runat="server" meta:resourcekey="UserCountResource1" CssClass="badge hollowbadge"></asp:Label>

            </p>
            
            <p class="navbar-text">&nbsp;
                
            </p>
            
            <%if (!m_ResellerMode && !SessionIsInstalledApp)
                { %>
            <form class="navbar-form navbar-right" role="search">
                <div class="form-inline">
                    <asp:CheckBox ID="team" runat="server" Checked="True" Text="Team" meta:resourcekey="teamResource1" />&nbsp;&nbsp;
                        <asp:CheckBox ID="prem" runat="server" Text="Premium" meta:resourcekey="premResource1" />&nbsp;&nbsp;
                        <asp:CheckBox ID="prof" runat="server" Text="Professional" meta:resourcekey="profResource1" />
                </div>
            </form>

            <%} %>


            

            <div class="navbar-right sectextcolor" style="width:40px; font-size:48px;  font-weight:100; cursor:pointer; margin-top:-13px;" onclick="ReturnLast();">&times;</div>



        
    </div>
    <%} %>
    <table id="grid-table" width="100%" align="center" cellspacing="0" cellpadding="0" border="0" style="  padding-top: 0px; margin-top:28px;" >
        <tr>
            <td colspan="5" height="400px" valign="top" style="border-top: 0px solid #e0e0e0;padding-left:10px;" id="grid-example">
                <div id="errmsgdiv" style="padding-left:10px;">
                    <b><asp:Label ID="ErrorMsg" runat="server" Style="color:red;font-weight:400;font-size:16px;" meta:resourcekey="ErrorMsgResource1"></asp:Label></b>
                </div>
                <div id="rowcontainer" style="-webkit-overflow-scrolling: touch; overflow:auto; width:100%;padding:10px;">
                    <div class="row" id="tcontainer" style="-webkit-overflow-scrolling: touch; width:95%;">
                    </div>
                    </div>
              
            </td>
        </tr>
    </table>
    <table width="96%" align="center" style="display: none">
        <tr >
            <td>
            </td>
            <td colspan="6">
                <div width="90%" style="padding: 10px;">
                    <asp:Button ID="DeleteTenant" runat="server" Text="Button" OnClick="DeleteTenant_Click" meta:resourcekey="DeleteTenantResource1" />
                    <asp:HiddenField ID="PageDomainId" runat="server" />
                    <asp:HiddenField ID="Admin" runat="server" />
                    <asp:Button ID="SubspendTenant" runat="server" Text="Button" OnClick="SubspendTenant_Click" />
                    <asp:Button ID="ResumeTenant" runat="server" Text="Button" OnClick="ResumeTenant_Click" />
                    <asp:Button ID="ScanTenant" runat="server" Text="Button" OnClick="ScanTenant_Click" meta:resourcekey="ScanTenantResource1" />
                </div>
            </td>
            <td>
                <%if (!SessionIsInstalledApp)
                    { %>
                <td align="right" style="padding: 0px;" width="52px">
                    <asp:Localize ID="LocRslPurMsg" meta:resourcekey="str_rslPurMsg" runat="server" Visible="False">Purchase Gladinet products and services on behave of your customers. Your customers will be the end user of Gladinet Cloud products and services. You can purchase with reseller discount here.</asp:Localize>

                    <a href="javascript:;" onclick="OnPurchaseTeam();return false;" style="font-size: 12px;" title="<%=LocRslPurMsg.Text %>">
                        <img width="32px" src="/portal/images/resellerpurchase.png" /></a>
                </td>
                <%} %>
            </td>
        </tr>
    </table>
    <div id="Search" class="modal fade" role="dialog">
  <div class="modal-dialog">

    <!-- Modal content-->
    <div class="modal-content">
      <div class="modal-header">
          <h4 class="modal-title" style="color:#565656;"><%=str_search.Text %></h4>
        <button type="button" class="close" data-dismiss="modal">&times;</button>
        
      </div>
      <div class="modal-body">
        <asp:TextBox ID="Contains" runat="server" Width="100%" CssClass="form-control dark"
                                meta:resourcekey="ContainsResource1"></asp:TextBox>
      </div>
      <div class="modal-footer">
            <asp:Button ID="Button1" OnClick="FileterUsers_Click" runat="server" Text="Search"
                                OnClientClick="Wait('Listing')" meta:resourcekey="Button1Resource2" CssClass="btn btn-primary nbtn gladbtn" />
        <button type="button" class="btn btn-default" data-dismiss="modal"><asp:Localize meta:resourcekey="str_cls" runat="server">Close</asp:Localize></button>
      </div>
    </div>

  </div>
</div>    

<div id="DeleteTenantModal" class="modal fade" role="dialog">
  <div class="modal-dialog">

    <!-- Modal content-->
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title" style="color:#ff0000 !important;font-weight:400;font-size:20px;"><span class="gladinet-icons md-dark" style="font-size:40px;position:relative;top:5px;margin-right:10px;color:#ff0000 !important;">I</span>
            <asp:Localize meta:resourcekey="str_tntDltCfm" runat="server">Tenant Deletion Confirmation</asp:Localize> </h4>
        <button type="button" class="close" data-dismiss="modal">&times;</button>
        
      </div>
      <div class="modal-body">
        <asp:Localize meta:resourcekey="str_etrNmeOfTntCfm" runat="server">Please enter the name of the tenant below to confirm that you
really want to delete it.</asp:Localize>

        <input type="text" id="DeleteTenantNameBox" class="form-control" style="margin-top:10px;" />
        <input type="hidden" id="DeleteTenantNameHidden" />
        <span id="dltTntMsg" style="color:red"></span>   
      </div>
      <div class="modal-footer">
        <input type="button" class="btn gladbtn" onclick="ConfirmedDeleteTenant();" value="<asp:Localize meta:resourcekey="str_dltTntDltCfm" runat="server">DELETE</asp:Localize>" /> 
        <input type="button" class="btn gladbtn" onclick="CancelDeleteTenant();" value="<asp:Localize meta:resourcekey="str_cncTntDltCfm" runat="server">CANCEL</asp:Localize>" />
      </div>
    </div>

  </div>
</div>
<div id="DeleteTenantSuccessModal" class="modal fade" role="dialog">
  <div class="modal-dialog">
    <!-- Modal content-->
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title" style="color:#569F00 !important;font-weight:400;font-size:20px;"><span class="gladinet-icons md-dark" style="font-size:40px;position:relative;top:5px;margin-right:10px;color:#569F00 !important;">ú</span>
        <asp:Localize ID="LocDelScs" meta:resourcekey="str_delScs" runat="server">Deleted successfully.</asp:Localize></h4>
          <button type="button" class="close" data-dismiss="modal">&times;</button>        
      </div>
      <div class="modal-body">
        <asp:Localize ID="LocDelScsMsg" meta:resourcekey="str_delScsMsg" runat="server">You may want remove the Tenant storage manually from the server.</asp:Localize>
        <br /><br />
        <div id="divTenantStoragePath"></div>
      </div>
      <div class="modal-footer">
        <input type="button" class="btn gladbtn" onclick="DeleteTenantSuccessOK()" value="<asp:Localize meta:resourcekey="str_ok" runat="server">OK</asp:Localize>" />
      </div>
    </div>

  </div>
</div>

    <asp:Localize ID="str_addAnchor" meta:resourcekey="str_addAnchor"  runat="server" Visible="False">Migrate from Anchor</asp:Localize>

    <script type="text/javascript">
        function gEncodeUri(str) {
            var s = encodeURI(str).replace(/&/g, '%26').replace(/#/g, '|').replace('+', ':').replace(/'/g, '%27');

            while (true) {
                var i = s.indexOf('+');
                if (i == -1)
                    break;
                s = s.replace('+', ':');
            }

            return s;


        }       
        function OpenHtmlWindowShort(id, title, Html, w, h) {

            activewin = new Ext.Window({
                id: id,
                title: title,
                width: w,
                height: maxh(h),
                plain: true,
                modal: true,
                constrain: true,
                maximizable: false,
                maximized: false,
                bodyPadding: 5,
                resizable: false,
                shadow: 'drop',
                iconCls: 'publish',
                bodyStyle: 'background:#dfe8f6;border:0px; ',
                shadowOffset: 10,
                html: Html,
                defaults: {
                    border: false
                }
            });
            activewin.show();

        }
        function EditCloudStorage(name) {

            window.location = 'SelectProvider.aspx?c=1&f=/&did=' + gEncodeUri(name);

            return;
            /*var uri = "<iframe id='add_local' src='SelectProvider.aspx?f=/&did=" + gEncodeUri(name)  +"' scrolling='auto' style='width:100%;height:100%;margin:0;padding:0'></iframe>";

            
            OpenHtmlWindowShort("edit_cloud", "<asp:Localize meta:resourcekey="js_string5" runat="server">Edit Cloud Storage</asp:Localize>", uri,800,620);
            */


        }
        function EditCloudStorageEx(name) {
            window.location = 'SelectProvider.aspx?c=1&f=/&did=' + gEncodeUri(name);
            return;
            /*var uri = "<iframe id='add_local' src='SelectProvider.aspx?c=1&f=/&did=" + gEncodeUri(name)  +"' scrolling='auto' style='width:100%;height:100%;margin:0;padding:0'></iframe>";

            
            OpenHtmlWindowShort("edit_cloud", "<asp:Localize meta:resourcekey="js_string5" runat="server">Edit Cloud Storage</asp:Localize>", uri,800,620);
            */


        }
        function EditCloudStorage(name) {
            window.location = 'SelectProvider.aspx?c=1&f=/&did=' + gEncodeUri(name);
            return;  
            /*var uri = "<iframe id='add_local' src='SelectProvider.aspx?f=/&did=" + gEncodeUri(name)  +"' scrolling='auto' style='width:100%;height:100%;margin:0;padding:0'></iframe>";

            
            OpenHtmlWindowShort("edit_cloud", "<asp:Localize meta:resourcekey="js_string5" runat="server">Edit Cloud Storage</asp:Localize>", uri,800,620);
            */


        }

        function EditLocalStorage(name) {
            window.location = 'AddLocalStorage.aspx?f=/&did=' + gEncodeUri(name);
            return;
            /*var uri = "<iframe id='add_local' src='AddLocalStorage.aspx?f=/&did=" + gEncodeUri(name) + "' scrolling='auto' style='width:100%;height:100%;margin:0;padding:0'></iframe>";
            
            OpenHtmlWindowShort("edit_local", "<asp:Localize meta:resourcekey="js_string6" runat="server">Edit Local Storage</asp:Localize>", uri,800,620);
            */

        }
        function EditBranding(name) {
            var uri = "<iframe id='add_local' src='BrandingMgrPage.aspx?mode=edit&brid=" + gEncodeUri(name) + "' scrolling='auto' style='width:100%;height:100%;margin:0;padding:0'></iframe>";
            
            OpenHtmlWindowShort("edit_branding", 'Edit Tenant Branding', uri,1000,720);


        }

        function DeleteTenantSuccessMessage(path) 
        {
            var divTenantStoragePath = $('#divTenantStoragePath');
            divTenantStoragePath.html(path);
            $("#DeleteTenantSuccessModal").modal({ backdrop: 'static', keyboard: false });
        }
        function DeleteTenantConfirm(name) 
        {
            var nameBox = $('#DeleteTenantNameBox');
            var nameHid = $('#DeleteTenantNameHidden');
            var msg = $('#dltTntMsg');
            nameBox.prop("placeholder", name);
            nameHid.val(name);
            msg.html("");
            $("#DeleteTenantModal").modal({ backdrop: 'static', keyboard: false });
        }
        function ConfirmedDeleteTenant()
        {            
            var domainid = $('#ctl00_MainContent_PageDomainId').val();
            var nameBox = $('#DeleteTenantNameBox').val();
            var nameHid = $('#DeleteTenantNameHidden').val();
            var msg = $('#dltTntMsg');
            if(nameBox.trim() != ""  &&  nameBox == nameHid)
            {
                var btn = $('#ctl00_MainContent_DeleteTenant')[0];
                try
                {
                    parent.DeleteTenant(domainid);
                }
                catch(ex)
                {
                    alert(ex);
                }
                btn.click();
            }else{
                msg.html("<asp:Localize meta:resourcekey="str_tntNmeDntMtc" runat="server">The tenant's name does not match.</asp:Localize>");
                return false;
            }
        }
        function CancelDeleteTenant()
        {            
            var domainid = $('#ctl00_MainContent_PageDomainId');
            var adminid = $('#ctl00_MainContent_Admin');
            var nameBox = $('#DeleteTenantNameBox');
            var nameHid = $('#DeleteTenantNameHidden');
            var msg = $('#dltTntMsg');
            domainid.val("");
            adminid.val("");
            nameBox.prop("placeholder", "");
            nameHid.val("");
            msg.html("");
            $('#DeleteTenantModal').modal('hide');
        }
        function DeleteTenantSuccessOK()
        {            
            $('#DeleteTenantSuccessModal').modal('hide');
        }
        function RefreshTenant(idomainid, iadminid, name) {
            var btn = document.getElementById('ctl00_MainContent_ScanTenant');
            var domainid = document.getElementById('ctl00_MainContent_PageDomainId');
            var adminid = document.getElementById('ctl00_MainContent_Admin');

            if (confirm("<asp:Localize meta:resourcekey="js_string35" runat="server" Visible="False">This may take a long time to process for accounts that have significant storage usage. Continue?</asp:Localize>")) {
                    domainid.value = idomainid;
                  adminid.value = iadminid;
                    Wait("<asp:Localize meta:resourcekey="js_string36" runat="server">Scanning...</asp:Localize>");
                    btn.click();
        }  
        }
                              

        var myData = [
       <asp:Repeater ID="UsersRepeater" runat="server" >
              <ItemTemplate>         
              <%#(Container.ItemIndex == 0)? "": "," %>      ['<%#(((RepeaterItem)Container).ItemIndex+1) %>',
        '<%#DataBinder.Eval(Container.DataItem, "FirstName").ToString().Replace("'","%27")%>&nbsp;<%#DataBinder.Eval(Container.DataItem, "LastName").ToString().Replace("'","%27")%>', 
        '<%#DataBinder.Eval(Container.DataItem,"Email").ToString().Replace("'","%27") %>', 
        '<%# DataBinder.Eval(Container.DataItem, "QuotaUsed")%>',
        '<%# FormatGBytesOfUsed((long)DataBinder.Eval(Container.DataItem, "Quota"))%>', 
        '<%#DataBinder.Eval(Container.DataItem,"UserPlan").ToString().Replace("'","%27") %>',
        '<%#DataBinder.Eval(Container.DataItem,"ResellerId").ToString().Replace("'","%27") %>',
        '<%#DataBinder.Eval(Container.DataItem,"IsActivated").ToString().Replace("'","%27") %>',
        '<%#DataBinder.Eval(Container.DataItem,"StorageProviderId").ToString().Replace("'","%27") %>',
         '<%#DataBinder.Eval(Container.DataItem,"PaypalProfileId").ToString().Replace("'","%27") %>',
        '<%#DataBinder.Eval(Container.DataItem,"DomainId").ToString().Replace("'","%27") %>',
         '<%#DataBinder.Eval(Container.DataItem,"AdminId").ToString().Replace("'","%27") %>',
         '<%#DataBinder.Eval(Container.DataItem,"Edition").ToString().Replace("'","%27") %>',
         '<%#DataBinder.Eval(Container.DataItem,"Expire").ToString().Replace("'","%27") %>',
         '<%#DataBinder.Eval(Container.DataItem,"ResellerName").ToString().Replace("'","%27") %>',
         '<%#DataBinder.Eval(Container.DataItem,"PromoCode").ToString().Replace("'","%27") %>',
         '<%#DataBinder.Eval(Container.DataItem,"IsCloudStorage").ToString().Replace("'","%27") %>',
         '<%#DataBinder.Eval(Container.DataItem,"Orgnization").ToString().Replace("'","%27") %>',
         '<%#DataBinder.Eval(Container.DataItem,"UserPlanUsed").ToString().Replace("'","%27") %>',
         '<%# DataBinder.Eval(Container.DataItem,"Quota").ToString().Replace("'","%27")%>',
         '<%# DataBinder.Eval(Container.DataItem,"TenantLogo").ToString().Replace("'","%27")%>',
         '<%# DataBinder.Eval(Container.DataItem,"AccountBi").ToString().Replace("'","%27")%>'
         
        ] 
        </ItemTemplate>
    </asp:Repeater>      
  ];
    </script>
    <script type="text/javascript">
        var grid;
        function AdjustGrodObj()
        {
            try{
                if(document.documentElement.clientWidth > 1900)
                    eleClassName = "gridobject col-2";
                else if(document.documentElement.clientWidth > 1300)
                    eleClassName = "gridobject col-3";
                else if(document.documentElement.clientWidth > 800)
                    eleClassName = "gridobject col-4";
                else
                    eleClassName = "gridobject col-4";
            }catch(e){

            }

            try{
                var elements = document.getElementsByClassName("gridobject");
                if(elements && elements.length != 0){
                    for(var i=0; i< elements.length; ++i){
                        elements[i].className = eleClassName;
                    }
                }
            }catch(e){

            }

        }
        function AdjustGridTable () {
            isMobileBrowserOrNarrow();
            var h = 400;
          
            AdjustGrodObj();
            try {
                var tableY = 0;
                var ee = document.getElementById("navmenu");
                
                <% if (IsMobile()){ %>
                tableY = -26;
                <% }else {%>
                tableY = ee.offsetHeight;
                <% }%>
                h = document.body.offsetHeight-tableY-56;
                   //var ee = document.getElementById('tinfo');
                    //ee.style.height = h + "px";

                } catch (err) {
            }
            grid.setWidth(document.documentElement.clientWidth - 2);
            grid.setHeight(h);
            grid.doComponentLayout();
            
            var e = document.getElementById("grid-example");
                e.style.height = h + "px";
            
            e = document.getElementById("rowcontainer");
            e.style.height = h + "px";
            
        }
        
            function CreateAddIcon() {
                var container = document.getElementById("tcontainer");
                var tdiv = document.createElement("div");
                tdiv.className = eleClassName;
                tdiv.style.padding = "10px";
                tdiv.style.height="320px";
                tdiv.style.height="320px";
                
                tdiv.style.paddingRight = "1px";

                var dc = document.createElement("div");
                dc.className = "viewcard iconobj";
                dc.style.padding = "10px";
                dc.style.paddingTop = "100px";

                tdiv.appendChild(dc);
                dc.style.width = "95%";
                dc.style.height = "300px";

                var tbl = document.createElement("table");
                tbl.style.width = "100%";
                

                

                dc.appendChild(tbl);


                tbl.style.cursor = "hand";
               

                var tbody = document.createElement("tbody");
                tbl.appendChild(tbody);




                var theadr = document.createElement("tr");
                tbody.appendChild(theadr);

                //theadr.style.backgroundColor = "#f8f8f8";


                var ttitled = document.createElement("td");
                theadr.appendChild(ttitled);
                ttitled.style.height = "48px";
                ttitled.style.paddingLeft = "5px";
                ttitled.style.color = "#808080";
                ttitled.align = "center";
                ttitled.style.fontSize = "16px";
                ttitled.style.borderBottom = "0px solid #d0d0d0";

                //ttitled.innerHTML = "New Tenant";
                var tbodyr = document.createElement("tr");
                tbody.appendChild(tbodyr);
                //tbodyr.style.backgroundColor = "#f8f8f8";

                var tbodyd = document.createElement("td");
                tbodyr.appendChild(tbodyd);
                tbodyd.style.padding = "3px";

                tbodyd.align = "center";
                tbodyd.vAlign = "middle";
                tbodyd.innerHTML = "<span style='font-size: 90px; cursor:pointer;color:#404040'><a style='font-size: 90px; curor:hand;' href='#' onclick='return false;' class='secpaneltextcolor'>+</a></span><br/><span style='font-size:18px; color:#565656; font-weight:100'><asp:Localize meta:resourcekey="str_newTnt" runat="server">New Tenant</asp:Localize></span>";
                tbodyd.style.cursor = "hand";
                tbodyd.onclick = function() {
                    OnAddTeam();
                };

                tbodyr = document.createElement("tr");
                tbody.appendChild(tbodyr);
                tbodyd = document.createElement("td");
                tbodyr.appendChild(tbodyd);
                tbodyd.style.height="84px";
                tbodyd.style.paddingTop="44px";
                tbodyd.align = "right";
                tbodyd.innerHTML = "&nbsp"; 

                container.appendChild(tdiv);
            }

            var menuidindex = 1;
            var menu = null;

            function TenantMenu(o,index) {
                var rect = o.getBoundingClientRect();

            var isClusterAdmin = false;
            var DelAction = {};
            try{
                isClusterAdmin = myData[index][10] == "<%=m_DefaultDomainId%>"; 
            }catch(ex){
                console.log("TenantMenu:ex:"+ex);
            }
            if(isClusterAdmin){
                DelAction = new Ext.Action({
                disabled:true,
                text: "<span style='color:#C0C0C0;font-weight:100 !important;cursor:default;'><asp:Localize meta:resourcekey="js_string24" runat="server">Delete Tenant</asp:Localize></span>",
                handler: function () { }});
            }else{
                DelAction = new Ext.Action({
                text: "<span style='color:#565656; font-weight:100!important'><asp:Localize meta:resourcekey="js_string24" runat="server">Delete Tenant</asp:Localize></span>",
                handler: function () {
                    /*var btn = document.getElementById('ctl00_MainContent_DeleteTenant');
                    var domainid = document.getElementById('ctl00_MainContent_PageDomainId');
                    var adminid = document.getElementById('ctl00_MainContent_Admin');
                    var name = unescape(myData[index][17]);
                    name = name.replace(/&nbsp;/gi, " ");
                    if (confirm("<asp:Localize meta:resourcekey="js_string25" runat="server">Do you really want to delete (</asp:Localize>" + name + ")?")) {
                        domainid.value =myData[index][10];
                        adminid.value = myData[index][11];
                        Wait("<asp:Localize meta:resourcekey="js_string26" runat="server">Deleting</asp:Localize>");
                        try{
                            parent.DeleteTenant(domainid.value);
                        }catch(E){

                        }
                        btn.click();
                    }*/
                    var domainid = document.getElementById('ctl00_MainContent_PageDomainId');
                    var adminid = document.getElementById('ctl00_MainContent_Admin');
                    var name = unescape(myData[index][17]); 
                    domainid.value =myData[index][10];
                    adminid.value = myData[index][11];
                    DeleteTenantConfirm(name);
                },
                scope: this,
                iconCls: 'cm-publish16'
                });
            }
                    
            var ScanAction = new Ext.Action({
                text: "<span style='color:#565656; font-weight:100!important'>"+"<asp:Localize meta:resourcekey="js_string34" runat="server">Force full scan for storage quota usage</asp:Localize>"+"</span>",
                handler: function () {
                    var btn = document.getElementById('ctl00_MainContent_ScanTenant');
            var domainid = document.getElementById('ctl00_MainContent_PageDomainId');
            var adminid = document.getElementById('ctl00_MainContent_Admin');

                    if (confirm("<asp:Localize meta:resourcekey="js_string35" runat="server">It may take a long time to process for accounts that have significant storage usage , continue?</asp:Localize>")) {
                        domainid.value =myData[index][10];
                        adminid.value = myData[index][11];
                        Wait("<asp:Localize meta:resourcekey="js_string36" runat="server">Scanning...</asp:Localize>");
            btn.click();
                }    

        },
        scope: this,
            iconCls: 'cm-publish16'
        });
        var EditAction = new Ext.Action({
            text: "<span style='color:#565656; font-weight:100!important'>"+"<asp:Localize meta:resourcekey="js_string39" runat="server">Manage Tenant</asp:Localize>"+"</span>",
            handler: function () {
                ShowDashboard(myData[index][11],myData[index][17] );           
            },
            scope: this,
            iconCls: 'cm-publish16'
        });

        var ChangePwd = new Ext.Action({
            text: "<span style='color:#565656; font-weight:100!important'>"+"<asp:Localize meta:resourcekey="js_string40" runat="server">Change Tenant Admin Password</asp:Localize>"+"</span>",
            handler: function () {
                ResetPassword(myData[index][21]);
            },
            scope: this,
            iconCls: 'cm-publish16'
        });
        var EditStorage = new Ext.Action({
            text: "<span style='color:#565656; font-weight:100!important'>"+"<asp:Localize meta:resourcekey="js_string41" runat="server">Edit Existing Default Storage</asp:Localize>"+"</span>",
            handler: function () {
                if (myData[index][16] == "False")
                    EditLocalStorage(myData[index][10]);
                else
                    EditCloudStorage(myData[index][10]);

            },
            scope: this,
            iconCls: 'cm-publish16'
        });
        var ReplaceStorage = new Ext.Action({
            text: "<span style='color:#565656; font-weight:100!important'>"+"<asp:Localize meta:resourcekey="js_string42" runat="server">Replace default storage with new cloud storage</asp:Localize>"+"</span>",
            handler: function () {
                EditCloudStorageEx(myData[index][10]);
            },
            scope: this,
            iconCls: 'cm-publish16'
        });
        var ReplaceLocalStorage = new Ext.Action({
            text: "<span style='color:#565656; font-weight:100!important'>"+"<asp:Localize meta:resourcekey="js_string43" runat="server">Replace default storage with new local storage</asp:Localize>"+"</span>",
            handler: function () {
                EditLocalStorage(myData[index][10]);
                             
            },
            scope: this,
            iconCls: 'cm-publish16'
        });
            
        if (menu != null) {
            menu.close();
            menu = null;
        }
          <%if (m_CanChangeDefaultStorage)
        { %>
        menu = new Ext.menu.Menu({
            id: 'grid-ctx',
            items: [EditAction,ScanAction,'-',ChangePwd,'-',EditStorage,ReplaceStorage,ReplaceLocalStorage,'-', DelAction]
        });
            <%}
        else
        { %>
        menu = new Ext.menu.Menu({
            id: 'grid-ctx',
            items: [EditAction,ScanAction,'-',ChangePwd,'-',EditStorage,'-', DelAction]
        });

        <%} %>

            <% if (SessionIsDelegateClusterAdmin)
        { %>
        DelAction.hide();
            <% } %>
          
        menu.showAt({ x: rect.left+4, y: rect.top+18 });
        }

        function CreateIconView() {
            var container = document.getElementById("tcontainer");
            var count = myData.length;

          <% if (!SessionIsDelegateClusterAdmin && !IsMobile())
        { %>
          CreateAddIcon();
          <%} %>
          
          for (var i = 0; i < count; ++i) {
              var tdiv = document.createElement("div");
              tdiv.className = eleClassName;
              tdiv.style.padding = "10px";
              tdiv.style.paddingRight = "1px";
              tdiv.style.height="320px";
              
              tdiv.style.boxShadow = "0px 0px 0px #cccccc !important";
       
              var divp1 = document.createElement("div");
              divp1.className= "viewcard iconobj";
              divp1.style.height = "300px";
              divp1.style.width  = "95%";
              divp1.style.boxShadow = "0px 0px 0px #cccccc !important";
              divp1.style.backgroundImage=  "url(images/tenantbg.jpg)";
              tdiv.appendChild(divp1);

              var divph = document.createElement("div");
              divph.className= "panel-body";  
              divph.style.textAlign = 'right';
              divph.style.height = '48px';
              divph.style.position = 'absolute';
              divph.style.top = '15px';
              divph.style.left = '15px';
              divph.style.width = '100px';
              divp1.appendChild(divph);

              var divhm = document.createElement("div");
              divhm.style.textAlign = 'right';
              divhm.style.height = '48px';
              divhm.style.position = 'relative';
              divhm.style.top = '10px';
              divhm.style.left = '0px';
              divhm.style.width = '100%';
              divhm.innerHTML = "<span class='fa fa-bars secpaneltextcolor' style='font-size:18px;padding:5px; font-weight:400;cursor: pointer;' onclick='TenantMenu(this,\""+i+"\")' />&nbsp;";
              divp1.appendChild(divhm);

              var divpb = document.createElement("div");
              divpb.style.marginTop = "-15px";
              divp1.appendChild(divpb);
              if (myData[i][20].toLowerCase().indexOf("cctenants64.png") == -1) {
                  //tenant has a branded image
                  divph.style.backgroundImage = 'url("' + myData[i][20] + '")';
                  divph.style.backgroundRepeat = 'no-repeat';
                  divph.style.backgroundSize = 'auto 48px';
              } else {
                  //generic tenant vector icon
                  var ficon = document.createElement("div");
                  ficon.style.position = "absolute";
                  ficon.innerHTML = "<i class=\"gladinet-icons md-45 iconviewitemcolor hand center \" style=\"line-height:1;\">t</i></div>";
                  ficon.style.zIndex = "100";                  
                  divph.appendChild(ficon);                  
              }

              
              var tbl = document.createElement("table");

              tbl.style.width = "100%";
              //tbl.style.height = "300px";
              //tbl.className = "panel";
              divpb.appendChild(tbl);
              tbl.border = "0";
              

              var tbody = document.createElement("tbody");
              tbl.appendChild(tbody);
              tbody.style.border = "0px solid #e0e0e0";
              //tbody.style.borderRight = "2px solid #e0e0e0";
              //tbody.style.borderBottom = "1px solid #e0e0e0";
              
              
              var theadr = document.createElement("tr");
              //tbody.appendChild(theadr);
              //theadr.style.backgroundColor = "#35BAF6";
              //theadr.style.backgroundColor = "#f0f0f0";
              
              var ted = document.createElement("td");
              theadr.appendChild(ted);

              var ttbl = document.createElement("table");
              var ttbd = document.createElement("tbody");
              ttbl.appendChild(ttbd);
              var ttr = document.createElement("tr");
              ttbd.appendChild(ttr);
              ted.appendChild(ttbl);
              ttbl.border = "1";
              var tld = document.createElement("td");
              ttr.appendChild(tld);
              var tl = document.createElement("img");
              tl.src = myData[i][20];
              
              tld.appendChild(tl);

              var ttitled = document.createElement("td");
              // ttr.appendChild(ttitled);


              ttitled.style.height = "48px";
              ttitled.style.paddingLeft = "5px";
              ttitled.style.color = "#404040";
              //ttitled.style.color = "#f0f0f0";
              ttitled.className = "x-tab-default-active x-window-header-text-container-default x-header-text";
              ttitled.style.fontSize = "16px";
              ttitled.style.borderBottom = "1px solid #d0d0d0";
              ttitled.align = "right";
              //ttitled.innerHTML = "<img src='/webui/image-gray/tree-24.png' onclick='TenantMenu(this,\""+i+"\")'/>";
              ttitled.innerHTML = "<span class='fa fa-bars' onclick='TenantMenu(this,\""+i+"\")' />&nbsp;";
              

              var tbodyr = document.createElement("tr");
              tbody.appendChild(tbodyr);
              
              // tbodyr.style.backgroundColor = "white";
              var tbodyd = document.createElement("td");
              tbodyr.appendChild(tbodyd);
              tbodyd.style.padding = "3px";
              tbodyr.id = "" + i;
              tbodyr.onclick = function() {
                  var index = this.id;
                  ShowDashboard(myData[index][11],myData[index][17]);   
                  
              }
              tbodyr.title = "<asp:Localize meta:resourcekey="js_string38" runat="server">Click to manage</asp:Localize>";
              tbodyr.style.cursor = "pointer";

              var tblc = document.createElement("table");
              tblc.style.width = "100%";
              var tcbody = document.createElement("tbody");
              tblc.appendChild(tcbody);
              tbodyd.appendChild(tblc);
              tblc.border = "0";
              

              var titletr = document.createElement("tr");
              tcbody.appendChild(titletr);
              var titletd = document.createElement("td");
              titletr.appendChild(titletd);
              titletd.style.height = "150px";
              titletd.style.borderBottom = "1px solid #f0f0f0";
              titletd.className = "innerboxbordercolor";
              //titletd.style.backgroundColor = "white";
              titletd.style.whiteSpace == 'nowrap';
              titletd.align = "center";
              titletd.vAlign = "middle";
              titletd.style.cursor = "pointer";
              //titletd.style.overflowX = "scroll";
              var localStr = unescape(myData[i][17]);
              if (localStr.length> 16) {
                  localStr = localStr.substring(0, 16);
              }
              localStr= Ext.util.Format.htmlEncode(localStr);

              var userNameStr = unescape(myData[i][1]).replace('&nbsp;', ' ');
              userNameStr= Ext.util.Format.htmlEncode(userNameStr);

              var emailStr = myData[i][2];
              emailStr= Ext.util.Format.htmlEncode(emailStr);


              titletd.innerHTML = "<span style='font-size: 30px;cursor: pointer;font-weight:100;  color:#404040' class='sectextcolor'>"+localStr+"</span><br/>"+"<span style='font-size: 10px;cursor: pointer;color:#808080;font-weight:100; '>"+userNameStr+"</span><br/>"+"<span style='cursor: pointer;font-size: 10px;color:#808080;font-weight:100; '>"+emailStr+"</span>";
              titletd.colSpan = "2";

              var stastictr = document.createElement("tr");
              tcbody.appendChild(stastictr);
              var stastictd = document.createElement("td");
              stastictr.appendChild(stastictd);
              //stastictd.style.backgroundColor = "red";
              stastictd.style.height = "100px";
              stastictd.style.width = "50%";
              stastictd.style.borderRight = "1px solid #f0f0f0";
              stastictd.style.whiteSpace == 'nowrap';
              stastictd.align = "center";
              stastictd.vAlign = "middle";
              stastictd.innerHTML = "<span style='font-size: 24px; font-weight:100; color:#868686'>"+myData[i][18]+"</span><span style='font-size: 10px;color:#808080'> <asp:Localize meta:resourcekey="str_usr" runat="server">user(s)</asp:Localize></span><br/>"+"<span><span class='badge' style='background-color:white; color:#565656;font-size: 14px; border:1px solid #d0d0d0; color:#868686;font-weight:100;'>"+myData[i][5]+"</span><span style='font-size: 14px; color:#868686;font-weight:100;'> <asp:Localize meta:resourcekey="str_usrLic" runat="server">user license(s)</asp:Localize></span></span>";

              var stastictdr = document.createElement("td");
              stastictr.appendChild(stastictdr);
              stastictdr.align = "center";
              stastictdr.vAlign = "middle";

              stastictdr.innerHTML = "<span style='font-size: 24px; font-weight:100; color:#868686'>"+Ext.util.Format.fileSize(myData[i][3])+"</span><br/>"+"<span class='badge' style='background-color:white; color:#565656;font-size: 14px; border:1px solid #d0d0d0; color:#868686;font-weight:100;'>"+myData[i][4]+"</span>";


              stastictr = document.createElement("tr");
              tcbody.appendChild(stastictr);
              stastictd = document.createElement("td");
              stastictr.appendChild(stastictd);
              //stastictd.style.backgroundColor = "red";
              stastictd.style.height = "10px";
              stastictd.style.width = "50%";
              stastictd.style.borderRight = "1px solid #f0f0f0";
              stastictd.style.whiteSpace == 'nowrap';
              stastictd.id = "user_" + myData[i][10];
              stastictd.align = 'center';
              stastictd.style.paddingBottom = "10px";

              stastictdr = document.createElement("td");
              stastictr.appendChild(stastictdr);
              stastictdr.id = "strorage_" + myData[i][10];
              stastictdr.align = 'center';
              stastictdr.style.paddingBottom = "10px";

              

              container.appendChild(tdiv);
              var UserMenubar = Ext.create('Ext.ProgressBar', {
                  height: 5,
                  width: '95%',
                  text: '',
                  color : "#4D0099",
                  id: "userp_" + myData[i][10],
                  cls: 'roundbar',                
                  renderTo:"user_" + myData[i][10]
              });
              var pct = myData[i][18] / myData[i][5];
              UserMenubar.updateProgress(pct   , "");
              if(UserMenubar.getEl())
              {
                  if(pct > 0.9)
                      UserMenubar.getEl().child(".x-progress-bar",true).style.backgroundColor = "#b71c1c";
                  else if(pct > 0.5)
                      UserMenubar.getEl().child(".x-progress-bar",true).style.backgroundColor = "#f57f17";
                  else
                      UserMenubar.getEl().child(".x-progress-bar",true).style.backgroundColor = "#1b5e20";
            
              }

              if (myData[i][19] != 0) {

                  var Storagebar = Ext.create('Ext.ProgressBar', {
                      height: 5,
                      width: '95%',
                      text: '',
                      color : "#4D0099",
                      id: "storagep_" + myData[i][10],
                      cls: 'roundbar',                
                      renderTo:"strorage_" + myData[i][10]
                  });
                  var pct = myData[i][3] / (myData[i][19]*1024*1024*1024);
                  Storagebar.updateProgress(pct   , "");
                  if(Storagebar.getEl())
                  {
                      if(pct > 0.9)
                          Storagebar.getEl().child(".x-progress-bar",true).style.backgroundColor = "b71c1c";
                      else if(pct > 0.5)
                          Storagebar.getEl().child(".x-progress-bar",true).style.backgroundColor = "#f57f17";
                      else
                          Storagebar.getEl().child(".x-progress-bar",true).style.backgroundColor = "#1b5e20";
            
                  }
              }

          }
          
      }

      Ext.require([
          'Ext.grid.*',
          'Ext.data.*',
          'Ext.util.*',
          'Ext.state.*'
      ]);

        function delBtnHdl(tntNme, dmnID, admID) {   
            var domainid = document.getElementById('ctl00_MainContent_PageDomainId');
            var adminid = document.getElementById('ctl00_MainContent_Admin');
            domainid.value = dmnID;
            adminid.value = admID;
            DeleteTenantConfirm(tntNme);

            /*
            var btn = document.getElementById('ctl00_MainContent_DeleteTenant');
            var domainid = document.getElementById('ctl00_MainContent_PageDomainId');
            var adminid = document.getElementById('ctl00_MainContent_Admin');
          
            if (confirm("<asp:Localize meta:resourcekey="js_string25" runat="server">Do you really want to delete (</asp:Localize>" + tntNme + ")?")) {
                domainid.value = dmnID;
                adminid.value = admID;
                try{
                    parent.DeleteTenant(domainid.value);
                }catch(E){

                }
                Wait("<asp:Localize meta:resourcekey="js_string26" runat="server">Deleting</asp:Localize>");
                btn.click();
            } */
      }
      function frcSncBtnHdl(dmnID, admID) {
          var btn = document.getElementById('ctl00_MainContent_ScanTenant');
          var domainid = document.getElementById('ctl00_MainContent_PageDomainId');
          var adminid = document.getElementById('ctl00_MainContent_Admin');
          if (confirm("<asp:Localize meta:resourcekey="js_string35" runat="server">This may take a long time to process for accounts that have significant storage usage. Continue?</asp:Localize>")) {
              domainid.value = dmnID;
              adminid.value = admID;
              Wait("<asp:Localize meta:resourcekey="js_string36" runat="server">Scanning...</asp:Localize>");
              btn.click();
          }    
      }

      Ext.onReady(function () {

          Ext.QuickTips.init();

          var store = Ext.create('Ext.data.ArrayStore', {
              fields: [
                  { name: 'index' },
                  { name: 'fullname' },
                  { name: 'email' },
                  { name: 'used' , sortType: 'asInt' },
                  { name: 'quota' },
                  { name: 'userplan', sortType: 'asInt' },
                  { name: 'resellerid' },
                  { name: 'isactive' },
                  { name: 'storage' },
                  { name: 'pid' },
                  { name: 'domainid' },
                  { name: 'adminid' },
                  { name: 'edition' },
                  { name: 'expire' },
                  { name: 'rname' },
                  { name: 'promo' },
                  { name: 'iscloud' },
                  { name: 'org' },
                  { name: 'users' },
                  { name: 'rq' },
                  { name: 'logo' }
              ],
              data: myData
          });

          isMobileBrowserOrNarrow();

            
          var h = 400;
          
          /*try {
            
            h = document.body.offsetHeight-75;
              var ee = document.getElementById('tinfo');
              ee.style.height = h + "px";

          } catch (err) {
           }*/
          grid = Ext.create('Ext.grid.Panel', {
              
              frame: false,
              store: store,
              stripeRows: true,
              border: false,
              columnLines: false,
              height:h,
              listeners: {
                  itemdblclick: function (grd, rec, colIndex, e) {
                      //UpgardeTeam(rec.data.adminid);
                      ShowDashboard(rec.data.adminid,  rec.data.org );   
                  }
              },
              columns: [
                  
                  {
                      
                  width: 40,
          sortable: true,
          dataIndex: 'logo',                      
          renderer: function (value, metaData, record, rowIndex) {
              if (value.toLowerCase().indexOf("cctenants64.png") != -1) {
                  return "<i class=\"gladinet-icons iconviewitemcolor hand center \" style=\"margin-top:10px;\">t</i></div>";

              }
              return  "<img style='width:32px; height:32px;' src='" + unescape(value) +"'/>";
          }
      },
                  {
                      text: "<span style='font-weight:100; color:#565656'><asp:Localize meta:resourcekey="js_string19" runat="server">Organization</asp:Localize></span>",
                  flex: 1,
          sortable: true,
          dataIndex: 'org',                      
          renderer: function (value, metaData, record, rowIndex) {
              if(record.data.index == 1) {
                              
                  //UpgardeTeam(record.data.adminid);
              }
              return  "<span style='line-height:150%; font-weight:100;' >" + unescape(value) +"</span><br/>" + "<font size='smaller' color='#a0a0a0'>"+ unescape(record.data.fullname) +"("+record.data.email+ ") </font>";
          }
      },  {
          text: "<span style='font-weight:100; color:#565656'><asp:Localize meta:resourcekey="js_string11" runat="server">Expiration</asp:Localize></span>",
          width: 120,
      sortable: true,
      dataIndex: 'expire',
      renderer: function(value, metaData, record, rowIndex) {
          return "<span style='font-weight:100; color:#565656'>" + value + "</span>";
      }
      },
      {
          text: "<span style='font-weight:100; color:#565656'><asp:Localize meta:resourcekey="js_string12" runat="server">Storage Plan</asp:Localize></span>",
          width: 150,
          sortable: true,
          dataIndex: 'quota',
          renderer: function(value, metaData, record, rowIndex) {
              return "<span style='font-weight:100; color:#565656'>" + value + "</span>";
          }
      }, {
        text: "<span style='font-weight:100; color:#565656'><asp:Localize meta:resourcekey="js_string13" runat="server">Storage Type</asp:Localize></span>",
      flex: 1,
      sortable: true,
      dataIndex: 'storage',
      renderer: function(value, metaData, record, rowIndex) {
          return "<span style='font-weight:100; color:#565656'>" + value + "</span>";
      }
      }, {
          text: "<span style='font-weight:100; color:#565656'><asp:Localize meta:resourcekey="js_string14" runat="server">Used</asp:Localize></span>",
          flex: 0,
          sortable: true,
          dataIndex: 'used',renderer: function (value, metaData, record, rowIndex) {

              if(record.data.rq == 0)
                  return "<span style='font-weight:100; color:#1b5e20'>"+Ext.util.Format.fileSize(value)+"</span>";

              var pct = record.data.used / (record.data.rq*1024*1024*1024);
              
              if(pct > 0.9)
                  return "<span style='font-weight:100; color:#b71c1c'>"+Ext.util.Format.fileSize(value)+"</span>";
                      
              if(pct > 0.5)
                  return "<span style='font-weight:100; color:#f57f17'>"+Ext.util.Format.fileSize(value)+"</span>";
                      
            
              return "<span style='font-weight:100; color:#1b5e20'>"+Ext.util.Format.fileSize(value)+"</span>";
                      
            
              

          }
      },
      {
        text: "<span style='font-weight:100; color:#565656'><asp:Localize meta:resourcekey="js_string15" runat="server">User Plan</asp:Localize></span>",
      flex: 0,
      sortable: true,
      dataIndex: 'userplan',
      renderer: function(value, metaData, record, rowIndex) {
          return "<span style='font-weight:100; color:#565656'>" + value + "</span>";
      }
      },{
          text: "<span style='font-weight:100; color:#565656'><asp:Localize runat="server" meta:resourcekey="str_Use">Users</asp:Localize></span>",
          width: 80,
          sortable: true,
          dataIndex: 'users',
          renderer: function(value, metaData, record, rowIndex) {
              return "<span style='font-weight:100; color:#565656'>" + value + "</span>";
          }
      }, {
        text: "<span style='font-weight:100; color:#565656'><asp:Localize meta:resourcekey="js_string20" runat="server">Active</asp:Localize></span>",
      width: 75,
      flex:0,
      sortable: true,
      dataIndex: 'isactive',
      renderer: function (value, metaData, record, rowIndex) {
          var s = unescape(record.data.domainid);              
          var t = '<%=SessionDomainId%>';
                          
                         

                          if (s != t) {
                              if (value == 'True') {
                                  return "<input type='checkbox' checked onclick='OnSuspend(\"" + s + "\")'/>";
                              } else {
                                  return "<input type='checkbox' onclick='OnResume(\"" + s + "\")'/>";
                              }
                          } else {
                            
                          }
                      }
        }, {




                sortable: false,
                width:120,
                renderer: function (value, metaData, record, rowIndex) {
                                
                    var rec = grid.getStore().getAt(rowIndex);
                    var d = rec.data;
                    var tntNme = unescape(d.fullname).replace(/&nbsp;/gi, " ");
                    var dmnID = d.domainid;
                    var admID = d.adminid;
                    var org = d.org;
                    
                    var delBtn = "", editBtn = "", frcSncBtn = "";
                    
                    var delBtnTTip = "data-toggle=\"tooltip\" data-placement=\"bottom\" data-original-title=\"<asp:Localize meta:resourcekey="js_string24" runat="server">Delete Tenant</asp:Localize>\"";
                    var editBtnTTip = "data-toggle=\"tooltip\" data-placement=\"bottom\" data-original-title=\"<asp:Localize meta:resourcekey="str_mgr" runat="server">Manage Tenant</asp:Localize>\"";
                    var frcSncBtnTTip = "data-toggle=\"tooltip\" data-placement=\"bottom\" data-original-title=\"<asp:Localize meta:resourcekey="js_string34" runat="server">Force full scan for storage quota usage</asp:Localize>\"";
                     
                    editBtn = "<div class=\"actioncol\"><i class=\"gladinet-icons md-24 md-dark hand\" onclick='ShowDashboard(\"" + admID +"\",\"" + org + "\")' "+editBtnTTip+">/</i>";    
                    frcSncBtn = "<i class=\"gladinet-icons md-24 md-dark hand\" onclick='frcSncBtnHdl(\"" + dmnID +"\",\"" + admID + "\")' "+frcSncBtnTTip+">Ç</i>";               
                    delBtn = "<i class=\"gladinet-icons md-24 md-dark hand\" onclick='delBtnHdl(\""+org+"\",\"" + dmnID +"\",\"" + admID + "\")' "+delBtnTTip+">n</i></div>";
                    
                    return editBtn+frcSncBtn+delBtn;
                }


            /*

                          xtype: 'actioncolumn',
                          width: 160,
                          flex:0,
                          items:
                          [
                              {
                                  icon: '/portal/images/changepassword.png',  // Use a URL in the icon config
                                  tooltip: "<asp:Localize meta:resourcekey="js_string29" runat="server">Reset Tenant Admin Password</asp:Localize>",
                                                  handler: function (grid, rowIndex, colIndex) {
                                                      var rec = grid.getStore().getAt(rowIndex);
                                                      var d = rec.data;

                                                      ResetPassword(d.email);
                                                  }
                                  ,
                                              getClass: function (v, meta, rec) {
                                                  return 'x-col-hdide';
                                              }
                                          },
                                          {
                                          icon: '/portal/images/activedir.png',  // Use a URL in the icon config
                                              tooltip: "<asp:Localize meta:resourcekey="js_string30" runat="server">Configure Active Directory/LDAP Service for the Tenant</asp:Localize>",
                                          handler: function (grid, rowIndex, colIndex) {
                                              var rec = grid.getStore().getAt(rowIndex);
                                              var d = rec.data;

                                              EditTeamAds(d.domainid);
                                          }
                                          ,
                                          getClass: function (v, meta, rec) {
                                              return 'x-col-hdide';
                                          }
                                          },{
                                              icon: '/portal/images/pie.png',  // Use a URL in the icon config
                                              tooltip: "<asp:Localize meta:resourcekey="str_sud1" runat="server">Storage Usage Detail</asp:Localize>",
                                              handler: function (grid, rowIndex, colIndex) {   
                                                  var rec = grid.getStore().getAt(rowIndex);
                                                  var d = rec.data;

                                                  ShowDashboard(d.domainid);                        
                                                 
                                              },
                                              getClass: function (v, meta, rec) {
                                                  return 'x-col-hdide';
                                              }

                                          },
                                          {
                                          icon: '/portal/images/editstor.png',  // Use a URL in the icon config
                                          tooltip: "<asp:Localize meta:resourcekey="js_string31" runat="server">Edit Existing Default Storage</asp:Localize>",
                                          handler: function (grid, rowIndex, colIndex) {
                                              var rec = grid.getStore().getAt(rowIndex);
                                              var d = rec.data;
                            
                                              if (d.iscloud == "False")
                                                  EditLocalStorage(d.domainid);
                                              else
                                                  EditCloudStorage(d.domainid);

                                          },
                                          getClass: function (v, meta, rec) {
                                              return 'x-col-hdide';            
                                          }

                                          },
                                          {
                                              icon: '/portal/images/mystorage.png',  // Use a URL in the icon config
                                              tooltip: "<asp:Localize meta:resourcekey="js_string32" runat="server">Replace default storage with new cloud storage</asp:Localize>",
                                              handler: function (grid, rowIndex, colIndex) {
                                                  var rec = grid.getStore().getAt(rowIndex);
                                                  var d = rec.data;
                                                  EditCloudStorageEx(d.domainid);

                                              },
                                              getClass: function (v, meta, rec) {
                            
                                                  return 'x-col-hdide';
                            
                           
                                              }

                                          },
                                          {
                                          icon: '/portal/images/addlocal.png',  // Use a URL in the icon config
                                              tooltip: "<asp:Localize meta:resourcekey="js_string33" runat="server">Replace default storage with new local storage</asp:Localize>",
                                          handler: function (grid, rowIndex, colIndex) {
                                              var rec = grid.getStore().getAt(rowIndex);
                                              var d = rec.data;
                                              EditLocalStorage(d.domainid);

                                          },
                                          getClass: function (v, meta, rec) {
                         
                                              var d = rec.data;
                                              return 'x-col-hdide';

                                              if (d.iscloud == "False")
                                                  return 'x-col-hdide';
                                                //% if (!m_CanChangeDefaultStorage) { %//
                                                return 'x-col-hdide';
                                                //%} %//
                                            }

                            },
                            {
                                icon: '/portal/images/manage32.png',  // Use a URL in the icon config
                                tooltip: "<asp:Localize meta:resourcekey="str_editbrand" runat="server">Edit Branding Setting</asp:Localize>",
                                handler: function (grid, rowIndex, colIndex) {
                                    var rec = grid.getStore().getAt(rowIndex);
                                    var d = rec.data;
                                    EditBranding(d.domainid);

                                },
                                getClass: function (v, meta, rec) {
                         
                                    var d = rec.data;
                                    return 'x-col-hdide';
                            
                                }

                            }
                    ]
        */





        }
                  
                  
        ], 

                  
        renderTo: 'grid-example',
       
               
               
            features: [{
                ftype: 'rowbody',
               
                setupRowData: function(record, rowIndex, rowValues) {
                    var headerCt = this.view.headerCt,
					colspan = headerCt.getColumnCount();
                    // Usually you would style the my-body-class in CSS file
                    if (g_isMobileBrowserOrNarrow) {
                        var myRowBodyTpl =  new Ext.XTemplate( '<p> {fullname:this.formatName} &lt;{email}&gt; - {org}</p>',
                        '<p>{users} of {userplan} Users, {used:this.formatSize} of {quota} Storage</p>',
                        {
                            formatSize: function(v){
                  
                                return Ext.util.Format.fileSize(v);
                            },
                            formatName: function(v) {
                                return decodeURIComponent(v);
                            }
                        });

                        rowValues.rowBody = myRowBodyTpl.applyTemplate(record.getData()); 
                        rowValues.rowBodyCls = 'x-grid-rowbody-tr';
                    } else {
                        rowValues.rowBody = '';
                        rowValues.rowBodyCls = 'x-grid-row-body-hidden';
                    }
					
                }
            },
                {
                    ftype: 'rowwrap'
                }]
        });

        //Ext.EventManager.onWindowResize(grid.doLayout, grid);
        Ext.EventManager.onWindowResize(AdjustGridTable);
        AdjustGridTable ();

        grid.hide();
        CreateIconView();
        
       
        try {
            document.body.style.backgroundColor = "#f8f8f8";
            if (PageGetUIState("tenmgr") == "1") {
                OnListView();
            }
        } catch (e) {
            
          }

        <asp:Literal id="LtlScripts" runat="server" />

        });


        function OnIconView() {

            document.body.style.backgroundColor = "#f8f8f8";
            var container = document.getElementById("rowcontainer");
            container.style.display = "";
            grid.hide();

            var e = document.getElementById("listview");
            e.style.display = "";
            e = document.getElementById("iconview");
            e.style.display = "none";

            PageSetUIState("tenmgr", "0");
        }

        function OnListView() {

            document.body.style.backgroundColor = "white";
            var container = document.getElementById("rowcontainer");
            container.style.display = "none";
            grid.show();

            var e = document.getElementById("listview");
            e.style.display = "none";
            e = document.getElementById("iconview");
            e.style.display = "";

            PageSetUIState("tenmgr", "1");

          
        }

        try {
            parent.ClearRelativePageTitle();
        } catch (e) {
            
        }
    </script>
    <div style="position: absolute; width: 1px; height: 1px; left: -100px">
        <iframe style="width: 1px; height: 1px;" id="downloadframe"></iframe>
    </div>
</asp:Content>
