﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using System.Collections;
using System.Text;

using GladinetStorage;
using user;
using reseller;

namespace GladinetPayFlow
{
    public class UpdateBasePage : BasePage
    {
        protected string baseErrmsg = "";

        protected GladinetStorageDescriptor PageGSD
        {
            get
            {
                string xml = GetSessionValue("update_gsd");
                if (string.IsNullOrEmpty(xml))
                    return null;
                GladinetStorageDescriptor gsd = new GladinetStorageDescriptor();
                try
                {
                    gsd.fromXml(xml);
                }
                catch (Exception)
                {
                    return null;
                }

                return gsd;
            }
            set
            {
                string result = value.toXml();
                result = result.Replace("\n", "");
                result = result.Replace("\t", "");

                AddOrSetValue("update_gsd", result);
                
            }
        }

        protected void GetPageGsd()
        {
            if (!IsPostBack)
            {
                string cookie = Request.Cookies["y-glad-token"].Value;
                if (string.IsNullOrEmpty(cookie))
                {
                    baseErrmsg = "Session Expired, Please Login again";
                    Response.Redirect("../loginpage.aspx");
                    return;
                }
               

                GuidResult gr = AccessTicket.GetUserGuidByIdentityTicket(cookie);
                if (!gr.Success)
                {
                    baseErrmsg = "Session Expired, Please Login again";
                    Response.Redirect("../loginpage.aspx");
                    return;
                }

                string s = ClusterSettings.GetSingleUserSetting(gr.Guid, Common.HomeStorageServiceString, Common.StorageDescriptorTag);
                if (string.IsNullOrEmpty(s))
                {
                    baseErrmsg = "No storage config found";
                    return;
                }
                GladinetStorageDescriptor gsd = new GladinetStorageDescriptor();
                gsd.fromXml(s);
                PageGSD = gsd;
            }
        }

        protected Result SaveGSD(GladinetStorageDescriptor gsd)
        {

            Result result = new Result();

            try
            {
                GladCloudDomain.OnTeamConfigureChanged(new Guid(SessionDomainId));
            }
            catch (Exception)
            {

            }

            string cookie = Request.Cookies["y-glad-token"].Value;
            if (string.IsNullOrEmpty(cookie))
            {
                baseErrmsg = "Session Expired, Please Login again";
                Response.Redirect("../loginpage.aspx");
                result.Success = false;
                result.Reason = FAILED_REASON.INVALID_TOKEN_EXPIRED.ToString("f");
                return result;
            }

            GuidResult gr = AccessTicket.GetUserGuidByIdentityTicket(cookie);
            if (!gr.Success)
            {
                baseErrmsg = "Session Expired, Please Login again";
                Response.Redirect("../loginpage.aspx");
                result.Success = false;
                result.Reason = FAILED_REASON.INVALID_TOKEN_EXPIRED.ToString("f");
                return result;
            }

            result.Success = ClusterSettings.AddOrUpdateUserSetting(gr.Guid, Common.HomeStorageServiceString, gsd.toXml(), Common.StorageDescriptorTag);

            if (result.Success)
            {
                Response.Redirect("../MyAccountPage.aspx");
                
            }

            return result;


        }
    }
}