﻿<%@ Page Title="Gladinet Cloud - Setup OpenStack Storage Account" Language="C#" MasterPageFile="StorageConfig.master"
    AutoEventWireup="true" CodeBehind="OpenStack.aspx.cs" Inherits="GladinetPayFlow.StorageConfig.OpenStack" culture="auto" meta:resourcekey="PageResource1" uiculture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">

    <style type="text/css">
        .titlecol
        {
            background-color: #f0f0f0;
            font-size: 14px;
        }
        
        *
        {
            margin: 0;
        }
        html, body
        {
            height: 100%;
        }
        .main, #aspnetForm, .tabpanel, .storagepanel, #Form2, div.textbox, .storagetd
         {
             height: 100%;
         }
        .wrapper
        {
            min-height: 100%;
            height: auto !important;
            height: 100%;
            padding: 0px;
            background-color: white;
            margin: 0 auto -69px; /* the bottom margin is the negative value of the footer's height */
            overflow:auto;
        }
        .footer, .push
        {
            height: 68px; /* .push must be the same height as .footer */
        }
    </style>
    </asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
    <div class="wrapper">
        <table width="100%">
            <tr> <td align="center" style="padding-top:30px;">
    <table width="100%" align="center" style="background: WHITE; padding: 15px; padding-top:1px;max-width:800px;" cellspacing="0"
        id="input_panel">
        <tr>
            <td>
                <table width="100%">
                    <tr>
                        <td width="80px">
                            <asp:Image ID="ImageStorage" runat="server" ImageUrl="~/StorageConfig/images/openstack.jpg"
                                Width="80px" meta:resourcekey="ImageStorageResource1" />
                        </td>
                        <td>
                             <h3 style="color: #565656; font-weight:100; ">
                                <asp:Label ID="LabelStorage" runat="server" Text="Label Storage" 
                                    meta:resourcekey="LabelStorageResource1"></asp:Label>
                                <asp:Localize meta:resourcekey="asp_string1" runat="server" Text="Information"></asp:Localize></h3>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
        <tr>
            <td style="padding: 10px; padding-top:0px; vertical-align: top;">
                
                <b>
                    <asp:Label ID="ErrorMsg" runat="server" Style="color: Red;" 
                    meta:resourcekey="ErrorMsgResource1"></asp:Label></b>
                
                <%if(FirstStage){ %>
                <asp:Panel ID="PanelEndPoint" runat="server" 
                    meta:resourcekey="PanelEndPointResource1">
                    <table width="100%" align="center" >
                        
                        <tr>
                            <td style="padding-top: 15px;">
                                 <h4 style="color: #565656; font-weight:100; ">
                                <asp:Localize meta:resourcekey="asp_string2" runat="server" 
                                    Text="OpenStack API End-Point:"></asp:Localize>(<asp:Localize 
                                    ID="Localize1" meta:resourcekey="asp_string3" runat="server" Text="Example"></asp:Localize>: https://auth.yourdomain.com/v1.0)
                                     </h4>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <asp:TextBox ID="TextBoxEndPoint" runat="server" Width="96%"  
                                    meta:resourcekey="TextBoxEndPointResource1" CssClass="form-control"></asp:TextBox><br />
                                
                            </td>
                        </tr>
                    </table>
                </asp:Panel>
                <%} %>
                <table width="100%" align="center" >
                <%if(FirstStage){ %>
                    <tr>
                        <td height="15px" style="padding-top: 15px;">
                             <h4 style="color: #565656; font-weight:100; ">
                            <asp:Label ID="LabelAccessKey" runat="server" 
                                Text="Access Key ID (X-Auth-User or Username)" 
                                meta:resourcekey="LabelAccessKeyResource1"></asp:Label>
                                 </h4>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <asp:TextBox ID="TxtAccessKey" runat="server" Width="96%" 
                                meta:resourcekey="TxtAccessKeyResource1" CssClass="form-control"></asp:TextBox>
                            <asp:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server" ErrorMessage="Access Key Required"
                                ControlToValidate="TxtAccessKey" ForeColor="#CC0000" CssClass="errmsg" 
                                meta:resourcekey="RequiredFieldValidator1Resource1"></asp:RequiredFieldValidator>
                        </td>
                    </tr>
                    <tr>
                        <td>
                             <h4 style="color: #565656; font-weight:100; ">
                            <asp:Label ID="LabelSecret" runat="server" 
                                Text="Secret Access Key (X-Auth-Key or API Key)" 
                                meta:resourcekey="LabelSecretResource1"></asp:Label>
                                 </h4>
                        </td>
                    </tr>
                    <tr>
                        <td height="15px">
                            <asp:TextBox ID="TxtSecretKey" runat="server" Width="96%" TextMode="Password" 
                                meta:resourcekey="TxtSecretKeyResource1" 
                                CssClass="form-control"></asp:TextBox>
                            
                            <asp:RequiredFieldValidator ID="RequiredFieldValidator2" runat="server" ControlToValidate="TxtSecretKey"
                                ErrorMessage="Secret Key Required" ForeColor="#CC0000" CssClass="errmsg" 
                                meta:resourcekey="RequiredFieldValidator2Resource1"></asp:RequiredFieldValidator>
                        </td>
                    </tr>
                    <%}else{ %>
                    <tr>
                        <td>
                            <asp:Panel ID="PanelPickBucket" runat="server" 
                                meta:resourcekey="PanelPickBucketResource1">
                                <table width="100%" border="0">
                                    <tr>
                                        <td>
                                             <h4 style="color: #565656; font-weight:100; ">
                                            <asp:Localize meta:resourcekey="asp_string4" runat="server" 
                                                Text="Select a Container"></asp:Localize>
                                                 </h4>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td height="32">
                                            <asp:DropDownList ID="DropDownListBuckets" runat="server" AutoPostBack="True" CssClass="browser-default custom-select secsubbordercolor"
                                                OnSelectedIndexChanged="DropDownListBuckets_SelectedIndexChanged" 
                                                meta:resourcekey="DropDownListBucketsResource1">
                                                <asp:ListItem meta:resourcekey="ListItemResource1" 
                                                    Text="{Test Connection First}"></asp:ListItem>
                                            </asp:DropDownList>
                                            &nbsp;
                                            <br />
                                            <asp:Panel ID="PanelCreateBucket" runat="server" 
                                                meta:resourcekey="PanelCreateBucketResource1">
                                                <asp:Localize meta:resourcekey="asp_string5" runat="server" 
                                                    Text="New Container Name"></asp:Localize> :&nbsp;
                                                <asp:TextBox ID="TxtNewBucket" runat="server" Width="96%"  CssClass="form-control"
                                                    meta:resourcekey="TxtNewBucketResource1" 
                                                    ></asp:TextBox>
                                                <br />
                                            </asp:Panel>
                                            <br />
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <asp:Panel ID="PanelPickFolder" runat="server" 
                                                meta:resourcekey="PanelPickFolderResource1">
                                                <asp:Panel ID="PanelFolderDropDown" runat="server" Visible="False" 
                                                    meta:resourcekey="PanelFolderDropDownResource1">
                                                    <table width="100%" border="0">
                                                        <tr>
                                                            <td height="32">
                                                                <asp:Localize meta:resourcekey="asp_string6" runat="server" 
                                                                    Text="Select a Folder (Leave it blank for the root folder in the bucket)"></asp:Localize>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td>
                                                                <asp:DropDownList ID="DropDownListFolder" runat="server"  CssClass="browser-default custom-select secsubbordercolor"
                                                                    meta:resourcekey="DropDownListFolderResource1">
                                                                </asp:DropDownList>
                                                            </td>
                                                        </tr>
                                                    </table>
                                                </asp:Panel>
                                            </asp:Panel>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <asp:CheckBox ID="SupportADAuth" runat="server" 
                                                Text="Allow users to use Active Directory credentials when the OpenStack storage supports Active Directory Authentication" 
                                                meta:resourcekey="SupportADAuthResource1"/>
                                            
                                            <div class='idea_flex' style="height: 70px; padding-top: 3px; vertical-align: middle;">
                                                <asp:Localize meta:resourcekey="str_adhint" runat="server" 
                                                    Text="don't turn on the option if your OpenStack storage doesn't support Active Directory integration or you don't plan to use OpenStack storage's Active Directory integration."></asp:Localize>
                                            </div>
                                            </td>
                                    </tr>
                                </table>
                            </asp:Panel>
                        </td>
                    </tr>
                    <%} %>
                    <tr>
                        <td align="center">
                            
                        </td>
                    </tr>
                    <tr>
                                    <td align="right">
                                        <asp:Localize runat="server" ID="LocPlsWat" meta:resourcekey="str_plsWat" Visible="False">Please Wait</asp:Localize> 
                                        <asp:Localize runat="server" ID="LocApyChg" meta:resourcekey="str_apyChg" Visible="False">Applying Changes</asp:Localize> 
                                        <%if (!string.IsNullOrEmpty(StorageConfigBackPage))
  { %>
                                            <asp:Button ID="Back1" runat="server" 
                                                CssClass="btn" CausesValidation="False" OnClick="Back_Click" 
                                                meta:resourcekey="BackResource1" Text="Back"></asp:Button>
                                        
                                        <%} %>
                                    &nbsp;&nbsp;
                                        
                                            <asp:Button ID="LinkButtonNext1" runat="server" 
                                                OnClick="ButtonFinish_Click" 
                                                CssClass="btn btn-primary gladbtn" meta:resourcekey="LinkButtonNextResource1" 
                                                Text="Finish"></asp:Button>
                                        
                                    
                                        <%if (!string.IsNullOrEmpty(StorageConfigCancelPage))
  { %>
                                        &nbsp;&nbsp;
                                            <asp:Button ID="CancelBtn1" runat="server" 
                                                CssClass="btn" OnClick="CancelBtn_Click" CausesValidation="False" 
                                                meta:resourcekey="CancelBtnResource1" Text="Cancel"></asp:Button>
                                        
                                        <%} 
                                          Back1.OnClientClick = String.Format("Wait('{0}')", LocApyChg.Text);
                                          LinkButtonNext1.OnClientClick = String.Format("Wait('{0}')", LocApyChg.Text);
                                          CancelBtn1.OnClientClick = String.Format("Wait('{0}')", LocPlsWat.Text);
                                        %>
                                    </td>
                                </tr>
                </table>
            </td>
        </tr>
    </table>
                </td></tr></table>
    </div>

    <div class="footer x-panel-header-light" style="border-left: 0; border-right: 0;
        border-bottom: 0; vertical-align: middle;">
        <table width="100%" style="height: 64px; text-align:right; padding-right:64px;" align="right">
                                
                            </table>
                            </div>
</asp:Content>
