﻿<%@ Page Title="Gladinet Cloud - Setup HPCloud Storage Account" Language="C#" MasterPageFile="StorageConfig.master"
    AutoEventWireup="true" CodeBehind="HPCloud.aspx.cs" Inherits="GladinetPayFlow.StorageConfig.HPCloud" culture="auto" meta:resourcekey="PageResource1" uiculture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
        .style1
        {
            color: #339966;
        }
    </style>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
    <table width="100%" align="center" style="background: WHITE; padding: 15px;" cellspacing="0"
        id="input_panel">
        <tr>
            <td>
                <table width="100%">
                    <tr>
                        <td width="80px">
                            <img src="../images/HPCloud.png" width="80px" />
                        </td>
                        <td>
                            <h2>
                                <asp:Label ID="LabelStorage" runat="server" Text="Label Storage" 
                                    meta:resourcekey="LabelStorageResource1"></asp:Label>
                                <asp:Localize meta:resourcekey="asp_string1" runat="server">Account Configuration</asp:Localize></h2>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
        <tr>
            <td style="padding: 10px; vertical-align: top;">
                <b>
                    <asp:Label ID="ErrorMsg" runat="server" Style="color: Red;" 
                    meta:resourcekey="ErrorMsgResource1"></asp:Label></b>
                <br />
                <%if (FirstStage)
                  { %>
                <asp:Panel ID="PanelEndPoint" runat="server" 
                    meta:resourcekey="PanelEndPointResource1">
                    <table width="100%" align="center">
                        <tr>
                            <td>
                                <strong><asp:Localize meta:resourcekey="asp_string2" runat="server">Identity Service v2.0 API End-Point:</asp:Localize> </strong>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <asp:TextBox ID="TextBoxEndPoint" runat="server" Width="100%" 
                                    meta:resourcekey="TextBoxEndPointResource1">https://region-a.geo-1.identity.hpcloudsvc.com:35357/v2.0/</asp:TextBox><br />
                            </td>
                        </tr>
                    </table>
                </asp:Panel>
                <%} %>
                <table width="100%" align="center" cellspacing="5">
                    <%if (FirstStage)
                      { %>
                    <tr>
                        <td colspan="2">
                            <asp:RequiredFieldValidator ID="RequiredFieldValidator4" runat="server" ErrorMessage="Region Required"
                                ControlToValidate="TxtRegion" ForeColor="#CC0000" CssClass="errmsg" 
                                meta:resourcekey="RequiredFieldValidator4Resource1"></asp:RequiredFieldValidator>
                            <asp:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server" ErrorMessage="Tenant ID Required"
                                ControlToValidate="TxtAccessKey" ForeColor="#CC0000" CssClass="errmsg" 
                                meta:resourcekey="RequiredFieldValidator1Resource1"></asp:RequiredFieldValidator>
                            <asp:RequiredFieldValidator ID="RequiredFieldValidator3" runat="server" ErrorMessage="Tenant Name Required"
                                ControlToValidate="TxtUsername" ForeColor="#CC0000" CssClass="errmsg" 
                                meta:resourcekey="RequiredFieldValidator3Resource1"></asp:RequiredFieldValidator>
                            <asp:RequiredFieldValidator ID="RequiredFieldValidator2" runat="server" ControlToValidate="TxtSecretKey"
                                ErrorMessage="Password Required" ForeColor="#CC0000" CssClass="errmsg" 
                                meta:resourcekey="RequiredFieldValidator2Resource1"></asp:RequiredFieldValidator>
                        </td>
                    </tr>
                    <tr>
                        <td width="220px" style="padding-top: 5px">
                            <asp:Label ID="Label2" runat="server" Text="Region" Style="font-weight: 700" 
                                meta:resourcekey="Label2Resource1"></asp:Label>
                        </td>
                        <td valign="bottom" style="padding-top: 5px">
                            <asp:TextBox ID="TxtRegion" runat="server" Width="100%" Text="region-a.geo-1" 
                                meta:resourcekey="TxtRegionResource1"></asp:TextBox>
                        </td>
                    </tr>
                    <tr>
                        <td style="padding-top: 5px">
                            <asp:Label ID="LabelAccessKey" runat="server" Text="Tenant ID" 
                                Style="font-weight: 700" meta:resourcekey="LabelAccessKeyResource1"></asp:Label>
                        </td>
                        <td style="padding-top: 5px">
                            <asp:TextBox ID="TxtAccessKey" runat="server" Width="100%" 
                                meta:resourcekey="TxtAccessKeyResource1"></asp:TextBox>
                        </td>
                    </tr>
                    <tr>
                        <td style="padding-top: 5px">
                            <asp:Label ID="Label1" runat="server" Text="Tenant Name" 
                                Style="font-weight: 700" meta:resourcekey="Label1Resource1"></asp:Label>
                        </td>
                        <td style="padding-top: 5px">
                            <asp:TextBox ID="TxtUsername" runat="server" Width="100%" 
                                meta:resourcekey="TxtUsernameResource1"></asp:TextBox>
                        </td>
                    </tr>
                    <tr>
                        <td style="padding-top: 5px">
                            <asp:Label ID="LabelSecret" runat="server" Text="Password" 
                                Style="font-weight: 700" meta:resourcekey="LabelSecretResource1"></asp:Label>
                        </td>
                        <td style="padding-top: 5px">
                            <asp:TextBox ID="TxtSecretKey" runat="server" Width="100%" TextMode="Password" 
                                ViewStateMode="Enabled" meta:resourcekey="TxtSecretKeyResource1"></asp:TextBox>
                        </td>
                    </tr>
                    <%}
                      else
                      { %>
                    <tr>
                        <td colspan="2">
                            <asp:Panel ID="PanelPickBucket" runat="server" 
                                meta:resourcekey="PanelPickBucketResource1">
                                <table width="100%" border="0">
                                    <tr>
                                        <td>
                                            <asp:Localize meta:resourcekey="asp_string3" runat="server">Select a Container</asp:Localize>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td height="32">
                                            <asp:DropDownList ID="DropDownListBuckets" runat="server" AutoPostBack="True" cssclass="browser-default custom-select secsubbordercolor"
                                                OnSelectedIndexChanged="DropDownListBuckets_SelectedIndexChanged" 
                                                meta:resourcekey="DropDownListBucketsResource1">
                                                <asp:ListItem meta:resourcekey="ListItemResource1">{Test Connection First}</asp:ListItem>
                                            </asp:DropDownList>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <asp:Panel ID="PanelCreateBucket" runat="server" 
                                                meta:resourcekey="PanelCreateBucketResource1">
                                                <asp:Localize meta:resourcekey="asp_string4" runat="server">New Container Name</asp:Localize> :<br />
                                                <asp:TextBox ID="TxtNewBucket" runat="server" Width="100%" 
                                                    meta:resourcekey="TxtNewBucketResource1"></asp:TextBox>
                                            </asp:Panel>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <asp:Panel ID="PanelPickFolder" runat="server" 
                                                meta:resourcekey="PanelPickFolderResource1">
                                                <asp:Panel ID="PanelFolderDropDown" runat="server" Visible="False" 
                                                    meta:resourcekey="PanelFolderDropDownResource1">
                                                    <table width="100%" border="0">
                                                        <tr>
                                                            <td height="32">
                                                                <asp:Localize meta:resourcekey="asp_string5" runat="server">Select a Folder (Leave it blank for the root folder in the bucket)</asp:Localize>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td>
                                                                <asp:DropDownList ID="DropDownListFolder" runat="server" Width="100%"  CssClass="browser-default custom-select secsubbordercolor"
                                                                    meta:resourcekey="DropDownListFolderResource1">
                                                                </asp:DropDownList>
                                                            </td>
                                                        </tr>
                                                    </table>
                                                </asp:Panel>
                                            </asp:Panel>
                                        </td>
                                    </tr>
                                </table>
                            </asp:Panel>
                        </td>
                    </tr>
                    <%} %>
                    <tr>
                        <td colspan="2" align="center">
                            <table>
                                <tr>
                                    <td colspan="3" height="20px">
                                        &nbsp;
                                    </td>
                                </tr>
                                <tr>
                                    <td >
                                        <asp:Localize runat="server" ID="LocPlsWat" meta:resourcekey="str_plsWat" Visible="False">Please Wait</asp:Localize> 
                                        <asp:Localize runat="server" ID="LocApyChg" meta:resourcekey="str_apyChg" Visible="False">Applying Changes</asp:Localize> 
                                        <%if (!string.IsNullOrEmpty(StorageConfigBackPage))
                                          { %>
                                        <div class="linkbutton">
                                            <asp:LinkButton ID="Back" runat="server" Font-Bold="True" Font-Size="16px" CssClass="linkbuttona" CausesValidation="False" OnClick="Back_Click" meta:resourcekey="BackResource1">Back</asp:LinkButton>
                                        </div>
                                        <%} %>
                                    </td>
                                    <td>
                                        <div class="linkbutton">
                                            <asp:LinkButton ID="LinkButtonNext" runat="server" Font-Bold="True" Font-Size="16px" OnClick="ButtonFinish_Click" CssClass="linkbuttona" meta:resourcekey="LinkButtonNextResource1">Finish</asp:LinkButton>
                                        </div>
                                    </td>
                                    <td>
                                        <%if (!string.IsNullOrEmpty(StorageConfigCancelPage))
                                          { %>
                                        <div class="linkbutton">
                                            <asp:LinkButton ID="CancelBtn" runat="server" Font-Bold="True" Font-Size="16px" CssClass="linkbuttona" OnClick="CancelBtn_Click" CausesValidation="False" meta:resourcekey="CancelBtnResource1">Cancel</asp:LinkButton>
                                        </div>
                                        <%}
                                          Back.OnClientClick = String.Format("Wait('{0}')", LocApyChg.Text);
                                          LinkButtonNext.OnClientClick = String.Format("Wait('{0}')", LocApyChg.Text);
                                          CancelBtn.OnClientClick = String.Format("Wait('{0}')", LocPlsWat.Text);
                                        %>
                                    </td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                </table>
            </td>
    </table>
</asp:Content>
