﻿<%@ Page Title="Gladinet Cloud - Setup Azure Blob Account" Language="C#" MasterPageFile="StorageConfig.master"
    AutoEventWireup="true" CodeBehind="Azure.aspx.cs" Inherits="GladinetPayFlow.StorageConfig.AzureBlob"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
        .titlecol
        {
            background-color: #f0f0f0;
            font-size: 14px;
        }
        
        *
        {
            margin: 0;
        }
        
        .wrapper
        {
            padding: 0px;
            background-color: white;
            margin: 0 auto -69px; /* the bottom margin is the negative value of the footer's height */
            overflow: auto;
        }
        .footer, .push
        {
            height: 68px; /* .push must be the same height as .footer */
        }
    </style>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
    <div class="wrapper">
        <table width="100%">
            <tr> <td align="center" style="padding-top:30px;">
        <table align="center" style="background: WHITE; padding: 15px;width:100%; max-width:800px;" cellspacing="0"
            id="input_panel">
            <tr>
                <td>
                    <table width="100%">
                        <tr>
                            <td width="80px">
                                <img src="../images/azure.png" width="80px" />
                            </td>
                            <td>
                                <h2>
                                    <asp:Localize meta:resourcekey="asp_string1" runat="server">Azure Blob Account Information</asp:Localize></h2>
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
            <tr>
                <td style="padding: 10px; vertical-align: top;">
                    <% if (!string.IsNullOrEmpty(ErrorMsg.Text))
                       { %>
                    <asp:Label ID="ErrorMsg" runat="server" Style="" CssClass="errmsg" meta:resourcekey="ErrorMsgResource1"></asp:Label>
                    <%} %>
                    <table width="100%" align="center">
                        <%if (FirstStage)
                          { %>
                        <tr>
                            <td height="15px" style="font-size:14px; font-weight:100; color:#565656;">
                                
                                <asp:Localize meta:resourcekey="asp_string2" runat="server">Storage Account Name</asp:Localize>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <asp:TextBox ID="TxtAccessKey" runat="server" Width="100%" meta:resourcekey="TxtAccessKeyResource1" CssClass="form-control"></asp:TextBox><br />
                                <asp:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server" ErrorMessage="Access Key Required"
                                    ControlToValidate="TxtAccessKey" ForeColor="#CC0000" CssClass="errmsg" meta:resourcekey="RequiredFieldValidator1Resource1"></asp:RequiredFieldValidator>
                            </td>
                        </tr>
                        <tr>
                            <td style="font-size:14px; font-weight:100; color:#565656;">
                                <asp:Localize meta:resourcekey="asp_string3" runat="server">Primary Access Key</asp:Localize>
                            </td>
                        </tr>
                        <tr>
                            <td height="15px">
                                <asp:TextBox ID="TxtSecretKey" runat="server" Width="100%" TextMode="Password" meta:resourcekey="TxtSecretKeyResource1" CssClass="form-control"></asp:TextBox>
                                <br />
                                <asp:RequiredFieldValidator ID="RequiredFieldValidator2" runat="server" ControlToValidate="TxtSecretKey"
                                    ErrorMessage="Secret Key Required" ForeColor="#CC0000" CssClass="errmsg" meta:resourcekey="RequiredFieldValidator2Resource1"></asp:RequiredFieldValidator>
                            </td>
                        </tr>
                         <tr>
                            <td>
                                <asp:CheckBox ID="EnableInplaceVersion" runat="server" Checked="True"
                                                        Text="Enable Inplace Versioning" meta:resourcekey="EnableInplaceVersionResource1" 
                                                        /> 
                            </td>
                        </tr>
                        <%}
                          else
                          { %>
                        <tr>
                            <td>
                                <asp:Panel ID="PanelPickBucket" runat="server" meta:resourcekey="PanelPickBucketResource1">
                                    <table width="100%" border="0">
                                        <tr>
                                            <td>
                                                <asp:Localize meta:resourcekey="asp_string4" runat="server">Select a Container:</asp:Localize>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <asp:DropDownList ID="DropDownListBuckets" runat="server" AutoPostBack="True" OnSelectedIndexChanged="DropDownListBuckets_SelectedIndexChanged"  CssClass="browser-default custom-select secsubbordercolor"
                                                    meta:resourcekey="DropDownListBucketsResource1">
                                                    <asp:ListItem meta:resourcekey="ListItemResource1">{Test Connection First}</asp:ListItem>
                                                </asp:DropDownList>
                                                &nbsp;
                                                <br />
                                                <asp:Panel ID="PanelCreateBucket" runat="server" meta:resourcekey="PanelCreateBucketResource1">
                                                    <div class='idea' style="width: 100%;">
                                                        <asp:Localize meta:resourcekey="asp_string5" runat="server">For SSL, your container name should contain no periods. Also, the container name must be all lower case (not $root either).</asp:Localize>
                                                        <br />
                                                    </div>
                                                    <asp:Panel ID="Panel1" runat="server" GroupingText="Create Container" meta:resourcekey="Panel1Resource1">
                                                        <asp:Localize meta:resourcekey="asp_string6" runat="server">New Container Name (all lower case):</asp:Localize>&nbsp;
                                                        <asp:TextBox ID="TxtNewBucket" runat="server" Width="100%"  CssClass="form-control"
                                                            meta:resourcekey="TxtNewBucketResource1"></asp:TextBox>
                                                        <br />
                                                        <table width='100%'>
                                                            <tr>
                                                                <td width="50%">
                                                                    &nbsp;
                                                                </td>
                                                                <td width="50%">
                                                                    &nbsp;
                                                                </td>
                                                            </tr>
                                                        </table>
                                                    </asp:Panel>
                                                </asp:Panel>
                                                <br />
                                            </td>
                                        </tr>
                                    </table>
                                </asp:Panel>
                            </td>
                        </tr>
                        <%} %>
                    </table>
                </td>
                </tr>
            <tr>
                <td align="right">
                    <asp:Localize runat="server" ID="LocPlsWat" meta:resourcekey="str_plsWat" Visible="False">Please Wait</asp:Localize> 
                    <asp:Localize runat="server" ID="LocApyChg" meta:resourcekey="str_apyChg" Visible="False">Applying Changes</asp:Localize> 
                    <%if (!string.IsNullOrEmpty(StorageConfigBackPage))
                      { %>
                        <asp:Button ID="Back1" runat="server" CssClass="btn" CausesValidation="False" OnClick="Back_Click" meta:resourcekey="BackResource1"></asp:Button>
                    <%} %>
                    &nbsp;&nbsp;
                        <asp:Button ID="LinkButtonNext" runat="server" OnClick="ButtonFinish_Click" CssClass="btn btn-primary gladbtn" meta:resourcekey="LinkButtonNextResource1"></asp:Button>
                    &nbsp;&nbsp;
                    <%if (!string.IsNullOrEmpty(StorageConfigCancelPage))
                      { %>
                        <asp:Button ID="CancelBtn" runat="server" CssClass="btn" OnClick="CancelBtn_Click" CausesValidation="False" meta:resourcekey="CancelBtnResource1"></asp:Button>
                    <%} 
                        Back1.OnClientClick = String.Format("Wait('{0}')", LocApyChg.Text);
                        LinkButtonNext.OnClientClick = String.Format("Wait('{0}')", LocApyChg.Text);
                        CancelBtn.OnClientClick = String.Format("Wait('{0}')", LocPlsWat.Text);
                    %>
                </td>
            </tr>
        </table>
                </td></tr>
            </table>
    </div>
    <div class="footer x-panel-header-light" style="border-left: 0; border-right: 0;display:none;
        border-bottom: 0; vertical-align: middle;">
        <table width="100%" style="height: 64px; text-align: right; padding-right: 64px;"
            align="right">
            
            
        </table>
    </div>
</asp:Content>
