﻿<%@ Page Title="Gladinet Cloud - Setup OpenStack Storage Account" Language="C#" MasterPageFile="StorageConfig.master"
    AutoEventWireup="true" CodeBehind="Atmos2.aspx.cs" Inherits="GladinetPayFlow.StorageConfig.Atmos2" culture="auto" meta:resourcekey="PageResource1" uiculture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
    <table width="100%" align="center" style="background: WHITE; padding: 15px;" cellspacing="0"
        id="input_panel">
        <tr>
            <td>
                <table width="100%">
                    <tr>
                        <td width="80px">
                            <asp:Image ID="ImageStorage" runat="server" ImageUrl="~/StorageConfig/images/atmos2.png"
                                Width="80px" meta:resourcekey="ImageStorageResource1" />
                        </td>
                        <td>
                            <h2>
                                <asp:Label ID="LabelStorage" runat="server" 
                                    meta:resourcekey="LabelStorageResource1"></asp:Label></h2>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
        <tr>
            <td style="padding: 10px; vertical-align: top;">
                <b>
                    <asp:Label ID="ErrorMsg" runat="server" Style="color: Red;" 
                    meta:resourcekey="ErrorMsgResource1"></asp:Label></b>
                <br />
                <asp:Panel ID="PanelEndPoint" runat="server" 
                    meta:resourcekey="PanelEndPointResource1">
                    <table width="100%" align="center" >
                        <tr>
                            <td>
                                <asp:Localize meta:resourcekey="asp_string1" runat="server">Atmos API End-Point: (Example: https://storage.synaptic.att.com/, http://cloudonestorage.peer1.com)</asp:Localize>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <asp:TextBox ID="TextBoxEndPoint" runat="server" Width="100%" 
                                    meta:resourcekey="TextBoxEndPointResource1"></asp:TextBox>
                            </td>
                        </tr>
                    </table>
                </asp:Panel>
                <table width="100%" align="center" >
                    <tr>
                        <td height="15px">
                            <asp:Label ID="LabelAccessKey" runat="server" Text="Subtenant ID" 
                                meta:resourcekey="LabelAccessKeyResource1"></asp:Label>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <asp:TextBox ID="TxtSubtenant" runat="server" Width="100%" 
                                meta:resourcekey="TxtSubtenantResource1"></asp:TextBox><br />
                            <asp:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server" ErrorMessage="Subtenant ID Required"
                                ControlToValidate="TxtSubtenant" ForeColor="#CC0000" CssClass="errmsg" 
                                meta:resourcekey="RequiredFieldValidator1Resource1"></asp:RequiredFieldValidator>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <asp:Label ID="Label1" runat="server" Text="User ID (Application ID) :" 
                                meta:resourcekey="Label1Resource1"></asp:Label>
                        </td>
                    </tr>
                    <tr>
                        <td height="15px">
                            <asp:TextBox ID="TxtUID" runat="server" Width="100%" 
                                meta:resourcekey="TxtUIDResource1"></asp:TextBox>
                            <br />
                            <asp:RequiredFieldValidator ID="RequiredFieldValidator3" runat="server" ControlToValidate="TxtUID"
                                ErrorMessage="UID Required" ForeColor="#CC0000" CssClass="errmsg" 
                                meta:resourcekey="RequiredFieldValidator3Resource1"></asp:RequiredFieldValidator>
                        </td>
                    </tr>
                    <tr>
                        <td>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <asp:Label ID="LabelSecret" runat="server" Text="Secret Access Key" 
                                meta:resourcekey="LabelSecretResource1"></asp:Label>
                        </td>
                    </tr>
                    <tr>
                        <td height="15px">
                            <asp:TextBox ID="TxtSecretKey" runat="server" Width="100%" TextMode="Password" 
                                meta:resourcekey="TxtSecretKeyResource1"></asp:TextBox>
                            <br />
                            <asp:RequiredFieldValidator ID="RequiredFieldValidator2" runat="server" ControlToValidate="TxtSecretKey"
                                ErrorMessage="Secret Key Required" ForeColor="#CC0000" CssClass="errmsg" 
                                meta:resourcekey="RequiredFieldValidator2Resource1"></asp:RequiredFieldValidator>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <asp:Label ID="Label2" runat="server" 
                                Text="Root Folder (Create if it doesn't exist)" meta:resourcekey="Label2Resource1"></asp:Label>
                        </td>
                    </tr>
                    <tr>
                        <td height="15px">
                            <asp:TextBox ID="RootFolder" runat="server" Width="100%" Text="GladinetFolder" ></asp:TextBox>
                            <br />
                            <asp:RequiredFieldValidator ID="RequiredFieldValidator4" runat="server" ControlToValidate="RootFolder"
                                ErrorMessage="Secret Key Required" ForeColor="#CC0000" CssClass="errmsg" 
                                meta:resourcekey="RequiredFieldValidator4Resource1"></asp:RequiredFieldValidator>
                        </td>
                    </tr>
                    <tr>
                        <td align="center" nowrap="nowrap">
                            <table>
                                <tr>
                                    <td>
                                        <asp:Localize runat="server" ID="LocPlsWat" meta:resourcekey="str_plsWat" Visible="False">Please Wait</asp:Localize> 
                                        <asp:Localize runat="server" ID="LocApyChg" meta:resourcekey="str_apyChg" Visible="False">Applying Changes</asp:Localize> 
                                        <%if (!string.IsNullOrEmpty(StorageConfigBackPage))
                                          { %>
                                        <div class="linkbutton">
                                            <asp:LinkButton ID="Back" runat="server" Font-Bold="True" Font-Size="16px" CssClass="linkbuttona" CausesValidation="False" OnClick="Back_Click" meta:resourcekey="BackResource1">Back</asp:LinkButton>
                                        </div>
                                        <%} %>
                                    </td>
                                    <td>
                                        <div class="linkbutton">
                                            <asp:LinkButton ID="LinkButtonNext" runat="server" Font-Bold="True" Font-Size="16px" OnClick="ButtonFinish_Click" CssClass="linkbuttona"  meta:resourcekey="LinkButtonNextResource1">Finish</asp:LinkButton>
                                        </div>
                                    </td>
                                    <td>
                                        <%if (!string.IsNullOrEmpty(StorageConfigCancelPage))
                                          { %>
                                        <div class="linkbutton">
                                            <asp:LinkButton ID="CancelBtn" runat="server" Font-Bold="True" Font-Size="16px" CssClass="linkbuttona" OnClick="CancelBtn_Click" CausesValidation="False" meta:resourcekey="CancelBtnResource1">Cancel</asp:LinkButton>
                                        </div>
                                        <%}
                                          Back.OnClientClick = String.Format("Wait('{0}')", LocApyChg.Text);
                                          LinkButtonNext.OnClientClick = String.Format("Wait('{0}')", LocApyChg.Text);
                                          CancelBtn.OnClientClick = String.Format("Wait('{0}')", LocPlsWat.Text);
                                        %>
                                    </td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            &nbsp;
                        </td>
                    </tr>
                </table>
            </td>
    </table>
</asp:Content>
