﻿<%@ Page Title="Gladinet Cloud - Setup Amazon S3 Account" Language="C#" MasterPageFile="StorageConfig.master"
    AutoEventWireup="true" CodeBehind="AmazonS3.aspx.cs" Inherits="GladinetPayFlow.StorageConfig.AmazonS3"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">

    <style type="text/css">
        .titlecol
        {
            background-color: #f0f0f0;
            font-size: 14px;
        }
        
        *
        {
            margin: 0;
        }
      
        .wrapper
        {
            min-height: 100%;
            height: auto !important;
            height: 100%;
            padding: 0px;
            background-color: white;
            margin: 0 auto -69px; /* the bottom margin is the negative value of the footer's height */
            overflow: auto;
        }
        .footer, .push
        {
            height: 68px; /* .push must be the same height as .footer */
        }
        .btndlg
        {
            min-width:128px;
        }
        
        .rclass {
            font-weight: 100!important;
            color: #565656!important;
        }
        label {
            padding-left: 5px;
            font-size: 14px;
            font-weight: 100!important;
            color: #565656!important;
        }
        #<%=TxtSubFolder.ClientID %>::placeholder{color:lightgray;opacity:1;}
        #<%=TxtSubFolder.ClientID %>:-ms-input-placeholder{color:lightgray;}
        #<%=TxtSubFolder.ClientID %>::-ms-input-placeholder{color:lightgray;}

        
        .editModeLabel{color: #565656; font-weight: 100;font-size:16px;height: 50px; padding-left: 20px;}

        <% if ("summary".Equals(EditMode)) { %>
            .fields1{display:none !important;}
            .fields2{display:none !important;}
        <% } %>

       .gladinet-icons.gladbtn{font-size:24px!important;line-height:32px;}

    </style>
    <script type="text/javascript">
        document.onkeydown = function (evt) {
            var keyCode = evt ? (evt.which ? evt.which : evt.keyCode) : event.keyCode;
            if(keyCode == 13)
            {             
                //enter key
                evt.preventDefault();   
	            evt.stopPropagation(); 
            }
        }
        function editPage1()
        {
            location.href = "AmazonS3.aspx?edit=1";
        }
        function editPage2()
        {
            location.href = "AmazonS3.aspx?edit=2";
        }
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
    <div class="wrapper">
          <table width="100%">
            <tr> <td align="center" style="padding-top:30px;">
        <table width="100%" align="center" style="background: WHITE; padding: 15px; width:100%; max-width:800px;" cellspacing="0"
            id="input_panel">
            <tr>
                <td>
                    <table width="100%">
                        <tr>
                            <td width="80px">
                                <img src="../images/aws.png" width="80px" />
                            </td>
                            <td style="color: #565656; font-weight: 100;font-size:18px;">
                                
                                    <asp:Localize meta:resourcekey="asp_string1" runat="server">Amazon S3 Account Configuration</asp:Localize>
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
            <tr>
                <td width="100%" style="padding: 10px; vertical-align: top;">
                    <% if (!string.IsNullOrEmpty(ErrorMsg.Text))
                       { %>
                    <asp:Label ID="ErrorMsg" runat="server" Style="" CssClass="errmsg" meta:resourcekey="ErrorMsgResource1"></asp:Label>
                    <%} %>
                    <table width="100%" align="center">
                        <%if ("summary".Equals(EditMode)) { %>
                        <tr>
                            <td>
                                <table style="margin-top:20px;">
                                <tr>
                                    <td class="editModeLabel"><asp:Localize meta:resourcekey="str_athTpe" runat="server">Authentication Type</asp:Localize></td>
                                    <td class="editModeLabel hand" onclick="editPage1()" title="<%=LocClkToEdt.Text %>">
                                        <asp:Localize ID="LocBscAth" meta:resourcekey="str_bscAth" runat="server" Visible="false">Basic Authentication</asp:Localize> 
                                        <asp:Localize ID="LocIstIAMRle" meta:resourcekey="str_istIAMRle" runat="server" Visible="false">Instance IAM Role</asp:Localize>
                                        <asp:Localize ID="LocClkToEdt" meta:resourcekey="str_clkToEdt" runat="server" Visible="false">Click to Edit</asp:Localize>
                                        <asp:Literal ID="LtlAuthType" runat="server" />
                                    </td>
                                    <td class="editModeLabel" onclick="editPage1()" title="<%=LocClkToEdt.Text %>"><span class="gladinet-icons gladbtn hand">/</span></td>
                                </tr>
                                <% if (!LtlAuthType.Text.Equals(LocIstIAMRle.Text)) { %>
                                <tr>
                                    <td class="editModeLabel"><asp:Localize meta:resourcekey="asp_string2" runat="server">Access Key ID</asp:Localize></td>
                                    <td class="editModeLabel" onclick="editPage1()" title="<%=LocClkToEdt.Text %>"><asp:Literal ID="LtlAcsKey" runat="server" /></td>
                                    <td class="editModeLabel" onclick="editPage1()" title="<%=LocClkToEdt.Text %>"><span class="gladinet-icons gladbtn hand">/</span></td>
                                </tr>
                                <tr>
                                    <td class="editModeLabel"><asp:Localize meta:resourcekey="asp_string3" runat="server">Secret Access Key</asp:Localize></td>
                                    <td class="editModeLabel" onclick="editPage1()" style="user-select:none;" title="<%=LocClkToEdt.Text %>"><asp:Literal ID="LtlScrKey" runat="server" /></td>
                                    <td class="editModeLabel" onclick="editPage1()" title="<%=LocClkToEdt.Text %>"><span class="gladinet-icons gladbtn hand">/</span></td>
                                </tr>
                                <% } else { %>
                                <tr>
                                    <td class="editModeLabel"><asp:Localize meta:resourcekey="str_rleNme" runat="server">Role Name</asp:Localize></td>
                                    <td class="editModeLabel" onclick="editPage1()" title="<%=LocClkToEdt.Text %>"><asp:Literal ID="LtlRoleName" runat="server" /></td>
                                    <td class="editModeLabel" onclick="editPage1()" title="<%=LocClkToEdt.Text %>"><span class="gladinet-icons gladbtn hand">/</span></td>
                                </tr>
                                <% } %>
                                <tr>
                                    <td class="editModeLabel"><asp:Localize meta:resourcekey="str_bktNme" runat="server">Bucket Name</asp:Localize></td>
                                    <td class="editModeLabel" onclick="editPage2()" title="<%=LocClkToEdt.Text %>"><asp:Literal ID="LtlBktNme" runat="server" /></td>
                                    <td class="editModeLabel" onclick="editPage2()" title="<%=LocClkToEdt.Text %>"><span class="gladinet-icons gladbtn hand">/</span></td>
                                </tr>
                                <tr>
                                    <td class="editModeLabel"><asp:Localize meta:resourcekey="str_selSubFol2" runat="server">Sub-Folder</asp:Localize></td>
                                    <td class="editModeLabel" onclick="editPage2()" title="<%=LocClkToEdt.Text %>"><asp:Literal ID="LtlSubFld" runat="server" /></td>
                                    <td class="editModeLabel" onclick="editPage2()" title="<%=LocClkToEdt.Text %>"><span class="gladinet-icons gladbtn hand">/</span></td>
                                </tr>
                                <tr>
                                    <td class="editModeLabel"><asp:Localize meta:resourcekey="str_amzS3TfrAcnEbd" runat="server">Amazon S3 Transfer Acceleration</asp:Localize></td>
                                    <td class="editModeLabel hand" title="<%=LocClkToEdt.Text %>" colspan="2">
                                        <% if ("1".Equals(LtlS3Acceleration.Text)) { %>
                                        <a href="javascript:;" style="font-size:64px;" onclick="editPage2()"><span class="gladinet-icons gladrootbtn" style="font-size:48px!important">Ś</span></a>
                                        <% } else { %>
                                        <a href="javascript:;" style="font-size:64px;" onclick="editPage2()"><span class="gladinet-icons gladrootbtn" style="font-size:48px!important">ś</span></a>
                                        <% } %>
                                        <asp:Literal ID="LtlS3Acceleration" runat="server" Visible="false" /></td>
                                </tr>
                                <tr>
                                    <td class="editModeLabel"><asp:Localize meta:resourcekey="str_useSvrSdeEnc" runat="server">Server-side encryption (SSE-S3)</asp:Localize></td>
                                    <td class="editModeLabel hand" title="<%=LocClkToEdt.Text %>" colspan="2">
                                        <% if ("1".Equals(LtlSrvSdeEnc.Text)) { %>
                                        <span class="gladinet-icons" style="font-size:48px !important;color:lightgray !important;">Ś</span>
                                        <% } else { %>
                                        <span class="gladinet-icons" style="font-size:48px !important;color:lightgray !important;">ś</span>
                                        <% } %>
                                        <asp:Literal ID="LtlSrvSdeEnc" runat="server" Visible="false" /></td>
                                </tr>
                                </table> 
                            </td>
                        </tr>

                        <% } %>
                        <%if (FirstStage)
                          { %>
                        <tr class="fields1">
                            <td style="padding-top:50px;padding-bottom:30px;">
                                 <asp:DropDownList ID="AuthType" runat="server" CssClass="browser-default custom-select secsubbordercolor h6" AutoPostBack="true"  ></asp:DropDownList>  
                            </td>
                        </tr>
                        <%if (AuthType.SelectedIndex == 1){ %>
                         <tr class="fields1">
                            <td height="15px">
                                &nbsp;
                               <h3 style="color: #565656; font-weight: 100;font-size:16px;"><asp:Localize meta:resourcekey="str_rleNme" runat="server">Role Name</asp:Localize></h3>
                            </td>
                        </tr>
                        <tr class="fields1">
                            <td>
                                <asp:TextBox ID="TxtRoleName" runat="server" Width="100%"  CssClass="form-control" TabIndex="1"></asp:TextBox><br />                               
                            </td>
                        </tr>
                        <%}else { %>
                        <tr class="fields1">
                            <td height="15px">
                                &nbsp;
                               <h3 style="color: #565656; font-weight: 100;font-size:16px;"> <asp:Localize meta:resourcekey="asp_string2" runat="server">Access Key ID</asp:Localize></h3>
                            </td>
                        </tr>
                        <tr class="fields1">
                            <td>
                                <asp:TextBox ID="TxtAccessKey" runat="server" Width="100%" meta:resourcekey="TxtAccessKeyResource1" CssClass="form-control" TabIndex="1"></asp:TextBox><br />
                                <asp:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server" ErrorMessage="Access Key Required"
                                    ControlToValidate="TxtAccessKey" ForeColor="#CC0000" CssClass="errmsg" meta:resourcekey="RequiredFieldValidator1Resource1"></asp:RequiredFieldValidator>
                            </td>
                        </tr>
                        <tr class="fields1">
                            <td>
                                <h3 style="color: #565656; font-weight: 100;font-size:16px;">
                                <asp:Localize meta:resourcekey="asp_string3" runat="server">Secret Access Key</asp:Localize></h3>
                            </td>
                        </tr>
                        <tr class="fields1">
                            <td height="15px">
                                <asp:TextBox ID="TxtSecretKey" runat="server" Width="100%" TextMode="Password" meta:resourcekey="TxtSecretKeyResource1" CssClass="form-control" TabIndex="2"></asp:TextBox>
                                <br />
                                <asp:RequiredFieldValidator ID="RequiredFieldValidator2" runat="server" ControlToValidate="TxtSecretKey"
                                    ErrorMessage="Secret Key Required" ForeColor="#CC0000" CssClass="errmsg" meta:resourcekey="RequiredFieldValidator2Resource1"></asp:RequiredFieldValidator>
                            </td>
                        </tr>
                         <%} %>
                        <tr class="fields1">
                            <td>
                                <asp:CheckBox ID="EnableInplaceVersion" runat="server" Checked="True"
                                                        Text="Enable Inplace Versioning" meta:resourcekey="EnableInplaceVersionResource1" 
                                                        TabIndex="3" /> 
                            </td>
                        </tr>
                        <%}
                          else
                          {%>
                        <tr class="fields2">
                            <td>
                                <asp:Panel ID="PanelPickBucket" runat="server" meta:resourcekey="PanelPickBucketResource1">
                                    <table width="100%" border="0">
                                        <tr>
                                            <td>
                                                <h3 style="color: #565656; font-weight: 100;font-size:14px;"><asp:Localize meta:resourcekey="asp_string4" runat="server">Select a Bucket:</asp:Localize></h3>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                               <asp:Localize id="LocCrtNewBkt" meta:resourcekey="str_crtNewBkt" runat="server" Visible="false">Create New Bucket</asp:Localize>   
                                               <asp:Localize id="LocNotLstEtrMnl" meta:resourcekey="str_notLstEtrMnl" runat="server" Visible="false">Not Listed / Enter Name Manually</asp:Localize> 
                                                <asp:DropDownList ID="DropDownListBuckets" runat="server" AutoPostBack="True" Width="100%" CssClass="browser-default custom-select secsubbordercolor"
                                                    OnSelectedIndexChanged="DropDownListBuckets_SelectedIndexChanged" meta:resourcekey="DropDownListBucketsResource1">
                                                    <asp:ListItem meta:resourcekey="ListItemResource1">{Test Connection First}</asp:ListItem>
                                                </asp:DropDownList>
                                            </td>
                                        </tr>
                                        <%if (!PanelCreateBucket.Visible){ %>
                                        <tr>
                                            <td style="padding-left:30px;padding-top:20px;padding-bottom:20px;">
                                                <h3 style="color: #565656; font-weight: 100;font-size:14px;line-height: 28px;">
                                                    <asp:Localize meta:resourcekey="str_selSubFol" runat="server">Sub-Folder:</asp:Localize>
                                                </h3>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="padding-left:30px;">
                                                <asp:TextBox ID="TxtSubFolder" runat="server" style="margin-top:-20px;" Width="100%" CssClass="form-control InputText secsubbordercolor" placeholder="folder1/folder2/" /><br />
                                                <p><label style="font-style:italic;line-height:18px;margin-top:-10px;">
                                                    (<asp:Localize meta:resourcekey="str_subFolHlp1" runat="server">Enter a case-sensitive virtual path of an existing folder inside the selected bucket.</asp:Localize><br />
                                                    <asp:Localize meta:resourcekey="str_subFolHlp2" runat="server">Leave it blank if you want to mount the whole bucket.</asp:Localize>)
                                                    </label></p>
                                            </td>
                                        </tr>
                                        <%} %>
                                        <tr>
                                            <td style="padding-left:0%;padding-top:20px;padding-bottom:20px;">
                                                <%if (!PanelCreateBucket.Visible){ %>
                                                <asp:CheckBox ID="AccBucket" runat="server" 
                                                        Text="Amazon S3 Transfer Acceleration Enabled" 
                                                       meta:resourcekey="str_amzS3TfrAcnEbd" /> 
                                                <br />
                                                <asp:CheckBox ID="UseServerSideEncryption" runat="server"
                                                        Text="Use server-side encryption (SSE-S3)"
                                                       meta:resourcekey="str_useSvrSdeEnc" />
                                                <%} %>
                                                <asp:Panel ID="PanelCreateBucket" runat="server" meta:resourcekey="PanelCreateBucketResource1">
                                                    
                                                    <asp:Panel ID="Panel1" runat="server" >
                                                        <span class="rclass" style="font-weight: 100; font-size: 14px;">

                                                        <asp:Localize ID="LocNewBktNme" meta:resourcekey="asp_string7" runat="server" >New Bucket Name:</asp:Localize>
                                                                                                                                                  
                                                        <asp:Localize ID="LocExtBktNme" meta:resourcekey="asp_extBktNme" runat="server" >Existing Bucket Name:</asp:Localize>
                                                            
                                                        &nbsp;(<asp:Localize meta:resourcekey="asp_string5" runat="server">For SSL, your bucket name should contain no periods.</asp:Localize>&nbsp;<asp:Localize meta:resourcekey="asp_string6" runat="server">For example:</asp:Localize>
                                                        <span class="style3"><asp:Localize runat="server" meta:resourcekey="str_Htt">https://</asp:Localize></span>bucketname.<span class="style2"><asp:Localize runat="server" meta:resourcekey="str_S3a">s3.amazon.com</asp:Localize></span>)
                                                            </span>
                                                        <br />
                                                        <asp:TextBox ID="TxtNewBucket" runat="server" Width="100%" CssClass="form-control"
                                                            meta:resourcekey="TxtNewBucketResource1"></asp:TextBox>
                                                       <br />
                                                       <span class="rclass" style="font-weight: 100; font-size: 14px;"><asp:Localize runat="server" meta:resourcekey="str_Reg">Region</asp:Localize></span>
                                                        <br />        
                                                       <asp:DropDownList ID="RegionList" runat="server" cssclass="browser-default custom-select secsubbordercolor"></asp:DropDownList>
                                                    </asp:Panel>
                                                </asp:Panel>
                                                <br />
                                            </td>
                                        </tr>

                                    </table>
                                </asp:Panel>
                            </td>
                        </tr>
                        <%} %>

                        </table>
                </td>
            </tr>
            <tr>
                <td align="right" style="padding-top:30px;">
                    <asp:Localize runat="server" ID="LocPlsWat" meta:resourcekey="str_plsWat" Visible="False">Please Wait</asp:Localize> 
                    <asp:Localize runat="server" ID="LocApyChg" meta:resourcekey="str_apyChg" Visible="False">Applying Changes</asp:Localize> 
                    <%if (!string.IsNullOrEmpty(StorageConfigBackPage))
                      { %> 
                        <asp:Button ID="Back1" runat="server" 
                            CssClass="btn btndlg btn-default" CausesValidation="False" OnClick="Back_Click" meta:resourcekey="BackResource1"></asp:Button> 
                    <%} %>
                <%if (!"summary".Equals(EditMode)) { %>
                &nbsp;&nbsp;
                        <asp:Button ID="LinkButtonNext1" runat="server" 
                            OnClick="ButtonFinish_Click" CssClass="btn btn-primary gladbtn btndlg" meta:resourcekey="LinkButtonNextResource1" TabIndex="4"></asp:Button>
                &nbsp;&nbsp;
                    <%if (!string.IsNullOrEmpty(StorageConfigCancelPage))
                      { %>
                        <asp:Button ID="CancelBtn1" runat="server" 
                            CssClass="btn btndlg btn-default" OnClick="CancelBtn_Click" CausesValidation="False" meta:resourcekey="CancelBtnResource1"></asp:Button>
                <%} %>
                    <%}
                      Back1.OnClientClick = String.Format("Wait('{0}')", LocApyChg.Text);
                      LinkButtonNext1.OnClientClick = String.Format("Wait('{0}')", LocApyChg.Text);
                      CancelBtn1.OnClientClick = String.Format("Wait('{0}')", LocPlsWat.Text);
                    %>
                    &nbsp;&nbsp;
                </td>
            </tr>
        </table>
                </td></tr></table>
    </div>
    <div class="footer x-panel-header-light" style="border-left: 0; border-right: 0;display:none;
        border-bottom: 0; vertical-align: middle;">
        <table width="100%" style="height: 64px; text-align: right; padding-right: 64px;"
            align="right">
            
        </table>
    </div>
</asp:Content>
