﻿<%@ Page Title="Gladinet Cloud - Published Folders" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="ShareNotificationMgrPage.aspx.cs" Inherits="GladinetPayFlow.ShareNotificationMgrPage"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
        .titlecol
        {
            background-color: #f0f0f0;
            font-size: 14px;
        }
        
        
        .securityicon
        {
            background-image: url(images/security2.png);
        }
        .groupicon
        {
            background-image: url(images/group.png);
        }
        

    </style>
    <script type="text/javascript">




        function ClearErrorMsg() {

            var d = document.getElementById("errmsgdiv");
            if (d) {
                d.style.display = 'none';
            }
        }
        setTimeout("ClearErrorMsg()", 30000);
        //parent.setActivePanel("PubMgr");




        function gEncodeUri(str) {
            var s = encodeURI(str).replace(/&/g, '%26').replace(/#/g, '|').replace('+', ':');
            while (true) {
                var i = s.indexOf('+');
                if (i == -1)
                    break;
                s = s.replace('+', ':');
            }

            return s;

        }



        var ActiveWin;
        function OnEdit(ShareId, isDir) {

            var uri = "<iframe id='openwin' src=\"/portal/AddSharePage.aspx?src=filebrowser&folder=";
            uri += isDir;
            uri += "&location=/";


            uri += encodeURIComponent(ShareId.replace("%27", "'"));
            uri += "&vdid=<%=SessionDomainId %>";
            uri += "\" scrolling='auto' style='width:100%;height:100%;margin:0;padding:0'></iframe>";

            ActiveWin = new Ext.Window({
                id: 'pubs_win',
                title: "<asp:Localize meta:resourcekey="str_sendshare" runat="server">Create link and send</asp:Localize>",
                width: 820,
                height: 640,
                plain: true,
                modal: true,
                maximizable: true,
                maximized: false,
                constrainHeader: true,
                bodyPadding: 5,
                resizable: false,
                html: uri,
                defaults: {
                    border: false
                }
            });
            ActiveWin.show();

        }



        function ViewShare(oid, id) {
            id = gEncodeUri(unescape(id));
            var uri = "<iframe id='openwin' src=\"/management/ViewSharePage.aspx?u=";
            uri += oid;
            uri += "&location=" + id;
            uri += "&vdid=<%=SessionDomainId %>";

            uri += "\" scrolling='auto' style='width:100%;height:100%;margin:0;padding:0'></iframe>";

            ActiveWin = new Ext.Window({
                id: 'pubs_win',
                title: "<asp:Localize meta:resourcekey="js_viwShr" runat="server">View Share</asp:Localize>",
                width: 720,
                height: maxh(540),
                plain: true,
                modal: true,
                maximizable: true,
                maximized: false,
                constrainHeader: true,
                bodyPadding: 5,
                resizable: false,
                html: uri,
                defaults: {
                    border: false
                }
            });
            ActiveWin.show();
        }

        function UnpublishUrl(id) {
            id = gEncodeUri(unescape(id));
            var h = "TenantShareMgrPage.aspx?op=delpub&id=" + id+"&oid=1&vdid=<%=SessionDomainId %>";

            if (confirm("<asp:Localize meta:resourcekey="js_string7" runat="server">Are you sure you want to delete?</asp:Localize>"))
                window.location = h;
        }

        function Unpublish(oid, id) {
            id = gEncodeUri(unescape(id));
            var h = "TenantShareMgrPage.aspx?op=delete&id=" + id + "&oid=" + oid+"&vdid=<%=SessionDomainId %>";

            if (confirm("<asp:Localize meta:resourcekey="js_string7" runat="server">Are you sure you want to delete?</asp:Localize>"))
                window.location = h;
        }

        //parent.HelpSrc = "PubMgrHelp.htm";


        function closeActiveWin() {


            window.location = window.location;

        }

        function closeCancelActiveWin() {
            ActiveWin.close();
        }

        function OnClickTeam() {
            window.location = "/portal/PubMgrPage.aspx";
        }

        function OnClickStorage() {
            window.location = "/management/StorageMgr.aspx";
        }

        function SetDownloadNotification(o, sid, email) {
            var e = document.getElementById("ctl00_MainContent_SetDownloadBtn");
            var s = document.getElementById("ctl00_MainContent_ShareId");
            var ae = document.getElementById("ctl00_MainContent_AclEmail");
            var v = document.getElementById("ctl00_MainContent_SValue");

            s.value = sid;
            ae.value = email;
            v.value = "" + o.checked;
            Wait("<asp:Localize runat="server" meta:resourcekey="str_apyStg">Applying setting...</asp:Localize>");
            e.click();

        }

        function SetUploadNotification(o, sid, email) {
            var e = document.getElementById("ctl00_MainContent_SetUploadBtn");
            var s = document.getElementById("ctl00_MainContent_ShareId");
            var ae = document.getElementById("ctl00_MainContent_AclEmail");
            var v = document.getElementById("ctl00_MainContent_SValue");

            s.value = sid;
            ae.value = email;
            v.value = "" + o.checked;
             
            Wait("<asp:Localize runat="server" meta:resourcekey="str_apyStg">Applying setting...</asp:Localize>");
            e.click();

        }
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
<asp:Localize runat="server" ID="LocFaiToGetShaObjLis" meta:resourcekey="str_faiToGetShaObjLis" Visible="false">Failed to get shared object list.</asp:Localize>
    <asp:Localize meta:resourcekey="str_shrObj" ID="LocShrObj" runat="server" Visible="false">Shared Object(s)</asp:Localize>
   <nav class="navbar navbar-default" role="navigation" style="padding:0px!important; box-shadow: 3px 3px 3px white;">
       <div class="container-fluid">
           <p class="navbar-text">
               <asp:Label ID="PubFolderCount" runat="server" meta:resourcekey="PubFolderCountResource1" CssClass="badge"></asp:Label>
           </p>
           <p class="navbar-text">
               <b>
                   <asp:Label ID="ErrorMsg" runat="server" Style="color: Red;" meta:resourcekey="ErrorMsgResource1"></asp:Label></b>
           </p>
           <div class="navbar-form navbar-right" style="width:400px;">
               <table>
                   <tr>
                       <td>
                           <asp:LinkButton ID="AllUsers" runat="server" Font-Size="Larger" ForeColor="Green" OnClick="AllUsers_Click" meta:resourcekey="AllUsersResource1" >All Shares</asp:LinkButton>
                       </td>
                       <td>
                           <asp:TextBox ID="Contains" runat="server" Width="228px" CssClass="form-control dark" meta:resourcekey="ContainsResource1"></asp:TextBox>
                       </td>
                       <td>
                           <asp:Button ID="Serach" runat="server" Text="Search" OnClick="Serach_Click" CssClass="btn btn-default nbtn dark" meta:resourcekey="SerachResource1" />
                       </td>
                   </tr>
               </table>
               
               
               
               
           </div>
       </div>
    </nav>
    <table width="100%" style="padding: 2px; background-color: white; margin-top: -13px; overflow: auto;" cellspacing="0" cellpadding="0" id="grid-table">
        
        <tr>
            <td style="padding:0px;padding-top: 0px; border-bottom: 0px solid #c0c0c0; border-left: 0px solid #c0c0c0; border-right: 0px solid #c0c0c0; background-color: white; padding-top: 20px;" align="center" valign="top"
                id="grid-example">
                
                <div class="row " align="center" style="width: 95%; background-color: white;">
                <asp:Repeater ID="PubsRepeater" runat="server" OnItemDataBound="OnShareItemBound">
        <ItemTemplate>
                <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 text-center topbuffer" style="padding-bottom:10px;">
                                <div class=" panel panel-default viewcard" style=" align-content: center;"
                                    align="center">
                                    <table width="100%">
                                        <tr>
                                            <td width="80px;" valign="middle" align="center" style="border-right: 1px dashed #d0d0d0;background-color: #f8f8f8; ">
                                                 <span class='fa fa fa-share sectextcolor' 
                                                     
                                                     style=' font-size: 24px; cursor: pointer;'></span>
                                            </td>
                                            <td>
                                                <table width="100%">
                                                    <tr>
                                                        <td  style="padding: 5px; padding-left: 10px;  color: black;" width="300px" nowrap="nowrap">
                                                            <table>
                                                                <td>
                                                            <h4 style="font-size:18px;">
                                                                <%#DataBinder.Eval(Container.DataItem, "ShareName")%>
                                                            </h4>
                                                                    
                                                                </td>
                                                                                                                        <td style="padding: 5px; padding-left: 10px;"  class="text-muted">
                                                         
                                                            <%#DataBinder.Eval(Container.DataItem, "PathLocation")%>
                                                        </td>

                                                            </table>
                                                            
                                                        </td>
                                                       
                                                    </tr>
                                                    <tr>
                                                        
                                                        <td style="border-top:1px dashed #d0d0d0; padding: 5px; padding-left: 10px;"  class="text-muted">
                                                         <table width="100%" class="table-striped">
                                                             <tr>
                                                                     <td></td>
                                                                     <td width="150px"><asp:Localize meta:resourcekey="str_dwdNfn" runat="server">Download Notification</asp:Localize></td>
                                                                     <td width="150px"><asp:Localize meta:resourcekey="str_chgNfn" runat="server">Change Notification</asp:Localize></td>
                                                                 </tr>
                                                             <asp:Repeater ID="UserRepeater" runat="server">
                                                                 
                                                            <ItemTemplate>
                                                                <tr>
                                                                    <td>
                                                                         <%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "UserEmail").ToString())%>
                                                                    </td>
                                                                    <td align="center">
                                                                        <input  type="checkbox" <%#DataBinder.Eval(Container.DataItem, "DownloadNotificationCheck")%> onclick='SetDownloadNotification(this,"<%#DataBinder.Eval(Container.DataItem, "ShareUid")%>","<%#DataBinder.Eval(Container.DataItem, "UserEmail")%>");'/>
                                                                    </td>
                                                                    <td align="center">
                                                                        <input  type="checkbox" <%#DataBinder.Eval(Container.DataItem, "UploadNotificationCheck")%> onclick='SetUploadNotification(this,"<%#DataBinder.Eval(Container.DataItem, "ShareUid")%>","<%#DataBinder.Eval(Container.DataItem, "UserEmail")%>");'/>
                                                                    </td>
                                                                </tr>
                                                            </ItemTemplate>
                                                            </asp:Repeater>
                                                         </table>
                                                            
                                                        </td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                            </ItemTemplate>
    </asp:Repeater>      
                </div>
            </td>
        </tr>
        
    </table>
    <div style="display: none;">
        <asp:Button ID="SetDownloadBtn" runat="server" Text="Button" 
                    onclick="SetDownloadBtn_Click" />
        <asp:Button ID="SetUploadBtn" runat="server" Text="Button" 
                    onclick="SetUploadBtn_Click" />
        <asp:HiddenField ID="ShareId" runat="server" />
        <asp:HiddenField ID="AclEmail" runat="server" />
        <asp:HiddenField ID="SValue" runat="server" />
    </div>
    <input type="hidden" id="current_share" name="current_share" />
    
    <script type="text/javascript">

        Ext.require([
          'Ext.grid.*',
          'Ext.data.*',
          'Ext.util.*',
          'Ext.state.*'
      ]);
        var grid;
function AdjustGridTable () {
           
        var h = 400;
          
        try {

           
            h = document.body.offsetHeight-103;
           

          } catch (err) {
          }
             

          var e = document.getElementById("grid-table");
          e.style.height = h + "px";

      }

        Ext.onReady(function () {

            Ext.QuickTips.init();


           

            
              AdjustGridTable ();
             
             Ext.EventManager.onWindowResize(AdjustGridTable);

        });
    </script>
</asp:Content>
