﻿<%@ Page Title="Gladinet Cloud - Account Info" Language="C#" MasterPageFile="../WebAppPanel.master" EnableSessionState="false" 
    AutoEventWireup="true" CodeBehind="ShareSecureSettings.aspx.cs" Inherits="GladinetPayFlow.ShareSecureSettings"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
          
       
    </style>
    <script type="text/javascript">
        function gEncodeUri(str) {

            var s = encodeURI(str).replace(/&/g, '%26').replace(/#/g, '|').replace('+', ':').replace(/'/g, '%27');

            while (true) {
                var i = s.indexOf('+');
                if (i == -1)
                    break;
                s = s.replace('+', ':');
            }

            return s;


        }


        function ClearErrorMsg() {

            var d = document.getElementById("errmsgdiv");
            if (d !== null && d !== undefined) {
                d.style.display = 'none';
            }
        }
        setTimeout("ClearErrorMsg()", 30000);




        function closeCancelActiveWin() {
            ActiveWin.close();
        }


        function OnSaveChanges() {
            Wait("Please wait...");
            var btn = document.getElementById('ctl00_MainContent_ApplyBtn');
            btn.click();

        }






       

    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
<asp:Localize runat="server" ID="LocFaiToLoaSet" meta:resourcekey="str_faiToLoaSet" Visible="false">failed to load settings</asp:Localize>
    <div style="  padding-right: 20px;" >
        <table width="100%">
            <tr>
                <td></td>
                <td>
                    <asp:Label ID="ErrorMsg" runat="server" Style="color: Red;"
                        meta:resourcekey="ErrorMsgResource1"></asp:Label>
                </td>
                <td align="right"></td>
            </tr>
        </table>

    </div>
    <table style="width:100%;">
        <tr>
            <td align="center">
                <table style="width:100%; max-width:800px">
                    
                        
                        <tr>
                            <td colspan="2" style="padding: 5px; padding-top:30px; font-weight: 400; color: #202020; font-size: 18px;"><asp:Localize runat="server" meta:resourcekey="str_set">Settings</asp:Localize></td>
                        </tr>
                        <tr>
                            <td colspan="2" style="padding: 10px; font-weight: 100; color: #565656; font-size: 16px;font-style:italic;">
                                <asp:Localize runat="server" meta:resourcekey="str_note">Note: These settings only affect non-administrator users.</asp:Localize>

                            </td>
                        </tr>
                        <tr>
                            <td style="padding: 5px; font-weight: 100; color: #565656; font-size: 16px;" colspan="2">
                                <table>
                                    <tr class="filerow">
                                        <td style="display:none;">
                                            <asp:CheckBox ID="DisableSharing" runat="server" />
                                        </td>
                                        <td style="padding: 5px; font-weight: 100; color: #565656; font-size: 16px;"><asp:Localize runat="server" meta:resourcekey="str_disExtSha">Disable external sharing</asp:Localize></td>
                                        <td>
                                            <%if (DisableSharing.Checked){ %>
                                                    <asp:LinkButton CssClass=" nopadding" ID="LinkButton3" runat="server" OnClick="DisableSharing_Click"><span class="gladinet-icons gladrootbtn" style="font-size:48px!important">&#x15A;</span></asp:LinkButton>
                                                    <%}else{ %>
                                                    <asp:LinkButton CssClass="nopadding" Font-Size="64px" ID="LinkButton4" runat="server" OnClick="EnableSharing_Click"><span class="gladinet-icons gladrootbtn" style="font-size:48px!important">&#x15B;</span></asp:LinkButton>
                                                    <%} %>
                                        </td>
                                    </tr>
                                    <tr><td style="height:10px!important;">&nbsp;</td></tr>
                                    <tr class="filerow">
                                       <td style="display:none;">
                                            <asp:CheckBox ID="DisableCache" runat="server" />
                                        </td>
                                        <td style="padding: 5px; font-weight: 100; color: #565656; font-size: 16px;"><asp:Localize runat="server" meta:resourcekey="str_disOffAcc">Disable Offline Access</asp:Localize></td>
                                        <td>
                                            <%if (DisableCache.Checked){ %>
                                                    <asp:LinkButton CssClass=" nopadding" ID="LinkButton1" runat="server" OnClick="DisableDisableCache_Click"><span class="gladinet-icons gladrootbtn" style="font-size:48px!important">&#x15A;</span></asp:LinkButton>
                                                    <%}else{ %>
                                                    <asp:LinkButton CssClass="nopadding" Font-Size="64px" ID="LinkButton2" runat="server" OnClick="EnableDisableCache_Click"><span class="gladinet-icons gladrootbtn" style="font-size:48px!important">&#x15B;</span></asp:LinkButton>
                                                    <%} %>
                                        </td>
                                    </tr>
                                    <tr><td style="height:10px!important;">&nbsp;</td></tr>
                                    <tr class="filerow">
                                        <td style="display:none;">
                                            <asp:CheckBox ID="HideDeniedFolder" runat="server" />
                                        </td>
                                        <td style="padding: 5px; font-weight: 100; color: #565656; font-size: 16px;"><asp:Localize runat="server" meta:resourcekey="str_hidFolWhiUseDon">Hide folders to which users don't have permissions</asp:Localize></td>
                                        <td>
                                            <%if (HideDeniedFolder.Checked){ %>
                                                    <asp:LinkButton CssClass=" nopadding" ID="LinkButton5" runat="server" OnClick="DisableHideDeniedFolder_Click"><span class="gladinet-icons gladrootbtn" style="font-size:48px!important">&#x15A;</span></asp:LinkButton>
                                                    <%}else{ %>
                                                    <asp:LinkButton CssClass="nopadding" Font-Size="64px" ID="LinkButton6" runat="server" OnClick="EnableHideDeniedFolder_Click"><span class="gladinet-icons gladrootbtn" style="font-size:48px!important">&#x15B;</span></asp:LinkButton>
                                                    <%} %>
                                        </td>
                                    </tr>
                                    <tr><td style="height:10px!important;">&nbsp;</td></tr>
                                    <tr class="filerow" style="display:none;">
                                        <td style="display:none;">
                                            <asp:CheckBox ID="WebOnlyTeamFolder" runat="server" />
                                        </td>
                                        <td style="padding: 5px; font-weight: 100; color: #565656; font-size: 16px;"><asp:Localize runat="server" meta:resourcekey="str_secDatRooCanVie">Secure Data Room (Can be viewed only from the web portal)</asp:Localize></td>
                                        <td>
                                            <%if (WebOnlyTeamFolder.Checked){ %>
                                                    <asp:LinkButton CssClass="nopadding" ID="LinkButton7" runat="server" OnClick="DisableWebOnly_Click"><span class="gladinet-icons gladrootbtn" style="font-size:48px!important">&#x15A;</span></asp:LinkButton>
                                                    <%}else{ %>
                                                    <asp:LinkButton CssClass=" nopadding" Font-Size="64px" ID="LinkButton8" runat="server" OnClick="EnableWebOnly_Click"><span class="gladinet-icons gladrootbtn" style="font-size:48px!important">&#x15B;</span></asp:LinkButton>
                                                    <%} %>
                                        </td>
                                    </tr>
                                   

                                </table>
                            </td>
                        </tr>
                        <tr>
                            <td height="10px" colspan="2">&nbsp;</td>
                        </tr>
                        <tr style="display:none;">
                            <td colspan="2" style="padding: 5px; font-weight: 400; color: #202020; font-size: 18px;"><asp:Localize runat="server" meta:resourcekey="str_whiLis">IP White List</asp:Localize></td>
                        </tr>

                        <tr style="display:none;">
                            <td colspan="2">
                                <table>

                                    <tr>
                                        <td style="border-top: 1px solid #f0f0f0; padding-top: 5px; font-weight: 100; color: #565656; font-size: 16px;">
                                            <asp:Localize meta:resourcekey="str_only" runat="server"
                                                Text="Only allow the access of the share from following IPs"></asp:Localize>

                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="padding: 5px; font-weight: 100; color: #565656; font-size: 16px;">
                                            <asp:TextBox ID="IPWhiteList" runat="server" CssClass="form-control" onchange="ShowSavePanel();" onkeypress="ShowSavePanel();"
                                                Width="100%" meta:resourcekey="IPWhiteListResource1"></asp:TextBox>
                                            <p class="text-muted" style="font-size: smaller;">
                                                <asp:Localize ID="Localize11" meta:resourcekey="str_iphint" runat="server"
                                                    Text="(IP/Mask;IP/Mask, i.e. 254.234.234.128/255.255.255.0; 192.234.234.128/255.255.255.0    empty: no restriction)"></asp:Localize>
                                            </p>
                                        </td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                    </table>
                
            </td>
        </tr>
    </table>
    

    <div style="display: none">
        
        <asp:HiddenField ID="TeamFolderLocation" runat="server" />
        <asp:HiddenField ID="PubFolderId" runat="server" />
        <asp:HiddenField ID="ShareName" runat="server" />
        
        <asp:Button ID="ApplyBtn" runat="server" 
                            CausesValidation="False" OnClick="ApplylNow_Click" 
                            CssClass="btn btn-primary gladbtn navbar-btn navbar-right btndlg" meta:resourcekey="ApplylNowResource1" 
                            Text="Apply" Width="108px"></asp:Button>     
    </div>

    <script type="text/javascript">

        
        function AdjustSize() {


        }


        Ext.onReady(function () {
            AdjustSize();

        });

        Ext.EventManager.onWindowResize(function () {
            AdjustSize();
        });
    </script>
</asp:Content>
