﻿<%@ Page Title="Gladinet Cloud - Role" Language="C#" MasterPageFile="~/WebAppPanel.master" EnableSessionState="false" 
    AutoEventWireup="true" CodeBehind="ShareBackup.aspx.cs" Inherits="GladinetPayFlow.ShareBackup"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
       
           
    </style>
    <script type="text/javascript">
        function SetPage(n) {
            
            var e = document.getElementById("page_1");
            e.className = "nav-link";
            e = document.getElementById("page_1_div");
            e.style.display = "none";

            e = document.getElementById("page_2");
            e.className = "nav-link";
            e = document.getElementById("page_2_div");
            e.style.display = "none";

            e = document.getElementById("page_3");
            e.className = "nav-link";
            e = document.getElementById("page_3_div");
            e.style.display = "none";

            e = document.getElementById("page_4");
            e.className = "nav-link";
            e = document.getElementById("page_4_div");
            e.style.display = "none";

            e = document.getElementById("page_5");
            e.className = "nav-link";
            e = document.getElementById("page_5_div");
            e.style.display = "none";

            e = document.getElementById("page_6");
            e.className = "nav-link";
            e = document.getElementById("page_6_div");
            e.style.display = "none";

            e = document.getElementById("page_"+n);
            e.className = "nav-link active";

            e = document.getElementById("page_"+n+"_div");
            e.style.display = "";
            if (n == 2)
                window.location = window.location;
        }

        function OnSaveChanges() {
            Wait("Please wait...");
            var btn = document.getElementById('ctl00_MainContent_ApplyBtn');
            btn.click();

        }
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
<asp:Localize runat="server" ID="LocFaiToAppSet" meta:resourcekey="str_faiToAppSet" Visible="false">failed to apply settings</asp:Localize>
<asp:Localize runat="server" ID="LocFaiToLoaProLog" meta:resourcekey="str_faiToLoaProLog" Visible="false">failed to load process log.</asp:Localize>
<asp:Localize runat="server" ID="LocMisPar" meta:resourcekey="str_misPar" Visible="false">missing parameter</asp:Localize>
    <div id="defaultcontent">
    <%if (EnableBackup.Checked){ %>
    <div style="width: 100%; padding:5px; <% if (IsChildUi){ %>border-bottom:1px solid #eeeeee;<% } %> " <% if (!IsChildUi){ %>class="meubardrop"<% } %>>
                <table width="100%" >
                    <tr>
                        <td>
                            <nav class="nav">
                                <%if (DeviceView){ %>
                                <a class="nav-link active" href="#" id="page_2" onclick="SetPage(2);return false;" style="display: none;"><asp:Localize runat="server" meta:resourcekey="str_sna">Snapshots</asp:Localize></a>
                                <a class="nav-link active" href="#" id="page_4" onclick="SetPage(4);return false;"><asp:Localize runat="server" meta:resourcekey="str_bacLog">Backup Log</asp:Localize></a>
                                <%}else { %>
                                <a class="nav-link active" href="#" id="page_2" onclick="SetPage(2);return false;"><asp:Localize runat="server" meta:resourcekey="str_sna">Snapshots</asp:Localize></a>
                                <a class="nav-link " href="#" id="page_4" onclick="SetPage(4);return false;"><asp:Localize runat="server" meta:resourcekey="str_bacLog">Backup Log</asp:Localize></a>

                                <%} %>
                                <a class="nav-link " href="#" id="page_1" onclick="SetPage(1);return false;"><asp:Localize runat="server" meta:resourcekey="str_bacTasSta">Backup Task Status</asp:Localize></a>
                                <a class="nav-link " href="#" id="page_5" onclick="SetPage(5);return false;"><asp:Localize runat="server" meta:resourcekey="str_faiTas">Failed Tasks</asp:Localize></a>
                                <a class="nav-link" href="#" id="page_3" onclick="SetPage(3);return false;" style="display: none;"><asp:Localize runat="server" meta:resourcekey="str_tasSta">Task Status</asp:Localize></a>
                                <a class="nav-link " href="#" id="page_6" onclick="SetPage(6);return false;"><asp:Localize runat="server" meta:resourcekey="str_retPol">Retention Policy</asp:Localize></a>

                            </nav>
                        </td>
                        <td>
                            <asp:CheckBox ID="EnableBackup" runat="server" Text="Enable backup" OnCheckedChanged="EnableBackup_CheckedChanged" AutoPostBack="true" Visible="false" />
                        </td>
                        <td></td>
                        <td align="right">
                            <asp:LinkButton CssClass="btn btn-primary gladbtn" ID="LinkButton2" runat="server" OnClick="StartSeeding_Click" meta:resourcekey="str_forStaNow">Force Start Now</asp:LinkButton>
                            <asp:LinkButton CssClass="" ID="StopBackup" runat="server" ToolTip="Disable Backup" OnClientClick="ConfirmDisable();return false;"><span class="gladinet-icons gladrootbtn" style="font-size:64px!important">&#x15A;</span></asp:LinkButton>
                        </td>
                    </tr>
                 

                </table>
                    </div>
    <%}%>
    <table width="100%" >
        
        <tr>
            <td style="padding-bottom:20px; ">
                  <%if (!string.IsNullOrEmpty(ErrorMsg.Text))
                             { %>        
         <div class="alert alert-warning  " style="padding-top: 2px; " id='errmsgdiv' role="alert">
           <a href="javascript:;" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                                          
                                                <asp:Label ID="ErrorMsg" runat="server" Text="" ForeColor="Red"></asp:Label>
                                          
                                        </div>

                                        
        <%} %>
                            
            </td>
        </tr>
        

        <tr>
            <td align="center" >
                <%if (EnableBackup.Checked){ %>
                <div class="wrapper" style="background-color: white;overflow:auto; padding:10px;<%if (DeviceView){ %>display:none<%}%> " id="page_2_div" >
                  <div style="overflow: auto; overflow-x:hidden;" id="maindiv">
            <div id="myModal" class="modal fade" role="dialog">
                <asp:Localize meta:resourcekey="str_onfirmrestore" id="str_onfirmrestore" runat="server" Visible="false">Confirm you want to restore this version to head version?</asp:Localize>
        <div class="modal-dialog">
            <!-- Modal content-->
            <div class="modal-content" style="width: 600px;">
                <div class="modal-header">
                                       

                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <div class="modal-body">
                    <table>
                        <tr>
                            <td align="left" valign="middle" style="padding:10px; " class="glabel2"><asp:Localize runat="server" meta:resourcekey="str_snaNam">Snapshot Name</asp:Localize></td>
                            <td align="right" valign="middle" style="padding:10px; width: 100px;">
                                
                                <asp:TextBox ID="SnapshotName" runat="server" CssClass="form-control" Width="300px"></asp:TextBox>
                                      
                            </td>

                        </tr>
                    </table>
                </div>
                <div class="modal-footer">
                                                    <asp:Button ID="AddNewVersion" runat="server" meta:resourcekey="str_takASna" Text="Take a snapshot" CssClass="btn btn-default sectextcolor"
                                    OnClick="AddNewVersion_Click" OnClientClick="Wait('Uploading');" />

                    <button type="button" class="btn btn-default" data-dismiss="modal">
                        <%=str_close.Text %></button>
                </div>
            </div>
        </div>
    </div>
            <table width="100%"  align="center"  cellspacing="0"  
                cellpadding="0" style="background-color: transparent;">
                 
                <%if (VersionRepeat.Items.Count != 0){ %>
                <tr style=" border-bottom: 0px solid red; font-weight: 100;">
                    
                    <td  style="padding: 5px; border: 0px; border-bottom: 0px solid #d0d0d0; color: #565656; font-size: 14px;
                        border-top: 0px solid #d0d0d0;"><asp:Localize runat="server" meta:resourcekey="str_snaNam">Snapshot Name</asp:Localize></td>
                    <td style="padding: 5px; border: 0px; border-bottom: 0px solid #d0d0d0;color: #565656;font-size: 14px;width:180px;
                        border-top: 0px solid #d0d0d0;"><asp:Localize runat="server" meta:resourcekey="str_stoUsa">Storage Usage</asp:Localize></td>
                    <td style="padding: 5px; border: 0px; border-bottom: 0px solid #d0d0d0;color: #565656;font-size: 14px;width:180px;
                        border-top: 0px solid #d0d0d0;"><asp:Localize runat="server" meta:resourcekey="str_folCou">Folder Count</asp:Localize></td>
                    <td style="padding: 5px; border: 0px; border-bottom: 0px solid #d0d0d0;color: #565656;font-size: 14px;width:180px;
                        border-top: 0px solid #d0d0d0;"><asp:Localize runat="server" meta:resourcekey="str_filCou">File Count</asp:Localize></td>
                    <td style="padding: 5px; border: 0px; border-bottom: 0px solid #d0d0d0;color: #565656;font-size: 14px;width:180px;
                        border-top: 0px solid #d0d0d0;"><asp:Localize runat="server" meta:resourcekey="str_creTim">Create Time</asp:Localize></td>
                    <td  style="padding: 5px; border: 0px; border-bottom: 0px solid #d0d0d0;color: #565656;font-size: 14px; width:100px;
                        border-top: 0px solid #d0d0d0;"><asp:Localize runat="server" meta:resourcekey="str_cre">Created by</asp:Localize></td>
                   
                    <td width="80px" style=" border: 0px; border-bottom: 0px solid #d0d0d0;
                        border-top: 0px solid #d0d0d0; border-right: 0px solid #d0d0d0; height:32px!important; overflow:hidden" >
                       
    
                        <table width="100%" align="center"  cellspacing="0" cellpadding="0" >
            <tr>
                 
                <td align="right" style=" padding-right: 10px; padding-top:5px;">
                    
                    <button type="button" class="btn btn-default " data-toggle="modal" data-target="#myModal" style="padding:3px!important; "
                        title="<%=AddNewVersion.Text%>">
                        <span class="sectextcolor" aria-hidden="true" style="font-size: 32px; font-weight:100;">+</span>
                    </button>
                    
                </td>
                
                <td width="32px">
                    <asp:LinkButton ID="RefreshBtn" runat="server" OnClick="RefreshBtn_Click"><i class="gladinet-icons md-32 md-dark hand center " style="display: inline-block; margin-top: 8px;">&#0181;</i></asp:LinkButton>
                     
                </td>
            </tr>
        </table>
        
    
    
                        <asp:Localize meta:resourcekey="str_down" ID="str_down" runat="server" Visible="False">Download</asp:Localize>
                        <asp:Localize meta:resourcekey="str_del" id="str_del" Visible="False" runat="server">Delete</asp:Localize>
                        <asp:Localize meta:resourcekey="str_restore" id="str_restore" Visible="False" runat="server">Restore to this version</asp:Localize>
                        <asp:Localize meta:resourcekey="str_close" id="str_close" Visible="False" runat="server">Close</asp:Localize>
                        <asp:Localize meta:resourcekey="str_browse" id="str_browse" Visible="False" runat="server">Browse</asp:Localize>
                    </td>
                </tr>
                
               
                <asp:Repeater ID="VersionRepeat" runat="server">
                    <ItemTemplate>
                        <tr style="border-top: 1px solid #f0f0f0; padding: 5px 5px 5px 5px; font-weight: 100; background-color:white;" class="filerow" ondblclick='BrowseSnapshot("<%#DataBinder.Eval(Container.DataItem, "SnapshotName")%>","<%# DataBinder.Eval(Container.DataItem, "SnapshotId").ToString().Replace("'","%27") %>");return false;'>
                          
                            <td style="padding: 10px; border-bottom: 1px solid #f8f8f8;font-size:16px; font-weight:100; color:#404040;">
                                <%#DataBinder.Eval(Container.DataItem, "SnapshotName")%>
                                
                            </td>
                            <td style="padding: 10px; border-bottom: 1px solid #f8f8f8;">
                               <%#DataBinder.Eval(Container.DataItem, "StorageDisplayName")%>
                            </td>
                            <td style="padding: 10px; border-bottom: 1px solid #f8f8f8;">
                               <%#DataBinder.Eval(Container.DataItem, "DirCount")%>
                            </td>
                            <td style="padding: 10px; border-bottom: 1px solid #f8f8f8;">
                               <%#DataBinder.Eval(Container.DataItem, "FileCount")%>
                            </td>
                            <td style="padding: 10px; border-bottom: 1px solid #f8f8f8;">
                               <%#DataBinder.Eval(Container.DataItem, "CreateTimeDisplay")%>
                            </td>
                            <td style="padding: 10px; border-bottom: 1px solid #f8f8f8;">
                               <%#DataBinder.Eval(Container.DataItem, "UpdateDisplayName")%>
                            </td>
                           
                          
                            <td style="padding-right: 4px; border-bottom: 1px solid #f8f8f8; border-right: 0px solid #e0e0e0; padding:5px;" >
                                
                                <table>
                                    <tr>
                                        
                                         
                                        <td >
                                            <a href='#' onclick='BrowseSnapshot("<%#DataBinder.Eval(Container.DataItem, "SnapshotName")%>","<%# DataBinder.Eval(Container.DataItem, "SnapshotId").ToString().Replace("'","%27") %>");return false;'>
                                                
                                                <i class="gladinet-icons  iconviewitemcolor hand center" title="<%=str_browse.Text %>" style="font-size:16px!important">&#xDB;</i>
                                                
                                                </a>
                                        </td>
                                           <td width="5px">&nbsp;</td>
                                        <td <%#(Container.ItemIndex == 0)? "style='display:none'": "" %>>
                                            <a href='#' onclick="DeleteSnapshot('<%#DataBinder.Eval(Container.DataItem, "SnapshotName").ToString().Replace("'","%27") %>','<%# DataBinder.Eval(Container.DataItem, "SnapshotId").ToString().Replace("'","%27") %>');return false;">
                                                
                                                
                                                <i class="gladinet-icons  iconviewitemcolor hand center" title="<%=str_del.Text %>" style="font-size:16px!important">&#xFB;</i>
                                                </a>
                                            
                                        </td>
                                        <td width="5px">&nbsp;</td>
                                        <td style="display:none;">
                                            <a href='#' onclick="restoreByKey('<%# DataBinder.Eval(Container.DataItem, "SnapshotId").ToString().Replace("'","%27") %>');return false;">
                                                
                                                <i class="gladinet-icons  iconviewitemcolor hand center" title="<%=str_restore.Text %>" style="font-size:16px!important">&#xFC;</i>
                                                
                                                </a>
                                        </td>
                                        
                                    </tr>
                                </table>
                            
                            </td>
                        </tr>
                    </ItemTemplate>
                </asp:Repeater>
                <%}else { %>
                <tr>
                    <td align="center">
                <div style="font-size:18px; font-weight:100; color:#565656; padding-top:40px"><asp:Localize runat="server" meta:resourcekey="str_theNoSnaAvaBef">There is no snapshot available before the initial data seeding. Initial data seeding will occur when the backup process runs next time.</asp:Localize></div>
                <div style="padding-top:40px;">
                    <asp:LinkButton CssClass="btn btn-primary gladbtn" ID="ForceStart" runat="server" OnClick="StartSeeding_Click" meta:resourcekey="str_forIniSeeNow">Force Initial Seeding Now</asp:LinkButton>
                </div>

                    </td>
                </tr>
                <%} %>
            </table>
             
        </div>           
                </div>

                <div class="wrapper" style="background-color: white; display:none; " id="page_1_div">
                    <table width="100%" id="SummaryTable">
                        <tr>
                            <td align="center" style="padding-top:30px;">
                                <table style="width:100%; max-width:800px; display:;" border="0" id="SummaryPanel">
                                    <tr>
                                        <td colspan="2" align="center" height="90px" valign="top" id="displayicon">
                                            <span class="alert-<%=DipslayIconColor.Value%> fa fa-<%= DipslayIconName.Value%>" style="font-size:64px; background-color:white!important; "></span>
                                        </td>
                                    </tr>
                                    <tr>
                                                <td colspan="2" align="center">
                                                    <span style="padding:3px; font-size:18px;font-weight:100; color:#565656; " >
                                                        <asp:Label ID="DisplayStatus" runat="server" Text=""></asp:Label></span>
                                                </td>
                                            </tr>
                                     <tr>
                                                <td colspan="2" style="padding-top:20px;" align="center">
                                                    <asp:LinkButton CssClass="btn btn-primary gladbtn" ID="LinkButton1" runat="server" OnClick="StartSeeding_Click" meta:resourcekey="str_forStaNow">Force Start Now</asp:LinkButton>
                                                </td>
                                            </tr>
                                    <tr>
                                                <td colspan="2" height="20px;"></td>
                                            </tr>
                                            <tr style="display:none;">
                                                <td colspan="2" align="center">
                                                    <table>
                                                        <tr >
                                                <td style="color:#565656;font-weight:100;font-size:12px;" width="150px" nowrpa="nowrap"></td>
                                                <td style="font-weight:100;font-size:14px;" align="left" class="sectextcolor"></td>
                                            </tr>
                                            <tr>
                                                <td style="color:#565656;font-weight:100;font-size:12px; padding-top:10px;"  width="100px" nowrpa="nowrap"><asp:Localize runat="server" meta:resourcekey="str_lasStaTim">Last Start Time</asp:Localize></td>
                                                <td style="font-weight:100;font-size:14px;" align="left" class="sectextcolor" id="starttime">
                                                    
                                                    <asp:Label ID="StartTime" runat="server" Text=""></asp:Label>
                                                </td>
                                            </tr>
                                            <tr>                                                
                                                <td style="color:#565656;font-weight:100;font-size:12px;"><asp:Localize runat="server" meta:resourcekey="str_dur">Duration</asp:Localize></td>
                                                <td style="font-weight:100;font-size:14px;" align="left" class="sectextcolor" id="duration">
                                                    
                                                    <asp:Label ID="Duration" runat="server" Text=""></asp:Label>
                                                    
                                                </td>
                                            </tr>
                                            <tr>                                                
                                                <td style="color:#565656;font-weight:100;font-size:12px;"><asp:Localize runat="server" meta:resourcekey="str_filCou">File Count</asp:Localize></td>
                                                <td style="font-weight:100;font-size:14px;" align="left" class="sectextcolor" id="filecount">                                                    
                                                    <asp:Label ID="FileCount" runat="server" Text=""></asp:Label>
                                                </td>
                                            </tr>
                                            <tr>                                                
                                                <td style="color:#565656;font-weight:100;font-size:12px;"><asp:Localize runat="server" meta:resourcekey="str_datSiz">Data Size</asp:Localize></td>
                                                <td style="font-weight:100;font-size:14px;" align="left" class="sectextcolor" id="backupsize">                                                    
                                                    <asp:Label ID="DisplayBackupSize" runat="server" Text=""></asp:Label>
                                                </td>
                                            </tr>
                                                    </table>
                                                </td>
                                            </tr>

                                    
                                            
                                </table>
                                
                               
                            </td>
                        </tr>
                    </table>
                    <table width="100%" id="tablerunning" style="display:none;">
                        <tr>
                            <td align="center" style="padding-top:30px;">
                                 <div  style="width:100%;max-width: 800px; padding:5px; font-size:16px;  display:;" id="RunningPanel" >
                                <table width="100%">
                        <tr>
                            <td width="30%" style="padding-top:0px;" valign="top">
                                <table width="100%">
                                    <tr>
                                        <td colspan="2" style="font-weight:100; padding:10px; font-size:18px; color:#565656;" align="center"><asp:Localize runat="server" meta:resourcekey="str_sum">Summary</asp:Localize></td>
                                    </tr>
                                    <tr style="display:none;">
                                        <td style="padding: 5px; border-bottom: 1px solid #f0f0f0;"><asp:Localize runat="server" meta:resourcekey="str_sta">Status</asp:Localize></td>
                                        <td style="padding: 5px; border-bottom: 1px solid #f0f0f0;" class="sectextcolor" id="iTaskStatus">
                                            <asp:Label ID="TaskStatus" runat="server" Text=""></asp:Label>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="padding: 5px; border-bottom: 1px solid #f0f0f0;font-size:16px; color:#565656; font-weight:100;"><asp:Localize runat="server" meta:resourcekey="str_totTas">Total Tasks</asp:Localize></td>
                                        <td style="padding: 5px; border-bottom: 1px solid #f0f0f0;font-size:16px; color:#565656; font-weight:100;" class="sectextcolor" id="iTotalTask">
                                            <asp:Label ID="TotalTask" runat="server" Text=""></asp:Label>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="padding: 5px; border-bottom: 1px solid #f0f0f0;font-size:16px; color:#565656; font-weight:100;"><asp:Localize runat="server" meta:resourcekey="str_penTas">Pending Tasks</asp:Localize></td>
                                        <td style="padding: 5px; border-bottom: 1px solid #f0f0f0;font-size:16px; color:#565656; font-weight:100;" class="sectextcolor" id="iPendingTask">
                                            <asp:Label ID="PendingTask" runat="server" Text=""></asp:Label>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="padding: 5px; border-bottom: 1px solid #f0f0f0;font-size:16px; color:#565656; font-weight:100;"><asp:Localize runat="server" meta:resourcekey="str_faiTas">Failed Tasks</asp:Localize></td>
                                        <td style="padding: 5px; border-bottom: 1px solid #f0f0f0;font-size:16px; color:#565656; font-weight:100;" class="sectextcolor" id="iFailedTask">
                                            <asp:Label ID="FailedTask" runat="server" Text=""></asp:Label>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="padding: 5px; border-bottom: 1px solid #f0f0f0;font-size:16px; color:#565656; font-weight:100;"><asp:Localize runat="server" meta:resourcekey="str_skiTas">Skipped Tasks</asp:Localize></td>
                                        <td style="padding: 5px; border-bottom: 1px solid #f0f0f0;font-size:16px; color:#565656; font-weight:100;" class="sectextcolor" id="iSkippedTask">
                                            <asp:Label ID="SkippedTask" runat="server" Text=""></asp:Label>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td colspan="2" style="padding:10px; padding-top:20px; display:none;" align="right">
                                            <table>
                                                            <tr>
                                                                <td id="tdr" style="display:none;">                                                                    
                                                                    <asp:Button ID="Resume" runat="server" Text="Resume" CssClass="btn btn-primary gladbtn" OnClick="Resume_Click" />
                                                                </td>
                                                                <td id="tdp" style="display:none;">
                                                                    <asp:Button ID="Pause" runat="server" Text="Pause" CssClass="btn btn-primary gladbtn" OnClick="Pause_Click"  />
                                                                </td>

                                                                <td id="tds" style="display:none;">
                                                                    <asp:Button ID="Start" runat="server" Text="ReStart" CssClass="btn btn-primary gladbtn" OnClick="Start_Click"  />
                                                                </td>
                                                            </tr>
                                                        </table>
                                        </td>
                                    </tr>
                                     <tr>
                <td colspan="2" style="height:20px; color:red;" id="PollRes" align="center"></td>
            </tr>
                                </table>
                            </td>
                            <td style="width:1px; border-left: 1px solid#f4f4f4 ;"></td>
                            <td valign="top" style="padding-top:0px; border-left:0px solid #f0f0f0;">
                                <table width="100%" style="font-size:16px!important;" >
                                    <tr>
                                        <td  colspan="2" style="font-weight:100; padding:10px; font-size:18px; color:#565656;" align="center"><asp:Localize runat="server" meta:resourcekey="str_pro">Progress</asp:Localize></td>
                                    </tr>
                                    <tr>
                                        <td colspan="2" id="" style="padding:5px;" class="sectextcolor"></td>
                                    </tr>
                                    <tr >
                                        <td width="120px" style="padding:5px; font-size:16px; color:#565656; font-weight:100;"><asp:Localize runat="server" meta:resourcekey="str_ove">Overall</asp:Localize></td>
                                        <td >
                                            <div class="progress" style="width:100%;">
                                                                <div class="progress-bar  <%#SyncProgressBarType.Value %>" role="progressbar" aria-valuenow="40" id="iTaskProgress"
                                                                    aria-valuemin="0" aria-valuemax="100" style="width:<%=SyncProgressPercent.Value %>%"></div>
                                                                </div>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td colspan="2" style="height:250px; overflow-y:auto;padding:5px;" valign="top">
                                            <table width="100%">
                                                <tbody id="Running">

                                                </tbody>
                                            </table>
                                        </td>
                                    </tr>

                                    </table>
                            </td>
                        </tr>
                    </table>
                                </div>
                                </td>
                        </tr>
                    </table>
                </div>

                <div class="wrapper" style="background-color: white; display:none; " id="page_3_div"></div>
                <iframe id="page_5_div" src="/management/BackupSubtasks.aspx?child=1&vdid=<%=SessionDomainId%>&tid=<%=TeamFolderId.Value %>" style="width:100%; border:0px; display:none;">

                </iframe>
                <table width="100%" style="max-width: 800px; display: none;" id="page_6_div">
                         <tr>
                            <td colspan="2" style="padding-top: 30px; font-size: 24px; color: #404040; font-weight: 400; border-bottom: 0px solid #f0f0f0;"></td>
                        </tr>
                        <tr>
                            <td style="padding: 5px; font-weight: 100; color: #565656; font-size: 16px;">
                                <asp:Localize runat="server" meta:resourcekey="str_keeLasSnaUnl">Keep last n snapshots (0 - unlimited)</asp:Localize></td>
                            <td style="padding: 5px; font-weight: 100; color: #565656; font-size: 16px;">
                                <asp:TextBox ID="BackupSnapshotCount" runat="server" CssClass="form-control" onchange="ShowSavePanel();"  onkeypress="ShowSavePanel();" Width="300" Text="0"></asp:TextBox>
                            </td>
                        </tr>
                         <tr>
                            <td style="padding: 5px; font-weight: 100; color: #565656; font-size: 16px;">
                                <asp:Localize runat="server" meta:resourcekey="str_keeSnaForLeaDay">Keep snapshot for at least n days (0 - controlled by other policies, otherwise override above policy)</asp:Localize></td>
                            <td style="padding: 5px; font-weight: 100; color: #565656; font-size: 16px;">
                                <asp:TextBox ID="BackupSnapshotDays" runat="server" CssClass="form-control" onchange="ShowSavePanel();" onkeypress="ShowSavePanel();" Width="300" Text="0"></asp:TextBox>
                            </td>
                        </tr>
                        <tr>
                            <td style="padding: 5px; font-weight: 100; color: #565656; font-size: 16px;">
                                <asp:Localize runat="server" meta:resourcekey="str_genFulBacSnaEve">Generate full backup snapshot every n days (0 - never)</asp:Localize></td>
                            <td style="padding: 5px; font-weight: 100; color: #565656; font-size: 16px;">
                                <asp:TextBox ID="FullBackupDays" runat="server" CssClass="form-control" onchange="ShowSavePanel();"  onkeypress="ShowSavePanel();" Width="300" Text="0"></asp:TextBox>
                            </td>
                        </tr>

                    </table>
                <div class="wrapper" style="background-color: white; overflow:auto; <%if (!DeviceView){ %>display:none<%}%>" id="page_4_div">
                     <table width="100%"  align="center"  cellspacing="0"  
                cellpadding="0" style="background-color: transparent;">
                    <%if (LogRepeater.Items.Count != 0){ %>
                         <tr style=" border-bottom: 0px solid red; font-weight: 100;">
                    <td  style="padding: 5px; border: 0px; border-bottom: 0px solid #d0d0d0; color: #565656; font-size: 14px; width:42px;
                        border-top: 0px solid #d0d0d0;"></td>
                    <td  style="padding: 5px; border: 0px; border-bottom: 0px solid #d0d0d0; color: #565656; font-size: 14px; 
                        border-top: 0px solid #d0d0d0;"><asp:Localize runat="server" meta:resourcekey="str_tasNam">Task Name</asp:Localize></td>
                    <td style="padding: 5px; border: 0px; border-bottom: 0px solid #d0d0d0;color: #565656;font-size: 14px;width:180px;
                        border-top: 0px solid #d0d0d0;"><asp:Localize runat="server" meta:resourcekey="str_staTim">Start Time</asp:Localize></td>
                    <td style="padding: 5px; border: 0px; border-bottom: 0px solid #d0d0d0;color: #565656;font-size: 14px;width:180px;
                        border-top: 0px solid #d0d0d0;"><asp:Localize runat="server" meta:resourcekey="str_dur">Duration</asp:Localize></td>
                    <td style="padding: 5px; border: 0px; border-bottom: 0px solid #d0d0d0;color: #565656;font-size: 14px;width:80px;
                        border-top: 0px solid #d0d0d0;"><asp:Localize runat="server" meta:resourcekey="str_filCou">File Count</asp:Localize></td>
                    <td style="padding: 5px; border: 0px; border-bottom: 0px solid #d0d0d0;color: #565656;font-size: 14px;width:180px;
                        border-top: 0px solid #d0d0d0;"><asp:Localize runat="server" meta:resourcekey="str_totFilSiz">Total File Size</asp:Localize></td>
                    <td  style="padding: 5px; border: 0px; border-bottom: 0px solid #d0d0d0;color: #565656;font-size: 14px; width:100px;
                        border-top: 0px solid #d0d0d0;"><asp:Localize runat="server" meta:resourcekey="str_delFil">Deleted Files</asp:Localize></td>
                                                 <td  style="padding: 5px; border: 0px; border-bottom: 0px solid #d0d0d0;color: #565656;font-size: 14px; width:100px;
                        border-top: 0px solid #d0d0d0;"><asp:Localize runat="server" meta:resourcekey="str_pro">Processed</asp:Localize></td>
                                                 <td  style="padding: 5px; border: 0px; border-bottom: 0px solid #d0d0d0;color: #565656;font-size: 14px; width:100px;
                        border-top: 0px solid #d0d0d0;"><asp:Localize runat="server" meta:resourcekey="str_faiCou">Failed Count</asp:Localize></td>

                             </tr>
                    <asp:Repeater ID="LogRepeater" runat="server">
                    <ItemTemplate>
                        <tr class="filerow" style=" border-bottom: 0px solid red; font-weight: 100; cursor:default!important;">
                            <td style="padding: 10px; border-bottom: 1px solid #f8f8f8;font-size:16px; font-weight:100; color:#404040;">
                               
                                 <span class="alert-<%#DataBinder.Eval(Container.DataItem, "DipslayIconColor")%> fa fa-<%#DataBinder.Eval(Container.DataItem, "DipslayIconName")%>" style="font-size:24px; background-color:white!important; "></span>
                                
                            </td>
                             <td style="padding: 10px; border-bottom: 1px solid #f8f8f8;font-size:16px; font-weight:100; color:#404040;" align="left">
                                <%#DataBinder.Eval(Container.DataItem, "LogName")%>
                                
                            </td>
                            <td style="padding: 10px; border-bottom: 1px solid #f8f8f8;font-size:16px; font-weight:100; color:#404040;">
                                <%#DataBinder.Eval(Container.DataItem, "DisplayStartTime")%>
                                
                            </td>
                            <td style="padding: 10px; border-bottom: 1px solid #f8f8f8;font-size:16px; font-weight:100; color:#404040;">
                                <%#DataBinder.Eval(Container.DataItem, "Duration")%>
                                
                            </td>
                            <td style="padding: 10px; border-bottom: 1px solid #f8f8f8;font-size:16px; font-weight:100; color:#404040;">
                                <%#DataBinder.Eval(Container.DataItem, "FileCount")%>
                                
                            </td>
                             <td style="padding: 10px; border-bottom: 1px solid #f8f8f8;font-size:16px; font-weight:100; color:#404040;">
                                <%#DataBinder.Eval(Container.DataItem, "DisplayFileSize")%>
                                
                            </td>
                            <td style="padding: 10px; border-bottom: 1px solid #f8f8f8;font-size:16px; font-weight:100; color:#404040;">
                                <%#DataBinder.Eval(Container.DataItem, "DeleteFileCount")%>
                                
                            </td>
                            <td style="padding: 10px; border-bottom: 1px solid #f8f8f8;font-size:16px; font-weight:100; color:#404040;">
                                <%#DataBinder.Eval(Container.DataItem, "ProcessedCount")%>/<%#DataBinder.Eval(Container.DataItem, "TotalTaskCount")%>
                            </td>
                            <td style="padding: 10px; border-bottom: 1px solid #f8f8f8;font-size:16px; font-weight:100; color:#800000;">
                                <%#DataBinder.Eval(Container.DataItem, "FailedCount")%>
                                
                            </td>
                        </tr>
                    </ItemTemplate>
                    </asp:Repeater>
                    <%}else { %>
                    <tr>
                    <td align="center">
                <div style="font-size:18px; font-weight:100; color:#565656; padding-top:40px"><asp:Localize runat="server" meta:resourcekey="str_theNoProLogFou">There is no process log found.</asp:Localize></div>
               

                    </td>
                </tr>
                    <%} %>
               

                <%}else { %>
                 <tr>
                    <td align="center">
                <div style="padding-top:120px;font-size:24px; font-weight:100;">
                    <asp:Localize runat="server" meta:resourcekey="str_bacNotEnaForSha">Backup is not enabled for the share.</asp:Localize><br /><br />
                    <asp:LinkButton CssClass="" ID="StartBackup" runat="server" ToolTip="Enable Backup" OnClick="StartBackup_Click"><span class="gladinet-icons gladrootbtn" style="font-size:64px!important">&#x15B;</span></asp:LinkButton>

                </div>
             
                        </td>
                </tr>
           <%}%>
                 </table>
    </div>
            </td>
        </tr>
    </table>
        </div>
    <div id="childwnd" style="width:100%; display:none;">
    <div width="100%" style="background-color: white;  border: 0px; padding-bottom:0px; align-content: right; border-bottom: 1px solid #f0f0f0; " >
        <table width="100%" style="border-collapse:collapse;" cellpadding="0" cellspacing="0" >
            <tr>
                <td>
                    <table>
                        <tr>
                <td style="padding:5px; font-size:18px; cursor:pointer;font-weight:100;" class="sectextcolor toolnavbtn" onclick="CloseChildWnd();"><asp:Localize runat="server" meta:resourcekey="str_sna">Snapshots</asp:Localize></td>
                                
                <td  style="padding:5px; font-size:18px;" class="sectextcolor ">></td>
                <td align="left" style="padding:5px;border-bottom: 0px solid #cccccc;padding-right:10px; height:48px; font-size:18px; font-weight:100;" id="child_title" ></td>

                        </tr>
                    </table>
                </td>
                    
                <td style="border-bottom: 0px solid #cccccc;padding-right:10px;">
                    <div style="float:right; font-size:32px;  font-weight:100; cursor:pointer;" class="sectextcolor" onclick="CloseChildWnd();">&times;</div>
                </td>
                </tr>
            </table>
        </div>
   
   
<iframe width="100%" src="/portal/WaitWin.htm" frameborder="0" style="margin-top:5px;"
                    border="0" height="100%" id="child_body"></iframe>
        </div>
    <div style="display:none">
        <asp:Button ID="ApplyBtn" runat="server" Text="Button" OnClick="ApplyBtn_Click" />
    <asp:HiddenField ID="TeamFolderId" runat="server" />         
        <asp:HiddenField ID="SnapshotId" runat="server" />         
    <asp:HiddenField ID="DipslayIconColor" runat="server" />
    <asp:HiddenField ID="DipslayIconName" runat="server" />
     <asp:HiddenField ID="SyncProgressBarType" runat="server" />        
     <asp:HiddenField ID="SyncProgressPercent" runat="server" />
        <asp:LinkButton ID="DeleteSnapshot" runat="server" OnClick="DeleteSnapshot_Click" meta:resourcekey="str_del">DeleteSnapshot</asp:LinkButton>
        </div>
    <div style="display: none">
                            <asp:Button ID="Button1" runat="server" Text="Button" onclick="StopBackup_Click"/>
                            
    </div>
    <script type="text/javascript">
        function ConfirmDisable() {
            gConfirm("Are you sure you want to disable?", "", function (btn, tex) {
                if (btn == 'yes' || btn == 'ok') {
                    var e = document.getElementById("ctl00_MainContent_Button1");
                    Wait("Applying Changes");
                    e.click();
                }
            });
        }

        function CloseChildWnd() {
            var f = document.getElementById('defaultcontent');
            f.style.display = "";


            f = document.getElementById('child_body');
            f.src = "/portal/WaitWin.htm";

            f = document.getElementById('childwnd');
            f.style.display = "none";

        }
        function OpenChildWnd(t, s) {
            var f = document.getElementById('defaultcontent');
            f.style.display = "none";


            f = document.getElementById('child_body');
            f.src = s;

            f = document.getElementById('childwnd');
            f.style.display = "";

            f = document.getElementById('child_title');
            f.innerHTML = t;

        }

        function closeCancelActiveWin() {
            CloseChildWnd();
        }

        function BrowseSnapshot(n, sid)
        {
            OpenChildWnd(n, "/management/BackupMgr/UI/BackupSnapshotBrowser.aspx?tid=<%=TeamFolderId.Value%><% if (IsChildUi) { %>&child=1<%}%>&sid="+sid)
        }

        function DeleteSnapshot(n,s)
        {

            gConfirm('Confirm you want to delete snapshot: "'+n+'"?', "", function (btn1) {

                if (btn1 != 'ok')
                    return;
                var btn = document.getElementById('ctl00_MainContent_DeleteSnapshot');
                var sname = document.getElementById('ctl00_MainContent_SnapshotId');

                sname.value = s;

                Wait('Applying');
                btn.click();
            });
        }

        function stringStartsWith(s, p) {
            return (s.indexOf(p) == 0);
        }
        function GetShortString(src, MaxLen) {
            if (src.length <= MaxLen)
                return src;
            src = src.replace('[BuiltInGroup]', '');
            if (src.length <= MaxLen)
                return src;
            var len = (MaxLen - 3) / 2;
            var p1 = src.substring(0, len);
            var p2 = src.substring(src.length - len);
            return p1 + "..." + p2;

        }

        function FormatFileSize(size) {
            if (size < 1024) { //pow(2,10)
                return size + " B";
            } else if (size < 1048576) { //pow(2,20)
                return (Math.round(((size * 10) / 1024)) / 10) + " KB";
            } else if (size < 1073741824) { //pow(2,30)
                return (Math.round(((size * 10) / 1048576)) / 10) + " MB";
            } else if (size < 1099511627776) { //pow(2,40)
                return (Math.round(((size * 100) / 1073741824)) / 100) + " GB";
            } else if (size < 1125899906842624) { //pow(2,50)
                return (Math.round(((size * 100) / 1099511627776)) / 100) + " TB";
            } else { //pow(2,60)
                return (Math.round(((size * 100) / 1125899906842624)) / 100) + " PB";
            }
        }
        function AddRunningTask(res)
        {
            try{
                var e = document.getElementById("Running");
                e.innerHTML = "";

                var count = Math.floor((res.length - 8) / 4);
                for (var i = 0; i < count; ++i) {
                    var etr = document.createElement("tr");
                    etr.style.fontSize = "16px";
                    etr.style.borderBottom = "1px solid #f0f0f0";
                    var ttd = document.createElement("td");
                    ttd.innerHTML = res[8 + i * 4];
                    etr.appendChild(ttd);
                    ttd.style.width = "60px";
                    ttd.className = "sectextcolor";
                    ttd.fontSize = "24px!important";
                    var ntd = document.createElement("td");
                    ntd.innerHTML = GetShortString(res[8 + i * 4 + 1], 20);
                    etr.appendChild(ntd);


                    var ptd = document.createElement("td");
                    ptd.align = "right";
                    ptd.fontSize = "16px!important";
                    ptd.className = "sectextcolor";
                    if (res[8 + i * 4 + 2] != 0) {
                        ptd.innerHTML = FormatFileSize(res[8 + i * 4 + 3]) + "/" + FormatFileSize(res[8 + i * 4 + 2]);
                    }
                    etr.appendChild(ptd);

                    e.appendChild(etr);
                }
            } catch (eee) {

            }
        }

        function onChangeTaskStatus(s)
        {

            try{
                var tdr = document.getElementById("tdr");
                var tdp = document.getElementById("tdp");
                var tds = document.getElementById("tds");

                if (s == "Task Pending") {
                    tdr.style.display = "none";
                    tdp.style.display = "";
                    tds.style.display = "none";
                }
                else if (s == "Task Running") {
                    tdr.style.display = "none";
                    tdp.style.display = "";
                    tds.style.display = "none";

                } else if (s == "Task Paused") {
                    tdr.style.display = "";
                    tdp.style.display = "none";
                    tds.style.display = "none";
                } else if (s == "Completed") {

                    tdr.style.display = "none";
                    tdp.style.display = "none";
                    tds.style.display = "none";
                } else {
                    tdr.style.display = "";
                    tdp.style.display = "none";
                    tds.style.display = "";
                }
            } catch (e) {

            }

            var ee1 = document.getElementById("ctl00_MainContent_DisplayStatus");
            var res = s.split(";");

            if (res.length == 1) {
                ee1.innerHTML = s;
                return;
            }

            ee1.innerHTML = res[0];
            var ss = '<span class="alert-' + res[1] + ' fa fa-' + res[2] + '" style="font-size:64px!important; background-color:white!important; "></span>';

            ee1 = document.getElementById("displayicon");
            ee1.innerHTML = ss;

            ee1 = document.getElementById("starttime");
            ee1.innerHTML = res[3];

            ee1 = document.getElementById("filecount");
            ee1.innerHTML = res[4];

            ee1 = document.getElementById("backupsize");
            ee1.innerHTML = res[5];

            ee1 = document.getElementById("duration");
            ee1.innerHTML = res[6];

        }

        function ShowRunning(s)
        {
            var r = document.getElementById("tablerunning");
            var m = document.getElementById("SummaryTable");
            if (s) {
                r.style.display = "";
                m.style.display = "none";
            } else {
                r.style.display = "none";
                m.style.display = "";

            }
        }



        function OnPollRes(m) {
            try {

                var e = document.getElementById("PollRes")
                if (stringStartsWith(m, "bad^")) {
                    e.innerHTML = m.substring(4);
                    ShowRunning(false);
                    setTimeout("Poll()", 3000);
                    return;
                }
                e.innerHTML = "&nbsp;";

                var res = m.split("|");

                e = document.getElementById("iTotalTask");
                e.innerHTML = res[0];
                if (res.length >= 8) {
                    e.innerHTML = res[7];
                    ShowRunning(true);
                } else {
                    ShowRunning(false);

                }


                onChangeTaskStatus(res[4]);
                e = document.getElementById("iPendingTask");
                if(res[1] != "-1")
                    e.innerHTML = res[1];
                else
                    e.innerHTML = "";

                e = document.getElementById("iFailedTask");
                if (res[2] != "-1")
                    e.innerHTML = res[2];
                else
                    e.innerHTML = "";

                e = document.getElementById("iSkippedTask");
                if (res[3] != "-1")
                    e.innerHTML = res[3];
                else
                    e.innerHTML = "";


                e = document.getElementById("iTaskStatus");
                e.innerHTML = res[4];

                e = document.getElementById("iTaskProgress");
                e.style.width = res[5]+"%";

                e = document.getElementById("ProcessStatus");
                if (e) {
                    if (res.length >= 7) {
                        e.innerHTML = res[6];
                    } else {
                        e.innerHTML = "";

                    }
                }

                if(res.length >= 9){
                    AddRunningTask(res);
                } else {
                    var e = document.getElementById("Running");
                    if(e)
                        e.innerHTML = "";

                }


            } catch (ee) {

            }
            setTimeout("Poll()", 1000);
        }

        function Poll() {


            try {
                Ext.Ajax.request({
                    url: '/management/BackupMgr/UI/BackupTeamFolder.aspx?tid=<%=TeamFolderId.Value %>&vdid=<%=SessionDomainId%>&poll=1',
                    success: function (response) {

                        OnPollRes(response.responseText);
                    },
                    failure: function () {
                        OnPollRes('bad^unknown');
                    },
                    method: 'GET'
                });

            } catch (e) {
                alert(e);
            }


        }

        function AdjustSize() {


            var f = document.getElementById('page_2_div');
            f.style.height = (document.documentElement.clientHeight - 150) + "px";
            
            var f = document.getElementById('page_4_div');
            f.style.height = (document.documentElement.clientHeight - 150) + "px";
            
            var f = document.getElementById('page_5_div');
            f.style.height = (document.documentElement.clientHeight - 150) + "px";


            f = document.getElementById('child_body');
            f.style.height = (document.documentElement.clientHeight - 150) + "px";
            
        }


        Ext.onReady(function () {
             <%if(m_ShowSummary){%>
            SetPage(1);
            <%}%>
            AdjustSize();
            setTimeout("Poll()", 2000);
            

        });

        Ext.EventManager.onWindowResize(function () {
                       

            AdjustSize();
        });

    </script>
</asp:Content>
