﻿<%@ Page Title="Gladinet Cloud - Cluster Settings" Language="C#" MasterPageFile="../WebAppPanel.master" ValidateRequest="false" EnableSessionState="false" 
    AutoEventWireup="true" CodeBehind="ServoSecSSOCfg.aspx.cs" Inherits="GladinetPayFlow.ServoSecSSOCfg"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">


    <style type="text/css">
        td {
            font-size: 15px;
            font-weight: 100;
        }

        b {
            font-weight: 500;
        }

        .badgefont {
            font-size: 15px;
        }
    </style>
    <script type="text/javascript">

        function ReturnLast() {
            window.location = "<%=GetLastSubPage("ServoSecSSO.aspx"+SessionDomainId)%>";
        }

    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
<asp:Localize runat="server" ID="LocFaiToLoaIdpMetDatFedMetDoc" meta:resourcekey="str_faiToLoaIdpMetDatFedMetDoc" Visible="false">Failed to load IdP Meta Data (Federation Metadata Document)</asp:Localize>
<asp:Localize runat="server" ID="LocFulQuaDomNamIsEmp" meta:resourcekey="str_fulQuaDomNamIsEmp" Visible="false">Fully Qualified Domain Name is empty</asp:Localize>
<asp:Localize runat="server" ID="LocDirIdIsEmp" meta:resourcekey="str_dirIdIsEmp" Visible="false">Directory ID is empty</asp:Localize>
    <asp:Localize runat="server" ID="LocOth" meta:resourcekey="str_oth" Visible="false">Other</asp:Localize>
    <asp:Localize ID="LocSSO" meta:resourcekey="str_sso" runat="server" Visible="false"></asp:Localize>


    <div style="width: 100%; padding: 5px;height:60px; border-bottom:1px solid #cccccc;" class="meubardrop1">
        <table style="width: 100%">
            <tr>
                <td>
                    <span class="gladbtn" style="font-weight: 400!important; font-size: 20px!important; text-transform: uppercase; color:#808080!important;"><asp:Localize runat="server" meta:resourcekey="str_enaSinSig">Enable Single sign on</asp:Localize></span>
                </td>
                <td style="font-weight: 100; font-size: 18px; color: red;">
                    <asp:Label ID="ErrorMsg" runat="server" Text=""></asp:Label>
                </td>
                <td style="padding-right: 10px;">
                    <div style="float: right; font-size: 32px; font-weight: 100; cursor: pointer;" class="sectextcolor" onclick="ReturnLast();">&times;</div>
                </td>
            </tr>
        </table>
    </div>

    <div class="wrapper" style="background-color: white; width: 100%; margin-top: 30px; font-size: 18px; align-content: center;">
        <asp:Panel ID="Step1Panel" runat="server">
            <table width="100%" style="max-width: 1400px;" align="center">
                <tr>
                    <td style="padding: 15px; font-size: 18px; color: #565656; font-weight: 100; padding-top: 60px;"><asp:Localize runat="server" meta:resourcekey="str_pleSelSSOProBel">Please select SSO Provider  below:</asp:Localize></td>
                </tr>
                <tr>
                    <td style="padding: 15px;">
                        <asp:DropDownList ID="SSOProviderList" runat="server" CssClass="browser-default custom-select secsubbordercolor"></asp:DropDownList>
                    </td>
                </tr>
                <tr>
                    <td align="right" style="padding-top: 40px;">
                        <asp:LinkButton CssClass="btn btn-primary gladbtn" ID="Step1Contine" runat="server" OnClick="Step1Contine_Click" meta:resourcekey="str_nex">Next</asp:LinkButton>
                        <asp:LinkButton CssClass="btn btn-default gladbtn" ID="CancelBtn" runat="server" OnClientClick="ReturnLast();return false;" meta:resourcekey="str_can">Cancel</asp:LinkButton>
                    </td>
                </tr>
            </table>
        </asp:Panel>
        <asp:Panel ID="Step2Panel" runat="server" Visible="false">
            <table width="100%" style="max-width: 1400px;" align="center">

                <tr>
                    <td style="height: 60px">&nbsp;</td>
                </tr>




                <%if (SSOProviderList.SelectedIndex == 0)
                    { %>
                <tr>
                    <td style="padding: 15px; font-size: 18px; color: #565656; font-weight: 100;">
                        <asp:Localize meta:resourcekey="azuretenantid" runat="server">Azure AD Directory ID</asp:Localize>

                    </td>
                </tr>
                <tr>
                    <td style="padding: 15px;">
                        <asp:TextBox ID="AzureTenantID" runat="server" Text="" CssClass="form-control"></asp:TextBox>
                    </td>

                </tr>
                <%}
                    else if (SSOProviderList.SelectedIndex == 1)
                    { %>
                <tr>
                    <td style="padding: 15px; font-size: 18px; color: #565656; font-weight: 100;">
                        <asp:Localize meta:resourcekey="str_fqdn" runat="server">Fully Qualified Domain Name</asp:Localize>

                    </td>
                </tr>
                <tr>

                    <td style="padding: 15px;">
                        <asp:TextBox ID="ADFSFQDN" runat="server" Text="" CssClass="form-control"></asp:TextBox>
                    </td>

                </tr>
                <%}
                    else if (SSOProviderList.SelectedIndex == 2)
                    { %>
                <tr>
                    <td style="padding: 15px; font-size: 18px; color: #565656; font-weight: 100;">
                        <asp:Localize meta:resourcekey="str_idpurl" runat="server">IdP End Point URL</asp:Localize>
                        <p class="text-muted" style="font-size: smaller">
                            <asp:Localize meta:resourcekey="str_idpurlh" runat="server">URL of the Identity Provider that the Service Provider must contact.</asp:Localize>
                        </p>

                    </td>
                </tr>
                <tr>

                    <td style="padding: 15px; padding-top:0px;">
                        <asp:TextBox ID="SAMLUrl" runat="server" Text="" CssClass="form-control"></asp:TextBox>

                    </td>
                </tr>

                <tr>
                    <td style="padding: 15px; font-size: 18px; color: #565656; font-weight: 100;">
                        <asp:Localize meta:resourcekey="str_idpemail" runat="server">IdP Email Parameter</asp:Localize>
                        <p class="text-muted" style="font-size: smaller">
                            <asp:Localize meta:resourcekey="str_idpemailh" runat="server">Email Parameter Name in Identity Provider</asp:Localize>
                        </p>

                    </td>
                </tr>
                <tr>

                    <td style="padding: 15px;padding-top:0px;">
                        <asp:TextBox ID="SAMLEmail" runat="server" Text="" CssClass="form-control"></asp:TextBox>

                    </td>
                </tr>
                <tr>
                    <td style="padding: 15px; font-size: 18px; color: #565656; font-weight: 100;">
                        <asp:Localize meta:resourcekey="str_idpfname" runat="server">IdP Given Name Parameter</asp:Localize>
                        <p class="text-muted" style="font-size: smaller">
                            <asp:Localize meta:resourcekey="str_idpfnameh" runat="server">Given Name Parameter Name in Identity Provider</asp:Localize>
                        </p>

                    </td>
                </tr>
                <tr>

                    <td style="padding: 15px;padding-top:0px;">
                        <asp:TextBox ID="SAMLFirstName" runat="server" Text="" CssClass="form-control"></asp:TextBox>

                    </td>
                </tr>
                <tr>
                    <td style="padding: 15px; font-size: 18px; color: #565656; font-weight: 100;">
                        <asp:Localize meta:resourcekey="str_idpsname" runat="server">IdP Surname Parameter</asp:Localize>
                        <p class="text-muted" style="font-size: smaller">
                            <asp:Localize meta:resourcekey="str_idpsnameh" runat="server">SurName Parameter Name in Identity Provider</asp:Localize>
                        </p>

                    </td>
                </tr>
                <tr>

                    <td style="padding: 15px;padding-top:0px;">
                        <asp:TextBox ID="SAMLLastName" runat="server" Text="" CssClass="form-control"></asp:TextBox>

                    </td>
                </tr>
                <tr>
                    <td style="padding: 15px; font-size: 18px; color: #565656; font-weight: 100;">
                        <asp:Localize meta:resourcekey="str_idpm" runat="server">IdP Meta Data</asp:Localize>
                        <p class="text-muted" style="font-size: smaller">
                            <asp:Localize meta:resourcekey="str_idtPrvMetXml" runat="server">Identity Provider Metadata in XML Format</asp:Localize>
                        </p>

                    </td>
                </tr>
                <tr>

                    <td style="padding: 15px;padding-top:0px;">
                        <asp:TextBox ID="SAMLIDPMeta" runat="server" Text="" TextMode="MultiLine" Height="300px" CssClass="form-control" BorderStyle="Solid" BorderWidth="1" BorderColor="#f0f0f0"></asp:TextBox>

                    </td>
                </tr>

                <%}%>
                <tr>
                    <td align="right" style="padding-top: 40px;">
                        <asp:LinkButton CssClass="btn btn-default gladbtn" ID="Step2Back" runat="server" OnClick="Step2Back_Click" meta:resourcekey="str_bac">Back</asp:LinkButton>
                        <asp:LinkButton CssClass="btn btn-primary gladbtn" ID="Step2ContinueBtn" runat="server" OnClick="Step2Contine_Click" meta:resourcekey="str_nex">Next</asp:LinkButton>
                        <asp:LinkButton CssClass="btn btn-default gladbtn" ID="LinkButton2" runat="server" OnClientClick="ReturnLast();return false;" meta:resourcekey="str_can">Cancel</asp:LinkButton>
                    </td>
                </tr>
            </table>
        </asp:Panel>
        <asp:Panel ID="Step3Panel" runat="server" Visible="false">
            <table width="100%" style="max-width: 1400px;" align="center">
                <tr>
                    <td style="height: 60px">&nbsp;</td>
                </tr>

                <tr>
                    <td style="padding: 15px; font-size: 18px; color: #565656; font-weight: 100;" colspan="2">
                        <asp:Localize meta:resourcekey="str_ssotext" runat="server">Display text for SSO link</asp:Localize>

                    </td>
                </tr>
                <tr>
                    <td style="padding: 15px; padding-bottom: 30px; padding-top: 0px;" colspan="2">
                        <asp:TextBox ID="SSOName" runat="server" Text="Single Sign On" CssClass="form-control"></asp:TextBox>
                    </td>
                </tr>
                <tr>
                    <td style="padding: 15px; padding-top: 0px; width: 18px;">
                        <asp:CheckBox ID="AddSSOLink" runat="server" />
                    </td>

                    <td style="padding: 15px; padding-top: 0px; font-size: 18px; color: #565656; font-weight: 100;"><asp:Localize runat="server" meta:resourcekey="str_donRedIdpLogPag">Don't redirect to IdP login page automatically</asp:Localize></td>
                </tr>
                <tr>
                    <td colspan="2" style="padding-left: 15px; font-size: 12px; font-weight: 100; color: #565656;">
                        <asp:Localize meta:resourcekey="str_llink" runat="server">if this setting is unchecked, the login page will be redirected to the IdP login page directly</asp:Localize>
                    </td>
                </tr>
                <tr>
                    <td style="padding: 15px; padding-top: 0px; width: 18px;">
                        <asp:CheckBox ID="SAMLAutoCreateUser" runat="server" />
                    </td>
                    <td style="padding: 15px; padding-top: 0px; font-size: 18px; color: #565656; font-weight: 100;">
                        <asp:Label ID="Label3" runat="server" Text="Create User when User Doesn't Exist" meta:resourcekey="asp_crtUsrWhnDntExt"></asp:Label>
                    </td>

                </tr>

                <tr>
                    <td align="right" style="padding-top: 40px;" colspan="2">
                        <asp:LinkButton CssClass="btn btn-default gladbtn" ID="LinkButton1" runat="server" OnClick="Step3Back_Click" meta:resourcekey="str_bac">Back</asp:LinkButton>
                        <asp:LinkButton CssClass="btn btn-primary gladbtn" ID="LinkButton3" runat="server" OnClick="Step3Contine_Click" meta:resourcekey="str_com">Commit</asp:LinkButton>
                        <asp:LinkButton CssClass="btn btn-default gladbtn" ID="LinkButton4" runat="server" OnClientClick="ReturnLast();return false;" meta:resourcekey="str_can">Cancel</asp:LinkButton>
                    </td>
                </tr>

            </table>
        </asp:Panel>


    </div>

    <asp:Localize ID="NOTConfig" meta:resourcekey="str_notconfiged" runat="server" Visible="False">Not Configured</asp:Localize>
    <div style="display: none;">
        <asp:Localize runat="server" ID="LocPlsWat" meta:resourcekey="str_plsWat" Visible="False">Please Wait</asp:Localize>
        <asp:Localize runat="server" ID="LocApyChg" meta:resourcekey="str_apyChg" Visible="False">Applying Changes</asp:Localize>
    </div>
    <asp:Localize meta:resourcekey="str_failedapply" ID="FailedApply" runat="server" Visible="False">Failed to apply changes</asp:Localize>

    <script type="text/javascript">
     
    </script>

</asp:Content>
