﻿<%@ Page Title="Servers" Language="C#" MasterPageFile="../WebAppPanel.master" EnableSessionState="false" 
    AutoEventWireup="true" CodeBehind="ServerShares.aspx.cs" Inherits="GladinetPayFlow.ServerShares" Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
        /*Certain versions of Chrome will always try to autofill the first form field on a page with the saved username for a website
          This behavior ignores the autocomplete property of the field, so a dummy field with zero opacity has been introduced before the search field.*/
        .hiddenCell .bmd-form-group{height:1px !important;width:1px !important;opacity:0 !important;}
       .hiddenDummyFieldForChrome{height:1px !important;width:1px !important;opacity:0 !important;float:left !important;display:block !important;}

       <% if(!m_CanAdd) { %>
       .gladrootbtn.unpublished { opacity: 0.5; }
       .gladrootbtn.unpublished:hover, .gladrootbtn.unpublished:focus { box-shadow: none !important; cursor: default !important; }
       .filerow.unpublished{ cursor: default !important; }
       .filerow.unpublished:hover { background-color: transparent !important; }
       <% } %>
       <% if(!m_CanDelete) { %>
       .gladrootbtn.published { opacity: 0.5; }
       .gladrootbtn.published:hover, .gladrootbtn.published:focus { box-shadow: none !important; cursor: default !important; }
       .filerow.published{ cursor: default !important; }
       .filerow.published:hover { background-color: transparent !important; }
       <% } %>
    </style>
    <script type="text/javascript">
        function ClickSvrShare(rowID) { 
            var svrName = "<%=ServerName.Value%>";
            <% if (m_CanView) { %>
            try {  
                var shareName = $("#shrNme_" + rowID).html();
                var elements = document.getElementsByClassName("gladactiverow");
                if (elements && elements.length != 0) {
                    for (var i = 0; i < elements.length; ++i) {
                        elements[i].className = "";
                    }
                }
            } catch (e) {

            }

            var e = document.getElementById("id_" + shareName);
            e.className = "gladactiverow";
            parent.ClickSvrShare(svrName, shareName);
            <% } %>
        }

        function OnEdit() {
            var e = document.getElementById("DashboardView");
            e.style.display = "none";

            e = document.getElementById("EditView");
            e.style.display = "";

        }

        function CloseEdit() {
            var e = document.getElementById("DashboardView");
            e.style.display = "";

            e = document.getElementById("EditView");
            e.style.display = "none";


        }

        function PublishShare(rowID) {    
            <% if (m_CanAdd) { %>
            var shareName = $("#shrNme_" + rowID).html();
            var b = document.getElementById("ctl00_MainContent_PublishShareBtn");
            var s = document.getElementById("ctl00_MainContent_HiddenShareName");
            s.value = shareName;
            b.click();
            <% } %>
        }
        function onDeleteShare(rowID) {   
            <% if (m_CanDelete) { %>
            var shareName = $("#shrNme_" + rowID).html();
            var b = document.getElementById("ctl00_MainContent_DeleteShareBtn");
            var s = document.getElementById("ctl00_MainContent_ShareName");

            if (confirm("<asp:Localize runat="server" meta:resourcekey="str_wanUnpSha">Do you want to unpublish this share?</asp:Localize>")) {
                s.value = shareName;
                b.click();
            }
            <% } %>
        }

        function ConfirmDelete() {
            <% if (m_CanDelete) { %>
            if (confirm("Confirm delete this server entry?")) {
                return true;
            }
            <% } %>
            return false;
        }

        function OnDeleteThisServer() {
            <% if (m_CanDelete) { %>
            gConfirm("<asp:Localize runat="server" meta:resourcekey="str_waDelSer">Do you want to delete this server entry? All user access will be revoked.</asp:Localize>", "", function (btn, tex) {
                if (btn == 'yes' || btn == 'ok') {
                    var e = document.getElementById("ctl00_MainContent_DeleteBtn");
                    Wait("...");
                    e.click();
                }
            });
            <% } %>
        }


        function DeleteShare(rowID)
        {                        
            <% if (m_CanDelete) { %>
            var shareName = $("#shrNme_" + rowID).html();
            gConfirm("<asp:Localize runat="server" meta:resourcekey="str_wanUnpSha">Do you want to unpublish this share?</asp:Localize>", "", function (btn, tex) {
                if (btn == 'yes' || btn == 'ok') {
                    var e = document.getElementById("ctl00_MainContent_DeleteShareBtn");
                    var s = document.getElementById("ctl00_MainContent_HiddenShareName");
                    s.value = shareName;
                    
                    Wait("...");
                    e.click();
                }
            });
            <% } %>
        }
        function strcontains(s, s1) {
            if (s.toLowerCase().indexOf(s1.toLowerCase()) != -1)
                return true;

            return false;
        }
        function OnSearch() {
            var st = document.getElementById("dummysearchtest");
            var tis = document.getElementsByClassName("shareitem");


            for (i = 0; i < tis.length; ++i) {
                var e = tis[i];
                if (st.value == null || st.value == "") {
                    e.style.display = "";
                } else {
                    if (strcontains(e.title, st.value))
                        e.style.display = "";
                    else
                        e.style.display = "none";
                }
            }
        }
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
<asp:Localize ID="LocNoShaWerFou" meta:resourcekey="str_noShaWerFou" Visible="false" runat="server">No shares were found.</asp:Localize>
<asp:Localize runat="server" ID="LocPasIsMis" meta:resourcekey="str_pasIsMis" Visible="false">Password is missing</asp:Localize>
<asp:Localize runat="server" ID="LocUseNamIsMis" meta:resourcekey="str_useNamIsMis" Visible="false">User name is missing</asp:Localize>
    <asp:Localize ID="LocFldLodShr" meta:resourcekey="str_fldLodShr" runat="server" Visible="false">Failed to load shares</asp:Localize>
    <asp:Localize ID="LocFldPrsShrLst" meta:resourcekey="str_fldPrsShrLst" runat="server" Visible="false">Failed to parse share list</asp:Localize>
    <asp:Localize ID="LocUsrNmeMsg" meta:resourcekey="str_usrNmeMsg" runat="server" Visible="false">User name is missing</asp:Localize>
    <asp:Localize ID="LocPwdMsg" meta:resourcekey="str_pwdMsg" runat="server" Visible="false">Password is missing</asp:Localize>
    <asp:Localize ID="LocAcsDnd" meta:resourcekey="str_acsDnd" runat="server" Visible="false">Access is denied</asp:Localize>
    <asp:Localize ID="LocMsgSrvNme" meta:resourcekey="str_msgSrvNme" runat="server" Visible="false">Missing server name</asp:Localize>
    <asp:Localize ID="LocShaNamEmp" meta:resourcekey="str_shaNamEmp" runat="server" Visible="false">Share name is empty.</asp:Localize>
    <asp:Localize ID="LocFolNamPatEmp" meta:resourcekey="str_folNamPatEmp" runat="server" Visible="false">Folder path is empty.</asp:Localize>
    <asp:Localize ID="LocFolPatConInvCha" meta:resourcekey="str_folPatConInvCha" runat="server" Visible="false">Folder path contains invalid character(s).</asp:Localize>
    <asp:Localize ID="LocSpeLocCanNotVer" meta:resourcekey="str_speLocCanNotVer" runat="server" Visible="false">The specified location cannot be verified</asp:Localize>
    <asp:Localize ID="LocShaSamNamAlrAdd" meta:resourcekey="str_shaSamNamAlrAdd" runat="server" Visible="false">A share with same name was already added</asp:Localize>
    <asp:Localize ID="LocFaiVerSha" meta:resourcekey="str_faiVerSha" runat="server" Visible="false">Failed to verify share</asp:Localize>

    <div class="wrapper" id="DashboardView" style="overflow: auto; width: 100%; padding: 0px;">

        <asp:Panel ID="SharesPanel" runat="server">
            <div style="width: 100%; padding: 5px;border-bottom: 1px solid #cccccc;" >
                <table style="width: 100%" border="0">
                    <tr>
                        <td height="48px">
                            <button class="btn btn-primary gladbtn" style="display: none; font-weight: 400!important; font-size: 20px!important;" onclick="parent.clickSvrs(); return false;"><asp:Localize runat="server" meta:resourcekey="str_ser">Servers</asp:Localize></button>
                            <i class="gladinet-icons " style="margin-top: 8px; display: none; font-size: 18px!important; color: #565656;">&#xDD;</i>
                            <button class="btn btn-primary gladbtn" style="font-weight: 400!important; font-size: 18px!important;" onclick="OnEdit();return false;"><%=ServerDisplayName.Value %></button>
                        </td>
                        <td align="right" style="">
                            <asp:LinkButton CssClass="btn btn-primary gladmbtn" ID="AddToMyServer" runat="server" OnClick="OnAddSvr_Click" meta:resourcekey="str_addSer">Add to my servers</asp:LinkButton>
                        </td>
                        <td style="width:200px;">
                              <div style="padding:3px; border:1px solid #eeeeee; border-radius:15px" class="boxbordercolor">
                                             <table>
                                                 <tr> <td class="hiddenCell"><input type="text" id="user" name="user" class="hiddenDummyFieldForChrome" /></td>
                                                     <td> 
                                                          <input type="text" id="dummysearchtest" name="dummytext" class="form-control" onchange="OnSearch(); "  autocomplete="off" />
                                                     </td>
                                                     <td>
                                                         <i class="btn btn-primary gladmbtn gladinet-icons" style="font-weight: 100!important; font-size: 20px!important;" onclick="OnSearch(); return false;">&#XA7;</i>
                                                     </td>
                                                 </tr>
                                             </table>
                                         </div>
                        </td>
                        <%if (LinkAddShareBtn.Visible){ %>
                        <td align="right" style="width: 60px; height: 48px">
                            <asp:LinkButton CssClass="btn btn-primary gladbtn" ID="LinkAddShareBtn" runat="server" OnClick="AddShareBtn_Click" OnClientClick="Wait('...'); return true;"> 
                            <i class="btn btn-primary gladmbtn gladinet-icons" style="font-weight:400!important; font-size:24px!important;" title="<%=AddShareBtn.Text %>">v</i>

                            </asp:LinkButton>

                        </td>

                        <%}else { %>
                        <td align="right" style="width: 60px; height: 48px">
                            <asp:LinkButton CssClass="btn btn-primary gladbtn" ID="AddVirtualShare" runat="server" OnClick="AddVirtualShareBtn_Click" OnClientClick="Wait('...'); return true;"> 
                            <i class="btn btn-primary gladmbtn gladinet-icons" style="font-weight:400!important; font-size:24px!important;" title="Add subfolder as virtual share">&#xc8;</i>

                            </asp:LinkButton>

                        </td>
                        <%} %>
                        <%if (!AddToMyServer.Visible)
                            { %>
                        <td align="right" style="width: 60px; height: 48px">
                            <i class="btn btn-primary gladmbtn gladinet-icons" style="font-weight: 400!important; font-size: 24px!important;" onclick="OnEdit();return false;">/</i>
                        </td>
                        <%} %>

                        <td align="right" style="width: 40px; padding-right: 10px; height: 48px;">
                            <i class="btn btn-primary gladmbtn gladinet-icons" style="font-weight: 400!important; font-size: 20px!important;" onclick="parent.clickSvrs(); return false;">&#XFB;</i>
                        </td>
                    </tr>
                </table>
            </div>
            <div style="width: 100%; padding: 20px;">
                <%if (SharesRepeater.Items.Count != 0)
                    { %>
                <table width="100%" border="0">
                    <asp:Repeater ID="SharesRepeater" runat="server">
                        <ItemTemplate>
                            <tr style="border-bottom: 1px solid #f0f0f0; ">
                                <td>          
                                    <div id="shrNme_<%# Container.ItemIndex + 1 %>" style="display:none;"><%#DataBinder.Eval(Container.DataItem,"ShareName") %></div>
                                    <div id="dpyShrNme_<%# Container.ItemIndex + 1 %>" style="display:none;"><%#DataBinder.Eval(Container.DataItem,"DisplayShareName") %></div>
                                    <div style="padding: 5px; width: 100%; border-radius: 3px; cursor: pointer;" class="filerow shareitem <%#GetStatus(Container.DataItem, "ShareName") %>" 
                                        title="<%#DataBinder.Eval(Container.DataItem,"ShareName") %> <%#DataBinder.Eval(Container.DataItem,"DisplayShareName") %>"
                                         id="id_<%#DataBinder.Eval(Container.DataItem,"ShareName") %>">
                                        <table width="100%">
                                            <tr>
                                                <td style="padding: 4px; padding-left: 10px; font-size: 14px; color: #404040; font-weight: 100; width: 48px;" valign="middle" onclick='ClickSvrShare(<%# Container.ItemIndex + 1 %>);'>
                                                    <i class="gladinet-icons md-32 md-dark hand" style="margin-top: 8px;"><%#DataBinder.Eval(Container.DataItem,"ShareIcon") %></i>

                                                </td>
                                                <td style="padding: 4px; font-size: 16px; color: #404040; font-weight: 100;" valign="middle" onclick='ClickSvrShare(<%# Container.ItemIndex + 1 %>);'>
                                                    <%#DataBinder.Eval(Container.DataItem,"DisplayShareName") %>
                                                    <div style="font-size: 12px; font-weight: 100; padding: 0px; color: #565656; <%#DataBinder.Eval(Container.DataItem,"UNCStyle") %>">
                                                        <%#DataBinder.Eval(Container.DataItem,"DisplayUNC") %> <%#DataBinder.Eval(Container.DataItem,"Desc") %>
                                                    </div>
                                                </td>
                                                <td style="width:80px" >
                                                    <span class="gladinet-icons gladrootbtn published" style="font-size:48px!important;<%#DataBinder.Eval(Container.DataItem,"PublishShareDisplay") %>" onclick='DeleteShare(<%# Container.ItemIndex + 1 %>);return false;'>&#x15A;</span>
                                                    <span class="gladinet-icons gladrootbtn unpublished" style="font-size:48px!important;<%#DataBinder.Eval(Container.DataItem,"UnPublishShareDisplay") %>" onclick='PublishShare(<%# Container.ItemIndex + 1 %>);'>&#x15B;</span>
                                                </td>
                                            </tr>

                                        </table>
                                    </div>
                                </td>
                                
                                <td style="width:60px;display:none;" valign="middle">
                                                    <i class="btn btn-primary gladmbtn gladinet-icons" style="font-weight: 400!important; font-size: 24px!important;" onclick='DeleteShare(<%# Container.ItemIndex + 1 %>);return false;'>n</i>
                                                </td>
                                
                            </tr>
                        </ItemTemplate>
                    </asp:Repeater>
                </table>
                <%}
                else
                { %>
                <table width="100%" border="0">
                    <tr>
                        <td style="padding: 10px; font-size: 20px; padding-top: 50px; color: #565656; font-weight: 100" align="center">
                            <asp:Label ID="ShareEnumFailed" runat="server" Text="No shares found."></asp:Label>

                        </td>
                    </tr>
                    <tr>
                        <td style="padding: 10px;" align="center">
                            <%if (DeleteBtn.Visible)
                            { %>
                            <span class="btn btn-primary gladmbtn" onclick="OnDeleteThisServer()"><asp:Localize runat="server" meta:resourcekey="str_delThiSer">Delete this server</asp:Localize></span>
                            <%} %>
                            <asp:LinkButton CssClass="btn btn-primary gladbtn" ID="FRefreshBtn" runat="server" OnClick="RefreshBtn_Click" OnClientClick="Wait('...'); return true;" meta:resourcekey="str_ref">Refresh</asp:LinkButton>
                            <asp:LinkButton CssClass="btn btn-primary gladbtn" ID="AddShareBtn" runat="server" OnClick="AddShareBtn_Click" OnClientClick="Wait('...'); return true;" meta:resourcekey="str_addSha">Add Share</asp:LinkButton>
                        </td>
                    </tr>
                </table>
                <%} %>
            </div>
        </asp:Panel>
        <asp:Panel ID="AddVirtualSharePanel" runat="server" Visible="false">
            <table width="100%">
                <tr>
                    <td align="center" style="padding-top: 40px;">

                        <table style="width: 100%; max-width: 800px;">
                            <tr>
                                <td style="padding: 5px; font-size: 18px; font-weight: 100; color: #565656"></td>
                            </tr>
                            <tr>
                                <td height="20px">&nbsp;</td>
                            </tr>
                            <tr>
                                <td style="padding: 5px; font-size: 16px; font-weight: 100; color: #565656"><asp:Localize runat="server" meta:resourcekey="str_virShaNam">Virtual Share Name</asp:Localize></td>
                            </tr>
                            <tr>
                                <td style="padding: 5px; font-size: 16px; font-weight: 100; color: #565656">
                                    <asp:TextBox ID="VirtualShareName" runat="server" CssClass="form-control"></asp:TextBox>
                                </td>
                            </tr>
                            <tr>
                                <td style="padding: 5px; font-size: 16px; font-weight: 100; color: #565656"><asp:Localize runat="server" meta:resourcekey="str_folPatPhyShaNam">Folder Path ({Physical share name}\folder)</asp:Localize></td>
                            </tr>
                            <tr>
                                <td style="padding: 5px; font-size: 16px; font-weight: 100; color: #565656">
                                    <asp:TextBox ID="FolderPath" runat="server" CssClass="form-control"></asp:TextBox>
                                </td>
                            </tr>
                            <tr>
                                <td style="font-size: 16px; font-weight: 100;">
                                    <asp:Label ID="AddVirtualShareError" runat="server" Text="" ForeColor="red"></asp:Label>
                                </td>
                            </tr>
                            <tr>
                                <td align="right" style="padding: 10px">
                                    <table>
                                        <tr>
                                            <td>

                                                <asp:LinkButton CssClass="btn btn-primary gladbtn" ID="ApplyAddVirtualShare" runat="server" OnClick="ApplyAddVirtualShareBtn_Click" OnClientClick="Wait('...'); return true;" meta:resourcekey="str_add">Add</asp:LinkButton>

                                            </td>
                                            <td>
                                                <asp:LinkButton CssClass="btn btn-primary gladbtn" ID="LinkButton2" runat="server" OnClick="CancelAddShareBtn_Click" OnClientClick="Wait('...'); return true;" meta:resourcekey="str_can">Cancel</asp:LinkButton>

                                            </td>
                                        </tr>
                                    </table>
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>
            </table>
        </asp:Panel>
        <asp:Panel ID="AddSharePanel" runat="server" Visible="false">
            <table width="100%">
                <tr>
                    <td align="center" style="padding-top: 40px;">

                        <table style="width: 100%; max-width: 800px;">
                            <tr>
                                <td style="padding: 5px; font-size: 18px; font-weight: 100; color: #565656"><asp:Localize runat="server" meta:resourcekey="str_pleEntShaNamOnl">Please enter the share name only</asp:Localize></td>
                            </tr>
                            <tr>
                                <td height="20px">&nbsp;</td>
                            </tr>
                            <tr>
                                <td style="padding: 5px; font-size: 16px; font-weight: 100; color: #565656"><asp:Localize runat="server" meta:resourcekey="str_shaNam">Share Name</asp:Localize></td>
                            </tr>
                            <tr>
                                <td style="padding: 5px; font-size: 16px; font-weight: 100; color: #565656">
                                    <asp:TextBox ID="ShareName" runat="server" CssClass="form-control"></asp:TextBox>
                                </td>
                            </tr>
                            <tr>
                                <td style="font-size: 16px; font-weight: 100;">
                                    <asp:Label ID="AddShareError" runat="server" Text="" ForeColor="red"></asp:Label>
                                </td>
                            </tr>
                            <tr>
                                <td align="right" style="padding: 10px">
                                    <table>
                                        <tr>
                                            <td>

                                                <asp:LinkButton CssClass="btn btn-primary gladbtn" ID="ApplyAddShareBtn" runat="server" OnClick="ApplyAddShareBtn_Click" OnClientClick="Wait('...'); return true;" meta:resourcekey="str_add">Add</asp:LinkButton>

                                            </td>
                                            <td>
                                                <asp:LinkButton CssClass="btn btn-primary gladbtn" ID="CancelAddShareBtn" runat="server" OnClick="CancelAddShareBtn_Click" OnClientClick="Wait('...'); return true;" meta:resourcekey="str_can">Cancel</asp:LinkButton>

                                            </td>
                                        </tr>
                                    </table>
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>
            </table>
        </asp:Panel>
        <asp:Panel ID="ServerInfoPanel" runat="server" Visible="false">

            <table width="100%">
                <tr>
                    <td align="center" style="padding-top: 40px;">

                        <table style="width: 100%; max-width: 800px;">
                            <tr>
                                <td style="padding: 5px; font-size: 18px; font-weight: 100; color: #565656">
								<asp:Localize runat="server" meta:resourcekey="str_autInfReqEnuSha">Authentication information is required to enumerate shares from server</asp:Localize> (<%=ServerName.Value %>)
                                </td>
                            </tr>
                            <tr>
                                <td height="20px">&nbsp;</td>
                            </tr>
                            <tr>
                                <td style="padding: 5px; font-size: 16px; font-weight: 100; color: #565656"><asp:Localize runat="server" meta:resourcekey="str_useNam">User Name</asp:Localize></td>
                            </tr>
                            <tr>
                                <td style="padding: 5px; font-size: 16px; font-weight: 100; color: #565656">
                                    <asp:TextBox ID="SvrUserName" runat="server" CssClass="form-control"></asp:TextBox>
                                </td>
                            </tr>
                            <tr>
                                <td height="10px">&nbsp;</td>
                            </tr>
                            <tr>
                                <td style="padding: 5px; font-size: 16px; font-weight: 100; color: #565656"><asp:Localize runat="server" meta:resourcekey="str_pas">Password</asp:Localize></td>
                            </tr>
                            <tr>
                                <td style="padding: 5px; font-size: 16px; font-weight: 100; color: #565656">
                                    <asp:TextBox ID="SvrPassword" TextMode="Password" runat="server" CssClass="form-control"></asp:TextBox>
                                </td>
                            </tr>

                            <tr>
                                <td style="padding: 5px; font-size: 16px; font-weight: 100; color: #565656">
                                    <asp:CheckBox ID="SaveAsDefault" runat="server" Checked="false" Text="Save as default" meta:resourcekey="str_savDef" />
                                </td>
                            </tr>

                            <tr>
                                <td height="10px">&nbsp;</td>
                            </tr>
                            <tr>
                                <td style="font-size: 16px; font-weight: 100;">
                                    <asp:Label ID="UserInfoError" runat="server" Text="" ForeColor="red"></asp:Label>
                                </td>
                            </tr>
                            <tr>
                                <td align="right" style="padding: 10px">
                                    <table width="100%">
                                        <tr>
                                            <td>
                                                <%if (DeleteBtn.Visible)
                                                { %>
                                                <div class="btn btn-primary gladmbtn" onclick="OnDeleteThisServer()"><asp:Localize runat="server" meta:resourcekey="str_delThiSer">Delete this server</asp:Localize></div>
                                                <%} %>
                                            </td>
                                            <td align="right">

                                                <asp:LinkButton CssClass="btn btn-primary gladbtn" ID="ApplyUserInfoBtn" runat="server" OnClick="ApplyUserInfoBtn_Click" meta:resourcekey="str_app">Apply</asp:LinkButton>
                                            </td>
                                        </tr>
                                    </table>
                                </td>
                            </tr>

                        </table>
                    </td>
                </tr>
            </table>
        </asp:Panel>


    </div>

    <div id="EditView" style="overflow: auto; width: 100%; padding: 0px; display: none;">
        <table width="100%">
            <tr>
                <td style="padding-top: 40px; font-size: 16px; font-weight: 100;" align="center">
                    <table style="width: 100%; max-width: 800px">
                        <tr>
                            <td style="font-size: 20px; color: #404040; padding-bottom: 20px;"><asp:Localize runat="server" meta:resourcekey="str_edi">Edit</asp:Localize> <%=ServerName.Value %>

                            </td>
                        </tr>
                        <tr>
                            <td style="padding: 5px; padding-bottom: 0px">
                                <asp:Label ID="EditErrorMsg" runat="server" Text="" ForeColor="Red"></asp:Label>
                            </td>
                        </tr>

                        <tr>
                            <td style="padding: 5px; padding-bottom: 0px"><asp:Localize runat="server" meta:resourcekey="str_disNam">Display Name</asp:Localize></td>
                        </tr>
                        <tr>
                            <td style="padding: 5px; padding-top: 0px">
                                <asp:TextBox ID="EditDisplayName" runat="server" CssClass="form-control"></asp:TextBox>
                            </td>
                        </tr>




                        <tr>
                            <td style="padding: 5px; padding-bottom: 0px; padding-top: 20px;"><asp:Localize runat="server" meta:resourcekey="str_fqd">FQDN</asp:Localize></td>
                        </tr>
                        <tr>
                            <td style="padding: 5px; padding-top: 0px">
                                <asp:TextBox ID="EditFQDN" runat="server" CssClass="form-control"></asp:TextBox>
                            </td>
                        </tr>

                        <tr>
                            <td style="padding: 5px; padding-bottom: 0px; padding-top: 20px;"><asp:Localize runat="server" meta:resourcekey="str_des">Description</asp:Localize></td>
                        </tr>
                        <tr>
                            <td style="padding: 5px; padding-top: 0px">
                                <asp:TextBox ID="EditDesc" runat="server" CssClass="form-control"></asp:TextBox>
                            </td>
                        </tr>

                        <%if (!m_HideDefaultCredentialsOption) { %>
                        <tr>
                            <td style="padding: 5px; padding-bottom: 0px; padding-top: 20px;">
                                <asp:CheckBox ID="UseDefaultCred" runat="server" Text="Use default credentials to access" AutoPostBack="true" OnCheckedChanged="OnChange_Click" />
                            </td>
                        </tr>                        
                        <% } else { %>
                        <tr>
                            <td style="padding: 5px; padding-bottom: 0px; padding-top: 20px;font-size:16px;color:#404040;"><asp:Localize runat="server" meta:resourcekey="str_creUseAccSer">Credentials used to access the server</asp:Localize></td>
                        </tr>          
                        <% } %>
                        <%if (!UseDefaultCred.Checked) { %>
                        <tr>
                            <td style="padding: 5px; padding-bottom: 0px; padding-top: 20px;"><asp:Localize runat="server" meta:resourcekey="str_useNam">User Name</asp:Localize></td>
                        </tr>
                        <tr>
                            <td style="padding: 5px; padding-top: 0px">
                                <asp:TextBox ID="EditUserName" runat="server" CssClass="form-control"></asp:TextBox>
                            </td>
                        </tr>

                        <tr>
                            <td style="padding: 5px; padding-bottom: 0px; padding-top: 20px;"><asp:Localize runat="server" meta:resourcekey="str_pas">Password</asp:Localize></td>
                        </tr>
                        <tr>
                            <td style="padding: 5px; padding-top: 0px">
                                <asp:TextBox ID="EditPassword" runat="server" TextMode="Password" CssClass="form-control"></asp:TextBox>
                            </td>
                        </tr>
                        <%} %>
                        <tr>
                            <td align="right" style="padding-top: 40px;">
                                <table width="100%">
                                    <tr>
                                        <td>

                                            <%if (DeleteBtn.Visible)
                                            { %>
                                            <div class="btn btn-primary gladmbtn" onclick="OnDeleteThisServer()"><asp:Localize runat="server" meta:resourcekey="str_delThiSer">Delete this server</asp:Localize></div>
                                            <%} %>


                                        </td>
                                        <td align="right">
                                            <asp:Button ID="Button1" runat="server"
                                                Text="Save" OnClick="OnSaveSettings_Click" CssClass="btn btn-primary gladmbtn"
                                                meta:resourcekey="Button1Resource1" />
                                            <button class="btn btn-default gladmbtn" onclick="CloseEdit(); return false;"><asp:Localize runat="server" meta:resourcekey="str_clo">Close</asp:Localize></button>

                                        </td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>
    </div>

    <div style="display: none;">
        <asp:LinkButton ID="RefreshBtn" runat="server" OnClick="RefreshBtn_Click" meta:resourcekey="str_ref">Refresh</asp:LinkButton>
        <asp:HiddenField ID="ServerName" runat="server" />
        <asp:HiddenField ID="HiddenShareName" runat="server" />
        <asp:HiddenField ID="ServerDisplayName" runat="server" />
        <asp:Button ID="DeleteBtn" runat="server" Text="Delete this server" OnClick="OnDelete_Click" CssClass="btn btn-primary gladmbtn" meta:resourcekey="Button1Resource1" />
        <asp:Button ID="DeleteShareBtn" runat="server" Text="Delete this server" OnClick="OnDeleteShare_Click" CssClass="btn btn-primary gladmbtn" meta:resourcekey="Button1Resource1" />
        <asp:Button ID="PublishShareBtn" runat="server" Text="publish share" OnClick="PublishShare_Click" CssClass="btn btn-primary gladmbtn" meta:resourcekey="Button1Resource1" />
    </div>
    <script type="text/javascript">
        var oldOnload = window.onload;
        window.onload = function () {   
            try{    
                if (oldOnload) oldOnload(); 
            } catch(ex) {}    
            try{         
                 <%if (m_RedirectToServers) {%>    
                parent.clickSvrs();
                <%}%>
                <%if (m_InEdit) {%>
                OnEdit();
                 <%}%>
            } catch(ex) {
                console.log("ex1:"+ex);
            }                
            try{          
                var e = document.getElementById("dummysearchtest");
                e.value = "";  
            } catch(ex) {
                console.log("ex2:"+ex);
            }           
            try{       
                parent.SetCurrentRelativeTitle("<%=ServerDisplayName.Value%>");
            } catch(ex) {
                console.log("ex3:"+ex);
            }   
        }

    </script>
</asp:Content>
