﻿<%@ Page Title="Servers" Language="C#" MasterPageFile="../WebAppPanel.master" EnableSessionState="false" 
    AutoEventWireup="true" CodeBehind="PublishedShares.aspx.cs" Inherits="GladinetPayFlow.PublishedShares" Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style>
        div.description { font-size:16px !important;color:#565656 !important;display:block;line-height:16px;display:block;padding-left:2px;}
    </style>
    <script type="text/javascript">
        
        var oldOnload = window.onload;
        window.onload = function () {
            if (oldOnload) oldOnload();  
            if (!parent.ClickSvrShare) {
                if (parent.parent.ClickSvrShare){ 
                    //reload page in higher frame to correct breadcrums and prevent page from being nested too deeply
                    try {
                        parent.parent.document.getElementById("pshares_menu").click(); 
                    } catch (ex) {
                        console.log("Couldn't reload page in higher frame. Ex:" + ex);
                    }
                }
            }  
        }

        function ClickSvrShare(rowID) {
            <% if (mCanView) { %>
            var svrName = $("#svrNme_" + rowID).text();
            var shareName = $("#shrNme_" + rowID).text();
            var dname = $("#dpyShrNme_" + rowID).text();
            if (parent.ClickSvrShare) {
                parent.ClickSvrShare("{CloudFileServer}", shareName, dname);
            } else if (parent.parent.ClickSvrShare){ 
                parent.parent.ClickSvrShare("{CloudFileServer}", shareName, dname);
            }
            <% } %>
        }

        function onEditShare(rowID) {
            <% if (mCanEdit) { %>
            var shareName = $("#shrNme_" + rowID).text();
            window.location = "AddCloudShare.aspx?vdid=<%=SessionDomainId%>&f=" + encodeURIComponent(shareName);
            <% } %>
        }

        function onEditFileShare(rowID) {
            <% if (mCanEdit) { %>
            var shareName = $("#shrNme_" + rowID).text();
            var b = document.getElementById("ctl00_MainContent_EditShareBtn");
            var s = document.getElementById("ctl00_MainContent_ShareName");
            s.value = shareName;
            b.click();
            Wait();
            <% } %>

        }

        function onDeleteShare(rowID) {
            <% if (mCanDelete) { %>
            var shareName = $("#shrNme_" + rowID).text();
            var serverName = $("#svrNme_" + rowID).text();
            var b = document.getElementById("ctl00_MainContent_DeleteShareBtn");
            var s = document.getElementById("ctl00_MainContent_ShareName");   
            var sn = document.getElementById("ctl00_MainContent_ServerName");

            if (confirm("Confirm unpublish this share?")) {
                s.value = shareName;
                sn.value = serverName;
                b.click();
                Wait();
            }
            <% } %>
        }
        function onAssignDriveLetter(rowID) {
            var shareName = $("#shrNme_" + rowID).text();
            var mountDrive = $("#mntDrv_" + rowID).text();
            var s = document.getElementById("ctl00_MainContent_ShareName");
            s.value = shareName;

            s = document.getElementById("ctl00_MainContent_ShareMountDrive");
            s.value = mountDrive;
            
            $('#myModal').modal({ backdrop: 'static', keyboard: false });
        }

        function OnEdit() {
            <% if (mCanEdit) { %>
            var e = document.getElementById("DashboardView");
            e.style.display = "none";

            e = document.getElementById("EditView");
            e.style.display = "";
            <% } %>

        }

        function CloseEdit() {
            var e = document.getElementById("DashboardView");
            e.style.display = "";

            e = document.getElementById("EditView");
            e.style.display = "none";


        }

        function OnAddNewShare() {
            <% if (mCanAdd) { %>
            Wait();
            window.location = "AddShareName.aspx?vdid=<%=SessionDomainId%>";
            <% } %>
        }

        function ConfirmDelete() {
            if (confirm("Confirm delete this server entry?")) {
                return true;
            }

            return false;
        }

        function strcontains(s, s1)
        {
            if (s.toLowerCase().indexOf(s1.toLowerCase()) != -1)
                return true;

            return false;
        }

        function OnDriveSettings() {
            $('#sModal').modal({ backdrop: 'static', keyboard: false });
        }
        function OnSearch() {
            var st = document.getElementById("searchtext");
            var tis = document.getElementsByClassName("shareitem");


            for (i = 0; i < tis.length; ++i) {
                var e = tis[i];
                if (st.value == null || st.value == "") {
                    e.style.display = "";
                } else {
                    if (strcontains(e.title, st.value))
                        e.style.display = "";
                    else
                        e.style.display = "none";
                }
            }
        }
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
<asp:Localize runat="server" ID="LocShaNotFou" meta:resourcekey="str_shaNotFou" Visible="false">share not found</asp:Localize>
    <asp:Localize ID="LocFldLodShr" meta:resourcekey="str_fldLodShr" runat="server" Visible="false">Failed to load shares</asp:Localize>
    <asp:Localize ID="LocFldPrsShrLst" meta:resourcekey="str_fldPrsShrLst" runat="server" Visible="false">Failed to parse share list</asp:Localize>
    <asp:Localize ID="LocUsrNmeMsg" meta:resourcekey="str_usrNmeMsg" runat="server" Visible="false">User name is missing</asp:Localize>
    <asp:Localize ID="LocPwdMsg" meta:resourcekey="str_pwdMsg" runat="server" Visible="false">Password is missing</asp:Localize>
    <asp:Localize ID="LocAcsDnd" meta:resourcekey="str_acsDnd" runat="server" Visible="false">Access is denied</asp:Localize>
    <asp:Localize ID="LocMsgSrvNme" meta:resourcekey="str_msgSrvNme" runat="server" Visible="false">Missing server name</asp:Localize>
 
<asp:Localize ID="LocNoShaWerFou" meta:resourcekey="str_noShaWerFou" runat="server" Visible="False">No shares were found.</asp:Localize>
<asp:Localize ID="LocDriLetConOptSav" meta:resourcekey="str_driLetConOptSav" runat="server" Visible="False">drive letter confliction option saved.</asp:Localize>
<asp:Localize ID="LocHomDriLetChaTo" meta:resourcekey="str_homDriLetChaTo" runat="server" Visible="False">Mounted drive letter changed to:</asp:Localize>
<asp:Localize ID="LocDriSetSav" meta:resourcekey="str_driSetSav" runat="server" Visible="False">drive settings saved.</asp:Localize>
<asp:Localize ID="LocMtdDrv" meta:resourcekey="str_mtdDrv" runat="server" Visible="False">Mounted Drive</asp:Localize>
    <div class="wrapper" id="DashboardView" style="overflow: auto; width: 100%; padding: 0px;">

        <asp:Panel ID="SharesPanel" runat="server">
            <div style="width: 100%; padding: 5px; border-bottom: 1px solid #f0f0f0 ;" class="meubardrop1">
                <table style="width: 100%" border="0">
                    <tr>
                        <td>
                            <span class="gladbtn" style="font-weight: 400!important; font-size: 20px!important; text-transform: uppercase; color:#808080!important;"><asp:Localize runat="server" meta:resourcekey="str_pubSha">Published Shares</asp:Localize></span>
                        </td>
                        <td height="48px"></td>
                        <td align="right" style=" height: 48px" valign="middle"></td>
                        <td align="right" style="display:none;width: 40px; padding-right: 10px; height: 48px;">
                            <i class="btn btn-primary gladmbtn gladinet-icons" style="font-weight: 400!important; font-size: 20px!important;" onclick="parent.OnDashboard(); return false;">&#XFB;</i>
                        </td>
                    </tr>
                 
                </table>
            </div>
            <div style="width: 100%; padding: 0px;padding-top:0px;">
                <%if (SharesRepeater.Items.Count != 0)
                    { %>
                <table width="100%" border="0">
                      <tr>
                        <td style="width: 100%; padding: 5px; border-bottom: 1px solid #cccccc;" >
                            <table >
                                <%if (mCanAdd){ %>
                                <tr>
                                    <td style="padding: 5px; padding-right:10px;border-right: 1px solid #f0f0f0" valign="middle">
                                        <asp:LinkButton CssClass="btn btn-primary gladbtn" ID="LinkButton2" runat="server" OnClientClick="OnAddNewShare(); return false;" meta:resourcekey="str_addSha">Add a Share</asp:LinkButton>
                                    </td>
                                    <%if(!IsMobile()){ %>
                                    <td style="padding: 5px; padding-left:10px;padding-right:10px;border-right: 1px solid #f0f0f0" valign="middle">
                                        <table width="100%" >
                                            <tr>
                                                
                                                <td style="color: #565656; font-weight: 100; font-size: 16px;" valign="middle">
                                                    <span  style="color: #202020; cursor: pointer;" ><asp:Localize runat="server" meta:resourcekey="str_homDri">Mounted drive:</asp:Localize></span>
                                                </td>
                                                <td width="55px" valign="middle" style="padding-left:10px; overflow:hidden;">
                                                     <asp:DropDownList ID="MappedDriveName" runat="server" CssClass="browser-default custom-select secsubbordercolor" meta:resourcekey="MappedDriveNameResource1"  width="70px" OnSelectedIndexChanged="MappedDriveName_SelectedIndexChanged" AutoPostBack="true">
                                                    </asp:DropDownList>
                                                </td>
                                            </tr>
                                        </table>
                                    </td>
                                    <td style="padding: 5px; padding-left:10px;padding-right:10px;  border-right: 1px solid #f0f0f0" valign="middle">
                                        <table width="100%" >
                                            <tr>
                                                
                                                <td style="color: #565656; font-weight: 100; font-size: 16px;" valign="middle">
                                                    <span  style="color: #202020; cursor: pointer;" ><asp:Localize runat="server" meta:resourcekey="str_mouEacShaSepDri">Mount each share as a separate drive letter:</asp:Localize></span>
                                                </td>
                                                <td  valign="middle" style="padding-left:10px; " valign="middle">
                                                    <div style="">
                                                    <%if (ShareDrive){ %>
                                                    <asp:LinkButton CssClass="nopadding" ID="DisableShareDrive" runat="server" OnClick="DisableShareDrive_Click"><span class="gladinet-icons gladrootbtn" style="font-size:48px!important; margin-top:4px;">&#x15A;</span></asp:LinkButton>
                                                    <%}else{ %>
                                                    <asp:LinkButton CssClass="nopadding" Font-Size="64px" ID="EnableShareDrive" runat="server" OnClick="EnableShareDrive_Click"><span class="gladinet-icons gladrootbtn" style="font-size:48px!important">&#x15B;</span></asp:LinkButton>
                                                    <%} %>
                                                        </div>
                                                </td>
                                            </tr>
                                            <%if (ShareDrive){ %>
                                            <tr>
                                                
                                                <td style="color: #565656; font-weight: 100; font-size: 16px;text-align:right;" valign="middle">
                                                    <span  style="color: #202020; cursor: pointer;" ><asp:Localize runat="server" meta:resourcekey="str_hdeMtdDrv">Hide Mounted Drive:</asp:Localize></span>
                                                </td>
                                                <td  valign="middle" style="padding-left:10px; " valign="middle">
                                                    <%if (HideHomeDrive){ %>
                                                    <asp:LinkButton CssClass="nopadding" ID="EnabledHideHomeDrive" runat="server" OnClick="DisableHideHomeDrive_Click"><span class="gladinet-icons gladrootbtn" style="font-size:48px!important; margin-top:4px;">&#x15A;</span></asp:LinkButton>
                                                    <%}else{ %>
                                                    <asp:LinkButton CssClass="nopadding" Font-Size="64px" ID="DisabledHideHomeDrive" runat="server" OnClick="EnableHideHomeDrive_Click"><span class="gladinet-icons gladrootbtn" style="font-size:48px!important">&#x15B;</span></asp:LinkButton>
                                                    <%} %>
                                                </td>
                                            </tr>
                                            <%} %>
                                        </table>
                                    </td>
                                    <td style="padding: 5px; padding-left:10px;padding-right:10px;border-right: 1px solid #f0f0f0" valign="middle">
                                         <div style="padding:3px; border:1px solid #eeeeee; border-radius:15px" class="boxbordercolor">
                                             <table>
                                                 <tr>
                                                     <td>
                                                          <input type="text" id="searchtext" class="form-control" onchange="OnSearch(); " />
                                                     </td>
                                                     <td>
                                                         <i class="btn btn-primary gladmbtn gladinet-icons" style="font-weight: 100!important; font-size: 20px!important;" onclick="OnSearch(); return false;">&#XA7;</i>
                                                     </td>
                                                 </tr>
                                             </table>
                                         </div>
                                    </td>
                                    <%if (ShareDrive){ %>
                                    <td style="padding: 5px; padding-left:10px;padding-right:10px;border-right: 0px solid #f0f0f0" valign="middle">
                                         <span class="btn btn-primary gladmbtn gladinet-icons" style="font-weight: 100!important; font-size: 32px!important;" onclick="OnDriveSettings(); return false;"  title="Settings">g</span>
                                    </td>
                                     
                                    <%} %>
                                    <%} %>
                                </tr>
                                <% } %>
                            </table>
                        </td>
                    </tr>
                    <asp:Repeater ID="SharesRepeater" runat="server">
                        <ItemTemplate>
                            <tr>
                                <td>
                                    <div style="padding: 5px; width: 100%; border-radius: 3px; border-bottom: 1px solid #dddddd; cursor: pointer;" 
                                        title="<%#DataBinder.Eval(Container.DataItem,"ShareName") %> <%#DataBinder.Eval(Container.DataItem,"DisplayShareName") %>"
                                        class="shareitem" id="id_<%#DataBinder.Eval(Container.DataItem,"ShareName") %> ">
                                        <table width="100%">
                                            <tr>
                                                <td style="padding: 4px; padding-left: 10px; font-size: 14px; color: #404040; font-weight: 100; width:60px;" valign="middle" >
                                                    <i class="gladinet-icons md-32 md-dark hand" style="margin-top: 8px;"><%#DataBinder.Eval(Container.DataItem,"ShareIcon") %></i>

                                                </td>
                                                <td style="padding: 4px; font-size: 22px; color: black; font-weight: 200;" valign="middle" >
                                                    <div id="svrNme_<%# Container.ItemIndex + 1 %>" style="display:none;"><%#DataBinder.Eval(Container.DataItem,"ServerName") %></div>   
                                                    <div id="shrNme_<%# Container.ItemIndex + 1 %>" style="display:none;"><%#DataBinder.Eval(Container.DataItem,"ShareName") %></div>
                                                    <div id="dpyShrNme_<%# Container.ItemIndex + 1 %>" style="display:none;"><%#DataBinder.Eval(Container.DataItem,"DisplayShareName") %></div>
                                                    <div id="mntDrv_<%# Container.ItemIndex + 1 %>" style="display:none;"><%#DataBinder.Eval(Container.DataItem,"MountDrive") %></div>

                                                    <span onclick='ClickSvrShare(<%# Container.ItemIndex + 1 %>);' class="toolnavbtn iconviewitemcolor hand" style="padding: 3px; color:#565656!important;">
                                                    <%#DataBinder.Eval(Container.DataItem,"DisplayShareName") %>
                                                        </span>
                                                    <span onclick='ClickSvrShare(<%# Container.ItemIndex + 1 %>);'>
                                                    <%#DataBinder.Eval(Container.DataItem,"Desc2") %>
                                                    </span>   
                                                    <%if (!IsMobile()){ %>
                                                    <div>
                                                        <span style="font-size: 12px; font-weight: 100; padding: 3px; color: #565656; <%#DataBinder.Eval(Container.DataItem,"UNCStyle") %>"><b style="<%#DataBinder.Eval(Container.DataItem,"UNCTextStyle") %>">UNC Path:</b> <%#DataBinder.Eval(Container.DataItem,"Desc") %></span>
                                                        <span style="font-size: 12px; font-weight: 100; padding: 0px; color: #565656;"><%#DataBinder.Eval(Container.DataItem,"DisplayUNC") %>&nbsp; &nbsp;<b><asp:Localize runat="server" meta:resourcekey="str_Ser">Server:</asp:Localize></b><%#DataBinder.Eval(Container.DataItem,"DisplayServerName") %></span>
                                                    </div>
                                                    <%} %>
                                                    <div style="padding-top:5px;font-size:16px;">
                                                        
                                                         <%if (mCanView){ %>
                                                        <span onclick='ClickSvrShare(<%# Container.ItemIndex + 1 %>);' class="toolnavbtn iconviewitemcolor hand secsubbordercolor" style="padding: 5px; border:1px solid #f0f0f0; border-radius:4px;">
                                                             <i class="gladinet-icons md-16 iconviewitemcolor hand center">c</i>
                                                             <span style="padding-left: 1px; color: #565656; font-weight: 100;" class="sectextcolor"><asp:Localize runat="server" meta:resourcekey="str_man">Manage</asp:Localize></span>
                                                          </span>
                                                         <% } %>
                                                         <%if (mCanEdit){ %>
                                                        <span onclick='onEditFileShare(<%# Container.ItemIndex + 1 %>); return false;' class="toolnavbtn iconviewitemcolor hand secsubbordercolor" style="padding: 5px;margin-left:30px; border:1px solid #f0f0f0; border-radius:4px;  font-size:16px;">
                                                             <i class="gladinet-icons md-16 iconviewitemcolor hand center" style="padding-right:3px;">/</i>Edit Share                                                      
                                                          </span>
                                                         <% } %>
                                                         <%if (mCanDelete){ %>
                                                        <span onclick='onDeleteShare(<%# Container.ItemIndex + 1 %>); return false;' class="toolnavbtn iconviewitemcolor hand secsubbordercolor" style="padding: 5px;margin-left:30px;border:1px solid #f0f0f0; border-radius:4px;">
                                                             <i class="gladinet-icons md-16 iconviewitemcolor hand center">&#XFB;</i>
                                                             <span style="padding-left: 1px; color: #565656; font-weight: 100; " class="sectextcolor"><asp:Localize runat="server" meta:resourcekey="str_unp">Unpublish</asp:Localize></span>
                                                          </span>
                                                         <% } %>
                                                         <%if (mCanEdit && ShareDrive && !IsMobile()){ %>
                                                        <span style="padding: 5px;margin-left:30px;border:1px solid #f0f0f0; border-radius:4px;" class="toolnavbtn iconviewitemcolor hand secsubbordercolor" onclick='onAssignDriveLetter(<%# Container.ItemIndex + 1 %>);' >
                                                            <i class="gladinet-icons md-16 iconviewitemcolor hand center">/</i>
                                                            <span style="padding-left: 1px; color: #565656; font-weight: 100;" class="sectextcolor"><asp:Localize runat="server" meta:resourcekey="str_driLet">Drive Letter:</asp:Localize></span>
                                                            <span style="padding-left: 1px; color: #202020; font-weight: 200;" ><%#DataBinder.Eval(Container.DataItem,"MountDriveLabel") %></span>
                                                        </span>
                                                        <%} %>
                                                    </div>
                                                </td>
                                                <td style="padding: 4px; width: 90px; display:none;" align="right">
                                                    <i class="btn btn-primary gladmbtn gladinet-icons" style="font-weight: 400!important; display: none; font-size: 24px!important;" onclick='onEditShare(<%# Container.ItemIndex + 1 %>); return false;'>/</i> &nbsp;&nbsp;
                                <i class="btn btn-primary gladmbtn gladinet-icons" style="font-weight: 400!important; font-size: 24px!important;" onclick='onDeleteShare(<%# Container.ItemIndex + 1 %>); return false;'>&#XFB;</i>
                                                </td>
                                            </tr>

                                        </table>
                                    </div>
                                </td>
                            </tr>
                        </ItemTemplate>
                    </asp:Repeater>
                </table>
                <%}
                else
                { %>
                <table width="100%" border="0">
                    <tr>
                        <td style="padding: 10px; font-size: 20px; padding-top: 50px; font-weight: 400;color: #808080 !important;" align="center">
                            <asp:Label ID="ShareEnumFailed" runat="server" Text="You don't have any share published yet."></asp:Label>

                        </td>
                    </tr>
                    <tr>
                        <td style="padding: 10px;" align="center">
                            <asp:LinkButton CssClass="btn btn-primary gladbtn" ID="AddNewShare" runat="server" OnClientClick="OnAddNewShare(); return false;" meta:resourcekey="str_pubASha">Publish a Share</asp:LinkButton>
                            <asp:LinkButton CssClass="btn btn-primary gladbtn" ID="FRefreshBtn" runat="server" OnClick="RefreshBtn_Click" OnClientClick="Wait('...'); return true;" meta:resourcekey="str_ref">Refresh</asp:LinkButton>
                        </td>
                    </tr>
                </table>
                <%} %>
            </div>
        </asp:Panel>




    </div>
    <div id="myModal" class="modal fade" role="dialog">
                
        <div class="modal-dialog">
           
            <div class="modal-content" style="width: 600px;">
                <div class="modal-header" style="display:none;">
                                       

                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <div class="modal-body">
                    <table width=100%>
                <tr>
                <td style="font-size:16px; font-weight:100; color:#202020;" >
                    <asp:Localize runat="server" meta:resourcekey="str_driLet">Drive Letter</asp:Localize>
                    <p style="font-size:12px; color:#565656; font-weight:100;"><asp:Localize runat="server" meta:resourcekey="str_thiDriLetShaWil">This is the drive letter the share will be mounted. if no drive letter assigned the share will appear as a root folder in the mounted drive.</asp:Localize></p>
                </tr><tr>
                <td align="center">
                    <asp:DropDownList ID="ShareMountDrive" runat="server" CssClass="browser-default custom-select secsubbordercolor"   width="140px">
                                                    </asp:DropDownList>
                </td>
                </tr>
               
                </table>
                    
                </div>
                <div class="modal-footer">
                                                    <asp:Button ID="ApplyDriveLetter" runat="server" meta:resourcekey="str_app" Text="Apply" CssClass="btn btn-primary gladbtn"
                                    OnClick="ApplyDriveLetter_Click" OnClientClick="Wait('Uploading');" />

                    <button type="button" class="btn btn-default" data-dismiss="modal"><asp:Localize runat="server" meta:resourcekey="str_can">Cancel</asp:Localize></button>
                </div>
            </div>
        </div>
    </div>
    <div id="sModal" class="modal fade" role="dialog">
                
        <div class="modal-dialog">
           
            <div class="modal-content" style="width: 600px;">
                <div class="modal-header" style="display:none;">
                                       

                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <div class="modal-body">
                    <table width="100%">
                        <tr>
                             <td style="padding: 5px; padding-left:10px;padding:10px;border-right: 0px solid #f0f0f0" valign="middle">
                                          <table width="100%" >
                                            <tr>
                                                
                                                <td style="color: #565656; font-weight: 100; font-size: 16px;" valign="middle">
                                                    <span  style="color: #202020; cursor: pointer;" ><asp:Localize runat="server" meta:resourcekey="str_wheDriLetNotAva">When drive letter is not available:</asp:Localize></span>
                                                </td>
                                                </tr><tr>
                                                <td  valign="middle" style="padding-left:10px; overflow:hidden;">
                                                     <asp:DropDownList ID="DriveLetterConflictOption" runat="server" CssClass="browser-default custom-select secsubbordercolor" >
                                                    </asp:DropDownList>
                                                </td>
                                            </tr>
                                        </table>

                                    </td>
                        </tr>
                        <tr>
                             <td style="padding: 5px; padding-left:10px;padding:10px;border-right: 0px solid #f0f0f0" valign="middle">
                                             <table >
                                            <tr>
                                                
                                                <td style="color: #565656; font-weight: 100; font-size: 16px;" valign="middle">
                                                    <span  style="color: #202020; cursor: pointer;" ><asp:Localize meta:resourcekey="str_useShaUncAsDriLab" runat="server">Use share UNC as drive label</asp:Localize></span>
                                                </td>
                                                
                                                <td  valign="middle" style="padding:10px; overflow:hidden; ">
                                                    <asp:CheckBox ID="UNCDriveLabel" runat="server" Checked="true"/>
                                                </td>
                                            </tr>
                                        </table>

                              </td>
                        </tr>
               
                </table>
                    
                </div>
                <div class="modal-footer">
                                                    <asp:Button ID="Button1" runat="server" meta:resourcekey="str_app" Text="Apply" CssClass="btn btn-primary gladbtn"
                                    OnClick="ApplyDriveSettings_Click" OnClientClick="Wait('Uploading');" />

                    <button type="button" class="btn btn-default" data-dismiss="modal"><asp:Localize runat="server" meta:resourcekey="str_can">Cancel</asp:Localize></button>
                </div>
            </div>
        </div>
    </div>

    <div class="alert alert-success" role="alert" style="position:absolute!important; top:10px;right:50%; border-radius:3px;display:none;" id="alertdiv">
        <asp:Label ID="AlertMessage" runat="server" Text=""></asp:Label>
    </div>
    <div style="display: none;">
        <asp:LinkButton ID="RefreshBtn" runat="server" OnClick="RefreshBtn_Click" meta:resourcekey="str_ref">Refresh</asp:LinkButton>    
        <asp:HiddenField ID="ShareName" runat="server" /> 
        <asp:HiddenField ID="ServerName" runat="server" />
        <asp:LinkButton ID="DeleteShareBtn" runat="server" OnClick="DeleteShareBtn_Click" meta:resourcekey="str_ref">Refresh</asp:LinkButton>
        <asp:LinkButton ID="EditShareBtn" runat="server" OnClick="EditShareBtn_Click" meta:resourcekey="str_ref">Refresh</asp:LinkButton>
        <asp:Label ID="ErrorMsg" runat="server" Text=""></asp:Label>
    </div>
    <script type="text/javascript">
        function DisplayError() {

            var d = document.getElementById("ctl00_MainContent_ErrorMsg");
            try{
                if (d) {
                    if (d.innerHTML != "") {
                        gConfirm("", d.innerHTML);
                    }
                }
            } catch (e) {

            }
            
            d = document.getElementById("ctl00_MainContent_AlertMessage");
            
            if (d) {
                if (d.innerHTML != "") {
                    d = document.getElementById("alertdiv");
                    d.style.display = "";
                    setTimeout(function () {
                        d.style.display = "none";
                    }, 3000);

                }
            }
            
            

        }
        DisplayError();
    </script>
</asp:Content>
