﻿<%@ Page Title="Reset Password" Language="C#" MasterPageFile="~/WebAppPanel.master" EnableSessionState="false" 
    AutoEventWireup="true" CodeBehind="MResetUserPassword.aspx.cs" Inherits="GladinetPayFlow.MResetUserPassword" culture="auto" meta:resourcekey="PageResource1" uiculture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
 <script type="text/javascript">
     
     var Base64 = {

         // private property
         _keyStr: "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=",

         // public method for encoding
         encode: function (input) {
             var output = "";
             var chr1, chr2, chr3, enc1, enc2, enc3, enc4;
             var i = 0;

             input = Base64._utf8_encode(input);

             while (i < input.length) {

                 chr1 = input.charCodeAt(i++);
                 chr2 = input.charCodeAt(i++);
                 chr3 = input.charCodeAt(i++);

                 enc1 = chr1 >> 2;
                 enc2 = ((chr1 & 3) << 4) | (chr2 >> 4);
                 enc3 = ((chr2 & 15) << 2) | (chr3 >> 6);
                 enc4 = chr3 & 63;

                 if (isNaN(chr2)) {
                     enc3 = enc4 = 64;
                 } else if (isNaN(chr3)) {
                     enc4 = 64;
                 }

                 output = output +
        this._keyStr.charAt(enc1) + this._keyStr.charAt(enc2) +
        this._keyStr.charAt(enc3) + this._keyStr.charAt(enc4);

             }

             return output;
         },

         // public method for decoding
         decode: function (input) {
             var output = "";
             var chr1, chr2, chr3;
             var enc1, enc2, enc3, enc4;
             var i = 0;

             input = input.replace(/[^A-Za-z0-9\+\/\=]/g, "");

             while (i < input.length) {

                 enc1 = this._keyStr.indexOf(input.charAt(i++));
                 enc2 = this._keyStr.indexOf(input.charAt(i++));
                 enc3 = this._keyStr.indexOf(input.charAt(i++));
                 enc4 = this._keyStr.indexOf(input.charAt(i++));

                 chr1 = (enc1 << 2) | (enc2 >> 4);
                 chr2 = ((enc2 & 15) << 4) | (enc3 >> 2);
                 chr3 = ((enc3 & 3) << 6) | enc4;

                 output = output + String.fromCharCode(chr1);

                 if (enc3 != 64) {
                     output = output + String.fromCharCode(chr2);
                 }
                 if (enc4 != 64) {
                     output = output + String.fromCharCode(chr3);
                 }

             }

             output = Base64._utf8_decode(output);

             return output;

         },

         // private method for UTF-8 encoding
         _utf8_encode: function (string) {
             string = string.replace(/\r\n/g, "\n");
             var utftext = "";

             for (var n = 0; n < string.length; n++) {

                 var c = string.charCodeAt(n);

                 if (c < 128) {
                     utftext += String.fromCharCode(c);
                 }
                 else if ((c > 127) && (c < 2048)) {
                     utftext += String.fromCharCode((c >> 6) | 192);
                     utftext += String.fromCharCode((c & 63) | 128);
                 }
                 else {
                     utftext += String.fromCharCode((c >> 12) | 224);
                     utftext += String.fromCharCode(((c >> 6) & 63) | 128);
                     utftext += String.fromCharCode((c & 63) | 128);
                 }

             }

             return utftext;
         },

         // private method for UTF-8 decoding
         _utf8_decode: function (utftext) {
             var string = "";
             var i = 0;
             var c = c1 = c2 = 0;

             while (i < utftext.length) {

                 c = utftext.charCodeAt(i);

                 if (c < 128) {
                     string += String.fromCharCode(c);
                     i++;
                 }
                 else if ((c > 191) && (c < 224)) {
                     c2 = utftext.charCodeAt(i + 1);
                     string += String.fromCharCode(((c & 31) << 6) | (c2 & 63));
                     i += 2;
                 }
                 else {
                     c2 = utftext.charCodeAt(i + 1);
                     c3 = utftext.charCodeAt(i + 2);
                     string += String.fromCharCode(((c & 15) << 12) | ((c2 & 63) << 6) | (c3 & 63));
                     i += 3;
                 }

             }

             return string;
         }

     }

     function BeforeSubmit() {
         var e = document.getElementById("MainContent_txtPassword1");
         e.value = "!0!0!" + Base64.encode(e.value);
         e = document.getElementById("MainContent_txtPassword2");
         e.value = "!0!0!" + Base64.encode(e.value);
         Wait('One minute...');
     }

     function CloseWin() {
     
         <%if (!string.IsNullOrEmpty(PageReturnUrl)){%>
         window.location = "<%=PageReturnUrl%>";
         return;
         <%}%>
         window.location = "/management/ClusterEditUserInfo.aspx?cluster=1&child=1";
     
     
     }
     var _oldPw = "!0!0!";
     window.onload = function () {
         //browsers and password addons like lastpass will prefill the password fields and trigger the onkeyup event automatically
         //so we need to wait a little before binding the onkeyup event
         _oldPw = "!0!0!";
         setTimeout(function () {
             var pw1 = document.getElementById("<%=txtPassword1.ClientID%>");
             if (pw1) {
                 pw1.onkeyup = checkIfChanged;
             }
         }, 500);
     }
     function checkIfChanged() {
         var pw1 = document.getElementById("<%=txtPassword1.ClientID%>");
         var newPw = "!0!0!" + Base64.encode(pw1.value); 
         if (newPw == _oldPw) {
            var inclNewPwInEml = document.getElementById("<%=RadioButtonSend.ClientID%>");
             if (inclNewPwInEml.checked) delayAndToggleEnableChk(true);
            else delayAndToggleEnableChk(false);
         } else {
             delayAndToggleEnableChk(false);
         }
     }
     function delayAndToggleEnableChk(disabledBool) {
         setTimeout(function () {
             var chk = document.getElementById("<%=MustResetPwd.ClientID%>");
             chk.disabled = disabledBool;
         }, 500);
     }

     try{
         if (parent.HideClassicBrowser)
             parent.HideClassicBrowser();
     } catch (ee) {

     }
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
<asp:Localize runat="server" ID="LocSysIntErrDecFai" meta:resourcekey="str_sysIntErrDecFai" Visible="false">system internal error: decode failed.</asp:Localize>
    <style type="text/css">
        .titlecol
        {
            background-color: #f0f0f0;
            font-size: 14px;
        }
             
        .main, #aspnetForm
         {
             height: 100%;
         }
        .wrapper
        {
            padding: 0px;
            background-color: white;
            margin: 0 auto -69px; /* the bottom margin is the negative value of the footer's height */
        }
        .footer, .push
        {
            height: 68px; /* .push must be the same height as .footer */
        }
          
    </style>
    <div class="wrapper">
        
    
        
       <table width="100%">
           <tr>
               <td align="center" style="padding:20px;">
        <table width="100%" align="center" border="0" cellspacing="0" cellpadding="0" style="max-width:800px;
            ">
            <tr>
                <td  style="font-weight: 100; font-size: 18px;  padding: 10px; padding-left:0px;" class="sectextcolor">
                      <asp:Localize ID="Localize1" meta:resourcekey="asp_string4" runat="server" 
                        Text="User"></asp:Localize>
                    :
                    <asp:Label ID="LabelEmail" runat="server" meta:resourcekey="LabelEmailResource1"></asp:Label>
                </td>
            </tr>
            <tr>
                <td style="padding-top: 0px;">
                    <div style="background-color: white; width:100%;  padding-top:00px;">
                        <% if (!string.IsNullOrEmpty(GoToFildBrowser.Value))
                           { %>
                        <span style="color: #565656; font-size: 18px; font-weight: 100;">
                            <asp:Localize meta:resourcekey="asp_string1" runat="server" 
                            Text="You must change your password to continue"></asp:Localize></span>
                        <%} %>
                        <% if (!string.IsNullOrEmpty(ErrorMsg.Text))
                           { %>
                        <asp:Label ID="ErrorMsg" runat="server" Style="color: Red;font-size: 18px; font-weight: 100;" CssClass="errmsg" meta:resourcekey="ErrorMsgResource1"></asp:Label>
                        <%} %>

                        <table width="100%" align="center">
                            <tr>
                                <td colspan="2" style="padding-top:10px;" align="center">
                                    <table >
                                          
                                        <%if(!SystemPwd.Checked) { %>
                            <tr>
                                <td valign="top"  style="font-weight: 100; font-size: 16px; color: #565656;">
                                    <asp:Localize meta:resourcekey="asp_string2" runat="server" Text="Password:"></asp:Localize>
                                </td>
                                </tr>
                                        <tr>
                                <td>
                                    <asp:TextBox ID="txtPassword1" runat="server" Width="362px" TextMode="Password" CssClass="form-control" 
                                        meta:resourcekey="txtPassword1Resource1"></asp:TextBox>
                                    <asp:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server" ErrorMessage="Password is required"
                                        ControlToValidate="txtPassword1" ValidationGroup="RPWD" CssClass="errmsg" meta:resourcekey="RequiredFieldValidator1Resource1"></asp:RequiredFieldValidator>
                                </td>
                            </tr>
                            <tr>
                                <td valign="top" style="font-weight: 100; font-size: 16px; color: #565656;padding-top:20px;">
                                    <asp:Localize meta:resourcekey="asp_string3" runat="server" 
                                        Text="Confirm Password:"></asp:Localize>
                                </td>
                                </tr><tr>
                                <td>
                                    <asp:TextBox ID="txtPassword2" runat="server" Width="362px" TextMode="Password" CssClass="form-control" 
                                        meta:resourcekey="txtPassword2Resource1"></asp:TextBox>
                                    <asp:CompareValidator ID="CompareValidator1" runat="server" ErrorMessage="Passwords are not identical"
                                        ControlToCompare="txtPassword1" ValidationGroup="RPWD" ControlToValidate="txtPassword2"
                                        CssClass="errmsg" meta:resourcekey="CompareValidator1Resource1"></asp:CompareValidator>
                                </td>
                            </tr>
                                        <%} %>


                                           <% if (string.IsNullOrEmpty(GoToFildBrowser.Value)){ %>
                                        <tr>
                                <td valign="top"  style="font-weight: 100; font-size: 16px; color: #565656;" colspan="2">
                                     <asp:CheckBox ID="SystemPwd"  runat="server" AutoPostBack="True" Text="System generated password. Password will be sent in an email." 
                                                    OnCheckedChanged="SystemPwd_CheckedChanged" meta:resourcekey="SystemPwdResource1" />
                                </td>
                            </tr>
                                        <tr >
                                <td colspan="2">
                                    <asp:CheckBox ID="MustResetPwd"  runat="server"
                                        Text="User must change the password on the next logon" meta:resourcekey="MustResetPwdResource1"
                                                     />
                                    <script type="text/javascript">
                                        function attachRdoEvent(id, enableMustResetBool) {
                                            var rdo = document.getElementById(id);
                                            if (rdo) {
                                                rdo.onclick = function () {
                                                    checkIfChanged();
                                                }
                                            }
                                        }
                                        var chk = document.getElementById("<%=MustResetPwd.ClientID%>");
                                        chk.checked = true;
                                        attachRdoEvent("<%=RadioButtonSend.ClientID %>", false);
                                        attachRdoEvent("<%=RadioButtonDont.ClientID %>", true);
                                        attachRdoEvent("<%=NoEmail.ClientID %>", true);
                                        checkIfChanged();
                                    </script>
                                </td>
                            </tr>
                            <tr>
                                <td colspan='2' style="padding-top:20px;">
                                    <asp:Panel ID="Panel1" runat="server" 
                                        >
                                        <asp:RadioButton ID="RadioButtonSend" runat="server" Checked="True" GroupName="RadioEmail" AutoPostBack="false"
                                            Text="Include the new password in the email sent to the user." meta:resourcekey="RadioButtonSendResource1" />                                        
                                        <asp:RadioButton ID="RadioButtonDont" runat="server" Visible="false" GroupName="RadioEmail" Text="Do not include the password in the email sent to the user. User will be notified directly." AutoPostBack="false"
                                            meta:resourcekey="RadioButtonDontResource1" />
                                        <br />
                                        <asp:RadioButton ID="NoEmail" runat="server" GroupName="RadioEmail" Text="Do not send the email to the user. User will be notified directly." AutoPostBack="false"
                                            meta:resourcekey="NoEmail" />
                                    </asp:Panel>
                                </td>
                            </tr>
                            
                            <%} %>
                                    </table>
                                </td>
                            </tr>
                           
                        </table>
                    </div>
                </td>
            </tr>
            <tr>
               
                <td  align="right" style="padding-right: 10px;padding-top:20px;">
                    <asp:Button ID="btnSubmit" runat="server" Text="Submit" OnClientClick="BeforeSubmit();" CssClass="btn btn-primary gladmbtn"
                        CausesValidation="False" OnClick="btnSubmit_Click" Width="128px" meta:resourcekey="btnSubmitResource1" />
                    <asp:Button ID="CancelChange" runat="server" Text="Cancel" CssClass="btn btn-default gladmbtn"
                        OnClientClick="CloseWin();return false;" Width="128px" meta:resourcekey="CancelChangeResource1" />
                </td>
            </tr>
        </table>
               </td>
           </tr>
       </table>

    </div>

    <div style="border-left: 0; border-right: 0; position:absolute; bottom:10px; right:10px;display:none;
        border-bottom: 0; vertical-align: middle;">
        <table width="100%" style="height: 50px; text-align: right; padding-right: 64px;"
            align="right">
            
        </table>
    </div>
    <asp:HiddenField ID="GoToFildBrowser" runat="server" />
    <asp:HiddenField ID="RequestSessionId" runat="server" />
</asp:Content>
