﻿<%@ Page Title="Gladinet Cloud - Search" Language="C#" MasterPageFile="~/WebAppPanel.master" EnableSessionState="false" 
    AutoEventWireup="true" CodeBehind="MDevicesPage.aspx.cs" Inherits="GladinetPayFlow.MDevicesPage"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
        .titlecol {
            background-color: #f0f0f0;
            font-size: 14px;
        }

        .dark {
            color: #565656 !important;
        }

        .mbadge {
            font-size: 20px !important;
        }
        #devicesListTable {white-space: nowrap;}
        td.cellText{font-size:14px;ffont-weight:100;color:#404040;}
        .sortable{cursor:pointer;}
    </style>
    <script type="text/javascript">

        function  OnDeleteToken(id, name) 
        {
            var ng = document.getElementById("ctl00_MainContent_DeviceId");
            var btn = document.getElementById("ctl00_MainContent_DeleteToken");

            if (confirm("<asp:Localize meta:resourcekey="str_cfmDelTkn" runat="server">Do you really want to delete the token: (</asp:Localize>" + unescape(name) + ")?")) {
                Wait("<asp:Localize meta:resourcekey="str_delentry" runat="server">Wiping...</asp:Localize>");
            ng.value = id;
            btn.click();
        }
        }


        function  OnDisableDevice(id, name) 
        {
            var ng = document.getElementById("ctl00_MainContent_DeviceId");
            var btn = document.getElementById("ctl00_MainContent_DisableDevice");

            
            ng.value = id;
            btn.click();
        
        }
        function  OnEnableDevice(id, name) 
        {
            var ng = document.getElementById("ctl00_MainContent_DeviceId");
            var btn = document.getElementById("ctl00_MainContent_EnableDevice");

            
            ng.value = id;
            btn.click();
        
        }

        function ClearErrorMsg() {

            var d = document.getElementById("errmsgdiv");
            if (d) {
                d.style.display = 'none';
            }
        }
        setTimeout("ClearErrorMsg()", 30000);



        var ActiveWin;
        var MainWnd;
        function closeActiveWin() {


            window.location = window.location;

        }

        function OnViewDevice(id, name) {
            window.location = "/management/DeviceDashboard.aspx?id=" + id;
        }

        function closeCancelActiveWin() {
            ActiveWin.close();
        }

        function gEncodeUri(str) {
            var s = encodeURI(str).replace(/&/g, '%26').replace(/#/g, '|').replace('+', ':');
            while (true) {
                var i = s.indexOf('+');
                if (i == -1)
                    break;
                s = s.replace('+', ':');
            }

            return s;

        }

        function OpenFile(file) {
            var f = document.getElementById('rightpanel');
            f.src = "File.aspx?f=" + gEncodeUri(unescape(file));

        }
        function OnViewDetail(id, name)
        {
            parent.SetThirdMenuView("/management/DeviceDashboard.aspx?id=" + id, name);
        }
        function OnWipeDevice(id, name) {
            var ng = document.getElementById("ctl00_MainContent_DeviceId");
            var btn = document.getElementById("ctl00_MainContent_WipeDevice");

            if (confirm("<asp:Localize meta:resourcekey="str_wipe" runat="server">Do you really want to wipe the device (</asp:Localize>" + unescape(name) + ")?")) {
                Wait("<asp:Localize meta:resourcekey="str_wiping" runat="server">wiping...</asp:Localize>");
            ng.value = id;
            btn.click();
        }
        }

        function OnDeleteDevice(id, name) {
            var ng = document.getElementById("ctl00_MainContent_DeviceId");
            var btn = document.getElementById("ctl00_MainContent_DeleteDevice");

            if (confirm("<asp:Localize meta:resourcekey="str_deldev" runat="server">Do you really want to delete the device entry</asp:Localize> (" + unescape(name) + ")?")) {
                Wait("<asp:Localize meta:resourcekey="str_delentry" runat="server">wiping...</asp:Localize>");
            ng.value = id;
            btn.click();
        }
        }

        
        function OnAgentAttachedFolders(id, name) {
            Wait("Please wait");
            window.location = "/management/DeviceAttachedFolders.aspx?f=c&id=" + id + "&name=" + name;
        }

        function OnAgentTasks(id, name) {
            Wait("Please wait");
            window.location = "/management/DeviceTasks.aspx?f=c&id=" + id + "&name=" + name;
        }
        function DownloadClient()
        {
            window.location = "/management/servo/ServoClients.aspx?vdid=<%=SessionDomainId%>";
                     }
        function ShowToast(msg,color) {                   
            $("#<%=ErrorMsg.ClientID %>").html(msg);
            $("#<%=ErrorMsg.ClientID %>").css("color",color);
            setTimeout(function () {       
                $("#<%=ErrorMsg.ClientID %>").html("");
                $("#<%=ErrorMsg.ClientID %>").css("color","red");
            }, 4000);
        }              
        var oldOnload = window.onload;
        window.onload = function(){
            if(oldOnload) oldOnload();
            <asp:Literal id="LtlScript" runat="server" />;	

            document.querySelectorAll('th').forEach(th => th.addEventListener('click', (() => {
                const table = th.closest('table');
                const tbody = table.querySelector('tbody');
                Array.from(tbody.querySelectorAll('tr'))
                .sort(comparer(Array.from(th.parentNode.children).indexOf(th), this.asc = !this.asc))
                        .forEach(tr => tbody.appendChild(tr));
            })));

        };

        var getCellValue = function(tr, idx){ return tr.children[idx].innerText || tr.children[idx].textContent; }

        var comparer = function(idx, asc) { return function(a, b) { return function(v1, v2) {
                return v1 !== '' && v2 !== '' && !isNaN(v1) && !isNaN(v2) ? v1 - v2 : v1.toString().localeCompare(v2);
            }(getCellValue(asc ? a : b, idx), getCellValue(asc ? b : a, idx));
        }};
        function ToggleView() {
            document.getElementById("<%=BtnChangeView.ClientID %>").click();
        }
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">                                                                 
<asp:Localize runat="server" ID="LocFaiToWipTheDev" meta:resourcekey="str_faiToWipTheDev" Visible="false">Failed to wipe the device</asp:Localize>
<asp:Localize runat="server" ID="LocWipSuc" meta:resourcekey="str_wipSuc" Visible="false">Wiped successfully</asp:Localize>
<asp:Localize runat="server" ID="LocDevWipIsSch" meta:resourcekey="str_devWipIsSch" Visible="false">Device wipe is scheduled</asp:Localize>
    <asp:Localize runat="server" ID="LocNotFou" meta:resourcekey="str_notFou" Visible="false">not found</asp:Localize>
    <asp:Localize ID="LocDvcFnd" meta:resourcekey="str_dvcFnd" runat="server" Visible="false">Device(s) found</asp:Localize>

    <div style="width: 100%; border-bottom: 1px solid #cccccc; padding: 5px; padding-right: 10px;" id="toolmenu">
        <table style="width: 100%">
            <tr>
                 <td>
                        <span class="gladbtn" style="font-weight: 400!important; font-size: 20px!important; text-transform: uppercase; color:#808080!important;"><asp:Localize runat="server" meta:resourcekey="str_dev">Devices</asp:Localize></span>
                    </td>
                <td style="height: 48px;padding-left:20px;">
                    <asp:Label ID="ResultCount" runat="server" meta:resourcekey="ResultCountResource1" CssClass="sectextcolor mbadge"></asp:Label>
                </td>
                <td>
                    <%if (ResultCount.Text == "") { 
                    ErrorMsg.Text = "";
                     } %>
                    <asp:Label ID="ErrorMsg" runat="server" Style="color: Red;" meta:resourcekey="ErrorMsgResource1"></asp:Label>
                </td>
                <td align="right">                                                                                                   
                  <asp:Localize ID="LocLstVie" meta:resourcekey="str_lstVie" runat="server" Visible="false">List View</asp:Localize>
                  <asp:Localize ID="LocIcoVie" meta:resourcekey="str_icoVie" runat="server" Visible="false">Icon View</asp:Localize> 
                  <asp:Localize ID="LocSrc" meta:resourcekey="str_src" runat="server" Visible="false">Search</asp:Localize>     
                  <asp:Localize ID="LocStg" meta:resourcekey="str_stg" runat="server" Visible="false">Settings</asp:Localize>
                  <asp:Localize ID="LocDowCltSfw" meta:resourcekey="str_dowCltSfw" runat="server" Visible="false">Download Client Software</asp:Localize>
                   <% if (ViewType == "icon") { %>  
                    <i class="gladinet-icons md-24 md-dark hand center toolbtn" style="display: inline-block;" onclick="ToggleView();" title="<%=LocLstVie.Text %>">&#x146;</i>
                   <% } else { %>                                                                                                                                 
                    <i class="gladinet-icons md-24 md-dark hand center toolbtn" style="display: inline-block;" onclick="ToggleView();" title="<%=LocIcoVie.Text %>">&#x140;</i>
                   <% } %>
                    <div style="display:none">
                    <asp:Button ID="BtnChangeView" runat="server" OnClick="BtnChangeView_Click" /></div>
                </td>
                <td align="right" width="40px" valign="middle" style="padding-right: 10px;">
                    <i class="gladinet-icons md-24 md-dark hand center toolbtn" style="display: inline-block;" onclick="OpenSearch();" title="<%=LocSrc.Text %>">&#xA7;</i>
                </td>
                 <td align="right" width="40px" valign="middle" style="padding-right: 10px;">
                    <i class="gladinet-icons md-24 md-dark hand center toolbtn" style="display: inline-block;" onclick="OpenSettings();" title="<%=LocStg.Text %>">g</i>
                </td>
                <%if (!IsMobile()) { %>
                    <%if (exportcsv.Visible) { %>

                <td align="right" width="40px" valign="middle">

                <asp:LinkButton ID="exportcsv" runat="server" Visible="False" OnClick="exportcsv_Click" style="font-size:16px; font-weight:100;"><asp:Localize ID="Localize1" meta:resourcekey="str_csv" runat="server"><i class="gladinet-icons md-32 md-dark hand center" title="Download as a CSV file">&#xB2;</i></asp:Localize></asp:LinkButton>

                </td>
                    <% } %>


                <td align="right" width="40px" valign="middle">
                    <i class="gladinet-icons md-32 md-dark hand center" onclick="DownloadClient();" title="<%=LocDowCltSfw.Text %>">)</i>
                </td>

                <td width="40px" align="right" valign="middle" style="display:none;">
                    <div class="sectextcolor" style="width: 40px; font-size: 32px; font-weight: 100; cursor: pointer;" onclick="parent.ReturnLast();"><i class="gladinet-icons md-24 md-dark hand" style="display: table-cell;">&#xFB;</i></div>
                </td>

                <%} %>
            </tr>
        </table>
    </div>
    <div style="width: 100%; overflow: auto" id="grid-table">


        <table width="100%" style="padding: 2px; background-color: white; margin: 0px; margin-top: 13px; overflow: auto;" cellspacing="0"
            cellpadding="0">


            <tr id="resulttr">
                <td colspan="3" style="vertical-align: top;" align="center">
                    <%if (PubsRepeater.Items.Count != 0 && PubsRepeaterList.Items.Count != 0){ %>
                    <% if (ViewType == "icon") { %>
                    <div class="row" style="width: 100%; align-content: center; margin: 0;">
                        <div class="col-xs-12 col-sm-6 col-md-4 col-lg-3 text-center topbuffer" style="padding-bottom: 10px;">
                        <table id="devicesListTable" class="table table-striped table-bordered table-hover">  
                          <thead>
                            <tr>
                              <th scope="col" class="sortable">#</th>
                              <th scope="col" class="sortable">Name</th>    
                              <th scope="col" class="sortable">Type</th>
                              <th scope="col" class="sortable">Email</th>
                              <th scope="col" class="sortable">Last Login</th>
                              <th scope="col" class="sortable">Last Report</th>
                              <th scope="col" class="sortable">Status</th>  
                              <th scope="col" class="sortable">Allowed</th>
                              <th scope="col" colspan="3"></th>
                            </tr>
                          </thead>   
                        <asp:Repeater ID="PubsRepeaterList" runat="server">
                            <ItemTemplate>  
                                <tr style="background: transparent;">
                                    <th scope="row"><%#(((RepeaterItem)Container).ItemIndex+1) %></th><td><%#DataBinder.Eval(Container.DataItem, "HostName")%></td>
                                    <td class="cellText"><%#DataBinder.Eval(Container.DataItem,"DeviceType") %></td>
                                    <td class="cellText"><%#DataBinder.Eval(Container.DataItem,"UserEmail") %></td>
                                    <td class="cellText"><%#DataBinder.Eval(Container.DataItem,"LastLogin") %></td>
                                    <td class="cellText"><%#DataBinder.Eval(Container.DataItem,"LastReport") %></td>
                                    <td class="cellText fa <%#DataBinder.Eval(Container.DataItem, "SyncStatusIcon")%>" style="color: #008000!important; font-size: 24px;border:none;" title="<%#DataBinder.Eval(Container.DataItem, "SyncStatusString")%>"></td>
                                    <td>
                                        <span class="gladinet-icons sectextcolor" style="font-size: 64px!important; <%#DataBinder.Eval(Container.DataItem,"EnableDisplay") %>" onclick='OnDisableDevice("<%#DataBinder.Eval(Container.DataItem, "InstanceId")%>","<%#DataBinder.Eval(Container.DataItem, "HostName")%>");'>&#x15A;</span>
                                        <span class="gladinet-icons sectextcolor" style="font-size: 64px!important; <%#DataBinder.Eval(Container.DataItem,"DisableDisplay") %>" onclick='OnEnableDevice("<%#DataBinder.Eval(Container.DataItem, "InstanceId")%>","<%#DataBinder.Eval(Container.DataItem, "HostName")%>");'>&#x15B;</span>
                                    </td>
                                    <td>
                                        <button class="btn btn-primary gladmbtn" onclick='OnViewDetail("<%#DataBinder.Eval(Container.DataItem, "InstanceId")%>","<%#DataBinder.Eval(Container.DataItem, "HostName")%>");return false;'><asp:Localize runat="server" meta:resourcekey="str_man">Manage</asp:Localize></button>
                                    </td>
                                    <td>
                                        <button class="btn btn-primary gladmbtn" onclick='OnWipeDevice("<%#DataBinder.Eval(Container.DataItem, "InstanceId")%>","<%#DataBinder.Eval(Container.DataItem, "HostName")%>");return false;'><asp:Localize runat="server" meta:resourcekey="str_wip">Wipe</asp:Localize></button>
                                    </td>
                                    <td>
                                        <button class="btn btn-primary gladmbtn" onclick='OnDeleteDevice("<%#DataBinder.Eval(Container.DataItem, "InstanceId")%>","<%#DataBinder.Eval(Container.DataItem, "HostName")%>");return false;'><asp:Localize runat="server" meta:resourcekey="str_del">Delete</asp:Localize></button>
                                    </td>
                                </tr>
                            </ItemTemplate>
                        </asp:Repeater>
                        </table>   
                            </div>
                        </div>
                    <% } else { %>   
                    <div class="row" style="width: 100%; align-content: center; margin: 0;">
                        <asp:Repeater ID="PubsRepeater" runat="server">
                            <ItemTemplate>
                                <div class="col-xs-12 col-sm-6 col-md-4 col-lg-3 text-center topbuffer" style="padding-bottom: 10px;">
                                    <div class="viewcard">
                                        <div style="padding: 10px; border-bottom: 1px solid #f0f0f0;" class="boxbordercolor secsubcolor">
                                            <table width="100%">
                                                <tr>
                                                    <td align="left">
                                                        <span style="font-size: 18px; font-weight: 100;"><%#DataBinder.Eval(Container.DataItem, "HostName")%></span>
                                                    </td>
                                                    <td width="144px" align="right" style="font-size: 16px; display: none;">
                                                        <span class="fa fa-wrench sectextcolor toolbtn" style="cursor: pointer;" title="<%=str_mgrdev.Text %>" onclick='OnViewDevice("<%#DataBinder.Eval(Container.DataItem, "InstanceId")%>","<%#DataBinder.Eval(Container.DataItem, "HostName")%>");'></span>&nbsp;&nbsp;
                                                        <span class="fa fa-eraser sectextcolor toolbtn" style="cursor: pointer;" title="<%=str_wipedev.Text %>" onclick='OnWipeDevice("<%#DataBinder.Eval(Container.DataItem, "InstanceId")%>","<%#DataBinder.Eval(Container.DataItem, "HostName")%>");'></span>&nbsp;&nbsp;
                                                        <span class="fa fa-remove sectextcolor toolbtn" style="cursor: pointer;" title="<%=str_deldev.Text %>" onclick='OnDeleteDevice("<%#DataBinder.Eval(Container.DataItem, "InstanceId")%>","<%#DataBinder.Eval(Container.DataItem, "HostName")%>");'></span>
                                                    </td>
                                                    <td align="right">
                                                        <span class="gladinet-icons sectextcolor" style="font-size: 64px!important; <%#DataBinder.Eval(Container.DataItem,"EnableDisplay") %>" onclick='OnDisableDevice("<%#DataBinder.Eval(Container.DataItem, "InstanceId")%>","<%#DataBinder.Eval(Container.DataItem, "HostName")%>");'>&#x15A;</span>
                                                        <span class="gladinet-icons sectextcolor" style="font-size: 64px!important; <%#DataBinder.Eval(Container.DataItem,"DisableDisplay") %>" onclick='OnEnableDevice("<%#DataBinder.Eval(Container.DataItem, "InstanceId")%>","<%#DataBinder.Eval(Container.DataItem, "HostName")%>");'>&#x15B;</span>
                                                    </td>
                                                </tr>
                                            </table>

                                        </div>
                                        <div class="panel-body">
                                            <table width="100%">
                                                <tr>
                                                    <td style="height: 280px!important; color: #404040; font-size: 16px; font-weight: 100; padding: 5px; padding-left: 0px;" align="center" valign="middle">

                                                        <table width="100%" class="table-striped">

                                                            <tr>
                                                                <td style="padding: 5px; color: #565656; font-size: 16px; font-weight: 100"><asp:Localize runat="server" meta:resourcekey="str_logEma">Login Email</asp:Localize></td>
                                                                <td width="220px">
                                                                    <%#DataBinder.Eval(Container.DataItem,"UserEmail") %>
                                                                </td>
                                                            </tr>

                                                            <tr>
                                                                <td style="padding: 5px; color: #565656; font-size: 16px; font-weight: 100">
                                                                    <asp:Localize meta:resourcekey="str_devtype" runat="server">Type</asp:Localize>
                                                                </td>
                                                                <td width="220px">
                                                                    <%#DataBinder.Eval(Container.DataItem,"DeviceType") %>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td style="padding: 5px; color: #565656; font-size: 16px; font-weight: 100">
                                                                    <asp:Localize meta:resourcekey="str_osver" runat="server">OS Version</asp:Localize>
                                                                </td>
                                                                <td>
                                                                    <%#DataBinder.Eval(Container.DataItem,"OsVer") %>
                                                     
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td style="padding: 5px; color: #565656; font-size: 16px; font-weight: 100">
                                                                    <asp:Localize meta:resourcekey="str_clientver" runat="server">Client Version</asp:Localize>
                                                                </td>
                                                                <td width="120px">
                                                                    <%#DataBinder.Eval(Container.DataItem,"ClientVer") %>
                                                                </td>
                                                            </tr>

                                                            <tr>
                                                                <td style="padding: 5px; color: #565656; font-size: 16px; font-weight: 100">
                                                                    <asp:Localize meta:resourcekey="str_lastlogintime" runat="server">Last Login Time</asp:Localize>
                                                                </td>
                                                                <td>
                                                                    <%#DataBinder.Eval(Container.DataItem,"LastLogin") %>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td style="padding: 5px; color: #565656; font-size: 16px; font-weight: 100">
                                                                    <asp:Localize meta:resourcekey="str_syncstatus" runat="server">Sync Status</asp:Localize>
                                                                </td>
                                                                <td>

                                                                    <span class="fa <%#DataBinder.Eval(Container.DataItem, "SyncStatusIcon")%>  " title="<%#DataBinder.Eval(Container.DataItem, "SyncStatusString")%>" style="color: <%#DataBinder.Eval(Container.DataItem, "SyncStatusColor")%>!important; font-size: 24px;"></span>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td style="padding: 5px; color: #565656; font-size: 16px; font-weight: 100"><asp:Localize runat="server" meta:resourcekey="str_staRepTim">Status Report Time</asp:Localize></td>
                                                                <td>
                                                                    <%#DataBinder.Eval(Container.DataItem,"LastReport") %>
                                                                </td>
                                                            </tr>

                                                            <tr>
                                                                <td colspan="2" align="right">
                                                                    <button class="btn btn-primary gladmbtn" onclick='OnViewDetail("<%#DataBinder.Eval(Container.DataItem, "InstanceId")%>","<%#DataBinder.Eval(Container.DataItem, "HostName")%>");return false;' <%#HideIfMobileDevice(DataBinder.Eval(Container.DataItem,"DeviceType"))%>><asp:Localize runat="server" meta:resourcekey="str_man">Manage</asp:Localize></button>
                                                                    <button class="btn btn-primary gladmbtn" onclick='OnWipeDevice("<%#DataBinder.Eval(Container.DataItem, "InstanceId")%>","<%#DataBinder.Eval(Container.DataItem, "HostName")%>");return false;'><asp:Localize runat="server" meta:resourcekey="str_wip">Wipe</asp:Localize></button>
                                                                    <button class="btn btn-primary gladmbtn" onclick='OnDeleteDevice("<%#DataBinder.Eval(Container.DataItem, "InstanceId")%>","<%#DataBinder.Eval(Container.DataItem, "HostName")%>");return false;'><asp:Localize runat="server" meta:resourcekey="str_del">Delete</asp:Localize></button>
                                                                </td>
                                                            </tr>


                                                        </table>

                                                    </td>
                                                </tr>
                                            </table>

                                        </div>

                                    </div>

                                </div>
                            </ItemTemplate>
                        </asp:Repeater>

                    </div>
                    <% } %>  
                    <%}else { %>
                    <table style="width:100%; max-width:800px">
                        <tr>
                            <td style="padding:10px; padding-top:40px; font-size:18px;font-weight: 400;color: #808080 !important;" align="center"><asp:Localize runat="server" meta:resourcekey="str_noDevFou">No Devices Found.</asp:Localize></td>
                            
                        </tr>
                        <tr>
                            <td style="padding:10px; padding-top:20px; font-size:18px; color:#565656;" align="center">
                                <span class="gladmbtn btn btn-primary" style="display: inline-block;" onclick="OpenSearch();" title="Search"><asp:Localize runat="server" meta:resourcekey="str_sea">Search</asp:Localize></span>
                                <span class="gladmbtn btn btn-primary" style="display: inline-block;" onclick="OpenSettings();" title="Settings"><asp:Localize runat="server" meta:resourcekey="str_set">Settings</asp:Localize></span>
                            </td>
                        </tr>
                    </table>
                    <%} %>
                </td>
            </tr>
            <tr id="querytr" style="display: none;">
                <td align="center" style="padding: 10px; padding-top: 20px;">
                    <div style="width: 100%; max-width: 800px; padding: 20px;">
                        <table style="width: 100%">
                              <tr>
                                <td colspan="2" style="font-size:20px; color:#404040; padding-bottom:20px;"><asp:Localize runat="server" meta:resourcekey="str_que">Query</asp:Localize></td>
                            </tr>
                                <tr>
                                    <td style="padding: 5px; ">
                                        <asp:DropDownList ID="Field" runat="server" AutoPostBack="True" OnSelectedIndexChanged="Field_SelectedIndexChanged" CssClass="browser-default custom-select secsubbordercolor"
                                            meta:resourcekey="FieldResource1">
                                        </asp:DropDownList>
                                    </td>
                                </tr>
                                <tr>
                                    <td style="padding: 5px; ">
                                        <asp:DropDownList ID="ActionName" runat="server" meta:resourcekey="ActionNameResource1" CssClass="browser-default custom-select secsubbordercolor">
                                        </asp:DropDownList>

                                    </td>
                                </tr>
                                <tr>
                                    <td style="padding: 5px; ">
                                        <asp:DropDownList ID="StatusList" runat="server" meta:resourcekey="ActionNameResource1" CssClass="browser-default custom-select secsubbordercolor">
                                        </asp:DropDownList>
                                    </td>

                                </tr>
                                <tr>
                                    <td style="padding: 5px; ">
                                        <asp:TextBox ID="FileName" runat="server" meta:resourcekey="FileNameResource1"
                                            CssClass="form-control dark"></asp:TextBox>
                                        </td>
                                    </tr>

                                <tr>
                            <td align="right" style="padding-top:40px; ">
                                <asp:Button ID="Button1" runat="server"
                                    Text="Search" OnClick="Button1_Click" CssClass="btn btn-primary gladmbtn"
                                    meta:resourcekey="Button1Resource1"  />
                                <button class="btn btn-default gladmbtn" onclick="CloseSearch(); return false;"><asp:Localize runat="server" meta:resourcekey="str_clo">Close</asp:Localize></button>
                            </td>
                            </tr>                                    

                        </table>
                    </div>
                </td>
            </tr>

            <tr id="settingstr" style="display: none;">
                <td align="center" style="padding: 10px; padding-top: 20px;">
                    
                         <table >
                              <tr>
                                <td colspan="2" style="font-size:20px; color:#404040; padding-bottom:20px;"><asp:Localize runat="server" meta:resourcekey="str_set">Settings</asp:Localize></td>
                            </tr>
                                                     <tr>
                            <td style="padding: 5px; font-weight: 100; color: #565656; font-size: 16px;" >
                                <table>
                                    <tr class="filerow">
                                        <td style="display:none;">
                                            <asp:CheckBox ID="ApproveNewDevice" runat="server" />
                                        </td>
                                        <td style="padding: 5px; font-weight: 100; color: #565656; font-size: 16px;">
                                            <asp:Localize runat="server" meta:resourcekey="str_reqApp">Require approval for device access</asp:Localize>
                                             <p class="text-muted" style="font-size: smaller;"><asp:Localize runat="server" meta:resourcekey="str_wheUseAttLogFro">When a user attempts to log in from a new device via native client applications, the connection will be rejected until the cluster admin approves the new device.</asp:Localize></p>
                                        </td>
                                        <td>
                                            <%if (ApproveNewDevice.Checked){ %>
                                                    <asp:LinkButton CssClass=" nopadding" ID="LinkButton3" runat="server" OnClick="DisableApproveNew_Click"><span class="gladinet-icons gladrootbtn" style="font-size:48px!important">&#x15A;</span></asp:LinkButton>
                                                    <%}else{ %>
                                                    <asp:LinkButton CssClass="nopadding" Font-Size="64px" ID="LinkButton4" runat="server" OnClick="EnableApproveNew_Click"><span class="gladinet-icons gladrootbtn" style="font-size:48px!important">&#x15B;</span></asp:LinkButton>
                                                    <%} %>
                                        </td>
                                    </tr>
                                    <tr><td style="height:10px!important;">&nbsp;</td></tr>
                                    <tr class="filerow">
                                       <td style="display:none;">
                                            <asp:CheckBox ID="ApproveExternalNewDevice" runat="server" />
                                        </td>
                                        <td style="padding: 5px; font-weight: 100; color: #565656; font-size: 16px;">
                                            <asp:Localize runat="server" ID="Loc" meta:resourcekey="str_reqAppForDevAcc">Require approval for device access from external network</asp:Localize>
                                            <p class="text-muted" style="font-size: smaller;"><asp:Localize runat="server" meta:resourcekey="str_wheUseAttLogFro">When a user attempts to log in from a new device via native client applications from external network, the connection will be rejected until the cluster admin approves the new device.</asp:Localize></p>
                                        </td>
                                        <td>
                                            <%if (ApproveExternalNewDevice.Checked){ %>
                                                    <asp:LinkButton CssClass=" nopadding" ID="LinkButton1" runat="server" OnClick="DisableApproveExternal_Click"><span class="gladinet-icons gladrootbtn" style="font-size:48px!important">&#x15A;</span></asp:LinkButton>
                                                    <%}else{ %>
                                                    <asp:LinkButton CssClass="nopadding" Font-Size="64px" ID="LinkButton2" runat="server" OnClick="EnableApproveExternal_Click"><span class="gladinet-icons gladrootbtn" style="font-size:48px!important">&#x15B;</span></asp:LinkButton>
                                                    <%} %>
                                        </td>
                                    </tr>
                                    <tr><td style="height:10px!important;"></td></tr>
                                    <tr class="filerow">
                                        <td style="display:none;">
                                            <asp:CheckBox ID="EnableOutlookAddin" runat="server" />
                                        </td>
                                        <td style="padding: 5px; font-weight: 100; color: #565656; font-size: 16px;">
                                            <asp:Localize runat="server" meta:resourcekey="str_enaAutOutPlu">Enable auto-installation of the Outlook Plugin</asp:Localize></td>
                                        <td>
                                            <%if (EnableOutlookAddin.Checked){ %>
                                                    <asp:LinkButton CssClass=" nopadding" ID="LinkButton5" runat="server" OnClick="DisableOutlookPlugin_Click"><span class="gladinet-icons gladrootbtn" style="font-size:48px!important">&#x15A;</span></asp:LinkButton>
                                                    <%}else{ %>
                                                    <asp:LinkButton CssClass="nopadding" Font-Size="64px" ID="LinkButton6" runat="server" OnClick="EnableOutlookPlugin_Click"><span class="gladinet-icons gladrootbtn" style="font-size:48px!important">&#x15B;</span></asp:LinkButton>
                                                    <%} %>
                                        </td>
                                    </tr>
                                    <tr><td style="height:10px!important;"></td></tr>
                                    <tr class="filerow">
                                        <td style="display:none;">
                                            <asp:CheckBox ID="AddShortCutToDocuments" runat="server" checked="true"/>
                                        </td>
                                        <td style="padding: 5px; font-weight: 100; color: #565656; font-size: 16px;">
                                            <asp:Localize runat="server" meta:resourcekey="str_creShoDocLib">Create shortcut in documents library</asp:Localize>
                                            <p class="text-muted" style="font-size: smaller;"><asp:Localize runat="server" meta:resourcekey="str_wheEnaWinCliWil">When enabled, the windows client will create a shortcut to the mapped drive in the documents library.</asp:Localize></p>
                                        </td>
                                        <td>
                                            <%if (AddShortCutToDocuments.Checked){ %>
                                                    <asp:LinkButton CssClass=" nopadding" ID="LinkButton9" runat="server" OnClick="DisableDocShortCut_Click"><span class="gladinet-icons gladrootbtn" style="font-size:48px!important">&#x15A;</span></asp:LinkButton>
                                                    <%}else{ %>
                                                    <asp:LinkButton CssClass="nopadding" Font-Size="64px" ID="LinkButton10" runat="server" OnClick="EnableDocShortCut_Click"><span class="gladinet-icons gladrootbtn" style="font-size:48px!important">&#x15B;</span></asp:LinkButton>
                                                    <%} %>
                                        </td>
                                    </tr>
                                    <tr><td style="height:10px!important;"></td></tr>
                                    <tr class="filerow">
                                        <td style="display:none;">
                                            <asp:CheckBox ID="AddShortCutToDesktop" runat="server" checked="true"/>
                                        </td>
                                        <td style="padding: 5px; font-weight: 100; color: #565656; font-size: 16px;">
                                            <asp:Localize runat="server" meta:resourcekey="str_creShoDes">Create shortcut on Desktop</asp:Localize>
                                            <p class="text-muted" style="font-size: smaller;"><asp:Localize runat="server" meta:resourcekey="str_wheEnaWinCliWil">When enabled, the windows client will create a shortcut to the mapped drive on the desktop.</asp:Localize></p>
                                        </td>
                                        <td>
                                            <%if (AddShortCutToDesktop.Checked){ %>
                                                    <asp:LinkButton CssClass="nopadding" ID="LinkButton7" runat="server" OnClick="DisableDeskShortCut_Click"><span class="gladinet-icons gladrootbtn" style="font-size:48px!important">&#x15A;</span></asp:LinkButton>
                                                    <%}else{ %>
                                                    <asp:LinkButton CssClass=" nopadding" Font-Size="64px" ID="LinkButton8" runat="server" OnClick="EnableDeskShortCut_Click"><span class="gladinet-icons gladrootbtn" style="font-size:48px!important">&#x15B;</span></asp:LinkButton>
                                                    <%} %>
                                        </td>
                                    </tr>
                                   

                                </table>
                            </td>
                        </tr>

                             <tr>
                            <td align="right" style="padding-top:40px; ">
                                <asp:Button ID="Button2" runat="server" Visible="false"
                                    Text="Apply" OnClick="ApplySettings_Click" CssClass="btn btn-primary gladmbtn"
                                    meta:resourcekey="Button1Resource1"  />
                                <button class="btn btn-default gladmbtn" onclick="CloseSettings(); return false;"><asp:Localize runat="server" meta:resourcekey="str_clo">Close</asp:Localize></button>
                            </td>
                            </tr>  
                             </table>
                    
                </td>
                </tr>
        </table>
    </div>
    <div style="display: none;">
        <asp:HiddenField ID="InstanceId" runat="server" />
        <asp:Localize meta:resourcekey="str_deldev" ID="str_deldev" Visible="False" runat="server">Delete</asp:Localize>
        <asp:Localize meta:resourcekey="str_wipe" ID="str_wipedev" runat="server" Visible="False">Wipe Device</asp:Localize>
        <asp:Localize meta:resourcekey="str_mgrdev" ID="str_mgrdev" Visible="False" runat="server">View Details</asp:Localize>
        <asp:Localize meta:resourcekey="str_delTkn" ID="str_delTkn" Visible="False" runat="server">Delete the Token</asp:Localize>

    </div>

    <div style="display: none;">
        <asp:Button ID="DeleteToken" runat="server" OnClick="DeleteToken_Click" />
        <asp:HiddenField ID="DeviceId" runat="server" />
        <asp:Button ID="DeleteDevice" runat="server" OnClick="DeleteDevice_Click" />
        <asp:Button ID="WipeDevice" runat="server" OnClick="WipeDevice_Click" />
        <asp:Button ID="DisableDevice" runat="server" OnClick="DisableDevice_Click" />
        <asp:Button ID="EnableDevice" runat="server" OnClick="EnableDevice_Click" />

        <asp:Localize meta:resourcekey="str_ddl_usrEml" ID="LocUsrEml"  Visible="false" runat="server">User Email</asp:Localize>
<asp:Localize meta:resourcekey="str_ddl_dvcTpe" ID="LocDvcTpe"  Visible="false" runat="server">Device Type</asp:Localize>
<asp:Localize meta:resourcekey="str_ddl_hstNme" ID="LocHstNme"  Visible="false" runat="server">Host Name</asp:Localize>
<asp:Localize meta:resourcekey="str_ddl_oprStm" ID="LocOprStm"  Visible="false" runat="server">Operating System</asp:Localize>
<asp:Localize meta:resourcekey="str_ddl_cntSfw" ID="LocCntSfw"  Visible="false" runat="server">Client Software Version</asp:Localize>
<asp:Localize meta:resourcekey="str_ddl_sts" ID="LocSts"  Visible="false" runat="server">Status</asp:Localize>
<asp:Localize meta:resourcekey="str_ddl_sncSts" ID="LocSncSts"  Visible="false" runat="server">Sync Status</asp:Localize>

<asp:Localize meta:resourcekey="str_ddl_acd" ID="LocAcd"  Visible="false" runat="server">Accepted</asp:Localize>
<asp:Localize meta:resourcekey="str_ddl_rjd" ID="LocRjd"  Visible="false" runat="server">Rejected</asp:Localize>
                
<asp:Localize meta:resourcekey="str_ddl_snc" ID="LocSnc"  Visible="false" runat="server">Syncing</asp:Localize>
<asp:Localize meta:resourcekey="str_ddl_fld" ID="LocFld"  Visible="false" runat="server">Failed</asp:Localize>
<asp:Localize meta:resourcekey="str_ddl_sncCpd" ID="LocSncCpd"  Visible="false" runat="server">Sync Completed</asp:Localize>
<asp:Localize meta:resourcekey="str_ddl_fldRtvSts" ID="LocFldRtvSts"  Visible="false" runat="server">Failed to Retrieve Sync Status</asp:Localize>
<asp:Localize meta:resourcekey="str_ddl_sncTskPnd" ID="LocSncTskPnd"  Visible="false" runat="server">Sync Task Pending</asp:Localize>
<asp:Localize meta:resourcekey="str_ddl_sncTskPsd" ID="LocSncTskPsd"  Visible="false" runat="server">Sync Task Paused</asp:Localize>

<asp:Localize meta:resourcekey="str_dvcFnd" ID="Localize2"  Visible="false" runat="server">Device(s) found</asp:Localize>

    </div>

    <script type="text/javascript">
        function CloseSearch()
        {
            var e = document.getElementById("resulttr");
            e.style.display = "";

            e = document.getElementById("querytr");
            e.style.display = "none";

            e = document.getElementById("toolmenu");
            e.style.display = "";

        }

        function CloseSettings()
        {
            var e = document.getElementById("resulttr");
            e.style.display = "";

            e = document.getElementById("querytr");
            e.style.display = "none";

            e = document.getElementById("settingstr");
            e.style.display = "none";


            e = document.getElementById("toolmenu");
            e.style.display = "";

        }

        function OpenSettings()
        {
            var e = document.getElementById("resulttr");
            e.style.display = "none";

            e = document.getElementById("querytr");
            e.style.display = "none";

            e = document.getElementById("settingstr");
            e.style.display = "";


            e = document.getElementById("toolmenu");
            e.style.display = "none";

        }
        

        function OpenSearch() {
            var e = document.getElementById("resulttr");
            e.style.display = "none";

            e = document.getElementById("toolmenu");
            e.style.display = "none";
            
            e = document.getElementById("querytr");
            e.style.display = "";
            e = document.getElementById("ctl00_MainContent_FileName");
            e.focus();

            
        }

        function OnChange(id) {
          
            var idc = document.getElementById("ctl00_MainContent_InstanceId");
            var db = document.getElementById("ctl00_MainContent_DenyBtn");
            var ab = document.getElementById("ctl00_MainContent_AllowBtn");
            idc.value = id;

            var e = document.getElementById(id);
            if (e.checked) {
              
                ab.click();
            } else {
          
                db.click();
            }

        }

        function MgrDevice(id) {
            window.location = "DeviceDashboard.aspx?id=" + id;
        }

        function adjust(){
            
            var e = document.getElementById("grid-table");
            e.style.height = (document.documentElement.clientHeight -60) + "px";
            
            <%if (m_InSearch ){ %>
            OpenSearch();
            <%}%>
            <%if (m_InSetting ){ %>
            OpenSettings();
            <%}%>

        }

        adjust();
    </script>
</asp:Content>
