﻿<%@ Page Title="Servers" Language="C#" MasterPageFile="../WebAppPanel.master" EnableSessionState="false" 
    AutoEventWireup="true" CodeBehind="CloudFileServer.aspx.cs" Inherits="GladinetPayFlow.CloudFileServer" Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <script type="text/javascript">
        function ClickSvrShare(svrName, ShareName) 
        {
            try {
                var elements = document.getElementsByClassName("gladactiverow");
                if (elements && elements.length != 0) {
                    for (var i = 0; i < elements.length; ++i) {
                        elements[i].className = "";
                    }
                }
            } catch (e) {

            }

            var e = document.getElementById("id_" + ShareName);
            e.className = "gladactiverow";
            parent.ClickSvrShare("{CloudFileServer}", ShareName);
        }
        
        function onEditShare(n)
        {
            window.location = "AddCloudShare.aspx?vdid=<%=SessionDomainId%>&f="+n;
        }

        function onDeleteShare(n)
        {
            var b = document.getElementById("ctl00_MainContent_DeleteShareBtn");
            var s = document.getElementById("ctl00_MainContent_ShareName");

            if (confirm("Confirm delete this share?")) {
                s.value = n;
                b.click();
            }
        }

        function OnEdit() {
            var e = document.getElementById("DashboardView");
            e.style.display = "none";

            e = document.getElementById("EditView");
            e.style.display = "";

        }

        function CloseEdit() {
            var e = document.getElementById("DashboardView");
            e.style.display = "";

            e = document.getElementById("EditView");
            e.style.display = "none";

          
        }

        function OnAddNewShare()
        {
            window.location = "AddShareName.aspx?vdid=<%=SessionDomainId%>";
        }

        function ConfirmDelete() {
            if (confirm("Confirm delete this server entry?")) {
                return true;
            }

            return false;
        }
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
<asp:Localize runat="server" ID="LocPasIsMis" meta:resourcekey="str_pasIsMis" Visible="false">Password is missing</asp:Localize>
<asp:Localize runat="server" ID="LocUseNamIsMis" meta:resourcekey="str_useNamIsMis" Visible="false">User name is missing</asp:Localize>
    <asp:Localize ID="LocFldLodShr" meta:resourcekey="str_fldLodShr" runat="server" Visible="false">Failed to load shares</asp:Localize>
    <asp:Localize ID="LocFldPrsShrLst" meta:resourcekey="str_fldPrsShrLst" runat="server" Visible="false">Failed to parse share list</asp:Localize>
    <asp:Localize ID="LocUsrNmeMsg" meta:resourcekey="str_usrNmeMsg" runat="server" Visible="false">User name is missing</asp:Localize>
    <asp:Localize ID="LocPwdMsg" meta:resourcekey="str_pwdMsg" runat="server" Visible="false">Password is missing</asp:Localize>
    <asp:Localize ID="LocAcsDnd" meta:resourcekey="str_acsDnd" runat="server" Visible="false">Access is denied</asp:Localize>
    <asp:Localize ID="LocMsgSrvNme" meta:resourcekey="str_msgSrvNme" runat="server" Visible="false">Missing server name</asp:Localize>
    <asp:Localize ID="LocNoShaWerFou" meta:resourcekey="str_noShaWerFou" Visible="false" runat="server">No shares were found.</asp:Localize>
<asp:Localize ID="LocCloFilSer" meta:resourcekey="str_cloFilSer" runat="server" Visible="False">Cloud File Server</asp:Localize>
    <div class="wrapper" id="DashboardView" style="overflow: auto; width: 100%; padding: 0px;">
         
        <asp:Panel ID="SharesPanel" runat="server">
           <div style="width:100%; padding:5px; border-bottom:1px solid #cccccc;" class="meubardrop1">
            <table style="width:100%" border="0">
                <tr>
                    <td height="48px">
                        <button class="btn btn-primary gladbtn" style="display:none;font-weight:400!important; font-size:20px!important;" onclick="parent.clickSvrs(); return false;"><asp:Localize runat="server" meta:resourcekey="str_ser">Servers</asp:Localize></button> 
                        <i class="gladinet-icons " style="margin-top:8px;display:none;font-size:18px!important; color:#565656;">&#xDD;</i>
                        <span class="gladbtn" style="font-weight: 400!important; font-size: 20px!important; text-transform: uppercase; color:#808080!important;"><%=ServerDisplayName.Value %></span>
                    </td>
                    <td align="right" style="width:60px;height:48px">
                       <asp:LinkButton  CssClass="btn btn-primary gladbtn" ID="LinkButton1" runat="server" OnClientClick="OnAddNewShare(); return false;"><span style="font-size:24px!important; font-weight:100">+</span></asp:LinkButton> 
                    </td>
                    <td align="right" style="width:40px; padding-right:10px;height:48px;">
                        <i class="btn btn-primary gladmbtn gladinet-icons" style="font-weight:400!important; font-size:20px!important;" onclick="parent.clickSvrs(); return false;">&#XFB;</i> 
                    </td>
                </tr>
            </table>
        </div>
            <div style="width:100%; padding:20px;">
            <%if (SharesRepeater.Items.Count != 0)
                { %>
            <table width="100%" border="0">
                <asp:Repeater ID="SharesRepeater" runat="server">
                    <ItemTemplate>
                        <tr>
                            <td>
                                <div style="padding:5px; width:100%;border-radius:3px; border-bottom: 1px solid #f0f0f0;cursor:pointer;" class="filerow"  id="id_<%#DataBinder.Eval(Container.DataItem,"ShareName") %>">
                                    <table width="100%">
                        <tr  >
                            <td style="padding: 4px; padding-left:10px; font-size: 14px; color: #404040; font-weight: 100; width: 48px;" valign="middle" onclick='ClickSvrShare("<%=ServerName.Value %>", "<%#DataBinder.Eval(Container.DataItem,"ShareName") %>");'>
                                <i class="gladinet-icons md-32 md-dark hand" style="margin-top:8px;"><%#DataBinder.Eval(Container.DataItem,"ShareIcon") %></i>
                                
                            </td>
                            <td style="padding: 4px; font-size: 16px; color: #404040; font-weight: 100; " valign="middle" onclick='ClickSvrShare("<%=ServerName.Value %>", "<%#DataBinder.Eval(Container.DataItem,"ShareName") %>");'>
                                <%#DataBinder.Eval(Container.DataItem,"ShareName") %>
                                <%if (!IsMobile())
                                    { %>
                                    <div style="font-size: 12px; font-weight: 100;padding:0px; color: #565656;   <%#DataBinder.Eval(Container.DataItem,"UNCStyle") %>">
                                         <%#DataBinder.Eval(Container.DataItem,"Desc") %> <%#DataBinder.Eval(Container.DataItem,"DisplayUNC") %>
                                    </div>
                                <%} %>
                            </td>
                            <td style="padding:4px;width:90px;" align="right">
                                <i class="btn btn-primary gladmbtn gladinet-icons" style="font-weight:400!important; font-size:24px!important;" onclick='onEditShare("<%#DataBinder.Eval(Container.DataItem,"ShareName") %>"); return false;'>/</i> &nbsp;&nbsp;
                                <i class="btn btn-primary gladmbtn gladinet-icons" style="font-weight:400!important; font-size:24px!important;" onclick='onDeleteShare("<%#DataBinder.Eval(Container.DataItem,"ShareName") %>"); return false;'>&#XFB;</i> 
                            </td>
                        </tr>

                                    </table>
                                </div>
                            </td>
                        </tr>
                    </ItemTemplate>
                </asp:Repeater>
                </table>
                <%}else{ %>
                <table width="100%" border="0">
                    <tr>
                        <td style="padding:10px; font-size:20px; padding-top:50px; color:#565656; font-weight:100" align="center">
                            <asp:Label ID="ShareEnumFailed" runat="server" Text="No shares found."></asp:Label>
                           
                        </td>
                    </tr>
                    <tr>
                        <td style="padding:10px;" align="center">
                            <asp:LinkButton  CssClass="btn btn-primary gladbtn" ID="AddNewShare" runat="server" OnClientClick="OnAddNewShare(); return false;" meta:resourcekey="str_addCloSha">Add Cloud Share</asp:LinkButton> 
                            <asp:LinkButton CssClass="btn btn-primary gladbtn" ID="FRefreshBtn" runat="server" OnClick="RefreshBtn_Click" OnClientClick="Wait('...'); return true;" meta:resourcekey="str_ref">Refresh</asp:LinkButton>
                        </td>
                    </tr>
                </table>
                <%} %>
            
                </div>
        </asp:Panel>

        


    </div>

     <div  id="EditView" style="overflow: auto; width: 100%; padding: 0px; display:none;">
         <table width="100%">
             <tr>
                 <td style="padding-top:40px;font-size:16px;font-weight:100;" align="center">
                     <table style="width:100%; max-width:800px">
                         <tr>
                                <td  style="font-size:20px; color:#404040; padding-bottom:20px;">
								<asp:Localize runat="server" meta:resourcekey="str_edi">Edit</asp:Localize>
                                     <%=ServerName.Value %>

                                </td>
                            </tr>
                          <tr>
                             <td style="padding:5px; padding-bottom:0px">
                                 <asp:Label ID="EditErrorMsg" runat="server" Text="" ForeColor="Red"></asp:Label>
                             </td>
                         </tr>

                         <tr>
                             <td style="padding:5px; padding-bottom:0px"><asp:Localize runat="server" meta:resourcekey="str_disNam">Display Name</asp:Localize></td>
                         </tr>
                          <tr>
                             <td style="padding:5px; padding-top:0px">
                                 <asp:TextBox ID="EditDisplayName" runat="server" CssClass="form-control"></asp:TextBox>
                             </td>
                         </tr>


                            

                            <tr>
                             <td style="padding:5px; padding-bottom:0px;padding-top:20px;"><asp:Localize runat="server" meta:resourcekey="str_fqd">FQDN</asp:Localize></td>
                         </tr>
                          <tr>
                             <td style="padding:5px; padding-top:0px">
                                 <asp:TextBox ID="EditFQDN" runat="server" CssClass="form-control"></asp:TextBox>
                             </td>
                         </tr>

                         <tr>
                             <td style="padding:5px; padding-bottom:0px;padding-top:20px;"><asp:Localize runat="server" meta:resourcekey="str_des">Description</asp:Localize></td>
                         </tr>
                          <tr>
                             <td style="padding:5px; padding-top:0px">
                                 <asp:TextBox ID="EditDesc" runat="server" CssClass="form-control"></asp:TextBox>
                             </td>
                         </tr>

                         <tr>
                             <td style="padding:5px; padding-bottom:0px;padding-top:20px;">
                                 <asp:CheckBox ID="UseDefaultCred" runat="server" Text="Use default credential to access" AutoPostBack="true" OnCheckedChanged="OnChange_Click"/>
                             </td>
                         </tr>
                         <%if (!UseDefaultCred.Checked){ %>
                         <tr>
                             <td style="padding:5px; padding-bottom:0px;padding-top:20px;"><asp:Localize runat="server" meta:resourcekey="str_useNam">User Name</asp:Localize></td>
                         </tr>
                          <tr>
                             <td style="padding:5px; padding-top:0px">
                                 <asp:TextBox ID="EditUserName" runat="server" CssClass="form-control"></asp:TextBox>
                             </td>
                         </tr>

                         <tr>
                             <td style="padding:5px; padding-bottom:0px;padding-top:20px;"><asp:Localize runat="server" meta:resourcekey="str_pas">Password</asp:Localize></td>
                         </tr>
                          <tr>
                             <td style="padding:5px; padding-top:0px">
                                 <asp:TextBox ID="EditPassword" runat="server" CssClass="form-control"></asp:TextBox>
                             </td>
                         </tr>
                         <%} %>
                         <tr>
                            <td align="right" style="padding-top:40px; ">
                                <table width="100%">
                                    <tr>
                                        <td>
                                <asp:Button ID="DeleteBtn" runat="server"
                                    Text="Delete this server" OnClick="OnDelete_Click" CssClass="btn btn-primary gladmbtn" OnClientClick="return ConfirmDelete();"
                                    meta:resourcekey="Button1Resource1"  />

                                        </td>
                                        <td align="right">
                                <asp:Button ID="Button1" runat="server"
                                    Text="Save" OnClick="OnSaveSettings_Click" CssClass="btn btn-primary gladmbtn"
                                    meta:resourcekey="Button1Resource1"  />
                                <button class="btn btn-default gladmbtn" onclick="CloseEdit(); return false;"><asp:Localize runat="server" meta:resourcekey="str_clo">Close</asp:Localize></button>

                                        </td>
                                    </tr>
                                </table>
                            </td>
                            </tr>
                     </table>
                 </td>
             </tr>
         </table>
     </div>
  
    <div style="display: none;">
        <asp:LinkButton ID="RefreshBtn" runat="server" OnClick="RefreshBtn_Click" meta:resourcekey="str_ref">Refresh</asp:LinkButton>
        <asp:HiddenField ID="ServerName" runat="server" />
        <asp:HiddenField ID="ServerDisplayName" runat="server" />
        <asp:HiddenField ID="ShareName" runat="server" />
        <asp:LinkButton ID="DeleteShareBtn" runat="server" OnClick="DeleteShareBtn_Click" meta:resourcekey="str_ref">Refresh</asp:LinkButton>
    </div>
     <script type="text/javascript">
         <%if(m_RedirectToServers){%>
         parent.clickSvrs();
         <%}%>
         <%if(m_InEdit){%>
         OnEdit();
         <%}%>

         
         parent.SetCurrentRelativeTitle("<%=ServerDisplayName.Value%>");
    </script>
</asp:Content>
