﻿<%@ Page Title="Gladinet Cloud - Select Plan" Language="C#" MasterPageFile="~/WebAppPanel.master" EnableSessionState="false" 
    AutoEventWireup="true" CodeBehind="AddShareNameUsers.aspx.cs" Inherits="GladinetPayFlow.AddShareNameUsers" Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
<asp:Localize runat="server" ID="LocFaiToGraUseAcc" meta:resourcekey="str_faiToGraUseAcc" Visible="false">Failed to grand user access:</asp:Localize>
<asp:Localize runat="server" ID="LocMisShaStoCon" meta:resourcekey="str_misShaStoCon" Visible="false">Missing share storage config</asp:Localize>
<asp:Localize runat="server" ID="LocMisShaNam" meta:resourcekey="str_misShaNam" Visible="false">Missing share name</asp:Localize>
<asp:Localize runat="server" ID="LocShaNamConInvCha" meta:resourcekey="str_shaNamConInvCha" Visible="false">Share name contains invalid characters</asp:Localize>

    <style type="text/css">
        .titlecol {
            background-color: #f0f0f0;
            font-size: 14px;
        }

        * {
            margin: 0;
        }

        html, body {
            height: 100%;
        }

        .main, #aspnetForm {
            height: 100%;
        }

        .wrapper {
            min-height: 100%;
            height: auto !important;
            height: 100%;
            padding: 0px;
            background-color: white;
            margin: 0 auto -69px; /* the bottom margin is the negative value of the footer's height */
        }

        .footer, .push {
            height: 68px; /* .push must be the same height as .footer */
        }
        .uname{
            font-size:16px;
            color:#565656;
            font-weight:100;
            padding:5px;
        }
    </style>
    <script type="text/javascript">
        
        function AddSelecteUser() {
            var e = document.getElementById("aduserlist");
            e.contentWindow.OnUserSelected();
        }
        function DelSelecteUser() {



            var tb = document.getElementById("seluserlist");
            var Users = document.getElementsByClassName("leftmenuselect");
            
            while (Users != null && Users.length > 0) {
                tb.removeChild(Users[0]);
                Users = document.getElementsByClassName("leftmenuselect");
            }
        }
        function AddSelUser(s){
            var res = s.split(";");
            if (res.length != 3) {                
                return;
            }
            var oe = document.getElementById(res[2]);
            if (oe)
                return;
            
            var tb = document.getElementById("seluserlist");
            var etr = document.createElement("tr");

            tb.appendChild(etr);
            var etdname = document.createElement("td");
            etr.appendChild(etdname);
            etdname.className = "uname";
            etr.className = "filerow";
            etr.style.borderBottom = "1px solid #f0f0f0";
            etr.id = res[2];
            etr.onclick = function () {
                if (this.className == "filerow")
                    this.className = "filerow leftmenuselect";
                else
                    this.className = "filerow";
            }
            
            etdname.innerHTML = res[1];
            var etdcheck = document.createElement("td");
            etr.appendChild(etdcheck);
            etdcheck.style.width = "32px";
            var   echeck = document.createElement("input");
            echeck.type = "checkbox";
            echeck.checked = true;
            etdcheck.appendChild(echeck);
            echeck.name = "[H]"+s;
            echeck.id = "h_" + res[2];
            echeck.style.display = "none";

        }
        function SetUserList(UserList) {
            
            var res = UserList.split("\n");
            for (var i = 0; i < res.length; ++i)
                AddSelUser(res[i]);
        }

        function OnSelectUser() {
            parent.OpenQuickWindow("/portal/SelectUser.aspx?vdid=<%=SessionDomainId%>","");
        }
        function AddSelOwnUser(s) {
            var res = s.split(",");
            
            if (res.length != 3) {                
                return;
            }
            var oe = document.getElementById(res[0]);
            if (oe)
                return;

            var tb = document.getElementById("seluserlist");
            var etr = document.createElement("tr");

            tb.appendChild(etr);
            var etdname = document.createElement("td");
            etr.appendChild(etdname);
            etdname.className = "uname";
            etr.className = "filerow";
            etr.style.borderBottom = "1px solid #f0f0f0";
            etr.id = res[0];
            etr.onclick = function () {
                if (this.className == "filerow")
                    this.className = "filerow leftmenuselect";
                else
                    this.className = "filerow";
            }

            etdname.innerHTML = res[2]+" ("+ res[1]+")";
            var etdcheck = document.createElement("td");
            etr.appendChild(etdcheck);
            etdcheck.style.width = "32px";

            var echeck = document.createElement("input");
            echeck.type = "checkbox";
            echeck.checked = true;
            echeck.style.display = "none";
            etdcheck.appendChild(echeck);
            echeck.name = "[H][EUSER];" + s.replaceAll(",", ";");
            echeck.id = "h_"+res[0];

        }
        function OnUserSelected(UserList) {
            var res = UserList.split("\n");
            for (var i = 0; i < res.length; ++i)
                AddSelOwnUser(res[i]);
        }

        function onUserItemClick(e)
        {
            
            if (e.className == "filerow")
                e.className = "filerow leftmenuselect";
            else
                e.className = "filerow";
        }
        
    </script>

    <div class="wrapper">
        <asp:Localize runat="server" ID="LocSysIntErr" meta:resourcekey="str_sysIntErr" Visible="false">System Internal Error.</asp:Localize>
        <asp:Localize runat="server" ID="LocInvStoAccNam" meta:resourcekey="str_invStoAccNam" Visible="false">Invalid storage account name</asp:Localize>
        <asp:Localize runat="server" ID="LocTeaFolWitTheSamNamAlrExi" meta:resourcekey="str_teaFolWitTheSamNamAlrExi" Visible="false">A share with the same name already exists</asp:Localize>
        <asp:Localize runat="server" ID="LocFaiToValTheFolNam" meta:resourcekey="str_faiToValTheFolNam" Visible="false">Failed to validate the folder name</asp:Localize>
        <asp:Localize runat="server" ID="LocTheTeaFolCanNotConTheKeyWorTeaFol" meta:resourcekey="str_theTeaFolCanNotConTheKeyWorTeaFol" Visible="false">Share names cannot contain the key word '(Team Folder)'</asp:Localize>

        <table width="100%">
            <tr>
                <td align="center" style="padding-top: 40px;">
                    <table width="100%" align="center" style="background: WHITE; padding: 0px; margin: 0px; max-width: 1000px;" cellspacing="0">


                        <tr>
                            <td width="100%" style="padding: 0px; vertical-align: top; border-top: 0px solid #d0d0d0; padding-top: 10px; margin: 8px;" align="center">
                                <table width="100%">
                                    <tr>
                                        <td style="font-size: 18px;"><asp:Localize runat="server" meta:resourcekey="str_addUse">Add Users</asp:Localize></td>
                                    </tr>


                                </table>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <table style="width: 100%">
                                    
                                    <tr>
                                        <%if (AdUserPanel.Visible){ %>
                                        <td>
                                            <span style="font-size: 16px; font-weight: 100; color: #202020; height:20px;"><asp:Localize runat="server" meta:resourcekey="str_useFroActDir">Users from Active Directory</asp:Localize></span>
                                            <iframe src="QueryLDAPCtrl.aspx" style="width: 100%; height: <%if (IsMobile()){ %>350px<%}else{ %>500px<%} %>; border: 1px solid #cccccc; border-radius: 3px;" id="aduserlist"></iframe>
                                        </td>
                                        <td style="width: 60px; " align="center">
                                            <div  class="btn btn-primary gladbtn"  title="Add selected users" onclick="AddSelecteUser();">
                                            <i class="gladinet-icons md-32 md-dark hand center " >&#xDD;</i>
                                                </div>
                                            <div style="margin-top:20px;" class="btn btn-primary gladbtn"  title="Remove selected users" onclick="DelSelecteUser();">
                                            <i class="gladinet-icons md-32 md-dark hand center " >&#x10A;</i>
                                                </div>
                                        </td>
                                        <%} %>
                                        <td style="width: 300px;">
                                            <span style="font-size: 16px; font-weight: 100; color: #202020;padding-right:10px;height:20px;"><asp:Localize runat="server" meta:resourcekey="str_useAllForAcc">Users allowed for access</asp:Localize></span><span class="toolnavbtn gladbtn" style="font-size:10px!important; cursor:pointer;" title="" onclick="OnSelectUser();"><asp:Localize runat="server" meta:resourcekey="str_addExiUse">Add Existing Users</asp:Localize></span>
                                            <%if (!AdUserPanel.Visible){ %>
                                            <span style="width:20px">&nbsp;</span><span class="toolnavbtn gladbtn" style="font-size:10px!important; cursor:pointer;" title="" onclick="DelSelecteUser();"><asp:Localize runat="server" meta:resourcekey="str_delSelUse">Delete Selected Users</asp:Localize></span>
                                            <%} %>
                                            <div style="width: 100%; height: <%if (IsMobile()){ %>350px<%}else{ %>500px<%} %>; border: 1px solid #cccccc; border-radius: 3px;overflow: auto;">
                                                <table width="100%" border="0">
                                                    <tbody id="seluserlist">
                                                        <asp:Repeater ID="SharesUserRepeater" runat="server">
                                                            <ItemTemplate>
                                                                <tr class="filerow" style="1px solid #f0f0f0" onclick="onUserItemClick(this);" id="<%#DataBinder.Eval(Container.DataItem,"EntryId") %>">
                                                                    <td class="uname">
                                                                        <%#DataBinder.Eval(Container.DataItem,"Name") %>
                                                                    </td>
                                                                    <td style="width:32px">
                                                                        <input type="checkbox" name="<%#DataBinder.Eval(Container.DataItem,"Desc") %>" checked="checked" id="h_<%#DataBinder.Eval(Container.DataItem,"EntryId") %>" style="display:none;"/>
                                                                    </td>
                                                                 </tr>
                                                            </ItemTemplate>
                                                        </asp:Repeater>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                        <tr>
                            <td style="font-size: 16">
                                <%if (!string.IsNullOrEmpty(ErrorMsg.Text))
                                    { %>
                                <asp:Label ID="ErrorMsg" runat="server" CssClass="errmsg"
                                    meta:resourcekey="ErrorMsgResource1"></asp:Label>
                                <%} %>
                            </td>
                        </tr>
                        <tr>
                            <td height="10px" colspan="2">&nbsp;</td>
                        </tr>

                        <tr>

                            <td align="right">

                                <asp:Button ID="Button11" runat="server"
                                    OnClick="LinkButton1_Click" OnClientClick="Wait('please wait');"
                                    CssClass="btn btn-primary gladmbtn" meta:resourcekey="LinkButton1Resource1" Text="Publish"></asp:Button>
                                &nbsp;&nbsp;<asp:Button ID="BackBtn" runat="server"
                                    OnClick="BackBtn_Click" OnClientClick="Wait('please wait');" 
                                    CssClass="btn btn-default gladmbtn" meta:resourcekey="str_bac" Text="Back"></asp:Button>
                                &nbsp;&nbsp;<asp:Button ID="Button2" runat="server"
                                    OnClientClick="Wait('please wait');"
                                    CssClass="btn btn-default gladmbtn" Text="Cancel" OnClick="Button2_Click" meta:resourcekey="Button2Resource1"></asp:Button>
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>
    </div>
    <div class="footer x-panel-header-light" style="border-left: 0; border-right: 0; border-bottom: 0; vertical-align: middle; display: none;">
        <asp:Panel ID="AdUserPanel" runat="server" Visible="true"></asp:Panel>
    </div>

    <script type="text/javascript">

        

    </script>
    <asp:HiddenField ID="EditStorage" runat="server" />
</asp:Content>
